#ifndef CYGONCE_LIBM_FREXPF_H
#define CYGONCE_LIBM_FREXPF_H
//===========================================================================
//
//      frexpf.h
//
//      Test vectors for testing of frexpf() math library function
//
//===========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 2013 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later
// version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License
// along with eCos; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
// As a special exception, if other files instantiate templates or use
// macros or inline functions from this file, or you compile this file
// and link it with other works to produce a work based on this file,
// this file does not by itself cause the resulting work to be covered by
// the GNU General Public License. However the source code for this file
// must still be made available in accordance with section (3) of the GNU
// General Public License v2.
//
// This exception does not invalidate any other reasons why a work based
// on this file might be covered by the GNU General Public License.
// -------------------------------------------
// ####ECOSGPLCOPYRIGHTEND####
//===========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):
// Contributors:  ilijak
// Date:        2013-06-26
// Purpose:
// Description:
// Usage:       #include "vectors/frexpf.h"
//
//####DESCRIPTIONEND####
//
//===========================================================================


// CONFIGURATION

#include <pkgconf/libm.h>   // Configuration header


// INCLUDES

#include <cyg/infra/cyg_type.h>    // Common type definitions and support
#include "vectors/vector_support_float.h"// extra support for math tests

#define FREXPF_TOLERANCE 1.0E-04

static const Cyg_libm_test_float_vec_t frexpf_vec[] = {

// AUTOMATICALLY GENERATED VECTORS START
{0, 3519987949u, 37u, 3209609453u, 0, FREXPF_TOLERANCE, 0 }, // -1.1100E+11=F( -0.8076, +37)
{1, 3518632969u, 37u, 3208254473u, 0, FREXPF_TOLERANCE, 0 }, // -9.9900E+10=F( -0.7269, +37)
{2, 3517277989u, 37u, 3206899493u, 0, FREXPF_TOLERANCE, 0 }, // -8.8800E+10=F( -0.6461, +37)
{3, 3515923009u, 37u, 3205544513u, 0, FREXPF_TOLERANCE, 0 }, // -7.7700E+10=F( -0.5653, +37)
{4, 3514309305u, 36u, 3212319417u, 0, FREXPF_TOLERANCE, 0 }, // -6.6600E+10=F( -0.9692, +36)
{5, 3511599344u, 36u, 3209609456u, 0, FREXPF_TOLERANCE, 0 }, // -5.5500E+10=F( -0.8076, +36)
{6, 3508889383u, 36u, 3206899495u, 0, FREXPF_TOLERANCE, 0 }, // -4.4400E+10=F( -0.6461, +36)
{7, 3505920700u, 35u, 3212319420u, 0, FREXPF_TOLERANCE, 0 }, // -3.3300E+10=F( -0.9692, +35)
{8, 3500500778u, 35u, 3206899498u, 0, FREXPF_TOLERANCE, 0 }, // -2.2200E+10=F( -0.6461, +35)
{9, 3492112176u, 34u, 3206899504u, 0, FREXPF_TOLERANCE, 0 }, // -1.1100E+10=F( -0.6461, +34)
{10, 3326345216u, 14u, 3208904704u, 0, FREXPF_TOLERANCE, 0 }, // -1.2544E+04=F( -0.7656, +14)
{11, 3297435648u, 11u, 3205160960u, 0, FREXPF_TOLERANCE, 0 }, // -1.1110E+03=F( -0.5425, +11)
{12, 3296329728u, 10u, 3212443648u, 0, FREXPF_TOLERANCE, 0 }, // -1.0000E+03=F( -0.9766, +10)
{13, 3294511104u, 10u, 3210625024u, 0, FREXPF_TOLERANCE, 0 }, // -8.8900E+02=F( -0.8682, +10)
{14, 3292692480u, 10u, 3208806400u, 0, FREXPF_TOLERANCE, 0 }, // -7.7800E+02=F( -0.7598, +10)
{15, 3290873856u, 10u, 3206987776u, 0, FREXPF_TOLERANCE, 0 }, // -6.6700E+02=F( -0.6514, +10)
{16, 3289055232u, 10u, 3205169152u, 0, FREXPF_TOLERANCE, 0 }, // -5.5600E+02=F(  -0.543, +10)
{17, 3286138880u, 9u, 3210641408u, 0, FREXPF_TOLERANCE, 0 }, // -4.4500E+02=F( -0.8691, +9)
{18, 3282501632u, 9u, 3207004160u, 0, FREXPF_TOLERANCE, 0 }, // -3.3400E+02=F( -0.6523, +9)
{19, 3277783040u, 8u, 3210674176u, 0, FREXPF_TOLERANCE, 0 }, // -2.2300E+02=F( -0.8711, +8)
{20, 3269459968u, 7u, 3210739712u, 0, FREXPF_TOLERANCE, 0 }, // -1.1200E+02=F(  -0.875, +7)
{21, 3269328896u, 7u, 3210608640u, 0, FREXPF_TOLERANCE, 0 }, // -1.1100E+02=F( -0.8672, +7)
{22, 3269184717u, 7u, 3210464461u, 0, FREXPF_TOLERANCE, 0 }, // -1.0990E+02=F( -0.8586, +7)
{23, 3269040538u, 7u, 3210320282u, 0, FREXPF_TOLERANCE, 0 }, // -1.0880E+02=F(   -0.85, +7)
{24, 3268896359u, 7u, 3210176103u, 0, FREXPF_TOLERANCE, 0 }, // -1.0770E+02=F( -0.8414, +7)
{25, 3268752180u, 7u, 3210031924u, 0, FREXPF_TOLERANCE, 0 }, // -1.0660E+02=F( -0.8328, +7)
{26, 3268608001u, 7u, 3209887745u, 0, FREXPF_TOLERANCE, 0 }, // -1.0550E+02=F( -0.8242, +7)
{27, 3268463822u, 7u, 3209743566u, 0, FREXPF_TOLERANCE, 0 }, // -1.0440E+02=F( -0.8156, +7)
{28, 3268319643u, 7u, 3209599387u, 0, FREXPF_TOLERANCE, 0 }, // -1.0330E+02=F(  -0.807, +7)
{29, 3268175464u, 7u, 3209455208u, 0, FREXPF_TOLERANCE, 0 }, // -1.0220E+02=F( -0.7984, +7)
{30, 3268031285u, 7u, 3209311029u, 0, FREXPF_TOLERANCE, 0 }, // -1.0110E+02=F( -0.7898, +7)
{31, 3267887106u, 7u, 3209166850u, 0, FREXPF_TOLERANCE, 0 }, // -1.0000E+02=F( -0.7813, +7)
{32, 3267742927u, 7u, 3209022671u, 0, FREXPF_TOLERANCE, 0 }, // -9.8900E+01=F( -0.7727, +7)
{33, 3267598748u, 7u, 3208878492u, 0, FREXPF_TOLERANCE, 0 }, // -9.7800E+01=F( -0.7641, +7)
{34, 3267454569u, 7u, 3208734313u, 0, FREXPF_TOLERANCE, 0 }, // -9.6700E+01=F( -0.7555, +7)
{35, 3267310390u, 7u, 3208590134u, 0, FREXPF_TOLERANCE, 0 }, // -9.5600E+01=F( -0.7469, +7)
{36, 3267166211u, 7u, 3208445955u, 0, FREXPF_TOLERANCE, 0 }, // -9.4500E+01=F( -0.7383, +7)
{37, 3267022032u, 7u, 3208301776u, 0, FREXPF_TOLERANCE, 0 }, // -9.3400E+01=F( -0.7297, +7)
{38, 3266877853u, 7u, 3208157597u, 0, FREXPF_TOLERANCE, 0 }, // -9.2300E+01=F( -0.7211, +7)
{39, 3266733674u, 7u, 3208013418u, 0, FREXPF_TOLERANCE, 0 }, // -9.1200E+01=F( -0.7125, +7)
{40, 3266589495u, 7u, 3207869239u, 0, FREXPF_TOLERANCE, 0 }, // -9.0100E+01=F( -0.7039, +7)
{41, 3266445316u, 7u, 3207725060u, 0, FREXPF_TOLERANCE, 0 }, // -8.9000E+01=F( -0.6953, +7)
{42, 3266301137u, 7u, 3207580881u, 0, FREXPF_TOLERANCE, 0 }, // -8.7900E+01=F( -0.6867, +7)
{43, 3266156958u, 7u, 3207436702u, 0, FREXPF_TOLERANCE, 0 }, // -8.6800E+01=F( -0.6781, +7)
{44, 3266012779u, 7u, 3207292523u, 0, FREXPF_TOLERANCE, 0 }, // -8.5700E+01=F( -0.6695, +7)
{45, 3265868600u, 7u, 3207148344u, 0, FREXPF_TOLERANCE, 0 }, // -8.4600E+01=F( -0.6609, +7)
{46, 3265724421u, 7u, 3207004165u, 0, FREXPF_TOLERANCE, 0 }, // -8.3500E+01=F( -0.6523, +7)
{47, 3265580242u, 7u, 3206859986u, 0, FREXPF_TOLERANCE, 0 }, // -8.2400E+01=F( -0.6438, +7)
{48, 3265436063u, 7u, 3206715807u, 0, FREXPF_TOLERANCE, 0 }, // -8.1300E+01=F( -0.6352, +7)
{49, 3265291884u, 7u, 3206571628u, 0, FREXPF_TOLERANCE, 0 }, // -8.0200E+01=F( -0.6266, +7)
{50, 3265147705u, 7u, 3206427449u, 0, FREXPF_TOLERANCE, 0 }, // -7.9100E+01=F(  -0.618, +7)
{51, 3265003526u, 7u, 3206283270u, 0, FREXPF_TOLERANCE, 0 }, // -7.8000E+01=F( -0.6094, +7)
{52, 3264859347u, 7u, 3206139091u, 0, FREXPF_TOLERANCE, 0 }, // -7.6900E+01=F( -0.6008, +7)
{53, 3264715168u, 7u, 3205994912u, 0, FREXPF_TOLERANCE, 0 }, // -7.5800E+01=F( -0.5922, +7)
{54, 3264570989u, 7u, 3205850733u, 0, FREXPF_TOLERANCE, 0 }, // -7.4700E+01=F( -0.5836, +7)
{55, 3264426810u, 7u, 3205706554u, 0, FREXPF_TOLERANCE, 0 }, // -7.3600E+01=F(  -0.575, +7)
{56, 3264282631u, 7u, 3205562375u, 0, FREXPF_TOLERANCE, 0 }, // -7.2500E+01=F( -0.5664, +7)
{57, 3264138452u, 7u, 3205418196u, 0, FREXPF_TOLERANCE, 0 }, // -7.1400E+01=F( -0.5578, +7)
{58, 3263994273u, 7u, 3205274017u, 0, FREXPF_TOLERANCE, 0 }, // -7.0300E+01=F( -0.5492, +7)
{59, 3263850094u, 7u, 3205129838u, 0, FREXPF_TOLERANCE, 0 }, // -6.9200E+01=F( -0.5406, +7)
{60, 3263705915u, 7u, 3204985659u, 0, FREXPF_TOLERANCE, 0 }, // -6.8100E+01=F(  -0.532, +7)
{61, 3263561736u, 7u, 3204841480u, 0, FREXPF_TOLERANCE, 0 }, // -6.7000E+01=F( -0.5234, +7)
{62, 3263417557u, 7u, 3204697301u, 0, FREXPF_TOLERANCE, 0 }, // -6.5900E+01=F( -0.5148, +7)
{63, 3263273378u, 7u, 3204553122u, 0, FREXPF_TOLERANCE, 0 }, // -6.4800E+01=F( -0.5063, +7)
{64, 3263089886u, 6u, 3212758238u, 0, FREXPF_TOLERANCE, 0 }, // -6.3700E+01=F( -0.9953, +6)
{65, 3262801528u, 6u, 3212469880u, 0, FREXPF_TOLERANCE, 0 }, // -6.2600E+01=F( -0.9781, +6)
{66, 3262513170u, 6u, 3212181522u, 0, FREXPF_TOLERANCE, 0 }, // -6.1500E+01=F( -0.9609, +6)
{67, 3262224812u, 6u, 3211893164u, 0, FREXPF_TOLERANCE, 0 }, // -6.0400E+01=F( -0.9438, +6)
{68, 3261936454u, 6u, 3211604806u, 0, FREXPF_TOLERANCE, 0 }, // -5.9300E+01=F( -0.9266, +6)
{69, 3261648096u, 6u, 3211316448u, 0, FREXPF_TOLERANCE, 0 }, // -5.8200E+01=F( -0.9094, +6)
{70, 3261359738u, 6u, 3211028090u, 0, FREXPF_TOLERANCE, 0 }, // -5.7100E+01=F( -0.8922, +6)
{71, 3261071380u, 6u, 3210739732u, 0, FREXPF_TOLERANCE, 0 }, // -5.6000E+01=F(  -0.875, +6)
{72, 3260783022u, 6u, 3210451374u, 0, FREXPF_TOLERANCE, 0 }, // -5.4900E+01=F( -0.8578, +6)
{73, 3260494664u, 6u, 3210163016u, 0, FREXPF_TOLERANCE, 0 }, // -5.3800E+01=F( -0.8406, +6)
{74, 3260206306u, 6u, 3209874658u, 0, FREXPF_TOLERANCE, 0 }, // -5.2700E+01=F( -0.8234, +6)
{75, 3259917948u, 6u, 3209586300u, 0, FREXPF_TOLERANCE, 0 }, // -5.1600E+01=F( -0.8063, +6)
{76, 3259629590u, 6u, 3209297942u, 0, FREXPF_TOLERANCE, 0 }, // -5.0500E+01=F( -0.7891, +6)
{77, 3259341232u, 6u, 3209009584u, 0, FREXPF_TOLERANCE, 0 }, // -4.9400E+01=F( -0.7719, +6)
{78, 3259052874u, 6u, 3208721226u, 0, FREXPF_TOLERANCE, 0 }, // -4.8300E+01=F( -0.7547, +6)
{79, 3258764516u, 6u, 3208432868u, 0, FREXPF_TOLERANCE, 0 }, // -4.7200E+01=F( -0.7375, +6)
{80, 3258476158u, 6u, 3208144510u, 0, FREXPF_TOLERANCE, 0 }, // -4.6100E+01=F( -0.7203, +6)
{81, 3258187800u, 6u, 3207856152u, 0, FREXPF_TOLERANCE, 0 }, // -4.5000E+01=F( -0.7031, +6)
{82, 3257899442u, 6u, 3207567794u, 0, FREXPF_TOLERANCE, 0 }, // -4.3900E+01=F( -0.6859, +6)
{83, 3257611084u, 6u, 3207279436u, 0, FREXPF_TOLERANCE, 0 }, // -4.2800E+01=F( -0.6688, +6)
{84, 3257322726u, 6u, 3206991078u, 0, FREXPF_TOLERANCE, 0 }, // -4.1700E+01=F( -0.6516, +6)
{85, 3257034368u, 6u, 3206702720u, 0, FREXPF_TOLERANCE, 0 }, // -4.0600E+01=F( -0.6344, +6)
{86, 3256746010u, 6u, 3206414362u, 0, FREXPF_TOLERANCE, 0 }, // -3.9500E+01=F( -0.6172, +6)
{87, 3256457652u, 6u, 3206126004u, 0, FREXPF_TOLERANCE, 0 }, // -3.8400E+01=F(    -0.6, +6)
{88, 3256169294u, 6u, 3205837646u, 0, FREXPF_TOLERANCE, 0 }, // -3.7300E+01=F( -0.5828, +6)
{89, 3255880936u, 6u, 3205549288u, 0, FREXPF_TOLERANCE, 0 }, // -3.6200E+01=F( -0.5656, +6)
{90, 3255592578u, 6u, 3205260930u, 0, FREXPF_TOLERANCE, 0 }, // -3.5100E+01=F( -0.5484, +6)
{91, 3255304220u, 6u, 3204972572u, 0, FREXPF_TOLERANCE, 0 }, // -3.4000E+01=F( -0.5313, +6)
{92, 3255015862u, 6u, 3204684214u, 0, FREXPF_TOLERANCE, 0 }, // -3.2900E+01=F( -0.5141, +6)
{93, 3254675103u, 5u, 3212732063u, 0, FREXPF_TOLERANCE, 0 }, // -3.1800E+01=F( -0.9938, +5)
{94, 3254098386u, 5u, 3212155346u, 0, FREXPF_TOLERANCE, 0 }, // -3.0700E+01=F( -0.9594, +5)
{95, 3253521669u, 5u, 3211578629u, 0, FREXPF_TOLERANCE, 0 }, // -2.9600E+01=F(  -0.925, +5)
{96, 3252944952u, 5u, 3211001912u, 0, FREXPF_TOLERANCE, 0 }, // -2.8500E+01=F( -0.8906, +5)
{97, 3252368235u, 5u, 3210425195u, 0, FREXPF_TOLERANCE, 0 }, // -2.7400E+01=F( -0.8563, +5)
{98, 3251791518u, 5u, 3209848478u, 0, FREXPF_TOLERANCE, 0 }, // -2.6300E+01=F( -0.8219, +5)
{99, 3251214801u, 5u, 3209271761u, 0, FREXPF_TOLERANCE, 0 }, // -2.5200E+01=F( -0.7875, +5)
{100, 3250638084u, 5u, 3208695044u, 0, FREXPF_TOLERANCE, 0 }, // -2.4100E+01=F( -0.7531, +5)
{101, 3250061367u, 5u, 3208118327u, 0, FREXPF_TOLERANCE, 0 }, // -2.3000E+01=F( -0.7188, +5)
{102, 3249484650u, 5u, 3207541610u, 0, FREXPF_TOLERANCE, 0 }, // -2.1900E+01=F( -0.6844, +5)
{103, 3248907933u, 5u, 3206964893u, 0, FREXPF_TOLERANCE, 0 }, // -2.0800E+01=F(   -0.65, +5)
{104, 3248331216u, 5u, 3206388176u, 0, FREXPF_TOLERANCE, 0 }, // -1.9700E+01=F( -0.6156, +5)
{105, 3247754499u, 5u, 3205811459u, 0, FREXPF_TOLERANCE, 0 }, // -1.8600E+01=F( -0.5813, +5)
{106, 3247177782u, 5u, 3205234742u, 0, FREXPF_TOLERANCE, 0 }, // -1.7500E+01=F( -0.5469, +5)
{107, 3246601065u, 5u, 3204658025u, 0, FREXPF_TOLERANCE, 0 }, // -1.6400E+01=F( -0.5125, +5)
{108, 3245657400u, 4u, 3212102968u, 0, FREXPF_TOLERANCE, 0 }, // -1.5300E+01=F( -0.9563, +4)
{109, 3244503966u, 4u, 3210949534u, 0, FREXPF_TOLERANCE, 0 }, // -1.4200E+01=F( -0.8875, +4)
{110, 3243350532u, 4u, 3209796100u, 0, FREXPF_TOLERANCE, 0 }, // -1.3100E+01=F( -0.8188, +4)
{111, 3242197098u, 4u, 3208642666u, 0, FREXPF_TOLERANCE, 0 }, // -1.2000E+01=F(   -0.75, +4)
{112, 3241043664u, 4u, 3207489232u, 0, FREXPF_TOLERANCE, 0 }, // -1.0900E+01=F( -0.6813, +4)
{113, 3239890230u, 4u, 3206335798u, 0, FREXPF_TOLERANCE, 0 }, // -9.8001E+00=F( -0.6125, +4)
{114, 3238736796u, 4u, 3205182364u, 0, FREXPF_TOLERANCE, 0 }, // -8.7001E+00=F( -0.5438, +4)
{115, 3237164037u, 3u, 3211998213u, 0, FREXPF_TOLERANCE, 0 }, // -7.6001E+00=F(   -0.95, +3)
{116, 3234857170u, 3u, 3209691346u, 0, FREXPF_TOLERANCE, 0 }, // -6.5001E+00=F( -0.8125, +3)
{117, 3232550303u, 3u, 3207384479u, 0, FREXPF_TOLERANCE, 0 }, // -5.4001E+00=F(  -0.675, +3)
{118, 3230243436u, 3u, 3205077612u, 0, FREXPF_TOLERANCE, 0 }, // -4.3001E+00=F( -0.5375, +3)
{119, 3226259058u, 2u, 3209481842u, 0, FREXPF_TOLERANCE, 0 }, // -3.2001E+00=F(    -0.8, +2)
{120, 3221645324u, 2u, 3204868108u, 0, FREXPF_TOLERANCE, 0 }, // -2.1001E+00=F(  -0.525, +2)
{121, 3213675725u, 1u, 3205287117u, 0, FREXPF_TOLERANCE, 0 }, // -1.1000E+00=F(   -0.55, +1)
{122, 3213583450u, 1u, 3205194842u, 0, FREXPF_TOLERANCE, 0 }, // -1.0890E+00=F( -0.5445, +1)
{123, 3213491175u, 1u, 3205102567u, 0, FREXPF_TOLERANCE, 0 }, // -1.0780E+00=F(  -0.539, +1)
{124, 3213398900u, 1u, 3205010292u, 0, FREXPF_TOLERANCE, 0 }, // -1.0670E+00=F( -0.5335, +1)
{125, 3213306625u, 1u, 3204918017u, 0, FREXPF_TOLERANCE, 0 }, // -1.0560E+00=F(  -0.528, +1)
{126, 3213214350u, 1u, 3204825742u, 0, FREXPF_TOLERANCE, 0 }, // -1.0450E+00=F( -0.5225, +1)
{127, 3213122075u, 1u, 3204733467u, 0, FREXPF_TOLERANCE, 0 }, // -1.0340E+00=F(  -0.517, +1)
{128, 3213029800u, 1u, 3204641192u, 0, FREXPF_TOLERANCE, 0 }, // -1.0230E+00=F( -0.5115, +1)
{129, 3212937525u, 1u, 3204548917u, 0, FREXPF_TOLERANCE, 0 }, // -1.0120E+00=F(  -0.506, +1)
{130, 3212845250u, 1u, 3204456642u, 0, FREXPF_TOLERANCE, 0 }, // -1.0010E+00=F( -0.5005, +1)
{131, 3212669087u, 0u, 3212669087u, 0, FREXPF_TOLERANCE, 0 }, // -9.9000E-01=F(   -0.99, +0)
{132, 3212484538u, 0u, 3212484538u, 0, FREXPF_TOLERANCE, 0 }, // -9.7900E-01=F(  -0.979, +0)
{133, 3212299989u, 0u, 3212299989u, 0, FREXPF_TOLERANCE, 0 }, // -9.6800E-01=F(  -0.968, +0)
{134, 3212115440u, 0u, 3212115440u, 0, FREXPF_TOLERANCE, 0 }, // -9.5700E-01=F(  -0.957, +0)
{135, 3211930891u, 0u, 3211930891u, 0, FREXPF_TOLERANCE, 0 }, // -9.4600E-01=F(  -0.946, +0)
{136, 3211746342u, 0u, 3211746342u, 0, FREXPF_TOLERANCE, 0 }, // -9.3500E-01=F(  -0.935, +0)
{137, 3211561793u, 0u, 3211561793u, 0, FREXPF_TOLERANCE, 0 }, // -9.2400E-01=F(  -0.924, +0)
{138, 3211377244u, 0u, 3211377244u, 0, FREXPF_TOLERANCE, 0 }, // -9.1300E-01=F(  -0.913, +0)
{139, 3211192695u, 0u, 3211192695u, 0, FREXPF_TOLERANCE, 0 }, // -9.0200E-01=F(  -0.902, +0)
{140, 3211008146u, 0u, 3211008146u, 0, FREXPF_TOLERANCE, 0 }, // -8.9100E-01=F(  -0.891, +0)
{141, 3210823597u, 0u, 3210823597u, 0, FREXPF_TOLERANCE, 0 }, // -8.8000E-01=F(   -0.88, +0)
{142, 3210639048u, 0u, 3210639048u, 0, FREXPF_TOLERANCE, 0 }, // -8.6900E-01=F(  -0.869, +0)
{143, 3210454499u, 0u, 3210454499u, 0, FREXPF_TOLERANCE, 0 }, // -8.5800E-01=F(  -0.858, +0)
{144, 3210269950u, 0u, 3210269950u, 0, FREXPF_TOLERANCE, 0 }, // -8.4700E-01=F(  -0.847, +0)
{145, 3210085401u, 0u, 3210085401u, 0, FREXPF_TOLERANCE, 0 }, // -8.3600E-01=F(  -0.836, +0)
{146, 3209900852u, 0u, 3209900852u, 0, FREXPF_TOLERANCE, 0 }, // -8.2500E-01=F(  -0.825, +0)
{147, 3209716303u, 0u, 3209716303u, 0, FREXPF_TOLERANCE, 0 }, // -8.1400E-01=F(  -0.814, +0)
{148, 3209531754u, 0u, 3209531754u, 0, FREXPF_TOLERANCE, 0 }, // -8.0300E-01=F(  -0.803, +0)
{149, 3209347205u, 0u, 3209347205u, 0, FREXPF_TOLERANCE, 0 }, // -7.9200E-01=F(  -0.792, +0)
{150, 3209162656u, 0u, 3209162656u, 0, FREXPF_TOLERANCE, 0 }, // -7.8100E-01=F(  -0.781, +0)
{151, 3208978107u, 0u, 3208978107u, 0, FREXPF_TOLERANCE, 0 }, // -7.7000E-01=F(   -0.77, +0)
{152, 3208793558u, 0u, 3208793558u, 0, FREXPF_TOLERANCE, 0 }, // -7.5900E-01=F(  -0.759, +0)
{153, 3208609009u, 0u, 3208609009u, 0, FREXPF_TOLERANCE, 0 }, // -7.4800E-01=F(  -0.748, +0)
{154, 3208424460u, 0u, 3208424460u, 0, FREXPF_TOLERANCE, 0 }, // -7.3700E-01=F(  -0.737, +0)
{155, 3208239911u, 0u, 3208239911u, 0, FREXPF_TOLERANCE, 0 }, // -7.2600E-01=F(  -0.726, +0)
{156, 3208055362u, 0u, 3208055362u, 0, FREXPF_TOLERANCE, 0 }, // -7.1500E-01=F(  -0.715, +0)
{157, 3207870813u, 0u, 3207870813u, 0, FREXPF_TOLERANCE, 0 }, // -7.0400E-01=F(  -0.704, +0)
{158, 3207686264u, 0u, 3207686264u, 0, FREXPF_TOLERANCE, 0 }, // -6.9300E-01=F(  -0.693, +0)
{159, 3207501715u, 0u, 3207501715u, 0, FREXPF_TOLERANCE, 0 }, // -6.8200E-01=F(  -0.682, +0)
{160, 3207317166u, 0u, 3207317166u, 0, FREXPF_TOLERANCE, 0 }, // -6.7100E-01=F(  -0.671, +0)
{161, 3207132617u, 0u, 3207132617u, 0, FREXPF_TOLERANCE, 0 }, // -6.6000E-01=F(   -0.66, +0)
{162, 3206948068u, 0u, 3206948068u, 0, FREXPF_TOLERANCE, 0 }, // -6.4900E-01=F(  -0.649, +0)
{163, 3206763519u, 0u, 3206763519u, 0, FREXPF_TOLERANCE, 0 }, // -6.3800E-01=F(  -0.638, +0)
{164, 3206578970u, 0u, 3206578970u, 0, FREXPF_TOLERANCE, 0 }, // -6.2700E-01=F(  -0.627, +0)
{165, 3206394421u, 0u, 3206394421u, 0, FREXPF_TOLERANCE, 0 }, // -6.1600E-01=F(  -0.616, +0)
{166, 3206209872u, 0u, 3206209872u, 0, FREXPF_TOLERANCE, 0 }, // -6.0500E-01=F(  -0.605, +0)
{167, 3206025323u, 0u, 3206025323u, 0, FREXPF_TOLERANCE, 0 }, // -5.9400E-01=F(  -0.594, +0)
{168, 3205840774u, 0u, 3205840774u, 0, FREXPF_TOLERANCE, 0 }, // -5.8300E-01=F(  -0.583, +0)
{169, 3205656225u, 0u, 3205656225u, 0, FREXPF_TOLERANCE, 0 }, // -5.7200E-01=F(  -0.572, +0)
{170, 3205471676u, 0u, 3205471676u, 0, FREXPF_TOLERANCE, 0 }, // -5.6100E-01=F(  -0.561, +0)
{171, 3205287127u, 0u, 3205287127u, 0, FREXPF_TOLERANCE, 0 }, // -5.5000E-01=F(   -0.55, +0)
{172, 3205102578u, 0u, 3205102578u, 0, FREXPF_TOLERANCE, 0 }, // -5.3900E-01=F(  -0.539, +0)
{173, 3204918029u, 0u, 3204918029u, 0, FREXPF_TOLERANCE, 0 }, // -5.2800E-01=F(  -0.528, +0)
{174, 3204733480u, 0u, 3204733480u, 0, FREXPF_TOLERANCE, 0 }, // -5.1700E-01=F(  -0.517, +0)
{175, 3204548931u, 0u, 3204548931u, 0, FREXPF_TOLERANCE, 0 }, // -5.0600E-01=F(  -0.506, +0)
{176, 3204280507u, 4294967295u, 3212669115u, 0, FREXPF_TOLERANCE, 0 }, // -4.9500E-01=F(   -0.99, -1)
{177, 3203911408u, 4294967295u, 3212300016u, 0, FREXPF_TOLERANCE, 0 }, // -4.8400E-01=F(  -0.968, -1)
{178, 3203542309u, 4294967295u, 3211930917u, 0, FREXPF_TOLERANCE, 0 }, // -4.7300E-01=F(  -0.946, -1)
{179, 3203173210u, 4294967295u, 3211561818u, 0, FREXPF_TOLERANCE, 0 }, // -4.6200E-01=F(  -0.924, -1)
{180, 3202804111u, 4294967295u, 3211192719u, 0, FREXPF_TOLERANCE, 0 }, // -4.5100E-01=F(  -0.902, -1)
{181, 3202435012u, 4294967295u, 3210823620u, 0, FREXPF_TOLERANCE, 0 }, // -4.4000E-01=F(   -0.88, -1)
{182, 3202065913u, 4294967295u, 3210454521u, 0, FREXPF_TOLERANCE, 0 }, // -4.2900E-01=F(  -0.858, -1)
{183, 3201696814u, 4294967295u, 3210085422u, 0, FREXPF_TOLERANCE, 0 }, // -4.1800E-01=F(  -0.836, -1)
{184, 3201327715u, 4294967295u, 3209716323u, 0, FREXPF_TOLERANCE, 0 }, // -4.0700E-01=F(  -0.814, -1)
{185, 3200958616u, 4294967295u, 3209347224u, 0, FREXPF_TOLERANCE, 0 }, // -3.9600E-01=F(  -0.792, -1)
{186, 3200589517u, 4294967295u, 3208978125u, 0, FREXPF_TOLERANCE, 0 }, // -3.8500E-01=F(   -0.77, -1)
{187, 3200220418u, 4294967295u, 3208609026u, 0, FREXPF_TOLERANCE, 0 }, // -3.7400E-01=F(  -0.748, -1)
{188, 3199851319u, 4294967295u, 3208239927u, 0, FREXPF_TOLERANCE, 0 }, // -3.6300E-01=F(  -0.726, -1)
{189, 3199482220u, 4294967295u, 3207870828u, 0, FREXPF_TOLERANCE, 0 }, // -3.5200E-01=F(  -0.704, -1)
{190, 3199113121u, 4294967295u, 3207501729u, 0, FREXPF_TOLERANCE, 0 }, // -3.4100E-01=F(  -0.682, -1)
{191, 3198744022u, 4294967295u, 3207132630u, 0, FREXPF_TOLERANCE, 0 }, // -3.3000E-01=F(   -0.66, -1)
{192, 3198374923u, 4294967295u, 3206763531u, 0, FREXPF_TOLERANCE, 0 }, // -3.1900E-01=F(  -0.638, -1)
{193, 3198005824u, 4294967295u, 3206394432u, 0, FREXPF_TOLERANCE, 0 }, // -3.0800E-01=F(  -0.616, -1)
{194, 3197636725u, 4294967295u, 3206025333u, 0, FREXPF_TOLERANCE, 0 }, // -2.9700E-01=F(  -0.594, -1)
{195, 3197267626u, 4294967295u, 3205656234u, 0, FREXPF_TOLERANCE, 0 }, // -2.8600E-01=F(  -0.572, -1)
{196, 3196898527u, 4294967295u, 3205287135u, 0, FREXPF_TOLERANCE, 0 }, // -2.7500E-01=F(   -0.55, -1)
{197, 3196529428u, 4294967295u, 3204918036u, 0, FREXPF_TOLERANCE, 0 }, // -2.6400E-01=F(  -0.528, -1)
{198, 3196160329u, 4294967295u, 3204548937u, 0, FREXPF_TOLERANCE, 0 }, // -2.5300E-01=F(  -0.506, -1)
{199, 3195522812u, 4294967294u, 3212300028u, 0, FREXPF_TOLERANCE, 0 }, // -2.4200E-01=F(  -0.968, -2)
{200, 3194784614u, 4294967294u, 3211561830u, 0, FREXPF_TOLERANCE, 0 }, // -2.3100E-01=F(  -0.924, -2)
{201, 3194046416u, 4294967294u, 3210823632u, 0, FREXPF_TOLERANCE, 0 }, // -2.2000E-01=F(   -0.88, -2)
{202, 3193308218u, 4294967294u, 3210085434u, 0, FREXPF_TOLERANCE, 0 }, // -2.0900E-01=F(  -0.836, -2)
{203, 3192570020u, 4294967294u, 3209347236u, 0, FREXPF_TOLERANCE, 0 }, // -1.9800E-01=F(  -0.792, -2)
{204, 3191831822u, 4294967294u, 3208609038u, 0, FREXPF_TOLERANCE, 0 }, // -1.8700E-01=F(  -0.748, -2)
{205, 3191093624u, 4294967294u, 3207870840u, 0, FREXPF_TOLERANCE, 0 }, // -1.7600E-01=F(  -0.704, -2)
{206, 3190355426u, 4294967294u, 3207132642u, 0, FREXPF_TOLERANCE, 0 }, // -1.6500E-01=F(   -0.66, -2)
{207, 3189617228u, 4294967294u, 3206394444u, 0, FREXPF_TOLERANCE, 0 }, // -1.5400E-01=F(  -0.616, -2)
{208, 3188879030u, 4294967294u, 3205656246u, 0, FREXPF_TOLERANCE, 0 }, // -1.4300E-01=F(  -0.572, -2)
{209, 3188140832u, 4294967294u, 3204918048u, 0, FREXPF_TOLERANCE, 0 }, // -1.3200E-01=F(  -0.528, -2)
{210, 3187134229u, 4294967293u, 3212300053u, 0, FREXPF_TOLERANCE, 0 }, // -1.2100E-01=F(  -0.968, -3)
{211, 3185657834u, 4294967293u, 3210823658u, 0, FREXPF_TOLERANCE, 0 }, // -1.1000E-01=F(   -0.88, -3)
{212, 3184181439u, 4294967293u, 3209347263u, 0, FREXPF_TOLERANCE, 0 }, // -9.9000E-02=F(  -0.792, -3)
{213, 3182705044u, 4294967293u, 3207870868u, 0, FREXPF_TOLERANCE, 0 }, // -8.8000E-02=F(  -0.704, -3)
{214, 3181228649u, 4294967293u, 3206394473u, 0, FREXPF_TOLERANCE, 0 }, // -7.7000E-02=F(  -0.616, -3)
{215, 3179752254u, 4294967293u, 3204918078u, 0, FREXPF_TOLERANCE, 0 }, // -6.6000E-02=F(  -0.528, -3)
{216, 3177269286u, 4294967292u, 3210823718u, 0, FREXPF_TOLERANCE, 0 }, // -5.5000E-02=F(   -0.88, -4)
{217, 3174316496u, 4294967292u, 3207870928u, 0, FREXPF_TOLERANCE, 0 }, // -4.4000E-02=F(  -0.704, -4)
{218, 3171363706u, 4294967292u, 3204918138u, 0, FREXPF_TOLERANCE, 0 }, // -3.3000E-02=F(  -0.528, -4)
{219, 3165928008u, 4294967291u, 3207871048u, 0, FREXPF_TOLERANCE, 0 }, // -2.2000E-02=F(  -0.704, -5)
{220, 3157539640u, 4294967290u, 3207871288u, 0, FREXPF_TOLERANCE, 0 }, // -1.1000E-02=F(  -0.704, -6)
{221, 3035625423u, 4294967275u, 3211786191u, 0, FREXPF_TOLERANCE, 0 }, // -4.4698E-07=F( -0.9374, -21)
{222, 1010055032u, 4294967290u, 1060386680u, 0, FREXPF_TOLERANCE, 0 }, // +1.1000E-02=F(  +0.704, -6)
{223, 1018443880u, 4294967291u, 1060386920u, 0, FREXPF_TOLERANCE, 0 }, // +2.2000E-02=F(  +0.704, -5)
{224, 1023879818u, 4294967292u, 1057434250u, 0, FREXPF_TOLERANCE, 0 }, // +3.3000E-02=F(  +0.528, -4)
{225, 1026832608u, 4294967292u, 1060387040u, 0, FREXPF_TOLERANCE, 0 }, // +4.4000E-02=F(  +0.704, -4)
{226, 1029785398u, 4294967292u, 1063339830u, 0, FREXPF_TOLERANCE, 0 }, // +5.5000E-02=F(   +0.88, -4)
{227, 1032268486u, 4294967293u, 1057434310u, 0, FREXPF_TOLERANCE, 0 }, // +6.6000E-02=F(  +0.528, -3)
{228, 1033744881u, 4294967293u, 1058910705u, 0, FREXPF_TOLERANCE, 0 }, // +7.7000E-02=F(  +0.616, -3)
{229, 1035221276u, 4294967293u, 1060387100u, 0, FREXPF_TOLERANCE, 0 }, // +8.8000E-02=F(  +0.704, -3)
{230, 1036697671u, 4294967293u, 1061863495u, 0, FREXPF_TOLERANCE, 0 }, // +9.9000E-02=F(  +0.792, -3)
{231, 1038174066u, 4294967293u, 1063339890u, 0, FREXPF_TOLERANCE, 0 }, // +1.1000E-01=F(   +0.88, -3)
{232, 1039650461u, 4294967293u, 1064816285u, 0, FREXPF_TOLERANCE, 0 }, // +1.2100E-01=F(  +0.968, -3)
{233, 1040657124u, 4294967294u, 1057434340u, 0, FREXPF_TOLERANCE, 0 }, // +1.3200E-01=F(  +0.528, -2)
{234, 1041395322u, 4294967294u, 1058172538u, 0, FREXPF_TOLERANCE, 0 }, // +1.4300E-01=F(  +0.572, -2)
{235, 1042133520u, 4294967294u, 1058910736u, 0, FREXPF_TOLERANCE, 0 }, // +1.5400E-01=F(  +0.616, -2)
{236, 1042871718u, 4294967294u, 1059648934u, 0, FREXPF_TOLERANCE, 0 }, // +1.6500E-01=F(   +0.66, -2)
{237, 1043609916u, 4294967294u, 1060387132u, 0, FREXPF_TOLERANCE, 0 }, // +1.7600E-01=F(  +0.704, -2)
{238, 1044348114u, 4294967294u, 1061125330u, 0, FREXPF_TOLERANCE, 0 }, // +1.8700E-01=F(  +0.748, -2)
{239, 1045086312u, 4294967294u, 1061863528u, 0, FREXPF_TOLERANCE, 0 }, // +1.9800E-01=F(  +0.792, -2)
{240, 1045824510u, 4294967294u, 1062601726u, 0, FREXPF_TOLERANCE, 0 }, // +2.0900E-01=F(  +0.836, -2)
{241, 1046562708u, 4294967294u, 1063339924u, 0, FREXPF_TOLERANCE, 0 }, // +2.2000E-01=F(   +0.88, -2)
{242, 1047300906u, 4294967294u, 1064078122u, 0, FREXPF_TOLERANCE, 0 }, // +2.3100E-01=F(  +0.924, -2)
{243, 1048039104u, 4294967294u, 1064816320u, 0, FREXPF_TOLERANCE, 0 }, // +2.4200E-01=F(  +0.968, -2)
{244, 1048676651u, 4294967295u, 1057065259u, 0, FREXPF_TOLERANCE, 0 }, // +2.5300E-01=F(  +0.506, -1)
{245, 1049045750u, 4294967295u, 1057434358u, 0, FREXPF_TOLERANCE, 0 }, // +2.6400E-01=F(  +0.528, -1)
{246, 1049414849u, 4294967295u, 1057803457u, 0, FREXPF_TOLERANCE, 0 }, // +2.7500E-01=F(   +0.55, -1)
{247, 1049783948u, 4294967295u, 1058172556u, 0, FREXPF_TOLERANCE, 0 }, // +2.8600E-01=F(  +0.572, -1)
{248, 1050153047u, 4294967295u, 1058541655u, 0, FREXPF_TOLERANCE, 0 }, // +2.9700E-01=F(  +0.594, -1)
{249, 1050522146u, 4294967295u, 1058910754u, 0, FREXPF_TOLERANCE, 0 }, // +3.0800E-01=F(  +0.616, -1)
{250, 1050891245u, 4294967295u, 1059279853u, 0, FREXPF_TOLERANCE, 0 }, // +3.1900E-01=F(  +0.638, -1)
{251, 1051260344u, 4294967295u, 1059648952u, 0, FREXPF_TOLERANCE, 0 }, // +3.3000E-01=F(   +0.66, -1)
{252, 1051629443u, 4294967295u, 1060018051u, 0, FREXPF_TOLERANCE, 0 }, // +3.4100E-01=F(  +0.682, -1)
{253, 1051998542u, 4294967295u, 1060387150u, 0, FREXPF_TOLERANCE, 0 }, // +3.5200E-01=F(  +0.704, -1)
{254, 1052367641u, 4294967295u, 1060756249u, 0, FREXPF_TOLERANCE, 0 }, // +3.6300E-01=F(  +0.726, -1)
{255, 1052736740u, 4294967295u, 1061125348u, 0, FREXPF_TOLERANCE, 0 }, // +3.7400E-01=F(  +0.748, -1)
{256, 1053105839u, 4294967295u, 1061494447u, 0, FREXPF_TOLERANCE, 0 }, // +3.8500E-01=F(   +0.77, -1)
{257, 1053474938u, 4294967295u, 1061863546u, 0, FREXPF_TOLERANCE, 0 }, // +3.9600E-01=F(  +0.792, -1)
{258, 1053844037u, 4294967295u, 1062232645u, 0, FREXPF_TOLERANCE, 0 }, // +4.0700E-01=F(  +0.814, -1)
{259, 1054213136u, 4294967295u, 1062601744u, 0, FREXPF_TOLERANCE, 0 }, // +4.1800E-01=F(  +0.836, -1)
{260, 1054582235u, 4294967295u, 1062970843u, 0, FREXPF_TOLERANCE, 0 }, // +4.2900E-01=F(  +0.858, -1)
{261, 1054951334u, 4294967295u, 1063339942u, 0, FREXPF_TOLERANCE, 0 }, // +4.4000E-01=F(   +0.88, -1)
{262, 1055320433u, 4294967295u, 1063709041u, 0, FREXPF_TOLERANCE, 0 }, // +4.5100E-01=F(  +0.902, -1)
{263, 1055689532u, 4294967295u, 1064078140u, 0, FREXPF_TOLERANCE, 0 }, // +4.6200E-01=F(  +0.924, -1)
{264, 1056058631u, 4294967295u, 1064447239u, 0, FREXPF_TOLERANCE, 0 }, // +4.7300E-01=F(  +0.946, -1)
{265, 1056427730u, 4294967295u, 1064816338u, 0, FREXPF_TOLERANCE, 0 }, // +4.8400E-01=F(  +0.968, -1)
{266, 1056796829u, 4294967295u, 1065185437u, 0, FREXPF_TOLERANCE, 0 }, // +4.9500E-01=F(   +0.99, -1)
{267, 1057065268u, 0u, 1057065268u, 0, FREXPF_TOLERANCE, 0 }, // +5.0600E-01=F(  +0.506, +0)
{268, 1057249817u, 0u, 1057249817u, 0, FREXPF_TOLERANCE, 0 }, // +5.1700E-01=F(  +0.517, +0)
{269, 1057434366u, 0u, 1057434366u, 0, FREXPF_TOLERANCE, 0 }, // +5.2800E-01=F(  +0.528, +0)
{270, 1057618915u, 0u, 1057618915u, 0, FREXPF_TOLERANCE, 0 }, // +5.3900E-01=F(  +0.539, +0)
{271, 1057803464u, 0u, 1057803464u, 0, FREXPF_TOLERANCE, 0 }, // +5.5000E-01=F(   +0.55, +0)
{272, 1057988013u, 0u, 1057988013u, 0, FREXPF_TOLERANCE, 0 }, // +5.6100E-01=F(  +0.561, +0)
{273, 1058172562u, 0u, 1058172562u, 0, FREXPF_TOLERANCE, 0 }, // +5.7200E-01=F(  +0.572, +0)
{274, 1058357111u, 0u, 1058357111u, 0, FREXPF_TOLERANCE, 0 }, // +5.8300E-01=F(  +0.583, +0)
{275, 1058541660u, 0u, 1058541660u, 0, FREXPF_TOLERANCE, 0 }, // +5.9400E-01=F(  +0.594, +0)
{276, 1058726209u, 0u, 1058726209u, 0, FREXPF_TOLERANCE, 0 }, // +6.0500E-01=F(  +0.605, +0)
{277, 1058910758u, 0u, 1058910758u, 0, FREXPF_TOLERANCE, 0 }, // +6.1600E-01=F(  +0.616, +0)
{278, 1059095307u, 0u, 1059095307u, 0, FREXPF_TOLERANCE, 0 }, // +6.2700E-01=F(  +0.627, +0)
{279, 1059279856u, 0u, 1059279856u, 0, FREXPF_TOLERANCE, 0 }, // +6.3800E-01=F(  +0.638, +0)
{280, 1059464405u, 0u, 1059464405u, 0, FREXPF_TOLERANCE, 0 }, // +6.4900E-01=F(  +0.649, +0)
{281, 1059648954u, 0u, 1059648954u, 0, FREXPF_TOLERANCE, 0 }, // +6.6000E-01=F(   +0.66, +0)
{282, 1059833503u, 0u, 1059833503u, 0, FREXPF_TOLERANCE, 0 }, // +6.7100E-01=F(  +0.671, +0)
{283, 1060018052u, 0u, 1060018052u, 0, FREXPF_TOLERANCE, 0 }, // +6.8200E-01=F(  +0.682, +0)
{284, 1060202601u, 0u, 1060202601u, 0, FREXPF_TOLERANCE, 0 }, // +6.9300E-01=F(  +0.693, +0)
{285, 1060387150u, 0u, 1060387150u, 0, FREXPF_TOLERANCE, 0 }, // +7.0400E-01=F(  +0.704, +0)
{286, 1060571699u, 0u, 1060571699u, 0, FREXPF_TOLERANCE, 0 }, // +7.1500E-01=F(  +0.715, +0)
{287, 1060756248u, 0u, 1060756248u, 0, FREXPF_TOLERANCE, 0 }, // +7.2600E-01=F(  +0.726, +0)
{288, 1060940797u, 0u, 1060940797u, 0, FREXPF_TOLERANCE, 0 }, // +7.3700E-01=F(  +0.737, +0)
{289, 1061125346u, 0u, 1061125346u, 0, FREXPF_TOLERANCE, 0 }, // +7.4800E-01=F(  +0.748, +0)
{290, 1061309895u, 0u, 1061309895u, 0, FREXPF_TOLERANCE, 0 }, // +7.5900E-01=F(  +0.759, +0)
{291, 1061494444u, 0u, 1061494444u, 0, FREXPF_TOLERANCE, 0 }, // +7.7000E-01=F(   +0.77, +0)
{292, 1061678993u, 0u, 1061678993u, 0, FREXPF_TOLERANCE, 0 }, // +7.8100E-01=F(  +0.781, +0)
{293, 1061863542u, 0u, 1061863542u, 0, FREXPF_TOLERANCE, 0 }, // +7.9200E-01=F(  +0.792, +0)
{294, 1062048091u, 0u, 1062048091u, 0, FREXPF_TOLERANCE, 0 }, // +8.0300E-01=F(  +0.803, +0)
{295, 1062232640u, 0u, 1062232640u, 0, FREXPF_TOLERANCE, 0 }, // +8.1400E-01=F(  +0.814, +0)
{296, 1062417189u, 0u, 1062417189u, 0, FREXPF_TOLERANCE, 0 }, // +8.2500E-01=F(  +0.825, +0)
{297, 1062601738u, 0u, 1062601738u, 0, FREXPF_TOLERANCE, 0 }, // +8.3600E-01=F(  +0.836, +0)
{298, 1062786287u, 0u, 1062786287u, 0, FREXPF_TOLERANCE, 0 }, // +8.4700E-01=F(  +0.847, +0)
{299, 1062970836u, 0u, 1062970836u, 0, FREXPF_TOLERANCE, 0 }, // +8.5800E-01=F(  +0.858, +0)
{300, 1063155385u, 0u, 1063155385u, 0, FREXPF_TOLERANCE, 0 }, // +8.6900E-01=F(  +0.869, +0)
{301, 1063339934u, 0u, 1063339934u, 0, FREXPF_TOLERANCE, 0 }, // +8.8000E-01=F(   +0.88, +0)
{302, 1063524483u, 0u, 1063524483u, 0, FREXPF_TOLERANCE, 0 }, // +8.9100E-01=F(  +0.891, +0)
{303, 1063709032u, 0u, 1063709032u, 0, FREXPF_TOLERANCE, 0 }, // +9.0200E-01=F(  +0.902, +0)
{304, 1063893581u, 0u, 1063893581u, 0, FREXPF_TOLERANCE, 0 }, // +9.1300E-01=F(  +0.913, +0)
{305, 1064078130u, 0u, 1064078130u, 0, FREXPF_TOLERANCE, 0 }, // +9.2400E-01=F(  +0.924, +0)
{306, 1064262679u, 0u, 1064262679u, 0, FREXPF_TOLERANCE, 0 }, // +9.3500E-01=F(  +0.935, +0)
{307, 1064447228u, 0u, 1064447228u, 0, FREXPF_TOLERANCE, 0 }, // +9.4600E-01=F(  +0.946, +0)
{308, 1064631777u, 0u, 1064631777u, 0, FREXPF_TOLERANCE, 0 }, // +9.5700E-01=F(  +0.957, +0)
{309, 1064816326u, 0u, 1064816326u, 0, FREXPF_TOLERANCE, 0 }, // +9.6800E-01=F(  +0.968, +0)
{310, 1065000875u, 0u, 1065000875u, 0, FREXPF_TOLERANCE, 0 }, // +9.7900E-01=F(  +0.979, +0)
{311, 1065185424u, 0u, 1065185424u, 0, FREXPF_TOLERANCE, 0 }, // +9.9000E-01=F(   +0.99, +0)
{312, 1065361595u, 1u, 1056972987u, 0, FREXPF_TOLERANCE, 0 }, // +1.0010E+00=F( +0.5005, +1)
{313, 1065453870u, 1u, 1057065262u, 0, FREXPF_TOLERANCE, 0 }, // +1.0120E+00=F(  +0.506, +1)
{314, 1065546145u, 1u, 1057157537u, 0, FREXPF_TOLERANCE, 0 }, // +1.0230E+00=F( +0.5115, +1)
{315, 1065638420u, 1u, 1057249812u, 0, FREXPF_TOLERANCE, 0 }, // +1.0340E+00=F(  +0.517, +1)
{316, 1065730695u, 1u, 1057342087u, 0, FREXPF_TOLERANCE, 0 }, // +1.0450E+00=F( +0.5225, +1)
{317, 1065822970u, 1u, 1057434362u, 0, FREXPF_TOLERANCE, 0 }, // +1.0560E+00=F(  +0.528, +1)
{318, 1065915245u, 1u, 1057526637u, 0, FREXPF_TOLERANCE, 0 }, // +1.0670E+00=F( +0.5335, +1)
{319, 1066007520u, 1u, 1057618912u, 0, FREXPF_TOLERANCE, 0 }, // +1.0780E+00=F(  +0.539, +1)
{320, 1066099795u, 1u, 1057711187u, 0, FREXPF_TOLERANCE, 0 }, // +1.0890E+00=F( +0.5445, +1)
{321, 1066192070u, 1u, 1057803462u, 0, FREXPF_TOLERANCE, 0 }, // +1.1000E+00=F(   +0.55, +1)
{322, 3213675725u, 1u, 3205287117u, 0, FREXPF_TOLERANCE, 0 }, // -1.1000E+00=F(   -0.55, +1)
{323, 2999766221u, 4294967271u, 3209481421u, 0, FREXPF_TOLERANCE, 0 }, // -2.3842E-08=F(    -0.8, -25)
{324, 1066192077u, 1u, 1057803469u, 0, FREXPF_TOLERANCE, 0 }, // +1.1000E+00=F(   +0.55, +1)
{325, 1074580685u, 2u, 1057803469u, 0, FREXPF_TOLERANCE, 0 }, // +2.2000E+00=F(   +0.55, +2)
{326, 1079194419u, 2u, 1062417203u, 0, FREXPF_TOLERANCE, 0 }, // +3.3000E+00=F(  +0.825, +2)
{327, 1082969293u, 3u, 1057803469u, 0, FREXPF_TOLERANCE, 0 }, // +4.4000E+00=F(   +0.55, +3)
{328, 1085276160u, 3u, 1060110336u, 0, FREXPF_TOLERANCE, 0 }, // +5.5000E+00=F( +0.6875, +3)
{329, 1087583027u, 3u, 1062417203u, 0, FREXPF_TOLERANCE, 0 }, // +6.6000E+00=F(  +0.825, +3)
{330, 1089889894u, 3u, 1064724070u, 0, FREXPF_TOLERANCE, 0 }, // +7.7000E+00=F( +0.9625, +3)
{331, 1091357901u, 4u, 1057803469u, 0, FREXPF_TOLERANCE, 0 }, // +8.8000E+00=F(   +0.55, +4)
{332, 1092511335u, 4u, 1058956903u, 0, FREXPF_TOLERANCE, 0 }, // +9.9000E+00=F( +0.6188, +4)
{333, 1093664769u, 4u, 1060110337u, 0, FREXPF_TOLERANCE, 0 }, // +1.1000E+01=F( +0.6875, +4)
{334, 1094818203u, 4u, 1061263771u, 0, FREXPF_TOLERANCE, 0 }, // +1.2100E+01=F( +0.7563, +4)
{335, 1095971637u, 4u, 1062417205u, 0, FREXPF_TOLERANCE, 0 }, // +1.3200E+01=F(  +0.825, +4)
{336, 1097125071u, 4u, 1063570639u, 0, FREXPF_TOLERANCE, 0 }, // +1.4300E+01=F( +0.8938, +4)
{337, 1098278505u, 4u, 1064724073u, 0, FREXPF_TOLERANCE, 0 }, // +1.5400E+01=F( +0.9625, +4)
{338, 1099169793u, 5u, 1057226753u, 0, FREXPF_TOLERANCE, 0 }, // +1.6500E+01=F( +0.5156, +5)
{339, 1099746510u, 5u, 1057803470u, 0, FREXPF_TOLERANCE, 0 }, // +1.7600E+01=F(   +0.55, +5)
{340, 1100323227u, 5u, 1058380187u, 0, FREXPF_TOLERANCE, 0 }, // +1.8700E+01=F( +0.5844, +5)
{341, 1100899944u, 5u, 1058956904u, 0, FREXPF_TOLERANCE, 0 }, // +1.9800E+01=F( +0.6188, +5)
{342, 1101476661u, 5u, 1059533621u, 0, FREXPF_TOLERANCE, 0 }, // +2.0900E+01=F( +0.6531, +5)
{343, 1102053378u, 5u, 1060110338u, 0, FREXPF_TOLERANCE, 0 }, // +2.2000E+01=F( +0.6875, +5)
{344, 1102630095u, 5u, 1060687055u, 0, FREXPF_TOLERANCE, 0 }, // +2.3100E+01=F( +0.7219, +5)
{345, 1103206812u, 5u, 1061263772u, 0, FREXPF_TOLERANCE, 0 }, // +2.4200E+01=F( +0.7563, +5)
{346, 1103783529u, 5u, 1061840489u, 0, FREXPF_TOLERANCE, 0 }, // +2.5300E+01=F( +0.7906, +5)
{347, 1104360246u, 5u, 1062417206u, 0, FREXPF_TOLERANCE, 0 }, // +2.6400E+01=F(  +0.825, +5)
{348, 1104936963u, 5u, 1062993923u, 0, FREXPF_TOLERANCE, 0 }, // +2.7500E+01=F( +0.8594, +5)
{349, 1105513680u, 5u, 1063570640u, 0, FREXPF_TOLERANCE, 0 }, // +2.8600E+01=F( +0.8938, +5)
{350, 1106090397u, 5u, 1064147357u, 0, FREXPF_TOLERANCE, 0 }, // +2.9700E+01=F( +0.9281, +5)
{351, 1106667114u, 5u, 1064724074u, 0, FREXPF_TOLERANCE, 0 }, // +3.0800E+01=F( +0.9625, +5)
{352, 1107243831u, 5u, 1065300791u, 0, FREXPF_TOLERANCE, 0 }, // +3.1900E+01=F( +0.9969, +5)
{353, 1107558402u, 6u, 1057226754u, 0, FREXPF_TOLERANCE, 0 }, // +3.3000E+01=F( +0.5156, +6)
{354, 1107846760u, 6u, 1057515112u, 0, FREXPF_TOLERANCE, 0 }, // +3.4100E+01=F( +0.5328, +6)
{355, 1108135118u, 6u, 1057803470u, 0, FREXPF_TOLERANCE, 0 }, // +3.5200E+01=F(   +0.55, +6)
{356, 1108423476u, 6u, 1058091828u, 0, FREXPF_TOLERANCE, 0 }, // +3.6300E+01=F( +0.5672, +6)
{357, 1108711834u, 6u, 1058380186u, 0, FREXPF_TOLERANCE, 0 }, // +3.7400E+01=F( +0.5844, +6)
{358, 1109000192u, 6u, 1058668544u, 0, FREXPF_TOLERANCE, 0 }, // +3.8500E+01=F( +0.6016, +6)
{359, 1109288550u, 6u, 1058956902u, 0, FREXPF_TOLERANCE, 0 }, // +3.9600E+01=F( +0.6187, +6)
{360, 1109576908u, 6u, 1059245260u, 0, FREXPF_TOLERANCE, 0 }, // +4.0700E+01=F( +0.6359, +6)
{361, 1109865266u, 6u, 1059533618u, 0, FREXPF_TOLERANCE, 0 }, // +4.1800E+01=F( +0.6531, +6)
{362, 1110153624u, 6u, 1059821976u, 0, FREXPF_TOLERANCE, 0 }, // +4.2900E+01=F( +0.6703, +6)
{363, 1110441982u, 6u, 1060110334u, 0, FREXPF_TOLERANCE, 0 }, // +4.4000E+01=F( +0.6875, +6)
{364, 1110730340u, 6u, 1060398692u, 0, FREXPF_TOLERANCE, 0 }, // +4.5100E+01=F( +0.7047, +6)
{365, 1111018698u, 6u, 1060687050u, 0, FREXPF_TOLERANCE, 0 }, // +4.6200E+01=F( +0.7219, +6)
{366, 1111307056u, 6u, 1060975408u, 0, FREXPF_TOLERANCE, 0 }, // +4.7300E+01=F( +0.7391, +6)
{367, 1111595414u, 6u, 1061263766u, 0, FREXPF_TOLERANCE, 0 }, // +4.8400E+01=F( +0.7562, +6)
{368, 1111883772u, 6u, 1061552124u, 0, FREXPF_TOLERANCE, 0 }, // +4.9500E+01=F( +0.7734, +6)
{369, 1112172130u, 6u, 1061840482u, 0, FREXPF_TOLERANCE, 0 }, // +5.0600E+01=F( +0.7906, +6)
{370, 1112460488u, 6u, 1062128840u, 0, FREXPF_TOLERANCE, 0 }, // +5.1700E+01=F( +0.8078, +6)
{371, 1112748846u, 6u, 1062417198u, 0, FREXPF_TOLERANCE, 0 }, // +5.2800E+01=F(  +0.825, +6)
{372, 1113037204u, 6u, 1062705556u, 0, FREXPF_TOLERANCE, 0 }, // +5.3900E+01=F( +0.8422, +6)
{373, 1113325562u, 6u, 1062993914u, 0, FREXPF_TOLERANCE, 0 }, // +5.5000E+01=F( +0.8594, +6)
{374, 1113613920u, 6u, 1063282272u, 0, FREXPF_TOLERANCE, 0 }, // +5.6100E+01=F( +0.8766, +6)
{375, 1113902278u, 6u, 1063570630u, 0, FREXPF_TOLERANCE, 0 }, // +5.7200E+01=F( +0.8937, +6)
{376, 1114190636u, 6u, 1063858988u, 0, FREXPF_TOLERANCE, 0 }, // +5.8300E+01=F( +0.9109, +6)
{377, 1114478994u, 6u, 1064147346u, 0, FREXPF_TOLERANCE, 0 }, // +5.9400E+01=F( +0.9281, +6)
{378, 1114767352u, 6u, 1064435704u, 0, FREXPF_TOLERANCE, 0 }, // +6.0500E+01=F( +0.9453, +6)
{379, 1115055710u, 6u, 1064724062u, 0, FREXPF_TOLERANCE, 0 }, // +6.1600E+01=F( +0.9625, +6)
{380, 1115344068u, 6u, 1065012420u, 0, FREXPF_TOLERANCE, 0 }, // +6.2700E+01=F( +0.9797, +6)
{381, 1115632426u, 6u, 1065300778u, 0, FREXPF_TOLERANCE, 0 }, // +6.3800E+01=F( +0.9969, +6)
{382, 1115802824u, 7u, 1057082568u, 0, FREXPF_TOLERANCE, 0 }, // +6.4900E+01=F(  +0.507, +7)
{383, 1115947003u, 7u, 1057226747u, 0, FREXPF_TOLERANCE, 0 }, // +6.6000E+01=F( +0.5156, +7)
{384, 1116091182u, 7u, 1057370926u, 0, FREXPF_TOLERANCE, 0 }, // +6.7100E+01=F( +0.5242, +7)
{385, 1116235361u, 7u, 1057515105u, 0, FREXPF_TOLERANCE, 0 }, // +6.8200E+01=F( +0.5328, +7)
{386, 1116379540u, 7u, 1057659284u, 0, FREXPF_TOLERANCE, 0 }, // +6.9300E+01=F( +0.5414, +7)
{387, 1116523719u, 7u, 1057803463u, 0, FREXPF_TOLERANCE, 0 }, // +7.0400E+01=F(   +0.55, +7)
{388, 1116667898u, 7u, 1057947642u, 0, FREXPF_TOLERANCE, 0 }, // +7.1500E+01=F( +0.5586, +7)
{389, 1116812077u, 7u, 1058091821u, 0, FREXPF_TOLERANCE, 0 }, // +7.2600E+01=F( +0.5672, +7)
{390, 1116956256u, 7u, 1058236000u, 0, FREXPF_TOLERANCE, 0 }, // +7.3700E+01=F( +0.5758, +7)
{391, 1117100435u, 7u, 1058380179u, 0, FREXPF_TOLERANCE, 0 }, // +7.4800E+01=F( +0.5844, +7)
{392, 1117244614u, 7u, 1058524358u, 0, FREXPF_TOLERANCE, 0 }, // +7.5900E+01=F(  +0.593, +7)
{393, 1117388793u, 7u, 1058668537u, 0, FREXPF_TOLERANCE, 0 }, // +7.7000E+01=F( +0.6016, +7)
{394, 1117532972u, 7u, 1058812716u, 0, FREXPF_TOLERANCE, 0 }, // +7.8100E+01=F( +0.6102, +7)
{395, 1117677151u, 7u, 1058956895u, 0, FREXPF_TOLERANCE, 0 }, // +7.9200E+01=F( +0.6187, +7)
{396, 1117821330u, 7u, 1059101074u, 0, FREXPF_TOLERANCE, 0 }, // +8.0300E+01=F( +0.6273, +7)
{397, 1117965509u, 7u, 1059245253u, 0, FREXPF_TOLERANCE, 0 }, // +8.1400E+01=F( +0.6359, +7)
{398, 1118109688u, 7u, 1059389432u, 0, FREXPF_TOLERANCE, 0 }, // +8.2500E+01=F( +0.6445, +7)
{399, 1118253867u, 7u, 1059533611u, 0, FREXPF_TOLERANCE, 0 }, // +8.3600E+01=F( +0.6531, +7)
{400, 1118398046u, 7u, 1059677790u, 0, FREXPF_TOLERANCE, 0 }, // +8.4700E+01=F( +0.6617, +7)
{401, 1118542225u, 7u, 1059821969u, 0, FREXPF_TOLERANCE, 0 }, // +8.5800E+01=F( +0.6703, +7)
{402, 1118686404u, 7u, 1059966148u, 0, FREXPF_TOLERANCE, 0 }, // +8.6900E+01=F( +0.6789, +7)
{403, 1118830583u, 7u, 1060110327u, 0, FREXPF_TOLERANCE, 0 }, // +8.8000E+01=F( +0.6875, +7)
{404, 1118974762u, 7u, 1060254506u, 0, FREXPF_TOLERANCE, 0 }, // +8.9100E+01=F( +0.6961, +7)
{405, 1119118941u, 7u, 1060398685u, 0, FREXPF_TOLERANCE, 0 }, // +9.0200E+01=F( +0.7047, +7)
{406, 1119263120u, 7u, 1060542864u, 0, FREXPF_TOLERANCE, 0 }, // +9.1300E+01=F( +0.7133, +7)
{407, 1119407299u, 7u, 1060687043u, 0, FREXPF_TOLERANCE, 0 }, // +9.2400E+01=F( +0.7219, +7)
{408, 1119551478u, 7u, 1060831222u, 0, FREXPF_TOLERANCE, 0 }, // +9.3500E+01=F( +0.7305, +7)
{409, 1119695657u, 7u, 1060975401u, 0, FREXPF_TOLERANCE, 0 }, // +9.4600E+01=F( +0.7391, +7)
{410, 1119839836u, 7u, 1061119580u, 0, FREXPF_TOLERANCE, 0 }, // +9.5700E+01=F( +0.7477, +7)
{411, 1119984015u, 7u, 1061263759u, 0, FREXPF_TOLERANCE, 0 }, // +9.6800E+01=F( +0.7562, +7)
{412, 1120128194u, 7u, 1061407938u, 0, FREXPF_TOLERANCE, 0 }, // +9.7900E+01=F( +0.7648, +7)
{413, 1120272373u, 7u, 1061552117u, 0, FREXPF_TOLERANCE, 0 }, // +9.9000E+01=F( +0.7734, +7)
{414, 1120416552u, 7u, 1061696296u, 0, FREXPF_TOLERANCE, 0 }, // +1.0010E+02=F(  +0.782, +7)
{415, 1120560731u, 7u, 1061840475u, 0, FREXPF_TOLERANCE, 0 }, // +1.0120E+02=F( +0.7906, +7)
{416, 1120704910u, 7u, 1061984654u, 0, FREXPF_TOLERANCE, 0 }, // +1.0230E+02=F( +0.7992, +7)
{417, 1120849089u, 7u, 1062128833u, 0, FREXPF_TOLERANCE, 0 }, // +1.0340E+02=F( +0.8078, +7)
{418, 1120993268u, 7u, 1062273012u, 0, FREXPF_TOLERANCE, 0 }, // +1.0450E+02=F( +0.8164, +7)
{419, 1121137447u, 7u, 1062417191u, 0, FREXPF_TOLERANCE, 0 }, // +1.0560E+02=F(  +0.825, +7)
{420, 1121281626u, 7u, 1062561370u, 0, FREXPF_TOLERANCE, 0 }, // +1.0670E+02=F( +0.8336, +7)
{421, 1121425805u, 7u, 1062705549u, 0, FREXPF_TOLERANCE, 0 }, // +1.0780E+02=F( +0.8422, +7)
{422, 1121569984u, 7u, 1062849728u, 0, FREXPF_TOLERANCE, 0 }, // +1.0890E+02=F( +0.8508, +7)
{423, 1121714163u, 7u, 1062993907u, 0, FREXPF_TOLERANCE, 0 }, // +1.1000E+02=F( +0.8594, +7)
{424, 1121845248u, 7u, 1063124992u, 0, FREXPF_TOLERANCE, 0 }, // +1.1100E+02=F( +0.8672, +7)
{425, 1130233856u, 8u, 1063124992u, 0, FREXPF_TOLERANCE, 0 }, // +2.2200E+02=F( +0.8672, +8)
{426, 1134985216u, 9u, 1059487744u, 0, FREXPF_TOLERANCE, 0 }, // +3.3300E+02=F( +0.6504, +9)
{427, 1138622464u, 9u, 1063124992u, 0, FREXPF_TOLERANCE, 0 }, // +4.4400E+02=F( +0.8672, +9)
{428, 1141555200u, 10u, 1057669120u, 0, FREXPF_TOLERANCE, 0 }, // +5.5500E+02=F(  +0.542, +10)
{429, 1143373824u, 10u, 1059487744u, 0, FREXPF_TOLERANCE, 0 }, // +6.6600E+02=F( +0.6504, +10)
{430, 1145192448u, 10u, 1061306368u, 0, FREXPF_TOLERANCE, 0 }, // +7.7700E+02=F( +0.7588, +10)
{431, 1147011072u, 10u, 1063124992u, 0, FREXPF_TOLERANCE, 0 }, // +8.8800E+02=F( +0.8672, +10)
{432, 1148829696u, 10u, 1064943616u, 0, FREXPF_TOLERANCE, 0 }, // +9.9900E+02=F( +0.9756, +10)
{433, 1149943808u, 11u, 1057669120u, 0, FREXPF_TOLERANCE, 0 }, // +1.1100E+03=F(  +0.542, +11)
{434, 1149952000u, 11u, 1057677312u, 0, FREXPF_TOLERANCE, 0 }, // +1.1110E+03=F( +0.5425, +11)
{435, 1344628517u, 34u, 1059415845u, 0, FREXPF_TOLERANCE, 0 }, // +1.1100E+10=F( +0.6461, +34)
{436, 1353017124u, 35u, 1059415844u, 0, FREXPF_TOLERANCE, 0 }, // +2.2200E+10=F( +0.6461, +35)
{437, 1358437046u, 35u, 1064835766u, 0, FREXPF_TOLERANCE, 0 }, // +3.3300E+10=F( +0.9692, +35)
{438, 1361405732u, 36u, 1059415844u, 0, FREXPF_TOLERANCE, 0 }, // +4.4400E+10=F( +0.6461, +36)
{439, 1364115693u, 36u, 1062125805u, 0, FREXPF_TOLERANCE, 0 }, // +5.5500E+10=F( +0.8076, +36)
{440, 1366825654u, 36u, 1064835766u, 0, FREXPF_TOLERANCE, 0 }, // +6.6600E+10=F( +0.9692, +36)
{441, 1368439359u, 37u, 1058060863u, 0, FREXPF_TOLERANCE, 0 }, // +7.7700E+10=F( +0.5653, +37)
{442, 1369794339u, 37u, 1059415843u, 0, FREXPF_TOLERANCE, 0 }, // +8.8800E+10=F( +0.6461, +37)
{443, 1371149319u, 37u, 1060770823u, 0, FREXPF_TOLERANCE, 0 }, // +9.9900E+10=F( +0.7269, +37)
{444, 1372504299u, 37u, 1062125803u, 0, FREXPF_TOLERANCE, 0 }, // +1.1100E+11=F( +0.8076, +37)
{445, 0u, 0u, 0u, 0, FREXPF_TOLERANCE, 0 }, // +0.0000E+00=F(      +0, +0)
{446, 8388608u, 4294967171u, 1056964608u, 0, FREXPF_TOLERANCE, 0 }, // +1.1755E-38=F(    +0.5, -125)
{447, 2139095039u, 128u, 1065353215u, 0, FREXPF_TOLERANCE, 0 }, // +3.4028E+38=F(      +1, +128)
{448, 2143289344u, 0u, 2143289344u, 0, FREXPF_TOLERANCE, 0 }, // +NAN       =F(    +nan, +0)
{449, 2139095040u, 0u, 2139095040u, 0, FREXPF_TOLERANCE, 0 }, // +INF       =F(    +inf, +0)

// AUTOMATICALLY GENERATED VECTORS STOP

};

#endif // CYGONCE_LIBM_FREXPF_H multiple inclusion protection

// EOF frexpf.h
