#ifndef CYGONCE_LIBM_FMOD_H
#define CYGONCE_LIBM_FMOD_H
//===========================================================================
//
//      fmod.h
//
//      Test vectors for testing of fmod() math library function
//
//===========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 2012 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later
// version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License
// along with eCos; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
// As a special exception, if other files instantiate templates or use
// macros or inline functions from this file, or you compile this file
// and link it with other works to produce a work based on this file,
// this file does not by itself cause the resulting work to be covered by
// the GNU General Public License. However the source code for this file
// must still be made available in accordance with section (3) of the GNU
// General Public License v2.
//
// This exception does not invalidate any other reasons why a work based
// on this file might be covered by the GNU General Public License.
// -------------------------------------------
// ####ECOSGPLCOPYRIGHTEND####
//===========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):
// Contributors:  visar, ilijak
// Date:        1998-02-13
// Purpose:
// Description:
// Usage:       #include "vectors/fmod.h"
//
//####DESCRIPTIONEND####
//
//===========================================================================


// CONFIGURATION

#include <pkgconf/libm.h>   // Configuration header


// INCLUDES

#include <cyg/infra/cyg_type.h>    // Common type definitions and support
#include "vectors/vector_support_float.h"// extra support for math tests

#define FMOD_TOLERANCE 2.0E-04

static const Cyg_libm_test_float_vec_t fmodf_vec[] = {

// AUTOMATICALLY GENERATED VECTORS START

{0, 3214514586u, 1077097267u, 3214514586u, 0, FMOD_TOLERANCE, 0},
{1, 3214430700u, 1077139210u, 3214430700u, 0, FMOD_TOLERANCE, 0},
{2, 3214346813u, 1077181153u, 3214346813u, 0, FMOD_TOLERANCE, 0},
{3, 3214262927u, 1077223096u, 3214262927u, 0, FMOD_TOLERANCE, 0},
{4, 3214179041u, 1077265039u, 3214179041u, 0, FMOD_TOLERANCE, 0},
{5, 3214095155u, 1077306982u, 3214095155u, 0, FMOD_TOLERANCE, 0},
{6, 3214011269u, 1077348925u, 3214011269u, 0, FMOD_TOLERANCE, 0},
{7, 3213927383u, 1077390868u, 3213927383u, 0, FMOD_TOLERANCE, 0},
{8, 3213843497u, 1077432812u, 3213843497u, 0, FMOD_TOLERANCE, 0},
{9, 3213759611u, 1077474755u, 3213759611u, 0, FMOD_TOLERANCE, 0},
{10, 3213675725u, 1077516698u, 3213675725u, 0, FMOD_TOLERANCE, 0},
{11, 3213591839u, 1077558641u, 3213591839u, 0, FMOD_TOLERANCE, 0},
{12, 3213507953u, 1077600584u, 3213507953u, 0, FMOD_TOLERANCE, 0},
{13, 3213424067u, 1077642527u, 3213424067u, 0, FMOD_TOLERANCE, 0},
{14, 3213340180u, 1077684470u, 3213340180u, 0, FMOD_TOLERANCE, 0},
{15, 3213256294u, 1077726413u, 3213256294u, 0, FMOD_TOLERANCE, 0},
{16, 3213172408u, 1077768356u, 3213172408u, 0, FMOD_TOLERANCE, 0},
{17, 3213088522u, 1077810299u, 3213088522u, 0, FMOD_TOLERANCE, 0},
{18, 3213004636u, 1077852242u, 3213004636u, 0, FMOD_TOLERANCE, 0},
{19, 3212920750u, 1077894185u, 3212920750u, 0, FMOD_TOLERANCE, 0},
{20, 3212836864u, 1077936128u, 3212836864u, 0, FMOD_TOLERANCE, 0},
{21, 3212669092u, 1077978071u, 3212669092u, 0, FMOD_TOLERANCE, 0},
{22, 3212501320u, 1078020014u, 3212501320u, 0, FMOD_TOLERANCE, 0},
{23, 3212333548u, 1078061957u, 3212333548u, 0, FMOD_TOLERANCE, 0},
{24, 3212165775u, 1078103900u, 3212165775u, 0, FMOD_TOLERANCE, 0},
{25, 3211998003u, 1078145843u, 3211998003u, 0, FMOD_TOLERANCE, 0},
{26, 3211830231u, 1078187786u, 3211830231u, 0, FMOD_TOLERANCE, 0},
{27, 3211662459u, 1078229729u, 3211662459u, 0, FMOD_TOLERANCE, 0},
{28, 3211494687u, 1078271672u, 3211494687u, 0, FMOD_TOLERANCE, 0},
{29, 3211326915u, 1078313615u, 3211326915u, 0, FMOD_TOLERANCE, 0},
{30, 3211159142u, 1078355558u, 3211159142u, 0, FMOD_TOLERANCE, 0},
{31, 3210991370u, 1078397501u, 3210991370u, 0, FMOD_TOLERANCE, 0},
{32, 3210823598u, 1078439444u, 3210823598u, 0, FMOD_TOLERANCE, 0},
{33, 3210655826u, 1078481388u, 3210655826u, 0, FMOD_TOLERANCE, 0},
{34, 3210488054u, 1078523331u, 3210488054u, 0, FMOD_TOLERANCE, 0},
{35, 3210320282u, 1078565274u, 3210320282u, 0, FMOD_TOLERANCE, 0},
{36, 3210152509u, 1078607217u, 3210152509u, 0, FMOD_TOLERANCE, 0},
{37, 3209984737u, 1078649160u, 3209984737u, 0, FMOD_TOLERANCE, 0},
{38, 3209816965u, 1078691103u, 3209816965u, 0, FMOD_TOLERANCE, 0},
{39, 3209649193u, 1078733046u, 3209649193u, 0, FMOD_TOLERANCE, 0},
{40, 3209481421u, 1078774989u, 3209481421u, 0, FMOD_TOLERANCE, 0},
{41, 3209313649u, 1078816932u, 3209313649u, 0, FMOD_TOLERANCE, 0},
{42, 3209145876u, 1078858875u, 3209145876u, 0, FMOD_TOLERANCE, 0},
{43, 3208978104u, 1078900818u, 3208978104u, 0, FMOD_TOLERANCE, 0},
{44, 3208810332u, 1078942761u, 3208810332u, 0, FMOD_TOLERANCE, 0},
{45, 3208642560u, 1078984704u, 3208642560u, 0, FMOD_TOLERANCE, 0},
{46, 3208474788u, 1079026647u, 3208474788u, 0, FMOD_TOLERANCE, 0},
{47, 3208307016u, 1079068590u, 3208307016u, 0, FMOD_TOLERANCE, 0},
{48, 3208139244u, 1079110533u, 3208139244u, 0, FMOD_TOLERANCE, 0},
{49, 3207971471u, 1079152476u, 3207971471u, 0, FMOD_TOLERANCE, 0},
{50, 3207803699u, 1079194419u, 3207803699u, 0, FMOD_TOLERANCE, 0},
{51, 3207635927u, 1079236362u, 3207635927u, 0, FMOD_TOLERANCE, 0},
{52, 3207468155u, 1079278305u, 3207468155u, 0, FMOD_TOLERANCE, 0},
{53, 3207300383u, 1079320248u, 3207300383u, 0, FMOD_TOLERANCE, 0},
{54, 3207132611u, 1079362191u, 3207132611u, 0, FMOD_TOLERANCE, 0},
{55, 3206964838u, 1079404134u, 3206964838u, 0, FMOD_TOLERANCE, 0},
{56, 3206797066u, 1079446077u, 3206797066u, 0, FMOD_TOLERANCE, 0},
{57, 3206629294u, 1079488020u, 3206629294u, 0, FMOD_TOLERANCE, 0},
{58, 3206461522u, 1079529964u, 3206461522u, 0, FMOD_TOLERANCE, 0},
{59, 3206293750u, 1079571907u, 3206293750u, 0, FMOD_TOLERANCE, 0},
{60, 3206125978u, 1079613850u, 3206125978u, 0, FMOD_TOLERANCE, 0},
{61, 3205958205u, 1079655793u, 3205958205u, 0, FMOD_TOLERANCE, 0},
{62, 3205790433u, 1079697736u, 3205790433u, 0, FMOD_TOLERANCE, 0},
{63, 3205622661u, 1079739679u, 3205622661u, 0, FMOD_TOLERANCE, 0},
{64, 3205454889u, 1079781622u, 3205454889u, 0, FMOD_TOLERANCE, 0},
{65, 3205287117u, 1079823565u, 3205287117u, 0, FMOD_TOLERANCE, 0},
{66, 3205119345u, 1079865508u, 3205119345u, 0, FMOD_TOLERANCE, 0},
{67, 3204951572u, 1079907451u, 3204951572u, 0, FMOD_TOLERANCE, 0},
{68, 3204783800u, 1079949394u, 3204783800u, 0, FMOD_TOLERANCE, 0},
{69, 3204616028u, 1079991337u, 3204616028u, 0, FMOD_TOLERANCE, 0},
{70, 3204448256u, 1080033280u, 3204448256u, 0, FMOD_TOLERANCE, 0},
{71, 3204112712u, 1080075223u, 3204112712u, 0, FMOD_TOLERANCE, 0},
{72, 3203777167u, 1080117166u, 3203777167u, 0, FMOD_TOLERANCE, 0},
{73, 3203441623u, 1080159109u, 3203441623u, 0, FMOD_TOLERANCE, 0},
{74, 3203106079u, 1080201052u, 3203106079u, 0, FMOD_TOLERANCE, 0},
{75, 3202770534u, 1080242995u, 3202770534u, 0, FMOD_TOLERANCE, 0},
{76, 3202434990u, 1080284938u, 3202434990u, 0, FMOD_TOLERANCE, 0},
{77, 3202099446u, 1080326881u, 3202099446u, 0, FMOD_TOLERANCE, 0},
{78, 3201763901u, 1080368824u, 3201763901u, 0, FMOD_TOLERANCE, 0},
{79, 3201428357u, 1080410767u, 3201428357u, 0, FMOD_TOLERANCE, 0},
{80, 3201092813u, 1080452710u, 3201092813u, 0, FMOD_TOLERANCE, 0},
{81, 3200757268u, 1080494653u, 3200757268u, 0, FMOD_TOLERANCE, 0},
{82, 3200421724u, 1080536596u, 3200421724u, 0, FMOD_TOLERANCE, 0},
{83, 3200086180u, 1080578540u, 3200086180u, 0, FMOD_TOLERANCE, 0},
{84, 3199750636u, 1080620483u, 3199750636u, 0, FMOD_TOLERANCE, 0},
{85, 3199415091u, 1080662426u, 3199415091u, 0, FMOD_TOLERANCE, 0},
{86, 3199079547u, 1080704369u, 3199079547u, 0, FMOD_TOLERANCE, 0},
{87, 3198744003u, 1080746312u, 3198744003u, 0, FMOD_TOLERANCE, 0},
{88, 3198408458u, 1080788255u, 3198408458u, 0, FMOD_TOLERANCE, 0},
{89, 3198072914u, 1080830198u, 3198072914u, 0, FMOD_TOLERANCE, 0},
{90, 3197737370u, 1080872141u, 3197737370u, 0, FMOD_TOLERANCE, 0},
{91, 3197401825u, 1080914084u, 3197401825u, 0, FMOD_TOLERANCE, 0},
{92, 3197066281u, 1080956027u, 3197066281u, 0, FMOD_TOLERANCE, 0},
{93, 3196730737u, 1080997970u, 3196730737u, 0, FMOD_TOLERANCE, 0},
{94, 3196395192u, 1081039913u, 3196395192u, 0, FMOD_TOLERANCE, 0},
{95, 3196059648u, 1081081856u, 3196059648u, 0, FMOD_TOLERANCE, 0},
{96, 3195388559u, 1081123799u, 3195388559u, 0, FMOD_TOLERANCE, 0},
{97, 3194717471u, 1081165742u, 3194717471u, 0, FMOD_TOLERANCE, 0},
{98, 3194046382u, 1081207685u, 3194046382u, 0, FMOD_TOLERANCE, 0},
{99, 3193375293u, 1081249628u, 3193375293u, 0, FMOD_TOLERANCE, 0},
{100, 3192704205u, 1081291571u, 3192704205u, 0, FMOD_TOLERANCE, 0},
{101, 3192033116u, 1081333514u, 3192033116u, 0, FMOD_TOLERANCE, 0},
{102, 3191362028u, 1081375457u, 3191362028u, 0, FMOD_TOLERANCE, 0},
{103, 3190690939u, 1081417400u, 3190690939u, 0, FMOD_TOLERANCE, 0},
{104, 3190019850u, 1081459343u, 3190019850u, 0, FMOD_TOLERANCE, 0},
{105, 3189348762u, 1081501286u, 3189348762u, 0, FMOD_TOLERANCE, 0},
{106, 3188677673u, 1081543229u, 3188677673u, 0, FMOD_TOLERANCE, 0},
{107, 3188006584u, 1081585172u, 3188006584u, 0, FMOD_TOLERANCE, 0},
{108, 3186999951u, 1081627116u, 3186999951u, 0, FMOD_TOLERANCE, 0},
{109, 3185657774u, 1081669059u, 3185657774u, 0, FMOD_TOLERANCE, 0},
{110, 3184315597u, 1081711002u, 3184315597u, 0, FMOD_TOLERANCE, 0},
{111, 3182973420u, 1081752945u, 3182973420u, 0, FMOD_TOLERANCE, 0},
{112, 3181631242u, 1081794888u, 3181631242u, 0, FMOD_TOLERANCE, 0},
{113, 3180289065u, 1081836831u, 3180289065u, 0, FMOD_TOLERANCE, 0},
{114, 3178611343u, 1081878774u, 3178611343u, 0, FMOD_TOLERANCE, 0},
{115, 3175926989u, 1081920717u, 3175926989u, 0, FMOD_TOLERANCE, 0},
{116, 3173242634u, 1081962660u, 3173242634u, 0, FMOD_TOLERANCE, 0},
{117, 3170222735u, 1082004603u, 3170222735u, 0, FMOD_TOLERANCE, 0},
{118, 3164854026u, 1082046546u, 3164854026u, 0, FMOD_TOLERANCE, 0},
{119, 3156465418u, 1082088489u, 3156465418u, 0, FMOD_TOLERANCE, 0},
{120, 1008981770u, 1082151404u, 1008981770u, 0, FMOD_TOLERANCE, 0},
{121, 1017370378u, 1082172375u, 1017370378u, 0, FMOD_TOLERANCE, 0},
{122, 1022739087u, 1082193347u, 1022739087u, 0, FMOD_TOLERANCE, 0},
{123, 1025758986u, 1082214318u, 1025758986u, 0, FMOD_TOLERANCE, 0},
{124, 1028443341u, 1082235290u, 1028443341u, 0, FMOD_TOLERANCE, 0},
{125, 1031127695u, 1082256261u, 1031127695u, 0, FMOD_TOLERANCE, 0},
{126, 1032805417u, 1082277233u, 1032805417u, 0, FMOD_TOLERANCE, 0},
{127, 1034147594u, 1082298204u, 1034147594u, 0, FMOD_TOLERANCE, 0},
{128, 1035489772u, 1082319176u, 1035489772u, 0, FMOD_TOLERANCE, 0},
{129, 1036831949u, 1082340147u, 1036831949u, 0, FMOD_TOLERANCE, 0},
{130, 1038174126u, 1082361119u, 1038174126u, 0, FMOD_TOLERANCE, 0},
{131, 1039516303u, 1082382090u, 1039516303u, 0, FMOD_TOLERANCE, 0},
{132, 1040522936u, 1082403062u, 1040522936u, 0, FMOD_TOLERANCE, 0},
{133, 1041194025u, 1082424033u, 1041194025u, 0, FMOD_TOLERANCE, 0},
{134, 1041865114u, 1082445005u, 1041865114u, 0, FMOD_TOLERANCE, 0},
{135, 1042536202u, 1082465976u, 1042536202u, 0, FMOD_TOLERANCE, 0},
{136, 1043207291u, 1082486948u, 1043207291u, 0, FMOD_TOLERANCE, 0},
{137, 1043878380u, 1082507919u, 1043878380u, 0, FMOD_TOLERANCE, 0},
{138, 1044549468u, 1082528891u, 1044549468u, 0, FMOD_TOLERANCE, 0},
{139, 1045220557u, 1082549862u, 1045220557u, 0, FMOD_TOLERANCE, 0},
{140, 1045891645u, 1082570834u, 1045891645u, 0, FMOD_TOLERANCE, 0},
{141, 1046562734u, 1082591805u, 1046562734u, 0, FMOD_TOLERANCE, 0},
{142, 1047233823u, 1082612777u, 1047233823u, 0, FMOD_TOLERANCE, 0},
{143, 1047904911u, 1082633748u, 1047904911u, 0, FMOD_TOLERANCE, 0},
{144, 1048576000u, 1082654720u, 1048576000u, 0, FMOD_TOLERANCE, 0},
{145, 1048911544u, 1082675692u, 1048911544u, 0, FMOD_TOLERANCE, 0},
{146, 1049247089u, 1082696663u, 1049247089u, 0, FMOD_TOLERANCE, 0},
{147, 1049582633u, 1082717635u, 1049582633u, 0, FMOD_TOLERANCE, 0},
{148, 1049918177u, 1082738606u, 1049918177u, 0, FMOD_TOLERANCE, 0},
{149, 1050253722u, 1082759578u, 1050253722u, 0, FMOD_TOLERANCE, 0},
{150, 1050589266u, 1082780549u, 1050589266u, 0, FMOD_TOLERANCE, 0},
{151, 1050924810u, 1082801521u, 1050924810u, 0, FMOD_TOLERANCE, 0},
{152, 1051260355u, 1082822492u, 1051260355u, 0, FMOD_TOLERANCE, 0},
{153, 1051595899u, 1082843464u, 1051595899u, 0, FMOD_TOLERANCE, 0},
{154, 1051931443u, 1082864435u, 1051931443u, 0, FMOD_TOLERANCE, 0},
{155, 1052266988u, 1082885407u, 1052266988u, 0, FMOD_TOLERANCE, 0},
{156, 1052602532u, 1082906378u, 1052602532u, 0, FMOD_TOLERANCE, 0},
{157, 1052938076u, 1082927350u, 1052938076u, 0, FMOD_TOLERANCE, 0},
{158, 1053273620u, 1082948321u, 1053273620u, 0, FMOD_TOLERANCE, 0},
{159, 1053609165u, 1082969293u, 1053609165u, 0, FMOD_TOLERANCE, 0},
{160, 1053944709u, 1082990264u, 1053944709u, 0, FMOD_TOLERANCE, 0},
{161, 1054280253u, 1083011236u, 1054280253u, 0, FMOD_TOLERANCE, 0},
{162, 1054615798u, 1083032207u, 1054615798u, 0, FMOD_TOLERANCE, 0},
{163, 1054951342u, 1083053179u, 1054951342u, 0, FMOD_TOLERANCE, 0},
{164, 1055286886u, 1083074150u, 1055286886u, 0, FMOD_TOLERANCE, 0},
{165, 1055622431u, 1083095122u, 1055622431u, 0, FMOD_TOLERANCE, 0},
{166, 1055957975u, 1083116093u, 1055957975u, 0, FMOD_TOLERANCE, 0},
{167, 1056293519u, 1083137065u, 1056293519u, 0, FMOD_TOLERANCE, 0},
{168, 1056629064u, 1083158036u, 1056629064u, 0, FMOD_TOLERANCE, 0},
{169, 1056964608u, 1083179008u, 1056964608u, 0, FMOD_TOLERANCE, 0},
{170, 1057132380u, 1083199980u, 1057132380u, 0, FMOD_TOLERANCE, 0},
{171, 1057300152u, 1083220951u, 1057300152u, 0, FMOD_TOLERANCE, 0},
{172, 1057467924u, 1083241923u, 1057467924u, 0, FMOD_TOLERANCE, 0},
{173, 1057635697u, 1083262894u, 1057635697u, 0, FMOD_TOLERANCE, 0},
{174, 1057803469u, 1083283866u, 1057803469u, 0, FMOD_TOLERANCE, 0},
{175, 1057971241u, 1083304837u, 1057971241u, 0, FMOD_TOLERANCE, 0},
{176, 1058139013u, 1083325809u, 1058139013u, 0, FMOD_TOLERANCE, 0},
{177, 1058306785u, 1083346780u, 1058306785u, 0, FMOD_TOLERANCE, 0},
{178, 1058474557u, 1083367752u, 1058474557u, 0, FMOD_TOLERANCE, 0},
{179, 1058642330u, 1083388723u, 1058642330u, 0, FMOD_TOLERANCE, 0},
{180, 1058810102u, 1083409695u, 1058810102u, 0, FMOD_TOLERANCE, 0},
{181, 1058977874u, 1083430666u, 1058977874u, 0, FMOD_TOLERANCE, 0},
{182, 1059145646u, 1083451638u, 1059145646u, 0, FMOD_TOLERANCE, 0},
{183, 1059313418u, 1083472609u, 1059313418u, 0, FMOD_TOLERANCE, 0},
{184, 1059481190u, 1083493581u, 1059481190u, 0, FMOD_TOLERANCE, 0},
{185, 1059648963u, 1083514552u, 1059648963u, 0, FMOD_TOLERANCE, 0},
{186, 1059816735u, 1083535524u, 1059816735u, 0, FMOD_TOLERANCE, 0},
{187, 1059984507u, 1083556495u, 1059984507u, 0, FMOD_TOLERANCE, 0},
{188, 1060152279u, 1083577467u, 1060152279u, 0, FMOD_TOLERANCE, 0},
{189, 1060320051u, 1083598438u, 1060320051u, 0, FMOD_TOLERANCE, 0},
{190, 1060487823u, 1083619410u, 1060487823u, 0, FMOD_TOLERANCE, 0},
{191, 1060655596u, 1083640381u, 1060655596u, 0, FMOD_TOLERANCE, 0},
{192, 1060823368u, 1083661353u, 1060823368u, 0, FMOD_TOLERANCE, 0},
{193, 1060991140u, 1083682324u, 1060991140u, 0, FMOD_TOLERANCE, 0},
{194, 1061158912u, 1083703296u, 1061158912u, 0, FMOD_TOLERANCE, 0},
{195, 1061326684u, 1083724268u, 1061326684u, 0, FMOD_TOLERANCE, 0},
{196, 1061494456u, 1083745239u, 1061494456u, 0, FMOD_TOLERANCE, 0},
{197, 1061662228u, 1083766211u, 1061662228u, 0, FMOD_TOLERANCE, 0},
{198, 1061830001u, 1083787182u, 1061830001u, 0, FMOD_TOLERANCE, 0},
{199, 1061997773u, 1083808154u, 1061997773u, 0, FMOD_TOLERANCE, 0},
{200, 1062165545u, 1083829125u, 1062165545u, 0, FMOD_TOLERANCE, 0},
{201, 1062333317u, 1083850097u, 1062333317u, 0, FMOD_TOLERANCE, 0},
{202, 1062501089u, 1083871068u, 1062501089u, 0, FMOD_TOLERANCE, 0},
{203, 1062668861u, 1083892040u, 1062668861u, 0, FMOD_TOLERANCE, 0},
{204, 1062836634u, 1083913011u, 1062836634u, 0, FMOD_TOLERANCE, 0},
{205, 1063004406u, 1083933983u, 1063004406u, 0, FMOD_TOLERANCE, 0},
{206, 1063172178u, 1083954954u, 1063172178u, 0, FMOD_TOLERANCE, 0},
{207, 1063339950u, 1083975926u, 1063339950u, 0, FMOD_TOLERANCE, 0},
{208, 1063507722u, 1083996897u, 1063507722u, 0, FMOD_TOLERANCE, 0},
{209, 1063675494u, 1084017869u, 1063675494u, 0, FMOD_TOLERANCE, 0},
{210, 1063843267u, 1084038840u, 1063843267u, 0, FMOD_TOLERANCE, 0},
{211, 1064011039u, 1084059812u, 1064011039u, 0, FMOD_TOLERANCE, 0},
{212, 1064178811u, 1084080783u, 1064178811u, 0, FMOD_TOLERANCE, 0},
{213, 1064346583u, 1084101755u, 1064346583u, 0, FMOD_TOLERANCE, 0},
{214, 1064514355u, 1084122726u, 1064514355u, 0, FMOD_TOLERANCE, 0},
{215, 1064682127u, 1084143698u, 1064682127u, 0, FMOD_TOLERANCE, 0},
{216, 1064849900u, 1084164669u, 1064849900u, 0, FMOD_TOLERANCE, 0},
{217, 1065017672u, 1084185641u, 1065017672u, 0, FMOD_TOLERANCE, 0},
{218, 1065185444u, 1084206612u, 1065185444u, 0, FMOD_TOLERANCE, 0},
{219, 1065353216u, 1084227584u, 1065353216u, 0, FMOD_TOLERANCE, 0},
{220, 1065437102u, 1084248556u, 1065437102u, 0, FMOD_TOLERANCE, 0},
{221, 1065520988u, 1084269527u, 1065520988u, 0, FMOD_TOLERANCE, 0},
{222, 1065604874u, 1084290499u, 1065604874u, 0, FMOD_TOLERANCE, 0},
{223, 1065688760u, 1084311470u, 1065688760u, 0, FMOD_TOLERANCE, 0},
{224, 1065772646u, 1084332442u, 1065772646u, 0, FMOD_TOLERANCE, 0},
{225, 1065856532u, 1084353413u, 1065856532u, 0, FMOD_TOLERANCE, 0},
{226, 1065940419u, 1084374385u, 1065940419u, 0, FMOD_TOLERANCE, 0},
{227, 1066024305u, 1084395356u, 1066024305u, 0, FMOD_TOLERANCE, 0},
{228, 1066108191u, 1084416328u, 1066108191u, 0, FMOD_TOLERANCE, 0},
{229, 1066192077u, 1084437299u, 1066192077u, 0, FMOD_TOLERANCE, 0},
{230, 1066275963u, 1084458271u, 1066275963u, 0, FMOD_TOLERANCE, 0},
{231, 1066359849u, 1084479242u, 1066359849u, 0, FMOD_TOLERANCE, 0},
{232, 1066443735u, 1084500214u, 1066443735u, 0, FMOD_TOLERANCE, 0},
{233, 1066527621u, 1084521185u, 1066527621u, 0, FMOD_TOLERANCE, 0},
{234, 1066611507u, 1084542157u, 1066611507u, 0, FMOD_TOLERANCE, 0},
{235, 1066695393u, 1084563128u, 1066695393u, 0, FMOD_TOLERANCE, 0},
{236, 1066779279u, 1084584100u, 1066779279u, 0, FMOD_TOLERANCE, 0},
{237, 1066863165u, 1084605071u, 1066863165u, 0, FMOD_TOLERANCE, 0},
{238, 1066947052u, 1084626043u, 1066947052u, 0, FMOD_TOLERANCE, 0},
{239, 3234402267u, 3222413237u, 3218849944u, 0, FMOD_TOLERANCE, 0},
{240, 3231108068u, 3208011552u, 3202369728u, 0, FMOD_TOLERANCE, 0},
{241, 3226013659u, 1062977685u, 3205561773u, 0, FMOD_TOLERANCE, 0},
{242, 3217625051u, 1075542035u, 3217625051u, 0, FMOD_TOLERANCE, 0},
{243, 1070141403u, 1085424631u, 1070141403u, 0, FMOD_TOLERANCE, 0},
{244, 1078530011u, 1088718829u, 1078530011u, 0, FMOD_TOLERANCE, 0},
{245, 1083624420u, 1091266034u, 1083624420u, 0, FMOD_TOLERANCE, 0},
{246, 3253731328u, 3251634176u, 3229614080u, 0, FMOD_TOLERANCE, 0},
{247, 3252840038u, 3250742886u, 3229614080u, 0, FMOD_TOLERANCE, 0},
{248, 3251948749u, 3249851597u, 3229614080u, 0, FMOD_TOLERANCE, 0},
{249, 3251057459u, 3248960307u, 3229614080u, 0, FMOD_TOLERANCE, 0},
{250, 3250166170u, 3248069018u, 3229614080u, 0, FMOD_TOLERANCE, 0},
{251, 3249274880u, 3247177728u, 3229614080u, 0, FMOD_TOLERANCE, 0},
{252, 3248383590u, 3246181581u, 3229614076u, 0, FMOD_TOLERANCE, 0},
{253, 3247492301u, 3244399002u, 3229614080u, 0, FMOD_TOLERANCE, 0},
{254, 3246601011u, 3242616422u, 3229614080u, 0, FMOD_TOLERANCE, 0},
{255, 3245028147u, 3240833843u, 3229614080u, 0, FMOD_TOLERANCE, 0},
{256, 3243245568u, 3239051264u, 3229614080u, 0, FMOD_TOLERANCE, 0},
{257, 3241462989u, 3236534682u, 3229614080u, 0, FMOD_TOLERANCE, 0},
{258, 3239680410u, 3232969523u, 3229614081u, 0, FMOD_TOLERANCE, 0},
{259, 3237792973u, 3229194650u, 3184315584u, 0, FMOD_TOLERANCE, 0},
{260, 3234227814u, 3222064333u, 3219547748u, 0, FMOD_TOLERANCE, 0},
{261, 3224580915u, 1067030938u, 3201092808u, 0, FMOD_TOLERANCE, 0},
{262, 3213675725u, 1077516698u, 3213675725u, 0, FMOD_TOLERANCE, 0},
{263, 1058642330u, 1083388723u, 1058642330u, 0, FMOD_TOLERANCE, 0},
{264, 1075000115u, 1086953882u, 1075000115u, 0, FMOD_TOLERANCE, 0},
{265, 1082130432u, 1090519040u, 1082130432u, 0, FMOD_TOLERANCE, 0},
{266, 1085695590u, 1092301619u, 1085695590u, 0, FMOD_TOLERANCE, 0},
{267, 1089260749u, 1094084198u, 1089260749u, 0, FMOD_TOLERANCE, 0},
{268, 1091672474u, 1095866778u, 1091672474u, 0, FMOD_TOLERANCE, 0},
{269, 1093455053u, 1097649357u, 1093455053u, 0, FMOD_TOLERANCE, 0},
{270, 1095237632u, 1099169792u, 1095237632u, 0, FMOD_TOLERANCE, 0},
{271, 1097020211u, 1100061082u, 1097020211u, 0, FMOD_TOLERANCE, 0},
{272, 1098802790u, 1100952371u, 1098802790u, 0, FMOD_TOLERANCE, 0},
{273, 1099746509u, 1101843661u, 1099746509u, 0, FMOD_TOLERANCE, 0},
{274, 1100637798u, 1102734950u, 1100637798u, 0, FMOD_TOLERANCE, 0},
{275, 1101529088u, 1103626240u, 1101529088u, 0, FMOD_TOLERANCE, 0},
{276, 1102420378u, 1104517530u, 1102420378u, 0, FMOD_TOLERANCE, 0},
{277, 1103311667u, 1105408819u, 1103311667u, 0, FMOD_TOLERANCE, 0},
{278, 1104202957u, 1106300109u, 1104202957u, 0, FMOD_TOLERANCE, 0},
{279, 1105094246u, 1107191398u, 1105094246u, 0, FMOD_TOLERANCE, 0},
{280, 1105985536u, 1107689472u, 1105985536u, 0, FMOD_TOLERANCE, 0},
{281, 1107800421u, 1203999711u, 1107800421u, 0, FMOD_TOLERANCE, 0},
{282, 3221027117u, 1284201705u, 3221027117u, 0, FMOD_TOLERANCE, 0},
{283, 966554515u, 3234538174u, 966554515u, 0, FMOD_TOLERANCE, 0},
{284, 3111900019u, 1130472166u, 3111900019u, 0, FMOD_TOLERANCE, 0},
{285, 3181522772u, 3305392896u, 3181522772u, 0, FMOD_TOLERANCE, 0},
{286, 3122346862u, 1111584337u, 3122346862u, 0, FMOD_TOLERANCE, 0},
{287, 1052361612u, 1280025214u, 1052361612u, 0, FMOD_TOLERANCE, 0},
{288, 3319724992u, 3354615790u, 3319724992u, 0, FMOD_TOLERANCE, 0},
{289, 1001673627u, 3462631271u, 1001673627u, 0, FMOD_TOLERANCE, 0},
{290, 976098044u, 1151967422u, 976098044u, 0, FMOD_TOLERANCE, 0},
{291, 1139941253u, 1147688821u, 1139941253u, 0, FMOD_TOLERANCE, 0},
{292, 3143717025u, 3234638157u, 3143717025u, 0, FMOD_TOLERANCE, 0},
{293, 1333134799u, 1338107877u, 1333134799u, 0, FMOD_TOLERANCE, 0},
{294, 1187847971u, 1317663644u, 1187847971u, 0, FMOD_TOLERANCE, 0},
{295, 1038851706u, 1327544110u, 1038851706u, 0, FMOD_TOLERANCE, 0},
{296, 1106778573u, 3304487767u, 1106778573u, 0, FMOD_TOLERANCE, 0},
{297, 3154871957u, 1276671061u, 3154871957u, 0, FMOD_TOLERANCE, 0},
{298, 1082692850u, 1211581107u, 1082692850u, 0, FMOD_TOLERANCE, 0},
{299, 974547519u, 3475164509u, 974547519u, 0, FMOD_TOLERANCE, 0},
{300, 3182301130u, 3460764044u, 3182301130u, 0, FMOD_TOLERANCE, 0},
{301, 3239231622u, 3302723069u, 3239231622u, 0, FMOD_TOLERANCE, 0},
{302, 3417964312u, 1321337529u, 3417964312u, 0, FMOD_TOLERANCE, 0},
{303, 3109481038u, 1143864063u, 3109481038u, 0, FMOD_TOLERANCE, 0},
{304, 1148867223u, 1256486202u, 1148867223u, 0, FMOD_TOLERANCE, 0},
{305, 989687421u, 3372681320u, 989687421u, 0, FMOD_TOLERANCE, 0},
{306, 1109627625u, 1314158257u, 1109627625u, 0, FMOD_TOLERANCE, 0},
{307, 1077234132u, 3272167130u, 1077234132u, 0, FMOD_TOLERANCE, 0},
{308, 1009535440u, 3381353228u, 1009535440u, 0, FMOD_TOLERANCE, 0},
{309, 3126820946u, 1077903063u, 3126820946u, 0, FMOD_TOLERANCE, 0},
{310, 3152729489u, 1060398533u, 3152729489u, 0, FMOD_TOLERANCE, 0},
{311, 976791751u, 3230678102u, 976791751u, 0, FMOD_TOLERANCE, 0},
{312, 3212952285u, 3329407365u, 3212952285u, 0, FMOD_TOLERANCE, 0},
{313, 3319315516u, 3422089012u, 3319315516u, 0, FMOD_TOLERANCE, 0},
{314, 3212614372u, 1152633030u, 3212614372u, 0, FMOD_TOLERANCE, 0},
{315, 1134593658u, 3456812581u, 1134593658u, 0, FMOD_TOLERANCE, 0},
{316, 1135271264u, 3284878412u, 1135271264u, 0, FMOD_TOLERANCE, 0},
{317, 3316278408u, 3455589207u, 3316278408u, 0, FMOD_TOLERANCE, 0},
{318, 1030934236u, 1045139240u, 1030934236u, 0, FMOD_TOLERANCE, 0},
{319, 3131791114u, 3408392958u, 3131791114u, 0, FMOD_TOLERANCE, 0},
{320, 3180213739u, 1108793820u, 3180213739u, 0, FMOD_TOLERANCE, 0},
{321, 1268194719u, 1332489410u, 1268194719u, 0, FMOD_TOLERANCE, 0},
{322, 1133420220u, 1245770860u, 1133420220u, 0, FMOD_TOLERANCE, 0},
{323, 3184462258u, 1263529646u, 3184462258u, 0, FMOD_TOLERANCE, 0},
{324, 3295996963u, 3453334307u, 3295996963u, 0, FMOD_TOLERANCE, 0},
{325, 3116607482u, 3224327456u, 3116607482u, 0, FMOD_TOLERANCE, 0},
{326, 3224857113u, 3398166843u, 3224857113u, 0, FMOD_TOLERANCE, 0},
{327, 3424831780u, 1304806106u, 3424831780u, 0, FMOD_TOLERANCE, 0},
{328, 1257596246u, 3420832544u, 1257596246u, 0, FMOD_TOLERANCE, 0},
{329, 1090870906u, 3294742905u, 1090870906u, 0, FMOD_TOLERANCE, 0},
{330, 1137854355u, 3335041917u, 1137854355u, 0, FMOD_TOLERANCE, 0},
{331, 1131196082u, 1164573183u, 1131196082u, 0, FMOD_TOLERANCE, 0},
{332, 3177294154u, 1282436638u, 3177294154u, 0, FMOD_TOLERANCE, 0},
{333, 3258097678u, 1305882290u, 3258097678u, 0, FMOD_TOLERANCE, 0},
{334, 1053698677u, 3284313107u, 1053698677u, 0, FMOD_TOLERANCE, 0},
{335, 1065761827u, 3333928591u, 1065761827u, 0, FMOD_TOLERANCE, 0},
{336, 1080781593u, 1213908300u, 1080781593u, 0, FMOD_TOLERANCE, 0},
{337, 3235326590u, 1271705594u, 3235326590u, 0, FMOD_TOLERANCE, 0},
{338, 3118883815u, 1051802647u, 3118883815u, 0, FMOD_TOLERANCE, 0},
{339, 965378004u, 1292594138u, 965378004u, 0, FMOD_TOLERANCE, 0},
{340, 3226990408u, 1110755136u, 3226990408u, 0, FMOD_TOLERANCE, 0},
{341, 3117098218u, 1122474770u, 3117098218u, 0, FMOD_TOLERANCE, 0},
{342, 970649315u, 1078286437u, 970649315u, 0, FMOD_TOLERANCE, 0},
{343, 1106502045u, 1290849316u, 1106502045u, 0, FMOD_TOLERANCE, 0},
{344, 1157598381u, 3309023746u, 1157598381u, 0, FMOD_TOLERANCE, 0},
{345, 3157416480u, 1309984610u, 3157416480u, 0, FMOD_TOLERANCE, 0},
{346, 1109198803u, 1221754614u, 1109198803u, 0, FMOD_TOLERANCE, 0},
{347, 3361149474u, 3387342069u, 3361149474u, 0, FMOD_TOLERANCE, 0},
{348, 1207502108u, 3388073586u, 1207502108u, 0, FMOD_TOLERANCE, 0},
{349, 3160728744u, 3382954009u, 3160728744u, 0, FMOD_TOLERANCE, 0},
{350, 1017843965u, 1193076204u, 1017843965u, 0, FMOD_TOLERANCE, 0},
{351, 970094304u, 3344590506u, 970094304u, 0, FMOD_TOLERANCE, 0},
{352, 1125551064u, 3331248076u, 1125551064u, 0, FMOD_TOLERANCE, 0},
{353, 3427296372u, 3455289118u, 3427296372u, 0, FMOD_TOLERANCE, 0},
{354, 1198917460u, 1327195159u, 1198917460u, 0, FMOD_TOLERANCE, 0},
{355, 3114686212u, 3476082461u, 3114686212u, 0, FMOD_TOLERANCE, 0},
{356, 3224245428u, 3271307999u, 3224245428u, 0, FMOD_TOLERANCE, 0},
{357, 1120124467u, 1135619937u, 1120124467u, 0, FMOD_TOLERANCE, 0},
{358, 1165195428u, 3390323168u, 1165195428u, 0, FMOD_TOLERANCE, 0},
{359, 3149469534u, 1278465842u, 3149469534u, 0, FMOD_TOLERANCE, 0},
{360, 3215244648u, 1083988595u, 3215244648u, 0, FMOD_TOLERANCE, 0},
{361, 3275973009u, 3450721670u, 3275973009u, 0, FMOD_TOLERANCE, 0},
{362, 3391162308u, 1291220039u, 3391162308u, 0, FMOD_TOLERANCE, 0},
{363, 1044867873u, 3369493273u, 1044867873u, 0, FMOD_TOLERANCE, 0},
{364, 1089986803u, 3462160118u, 1089986803u, 0, FMOD_TOLERANCE, 0},
{365, 3262169538u, 1268270462u, 3262169538u, 0, FMOD_TOLERANCE, 0},
{366, 989762529u, 3362011135u, 989762529u, 0, FMOD_TOLERANCE, 0},
{367, 1002632518u, 3330388441u, 1002632518u, 0, FMOD_TOLERANCE, 0},
{368, 3404372005u, 3450484255u, 3404372005u, 0, FMOD_TOLERANCE, 0},
{369, 999985470u, 3409354318u, 999985470u, 0, FMOD_TOLERANCE, 0},
{370, 3132541814u, 3444521949u, 3132541814u, 0, FMOD_TOLERANCE, 0},
{371, 1164046161u, 3440635788u, 1164046161u, 0, FMOD_TOLERANCE, 0},
{372, 1181604787u, 3363067409u, 1181604787u, 0, FMOD_TOLERANCE, 0},
{373, 1043691622u, 3402603223u, 1043691622u, 0, FMOD_TOLERANCE, 0},
{374, 3157534378u, 3451674717u, 3157534378u, 0, FMOD_TOLERANCE, 0},
{375, 969804941u, 3355439348u, 969804941u, 0, FMOD_TOLERANCE, 0},
{376, 3162548604u, 3461790298u, 3162548604u, 0, FMOD_TOLERANCE, 0},
{377, 3185240099u, 1123403720u, 3185240099u, 0, FMOD_TOLERANCE, 0},
{378, 3424264117u, 3434026174u, 3424264117u, 0, FMOD_TOLERANCE, 0},
{379, 3228365887u, 1216775310u, 3228365887u, 0, FMOD_TOLERANCE, 0},
{380, 1035909900u, 1249532942u, 1035909900u, 0, FMOD_TOLERANCE, 0},
{381, 1131358407u, 3325958870u, 1131358407u, 0, FMOD_TOLERANCE, 0},
{382, 1156517523u, 3343716230u, 1156517523u, 0, FMOD_TOLERANCE, 0},
{383, 3337499209u, 1226297264u, 3337499209u, 0, FMOD_TOLERANCE, 0},
{384, 3253515800u, 1189005947u, 3253515800u, 0, FMOD_TOLERANCE, 0},
{385, 1039917375u, 1122740999u, 1039917375u, 0, FMOD_TOLERANCE, 0},
{386, 3220979495u, 3429223871u, 3220979495u, 0, FMOD_TOLERANCE, 0},
{387, 1128016396u, 1105151547u, 1101376254u, 0, FMOD_TOLERANCE, 0},
{388, 3144504834u, 1162227076u, 3144504834u, 0, FMOD_TOLERANCE, 0},
{389, 995850843u, 1332031130u, 995850843u, 0, FMOD_TOLERANCE, 0},
{390, 3362082828u, 3374056268u, 3362082828u, 0, FMOD_TOLERANCE, 0},
{391, 3235395924u, 1132055244u, 3235395924u, 0, FMOD_TOLERANCE, 0},
{392, 3161654634u, 3335899347u, 3161654634u, 0, FMOD_TOLERANCE, 0},
{393, 3162655243u, 3307203982u, 3162655243u, 0, FMOD_TOLERANCE, 0},
{394, 1165476654u, 3350219111u, 1165476654u, 0, FMOD_TOLERANCE, 0},
{395, 1017239798u, 3438501281u, 1017239798u, 0, FMOD_TOLERANCE, 0},
{396, 1189849849u, 3382739134u, 1189849849u, 0, FMOD_TOLERANCE, 0},
{397, 1168098747u, 1316854744u, 1168098747u, 0, FMOD_TOLERANCE, 0},
{398, 3301009024u, 3406174560u, 3301009024u, 0, FMOD_TOLERANCE, 0},
{399, 3233089227u, 1212652543u, 3233089227u, 0, FMOD_TOLERANCE, 0},
{400, 3218245284u, 1238873830u, 3218245284u, 0, FMOD_TOLERANCE, 0},
{401, 3215981890u, 3240474694u, 3215981890u, 0, FMOD_TOLERANCE, 0},
{402, 1141063391u, 1168908072u, 1141063391u, 0, FMOD_TOLERANCE, 0},
{403, 1001823878u, 1016826861u, 1001823878u, 0, FMOD_TOLERANCE, 0},
{404, 1009130212u, 1004302940u, 996116184u, 0, FMOD_TOLERANCE, 0},
{405, 1032920919u, 3449126417u, 1032920919u, 0, FMOD_TOLERANCE, 0},
{406, 1153753924u, 3322269242u, 1153753924u, 0, FMOD_TOLERANCE, 0},
{407, 3226328360u, 3366432856u, 3226328360u, 0, FMOD_TOLERANCE, 0},
{408, 3166889490u, 3306023523u, 3166889490u, 0, FMOD_TOLERANCE, 0},
{409, 1087750238u, 1099325523u, 1087750238u, 0, FMOD_TOLERANCE, 0},
{410, 3121620061u, 3359488363u, 3121620061u, 0, FMOD_TOLERANCE, 0},
{411, 1030612298u, 3345396001u, 1030612298u, 0, FMOD_TOLERANCE, 0},
{412, 1045232522u, 3234993273u, 1045232522u, 0, FMOD_TOLERANCE, 0},
{413, 3228795133u, 3273940030u, 3228795133u, 0, FMOD_TOLERANCE, 0},
{414, 3388153589u, 3426245389u, 3388153589u, 0, FMOD_TOLERANCE, 0},
{415, 1133410485u, 3329658993u, 1133410485u, 0, FMOD_TOLERANCE, 0},
{416, 3136790322u, 1088652637u, 3136790322u, 0, FMOD_TOLERANCE, 0},
{417, 1001897182u, 3191875320u, 1001897182u, 0, FMOD_TOLERANCE, 0},
{418, 3152777939u, 3245830463u, 3152777939u, 0, FMOD_TOLERANCE, 0},
{419, 985903305u, 3333087577u, 985903305u, 0, FMOD_TOLERANCE, 0},
{420, 3267868136u, 1208301947u, 3267868136u, 0, FMOD_TOLERANCE, 0},
{421, 3319048157u, 1172271145u, 3319048157u, 0, FMOD_TOLERANCE, 0},
{422, 3301461672u, 1233693827u, 3301461672u, 0, FMOD_TOLERANCE, 0},
{423, 3130670309u, 3192399254u, 3130670309u, 0, FMOD_TOLERANCE, 0},
{424, 1258369714u, 3462258576u, 1258369714u, 0, FMOD_TOLERANCE, 0},
{425, 1216602683u, 3371396332u, 1216602683u, 0, FMOD_TOLERANCE, 0},
{426, 3297265739u, 1214184410u, 3297265739u, 0, FMOD_TOLERANCE, 0},
{427, 1071940738u, 3311731012u, 1071940738u, 0, FMOD_TOLERANCE, 0},
{428, 3131219358u, 3471261157u, 3131219358u, 0, FMOD_TOLERANCE, 0},
{429, 3222096285u, 1198013705u, 3222096285u, 0, FMOD_TOLERANCE, 0},
{430, 3345532722u, 3383708463u, 3345532722u, 0, FMOD_TOLERANCE, 0},
{431, 3418753236u, 3481843070u, 3418753236u, 0, FMOD_TOLERANCE, 0},
{432, 1277417964u, 3487506626u, 1277417964u, 0, FMOD_TOLERANCE, 0},
{433, 987577257u, 1152077087u, 987577257u, 0, FMOD_TOLERANCE, 0},
{434, 3161606610u, 3190282989u, 3161606610u, 0, FMOD_TOLERANCE, 0},
{435, 1043442869u, 3311393817u, 1043442869u, 0, FMOD_TOLERANCE, 0},
{436, 3320923228u, 3464544249u, 3320923228u, 0, FMOD_TOLERANCE, 0},
{437, 1337400405u, 3488844154u, 1337400405u, 0, FMOD_TOLERANCE, 0},
{438, 3284411233u, 1173613526u, 3284411233u, 0, FMOD_TOLERANCE, 0},
{439, 1215968622u, 3469884568u, 1215968622u, 0, FMOD_TOLERANCE, 0},
{440, 1025404104u, 1066370251u, 1025404104u, 0, FMOD_TOLERANCE, 0},
{441, 3138086437u, 3195983510u, 3138086437u, 0, FMOD_TOLERANCE, 0},
{442, 3362748242u, 3369843597u, 3362748242u, 0, FMOD_TOLERANCE, 0},
{443, 3327895594u, 1224511805u, 3327895594u, 0, FMOD_TOLERANCE, 0},
{444, 1157186482u, 1288722647u, 1157186482u, 0, FMOD_TOLERANCE, 0},
{445, 3477008113u, 1331845018u, 3477008113u, 0, FMOD_TOLERANCE, 0},
{446, 3292127294u, 3409957764u, 3292127294u, 0, FMOD_TOLERANCE, 0},
{447, 1123357102u, 3281307320u, 1123357102u, 0, FMOD_TOLERANCE, 0},
{448, 1049949008u, 1130799489u, 1049949008u, 0, FMOD_TOLERANCE, 0},
{449, 1108543194u, 3281299199u, 1108543194u, 0, FMOD_TOLERANCE, 0},
{450, 3163283126u, 1328636961u, 3163283126u, 0, FMOD_TOLERANCE, 0},
{451, 1160162706u, 1264067367u, 1160162706u, 0, FMOD_TOLERANCE, 0},
{452, 972485427u, 1124312043u, 972485427u, 0, FMOD_TOLERANCE, 0},
{453, 3222106584u, 1183748648u, 3222106584u, 0, FMOD_TOLERANCE, 0},
{454, 3167730654u, 3195765940u, 3167730654u, 0, FMOD_TOLERANCE, 0},
{455, 1098530298u, 3255870890u, 1098530298u, 0, FMOD_TOLERANCE, 0},
{456, 3203377685u, 1306427476u, 3203377685u, 0, FMOD_TOLERANCE, 0},
{457, 1096155623u, 1256423752u, 1096155623u, 0, FMOD_TOLERANCE, 0},
{458, 3238729605u, 1298769842u, 3238729605u, 0, FMOD_TOLERANCE, 0},
{459, 3154720153u, 3443720494u, 3154720153u, 0, FMOD_TOLERANCE, 0},
{460, 3136364836u, 1018492227u, 3136364836u, 0, FMOD_TOLERANCE, 0},
{461, 1011225926u, 1180485180u, 1011225926u, 0, FMOD_TOLERANCE, 0},
{462, 3137758475u, 1039403054u, 3137758475u, 0, FMOD_TOLERANCE, 0},
{463, 1040617590u, 1034835971u, 1027445202u, 0, FMOD_TOLERANCE, 0},
{464, 1039827284u, 1072928888u, 1039827284u, 0, FMOD_TOLERANCE, 0},
{465, 1021564080u, 1064468397u, 1021564080u, 0, FMOD_TOLERANCE, 0},
{466, 3327516316u, 3405380971u, 3327516316u, 0, FMOD_TOLERANCE, 0},
{467, 1040711112u, 3229444200u, 1040711112u, 0, FMOD_TOLERANCE, 0},
{468, 1134528351u, 3365952513u, 1134528351u, 0, FMOD_TOLERANCE, 0},
{469, 1066157309u, 3241712664u, 1066157309u, 0, FMOD_TOLERANCE, 0},
{470, 3272661536u, 3461799138u, 3272661536u, 0, FMOD_TOLERANCE, 0},
{471, 1170245333u, 1233406410u, 1170245333u, 0, FMOD_TOLERANCE, 0},
{472, 1219052056u, 3369557946u, 1219052056u, 0, FMOD_TOLERANCE, 0},
{473, 3190796331u, 1320011850u, 3190796331u, 0, FMOD_TOLERANCE, 0},
{474, 3257224022u, 3361778245u, 3257224022u, 0, FMOD_TOLERANCE, 0},
{475, 1086717248u, 3423795374u, 1086717248u, 0, FMOD_TOLERANCE, 0},
{476, 1200927971u, 1317167489u, 1200927971u, 0, FMOD_TOLERANCE, 0},
{477, 3326858092u, 3452602832u, 3326858092u, 0, FMOD_TOLERANCE, 0},
{478, 3184801644u, 1137974313u, 3184801644u, 0, FMOD_TOLERANCE, 0},
{479, 1015670780u, 1101217251u, 1015670780u, 0, FMOD_TOLERANCE, 0},
{480, 1012543234u, 1116520440u, 1012543234u, 0, FMOD_TOLERANCE, 0},
{481, 3316611992u, 3394732912u, 3316611992u, 0, FMOD_TOLERANCE, 0},
{482, 1087942795u, 3316660295u, 1087942795u, 0, FMOD_TOLERANCE, 0},
{483, 3295326432u, 1313396175u, 3295326432u, 0, FMOD_TOLERANCE, 0},
{484, 1173247961u, 1191127979u, 1173247961u, 0, FMOD_TOLERANCE, 0},
{485, 3248534678u, 1323683800u, 3248534678u, 0, FMOD_TOLERANCE, 0},
{486, 3157626955u, 3483653298u, 3157626955u, 0, FMOD_TOLERANCE, 0},
{487, 3182695954u, 3256861672u, 3182695954u, 0, FMOD_TOLERANCE, 0},
{488, 1105291533u, 3482971524u, 1105291533u, 0, FMOD_TOLERANCE, 0},
{489, 1016023520u, 3227712090u, 1016023520u, 0, FMOD_TOLERANCE, 0},
{490, 3370691006u, 1295870514u, 3370691006u, 0, FMOD_TOLERANCE, 0},
{491, 3335212901u, 3486414589u, 3335212901u, 0, FMOD_TOLERANCE, 0},
{492, 3266691185u, 1160074593u, 3266691185u, 0, FMOD_TOLERANCE, 0},
{493, 3179003144u, 1108615803u, 3179003144u, 0, FMOD_TOLERANCE, 0},
{494, 973664327u, 1319516167u, 973664327u, 0, FMOD_TOLERANCE, 0},
{495, 979878744u, 1232482646u, 979878744u, 0, FMOD_TOLERANCE, 0},
{496, 1002542205u, 3152136093u, 1002542205u, 0, FMOD_TOLERANCE, 0},
{497, 989655126u, 1308376568u, 989655126u, 0, FMOD_TOLERANCE, 0},
{498, 1002715618u, 1191006977u, 1002715618u, 0, FMOD_TOLERANCE, 0},
{499, 1000863905u, 1196831314u, 1000863905u, 0, FMOD_TOLERANCE, 0},
{500, 3283471961u, 1260093226u, 3283471961u, 0, FMOD_TOLERANCE, 0},
{501, 3311210827u, 1192192264u, 3311210827u, 0, FMOD_TOLERANCE, 0},
{502, 1288901567u, 1296370667u, 1288901567u, 0, FMOD_TOLERANCE, 0},
{503, 1062512367u, 3229559531u, 1062512367u, 0, FMOD_TOLERANCE, 0},
{504, 1034561811u, 1054043114u, 1034561811u, 0, FMOD_TOLERANCE, 0},
{505, 1042014529u, 1146708584u, 1042014529u, 0, FMOD_TOLERANCE, 0},
{506, 3196144817u, 1056118717u, 3196144817u, 0, FMOD_TOLERANCE, 0},
{507, 3375507013u, 1306310823u, 3375507013u, 0, FMOD_TOLERANCE, 0},
{508, 1055319316u, 3261813492u, 1055319316u, 0, FMOD_TOLERANCE, 0},
{509, 1123114742u, 1229815537u, 1123114742u, 0, FMOD_TOLERANCE, 0},
{510, 1258114435u, 1291336083u, 1258114435u, 0, FMOD_TOLERANCE, 0},
{511, 3223384012u, 1130486973u, 3223384012u, 0, FMOD_TOLERANCE, 0},
{512, 1019964626u, 1235133609u, 1019964626u, 0, FMOD_TOLERANCE, 0},
{513, 3445262427u, 3465211174u, 3445262427u, 0, FMOD_TOLERANCE, 0},
{514, 1125653081u, 1207799746u, 1125653081u, 0, FMOD_TOLERANCE, 0},
{515, 996404791u, 3353251979u, 996404791u, 0, FMOD_TOLERANCE, 0},
{516, 996786317u, 3179221951u, 996786317u, 0, FMOD_TOLERANCE, 0},
{517, 1188167943u, 1200744896u, 1188167943u, 0, FMOD_TOLERANCE, 0},
{518, 1102061604u, 3424449935u, 1102061604u, 0, FMOD_TOLERANCE, 0},
{519, 3116209179u, 3303588342u, 3116209179u, 0, FMOD_TOLERANCE, 0},
{520, 3207056527u, 3384206601u, 3207056527u, 0, FMOD_TOLERANCE, 0},
{521, 1284174954u, 3436881197u, 1284174954u, 0, FMOD_TOLERANCE, 0},
{522, 3156081645u, 3308839704u, 3156081645u, 0, FMOD_TOLERANCE, 0},
{523, 1102631663u, 3396951425u, 1102631663u, 0, FMOD_TOLERANCE, 0},
{524, 968803479u, 992989712u, 968803479u, 0, FMOD_TOLERANCE, 0},
{525, 1003649752u, 1218792138u, 1003649752u, 0, FMOD_TOLERANCE, 0},
{526, 1078478376u, 1326246424u, 1078478376u, 0, FMOD_TOLERANCE, 0},
{527, 3158855023u, 3151283866u, 3149648964u, 0, FMOD_TOLERANCE, 0},
{528, 1165177679u, 3276237026u, 1120720980u, 0, FMOD_TOLERANCE, 0},
{529, 1208345407u, 1254181270u, 1208345407u, 0, FMOD_TOLERANCE, 0},
{530, 1248478509u, 1287895126u, 1248478509u, 0, FMOD_TOLERANCE, 0},
{531, 1153863988u, 3430539165u, 1153863988u, 0, FMOD_TOLERANCE, 0},
{532, 1064922416u, 1320485628u, 1064922416u, 0, FMOD_TOLERANCE, 0},
{533, 3230403187u, 1322841992u, 3230403187u, 0, FMOD_TOLERANCE, 0},
{534, 1072458508u, 3372833993u, 1072458508u, 0, FMOD_TOLERANCE, 0},
{535, 3319723279u, 3414482416u, 3319723279u, 0, FMOD_TOLERANCE, 0},
{536, 3237813668u, 3441016803u, 3237813668u, 0, FMOD_TOLERANCE, 0},
{537, 975349337u, 1311932596u, 975349337u, 0, FMOD_TOLERANCE, 0},
{538, 981908840u, 3314038398u, 981908840u, 0, FMOD_TOLERANCE, 0},
{539, 1315857601u, 3487600045u, 1315857601u, 0, FMOD_TOLERANCE, 0},
{540, 1029557624u, 3302959071u, 1029557624u, 0, FMOD_TOLERANCE, 0},
{541, 1028355074u, 3442294040u, 1028355074u, 0, FMOD_TOLERANCE, 0},
{542, 3119299090u, 1187096397u, 3119299090u, 0, FMOD_TOLERANCE, 0},
{543, 3192315328u, 3289489214u, 3192315328u, 0, FMOD_TOLERANCE, 0},
{544, 3392827417u, 1277961150u, 3392827417u, 0, FMOD_TOLERANCE, 0},
{545, 1161241793u, 1328003707u, 1161241793u, 0, FMOD_TOLERANCE, 0},
{546, 1171318485u, 3374409104u, 1171318485u, 0, FMOD_TOLERANCE, 0},
{547, 1127109339u, 3368125489u, 1127109339u, 0, FMOD_TOLERANCE, 0},
{548, 1155775526u, 1255814444u, 1155775526u, 0, FMOD_TOLERANCE, 0},
{549, 1234491880u, 3408568717u, 1234491880u, 0, FMOD_TOLERANCE, 0}

// AUTOMATICALLY GENERATED VECTORS STOP

};

#endif // CYGONCE_LIBM_FMOD_H multiple inclusion protection

// EOF fmod.h
