#ifndef CYGONCE_LIBM_EXPM1F_H
#define CYGONCE_LIBM_EXPM1F_H
//===========================================================================
//
//      expm1f.h
//
//      Test vectors for testing of expm1f() math library function
//
//===========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 2012 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later
// version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License
// along with eCos; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
// As a special exception, if other files instantiate templates or use
// macros or inline functions from this file, or you compile this file
// and link it with other works to produce a work based on this file,
// this file does not by itself cause the resulting work to be covered by
// the GNU General Public License. However the source code for this file
// must still be made available in accordance with section (3) of the GNU
// General Public License v2.
//
// This exception does not invalidate any other reasons why a work based
// on this file might be covered by the GNU General Public License.
// -------------------------------------------
// ####ECOSGPLCOPYRIGHTEND####
//===========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):
// Contributors:  visar, ilijak
// Date:        1998-02-13
// Purpose:
// Description:
// Usage:       #include "vectors/expm1f.h"
//
//####DESCRIPTIONEND####
//
//===========================================================================


// CONFIGURATION

#include <pkgconf/libm.h>   // Configuration header


// INCLUDES

#include <cyg/infra/cyg_type.h>    // Common type definitions and support
#include "vectors/vector_support_float.h"// extra support for math tests

#define EXPM1F_TOLERANCE 1.0E-04

static const Cyg_libm_test_float_vec_t expm1f_vec[] = {

// AUTOMATICALLY GENERATED VECTORS START

{0, 3212836864u, 3079358544u, 3206664871u, 0, EXPM1F_TOLERANCE, 0},
{1, 3212836864u, 3079358544u, 3206664871u, 0, EXPM1F_TOLERANCE, 0},
{2, 3212836864u, 3079358544u, 3206664871u, 0, EXPM1F_TOLERANCE, 0},
{3, 3212836864u, 3079358544u, 3206664871u, 0, EXPM1F_TOLERANCE, 0},
{4, 3212836864u, 3079358544u, 3206664871u, 0, EXPM1F_TOLERANCE, 0},
{5, 3212836864u, 3079358544u, 3206664871u, 0, EXPM1F_TOLERANCE, 0},
{6, 3212836864u, 3079358544u, 3206664871u, 0, EXPM1F_TOLERANCE, 0},
{7, 3212836864u, 3079358544u, 3206664871u, 0, EXPM1F_TOLERANCE, 0},
{8, 3212836864u, 3079358544u, 3206664871u, 0, EXPM1F_TOLERANCE, 0},
{9, 3212836864u, 3079358544u, 3206664871u, 0, EXPM1F_TOLERANCE, 0},
{10, 3212836864u, 3079358544u, 3206664871u, 0, EXPM1F_TOLERANCE, 0},
{11, 3212836864u, 3079358544u, 3206664871u, 0, EXPM1F_TOLERANCE, 0},
{12, 3212836864u, 3079358544u, 3206664871u, 0, EXPM1F_TOLERANCE, 0},
{13, 3212836864u, 3079358544u, 3206664871u, 0, EXPM1F_TOLERANCE, 0},
{14, 3212836864u, 3079358544u, 3206664871u, 0, EXPM1F_TOLERANCE, 0},
{15, 3212836864u, 3079358544u, 3206664871u, 0, EXPM1F_TOLERANCE, 0},
{16, 3212836864u, 3079358544u, 3206664871u, 0, EXPM1F_TOLERANCE, 0},
{17, 3212836864u, 3079358544u, 3206664871u, 0, EXPM1F_TOLERANCE, 0},
{18, 3212836864u, 3079358544u, 3206664871u, 0, EXPM1F_TOLERANCE, 0},
{19, 3212836864u, 3079358544u, 3206664871u, 0, EXPM1F_TOLERANCE, 0},
{20, 3212836864u, 3079358544u, 3206664871u, 0, EXPM1F_TOLERANCE, 0},
{21, 3212836864u, 3079358544u, 3206664871u, 0, EXPM1F_TOLERANCE, 0},
{22, 3212836864u, 3079358544u, 3206664871u, 0, EXPM1F_TOLERANCE, 0},
{23, 3212836864u, 3079358544u, 3206664871u, 0, EXPM1F_TOLERANCE, 0},
{24, 3212836864u, 3079358544u, 3206664871u, 0, EXPM1F_TOLERANCE, 0},
{25, 3212836864u, 3079358544u, 3206664871u, 0, EXPM1F_TOLERANCE, 0},
{26, 3212836864u, 3079358544u, 3206664871u, 0, EXPM1F_TOLERANCE, 0},
{27, 3212836864u, 3079358544u, 3206664871u, 0, EXPM1F_TOLERANCE, 0},
{28, 3212836864u, 3079358544u, 3206664871u, 0, EXPM1F_TOLERANCE, 0},
{29, 3212836864u, 3079358544u, 3206664871u, 0, EXPM1F_TOLERANCE, 0},
{30, 3212836864u, 3079358544u, 3206664871u, 0, EXPM1F_TOLERANCE, 0},
{31, 3212836864u, 3079358544u, 3206664871u, 0, EXPM1F_TOLERANCE, 0},
{32, 3212836864u, 3079358544u, 3206664871u, 0, EXPM1F_TOLERANCE, 0},
{33, 3212836864u, 3079358544u, 3206664871u, 0, EXPM1F_TOLERANCE, 0},
{34, 3212836864u, 3079358544u, 3206664871u, 0, EXPM1F_TOLERANCE, 0},
{35, 3212836864u, 3079358544u, 3206664871u, 0, EXPM1F_TOLERANCE, 0},
{36, 3212836864u, 3079358544u, 3206664871u, 0, EXPM1F_TOLERANCE, 0},
{37, 3212836864u, 3079358544u, 3206664871u, 0, EXPM1F_TOLERANCE, 0},
{38, 3212836864u, 3079358544u, 3206664871u, 0, EXPM1F_TOLERANCE, 0},
{39, 3212836864u, 3079358544u, 3206664871u, 0, EXPM1F_TOLERANCE, 0},
{40, 3211998003u, 3079358544u, 3206348426u, 0, EXPM1F_TOLERANCE, 0},
{41, 3211998003u, 3079358544u, 3206348426u, 0, EXPM1F_TOLERANCE, 0},
{42, 3211998003u, 3079358544u, 3206348426u, 0, EXPM1F_TOLERANCE, 0},
{43, 3211998003u, 3079358544u, 3206348426u, 0, EXPM1F_TOLERANCE, 0},
{44, 3211998003u, 3079358544u, 3206348426u, 0, EXPM1F_TOLERANCE, 0},
{45, 3211998003u, 3079358544u, 3206348426u, 0, EXPM1F_TOLERANCE, 0},
{46, 3211998003u, 3079358544u, 3206348426u, 0, EXPM1F_TOLERANCE, 0},
{47, 3211998003u, 3079358544u, 3206348426u, 0, EXPM1F_TOLERANCE, 0},
{48, 3211998003u, 3079358544u, 3206348426u, 0, EXPM1F_TOLERANCE, 0},
{49, 3211998003u, 3079358544u, 3206348426u, 0, EXPM1F_TOLERANCE, 0},
{50, 3211998003u, 3079358544u, 3206348426u, 0, EXPM1F_TOLERANCE, 0},
{51, 3211998003u, 3079358544u, 3206348426u, 0, EXPM1F_TOLERANCE, 0},
{52, 3211998003u, 3079358544u, 3206348426u, 0, EXPM1F_TOLERANCE, 0},
{53, 3211998003u, 3079358544u, 3206348426u, 0, EXPM1F_TOLERANCE, 0},
{54, 3211998003u, 3079358544u, 3206348426u, 0, EXPM1F_TOLERANCE, 0},
{55, 3211998003u, 3079358544u, 3206348426u, 0, EXPM1F_TOLERANCE, 0},
{56, 3211998003u, 3079358544u, 3206348426u, 0, EXPM1F_TOLERANCE, 0},
{57, 3211998003u, 3079358544u, 3206348426u, 0, EXPM1F_TOLERANCE, 0},
{58, 3211998003u, 3079358544u, 3206348426u, 0, EXPM1F_TOLERANCE, 0},
{59, 3211998003u, 3079358544u, 3206348426u, 0, EXPM1F_TOLERANCE, 0},
{60, 3211998003u, 3079358544u, 3206348426u, 0, EXPM1F_TOLERANCE, 0},
{61, 3211998003u, 3079358544u, 3206348426u, 0, EXPM1F_TOLERANCE, 0},
{62, 3211998003u, 3079358544u, 3206348426u, 0, EXPM1F_TOLERANCE, 0},
{63, 3211998003u, 3079358544u, 3206348426u, 0, EXPM1F_TOLERANCE, 0},
{64, 3211998003u, 3079358544u, 3206348426u, 0, EXPM1F_TOLERANCE, 0},
{65, 3211998003u, 3079358544u, 3206348426u, 0, EXPM1F_TOLERANCE, 0},
{66, 3211998003u, 3079358544u, 3206348426u, 0, EXPM1F_TOLERANCE, 0},
{67, 3211998003u, 3079358544u, 3206348426u, 0, EXPM1F_TOLERANCE, 0},
{68, 3211998003u, 3079358544u, 3206348426u, 0, EXPM1F_TOLERANCE, 0},
{69, 3211998003u, 3079358544u, 3206348426u, 0, EXPM1F_TOLERANCE, 0},
{70, 3211998003u, 3079358544u, 3206348426u, 0, EXPM1F_TOLERANCE, 0},
{71, 3211998003u, 3079358544u, 3206348426u, 0, EXPM1F_TOLERANCE, 0},
{72, 3211998003u, 3079358544u, 3206348426u, 0, EXPM1F_TOLERANCE, 0},
{73, 3211998003u, 3079358544u, 3206348426u, 0, EXPM1F_TOLERANCE, 0},
{74, 3211998003u, 3079358544u, 3206348426u, 0, EXPM1F_TOLERANCE, 0},
{75, 3211998003u, 3079358544u, 3206348426u, 0, EXPM1F_TOLERANCE, 0},
{76, 3211998003u, 3079358544u, 3206348426u, 0, EXPM1F_TOLERANCE, 0},
{77, 3211998003u, 3079358544u, 3206348426u, 0, EXPM1F_TOLERANCE, 0},
{78, 3211998003u, 3079358544u, 3206348426u, 0, EXPM1F_TOLERANCE, 0},
{79, 3211998003u, 3079358544u, 3206348426u, 0, EXPM1F_TOLERANCE, 0},
{80, 3211159142u, 3079358544u, 3206015757u, 0, EXPM1F_TOLERANCE, 0},
{81, 3211159142u, 3079358544u, 3206015757u, 0, EXPM1F_TOLERANCE, 0},
{82, 3211159142u, 3079358544u, 3206015757u, 0, EXPM1F_TOLERANCE, 0},
{83, 3211159142u, 3079358544u, 3206015757u, 0, EXPM1F_TOLERANCE, 0},
{84, 3211159142u, 3079358544u, 3206015757u, 0, EXPM1F_TOLERANCE, 0},
{85, 3211159142u, 3079358544u, 3206015757u, 0, EXPM1F_TOLERANCE, 0},
{86, 3211159142u, 3079358544u, 3206015757u, 0, EXPM1F_TOLERANCE, 0},
{87, 3211159142u, 3079358544u, 3206015757u, 0, EXPM1F_TOLERANCE, 0},
{88, 3211159142u, 3079358544u, 3206015757u, 0, EXPM1F_TOLERANCE, 0},
{89, 3211159142u, 3079358544u, 3206015757u, 0, EXPM1F_TOLERANCE, 0},
{90, 3211159142u, 3079358544u, 3206015757u, 0, EXPM1F_TOLERANCE, 0},
{91, 3211159142u, 3079358544u, 3206015757u, 0, EXPM1F_TOLERANCE, 0},
{92, 3211159142u, 3079358544u, 3206015757u, 0, EXPM1F_TOLERANCE, 0},
{93, 3211159142u, 3079358544u, 3206015757u, 0, EXPM1F_TOLERANCE, 0},
{94, 3211159142u, 3079358544u, 3206015757u, 0, EXPM1F_TOLERANCE, 0},
{95, 3211159142u, 3079358544u, 3206015757u, 0, EXPM1F_TOLERANCE, 0},
{96, 3211159142u, 3079358544u, 3206015757u, 0, EXPM1F_TOLERANCE, 0},
{97, 3211159142u, 3079358544u, 3206015757u, 0, EXPM1F_TOLERANCE, 0},
{98, 3211159142u, 3079358544u, 3206015757u, 0, EXPM1F_TOLERANCE, 0},
{99, 3211159142u, 3079358544u, 3206015757u, 0, EXPM1F_TOLERANCE, 0},
{100, 3211159142u, 3079358544u, 3206015757u, 0, EXPM1F_TOLERANCE, 0},
{101, 3211159142u, 3079358544u, 3206015757u, 0, EXPM1F_TOLERANCE, 0},
{102, 3211159142u, 3079358544u, 3206015757u, 0, EXPM1F_TOLERANCE, 0},
{103, 3211159142u, 3079358544u, 3206015757u, 0, EXPM1F_TOLERANCE, 0},
{104, 3211159142u, 3079358544u, 3206015757u, 0, EXPM1F_TOLERANCE, 0},
{105, 3211159142u, 3079358544u, 3206015757u, 0, EXPM1F_TOLERANCE, 0},
{106, 3211159142u, 3079358544u, 3206015757u, 0, EXPM1F_TOLERANCE, 0},
{107, 3211159142u, 3079358544u, 3206015757u, 0, EXPM1F_TOLERANCE, 0},
{108, 3211159142u, 3079358544u, 3206015757u, 0, EXPM1F_TOLERANCE, 0},
{109, 3211159142u, 3079358544u, 3206015757u, 0, EXPM1F_TOLERANCE, 0},
{110, 3211159142u, 3079358544u, 3206015757u, 0, EXPM1F_TOLERANCE, 0},
{111, 3211159142u, 3079358544u, 3206015757u, 0, EXPM1F_TOLERANCE, 0},
{112, 3211159142u, 3079358544u, 3206015757u, 0, EXPM1F_TOLERANCE, 0},
{113, 3211159142u, 3079358544u, 3206015757u, 0, EXPM1F_TOLERANCE, 0},
{114, 3211159142u, 3079358544u, 3206015757u, 0, EXPM1F_TOLERANCE, 0},
{115, 3211159142u, 3079358544u, 3206015757u, 0, EXPM1F_TOLERANCE, 0},
{116, 3211159142u, 3079358544u, 3206015757u, 0, EXPM1F_TOLERANCE, 0},
{117, 3211159142u, 3079358544u, 3206015757u, 0, EXPM1F_TOLERANCE, 0},
{118, 3211159142u, 3079358544u, 3206015757u, 0, EXPM1F_TOLERANCE, 0},
{119, 3211159142u, 3079358544u, 3206015757u, 0, EXPM1F_TOLERANCE, 0},
{120, 3210320282u, 3079358544u, 3205666032u, 0, EXPM1F_TOLERANCE, 0},
{121, 3210320282u, 3079358544u, 3205666032u, 0, EXPM1F_TOLERANCE, 0},
{122, 3210320282u, 3079358544u, 3205666032u, 0, EXPM1F_TOLERANCE, 0},
{123, 3210320282u, 3079358544u, 3205666032u, 0, EXPM1F_TOLERANCE, 0},
{124, 3210320282u, 3079358544u, 3205666032u, 0, EXPM1F_TOLERANCE, 0},
{125, 3210320282u, 3079358544u, 3205666032u, 0, EXPM1F_TOLERANCE, 0},
{126, 3210320282u, 3079358544u, 3205666032u, 0, EXPM1F_TOLERANCE, 0},
{127, 3210320282u, 3079358544u, 3205666032u, 0, EXPM1F_TOLERANCE, 0},
{128, 3210320282u, 3079358544u, 3205666032u, 0, EXPM1F_TOLERANCE, 0},
{129, 3210320282u, 3079358544u, 3205666032u, 0, EXPM1F_TOLERANCE, 0},
{130, 3210320282u, 3079358544u, 3205666032u, 0, EXPM1F_TOLERANCE, 0},
{131, 3210320282u, 3079358544u, 3205666032u, 0, EXPM1F_TOLERANCE, 0},
{132, 3210320282u, 3079358544u, 3205666032u, 0, EXPM1F_TOLERANCE, 0},
{133, 3210320282u, 3079358544u, 3205666032u, 0, EXPM1F_TOLERANCE, 0},
{134, 3210320282u, 3079358544u, 3205666032u, 0, EXPM1F_TOLERANCE, 0},
{135, 3210320282u, 3079358544u, 3205666032u, 0, EXPM1F_TOLERANCE, 0},
{136, 3210320282u, 3079358544u, 3205666032u, 0, EXPM1F_TOLERANCE, 0},
{137, 3210320282u, 3079358544u, 3205666032u, 0, EXPM1F_TOLERANCE, 0},
{138, 3210320282u, 3079358544u, 3205666032u, 0, EXPM1F_TOLERANCE, 0},
{139, 3210320282u, 3079358544u, 3205666032u, 0, EXPM1F_TOLERANCE, 0},
{140, 3210320282u, 3079358544u, 3205666032u, 0, EXPM1F_TOLERANCE, 0},
{141, 3210320282u, 3079358544u, 3205666032u, 0, EXPM1F_TOLERANCE, 0},
{142, 3210320282u, 3079358544u, 3205666032u, 0, EXPM1F_TOLERANCE, 0},
{143, 3210320282u, 3079358544u, 3205666032u, 0, EXPM1F_TOLERANCE, 0},
{144, 3210320282u, 3079358544u, 3205666032u, 0, EXPM1F_TOLERANCE, 0},
{145, 3210320282u, 3079358544u, 3205666032u, 0, EXPM1F_TOLERANCE, 0},
{146, 3210320282u, 3079358544u, 3205666032u, 0, EXPM1F_TOLERANCE, 0},
{147, 3210320282u, 3079358544u, 3205666032u, 0, EXPM1F_TOLERANCE, 0},
{148, 3210320282u, 3079358544u, 3205666032u, 0, EXPM1F_TOLERANCE, 0},
{149, 3210320282u, 3079358544u, 3205666032u, 0, EXPM1F_TOLERANCE, 0},
{150, 3210320282u, 3079358544u, 3205666032u, 0, EXPM1F_TOLERANCE, 0},
{151, 3210320282u, 3079358544u, 3205666032u, 0, EXPM1F_TOLERANCE, 0},
{152, 3210320282u, 3079358544u, 3205666032u, 0, EXPM1F_TOLERANCE, 0},
{153, 3210320282u, 3079358544u, 3205666032u, 0, EXPM1F_TOLERANCE, 0},
{154, 3210320282u, 3079358544u, 3205666032u, 0, EXPM1F_TOLERANCE, 0},
{155, 3210320282u, 3079358544u, 3205666032u, 0, EXPM1F_TOLERANCE, 0},
{156, 3210320282u, 3079358544u, 3205666032u, 0, EXPM1F_TOLERANCE, 0},
{157, 3210320282u, 3079358544u, 3205666032u, 0, EXPM1F_TOLERANCE, 0},
{158, 3210320282u, 3079358544u, 3205666032u, 0, EXPM1F_TOLERANCE, 0},
{159, 3210320282u, 3079358544u, 3205666032u, 0, EXPM1F_TOLERANCE, 0},
{160, 3209481421u, 3079358544u, 3205298375u, 0, EXPM1F_TOLERANCE, 0},
{161, 3209481421u, 3079358544u, 3205298375u, 0, EXPM1F_TOLERANCE, 0},
{162, 3209481421u, 3079358544u, 3205298375u, 0, EXPM1F_TOLERANCE, 0},
{163, 3209481421u, 3079358544u, 3205298375u, 0, EXPM1F_TOLERANCE, 0},
{164, 3209481421u, 3079358544u, 3205298375u, 0, EXPM1F_TOLERANCE, 0},
{165, 3209481421u, 3079358544u, 3205298375u, 0, EXPM1F_TOLERANCE, 0},
{166, 3209481421u, 3079358544u, 3205298375u, 0, EXPM1F_TOLERANCE, 0},
{167, 3209481421u, 3079358544u, 3205298375u, 0, EXPM1F_TOLERANCE, 0},
{168, 3209481421u, 3079358544u, 3205298375u, 0, EXPM1F_TOLERANCE, 0},
{169, 3209481421u, 3079358544u, 3205298375u, 0, EXPM1F_TOLERANCE, 0},
{170, 3209481421u, 3079358544u, 3205298375u, 0, EXPM1F_TOLERANCE, 0},
{171, 3209481421u, 3079358544u, 3205298375u, 0, EXPM1F_TOLERANCE, 0},
{172, 3209481421u, 3079358544u, 3205298375u, 0, EXPM1F_TOLERANCE, 0},
{173, 3209481421u, 3079358544u, 3205298375u, 0, EXPM1F_TOLERANCE, 0},
{174, 3209481421u, 3079358544u, 3205298375u, 0, EXPM1F_TOLERANCE, 0},
{175, 3209481421u, 3079358544u, 3205298375u, 0, EXPM1F_TOLERANCE, 0},
{176, 3209481421u, 3079358544u, 3205298375u, 0, EXPM1F_TOLERANCE, 0},
{177, 3209481421u, 3079358544u, 3205298375u, 0, EXPM1F_TOLERANCE, 0},
{178, 3209481421u, 3079358544u, 3205298375u, 0, EXPM1F_TOLERANCE, 0},
{179, 3209481421u, 3079358544u, 3205298375u, 0, EXPM1F_TOLERANCE, 0},
{180, 3209481421u, 3079358544u, 3205298375u, 0, EXPM1F_TOLERANCE, 0},
{181, 3209481421u, 3079358544u, 3205298375u, 0, EXPM1F_TOLERANCE, 0},
{182, 3209481421u, 3079358544u, 3205298375u, 0, EXPM1F_TOLERANCE, 0},
{183, 3209481421u, 3079358544u, 3205298375u, 0, EXPM1F_TOLERANCE, 0},
{184, 3209481421u, 3079358544u, 3205298375u, 0, EXPM1F_TOLERANCE, 0},
{185, 3209481421u, 3079358544u, 3205298375u, 0, EXPM1F_TOLERANCE, 0},
{186, 3209481421u, 3079358544u, 3205298375u, 0, EXPM1F_TOLERANCE, 0},
{187, 3209481421u, 3079358544u, 3205298375u, 0, EXPM1F_TOLERANCE, 0},
{188, 3209481421u, 3079358544u, 3205298375u, 0, EXPM1F_TOLERANCE, 0},
{189, 3209481421u, 3079358544u, 3205298375u, 0, EXPM1F_TOLERANCE, 0},
{190, 3209481421u, 3079358544u, 3205298375u, 0, EXPM1F_TOLERANCE, 0},
{191, 3209481421u, 3079358544u, 3205298375u, 0, EXPM1F_TOLERANCE, 0},
{192, 3209481421u, 3079358544u, 3205298375u, 0, EXPM1F_TOLERANCE, 0},
{193, 3209481421u, 3079358544u, 3205298375u, 0, EXPM1F_TOLERANCE, 0},
{194, 3209481421u, 3079358544u, 3205298375u, 0, EXPM1F_TOLERANCE, 0},
{195, 3209481421u, 3079358544u, 3205298375u, 0, EXPM1F_TOLERANCE, 0},
{196, 3209481421u, 3079358544u, 3205298375u, 0, EXPM1F_TOLERANCE, 0},
{197, 3209481421u, 3079358544u, 3205298375u, 0, EXPM1F_TOLERANCE, 0},
{198, 3209481421u, 3079358544u, 3205298375u, 0, EXPM1F_TOLERANCE, 0},
{199, 3209481421u, 3079358544u, 3205298375u, 0, EXPM1F_TOLERANCE, 0},
{200, 3208642560u, 3079358544u, 3204911868u, 0, EXPM1F_TOLERANCE, 0},
{201, 3208642560u, 3079358544u, 3204911868u, 0, EXPM1F_TOLERANCE, 0},
{202, 3208642560u, 3079358544u, 3204911868u, 0, EXPM1F_TOLERANCE, 0},
{203, 3208642560u, 3079358544u, 3204911868u, 0, EXPM1F_TOLERANCE, 0},
{204, 3208642560u, 3079358544u, 3204911868u, 0, EXPM1F_TOLERANCE, 0},
{205, 3208642560u, 3079358544u, 3204911868u, 0, EXPM1F_TOLERANCE, 0},
{206, 3208642560u, 3079358544u, 3204911868u, 0, EXPM1F_TOLERANCE, 0},
{207, 3208642560u, 3079358544u, 3204911868u, 0, EXPM1F_TOLERANCE, 0},
{208, 3208642560u, 3079358544u, 3204911868u, 0, EXPM1F_TOLERANCE, 0},
{209, 3208642560u, 3079358544u, 3204911868u, 0, EXPM1F_TOLERANCE, 0},
{210, 3208642560u, 3079358544u, 3204911868u, 0, EXPM1F_TOLERANCE, 0},
{211, 3208642560u, 3079358544u, 3204911868u, 0, EXPM1F_TOLERANCE, 0},
{212, 3208642560u, 3079358544u, 3204911868u, 0, EXPM1F_TOLERANCE, 0},
{213, 3208642560u, 3079358544u, 3204911868u, 0, EXPM1F_TOLERANCE, 0},
{214, 3208642560u, 3079358544u, 3204911868u, 0, EXPM1F_TOLERANCE, 0},
{215, 3208642560u, 3079358544u, 3204911868u, 0, EXPM1F_TOLERANCE, 0},
{216, 3208642560u, 3079358544u, 3204911868u, 0, EXPM1F_TOLERANCE, 0},
{217, 3208642560u, 3079358544u, 3204911868u, 0, EXPM1F_TOLERANCE, 0},
{218, 3208642560u, 3079358544u, 3204911868u, 0, EXPM1F_TOLERANCE, 0},
{219, 3208642560u, 3079358544u, 3204911868u, 0, EXPM1F_TOLERANCE, 0},
{220, 3208642560u, 3079358544u, 3204911868u, 0, EXPM1F_TOLERANCE, 0},
{221, 3208642560u, 3079358544u, 3204911868u, 0, EXPM1F_TOLERANCE, 0},
{222, 3208642560u, 3079358544u, 3204911868u, 0, EXPM1F_TOLERANCE, 0},
{223, 3208642560u, 3079358544u, 3204911868u, 0, EXPM1F_TOLERANCE, 0},
{224, 3208642560u, 3079358544u, 3204911868u, 0, EXPM1F_TOLERANCE, 0},
{225, 3208642560u, 3079358544u, 3204911868u, 0, EXPM1F_TOLERANCE, 0},
{226, 3208642560u, 3079358544u, 3204911868u, 0, EXPM1F_TOLERANCE, 0},
{227, 3208642560u, 3079358544u, 3204911868u, 0, EXPM1F_TOLERANCE, 0},
{228, 3208642560u, 3079358544u, 3204911868u, 0, EXPM1F_TOLERANCE, 0},
{229, 3208642560u, 3079358544u, 3204911868u, 0, EXPM1F_TOLERANCE, 0},
{230, 3208642560u, 3079358544u, 3204911868u, 0, EXPM1F_TOLERANCE, 0},
{231, 3208642560u, 3079358544u, 3204911868u, 0, EXPM1F_TOLERANCE, 0},
{232, 3208642560u, 3079358544u, 3204911868u, 0, EXPM1F_TOLERANCE, 0},
{233, 3208642560u, 3079358544u, 3204911868u, 0, EXPM1F_TOLERANCE, 0},
{234, 3208642560u, 3079358544u, 3204911868u, 0, EXPM1F_TOLERANCE, 0},
{235, 3208642560u, 3079358544u, 3204911868u, 0, EXPM1F_TOLERANCE, 0},
{236, 3208642560u, 3079358544u, 3204911868u, 0, EXPM1F_TOLERANCE, 0},
{237, 3208642560u, 3079358544u, 3204911868u, 0, EXPM1F_TOLERANCE, 0},
{238, 3208642560u, 3079358544u, 3204911868u, 0, EXPM1F_TOLERANCE, 0},
{239, 3208642560u, 3079358544u, 3204911868u, 0, EXPM1F_TOLERANCE, 0},
{240, 3207803699u, 3079358544u, 3204505545u, 0, EXPM1F_TOLERANCE, 0},
{241, 3207803699u, 3079358544u, 3204505545u, 0, EXPM1F_TOLERANCE, 0},
{242, 3207803699u, 3079358544u, 3204505545u, 0, EXPM1F_TOLERANCE, 0},
{243, 3207803699u, 3079358544u, 3204505545u, 0, EXPM1F_TOLERANCE, 0},
{244, 3207803699u, 3079358544u, 3204505545u, 0, EXPM1F_TOLERANCE, 0},
{245, 3207803699u, 3079358544u, 3204505545u, 0, EXPM1F_TOLERANCE, 0},
{246, 3207803699u, 3079358544u, 3204505545u, 0, EXPM1F_TOLERANCE, 0},
{247, 3207803699u, 3079358544u, 3204505545u, 0, EXPM1F_TOLERANCE, 0},
{248, 3207803699u, 3079358544u, 3204505545u, 0, EXPM1F_TOLERANCE, 0},
{249, 3207803699u, 3079358544u, 3204505545u, 0, EXPM1F_TOLERANCE, 0},
{250, 3207803699u, 3079358544u, 3204505545u, 0, EXPM1F_TOLERANCE, 0},
{251, 3207803699u, 3079358544u, 3204505545u, 0, EXPM1F_TOLERANCE, 0},
{252, 3207803699u, 3079358544u, 3204505545u, 0, EXPM1F_TOLERANCE, 0},
{253, 3207803699u, 3079358544u, 3204505545u, 0, EXPM1F_TOLERANCE, 0},
{254, 3207803699u, 3079358544u, 3204505545u, 0, EXPM1F_TOLERANCE, 0},
{255, 3207803699u, 3079358544u, 3204505545u, 0, EXPM1F_TOLERANCE, 0},
{256, 3207803699u, 3079358544u, 3204505545u, 0, EXPM1F_TOLERANCE, 0},
{257, 3207803699u, 3079358544u, 3204505545u, 0, EXPM1F_TOLERANCE, 0},
{258, 3207803699u, 3079358544u, 3204505545u, 0, EXPM1F_TOLERANCE, 0},
{259, 3207803699u, 3079358544u, 3204505545u, 0, EXPM1F_TOLERANCE, 0},
{260, 3207803699u, 3079358544u, 3204505545u, 0, EXPM1F_TOLERANCE, 0},
{261, 3207803699u, 3079358544u, 3204505545u, 0, EXPM1F_TOLERANCE, 0},
{262, 3207803699u, 3079358544u, 3204505545u, 0, EXPM1F_TOLERANCE, 0},
{263, 3207803699u, 3079358544u, 3204505545u, 0, EXPM1F_TOLERANCE, 0},
{264, 3207803699u, 3079358544u, 3204505545u, 0, EXPM1F_TOLERANCE, 0},
{265, 3207803699u, 3079358544u, 3204505545u, 0, EXPM1F_TOLERANCE, 0},
{266, 3207803699u, 3079358544u, 3204505545u, 0, EXPM1F_TOLERANCE, 0},
{267, 3207803699u, 3079358544u, 3204505545u, 0, EXPM1F_TOLERANCE, 0},
{268, 3207803699u, 3079358544u, 3204505545u, 0, EXPM1F_TOLERANCE, 0},
{269, 3207803699u, 3079358544u, 3204505545u, 0, EXPM1F_TOLERANCE, 0},
{270, 3207803699u, 3079358544u, 3204505545u, 0, EXPM1F_TOLERANCE, 0},
{271, 3207803699u, 3079358544u, 3204505545u, 0, EXPM1F_TOLERANCE, 0},
{272, 3207803699u, 3079358544u, 3204505545u, 0, EXPM1F_TOLERANCE, 0},
{273, 3207803699u, 3079358544u, 3204505545u, 0, EXPM1F_TOLERANCE, 0},
{274, 3207803699u, 3079358544u, 3204505545u, 0, EXPM1F_TOLERANCE, 0},
{275, 3207803699u, 3079358544u, 3204505545u, 0, EXPM1F_TOLERANCE, 0},
{276, 3207803699u, 3079358544u, 3204505545u, 0, EXPM1F_TOLERANCE, 0},
{277, 3207803699u, 3079358544u, 3204505545u, 0, EXPM1F_TOLERANCE, 0},
{278, 3207803699u, 3079358544u, 3204505545u, 0, EXPM1F_TOLERANCE, 0},
{279, 3207803699u, 3079358544u, 3204505545u, 0, EXPM1F_TOLERANCE, 0},
{280, 3206964838u, 3079358544u, 3203708522u, 0, EXPM1F_TOLERANCE, 0},
{281, 3206964838u, 3079358544u, 3203708522u, 0, EXPM1F_TOLERANCE, 0},
{282, 3206964838u, 3079358544u, 3203708522u, 0, EXPM1F_TOLERANCE, 0},
{283, 3206964838u, 3079358544u, 3203708522u, 0, EXPM1F_TOLERANCE, 0},
{284, 3206964838u, 3079358544u, 3203708522u, 0, EXPM1F_TOLERANCE, 0},
{285, 3206964838u, 3079358544u, 3203708522u, 0, EXPM1F_TOLERANCE, 0},
{286, 3206964838u, 3079358544u, 3203708522u, 0, EXPM1F_TOLERANCE, 0},
{287, 3206964838u, 3079358544u, 3203708522u, 0, EXPM1F_TOLERANCE, 0},
{288, 3206964838u, 3079358544u, 3203708522u, 0, EXPM1F_TOLERANCE, 0},
{289, 3206964838u, 3079358544u, 3203708522u, 0, EXPM1F_TOLERANCE, 0},
{290, 3206964838u, 3079358544u, 3203708522u, 0, EXPM1F_TOLERANCE, 0},
{291, 3206964838u, 3079358544u, 3203708522u, 0, EXPM1F_TOLERANCE, 0},
{292, 3206964838u, 3079358544u, 3203708522u, 0, EXPM1F_TOLERANCE, 0},
{293, 3206964838u, 3079358544u, 3203708522u, 0, EXPM1F_TOLERANCE, 0},
{294, 3206964838u, 3079358544u, 3203708522u, 0, EXPM1F_TOLERANCE, 0},
{295, 3206964838u, 3079358544u, 3203708522u, 0, EXPM1F_TOLERANCE, 0},
{296, 3206964838u, 3079358544u, 3203708522u, 0, EXPM1F_TOLERANCE, 0},
{297, 3206964838u, 3079358544u, 3203708522u, 0, EXPM1F_TOLERANCE, 0},
{298, 3206964838u, 3079358544u, 3203708522u, 0, EXPM1F_TOLERANCE, 0},
{299, 3206964838u, 3079358544u, 3203708522u, 0, EXPM1F_TOLERANCE, 0},
{300, 3206964838u, 3079358544u, 3203708522u, 0, EXPM1F_TOLERANCE, 0},
{301, 3206964838u, 3079358544u, 3203708522u, 0, EXPM1F_TOLERANCE, 0},
{302, 3206964838u, 3079358544u, 3203708522u, 0, EXPM1F_TOLERANCE, 0},
{303, 3206964838u, 3079358544u, 3203708522u, 0, EXPM1F_TOLERANCE, 0},
{304, 3206964838u, 3079358544u, 3203708522u, 0, EXPM1F_TOLERANCE, 0},
{305, 3206964838u, 3079358544u, 3203708522u, 0, EXPM1F_TOLERANCE, 0},
{306, 3206964838u, 3079358544u, 3203708522u, 0, EXPM1F_TOLERANCE, 0},
{307, 3206964838u, 3079358544u, 3203708522u, 0, EXPM1F_TOLERANCE, 0},
{308, 3206964838u, 3079358544u, 3203708522u, 0, EXPM1F_TOLERANCE, 0},
{309, 3206964838u, 3079358544u, 3203708522u, 0, EXPM1F_TOLERANCE, 0},
{310, 3206964838u, 3079358544u, 3203708522u, 0, EXPM1F_TOLERANCE, 0},
{311, 3206964838u, 3079358544u, 3203708522u, 0, EXPM1F_TOLERANCE, 0},
{312, 3206964838u, 3079358544u, 3203708522u, 0, EXPM1F_TOLERANCE, 0},
{313, 3206964838u, 3079358544u, 3203708522u, 0, EXPM1F_TOLERANCE, 0},
{314, 3206964838u, 3079358544u, 3203708522u, 0, EXPM1F_TOLERANCE, 0},
{315, 3206964838u, 3079358544u, 3203708522u, 0, EXPM1F_TOLERANCE, 0},
{316, 3206964838u, 3079358544u, 3203708522u, 0, EXPM1F_TOLERANCE, 0},
{317, 3206964838u, 3079358544u, 3203708522u, 0, EXPM1F_TOLERANCE, 0},
{318, 3206964838u, 3079358544u, 3203708522u, 0, EXPM1F_TOLERANCE, 0},
{319, 3206964838u, 3079358544u, 3203708522u, 0, EXPM1F_TOLERANCE, 0},
{320, 3206125978u, 3079358544u, 3202810410u, 0, EXPM1F_TOLERANCE, 0},
{321, 3206125978u, 3079358544u, 3202810410u, 0, EXPM1F_TOLERANCE, 0},
{322, 3206125978u, 3079358544u, 3202810410u, 0, EXPM1F_TOLERANCE, 0},
{323, 3206125978u, 3079358544u, 3202810410u, 0, EXPM1F_TOLERANCE, 0},
{324, 3206125978u, 3079358544u, 3202810410u, 0, EXPM1F_TOLERANCE, 0},
{325, 3206125978u, 3079358544u, 3202810410u, 0, EXPM1F_TOLERANCE, 0},
{326, 3206125978u, 3079358544u, 3202810410u, 0, EXPM1F_TOLERANCE, 0},
{327, 3206125978u, 3079358544u, 3202810410u, 0, EXPM1F_TOLERANCE, 0},
{328, 3206125978u, 3079358544u, 3202810410u, 0, EXPM1F_TOLERANCE, 0},
{329, 3206125978u, 3079358544u, 3202810410u, 0, EXPM1F_TOLERANCE, 0},
{330, 3206125978u, 3079358544u, 3202810410u, 0, EXPM1F_TOLERANCE, 0},
{331, 3206125978u, 3079358544u, 3202810410u, 0, EXPM1F_TOLERANCE, 0},
{332, 3206125978u, 3079358544u, 3202810410u, 0, EXPM1F_TOLERANCE, 0},
{333, 3206125978u, 3079358544u, 3202810410u, 0, EXPM1F_TOLERANCE, 0},
{334, 3206125978u, 3079358544u, 3202810410u, 0, EXPM1F_TOLERANCE, 0},
{335, 3206125978u, 3079358544u, 3202810410u, 0, EXPM1F_TOLERANCE, 0},
{336, 3206125978u, 3079358544u, 3202810410u, 0, EXPM1F_TOLERANCE, 0},
{337, 3206125978u, 3079358544u, 3202810410u, 0, EXPM1F_TOLERANCE, 0},
{338, 3206125978u, 3079358544u, 3202810410u, 0, EXPM1F_TOLERANCE, 0},
{339, 3206125978u, 3079358544u, 3202810410u, 0, EXPM1F_TOLERANCE, 0},
{340, 3206125978u, 3079358544u, 3202810410u, 0, EXPM1F_TOLERANCE, 0},
{341, 3206125978u, 3079358544u, 3202810410u, 0, EXPM1F_TOLERANCE, 0},
{342, 3206125978u, 3079358544u, 3202810410u, 0, EXPM1F_TOLERANCE, 0},
{343, 3206125978u, 3079358544u, 3202810410u, 0, EXPM1F_TOLERANCE, 0},
{344, 3206125978u, 3079358544u, 3202810410u, 0, EXPM1F_TOLERANCE, 0},
{345, 3206125978u, 3079358544u, 3202810410u, 0, EXPM1F_TOLERANCE, 0},
{346, 3206125978u, 3079358544u, 3202810410u, 0, EXPM1F_TOLERANCE, 0},
{347, 3206125978u, 3079358544u, 3202810410u, 0, EXPM1F_TOLERANCE, 0},
{348, 3206125978u, 3079358544u, 3202810410u, 0, EXPM1F_TOLERANCE, 0},
{349, 3206125978u, 3079358544u, 3202810410u, 0, EXPM1F_TOLERANCE, 0},
{350, 3206125978u, 3079358544u, 3202810410u, 0, EXPM1F_TOLERANCE, 0},
{351, 3206125978u, 3079358544u, 3202810410u, 0, EXPM1F_TOLERANCE, 0},
{352, 3206125978u, 3079358544u, 3202810410u, 0, EXPM1F_TOLERANCE, 0},
{353, 3206125978u, 3079358544u, 3202810410u, 0, EXPM1F_TOLERANCE, 0},
{354, 3206125978u, 3079358544u, 3202810410u, 0, EXPM1F_TOLERANCE, 0},
{355, 3206125978u, 3079358544u, 3202810410u, 0, EXPM1F_TOLERANCE, 0},
{356, 3206125978u, 3079358544u, 3202810410u, 0, EXPM1F_TOLERANCE, 0},
{357, 3206125978u, 3079358544u, 3202810410u, 0, EXPM1F_TOLERANCE, 0},
{358, 3206125978u, 3079358544u, 3202810410u, 0, EXPM1F_TOLERANCE, 0},
{359, 3206125978u, 3079358544u, 3202810410u, 0, EXPM1F_TOLERANCE, 0},
{360, 3205287117u, 3079358544u, 3201866249u, 0, EXPM1F_TOLERANCE, 0},
{361, 3205287117u, 3079358544u, 3201866249u, 0, EXPM1F_TOLERANCE, 0},
{362, 3205287117u, 3079358544u, 3201866249u, 0, EXPM1F_TOLERANCE, 0},
{363, 3205287117u, 3079358544u, 3201866249u, 0, EXPM1F_TOLERANCE, 0},
{364, 3205287117u, 3079358544u, 3201866249u, 0, EXPM1F_TOLERANCE, 0},
{365, 3205287117u, 3079358544u, 3201866249u, 0, EXPM1F_TOLERANCE, 0},
{366, 3205287117u, 3079358544u, 3201866249u, 0, EXPM1F_TOLERANCE, 0},
{367, 3205287117u, 3079358544u, 3201866249u, 0, EXPM1F_TOLERANCE, 0},
{368, 3205287117u, 3079358544u, 3201866249u, 0, EXPM1F_TOLERANCE, 0},
{369, 3205287117u, 3079358544u, 3201866249u, 0, EXPM1F_TOLERANCE, 0},
{370, 3205287117u, 3079358544u, 3201866249u, 0, EXPM1F_TOLERANCE, 0},
{371, 3205287117u, 3079358544u, 3201866249u, 0, EXPM1F_TOLERANCE, 0},
{372, 3205287117u, 3079358544u, 3201866249u, 0, EXPM1F_TOLERANCE, 0},
{373, 3205287117u, 3079358544u, 3201866249u, 0, EXPM1F_TOLERANCE, 0},
{374, 3205287117u, 3079358544u, 3201866249u, 0, EXPM1F_TOLERANCE, 0},
{375, 3205287117u, 3079358544u, 3201866249u, 0, EXPM1F_TOLERANCE, 0},
{376, 3205287117u, 3079358544u, 3201866249u, 0, EXPM1F_TOLERANCE, 0},
{377, 3205287117u, 3079358544u, 3201866249u, 0, EXPM1F_TOLERANCE, 0},
{378, 3205287117u, 3079358544u, 3201866249u, 0, EXPM1F_TOLERANCE, 0},
{379, 3205287117u, 3079358544u, 3201866249u, 0, EXPM1F_TOLERANCE, 0},
{380, 3205287117u, 3079358544u, 3201866249u, 0, EXPM1F_TOLERANCE, 0},
{381, 3205287117u, 3079358544u, 3201866249u, 0, EXPM1F_TOLERANCE, 0},
{382, 3205287117u, 3079358544u, 3201866249u, 0, EXPM1F_TOLERANCE, 0},
{383, 3205287117u, 3079358544u, 3201866249u, 0, EXPM1F_TOLERANCE, 0},
{384, 3205287117u, 3079358544u, 3201866249u, 0, EXPM1F_TOLERANCE, 0},
{385, 3205287117u, 3079358544u, 3201866249u, 0, EXPM1F_TOLERANCE, 0},
{386, 3205287117u, 3079358544u, 3201866249u, 0, EXPM1F_TOLERANCE, 0},
{387, 3205287117u, 3079358544u, 3201866249u, 0, EXPM1F_TOLERANCE, 0},
{388, 3205287117u, 3079358544u, 3201866249u, 0, EXPM1F_TOLERANCE, 0},
{389, 3205287117u, 3079358544u, 3201866249u, 0, EXPM1F_TOLERANCE, 0},
{390, 3205287117u, 3079358544u, 3201866249u, 0, EXPM1F_TOLERANCE, 0},
{391, 3205287117u, 3079358544u, 3201866249u, 0, EXPM1F_TOLERANCE, 0},
{392, 3205287117u, 3079358544u, 3201866249u, 0, EXPM1F_TOLERANCE, 0},
{393, 3205287117u, 3079358544u, 3201866249u, 0, EXPM1F_TOLERANCE, 0},
{394, 3205287117u, 3079358544u, 3201866249u, 0, EXPM1F_TOLERANCE, 0},
{395, 3205287117u, 3079358544u, 3201866249u, 0, EXPM1F_TOLERANCE, 0},
{396, 3205287117u, 3079358544u, 3201866249u, 0, EXPM1F_TOLERANCE, 0},
{397, 3205287117u, 3079358544u, 3201866249u, 0, EXPM1F_TOLERANCE, 0},
{398, 3205287117u, 3079358544u, 3201866249u, 0, EXPM1F_TOLERANCE, 0},
{399, 3205287117u, 3079358544u, 3201866249u, 0, EXPM1F_TOLERANCE, 0},
{400, 3204448256u, 3079358544u, 3200873680u, 0, EXPM1F_TOLERANCE, 0},
{401, 3204448256u, 3079358544u, 3200873680u, 0, EXPM1F_TOLERANCE, 0},
{402, 3204448256u, 3079358544u, 3200873680u, 0, EXPM1F_TOLERANCE, 0},
{403, 3204448256u, 3079358544u, 3200873680u, 0, EXPM1F_TOLERANCE, 0},
{404, 3204448256u, 3079358544u, 3200873680u, 0, EXPM1F_TOLERANCE, 0},
{405, 3204448256u, 3079358544u, 3200873680u, 0, EXPM1F_TOLERANCE, 0},
{406, 3204448256u, 3079358544u, 3200873680u, 0, EXPM1F_TOLERANCE, 0},
{407, 3204448256u, 3079358544u, 3200873680u, 0, EXPM1F_TOLERANCE, 0},
{408, 3204448256u, 3079358544u, 3200873680u, 0, EXPM1F_TOLERANCE, 0},
{409, 3204448256u, 3079358544u, 3200873680u, 0, EXPM1F_TOLERANCE, 0},
{410, 3204448256u, 3079358544u, 3200873680u, 0, EXPM1F_TOLERANCE, 0},
{411, 3204448256u, 3079358544u, 3200873680u, 0, EXPM1F_TOLERANCE, 0},
{412, 3204448256u, 3079358544u, 3200873680u, 0, EXPM1F_TOLERANCE, 0},
{413, 3204448256u, 3079358544u, 3200873680u, 0, EXPM1F_TOLERANCE, 0},
{414, 3204448256u, 3079358544u, 3200873680u, 0, EXPM1F_TOLERANCE, 0},
{415, 3204448256u, 3079358544u, 3200873680u, 0, EXPM1F_TOLERANCE, 0},
{416, 3204448256u, 3079358544u, 3200873680u, 0, EXPM1F_TOLERANCE, 0},
{417, 3204448256u, 3079358544u, 3200873680u, 0, EXPM1F_TOLERANCE, 0},
{418, 3204448256u, 3079358544u, 3200873680u, 0, EXPM1F_TOLERANCE, 0},
{419, 3204448256u, 3079358544u, 3200873680u, 0, EXPM1F_TOLERANCE, 0},
{420, 3204448256u, 3079358544u, 3200873680u, 0, EXPM1F_TOLERANCE, 0},
{421, 3204448256u, 3079358544u, 3200873680u, 0, EXPM1F_TOLERANCE, 0},
{422, 3204448256u, 3079358544u, 3200873680u, 0, EXPM1F_TOLERANCE, 0},
{423, 3204448256u, 3079358544u, 3200873680u, 0, EXPM1F_TOLERANCE, 0},
{424, 3204448256u, 3079358544u, 3200873680u, 0, EXPM1F_TOLERANCE, 0},
{425, 3204448256u, 3079358544u, 3200873680u, 0, EXPM1F_TOLERANCE, 0},
{426, 3204448256u, 3079358544u, 3200873680u, 0, EXPM1F_TOLERANCE, 0},
{427, 3204448256u, 3079358544u, 3200873680u, 0, EXPM1F_TOLERANCE, 0},
{428, 3204448256u, 3079358544u, 3200873680u, 0, EXPM1F_TOLERANCE, 0},
{429, 3204448256u, 3079358544u, 3200873680u, 0, EXPM1F_TOLERANCE, 0},
{430, 3204448256u, 3079358544u, 3200873680u, 0, EXPM1F_TOLERANCE, 0},
{431, 3204448256u, 3079358544u, 3200873680u, 0, EXPM1F_TOLERANCE, 0},
{432, 3204448256u, 3079358544u, 3200873680u, 0, EXPM1F_TOLERANCE, 0},
{433, 3204448256u, 3079358544u, 3200873680u, 0, EXPM1F_TOLERANCE, 0},
{434, 3204448256u, 3079358544u, 3200873680u, 0, EXPM1F_TOLERANCE, 0},
{435, 3204448256u, 3079358544u, 3200873680u, 0, EXPM1F_TOLERANCE, 0},
{436, 3204448256u, 3079358544u, 3200873680u, 0, EXPM1F_TOLERANCE, 0},
{437, 3204448256u, 3079358544u, 3200873680u, 0, EXPM1F_TOLERANCE, 0},
{438, 3204448256u, 3079358544u, 3200873680u, 0, EXPM1F_TOLERANCE, 0},
{439, 3204448256u, 3079358544u, 3200873680u, 0, EXPM1F_TOLERANCE, 0},
{440, 3202770534u, 3079358544u, 3199830221u, 0, EXPM1F_TOLERANCE, 0},
{441, 3202770534u, 3079358544u, 3199830221u, 0, EXPM1F_TOLERANCE, 0},
{442, 3202770534u, 3079358544u, 3199830221u, 0, EXPM1F_TOLERANCE, 0},
{443, 3202770534u, 3079358544u, 3199830221u, 0, EXPM1F_TOLERANCE, 0},
{444, 3202770534u, 3079358544u, 3199830221u, 0, EXPM1F_TOLERANCE, 0},
{445, 3202770534u, 3079358544u, 3199830221u, 0, EXPM1F_TOLERANCE, 0},
{446, 3202770534u, 3079358544u, 3199830221u, 0, EXPM1F_TOLERANCE, 0},
{447, 3202770534u, 3079358544u, 3199830221u, 0, EXPM1F_TOLERANCE, 0},
{448, 3202770534u, 3079358544u, 3199830221u, 0, EXPM1F_TOLERANCE, 0},
{449, 3202770534u, 3079358544u, 3199830221u, 0, EXPM1F_TOLERANCE, 0},
{450, 3202770534u, 3079358544u, 3199830221u, 0, EXPM1F_TOLERANCE, 0},
{451, 3202770534u, 3079358544u, 3199830221u, 0, EXPM1F_TOLERANCE, 0},
{452, 3202770534u, 3079358544u, 3199830221u, 0, EXPM1F_TOLERANCE, 0},
{453, 3202770534u, 3079358544u, 3199830221u, 0, EXPM1F_TOLERANCE, 0},
{454, 3202770534u, 3079358544u, 3199830221u, 0, EXPM1F_TOLERANCE, 0},
{455, 3202770534u, 3079358544u, 3199830221u, 0, EXPM1F_TOLERANCE, 0},
{456, 3202770534u, 3079358544u, 3199830221u, 0, EXPM1F_TOLERANCE, 0},
{457, 3202770534u, 3079358544u, 3199830221u, 0, EXPM1F_TOLERANCE, 0},
{458, 3202770534u, 3079358544u, 3199830221u, 0, EXPM1F_TOLERANCE, 0},
{459, 3202770534u, 3079358544u, 3199830221u, 0, EXPM1F_TOLERANCE, 0},
{460, 3202770534u, 3079358544u, 3199830221u, 0, EXPM1F_TOLERANCE, 0},
{461, 3202770534u, 3079358544u, 3199830221u, 0, EXPM1F_TOLERANCE, 0},
{462, 3202770534u, 3079358544u, 3199830221u, 0, EXPM1F_TOLERANCE, 0},
{463, 3202770534u, 3079358544u, 3199830221u, 0, EXPM1F_TOLERANCE, 0},
{464, 3202770534u, 3079358544u, 3199830221u, 0, EXPM1F_TOLERANCE, 0},
{465, 3202770534u, 3079358544u, 3199830221u, 0, EXPM1F_TOLERANCE, 0},
{466, 3202770534u, 3079358544u, 3199830221u, 0, EXPM1F_TOLERANCE, 0},
{467, 3202770534u, 3079358544u, 3199830221u, 0, EXPM1F_TOLERANCE, 0},
{468, 3202770534u, 3079358544u, 3199830221u, 0, EXPM1F_TOLERANCE, 0},
{469, 3202770534u, 3079358544u, 3199830221u, 0, EXPM1F_TOLERANCE, 0},
{470, 3202770534u, 3079358544u, 3199830221u, 0, EXPM1F_TOLERANCE, 0},
{471, 3202770534u, 3079358544u, 3199830221u, 0, EXPM1F_TOLERANCE, 0},
{472, 3202770534u, 3079358544u, 3199830221u, 0, EXPM1F_TOLERANCE, 0},
{473, 3202770534u, 3079358544u, 3199830221u, 0, EXPM1F_TOLERANCE, 0},
{474, 3202770534u, 3079358544u, 3199830221u, 0, EXPM1F_TOLERANCE, 0},
{475, 3202770534u, 3079358544u, 3199830221u, 0, EXPM1F_TOLERANCE, 0},
{476, 3202770534u, 3079358544u, 3199830221u, 0, EXPM1F_TOLERANCE, 0},
{477, 3202770534u, 3079358544u, 3199830221u, 0, EXPM1F_TOLERANCE, 0},
{478, 3202770534u, 3079358544u, 3199830221u, 0, EXPM1F_TOLERANCE, 0},
{479, 3202770534u, 3079358544u, 3199830221u, 0, EXPM1F_TOLERANCE, 0},
{480, 3201092813u, 3079358544u, 3198733264u, 0, EXPM1F_TOLERANCE, 0},
{481, 3201092813u, 3079358544u, 3198733264u, 0, EXPM1F_TOLERANCE, 0},
{482, 3201092813u, 3079358544u, 3198733264u, 0, EXPM1F_TOLERANCE, 0},
{483, 3201092813u, 3079358544u, 3198733264u, 0, EXPM1F_TOLERANCE, 0},
{484, 3201092813u, 3079358544u, 3198733264u, 0, EXPM1F_TOLERANCE, 0},
{485, 3201092813u, 3079358544u, 3198733264u, 0, EXPM1F_TOLERANCE, 0},
{486, 3201092813u, 3079358544u, 3198733264u, 0, EXPM1F_TOLERANCE, 0},
{487, 3201092813u, 3079358544u, 3198733264u, 0, EXPM1F_TOLERANCE, 0},
{488, 3201092813u, 3079358544u, 3198733264u, 0, EXPM1F_TOLERANCE, 0},
{489, 3201092813u, 3079358544u, 3198733264u, 0, EXPM1F_TOLERANCE, 0},
{490, 3201092813u, 3079358544u, 3198733264u, 0, EXPM1F_TOLERANCE, 0},
{491, 3201092813u, 3079358544u, 3198733264u, 0, EXPM1F_TOLERANCE, 0},
{492, 3201092813u, 3079358544u, 3198733264u, 0, EXPM1F_TOLERANCE, 0},
{493, 3201092813u, 3079358544u, 3198733264u, 0, EXPM1F_TOLERANCE, 0},
{494, 3201092813u, 3079358544u, 3198733264u, 0, EXPM1F_TOLERANCE, 0},
{495, 3201092813u, 3079358544u, 3198733264u, 0, EXPM1F_TOLERANCE, 0},
{496, 3201092813u, 3079358544u, 3198733264u, 0, EXPM1F_TOLERANCE, 0},
{497, 3201092813u, 3079358544u, 3198733264u, 0, EXPM1F_TOLERANCE, 0},
{498, 3201092813u, 3079358544u, 3198733264u, 0, EXPM1F_TOLERANCE, 0},
{499, 3201092813u, 3079358544u, 3198733264u, 0, EXPM1F_TOLERANCE, 0},
{500, 3201092813u, 3079358544u, 3198733264u, 0, EXPM1F_TOLERANCE, 0},
{501, 3201092813u, 3079358544u, 3198733264u, 0, EXPM1F_TOLERANCE, 0},
{502, 3201092813u, 3079358544u, 3198733264u, 0, EXPM1F_TOLERANCE, 0},
{503, 3201092813u, 3079358544u, 3198733264u, 0, EXPM1F_TOLERANCE, 0},
{504, 3201092813u, 3079358544u, 3198733264u, 0, EXPM1F_TOLERANCE, 0},
{505, 3201092813u, 3079358544u, 3198733264u, 0, EXPM1F_TOLERANCE, 0},
{506, 3201092813u, 3079358544u, 3198733264u, 0, EXPM1F_TOLERANCE, 0},
{507, 3201092813u, 3079358544u, 3198733264u, 0, EXPM1F_TOLERANCE, 0},
{508, 3201092813u, 3079358544u, 3198733264u, 0, EXPM1F_TOLERANCE, 0},
{509, 3201092813u, 3079358544u, 3198733264u, 0, EXPM1F_TOLERANCE, 0},
{510, 3201092813u, 3079358544u, 3198733264u, 0, EXPM1F_TOLERANCE, 0},
{511, 3201092813u, 3079358544u, 3198733264u, 0, EXPM1F_TOLERANCE, 0},
{512, 3201092813u, 3079358544u, 3198733264u, 0, EXPM1F_TOLERANCE, 0},
{513, 3201092813u, 3079358544u, 3198733264u, 0, EXPM1F_TOLERANCE, 0},
{514, 3201092813u, 3079358544u, 3198733264u, 0, EXPM1F_TOLERANCE, 0},
{515, 3201092813u, 3079358544u, 3198733264u, 0, EXPM1F_TOLERANCE, 0},
{516, 3201092813u, 3079358544u, 3198733264u, 0, EXPM1F_TOLERANCE, 0},
{517, 3201092813u, 3079358544u, 3198733264u, 0, EXPM1F_TOLERANCE, 0},
{518, 3201092813u, 3079358544u, 3198733264u, 0, EXPM1F_TOLERANCE, 0},
{519, 3201092813u, 3079358544u, 3198733264u, 0, EXPM1F_TOLERANCE, 0},
{520, 3199415091u, 3079358544u, 3197580063u, 0, EXPM1F_TOLERANCE, 0},
{521, 3199415091u, 3079358544u, 3197580063u, 0, EXPM1F_TOLERANCE, 0},
{522, 3199415091u, 3079358544u, 3197580063u, 0, EXPM1F_TOLERANCE, 0},
{523, 3199415091u, 3079358544u, 3197580063u, 0, EXPM1F_TOLERANCE, 0},
{524, 3199415091u, 3079358544u, 3197580063u, 0, EXPM1F_TOLERANCE, 0},
{525, 3199415091u, 3079358544u, 3197580063u, 0, EXPM1F_TOLERANCE, 0},
{526, 3199415091u, 3079358544u, 3197580063u, 0, EXPM1F_TOLERANCE, 0},
{527, 3199415091u, 3079358544u, 3197580063u, 0, EXPM1F_TOLERANCE, 0},
{528, 3199415091u, 3079358544u, 3197580063u, 0, EXPM1F_TOLERANCE, 0},
{529, 3199415091u, 3079358544u, 3197580063u, 0, EXPM1F_TOLERANCE, 0},
{530, 3199415091u, 3079358544u, 3197580063u, 0, EXPM1F_TOLERANCE, 0},
{531, 3199415091u, 3079358544u, 3197580063u, 0, EXPM1F_TOLERANCE, 0},
{532, 3199415091u, 3079358544u, 3197580063u, 0, EXPM1F_TOLERANCE, 0},
{533, 3199415091u, 3079358544u, 3197580063u, 0, EXPM1F_TOLERANCE, 0},
{534, 3199415091u, 3079358544u, 3197580063u, 0, EXPM1F_TOLERANCE, 0},
{535, 3199415091u, 3079358544u, 3197580063u, 0, EXPM1F_TOLERANCE, 0},
{536, 3199415091u, 3079358544u, 3197580063u, 0, EXPM1F_TOLERANCE, 0},
{537, 3199415091u, 3079358544u, 3197580063u, 0, EXPM1F_TOLERANCE, 0},
{538, 3199415091u, 3079358544u, 3197580063u, 0, EXPM1F_TOLERANCE, 0},
{539, 3199415091u, 3079358544u, 3197580063u, 0, EXPM1F_TOLERANCE, 0},
{540, 3199415091u, 3079358544u, 3197580063u, 0, EXPM1F_TOLERANCE, 0},
{541, 3199415091u, 3079358544u, 3197580063u, 0, EXPM1F_TOLERANCE, 0},
{542, 3199415091u, 3079358544u, 3197580063u, 0, EXPM1F_TOLERANCE, 0},
{543, 3199415091u, 3079358544u, 3197580063u, 0, EXPM1F_TOLERANCE, 0},
{544, 3199415091u, 3079358544u, 3197580063u, 0, EXPM1F_TOLERANCE, 0},
{545, 3199415091u, 3079358544u, 3197580063u, 0, EXPM1F_TOLERANCE, 0},
{546, 3199415091u, 3079358544u, 3197580063u, 0, EXPM1F_TOLERANCE, 0},
{547, 3199415091u, 3079358544u, 3197580063u, 0, EXPM1F_TOLERANCE, 0},
{548, 3199415091u, 3079358544u, 3197580063u, 0, EXPM1F_TOLERANCE, 0},
{549, 3199415091u, 3079358544u, 3197580063u, 0, EXPM1F_TOLERANCE, 0},
{550, 3199415091u, 3079358544u, 3197580063u, 0, EXPM1F_TOLERANCE, 0},
{551, 3199415091u, 3079358544u, 3197580063u, 0, EXPM1F_TOLERANCE, 0},
{552, 3199415091u, 3079358544u, 3197580063u, 0, EXPM1F_TOLERANCE, 0},
{553, 3199415091u, 3079358544u, 3197580063u, 0, EXPM1F_TOLERANCE, 0},
{554, 3199415091u, 3079358544u, 3197580063u, 0, EXPM1F_TOLERANCE, 0},
{555, 3199415091u, 3079358544u, 3197580063u, 0, EXPM1F_TOLERANCE, 0},
{556, 3199415091u, 3079358544u, 3197580063u, 0, EXPM1F_TOLERANCE, 0},
{557, 3199415091u, 3079358544u, 3197580063u, 0, EXPM1F_TOLERANCE, 0},
{558, 3199415091u, 3079358544u, 3197580063u, 0, EXPM1F_TOLERANCE, 0},
{559, 3199415091u, 3079358544u, 3197580063u, 0, EXPM1F_TOLERANCE, 0},
{560, 3197737370u, 3079358544u, 3196367738u, 0, EXPM1F_TOLERANCE, 0},
{561, 3197737370u, 3079358544u, 3196367738u, 0, EXPM1F_TOLERANCE, 0},
{562, 3197737370u, 3079358544u, 3196367738u, 0, EXPM1F_TOLERANCE, 0},
{563, 3197737370u, 3079358544u, 3196367738u, 0, EXPM1F_TOLERANCE, 0},
{564, 3197737370u, 3079358544u, 3196367738u, 0, EXPM1F_TOLERANCE, 0},
{565, 3197737370u, 3079358544u, 3196367738u, 0, EXPM1F_TOLERANCE, 0},
{566, 3197737370u, 3079358544u, 3196367738u, 0, EXPM1F_TOLERANCE, 0},
{567, 3197737370u, 3079358544u, 3196367738u, 0, EXPM1F_TOLERANCE, 0},
{568, 3197737370u, 3079358544u, 3196367738u, 0, EXPM1F_TOLERANCE, 0},
{569, 3197737370u, 3079358544u, 3196367738u, 0, EXPM1F_TOLERANCE, 0},
{570, 3197737370u, 3079358544u, 3196367738u, 0, EXPM1F_TOLERANCE, 0},
{571, 3197737370u, 3079358544u, 3196367738u, 0, EXPM1F_TOLERANCE, 0},
{572, 3197737370u, 3079358544u, 3196367738u, 0, EXPM1F_TOLERANCE, 0},
{573, 3197737370u, 3079358544u, 3196367738u, 0, EXPM1F_TOLERANCE, 0},
{574, 3197737370u, 3079358544u, 3196367738u, 0, EXPM1F_TOLERANCE, 0},
{575, 3197737370u, 3079358544u, 3196367738u, 0, EXPM1F_TOLERANCE, 0},
{576, 3197737370u, 3079358544u, 3196367738u, 0, EXPM1F_TOLERANCE, 0},
{577, 3197737370u, 3079358544u, 3196367738u, 0, EXPM1F_TOLERANCE, 0},
{578, 3197737370u, 3079358544u, 3196367738u, 0, EXPM1F_TOLERANCE, 0},
{579, 3197737370u, 3079358544u, 3196367738u, 0, EXPM1F_TOLERANCE, 0},
{580, 3197737370u, 3079358544u, 3196367738u, 0, EXPM1F_TOLERANCE, 0},
{581, 3197737370u, 3079358544u, 3196367738u, 0, EXPM1F_TOLERANCE, 0},
{582, 3197737370u, 3079358544u, 3196367738u, 0, EXPM1F_TOLERANCE, 0},
{583, 3197737370u, 3079358544u, 3196367738u, 0, EXPM1F_TOLERANCE, 0},
{584, 3197737370u, 3079358544u, 3196367738u, 0, EXPM1F_TOLERANCE, 0},
{585, 3197737370u, 3079358544u, 3196367738u, 0, EXPM1F_TOLERANCE, 0},
{586, 3197737370u, 3079358544u, 3196367738u, 0, EXPM1F_TOLERANCE, 0},
{587, 3197737370u, 3079358544u, 3196367738u, 0, EXPM1F_TOLERANCE, 0},
{588, 3197737370u, 3079358544u, 3196367738u, 0, EXPM1F_TOLERANCE, 0},
{589, 3197737370u, 3079358544u, 3196367738u, 0, EXPM1F_TOLERANCE, 0},
{590, 3197737370u, 3079358544u, 3196367738u, 0, EXPM1F_TOLERANCE, 0},
{591, 3197737370u, 3079358544u, 3196367738u, 0, EXPM1F_TOLERANCE, 0},
{592, 3197737370u, 3079358544u, 3196367738u, 0, EXPM1F_TOLERANCE, 0},
{593, 3197737370u, 3079358544u, 3196367738u, 0, EXPM1F_TOLERANCE, 0},
{594, 3197737370u, 3079358544u, 3196367738u, 0, EXPM1F_TOLERANCE, 0},
{595, 3197737370u, 3079358544u, 3196367738u, 0, EXPM1F_TOLERANCE, 0},
{596, 3197737370u, 3079358544u, 3196367738u, 0, EXPM1F_TOLERANCE, 0},
{597, 3197737370u, 3079358544u, 3196367738u, 0, EXPM1F_TOLERANCE, 0},
{598, 3197737370u, 3079358544u, 3196367738u, 0, EXPM1F_TOLERANCE, 0},
{599, 3197737370u, 3079358544u, 3196367738u, 0, EXPM1F_TOLERANCE, 0},
{600, 3196059648u, 3079358544u, 3194126860u, 0, EXPM1F_TOLERANCE, 0},
{601, 3196059648u, 3079358544u, 3194126860u, 0, EXPM1F_TOLERANCE, 0},
{602, 3196059648u, 3079358544u, 3194126860u, 0, EXPM1F_TOLERANCE, 0},
{603, 3196059648u, 3079358544u, 3194126860u, 0, EXPM1F_TOLERANCE, 0},
{604, 3196059648u, 3079358544u, 3194126860u, 0, EXPM1F_TOLERANCE, 0},
{605, 3196059648u, 3079358544u, 3194126860u, 0, EXPM1F_TOLERANCE, 0},
{606, 3196059648u, 3079358544u, 3194126860u, 0, EXPM1F_TOLERANCE, 0},
{607, 3196059648u, 3079358544u, 3194126860u, 0, EXPM1F_TOLERANCE, 0},
{608, 3196059648u, 3079358544u, 3194126860u, 0, EXPM1F_TOLERANCE, 0},
{609, 3196059648u, 3079358544u, 3194126860u, 0, EXPM1F_TOLERANCE, 0},
{610, 3196059648u, 3079358544u, 3194126860u, 0, EXPM1F_TOLERANCE, 0},
{611, 3196059648u, 3079358544u, 3194126860u, 0, EXPM1F_TOLERANCE, 0},
{612, 3196059648u, 3079358544u, 3194126860u, 0, EXPM1F_TOLERANCE, 0},
{613, 3196059648u, 3079358544u, 3194126860u, 0, EXPM1F_TOLERANCE, 0},
{614, 3196059648u, 3079358544u, 3194126860u, 0, EXPM1F_TOLERANCE, 0},
{615, 3196059648u, 3079358544u, 3194126860u, 0, EXPM1F_TOLERANCE, 0},
{616, 3196059648u, 3079358544u, 3194126860u, 0, EXPM1F_TOLERANCE, 0},
{617, 3196059648u, 3079358544u, 3194126860u, 0, EXPM1F_TOLERANCE, 0},
{618, 3196059648u, 3079358544u, 3194126860u, 0, EXPM1F_TOLERANCE, 0},
{619, 3196059648u, 3079358544u, 3194126860u, 0, EXPM1F_TOLERANCE, 0},
{620, 3196059648u, 3079358544u, 3194126860u, 0, EXPM1F_TOLERANCE, 0},
{621, 3196059648u, 3079358544u, 3194126860u, 0, EXPM1F_TOLERANCE, 0},
{622, 3196059648u, 3079358544u, 3194126860u, 0, EXPM1F_TOLERANCE, 0},
{623, 3196059648u, 3079358544u, 3194126860u, 0, EXPM1F_TOLERANCE, 0},
{624, 3196059648u, 3079358544u, 3194126860u, 0, EXPM1F_TOLERANCE, 0},
{625, 3196059648u, 3079358544u, 3194126860u, 0, EXPM1F_TOLERANCE, 0},
{626, 3196059648u, 3079358544u, 3194126860u, 0, EXPM1F_TOLERANCE, 0},
{627, 3196059648u, 3079358544u, 3194126860u, 0, EXPM1F_TOLERANCE, 0},
{628, 3196059648u, 3079358544u, 3194126860u, 0, EXPM1F_TOLERANCE, 0},
{629, 3196059648u, 3079358544u, 3194126860u, 0, EXPM1F_TOLERANCE, 0},
{630, 3196059648u, 3079358544u, 3194126860u, 0, EXPM1F_TOLERANCE, 0},
{631, 3196059648u, 3079358544u, 3194126860u, 0, EXPM1F_TOLERANCE, 0},
{632, 3196059648u, 3079358544u, 3194126860u, 0, EXPM1F_TOLERANCE, 0},
{633, 3196059648u, 3079358544u, 3194126860u, 0, EXPM1F_TOLERANCE, 0},
{634, 3196059648u, 3079358544u, 3194126860u, 0, EXPM1F_TOLERANCE, 0},
{635, 3196059648u, 3079358544u, 3194126860u, 0, EXPM1F_TOLERANCE, 0},
{636, 3196059648u, 3079358544u, 3194126860u, 0, EXPM1F_TOLERANCE, 0},
{637, 3196059648u, 3079358544u, 3194126860u, 0, EXPM1F_TOLERANCE, 0},
{638, 3196059648u, 3079358544u, 3194126860u, 0, EXPM1F_TOLERANCE, 0},
{639, 3196059648u, 3079358544u, 3194126860u, 0, EXPM1F_TOLERANCE, 0},
{640, 3192704205u, 3079358544u, 3191447205u, 0, EXPM1F_TOLERANCE, 0},
{641, 3192704205u, 3079358544u, 3191447205u, 0, EXPM1F_TOLERANCE, 0},
{642, 3192704205u, 3079358544u, 3191447205u, 0, EXPM1F_TOLERANCE, 0},
{643, 3192704205u, 3079358544u, 3191447205u, 0, EXPM1F_TOLERANCE, 0},
{644, 3192704205u, 3079358544u, 3191447205u, 0, EXPM1F_TOLERANCE, 0},
{645, 3192704205u, 3079358544u, 3191447205u, 0, EXPM1F_TOLERANCE, 0},
{646, 3192704205u, 3079358544u, 3191447205u, 0, EXPM1F_TOLERANCE, 0},
{647, 3192704205u, 3079358544u, 3191447205u, 0, EXPM1F_TOLERANCE, 0},
{648, 3192704205u, 3079358544u, 3191447205u, 0, EXPM1F_TOLERANCE, 0},
{649, 3192704205u, 3079358544u, 3191447205u, 0, EXPM1F_TOLERANCE, 0},
{650, 3192704205u, 3079358544u, 3191447205u, 0, EXPM1F_TOLERANCE, 0},
{651, 3192704205u, 3079358544u, 3191447205u, 0, EXPM1F_TOLERANCE, 0},
{652, 3192704205u, 3079358544u, 3191447205u, 0, EXPM1F_TOLERANCE, 0},
{653, 3192704205u, 3079358544u, 3191447205u, 0, EXPM1F_TOLERANCE, 0},
{654, 3192704205u, 3079358544u, 3191447205u, 0, EXPM1F_TOLERANCE, 0},
{655, 3192704205u, 3079358544u, 3191447205u, 0, EXPM1F_TOLERANCE, 0},
{656, 3192704205u, 3079358544u, 3191447205u, 0, EXPM1F_TOLERANCE, 0},
{657, 3192704205u, 3079358544u, 3191447205u, 0, EXPM1F_TOLERANCE, 0},
{658, 3192704205u, 3079358544u, 3191447205u, 0, EXPM1F_TOLERANCE, 0},
{659, 3192704205u, 3079358544u, 3191447205u, 0, EXPM1F_TOLERANCE, 0},
{660, 3192704205u, 3079358544u, 3191447205u, 0, EXPM1F_TOLERANCE, 0},
{661, 3192704205u, 3079358544u, 3191447205u, 0, EXPM1F_TOLERANCE, 0},
{662, 3192704205u, 3079358544u, 3191447205u, 0, EXPM1F_TOLERANCE, 0},
{663, 3192704205u, 3079358544u, 3191447205u, 0, EXPM1F_TOLERANCE, 0},
{664, 3192704205u, 3079358544u, 3191447205u, 0, EXPM1F_TOLERANCE, 0},
{665, 3192704205u, 3079358544u, 3191447205u, 0, EXPM1F_TOLERANCE, 0},
{666, 3192704205u, 3079358544u, 3191447205u, 0, EXPM1F_TOLERANCE, 0},
{667, 3192704205u, 3079358544u, 3191447205u, 0, EXPM1F_TOLERANCE, 0},
{668, 3192704205u, 3079358544u, 3191447205u, 0, EXPM1F_TOLERANCE, 0},
{669, 3192704205u, 3079358544u, 3191447205u, 0, EXPM1F_TOLERANCE, 0},
{670, 3192704205u, 3079358544u, 3191447205u, 0, EXPM1F_TOLERANCE, 0},
{671, 3192704205u, 3079358544u, 3191447205u, 0, EXPM1F_TOLERANCE, 0},
{672, 3192704205u, 3079358544u, 3191447205u, 0, EXPM1F_TOLERANCE, 0},
{673, 3192704205u, 3079358544u, 3191447205u, 0, EXPM1F_TOLERANCE, 0},
{674, 3192704205u, 3079358544u, 3191447205u, 0, EXPM1F_TOLERANCE, 0},
{675, 3192704205u, 3079358544u, 3191447205u, 0, EXPM1F_TOLERANCE, 0},
{676, 3192704205u, 3079358544u, 3191447205u, 0, EXPM1F_TOLERANCE, 0},
{677, 3192704205u, 3079358544u, 3191447205u, 0, EXPM1F_TOLERANCE, 0},
{678, 3192704205u, 3079358544u, 3191447205u, 0, EXPM1F_TOLERANCE, 0},
{679, 3192704205u, 3079358544u, 3191447205u, 0, EXPM1F_TOLERANCE, 0},
{680, 3189348762u, 3079358544u, 3188630162u, 0, EXPM1F_TOLERANCE, 0},
{681, 3189348762u, 3079358544u, 3188630162u, 0, EXPM1F_TOLERANCE, 0},
{682, 3189348762u, 3079358544u, 3188630162u, 0, EXPM1F_TOLERANCE, 0},
{683, 3189348762u, 3079358544u, 3188630162u, 0, EXPM1F_TOLERANCE, 0},
{684, 3189348762u, 3079358544u, 3188630162u, 0, EXPM1F_TOLERANCE, 0},
{685, 3189348762u, 3079358544u, 3188630162u, 0, EXPM1F_TOLERANCE, 0},
{686, 3189348762u, 3079358544u, 3188630162u, 0, EXPM1F_TOLERANCE, 0},
{687, 3189348762u, 3079358544u, 3188630162u, 0, EXPM1F_TOLERANCE, 0},
{688, 3189348762u, 3079358544u, 3188630162u, 0, EXPM1F_TOLERANCE, 0},
{689, 3189348762u, 3079358544u, 3188630162u, 0, EXPM1F_TOLERANCE, 0},
{690, 3189348762u, 3079358544u, 3188630162u, 0, EXPM1F_TOLERANCE, 0},
{691, 3189348762u, 3079358544u, 3188630162u, 0, EXPM1F_TOLERANCE, 0},
{692, 3189348762u, 3079358544u, 3188630162u, 0, EXPM1F_TOLERANCE, 0},
{693, 3189348762u, 3079358544u, 3188630162u, 0, EXPM1F_TOLERANCE, 0},
{694, 3189348762u, 3079358544u, 3188630162u, 0, EXPM1F_TOLERANCE, 0},
{695, 3189348762u, 3079358544u, 3188630162u, 0, EXPM1F_TOLERANCE, 0},
{696, 3189348762u, 3079358544u, 3188630162u, 0, EXPM1F_TOLERANCE, 0},
{697, 3189348762u, 3079358544u, 3188630162u, 0, EXPM1F_TOLERANCE, 0},
{698, 3189348762u, 3079358544u, 3188630162u, 0, EXPM1F_TOLERANCE, 0},
{699, 3189348762u, 3079358544u, 3188630162u, 0, EXPM1F_TOLERANCE, 0},
{700, 3189348762u, 3079358544u, 3188630162u, 0, EXPM1F_TOLERANCE, 0},
{701, 3189348762u, 3079358544u, 3188630162u, 0, EXPM1F_TOLERANCE, 0},
{702, 3189348762u, 3079358544u, 3188630162u, 0, EXPM1F_TOLERANCE, 0},
{703, 3189348762u, 3079358544u, 3188630162u, 0, EXPM1F_TOLERANCE, 0},
{704, 3189348762u, 3079358544u, 3188630162u, 0, EXPM1F_TOLERANCE, 0},
{705, 3189348762u, 3079358544u, 3188630162u, 0, EXPM1F_TOLERANCE, 0},
{706, 3189348762u, 3079358544u, 3188630162u, 0, EXPM1F_TOLERANCE, 0},
{707, 3189348762u, 3079358544u, 3188630162u, 0, EXPM1F_TOLERANCE, 0},
{708, 3189348762u, 3079358544u, 3188630162u, 0, EXPM1F_TOLERANCE, 0},
{709, 3189348762u, 3079358544u, 3188630162u, 0, EXPM1F_TOLERANCE, 0},
{710, 3189348762u, 3079358544u, 3188630162u, 0, EXPM1F_TOLERANCE, 0},
{711, 3189348762u, 3079358544u, 3188630162u, 0, EXPM1F_TOLERANCE, 0},
{712, 3189348762u, 3079358544u, 3188630162u, 0, EXPM1F_TOLERANCE, 0},
{713, 3189348762u, 3079358544u, 3188630162u, 0, EXPM1F_TOLERANCE, 0},
{714, 3189348762u, 3079358544u, 3188630162u, 0, EXPM1F_TOLERANCE, 0},
{715, 3189348762u, 3079358544u, 3188630162u, 0, EXPM1F_TOLERANCE, 0},
{716, 3189348762u, 3079358544u, 3188630162u, 0, EXPM1F_TOLERANCE, 0},
{717, 3189348762u, 3079358544u, 3188630162u, 0, EXPM1F_TOLERANCE, 0},
{718, 3189348762u, 3079358544u, 3188630162u, 0, EXPM1F_TOLERANCE, 0},
{719, 3189348762u, 3079358544u, 3188630162u, 0, EXPM1F_TOLERANCE, 0},
{720, 3184315597u, 3079358544u, 3183666330u, 0, EXPM1F_TOLERANCE, 0},
{721, 3184315597u, 3079358544u, 3183666330u, 0, EXPM1F_TOLERANCE, 0},
{722, 3184315597u, 3079358544u, 3183666330u, 0, EXPM1F_TOLERANCE, 0},
{723, 3184315597u, 3079358544u, 3183666330u, 0, EXPM1F_TOLERANCE, 0},
{724, 3184315597u, 3079358544u, 3183666330u, 0, EXPM1F_TOLERANCE, 0},
{725, 3184315597u, 3079358544u, 3183666330u, 0, EXPM1F_TOLERANCE, 0},
{726, 3184315597u, 3079358544u, 3183666330u, 0, EXPM1F_TOLERANCE, 0},
{727, 3184315597u, 3079358544u, 3183666330u, 0, EXPM1F_TOLERANCE, 0},
{728, 3184315597u, 3079358544u, 3183666330u, 0, EXPM1F_TOLERANCE, 0},
{729, 3184315597u, 3079358544u, 3183666330u, 0, EXPM1F_TOLERANCE, 0},
{730, 3184315597u, 3079358544u, 3183666330u, 0, EXPM1F_TOLERANCE, 0},
{731, 3184315597u, 3079358544u, 3183666330u, 0, EXPM1F_TOLERANCE, 0},
{732, 3184315597u, 3079358544u, 3183666330u, 0, EXPM1F_TOLERANCE, 0},
{733, 3184315597u, 3079358544u, 3183666330u, 0, EXPM1F_TOLERANCE, 0},
{734, 3184315597u, 3079358544u, 3183666330u, 0, EXPM1F_TOLERANCE, 0},
{735, 3184315597u, 3079358544u, 3183666330u, 0, EXPM1F_TOLERANCE, 0},
{736, 3184315597u, 3079358544u, 3183666330u, 0, EXPM1F_TOLERANCE, 0},
{737, 3184315597u, 3079358544u, 3183666330u, 0, EXPM1F_TOLERANCE, 0},
{738, 3184315597u, 3079358544u, 3183666330u, 0, EXPM1F_TOLERANCE, 0},
{739, 3184315597u, 3079358544u, 3183666330u, 0, EXPM1F_TOLERANCE, 0},
{740, 3184315597u, 3079358544u, 3183666330u, 0, EXPM1F_TOLERANCE, 0},
{741, 3184315597u, 3079358544u, 3183666330u, 0, EXPM1F_TOLERANCE, 0},
{742, 3184315597u, 3079358544u, 3183666330u, 0, EXPM1F_TOLERANCE, 0},
{743, 3184315597u, 3079358544u, 3183666330u, 0, EXPM1F_TOLERANCE, 0},
{744, 3184315597u, 3079358544u, 3183666330u, 0, EXPM1F_TOLERANCE, 0},
{745, 3184315597u, 3079358544u, 3183666330u, 0, EXPM1F_TOLERANCE, 0},
{746, 3184315597u, 3079358544u, 3183666330u, 0, EXPM1F_TOLERANCE, 0},
{747, 3184315597u, 3079358544u, 3183666330u, 0, EXPM1F_TOLERANCE, 0},
{748, 3184315597u, 3079358544u, 3183666330u, 0, EXPM1F_TOLERANCE, 0},
{749, 3184315597u, 3079358544u, 3183666330u, 0, EXPM1F_TOLERANCE, 0},
{750, 3184315597u, 3079358544u, 3183666330u, 0, EXPM1F_TOLERANCE, 0},
{751, 3184315597u, 3079358544u, 3183666330u, 0, EXPM1F_TOLERANCE, 0},
{752, 3184315597u, 3079358544u, 3183666330u, 0, EXPM1F_TOLERANCE, 0},
{753, 3184315597u, 3079358544u, 3183666330u, 0, EXPM1F_TOLERANCE, 0},
{754, 3184315597u, 3079358544u, 3183666330u, 0, EXPM1F_TOLERANCE, 0},
{755, 3184315597u, 3079358544u, 3183666330u, 0, EXPM1F_TOLERANCE, 0},
{756, 3184315597u, 3079358544u, 3183666330u, 0, EXPM1F_TOLERANCE, 0},
{757, 3184315597u, 3079358544u, 3183666330u, 0, EXPM1F_TOLERANCE, 0},
{758, 3184315597u, 3079358544u, 3183666330u, 0, EXPM1F_TOLERANCE, 0},
{759, 3184315597u, 3079358544u, 3183666330u, 0, EXPM1F_TOLERANCE, 0},
{760, 3175926989u, 3079358544u, 3175596968u, 0, EXPM1F_TOLERANCE, 0},
{761, 3175926989u, 3079358544u, 3175596968u, 0, EXPM1F_TOLERANCE, 0},
{762, 3175926989u, 3079358544u, 3175596968u, 0, EXPM1F_TOLERANCE, 0},
{763, 3175926989u, 3079358544u, 3175596968u, 0, EXPM1F_TOLERANCE, 0},
{764, 3175926989u, 3079358544u, 3175596968u, 0, EXPM1F_TOLERANCE, 0},
{765, 3175926989u, 3079358544u, 3175596968u, 0, EXPM1F_TOLERANCE, 0},
{766, 3175926989u, 3079358544u, 3175596968u, 0, EXPM1F_TOLERANCE, 0},
{767, 3175926989u, 3079358544u, 3175596968u, 0, EXPM1F_TOLERANCE, 0},
{768, 3175926989u, 3079358544u, 3175596968u, 0, EXPM1F_TOLERANCE, 0},
{769, 3175926989u, 3079358544u, 3175596968u, 0, EXPM1F_TOLERANCE, 0},
{770, 3175926989u, 3079358544u, 3175596968u, 0, EXPM1F_TOLERANCE, 0},
{771, 3175926989u, 3079358544u, 3175596968u, 0, EXPM1F_TOLERANCE, 0},
{772, 3175926989u, 3079358544u, 3175596968u, 0, EXPM1F_TOLERANCE, 0},
{773, 3175926989u, 3079358544u, 3175596968u, 0, EXPM1F_TOLERANCE, 0},
{774, 3175926989u, 3079358544u, 3175596968u, 0, EXPM1F_TOLERANCE, 0},
{775, 3175926989u, 3079358544u, 3175596968u, 0, EXPM1F_TOLERANCE, 0},
{776, 3175926989u, 3079358544u, 3175596968u, 0, EXPM1F_TOLERANCE, 0},
{777, 3175926989u, 3079358544u, 3175596968u, 0, EXPM1F_TOLERANCE, 0},
{778, 3175926989u, 3079358544u, 3175596968u, 0, EXPM1F_TOLERANCE, 0},
{779, 3175926989u, 3079358544u, 3175596968u, 0, EXPM1F_TOLERANCE, 0},
{780, 3175926989u, 3079358544u, 3175596968u, 0, EXPM1F_TOLERANCE, 0},
{781, 3175926989u, 3079358544u, 3175596968u, 0, EXPM1F_TOLERANCE, 0},
{782, 3175926989u, 3079358544u, 3175596968u, 0, EXPM1F_TOLERANCE, 0},
{783, 3175926989u, 3079358544u, 3175596968u, 0, EXPM1F_TOLERANCE, 0},
{784, 3175926989u, 3079358544u, 3175596968u, 0, EXPM1F_TOLERANCE, 0},
{785, 3175926989u, 3079358544u, 3175596968u, 0, EXPM1F_TOLERANCE, 0},
{786, 3175926989u, 3079358544u, 3175596968u, 0, EXPM1F_TOLERANCE, 0},
{787, 3175926989u, 3079358544u, 3175596968u, 0, EXPM1F_TOLERANCE, 0},
{788, 3175926989u, 3079358544u, 3175596968u, 0, EXPM1F_TOLERANCE, 0},
{789, 3175926989u, 3079358544u, 3175596968u, 0, EXPM1F_TOLERANCE, 0},
{790, 3175926989u, 3079358544u, 3175596968u, 0, EXPM1F_TOLERANCE, 0},
{791, 3175926989u, 3079358544u, 3175596968u, 0, EXPM1F_TOLERANCE, 0},
{792, 3175926989u, 3079358544u, 3175596968u, 0, EXPM1F_TOLERANCE, 0},
{793, 3175926989u, 3079358544u, 3175596968u, 0, EXPM1F_TOLERANCE, 0},
{794, 3175926989u, 3079358544u, 3175596968u, 0, EXPM1F_TOLERANCE, 0},
{795, 3175926989u, 3079358544u, 3175596968u, 0, EXPM1F_TOLERANCE, 0},
{796, 3175926989u, 3079358544u, 3175596968u, 0, EXPM1F_TOLERANCE, 0},
{797, 3175926989u, 3079358544u, 3175596968u, 0, EXPM1F_TOLERANCE, 0},
{798, 3175926989u, 3079358544u, 3175596968u, 0, EXPM1F_TOLERANCE, 0},
{799, 3175926989u, 3079358544u, 3175596968u, 0, EXPM1F_TOLERANCE, 0},
{800, 632815616u, 3079358544u, 632815616u, 0, EXPM1F_TOLERANCE, 0},
{801, 632815616u, 3079358544u, 632815616u, 0, EXPM1F_TOLERANCE, 0},
{802, 632815616u, 3079358544u, 632815616u, 0, EXPM1F_TOLERANCE, 0},
{803, 632815616u, 3079358544u, 632815616u, 0, EXPM1F_TOLERANCE, 0},
{804, 632815616u, 3079358544u, 632815616u, 0, EXPM1F_TOLERANCE, 0},
{805, 632815616u, 3079358544u, 632815616u, 0, EXPM1F_TOLERANCE, 0},
{806, 632815616u, 3079358544u, 632815616u, 0, EXPM1F_TOLERANCE, 0},
{807, 632815616u, 3079358544u, 632815616u, 0, EXPM1F_TOLERANCE, 0},
{808, 632815616u, 3079358544u, 632815616u, 0, EXPM1F_TOLERANCE, 0},
{809, 632815616u, 3079358544u, 632815616u, 0, EXPM1F_TOLERANCE, 0},
{810, 632815616u, 3079358544u, 632815616u, 0, EXPM1F_TOLERANCE, 0},
{811, 632815616u, 3079358544u, 632815616u, 0, EXPM1F_TOLERANCE, 0},
{812, 632815616u, 3079358544u, 632815616u, 0, EXPM1F_TOLERANCE, 0},
{813, 632815616u, 3079358544u, 632815616u, 0, EXPM1F_TOLERANCE, 0},
{814, 632815616u, 3079358544u, 632815616u, 0, EXPM1F_TOLERANCE, 0},
{815, 632815616u, 3079358544u, 632815616u, 0, EXPM1F_TOLERANCE, 0},
{816, 632815616u, 3079358544u, 632815616u, 0, EXPM1F_TOLERANCE, 0},
{817, 632815616u, 3079358544u, 632815616u, 0, EXPM1F_TOLERANCE, 0},
{818, 632815616u, 3079358544u, 632815616u, 0, EXPM1F_TOLERANCE, 0},
{819, 632815616u, 3079358544u, 632815616u, 0, EXPM1F_TOLERANCE, 0},
{820, 632815616u, 3079358544u, 632815616u, 0, EXPM1F_TOLERANCE, 0},
{821, 632815616u, 3079358544u, 632815616u, 0, EXPM1F_TOLERANCE, 0},
{822, 632815616u, 3079358544u, 632815616u, 0, EXPM1F_TOLERANCE, 0},
{823, 632815616u, 3079358544u, 632815616u, 0, EXPM1F_TOLERANCE, 0},
{824, 632815616u, 3079358544u, 632815616u, 0, EXPM1F_TOLERANCE, 0},
{825, 632815616u, 3079358544u, 632815616u, 0, EXPM1F_TOLERANCE, 0},
{826, 632815616u, 3079358544u, 632815616u, 0, EXPM1F_TOLERANCE, 0},
{827, 632815616u, 3079358544u, 632815616u, 0, EXPM1F_TOLERANCE, 0},
{828, 632815616u, 3079358544u, 632815616u, 0, EXPM1F_TOLERANCE, 0},
{829, 632815616u, 3079358544u, 632815616u, 0, EXPM1F_TOLERANCE, 0},
{830, 632815616u, 3079358544u, 632815616u, 0, EXPM1F_TOLERANCE, 0},
{831, 632815616u, 3079358544u, 632815616u, 0, EXPM1F_TOLERANCE, 0},
{832, 632815616u, 3079358544u, 632815616u, 0, EXPM1F_TOLERANCE, 0},
{833, 632815616u, 3079358544u, 632815616u, 0, EXPM1F_TOLERANCE, 0},
{834, 632815616u, 3079358544u, 632815616u, 0, EXPM1F_TOLERANCE, 0},
{835, 632815616u, 3079358544u, 632815616u, 0, EXPM1F_TOLERANCE, 0},
{836, 632815616u, 3079358544u, 632815616u, 0, EXPM1F_TOLERANCE, 0},
{837, 632815616u, 3079358544u, 632815616u, 0, EXPM1F_TOLERANCE, 0},
{838, 632815616u, 3079358544u, 632815616u, 0, EXPM1F_TOLERANCE, 0},
{839, 632815616u, 3079358544u, 632815616u, 0, EXPM1F_TOLERANCE, 0},
{840, 1028443341u, 3079358544u, 1028784548u, 0, EXPM1F_TOLERANCE, 0},
{841, 1028443341u, 3079358544u, 1028784548u, 0, EXPM1F_TOLERANCE, 0},
{842, 1028443341u, 3079358544u, 1028784548u, 0, EXPM1F_TOLERANCE, 0},
{843, 1028443341u, 3079358544u, 1028784548u, 0, EXPM1F_TOLERANCE, 0},
{844, 1028443341u, 3079358544u, 1028784548u, 0, EXPM1F_TOLERANCE, 0},
{845, 1028443341u, 3079358544u, 1028784548u, 0, EXPM1F_TOLERANCE, 0},
{846, 1028443341u, 3079358544u, 1028784548u, 0, EXPM1F_TOLERANCE, 0},
{847, 1028443341u, 3079358544u, 1028784548u, 0, EXPM1F_TOLERANCE, 0},
{848, 1028443341u, 3079358544u, 1028784548u, 0, EXPM1F_TOLERANCE, 0},
{849, 1028443341u, 3079358544u, 1028784548u, 0, EXPM1F_TOLERANCE, 0},
{850, 1028443341u, 3079358544u, 1028784548u, 0, EXPM1F_TOLERANCE, 0},
{851, 1028443341u, 3079358544u, 1028784548u, 0, EXPM1F_TOLERANCE, 0},
{852, 1028443341u, 3079358544u, 1028784548u, 0, EXPM1F_TOLERANCE, 0},
{853, 1028443341u, 3079358544u, 1028784548u, 0, EXPM1F_TOLERANCE, 0},
{854, 1028443341u, 3079358544u, 1028784548u, 0, EXPM1F_TOLERANCE, 0},
{855, 1028443341u, 3079358544u, 1028784548u, 0, EXPM1F_TOLERANCE, 0},
{856, 1028443341u, 3079358544u, 1028784548u, 0, EXPM1F_TOLERANCE, 0},
{857, 1028443341u, 3079358544u, 1028784548u, 0, EXPM1F_TOLERANCE, 0},
{858, 1028443341u, 3079358544u, 1028784548u, 0, EXPM1F_TOLERANCE, 0},
{859, 1028443341u, 3079358544u, 1028784548u, 0, EXPM1F_TOLERANCE, 0},
{860, 1028443341u, 3079358544u, 1028784548u, 0, EXPM1F_TOLERANCE, 0},
{861, 1028443341u, 3079358544u, 1028784548u, 0, EXPM1F_TOLERANCE, 0},
{862, 1028443341u, 3079358544u, 1028784548u, 0, EXPM1F_TOLERANCE, 0},
{863, 1028443341u, 3079358544u, 1028784548u, 0, EXPM1F_TOLERANCE, 0},
{864, 1028443341u, 3079358544u, 1028784548u, 0, EXPM1F_TOLERANCE, 0},
{865, 1028443341u, 3079358544u, 1028784548u, 0, EXPM1F_TOLERANCE, 0},
{866, 1028443341u, 3079358544u, 1028784548u, 0, EXPM1F_TOLERANCE, 0},
{867, 1028443341u, 3079358544u, 1028784548u, 0, EXPM1F_TOLERANCE, 0},
{868, 1028443341u, 3079358544u, 1028784548u, 0, EXPM1F_TOLERANCE, 0},
{869, 1028443341u, 3079358544u, 1028784548u, 0, EXPM1F_TOLERANCE, 0},
{870, 1028443341u, 3079358544u, 1028784548u, 0, EXPM1F_TOLERANCE, 0},
{871, 1028443341u, 3079358544u, 1028784548u, 0, EXPM1F_TOLERANCE, 0},
{872, 1028443341u, 3079358544u, 1028784548u, 0, EXPM1F_TOLERANCE, 0},
{873, 1028443341u, 3079358544u, 1028784548u, 0, EXPM1F_TOLERANCE, 0},
{874, 1028443341u, 3079358544u, 1028784548u, 0, EXPM1F_TOLERANCE, 0},
{875, 1028443341u, 3079358544u, 1028784548u, 0, EXPM1F_TOLERANCE, 0},
{876, 1028443341u, 3079358544u, 1028784548u, 0, EXPM1F_TOLERANCE, 0},
{877, 1028443341u, 3079358544u, 1028784548u, 0, EXPM1F_TOLERANCE, 0},
{878, 1028443341u, 3079358544u, 1028784548u, 0, EXPM1F_TOLERANCE, 0},
{879, 1028443341u, 3079358544u, 1028784548u, 0, EXPM1F_TOLERANCE, 0},
{880, 1036831949u, 3079358544u, 1037525978u, 0, EXPM1F_TOLERANCE, 0},
{881, 1036831949u, 3079358544u, 1037525978u, 0, EXPM1F_TOLERANCE, 0},
{882, 1036831949u, 3079358544u, 1037525978u, 0, EXPM1F_TOLERANCE, 0},
{883, 1036831949u, 3079358544u, 1037525978u, 0, EXPM1F_TOLERANCE, 0},
{884, 1036831949u, 3079358544u, 1037525978u, 0, EXPM1F_TOLERANCE, 0},
{885, 1036831949u, 3079358544u, 1037525978u, 0, EXPM1F_TOLERANCE, 0},
{886, 1036831949u, 3079358544u, 1037525978u, 0, EXPM1F_TOLERANCE, 0},
{887, 1036831949u, 3079358544u, 1037525978u, 0, EXPM1F_TOLERANCE, 0},
{888, 1036831949u, 3079358544u, 1037525978u, 0, EXPM1F_TOLERANCE, 0},
{889, 1036831949u, 3079358544u, 1037525978u, 0, EXPM1F_TOLERANCE, 0},
{890, 1036831949u, 3079358544u, 1037525978u, 0, EXPM1F_TOLERANCE, 0},
{891, 1036831949u, 3079358544u, 1037525978u, 0, EXPM1F_TOLERANCE, 0},
{892, 1036831949u, 3079358544u, 1037525978u, 0, EXPM1F_TOLERANCE, 0},
{893, 1036831949u, 3079358544u, 1037525978u, 0, EXPM1F_TOLERANCE, 0},
{894, 1036831949u, 3079358544u, 1037525978u, 0, EXPM1F_TOLERANCE, 0},
{895, 1036831949u, 3079358544u, 1037525978u, 0, EXPM1F_TOLERANCE, 0},
{896, 1036831949u, 3079358544u, 1037525978u, 0, EXPM1F_TOLERANCE, 0},
{897, 1036831949u, 3079358544u, 1037525978u, 0, EXPM1F_TOLERANCE, 0},
{898, 1036831949u, 3079358544u, 1037525978u, 0, EXPM1F_TOLERANCE, 0},
{899, 1036831949u, 3079358544u, 1037525978u, 0, EXPM1F_TOLERANCE, 0},
{900, 1036831949u, 3079358544u, 1037525978u, 0, EXPM1F_TOLERANCE, 0},
{901, 1036831949u, 3079358544u, 1037525978u, 0, EXPM1F_TOLERANCE, 0},
{902, 1036831949u, 3079358544u, 1037525978u, 0, EXPM1F_TOLERANCE, 0},
{903, 1036831949u, 3079358544u, 1037525978u, 0, EXPM1F_TOLERANCE, 0},
{904, 1036831949u, 3079358544u, 1037525978u, 0, EXPM1F_TOLERANCE, 0},
{905, 1036831949u, 3079358544u, 1037525978u, 0, EXPM1F_TOLERANCE, 0},
{906, 1036831949u, 3079358544u, 1037525978u, 0, EXPM1F_TOLERANCE, 0},
{907, 1036831949u, 3079358544u, 1037525978u, 0, EXPM1F_TOLERANCE, 0},
{908, 1036831949u, 3079358544u, 1037525978u, 0, EXPM1F_TOLERANCE, 0},
{909, 1036831949u, 3079358544u, 1037525978u, 0, EXPM1F_TOLERANCE, 0},
{910, 1036831949u, 3079358544u, 1037525978u, 0, EXPM1F_TOLERANCE, 0},
{911, 1036831949u, 3079358544u, 1037525978u, 0, EXPM1F_TOLERANCE, 0},
{912, 1036831949u, 3079358544u, 1037525978u, 0, EXPM1F_TOLERANCE, 0},
{913, 1036831949u, 3079358544u, 1037525978u, 0, EXPM1F_TOLERANCE, 0},
{914, 1036831949u, 3079358544u, 1037525978u, 0, EXPM1F_TOLERANCE, 0},
{915, 1036831949u, 3079358544u, 1037525978u, 0, EXPM1F_TOLERANCE, 0},
{916, 1036831949u, 3079358544u, 1037525978u, 0, EXPM1F_TOLERANCE, 0},
{917, 1036831949u, 3079358544u, 1037525978u, 0, EXPM1F_TOLERANCE, 0},
{918, 1036831949u, 3079358544u, 1037525978u, 0, EXPM1F_TOLERANCE, 0},
{919, 1036831949u, 3079358544u, 1037525978u, 0, EXPM1F_TOLERANCE, 0},
{920, 1041865114u, 3079358544u, 1042659297u, 0, EXPM1F_TOLERANCE, 0},
{921, 1041865114u, 3079358544u, 1042659297u, 0, EXPM1F_TOLERANCE, 0},
{922, 1041865114u, 3079358544u, 1042659297u, 0, EXPM1F_TOLERANCE, 0},
{923, 1041865114u, 3079358544u, 1042659297u, 0, EXPM1F_TOLERANCE, 0},
{924, 1041865114u, 3079358544u, 1042659297u, 0, EXPM1F_TOLERANCE, 0},
{925, 1041865114u, 3079358544u, 1042659297u, 0, EXPM1F_TOLERANCE, 0},
{926, 1041865114u, 3079358544u, 1042659297u, 0, EXPM1F_TOLERANCE, 0},
{927, 1041865114u, 3079358544u, 1042659297u, 0, EXPM1F_TOLERANCE, 0},
{928, 1041865114u, 3079358544u, 1042659297u, 0, EXPM1F_TOLERANCE, 0},
{929, 1041865114u, 3079358544u, 1042659297u, 0, EXPM1F_TOLERANCE, 0},
{930, 1041865114u, 3079358544u, 1042659297u, 0, EXPM1F_TOLERANCE, 0},
{931, 1041865114u, 3079358544u, 1042659297u, 0, EXPM1F_TOLERANCE, 0},
{932, 1041865114u, 3079358544u, 1042659297u, 0, EXPM1F_TOLERANCE, 0},
{933, 1041865114u, 3079358544u, 1042659297u, 0, EXPM1F_TOLERANCE, 0},
{934, 1041865114u, 3079358544u, 1042659297u, 0, EXPM1F_TOLERANCE, 0},
{935, 1041865114u, 3079358544u, 1042659297u, 0, EXPM1F_TOLERANCE, 0},
{936, 1041865114u, 3079358544u, 1042659297u, 0, EXPM1F_TOLERANCE, 0},
{937, 1041865114u, 3079358544u, 1042659297u, 0, EXPM1F_TOLERANCE, 0},
{938, 1041865114u, 3079358544u, 1042659297u, 0, EXPM1F_TOLERANCE, 0},
{939, 1041865114u, 3079358544u, 1042659297u, 0, EXPM1F_TOLERANCE, 0},
{940, 1041865114u, 3079358544u, 1042659297u, 0, EXPM1F_TOLERANCE, 0},
{941, 1041865114u, 3079358544u, 1042659297u, 0, EXPM1F_TOLERANCE, 0},
{942, 1041865114u, 3079358544u, 1042659297u, 0, EXPM1F_TOLERANCE, 0},
{943, 1041865114u, 3079358544u, 1042659297u, 0, EXPM1F_TOLERANCE, 0},
{944, 1041865114u, 3079358544u, 1042659297u, 0, EXPM1F_TOLERANCE, 0},
{945, 1041865114u, 3079358544u, 1042659297u, 0, EXPM1F_TOLERANCE, 0},
{946, 1041865114u, 3079358544u, 1042659297u, 0, EXPM1F_TOLERANCE, 0},
{947, 1041865114u, 3079358544u, 1042659297u, 0, EXPM1F_TOLERANCE, 0},
{948, 1041865114u, 3079358544u, 1042659297u, 0, EXPM1F_TOLERANCE, 0},
{949, 1041865114u, 3079358544u, 1042659297u, 0, EXPM1F_TOLERANCE, 0},
{950, 1041865114u, 3079358544u, 1042659297u, 0, EXPM1F_TOLERANCE, 0},
{951, 1041865114u, 3079358544u, 1042659297u, 0, EXPM1F_TOLERANCE, 0},
{952, 1041865114u, 3079358544u, 1042659297u, 0, EXPM1F_TOLERANCE, 0},
{953, 1041865114u, 3079358544u, 1042659297u, 0, EXPM1F_TOLERANCE, 0},
{954, 1041865114u, 3079358544u, 1042659297u, 0, EXPM1F_TOLERANCE, 0},
{955, 1041865114u, 3079358544u, 1042659297u, 0, EXPM1F_TOLERANCE, 0},
{956, 1041865114u, 3079358544u, 1042659297u, 0, EXPM1F_TOLERANCE, 0},
{957, 1041865114u, 3079358544u, 1042659297u, 0, EXPM1F_TOLERANCE, 0},
{958, 1041865114u, 3079358544u, 1042659297u, 0, EXPM1F_TOLERANCE, 0},
{959, 1041865114u, 3079358544u, 1042659297u, 0, EXPM1F_TOLERANCE, 0},
{960, 1045220557u, 3079358544u, 1046656872u, 0, EXPM1F_TOLERANCE, 0},
{961, 1045220557u, 3079358544u, 1046656872u, 0, EXPM1F_TOLERANCE, 0},
{962, 1045220557u, 3079358544u, 1046656872u, 0, EXPM1F_TOLERANCE, 0},
{963, 1045220557u, 3079358544u, 1046656872u, 0, EXPM1F_TOLERANCE, 0},
{964, 1045220557u, 3079358544u, 1046656872u, 0, EXPM1F_TOLERANCE, 0},
{965, 1045220557u, 3079358544u, 1046656872u, 0, EXPM1F_TOLERANCE, 0},
{966, 1045220557u, 3079358544u, 1046656872u, 0, EXPM1F_TOLERANCE, 0},
{967, 1045220557u, 3079358544u, 1046656872u, 0, EXPM1F_TOLERANCE, 0},
{968, 1045220557u, 3079358544u, 1046656872u, 0, EXPM1F_TOLERANCE, 0},
{969, 1045220557u, 3079358544u, 1046656872u, 0, EXPM1F_TOLERANCE, 0},
{970, 1045220557u, 3079358544u, 1046656872u, 0, EXPM1F_TOLERANCE, 0},
{971, 1045220557u, 3079358544u, 1046656872u, 0, EXPM1F_TOLERANCE, 0},
{972, 1045220557u, 3079358544u, 1046656872u, 0, EXPM1F_TOLERANCE, 0},
{973, 1045220557u, 3079358544u, 1046656872u, 0, EXPM1F_TOLERANCE, 0},
{974, 1045220557u, 3079358544u, 1046656872u, 0, EXPM1F_TOLERANCE, 0},
{975, 1045220557u, 3079358544u, 1046656872u, 0, EXPM1F_TOLERANCE, 0},
{976, 1045220557u, 3079358544u, 1046656872u, 0, EXPM1F_TOLERANCE, 0},
{977, 1045220557u, 3079358544u, 1046656872u, 0, EXPM1F_TOLERANCE, 0},
{978, 1045220557u, 3079358544u, 1046656872u, 0, EXPM1F_TOLERANCE, 0},
{979, 1045220557u, 3079358544u, 1046656872u, 0, EXPM1F_TOLERANCE, 0},
{980, 1045220557u, 3079358544u, 1046656872u, 0, EXPM1F_TOLERANCE, 0},
{981, 1045220557u, 3079358544u, 1046656872u, 0, EXPM1F_TOLERANCE, 0},
{982, 1045220557u, 3079358544u, 1046656872u, 0, EXPM1F_TOLERANCE, 0},
{983, 1045220557u, 3079358544u, 1046656872u, 0, EXPM1F_TOLERANCE, 0},
{984, 1045220557u, 3079358544u, 1046656872u, 0, EXPM1F_TOLERANCE, 0},
{985, 1045220557u, 3079358544u, 1046656872u, 0, EXPM1F_TOLERANCE, 0},
{986, 1045220557u, 3079358544u, 1046656872u, 0, EXPM1F_TOLERANCE, 0},
{987, 1045220557u, 3079358544u, 1046656872u, 0, EXPM1F_TOLERANCE, 0},
{988, 1045220557u, 3079358544u, 1046656872u, 0, EXPM1F_TOLERANCE, 0},
{989, 1045220557u, 3079358544u, 1046656872u, 0, EXPM1F_TOLERANCE, 0},
{990, 1045220557u, 3079358544u, 1046656872u, 0, EXPM1F_TOLERANCE, 0},
{991, 1045220557u, 3079358544u, 1046656872u, 0, EXPM1F_TOLERANCE, 0},
{992, 1045220557u, 3079358544u, 1046656872u, 0, EXPM1F_TOLERANCE, 0},
{993, 1045220557u, 3079358544u, 1046656872u, 0, EXPM1F_TOLERANCE, 0},
{994, 1045220557u, 3079358544u, 1046656872u, 0, EXPM1F_TOLERANCE, 0},
{995, 1045220557u, 3079358544u, 1046656872u, 0, EXPM1F_TOLERANCE, 0},
{996, 1045220557u, 3079358544u, 1046656872u, 0, EXPM1F_TOLERANCE, 0},
{997, 1045220557u, 3079358544u, 1046656872u, 0, EXPM1F_TOLERANCE, 0},
{998, 1045220557u, 3079358544u, 1046656872u, 0, EXPM1F_TOLERANCE, 0},
{999, 1045220557u, 3079358544u, 1046656872u, 0, EXPM1F_TOLERANCE, 0},
{1000, 1048576000u, 3079358544u, 1049717704u, 0, EXPM1F_TOLERANCE, 0},
{1001, 1048576000u, 3079358544u, 1049717704u, 0, EXPM1F_TOLERANCE, 0},
{1002, 1048576000u, 3079358544u, 1049717704u, 0, EXPM1F_TOLERANCE, 0},
{1003, 1048576000u, 3079358544u, 1049717704u, 0, EXPM1F_TOLERANCE, 0},
{1004, 1048576000u, 3079358544u, 1049717704u, 0, EXPM1F_TOLERANCE, 0},
{1005, 1048576000u, 3079358544u, 1049717704u, 0, EXPM1F_TOLERANCE, 0},
{1006, 1048576000u, 3079358544u, 1049717704u, 0, EXPM1F_TOLERANCE, 0},
{1007, 1048576000u, 3079358544u, 1049717704u, 0, EXPM1F_TOLERANCE, 0},
{1008, 1048576000u, 3079358544u, 1049717704u, 0, EXPM1F_TOLERANCE, 0},
{1009, 1048576000u, 3079358544u, 1049717704u, 0, EXPM1F_TOLERANCE, 0},
{1010, 1048576000u, 3079358544u, 1049717704u, 0, EXPM1F_TOLERANCE, 0},
{1011, 1048576000u, 3079358544u, 1049717704u, 0, EXPM1F_TOLERANCE, 0},
{1012, 1048576000u, 3079358544u, 1049717704u, 0, EXPM1F_TOLERANCE, 0},
{1013, 1048576000u, 3079358544u, 1049717704u, 0, EXPM1F_TOLERANCE, 0},
{1014, 1048576000u, 3079358544u, 1049717704u, 0, EXPM1F_TOLERANCE, 0},
{1015, 1048576000u, 3079358544u, 1049717704u, 0, EXPM1F_TOLERANCE, 0},
{1016, 1048576000u, 3079358544u, 1049717704u, 0, EXPM1F_TOLERANCE, 0},
{1017, 1048576000u, 3079358544u, 1049717704u, 0, EXPM1F_TOLERANCE, 0},
{1018, 1048576000u, 3079358544u, 1049717704u, 0, EXPM1F_TOLERANCE, 0},
{1019, 1048576000u, 3079358544u, 1049717704u, 0, EXPM1F_TOLERANCE, 0},
{1020, 1048576000u, 3079358544u, 1049717704u, 0, EXPM1F_TOLERANCE, 0},
{1021, 1048576000u, 3079358544u, 1049717704u, 0, EXPM1F_TOLERANCE, 0},
{1022, 1048576000u, 3079358544u, 1049717704u, 0, EXPM1F_TOLERANCE, 0},
{1023, 1048576000u, 3079358544u, 1049717704u, 0, EXPM1F_TOLERANCE, 0},
{1024, 1048576000u, 3079358544u, 1049717704u, 0, EXPM1F_TOLERANCE, 0},
{1025, 1048576000u, 3079358544u, 1049717704u, 0, EXPM1F_TOLERANCE, 0},
{1026, 1048576000u, 3079358544u, 1049717704u, 0, EXPM1F_TOLERANCE, 0},
{1027, 1048576000u, 3079358544u, 1049717704u, 0, EXPM1F_TOLERANCE, 0},
{1028, 1048576000u, 3079358544u, 1049717704u, 0, EXPM1F_TOLERANCE, 0},
{1029, 1048576000u, 3079358544u, 1049717704u, 0, EXPM1F_TOLERANCE, 0},
{1030, 1048576000u, 3079358544u, 1049717704u, 0, EXPM1F_TOLERANCE, 0},
{1031, 1048576000u, 3079358544u, 1049717704u, 0, EXPM1F_TOLERANCE, 0},
{1032, 1048576000u, 3079358544u, 1049717704u, 0, EXPM1F_TOLERANCE, 0},
{1033, 1048576000u, 3079358544u, 1049717704u, 0, EXPM1F_TOLERANCE, 0},
{1034, 1048576000u, 3079358544u, 1049717704u, 0, EXPM1F_TOLERANCE, 0},
{1035, 1048576000u, 3079358544u, 1049717704u, 0, EXPM1F_TOLERANCE, 0},
{1036, 1048576000u, 3079358544u, 1049717704u, 0, EXPM1F_TOLERANCE, 0},
{1037, 1048576000u, 3079358544u, 1049717704u, 0, EXPM1F_TOLERANCE, 0},
{1038, 1048576000u, 3079358544u, 1049717704u, 0, EXPM1F_TOLERANCE, 0},
{1039, 1048576000u, 3079358544u, 1049717704u, 0, EXPM1F_TOLERANCE, 0},
{1040, 1050253722u, 3079358544u, 1051926706u, 0, EXPM1F_TOLERANCE, 0},
{1041, 1050253722u, 3079358544u, 1051926706u, 0, EXPM1F_TOLERANCE, 0},
{1042, 1050253722u, 3079358544u, 1051926706u, 0, EXPM1F_TOLERANCE, 0},
{1043, 1050253722u, 3079358544u, 1051926706u, 0, EXPM1F_TOLERANCE, 0},
{1044, 1050253722u, 3079358544u, 1051926706u, 0, EXPM1F_TOLERANCE, 0},
{1045, 1050253722u, 3079358544u, 1051926706u, 0, EXPM1F_TOLERANCE, 0},
{1046, 1050253722u, 3079358544u, 1051926706u, 0, EXPM1F_TOLERANCE, 0},
{1047, 1050253722u, 3079358544u, 1051926706u, 0, EXPM1F_TOLERANCE, 0},
{1048, 1050253722u, 3079358544u, 1051926706u, 0, EXPM1F_TOLERANCE, 0},
{1049, 1050253722u, 3079358544u, 1051926706u, 0, EXPM1F_TOLERANCE, 0},
{1050, 1050253722u, 3079358544u, 1051926706u, 0, EXPM1F_TOLERANCE, 0},
{1051, 1050253722u, 3079358544u, 1051926706u, 0, EXPM1F_TOLERANCE, 0},
{1052, 1050253722u, 3079358544u, 1051926706u, 0, EXPM1F_TOLERANCE, 0},
{1053, 1050253722u, 3079358544u, 1051926706u, 0, EXPM1F_TOLERANCE, 0},
{1054, 1050253722u, 3079358544u, 1051926706u, 0, EXPM1F_TOLERANCE, 0},
{1055, 1050253722u, 3079358544u, 1051926706u, 0, EXPM1F_TOLERANCE, 0},
{1056, 1050253722u, 3079358544u, 1051926706u, 0, EXPM1F_TOLERANCE, 0},
{1057, 1050253722u, 3079358544u, 1051926706u, 0, EXPM1F_TOLERANCE, 0},
{1058, 1050253722u, 3079358544u, 1051926706u, 0, EXPM1F_TOLERANCE, 0},
{1059, 1050253722u, 3079358544u, 1051926706u, 0, EXPM1F_TOLERANCE, 0},
{1060, 1050253722u, 3079358544u, 1051926706u, 0, EXPM1F_TOLERANCE, 0},
{1061, 1050253722u, 3079358544u, 1051926706u, 0, EXPM1F_TOLERANCE, 0},
{1062, 1050253722u, 3079358544u, 1051926706u, 0, EXPM1F_TOLERANCE, 0},
{1063, 1050253722u, 3079358544u, 1051926706u, 0, EXPM1F_TOLERANCE, 0},
{1064, 1050253722u, 3079358544u, 1051926706u, 0, EXPM1F_TOLERANCE, 0},
{1065, 1050253722u, 3079358544u, 1051926706u, 0, EXPM1F_TOLERANCE, 0},
{1066, 1050253722u, 3079358544u, 1051926706u, 0, EXPM1F_TOLERANCE, 0},
{1067, 1050253722u, 3079358544u, 1051926706u, 0, EXPM1F_TOLERANCE, 0},
{1068, 1050253722u, 3079358544u, 1051926706u, 0, EXPM1F_TOLERANCE, 0},
{1069, 1050253722u, 3079358544u, 1051926706u, 0, EXPM1F_TOLERANCE, 0},
{1070, 1050253722u, 3079358544u, 1051926706u, 0, EXPM1F_TOLERANCE, 0},
{1071, 1050253722u, 3079358544u, 1051926706u, 0, EXPM1F_TOLERANCE, 0},
{1072, 1050253722u, 3079358544u, 1051926706u, 0, EXPM1F_TOLERANCE, 0},
{1073, 1050253722u, 3079358544u, 1051926706u, 0, EXPM1F_TOLERANCE, 0},
{1074, 1050253722u, 3079358544u, 1051926706u, 0, EXPM1F_TOLERANCE, 0},
{1075, 1050253722u, 3079358544u, 1051926706u, 0, EXPM1F_TOLERANCE, 0},
{1076, 1050253722u, 3079358544u, 1051926706u, 0, EXPM1F_TOLERANCE, 0},
{1077, 1050253722u, 3079358544u, 1051926706u, 0, EXPM1F_TOLERANCE, 0},
{1078, 1050253722u, 3079358544u, 1051926706u, 0, EXPM1F_TOLERANCE, 0},
{1079, 1050253722u, 3079358544u, 1051926706u, 0, EXPM1F_TOLERANCE, 0},
{1080, 1051931443u, 3079358544u, 1054248965u, 0, EXPM1F_TOLERANCE, 0},
{1081, 1051931443u, 3079358544u, 1054248965u, 0, EXPM1F_TOLERANCE, 0},
{1082, 1051931443u, 3079358544u, 1054248965u, 0, EXPM1F_TOLERANCE, 0},
{1083, 1051931443u, 3079358544u, 1054248965u, 0, EXPM1F_TOLERANCE, 0},
{1084, 1051931443u, 3079358544u, 1054248965u, 0, EXPM1F_TOLERANCE, 0},
{1085, 1051931443u, 3079358544u, 1054248965u, 0, EXPM1F_TOLERANCE, 0},
{1086, 1051931443u, 3079358544u, 1054248965u, 0, EXPM1F_TOLERANCE, 0},
{1087, 1051931443u, 3079358544u, 1054248965u, 0, EXPM1F_TOLERANCE, 0},
{1088, 1051931443u, 3079358544u, 1054248965u, 0, EXPM1F_TOLERANCE, 0},
{1089, 1051931443u, 3079358544u, 1054248965u, 0, EXPM1F_TOLERANCE, 0},
{1090, 1051931443u, 3079358544u, 1054248965u, 0, EXPM1F_TOLERANCE, 0},
{1091, 1051931443u, 3079358544u, 1054248965u, 0, EXPM1F_TOLERANCE, 0},
{1092, 1051931443u, 3079358544u, 1054248965u, 0, EXPM1F_TOLERANCE, 0},
{1093, 1051931443u, 3079358544u, 1054248965u, 0, EXPM1F_TOLERANCE, 0},
{1094, 1051931443u, 3079358544u, 1054248965u, 0, EXPM1F_TOLERANCE, 0},
{1095, 1051931443u, 3079358544u, 1054248965u, 0, EXPM1F_TOLERANCE, 0},
{1096, 1051931443u, 3079358544u, 1054248965u, 0, EXPM1F_TOLERANCE, 0},
{1097, 1051931443u, 3079358544u, 1054248965u, 0, EXPM1F_TOLERANCE, 0},
{1098, 1051931443u, 3079358544u, 1054248965u, 0, EXPM1F_TOLERANCE, 0},
{1099, 1051931443u, 3079358544u, 1054248965u, 0, EXPM1F_TOLERANCE, 0},
{1100, 1051931443u, 3079358544u, 1054248965u, 0, EXPM1F_TOLERANCE, 0},
{1101, 1051931443u, 3079358544u, 1054248965u, 0, EXPM1F_TOLERANCE, 0},
{1102, 1051931443u, 3079358544u, 1054248965u, 0, EXPM1F_TOLERANCE, 0},
{1103, 1051931443u, 3079358544u, 1054248965u, 0, EXPM1F_TOLERANCE, 0},
{1104, 1051931443u, 3079358544u, 1054248965u, 0, EXPM1F_TOLERANCE, 0},
{1105, 1051931443u, 3079358544u, 1054248965u, 0, EXPM1F_TOLERANCE, 0},
{1106, 1051931443u, 3079358544u, 1054248965u, 0, EXPM1F_TOLERANCE, 0},
{1107, 1051931443u, 3079358544u, 1054248965u, 0, EXPM1F_TOLERANCE, 0},
{1108, 1051931443u, 3079358544u, 1054248965u, 0, EXPM1F_TOLERANCE, 0},
{1109, 1051931443u, 3079358544u, 1054248965u, 0, EXPM1F_TOLERANCE, 0},
{1110, 1051931443u, 3079358544u, 1054248965u, 0, EXPM1F_TOLERANCE, 0},
{1111, 1051931443u, 3079358544u, 1054248965u, 0, EXPM1F_TOLERANCE, 0},
{1112, 1051931443u, 3079358544u, 1054248965u, 0, EXPM1F_TOLERANCE, 0},
{1113, 1051931443u, 3079358544u, 1054248965u, 0, EXPM1F_TOLERANCE, 0},
{1114, 1051931443u, 3079358544u, 1054248965u, 0, EXPM1F_TOLERANCE, 0},
{1115, 1051931443u, 3079358544u, 1054248965u, 0, EXPM1F_TOLERANCE, 0},
{1116, 1051931443u, 3079358544u, 1054248965u, 0, EXPM1F_TOLERANCE, 0},
{1117, 1051931443u, 3079358544u, 1054248965u, 0, EXPM1F_TOLERANCE, 0},
{1118, 1051931443u, 3079358544u, 1054248965u, 0, EXPM1F_TOLERANCE, 0},
{1119, 1051931443u, 3079358544u, 1054248965u, 0, EXPM1F_TOLERANCE, 0},
{1120, 1053609165u, 3079358544u, 1056690291u, 0, EXPM1F_TOLERANCE, 0},
{1121, 1053609165u, 3079358544u, 1056690291u, 0, EXPM1F_TOLERANCE, 0},
{1122, 1053609165u, 3079358544u, 1056690291u, 0, EXPM1F_TOLERANCE, 0},
{1123, 1053609165u, 3079358544u, 1056690291u, 0, EXPM1F_TOLERANCE, 0},
{1124, 1053609165u, 3079358544u, 1056690291u, 0, EXPM1F_TOLERANCE, 0},
{1125, 1053609165u, 3079358544u, 1056690291u, 0, EXPM1F_TOLERANCE, 0},
{1126, 1053609165u, 3079358544u, 1056690291u, 0, EXPM1F_TOLERANCE, 0},
{1127, 1053609165u, 3079358544u, 1056690291u, 0, EXPM1F_TOLERANCE, 0},
{1128, 1053609165u, 3079358544u, 1056690291u, 0, EXPM1F_TOLERANCE, 0},
{1129, 1053609165u, 3079358544u, 1056690291u, 0, EXPM1F_TOLERANCE, 0},
{1130, 1053609165u, 3079358544u, 1056690291u, 0, EXPM1F_TOLERANCE, 0},
{1131, 1053609165u, 3079358544u, 1056690291u, 0, EXPM1F_TOLERANCE, 0},
{1132, 1053609165u, 3079358544u, 1056690291u, 0, EXPM1F_TOLERANCE, 0},
{1133, 1053609165u, 3079358544u, 1056690291u, 0, EXPM1F_TOLERANCE, 0},
{1134, 1053609165u, 3079358544u, 1056690291u, 0, EXPM1F_TOLERANCE, 0},
{1135, 1053609165u, 3079358544u, 1056690291u, 0, EXPM1F_TOLERANCE, 0},
{1136, 1053609165u, 3079358544u, 1056690291u, 0, EXPM1F_TOLERANCE, 0},
{1137, 1053609165u, 3079358544u, 1056690291u, 0, EXPM1F_TOLERANCE, 0},
{1138, 1053609165u, 3079358544u, 1056690291u, 0, EXPM1F_TOLERANCE, 0},
{1139, 1053609165u, 3079358544u, 1056690291u, 0, EXPM1F_TOLERANCE, 0},
{1140, 1053609165u, 3079358544u, 1056690291u, 0, EXPM1F_TOLERANCE, 0},
{1141, 1053609165u, 3079358544u, 1056690291u, 0, EXPM1F_TOLERANCE, 0},
{1142, 1053609165u, 3079358544u, 1056690291u, 0, EXPM1F_TOLERANCE, 0},
{1143, 1053609165u, 3079358544u, 1056690291u, 0, EXPM1F_TOLERANCE, 0},
{1144, 1053609165u, 3079358544u, 1056690291u, 0, EXPM1F_TOLERANCE, 0},
{1145, 1053609165u, 3079358544u, 1056690291u, 0, EXPM1F_TOLERANCE, 0},
{1146, 1053609165u, 3079358544u, 1056690291u, 0, EXPM1F_TOLERANCE, 0},
{1147, 1053609165u, 3079358544u, 1056690291u, 0, EXPM1F_TOLERANCE, 0},
{1148, 1053609165u, 3079358544u, 1056690291u, 0, EXPM1F_TOLERANCE, 0},
{1149, 1053609165u, 3079358544u, 1056690291u, 0, EXPM1F_TOLERANCE, 0},
{1150, 1053609165u, 3079358544u, 1056690291u, 0, EXPM1F_TOLERANCE, 0},
{1151, 1053609165u, 3079358544u, 1056690291u, 0, EXPM1F_TOLERANCE, 0},
{1152, 1053609165u, 3079358544u, 1056690291u, 0, EXPM1F_TOLERANCE, 0},
{1153, 1053609165u, 3079358544u, 1056690291u, 0, EXPM1F_TOLERANCE, 0},
{1154, 1053609165u, 3079358544u, 1056690291u, 0, EXPM1F_TOLERANCE, 0},
{1155, 1053609165u, 3079358544u, 1056690291u, 0, EXPM1F_TOLERANCE, 0},
{1156, 1053609165u, 3079358544u, 1056690291u, 0, EXPM1F_TOLERANCE, 0},
{1157, 1053609165u, 3079358544u, 1056690291u, 0, EXPM1F_TOLERANCE, 0},
{1158, 1053609165u, 3079358544u, 1056690291u, 0, EXPM1F_TOLERANCE, 0},
{1159, 1053609165u, 3079358544u, 1056690291u, 0, EXPM1F_TOLERANCE, 0},
{1160, 1055286886u, 3079358544u, 1058110696u, 0, EXPM1F_TOLERANCE, 0},
{1161, 1055286886u, 3079358544u, 1058110696u, 0, EXPM1F_TOLERANCE, 0},
{1162, 1055286886u, 3079358544u, 1058110696u, 0, EXPM1F_TOLERANCE, 0},
{1163, 1055286886u, 3079358544u, 1058110696u, 0, EXPM1F_TOLERANCE, 0},
{1164, 1055286886u, 3079358544u, 1058110696u, 0, EXPM1F_TOLERANCE, 0},
{1165, 1055286886u, 3079358544u, 1058110696u, 0, EXPM1F_TOLERANCE, 0},
{1166, 1055286886u, 3079358544u, 1058110696u, 0, EXPM1F_TOLERANCE, 0},
{1167, 1055286886u, 3079358544u, 1058110696u, 0, EXPM1F_TOLERANCE, 0},
{1168, 1055286886u, 3079358544u, 1058110696u, 0, EXPM1F_TOLERANCE, 0},
{1169, 1055286886u, 3079358544u, 1058110696u, 0, EXPM1F_TOLERANCE, 0},
{1170, 1055286886u, 3079358544u, 1058110696u, 0, EXPM1F_TOLERANCE, 0},
{1171, 1055286886u, 3079358544u, 1058110696u, 0, EXPM1F_TOLERANCE, 0},
{1172, 1055286886u, 3079358544u, 1058110696u, 0, EXPM1F_TOLERANCE, 0},
{1173, 1055286886u, 3079358544u, 1058110696u, 0, EXPM1F_TOLERANCE, 0},
{1174, 1055286886u, 3079358544u, 1058110696u, 0, EXPM1F_TOLERANCE, 0},
{1175, 1055286886u, 3079358544u, 1058110696u, 0, EXPM1F_TOLERANCE, 0},
{1176, 1055286886u, 3079358544u, 1058110696u, 0, EXPM1F_TOLERANCE, 0},
{1177, 1055286886u, 3079358544u, 1058110696u, 0, EXPM1F_TOLERANCE, 0},
{1178, 1055286886u, 3079358544u, 1058110696u, 0, EXPM1F_TOLERANCE, 0},
{1179, 1055286886u, 3079358544u, 1058110696u, 0, EXPM1F_TOLERANCE, 0},
{1180, 1055286886u, 3079358544u, 1058110696u, 0, EXPM1F_TOLERANCE, 0},
{1181, 1055286886u, 3079358544u, 1058110696u, 0, EXPM1F_TOLERANCE, 0},
{1182, 1055286886u, 3079358544u, 1058110696u, 0, EXPM1F_TOLERANCE, 0},
{1183, 1055286886u, 3079358544u, 1058110696u, 0, EXPM1F_TOLERANCE, 0},
{1184, 1055286886u, 3079358544u, 1058110696u, 0, EXPM1F_TOLERANCE, 0},
{1185, 1055286886u, 3079358544u, 1058110696u, 0, EXPM1F_TOLERANCE, 0},
{1186, 1055286886u, 3079358544u, 1058110696u, 0, EXPM1F_TOLERANCE, 0},
{1187, 1055286886u, 3079358544u, 1058110696u, 0, EXPM1F_TOLERANCE, 0},
{1188, 1055286886u, 3079358544u, 1058110696u, 0, EXPM1F_TOLERANCE, 0},
{1189, 1055286886u, 3079358544u, 1058110696u, 0, EXPM1F_TOLERANCE, 0},
{1190, 1055286886u, 3079358544u, 1058110696u, 0, EXPM1F_TOLERANCE, 0},
{1191, 1055286886u, 3079358544u, 1058110696u, 0, EXPM1F_TOLERANCE, 0},
{1192, 1055286886u, 3079358544u, 1058110696u, 0, EXPM1F_TOLERANCE, 0},
{1193, 1055286886u, 3079358544u, 1058110696u, 0, EXPM1F_TOLERANCE, 0},
{1194, 1055286886u, 3079358544u, 1058110696u, 0, EXPM1F_TOLERANCE, 0},
{1195, 1055286886u, 3079358544u, 1058110696u, 0, EXPM1F_TOLERANCE, 0},
{1196, 1055286886u, 3079358544u, 1058110696u, 0, EXPM1F_TOLERANCE, 0},
{1197, 1055286886u, 3079358544u, 1058110696u, 0, EXPM1F_TOLERANCE, 0},
{1198, 1055286886u, 3079358544u, 1058110696u, 0, EXPM1F_TOLERANCE, 0},
{1199, 1055286886u, 3079358544u, 1058110696u, 0, EXPM1F_TOLERANCE, 0},
{1200, 1056964608u, 3079358544u, 1059459737u, 0, EXPM1F_TOLERANCE, 0},
{1201, 1056964608u, 3079358544u, 1059459737u, 0, EXPM1F_TOLERANCE, 0},
{1202, 1056964608u, 3079358544u, 1059459737u, 0, EXPM1F_TOLERANCE, 0},
{1203, 1056964608u, 3079358544u, 1059459737u, 0, EXPM1F_TOLERANCE, 0},
{1204, 1056964608u, 3079358544u, 1059459737u, 0, EXPM1F_TOLERANCE, 0},
{1205, 1056964608u, 3079358544u, 1059459737u, 0, EXPM1F_TOLERANCE, 0},
{1206, 1056964608u, 3079358544u, 1059459737u, 0, EXPM1F_TOLERANCE, 0},
{1207, 1056964608u, 3079358544u, 1059459737u, 0, EXPM1F_TOLERANCE, 0},
{1208, 1056964608u, 3079358544u, 1059459737u, 0, EXPM1F_TOLERANCE, 0},
{1209, 1056964608u, 3079358544u, 1059459737u, 0, EXPM1F_TOLERANCE, 0},
{1210, 1056964608u, 3079358544u, 1059459737u, 0, EXPM1F_TOLERANCE, 0},
{1211, 1056964608u, 3079358544u, 1059459737u, 0, EXPM1F_TOLERANCE, 0},
{1212, 1056964608u, 3079358544u, 1059459737u, 0, EXPM1F_TOLERANCE, 0},
{1213, 1056964608u, 3079358544u, 1059459737u, 0, EXPM1F_TOLERANCE, 0},
{1214, 1056964608u, 3079358544u, 1059459737u, 0, EXPM1F_TOLERANCE, 0},
{1215, 1056964608u, 3079358544u, 1059459737u, 0, EXPM1F_TOLERANCE, 0},
{1216, 1056964608u, 3079358544u, 1059459737u, 0, EXPM1F_TOLERANCE, 0},
{1217, 1056964608u, 3079358544u, 1059459737u, 0, EXPM1F_TOLERANCE, 0},
{1218, 1056964608u, 3079358544u, 1059459737u, 0, EXPM1F_TOLERANCE, 0},
{1219, 1056964608u, 3079358544u, 1059459737u, 0, EXPM1F_TOLERANCE, 0},
{1220, 1056964608u, 3079358544u, 1059459737u, 0, EXPM1F_TOLERANCE, 0},
{1221, 1056964608u, 3079358544u, 1059459737u, 0, EXPM1F_TOLERANCE, 0},
{1222, 1056964608u, 3079358544u, 1059459737u, 0, EXPM1F_TOLERANCE, 0},
{1223, 1056964608u, 3079358544u, 1059459737u, 0, EXPM1F_TOLERANCE, 0},
{1224, 1056964608u, 3079358544u, 1059459737u, 0, EXPM1F_TOLERANCE, 0},
{1225, 1056964608u, 3079358544u, 1059459737u, 0, EXPM1F_TOLERANCE, 0},
{1226, 1056964608u, 3079358544u, 1059459737u, 0, EXPM1F_TOLERANCE, 0},
{1227, 1056964608u, 3079358544u, 1059459737u, 0, EXPM1F_TOLERANCE, 0},
{1228, 1056964608u, 3079358544u, 1059459737u, 0, EXPM1F_TOLERANCE, 0},
{1229, 1056964608u, 3079358544u, 1059459737u, 0, EXPM1F_TOLERANCE, 0},
{1230, 1056964608u, 3079358544u, 1059459737u, 0, EXPM1F_TOLERANCE, 0},
{1231, 1056964608u, 3079358544u, 1059459737u, 0, EXPM1F_TOLERANCE, 0},
{1232, 1056964608u, 3079358544u, 1059459737u, 0, EXPM1F_TOLERANCE, 0},
{1233, 1056964608u, 3079358544u, 1059459737u, 0, EXPM1F_TOLERANCE, 0},
{1234, 1056964608u, 3079358544u, 1059459737u, 0, EXPM1F_TOLERANCE, 0},
{1235, 1056964608u, 3079358544u, 1059459737u, 0, EXPM1F_TOLERANCE, 0},
{1236, 1056964608u, 3079358544u, 1059459737u, 0, EXPM1F_TOLERANCE, 0},
{1237, 1056964608u, 3079358544u, 1059459737u, 0, EXPM1F_TOLERANCE, 0},
{1238, 1056964608u, 3079358544u, 1059459737u, 0, EXPM1F_TOLERANCE, 0},
{1239, 1056964608u, 3079358544u, 1059459737u, 0, EXPM1F_TOLERANCE, 0},
{1240, 1057803469u, 3079358544u, 1060877945u, 0, EXPM1F_TOLERANCE, 0},
{1241, 1057803469u, 3079358544u, 1060877945u, 0, EXPM1F_TOLERANCE, 0},
{1242, 1057803469u, 3079358544u, 1060877945u, 0, EXPM1F_TOLERANCE, 0},
{1243, 1057803469u, 3079358544u, 1060877945u, 0, EXPM1F_TOLERANCE, 0},
{1244, 1057803469u, 3079358544u, 1060877945u, 0, EXPM1F_TOLERANCE, 0},
{1245, 1057803469u, 3079358544u, 1060877945u, 0, EXPM1F_TOLERANCE, 0},
{1246, 1057803469u, 3079358544u, 1060877945u, 0, EXPM1F_TOLERANCE, 0},
{1247, 1057803469u, 3079358544u, 1060877945u, 0, EXPM1F_TOLERANCE, 0},
{1248, 1057803469u, 3079358544u, 1060877945u, 0, EXPM1F_TOLERANCE, 0},
{1249, 1057803469u, 3079358544u, 1060877945u, 0, EXPM1F_TOLERANCE, 0},
{1250, 1057803469u, 3079358544u, 1060877945u, 0, EXPM1F_TOLERANCE, 0},
{1251, 1057803469u, 3079358544u, 1060877945u, 0, EXPM1F_TOLERANCE, 0},
{1252, 1057803469u, 3079358544u, 1060877945u, 0, EXPM1F_TOLERANCE, 0},
{1253, 1057803469u, 3079358544u, 1060877945u, 0, EXPM1F_TOLERANCE, 0},
{1254, 1057803469u, 3079358544u, 1060877945u, 0, EXPM1F_TOLERANCE, 0},
{1255, 1057803469u, 3079358544u, 1060877945u, 0, EXPM1F_TOLERANCE, 0},
{1256, 1057803469u, 3079358544u, 1060877945u, 0, EXPM1F_TOLERANCE, 0},
{1257, 1057803469u, 3079358544u, 1060877945u, 0, EXPM1F_TOLERANCE, 0},
{1258, 1057803469u, 3079358544u, 1060877945u, 0, EXPM1F_TOLERANCE, 0},
{1259, 1057803469u, 3079358544u, 1060877945u, 0, EXPM1F_TOLERANCE, 0},
{1260, 1057803469u, 3079358544u, 1060877945u, 0, EXPM1F_TOLERANCE, 0},
{1261, 1057803469u, 3079358544u, 1060877945u, 0, EXPM1F_TOLERANCE, 0},
{1262, 1057803469u, 3079358544u, 1060877945u, 0, EXPM1F_TOLERANCE, 0},
{1263, 1057803469u, 3079358544u, 1060877945u, 0, EXPM1F_TOLERANCE, 0},
{1264, 1057803469u, 3079358544u, 1060877945u, 0, EXPM1F_TOLERANCE, 0},
{1265, 1057803469u, 3079358544u, 1060877945u, 0, EXPM1F_TOLERANCE, 0},
{1266, 1057803469u, 3079358544u, 1060877945u, 0, EXPM1F_TOLERANCE, 0},
{1267, 1057803469u, 3079358544u, 1060877945u, 0, EXPM1F_TOLERANCE, 0},
{1268, 1057803469u, 3079358544u, 1060877945u, 0, EXPM1F_TOLERANCE, 0},
{1269, 1057803469u, 3079358544u, 1060877945u, 0, EXPM1F_TOLERANCE, 0},
{1270, 1057803469u, 3079358544u, 1060877945u, 0, EXPM1F_TOLERANCE, 0},
{1271, 1057803469u, 3079358544u, 1060877945u, 0, EXPM1F_TOLERANCE, 0},
{1272, 1057803469u, 3079358544u, 1060877945u, 0, EXPM1F_TOLERANCE, 0},
{1273, 1057803469u, 3079358544u, 1060877945u, 0, EXPM1F_TOLERANCE, 0},
{1274, 1057803469u, 3079358544u, 1060877945u, 0, EXPM1F_TOLERANCE, 0},
{1275, 1057803469u, 3079358544u, 1060877945u, 0, EXPM1F_TOLERANCE, 0},
{1276, 1057803469u, 3079358544u, 1060877945u, 0, EXPM1F_TOLERANCE, 0},
{1277, 1057803469u, 3079358544u, 1060877945u, 0, EXPM1F_TOLERANCE, 0},
{1278, 1057803469u, 3079358544u, 1060877945u, 0, EXPM1F_TOLERANCE, 0},
{1279, 1057803469u, 3079358544u, 1060877945u, 0, EXPM1F_TOLERANCE, 0},
{1280, 1058642330u, 3079358544u, 1062368865u, 0, EXPM1F_TOLERANCE, 0},
{1281, 1058642330u, 3079358544u, 1062368865u, 0, EXPM1F_TOLERANCE, 0},
{1282, 1058642330u, 3079358544u, 1062368865u, 0, EXPM1F_TOLERANCE, 0},
{1283, 1058642330u, 3079358544u, 1062368865u, 0, EXPM1F_TOLERANCE, 0},
{1284, 1058642330u, 3079358544u, 1062368865u, 0, EXPM1F_TOLERANCE, 0},
{1285, 1058642330u, 3079358544u, 1062368865u, 0, EXPM1F_TOLERANCE, 0},
{1286, 1058642330u, 3079358544u, 1062368865u, 0, EXPM1F_TOLERANCE, 0},
{1287, 1058642330u, 3079358544u, 1062368865u, 0, EXPM1F_TOLERANCE, 0},
{1288, 1058642330u, 3079358544u, 1062368865u, 0, EXPM1F_TOLERANCE, 0},
{1289, 1058642330u, 3079358544u, 1062368865u, 0, EXPM1F_TOLERANCE, 0},
{1290, 1058642330u, 3079358544u, 1062368865u, 0, EXPM1F_TOLERANCE, 0},
{1291, 1058642330u, 3079358544u, 1062368865u, 0, EXPM1F_TOLERANCE, 0},
{1292, 1058642330u, 3079358544u, 1062368865u, 0, EXPM1F_TOLERANCE, 0},
{1293, 1058642330u, 3079358544u, 1062368865u, 0, EXPM1F_TOLERANCE, 0},
{1294, 1058642330u, 3079358544u, 1062368865u, 0, EXPM1F_TOLERANCE, 0},
{1295, 1058642330u, 3079358544u, 1062368865u, 0, EXPM1F_TOLERANCE, 0},
{1296, 1058642330u, 3079358544u, 1062368865u, 0, EXPM1F_TOLERANCE, 0},
{1297, 1058642330u, 3079358544u, 1062368865u, 0, EXPM1F_TOLERANCE, 0},
{1298, 1058642330u, 3079358544u, 1062368865u, 0, EXPM1F_TOLERANCE, 0},
{1299, 1058642330u, 3079358544u, 1062368865u, 0, EXPM1F_TOLERANCE, 0},
{1300, 1058642330u, 3079358544u, 1062368865u, 0, EXPM1F_TOLERANCE, 0},
{1301, 1058642330u, 3079358544u, 1062368865u, 0, EXPM1F_TOLERANCE, 0},
{1302, 1058642330u, 3079358544u, 1062368865u, 0, EXPM1F_TOLERANCE, 0},
{1303, 1058642330u, 3079358544u, 1062368865u, 0, EXPM1F_TOLERANCE, 0},
{1304, 1058642330u, 3079358544u, 1062368865u, 0, EXPM1F_TOLERANCE, 0},
{1305, 1058642330u, 3079358544u, 1062368865u, 0, EXPM1F_TOLERANCE, 0},
{1306, 1058642330u, 3079358544u, 1062368865u, 0, EXPM1F_TOLERANCE, 0},
{1307, 1058642330u, 3079358544u, 1062368865u, 0, EXPM1F_TOLERANCE, 0},
{1308, 1058642330u, 3079358544u, 1062368865u, 0, EXPM1F_TOLERANCE, 0},
{1309, 1058642330u, 3079358544u, 1062368865u, 0, EXPM1F_TOLERANCE, 0},
{1310, 1058642330u, 3079358544u, 1062368865u, 0, EXPM1F_TOLERANCE, 0},
{1311, 1058642330u, 3079358544u, 1062368865u, 0, EXPM1F_TOLERANCE, 0},
{1312, 1058642330u, 3079358544u, 1062368865u, 0, EXPM1F_TOLERANCE, 0},
{1313, 1058642330u, 3079358544u, 1062368865u, 0, EXPM1F_TOLERANCE, 0},
{1314, 1058642330u, 3079358544u, 1062368865u, 0, EXPM1F_TOLERANCE, 0},
{1315, 1058642330u, 3079358544u, 1062368865u, 0, EXPM1F_TOLERANCE, 0},
{1316, 1058642330u, 3079358544u, 1062368865u, 0, EXPM1F_TOLERANCE, 0},
{1317, 1058642330u, 3079358544u, 1062368865u, 0, EXPM1F_TOLERANCE, 0},
{1318, 1058642330u, 3079358544u, 1062368865u, 0, EXPM1F_TOLERANCE, 0},
{1319, 1058642330u, 3079358544u, 1062368865u, 0, EXPM1F_TOLERANCE, 0},
{1320, 1059481190u, 3079358544u, 1063936225u, 0, EXPM1F_TOLERANCE, 0},
{1321, 1059481190u, 3079358544u, 1063936225u, 0, EXPM1F_TOLERANCE, 0},
{1322, 1059481190u, 3079358544u, 1063936225u, 0, EXPM1F_TOLERANCE, 0},
{1323, 1059481190u, 3079358544u, 1063936225u, 0, EXPM1F_TOLERANCE, 0},
{1324, 1059481190u, 3079358544u, 1063936225u, 0, EXPM1F_TOLERANCE, 0},
{1325, 1059481190u, 3079358544u, 1063936225u, 0, EXPM1F_TOLERANCE, 0},
{1326, 1059481190u, 3079358544u, 1063936225u, 0, EXPM1F_TOLERANCE, 0},
{1327, 1059481190u, 3079358544u, 1063936225u, 0, EXPM1F_TOLERANCE, 0},
{1328, 1059481190u, 3079358544u, 1063936225u, 0, EXPM1F_TOLERANCE, 0},
{1329, 1059481190u, 3079358544u, 1063936225u, 0, EXPM1F_TOLERANCE, 0},
{1330, 1059481190u, 3079358544u, 1063936225u, 0, EXPM1F_TOLERANCE, 0},
{1331, 1059481190u, 3079358544u, 1063936225u, 0, EXPM1F_TOLERANCE, 0},
{1332, 1059481190u, 3079358544u, 1063936225u, 0, EXPM1F_TOLERANCE, 0},
{1333, 1059481190u, 3079358544u, 1063936225u, 0, EXPM1F_TOLERANCE, 0},
{1334, 1059481190u, 3079358544u, 1063936225u, 0, EXPM1F_TOLERANCE, 0},
{1335, 1059481190u, 3079358544u, 1063936225u, 0, EXPM1F_TOLERANCE, 0},
{1336, 1059481190u, 3079358544u, 1063936225u, 0, EXPM1F_TOLERANCE, 0},
{1337, 1059481190u, 3079358544u, 1063936225u, 0, EXPM1F_TOLERANCE, 0},
{1338, 1059481190u, 3079358544u, 1063936225u, 0, EXPM1F_TOLERANCE, 0},
{1339, 1059481190u, 3079358544u, 1063936225u, 0, EXPM1F_TOLERANCE, 0},
{1340, 1059481190u, 3079358544u, 1063936225u, 0, EXPM1F_TOLERANCE, 0},
{1341, 1059481190u, 3079358544u, 1063936225u, 0, EXPM1F_TOLERANCE, 0},
{1342, 1059481190u, 3079358544u, 1063936225u, 0, EXPM1F_TOLERANCE, 0},
{1343, 1059481190u, 3079358544u, 1063936225u, 0, EXPM1F_TOLERANCE, 0},
{1344, 1059481190u, 3079358544u, 1063936225u, 0, EXPM1F_TOLERANCE, 0},
{1345, 1059481190u, 3079358544u, 1063936225u, 0, EXPM1F_TOLERANCE, 0},
{1346, 1059481190u, 3079358544u, 1063936225u, 0, EXPM1F_TOLERANCE, 0},
{1347, 1059481190u, 3079358544u, 1063936225u, 0, EXPM1F_TOLERANCE, 0},
{1348, 1059481190u, 3079358544u, 1063936225u, 0, EXPM1F_TOLERANCE, 0},
{1349, 1059481190u, 3079358544u, 1063936225u, 0, EXPM1F_TOLERANCE, 0},
{1350, 1059481190u, 3079358544u, 1063936225u, 0, EXPM1F_TOLERANCE, 0},
{1351, 1059481190u, 3079358544u, 1063936225u, 0, EXPM1F_TOLERANCE, 0},
{1352, 1059481190u, 3079358544u, 1063936225u, 0, EXPM1F_TOLERANCE, 0},
{1353, 1059481190u, 3079358544u, 1063936225u, 0, EXPM1F_TOLERANCE, 0},
{1354, 1059481190u, 3079358544u, 1063936225u, 0, EXPM1F_TOLERANCE, 0},
{1355, 1059481190u, 3079358544u, 1063936225u, 0, EXPM1F_TOLERANCE, 0},
{1356, 1059481190u, 3079358544u, 1063936225u, 0, EXPM1F_TOLERANCE, 0},
{1357, 1059481190u, 3079358544u, 1063936225u, 0, EXPM1F_TOLERANCE, 0},
{1358, 1059481190u, 3079358544u, 1063936225u, 0, EXPM1F_TOLERANCE, 0},
{1359, 1059481190u, 3079358544u, 1063936225u, 0, EXPM1F_TOLERANCE, 0},
{1360, 1060320051u, 3079358544u, 1065468582u, 0, EXPM1F_TOLERANCE, 0},
{1361, 1060320051u, 3079358544u, 1065468582u, 0, EXPM1F_TOLERANCE, 0},
{1362, 1060320051u, 3079358544u, 1065468582u, 0, EXPM1F_TOLERANCE, 0},
{1363, 1060320051u, 3079358544u, 1065468582u, 0, EXPM1F_TOLERANCE, 0},
{1364, 1060320051u, 3079358544u, 1065468582u, 0, EXPM1F_TOLERANCE, 0},
{1365, 1060320051u, 3079358544u, 1065468582u, 0, EXPM1F_TOLERANCE, 0},
{1366, 1060320051u, 3079358544u, 1065468582u, 0, EXPM1F_TOLERANCE, 0},
{1367, 1060320051u, 3079358544u, 1065468582u, 0, EXPM1F_TOLERANCE, 0},
{1368, 1060320051u, 3079358544u, 1065468582u, 0, EXPM1F_TOLERANCE, 0},
{1369, 1060320051u, 3079358544u, 1065468582u, 0, EXPM1F_TOLERANCE, 0},
{1370, 1060320051u, 3079358544u, 1065468582u, 0, EXPM1F_TOLERANCE, 0},
{1371, 1060320051u, 3079358544u, 1065468582u, 0, EXPM1F_TOLERANCE, 0},
{1372, 1060320051u, 3079358544u, 1065468582u, 0, EXPM1F_TOLERANCE, 0},
{1373, 1060320051u, 3079358544u, 1065468582u, 0, EXPM1F_TOLERANCE, 0},
{1374, 1060320051u, 3079358544u, 1065468582u, 0, EXPM1F_TOLERANCE, 0},
{1375, 1060320051u, 3079358544u, 1065468582u, 0, EXPM1F_TOLERANCE, 0},
{1376, 1060320051u, 3079358544u, 1065468582u, 0, EXPM1F_TOLERANCE, 0},
{1377, 1060320051u, 3079358544u, 1065468582u, 0, EXPM1F_TOLERANCE, 0},
{1378, 1060320051u, 3079358544u, 1065468582u, 0, EXPM1F_TOLERANCE, 0},
{1379, 1060320051u, 3079358544u, 1065468582u, 0, EXPM1F_TOLERANCE, 0},
{1380, 1060320051u, 3079358544u, 1065468582u, 0, EXPM1F_TOLERANCE, 0},
{1381, 1060320051u, 3079358544u, 1065468582u, 0, EXPM1F_TOLERANCE, 0},
{1382, 1060320051u, 3079358544u, 1065468582u, 0, EXPM1F_TOLERANCE, 0},
{1383, 1060320051u, 3079358544u, 1065468582u, 0, EXPM1F_TOLERANCE, 0},
{1384, 1060320051u, 3079358544u, 1065468582u, 0, EXPM1F_TOLERANCE, 0},
{1385, 1060320051u, 3079358544u, 1065468582u, 0, EXPM1F_TOLERANCE, 0},
{1386, 1060320051u, 3079358544u, 1065468582u, 0, EXPM1F_TOLERANCE, 0},
{1387, 1060320051u, 3079358544u, 1065468582u, 0, EXPM1F_TOLERANCE, 0},
{1388, 1060320051u, 3079358544u, 1065468582u, 0, EXPM1F_TOLERANCE, 0},
{1389, 1060320051u, 3079358544u, 1065468582u, 0, EXPM1F_TOLERANCE, 0},
{1390, 1060320051u, 3079358544u, 1065468582u, 0, EXPM1F_TOLERANCE, 0},
{1391, 1060320051u, 3079358544u, 1065468582u, 0, EXPM1F_TOLERANCE, 0},
{1392, 1060320051u, 3079358544u, 1065468582u, 0, EXPM1F_TOLERANCE, 0},
{1393, 1060320051u, 3079358544u, 1065468582u, 0, EXPM1F_TOLERANCE, 0},
{1394, 1060320051u, 3079358544u, 1065468582u, 0, EXPM1F_TOLERANCE, 0},
{1395, 1060320051u, 3079358544u, 1065468582u, 0, EXPM1F_TOLERANCE, 0},
{1396, 1060320051u, 3079358544u, 1065468582u, 0, EXPM1F_TOLERANCE, 0},
{1397, 1060320051u, 3079358544u, 1065468582u, 0, EXPM1F_TOLERANCE, 0},
{1398, 1060320051u, 3079358544u, 1065468582u, 0, EXPM1F_TOLERANCE, 0},
{1399, 1060320051u, 3079358544u, 1065468582u, 0, EXPM1F_TOLERANCE, 0},
{1400, 1061158912u, 3079358544u, 1066334683u, 0, EXPM1F_TOLERANCE, 0},
{1401, 1061158912u, 3079358544u, 1066334683u, 0, EXPM1F_TOLERANCE, 0},
{1402, 1061158912u, 3079358544u, 1066334683u, 0, EXPM1F_TOLERANCE, 0},
{1403, 1061158912u, 3079358544u, 1066334683u, 0, EXPM1F_TOLERANCE, 0},
{1404, 1061158912u, 3079358544u, 1066334683u, 0, EXPM1F_TOLERANCE, 0},
{1405, 1061158912u, 3079358544u, 1066334683u, 0, EXPM1F_TOLERANCE, 0},
{1406, 1061158912u, 3079358544u, 1066334683u, 0, EXPM1F_TOLERANCE, 0},
{1407, 1061158912u, 3079358544u, 1066334683u, 0, EXPM1F_TOLERANCE, 0},
{1408, 1061158912u, 3079358544u, 1066334683u, 0, EXPM1F_TOLERANCE, 0},
{1409, 1061158912u, 3079358544u, 1066334683u, 0, EXPM1F_TOLERANCE, 0},
{1410, 1061158912u, 3079358544u, 1066334683u, 0, EXPM1F_TOLERANCE, 0},
{1411, 1061158912u, 3079358544u, 1066334683u, 0, EXPM1F_TOLERANCE, 0},
{1412, 1061158912u, 3079358544u, 1066334683u, 0, EXPM1F_TOLERANCE, 0},
{1413, 1061158912u, 3079358544u, 1066334683u, 0, EXPM1F_TOLERANCE, 0},
{1414, 1061158912u, 3079358544u, 1066334683u, 0, EXPM1F_TOLERANCE, 0},
{1415, 1061158912u, 3079358544u, 1066334683u, 0, EXPM1F_TOLERANCE, 0},
{1416, 1061158912u, 3079358544u, 1066334683u, 0, EXPM1F_TOLERANCE, 0},
{1417, 1061158912u, 3079358544u, 1066334683u, 0, EXPM1F_TOLERANCE, 0},
{1418, 1061158912u, 3079358544u, 1066334683u, 0, EXPM1F_TOLERANCE, 0},
{1419, 1061158912u, 3079358544u, 1066334683u, 0, EXPM1F_TOLERANCE, 0},
{1420, 1061158912u, 3079358544u, 1066334683u, 0, EXPM1F_TOLERANCE, 0},
{1421, 1061158912u, 3079358544u, 1066334683u, 0, EXPM1F_TOLERANCE, 0},
{1422, 1061158912u, 3079358544u, 1066334683u, 0, EXPM1F_TOLERANCE, 0},
{1423, 1061158912u, 3079358544u, 1066334683u, 0, EXPM1F_TOLERANCE, 0},
{1424, 1061158912u, 3079358544u, 1066334683u, 0, EXPM1F_TOLERANCE, 0},
{1425, 1061158912u, 3079358544u, 1066334683u, 0, EXPM1F_TOLERANCE, 0},
{1426, 1061158912u, 3079358544u, 1066334683u, 0, EXPM1F_TOLERANCE, 0},
{1427, 1061158912u, 3079358544u, 1066334683u, 0, EXPM1F_TOLERANCE, 0},
{1428, 1061158912u, 3079358544u, 1066334683u, 0, EXPM1F_TOLERANCE, 0},
{1429, 1061158912u, 3079358544u, 1066334683u, 0, EXPM1F_TOLERANCE, 0},
{1430, 1061158912u, 3079358544u, 1066334683u, 0, EXPM1F_TOLERANCE, 0},
{1431, 1061158912u, 3079358544u, 1066334683u, 0, EXPM1F_TOLERANCE, 0},
{1432, 1061158912u, 3079358544u, 1066334683u, 0, EXPM1F_TOLERANCE, 0},
{1433, 1061158912u, 3079358544u, 1066334683u, 0, EXPM1F_TOLERANCE, 0},
{1434, 1061158912u, 3079358544u, 1066334683u, 0, EXPM1F_TOLERANCE, 0},
{1435, 1061158912u, 3079358544u, 1066334683u, 0, EXPM1F_TOLERANCE, 0},
{1436, 1061158912u, 3079358544u, 1066334683u, 0, EXPM1F_TOLERANCE, 0},
{1437, 1061158912u, 3079358544u, 1066334683u, 0, EXPM1F_TOLERANCE, 0},
{1438, 1061158912u, 3079358544u, 1066334683u, 0, EXPM1F_TOLERANCE, 0},
{1439, 1061158912u, 3079358544u, 1066334683u, 0, EXPM1F_TOLERANCE, 0},
{1440, 1061997773u, 3079358544u, 1067245191u, 0, EXPM1F_TOLERANCE, 0},
{1441, 1061997773u, 3079358544u, 1067245191u, 0, EXPM1F_TOLERANCE, 0},
{1442, 1061997773u, 3079358544u, 1067245191u, 0, EXPM1F_TOLERANCE, 0},
{1443, 1061997773u, 3079358544u, 1067245191u, 0, EXPM1F_TOLERANCE, 0},
{1444, 1061997773u, 3079358544u, 1067245191u, 0, EXPM1F_TOLERANCE, 0},
{1445, 1061997773u, 3079358544u, 1067245191u, 0, EXPM1F_TOLERANCE, 0},
{1446, 1061997773u, 3079358544u, 1067245191u, 0, EXPM1F_TOLERANCE, 0},
{1447, 1061997773u, 3079358544u, 1067245191u, 0, EXPM1F_TOLERANCE, 0},
{1448, 1061997773u, 3079358544u, 1067245191u, 0, EXPM1F_TOLERANCE, 0},
{1449, 1061997773u, 3079358544u, 1067245191u, 0, EXPM1F_TOLERANCE, 0},
{1450, 1061997773u, 3079358544u, 1067245191u, 0, EXPM1F_TOLERANCE, 0},
{1451, 1061997773u, 3079358544u, 1067245191u, 0, EXPM1F_TOLERANCE, 0},
{1452, 1061997773u, 3079358544u, 1067245191u, 0, EXPM1F_TOLERANCE, 0},
{1453, 1061997773u, 3079358544u, 1067245191u, 0, EXPM1F_TOLERANCE, 0},
{1454, 1061997773u, 3079358544u, 1067245191u, 0, EXPM1F_TOLERANCE, 0},
{1455, 1061997773u, 3079358544u, 1067245191u, 0, EXPM1F_TOLERANCE, 0},
{1456, 1061997773u, 3079358544u, 1067245191u, 0, EXPM1F_TOLERANCE, 0},
{1457, 1061997773u, 3079358544u, 1067245191u, 0, EXPM1F_TOLERANCE, 0},
{1458, 1061997773u, 3079358544u, 1067245191u, 0, EXPM1F_TOLERANCE, 0},
{1459, 1061997773u, 3079358544u, 1067245191u, 0, EXPM1F_TOLERANCE, 0},
{1460, 1061997773u, 3079358544u, 1067245191u, 0, EXPM1F_TOLERANCE, 0},
{1461, 1061997773u, 3079358544u, 1067245191u, 0, EXPM1F_TOLERANCE, 0},
{1462, 1061997773u, 3079358544u, 1067245191u, 0, EXPM1F_TOLERANCE, 0},
{1463, 1061997773u, 3079358544u, 1067245191u, 0, EXPM1F_TOLERANCE, 0},
{1464, 1061997773u, 3079358544u, 1067245191u, 0, EXPM1F_TOLERANCE, 0},
{1465, 1061997773u, 3079358544u, 1067245191u, 0, EXPM1F_TOLERANCE, 0},
{1466, 1061997773u, 3079358544u, 1067245191u, 0, EXPM1F_TOLERANCE, 0},
{1467, 1061997773u, 3079358544u, 1067245191u, 0, EXPM1F_TOLERANCE, 0},
{1468, 1061997773u, 3079358544u, 1067245191u, 0, EXPM1F_TOLERANCE, 0},
{1469, 1061997773u, 3079358544u, 1067245191u, 0, EXPM1F_TOLERANCE, 0},
{1470, 1061997773u, 3079358544u, 1067245191u, 0, EXPM1F_TOLERANCE, 0},
{1471, 1061997773u, 3079358544u, 1067245191u, 0, EXPM1F_TOLERANCE, 0},
{1472, 1061997773u, 3079358544u, 1067245191u, 0, EXPM1F_TOLERANCE, 0},
{1473, 1061997773u, 3079358544u, 1067245191u, 0, EXPM1F_TOLERANCE, 0},
{1474, 1061997773u, 3079358544u, 1067245191u, 0, EXPM1F_TOLERANCE, 0},
{1475, 1061997773u, 3079358544u, 1067245191u, 0, EXPM1F_TOLERANCE, 0},
{1476, 1061997773u, 3079358544u, 1067245191u, 0, EXPM1F_TOLERANCE, 0},
{1477, 1061997773u, 3079358544u, 1067245191u, 0, EXPM1F_TOLERANCE, 0},
{1478, 1061997773u, 3079358544u, 1067245191u, 0, EXPM1F_TOLERANCE, 0},
{1479, 1061997773u, 3079358544u, 1067245191u, 0, EXPM1F_TOLERANCE, 0},
{1480, 1062836634u, 3079358544u, 1068202381u, 0, EXPM1F_TOLERANCE, 0},
{1481, 1062836634u, 3079358544u, 1068202381u, 0, EXPM1F_TOLERANCE, 0},
{1482, 1062836634u, 3079358544u, 1068202381u, 0, EXPM1F_TOLERANCE, 0},
{1483, 1062836634u, 3079358544u, 1068202381u, 0, EXPM1F_TOLERANCE, 0},
{1484, 1062836634u, 3079358544u, 1068202381u, 0, EXPM1F_TOLERANCE, 0},
{1485, 1062836634u, 3079358544u, 1068202381u, 0, EXPM1F_TOLERANCE, 0},
{1486, 1062836634u, 3079358544u, 1068202381u, 0, EXPM1F_TOLERANCE, 0},
{1487, 1062836634u, 3079358544u, 1068202381u, 0, EXPM1F_TOLERANCE, 0},
{1488, 1062836634u, 3079358544u, 1068202381u, 0, EXPM1F_TOLERANCE, 0},
{1489, 1062836634u, 3079358544u, 1068202381u, 0, EXPM1F_TOLERANCE, 0},
{1490, 1062836634u, 3079358544u, 1068202381u, 0, EXPM1F_TOLERANCE, 0},
{1491, 1062836634u, 3079358544u, 1068202381u, 0, EXPM1F_TOLERANCE, 0},
{1492, 1062836634u, 3079358544u, 1068202381u, 0, EXPM1F_TOLERANCE, 0},
{1493, 1062836634u, 3079358544u, 1068202381u, 0, EXPM1F_TOLERANCE, 0},
{1494, 1062836634u, 3079358544u, 1068202381u, 0, EXPM1F_TOLERANCE, 0},
{1495, 1062836634u, 3079358544u, 1068202381u, 0, EXPM1F_TOLERANCE, 0},
{1496, 1062836634u, 3079358544u, 1068202381u, 0, EXPM1F_TOLERANCE, 0},
{1497, 1062836634u, 3079358544u, 1068202381u, 0, EXPM1F_TOLERANCE, 0},
{1498, 1062836634u, 3079358544u, 1068202381u, 0, EXPM1F_TOLERANCE, 0},
{1499, 1062836634u, 3079358544u, 1068202381u, 0, EXPM1F_TOLERANCE, 0},
{1500, 1062836634u, 3079358544u, 1068202381u, 0, EXPM1F_TOLERANCE, 0},
{1501, 1062836634u, 3079358544u, 1068202381u, 0, EXPM1F_TOLERANCE, 0},
{1502, 1062836634u, 3079358544u, 1068202381u, 0, EXPM1F_TOLERANCE, 0},
{1503, 1062836634u, 3079358544u, 1068202381u, 0, EXPM1F_TOLERANCE, 0},
{1504, 1062836634u, 3079358544u, 1068202381u, 0, EXPM1F_TOLERANCE, 0},
{1505, 1062836634u, 3079358544u, 1068202381u, 0, EXPM1F_TOLERANCE, 0},
{1506, 1062836634u, 3079358544u, 1068202381u, 0, EXPM1F_TOLERANCE, 0},
{1507, 1062836634u, 3079358544u, 1068202381u, 0, EXPM1F_TOLERANCE, 0},
{1508, 1062836634u, 3079358544u, 1068202381u, 0, EXPM1F_TOLERANCE, 0},
{1509, 1062836634u, 3079358544u, 1068202381u, 0, EXPM1F_TOLERANCE, 0},
{1510, 1062836634u, 3079358544u, 1068202381u, 0, EXPM1F_TOLERANCE, 0},
{1511, 1062836634u, 3079358544u, 1068202381u, 0, EXPM1F_TOLERANCE, 0},
{1512, 1062836634u, 3079358544u, 1068202381u, 0, EXPM1F_TOLERANCE, 0},
{1513, 1062836634u, 3079358544u, 1068202381u, 0, EXPM1F_TOLERANCE, 0},
{1514, 1062836634u, 3079358544u, 1068202381u, 0, EXPM1F_TOLERANCE, 0},
{1515, 1062836634u, 3079358544u, 1068202381u, 0, EXPM1F_TOLERANCE, 0},
{1516, 1062836634u, 3079358544u, 1068202381u, 0, EXPM1F_TOLERANCE, 0},
{1517, 1062836634u, 3079358544u, 1068202381u, 0, EXPM1F_TOLERANCE, 0},
{1518, 1062836634u, 3079358544u, 1068202381u, 0, EXPM1F_TOLERANCE, 0},
{1519, 1062836634u, 3079358544u, 1068202381u, 0, EXPM1F_TOLERANCE, 0},
{1520, 1063675494u, 3079358544u, 1069208646u, 0, EXPM1F_TOLERANCE, 0},
{1521, 1063675494u, 3079358544u, 1069208646u, 0, EXPM1F_TOLERANCE, 0},
{1522, 1063675494u, 3079358544u, 1069208646u, 0, EXPM1F_TOLERANCE, 0},
{1523, 1063675494u, 3079358544u, 1069208646u, 0, EXPM1F_TOLERANCE, 0},
{1524, 1063675494u, 3079358544u, 1069208646u, 0, EXPM1F_TOLERANCE, 0},
{1525, 1063675494u, 3079358544u, 1069208646u, 0, EXPM1F_TOLERANCE, 0},
{1526, 1063675494u, 3079358544u, 1069208646u, 0, EXPM1F_TOLERANCE, 0},
{1527, 1063675494u, 3079358544u, 1069208646u, 0, EXPM1F_TOLERANCE, 0},
{1528, 1063675494u, 3079358544u, 1069208646u, 0, EXPM1F_TOLERANCE, 0},
{1529, 1063675494u, 3079358544u, 1069208646u, 0, EXPM1F_TOLERANCE, 0},
{1530, 1063675494u, 3079358544u, 1069208646u, 0, EXPM1F_TOLERANCE, 0},
{1531, 1063675494u, 3079358544u, 1069208646u, 0, EXPM1F_TOLERANCE, 0},
{1532, 1063675494u, 3079358544u, 1069208646u, 0, EXPM1F_TOLERANCE, 0},
{1533, 1063675494u, 3079358544u, 1069208646u, 0, EXPM1F_TOLERANCE, 0},
{1534, 1063675494u, 3079358544u, 1069208646u, 0, EXPM1F_TOLERANCE, 0},
{1535, 1063675494u, 3079358544u, 1069208646u, 0, EXPM1F_TOLERANCE, 0},
{1536, 1063675494u, 3079358544u, 1069208646u, 0, EXPM1F_TOLERANCE, 0},
{1537, 1063675494u, 3079358544u, 1069208646u, 0, EXPM1F_TOLERANCE, 0},
{1538, 1063675494u, 3079358544u, 1069208646u, 0, EXPM1F_TOLERANCE, 0},
{1539, 1063675494u, 3079358544u, 1069208646u, 0, EXPM1F_TOLERANCE, 0},
{1540, 1063675494u, 3079358544u, 1069208646u, 0, EXPM1F_TOLERANCE, 0},
{1541, 1063675494u, 3079358544u, 1069208646u, 0, EXPM1F_TOLERANCE, 0},
{1542, 1063675494u, 3079358544u, 1069208646u, 0, EXPM1F_TOLERANCE, 0},
{1543, 1063675494u, 3079358544u, 1069208646u, 0, EXPM1F_TOLERANCE, 0},
{1544, 1063675494u, 3079358544u, 1069208646u, 0, EXPM1F_TOLERANCE, 0},
{1545, 1063675494u, 3079358544u, 1069208646u, 0, EXPM1F_TOLERANCE, 0},
{1546, 1063675494u, 3079358544u, 1069208646u, 0, EXPM1F_TOLERANCE, 0},
{1547, 1063675494u, 3079358544u, 1069208646u, 0, EXPM1F_TOLERANCE, 0},
{1548, 1063675494u, 3079358544u, 1069208646u, 0, EXPM1F_TOLERANCE, 0},
{1549, 1063675494u, 3079358544u, 1069208646u, 0, EXPM1F_TOLERANCE, 0},
{1550, 1063675494u, 3079358544u, 1069208646u, 0, EXPM1F_TOLERANCE, 0},
{1551, 1063675494u, 3079358544u, 1069208646u, 0, EXPM1F_TOLERANCE, 0},
{1552, 1063675494u, 3079358544u, 1069208646u, 0, EXPM1F_TOLERANCE, 0},
{1553, 1063675494u, 3079358544u, 1069208646u, 0, EXPM1F_TOLERANCE, 0},
{1554, 1063675494u, 3079358544u, 1069208646u, 0, EXPM1F_TOLERANCE, 0},
{1555, 1063675494u, 3079358544u, 1069208646u, 0, EXPM1F_TOLERANCE, 0},
{1556, 1063675494u, 3079358544u, 1069208646u, 0, EXPM1F_TOLERANCE, 0},
{1557, 1063675494u, 3079358544u, 1069208646u, 0, EXPM1F_TOLERANCE, 0},
{1558, 1063675494u, 3079358544u, 1069208646u, 0, EXPM1F_TOLERANCE, 0},
{1559, 1063675494u, 3079358544u, 1069208646u, 0, EXPM1F_TOLERANCE, 0},
{1560, 1064514355u, 3079358544u, 1070266504u, 0, EXPM1F_TOLERANCE, 0},
{1561, 1064514355u, 3079358544u, 1070266504u, 0, EXPM1F_TOLERANCE, 0},
{1562, 1064514355u, 3079358544u, 1070266504u, 0, EXPM1F_TOLERANCE, 0},
{1563, 1064514355u, 3079358544u, 1070266504u, 0, EXPM1F_TOLERANCE, 0},
{1564, 1064514355u, 3079358544u, 1070266504u, 0, EXPM1F_TOLERANCE, 0},
{1565, 1064514355u, 3079358544u, 1070266504u, 0, EXPM1F_TOLERANCE, 0},
{1566, 1064514355u, 3079358544u, 1070266504u, 0, EXPM1F_TOLERANCE, 0},
{1567, 1064514355u, 3079358544u, 1070266504u, 0, EXPM1F_TOLERANCE, 0},
{1568, 1064514355u, 3079358544u, 1070266504u, 0, EXPM1F_TOLERANCE, 0},
{1569, 1064514355u, 3079358544u, 1070266504u, 0, EXPM1F_TOLERANCE, 0},
{1570, 1064514355u, 3079358544u, 1070266504u, 0, EXPM1F_TOLERANCE, 0},
{1571, 1064514355u, 3079358544u, 1070266504u, 0, EXPM1F_TOLERANCE, 0},
{1572, 1064514355u, 3079358544u, 1070266504u, 0, EXPM1F_TOLERANCE, 0},
{1573, 1064514355u, 3079358544u, 1070266504u, 0, EXPM1F_TOLERANCE, 0},
{1574, 1064514355u, 3079358544u, 1070266504u, 0, EXPM1F_TOLERANCE, 0},
{1575, 1064514355u, 3079358544u, 1070266504u, 0, EXPM1F_TOLERANCE, 0},
{1576, 1064514355u, 3079358544u, 1070266504u, 0, EXPM1F_TOLERANCE, 0},
{1577, 1064514355u, 3079358544u, 1070266504u, 0, EXPM1F_TOLERANCE, 0},
{1578, 1064514355u, 3079358544u, 1070266504u, 0, EXPM1F_TOLERANCE, 0},
{1579, 1064514355u, 3079358544u, 1070266504u, 0, EXPM1F_TOLERANCE, 0},
{1580, 1064514355u, 3079358544u, 1070266504u, 0, EXPM1F_TOLERANCE, 0},
{1581, 1064514355u, 3079358544u, 1070266504u, 0, EXPM1F_TOLERANCE, 0},
{1582, 1064514355u, 3079358544u, 1070266504u, 0, EXPM1F_TOLERANCE, 0},
{1583, 1064514355u, 3079358544u, 1070266504u, 0, EXPM1F_TOLERANCE, 0},
{1584, 1064514355u, 3079358544u, 1070266504u, 0, EXPM1F_TOLERANCE, 0},
{1585, 1064514355u, 3079358544u, 1070266504u, 0, EXPM1F_TOLERANCE, 0},
{1586, 1064514355u, 3079358544u, 1070266504u, 0, EXPM1F_TOLERANCE, 0},
{1587, 1064514355u, 3079358544u, 1070266504u, 0, EXPM1F_TOLERANCE, 0},
{1588, 1064514355u, 3079358544u, 1070266504u, 0, EXPM1F_TOLERANCE, 0},
{1589, 1064514355u, 3079358544u, 1070266504u, 0, EXPM1F_TOLERANCE, 0},
{1590, 1064514355u, 3079358544u, 1070266504u, 0, EXPM1F_TOLERANCE, 0},
{1591, 1064514355u, 3079358544u, 1070266504u, 0, EXPM1F_TOLERANCE, 0},
{1592, 1064514355u, 3079358544u, 1070266504u, 0, EXPM1F_TOLERANCE, 0},
{1593, 1064514355u, 3079358544u, 1070266504u, 0, EXPM1F_TOLERANCE, 0},
{1594, 1064514355u, 3079358544u, 1070266504u, 0, EXPM1F_TOLERANCE, 0},
{1595, 1064514355u, 3079358544u, 1070266504u, 0, EXPM1F_TOLERANCE, 0},
{1596, 1064514355u, 3079358544u, 1070266504u, 0, EXPM1F_TOLERANCE, 0},
{1597, 1064514355u, 3079358544u, 1070266504u, 0, EXPM1F_TOLERANCE, 0},
{1598, 1064514355u, 3079358544u, 1070266504u, 0, EXPM1F_TOLERANCE, 0},
{1599, 1064514355u, 3079358544u, 1070266504u, 0, EXPM1F_TOLERANCE, 0},
{1600, 1107800421u, 3079358544u, 1475721455u, 0, EXPM1F_TOLERANCE, 0},
{1601, 3196650934u, 3079358544u, 3195039781u, 0, EXPM1F_TOLERANCE, 0},
{1602, 3368700125u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1603, 1224242132u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1604, 3221027117u, 3079358544u, 3210511986u, 0, EXPM1F_TOLERANCE, 0},
{1605, 1198712763u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1606, 3159309973u, 3079358544u, 3159224434u, 0, EXPM1F_TOLERANCE, 0},
{1607, 954173073u, 3079358544u, 954173854u, 0, EXPM1F_TOLERANCE, 0},
{1608, 3090780435u, 3079358544u, 3090780166u, 0, EXPM1F_TOLERANCE, 0},
{1609, 966554515u, 3079358544u, 966556045u, 0, EXPM1F_TOLERANCE, 0},
{1610, 1312607135u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1611, 1166191415u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1612, 3111900019u, 3079358544u, 3111898037u, 0, EXPM1F_TOLERANCE, 0},
{1613, 1234419246u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1614, 1302107128u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1615, 1052801068u, 3079358544u, 1055499152u, 0, EXPM1F_TOLERANCE, 0},
{1616, 1060849628u, 3079358544u, 1066010305u, 0, EXPM1F_TOLERANCE, 0},
{1617, 3484320003u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1618, 3181522772u, 3079358544u, 3181112802u, 0, EXPM1F_TOLERANCE, 0},
{1619, 882596369u, 3079358544u, 882596370u, 0, EXPM1F_TOLERANCE, 0},
{1620, 1167223673u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1621, 968192794u, 3079358544u, 968194852u, 0, EXPM1F_TOLERANCE, 0},
{1622, 3122346862u, 3079358544u, 3122343850u, 0, EXPM1F_TOLERANCE, 0},
{1623, 1052361612u, 3079358544u, 1054863334u, 0, EXPM1F_TOLERANCE, 0},
{1624, 906701409u, 3079358544u, 906701418u, 0, EXPM1F_TOLERANCE, 0},
{1625, 3471653172u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1626, 3231467496u, 3079358544u, 3212709888u, 0, EXPM1F_TOLERANCE, 0},
{1627, 1341514497u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1628, 1272351391u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1629, 3319724992u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1630, 917622040u, 3079358544u, 917622071u, 0, EXPM1F_TOLERANCE, 0},
{1631, 940236348u, 3079358544u, 940236499u, 0, EXPM1F_TOLERANCE, 0},
{1632, 3251541546u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1633, 3099843889u, 3079358544u, 3099843290u, 0, EXPM1F_TOLERANCE, 0},
{1634, 3110358400u, 3079358544u, 3110356771u, 0, EXPM1F_TOLERANCE, 0},
{1635, 3371863479u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1636, 3204069187u, 3079358544u, 3200642460u, 0, EXPM1F_TOLERANCE, 0},
{1637, 1306460502u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1638, 1197542187u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1639, 922888249u, 3079358544u, 922888282u, 0, EXPM1F_TOLERANCE, 0},
{1640, 1184239996u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1641, 1252490238u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1642, 1001673627u, 3079358544u, 1001706204u, 0, EXPM1F_TOLERANCE, 0},
{1643, 976098044u, 3079358544u, 976101833u, 0, EXPM1F_TOLERANCE, 0},
{1644, 941796645u, 3079358544u, 941796852u, 0, EXPM1F_TOLERANCE, 0},
{1645, 3287199470u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1646, 893184329u, 3079358544u, 893184333u, 0, EXPM1F_TOLERANCE, 0},
{1647, 1143233714u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1648, 1139941253u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1649, 3143717025u, 3079358544u, 3143691671u, 0, EXPM1F_TOLERANCE, 0},
{1650, 3048866608u, 3079358544u, 3048866600u, 0, EXPM1F_TOLERANCE, 0},
{1651, 3240298487u, 3079358544u, 3212836234u, 0, EXPM1F_TOLERANCE, 0},
{1652, 1288902137u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1653, 1333134799u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1654, 1187847971u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1655, 1038851706u, 3079358544u, 1039775034u, 0, EXPM1F_TOLERANCE, 0},
{1656, 3329354473u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1657, 3077218579u, 3079358544u, 3077218471u, 0, EXPM1F_TOLERANCE, 0},
{1658, 1309289088u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1659, 3444653659u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1660, 3405585402u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1661, 3106647724u, 3079358544u, 3106646803u, 0, EXPM1F_TOLERANCE, 0},
{1662, 1106778573u, 3079358544u, 1440090537u, 0, EXPM1F_TOLERANCE, 0},
{1663, 1140567947u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1664, 1238569473u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1665, 3154871957u, 3079358544u, 3154833132u, 0, EXPM1F_TOLERANCE, 0},
{1666, 1261071232u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1667, 1175011025u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1668, 1082692850u, 3079358544u, 1116522639u, 0, EXPM1F_TOLERANCE, 0},
{1669, 974547519u, 3079358544u, 974550348u, 0, EXPM1F_TOLERANCE, 0},
{1670, 3058097085u, 3079358544u, 3058097066u, 0, EXPM1F_TOLERANCE, 0},
{1671, 3107252546u, 3079358544u, 3107251523u, 0, EXPM1F_TOLERANCE, 0},
{1672, 3096032662u, 3079358544u, 3096032366u, 0, EXPM1F_TOLERANCE, 0},
{1673, 3197942144u, 3079358544u, 3196518976u, 0, EXPM1F_TOLERANCE, 0},
{1674, 3403348556u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1675, 3182301130u, 3079358544u, 3181829817u, 0, EXPM1F_TOLERANCE, 0},
{1676, 1136411063u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1677, 3239231622u, 3079358544u, 3212835121u, 0, EXPM1F_TOLERANCE, 0},
{1678, 3340615780u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1679, 998567360u, 3079358544u, 998585054u, 0, EXPM1F_TOLERANCE, 0},
{1680, 3417964312u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1681, 3109481038u, 3079358544u, 3109479595u, 0, EXPM1F_TOLERANCE, 0},
{1682, 1148867223u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1683, 989687421u, 3079358544u, 989703488u, 0, EXPM1F_TOLERANCE, 0},
{1684, 1152956913u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1685, 892922651u, 3079358544u, 892922655u, 0, EXPM1F_TOLERANCE, 0},
{1686, 1109627625u, 3079358544u, 1560243939u, 0, EXPM1F_TOLERANCE, 0},
{1687, 1307091856u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1688, 1077234132u, 3079358544u, 1098897272u, 0, EXPM1F_TOLERANCE, 0},
{1689, 1142167709u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1690, 3426232834u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1691, 3368566779u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1692, 3030724760u, 3079358544u, 3030724758u, 0, EXPM1F_TOLERANCE, 0},
{1693, 1138741813u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1694, 982950501u, 3079358544u, 982956176u, 0, EXPM1F_TOLERANCE, 0},
{1695, 1142981585u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1696, 3347165962u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1697, 1009535440u, 3079358544u, 1009595015u, 0, EXPM1F_TOLERANCE, 0},
{1698, 3103736980u, 3079358544u, 3103735962u, 0, EXPM1F_TOLERANCE, 0},
{1699, 3126820946u, 3079358544u, 3126814704u, 0, EXPM1F_TOLERANCE, 0},
{1700, 3473956030u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1701, 3349098349u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1702, 3152729489u, 3079358544u, 3152674473u, 0, EXPM1F_TOLERANCE, 0},
{1703, 945568720u, 3079358544u, 945569099u, 0, EXPM1F_TOLERANCE, 0},
{1704, 3345489836u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1705, 940893161u, 3079358544u, 940893334u, 0, EXPM1F_TOLERANCE, 0},
{1706, 976791751u, 3079358544u, 976796014u, 0, EXPM1F_TOLERANCE, 0},
{1707, 1004442355u, 3079358544u, 1004492007u, 0, EXPM1F_TOLERANCE, 0},
{1708, 1108485380u, 3079358544u, 1506899287u, 0, EXPM1F_TOLERANCE, 0},
{1709, 1061834641u, 3079358544u, 1067064542u, 0, EXPM1F_TOLERANCE, 0},
{1710, 3381268392u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1711, 1087189715u, 3079358544u, 1142429899u, 0, EXPM1F_TOLERANCE, 0},
{1712, 3212952285u, 3079358544u, 3206749212u, 0, EXPM1F_TOLERANCE, 0},
{1713, 1000611335u, 3079358544u, 1000638315u, 0, EXPM1F_TOLERANCE, 0},
{1714, 3466188568u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1715, 3072456205u, 3079358544u, 3072456154u, 0, EXPM1F_TOLERANCE, 0},
{1716, 3319315516u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1717, 935938416u, 3079358544u, 935938574u, 0, EXPM1F_TOLERANCE, 0},
{1718, 3212614372u, 3079358544u, 3206582476u, 0, EXPM1F_TOLERANCE, 0},
{1719, 1315030230u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1720, 1134593658u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1721, 977281449u, 3079358544u, 977286064u, 0, EXPM1F_TOLERANCE, 0},
{1722, 1086198791u, 3079358544u, 1136489724u, 0, EXPM1F_TOLERANCE, 0},
{1723, 1255152035u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1724, 1135271264u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1725, 1094190727u, 3079358544u, 1203837979u, 0, EXPM1F_TOLERANCE, 0},
{1726, 1294665325u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1727, 1036608591u, 3079358544u, 1037279334u, 0, EXPM1F_TOLERANCE, 0},
{1728, 3229998064u, 3079358544u, 3212580992u, 0, EXPM1F_TOLERANCE, 0},
{1729, 3439134022u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1730, 3073083133u, 3079358544u, 3073083076u, 0, EXPM1F_TOLERANCE, 0},
{1731, 1325668223u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1732, 1092037607u, 3079358544u, 1179005485u, 0, EXPM1F_TOLERANCE, 0},
{1733, 3316278408u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1734, 3295436768u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1735, 1151984049u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1736, 1129287043u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1737, 1243664530u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1738, 950829092u, 3079358544u, 950829557u, 0, EXPM1F_TOLERANCE, 0},
{1739, 1115471979u, 3079358544u, 1829706150u, 0, EXPM1F_TOLERANCE, 0},
{1740, 3351092088u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1741, 3424479544u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1742, 3241193975u, 3079358544u, 3212836596u, 0, EXPM1F_TOLERANCE, 0},
{1743, 1030934236u, 3079358544u, 1031415341u, 0, EXPM1F_TOLERANCE, 0},
{1744, 3131791114u, 3079358544u, 3131783778u, 0, EXPM1F_TOLERANCE, 0},
{1745, 1025254314u, 3079358544u, 1025451852u, 0, EXPM1F_TOLERANCE, 0},
{1746, 1110545760u, 3079358544u, 1602518190u, 0, EXPM1F_TOLERANCE, 0},
{1747, 3180213739u, 3079358544u, 3179897519u, 0, EXPM1F_TOLERANCE, 0},
{1748, 3361976590u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1749, 881280146u, 3079358544u, 881280147u, 0, EXPM1F_TOLERANCE, 0},
{1750, 1304154705u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1751, 3264443610u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1752, 3374550627u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1753, 899599265u, 3079358544u, 899599271u, 0, EXPM1F_TOLERANCE, 0},
{1754, 1268194719u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1755, 1133420220u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1756, 1161858787u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1757, 3184462258u, 3079358544u, 3183798962u, 0, EXPM1F_TOLERANCE, 0},
{1758, 3295996963u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1759, 1270887389u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1760, 3325193181u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1761, 925657343u, 3079358544u, 925657401u, 0, EXPM1F_TOLERANCE, 0},
{1762, 3115275450u, 3079358544u, 3115273529u, 0, EXPM1F_TOLERANCE, 0},
{1763, 3116607482u, 3079358544u, 3116605090u, 0, EXPM1F_TOLERANCE, 0},
{1764, 3187892415u, 3079358544u, 3187054905u, 0, EXPM1F_TOLERANCE, 0},
{1765, 1189120494u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1766, 889030794u, 3079358544u, 889030798u, 0, EXPM1F_TOLERANCE, 0},
{1767, 1323529208u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1768, 3465768388u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1769, 3426099899u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1770, 3224857113u, 3079358544u, 3211881659u, 0, EXPM1F_TOLERANCE, 0},
{1771, 1065798296u, 3079358544u, 1072621125u, 0, EXPM1F_TOLERANCE, 0},
{1772, 3328989444u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1773, 3357819026u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1774, 1273397670u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1775, 3424831780u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1776, 1257596246u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1777, 1051773536u, 3079358544u, 1054025411u, 0, EXPM1F_TOLERANCE, 0},
{1778, 3294752507u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1779, 3424848725u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1780, 1090870906u, 3079358544u, 1166165113u, 0, EXPM1F_TOLERANCE, 0},
{1781, 1227582289u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1782, 1272325814u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1783, 3359508271u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1784, 1137854355u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1785, 3440773058u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1786, 3101598400u, 3079358544u, 3101597626u, 0, EXPM1F_TOLERANCE, 0},
{1787, 3451216836u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1788, 3437062994u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1789, 1131196082u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1790, 3177294154u, 3079358544u, 3176894149u, 0, EXPM1F_TOLERANCE, 0},
{1791, 3258097678u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1792, 3460915348u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1793, 3303035472u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1794, 1053698677u, 3079358544u, 1056824005u, 0, EXPM1F_TOLERANCE, 0},
{1795, 3396166221u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1796, 3037541131u, 3079358544u, 3037541129u, 0, EXPM1F_TOLERANCE, 0},
{1797, 3458934263u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1798, 1065761827u, 3079358544u, 1072516817u, 0, EXPM1F_TOLERANCE, 0},
{1799, 3025843188u, 3079358544u, 3025843187u, 0, EXPM1F_TOLERANCE, 0},
{1800, 926665223u, 3079358544u, 926665292u, 0, EXPM1F_TOLERANCE, 0},
{1801, 1199816046u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1802, 3333779015u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1803, 948398145u, 3079358544u, 948398431u, 0, EXPM1F_TOLERANCE, 0},
{1804, 3054021468u, 3079358544u, 3054021459u, 0, EXPM1F_TOLERANCE, 0},
{1805, 1080781593u, 3079358544u, 1109022074u, 0, EXPM1F_TOLERANCE, 0},
{1806, 3164749613u, 3079358544u, 3164645009u, 0, EXPM1F_TOLERANCE, 0},
{1807, 3235326590u, 3079358544u, 3212816701u, 0, EXPM1F_TOLERANCE, 0},
{1808, 3118883815u, 3079358544u, 3118880498u, 0, EXPM1F_TOLERANCE, 0},
{1809, 965378004u, 3079358544u, 965379203u, 0, EXPM1F_TOLERANCE, 0},
{1810, 3226990408u, 3079358544u, 3212262474u, 0, EXPM1F_TOLERANCE, 0},
{1811, 3117098218u, 3079358544u, 3117095639u, 0, EXPM1F_TOLERANCE, 0},
{1812, 1283624229u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1813, 970649315u, 3079358544u, 970652311u, 0, EXPM1F_TOLERANCE, 0},
{1814, 959776291u, 3079358544u, 959777315u, 0, EXPM1F_TOLERANCE, 0},
{1815, 3341117305u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1816, 1270734970u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1817, 3454816067u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1818, 917206623u, 3079358544u, 917206652u, 0, EXPM1F_TOLERANCE, 0},
{1819, 1106502045u, 3079358544u, 1434230090u, 0, EXPM1F_TOLERANCE, 0},
{1820, 1157598381u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1821, 3335234513u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1822, 1279489061u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1823, 3157416480u, 3079358544u, 3157353091u, 0, EXPM1F_TOLERANCE, 0},
{1824, 3143920719u, 3079358544u, 3143894661u, 0, EXPM1F_TOLERANCE, 0},
{1825, 1233171235u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1826, 1148920078u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1827, 3064988156u, 3079358544u, 3064988126u, 0, EXPM1F_TOLERANCE, 0},
{1828, 3083619260u, 3079358544u, 3083619097u, 0, EXPM1F_TOLERANCE, 0},
{1829, 1109198803u, 3079358544u, 1539769939u, 0, EXPM1F_TOLERANCE, 0},
{1830, 3219949483u, 3079358544u, 3210193291u, 0, EXPM1F_TOLERANCE, 0},
{1831, 3361149474u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1832, 1207502108u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1833, 1000014431u, 3079358544u, 1000038497u, 0, EXPM1F_TOLERANCE, 0},
{1834, 3161756316u, 3079358544u, 3161637277u, 0, EXPM1F_TOLERANCE, 0},
{1835, 3160728744u, 3079358544u, 3160624446u, 0, EXPM1F_TOLERANCE, 0},
{1836, 1234530539u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1837, 1017843965u, 3079358544u, 1017961839u, 0, EXPM1F_TOLERANCE, 0},
{1838, 951862956u, 3079358544u, 951863510u, 0, EXPM1F_TOLERANCE, 0},
{1839, 3306328852u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1840, 1291910469u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1841, 3027442905u, 3079358544u, 3027442903u, 0, EXPM1F_TOLERANCE, 0},
{1842, 1131927531u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1843, 3449879391u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1844, 970094304u, 3079358544u, 970097073u, 0, EXPM1F_TOLERANCE, 0},
{1845, 1125551064u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1846, 3427296372u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1847, 1198917460u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1848, 3201603336u, 3079358544u, 3199072887u, 0, EXPM1F_TOLERANCE, 0},
{1849, 3114686212u, 3079358544u, 3114684483u, 0, EXPM1F_TOLERANCE, 0},
{1850, 921940707u, 3079358544u, 921940765u, 0, EXPM1F_TOLERANCE, 0},
{1851, 1091906532u, 3079358544u, 1177479087u, 0, EXPM1F_TOLERANCE, 0},
{1852, 3393557778u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1853, 1276853215u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1854, 3462778440u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1855, 3360170117u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1856, 3224245428u, 3079358544u, 3211731684u, 0, EXPM1F_TOLERANCE, 0},
{1857, 1120124467u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1858, 1064364381u, 3079358544u, 1070073474u, 0, EXPM1F_TOLERANCE, 0},
{1859, 1268744779u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1860, 1165195428u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1861, 3044092739u, 3079358544u, 3044092732u, 0, EXPM1F_TOLERANCE, 0},
{1862, 3149469534u, 3079358544u, 3149435340u, 0, EXPM1F_TOLERANCE, 0},
{1863, 3247790039u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1864, 3215244648u, 3079358544u, 3208204851u, 0, EXPM1F_TOLERANCE, 0},
{1865, 3095275931u, 3079358544u, 3095275426u, 0, EXPM1F_TOLERANCE, 0},
{1866, 3059688264u, 3079358544u, 3059688240u, 0, EXPM1F_TOLERANCE, 0},
{1867, 1212717473u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1868, 3275973009u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1869, 3028857014u, 3079358544u, 3028857013u, 0, EXPM1F_TOLERANCE, 0},
{1870, 3391162308u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1871, 1044867873u, 3079358544u, 1046227233u, 0, EXPM1F_TOLERANCE, 0},
{1872, 1089986803u, 3079358544u, 1158708386u, 0, EXPM1F_TOLERANCE, 0},
{1873, 1296314700u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1874, 1251462432u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1875, 3485236902u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1876, 3262169538u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1877, 3080852256u, 3079358544u, 3080852153u, 0, EXPM1F_TOLERANCE, 0},
{1878, 1022211242u, 3079358544u, 1022439460u, 0, EXPM1F_TOLERANCE, 0},
{1879, 884661176u, 3079358544u, 884661178u, 0, EXPM1F_TOLERANCE, 0},
{1880, 3071422941u, 3079358544u, 3071422899u, 0, EXPM1F_TOLERANCE, 0},
{1881, 989762529u, 3079358544u, 989778742u, 0, EXPM1F_TOLERANCE, 0},
{1882, 1295475718u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1883, 1002632518u, 3079358544u, 1002670602u, 0, EXPM1F_TOLERANCE, 0},
{1884, 3404372005u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1885, 3158912530u, 3079358544u, 3158831914u, 0, EXPM1F_TOLERANCE, 0},
{1886, 1125800069u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1887, 3138037576u, 3079358544u, 3138027970u, 0, EXPM1F_TOLERANCE, 0},
{1888, 3108384823u, 3079358544u, 3108383596u, 0, EXPM1F_TOLERANCE, 0},
{1889, 999985470u, 3079358544u, 1000009399u, 0, EXPM1F_TOLERANCE, 0},
{1890, 1189421739u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1891, 3075182644u, 3079358544u, 3075182563u, 0, EXPM1F_TOLERANCE, 0},
{1892, 3028099649u, 3079358544u, 3028099647u, 0, EXPM1F_TOLERANCE, 0},
{1893, 3132541814u, 3079358544u, 3132533464u, 0, EXPM1F_TOLERANCE, 0},
{1894, 1164046161u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1895, 1292596266u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1896, 3469748379u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1897, 1314644642u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1898, 3399813173u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1899, 948775569u, 3079358544u, 948775880u, 0, EXPM1F_TOLERANCE, 0},
{1900, 1034611395u, 3079358544u, 1035092075u, 0, EXPM1F_TOLERANCE, 0},
{1901, 3489122735u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1902, 1181604787u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1903, 3059042077u, 3079358544u, 3059042055u, 0, EXPM1F_TOLERANCE, 0},
{1904, 1043691622u, 3079358544u, 1044810539u, 0, EXPM1F_TOLERANCE, 0},
{1905, 1314588083u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1906, 3141533334u, 3079358544u, 3141514921u, 0, EXPM1F_TOLERANCE, 0},
{1907, 3157534378u, 3079358544u, 3157469706u, 0, EXPM1F_TOLERANCE, 0},
{1908, 3400949680u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1909, 3365581801u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1910, 1110424755u, 3079358544u, 1596391869u, 0, EXPM1F_TOLERANCE, 0},
{1911, 3189917167u, 3079358544u, 3189117326u, 0, EXPM1F_TOLERANCE, 0},
{1912, 969804941u, 3079358544u, 969807595u, 0, EXPM1F_TOLERANCE, 0},
{1913, 1139120919u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1914, 934308144u, 3079358544u, 934308266u, 0, EXPM1F_TOLERANCE, 0},
{1915, 1220524226u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1916, 3162548604u, 3079358544u, 3162460251u, 0, EXPM1F_TOLERANCE, 0},
{1917, 3382391700u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1918, 1156767533u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1919, 3079222483u, 3079358544u, 3079222409u, 0, EXPM1F_TOLERANCE, 0},
{1920, 994934087u, 3079358544u, 994955222u, 0, EXPM1F_TOLERANCE, 0},
{1921, 3185240099u, 3079358544u, 3184499979u, 0, EXPM1F_TOLERANCE, 0},
{1922, 3479873563u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1923, 3424264117u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1924, 3228365887u, 3079358544u, 3212423070u, 0, EXPM1F_TOLERANCE, 0},
{1925, 1035909900u, 3079358544u, 1036510448u, 0, EXPM1F_TOLERANCE, 0},
{1926, 3024951184u, 3079358544u, 3024951183u, 0, EXPM1F_TOLERANCE, 0},
{1927, 1212129651u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1928, 3125775254u, 3079358544u, 3125769871u, 0, EXPM1F_TOLERANCE, 0},
{1929, 1037464105u, 3079358544u, 1038226266u, 0, EXPM1F_TOLERANCE, 0},
{1930, 1311706596u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1931, 918212457u, 3079358544u, 918212491u, 0, EXPM1F_TOLERANCE, 0},
{1932, 1337315179u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1933, 1131358407u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1934, 1156517523u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1935, 3210802820u, 3079358544u, 3205869338u, 0, EXPM1F_TOLERANCE, 0},
{1936, 3337499209u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1937, 3468429030u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1938, 3253515800u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1939, 3055299953u, 3079358544u, 3055299941u, 0, EXPM1F_TOLERANCE, 0},
{1940, 959956547u, 3079358544u, 959957602u, 0, EXPM1F_TOLERANCE, 0},
{1941, 3425290480u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1942, 1039917375u, 3079358544u, 1040581395u, 0, EXPM1F_TOLERANCE, 0},
{1943, 3220979495u, 3079358544u, 3210498750u, 0, EXPM1F_TOLERANCE, 0},
{1944, 1311016004u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1945, 1128016396u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1946, 3210335769u, 3079358544u, 3205672648u, 0, EXPM1F_TOLERANCE, 0},
{1947, 3022705759u, 3079358544u, 3022705758u, 0, EXPM1F_TOLERANCE, 0},
{1948, 1206054701u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1949, 3144504834u, 3079358544u, 3144476704u, 0, EXPM1F_TOLERANCE, 0},
{1950, 1213609983u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1951, 1246902946u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1952, 995850843u, 3079358544u, 995874955u, 0, EXPM1F_TOLERANCE, 0},
{1953, 3362082828u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1954, 1029480631u, 3079358544u, 1029877131u, 0, EXPM1F_TOLERANCE, 0},
{1955, 3153568584u, 3079358544u, 3153507414u, 0, EXPM1F_TOLERANCE, 0},
{1956, 3384988527u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1957, 1317696241u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1958, 3235395924u, 3079358544u, 3212817357u, 0, EXPM1F_TOLERANCE, 0},
{1959, 3341877624u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1960, 1228636133u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1961, 3161654634u, 3079358544u, 3161537097u, 0, EXPM1F_TOLERANCE, 0},
{1962, 3162655243u, 3079358544u, 3162587700u, 0, EXPM1F_TOLERANCE, 0},
{1963, 1207246237u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1964, 1165476654u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1965, 1215278023u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1966, 1017239798u, 3079358544u, 1017345270u, 0, EXPM1F_TOLERANCE, 0},
{1967, 1149651309u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1968, 1111943722u, 3079358544u, 1666598447u, 0, EXPM1F_TOLERANCE, 0},
{1969, 1189849849u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1970, 3204848496u, 3079358544u, 3201353450u, 0, EXPM1F_TOLERANCE, 0},
{1971, 1249758327u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1972, 3092982276u, 3079358544u, 3092981901u, 0, EXPM1F_TOLERANCE, 0},
{1973, 1168098747u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1974, 892549317u, 3079358544u, 892549321u, 0, EXPM1F_TOLERANCE, 0},
{1975, 3301009024u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1976, 3233089227u, 3079358544u, 3212778266u, 0, EXPM1F_TOLERANCE, 0},
{1977, 3218245284u, 3079358544u, 3209597789u, 0, EXPM1F_TOLERANCE, 0},
{1978, 3215981890u, 3079358544u, 3208594564u, 0, EXPM1F_TOLERANCE, 0},
{1979, 1266687209u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1980, 3487959775u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1981, 943645710u, 3079358544u, 943645995u, 0, EXPM1F_TOLERANCE, 0},
{1982, 3345065699u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1983, 935847271u, 3079358544u, 935847427u, 0, EXPM1F_TOLERANCE, 0},
{1984, 3410336089u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1985, 3082940740u, 3079358544u, 3082940593u, 0, EXPM1F_TOLERANCE, 0},
{1986, 1141063391u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1987, 3059263153u, 3079358544u, 3059263130u, 0, EXPM1F_TOLERANCE, 0},
{1988, 3353679791u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1989, 1001823878u, 3079358544u, 1001857290u, 0, EXPM1F_TOLERANCE, 0},
{1990, 1009130212u, 3079358544u, 1009185581u, 0, EXPM1F_TOLERANCE, 0},
{1991, 3367127535u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1992, 1032920919u, 3079358544u, 1033265990u, 0, EXPM1F_TOLERANCE, 0},
{1993, 3281952870u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1994, 1237868497u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1995, 1153753924u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1996, 1120261759u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{1997, 3226328360u, 3079358544u, 3212164262u, 0, EXPM1F_TOLERANCE, 0},
{1998, 3349595986u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{1999, 3166889490u, 3079358544u, 3166738746u, 0, EXPM1F_TOLERANCE, 0},
{2000, 1087750238u, 3079358544u, 1145489096u, 0, EXPM1F_TOLERANCE, 0},
{2001, 3121620061u, 3079358544u, 3121617464u, 0, EXPM1F_TOLERANCE, 0},
{2002, 1066116543u, 3079358544u, 1073550874u, 0, EXPM1F_TOLERANCE, 0},
{2003, 3210898034u, 3079358544u, 3205908768u, 0, EXPM1F_TOLERANCE, 0},
{2004, 3051923237u, 3079358544u, 3051923224u, 0, EXPM1F_TOLERANCE, 0},
{2005, 1030612298u, 3079358544u, 1031073947u, 0, EXPM1F_TOLERANCE, 0},
{2006, 1186234578u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2007, 1331680743u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2008, 3060774997u, 3079358544u, 3060774969u, 0, EXPM1F_TOLERANCE, 0},
{2009, 887589411u, 3079358544u, 887589414u, 0, EXPM1F_TOLERANCE, 0},
{2010, 1045232522u, 3079358544u, 1046671487u, 0, EXPM1F_TOLERANCE, 0},
{2011, 3119858470u, 3079358544u, 3119854711u, 0, EXPM1F_TOLERANCE, 0},
{2012, 3349432725u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2013, 912423027u, 3079358544u, 912423052u, 0, EXPM1F_TOLERANCE, 0},
{2014, 3228795133u, 3079358544u, 3212463322u, 0, EXPM1F_TOLERANCE, 0},
{2015, 3194674746u, 3079358544u, 3193037091u, 0, EXPM1F_TOLERANCE, 0},
{2016, 3296784303u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2017, 965402291u, 3079358544u, 965403496u, 0, EXPM1F_TOLERANCE, 0},
{2018, 3388153589u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2019, 1133410485u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2020, 3136790322u, 3079358544u, 3136775003u, 0, EXPM1F_TOLERANCE, 0},
{2021, 3369970587u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2022, 1270451568u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2023, 989498922u, 3079358544u, 989514626u, 0, EXPM1F_TOLERANCE, 0},
{2024, 1280215674u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2025, 1171873518u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2026, 3298258100u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2027, 3415208824u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2028, 1001897182u, 3079358544u, 1001931005u, 0, EXPM1F_TOLERANCE, 0},
{2029, 3152777939u, 3079358544u, 3152722577u, 0, EXPM1F_TOLERANCE, 0},
{2030, 985903305u, 3079358544u, 985912883u, 0, EXPM1F_TOLERANCE, 0},
{2031, 3357328848u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2032, 982612185u, 3079358544u, 982617477u, 0, EXPM1F_TOLERANCE, 0},
{2033, 3267868136u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2034, 3319048157u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2035, 1144755661u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2036, 898467286u, 3079358544u, 898467291u, 0, EXPM1F_TOLERANCE, 0},
{2037, 3301461672u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2038, 3364525678u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2039, 931441127u, 3079358544u, 931441196u, 0, EXPM1F_TOLERANCE, 0},
{2040, 3146660041u, 3079358544u, 3146639843u, 0, EXPM1F_TOLERANCE, 0},
{2041, 3467121799u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2042, 1151257041u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2043, 3097873255u, 3079358544u, 3097872826u, 0, EXPM1F_TOLERANCE, 0},
{2044, 3130670309u, 3079358544u, 3130664364u, 0, EXPM1F_TOLERANCE, 0},
{2045, 1017573824u, 3079358544u, 1017686067u, 0, EXPM1F_TOLERANCE, 0},
{2046, 1258369714u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2047, 1216602683u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2048, 3297265739u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2049, 1071940738u, 3079358544u, 1084146490u, 0, EXPM1F_TOLERANCE, 0},
{2050, 922601356u, 3079358544u, 922601419u, 0, EXPM1F_TOLERANCE, 0},
{2051, 3462285635u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2052, 3357177805u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2053, 3049120080u, 3079358544u, 3049120071u, 0, EXPM1F_TOLERANCE, 0},
{2054, 1153863660u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2055, 3034243695u, 3079358544u, 3034243692u, 0, EXPM1F_TOLERANCE, 0},
{2056, 1249365132u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2057, 3046215730u, 3079358544u, 3046215725u, 0, EXPM1F_TOLERANCE, 0},
{2058, 3047251716u, 3079358544u, 3047251710u, 0, EXPM1F_TOLERANCE, 0},
{2059, 3131219358u, 3079358544u, 3131212750u, 0, EXPM1F_TOLERANCE, 0},
{2060, 3222096285u, 3079358544u, 3210992003u, 0, EXPM1F_TOLERANCE, 0},
{2061, 1297708818u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2062, 3345532722u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2063, 3418753236u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2064, 1277417964u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2065, 987577257u, 3079358544u, 987589500u, 0, EXPM1F_TOLERANCE, 0},
{2066, 3161606610u, 3079358544u, 3161489779u, 0, EXPM1F_TOLERANCE, 0},
{2067, 888030585u, 3079358544u, 888030588u, 0, EXPM1F_TOLERANCE, 0},
{2068, 1043442869u, 3079358544u, 1044514105u, 0, EXPM1F_TOLERANCE, 0},
{2069, 3320923228u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2070, 1337400405u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2071, 3400348640u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2072, 1250249095u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2073, 3284411233u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2074, 3020883322u, 3079358544u, 3020883321u, 0, EXPM1F_TOLERANCE, 0},
{2075, 1215968622u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2076, 3202319550u, 3079358544u, 3199540720u, 0, EXPM1F_TOLERANCE, 0},
{2077, 3061638260u, 3079358544u, 3061638229u, 0, EXPM1F_TOLERANCE, 0},
{2078, 1025404104u, 3079358544u, 1025607506u, 0, EXPM1F_TOLERANCE, 0},
{2079, 3138086437u, 3079358544u, 3138076728u, 0, EXPM1F_TOLERANCE, 0},
{2080, 3091024506u, 3079358544u, 3091024226u, 0, EXPM1F_TOLERANCE, 0},
{2081, 3362748242u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2082, 3099671635u, 3079358544u, 3099671052u, 0, EXPM1F_TOLERANCE, 0},
{2083, 3068014841u, 3079358544u, 3068014793u, 0, EXPM1F_TOLERANCE, 0},
{2084, 1252237719u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2085, 3327895594u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2086, 3082454432u, 3079358544u, 3082454296u, 0, EXPM1F_TOLERANCE, 0},
{2087, 3396161504u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2088, 1099710167u, 3079358544u, 1276946230u, 0, EXPM1F_TOLERANCE, 0},
{2089, 1157186482u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2090, 1282110851u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2091, 3477008113u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2092, 3292127294u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2093, 1123357102u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2094, 1106837025u, 3079358544u, 1441744913u, 0, EXPM1F_TOLERANCE, 0},
{2095, 1049949008u, 3079358544u, 1051517247u, 0, EXPM1F_TOLERANCE, 0},
{2096, 1253017688u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2097, 1108543194u, 3079358544u, 1510117963u, 0, EXPM1F_TOLERANCE, 0},
{2098, 3087985411u, 3079358544u, 3087985251u, 0, EXPM1F_TOLERANCE, 0},
{2099, 3163283126u, 3079358544u, 3163205315u, 0, EXPM1F_TOLERANCE, 0},
{2100, 1160162706u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2101, 3305715025u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2102, 1266928623u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2103, 3025340297u, 3079358544u, 3025340296u, 0, EXPM1F_TOLERANCE, 0},
{2104, 3438080027u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2105, 3344574751u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2106, 1152416724u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2107, 1218239308u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2108, 3263310567u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2109, 3041998669u, 3079358544u, 3041998664u, 0, EXPM1F_TOLERANCE, 0},
{2110, 1000313118u, 3079358544u, 1000338621u, 0, EXPM1F_TOLERANCE, 0},
{2111, 972485427u, 3079358544u, 972489239u, 0, EXPM1F_TOLERANCE, 0},
{2112, 3290264612u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2113, 3222106584u, 3079358544u, 3210996528u, 0, EXPM1F_TOLERANCE, 0},
{2114, 1278946388u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2115, 947914771u, 3079358544u, 947915027u, 0, EXPM1F_TOLERANCE, 0},
{2116, 3167730654u, 3079358544u, 3167559490u, 0, EXPM1F_TOLERANCE, 0},
{2117, 1098530298u, 3079358544u, 1253914864u, 0, EXPM1F_TOLERANCE, 0},
{2118, 3232726036u, 3079358544u, 3212767186u, 0, EXPM1F_TOLERANCE, 0},
{2119, 1297190916u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2120, 1277649137u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2121, 3203377685u, 3079358544u, 3200213876u, 0, EXPM1F_TOLERANCE, 0},
{2122, 3090306474u, 3079358544u, 3090306226u, 0, EXPM1F_TOLERANCE, 0},
{2123, 3244032016u, 3079358544u, 3212836846u, 0, EXPM1F_TOLERANCE, 0},
{2124, 3033122376u, 3079358544u, 3033122374u, 0, EXPM1F_TOLERANCE, 0},
{2125, 1096155623u, 3079358544u, 1226652252u, 0, EXPM1F_TOLERANCE, 0},
{2126, 873151908u, 3079358544u, 873151909u, 0, EXPM1F_TOLERANCE, 0},
{2127, 3238729605u, 3079358544u, 3212834050u, 0, EXPM1F_TOLERANCE, 0},
{2128, 3317196817u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2129, 3374748510u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2130, 3345634950u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2131, 3189860276u, 3079358544u, 3189068752u, 0, EXPM1F_TOLERANCE, 0},
{2132, 887311687u, 3079358544u, 887311690u, 0, EXPM1F_TOLERANCE, 0},
{2133, 3396917283u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2134, 3317032737u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2135, 1200051436u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2136, 3105291012u, 3079358544u, 3105290300u, 0, EXPM1F_TOLERANCE, 0},
{2137, 1306520561u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2138, 1314936356u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2139, 3475052219u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2140, 3085636260u, 3079358544u, 3085636044u, 0, EXPM1F_TOLERANCE, 0},
{2141, 3393227708u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2142, 3182540197u, 3079358544u, 3182049210u, 0, EXPM1F_TOLERANCE, 0},
{2143, 3349005404u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2144, 3154720153u, 3079358544u, 3154682605u, 0, EXPM1F_TOLERANCE, 0},
{2145, 1262863321u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2146, 882902102u, 3079358544u, 882902104u, 0, EXPM1F_TOLERANCE, 0},
{2147, 1053387478u, 3079358544u, 1056360663u, 0, EXPM1F_TOLERANCE, 0},
{2148, 3387653691u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2149, 3136364836u, 3079358544u, 3136350309u, 0, EXPM1F_TOLERANCE, 0},
{2150, 1338680611u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2151, 1112891928u, 3079358544u, 1710836650u, 0, EXPM1F_TOLERANCE, 0},
{2152, 893449284u, 3079358544u, 893449289u, 0, EXPM1F_TOLERANCE, 0},
{2153, 892311459u, 3079358544u, 892311463u, 0, EXPM1F_TOLERANCE, 0},
{2154, 3105373037u, 3079358544u, 3105372313u, 0, EXPM1F_TOLERANCE, 0},
{2155, 1190105283u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2156, 1011225926u, 3079358544u, 1011304717u, 0, EXPM1F_TOLERANCE, 0},
{2157, 1043025031u, 3079358544u, 1044018642u, 0, EXPM1F_TOLERANCE, 0},
{2158, 3410531037u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2159, 3125834184u, 3079358544u, 3125828754u, 0, EXPM1F_TOLERANCE, 0},
{2160, 902318189u, 3079358544u, 902318199u, 0, EXPM1F_TOLERANCE, 0},
{2161, 3213624815u, 3079358544u, 3207218218u, 0, EXPM1F_TOLERANCE, 0},
{2162, 1120888322u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2163, 1315217243u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2164, 3137758475u, 3079358544u, 3137749450u, 0, EXPM1F_TOLERANCE, 0},
{2165, 1040617590u, 3079358544u, 1041223269u, 0, EXPM1F_TOLERANCE, 0},
{2166, 955384253u, 3079358544u, 955385168u, 0, EXPM1F_TOLERANCE, 0},
{2167, 3061417900u, 3079358544u, 3061417870u, 0, EXPM1F_TOLERANCE, 0},
{2168, 904255535u, 3079358544u, 904255548u, 0, EXPM1F_TOLERANCE, 0},
{2169, 1022984119u, 3079358544u, 1023235665u, 0, EXPM1F_TOLERANCE, 0},
{2170, 997362368u, 3079358544u, 997391818u, 0, EXPM1F_TOLERANCE, 0},
{2171, 900933520u, 3079358544u, 900933528u, 0, EXPM1F_TOLERANCE, 0},
{2172, 1168623062u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2173, 878737490u, 3079358544u, 878737492u, 0, EXPM1F_TOLERANCE, 0},
{2174, 1039827284u, 3079358544u, 1040530471u, 0, EXPM1F_TOLERANCE, 0},
{2175, 1021564080u, 3079358544u, 1021773646u, 0, EXPM1F_TOLERANCE, 0},
{2176, 3458669745u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2177, 3327516316u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2178, 1040711112u, 3079358544u, 1041330000u, 0, EXPM1F_TOLERANCE, 0},
{2179, 1134528351u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2180, 3039884464u, 3079358544u, 3039884460u, 0, EXPM1F_TOLERANCE, 0},
{2181, 3414352838u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2182, 1133689539u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2183, 3455688478u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2184, 1137634874u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2185, 3415502662u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2186, 954999730u, 3079358544u, 955000601u, 0, EXPM1F_TOLERANCE, 0},
{2187, 1066157309u, 3079358544u, 1073672539u, 0, EXPM1F_TOLERANCE, 0},
{2188, 3436353675u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2189, 940437609u, 3079358544u, 940437766u, 0, EXPM1F_TOLERANCE, 0},
{2190, 3108347547u, 3079358544u, 3108346327u, 0, EXPM1F_TOLERANCE, 0},
{2191, 3064200154u, 3079358544u, 3064200128u, 0, EXPM1F_TOLERANCE, 0},
{2192, 1023889593u, 3079358544u, 1024037701u, 0, EXPM1F_TOLERANCE, 0},
{2193, 3272661536u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2194, 1170245333u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2195, 1219052056u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2196, 3318983619u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2197, 3372118621u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2198, 3146190320u, 3079358544u, 3146172105u, 0, EXPM1F_TOLERANCE, 0},
{2199, 1299683827u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2200, 3190796331u, 3079358544u, 3189862754u, 0, EXPM1F_TOLERANCE, 0},
{2201, 3086068902u, 3079358544u, 3086068674u, 0, EXPM1F_TOLERANCE, 0},
{2202, 3064155399u, 3079358544u, 3064155373u, 0, EXPM1F_TOLERANCE, 0},
{2203, 3040314717u, 3079358544u, 3040314713u, 0, EXPM1F_TOLERANCE, 0},
{2204, 3257224022u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2205, 1229268598u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2206, 3184078812u, 3079358544u, 3183451889u, 0, EXPM1F_TOLERANCE, 0},
{2207, 1086717248u, 3079358544u, 1139981179u, 0, EXPM1F_TOLERANCE, 0},
{2208, 3434884607u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2209, 3464955606u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2210, 1025278524u, 3079358544u, 1025477004u, 0, EXPM1F_TOLERANCE, 0},
{2211, 1242829722u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2212, 3075149137u, 3079358544u, 3075149056u, 0, EXPM1F_TOLERANCE, 0},
{2213, 1200927971u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2214, 3326858092u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2215, 1246019790u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2216, 3184801644u, 3079358544u, 3184105328u, 0, EXPM1F_TOLERANCE, 0},
{2217, 1136052740u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2218, 1069009211u, 3079358544u, 1078788101u, 0, EXPM1F_TOLERANCE, 0},
{2219, 1015670780u, 3079358544u, 1015747281u, 0, EXPM1F_TOLERANCE, 0},
{2220, 1012543234u, 3079358544u, 1012638866u, 0, EXPM1F_TOLERANCE, 0},
{2221, 3316611992u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2222, 1087942795u, 3079358544u, 1146743424u, 0, EXPM1F_TOLERANCE, 0},
{2223, 3426365713u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2224, 3066654389u, 3079358544u, 3066654349u, 0, EXPM1F_TOLERANCE, 0},
{2225, 3295326432u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2226, 3318835308u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2227, 3283555717u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2228, 3381255420u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2229, 3040485181u, 3079358544u, 3040485177u, 0, EXPM1F_TOLERANCE, 0},
{2230, 3388772093u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2231, 954670189u, 3079358544u, 954671024u, 0, EXPM1F_TOLERANCE, 0},
{2232, 1319200415u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2233, 1279324488u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2234, 3217795424u, 3079358544u, 3209419343u, 0, EXPM1F_TOLERANCE, 0},
{2235, 3455131757u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2236, 1246947517u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2237, 3396723577u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2238, 3433761025u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2239, 3201187455u, 3079358544u, 3198796615u, 0, EXPM1F_TOLERANCE, 0},
{2240, 1173247961u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2241, 3037297123u, 3079358544u, 3037297121u, 0, EXPM1F_TOLERANCE, 0},
{2242, 3248534678u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2243, 3083019343u, 3079358544u, 3083019194u, 0, EXPM1F_TOLERANCE, 0},
{2244, 3042018375u, 3079358544u, 3042018370u, 0, EXPM1F_TOLERANCE, 0},
{2245, 1082862511u, 3079358544u, 1117311128u, 0, EXPM1F_TOLERANCE, 0},
{2246, 3157626955u, 3079358544u, 3157561267u, 0, EXPM1F_TOLERANCE, 0},
{2247, 1341821683u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2248, 881101379u, 3079358544u, 881101380u, 0, EXPM1F_TOLERANCE, 0},
{2249, 1079061705u, 3079358544u, 1103766846u, 0, EXPM1F_TOLERANCE, 0},
{2250, 3182695954u, 3079358544u, 3182191938u, 0, EXPM1F_TOLERANCE, 0},
{2251, 1105291533u, 3079358544u, 1405670241u, 0, EXPM1F_TOLERANCE, 0},
{2252, 1016023520u, 3079358544u, 1016106127u, 0, EXPM1F_TOLERANCE, 0},
{2253, 3370691006u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2254, 1156767169u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2255, 3077020499u, 3079358544u, 3077020394u, 0, EXPM1F_TOLERANCE, 0},
{2256, 1104284039u, 3079358544u, 1382754095u, 0, EXPM1F_TOLERANCE, 0},
{2257, 3335212901u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2258, 1093697541u, 3079358544u, 1198607884u, 0, EXPM1F_TOLERANCE, 0},
{2259, 3266691185u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2260, 3179003144u, 3079358544u, 3178506395u, 0, EXPM1F_TOLERANCE, 0},
{2261, 1094115255u, 3079358544u, 1202959080u, 0, EXPM1F_TOLERANCE, 0},
{2262, 3424086808u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2263, 3353608773u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2264, 973664327u, 3079358544u, 973666671u, 0, EXPM1F_TOLERANCE, 0},
{2265, 882878091u, 3079358544u, 882878093u, 0, EXPM1F_TOLERANCE, 0},
{2266, 1098662266u, 3079358544u, 1255578035u, 0, EXPM1F_TOLERANCE, 0},
{2267, 927582555u, 3079358544u, 927582635u, 0, EXPM1F_TOLERANCE, 0},
{2268, 3111440310u, 3079358544u, 3111438437u, 0, EXPM1F_TOLERANCE, 0},
{2269, 3476083859u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2270, 3038754840u, 3079358544u, 3038754837u, 0, EXPM1F_TOLERANCE, 0},
{2271, 979878744u, 3079358544u, 979885460u, 0, EXPM1F_TOLERANCE, 0},
{2272, 3464546616u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2273, 1002542205u, 3079358544u, 1002579752u, 0, EXPM1F_TOLERANCE, 0},
{2274, 3443552129u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2275, 1287620154u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2276, 946058434u, 3079358544u, 946058839u, 0, EXPM1F_TOLERANCE, 0},
{2277, 3073260205u, 3079358544u, 3073260146u, 0, EXPM1F_TOLERANCE, 0},
{2278, 1245702957u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2279, 989655126u, 3079358544u, 989671131u, 0, EXPM1F_TOLERANCE, 0},
{2280, 1002715618u, 3079358544u, 1002754200u, 0, EXPM1F_TOLERANCE, 0},
{2281, 3087802274u, 3079358544u, 3087802121u, 0, EXPM1F_TOLERANCE, 0},
{2282, 1000863905u, 3079358544u, 1000892168u, 0, EXPM1F_TOLERANCE, 0},
{2283, 3415763001u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2284, 3283471961u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2285, 3311210827u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2286, 3026311911u, 3079358544u, 3026311909u, 0, EXPM1F_TOLERANCE, 0},
{2287, 1198307901u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2288, 1288901567u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2289, 922255363u, 3079358544u, 922255423u, 0, EXPM1F_TOLERANCE, 0},
{2290, 1113104661u, 3079358544u, 1720471412u, 0, EXPM1F_TOLERANCE, 0},
{2291, 1136714348u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2292, 948856035u, 3079358544u, 948856352u, 0, EXPM1F_TOLERANCE, 0},
{2293, 1062512367u, 3079358544u, 1067826688u, 0, EXPM1F_TOLERANCE, 0},
{2294, 3486907092u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2295, 1162027071u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2296, 1034561811u, 3079358544u, 1035038186u, 0, EXPM1F_TOLERANCE, 0},
{2297, 3271615417u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2298, 1042014529u, 3079358544u, 1042833086u, 0, EXPM1F_TOLERANCE, 0},
{2299, 1177157787u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2300, 3196144817u, 3079358544u, 3194259351u, 0, EXPM1F_TOLERANCE, 0},
{2301, 3432084552u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2302, 1309658335u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2303, 1226494979u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2304, 3100289712u, 3079358544u, 3100289070u, 0, EXPM1F_TOLERANCE, 0},
{2305, 3375507013u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2306, 3460699001u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2307, 3079231719u, 3079358544u, 3079231645u, 0, EXPM1F_TOLERANCE, 0},
{2308, 3093951884u, 3079358544u, 3093951456u, 0, EXPM1F_TOLERANCE, 0},
{2309, 3468023178u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2310, 1204196034u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2311, 3459877411u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2312, 909696559u, 3079358544u, 909696576u, 0, EXPM1F_TOLERANCE, 0},
{2313, 1161439847u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2314, 908663107u, 3079358544u, 908663121u, 0, EXPM1F_TOLERANCE, 0},
{2315, 1055319316u, 3079358544u, 1058136138u, 0, EXPM1F_TOLERANCE, 0},
{2316, 1084378658u, 3079358544u, 1126072255u, 0, EXPM1F_TOLERANCE, 0},
{2317, 3053887750u, 3079358544u, 3053887741u, 0, EXPM1F_TOLERANCE, 0},
{2318, 3022828828u, 3079358544u, 3022828827u, 0, EXPM1F_TOLERANCE, 0},
{2319, 1226473697u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2320, 1123114742u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2321, 1258114435u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2322, 3468040845u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2323, 1178825761u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2324, 3059266302u, 3079358544u, 3059266279u, 0, EXPM1F_TOLERANCE, 0},
{2325, 3223384012u, 3079358544u, 3211479716u, 0, EXPM1F_TOLERANCE, 0},
{2326, 1019964626u, 3079358544u, 1020131532u, 0, EXPM1F_TOLERANCE, 0},
{2327, 3445262427u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2328, 1125653081u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2329, 3337652712u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2330, 1184753508u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2331, 996404791u, 3079358544u, 996430797u, 0, EXPM1F_TOLERANCE, 0},
{2332, 1188439315u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2333, 906557513u, 3079358544u, 906557522u, 0, EXPM1F_TOLERANCE, 0},
{2334, 916831283u, 3079358544u, 916831310u, 0, EXPM1F_TOLERANCE, 0},
{2335, 996786317u, 3079358544u, 996813670u, 0, EXPM1F_TOLERANCE, 0},
{2336, 3461635065u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2337, 1188167943u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2338, 3036502395u, 3079358544u, 3036502391u, 0, EXPM1F_TOLERANCE, 0},
{2339, 891257783u, 3079358544u, 891257786u, 0, EXPM1F_TOLERANCE, 0},
{2340, 3290079438u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2341, 3350690327u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2342, 1102061604u, 3079358544u, 1331236523u, 0, EXPM1F_TOLERANCE, 0},
{2343, 1282351521u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2344, 3458861065u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2345, 3095256878u, 3079358544u, 3095256374u, 0, EXPM1F_TOLERANCE, 0},
{2346, 3163373610u, 3079358544u, 3163294260u, 0, EXPM1F_TOLERANCE, 0},
{2347, 3228793330u, 3079358544u, 3212463162u, 0, EXPM1F_TOLERANCE, 0},
{2348, 3422194733u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2349, 3083885296u, 3079358544u, 3083885126u, 0, EXPM1F_TOLERANCE, 0},
{2350, 1261940623u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2351, 3400603081u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2352, 1219411812u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2353, 3094833770u, 3079358544u, 3094833292u, 0, EXPM1F_TOLERANCE, 0},
{2354, 3139250800u, 3079358544u, 3139238459u, 0, EXPM1F_TOLERANCE, 0},
{2355, 886201503u, 3079358544u, 886201506u, 0, EXPM1F_TOLERANCE, 0},
{2356, 3297366026u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2357, 1218488455u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2358, 3040358923u, 3079358544u, 3040358919u, 0, EXPM1F_TOLERANCE, 0},
{2359, 1283938137u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2360, 3182551696u, 3079358544u, 3182059752u, 0, EXPM1F_TOLERANCE, 0},
{2361, 1317098613u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2362, 3116209179u, 3079358544u, 3116206933u, 0, EXPM1F_TOLERANCE, 0},
{2363, 3431703657u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2364, 3239728775u, 3079358544u, 3212835779u, 0, EXPM1F_TOLERANCE, 0},
{2365, 3207141672u, 3079358544u, 3203892183u, 0, EXPM1F_TOLERANCE, 0},
{2366, 3154378805u, 3079358544u, 3154344050u, 0, EXPM1F_TOLERANCE, 0},
{2367, 3069658155u, 3079358544u, 3069658095u, 0, EXPM1F_TOLERANCE, 0},
{2368, 3313160088u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2369, 3207056527u, 3079358544u, 3203803993u, 0, EXPM1F_TOLERANCE, 0},
{2370, 1284174954u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2371, 3156081645u, 3079358544u, 3156031887u, 0, EXPM1F_TOLERANCE, 0},
{2372, 1063693032u, 3079358544u, 1069230225u, 0, EXPM1F_TOLERANCE, 0},
{2373, 3036026175u, 3079358544u, 3036026171u, 0, EXPM1F_TOLERANCE, 0},
{2374, 1102631663u, 3079358544u, 1344337477u, 0, EXPM1F_TOLERANCE, 0},
{2375, 968803479u, 3079358544u, 968805754u, 0, EXPM1F_TOLERANCE, 0},
{2376, 3273080388u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2377, 1172529774u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2378, 1306695905u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2379, 1003649752u, 3079358544u, 1003694149u, 0, EXPM1F_TOLERANCE, 0},
{2380, 1078478376u, 3079358544u, 1101978697u, 0, EXPM1F_TOLERANCE, 0},
{2381, 3158855023u, 3079358544u, 3158775107u, 0, EXPM1F_TOLERANCE, 0},
{2382, 1165177679u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2383, 3403009513u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2384, 952348506u, 3079358544u, 952349104u, 0, EXPM1F_TOLERANCE, 0},
{2385, 1222777442u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2386, 1325324763u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2387, 3363524213u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2388, 1158950321u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2389, 903129873u, 3079358544u, 903129884u, 0, EXPM1F_TOLERANCE, 0},
{2390, 3078339944u, 3079358544u, 3078339820u, 0, EXPM1F_TOLERANCE, 0},
{2391, 1208345407u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2392, 1258634105u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2393, 1248478509u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2394, 1153863988u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2395, 1235620969u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2396, 1097120930u, 3079358544u, 1237672369u, 0, EXPM1F_TOLERANCE, 0},
{2397, 3469778622u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2398, 1147712200u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2399, 1124721745u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2400, 3261744304u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2401, 1064922416u, 3079358544u, 1070800536u, 0, EXPM1F_TOLERANCE, 0},
{2402, 3303160152u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2403, 1315090496u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2404, 3230403187u, 3079358544u, 3212625939u, 0, EXPM1F_TOLERANCE, 0},
{2405, 1335399673u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2406, 1072458508u, 3079358544u, 1084942451u, 0, EXPM1F_TOLERANCE, 0},
{2407, 3303015249u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2408, 3252139741u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2409, 3468519966u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2410, 1006231203u, 3079358544u, 1006293797u, 0, EXPM1F_TOLERANCE, 0},
{2411, 951554138u, 3079358544u, 951554665u, 0, EXPM1F_TOLERANCE, 0},
{2412, 942046828u, 3079358544u, 942047045u, 0, EXPM1F_TOLERANCE, 0},
{2413, 3319723279u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2414, 3255104167u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2415, 1155477903u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2416, 3273889176u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2417, 3237813668u, 3079358544u, 3212830705u, 0, EXPM1F_TOLERANCE, 0},
{2418, 1228207362u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2419, 975349337u, 3079358544u, 975352645u, 0, EXPM1F_TOLERANCE, 0},
{2420, 1290175785u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2421, 981908840u, 3079358544u, 981913380u, 0, EXPM1F_TOLERANCE, 0},
{2422, 941187647u, 3079358544u, 941187831u, 0, EXPM1F_TOLERANCE, 0},
{2423, 1214223128u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2424, 3422922584u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2425, 1315857601u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2426, 3453226030u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2427, 1078359574u, 3079358544u, 1101644019u, 0, EXPM1F_TOLERANCE, 0},
{2428, 1029557624u, 3079358544u, 1029958397u, 0, EXPM1F_TOLERANCE, 0},
{2429, 1207675424u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2430, 1028355074u, 3079358544u, 1028691771u, 0, EXPM1F_TOLERANCE, 0},
{2431, 3119299090u, 3079358544u, 3119295588u, 0, EXPM1F_TOLERANCE, 0},
{2432, 1248421894u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2433, 3353251994u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2434, 876926659u, 3079358544u, 876926660u, 0, EXPM1F_TOLERANCE, 0},
{2435, 1076752219u, 3079358544u, 1096963550u, 0, EXPM1F_TOLERANCE, 0},
{2436, 3388531942u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2437, 1273395082u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2438, 3385588183u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2439, 3192315328u, 3079358544u, 3191127896u, 0, EXPM1F_TOLERANCE, 0},
{2440, 3441804648u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2441, 3392827417u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2442, 1161241793u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2443, 3034494183u, 3079358544u, 3034494180u, 0, EXPM1F_TOLERANCE, 0},
{2444, 1171318485u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2445, 3047748143u, 3079358544u, 3047748136u, 0, EXPM1F_TOLERANCE, 0},
{2446, 1001216371u, 3079358544u, 1001246474u, 0, EXPM1F_TOLERANCE, 0},
{2447, 912515889u, 3079358544u, 912515914u, 0, EXPM1F_TOLERANCE, 0},
{2448, 3391452505u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2449, 3249603369u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2450, 1220264047u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2451, 3169816394u, 3079358544u, 3169589060u, 0, EXPM1F_TOLERANCE, 0},
{2452, 3098997418u, 3079358544u, 3098996895u, 0, EXPM1F_TOLERANCE, 0},
{2453, 3282212423u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2454, 3352293320u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2455, 3296358441u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2456, 1197828352u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2457, 3340510371u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2458, 1127109339u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2459, 909467381u, 3079358544u, 909467397u, 0, EXPM1F_TOLERANCE, 0},
{2460, 1200599955u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2461, 962230977u, 3079358544u, 962232469u, 0, EXPM1F_TOLERANCE, 0},
{2462, 3192887808u, 3079358544u, 3191597321u, 0, EXPM1F_TOLERANCE, 0},
{2463, 3237183876u, 3079358544u, 3212828548u, 0, EXPM1F_TOLERANCE, 0},
{2464, 939285924u, 3079358544u, 939286173u, 0, EXPM1F_TOLERANCE, 0},
{2465, 944050180u, 3079358544u, 944050483u, 0, EXPM1F_TOLERANCE, 0},
{2466, 3058135703u, 3079358544u, 3058135684u, 0, EXPM1F_TOLERANCE, 0},
{2467, 3480592662u, 3079358544u, 3212836864u, 0, EXPM1F_TOLERANCE, 0},
{2468, 3061939312u, 3079358544u, 3061939296u, 0, EXPM1F_TOLERANCE, 0},
{2469, 1003299981u, 3079358544u, 1003342153u, 0, EXPM1F_TOLERANCE, 0},
{2470, 1155775526u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0},
{2471, 1234491880u, 3079358544u, 2139095040u, 0, EXPM1F_TOLERANCE, 0}

// AUTOMATICALLY GENERATED VECTORS STOP

};

#endif // CYGONCE_LIBM_EXPM1F_H multiple inclusion protection

// EOF expm1f.h
