#ifndef CYGONCE_LIBM_EXPF_H
#define CYGONCE_LIBM_EXPF_H
//===========================================================================
//
//      expf.h
//
//      Test vectors for testing of expf() math library function
//
//===========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 2012 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later
// version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License
// along with eCos; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
// As a special exception, if other files instantiate templates or use
// macros or inline functions from this file, or you compile this file
// and link it with other works to produce a work based on this file,
// this file does not by itself cause the resulting work to be covered by
// the GNU General Public License. However the source code for this file
// must still be made available in accordance with section (3) of the GNU
// General Public License v2.
//
// This exception does not invalidate any other reasons why a work based
// on this file might be covered by the GNU General Public License.
// -------------------------------------------
// ####ECOSGPLCOPYRIGHTEND####
//===========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):
// Contributors:  visar, ilijak
// Date:        1998-02-13
// Purpose:
// Description:
// Usage:       #include "vectors/exp.h"
//
//####DESCRIPTIONEND####
//
//===========================================================================


// CONFIGURATION

#include <pkgconf/libm.h>   // Configuration header


// INCLUDES

#include <cyg/infra/cyg_type.h>    // Common type definitions and support
#include "vectors/vector_support_float.h"// extra support for math tests

#define EXP_TOLERANCE 1.0E-04

static const Cyg_libm_test_float_vec_t expf_vec[] = {

// AUTOMATICALLY GENERATED VECTORS START

{0, 646742016u, 1065353216u, 1065353216u, 0, EXP_TOLERANCE, 0},
{1, 1008981770u, 1065437523u, 1065437523u, 0, EXP_TOLERANCE, 0},
{2, 1017370378u, 1065522677u, 1065522677u, 0, EXP_TOLERANCE, 0},
{3, 1022739087u, 1065608687u, 1065608687u, 0, EXP_TOLERANCE, 0},
{4, 1025758986u, 1065695562u, 1065695562u, 0, EXP_TOLERANCE, 0},
{5, 1028443341u, 1065783309u, 1065783309u, 0, EXP_TOLERANCE, 0},
{6, 1031127695u, 1065871938u, 1065871938u, 0, EXP_TOLERANCE, 0},
{7, 1032805417u, 1065961458u, 1065961458u, 0, EXP_TOLERANCE, 0},
{8, 1034147594u, 1066051878u, 1066051878u, 0, EXP_TOLERANCE, 0},
{9, 1035489772u, 1066143207u, 1066143207u, 0, EXP_TOLERANCE, 0},
{10, 1036831949u, 1066235454u, 1066235454u, 0, EXP_TOLERANCE, 0},
{11, 1038174126u, 1066328627u, 1066328627u, 0, EXP_TOLERANCE, 0},
{12, 1039516303u, 1066422737u, 1066422737u, 0, EXP_TOLERANCE, 0},
{13, 1040522936u, 1066517792u, 1066517792u, 0, EXP_TOLERANCE, 0},
{14, 1041194025u, 1066613804u, 1066613804u, 0, EXP_TOLERANCE, 0},
{15, 1041865114u, 1066710780u, 1066710780u, 0, EXP_TOLERANCE, 0},
{16, 1042536202u, 1066808730u, 1066808730u, 0, EXP_TOLERANCE, 0},
{17, 1043207291u, 1066907665u, 1066907665u, 0, EXP_TOLERANCE, 0},
{18, 1043878380u, 1067007595u, 1067007595u, 0, EXP_TOLERANCE, 0},
{19, 1044549468u, 1067108528u, 1067108528u, 0, EXP_TOLERANCE, 0},
{20, 1045220557u, 1067210477u, 1067210477u, 0, EXP_TOLERANCE, 0},
{21, 1045891645u, 1067313449u, 1067313449u, 0, EXP_TOLERANCE, 0},
{22, 1046562734u, 1067417457u, 1067417457u, 0, EXP_TOLERANCE, 0},
{23, 1047233823u, 1067522510u, 1067522510u, 0, EXP_TOLERANCE, 0},
{24, 1047904911u, 1067628618u, 1067628618u, 0, EXP_TOLERANCE, 0},
{25, 1048576000u, 1067735793u, 1067735793u, 0, EXP_TOLERANCE, 0},
{26, 1048911544u, 1067844046u, 1067844046u, 0, EXP_TOLERANCE, 0},
{27, 1049247089u, 1067953387u, 1067953387u, 0, EXP_TOLERANCE, 0},
{28, 1049582633u, 1068063826u, 1068063826u, 0, EXP_TOLERANCE, 0},
{29, 1049918177u, 1068175375u, 1068175375u, 0, EXP_TOLERANCE, 0},
{30, 1050253722u, 1068288045u, 1068288045u, 0, EXP_TOLERANCE, 0},
{31, 1050589266u, 1068401847u, 1068401847u, 0, EXP_TOLERANCE, 0},
{32, 1050924810u, 1068516793u, 1068516793u, 0, EXP_TOLERANCE, 0},
{33, 1051260355u, 1068632895u, 1068632895u, 0, EXP_TOLERANCE, 0},
{34, 1051595899u, 1068750163u, 1068750163u, 0, EXP_TOLERANCE, 0},
{35, 1051931443u, 1068868609u, 1068868609u, 0, EXP_TOLERANCE, 0},
{36, 1052266988u, 1068988247u, 1068988247u, 0, EXP_TOLERANCE, 0},
{37, 1052602532u, 1069109086u, 1069109086u, 0, EXP_TOLERANCE, 0},
{38, 1052938076u, 1069231140u, 1069231140u, 0, EXP_TOLERANCE, 0},
{39, 1053273620u, 1069354421u, 1069354421u, 0, EXP_TOLERANCE, 0},
{40, 1053609165u, 1069478941u, 1069478941u, 0, EXP_TOLERANCE, 0},
{41, 1053944709u, 1069604712u, 1069604712u, 0, EXP_TOLERANCE, 0},
{42, 1054280253u, 1069731747u, 1069731747u, 0, EXP_TOLERANCE, 0},
{43, 1054615798u, 1069860059u, 1069860059u, 0, EXP_TOLERANCE, 0},
{44, 1054951342u, 1069989660u, 1069989660u, 0, EXP_TOLERANCE, 0},
{45, 1055286886u, 1070120564u, 1070120564u, 0, EXP_TOLERANCE, 0},
{46, 1055622431u, 1070252784u, 1070252784u, 0, EXP_TOLERANCE, 0},
{47, 1055957975u, 1070386332u, 1070386332u, 0, EXP_TOLERANCE, 0},
{48, 1056293519u, 1070521223u, 1070521223u, 0, EXP_TOLERANCE, 0},
{49, 1056629064u, 1070657469u, 1070657469u, 0, EXP_TOLERANCE, 0},
{50, 1056964608u, 1070795084u, 1070795084u, 0, EXP_TOLERANCE, 0},
{51, 1057132380u, 1070934083u, 1070934083u, 0, EXP_TOLERANCE, 0},
{52, 1057300152u, 1071074479u, 1071074479u, 0, EXP_TOLERANCE, 0},
{53, 1057467924u, 1071216285u, 1071216285u, 0, EXP_TOLERANCE, 0},
{54, 1057635697u, 1071359517u, 1071359517u, 0, EXP_TOLERANCE, 0},
{55, 1057803469u, 1071504189u, 1071504189u, 0, EXP_TOLERANCE, 0},
{56, 1057971241u, 1071650314u, 1071650314u, 0, EXP_TOLERANCE, 0},
{57, 1058139013u, 1071797907u, 1071797907u, 0, EXP_TOLERANCE, 0},
{58, 1058306785u, 1071946984u, 1071946984u, 0, EXP_TOLERANCE, 0},
{59, 1058474557u, 1072097559u, 1072097559u, 0, EXP_TOLERANCE, 0},
{60, 1058642330u, 1072249649u, 1072249649u, 0, EXP_TOLERANCE, 0},
{61, 1058810102u, 1072403266u, 1072403266u, 0, EXP_TOLERANCE, 0},
{62, 1058977874u, 1072558427u, 1072558427u, 0, EXP_TOLERANCE, 0},
{63, 1059145646u, 1072715147u, 1072715147u, 0, EXP_TOLERANCE, 0},
{64, 1059313418u, 1072873443u, 1072873443u, 0, EXP_TOLERANCE, 0},
{65, 1059481190u, 1073033329u, 1073033329u, 0, EXP_TOLERANCE, 0},
{66, 1059648963u, 1073194823u, 1073194823u, 0, EXP_TOLERANCE, 0},
{67, 1059816735u, 1073357939u, 1073357939u, 0, EXP_TOLERANCE, 0},
{68, 1059984507u, 1073522694u, 1073522694u, 0, EXP_TOLERANCE, 0},
{69, 1060152279u, 1073689106u, 1073689106u, 0, EXP_TOLERANCE, 0},
{70, 1060320051u, 1073799507u, 1073799507u, 0, EXP_TOLERANCE, 0},
{71, 1060487823u, 1073884393u, 1073884393u, 0, EXP_TOLERANCE, 0},
{72, 1060655596u, 1073970134u, 1073970134u, 0, EXP_TOLERANCE, 0},
{73, 1060823368u, 1074056735u, 1074056735u, 0, EXP_TOLERANCE, 0},
{74, 1060991140u, 1074144206u, 1074144206u, 0, EXP_TOLERANCE, 0},
{75, 1061158912u, 1074232557u, 1074232557u, 0, EXP_TOLERANCE, 0},
{76, 1061326684u, 1074321796u, 1074321796u, 0, EXP_TOLERANCE, 0},
{77, 1061494456u, 1074411931u, 1074411931u, 0, EXP_TOLERANCE, 0},
{78, 1061662228u, 1074502974u, 1074502974u, 0, EXP_TOLERANCE, 0},
{79, 1061830001u, 1074594931u, 1074594931u, 0, EXP_TOLERANCE, 0},
{80, 1061997773u, 1074687812u, 1074687812u, 0, EXP_TOLERANCE, 0},
{81, 1062165545u, 1074781626u, 1074781626u, 0, EXP_TOLERANCE, 0},
{82, 1062333317u, 1074876383u, 1074876383u, 0, EXP_TOLERANCE, 0},
{83, 1062501089u, 1074972091u, 1074972091u, 0, EXP_TOLERANCE, 0},
{84, 1062668861u, 1075068762u, 1075068762u, 0, EXP_TOLERANCE, 0},
{85, 1062836634u, 1075166406u, 1075166406u, 0, EXP_TOLERANCE, 0},
{86, 1063004406u, 1075265030u, 1075265030u, 0, EXP_TOLERANCE, 0},
{87, 1063172178u, 1075364646u, 1075364646u, 0, EXP_TOLERANCE, 0},
{88, 1063339950u, 1075465262u, 1075465262u, 0, EXP_TOLERANCE, 0},
{89, 1063507722u, 1075566890u, 1075566890u, 0, EXP_TOLERANCE, 0},
{90, 1063675494u, 1075669539u, 1075669539u, 0, EXP_TOLERANCE, 0},
{91, 1063843267u, 1075773220u, 1075773220u, 0, EXP_TOLERANCE, 0},
{92, 1064011039u, 1075877942u, 1075877942u, 0, EXP_TOLERANCE, 0},
{93, 1064178811u, 1075983718u, 1075983718u, 0, EXP_TOLERANCE, 0},
{94, 1064346583u, 1076090556u, 1076090556u, 0, EXP_TOLERANCE, 0},
{95, 1064514355u, 1076198468u, 1076198468u, 0, EXP_TOLERANCE, 0},
{96, 1064682127u, 1076307465u, 1076307465u, 0, EXP_TOLERANCE, 0},
{97, 1064849900u, 1076417557u, 1076417557u, 0, EXP_TOLERANCE, 0},
{98, 1065017672u, 1076528756u, 1076528756u, 0, EXP_TOLERANCE, 0},
{99, 1065185444u, 1076641072u, 1076641072u, 0, EXP_TOLERANCE, 0},
{100, 1065353216u, 1076754516u, 1076754516u, 0, EXP_TOLERANCE, 0},
{101, 1065437102u, 1076869101u, 1076869101u, 0, EXP_TOLERANCE, 0},
{102, 1065520988u, 1076984838u, 1076984838u, 0, EXP_TOLERANCE, 0},
{103, 1065604874u, 1077101737u, 1077101737u, 0, EXP_TOLERANCE, 0},
{104, 1065688760u, 1077219812u, 1077219812u, 0, EXP_TOLERANCE, 0},
{105, 1065772646u, 1077339073u, 1077339073u, 0, EXP_TOLERANCE, 0},
{106, 1065856532u, 1077459533u, 1077459533u, 0, EXP_TOLERANCE, 0},
{107, 1065940419u, 1077581204u, 1077581204u, 0, EXP_TOLERANCE, 0},
{108, 1066024305u, 1077704098u, 1077704098u, 0, EXP_TOLERANCE, 0},
{109, 1066108191u, 1077828227u, 1077828227u, 0, EXP_TOLERANCE, 0},
{110, 1066192077u, 1077953602u, 1077953602u, 0, EXP_TOLERANCE, 0},
{111, 1066275963u, 1078080238u, 1078080238u, 0, EXP_TOLERANCE, 0},
{112, 1066359849u, 1078208147u, 1078208147u, 0, EXP_TOLERANCE, 0},
{113, 1066443735u, 1078337341u, 1078337341u, 0, EXP_TOLERANCE, 0},
{114, 1066527621u, 1078467832u, 1078467832u, 0, EXP_TOLERANCE, 0},
{115, 1066611507u, 1078599636u, 1078599636u, 0, EXP_TOLERANCE, 0},
{116, 1066695393u, 1078732765u, 1078732765u, 0, EXP_TOLERANCE, 0},
{117, 1066779279u, 1078867232u, 1078867232u, 0, EXP_TOLERANCE, 0},
{118, 1066863165u, 1079003050u, 1079003050u, 0, EXP_TOLERANCE, 0},
{119, 1066947052u, 1079140234u, 1079140234u, 0, EXP_TOLERANCE, 0},
{120, 1070141403u, 1083830126u, 1083830126u, 0, EXP_TOLERANCE, 0},
{121, 1078530011u, 1102651427u, 1102651427u, 0, EXP_TOLERANCE, 0},
{122, 1083624420u, 1121886899u, 1121886899u, 0, EXP_TOLERANCE, 0},
{123, 1058642330u, 1072249649u, 1072249649u, 0, EXP_TOLERANCE, 0},
{124, 1075000115u, 1092589119u, 1092589119u, 0, EXP_TOLERANCE, 0},
{125, 1082130432u, 1113220225u, 1113220225u, 0, EXP_TOLERANCE, 0},
{126, 1085695590u, 1133866754u, 1133866754u, 0, EXP_TOLERANCE, 0},
{127, 1089260749u, 1154252673u, 1154252673u, 0, EXP_TOLERANCE, 0},
{128, 1091672474u, 1175186737u, 1175186737u, 0, EXP_TOLERANCE, 0},
{129, 1093455053u, 1195343060u, 1195343060u, 0, EXP_TOLERANCE, 0},
{130, 1095237632u, 1216546343u, 1216546343u, 0, EXP_TOLERANCE, 0},
{131, 1097020211u, 1236487677u, 1236487677u, 0, EXP_TOLERANCE, 0},
{132, 1098802790u, 1257594946u, 1257594946u, 0, EXP_TOLERANCE, 0},
{133, 1099746509u, 1277683114u, 1277683114u, 0, EXP_TOLERANCE, 0},
{134, 1100637798u, 1298514882u, 1298514882u, 0, EXP_TOLERANCE, 0},
{135, 1101529088u, 1318926100u, 1318926100u, 0, EXP_TOLERANCE, 0},
{136, 1102420378u, 1339499947u, 1339499947u, 0, EXP_TOLERANCE, 0},
{137, 1103311667u, 1360213626u, 1360213626u, 0, EXP_TOLERANCE, 0},
{138, 1104202957u, 1380545923u, 1380545923u, 0, EXP_TOLERANCE, 0},
{139, 1105094246u, 1401542857u, 1401542857u, 0, EXP_TOLERANCE, 0},
{140, 1105985536u, 1421648972u, 1421648972u, 0, EXP_TOLERANCE, 0},
{141, 1082634597u, 1116397362u, 1116397362u, 0, EXP_TOLERANCE, 0},
{142, 1115190228u, 1816356396u, 1816356396u, 0, EXP_TOLERANCE, 0},
{143, 1106438075u, 1432328497u, 1432328497u, 0, EXP_TOLERANCE, 0},
{144, 1018427456u, 1065539544u, 1065539544u, 0, EXP_TOLERANCE, 0},
{145, 1046447761u, 1067399564u, 1067399564u, 0, EXP_TOLERANCE, 0},
{146, 1042051987u, 1066737957u, 1066737957u, 0, EXP_TOLERANCE, 0},
{147, 1090693943u, 1163665644u, 1163665644u, 0, EXP_TOLERANCE, 0},
{148, 1108590126u, 1511795659u, 1511795659u, 0, EXP_TOLERANCE, 0},
{149, 1069578284u, 1083175139u, 1083175139u, 0, EXP_TOLERANCE, 0},
{150, 1069238236u, 1082800389u, 1082800389u, 0, EXP_TOLERANCE, 0},
{151, 1025202705u, 1065677487u, 1065677487u, 0, EXP_TOLERANCE, 0},
{152, 1091726201u, 1175668846u, 1175668846u, 0, EXP_TOLERANCE, 0},
{153, 1043690266u, 1066979483u, 1066979483u, 0, EXP_TOLERANCE, 0},
{154, 1069138828u, 1082693675u, 1082693675u, 0, EXP_TOLERANCE, 0},
{155, 1032530529u, 1065943051u, 1065943051u, 0, EXP_TOLERANCE, 0},
{156, 1019185416u, 1065551659u, 1065551659u, 0, EXP_TOLERANCE, 0},
{157, 1035062552u, 1066114038u, 1066114038u, 0, EXP_TOLERANCE, 0},
{158, 1040899644u, 1066571569u, 1066571569u, 0, EXP_TOLERANCE, 0},
{159, 1105267499u, 1405080525u, 1405080525u, 0, EXP_TOLERANCE, 0},
{160, 1031940153u, 1065903645u, 1065903645u, 0, EXP_TOLERANCE, 0},
{161, 1100353916u, 1292219150u, 1292219150u, 0, EXP_TOLERANCE, 0},
{162, 1118272510u, 2078349621u, 2078349621u, 0, EXP_TOLERANCE, 0},
{163, 1052005275u, 1068894831u, 1068894831u, 0, EXP_TOLERANCE, 0},
{164, 1051595516u, 1068750028u, 1068750028u, 0, EXP_TOLERANCE, 0},
{165, 1042459941u, 1066797550u, 1066797550u, 0, EXP_TOLERANCE, 0},
{166, 1015139825u, 1065487194u, 1065487194u, 0, EXP_TOLERANCE, 0},
{167, 1027402057u, 1065749167u, 1065749167u, 0, EXP_TOLERANCE, 0},
{168, 1092902066u, 1189217227u, 1189217227u, 0, EXP_TOLERANCE, 0},
{169, 1089609605u, 1156678213u, 1156678213u, 0, EXP_TOLERANCE, 0},
{170, 1103961891u, 1375627298u, 1375627298u, 0, EXP_TOLERANCE, 0},
{171, 1064017530u, 1075882016u, 1075882016u, 0, EXP_TOLERANCE, 0},
{172, 1081612749u, 1111558359u, 1111558359u, 0, EXP_TOLERANCE, 0},
{173, 1090236299u, 1159909278u, 1159909278u, 0, EXP_TOLERANCE, 0},
{174, 1112740353u, 1703662707u, 1703662707u, 0, EXP_TOLERANCE, 0},
{175, 1016536733u, 1065509399u, 1065509399u, 0, EXP_TOLERANCE, 0},
{176, 1118464896u, 2096379477u, 2096379477u, 0, EXP_TOLERANCE, 0},
{177, 1099513553u, 1272403043u, 1272403043u, 0, EXP_TOLERANCE, 0},
{178, 1074304242u, 1090990231u, 1090990231u, 0, EXP_TOLERANCE, 0},
{179, 1050044991u, 1068217824u, 1068217824u, 0, EXP_TOLERANCE, 0},
{180, 1086079415u, 1135833648u, 1135833648u, 0, EXP_TOLERANCE, 0},
{181, 1048899008u, 1067839982u, 1067839982u, 0, EXP_TOLERANCE, 0},
{182, 1098535575u, 1253977432u, 1253977432u, 0, EXP_TOLERANCE, 0},
{183, 1056796285u, 1070725879u, 1070725879u, 0, EXP_TOLERANCE, 0},
{184, 1094236657u, 1204404773u, 1204404773u, 0, EXP_TOLERANCE, 0},
{185, 1027140379u, 1065740608u, 1065740608u, 0, EXP_TOLERANCE, 0},
{186, 1084461801u, 1126560528u, 1126560528u, 0, EXP_TOLERANCE, 0},
{187, 1077234132u, 1099426748u, 1099426748u, 0, EXP_TOLERANCE, 0},
{188, 1091836061u, 1176734999u, 1176734999u, 0, EXP_TOLERANCE, 0},
{189, 1088410165u, 1149784227u, 1149784227u, 0, EXP_TOLERANCE, 0},
{190, 1050059365u, 1068222645u, 1068222645u, 0, EXP_TOLERANCE, 0},
{191, 1092649937u, 1186051502u, 1186051502u, 0, EXP_TOLERANCE, 0},
{192, 1059867088u, 1073407214u, 1073407214u, 0, EXP_TOLERANCE, 0},
{193, 1046232016u, 1067366071u, 1067366071u, 0, EXP_TOLERANCE, 0},
{194, 1041556457u, 1066666057u, 1066666057u, 0, EXP_TOLERANCE, 0},
{195, 1052289223u, 1068996217u, 1068996217u, 0, EXP_TOLERANCE, 0},
{196, 1054774003u, 1069921003u, 1069921003u, 0, EXP_TOLERANCE, 0},
{197, 1083319556u, 1119912811u, 1119912811u, 0, EXP_TOLERANCE, 0},
{198, 1070223249u, 1083929038u, 1083929038u, 0, EXP_TOLERANCE, 0},
{199, 1078801107u, 1103461496u, 1103461496u, 0, EXP_TOLERANCE, 0},
{200, 1050942983u, 1068523051u, 1068523051u, 0, EXP_TOLERANCE, 0},
{201, 1023352018u, 1065618561u, 1065618561u, 0, EXP_TOLERANCE, 0},
{202, 1036601712u, 1066219564u, 1066219564u, 0, EXP_TOLERANCE, 0},
{203, 1014979800u, 1065484986u, 1065484986u, 0, EXP_TOLERANCE, 0},
{204, 1084262010u, 1125572253u, 1125572253u, 0, EXP_TOLERANCE, 0},
{205, 1052778921u, 1069173095u, 1069173095u, 0, EXP_TOLERANCE, 0},
{206, 1077810183u, 1100738137u, 1100738137u, 0, EXP_TOLERANCE, 0},
{207, 1084939616u, 1129343441u, 1129343441u, 0, EXP_TOLERANCE, 0},
{208, 1077413511u, 1099815970u, 1099815970u, 0, EXP_TOLERANCE, 0},
{209, 1061774415u, 1074564362u, 1074564362u, 0, EXP_TOLERANCE, 0},
{210, 1075260391u, 1093258691u, 1093258691u, 0, EXP_TOLERANCE, 0},
{211, 1011007332u, 1065453522u, 1065453522u, 0, EXP_TOLERANCE, 0},
{212, 1093263793u, 1193250687u, 1193250687u, 0, EXP_TOLERANCE, 0},
{213, 1087344003u, 1143208517u, 1143208517u, 0, EXP_TOLERANCE, 0},
{214, 1117835410u, 2038450983u, 2038450983u, 0, EXP_TOLERANCE, 0},
{215, 1043103780u, 1066892341u, 1066892341u, 0, EXP_TOLERANCE, 0},
{216, 1090306155u, 1160270677u, 1160270677u, 0, EXP_TOLERANCE, 0},
{217, 1013026833u, 1065469503u, 1065469503u, 0, EXP_TOLERANCE, 0},
{218, 1064488668u, 1076181876u, 1076181876u, 0, EXP_TOLERANCE, 0},
{219, 1058808746u, 1072402018u, 1072402018u, 0, EXP_TOLERANCE, 0},
{220, 1085379936u, 1132498287u, 1132498287u, 0, EXP_TOLERANCE, 0},
{221, 1011547567u, 1065457794u, 1065457794u, 0, EXP_TOLERANCE, 0},
{222, 1023886482u, 1065634870u, 1065634870u, 0, EXP_TOLERANCE, 0},
{223, 1025428385u, 1065684815u, 1065684815u, 0, EXP_TOLERANCE, 0},
{224, 1018637212u, 1065542895u, 1065542895u, 0, EXP_TOLERANCE, 0},
{225, 1117199775u, 1979751943u, 1979751943u, 0, EXP_TOLERANCE, 0},
{226, 1083088572u, 1118596995u, 1118596995u, 0, EXP_TOLERANCE, 0},
{227, 1094749923u, 1210357028u, 1210357028u, 0, EXP_TOLERANCE, 0},
{228, 1034709247u, 1066089985u, 1066089985u, 0, EXP_TOLERANCE, 0},
{229, 1105234414u, 1404311714u, 1404311714u, 0, EXP_TOLERANCE, 0},
{230, 1031637130u, 1065888859u, 1065888859u, 0, EXP_TOLERANCE, 0},
{231, 1065798296u, 1077375779u, 1077375779u, 0, EXP_TOLERANCE, 0},
{232, 1068550752u, 1082044780u, 1082044780u, 0, EXP_TOLERANCE, 0},
{233, 1074093690u, 1090556451u, 1090556451u, 0, EXP_TOLERANCE, 0},
{234, 1110141777u, 1583544929u, 1583544929u, 0, EXP_TOLERANCE, 0},
{235, 1087522707u, 1144164398u, 1144164398u, 0, EXP_TOLERANCE, 0},
{236, 1089253042u, 1154203512u, 1154203512u, 0, EXP_TOLERANCE, 0},
{237, 1070475893u, 1084240518u, 1084240518u, 0, EXP_TOLERANCE, 0},
{238, 1065761827u, 1077323625u, 1077323625u, 0, EXP_TOLERANCE, 0},
{239, 1035717127u, 1066158768u, 1066158768u, 0, EXP_TOLERANCE, 0},
{240, 1099152750u, 1264084739u, 1264084739u, 0, EXP_TOLERANCE, 0},
{241, 1015617571u, 1065494782u, 1065494782u, 0, EXP_TOLERANCE, 0},
{242, 1040672833u, 1066539155u, 1066539155u, 0, EXP_TOLERANCE, 0},
{243, 1080781593u, 1109284219u, 1109284219u, 0, EXP_TOLERANCE, 0},
{244, 1040875476u, 1066568110u, 1066568110u, 0, EXP_TOLERANCE, 0},
{245, 1020112556u, 1065566501u, 1065566501u, 0, EXP_TOLERANCE, 0},
{246, 1046146787u, 1067352870u, 1067352870u, 0, EXP_TOLERANCE, 0},
{247, 1043662371u, 1066975321u, 1066975321u, 0, EXP_TOLERANCE, 0},
{248, 1034647135u, 1066085763u, 1066085763u, 0, EXP_TOLERANCE, 0},
{249, 1081336221u, 1110751206u, 1110751206u, 0, EXP_TOLERANCE, 0},
{250, 1098878125u, 1258542001u, 1258542001u, 0, EXP_TOLERANCE, 0},
{251, 1011637382u, 1065458504u, 1065458504u, 0, EXP_TOLERANCE, 0},
{252, 1008460484u, 1065433410u, 1065433410u, 0, EXP_TOLERANCE, 0},
{253, 1107342115u, 1454053213u, 1454053213u, 0, EXP_TOLERANCE, 0},
{254, 1098588430u, 1254621775u, 1254621775u, 0, EXP_TOLERANCE, 0},
{255, 1084032979u, 1124549318u, 1124549318u, 0, EXP_TOLERANCE, 0},
{256, 1012481176u, 1065465182u, 1065465182u, 0, EXP_TOLERANCE, 0},
{257, 1106838812u, 1441798446u, 1441798446u, 0, EXP_TOLERANCE, 0},
{258, 1050346079u, 1068319255u, 1068319255u, 0, EXP_TOLERANCE, 0},
{259, 1108701419u, 1517208885u, 1517208885u, 0, EXP_TOLERANCE, 0},
{260, 1059787005u, 1073328915u, 1073328915u, 0, EXP_TOLERANCE, 0},
{261, 1044137644u, 1067046470u, 1067046470u, 0, EXP_TOLERANCE, 0},
{262, 1010973520u, 1065453254u, 1065453254u, 0, EXP_TOLERANCE, 0},
{263, 1089984491u, 1158702046u, 1158702046u, 0, EXP_TOLERANCE, 0},
{264, 1045591776u, 1067267310u, 1067267310u, 0, EXP_TOLERANCE, 0},
{265, 1083608024u, 1121773273u, 1121773273u, 0, EXP_TOLERANCE, 0},
{266, 1106642772u, 1436889651u, 1436889651u, 0, EXP_TOLERANCE, 0},
{267, 1039381219u, 1066413223u, 1066413223u, 0, EXP_TOLERANCE, 0},
{268, 1075129316u, 1092916302u, 1092916302u, 0, EXP_TOLERANCE, 0},
{269, 1009293126u, 1065439980u, 1065439980u, 0, EXP_TOLERANCE, 0},
{270, 1086570035u, 1138933348u, 1138933348u, 0, EXP_TOLERANCE, 0},
{271, 1072752989u, 1087514711u, 1087514711u, 0, EXP_TOLERANCE, 0},
{272, 1117749835u, 2030407796u, 2030407796u, 0, EXP_TOLERANCE, 0},
{273, 1098086564u, 1249369596u, 1249369596u, 0, EXP_TOLERANCE, 0},
{274, 1112054177u, 1671645028u, 1671645028u, 0, EXP_TOLERANCE, 0},
{275, 1070033697u, 1083701425u, 1083701425u, 0, EXP_TOLERANCE, 0},
{276, 1081598195u, 1111514539u, 1111514539u, 0, EXP_TOLERANCE, 0},
{277, 1117244704u, 1983198281u, 1983198281u, 0, EXP_TOLERANCE, 0},
{278, 1064154282u, 1075968187u, 1075968187u, 0, EXP_TOLERANCE, 0},
{279, 1027267512u, 1065744765u, 1065744765u, 0, EXP_TOLERANCE, 0},
{280, 1056871393u, 1070756716u, 1070756716u, 0, EXP_TOLERANCE, 0},
{281, 1052964166u, 1069240682u, 1069240682u, 0, EXP_TOLERANCE, 0},
{282, 1083857029u, 1123598411u, 1123598411u, 0, EXP_TOLERANCE, 0},
{283, 1050317118u, 1068309458u, 1068309458u, 0, EXP_TOLERANCE, 0},
{284, 1105535659u, 1411380676u, 1411380676u, 0, EXP_TOLERANCE, 0},
{285, 1013864474u, 1065476140u, 1065476140u, 0, EXP_TOLERANCE, 0},
{286, 1096937297u, 1235594288u, 1235594288u, 0, EXP_TOLERANCE, 0},
{287, 1041050257u, 1066593155u, 1066593155u, 0, EXP_TOLERANCE, 0},
{288, 1059777219u, 1073319373u, 1073319373u, 0, EXP_TOLERANCE, 0},
{289, 1106107315u, 1424881430u, 1424881430u, 0, EXP_TOLERANCE, 0},
{290, 1068857446u, 1082398380u, 1082398380u, 0, EXP_TOLERANCE, 0},
{291, 1020650268u, 1065575121u, 1065575121u, 0, EXP_TOLERANCE, 0},
{292, 1085258931u, 1131589792u, 1131589792u, 0, EXP_TOLERANCE, 0},
{293, 1045302413u, 1067222982u, 1067222982u, 0, EXP_TOLERANCE, 0},
{294, 1088789271u, 1151554336u, 1151554336u, 0, EXP_TOLERANCE, 0},
{295, 1009727125u, 1065443407u, 1065443407u, 0, EXP_TOLERANCE, 0},
{296, 1034971440u, 1066107829u, 1066107829u, 0, EXP_TOLERANCE, 0},
{297, 1111472322u, 1645079799u, 1645079799u, 0, EXP_TOLERANCE, 0},
{298, 1098047277u, 1248772238u, 1248772238u, 0, EXP_TOLERANCE, 0},
{299, 1053654343u, 1069495802u, 1069495802u, 0, EXP_TOLERANCE, 0},
{300, 1017067235u, 1065517846u, 1065517846u, 0, EXP_TOLERANCE, 0},
{301, 1021021288u, 1065581073u, 1065581073u, 0, EXP_TOLERANCE, 0},
{302, 1061075724u, 1074188639u, 1074188639u, 0, EXP_TOLERANCE, 0},
{303, 1111466355u, 1644870477u, 1644870477u, 0, EXP_TOLERANCE, 0},
{304, 1062629929u, 1075046244u, 1075046244u, 0, EXP_TOLERANCE, 0},
{305, 1035652969u, 1066154374u, 1066154374u, 0, EXP_TOLERANCE, 0},
{306, 1089415367u, 1155278106u, 1155278106u, 0, EXP_TOLERANCE, 0},
{307, 1097797267u, 1245452987u, 1245452987u, 0, EXP_TOLERANCE, 0},
{308, 1043842627u, 1067002246u, 1067002246u, 0, EXP_TOLERANCE, 0},
{309, 1065083199u, 1076572489u, 1076572489u, 0, EXP_TOLERANCE, 0},
{310, 1086073356u, 1135799723u, 1135799723u, 0, EXP_TOLERANCE, 0},
{311, 1105391405u, 1408432053u, 1408432053u, 0, EXP_TOLERANCE, 0},
{312, 1007073386u, 1065422477u, 1065422477u, 0, EXP_TOLERANCE, 0},
{313, 1112946687u, 1712954031u, 1712954031u, 0, EXP_TOLERANCE, 0},
{314, 1054571099u, 1069842892u, 1069842892u, 0, EXP_TOLERANCE, 0},
{315, 1063035063u, 1075283159u, 1075283159u, 0, EXP_TOLERANCE, 0},
{316, 1111195621u, 1631948943u, 1631948943u, 0, EXP_TOLERANCE, 0},
{317, 1106582941u, 1435722047u, 1435722047u, 0, EXP_TOLERANCE, 0},
{318, 1098367790u, 1252134505u, 1252134505u, 0, EXP_TOLERANCE, 0},
{319, 1114614727u, 1789788955u, 1789788955u, 0, EXP_TOLERANCE, 0},
{320, 1059182838u, 1072750102u, 1072750102u, 0, EXP_TOLERANCE, 0},
{321, 1090931053u, 1166671300u, 1166671300u, 0, EXP_TOLERANCE, 0},
{322, 1086777898u, 1140481682u, 1140481682u, 0, EXP_TOLERANCE, 0},
{323, 1015758316u, 1065497018u, 1065497018u, 0, EXP_TOLERANCE, 0},
{324, 1105963769u, 1421146184u, 1421146184u, 0, EXP_TOLERANCE, 0},
{325, 1092601275u, 1185523374u, 1185523374u, 0, EXP_TOLERANCE, 0},
{326, 1026767045u, 1065728411u, 1065728411u, 0, EXP_TOLERANCE, 0},
{327, 1115692265u, 1839892889u, 1839892889u, 0, EXP_TOLERANCE, 0},
{328, 1009779956u, 1065443824u, 1065443824u, 0, EXP_TOLERANCE, 0},
{329, 1044309006u, 1067072247u, 1067072247u, 0, EXP_TOLERANCE, 0},
{330, 1036510567u, 1066213281u, 1066213281u, 0, EXP_TOLERANCE, 0},
{331, 1090731743u, 1164195178u, 1164195178u, 0, EXP_TOLERANCE, 0},
{332, 1017223107u, 1065520330u, 1065520330u, 0, EXP_TOLERANCE, 0},
{333, 1052155526u, 1068948373u, 1068948373u, 0, EXP_TOLERANCE, 0},
{334, 1059461860u, 1073014826u, 1073014826u, 0, EXP_TOLERANCE, 0},
{335, 1058086743u, 1071751765u, 1071751765u, 0, EXP_TOLERANCE, 0},
{336, 1112039377u, 1671057660u, 1671057660u, 0, EXP_TOLERANCE, 0},
{337, 1095033668u, 1213708815u, 1213708815u, 0, EXP_TOLERANCE, 0},
{338, 1086707327u, 1139938718u, 1139938718u, 0, EXP_TOLERANCE, 0},
{339, 1079361630u, 1105312011u, 1105312011u, 0, EXP_TOLERANCE, 0},
{340, 1066116543u, 1077840653u, 1077840653u, 0, EXP_TOLERANCE, 0},
{341, 1064166730u, 1075976066u, 1075976066u, 0, EXP_TOLERANCE, 0},
{342, 1102348498u, 1337693492u, 1337693492u, 0, EXP_TOLERANCE, 0},
{343, 1015629204u, 1065494967u, 1065494967u, 0, EXP_TOLERANCE, 0},
{344, 1030195747u, 1065841068u, 1065841068u, 0, EXP_TOLERANCE, 0},
{345, 1070398346u, 1084143913u, 1084143913u, 0, EXP_TOLERANCE, 0},
{346, 1038252147u, 1066334072u, 1066334072u, 0, EXP_TOLERANCE, 0},
{347, 1040899763u, 1066571586u, 1066571586u, 0, EXP_TOLERANCE, 0},
{348, 1083078837u, 1118544657u, 1118544657u, 0, EXP_TOLERANCE, 0},
{349, 1056607786u, 1070648789u, 1070648789u, 0, EXP_TOLERANCE, 0},
{350, 1096376046u, 1229062802u, 1229062802u, 0, EXP_TOLERANCE, 0},
{351, 1052228830u, 1068974581u, 1068974581u, 0, EXP_TOLERANCE, 0},
{352, 1053012169u, 1069258256u, 1069258256u, 0, EXP_TOLERANCE, 0},
{353, 1049721049u, 1068109706u, 1068109706u, 0, EXP_TOLERANCE, 0},
{354, 1094424013u, 1206991542u, 1206991542u, 0, EXP_TOLERANCE, 0},
{355, 1016617613u, 1065510686u, 1065510686u, 0, EXP_TOLERANCE, 0},
{356, 1024296406u, 1065648120u, 1065648120u, 0, EXP_TOLERANCE, 0},
{357, 1022125625u, 1065598816u, 1065598816u, 0, EXP_TOLERANCE, 0},
{358, 1032104423u, 1065914592u, 1065914592u, 0, EXP_TOLERANCE, 0},
{359, 1092536785u, 1184860180u, 1184860180u, 0, EXP_TOLERANCE, 0},
{360, 1059516864u, 1073067533u, 1073067533u, 0, EXP_TOLERANCE, 0},
{361, 1115763378u, 1846718963u, 1846718963u, 0, EXP_TOLERANCE, 0},
{362, 1107550779u, 1463656357u, 1463656357u, 0, EXP_TOLERANCE, 0},
{363, 1071940738u, 1086243641u, 1086243641u, 0, EXP_TOLERANCE, 0},
{364, 1040041868u, 1066459846u, 1066459846u, 0, EXP_TOLERANCE, 0},
{365, 1095143404u, 1215268570u, 1215268570u, 0, EXP_TOLERANCE, 0},
{366, 1010621254u, 1065450470u, 1065450470u, 0, EXP_TOLERANCE, 0},
{367, 1006780558u, 1065420171u, 1065420171u, 0, EXP_TOLERANCE, 0},
{368, 1021933565u, 1065595727u, 1065595727u, 0, EXP_TOLERANCE, 0},
{369, 1054686121u, 1069887113u, 1069887113u, 0, EXP_TOLERANCE, 0},
{370, 1016828331u, 1065514041u, 1065514041u, 0, EXP_TOLERANCE, 0},
{371, 1030636921u, 1065855668u, 1065855668u, 0, EXP_TOLERANCE, 0},
{372, 1068608693u, 1082145451u, 1082145451u, 0, EXP_TOLERANCE, 0},
{373, 1018961646u, 1065548081u, 1065548081u, 0, EXP_TOLERANCE, 0},
{374, 1116031367u, 1871555577u, 1871555577u, 0, EXP_TOLERANCE, 0},
{375, 1115305326u, 1821871751u, 1821871751u, 0, EXP_TOLERANCE, 0},
{376, 1058958536u, 1072540463u, 1072540463u, 0, EXP_TOLERANCE, 0},
{377, 1118019991u, 2055414797u, 2055414797u, 0, EXP_TOLERANCE, 0},
{378, 1074544343u, 1091512203u, 1091512203u, 0, EXP_TOLERANCE, 0},
{379, 1098466226u, 1253179808u, 1253179808u, 0, EXP_TOLERANCE, 0},
{380, 1089802670u, 1157916191u, 1157916191u, 0, EXP_TOLERANCE, 0},
{381, 1081671201u, 1111735895u, 1111735895u, 0, EXP_TOLERANCE, 0},
{382, 1066726224u, 1078782030u, 1078782030u, 0, EXP_TOLERANCE, 0},
{383, 1118799960u, 2126821501u, 2126821501u, 0, EXP_TOLERANCE, 0},
{384, 1083377370u, 1120265465u, 1120265465u, 0, EXP_TOLERANCE, 0},
{385, 1093053842u, 1191353231u, 1191353231u, 0, EXP_TOLERANCE, 0},
{386, 1115933679u, 1862695146u, 1862695146u, 0, EXP_TOLERANCE, 0},
{387, 1093696468u, 1198591966u, 1198591966u, 0, EXP_TOLERANCE, 0},
{388, 1109187404u, 1539214917u, 1539214917u, 0, EXP_TOLERANCE, 0},
{389, 1011930984u, 1065460827u, 1065460827u, 0, EXP_TOLERANCE, 0},
{390, 1050644766u, 1068420780u, 1068420780u, 0, EXP_TOLERANCE, 0},
{391, 1047982899u, 1067641019u, 1067641019u, 0, EXP_TOLERANCE, 0},
{392, 1020067601u, 1065565781u, 1065565781u, 0, EXP_TOLERANCE, 0},
{393, 1040189459u, 1066470439u, 1066470439u, 0, EXP_TOLERANCE, 0},
{394, 1081753082u, 1111988788u, 1111988788u, 0, EXP_TOLERANCE, 0},
{395, 1079378407u, 1105371301u, 1105371301u, 0, EXP_TOLERANCE, 0},
{396, 1024146852u, 1065643284u, 1065643284u, 0, EXP_TOLERANCE, 0},
{397, 1029918023u, 1065831889u, 1065831889u, 0, EXP_TOLERANCE, 0},
{398, 1099388140u, 1269400788u, 1269400788u, 0, EXP_TOLERANCE, 0},
{399, 1025508438u, 1065687416u, 1065687416u, 0, EXP_TOLERANCE, 0},
{400, 1070164694u, 1083858175u, 1083858175u, 0, EXP_TOLERANCE, 0},
{401, 1009738856u, 1065443499u, 1065443499u, 0, EXP_TOLERANCE, 0},
{402, 1087726104u, 1145356237u, 1145356237u, 0, EXP_TOLERANCE, 0},
{403, 1027667012u, 1065757842u, 1065757842u, 0, EXP_TOLERANCE, 0},
{404, 1026529187u, 1065720649u, 1065720649u, 0, EXP_TOLERANCE, 0},
{405, 1106219203u, 1427327388u, 1427327388u, 0, EXP_TOLERANCE, 0},
{406, 1061557574u, 1074446076u, 1074446076u, 0, EXP_TOLERANCE, 0},
{407, 1068190855u, 1081343804u, 1081343804u, 0, EXP_TOLERANCE, 0},
{408, 1028147309u, 1065773589u, 1065773589u, 0, EXP_TOLERANCE, 0},
{409, 1011538415u, 1065457721u, 1065457721u, 0, EXP_TOLERANCE, 0},
{410, 1087333890u, 1143156822u, 1143156822u, 0, EXP_TOLERANCE, 0},
{411, 1065783414u, 1077354469u, 1077354469u, 0, EXP_TOLERANCE, 0},
{412, 1047658941u, 1067589604u, 1067589604u, 0, EXP_TOLERANCE, 0},
{413, 1020835656u, 1065578095u, 1065578095u, 0, EXP_TOLERANCE, 0},
{414, 1007660778u, 1065427105u, 1065427105u, 0, EXP_TOLERANCE, 0},
{415, 1030084655u, 1065837395u, 1065837395u, 0, EXP_TOLERANCE, 0},
{416, 1064927159u, 1076468626u, 1076468626u, 0, EXP_TOLERANCE, 0},
{417, 1056082624u, 1070436284u, 1070436284u, 0, EXP_TOLERANCE, 0},
{418, 1026762640u, 1065728267u, 1065728267u, 0, EXP_TOLERANCE, 0},
{419, 1093125590u, 1191959413u, 1191959413u, 0, EXP_TOLERANCE, 0},
{420, 1029732434u, 1065825761u, 1065825761u, 0, EXP_TOLERANCE, 0},
{421, 1064993108u, 1076512405u, 1076512405u, 0, EXP_TOLERANCE, 0},
{422, 1063507120u, 1075566524u, 1075566524u, 0, EXP_TOLERANCE, 0},
{423, 1065876936u, 1077489016u, 1077489016u, 0, EXP_TOLERANCE, 0},
{424, 1084196703u, 1125269096u, 1125269096u, 0, EXP_TOLERANCE, 0},
{425, 1083357891u, 1120145562u, 1120145562u, 0, EXP_TOLERANCE, 0},
{426, 1087303226u, 1143001584u, 1143001584u, 0, EXP_TOLERANCE, 0},
{427, 1047274418u, 1067528899u, 1067528899u, 0, EXP_TOLERANCE, 0},
{428, 1066157309u, 1077901485u, 1077901485u, 0, EXP_TOLERANCE, 0},
{429, 1041100905u, 1066600424u, 1066600424u, 0, EXP_TOLERANCE, 0},
{430, 1057444025u, 1071195998u, 1071195998u, 0, EXP_TOLERANCE, 0},
{431, 1094747861u, 1210335839u, 1210335839u, 0, EXP_TOLERANCE, 0},
{432, 1110000152u, 1577335997u, 1577335997u, 0, EXP_TOLERANCE, 0},
{433, 1013018969u, 1065469440u, 1065469440u, 0, EXP_TOLERANCE, 0},
{434, 1111828086u, 1661589669u, 1661589669u, 0, EXP_TOLERANCE, 0},
{435, 1022250020u, 1065600816u, 1065600816u, 0, EXP_TOLERANCE, 0},
{436, 1078328640u, 1102082707u, 1102082707u, 0, EXP_TOLERANCE, 0},
{437, 1058832956u, 1072424311u, 1072424311u, 0, EXP_TOLERANCE, 0},
{438, 1117000602u, 1960911677u, 1960911677u, 0, EXP_TOLERANCE, 0},
{439, 1100264675u, 1289849849u, 1289849849u, 0, EXP_TOLERANCE, 0},
{440, 1085721092u, 1133986574u, 1133986574u, 0, EXP_TOLERANCE, 0},
{441, 1069009211u, 1082556418u, 1082556418u, 0, EXP_TOLERANCE, 0},
{442, 1057613820u, 1071340759u, 1071340759u, 0, EXP_TOLERANCE, 0},
{443, 1062874882u, 1075188804u, 1075188804u, 0, EXP_TOLERANCE, 0},
{444, 1079554187u, 1106006973u, 1106006973u, 0, EXP_TOLERANCE, 0},
{445, 1046944877u, 1067477149u, 1067477149u, 0, EXP_TOLERANCE, 0},
{446, 1097750489u, 1244915131u, 1244915131u, 0, EXP_TOLERANCE, 0},
{447, 1074473903u, 1091355960u, 1091355960u, 0, EXP_TOLERANCE, 0},
{448, 1023707715u, 1065629098u, 1065629098u, 0, EXP_TOLERANCE, 0},
{449, 1079061705u, 1104291134u, 1104291134u, 0, EXP_TOLERANCE, 0},
{450, 1080125709u, 1107782090u, 1107782090u, 0, EXP_TOLERANCE, 0},
{451, 1057966560u, 1071646216u, 1071646216u, 0, EXP_TOLERANCE, 0},
{452, 1098046913u, 1248766806u, 1248766806u, 0, EXP_TOLERANCE, 0},
{453, 1079118215u, 1104477942u, 1104477942u, 0, EXP_TOLERANCE, 0},
{454, 1076920325u, 1098661587u, 1098661587u, 0, EXP_TOLERANCE, 0},
{455, 1077338039u, 1099650177u, 1099650177u, 0, EXP_TOLERANCE, 0},
{456, 1049161799u, 1067925490u, 1067925490u, 0, EXP_TOLERANCE, 0},
{457, 1025484427u, 1065686636u, 1065686636u, 0, EXP_TOLERANCE, 0},
{458, 1081885050u, 1112406912u, 1112406912u, 0, EXP_TOLERANCE, 0},
{459, 1036634459u, 1066221822u, 1066221822u, 0, EXP_TOLERANCE, 0},
{460, 1055376216u, 1070155635u, 1070155635u, 0, EXP_TOLERANCE, 0},
{461, 1052873853u, 1069207685u, 1069207685u, 0, EXP_TOLERANCE, 0},
{462, 1013844829u, 1065475984u, 1065475984u, 0, EXP_TOLERANCE, 0},
{463, 1019491913u, 1065556563u, 1065556563u, 0, EXP_TOLERANCE, 0},
{464, 1046721730u, 1067442252u, 1067442252u, 0, EXP_TOLERANCE, 0},
{465, 1056763990u, 1070712641u, 1070712641u, 0, EXP_TOLERANCE, 0},
{466, 1053047266u, 1069271122u, 1069271122u, 0, EXP_TOLERANCE, 0},
{467, 1051195553u, 1068610382u, 1068610382u, 0, EXP_TOLERANCE, 0},
{468, 1106033213u, 1422825889u, 1422825889u, 0, EXP_TOLERANCE, 0},
{469, 1039695875u, 1066435400u, 1066435400u, 0, EXP_TOLERANCE, 0},
{470, 1087938837u, 1146732848u, 1146732848u, 0, EXP_TOLERANCE, 0},
{471, 1086382700u, 1137663500u, 1137663500u, 0, EXP_TOLERANCE, 0},
{472, 1041130723u, 1066604706u, 1066604706u, 0, EXP_TOLERANCE, 0},
{473, 1070900975u, 1084786236u, 1084786236u, 0, EXP_TOLERANCE, 0},
{474, 1094918207u, 1212234718u, 1212234718u, 0, EXP_TOLERANCE, 0},
{475, 1059727635u, 1073271108u, 1073271108u, 0, EXP_TOLERANCE, 0},
{476, 1021599538u, 1065590359u, 1065590359u, 0, EXP_TOLERANCE, 0},
{477, 1067180353u, 1079529057u, 1079529057u, 0, EXP_TOLERANCE, 0},
{478, 1101660315u, 1321856380u, 1321856380u, 0, EXP_TOLERANCE, 0},
{479, 1109054467u, 1533379708u, 1533379708u, 0, EXP_TOLERANCE, 0},
{480, 1103532738u, 1365273754u, 1365273754u, 0, EXP_TOLERANCE, 0},
{481, 1035525679u, 1066145663u, 1066145663u, 0, EXP_TOLERANCE, 0},
{482, 1094330983u, 1205649366u, 1205649366u, 0, EXP_TOLERANCE, 0},
{483, 1034492227u, 1066075242u, 1066075242u, 0, EXP_TOLERANCE, 0},
{484, 1072096532u, 1086477996u, 1086477996u, 0, EXP_TOLERANCE, 0},
{485, 1075990050u, 1095373204u, 1095373204u, 0, EXP_TOLERANCE, 0},
{486, 1109033185u, 1532206806u, 1532206806u, 0, EXP_TOLERANCE, 0},
{487, 1089560310u, 1156310516u, 1156310516u, 0, EXP_TOLERANCE, 0},
{488, 1103328289u, 1360524395u, 1360524395u, 0, EXP_TOLERANCE, 0},
{489, 1061907666u, 1074637811u, 1074637811u, 0, EXP_TOLERANCE, 0},
{490, 1083710041u, 1122494921u, 1122494921u, 0, EXP_TOLERANCE, 0},
{491, 1100867428u, 1303512311u, 1303512311u, 0, EXP_TOLERANCE, 0},
{492, 1055125047u, 1070057263u, 1070057263u, 0, EXP_TOLERANCE, 0},
{493, 1104553235u, 1388607970u, 1388607970u, 0, EXP_TOLERANCE, 0},
{494, 1032386633u, 1065933431u, 1065933431u, 0, EXP_TOLERANCE, 0},
{495, 1034271795u, 1066060291u, 1066060291u, 0, EXP_TOLERANCE, 0},
{496, 1055506573u, 1070206981u, 1070206981u, 0, EXP_TOLERANCE, 0},
{497, 1104281863u, 1382690251u, 1382690251u, 0, EXP_TOLERANCE, 0},
{498, 1025475511u, 1065686346u, 1065686346u, 0, EXP_TOLERANCE, 0},
{499, 1076895780u, 1098565127u, 1098565127u, 0, EXP_TOLERANCE, 0},
{500, 1009589036u, 1065442316u, 1065442316u, 0, EXP_TOLERANCE, 0},
{501, 1110359908u, 1593993278u, 1593993278u, 0, EXP_TOLERANCE, 0},
{502, 1028807839u, 1065795292u, 1065795292u, 0, EXP_TOLERANCE, 0},
{503, 1109436551u, 1551267569u, 1551267569u, 0, EXP_TOLERANCE, 0},
{504, 1021730413u, 1065592462u, 1065592462u, 0, EXP_TOLERANCE, 0},
{505, 1072081640u, 1086455406u, 1086455406u, 0, EXP_TOLERANCE, 0},
{506, 1077465839u, 1099932685u, 1099932685u, 0, EXP_TOLERANCE, 0},
{507, 1044300951u, 1067071033u, 1067071033u, 0, EXP_TOLERANCE, 0},
{508, 1097032302u, 1236623967u, 1236623967u, 0, EXP_TOLERANCE, 0},
{509, 1053981400u, 1069618541u, 1069618541u, 0, EXP_TOLERANCE, 0},
{510, 1078478376u, 1102502986u, 1102502986u, 0, EXP_TOLERANCE, 0},
{511, 1098068815u, 1249096941u, 1249096941u, 0, EXP_TOLERANCE, 0},
{512, 1021467071u, 1065588231u, 1065588231u, 0, EXP_TOLERANCE, 0},
{513, 1009763492u, 1065443694u, 1065443694u, 0, EXP_TOLERANCE, 0},
{514, 1044623194u, 1067119679u, 1067119679u, 0, EXP_TOLERANCE, 0},
{515, 1015705469u, 1065496179u, 1065496179u, 0, EXP_TOLERANCE, 0},
{516, 1113725538u, 1748718730u, 1748718730u, 0, EXP_TOLERANCE, 0},
{517, 1091841457u, 1176790302u, 1176790302u, 0, EXP_TOLERANCE, 0},
{518, 1028958993u, 1065800266u, 1065800266u, 0, EXP_TOLERANCE, 0},
{519, 1107682111u, 1469872413u, 1469872413u, 0, EXP_TOLERANCE, 0},
{520, 1116027769u, 1871304107u, 1871304107u, 0, EXP_TOLERANCE, 0},
{521, 1095143732u, 1215273481u, 1215273481u, 0, EXP_TOLERANCE, 0},
{522, 1109791849u, 1567552701u, 1567552701u, 0, EXP_TOLERANCE, 0},
{523, 1080343714u, 1108255550u, 1108255550u, 0, EXP_TOLERANCE, 0},
{524, 1097380552u, 1241306521u, 1241306521u, 0, EXP_TOLERANCE, 0},
{525, 1014020764u, 1065477379u, 1065477379u, 0, EXP_TOLERANCE, 0},
{526, 1021650291u, 1065591174u, 1065591174u, 0, EXP_TOLERANCE, 0},
{527, 1082778705u, 1117044746u, 1117044746u, 0, EXP_TOLERANCE, 0},
{528, 1008484823u, 1065433602u, 1065433602u, 0, EXP_TOLERANCE, 0},
{529, 1007086271u, 1065422579u, 1065422579u, 0, EXP_TOLERANCE, 0},
{530, 1073311024u, 1088462085u, 1088462085u, 0, EXP_TOLERANCE, 0},
{531, 1019109924u, 1065550452u, 1065550452u, 0, EXP_TOLERANCE, 0},
{532, 1018648250u, 1065543071u, 1065543071u, 0, EXP_TOLERANCE, 0},
{533, 1072458508u, 1087039603u, 1087039603u, 0, EXP_TOLERANCE, 0},
{534, 1056562851u, 1070630475u, 1070630475u, 0, EXP_TOLERANCE, 0},
{535, 1043828826u, 1067000182u, 1067000182u, 0, EXP_TOLERANCE, 0},
{536, 1042710124u, 1066834276u, 1066834276u, 0, EXP_TOLERANCE, 0},
{537, 1096757647u, 1233884720u, 1233884720u, 0, EXP_TOLERANCE, 0},
{538, 1110766850u, 1612314434u, 1612314434u, 0, EXP_TOLERANCE, 0},
{539, 1050846809u, 1068489970u, 1068489970u, 0, EXP_TOLERANCE, 0},
{540, 1049017704u, 1067878521u, 1067878521u, 0, EXP_TOLERANCE, 0},
{541, 1041850943u, 1066708722u, 1066708722u, 0, EXP_TOLERANCE, 0},
{542, 1113559832u, 1741102728u, 1741102728u, 0, EXP_TOLERANCE, 0},
{543, 1078359574u, 1102168308u, 1102168308u, 0, EXP_TOLERANCE, 0},
{544, 1063112056u, 1075328834u, 1075328834u, 0, EXP_TOLERANCE, 0},
{545, 1107012128u, 1445401767u, 1445401767u, 0, EXP_TOLERANCE, 0},
{546, 1061909506u, 1074638830u, 1074638830u, 0, EXP_TOLERANCE, 0},
{547, 1027921603u, 1065766186u, 1065766186u, 0, EXP_TOLERANCE, 0},
{548, 1076752219u, 1098012128u, 1098012128u, 0, EXP_TOLERANCE, 0},
{549, 1021430647u, 1065587646u, 1065587646u, 0, EXP_TOLERANCE, 0},
{550, 1013529335u, 1065473484u, 1065473484u, 0, EXP_TOLERANCE, 0},
{551, 1094132929u, 1203159396u, 1203159396u, 0, EXP_TOLERANCE, 0},
{552, 1015879284u, 1065498941u, 1065498941u, 0, EXP_TOLERANCE, 0},
{553, 1095821013u, 1222937523u, 1222937523u, 0, EXP_TOLERANCE, 0},
{554, 1051548019u, 1068733358u, 1068733358u, 0, EXP_TOLERANCE, 0},
{555, 1038345009u, 1066340557u, 1066340557u, 0, EXP_TOLERANCE, 0},
{556, 1111212143u, 1632791232u, 1632791232u, 0, EXP_TOLERANCE, 0},
{557, 1105553664u, 1411746926u, 1411746926u, 0, EXP_TOLERANCE, 0},
{558, 1085166299u, 1130902555u, 1130902555u, 0, EXP_TOLERANCE, 0},
{559, 1009111476u, 1065438546u, 1065438546u, 0, EXP_TOLERANCE, 0},
{560, 1035296501u, 1066130000u, 1066130000u, 0, EXP_TOLERANCE, 0},
{561, 1099936659u, 1282493540u, 1282493540u, 0, EXP_TOLERANCE, 0},
{562, 1046117057u, 1067348269u, 1067348269u, 0, EXP_TOLERANCE, 0},
{563, 1039949220u, 1066453293u, 1066453293u, 0, EXP_TOLERANCE, 0},
{564, 1044713476u, 1067133350u, 1067133350u, 0, EXP_TOLERANCE, 0},
{565, 1053631629u, 1069487322u, 1069487322u, 0, EXP_TOLERANCE, 0},
{566, 1097055270u, 1236887207u, 1236887207u, 0, EXP_TOLERANCE, 0},
{567, 1108662760u, 1515063328u, 1515063328u, 0, EXP_TOLERANCE, 0}

// AUTOMATICALLY GENERATED VECTORS STOP

};

#endif // CYGONCE_LIBM_EXPF_H multiple inclusion protection

// EOF expf.h
