#ifndef CYGONCE_LIBM_ERFF_H
#define CYGONCE_LIBM_ERFF_H
//===========================================================================
//
//      erff.h
//
//      Test vectors for testing of erff() math library function
//
//===========================================================================
// ####EERFFGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 2012 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later
// version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License
// along with eCos; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
// As a special exception, if other files instantiate templates or use
// macros or inline functions from this file, or you compile this file
// and link it with other works to produce a work based on this file,
// this file does not by itself cause the resulting work to be covered by
// the GNU General Public License. However the source code for this file
// must still be made available in accordance with section (3) of the GNU
// General Public License v2.
//
// This exception does not invalidate any other reasons why a work based
// on this file might be covered by the GNU General Public License.
// -------------------------------------------
// ####EERFFGPLCOPYRIGHTEND####
//===========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):
// Contributors:  visar, ilijak
// Date:        1998-02-13
// Purpose:
// Description:
// Usage:       #include "vectors/erff.h"
//
//####DESCRIPTIONEND####
//
//===========================================================================


// CONFIGURATION

#include <pkgconf/libm.h>   // Configuration header


// INCLUDES

#include <cyg/infra/cyg_type.h>    // Common type definitions and support
#include "vectors/vector_support_float.h"// extra support for math tests

#define ERFF_TOLERANCE 1.0E-04

static const Cyg_libm_test_float_vec_t erff_vec[] = {

// AUTOMATICALLY GENERATED VECTORS START

{0, 3214514586u, 2147516072u, 3211332182u, 0, ERFF_TOLERANCE, 0},
{1, 3214430700u, 2147516072u, 3211286788u, 0, ERFF_TOLERANCE, 0},
{2, 3214346813u, 2147516072u, 3211240301u, 0, ERFF_TOLERANCE, 0},
{3, 3214262927u, 2147516072u, 3211192703u, 0, ERFF_TOLERANCE, 0},
{4, 3214179041u, 2147516072u, 3211143979u, 0, ERFF_TOLERANCE, 0},
{5, 3214095155u, 2147516072u, 3211094111u, 0, ERFF_TOLERANCE, 0},
{6, 3214011269u, 2147516072u, 3211043083u, 0, ERFF_TOLERANCE, 0},
{7, 3213927383u, 2147516072u, 3210990878u, 0, ERFF_TOLERANCE, 0},
{8, 3213843497u, 2147516072u, 3210937480u, 0, ERFF_TOLERANCE, 0},
{9, 3213759611u, 2147516072u, 3210882872u, 0, ERFF_TOLERANCE, 0},
{10, 3213675725u, 2147516072u, 3210827039u, 0, ERFF_TOLERANCE, 0},
{11, 3213591839u, 2147516072u, 3210769963u, 0, ERFF_TOLERANCE, 0},
{12, 3213507953u, 2147516072u, 3210711630u, 0, ERFF_TOLERANCE, 0},
{13, 3213424067u, 2147516072u, 3210652023u, 0, ERFF_TOLERANCE, 0},
{14, 3213340180u, 2147516072u, 3210591126u, 0, ERFF_TOLERANCE, 0},
{15, 3213256294u, 2147516072u, 3210528924u, 0, ERFF_TOLERANCE, 0},
{16, 3213172408u, 2147516072u, 3210465403u, 0, ERFF_TOLERANCE, 0},
{17, 3213088522u, 2147516072u, 3210400547u, 0, ERFF_TOLERANCE, 0},
{18, 3213004636u, 2147516072u, 3210334341u, 0, ERFF_TOLERANCE, 0},
{19, 3212920750u, 2147516072u, 3210266770u, 0, ERFF_TOLERANCE, 0},
{20, 3212836864u, 2147516072u, 3210197821u, 0, ERFF_TOLERANCE, 0},
{21, 3212669092u, 2147516072u, 3210127479u, 0, ERFF_TOLERANCE, 0},
{22, 3212501320u, 2147516072u, 3210055730u, 0, ERFF_TOLERANCE, 0},
{23, 3212333548u, 2147516072u, 3209982561u, 0, ERFF_TOLERANCE, 0},
{24, 3212165775u, 2147516072u, 3209907959u, 0, ERFF_TOLERANCE, 0},
{25, 3211998003u, 2147516072u, 3209831910u, 0, ERFF_TOLERANCE, 0},
{26, 3211662459u, 2147516072u, 3209675425u, 0, ERFF_TOLERANCE, 0},
{27, 3211494687u, 2147516072u, 3209594964u, 0, ERFF_TOLERANCE, 0},
{28, 3211326915u, 2147516072u, 3209513009u, 0, ERFF_TOLERANCE, 0},
{29, 3211159142u, 2147516072u, 3209429548u, 0, ERFF_TOLERANCE, 0},
{30, 3210991370u, 2147516072u, 3209344573u, 0, ERFF_TOLERANCE, 0},
{31, 3210823598u, 2147516072u, 3209258071u, 0, ERFF_TOLERANCE, 0},
{32, 3210655826u, 2147516072u, 3209170033u, 0, ERFF_TOLERANCE, 0},
{33, 3210488054u, 2147516072u, 3209080450u, 0, ERFF_TOLERANCE, 0},
{34, 3210320282u, 2147516072u, 3208989312u, 0, ERFF_TOLERANCE, 0},
{35, 3210152509u, 2147516072u, 3208896612u, 0, ERFF_TOLERANCE, 0},
{36, 3209984737u, 2147516072u, 3208802342u, 0, ERFF_TOLERANCE, 0},
{37, 3209816965u, 2147516072u, 3208706493u, 0, ERFF_TOLERANCE, 0},
{38, 3209649193u, 2147516072u, 3208609060u, 0, ERFF_TOLERANCE, 0},
{39, 3209481421u, 2147516072u, 3208510036u, 0, ERFF_TOLERANCE, 0},
{40, 3209313649u, 2147516072u, 3208409415u, 0, ERFF_TOLERANCE, 0},
{41, 3209145876u, 2147516072u, 3208307190u, 0, ERFF_TOLERANCE, 0},
{42, 3208978104u, 2147516072u, 3208203360u, 0, ERFF_TOLERANCE, 0},
{43, 3208810332u, 2147516072u, 3208097918u, 0, ERFF_TOLERANCE, 0},
{44, 3208642560u, 2147516072u, 3207990860u, 0, ERFF_TOLERANCE, 0},
{45, 3208474788u, 2147516072u, 3207882184u, 0, ERFF_TOLERANCE, 0},
{46, 3208307016u, 2147516072u, 3207771889u, 0, ERFF_TOLERANCE, 0},
{47, 3208139244u, 2147516072u, 3207659971u, 0, ERFF_TOLERANCE, 0},
{48, 3207971471u, 2147516072u, 3207546430u, 0, ERFF_TOLERANCE, 0},
{49, 3207803699u, 2147516072u, 3207431265u, 0, ERFF_TOLERANCE, 0},
{50, 3207635927u, 2147516072u, 3207314476u, 0, ERFF_TOLERANCE, 0},
{51, 3207468155u, 2147516072u, 3207196066u, 0, ERFF_TOLERANCE, 0},
{52, 3207300383u, 2147516072u, 3207076033u, 0, ERFF_TOLERANCE, 0},
{53, 3207132611u, 2147516072u, 3206954381u, 0, ERFF_TOLERANCE, 0},
{54, 3206964838u, 2147516072u, 3206831112u, 0, ERFF_TOLERANCE, 0},
{55, 3206797066u, 2147516072u, 3206706232u, 0, ERFF_TOLERANCE, 0},
{56, 3206629294u, 2147516072u, 3206579741u, 0, ERFF_TOLERANCE, 0},
{57, 3206461522u, 2147516072u, 3206451648u, 0, ERFF_TOLERANCE, 0},
{58, 3206293750u, 2147516072u, 3206321956u, 0, ERFF_TOLERANCE, 0},
{59, 3206125978u, 2147516072u, 3206190672u, 0, ERFF_TOLERANCE, 0},
{60, 3205958205u, 2147516072u, 3206057802u, 0, ERFF_TOLERANCE, 0},
{61, 3205790433u, 2147516072u, 3205923357u, 0, ERFF_TOLERANCE, 0},
{62, 3205622661u, 2147516072u, 3205787343u, 0, ERFF_TOLERANCE, 0},
{63, 3205454889u, 2147516072u, 3205649769u, 0, ERFF_TOLERANCE, 0},
{64, 3205287117u, 2147516072u, 3205510646u, 0, ERFF_TOLERANCE, 0},
{65, 3205119345u, 2147516072u, 3205369984u, 0, ERFF_TOLERANCE, 0},
{66, 3204951572u, 2147516072u, 3205227794u, 0, ERFF_TOLERANCE, 0},
{67, 3204783800u, 2147516072u, 3205084089u, 0, ERFF_TOLERANCE, 0},
{68, 3204616028u, 2147516072u, 3204938882u, 0, ERFF_TOLERANCE, 0},
{69, 3204448256u, 2147516072u, 3204792187u, 0, ERFF_TOLERANCE, 0},
{70, 3204112712u, 2147516072u, 3204644016u, 0, ERFF_TOLERANCE, 0},
{71, 3203777167u, 2147516072u, 3204494388u, 0, ERFF_TOLERANCE, 0},
{72, 3203441623u, 2147516072u, 3204238374u, 0, ERFF_TOLERANCE, 0},
{73, 3203106079u, 2147516072u, 3203933377u, 0, ERFF_TOLERANCE, 0},
{74, 3202770534u, 2147516072u, 3203625559u, 0, ERFF_TOLERANCE, 0},
{75, 3202434990u, 2147516072u, 3203314959u, 0, ERFF_TOLERANCE, 0},
{76, 3202099446u, 2147516072u, 3203001614u, 0, ERFF_TOLERANCE, 0},
{77, 3201763901u, 2147516072u, 3202685561u, 0, ERFF_TOLERANCE, 0},
{78, 3201428357u, 2147516072u, 3202366844u, 0, ERFF_TOLERANCE, 0},
{79, 3201092813u, 2147516072u, 3202045502u, 0, ERFF_TOLERANCE, 0},
{80, 3200757268u, 2147516072u, 3201721579u, 0, ERFF_TOLERANCE, 0},
{81, 3200421724u, 2147516072u, 3201395120u, 0, ERFF_TOLERANCE, 0},
{82, 3200086180u, 2147516072u, 3201066170u, 0, ERFF_TOLERANCE, 0},
{83, 3199750636u, 2147516072u, 3200734777u, 0, ERFF_TOLERANCE, 0},
{84, 3199415091u, 2147516072u, 3200400989u, 0, ERFF_TOLERANCE, 0},
{85, 3199079547u, 2147516072u, 3200064857u, 0, ERFF_TOLERANCE, 0},
{86, 3198744003u, 2147516072u, 3199726432u, 0, ERFF_TOLERANCE, 0},
{87, 3198408458u, 2147516072u, 3199385764u, 0, ERFF_TOLERANCE, 0},
{88, 3198072914u, 2147516072u, 3199042911u, 0, ERFF_TOLERANCE, 0},
{89, 3197737370u, 2147516072u, 3198697925u, 0, ERFF_TOLERANCE, 0},
{90, 3197401825u, 2147516072u, 3198350862u, 0, ERFF_TOLERANCE, 0},
{91, 3197066281u, 2147516072u, 3198001781u, 0, ERFF_TOLERANCE, 0},
{92, 3196730737u, 2147516072u, 3197650740u, 0, ERFF_TOLERANCE, 0},
{93, 3196395192u, 2147516072u, 3197297797u, 0, ERFF_TOLERANCE, 0},
{94, 3196059648u, 2147516072u, 3196943015u, 0, ERFF_TOLERANCE, 0},
{95, 3195388559u, 2147516072u, 3196586454u, 0, ERFF_TOLERANCE, 0},
{96, 3194717471u, 2147516072u, 3196228179u, 0, ERFF_TOLERANCE, 0},
{97, 3194046382u, 2147516072u, 3195676853u, 0, ERFF_TOLERANCE, 0},
{98, 3193375293u, 2147516072u, 3194953822u, 0, ERFF_TOLERANCE, 0},
{99, 3192704205u, 2147516072u, 3194227750u, 0, ERFF_TOLERANCE, 0},
{100, 3192033116u, 2147516072u, 3193498766u, 0, ERFF_TOLERANCE, 0},
{101, 3191362028u, 2147516072u, 3192767008u, 0, ERFF_TOLERANCE, 0},
{102, 3190690939u, 2147516072u, 3192032610u, 0, ERFF_TOLERANCE, 0},
{103, 3190019850u, 2147516072u, 3191295711u, 0, ERFF_TOLERANCE, 0},
{104, 3189348762u, 2147516072u, 3190556451u, 0, ERFF_TOLERANCE, 0},
{105, 3188677673u, 2147516072u, 3189814969u, 0, ERFF_TOLERANCE, 0},
{106, 3188006584u, 2147516072u, 3189071408u, 0, ERFF_TOLERANCE, 0},
{107, 3186999951u, 2147516072u, 3188325912u, 0, ERFF_TOLERANCE, 0},
{108, 3185657774u, 2147516072u, 3187486208u, 0, ERFF_TOLERANCE, 0},
{109, 3184315597u, 2147516072u, 3185988341u, 0, ERFF_TOLERANCE, 0},
{110, 3182973420u, 2147516072u, 3184487476u, 0, ERFF_TOLERANCE, 0},
{111, 3181631242u, 2147516072u, 3182983905u, 0, ERFF_TOLERANCE, 0},
{112, 3180289065u, 2147516072u, 3181477928u, 0, ERFF_TOLERANCE, 0},
{113, 3178611343u, 2147516072u, 3179969841u, 0, ERFF_TOLERANCE, 0},
{114, 3175926989u, 2147516072u, 3177637454u, 0, ERFF_TOLERANCE, 0},
{115, 3173242634u, 2147516072u, 3174614636u, 0, ERFF_TOLERANCE, 0},
{116, 3170222735u, 2147516072u, 3171589400u, 0, ERFF_TOLERANCE, 0},
{117, 3164854026u, 2147516072u, 3166230872u, 0, ERFF_TOLERANCE, 0},
{118, 3156465418u, 2147516072u, 3157843475u, 0, ERFF_TOLERANCE, 0},
{119, 646742016u, 2147516072u, 647924107u, 0, ERFF_TOLERANCE, 0},
{120, 1008981770u, 2147516072u, 1010359827u, 0, ERFF_TOLERANCE, 0},
{121, 1017370378u, 2147516072u, 1018747224u, 0, ERFF_TOLERANCE, 0},
{122, 1022739087u, 2147516072u, 1024105752u, 0, ERFF_TOLERANCE, 0},
{123, 1025758986u, 2147516072u, 1027130988u, 0, ERFF_TOLERANCE, 0},
{124, 1028443341u, 2147516072u, 1030153806u, 0, ERFF_TOLERANCE, 0},
{125, 1031127695u, 2147516072u, 1032486193u, 0, ERFF_TOLERANCE, 0},
{126, 1032805417u, 2147516072u, 1033994280u, 0, ERFF_TOLERANCE, 0},
{127, 1034147594u, 2147516072u, 1035500257u, 0, ERFF_TOLERANCE, 0},
{128, 1035489772u, 2147516072u, 1037003828u, 0, ERFF_TOLERANCE, 0},
{129, 1036831949u, 2147516072u, 1038504693u, 0, ERFF_TOLERANCE, 0},
{130, 1038174126u, 2147516072u, 1040002560u, 0, ERFF_TOLERANCE, 0},
{131, 1039516303u, 2147516072u, 1040842264u, 0, ERFF_TOLERANCE, 0},
{132, 1040522936u, 2147516072u, 1041587760u, 0, ERFF_TOLERANCE, 0},
{133, 1041194025u, 2147516072u, 1042331321u, 0, ERFF_TOLERANCE, 0},
{134, 1041865114u, 2147516072u, 1043072803u, 0, ERFF_TOLERANCE, 0},
{135, 1042536202u, 2147516072u, 1043812063u, 0, ERFF_TOLERANCE, 0},
{136, 1043207291u, 2147516072u, 1044548962u, 0, ERFF_TOLERANCE, 0},
{137, 1043878380u, 2147516072u, 1045283360u, 0, ERFF_TOLERANCE, 0},
{138, 1044549468u, 2147516072u, 1046015118u, 0, ERFF_TOLERANCE, 0},
{139, 1045220557u, 2147516072u, 1046744102u, 0, ERFF_TOLERANCE, 0},
{140, 1045891645u, 2147516072u, 1047470174u, 0, ERFF_TOLERANCE, 0},
{141, 1046562734u, 2147516072u, 1048193205u, 0, ERFF_TOLERANCE, 0},
{142, 1047233823u, 2147516072u, 1048744531u, 0, ERFF_TOLERANCE, 0},
{143, 1047904911u, 2147516072u, 1049102806u, 0, ERFF_TOLERANCE, 0},
{144, 1048576000u, 2147516072u, 1049459367u, 0, ERFF_TOLERANCE, 0},
{145, 1048911544u, 2147516072u, 1049814149u, 0, ERFF_TOLERANCE, 0},
{146, 1049247089u, 2147516072u, 1050167092u, 0, ERFF_TOLERANCE, 0},
{147, 1049582633u, 2147516072u, 1050518133u, 0, ERFF_TOLERANCE, 0},
{148, 1049918177u, 2147516072u, 1050867214u, 0, ERFF_TOLERANCE, 0},
{149, 1050253722u, 2147516072u, 1051214277u, 0, ERFF_TOLERANCE, 0},
{150, 1050589266u, 2147516072u, 1051559263u, 0, ERFF_TOLERANCE, 0},
{151, 1050924810u, 2147516072u, 1051902116u, 0, ERFF_TOLERANCE, 0},
{152, 1051260355u, 2147516072u, 1052242784u, 0, ERFF_TOLERANCE, 0},
{153, 1051595899u, 2147516072u, 1052581209u, 0, ERFF_TOLERANCE, 0},
{154, 1051931443u, 2147516072u, 1052917341u, 0, ERFF_TOLERANCE, 0},
{155, 1052266988u, 2147516072u, 1053251129u, 0, ERFF_TOLERANCE, 0},
{156, 1052602532u, 2147516072u, 1053582522u, 0, ERFF_TOLERANCE, 0},
{157, 1052938076u, 2147516072u, 1053911472u, 0, ERFF_TOLERANCE, 0},
{158, 1053273620u, 2147516072u, 1054237931u, 0, ERFF_TOLERANCE, 0},
{159, 1053609165u, 2147516072u, 1054561854u, 0, ERFF_TOLERANCE, 0},
{160, 1053944709u, 2147516072u, 1054883196u, 0, ERFF_TOLERANCE, 0},
{161, 1054280253u, 2147516072u, 1055201913u, 0, ERFF_TOLERANCE, 0},
{162, 1054615798u, 2147516072u, 1055517966u, 0, ERFF_TOLERANCE, 0},
{163, 1054951342u, 2147516072u, 1055831311u, 0, ERFF_TOLERANCE, 0},
{164, 1055286886u, 2147516072u, 1056141911u, 0, ERFF_TOLERANCE, 0},
{165, 1055622431u, 2147516072u, 1056449729u, 0, ERFF_TOLERANCE, 0},
{166, 1055957975u, 2147516072u, 1056754726u, 0, ERFF_TOLERANCE, 0},
{167, 1056293519u, 2147516072u, 1057010740u, 0, ERFF_TOLERANCE, 0},
{168, 1056629064u, 2147516072u, 1057160368u, 0, ERFF_TOLERANCE, 0},
{169, 1056964608u, 2147516072u, 1057308539u, 0, ERFF_TOLERANCE, 0},
{170, 1057132380u, 2147516072u, 1057455234u, 0, ERFF_TOLERANCE, 0},
{171, 1057300152u, 2147516072u, 1057600441u, 0, ERFF_TOLERANCE, 0},
{172, 1057467924u, 2147516072u, 1057744146u, 0, ERFF_TOLERANCE, 0},
{173, 1057635697u, 2147516072u, 1057886336u, 0, ERFF_TOLERANCE, 0},
{174, 1057803469u, 2147516072u, 1058026998u, 0, ERFF_TOLERANCE, 0},
{175, 1057971241u, 2147516072u, 1058166121u, 0, ERFF_TOLERANCE, 0},
{176, 1058139013u, 2147516072u, 1058303695u, 0, ERFF_TOLERANCE, 0},
{177, 1058306785u, 2147516072u, 1058439709u, 0, ERFF_TOLERANCE, 0},
{178, 1058474557u, 2147516072u, 1058574154u, 0, ERFF_TOLERANCE, 0},
{179, 1058642330u, 2147516072u, 1058707024u, 0, ERFF_TOLERANCE, 0},
{180, 1058810102u, 2147516072u, 1058838308u, 0, ERFF_TOLERANCE, 0},
{181, 1058977874u, 2147516072u, 1058968000u, 0, ERFF_TOLERANCE, 0},
{182, 1059145646u, 2147516072u, 1059096093u, 0, ERFF_TOLERANCE, 0},
{183, 1059313418u, 2147516072u, 1059222584u, 0, ERFF_TOLERANCE, 0},
{184, 1059481190u, 2147516072u, 1059347464u, 0, ERFF_TOLERANCE, 0},
{185, 1059648963u, 2147516072u, 1059470733u, 0, ERFF_TOLERANCE, 0},
{186, 1059816735u, 2147516072u, 1059592385u, 0, ERFF_TOLERANCE, 0},
{187, 1059984507u, 2147516072u, 1059712418u, 0, ERFF_TOLERANCE, 0},
{188, 1060152279u, 2147516072u, 1059830828u, 0, ERFF_TOLERANCE, 0},
{189, 1060320051u, 2147516072u, 1059947617u, 0, ERFF_TOLERANCE, 0},
{190, 1060487823u, 2147516072u, 1060062782u, 0, ERFF_TOLERANCE, 0},
{191, 1060655596u, 2147516072u, 1060176323u, 0, ERFF_TOLERANCE, 0},
{192, 1060823368u, 2147516072u, 1060288241u, 0, ERFF_TOLERANCE, 0},
{193, 1060991140u, 2147516072u, 1060398536u, 0, ERFF_TOLERANCE, 0},
{194, 1061158912u, 2147516072u, 1060507212u, 0, ERFF_TOLERANCE, 0},
{195, 1061326684u, 2147516072u, 1060614270u, 0, ERFF_TOLERANCE, 0},
{196, 1061494456u, 2147516072u, 1060719712u, 0, ERFF_TOLERANCE, 0},
{197, 1061662228u, 2147516072u, 1060823542u, 0, ERFF_TOLERANCE, 0},
{198, 1061830001u, 2147516072u, 1060925767u, 0, ERFF_TOLERANCE, 0},
{199, 1061997773u, 2147516072u, 1061026388u, 0, ERFF_TOLERANCE, 0},
{200, 1062165545u, 2147516072u, 1061125412u, 0, ERFF_TOLERANCE, 0},
{201, 1062333317u, 2147516072u, 1061222845u, 0, ERFF_TOLERANCE, 0},
{202, 1062501089u, 2147516072u, 1061318694u, 0, ERFF_TOLERANCE, 0},
{203, 1062668861u, 2147516072u, 1061412964u, 0, ERFF_TOLERANCE, 0},
{204, 1062836634u, 2147516072u, 1061505664u, 0, ERFF_TOLERANCE, 0},
{205, 1063004406u, 2147516072u, 1061596802u, 0, ERFF_TOLERANCE, 0},
{206, 1063172178u, 2147516072u, 1061686385u, 0, ERFF_TOLERANCE, 0},
{207, 1063339950u, 2147516072u, 1061774423u, 0, ERFF_TOLERANCE, 0},
{208, 1063507722u, 2147516072u, 1061860925u, 0, ERFF_TOLERANCE, 0},
{209, 1063675494u, 2147516072u, 1061945900u, 0, ERFF_TOLERANCE, 0},
{210, 1063843267u, 2147516072u, 1062029361u, 0, ERFF_TOLERANCE, 0},
{211, 1064011039u, 2147516072u, 1062111316u, 0, ERFF_TOLERANCE, 0},
{212, 1064178811u, 2147516072u, 1062191777u, 0, ERFF_TOLERANCE, 0},
{213, 1064514355u, 2147516072u, 1062348262u, 0, ERFF_TOLERANCE, 0},
{214, 1064682127u, 2147516072u, 1062424311u, 0, ERFF_TOLERANCE, 0},
{215, 1064849900u, 2147516072u, 1062498913u, 0, ERFF_TOLERANCE, 0},
{216, 1065017672u, 2147516072u, 1062572082u, 0, ERFF_TOLERANCE, 0},
{217, 1065185444u, 2147516072u, 1062643831u, 0, ERFF_TOLERANCE, 0},
{218, 1065353216u, 2147516072u, 1062714173u, 0, ERFF_TOLERANCE, 0},
{219, 1065437102u, 2147516072u, 1062783122u, 0, ERFF_TOLERANCE, 0},
{220, 1065520988u, 2147516072u, 1062850693u, 0, ERFF_TOLERANCE, 0},
{221, 1065604874u, 2147516072u, 1062916899u, 0, ERFF_TOLERANCE, 0},
{222, 1065688760u, 2147516072u, 1062981755u, 0, ERFF_TOLERANCE, 0},
{223, 1065772646u, 2147516072u, 1063045276u, 0, ERFF_TOLERANCE, 0},
{224, 1065856532u, 2147516072u, 1063107478u, 0, ERFF_TOLERANCE, 0},
{225, 1065940419u, 2147516072u, 1063168375u, 0, ERFF_TOLERANCE, 0},
{226, 1066024305u, 2147516072u, 1063227982u, 0, ERFF_TOLERANCE, 0},
{227, 1066108191u, 2147516072u, 1063286315u, 0, ERFF_TOLERANCE, 0},
{228, 1066192077u, 2147516072u, 1063343391u, 0, ERFF_TOLERANCE, 0},
{229, 1066275963u, 2147516072u, 1063399224u, 0, ERFF_TOLERANCE, 0},
{230, 1066359849u, 2147516072u, 1063453832u, 0, ERFF_TOLERANCE, 0},
{231, 1066443735u, 2147516072u, 1063507230u, 0, ERFF_TOLERANCE, 0},
{232, 1066527621u, 2147516072u, 1063559435u, 0, ERFF_TOLERANCE, 0},
{233, 1066611507u, 2147516072u, 1063610463u, 0, ERFF_TOLERANCE, 0},
{234, 1066695393u, 2147516072u, 1063660331u, 0, ERFF_TOLERANCE, 0},
{235, 1066779279u, 2147516072u, 1063709055u, 0, ERFF_TOLERANCE, 0},
{236, 1066863165u, 2147516072u, 1063756653u, 0, ERFF_TOLERANCE, 0},
{237, 1066947052u, 2147516072u, 1063803140u, 0, ERFF_TOLERANCE, 0},
{238, 3234402267u, 2147516072u, 3212836864u, 0, ERFF_TOLERANCE, 0},
{239, 3231108068u, 2147516072u, 3212836864u, 0, ERFF_TOLERANCE, 0},
{240, 3226013659u, 2147516072u, 3212836715u, 0, ERFF_TOLERANCE, 0},
{241, 3217625051u, 2147516072u, 3212395270u, 0, ERFF_TOLERANCE, 0},
{242, 0u, 2147516072u, 0u, 0, ERFF_TOLERANCE, 0},
{243, 1070141403u, 2147516072u, 1064911622u, 0, ERFF_TOLERANCE, 0},
{244, 1078530011u, 2147516072u, 1065353067u, 0, ERFF_TOLERANCE, 0},
{245, 1083624420u, 2147516072u, 1065353216u, 0, ERFF_TOLERANCE, 0},
{246, 3253731328u, 2147516072u, 3212836864u, 0, ERFF_TOLERANCE, 0},
{247, 3252840038u, 2147516072u, 3212836864u, 0, ERFF_TOLERANCE, 0},
{248, 3251948749u, 2147516072u, 3212836864u, 0, ERFF_TOLERANCE, 0},
{249, 3251057459u, 2147516072u, 3212836864u, 0, ERFF_TOLERANCE, 0},
{250, 3250166170u, 2147516072u, 3212836864u, 0, ERFF_TOLERANCE, 0},
{251, 3249274880u, 2147516072u, 3212836864u, 0, ERFF_TOLERANCE, 0},
{252, 3248383590u, 2147516072u, 3212836864u, 0, ERFF_TOLERANCE, 0},
{253, 3247492301u, 2147516072u, 3212836864u, 0, ERFF_TOLERANCE, 0},
{254, 3246601011u, 2147516072u, 3212836864u, 0, ERFF_TOLERANCE, 0},
{255, 3245028147u, 2147516072u, 3212836864u, 0, ERFF_TOLERANCE, 0},
{256, 3243245568u, 2147516072u, 3212836864u, 0, ERFF_TOLERANCE, 0},
{257, 3241462989u, 2147516072u, 3212836864u, 0, ERFF_TOLERANCE, 0},
{258, 3239680410u, 2147516072u, 3212836864u, 0, ERFF_TOLERANCE, 0},
{259, 3237792973u, 2147516072u, 3212836864u, 0, ERFF_TOLERANCE, 0},
{260, 3234227814u, 2147516072u, 3212836864u, 0, ERFF_TOLERANCE, 0},
{261, 3230662656u, 2147516072u, 3212836864u, 0, ERFF_TOLERANCE, 0},
{262, 3224580915u, 2147516072u, 3212835605u, 0, ERFF_TOLERANCE, 0},
{263, 3213675725u, 2147516072u, 3210827039u, 0, ERFF_TOLERANCE, 0},
{264, 1058642330u, 2147516072u, 1058707024u, 0, ERFF_TOLERANCE, 0},
{265, 1075000115u, 2147516072u, 1065334037u, 0, ERFF_TOLERANCE, 0},
{266, 1082130432u, 2147516072u, 1065353216u, 0, ERFF_TOLERANCE, 0},
{267, 1085695590u, 2147516072u, 1065353216u, 0, ERFF_TOLERANCE, 0},
{268, 1089260749u, 2147516072u, 1065353216u, 0, ERFF_TOLERANCE, 0},
{269, 1091672474u, 2147516072u, 1065353216u, 0, ERFF_TOLERANCE, 0},
{270, 1093455053u, 2147516072u, 1065353216u, 0, ERFF_TOLERANCE, 0},
{271, 1095237632u, 2147516072u, 1065353216u, 0, ERFF_TOLERANCE, 0},
{272, 1097020211u, 2147516072u, 1065353216u, 0, ERFF_TOLERANCE, 0},
{273, 1098802790u, 2147516072u, 1065353216u, 0, ERFF_TOLERANCE, 0},
{274, 1099746509u, 2147516072u, 1065353216u, 0, ERFF_TOLERANCE, 0},
{275, 1100637798u, 2147516072u, 1065353216u, 0, ERFF_TOLERANCE, 0},
{276, 1101529088u, 2147516072u, 1065353216u, 0, ERFF_TOLERANCE, 0},
{277, 1102420378u, 2147516072u, 1065353216u, 0, ERFF_TOLERANCE, 0},
{278, 1103311667u, 2147516072u, 1065353216u, 0, ERFF_TOLERANCE, 0},
{279, 1104202957u, 2147516072u, 1065353216u, 0, ERFF_TOLERANCE, 0},
{280, 1105094246u, 2147516072u, 1065353216u, 0, ERFF_TOLERANCE, 0},
{281, 1105985536u, 2147516072u, 1065353216u, 0, ERFF_TOLERANCE, 0}

// AUTOMATICALLY GENERATED VECTORS STOP

};

#endif // CYGONCE_LIBM_ERFF_H multiple inclusion protection

// EOF erff.h
