#ifndef CYGONCE_LIBM_COSH_H
#define CYGONCE_LIBM_COSH_H
//===========================================================================
//
//      coshf.h
//
//      Test vectors for testing of coshf() math library function
//
//===========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 2012 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later
// version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License
// along with eCos; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
// As a special exception, if other files instantiate templates or use
// macros or inline functions from this file, or you compile this file
// and link it with other works to produce a work based on this file,
// this file does not by itself cause the resulting work to be covered by
// the GNU General Public License. However the source code for this file
// must still be made available in accordance with section (3) of the GNU
// General Public License v2.
//
// This exception does not invalidate any other reasons why a work based
// on this file might be covered by the GNU General Public License.
// -------------------------------------------
// ####ECOSGPLCOPYRIGHTEND####
//===========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):
// Contributors:  visar, ilijak
// Date:        1998-02-13
// Purpose:
// Description:
// Usage:       #include "vectors/coshf.h"
//
//####DESCRIPTIONEND####
//
//===========================================================================


// CONFIGURATION

#include <pkgconf/libm.h>   // Configuration header


// INCLUDES

#include <cyg/infra/cyg_type.h>    // Common type definitions and support
#include "vectors/vector_support_float.h"// extra support for math tests

#define COSH_TOLERANCE 1.0E-04

static const Cyg_libm_test_float_vec_t coshf_vec[] = {

// AUTOMATICALLY GENERATED VECTORS START

{0, 3214514586u, 1072153489u, 1072153489u, 0, COSH_TOLERANCE, 0},
{1, 3214430700u, 1072027623u, 1072027623u, 0, COSH_TOLERANCE, 0},
{2, 3214346813u, 1071903263u, 1071903263u, 0, COSH_TOLERANCE, 0},
{3, 3214262927u, 1071780397u, 1071780397u, 0, COSH_TOLERANCE, 0},
{4, 3214179041u, 1071659013u, 1071659013u, 0, COSH_TOLERANCE, 0},
{5, 3214095155u, 1071539100u, 1071539100u, 0, COSH_TOLERANCE, 0},
{6, 3214011269u, 1071420643u, 1071420643u, 0, COSH_TOLERANCE, 0},
{7, 3213927383u, 1071303632u, 1071303632u, 0, COSH_TOLERANCE, 0},
{8, 3213843497u, 1071188056u, 1071188056u, 0, COSH_TOLERANCE, 0},
{9, 3213759611u, 1071073900u, 1071073900u, 0, COSH_TOLERANCE, 0},
{10, 3213675725u, 1070961157u, 1070961157u, 0, COSH_TOLERANCE, 0},
{11, 3213591839u, 1070849813u, 1070849813u, 0, COSH_TOLERANCE, 0},
{12, 3213507953u, 1070739857u, 1070739857u, 0, COSH_TOLERANCE, 0},
{13, 3213424067u, 1070631278u, 1070631278u, 0, COSH_TOLERANCE, 0},
{14, 3213340180u, 1070524066u, 1070524066u, 0, COSH_TOLERANCE, 0},
{15, 3213256294u, 1070418210u, 1070418210u, 0, COSH_TOLERANCE, 0},
{16, 3213172408u, 1070313701u, 1070313701u, 0, COSH_TOLERANCE, 0},
{17, 3213088522u, 1070210525u, 1070210525u, 0, COSH_TOLERANCE, 0},
{18, 3213004636u, 1070108675u, 1070108675u, 0, COSH_TOLERANCE, 0},
{19, 3212920750u, 1070008138u, 1070008138u, 0, COSH_TOLERANCE, 0},
{20, 3212836864u, 1069908906u, 1069908906u, 0, COSH_TOLERANCE, 0},
{21, 3212669092u, 1069810970u, 1069810970u, 0, COSH_TOLERANCE, 0},
{22, 3212501320u, 1069714317u, 1069714317u, 0, COSH_TOLERANCE, 0},
{23, 3212333548u, 1069618939u, 1069618939u, 0, COSH_TOLERANCE, 0},
{24, 3212165775u, 1069524826u, 1069524826u, 0, COSH_TOLERANCE, 0},
{25, 3211998003u, 1069431969u, 1069431969u, 0, COSH_TOLERANCE, 0},
{26, 3211830231u, 1069340360u, 1069340360u, 0, COSH_TOLERANCE, 0},
{27, 3211662459u, 1069249988u, 1069249988u, 0, COSH_TOLERANCE, 0},
{28, 3211494687u, 1069160844u, 1069160844u, 0, COSH_TOLERANCE, 0},
{29, 3211326915u, 1069072921u, 1069072921u, 0, COSH_TOLERANCE, 0},
{30, 3211159142u, 1068986208u, 1068986208u, 0, COSH_TOLERANCE, 0},
{31, 3210991370u, 1068900697u, 1068900697u, 0, COSH_TOLERANCE, 0},
{32, 3210823598u, 1068816380u, 1068816380u, 0, COSH_TOLERANCE, 0},
{33, 3210655826u, 1068733248u, 1068733248u, 0, COSH_TOLERANCE, 0},
{34, 3210488054u, 1068651292u, 1068651292u, 0, COSH_TOLERANCE, 0},
{35, 3210320282u, 1068570506u, 1068570506u, 0, COSH_TOLERANCE, 0},
{36, 3210152509u, 1068490879u, 1068490879u, 0, COSH_TOLERANCE, 0},
{37, 3209984737u, 1068412406u, 1068412406u, 0, COSH_TOLERANCE, 0},
{38, 3209816965u, 1068335079u, 1068335079u, 0, COSH_TOLERANCE, 0},
{39, 3209649193u, 1068258888u, 1068258888u, 0, COSH_TOLERANCE, 0},
{40, 3209481421u, 1068183826u, 1068183826u, 0, COSH_TOLERANCE, 0},
{41, 3209313649u, 1068109886u, 1068109886u, 0, COSH_TOLERANCE, 0},
{42, 3209145876u, 1068037060u, 1068037060u, 0, COSH_TOLERANCE, 0},
{43, 3208978104u, 1067965341u, 1067965341u, 0, COSH_TOLERANCE, 0},
{44, 3208810332u, 1067894723u, 1067894723u, 0, COSH_TOLERANCE, 0},
{45, 3208642560u, 1067825198u, 1067825198u, 0, COSH_TOLERANCE, 0},
{46, 3208474788u, 1067756759u, 1067756759u, 0, COSH_TOLERANCE, 0},
{47, 3208307016u, 1067689400u, 1067689400u, 0, COSH_TOLERANCE, 0},
{48, 3208139244u, 1067623113u, 1067623113u, 0, COSH_TOLERANCE, 0},
{49, 3207971471u, 1067557890u, 1067557890u, 0, COSH_TOLERANCE, 0},
{50, 3207803699u, 1067493729u, 1067493729u, 0, COSH_TOLERANCE, 0},
{51, 3207635927u, 1067430620u, 1067430620u, 0, COSH_TOLERANCE, 0},
{52, 3207468155u, 1067368557u, 1067368557u, 0, COSH_TOLERANCE, 0},
{53, 3207300383u, 1067307535u, 1067307535u, 0, COSH_TOLERANCE, 0},
{54, 3207132611u, 1067247547u, 1067247547u, 0, COSH_TOLERANCE, 0},
{55, 3206964838u, 1067188587u, 1067188587u, 0, COSH_TOLERANCE, 0},
{56, 3206797066u, 1067130650u, 1067130650u, 0, COSH_TOLERANCE, 0},
{57, 3206629294u, 1067073729u, 1067073729u, 0, COSH_TOLERANCE, 0},
{58, 3206461522u, 1067017820u, 1067017820u, 0, COSH_TOLERANCE, 0},
{59, 3206293750u, 1066962916u, 1066962916u, 0, COSH_TOLERANCE, 0},
{60, 3206125978u, 1066909011u, 1066909011u, 0, COSH_TOLERANCE, 0},
{61, 3205958205u, 1066856101u, 1066856101u, 0, COSH_TOLERANCE, 0},
{62, 3205790433u, 1066804180u, 1066804180u, 0, COSH_TOLERANCE, 0},
{63, 3205622661u, 1066753243u, 1066753243u, 0, COSH_TOLERANCE, 0},
{64, 3205454889u, 1066703285u, 1066703285u, 0, COSH_TOLERANCE, 0},
{65, 3205287117u, 1066654301u, 1066654301u, 0, COSH_TOLERANCE, 0},
{66, 3205119345u, 1066606286u, 1066606286u, 0, COSH_TOLERANCE, 0},
{67, 3204951572u, 1066559235u, 1066559235u, 0, COSH_TOLERANCE, 0},
{68, 3204783800u, 1066513143u, 1066513143u, 0, COSH_TOLERANCE, 0},
{69, 3204616028u, 1066468007u, 1066468007u, 0, COSH_TOLERANCE, 0},
{70, 3204448256u, 1066423820u, 1066423820u, 0, COSH_TOLERANCE, 0},
{71, 3204112712u, 1066380580u, 1066380580u, 0, COSH_TOLERANCE, 0},
{72, 3203777167u, 1066338281u, 1066338281u, 0, COSH_TOLERANCE, 0},
{73, 3203441623u, 1066296920u, 1066296920u, 0, COSH_TOLERANCE, 0},
{74, 3203106079u, 1066256491u, 1066256491u, 0, COSH_TOLERANCE, 0},
{75, 3202770534u, 1066216992u, 1066216992u, 0, COSH_TOLERANCE, 0},
{76, 3202434990u, 1066178419u, 1066178419u, 0, COSH_TOLERANCE, 0},
{77, 3202099446u, 1066140766u, 1066140766u, 0, COSH_TOLERANCE, 0},
{78, 3201763901u, 1066104032u, 1066104032u, 0, COSH_TOLERANCE, 0},
{79, 3201428357u, 1066068211u, 1066068211u, 0, COSH_TOLERANCE, 0},
{80, 3201092813u, 1066033300u, 1066033300u, 0, COSH_TOLERANCE, 0},
{81, 3200757268u, 1065999297u, 1065999297u, 0, COSH_TOLERANCE, 0},
{82, 3200421724u, 1065966197u, 1065966197u, 0, COSH_TOLERANCE, 0},
{83, 3200086180u, 1065933997u, 1065933997u, 0, COSH_TOLERANCE, 0},
{84, 3199750636u, 1065902694u, 1065902694u, 0, COSH_TOLERANCE, 0},
{85, 3199415091u, 1065872285u, 1065872285u, 0, COSH_TOLERANCE, 0},
{86, 3199079547u, 1065842767u, 1065842767u, 0, COSH_TOLERANCE, 0},
{87, 3198744003u, 1065814136u, 1065814136u, 0, COSH_TOLERANCE, 0},
{88, 3198408458u, 1065786390u, 1065786390u, 0, COSH_TOLERANCE, 0},
{89, 3198072914u, 1065759527u, 1065759527u, 0, COSH_TOLERANCE, 0},
{90, 3197737370u, 1065733543u, 1065733543u, 0, COSH_TOLERANCE, 0},
{91, 3197401825u, 1065708436u, 1065708436u, 0, COSH_TOLERANCE, 0},
{92, 3197066281u, 1065684204u, 1065684204u, 0, COSH_TOLERANCE, 0},
{93, 3196730737u, 1065660843u, 1065660843u, 0, COSH_TOLERANCE, 0},
{94, 3196395192u, 1065638352u, 1065638352u, 0, COSH_TOLERANCE, 0},
{95, 3196059648u, 1065616728u, 1065616728u, 0, COSH_TOLERANCE, 0},
{96, 3195388559u, 1065595970u, 1065595970u, 0, COSH_TOLERANCE, 0},
{97, 3194717471u, 1065576075u, 1065576075u, 0, COSH_TOLERANCE, 0},
{98, 3194046382u, 1065557040u, 1065557040u, 0, COSH_TOLERANCE, 0},
{99, 3193375293u, 1065538865u, 1065538865u, 0, COSH_TOLERANCE, 0},
{100, 3192704205u, 1065521548u, 1065521548u, 0, COSH_TOLERANCE, 0},
{101, 3192033116u, 1065505086u, 1065505086u, 0, COSH_TOLERANCE, 0},
{102, 3191362028u, 1065489479u, 1065489479u, 0, COSH_TOLERANCE, 0},
{103, 3190690939u, 1065474723u, 1065474723u, 0, COSH_TOLERANCE, 0},
{104, 3190019850u, 1065460819u, 1065460819u, 0, COSH_TOLERANCE, 0},
{105, 3189348762u, 1065447765u, 1065447765u, 0, COSH_TOLERANCE, 0},
{106, 3188677673u, 1065435559u, 1065435559u, 0, COSH_TOLERANCE, 0},
{107, 3188006584u, 1065424200u, 1065424200u, 0, COSH_TOLERANCE, 0},
{108, 3186999951u, 1065413686u, 1065413686u, 0, COSH_TOLERANCE, 0},
{109, 3185657774u, 1065404018u, 1065404018u, 0, COSH_TOLERANCE, 0},
{110, 3184315597u, 1065395194u, 1065395194u, 0, COSH_TOLERANCE, 0},
{111, 3182973420u, 1065387213u, 1065387213u, 0, COSH_TOLERANCE, 0},
{112, 3181631242u, 1065380074u, 1065380074u, 0, COSH_TOLERANCE, 0},
{113, 3180289065u, 1065373776u, 1065373776u, 0, COSH_TOLERANCE, 0},
{114, 3178611343u, 1065368320u, 1065368320u, 0, COSH_TOLERANCE, 0},
{115, 3175926989u, 1065363704u, 1065363704u, 0, COSH_TOLERANCE, 0},
{116, 3173242634u, 1065359928u, 1065359928u, 0, COSH_TOLERANCE, 0},
{117, 3170222735u, 1065356991u, 1065356991u, 0, COSH_TOLERANCE, 0},
{118, 3164854026u, 1065354894u, 1065354894u, 0, COSH_TOLERANCE, 0},
{119, 3156465418u, 1065353635u, 1065353635u, 0, COSH_TOLERANCE, 0},
{120, 1008981770u, 1065353635u, 1065353635u, 0, COSH_TOLERANCE, 0},
{121, 1017370378u, 1065354894u, 1065354894u, 0, COSH_TOLERANCE, 0},
{122, 1022739087u, 1065356991u, 1065356991u, 0, COSH_TOLERANCE, 0},
{123, 1025758986u, 1065359928u, 1065359928u, 0, COSH_TOLERANCE, 0},
{124, 1028443341u, 1065363704u, 1065363704u, 0, COSH_TOLERANCE, 0},
{125, 1031127695u, 1065368320u, 1065368320u, 0, COSH_TOLERANCE, 0},
{126, 1032805417u, 1065373776u, 1065373776u, 0, COSH_TOLERANCE, 0},
{127, 1034147594u, 1065380074u, 1065380074u, 0, COSH_TOLERANCE, 0},
{128, 1035489772u, 1065387213u, 1065387213u, 0, COSH_TOLERANCE, 0},
{129, 1036831949u, 1065395194u, 1065395194u, 0, COSH_TOLERANCE, 0},
{130, 1038174126u, 1065404018u, 1065404018u, 0, COSH_TOLERANCE, 0},
{131, 1039516303u, 1065413686u, 1065413686u, 0, COSH_TOLERANCE, 0},
{132, 1040522936u, 1065424200u, 1065424200u, 0, COSH_TOLERANCE, 0},
{133, 1041194025u, 1065435559u, 1065435559u, 0, COSH_TOLERANCE, 0},
{134, 1041865114u, 1065447765u, 1065447765u, 0, COSH_TOLERANCE, 0},
{135, 1042536202u, 1065460819u, 1065460819u, 0, COSH_TOLERANCE, 0},
{136, 1043207291u, 1065474723u, 1065474723u, 0, COSH_TOLERANCE, 0},
{137, 1043878380u, 1065489479u, 1065489479u, 0, COSH_TOLERANCE, 0},
{138, 1044549468u, 1065505086u, 1065505086u, 0, COSH_TOLERANCE, 0},
{139, 1045220557u, 1065521548u, 1065521548u, 0, COSH_TOLERANCE, 0},
{140, 1045891645u, 1065538865u, 1065538865u, 0, COSH_TOLERANCE, 0},
{141, 1046562734u, 1065557040u, 1065557040u, 0, COSH_TOLERANCE, 0},
{142, 1047233823u, 1065576075u, 1065576075u, 0, COSH_TOLERANCE, 0},
{143, 1047904911u, 1065595970u, 1065595970u, 0, COSH_TOLERANCE, 0},
{144, 1048576000u, 1065616728u, 1065616728u, 0, COSH_TOLERANCE, 0},
{145, 1048911544u, 1065638352u, 1065638352u, 0, COSH_TOLERANCE, 0},
{146, 1049247089u, 1065660843u, 1065660843u, 0, COSH_TOLERANCE, 0},
{147, 1049582633u, 1065684204u, 1065684204u, 0, COSH_TOLERANCE, 0},
{148, 1049918177u, 1065708436u, 1065708436u, 0, COSH_TOLERANCE, 0},
{149, 1050253722u, 1065733543u, 1065733543u, 0, COSH_TOLERANCE, 0},
{150, 1050589266u, 1065759527u, 1065759527u, 0, COSH_TOLERANCE, 0},
{151, 1050924810u, 1065786390u, 1065786390u, 0, COSH_TOLERANCE, 0},
{152, 1051260355u, 1065814136u, 1065814136u, 0, COSH_TOLERANCE, 0},
{153, 1051595899u, 1065842767u, 1065842767u, 0, COSH_TOLERANCE, 0},
{154, 1051931443u, 1065872285u, 1065872285u, 0, COSH_TOLERANCE, 0},
{155, 1052266988u, 1065902694u, 1065902694u, 0, COSH_TOLERANCE, 0},
{156, 1052602532u, 1065933997u, 1065933997u, 0, COSH_TOLERANCE, 0},
{157, 1052938076u, 1065966197u, 1065966197u, 0, COSH_TOLERANCE, 0},
{158, 1053273620u, 1065999297u, 1065999297u, 0, COSH_TOLERANCE, 0},
{159, 1053609165u, 1066033300u, 1066033300u, 0, COSH_TOLERANCE, 0},
{160, 1053944709u, 1066068211u, 1066068211u, 0, COSH_TOLERANCE, 0},
{161, 1054280253u, 1066104032u, 1066104032u, 0, COSH_TOLERANCE, 0},
{162, 1054615798u, 1066140766u, 1066140766u, 0, COSH_TOLERANCE, 0},
{163, 1054951342u, 1066178419u, 1066178419u, 0, COSH_TOLERANCE, 0},
{164, 1055286886u, 1066216992u, 1066216992u, 0, COSH_TOLERANCE, 0},
{165, 1055622431u, 1066256491u, 1066256491u, 0, COSH_TOLERANCE, 0},
{166, 1055957975u, 1066296920u, 1066296920u, 0, COSH_TOLERANCE, 0},
{167, 1056293519u, 1066338281u, 1066338281u, 0, COSH_TOLERANCE, 0},
{168, 1056629064u, 1066380580u, 1066380580u, 0, COSH_TOLERANCE, 0},
{169, 1056964608u, 1066423820u, 1066423820u, 0, COSH_TOLERANCE, 0},
{170, 1057132380u, 1066468007u, 1066468007u, 0, COSH_TOLERANCE, 0},
{171, 1057300152u, 1066513143u, 1066513143u, 0, COSH_TOLERANCE, 0},
{172, 1057467924u, 1066559235u, 1066559235u, 0, COSH_TOLERANCE, 0},
{173, 1057635697u, 1066606286u, 1066606286u, 0, COSH_TOLERANCE, 0},
{174, 1057803469u, 1066654301u, 1066654301u, 0, COSH_TOLERANCE, 0},
{175, 1057971241u, 1066703285u, 1066703285u, 0, COSH_TOLERANCE, 0},
{176, 1058139013u, 1066753243u, 1066753243u, 0, COSH_TOLERANCE, 0},
{177, 1058306785u, 1066804180u, 1066804180u, 0, COSH_TOLERANCE, 0},
{178, 1058474557u, 1066856101u, 1066856101u, 0, COSH_TOLERANCE, 0},
{179, 1058642330u, 1066909011u, 1066909011u, 0, COSH_TOLERANCE, 0},
{180, 1058810102u, 1066962916u, 1066962916u, 0, COSH_TOLERANCE, 0},
{181, 1058977874u, 1067017820u, 1067017820u, 0, COSH_TOLERANCE, 0},
{182, 1059145646u, 1067073729u, 1067073729u, 0, COSH_TOLERANCE, 0},
{183, 1059313418u, 1067130650u, 1067130650u, 0, COSH_TOLERANCE, 0},
{184, 1059481190u, 1067188587u, 1067188587u, 0, COSH_TOLERANCE, 0},
{185, 1059648963u, 1067247547u, 1067247547u, 0, COSH_TOLERANCE, 0},
{186, 1059816735u, 1067307535u, 1067307535u, 0, COSH_TOLERANCE, 0},
{187, 1059984507u, 1067368557u, 1067368557u, 0, COSH_TOLERANCE, 0},
{188, 1060152279u, 1067430620u, 1067430620u, 0, COSH_TOLERANCE, 0},
{189, 1060320051u, 1067493729u, 1067493729u, 0, COSH_TOLERANCE, 0},
{190, 1060487823u, 1067557890u, 1067557890u, 0, COSH_TOLERANCE, 0},
{191, 1060655596u, 1067623113u, 1067623113u, 0, COSH_TOLERANCE, 0},
{192, 1060823368u, 1067689400u, 1067689400u, 0, COSH_TOLERANCE, 0},
{193, 1060991140u, 1067756759u, 1067756759u, 0, COSH_TOLERANCE, 0},
{194, 1061158912u, 1067825198u, 1067825198u, 0, COSH_TOLERANCE, 0},
{195, 1061326684u, 1067894723u, 1067894723u, 0, COSH_TOLERANCE, 0},
{196, 1061494456u, 1067965341u, 1067965341u, 0, COSH_TOLERANCE, 0},
{197, 1061662228u, 1068037060u, 1068037060u, 0, COSH_TOLERANCE, 0},
{198, 1061830001u, 1068109886u, 1068109886u, 0, COSH_TOLERANCE, 0},
{199, 1061997773u, 1068183826u, 1068183826u, 0, COSH_TOLERANCE, 0},
{200, 1062165545u, 1068258888u, 1068258888u, 0, COSH_TOLERANCE, 0},
{201, 1062333317u, 1068335079u, 1068335079u, 0, COSH_TOLERANCE, 0},
{202, 1062501089u, 1068412406u, 1068412406u, 0, COSH_TOLERANCE, 0},
{203, 1062668861u, 1068490879u, 1068490879u, 0, COSH_TOLERANCE, 0},
{204, 1062836634u, 1068570506u, 1068570506u, 0, COSH_TOLERANCE, 0},
{205, 1063004406u, 1068651292u, 1068651292u, 0, COSH_TOLERANCE, 0},
{206, 1063172178u, 1068733248u, 1068733248u, 0, COSH_TOLERANCE, 0},
{207, 1063339950u, 1068816380u, 1068816380u, 0, COSH_TOLERANCE, 0},
{208, 1063507722u, 1068900697u, 1068900697u, 0, COSH_TOLERANCE, 0},
{209, 1063675494u, 1068986208u, 1068986208u, 0, COSH_TOLERANCE, 0},
{210, 1063843267u, 1069072921u, 1069072921u, 0, COSH_TOLERANCE, 0},
{211, 1064011039u, 1069160844u, 1069160844u, 0, COSH_TOLERANCE, 0},
{212, 1064178811u, 1069249988u, 1069249988u, 0, COSH_TOLERANCE, 0},
{213, 1064346583u, 1069340360u, 1069340360u, 0, COSH_TOLERANCE, 0},
{214, 1064514355u, 1069431969u, 1069431969u, 0, COSH_TOLERANCE, 0},
{215, 1064682127u, 1069524826u, 1069524826u, 0, COSH_TOLERANCE, 0},
{216, 1064849900u, 1069618939u, 1069618939u, 0, COSH_TOLERANCE, 0},
{217, 1065017672u, 1069714317u, 1069714317u, 0, COSH_TOLERANCE, 0},
{218, 1065185444u, 1069810970u, 1069810970u, 0, COSH_TOLERANCE, 0},
{219, 1065353216u, 1069908906u, 1069908906u, 0, COSH_TOLERANCE, 0},
{220, 1065437102u, 1070008138u, 1070008138u, 0, COSH_TOLERANCE, 0},
{221, 1065520988u, 1070108675u, 1070108675u, 0, COSH_TOLERANCE, 0},
{222, 1065604874u, 1070210525u, 1070210525u, 0, COSH_TOLERANCE, 0},
{223, 1065688760u, 1070313701u, 1070313701u, 0, COSH_TOLERANCE, 0},
{224, 1065772646u, 1070418210u, 1070418210u, 0, COSH_TOLERANCE, 0},
{225, 1065856532u, 1070524066u, 1070524066u, 0, COSH_TOLERANCE, 0},
{226, 1065940419u, 1070631278u, 1070631278u, 0, COSH_TOLERANCE, 0},
{227, 1066024305u, 1070739857u, 1070739857u, 0, COSH_TOLERANCE, 0},
{228, 1066108191u, 1070849813u, 1070849813u, 0, COSH_TOLERANCE, 0},
{229, 1066192077u, 1070961157u, 1070961157u, 0, COSH_TOLERANCE, 0},
{230, 1066275963u, 1071073900u, 1071073900u, 0, COSH_TOLERANCE, 0},
{231, 1066359849u, 1071188056u, 1071188056u, 0, COSH_TOLERANCE, 0},
{232, 1066443735u, 1071303632u, 1071303632u, 0, COSH_TOLERANCE, 0},
{233, 1066527621u, 1071420643u, 1071420643u, 0, COSH_TOLERANCE, 0},
{234, 1066611507u, 1071539100u, 1071539100u, 0, COSH_TOLERANCE, 0},
{235, 1066695393u, 1071659013u, 1071659013u, 0, COSH_TOLERANCE, 0},
{236, 1066779279u, 1071780397u, 1071780397u, 0, COSH_TOLERANCE, 0},
{237, 1066863165u, 1071903263u, 1071903263u, 0, COSH_TOLERANCE, 0},
{238, 1066947052u, 1072027623u, 1072027623u, 0, COSH_TOLERANCE, 0},
{239, 3234402267u, 1132846996u, 1132846996u, 0, COSH_TOLERANCE, 0},
{240, 3231108068u, 1113499468u, 1113499468u, 0, COSH_TOLERANCE, 0},
{241, 3226013659u, 1094285476u, 1094285476u, 0, COSH_TOLERANCE, 0},
{242, 3217625051u, 1075877474u, 1075877474u, 0, COSH_TOLERANCE, 0},
{243, 0u, 1065353216u, 1065353216u, 0, COSH_TOLERANCE, 0},
{244, 1070141403u, 1075877474u, 1075877474u, 0, COSH_TOLERANCE, 0},
{245, 1078530011u, 1094285476u, 1094285476u, 0, COSH_TOLERANCE, 0},
{246, 1083624420u, 1113499468u, 1113499468u, 0, COSH_TOLERANCE, 0},
{247, 3253731328u, 1419477554u, 1419477554u, 0, COSH_TOLERANCE, 0},
{248, 3252840038u, 1399014724u, 1399014724u, 0, COSH_TOLERANCE, 0},
{249, 3251948749u, 1378226969u, 1378226969u, 0, COSH_TOLERANCE, 0},
{250, 3251057459u, 1358083682u, 1358083682u, 0, COSH_TOLERANCE, 0},
{251, 3250166170u, 1337023431u, 1337023431u, 0, COSH_TOLERANCE, 0},
{252, 3249274880u, 1317116439u, 1317116439u, 0, COSH_TOLERANCE, 0},
{253, 3248383590u, 1295870124u, 1295870124u, 0, COSH_TOLERANCE, 0},
{254, 3247492301u, 1275750495u, 1275750495u, 0, COSH_TOLERANCE, 0},
{255, 3246601011u, 1254770489u, 1254770489u, 0, COSH_TOLERANCE, 0},
{256, 3245028147u, 1234423762u, 1234423762u, 0, COSH_TOLERANCE, 0},
{257, 3243245568u, 1213728180u, 1213728180u, 0, COSH_TOLERANCE, 0},
{258, 3241462989u, 1193138897u, 1193138897u, 0, COSH_TOLERANCE, 0},
{259, 3239680410u, 1172747042u, 1172747042u, 0, COSH_TOLERANCE, 0},
{260, 3237792973u, 1151898761u, 1151898761u, 0, COSH_TOLERANCE, 0},
{261, 3234227814u, 1131831325u, 1131831325u, 0, COSH_TOLERANCE, 0},
{262, 3230662656u, 1110707830u, 1110707830u, 0, COSH_TOLERANCE, 0},
{263, 3224580915u, 1090784045u, 1090784045u, 0, COSH_TOLERANCE, 0},
{264, 3213675725u, 1070961157u, 1070961157u, 0, COSH_TOLERANCE, 0},
{265, 1058642330u, 1066909011u, 1066909011u, 0, COSH_TOLERANCE, 0},
{266, 1075000115u, 1084305641u, 1084305641u, 0, COSH_TOLERANCE, 0},
{267, 1082130432u, 1104836417u, 1104836417u, 0, COSH_TOLERANCE, 0},
{268, 1085695590u, 1125478258u, 1125478258u, 0, COSH_TOLERANCE, 0},
{269, 1089260749u, 1145864069u, 1145864069u, 0, COSH_TOLERANCE, 0},
{270, 1091672474u, 1166798129u, 1166798129u, 0, COSH_TOLERANCE, 0},
{271, 1093455053u, 1186954451u, 1186954451u, 0, COSH_TOLERANCE, 0},
{272, 1095237632u, 1208157740u, 1208157740u, 0, COSH_TOLERANCE, 0},
{273, 1097020211u, 1228099076u, 1228099076u, 0, COSH_TOLERANCE, 0},
{274, 1098802790u, 1249206348u, 1249206348u, 0, COSH_TOLERANCE, 0},
{275, 1099746509u, 1269294498u, 1269294498u, 0, COSH_TOLERANCE, 0},
{276, 1100637798u, 1290126283u, 1290126283u, 0, COSH_TOLERANCE, 0},
{277, 1101529088u, 1310537485u, 1310537485u, 0, COSH_TOLERANCE, 0},
{278, 1102420378u, 1331111329u, 1331111329u, 0, COSH_TOLERANCE, 0},
{279, 1103311667u, 1351825023u, 1351825023u, 0, COSH_TOLERANCE, 0},
{280, 1104202957u, 1372157288u, 1372157288u, 0, COSH_TOLERANCE, 0},
{281, 1105094246u, 1393154230u, 1393154230u, 0, COSH_TOLERANCE, 0},
{282, 1105985536u, 1413260339u, 1413260339u, 0, COSH_TOLERANCE, 0},
{283, 1136446367u, 1194999402u, 2139095040u, 0, COSH_TOLERANCE, 0},
{284, 1125946360u, 3370647675u, 2139095040u, 0, COSH_TOLERANCE, 0},
{285, 3282993411u, 3033957825u, 2139095040u, 0, COSH_TOLERANCE, 0},
{286, 3287103796u, 1154138102u, 2139095040u, 0, COSH_TOLERANCE, 0},
{287, 1140187905u, 3466051188u, 2139095040u, 0, COSH_TOLERANCE, 0},
{288, 1121356447u, 3373485062u, 2139095040u, 0, COSH_TOLERANCE, 0},
{289, 1130299734u, 903489435u, 2139095040u, 0, COSH_TOLERANCE, 0},
{290, 1129518585u, 3123875978u, 2139095040u, 0, COSH_TOLERANCE, 0},
{291, 1140196815u, 1338107877u, 2139095040u, 0, COSH_TOLERANCE, 0},
{292, 1133128320u, 1019883016u, 2139095040u, 0, COSH_TOLERANCE, 0},
{293, 3276881499u, 1279248024u, 2139095040u, 0, COSH_TOLERANCE, 0},
{294, 3271367674u, 2962345057u, 2139095040u, 0, COSH_TOLERANCE, 0},
{295, 3269130828u, 3184653669u, 2139095040u, 0, COSH_TOLERANCE, 0},
{296, 3266969368u, 1321337529u, 2139095040u, 0, COSH_TOLERANCE, 0},
{297, 1130931088u, 1103202538u, 2139095040u, 0, COSH_TOLERANCE, 0},
{298, 3275237890u, 1036705270u, 2139095040u, 0, COSH_TOLERANCE, 0},
{299, 3281018046u, 976891930u, 2139095040u, 0, COSH_TOLERANCE, 0},
{300, 3281639192u, 1041678304u, 2139095040u, 0, COSH_TOLERANCE, 0},
{301, 1138869462u, 3336225884u, 2139095040u, 0, COSH_TOLERANCE, 0},
{302, 1120934307u, 851754050u, 2139095040u, 0, COSH_TOLERANCE, 0},
{303, 1126893165u, 991185677u, 2139095040u, 0, COSH_TOLERANCE, 0},
{304, 3279750470u, 1043829691u, 2139095040u, 0, COSH_TOLERANCE, 0},
{305, 1132730239u, 970681762u, 2139095040u, 0, COSH_TOLERANCE, 0},
{306, 3273484600u, 3312047722u, 2139095040u, 0, COSH_TOLERANCE, 0},
{307, 1127993937u, 2961937089u, 2139095040u, 0, COSH_TOLERANCE, 0},
{308, 1119892445u, 1156123987u, 2139095040u, 0, COSH_TOLERANCE, 0},
{309, 1138979832u, 3100744786u, 2139095040u, 0, COSH_TOLERANCE, 0},
{310, 3281219012u, 3190881451u, 2139095040u, 0, COSH_TOLERANCE, 0},
{311, 3275104955u, 1118756120u, 2139095040u, 0, COSH_TOLERANCE, 0},
{312, 1122402726u, 901308750u, 2139095040u, 0, COSH_TOLERANCE, 0},
{313, 3273836836u, 1304806106u, 2139095040u, 0, COSH_TOLERANCE, 0},
{314, 1123378518u, 3420832544u, 2139095040u, 0, COSH_TOLERANCE, 0},
{315, 3273853781u, 2973850350u, 2139095040u, 0, COSH_TOLERANCE, 0},
{316, 1121330870u, 3004311296u, 2139095040u, 0, COSH_TOLERANCE, 0},
{317, 3273000898u, 3204192793u, 2139095040u, 0, COSH_TOLERANCE, 0},
{318, 3275056068u, 3347783723u, 2139095040u, 0, COSH_TOLERANCE, 0},
{319, 3277679442u, 3106834845u, 2139095040u, 0, COSH_TOLERANCE, 0},
{320, 3284754580u, 1219372260u, 2139095040u, 0, COSH_TOLERANCE, 0},
{321, 3270337101u, 1201894512u, 2139095040u, 0, COSH_TOLERANCE, 0},
{322, 3282773495u, 1005577835u, 2139095040u, 0, COSH_TOLERANCE, 0},
{323, 1124240677u, 906796922u, 2139095040u, 0, COSH_TOLERANCE, 0},
{324, 1119740026u, 3355874874u, 2139095040u, 0, COSH_TOLERANCE, 0},
{325, 3278655299u, 868771977u, 2139095040u, 0, COSH_TOLERANCE, 0},
{326, 1128494117u, 1006049444u, 2139095040u, 0, COSH_TOLERANCE, 0},
{327, 1124138309u, 1211303367u, 2139095040u, 0, COSH_TOLERANCE, 0},
{328, 3273718623u, 991614550u, 2139095040u, 0, COSH_TOLERANCE, 0},
{329, 3276301428u, 3455289118u, 2139095040u, 0, COSH_TOLERANCE, 0},
{330, 3267728658u, 3383396815u, 2139095040u, 0, COSH_TOLERANCE, 0},
{331, 1125858271u, 873199561u, 2139095040u, 0, COSH_TOLERANCE, 0},
{332, 3286617672u, 3349284325u, 2139095040u, 0, COSH_TOLERANCE, 0},
{333, 1128542540u, 2957454177u, 2139095040u, 0, COSH_TOLERANCE, 0},
{334, 3283910310u, 980772835u, 2139095040u, 0, COSH_TOLERANCE, 0},
{335, 1127703558u, 3212305413u, 2139095040u, 0, COSH_TOLERANCE, 0},
{336, 3270154277u, 3450484255u, 2139095040u, 0, COSH_TOLERANCE, 0},
{337, 1124824106u, 3116569667u, 2139095040u, 0, COSH_TOLERANCE, 0},
{338, 3285199003u, 3412765608u, 2139095040u, 0, COSH_TOLERANCE, 0},
{339, 1138483874u, 3123051784u, 2139095040u, 0, COSH_TOLERANCE, 0},
{340, 3287796143u, 3372450889u, 2139095040u, 0, COSH_TOLERANCE, 0},
{341, 1138427315u, 856187848u, 2139095040u, 0, COSH_TOLERANCE, 0},
{342, 3266731952u, 3073750220u, 2139095040u, 0, COSH_TOLERANCE, 0},
{343, 3286935579u, 1246277393u, 2139095040u, 0, COSH_TOLERANCE, 0},
{344, 3273269173u, 3434026174u, 2139095040u, 0, COSH_TOLERANCE, 0},
{345, 1135545828u, 1254918706u, 2139095040u, 0, COSH_TOLERANCE, 0},
{346, 1135988587u, 3461361185u, 2139095040u, 0, COSH_TOLERANCE, 0},
{347, 3283879654u, 3253874001u, 2139095040u, 0, COSH_TOLERANCE, 0},
{348, 3274295536u, 1139193797u, 2139095040u, 0, COSH_TOLERANCE, 0},
{349, 1134855236u, 3334899880u, 2139095040u, 0, COSH_TOLERANCE, 0},
{350, 1121073826u, 3064047808u, 2139095040u, 0, COSH_TOLERANCE, 0},
{351, 1133146865u, 870681806u, 2139095040u, 0, COSH_TOLERANCE, 0},
{352, 1123929207u, 3104759211u, 2139095040u, 0, COSH_TOLERANCE, 0},
{353, 3286633183u, 3331372071u, 2139095040u, 0, COSH_TOLERANCE, 0},
{354, 3267729753u, 1111437780u, 2139095040u, 0, COSH_TOLERANCE, 0},
{355, 1138742759u, 1009396165u, 2139095040u, 0, COSH_TOLERANCE, 0},
{356, 1119456624u, 928393353u, 2139095040u, 0, COSH_TOLERANCE, 0},
{357, 1129220730u, 3148135875u, 2139095040u, 0, COSH_TOLERANCE, 0},
{358, 3282572423u, 3023584354u, 2139095040u, 0, COSH_TOLERANCE, 0},
{359, 3286124867u, 3444030332u, 2139095040u, 0, COSH_TOLERANCE, 0},
{360, 1123536012u, 3278686216u, 2139095040u, 0, COSH_TOLERANCE, 0},
{361, 1129936658u, 3079166173u, 2139095040u, 0, COSH_TOLERANCE, 0},
{362, 3267758292u, 3481843070u, 2139095040u, 0, COSH_TOLERANCE, 0},
{363, 1126423020u, 3487506626u, 2139095040u, 0, COSH_TOLERANCE, 0},
{364, 1136073813u, 3488844154u, 2139095040u, 0, COSH_TOLERANCE, 0},
{365, 3270332384u, 1182798837u, 2139095040u, 0, COSH_TOLERANCE, 0},
{366, 1131115907u, 3176633124u, 2139095040u, 0, COSH_TOLERANCE, 0},
{367, 3284070129u, 1331845018u, 2139095040u, 0, COSH_TOLERANCE, 0},
{368, 3278696475u, 3107114149u, 2139095040u, 0, COSH_TOLERANCE, 0},
{369, 1127951444u, 825129857u, 2139095040u, 0, COSH_TOLERANCE, 0},
{370, 1129418756u, 811863044u, 2139095040u, 0, COSH_TOLERANCE, 0},
{371, 1126654193u, 961171401u, 2139095040u, 0, COSH_TOLERANCE, 0},
{372, 3271088163u, 3066326686u, 2139095040u, 0, COSH_TOLERANCE, 0},
{373, 1130359793u, 957302464u, 2139095040u, 0, COSH_TOLERANCE, 0},
{374, 1138775588u, 2985592532u, 2139095040u, 0, COSH_TOLERANCE, 0},
{375, 3282114235u, 1284049853u, 2139095040u, 0, COSH_TOLERANCE, 0},
{376, 3267398588u, 3271879112u, 2139095040u, 0, COSH_TOLERANCE, 0},
{377, 1120256985u, 1219003129u, 2139095040u, 0, COSH_TOLERANCE, 0},
{378, 1137354019u, 1166078045u, 2139095040u, 0, COSH_TOLERANCE, 0},
{379, 3267924701u, 2953541915u, 2139095040u, 0, COSH_TOLERANCE, 0},
{380, 1139056475u, 3396371713u, 2139095040u, 0, COSH_TOLERANCE, 0},
{381, 3282508977u, 3033299853u, 2139095040u, 0, COSH_TOLERANCE, 0},
{382, 3279527710u, 3333091960u, 2139095040u, 0, COSH_TOLERANCE, 0},
{383, 3276970123u, 1174967495u, 2139095040u, 0, COSH_TOLERANCE, 0},
{384, 1131911667u, 966031619u, 2139095040u, 0, COSH_TOLERANCE, 0},
{385, 3275501055u, 3029593823u, 2139095040u, 0, COSH_TOLERANCE, 0},
{386, 3280406230u, 1017987696u, 2139095040u, 0, COSH_TOLERANCE, 0},
{387, 1120190670u, 850632217u, 2139095040u, 0, COSH_TOLERANCE, 0},
{388, 3275370769u, 3069778532u, 2139095040u, 0, COSH_TOLERANCE, 0},
{389, 1134651039u, 3387555900u, 2139095040u, 0, COSH_TOLERANCE, 0},
{390, 1128329544u, 3228401212u, 2139095040u, 0, COSH_TOLERANCE, 0},
{391, 3278970989u, 1260217257u, 2139095040u, 0, COSH_TOLERANCE, 0},
{392, 1121118397u, 1087951909u, 2139095040u, 0, COSH_TOLERANCE, 0},
{393, 3270894457u, 869285240u, 2139095040u, 0, COSH_TOLERANCE, 0},
{394, 3274377473u, 3060143904u, 2139095040u, 0, COSH_TOLERANCE, 0},
{395, 1140495091u, 3003675365u, 2139095040u, 0, COSH_TOLERANCE, 0},
{396, 3273091864u, 3260140004u, 2139095040u, 0, COSH_TOLERANCE, 0},
{397, 3283145875u, 966439623u, 2139095040u, 0, COSH_TOLERANCE, 0},
{398, 3279997240u, 3205527253u, 2139095040u, 0, COSH_TOLERANCE, 0},
{399, 3275779969u, 3165561391u, 2139095040u, 0, COSH_TOLERANCE, 0},
{400, 1128236602u, 3119707283u, 2139095040u, 0, COSH_TOLERANCE, 0},
{401, 1119873837u, 894348966u, 2139095040u, 0, COSH_TOLERANCE, 0},
{402, 1129518015u, 1296370667u, 2139095040u, 0, COSH_TOLERANCE, 0},
{403, 3285580500u, 823220784u, 2139095040u, 0, COSH_TOLERANCE, 0},
{404, 3272701000u, 2997091781u, 2139095040u, 0, COSH_TOLERANCE, 0},
{405, 1133497567u, 1010219988u, 2139095040u, 0, COSH_TOLERANCE, 0},
{406, 3284538233u, 3096700943u, 2139095040u, 0, COSH_TOLERANCE, 0},
{407, 3283473802u, 1209565017u, 2139095040u, 0, COSH_TOLERANCE, 0},
{408, 3283716643u, 2960476959u, 2139095040u, 0, COSH_TOLERANCE, 0},
{409, 1123896707u, 1291336083u, 2139095040u, 0, COSH_TOLERANCE, 0},
{410, 3283491469u, 3066966245u, 2139095040u, 0, COSH_TOLERANCE, 0},
{411, 3277490267u, 3465211174u, 2139095040u, 0, COSH_TOLERANCE, 0},
{412, 3285474297u, 1004690387u, 2139095040u, 0, COSH_TOLERANCE, 0},
{413, 1131356577u, 3039376424u, 2139095040u, 0, COSH_TOLERANCE, 0},
{414, 3282700297u, 3392466405u, 2139095040u, 0, COSH_TOLERANCE, 0},
{415, 3271199789u, 893873945u, 2139095040u, 0, COSH_TOLERANCE, 0},
{416, 1119334287u, 3402349985u, 2139095040u, 0, COSH_TOLERANCE, 0},
{417, 1124554585u, 1196383822u, 2139095040u, 0, COSH_TOLERANCE, 0},
{418, 1132549237u, 949986176u, 2139095040u, 0, COSH_TOLERANCE, 0},
{419, 3272320105u, 3014443710u, 2139095040u, 0, COSH_TOLERANCE, 0},
{420, 1124791402u, 3436881197u, 2139095040u, 0, COSH_TOLERANCE, 0},
{421, 1130535137u, 1292690378u, 2139095040u, 0, COSH_TOLERANCE, 0},
{422, 3268791785u, 3381966453u, 2139095040u, 0, COSH_TOLERANCE, 0},
{423, 1140775387u, 978336043u, 2139095040u, 0, COSH_TOLERANCE, 0},
{424, 1122649389u, 1287895126u, 2139095040u, 0, COSH_TOLERANCE, 0},
{425, 3285229246u, 1200179013u, 2139095040u, 0, COSH_TOLERANCE, 0},
{426, 1138929728u, 3269683237u, 2139095040u, 0, COSH_TOLERANCE, 0},
{427, 1134073081u, 974138676u, 2139095040u, 0, COSH_TOLERANCE, 0},
{428, 3283970590u, 3113982619u, 2139095040u, 0, COSH_TOLERANCE, 0},
{429, 1130792233u, 3008182462u, 2139095040u, 0, COSH_TOLERANCE, 0},
{430, 3271927640u, 1086391131u, 2139095040u, 0, COSH_TOLERANCE, 0},
{431, 1139696833u, 3487600045u, 2139095040u, 0, COSH_TOLERANCE, 0},
{432, 3277065262u, 3233768835u, 2139095040u, 0, COSH_TOLERANCE, 0},
{433, 1122592774u, 3367769132u, 2139095040u, 0, COSH_TOLERANCE, 0},
{434, 1122400138u, 3031189261u, 2139095040u, 0, COSH_TOLERANCE, 0},
{435, 3274032488u, 3274638356u, 2139095040u, 0, COSH_TOLERANCE, 0},
{436, 3266998297u, 1277961150u, 2139095040u, 0, COSH_TOLERANCE, 0},
{437, 3287654678u, 3261728191u, 2139095040u, 0, COSH_TOLERANCE, 0}

// AUTOMATICALLY GENERATED VECTORS STOP

};

#endif // CYGONCE_LIBM_COSH_H multiple inclusion protection

// EOF coshf.h
