#ifndef CYGONCE_LIBM_COSF_H
#define CYGONCE_LIBM_COSF_H
//===========================================================================
//
//      cosf.h
//
//      Test vectors for testing of cosf() math library function
//
//===========================================================================
// ####ECOSFGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 2012 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later
// version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License
// along with eCos; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
// As a special exception, if other files instantiate templates or use
// macros or inline functions from this file, or you compile this file
// and link it with other works to produce a work based on this file,
// this file does not by itself cause the resulting work to be covered by
// the GNU General Public License. However the source code for this file
// must still be made available in accordance with section (3) of the GNU
// General Public License v2.
//
// This exception does not invalidate any other reasons why a work based
// on this file might be covered by the GNU General Public License.
// -------------------------------------------
// ####ECOSFGPLCOPYRIGHTEND####
//===========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):
// Contributors:  visar, ilijak
// Date:        1998-02-13
// Purpose:
// Description:
// Usage:       #include "vectors/cosf.h"
//
//####DESCRIPTIONEND####
//
//===========================================================================


// CONFIGURATION

#include <pkgconf/libm.h>   // Configuration header


// INCLUDES

#include <cyg/infra/cyg_type.h>    // Common type definitions and support
#include "vectors/vector_support_float.h"// extra support for math tests

#define COSF_TOLERANCE 1.0E4

static const Cyg_libm_test_float_vec_t cosf_vec[] = {

// AUTOMATICALLY GENERATED VECTORS START

{0, 3214514586u, 0u, 1052346099u, 0, COSF_TOLERANCE, 0},
{1, 3214430700u, 0u, 1052658226u, 0, COSF_TOLERANCE, 0},
{2, 3214346813u, 0u, 1052969110u, 0, COSF_TOLERANCE, 0},
{3, 3214262927u, 0u, 1053278711u, 0, COSF_TOLERANCE, 0},
{4, 3214179041u, 0u, 1053587004u, 0, COSF_TOLERANCE, 0},
{5, 3214095155u, 0u, 1053893957u, 0, COSF_TOLERANCE, 0},
{6, 3214011269u, 0u, 1054199539u, 0, COSF_TOLERANCE, 0},
{7, 3213927383u, 0u, 1054503720u, 0, COSF_TOLERANCE, 0},
{8, 3213843497u, 0u, 1054806469u, 0, COSF_TOLERANCE, 0},
{9, 3213759611u, 0u, 1055107756u, 0, COSF_TOLERANCE, 0},
{10, 3213675725u, 0u, 1055407551u, 0, COSF_TOLERANCE, 0},
{11, 3213591839u, 0u, 1055705825u, 0, COSF_TOLERANCE, 0},
{12, 3213507953u, 0u, 1056002546u, 0, COSF_TOLERANCE, 0},
{13, 3213424067u, 0u, 1056297686u, 0, COSF_TOLERANCE, 0},
{14, 3213340180u, 0u, 1056591219u, 0, COSF_TOLERANCE, 0},
{15, 3213256294u, 0u, 1056883107u, 0, COSF_TOLERANCE, 0},
{16, 3213172408u, 0u, 1057068967u, 0, COSF_TOLERANCE, 0},
{17, 3213088522u, 0u, 1057213227u, 0, COSF_TOLERANCE, 0},
{18, 3213004636u, 0u, 1057356624u, 0, COSF_TOLERANCE, 0},
{19, 3212920750u, 0u, 1057499142u, 0, COSF_TOLERANCE, 0},
{20, 3212836864u, 0u, 1057640768u, 0, COSF_TOLERANCE, 0},
{21, 3212669092u, 0u, 1057781488u, 0, COSF_TOLERANCE, 0},
{22, 3212501320u, 0u, 1057921287u, 0, COSF_TOLERANCE, 0},
{23, 3212333548u, 0u, 1058060152u, 0, COSF_TOLERANCE, 0},
{24, 3212165775u, 0u, 1058198069u, 0, COSF_TOLERANCE, 0},
{25, 3211998003u, 0u, 1058335023u, 0, COSF_TOLERANCE, 0},
{26, 3211830231u, 0u, 1058471001u, 0, COSF_TOLERANCE, 0},
{27, 3211662459u, 0u, 1058605990u, 0, COSF_TOLERANCE, 0},
{28, 3211494687u, 0u, 1058739975u, 0, COSF_TOLERANCE, 0},
{29, 3211326915u, 0u, 1058872945u, 0, COSF_TOLERANCE, 0},
{30, 3211159142u, 0u, 1059004885u, 0, COSF_TOLERANCE, 0},
{31, 3210991370u, 0u, 1059135782u, 0, COSF_TOLERANCE, 0},
{32, 3210823598u, 0u, 1059265622u, 0, COSF_TOLERANCE, 0},
{33, 3210655826u, 0u, 1059394394u, 0, COSF_TOLERANCE, 0},
{34, 3210488054u, 0u, 1059522084u, 0, COSF_TOLERANCE, 0},
{35, 3210320282u, 0u, 1059648679u, 0, COSF_TOLERANCE, 0},
{36, 3210152509u, 0u, 1059774168u, 0, COSF_TOLERANCE, 0},
{37, 3209984737u, 0u, 1059898537u, 0, COSF_TOLERANCE, 0},
{38, 3209816965u, 0u, 1060021773u, 0, COSF_TOLERANCE, 0},
{39, 3209649193u, 0u, 1060143864u, 0, COSF_TOLERANCE, 0},
{40, 3209481421u, 0u, 1060264799u, 0, COSF_TOLERANCE, 0},
{41, 3209313649u, 0u, 1060384565u, 0, COSF_TOLERANCE, 0},
{42, 3209145876u, 0u, 1060503150u, 0, COSF_TOLERANCE, 0},
{43, 3208978104u, 0u, 1060620543u, 0, COSF_TOLERANCE, 0},
{44, 3208810332u, 0u, 1060736730u, 0, COSF_TOLERANCE, 0},
{45, 3208642560u, 0u, 1060851702u, 0, COSF_TOLERANCE, 0},
{46, 3208474788u, 0u, 1060965446u, 0, COSF_TOLERANCE, 0},
{47, 3208307016u, 0u, 1061077952u, 0, COSF_TOLERANCE, 0},
{48, 3208139244u, 0u, 1061189207u, 0, COSF_TOLERANCE, 0},
{49, 3207971471u, 0u, 1061299201u, 0, COSF_TOLERANCE, 0},
{50, 3207803699u, 0u, 1061407923u, 0, COSF_TOLERANCE, 0},
{51, 3207635927u, 0u, 1061515361u, 0, COSF_TOLERANCE, 0},
{52, 3207468155u, 0u, 1061621505u, 0, COSF_TOLERANCE, 0},
{53, 3207300383u, 0u, 1061726345u, 0, COSF_TOLERANCE, 0},
{54, 3207132611u, 0u, 1061829870u, 0, COSF_TOLERANCE, 0},
{55, 3206964838u, 0u, 1061932070u, 0, COSF_TOLERANCE, 0},
{56, 3206797066u, 0u, 1062032934u, 0, COSF_TOLERANCE, 0},
{57, 3206629294u, 0u, 1062132452u, 0, COSF_TOLERANCE, 0},
{58, 3206461522u, 0u, 1062230615u, 0, COSF_TOLERANCE, 0},
{59, 3206293750u, 0u, 1062327412u, 0, COSF_TOLERANCE, 0},
{60, 3206125978u, 0u, 1062422834u, 0, COSF_TOLERANCE, 0},
{61, 3205958205u, 0u, 1062516872u, 0, COSF_TOLERANCE, 0},
{62, 3205790433u, 0u, 1062609515u, 0, COSF_TOLERANCE, 0},
{63, 3205622661u, 0u, 1062700755u, 0, COSF_TOLERANCE, 0},
{64, 3205454889u, 0u, 1062790582u, 0, COSF_TOLERANCE, 0},
{65, 3205287117u, 0u, 1062878988u, 0, COSF_TOLERANCE, 0},
{66, 3205119345u, 0u, 1062965964u, 0, COSF_TOLERANCE, 0},
{67, 3204951572u, 0u, 1063051501u, 0, COSF_TOLERANCE, 0},
{68, 3204783800u, 0u, 1063135590u, 0, COSF_TOLERANCE, 0},
{69, 3204616028u, 0u, 1063218223u, 0, COSF_TOLERANCE, 0},
{70, 3204448256u, 0u, 1063299392u, 0, COSF_TOLERANCE, 0},
{71, 3204112712u, 0u, 1063379089u, 0, COSF_TOLERANCE, 0},
{72, 3203777167u, 0u, 1063457305u, 0, COSF_TOLERANCE, 0},
{73, 3203441623u, 0u, 1063534034u, 0, COSF_TOLERANCE, 0},
{74, 3203106079u, 0u, 1063609266u, 0, COSF_TOLERANCE, 0},
{75, 3202770534u, 0u, 1063682996u, 0, COSF_TOLERANCE, 0},
{76, 3202434990u, 0u, 1063755214u, 0, COSF_TOLERANCE, 0},
{77, 3202099446u, 0u, 1063825915u, 0, COSF_TOLERANCE, 0},
{78, 3201763901u, 0u, 1063895090u, 0, COSF_TOLERANCE, 0},
{79, 3201428357u, 0u, 1063962734u, 0, COSF_TOLERANCE, 0},
{80, 3201092813u, 0u, 1064028839u, 0, COSF_TOLERANCE, 0},
{81, 3200757268u, 0u, 1064093399u, 0, COSF_TOLERANCE, 0},
{82, 3200421724u, 0u, 1064156407u, 0, COSF_TOLERANCE, 0},
{83, 3200086180u, 0u, 1064217857u, 0, COSF_TOLERANCE, 0},
{84, 3199750636u, 0u, 1064277743u, 0, COSF_TOLERANCE, 0},
{85, 3199415091u, 0u, 1064336059u, 0, COSF_TOLERANCE, 0},
{86, 3199079547u, 0u, 1064392799u, 0, COSF_TOLERANCE, 0},
{87, 3198744003u, 0u, 1064447957u, 0, COSF_TOLERANCE, 0},
{88, 3198408458u, 0u, 1064501528u, 0, COSF_TOLERANCE, 0},
{89, 3198072914u, 0u, 1064553506u, 0, COSF_TOLERANCE, 0},
{90, 3197737370u, 0u, 1064603887u, 0, COSF_TOLERANCE, 0},
{91, 3197401825u, 0u, 1064652665u, 0, COSF_TOLERANCE, 0},
{92, 3197066281u, 0u, 1064699835u, 0, COSF_TOLERANCE, 0},
{93, 3196730737u, 0u, 1064745392u, 0, COSF_TOLERANCE, 0},
{94, 3196395192u, 0u, 1064789333u, 0, COSF_TOLERANCE, 0},
{95, 3196059648u, 0u, 1064831653u, 0, COSF_TOLERANCE, 0},
{96, 3195388559u, 0u, 1064872347u, 0, COSF_TOLERANCE, 0},
{97, 3194717471u, 0u, 1064911411u, 0, COSF_TOLERANCE, 0},
{98, 3194046382u, 0u, 1064948842u, 0, COSF_TOLERANCE, 0},
{99, 3193375293u, 0u, 1064984636u, 0, COSF_TOLERANCE, 0},
{100, 3192704205u, 0u, 1065018789u, 0, COSF_TOLERANCE, 0},
{101, 3192033116u, 0u, 1065051297u, 0, COSF_TOLERANCE, 0},
{102, 3191362028u, 0u, 1065082158u, 0, COSF_TOLERANCE, 0},
{103, 3190690939u, 0u, 1065111369u, 0, COSF_TOLERANCE, 0},
{104, 3190019850u, 0u, 1065138925u, 0, COSF_TOLERANCE, 0},
{105, 3189348762u, 0u, 1065164826u, 0, COSF_TOLERANCE, 0},
{106, 3188677673u, 0u, 1065189068u, 0, COSF_TOLERANCE, 0},
{107, 3188006584u, 0u, 1065211648u, 0, COSF_TOLERANCE, 0},
{108, 3186999951u, 0u, 1065232565u, 0, COSF_TOLERANCE, 0},
{109, 3185657774u, 0u, 1065251816u, 0, COSF_TOLERANCE, 0},
{110, 3184315597u, 0u, 1065269400u, 0, COSF_TOLERANCE, 0},
{111, 3182973420u, 0u, 1065285314u, 0, COSF_TOLERANCE, 0},
{112, 3181631242u, 0u, 1065299558u, 0, COSF_TOLERANCE, 0},
{113, 3180289065u, 0u, 1065312129u, 0, COSF_TOLERANCE, 0},
{114, 3178611343u, 0u, 1065323026u, 0, COSF_TOLERANCE, 0},
{115, 3175926989u, 0u, 1065332249u, 0, COSF_TOLERANCE, 0},
{116, 3173242634u, 0u, 1065339796u, 0, COSF_TOLERANCE, 0},
{117, 3170222735u, 0u, 1065345667u, 0, COSF_TOLERANCE, 0},
{118, 3164854026u, 0u, 1065349861u, 0, COSF_TOLERANCE, 0},
{119, 3156465418u, 0u, 1065352377u, 0, COSF_TOLERANCE, 0},
{120, 646742016u, 0u, 1065353216u, 0, COSF_TOLERANCE, 0},
{121, 1008981770u, 0u, 1065352377u, 0, COSF_TOLERANCE, 0},
{122, 1017370378u, 0u, 1065349861u, 0, COSF_TOLERANCE, 0},
{123, 1022739087u, 0u, 1065345667u, 0, COSF_TOLERANCE, 0},
{124, 1025758986u, 0u, 1065339796u, 0, COSF_TOLERANCE, 0},
{125, 1028443341u, 0u, 1065332249u, 0, COSF_TOLERANCE, 0},
{126, 1031127695u, 0u, 1065323026u, 0, COSF_TOLERANCE, 0},
{127, 1032805417u, 0u, 1065312129u, 0, COSF_TOLERANCE, 0},
{128, 1034147594u, 0u, 1065299558u, 0, COSF_TOLERANCE, 0},
{129, 1035489772u, 0u, 1065285314u, 0, COSF_TOLERANCE, 0},
{130, 1036831949u, 0u, 1065269400u, 0, COSF_TOLERANCE, 0},
{131, 1038174126u, 0u, 1065251816u, 0, COSF_TOLERANCE, 0},
{132, 1039516303u, 0u, 1065232565u, 0, COSF_TOLERANCE, 0},
{133, 1040522936u, 0u, 1065211648u, 0, COSF_TOLERANCE, 0},
{134, 1041194025u, 0u, 1065189068u, 0, COSF_TOLERANCE, 0},
{135, 1041865114u, 0u, 1065164826u, 0, COSF_TOLERANCE, 0},
{136, 1042536202u, 0u, 1065138925u, 0, COSF_TOLERANCE, 0},
{137, 1043207291u, 0u, 1065111369u, 0, COSF_TOLERANCE, 0},
{138, 1043878380u, 0u, 1065082158u, 0, COSF_TOLERANCE, 0},
{139, 1044549468u, 0u, 1065051297u, 0, COSF_TOLERANCE, 0},
{140, 1045220557u, 0u, 1065018789u, 0, COSF_TOLERANCE, 0},
{141, 1045891645u, 0u, 1064984636u, 0, COSF_TOLERANCE, 0},
{142, 1046562734u, 0u, 1064948842u, 0, COSF_TOLERANCE, 0},
{143, 1047233823u, 0u, 1064911411u, 0, COSF_TOLERANCE, 0},
{144, 1047904911u, 0u, 1064872347u, 0, COSF_TOLERANCE, 0},
{145, 1048576000u, 0u, 1064831653u, 0, COSF_TOLERANCE, 0},
{146, 1048911544u, 0u, 1064789333u, 0, COSF_TOLERANCE, 0},
{147, 1049247089u, 0u, 1064745392u, 0, COSF_TOLERANCE, 0},
{148, 1049582633u, 0u, 1064699835u, 0, COSF_TOLERANCE, 0},
{149, 1049918177u, 0u, 1064652665u, 0, COSF_TOLERANCE, 0},
{150, 1050253722u, 0u, 1064603887u, 0, COSF_TOLERANCE, 0},
{151, 1050589266u, 0u, 1064553506u, 0, COSF_TOLERANCE, 0},
{152, 1050924810u, 0u, 1064501528u, 0, COSF_TOLERANCE, 0},
{153, 1051260355u, 0u, 1064447957u, 0, COSF_TOLERANCE, 0},
{154, 1051595899u, 0u, 1064392799u, 0, COSF_TOLERANCE, 0},
{155, 1051931443u, 0u, 1064336059u, 0, COSF_TOLERANCE, 0},
{156, 1052266988u, 0u, 1064277743u, 0, COSF_TOLERANCE, 0},
{157, 1052602532u, 0u, 1064217857u, 0, COSF_TOLERANCE, 0},
{158, 1052938076u, 0u, 1064156407u, 0, COSF_TOLERANCE, 0},
{159, 1053273620u, 0u, 1064093399u, 0, COSF_TOLERANCE, 0},
{160, 1053609165u, 0u, 1064028839u, 0, COSF_TOLERANCE, 0},
{161, 1053944709u, 0u, 1063962734u, 0, COSF_TOLERANCE, 0},
{162, 1054280253u, 0u, 1063895090u, 0, COSF_TOLERANCE, 0},
{163, 1054615798u, 0u, 1063825915u, 0, COSF_TOLERANCE, 0},
{164, 1054951342u, 0u, 1063755214u, 0, COSF_TOLERANCE, 0},
{165, 1055286886u, 0u, 1063682996u, 0, COSF_TOLERANCE, 0},
{166, 1055622431u, 0u, 1063609266u, 0, COSF_TOLERANCE, 0},
{167, 1055957975u, 0u, 1063534034u, 0, COSF_TOLERANCE, 0},
{168, 1056293519u, 0u, 1063457305u, 0, COSF_TOLERANCE, 0},
{169, 1056629064u, 0u, 1063379089u, 0, COSF_TOLERANCE, 0},
{170, 1056964608u, 0u, 1063299392u, 0, COSF_TOLERANCE, 0},
{171, 1057132380u, 0u, 1063218223u, 0, COSF_TOLERANCE, 0},
{172, 1057300152u, 0u, 1063135590u, 0, COSF_TOLERANCE, 0},
{173, 1057467924u, 0u, 1063051501u, 0, COSF_TOLERANCE, 0},
{174, 1057635697u, 0u, 1062965964u, 0, COSF_TOLERANCE, 0},
{175, 1057803469u, 0u, 1062878988u, 0, COSF_TOLERANCE, 0},
{176, 1057971241u, 0u, 1062790582u, 0, COSF_TOLERANCE, 0},
{177, 1058139013u, 0u, 1062700755u, 0, COSF_TOLERANCE, 0},
{178, 1058306785u, 0u, 1062609515u, 0, COSF_TOLERANCE, 0},
{179, 1058474557u, 0u, 1062516872u, 0, COSF_TOLERANCE, 0},
{180, 1058642330u, 0u, 1062422834u, 0, COSF_TOLERANCE, 0},
{181, 1058810102u, 0u, 1062327412u, 0, COSF_TOLERANCE, 0},
{182, 1058977874u, 0u, 1062230615u, 0, COSF_TOLERANCE, 0},
{183, 1059145646u, 0u, 1062132452u, 0, COSF_TOLERANCE, 0},
{184, 1059313418u, 0u, 1062032934u, 0, COSF_TOLERANCE, 0},
{185, 1059481190u, 0u, 1061932070u, 0, COSF_TOLERANCE, 0},
{186, 1059648963u, 0u, 1061829870u, 0, COSF_TOLERANCE, 0},
{187, 1059816735u, 0u, 1061726345u, 0, COSF_TOLERANCE, 0},
{188, 1059984507u, 0u, 1061621505u, 0, COSF_TOLERANCE, 0},
{189, 1060152279u, 0u, 1061515361u, 0, COSF_TOLERANCE, 0},
{190, 1060320051u, 0u, 1061407923u, 0, COSF_TOLERANCE, 0},
{191, 1060487823u, 0u, 1061299201u, 0, COSF_TOLERANCE, 0},
{192, 1060655596u, 0u, 1061189207u, 0, COSF_TOLERANCE, 0},
{193, 1060823368u, 0u, 1061077952u, 0, COSF_TOLERANCE, 0},
{194, 1060991140u, 0u, 1060965446u, 0, COSF_TOLERANCE, 0},
{195, 1061158912u, 0u, 1060851702u, 0, COSF_TOLERANCE, 0},
{196, 1061326684u, 0u, 1060736730u, 0, COSF_TOLERANCE, 0},
{197, 1061494456u, 0u, 1060620543u, 0, COSF_TOLERANCE, 0},
{198, 1061662228u, 0u, 1060503150u, 0, COSF_TOLERANCE, 0},
{199, 1061830001u, 0u, 1060384565u, 0, COSF_TOLERANCE, 0},
{200, 1061997773u, 0u, 1060264799u, 0, COSF_TOLERANCE, 0},
{201, 1062165545u, 0u, 1060143864u, 0, COSF_TOLERANCE, 0},
{202, 1062333317u, 0u, 1060021773u, 0, COSF_TOLERANCE, 0},
{203, 1062501089u, 0u, 1059898537u, 0, COSF_TOLERANCE, 0},
{204, 1062668861u, 0u, 1059774168u, 0, COSF_TOLERANCE, 0},
{205, 1062836634u, 0u, 1059648679u, 0, COSF_TOLERANCE, 0},
{206, 1063004406u, 0u, 1059522084u, 0, COSF_TOLERANCE, 0},
{207, 1063172178u, 0u, 1059394394u, 0, COSF_TOLERANCE, 0},
{208, 1063339950u, 0u, 1059265622u, 0, COSF_TOLERANCE, 0},
{209, 1063507722u, 0u, 1059135782u, 0, COSF_TOLERANCE, 0},
{210, 1063675494u, 0u, 1059004885u, 0, COSF_TOLERANCE, 0},
{211, 1063843267u, 0u, 1058872945u, 0, COSF_TOLERANCE, 0},
{212, 1064011039u, 0u, 1058739975u, 0, COSF_TOLERANCE, 0},
{213, 1064178811u, 0u, 1058605990u, 0, COSF_TOLERANCE, 0},
{214, 1064346583u, 0u, 1058471001u, 0, COSF_TOLERANCE, 0},
{215, 1064514355u, 0u, 1058335023u, 0, COSF_TOLERANCE, 0},
{216, 1064682127u, 0u, 1058198069u, 0, COSF_TOLERANCE, 0},
{217, 1064849900u, 0u, 1058060152u, 0, COSF_TOLERANCE, 0},
{218, 1065017672u, 0u, 1057921287u, 0, COSF_TOLERANCE, 0},
{219, 1065185444u, 0u, 1057781488u, 0, COSF_TOLERANCE, 0},
{220, 1065353216u, 0u, 1057640768u, 0, COSF_TOLERANCE, 0},
{221, 1065437102u, 0u, 1057499142u, 0, COSF_TOLERANCE, 0},
{222, 1065520988u, 0u, 1057356624u, 0, COSF_TOLERANCE, 0},
{223, 1065604874u, 0u, 1057213227u, 0, COSF_TOLERANCE, 0},
{224, 1065688760u, 0u, 1057068967u, 0, COSF_TOLERANCE, 0},
{225, 1065772646u, 0u, 1056883107u, 0, COSF_TOLERANCE, 0},
{226, 1065856532u, 0u, 1056591219u, 0, COSF_TOLERANCE, 0},
{227, 1065940419u, 0u, 1056297686u, 0, COSF_TOLERANCE, 0},
{228, 1066024305u, 0u, 1056002546u, 0, COSF_TOLERANCE, 0},
{229, 1066108191u, 0u, 1055705825u, 0, COSF_TOLERANCE, 0},
{230, 1066192077u, 0u, 1055407551u, 0, COSF_TOLERANCE, 0},
{231, 1066275963u, 0u, 1055107756u, 0, COSF_TOLERANCE, 0},
{232, 1066359849u, 0u, 1054806469u, 0, COSF_TOLERANCE, 0},
{233, 1066443735u, 0u, 1054503720u, 0, COSF_TOLERANCE, 0},
{234, 1066527621u, 0u, 1054199539u, 0, COSF_TOLERANCE, 0},
{235, 1066611507u, 0u, 1053893957u, 0, COSF_TOLERANCE, 0},
{236, 1066695393u, 0u, 1053587004u, 0, COSF_TOLERANCE, 0},
{237, 1066779279u, 0u, 1053278711u, 0, COSF_TOLERANCE, 0},
{238, 1066863165u, 0u, 1052969110u, 0, COSF_TOLERANCE, 0},
{239, 1066947052u, 0u, 1052658226u, 0, COSF_TOLERANCE, 0},
{240, 3234402267u, 0u, 1065353216u, 0, COSF_TOLERANCE, 0},
{241, 3226013659u, 0u, 3212836864u, 0, COSF_TOLERANCE, 0},
{242, 3217625051u, 0u, 3007036718u, 0, COSF_TOLERANCE, 0},
{243, 0u, 0u, 1065353216u, 0, COSF_TOLERANCE, 0},
{244, 1070141403u, 0u, 3007036718u, 0, COSF_TOLERANCE, 0},
{245, 1078530011u, 0u, 3212836864u, 0, COSF_TOLERANCE, 0},
{246, 1083624420u, 0u, 843898414u, 0, COSF_TOLERANCE, 0},
{247, 3253731328u, 0u, 1042150424u, 0, COSF_TOLERANCE, 0},
{248, 3252840038u, 0u, 3212831339u, 0, COSF_TOLERANCE, 0},
{249, 3251948749u, 0u, 1037281885u, 0, COSF_TOLERANCE, 0},
{250, 3251057459u, 0u, 1064900864u, 0, COSF_TOLERANCE, 0},
{251, 3250166170u, 0u, 3199552432u, 0, COSF_TOLERANCE, 0},
{252, 3249274880u, 0u, 3210853658u, 0, COSF_TOLERANCE, 0},
{253, 3248383590u, 0u, 1058328972u, 0, COSF_TOLERANCE, 0},
{254, 3247492301u, 0u, 1060856784u, 0, COSF_TOLERANCE, 0},
{255, 3246601011u, 0u, 3208977235u, 0, COSF_TOLERANCE, 0},
{256, 3245028147u, 0u, 3205011706u, 0, COSF_TOLERANCE, 0},
{257, 3243245568u, 0u, 1063800431u, 0, COSF_TOLERANCE, 0},
{258, 3241462989u, 0u, 1050245183u, 0, COSF_TOLERANCE, 0},
{259, 3239680410u, 0u, 3212579968u, 0, COSF_TOLERANCE, 0},
{260, 3237792973u, 0u, 3174853843u, 0, COSF_TOLERANCE, 0},
{261, 3234227814u, 0u, 1065295202u, 0, COSF_TOLERANCE, 0},
{262, 3230662656u, 0u, 3193428699u, 0, COSF_TOLERANCE, 0},
{263, 3224580915u, 0u, 3211867515u, 0, COSF_TOLERANCE, 0},
{264, 3213675725u, 0u, 1055407551u, 0, COSF_TOLERANCE, 0},
{265, 1058642330u, 0u, 1062422834u, 0, COSF_TOLERANCE, 0},
{266, 1075000115u, 0u, 3207237904u, 0, COSF_TOLERANCE, 0},
{267, 1082130432u, 0u, 3207025968u, 0, COSF_TOLERANCE, 0},
{268, 1085695590u, 0u, 1062580155u, 0, COSF_TOLERANCE, 0},
{269, 1089260749u, 0u, 1054902596u, 0, COSF_TOLERANCE, 0},
{270, 1091672474u, 0u, 3211959780u, 0, COSF_TOLERANCE, 0},
{271, 1093455053u, 0u, 3192323679u, 0, COSF_TOLERANCE, 0},
{272, 1095237632u, 0u, 1065316277u, 0, COSF_TOLERANCE, 0},
{273, 1097020211u, 0u, 3179321561u, 0, COSF_TOLERANCE, 0},
{274, 1098802790u, 0u, 3212528459u, 0, COSF_TOLERANCE, 0},
{275, 1099746509u, 0u, 1050782006u, 0, COSF_TOLERANCE, 0},
{276, 1100637798u, 0u, 1063679759u, 0, COSF_TOLERANCE, 0},
{277, 1101529088u, 0u, 3205249020u, 0, COSF_TOLERANCE, 0},
{278, 1102420378u, 0u, 3208795393u, 0, COSF_TOLERANCE, 0},
{279, 1103311667u, 0u, 1061047231u, 0, COSF_TOLERANCE, 0},
{280, 1104202957u, 0u, 1058098048u, 0, COSF_TOLERANCE, 0},
{281, 1105094246u, 0u, 3210984606u, 0, COSF_TOLERANCE, 0},
{282, 1105985536u, 0u, 3199023149u, 0, COSF_TOLERANCE, 0},
{283, 1107800421u, 1203999711u, 3209573648u, 0, COSF_TOLERANCE, 0},
{284, 3196650934u, 896005582u, 1064755990u, 0, COSF_TOLERANCE, 0},
{285, 3368700125u, 3308232444u, 3212415424u, 0, COSF_TOLERANCE, 0},
{286, 1224242132u, 3061363425u, 1062694130u, 0, COSF_TOLERANCE, 0},
{287, 3221027117u, 1284201705u, 3200909320u, 0, COSF_TOLERANCE, 0},
{288, 1198712763u, 919636942u, 1058273289u, 0, COSF_TOLERANCE, 0},
{289, 3159309973u, 852521077u, 1065351874u, 0, COSF_TOLERANCE, 0},
{290, 954173073u, 850531830u, 1065353216u, 0, COSF_TOLERANCE, 0},
{291, 3090780435u, 1035260608u, 1065353216u, 0, COSF_TOLERANCE, 0},
{292, 966554515u, 3234538174u, 1065353215u, 0, COSF_TOLERANCE, 0},
{293, 1312607135u, 1194999402u, 3211015536u, 0, COSF_TOLERANCE, 0},
{294, 1166191415u, 1018661564u, 3212808685u, 0, COSF_TOLERANCE, 0},
{295, 3111900019u, 1130472166u, 1065353216u, 0, COSF_TOLERANCE, 0},
{296, 1234419246u, 2984575812u, 1044118836u, 0, COSF_TOLERANCE, 0},
{297, 1302107128u, 3370647675u, 1065238366u, 0, COSF_TOLERANCE, 0},
{298, 1052801068u, 3039122570u, 1064181687u, 0, COSF_TOLERANCE, 0},
{299, 1060849628u, 3081357692u, 1061060424u, 0, COSF_TOLERANCE, 0},
{300, 3484320003u, 3033957825u, 3211534416u, 0, COSF_TOLERANCE, 0},
{301, 3181522772u, 3305392896u, 1065300636u, 0, COSF_TOLERANCE, 0},
{302, 882596369u, 1256676590u, 1065353216u, 0, COSF_TOLERANCE, 0},
{303, 1167223673u, 846102364u, 3195973898u, 0, COSF_TOLERANCE, 0},
{304, 968192794u, 878547432u, 1065353215u, 0, COSF_TOLERANCE, 0},
{305, 3122346862u, 1111584337u, 1065353213u, 0, COSF_TOLERANCE, 0},
{306, 1052361612u, 1280025214u, 1064261014u, 0, COSF_TOLERANCE, 0},
{307, 906701409u, 2968301825u, 1065353216u, 0, COSF_TOLERANCE, 0},
{308, 3471653172u, 1154138102u, 1028780596u, 0, COSF_TOLERANCE, 0},
{309, 3231467496u, 934336592u, 1043244255u, 0, COSF_TOLERANCE, 0},
{310, 1341514497u, 3466051188u, 3212270872u, 0, COSF_TOLERANCE, 0},
{311, 1272351391u, 3373485062u, 1049939301u, 0, COSF_TOLERANCE, 0},
{312, 3319724992u, 3354615790u, 3206332287u, 0, COSF_TOLERANCE, 0},
{313, 917622040u, 1334966485u, 1065353216u, 0, COSF_TOLERANCE, 0},
{314, 940236348u, 3304072663u, 1065353216u, 0, COSF_TOLERANCE, 0},
{315, 3251541546u, 3174764041u, 1061509153u, 0, COSF_TOLERANCE, 0},
{316, 3099843889u, 3355962282u, 1065353216u, 0, COSF_TOLERANCE, 0},
{317, 3110358400u, 851145088u, 1065353216u, 0, COSF_TOLERANCE, 0},
{318, 3371863479u, 1014861921u, 1038395093u, 0, COSF_TOLERANCE, 0},
{319, 3204069187u, 966573255u, 1063389318u, 0, COSF_TOLERANCE, 0},
{320, 1306460502u, 903489435u, 3197908639u, 0, COSF_TOLERANCE, 0},
{321, 1197542187u, 3024598921u, 1062014001u, 0, COSF_TOLERANCE, 0},
{322, 922888249u, 1139392309u, 1065353216u, 0, COSF_TOLERANCE, 0},
{323, 1184239996u, 3224098462u, 1057000820u, 0, COSF_TOLERANCE, 0},
{324, 1252490238u, 1173619825u, 3212300137u, 0, COSF_TOLERANCE, 0},
{325, 1001673627u, 3462631271u, 1065352962u, 0, COSF_TOLERANCE, 0},
{326, 976098044u, 1151967422u, 1065353212u, 0, COSF_TOLERANCE, 0},
{327, 941796645u, 886451963u, 1065353216u, 0, COSF_TOLERANCE, 0},
{328, 3287199470u, 854245542u, 1065150928u, 0, COSF_TOLERANCE, 0},
{329, 893184329u, 1243067084u, 1065353216u, 0, COSF_TOLERANCE, 0},
{330, 1143233714u, 1007268238u, 3207062841u, 0, COSF_TOLERANCE, 0},
{331, 1139941253u, 1147688821u, 1063748220u, 0, COSF_TOLERANCE, 0},
{332, 3143717025u, 3234638157u, 1065353117u, 0, COSF_TOLERANCE, 0},
{333, 3048866608u, 3449209899u, 1065353216u, 0, COSF_TOLERANCE, 0},
{334, 3240298487u, 1020260821u, 3208166309u, 0, COSF_TOLERANCE, 0},
{335, 1288902137u, 3123875978u, 3207694694u, 0, COSF_TOLERANCE, 0},
{336, 1333134799u, 1338107877u, 1056301331u, 0, COSF_TOLERANCE, 0},
{337, 1187847971u, 1317663644u, 3197338100u, 0, COSF_TOLERANCE, 0},
{338, 1038851706u, 1327544110u, 1065242306u, 0, COSF_TOLERANCE, 0},
{339, 3329354473u, 3165437289u, 1058212602u, 0, COSF_TOLERANCE, 0},
{340, 3077218579u, 1308397879u, 1065353216u, 0, COSF_TOLERANCE, 0},
{341, 1309289088u, 1019883016u, 3206861402u, 0, COSF_TOLERANCE, 0},
{342, 3444653659u, 1279248024u, 3205948454u, 0, COSF_TOLERANCE, 0},
{343, 3405585402u, 2962345057u, 1049586375u, 0, COSF_TOLERANCE, 0},
{344, 3106647724u, 853848387u, 1065353216u, 0, COSF_TOLERANCE, 0},
{345, 1106778573u, 3304487767u, 1064007007u, 0, COSF_TOLERANCE, 0},
{346, 1140567947u, 3069174149u, 1061226693u, 0, COSF_TOLERANCE, 0},
{347, 1238569473u, 873035665u, 1063385096u, 0, COSF_TOLERANCE, 0},
{348, 3154871957u, 1276671061u, 1065352608u, 0, COSF_TOLERANCE, 0},
{349, 1261071232u, 1182202773u, 3182360604u, 0, COSF_TOLERANCE, 0},
{350, 1175011025u, 3029705783u, 1065054590u, 0, COSF_TOLERANCE, 0},
{351, 1082692850u, 1211581107u, 3202090793u, 0, COSF_TOLERANCE, 0},
{352, 974547519u, 3475164509u, 1065353213u, 0, COSF_TOLERANCE, 0},
{353, 3058097085u, 3104309359u, 1065353216u, 0, COSF_TOLERANCE, 0},
{354, 3107252546u, 1071134451u, 1065353216u, 0, COSF_TOLERANCE, 0},
{355, 3096032662u, 2976848821u, 1065353216u, 0, COSF_TOLERANCE, 0},
{356, 3197942144u, 3094120030u, 1064573331u, 0, COSF_TOLERANCE, 0},
{357, 3403348556u, 3184653669u, 1019220617u, 0, COSF_TOLERANCE, 0},
{358, 3182301130u, 3460764044u, 1065292658u, 0, COSF_TOLERANCE, 0},
{359, 1136411063u, 1118097422u, 1063474921u, 0, COSF_TOLERANCE, 0},
{360, 3239231622u, 3302723069u, 3212303719u, 0, COSF_TOLERANCE, 0},
{361, 3340615780u, 870350055u, 3207952094u, 0, COSF_TOLERANCE, 0},
{362, 998567360u, 2995278691u, 1065353078u, 0, COSF_TOLERANCE, 0},
{363, 3417964312u, 1321337529u, 1062054343u, 0, COSF_TOLERANCE, 0},
{364, 3109481038u, 1143864063u, 1065353216u, 0, COSF_TOLERANCE, 0},
{365, 1148867223u, 1256486202u, 3206780400u, 0, COSF_TOLERANCE, 0},
{366, 989687421u, 3372681320u, 1065353185u, 0, COSF_TOLERANCE, 0},
{367, 1152956913u, 3166480640u, 1050381098u, 0, COSF_TOLERANCE, 0},
{368, 892922651u, 3373029087u, 1065353216u, 0, COSF_TOLERANCE, 0},
{369, 1109627625u, 1314158257u, 3212813517u, 0, COSF_TOLERANCE, 0},
{370, 1307091856u, 1103202538u, 1044886424u, 0, COSF_TOLERANCE, 0},
{371, 1077234132u, 3272167130u, 3212042460u, 0, COSF_TOLERANCE, 0},
{372, 1142167709u, 1096445242u, 3192244228u, 0, COSF_TOLERANCE, 0},
{373, 3426232834u, 1036705270u, 3202908511u, 0, COSF_TOLERANCE, 0},
{374, 3368566779u, 967249167u, 3203307532u, 0, COSF_TOLERANCE, 0},
{375, 3030724760u, 3349013503u, 1065353216u, 0, COSF_TOLERANCE, 0},
{376, 1138741813u, 3073453199u, 1024337281u, 0, COSF_TOLERANCE, 0},
{377, 982950501u, 982549888u, 1065353205u, 0, COSF_TOLERANCE, 0},
{378, 1142981585u, 1015602236u, 1053132429u, 0, COSF_TOLERANCE, 0},
{379, 3347165962u, 3135486696u, 1058907526u, 0, COSF_TOLERANCE, 0},
{380, 1009535440u, 3381353228u, 1065352288u, 0, COSF_TOLERANCE, 0},
{381, 3103736980u, 3402950505u, 1065353216u, 0, COSF_TOLERANCE, 0},
{382, 3126820946u, 1077903063u, 1065353210u, 0, COSF_TOLERANCE, 0},
{383, 3473956030u, 976891930u, 3208545071u, 0, COSF_TOLERANCE, 0},
{384, 3349098349u, 1055327704u, 3210674348u, 0, COSF_TOLERANCE, 0},
{385, 3152729489u, 1060398533u, 1065352785u, 0, COSF_TOLERANCE, 0},
{386, 945568720u, 3313485084u, 1065353216u, 0, COSF_TOLERANCE, 0},
{387, 3345489836u, 1108392401u, 3211189684u, 0, COSF_TOLERANCE, 0},
{388, 940893161u, 1137000140u, 1065353216u, 0, COSF_TOLERANCE, 0},
{389, 976791751u, 3230678102u, 1065353212u, 0, COSF_TOLERANCE, 0},
{390, 1004442355u, 3036510596u, 1065352829u, 0, COSF_TOLERANCE, 0},
{391, 1108485380u, 3173536878u, 1053495770u, 0, COSF_TOLERANCE, 0},
{392, 1061834641u, 972388096u, 1060381268u, 0, COSF_TOLERANCE, 0},
{393, 3381268392u, 1146976802u, 1034505730u, 0, COSF_TOLERANCE, 0},
{394, 1087189715u, 2952822478u, 1065213234u, 0, COSF_TOLERANCE, 0},
{395, 3212952285u, 3329407365u, 1057445670u, 0, COSF_TOLERANCE, 0},
{396, 1000611335u, 857599439u, 1065353006u, 0, COSF_TOLERANCE, 0},
{397, 3466188568u, 1041678304u, 1047557643u, 0, COSF_TOLERANCE, 0},
{398, 3072456205u, 3160254633u, 1065353216u, 0, COSF_TOLERANCE, 0},
{399, 3319315516u, 3422089012u, 1055189382u, 0, COSF_TOLERANCE, 0},
{400, 935938416u, 1146676692u, 1065353216u, 0, COSF_TOLERANCE, 0},
{401, 3212614372u, 1152633030u, 1057827186u, 0, COSF_TOLERANCE, 0},
{402, 1315030230u, 3336225884u, 3211146944u, 0, COSF_TOLERANCE, 0},
{403, 1134593658u, 3456812581u, 1062345193u, 0, COSF_TOLERANCE, 0},
{404, 977281449u, 879922831u, 1065353211u, 0, COSF_TOLERANCE, 0},
{405, 1086198791u, 920125958u, 1064374585u, 0, COSF_TOLERANCE, 0},
{406, 1255152035u, 851754050u, 3208616871u, 0, COSF_TOLERANCE, 0},
{407, 1135271264u, 3284878412u, 3208847073u, 0, COSF_TOLERANCE, 0},
{408, 1094190727u, 1056854532u, 1056451200u, 0, COSF_TOLERANCE, 0},
{409, 1294665325u, 991185677u, 1060440078u, 0, COSF_TOLERANCE, 0},
{410, 1036608591u, 805416536u, 1065272164u, 0, COSF_TOLERANCE, 0},
{411, 3229998064u, 825237063u, 3204530827u, 0, COSF_TOLERANCE, 0},
{412, 3439134022u, 1043829691u, 3205512708u, 0, COSF_TOLERANCE, 0},
{413, 3073083133u, 1317170485u, 1065353216u, 0, COSF_TOLERANCE, 0},
{414, 1325668223u, 970681762u, 3207285914u, 0, COSF_TOLERANCE, 0},
{415, 1092037607u, 1027330835u, 3212832255u, 0, COSF_TOLERANCE, 0},
{416, 3316278408u, 3455589207u, 1051135228u, 0, COSF_TOLERANCE, 0},
{417, 3295436768u, 3129873731u, 3212713503u, 0, COSF_TOLERANCE, 0},
{418, 1151984049u, 3074547120u, 3198035925u, 0, COSF_TOLERANCE, 0},
{419, 1129287043u, 3076527544u, 1064992757u, 0, COSF_TOLERANCE, 0},
{420, 1243664530u, 972879810u, 3208729331u, 0, COSF_TOLERANCE, 0},
{421, 950829092u, 929114193u, 1065353216u, 0, COSF_TOLERANCE, 0},
{422, 1115471979u, 3047246262u, 1064300936u, 0, COSF_TOLERANCE, 0},
{423, 3351092088u, 3024661404u, 3210066335u, 0, COSF_TOLERANCE, 0},
{424, 3424479544u, 3312047722u, 3209978045u, 0, COSF_TOLERANCE, 0},
{425, 3241193975u, 884465785u, 1027867782u, 0, COSF_TOLERANCE, 0},
{426, 1030934236u, 1045139240u, 1065323747u, 0, COSF_TOLERANCE, 0},
{427, 3131791114u, 3408392958u, 1065353202u, 0, COSF_TOLERANCE, 0},
{428, 1025254314u, 3057812821u, 1065341028u, 0, COSF_TOLERANCE, 0},
{429, 1110545760u, 3240144177u, 1063938715u, 0, COSF_TOLERANCE, 0},
{430, 3180213739u, 1108793820u, 1065312785u, 0, COSF_TOLERANCE, 0},
{431, 3361976590u, 3138179993u, 1064942857u, 0, COSF_TOLERANCE, 0},
{432, 881280146u, 3421884736u, 1065353216u, 0, COSF_TOLERANCE, 0},
{433, 1304154705u, 2961937089u, 1065316526u, 0, COSF_TOLERANCE, 0},
{434, 3264443610u, 3222916705u, 3184186617u, 0, COSF_TOLERANCE, 0},
{435, 3374550627u, 3055856293u, 1064004706u, 0, COSF_TOLERANCE, 0},
{436, 899599265u, 3240118211u, 1065353216u, 0, COSF_TOLERANCE, 0},
{437, 1268194719u, 1332489410u, 1065342423u, 0, COSF_TOLERANCE, 0},
{438, 1133420220u, 1245770860u, 3209468141u, 0, COSF_TOLERANCE, 0},
{439, 1161858787u, 815362075u, 3205516474u, 0, COSF_TOLERANCE, 0},
{440, 3184462258u, 1263529646u, 1065267560u, 0, COSF_TOLERANCE, 0},
{441, 3295996963u, 3453334307u, 1063400576u, 0, COSF_TOLERANCE, 0},
{442, 1270887389u, 1156123987u, 3212780406u, 0, COSF_TOLERANCE, 0},
{443, 3325193181u, 993979179u, 3208634331u, 0, COSF_TOLERANCE, 0},
{444, 925657343u, 1315159742u, 1065353216u, 0, COSF_TOLERANCE, 0},
{445, 3115275450u, 3008350271u, 1065353215u, 0, COSF_TOLERANCE, 0},
{446, 3116607482u, 3224327456u, 1065353215u, 0, COSF_TOLERANCE, 0},
{447, 3187892415u, 3118097315u, 1065215324u, 0, COSF_TOLERANCE, 0},
{448, 1189120494u, 978961471u, 3184887707u, 0, COSF_TOLERANCE, 0},
{449, 889030794u, 3129523970u, 1065353216u, 0, COSF_TOLERANCE, 0},
{450, 1323529208u, 3100744786u, 3202135945u, 0, COSF_TOLERANCE, 0},
{451, 3465768388u, 3190881451u, 3212262509u, 0, COSF_TOLERANCE, 0},
{452, 3426099899u, 1118756120u, 3207882716u, 0, COSF_TOLERANCE, 0},
{453, 3224857113u, 3398166843u, 3212203079u, 0, COSF_TOLERANCE, 0},
{454, 1065798296u, 816191940u, 1056794032u, 0, COSF_TOLERANCE, 0},
{455, 3328989444u, 850266225u, 3210663044u, 0, COSF_TOLERANCE, 0},
{456, 3357819026u, 3148475462u, 1064572647u, 0, COSF_TOLERANCE, 0},
{457, 1273397670u, 901308750u, 3166465533u, 0, COSF_TOLERANCE, 0},
{458, 3424831780u, 1304806106u, 1065348980u, 0, COSF_TOLERANCE, 0},
{459, 1257596246u, 3420832544u, 3165249336u, 0, COSF_TOLERANCE, 0},
{460, 1051773536u, 896271348u, 1064362957u, 0, COSF_TOLERANCE, 0},
{461, 3294752507u, 3113225954u, 1057002112u, 0, COSF_TOLERANCE, 0},
{462, 3424848725u, 2973850350u, 3212724060u, 0, COSF_TOLERANCE, 0},
{463, 1090870906u, 3294742905u, 3203212900u, 0, COSF_TOLERANCE, 0},
{464, 1227582289u, 1208979668u, 1064452265u, 0, COSF_TOLERANCE, 0},
{465, 1272325814u, 3004311296u, 3208642571u, 0, COSF_TOLERANCE, 0},
{466, 3359508271u, 859974315u, 1030101838u, 0, COSF_TOLERANCE, 0},
{467, 1137854355u, 3335041917u, 1063934227u, 0, COSF_TOLERANCE, 0},
{468, 3440773058u, 3204192793u, 3205801340u, 0, COSF_TOLERANCE, 0},
{469, 3101598400u, 3057760708u, 1065353216u, 0, COSF_TOLERANCE, 0},
{470, 3451216836u, 3347783723u, 3211742026u, 0, COSF_TOLERANCE, 0},
{471, 3437062994u, 3106834845u, 1062562754u, 0, COSF_TOLERANCE, 0},
{472, 1131196082u, 1164573183u, 3203988310u, 0, COSF_TOLERANCE, 0},
{473, 3177294154u, 1282436638u, 1065327761u, 0, COSF_TOLERANCE, 0},
{474, 3258097678u, 1305882290u, 1061684501u, 0, COSF_TOLERANCE, 0},
{475, 3460915348u, 1219372260u, 3198742303u, 0, COSF_TOLERANCE, 0},
{476, 3303035472u, 3153013020u, 3208641160u, 0, COSF_TOLERANCE, 0},
{477, 1053698677u, 3284313107u, 1064011355u, 0, COSF_TOLERANCE, 0},
{478, 3396166221u, 1201894512u, 1050395522u, 0, COSF_TOLERANCE, 0},
{479, 3037541131u, 1085398440u, 1065353216u, 0, COSF_TOLERANCE, 0},
{480, 3458934263u, 1005577835u, 3210301928u, 0, COSF_TOLERANCE, 0},
{481, 1065761827u, 3333928591u, 1056920632u, 0, COSF_TOLERANCE, 0},
{482, 3025843188u, 820250112u, 1065353216u, 0, COSF_TOLERANCE, 0},
{483, 926665223u, 3150815797u, 1065353216u, 0, COSF_TOLERANCE, 0},
{484, 1199816046u, 3143776186u, 1059457067u, 0, COSF_TOLERANCE, 0},
{485, 3333779015u, 952421041u, 1063412304u, 0, COSF_TOLERANCE, 0},
{486, 948398145u, 3238273189u, 1065353216u, 0, COSF_TOLERANCE, 0},
{487, 3054021468u, 1270257895u, 1065353216u, 0, COSF_TOLERANCE, 0},
{488, 1080781593u, 1213908300u, 3210476977u, 0, COSF_TOLERANCE, 0},
{489, 3164749613u, 3010837763u, 1065349926u, 0, COSF_TOLERANCE, 0},
{490, 3235326590u, 1271705594u, 1063749838u, 0, COSF_TOLERANCE, 0},
{491, 3118883815u, 1051802647u, 1065353214u, 0, COSF_TOLERANCE, 0},
{492, 965378004u, 1292594138u, 1065353215u, 0, COSF_TOLERANCE, 0},
{493, 3226990408u, 1110755136u, 3212383995u, 0, COSF_TOLERANCE, 0},
{494, 3117098218u, 1122474770u, 1065353215u, 0, COSF_TOLERANCE, 0},
{495, 1283624229u, 906796922u, 3211981483u, 0, COSF_TOLERANCE, 0},
{496, 970649315u, 1078286437u, 1065353215u, 0, COSF_TOLERANCE, 0},
{497, 959776291u, 3280345347u, 1065353216u, 0, COSF_TOLERANCE, 0},
{498, 3341117305u, 3294559023u, 1055798833u, 0, COSF_TOLERANCE, 0},
{499, 1270734970u, 3355874874u, 1065302344u, 0, COSF_TOLERANCE, 0},
{500, 3454816067u, 868771977u, 3212739421u, 0, COSF_TOLERANCE, 0},
{501, 917206623u, 1172710814u, 1065353216u, 0, COSF_TOLERANCE, 0},
{502, 1106502045u, 1290849316u, 1058595715u, 0, COSF_TOLERANCE, 0},
{503, 1157598381u, 3309023746u, 3207978544u, 0, COSF_TOLERANCE, 0},
{504, 3335234513u, 1002337336u, 3212728047u, 0, COSF_TOLERANCE, 0},
{505, 1279489061u, 1006049444u, 3188087006u, 0, COSF_TOLERANCE, 0},
{506, 3157416480u, 1309984610u, 1065352222u, 0, COSF_TOLERANCE, 0},
{507, 3143920719u, 3131608518u, 1065353114u, 0, COSF_TOLERANCE, 0},
{508, 1233171235u, 826460580u, 3208947956u, 0, COSF_TOLERANCE, 0},
{509, 1148920078u, 1007674793u, 1060346730u, 0, COSF_TOLERANCE, 0},
{510, 3064988156u, 3230867340u, 1065353216u, 0, COSF_TOLERANCE, 0},
{511, 3083619260u, 1159415661u, 1065353216u, 0, COSF_TOLERANCE, 0},
{512, 1109198803u, 1221754614u, 1011415968u, 0, COSF_TOLERANCE, 0},
{513, 3219949483u, 1056167693u, 3196850244u, 0, COSF_TOLERANCE, 0},
{514, 3361149474u, 3387342069u, 1062393895u, 0, COSF_TOLERANCE, 0},
{515, 1207502108u, 3388073586u, 1065089606u, 0, COSF_TOLERANCE, 0},
{516, 1000014431u, 831213088u, 1065353028u, 0, COSF_TOLERANCE, 0},
{517, 3161756316u, 3143659754u, 1065351347u, 0, COSF_TOLERANCE, 0},
{518, 3160728744u, 3382954009u, 1065351579u, 0, COSF_TOLERANCE, 0},
{519, 1234530539u, 1079988872u, 1061039433u, 0, COSF_TOLERANCE, 0},
{520, 1017843965u, 1193076204u, 1065349558u, 0, COSF_TOLERANCE, 0},
{521, 951862956u, 1173464654u, 1065353216u, 0, COSF_TOLERANCE, 0},
{522, 3306328852u, 1118701064u, 1003885353u, 0, COSF_TOLERANCE, 0},
{523, 1291910469u, 1211303367u, 1063595141u, 0, COSF_TOLERANCE, 0},
{524, 3027442905u, 1173894400u, 1065353216u, 0, COSF_TOLERANCE, 0},
{525, 1131927531u, 3182962700u, 3211863029u, 0, COSF_TOLERANCE, 0},
{526, 3449879391u, 991614550u, 1061755886u, 0, COSF_TOLERANCE, 0},
{527, 970094304u, 3344590506u, 1065353215u, 0, COSF_TOLERANCE, 0},
{528, 1125551064u, 3331248076u, 1064830894u, 0, COSF_TOLERANCE, 0},
{529, 3427296372u, 3455289118u, 1065342989u, 0, COSF_TOLERANCE, 0},
{530, 1198917460u, 1327195159u, 1061636200u, 0, COSF_TOLERANCE, 0},
{531, 3201603336u, 820047343u, 1063927651u, 0, COSF_TOLERANCE, 0},
{532, 3114686212u, 3476082461u, 1065353215u, 0, COSF_TOLERANCE, 0},
{533, 921940707u, 2967544056u, 1065353216u, 0, COSF_TOLERANCE, 0},
{534, 1091906532u, 3011904455u, 3212750410u, 0, COSF_TOLERANCE, 0},
{535, 3393557778u, 3383396815u, 3211966318u, 0, COSF_TOLERANCE, 0},
{536, 1276853215u, 873199561u, 1064578880u, 0, COSF_TOLERANCE, 0},
{537, 3462778440u, 3349284325u, 1065155179u, 0, COSF_TOLERANCE, 0},
{538, 3360170117u, 3048354042u, 3207160802u, 0, COSF_TOLERANCE, 0},
{539, 3224245428u, 3271307999u, 3211367917u, 0, COSF_TOLERANCE, 0},
{540, 1120124467u, 1135619937u, 3210924569u, 0, COSF_TOLERANCE, 0},
{541, 1064364381u, 3180675544u, 1058456623u, 0, COSF_TOLERANCE, 0},
{542, 1268744779u, 3328452652u, 3212264195u, 0, COSF_TOLERANCE, 0},
{543, 1165195428u, 3390323168u, 1065343028u, 0, COSF_TOLERANCE, 0},
{544, 3044092739u, 1106497311u, 1065353216u, 0, COSF_TOLERANCE, 0},
{545, 3149469534u, 1278465842u, 1065352948u, 0, COSF_TOLERANCE, 0},
{546, 3247790039u, 909788142u, 1065077133u, 0, COSF_TOLERANCE, 0},
{547, 3215244648u, 1083988595u, 1049581731u, 0, COSF_TOLERANCE, 0},
{548, 3095275931u, 989153382u, 1065353216u, 0, COSF_TOLERANCE, 0},
{549, 3059688264u, 1117455718u, 1065353216u, 0, COSF_TOLERANCE, 0},
{550, 1212717473u, 837873779u, 3183067569u, 0, COSF_TOLERANCE, 0},
{551, 3275973009u, 3450721670u, 1062400303u, 0, COSF_TOLERANCE, 0},
{552, 3028857014u, 3188853813u, 1065353216u, 0, COSF_TOLERANCE, 0},
{553, 3391162308u, 1291220039u, 1056095531u, 0, COSF_TOLERANCE, 0},
{554, 1044867873u, 3369493273u, 1065036078u, 0, COSF_TOLERANCE, 0},
{555, 1089986803u, 3462160118u, 1037847106u, 0, COSF_TOLERANCE, 0},
{556, 1296314700u, 2957454177u, 1063610521u, 0, COSF_TOLERANCE, 0},
{557, 1251462432u, 3171021770u, 3204838869u, 0, COSF_TOLERANCE, 0},
{558, 3485236902u, 980772835u, 3172410705u, 0, COSF_TOLERANCE, 0},
{559, 3262169538u, 1268270462u, 3210791428u, 0, COSF_TOLERANCE, 0},
{560, 3080852256u, 994641495u, 1065353216u, 0, COSF_TOLERANCE, 0},
{561, 1022211242u, 922124181u, 1065346153u, 0, COSF_TOLERANCE, 0},
{562, 884661176u, 2985540645u, 1065353216u, 0, COSF_TOLERANCE, 0},
{563, 3071422941u, 3271100396u, 1065353216u, 0, COSF_TOLERANCE, 0},
{564, 989762529u, 3362011135u, 1065353184u, 0, COSF_TOLERANCE, 0},
{565, 1295475718u, 3212305413u, 1064649568u, 0, COSF_TOLERANCE, 0},
{566, 1002632518u, 3330388441u, 1065352919u, 0, COSF_TOLERANCE, 0},
{567, 3404372005u, 3450484255u, 3187716709u, 0, COSF_TOLERANCE, 0},
{568, 3158912530u, 3105501826u, 1065351951u, 0, COSF_TOLERANCE, 0},
{569, 1125800069u, 3256265749u, 3211461461u, 0, COSF_TOLERANCE, 0},
{570, 3138037576u, 3103365227u, 1065353178u, 0, COSF_TOLERANCE, 0},
{571, 3108384823u, 1300246663u, 1065353216u, 0, COSF_TOLERANCE, 0},
{572, 999985470u, 3409354318u, 1065353029u, 0, COSF_TOLERANCE, 0},
{573, 1189421739u, 1056599002u, 1062655041u, 0, COSF_TOLERANCE, 0},
{574, 3075182644u, 3144159778u, 1065353216u, 0, COSF_TOLERANCE, 0},
{575, 3028099649u, 3391513557u, 1065353216u, 0, COSF_TOLERANCE, 0},
{576, 3132541814u, 3444521949u, 1065353200u, 0, COSF_TOLERANCE, 0},
{577, 1164046161u, 3440635788u, 3204899255u, 0, COSF_TOLERANCE, 0},
{578, 1292596266u, 3116569667u, 3206207983u, 0, COSF_TOLERANCE, 0},
{579, 3469748379u, 3412765608u, 3209876572u, 0, COSF_TOLERANCE, 0},
{580, 1314644642u, 3123051784u, 3212183739u, 0, COSF_TOLERANCE, 0},
{581, 3399813173u, 828743798u, 3210005382u, 0, COSF_TOLERANCE, 0},
{582, 948775569u, 3485444126u, 1065353216u, 0, COSF_TOLERANCE, 0},
{583, 1034611395u, 882288581u, 1065294825u, 0, COSF_TOLERANCE, 0},
{584, 3489122735u, 3372450889u, 1062529522u, 0, COSF_TOLERANCE, 0},
{585, 1181604787u, 3363067409u, 1051301464u, 0, COSF_TOLERANCE, 0},
{586, 3059042077u, 3204983963u, 1065353216u, 0, COSF_TOLERANCE, 0},
{587, 1043691622u, 3402603223u, 1065090453u, 0, COSF_TOLERANCE, 0},
{588, 1314588083u, 856187848u, 1047604398u, 0, COSF_TOLERANCE, 0},
{589, 3141533334u, 3010142974u, 1065353144u, 0, COSF_TOLERANCE, 0},
{590, 3157534378u, 3451674717u, 1065352202u, 0, COSF_TOLERANCE, 0},
{591, 3400949680u, 3073750220u, 1031263669u, 0, COSF_TOLERANCE, 0},
{592, 3365581801u, 1175843167u, 3183136117u, 0, COSF_TOLERANCE, 0},
{593, 1110424755u, 3011308654u, 1065333876u, 0, COSF_TOLERANCE, 0},
{594, 3189917167u, 927278934u, 1065142996u, 0, COSF_TOLERANCE, 0},
{595, 969804941u, 3355439348u, 1065353215u, 0, COSF_TOLERANCE, 0},
{596, 1139120919u, 3270515074u, 1062973618u, 0, COSF_TOLERANCE, 0},
{597, 934308144u, 3118191228u, 1065353216u, 0, COSF_TOLERANCE, 0},
{598, 1220524226u, 1152648002u, 3211590558u, 0, COSF_TOLERANCE, 0},
{599, 3162548604u, 3461790298u, 1065351147u, 0, COSF_TOLERANCE, 0},
{600, 3382391700u, 3296962745u, 3184174453u, 0, COSF_TOLERANCE, 0},
{601, 1156767533u, 1088986462u, 1036918171u, 0, COSF_TOLERANCE, 0},
{602, 3079222483u, 3312324949u, 1065353216u, 0, COSF_TOLERANCE, 0},
{603, 994934087u, 967678094u, 1065353134u, 0, COSF_TOLERANCE, 0},
{604, 3185240099u, 1123403720u, 1065257467u, 0, COSF_TOLERANCE, 0},
{605, 3479873563u, 1246277393u, 3205786479u, 0, COSF_TOLERANCE, 0},
{606, 3424264117u, 3434026174u, 3212822518u, 0, COSF_TOLERANCE, 0},
{607, 3228365887u, 1216775310u, 3210266963u, 0, COSF_TOLERANCE, 0},
{608, 1035909900u, 1249532942u, 1065280512u, 0, COSF_TOLERANCE, 0},
{609, 3024951184u, 1247632131u, 1065353216u, 0, COSF_TOLERANCE, 0},
{610, 1212129651u, 3017366784u, 1064257239u, 0, COSF_TOLERANCE, 0},
{611, 3125775254u, 955826310u, 1065353211u, 0, COSF_TOLERANCE, 0},
{612, 1037464105u, 3121544932u, 1065261326u, 0, COSF_TOLERANCE, 0},
{613, 1311706596u, 1254918706u, 3206439060u, 0, COSF_TOLERANCE, 0},
{614, 918212457u, 1017468331u, 1065353216u, 0, COSF_TOLERANCE, 0},
{615, 1337315179u, 3461361185u, 3190319503u, 0, COSF_TOLERANCE, 0},
{616, 1131358407u, 3325958870u, 1064040283u, 0, COSF_TOLERANCE, 0},
{617, 1156517523u, 3343716230u, 3208051727u, 0, COSF_TOLERANCE, 0},
{618, 3210802820u, 3207408574u, 1059281629u, 0, COSF_TOLERANCE, 0},
{619, 3337499209u, 1226297264u, 3212835190u, 0, COSF_TOLERANCE, 0},
{620, 3468429030u, 3253874001u, 3192807433u, 0, COSF_TOLERANCE, 0},
{621, 3253515800u, 1189005947u, 3196174508u, 0, COSF_TOLERANCE, 0},
{622, 3055299953u, 3047908678u, 1065353216u, 0, COSF_TOLERANCE, 0},
{623, 959956547u, 876324728u, 1065353216u, 0, COSF_TOLERANCE, 0},
{624, 3425290480u, 1139193797u, 3212772076u, 0, COSF_TOLERANCE, 0},
{625, 1039917375u, 1122740999u, 1065226489u, 0, COSF_TOLERANCE, 0},
{626, 3220979495u, 3429223871u, 3200734071u, 0, COSF_TOLERANCE, 0},
{627, 1311016004u, 3334899880u, 3196914076u, 0, COSF_TOLERANCE, 0},
{628, 1128016396u, 1105151547u, 1064440802u, 0, COSF_TOLERANCE, 0},
{629, 3210335769u, 3100646155u, 1059637040u, 0, COSF_TOLERANCE, 0},
{630, 3022705759u, 3404762495u, 1065353216u, 0, COSF_TOLERANCE, 0},
{631, 1206054701u, 826010009u, 3186703559u, 0, COSF_TOLERANCE, 0},
{632, 3144504834u, 1162227076u, 1065353106u, 0, COSF_TOLERANCE, 0},
{633, 1213609983u, 919983950u, 1041951181u, 0, COSF_TOLERANCE, 0},
{634, 1246902946u, 3064047808u, 1062608718u, 0, COSF_TOLERANCE, 0},
{635, 995850843u, 1332031130u, 1065353122u, 0, COSF_TOLERANCE, 0},
{636, 3362082828u, 3374056268u, 1057834720u, 0, COSF_TOLERANCE, 0},
{637, 1029480631u, 3047777170u, 1065328884u, 0, COSF_TOLERANCE, 0},
{638, 3153568584u, 3106514232u, 1065352737u, 0, COSF_TOLERANCE, 0},
{639, 3384988527u, 3109485565u, 3212834710u, 0, COSF_TOLERANCE, 0},
{640, 1317696241u, 870681806u, 3206783984u, 0, COSF_TOLERANCE, 0},
{641, 3235395924u, 1132055244u, 1063504955u, 0, COSF_TOLERANCE, 0},
{642, 3341877624u, 2969495570u, 1059475152u, 0, COSF_TOLERANCE, 0},
{643, 1228636133u, 886552820u, 3188646051u, 0, COSF_TOLERANCE, 0},
{644, 3161654634u, 3335899347u, 1065351370u, 0, COSF_TOLERANCE, 0},
{645, 3162655243u, 3307203982u, 1065351094u, 0, COSF_TOLERANCE, 0},
{646, 1207246237u, 859223639u, 1054904154u, 0, COSF_TOLERANCE, 0},
{647, 1165476654u, 3350219111u, 1063369616u, 0, COSF_TOLERANCE, 0},
{648, 1215278023u, 3019755242u, 3198241437u, 0, COSF_TOLERANCE, 0},
{649, 1017239798u, 3438501281u, 1065349942u, 0, COSF_TOLERANCE, 0},
{650, 1149651309u, 970030475u, 1065211361u, 0, COSF_TOLERANCE, 0},
{651, 1111943722u, 3122211334u, 1062993436u, 0, COSF_TOLERANCE, 0},
{652, 1189849849u, 3382739134u, 1065290733u, 0, COSF_TOLERANCE, 0},
{653, 3204848496u, 3141519085u, 1063103336u, 0, COSF_TOLERANCE, 0},
{654, 1249758327u, 3104759211u, 1062600614u, 0, COSF_TOLERANCE, 0},
{655, 3092982276u, 3445282331u, 1065353216u, 0, COSF_TOLERANCE, 0},
{656, 1168098747u, 1316854744u, 3194302932u, 0, COSF_TOLERANCE, 0},
{657, 892549317u, 1179637545u, 1065353216u, 0, COSF_TOLERANCE, 0},
{658, 3301009024u, 3406174560u, 1023410660u, 0, COSF_TOLERANCE, 0},
{659, 3233089227u, 1212652543u, 1062170837u, 0, COSF_TOLERANCE, 0},
{660, 3218245284u, 1238873830u, 3180808519u, 0, COSF_TOLERANCE, 0},
{661, 3215981890u, 3240474694u, 1044860168u, 0, COSF_TOLERANCE, 0},
{662, 1266687209u, 3092038122u, 3203985802u, 0, COSF_TOLERANCE, 0},
{663, 3487959775u, 3331372071u, 1049182218u, 0, COSF_TOLERANCE, 0},
{664, 943645710u, 852875779u, 1065353216u, 0, COSF_TOLERANCE, 0},
{665, 3345065699u, 3282620725u, 1061200314u, 0, COSF_TOLERANCE, 0},
{666, 935847271u, 1067255804u, 1065353216u, 0, COSF_TOLERANCE, 0},
{667, 3410336089u, 1111437780u, 3212712938u, 0, COSF_TOLERANCE, 0},
{668, 3082940740u, 1336840432u, 1065353216u, 0, COSF_TOLERANCE, 0},
{669, 1141063391u, 1168908072u, 3211896554u, 0, COSF_TOLERANCE, 0},
{670, 3059263153u, 3067795684u, 1065353216u, 0, COSF_TOLERANCE, 0},
{671, 3353679791u, 897158391u, 1059472758u, 0, COSF_TOLERANCE, 0},
{672, 1001823878u, 1016826861u, 1065352955u, 0, COSF_TOLERANCE, 0},
{673, 1009130212u, 1004302940u, 1065352354u, 0, COSF_TOLERANCE, 0},
{674, 3367127535u, 943136342u, 1061178206u, 0, COSF_TOLERANCE, 0},
{675, 1032920919u, 3449126417u, 1065311113u, 0, COSF_TOLERANCE, 0},
{676, 3281952870u, 3147012185u, 3212817745u, 0, COSF_TOLERANCE, 0},
{677, 1237868497u, 3048281802u, 3211939539u, 0, COSF_TOLERANCE, 0},
{678, 1153753924u, 3322269242u, 3200943446u, 0, COSF_TOLERANCE, 0},
{679, 1120261759u, 892210998u, 3173569917u, 0, COSF_TOLERANCE, 0},
{680, 3226328360u, 3366432856u, 3212789662u, 0, COSF_TOLERANCE, 0},
{681, 3349595986u, 3251588707u, 3205275061u, 0, COSF_TOLERANCE, 0},
{682, 3166889490u, 3306023523u, 1065348468u, 0, COSF_TOLERANCE, 0},
{683, 1087750238u, 1099325523u, 1064051307u, 0, COSF_TOLERANCE, 0},
{684, 3121620061u, 3359488363u, 1065353213u, 0, COSF_TOLERANCE, 0},
{685, 1066116543u, 3072159933u, 1055676197u, 0, COSF_TOLERANCE, 0},
{686, 3210898034u, 2981803389u, 1059208147u, 0, COSF_TOLERANCE, 0},
{687, 3051923237u, 3364074347u, 1065353216u, 0, COSF_TOLERANCE, 0},
{688, 1030612298u, 3345396001u, 1065324927u, 0, COSF_TOLERANCE, 0},
{689, 1186234578u, 858134374u, 1054267135u, 0, COSF_TOLERANCE, 0},
{690, 1331680743u, 1009396165u, 3206173269u, 0, COSF_TOLERANCE, 0},
{691, 3060774997u, 1326067357u, 1065353216u, 0, COSF_TOLERANCE, 0},
{692, 887589411u, 1292305693u, 1065353216u, 0, COSF_TOLERANCE, 0},
{693, 1045232522u, 3234993273u, 1065018194u, 0, COSF_TOLERANCE, 0},
{694, 3119858470u, 962515365u, 1065353214u, 0, COSF_TOLERANCE, 0},
{695, 3349432725u, 928848003u, 3205415559u, 0, COSF_TOLERANCE, 0},
{696, 912423027u, 3184646319u, 1065353216u, 0, COSF_TOLERANCE, 0},
{697, 3228795133u, 3273940030u, 3209280997u, 0, COSF_TOLERANCE, 0},
{698, 3194674746u, 3112269709u, 1064913843u, 0, COSF_TOLERANCE, 0},
{699, 3296784303u, 3276182352u, 1056949368u, 0, COSF_TOLERANCE, 0},
{700, 965402291u, 3107104376u, 1065353215u, 0, COSF_TOLERANCE, 0},
{701, 3388153589u, 3426245389u, 3209951206u, 0, COSF_TOLERANCE, 0},
{702, 1133410485u, 3329658993u, 3205928783u, 0, COSF_TOLERANCE, 0},
{703, 3136790322u, 1088652637u, 1065353186u, 0, COSF_TOLERANCE, 0},
{704, 3369970587u, 959121458u, 3197103638u, 0, COSF_TOLERANCE, 0},
{705, 1270451568u, 928393353u, 3206261789u, 0, COSF_TOLERANCE, 0},
{706, 989498922u, 3088358419u, 1065353185u, 0, COSF_TOLERANCE, 0},
{707, 1280215674u, 3148135875u, 1063832706u, 0, COSF_TOLERANCE, 0},
{708, 1171873518u, 954709738u, 1064155935u, 0, COSF_TOLERANCE, 0},
{709, 3298258100u, 935525182u, 1050519430u, 0, COSF_TOLERANCE, 0},
{710, 3415208824u, 822843236u, 1055761783u, 0, COSF_TOLERANCE, 0},
{711, 1001897182u, 3191875320u, 1065352952u, 0, COSF_TOLERANCE, 0},
{712, 3152777939u, 3245830463u, 1065352782u, 0, COSF_TOLERANCE, 0},
{713, 985903305u, 3333087577u, 1065353197u, 0, COSF_TOLERANCE, 0},
{714, 3357328848u, 859306298u, 1065201471u, 0, COSF_TOLERANCE, 0},
{715, 982612185u, 923582663u, 1065353206u, 0, COSF_TOLERANCE, 0},
{716, 3267868136u, 1208301947u, 1061666965u, 0, COSF_TOLERANCE, 0},
{717, 3319048157u, 1172271145u, 1064637121u, 0, COSF_TOLERANCE, 0},
{718, 1144755661u, 860947435u, 3210782984u, 0, COSF_TOLERANCE, 0},
{719, 898467286u, 839254959u, 1065353216u, 0, COSF_TOLERANCE, 0},
{720, 3301461672u, 1233693827u, 1064849129u, 0, COSF_TOLERANCE, 0},
{721, 3364525678u, 3089849671u, 3212318569u, 0, COSF_TOLERANCE, 0},
{722, 931441127u, 1133424555u, 1065353216u, 0, COSF_TOLERANCE, 0},
{723, 3146660041u, 3143695961u, 1065353058u, 0, COSF_TOLERANCE, 0},
{724, 3467121799u, 3023584354u, 1065067045u, 0, COSF_TOLERANCE, 0},
{725, 1151257041u, 3084216427u, 1055307869u, 0, COSF_TOLERANCE, 0},
{726, 3097873255u, 3219266640u, 1065353216u, 0, COSF_TOLERANCE, 0},
{727, 3130670309u, 3192399254u, 1065353204u, 0, COSF_TOLERANCE, 0},
{728, 1017573824u, 3130901062u, 1065349732u, 0, COSF_TOLERANCE, 0},
{729, 1258369714u, 3462258576u, 3201969674u, 0, COSF_TOLERANCE, 0},
{730, 1216602683u, 3371396332u, 3210050328u, 0, COSF_TOLERANCE, 0},
{731, 3297265739u, 1214184410u, 3212702797u, 0, COSF_TOLERANCE, 0},
{732, 1071940738u, 3311731012u, 3193566987u, 0, COSF_TOLERANCE, 0},
{733, 922601356u, 3337171870u, 1065353216u, 0, COSF_TOLERANCE, 0},
{734, 3462285635u, 3444030332u, 3212427653u, 0, COSF_TOLERANCE, 0},
{735, 3357177805u, 1085464241u, 3207190309u, 0, COSF_TOLERANCE, 0},
{736, 3049120080u, 900832851u, 1065353216u, 0, COSF_TOLERANCE, 0},
{737, 1153863660u, 1011991342u, 1053945264u, 0, COSF_TOLERANCE, 0},
{738, 3034243695u, 917098003u, 1065353216u, 0, COSF_TOLERANCE, 0},
{739, 1249365132u, 3278686216u, 3206794534u, 0, COSF_TOLERANCE, 0},
{740, 3046215730u, 3211219980u, 1065353216u, 0, COSF_TOLERANCE, 0},
{741, 3047251716u, 1090787353u, 1065353216u, 0, COSF_TOLERANCE, 0},
{742, 3131219358u, 3471261157u, 1065353203u, 0, COSF_TOLERANCE, 0},
{743, 3222096285u, 1198013705u, 3206036104u, 0, COSF_TOLERANCE, 0},
{744, 1297708818u, 3079166173u, 3210136249u, 0, COSF_TOLERANCE, 0},
{745, 3345532722u, 3383708463u, 1037468763u, 0, COSF_TOLERANCE, 0},
{746, 3418753236u, 3481843070u, 1049116908u, 0, COSF_TOLERANCE, 0},
{747, 1277417964u, 3487506626u, 3211166061u, 0, COSF_TOLERANCE, 0},
{748, 987577257u, 1152077087u, 1065353192u, 0, COSF_TOLERANCE, 0},
{749, 3161606610u, 3190282989u, 1065351382u, 0, COSF_TOLERANCE, 0},
{750, 888030585u, 3062367380u, 1065353216u, 0, COSF_TOLERANCE, 0},
{751, 1043442869u, 3311393817u, 1065101303u, 0, COSF_TOLERANCE, 0},
{752, 3320923228u, 3464544249u, 1034266674u, 0, COSF_TOLERANCE, 0},
{753, 1337400405u, 3488844154u, 3212399289u, 0, COSF_TOLERANCE, 0},
{754, 3400348640u, 3129868490u, 3212750692u, 0, COSF_TOLERANCE, 0},
{755, 1250249095u, 1069023744u, 1064625332u, 0, COSF_TOLERANCE, 0},
{756, 3284411233u, 1173613526u, 3211360322u, 0, COSF_TOLERANCE, 0},
{757, 3020883322u, 2953622587u, 1065353216u, 0, COSF_TOLERANCE, 0},
{758, 1215968622u, 3469884568u, 3201990812u, 0, COSF_TOLERANCE, 0},
{759, 3202319550u, 819117302u, 1063779709u, 0, COSF_TOLERANCE, 0},
{760, 3061638260u, 3116222327u, 1065353216u, 0, COSF_TOLERANCE, 0},
{761, 1025404104u, 1066370251u, 1065340668u, 0, COSF_TOLERANCE, 0},
{762, 3138086437u, 3195983510u, 1065353178u, 0, COSF_TOLERANCE, 0},
{763, 3091024506u, 3456196859u, 1065353216u, 0, COSF_TOLERANCE, 0},
{764, 3362748242u, 3369843597u, 1062500671u, 0, COSF_TOLERANCE, 0},
{765, 3099671635u, 3218383623u, 1065353216u, 0, COSF_TOLERANCE, 0},
{766, 3068014841u, 2978226656u, 1065353216u, 0, COSF_TOLERANCE, 0},
{767, 1252237719u, 1121169249u, 3193168278u, 0, COSF_TOLERANCE, 0},
{768, 3327895594u, 1224511805u, 3210036731u, 0, COSF_TOLERANCE, 0},
{769, 3082454432u, 889268276u, 1065353216u, 0, COSF_TOLERANCE, 0},
{770, 3396161504u, 1182798837u, 3212737452u, 0, COSF_TOLERANCE, 0},
{771, 1099710167u, 887180181u, 1048526850u, 0, COSF_TOLERANCE, 0},
{772, 1157186482u, 1288722647u, 3207798214u, 0, COSF_TOLERANCE, 0},
{773, 1282110851u, 3176633124u, 1063172436u, 0, COSF_TOLERANCE, 0},
{774, 3477008113u, 1331845018u, 1033803075u, 0, COSF_TOLERANCE, 0},
{775, 3292127294u, 3409957764u, 3204259685u, 0, COSF_TOLERANCE, 0},
{776, 1123357102u, 3281307320u, 3212835571u, 0, COSF_TOLERANCE, 0},
{777, 1106837025u, 3088080674u, 1064643809u, 0, COSF_TOLERANCE, 0},
{778, 1049949008u, 1130799489u, 1064648250u, 0, COSF_TOLERANCE, 0},
{779, 1253017688u, 942062372u, 3202388818u, 0, COSF_TOLERANCE, 0},
{780, 1108543194u, 3281299199u, 1058438173u, 0, COSF_TOLERANCE, 0},
{781, 3087985411u, 1238341456u, 1065353216u, 0, COSF_TOLERANCE, 0},
{782, 3163283126u, 1328636961u, 1065350771u, 0, COSF_TOLERANCE, 0},
{783, 1160162706u, 1264067367u, 3211737515u, 0, COSF_TOLERANCE, 0},
{784, 3305715025u, 3017496063u, 3209506661u, 0, COSF_TOLERANCE, 0},
{785, 1266928623u, 811778614u, 1059902219u, 0, COSF_TOLERANCE, 0},
{786, 3025340297u, 1193925540u, 1065353216u, 0, COSF_TOLERANCE, 0},
{787, 3438080027u, 3107114149u, 3212289015u, 0, COSF_TOLERANCE, 0},
{788, 3344574751u, 3111270744u, 3204718571u, 0, COSF_TOLERANCE, 0},
{789, 1152416724u, 962669179u, 3196823613u, 0, COSF_TOLERANCE, 0},
{790, 1218239308u, 1126238113u, 3200397114u, 0, COSF_TOLERANCE, 0},
{791, 3263310567u, 1030748197u, 3206623965u, 0, COSF_TOLERANCE, 0},
{792, 3041998669u, 1160635263u, 1065353216u, 0, COSF_TOLERANCE, 0},
{793, 1000313118u, 2980130729u, 1065353017u, 0, COSF_TOLERANCE, 0},
{794, 972485427u, 1124312043u, 1065353214u, 0, COSF_TOLERANCE, 0},
{795, 3290264612u, 1124703898u, 1033417520u, 0, COSF_TOLERANCE, 0},
{796, 3222106584u, 1183748648u, 3206069195u, 0, COSF_TOLERANCE, 0},
{797, 1278946388u, 825129857u, 3207337564u, 0, COSF_TOLERANCE, 0},
{798, 947914771u, 3181847068u, 1065353216u, 0, COSF_TOLERANCE, 0},
{799, 3167730654u, 3195765940u, 1065347822u, 0, COSF_TOLERANCE, 0},
{800, 1098530298u, 3255870890u, 3212798281u, 0, COSF_TOLERANCE, 0},
{801, 3232726036u, 871038882u, 1060273352u, 0, COSF_TOLERANCE, 0},
{802, 1297190916u, 811863044u, 1049557645u, 0, COSF_TOLERANCE, 0},
{803, 1277649137u, 961171401u, 3186874497u, 0, COSF_TOLERANCE, 0},
{804, 3203377685u, 1306427476u, 1063548485u, 0, COSF_TOLERANCE, 0},
{805, 3090306474u, 3124785016u, 1065353216u, 0, COSF_TOLERANCE, 0},
{806, 3244032016u, 3045313345u, 1052855950u, 0, COSF_TOLERANCE, 0},
{807, 3033122376u, 3049877065u, 1065353216u, 0, COSF_TOLERANCE, 0},
{808, 1096155623u, 1256423752u, 1060154871u, 0, COSF_TOLERANCE, 0},
{809, 873151908u, 3246562559u, 1065353216u, 0, COSF_TOLERANCE, 0},
{810, 3238729605u, 1298769842u, 3208544401u, 0, COSF_TOLERANCE, 0},
{811, 3317196817u, 989537151u, 1055488317u, 0, COSF_TOLERANCE, 0},
{812, 3374748510u, 834161190u, 3211766708u, 0, COSF_TOLERANCE, 0},
{813, 3345634950u, 959901149u, 1047810758u, 0, COSF_TOLERANCE, 0},
{814, 3189860276u, 883598767u, 1065145234u, 0, COSF_TOLERANCE, 0},
{815, 887311687u, 1175312255u, 1065353216u, 0, COSF_TOLERANCE, 0},
{816, 3396917283u, 3066326686u, 1065330581u, 0, COSF_TOLERANCE, 0},
{817, 3317032737u, 3143803722u, 3210940381u, 0, COSF_TOLERANCE, 0},
{818, 1200051436u, 1163802508u, 1054691063u, 0, COSF_TOLERANCE, 0},
{819, 3105291012u, 1194385202u, 1065353216u, 0, COSF_TOLERANCE, 0},
{820, 1306520561u, 957302464u, 3202730728u, 0, COSF_TOLERANCE, 0},
{821, 1314936356u, 2985592532u, 1059259508u, 0, COSF_TOLERANCE, 0},
{822, 3475052219u, 1284049853u, 3212731294u, 0, COSF_TOLERANCE, 0},
{823, 3085636260u, 1107682820u, 1065353216u, 0, COSF_TOLERANCE, 0},
{824, 3393227708u, 3271879112u, 3212746551u, 0, COSF_TOLERANCE, 0},
{825, 3182540197u, 852580839u, 1065290094u, 0, COSF_TOLERANCE, 0},
{826, 3349005404u, 3080993030u, 1065287645u, 0, COSF_TOLERANCE, 0},
{827, 3154720153u, 3443720494u, 1065352628u, 0, COSF_TOLERANCE, 0},
{828, 1262863321u, 1219003129u, 1062939840u, 0, COSF_TOLERANCE, 0},
{829, 882902102u, 1224362550u, 1065353216u, 0, COSF_TOLERANCE, 0},
{830, 1053387478u, 3184880021u, 1064071666u, 0, COSF_TOLERANCE, 0},
{831, 3387653691u, 3347783852u, 3143612867u, 0, COSF_TOLERANCE, 0},
{832, 3136364836u, 1018492227u, 1065353188u, 0, COSF_TOLERANCE, 0},
{833, 1338680611u, 1166078045u, 3211297596u, 0, COSF_TOLERANCE, 0},
{834, 1112891928u, 3074730425u, 3212805372u, 0, COSF_TOLERANCE, 0},
{835, 893449284u, 1052877339u, 1065353216u, 0, COSF_TOLERANCE, 0},
{836, 892311459u, 1097338393u, 1065353216u, 0, COSF_TOLERANCE, 0},
{837, 3105373037u, 3246705916u, 1065353216u, 0, COSF_TOLERANCE, 0},
{838, 1190105283u, 3033907262u, 3208837018u, 0, COSF_TOLERANCE, 0},
{839, 1011225926u, 1180485180u, 1065351990u, 0, COSF_TOLERANCE, 0},
{840, 1043025031u, 987068973u, 1065119016u, 0, COSF_TOLERANCE, 0},
{841, 3410531037u, 2953541915u, 3210684265u, 0, COSF_TOLERANCE, 0},
{842, 3125834184u, 896953754u, 1065353211u, 0, COSF_TOLERANCE, 0},
{843, 902318189u, 849277289u, 1065353216u, 0, COSF_TOLERANCE, 0},
{844, 3213624815u, 2987148017u, 1055588756u, 0, COSF_TOLERANCE, 0},
{845, 1120888322u, 1086209113u, 3212830895u, 0, COSF_TOLERANCE, 0},
{846, 1315217243u, 3396371713u, 3205739778u, 0, COSF_TOLERANCE, 0},
{847, 3137758475u, 1039403054u, 1065353181u, 0, COSF_TOLERANCE, 0},
{848, 1040617590u, 1034835971u, 1065208564u, 0, COSF_TOLERANCE, 0},
{849, 955384253u, 3344785562u, 1065353216u, 0, COSF_TOLERANCE, 0},
{850, 3061417900u, 1172208065u, 1065353216u, 0, COSF_TOLERANCE, 0},
{851, 904255535u, 1019967545u, 1065353216u, 0, COSF_TOLERANCE, 0},
{852, 1022984119u, 3113891410u, 1065345435u, 0, COSF_TOLERANCE, 0},
{853, 997362368u, 3112875428u, 1065353101u, 0, COSF_TOLERANCE, 0},
{854, 900933520u, 1100589187u, 1065353216u, 0, COSF_TOLERANCE, 0},
{855, 1168623062u, 1143306482u, 3212305490u, 0, COSF_TOLERANCE, 0},
{856, 878737490u, 3269908326u, 1065353216u, 0, COSF_TOLERANCE, 0},
{857, 1039827284u, 1072928888u, 1065227867u, 0, COSF_TOLERANCE, 0},
{858, 1021564080u, 1064468397u, 1065346728u, 0, COSF_TOLERANCE, 0},
{859, 3458669745u, 3033299853u, 3207192275u, 0, COSF_TOLERANCE, 0},
{860, 3327516316u, 3405380971u, 3212243066u, 0, COSF_TOLERANCE, 0},
{861, 1040711112u, 3229444200u, 1065205484u, 0, COSF_TOLERANCE, 0},
{862, 1134528351u, 3365952513u, 1044204722u, 0, COSF_TOLERANCE, 0},
{863, 3039884464u, 1170612785u, 1065353216u, 0, COSF_TOLERANCE, 0},
{864, 3414352838u, 3350285760u, 1065213072u, 0, COSF_TOLERANCE, 0},
{865, 1133689539u, 1067460093u, 3196938746u, 0, COSF_TOLERANCE, 0},
{866, 3455688478u, 3333091960u, 3170953053u, 0, COSF_TOLERANCE, 0},
{867, 1137634874u, 1137038869u, 1059909857u, 0, COSF_TOLERANCE, 0},
{868, 3415502662u, 955510692u, 3207324162u, 0, COSF_TOLERANCE, 0},
{869, 954999730u, 969618597u, 1065353216u, 0, COSF_TOLERANCE, 0},
{870, 1066157309u, 3241712664u, 1055531362u, 0, COSF_TOLERANCE, 0},
{871, 3436353675u, 1174967495u, 1062525851u, 0, COSF_TOLERANCE, 0},
{872, 940437609u, 860372396u, 1065353216u, 0, COSF_TOLERANCE, 0},
{873, 3108347547u, 3434003435u, 1065353216u, 0, COSF_TOLERANCE, 0},
{874, 3064200154u, 3158080507u, 1065353216u, 0, COSF_TOLERANCE, 0},
{875, 1023889593u, 2979304683u, 1065344062u, 0, COSF_TOLERANCE, 0},
{876, 3272661536u, 3461799138u, 1064399564u, 0, COSF_TOLERANCE, 0},
{877, 1170245333u, 1233406410u, 3212532373u, 0, COSF_TOLERANCE, 0},
{878, 1219052056u, 3369557946u, 3210290288u, 0, COSF_TOLERANCE, 0},
{879, 3318983619u, 3259663338u, 1065030505u, 0, COSF_TOLERANCE, 0},
{880, 3372118621u, 837597103u, 3179313840u, 0, COSF_TOLERANCE, 0},
{881, 3146190320u, 889646054u, 1065353074u, 0, COSF_TOLERANCE, 0},
{882, 1299683827u, 966031619u, 3212569447u, 0, COSF_TOLERANCE, 0},
{883, 3190796331u, 1320011850u, 1065106891u, 0, COSF_TOLERANCE, 0},
{884, 3086068902u, 3484245751u, 1065353216u, 0, COSF_TOLERANCE, 0},
{885, 3064155399u, 3176569312u, 1065353216u, 0, COSF_TOLERANCE, 0},
{886, 3040314717u, 1071290674u, 1065353216u, 0, COSF_TOLERANCE, 0},
{887, 3257224022u, 3361778245u, 3210918690u, 0, COSF_TOLERANCE, 0},
{888, 1229268598u, 1066965677u, 1065119672u, 0, COSF_TOLERANCE, 0},
{889, 3184078812u, 871003709u, 1065272329u, 0, COSF_TOLERANCE, 0},
{890, 1086717248u, 3423795374u, 1065275932u, 0, COSF_TOLERANCE, 0},
{891, 3434884607u, 3029593823u, 3211446397u, 0, COSF_TOLERANCE, 0},
{892, 3464955606u, 1017987696u, 3209420100u, 0, COSF_TOLERANCE, 0},
{893, 1025278524u, 3121856207u, 1065340970u, 0, COSF_TOLERANCE, 0},
{894, 1242829722u, 3233935671u, 3205152024u, 0, COSF_TOLERANCE, 0},
{895, 3075149137u, 1117325737u, 1065353216u, 0, COSF_TOLERANCE, 0},
{896, 1200927971u, 1317167489u, 3197436878u, 0, COSF_TOLERANCE, 0},
{897, 3326858092u, 3452602832u, 1058159947u, 0, COSF_TOLERANCE, 0},
{898, 1246019790u, 850632217u, 3211310879u, 0, COSF_TOLERANCE, 0},
{899, 3184801644u, 1137974313u, 1065263225u, 0, COSF_TOLERANCE, 0},
{900, 1136052740u, 3244616020u, 1053786700u, 0, COSF_TOLERANCE, 0},
{901, 1069009211u, 3002507482u, 1040828843u, 0, COSF_TOLERANCE, 0},
{902, 1015670780u, 1101217251u, 1065350839u, 0, COSF_TOLERANCE, 0},
{903, 1012543234u, 1116520440u, 1065351728u, 0, COSF_TOLERANCE, 0},
{904, 3316611992u, 3394732912u, 3189155062u, 0, COSF_TOLERANCE, 0},
{905, 1087942795u, 3316660295u, 1063391976u, 0, COSF_TOLERANCE, 0},
{906, 3426365713u, 3069778532u, 1063585819u, 0, COSF_TOLERANCE, 0},
{907, 3066654389u, 3443934204u, 1065353216u, 0, COSF_TOLERANCE, 0},
{908, 3295326432u, 1313396175u, 3210161438u, 0, COSF_TOLERANCE, 0},
{909, 3318835308u, 3277583511u, 3212826231u, 0, COSF_TOLERANCE, 0},
{910, 3283555717u, 891875120u, 3190806489u, 0, COSF_TOLERANCE, 0},
{911, 3381255420u, 3015406047u, 3199347701u, 0, COSF_TOLERANCE, 0},
{912, 3040485181u, 3375450886u, 1065353216u, 0, COSF_TOLERANCE, 0},
{913, 3388772093u, 1032597076u, 1058319659u, 0, COSF_TOLERANCE, 0},
{914, 954670189u, 1144923689u, 1065353216u, 0, COSF_TOLERANCE, 0},
{915, 1319200415u, 3387555900u, 3212404062u, 0, COSF_TOLERANCE, 0},
{916, 1279324488u, 3228401212u, 3198691552u, 0, COSF_TOLERANCE, 0},
{917, 3217795424u, 865577227u, 3165019754u, 0, COSF_TOLERANCE, 0},
{918, 3455131757u, 1260217257u, 3212759112u, 0, COSF_TOLERANCE, 0},
{919, 1246947517u, 1087951909u, 3212751459u, 0, COSF_TOLERANCE, 0},
{920, 3396723577u, 869285240u, 3199745081u, 0, COSF_TOLERANCE, 0},
{921, 3433761025u, 3060143904u, 3209669423u, 0, COSF_TOLERANCE, 0},
{922, 3201187455u, 900233172u, 1064010350u, 0, COSF_TOLERANCE, 0},
{923, 1173247961u, 1191127979u, 1060192306u, 0, COSF_TOLERANCE, 0},
{924, 3037297123u, 3346394818u, 1065353216u, 0, COSF_TOLERANCE, 0},
{925, 3248534678u, 1323683800u, 1051129506u, 0, COSF_TOLERANCE, 0},
{926, 3083019343u, 3033309444u, 1065353216u, 0, COSF_TOLERANCE, 0},
{927, 3042018375u, 3203882372u, 1065353216u, 0, COSF_TOLERANCE, 0},
{928, 1082862511u, 3032804719u, 3199595173u, 0, COSF_TOLERANCE, 0},
{929, 3157626955u, 3483653298u, 1065352186u, 0, COSF_TOLERANCE, 0},
{930, 1341821683u, 3003675365u, 1031799938u, 0, COSF_TOLERANCE, 0},
{931, 881101379u, 1190838126u, 1065353216u, 0, COSF_TOLERANCE, 0},
{932, 1079061705u, 2960507663u, 3212702243u, 0, COSF_TOLERANCE, 0},
{933, 3182695954u, 3256861672u, 1065288396u, 0, COSF_TOLERANCE, 0},
{934, 1105291533u, 3482971524u, 3212756299u, 0, COSF_TOLERANCE, 0},
{935, 1016023520u, 3227712090u, 1065350650u, 0, COSF_TOLERANCE, 0},
{936, 3370691006u, 1295870514u, 3207194610u, 0, COSF_TOLERANCE, 0},
{937, 1156767169u, 1049756240u, 1041511887u, 0, COSF_TOLERANCE, 0},
{938, 3077020499u, 894671462u, 1065353216u, 0, COSF_TOLERANCE, 0},
{939, 1104284039u, 3040211914u, 1054748732u, 0, COSF_TOLERANCE, 0},
{940, 3335212901u, 3486414589u, 1050567781u, 0, COSF_TOLERANCE, 0},
{941, 1093697541u, 3193708441u, 1024597442u, 0, COSF_TOLERANCE, 0},
{942, 3266691185u, 1160074593u, 3212393816u, 0, COSF_TOLERANCE, 0},
{943, 3179003144u, 1108615803u, 1065321540u, 0, COSF_TOLERANCE, 0},
{944, 1094115255u, 3008610212u, 1054298469u, 0, COSF_TOLERANCE, 0},
{945, 3424086808u, 3260140004u, 1062663944u, 0, COSF_TOLERANCE, 0},
{946, 3353608773u, 1134068114u, 1057011823u, 0, COSF_TOLERANCE, 0},
{947, 973664327u, 1319516167u, 1065353214u, 0, COSF_TOLERANCE, 0},
{948, 882878091u, 3136970767u, 1065353216u, 0, COSF_TOLERANCE, 0},
{949, 1098662266u, 833740182u, 3212808631u, 0, COSF_TOLERANCE, 0},
{950, 927582555u, 947955456u, 1065353216u, 0, COSF_TOLERANCE, 0},
{951, 3111440310u, 3067634077u, 1065353216u, 0, COSF_TOLERANCE, 0},
{952, 3476083859u, 966439623u, 3212788520u, 0, COSF_TOLERANCE, 0},
{953, 3038754840u, 932009686u, 1065353216u, 0, COSF_TOLERANCE, 0},
{954, 979878744u, 1232482646u, 1065353209u, 0, COSF_TOLERANCE, 0},
{955, 3464546616u, 3205527253u, 3177740345u, 0, COSF_TOLERANCE, 0},
{956, 1002542205u, 3152136093u, 1065352923u, 0, COSF_TOLERANCE, 0},
{957, 3443552129u, 3165561391u, 3212354566u, 0, COSF_TOLERANCE, 0},
{958, 1287620154u, 3119707283u, 1055090182u, 0, COSF_TOLERANCE, 0},
{959, 946058434u, 1249928879u, 1065353216u, 0, COSF_TOLERANCE, 0},
{960, 3073260205u, 3093124531u, 1065353216u, 0, COSF_TOLERANCE, 0},
{961, 1245702957u, 894348966u, 1064624749u, 0, COSF_TOLERANCE, 0},
{962, 989655126u, 1308376568u, 1065353185u, 0, COSF_TOLERANCE, 0},
{963, 1002715618u, 1191006977u, 1065352915u, 0, COSF_TOLERANCE, 0},
{964, 3087802274u, 897541752u, 1065353216u, 0, COSF_TOLERANCE, 0},
{965, 1000863905u, 1196831314u, 1065352996u, 0, COSF_TOLERANCE, 0},
{966, 3415763001u, 3032518431u, 1057972712u, 0, COSF_TOLERANCE, 0},
{967, 3283471961u, 1260093226u, 1060111540u, 0, COSF_TOLERANCE, 0},
{968, 3311210827u, 1192192264u, 1064321527u, 0, COSF_TOLERANCE, 0},
{969, 3026311911u, 2968974374u, 1065353216u, 0, COSF_TOLERANCE, 0},
{970, 1198307901u, 1116328249u, 1058793373u, 0, COSF_TOLERANCE, 0},
{971, 1288901567u, 1296370667u, 1060913244u, 0, COSF_TOLERANCE, 0},
{972, 922255363u, 958305289u, 1065353216u, 0, COSF_TOLERANCE, 0},
{973, 1113104661u, 944376032u, 3208332702u, 0, COSF_TOLERANCE, 0},
{974, 1136714348u, 828849087u, 3209446366u, 0, COSF_TOLERANCE, 0},
{975, 948856035u, 1015466475u, 1065353216u, 0, COSF_TOLERANCE, 0},
{976, 1062512367u, 3229559531u, 1059890212u, 0, COSF_TOLERANCE, 0},
{977, 3486907092u, 823220784u, 1060681519u, 0, COSF_TOLERANCE, 0},
{978, 1162027071u, 3308983387u, 1061103464u, 0, COSF_TOLERANCE, 0},
{979, 1034561811u, 1054043114u, 1065295340u, 0, COSF_TOLERANCE, 0},
{980, 3271615417u, 3209997200u, 3212777366u, 0, COSF_TOLERANCE, 0},
{981, 1042014529u, 1146708584u, 1065159203u, 0, COSF_TOLERANCE, 0},
{982, 1177157787u, 3090208179u, 3207554300u, 0, COSF_TOLERANCE, 0},
{983, 3196144817u, 1056118717u, 1064821065u, 0, COSF_TOLERANCE, 0},
{984, 3432084552u, 2997091781u, 3201706790u, 0, COSF_TOLERANCE, 0},
{985, 1309658335u, 1010219988u, 3210696537u, 0, COSF_TOLERANCE, 0},
{986, 1226494979u, 2991604792u, 3189793814u, 0, COSF_TOLERANCE, 0},
{987, 3100289712u, 3456334210u, 1065353216u, 0, COSF_TOLERANCE, 0},
{988, 3375507013u, 1306310823u, 3210320892u, 0, COSF_TOLERANCE, 0},
{989, 3460699001u, 3096700943u, 3131659669u, 0, COSF_TOLERANCE, 0},
{990, 3079231719u, 1044386263u, 1065353216u, 0, COSF_TOLERANCE, 0},
{991, 3093951884u, 1014115231u, 1065353216u, 0, COSF_TOLERANCE, 0},
{992, 3468023178u, 1209565017u, 1039445927u, 0, COSF_TOLERANCE, 0},
{993, 1204196034u, 3298625731u, 1049351518u, 0, COSF_TOLERANCE, 0},
{994, 3459877411u, 2960476959u, 1040321054u, 0, COSF_TOLERANCE, 0},
{995, 909696559u, 1163075690u, 1065353216u, 0, COSF_TOLERANCE, 0},
{996, 1161439847u, 943449277u, 1063892963u, 0, COSF_TOLERANCE, 0},
{997, 908663107u, 939489763u, 1065353216u, 0, COSF_TOLERANCE, 0},
{998, 1055319316u, 3261813492u, 1063675936u, 0, COSF_TOLERANCE, 0},
{999, 1084378658u, 1009650785u, 1051996722u, 0, COSF_TOLERANCE, 0},
{1000, 3053887750u, 3341786453u, 1065353216u, 0, COSF_TOLERANCE, 0},
{1001, 3022828828u, 881335251u, 1065353216u, 0, COSF_TOLERANCE, 0},
{1002, 1226473697u, 821025132u, 3210808958u, 0, COSF_TOLERANCE, 0},
{1003, 1123114742u, 1229815537u, 1049003021u, 0, COSF_TOLERANCE, 0},
{1004, 1258114435u, 1291336083u, 1063128407u, 0, COSF_TOLERANCE, 0},
{1005, 3468040845u, 3066966245u, 3209603439u, 0, COSF_TOLERANCE, 0},
{1006, 1178825761u, 1113195286u, 1060387901u, 0, COSF_TOLERANCE, 0},
{1007, 3059266302u, 878503862u, 1065353216u, 0, COSF_TOLERANCE, 0},
{1008, 3223384012u, 1130486973u, 3209646119u, 0, COSF_TOLERANCE, 0},
{1009, 1019964626u, 1235133609u, 1065348044u, 0, COSF_TOLERANCE, 0},
{1010, 3445262427u, 3465211174u, 3207388524u, 0, COSF_TOLERANCE, 0},
{1011, 1125653081u, 1207799746u, 1048953689u, 0, COSF_TOLERANCE, 0},
{1012, 3337652712u, 3025581813u, 1046815450u, 0, COSF_TOLERANCE, 0},
{1013, 1184753508u, 3147374485u, 1048780362u, 0, COSF_TOLERANCE, 0},
{1014, 996404791u, 3353251979u, 1065353115u, 0, COSF_TOLERANCE, 0},
{1015, 1188439315u, 1113484271u, 3212669878u, 0, COSF_TOLERANCE, 0},
{1016, 906557513u, 3006513432u, 1065353216u, 0, COSF_TOLERANCE, 0},
{1017, 916831283u, 999465787u, 1065353216u, 0, COSF_TOLERANCE, 0},
{1018, 996786317u, 3179221951u, 1065353109u, 0, COSF_TOLERANCE, 0},
{1019, 3461635065u, 1004690387u, 1059256339u, 0, COSF_TOLERANCE, 0},
{1020, 1188167943u, 1200744896u, 1056968528u, 0, COSF_TOLERANCE, 0},
{1021, 3036502395u, 1172597364u, 1065353216u, 0, COSF_TOLERANCE, 0},
{1022, 891257783u, 1267560050u, 1065353216u, 0, COSF_TOLERANCE, 0},
{1023, 3290079438u, 846519377u, 3211632704u, 0, COSF_TOLERANCE, 0},
{1024, 3350690327u, 2967953392u, 1064717520u, 0, COSF_TOLERANCE, 0},
{1025, 1102061604u, 3424449935u, 3212831810u, 0, COSF_TOLERANCE, 0},
{1026, 1282351521u, 3039376424u, 3206969204u, 0, COSF_TOLERANCE, 0},
{1027, 3458861065u, 3392466405u, 1061025076u, 0, COSF_TOLERANCE, 0},
{1028, 3095256878u, 1023623326u, 1065353216u, 0, COSF_TOLERANCE, 0},
{1029, 3163373610u, 843150426u, 1065350722u, 0, COSF_TOLERANCE, 0},
{1030, 3228793330u, 855146890u, 3209285436u, 0, COSF_TOLERANCE, 0},
{1031, 3422194733u, 893873945u, 3189571899u, 0, COSF_TOLERANCE, 0},
{1032, 3083885296u, 974543672u, 1065353216u, 0, COSF_TOLERANCE, 0},
{1033, 1261940623u, 3402349985u, 1059371925u, 0, COSF_TOLERANCE, 0},
{1034, 3400603081u, 3234396843u, 3194979617u, 0, COSF_TOLERANCE, 0},
{1035, 1219411812u, 2961857939u, 1059936718u, 0, COSF_TOLERANCE, 0},
{1036, 3094833770u, 805351108u, 1065353216u, 0, COSF_TOLERANCE, 0},
{1037, 3139250800u, 3079109479u, 1065353168u, 0, COSF_TOLERANCE, 0},
{1038, 886201503u, 3272760705u, 1065353216u, 0, COSF_TOLERANCE, 0},
{1039, 3297366026u, 1089966380u, 3212509727u, 0, COSF_TOLERANCE, 0},
{1040, 1218488455u, 3309646450u, 3212486799u, 0, COSF_TOLERANCE, 0},
{1041, 3040358923u, 3093401553u, 1065353216u, 0, COSF_TOLERANCE, 0},
{1042, 1283938137u, 1196383822u, 3212578488u, 0, COSF_TOLERANCE, 0},
{1043, 3182551696u, 3029982441u, 1065289970u, 0, COSF_TOLERANCE, 0},
{1044, 1317098613u, 949986176u, 3192636969u, 0, COSF_TOLERANCE, 0},
{1045, 3116209179u, 3303588342u, 1065353215u, 0, COSF_TOLERANCE, 0},
{1046, 3431703657u, 3014443710u, 1061837671u, 0, COSF_TOLERANCE, 0},
{1047, 3239728775u, 927815421u, 3212427544u, 0, COSF_TOLERANCE, 0},
{1048, 3207141672u, 933456504u, 1061824313u, 0, COSF_TOLERANCE, 0},
{1049, 3154378805u, 905462392u, 1065352671u, 0, COSF_TOLERANCE, 0},
{1050, 3069658155u, 1041452042u, 1065353216u, 0, COSF_TOLERANCE, 0},
{1051, 3313160088u, 2964063309u, 3201046321u, 0, COSF_TOLERANCE, 0},
{1052, 3207056527u, 3384206601u, 1061876382u, 0, COSF_TOLERANCE, 0},
{1053, 1284174954u, 3436881197u, 3197483672u, 0, COSF_TOLERANCE, 0},
{1054, 3156081645u, 3308839704u, 1065352436u, 0, COSF_TOLERANCE, 0},
{1055, 1063693032u, 976661408u, 1058991141u, 0, COSF_TOLERANCE, 0},
{1056, 3036026175u, 1251203998u, 1065353216u, 0, COSF_TOLERANCE, 0},
{1057, 1102631663u, 3396951425u, 3202535888u, 0, COSF_TOLERANCE, 0},
{1058, 968803479u, 992989712u, 1065353215u, 0, COSF_TOLERANCE, 0},
{1059, 3273080388u, 3109405906u, 1063706432u, 0, COSF_TOLERANCE, 0},
{1060, 1172529774u, 3294550127u, 1064186558u, 0, COSF_TOLERANCE, 0},
{1061, 1306695905u, 1292690378u, 3204586469u, 0, COSF_TOLERANCE, 0},
{1062, 1003649752u, 1218792138u, 1065352870u, 0, COSF_TOLERANCE, 0},
{1063, 1078478376u, 1326246424u, 3212835593u, 0, COSF_TOLERANCE, 0},
{1064, 3158855023u, 3151283866u, 1065351962u, 0, COSF_TOLERANCE, 0},
{1065, 1165177679u, 3276237026u, 3198996477u, 0, COSF_TOLERANCE, 0},
{1066, 3403009513u, 3381966453u, 1064112873u, 0, COSF_TOLERANCE, 0},
{1067, 952348506u, 3377573987u, 1065353216u, 0, COSF_TOLERANCE, 0},
{1068, 1222777442u, 1125769920u, 1059372175u, 0, COSF_TOLERANCE, 0},
{1069, 1325324763u, 978336043u, 3210385803u, 0, COSF_TOLERANCE, 0},
{1070, 3363524213u, 3202991311u, 3210370597u, 0, COSF_TOLERANCE, 0},
{1071, 1158950321u, 1073578913u, 3204454895u, 0, COSF_TOLERANCE, 0},
{1072, 903129873u, 3416864271u, 1065353216u, 0, COSF_TOLERANCE, 0},
{1073, 3078339944u, 988173985u, 1065353216u, 0, COSF_TOLERANCE, 0},
{1074, 1208345407u, 1254181270u, 3197912734u, 0, COSF_TOLERANCE, 0},
{1075, 1258634105u, 1247426200u, 3212159515u, 0, COSF_TOLERANCE, 0},
{1076, 1248478509u, 1287895126u, 1013250315u, 0, COSF_TOLERANCE, 0},
{1077, 1153863988u, 3430539165u, 1055159277u, 0, COSF_TOLERANCE, 0},
{1078, 1235620969u, 866627358u, 3197807963u, 0, COSF_TOLERANCE, 0},
{1079, 1097120930u, 3221726305u, 3189900284u, 0, COSF_TOLERANCE, 0},
{1080, 3469778622u, 1200179013u, 3177965590u, 0, COSF_TOLERANCE, 0},
{1081, 1147712200u, 931865525u, 1059239330u, 0, COSF_TOLERANCE, 0},
{1082, 1124721745u, 3058969650u, 1064402756u, 0, COSF_TOLERANCE, 0},
{1083, 3261744304u, 1043806501u, 3202193916u, 0, COSF_TOLERANCE, 0},
{1084, 1064922416u, 1320485628u, 1058000246u, 0, COSF_TOLERANCE, 0},
{1085, 3303160152u, 3075455322u, 1064893552u, 0, COSF_TOLERANCE, 0},
{1086, 1315090496u, 3269683237u, 1065335705u, 0, COSF_TOLERANCE, 0},
{1087, 3230403187u, 1322841992u, 3198737980u, 0, COSF_TOLERANCE, 0},
{1088, 1335399673u, 974138676u, 1063062969u, 0, COSF_TOLERANCE, 0},
{1089, 1072458508u, 3372833993u, 3196822050u, 0, COSF_TOLERANCE, 0},
{1090, 3303015249u, 3015039539u, 1043481079u, 0, COSF_TOLERANCE, 0},
{1091, 3252139741u, 1059615003u, 3196321587u, 0, COSF_TOLERANCE, 0},
{1092, 3468519966u, 3113982619u, 3181119723u, 0, COSF_TOLERANCE, 0},
{1093, 1006231203u, 897530770u, 1065352728u, 0, COSF_TOLERANCE, 0},
{1094, 951554138u, 1001144381u, 1065353216u, 0, COSF_TOLERANCE, 0},
{1095, 942046828u, 986341002u, 1065353216u, 0, COSF_TOLERANCE, 0},
{1096, 3319723279u, 3414482416u, 3212789186u, 0, COSF_TOLERANCE, 0},
{1097, 3255104167u, 928827688u, 3195901186u, 0, COSF_TOLERANCE, 0},
{1098, 1155477903u, 3104812800u, 1054683158u, 0, COSF_TOLERANCE, 0},
{1099, 3273889176u, 980486479u, 1064943212u, 0, COSF_TOLERANCE, 0},
{1100, 3237813668u, 3441016803u, 3177499355u, 0, COSF_TOLERANCE, 0},
{1101, 1228207362u, 2985476579u, 3204716343u, 0, COSF_TOLERANCE, 0},
{1102, 975349337u, 1311932596u, 1065353213u, 0, COSF_TOLERANCE, 0},
{1103, 1290175785u, 3008182462u, 3207719515u, 0, COSF_TOLERANCE, 0},
{1104, 981908840u, 3314038398u, 1065353207u, 0, COSF_TOLERANCE, 0},
{1105, 941187647u, 1107765599u, 1065353216u, 0, COSF_TOLERANCE, 0},
{1106, 1214223128u, 3225536822u, 1065333862u, 0, COSF_TOLERANCE, 0},
{1107, 3422922584u, 1086391131u, 1063595800u, 0, COSF_TOLERANCE, 0},
{1108, 1315857601u, 3487600045u, 3207921796u, 0, COSF_TOLERANCE, 0},
{1109, 3453226030u, 3233768835u, 3211093747u, 0, COSF_TOLERANCE, 0},
{1110, 1078359574u, 3199175230u, 3212823014u, 0, COSF_TOLERANCE, 0},
{1111, 1029557624u, 3302959071u, 1065328624u, 0, COSF_TOLERANCE, 0},
{1112, 1207675424u, 3042692550u, 3212587330u, 0, COSF_TOLERANCE, 0},
{1113, 1028355074u, 3442294040u, 1065332524u, 0, COSF_TOLERANCE, 0},
{1114, 3119299090u, 1187096397u, 1065353214u, 0, COSF_TOLERANCE, 0},
{1115, 1248421894u, 3367769132u, 1061302737u, 0, COSF_TOLERANCE, 0},
{1116, 3353251994u, 1095517730u, 1046208216u, 0, COSF_TOLERANCE, 0},
{1117, 876926659u, 3288089977u, 1065353216u, 0, COSF_TOLERANCE, 0},
{1118, 1076752219u, 876236939u, 3211352228u, 0, COSF_TOLERANCE, 0},
{1119, 3388531942u, 2988520062u, 3212836555u, 0, COSF_TOLERANCE, 0},
{1120, 1273395082u, 3031189261u, 1064835354u, 0, COSF_TOLERANCE, 0},
{1121, 3385588183u, 3258252464u, 3189580137u, 0, COSF_TOLERANCE, 0},
{1122, 3192315328u, 3289489214u, 1065037827u, 0, COSF_TOLERANCE, 0},
{1123, 3441804648u, 3274638356u, 3194945623u, 0, COSF_TOLERANCE, 0},
{1124, 3392827417u, 1277961150u, 3210261568u, 0, COSF_TOLERANCE, 0},
{1125, 1161241793u, 1328003707u, 3207641762u, 0, COSF_TOLERANCE, 0},
{1126, 3034494183u, 3041579130u, 1065353216u, 0, COSF_TOLERANCE, 0},
{1127, 1171318485u, 3374409104u, 1063645118u, 0, COSF_TOLERANCE, 0},
{1128, 3047748143u, 831102792u, 1065353216u, 0, COSF_TOLERANCE, 0},
{1129, 1001216371u, 3052357038u, 1065352981u, 0, COSF_TOLERANCE, 0},
{1130, 912515889u, 1074635609u, 1065353216u, 0, COSF_TOLERANCE, 0},
{1131, 3391452505u, 897989232u, 3209655482u, 0, COSF_TOLERANCE, 0},
{1132, 3249603369u, 3147662248u, 3212683322u, 0, COSF_TOLERANCE, 0},
{1133, 1220264047u, 2960450369u, 3212372154u, 0, COSF_TOLERANCE, 0},
{1134, 3169816394u, 988430929u, 1065346043u, 0, COSF_TOLERANCE, 0},
{1135, 3098997418u, 3002162688u, 1065353216u, 0, COSF_TOLERANCE, 0},
{1136, 3282212423u, 3174079140u, 1016941376u, 0, COSF_TOLERANCE, 0},
{1137, 3352293320u, 3247843425u, 1050107930u, 0, COSF_TOLERANCE, 0},
{1138, 3296358441u, 875645354u, 3211409002u, 0, COSF_TOLERANCE, 0},
{1139, 1197828352u, 3245614728u, 1065315648u, 0, COSF_TOLERANCE, 0},
{1140, 3340510371u, 914930263u, 1057806643u, 0, COSF_TOLERANCE, 0},
{1141, 1127109339u, 3368125489u, 3171828278u, 0, COSF_TOLERANCE, 0},
{1142, 909467381u, 1232375752u, 1065353216u, 0, COSF_TOLERANCE, 0},
{1143, 1200599955u, 2981200675u, 1058314411u, 0, COSF_TOLERANCE, 0},
{1144, 962230977u, 2988248037u, 1065353216u, 0, COSF_TOLERANCE, 0},
{1145, 3192887808u, 3191848339u, 1065009608u, 0, COSF_TOLERANCE, 0},
{1146, 3237183876u, 3179379969u, 1048038805u, 0, COSF_TOLERANCE, 0},
{1147, 939285924u, 3056079386u, 1065353216u, 0, COSF_TOLERANCE, 0},
{1148, 944050180u, 3452557879u, 1065353216u, 0, COSF_TOLERANCE, 0},
{1149, 3058135703u, 3090284601u, 1065353216u, 0, COSF_TOLERANCE, 0},
{1150, 3480592662u, 3261728191u, 3210584153u, 0, COSF_TOLERANCE, 0},
{1151, 3061939312u, 3274418540u, 1065353216u, 0, COSF_TOLERANCE, 0},
{1152, 1003299981u, 853295521u, 1065352887u, 0, COSF_TOLERANCE, 0},
{1153, 1155775526u, 1255814444u, 1064855858u, 0, COSF_TOLERANCE, 0},
{1154, 1234491880u, 3408568717u, 1047219695u, 0, COSF_TOLERANCE, 0}

// AUTOMATICALLY GENERATED VECTORS STOP

};

#endif // CYGONCE_LIBM_COSF_H multiple inclusion protection

// EOF cosf.h
