#ifndef CYGONCE_LIBM_COPYSIGNF_H
#define CYGONCE_LIBM_COPYSIGNF_H
//===========================================================================
//
//      copysignf.h
//
//      Test vectors for testing of copysignf() math library function
//
//===========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 2012 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later
// version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License
// along with eCos; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
// As a special exception, if other files instantiate templates or use
// macros or inline functions from this file, or you compile this file
// and link it with other works to produce a work based on this file,
// this file does not by itself cause the resulting work to be covered by
// the GNU General Public License. However the source code for this file
// must still be made available in accordance with section (3) of the GNU
// General Public License v2.
//
// This exception does not invalidate any other reasons why a work based
// on this file might be covered by the GNU General Public License.
// -------------------------------------------
// ####ECOSGPLCOPYRIGHTEND####
//===========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):
// Contributors:  visar, ilijak
// Date:        1998-02-13
// Purpose:
// Description:
// Usage:       #include "vectors/copysignf.h"
//
//####DESCRIPTIONEND####
//
//===========================================================================


// CONFIGURATION

#include <pkgconf/libm.h>   // Configuration header


// INCLUDES

#include <cyg/infra/cyg_type.h>    // Common type definitions and support
#include "vectors/vector_support_float.h"// extra support for math tests

#define COPYSIGNF_TOLERANCE 1.0E-04

static const Cyg_libm_test_float_vec_t copysignf_vec[] = {

// AUTOMATICALLY GENERATED VECTORS START

{0, 3212836864u, 3212836864u, 3212836864u, 0, COPYSIGNF_TOLERANCE, 0},
{1, 3212836864u, 3211998003u, 3212836864u, 0, COPYSIGNF_TOLERANCE, 0},
{2, 3212836864u, 3211159142u, 3212836864u, 0, COPYSIGNF_TOLERANCE, 0},
{3, 3212836864u, 3210320282u, 3212836864u, 0, COPYSIGNF_TOLERANCE, 0},
{4, 3212836864u, 3209481421u, 3212836864u, 0, COPYSIGNF_TOLERANCE, 0},
{5, 3212836864u, 3208642560u, 3212836864u, 0, COPYSIGNF_TOLERANCE, 0},
{6, 3212836864u, 3207803699u, 3212836864u, 0, COPYSIGNF_TOLERANCE, 0},
{7, 3212836864u, 3206964838u, 3212836864u, 0, COPYSIGNF_TOLERANCE, 0},
{8, 3212836864u, 3206125978u, 3212836864u, 0, COPYSIGNF_TOLERANCE, 0},
{9, 3212836864u, 3205287117u, 3212836864u, 0, COPYSIGNF_TOLERANCE, 0},
{10, 3212836864u, 3204448256u, 3212836864u, 0, COPYSIGNF_TOLERANCE, 0},
{11, 3212836864u, 3202770534u, 3212836864u, 0, COPYSIGNF_TOLERANCE, 0},
{12, 3212836864u, 3201092813u, 3212836864u, 0, COPYSIGNF_TOLERANCE, 0},
{13, 3212836864u, 3199415091u, 3212836864u, 0, COPYSIGNF_TOLERANCE, 0},
{14, 3212836864u, 3197737370u, 3212836864u, 0, COPYSIGNF_TOLERANCE, 0},
{15, 3212836864u, 3196059648u, 3212836864u, 0, COPYSIGNF_TOLERANCE, 0},
{16, 3212836864u, 3192704205u, 3212836864u, 0, COPYSIGNF_TOLERANCE, 0},
{17, 3212836864u, 3189348762u, 3212836864u, 0, COPYSIGNF_TOLERANCE, 0},
{18, 3212836864u, 3184315597u, 3212836864u, 0, COPYSIGNF_TOLERANCE, 0},
{19, 3212836864u, 3175926989u, 3212836864u, 0, COPYSIGNF_TOLERANCE, 0},
{20, 3212836864u, 632815616u, 1065353216u, 0, COPYSIGNF_TOLERANCE, 0},
{21, 3212836864u, 1028443341u, 1065353216u, 0, COPYSIGNF_TOLERANCE, 0},
{22, 3212836864u, 1036831949u, 1065353216u, 0, COPYSIGNF_TOLERANCE, 0},
{23, 3212836864u, 1041865114u, 1065353216u, 0, COPYSIGNF_TOLERANCE, 0},
{24, 3212836864u, 1045220557u, 1065353216u, 0, COPYSIGNF_TOLERANCE, 0},
{25, 3212836864u, 1048576000u, 1065353216u, 0, COPYSIGNF_TOLERANCE, 0},
{26, 3212836864u, 1050253722u, 1065353216u, 0, COPYSIGNF_TOLERANCE, 0},
{27, 3212836864u, 1051931443u, 1065353216u, 0, COPYSIGNF_TOLERANCE, 0},
{28, 3212836864u, 1053609165u, 1065353216u, 0, COPYSIGNF_TOLERANCE, 0},
{29, 3212836864u, 1055286886u, 1065353216u, 0, COPYSIGNF_TOLERANCE, 0},
{30, 3212836864u, 1056964608u, 1065353216u, 0, COPYSIGNF_TOLERANCE, 0},
{31, 3212836864u, 1057803469u, 1065353216u, 0, COPYSIGNF_TOLERANCE, 0},
{32, 3212836864u, 1058642330u, 1065353216u, 0, COPYSIGNF_TOLERANCE, 0},
{33, 3212836864u, 1059481190u, 1065353216u, 0, COPYSIGNF_TOLERANCE, 0},
{34, 3212836864u, 1060320051u, 1065353216u, 0, COPYSIGNF_TOLERANCE, 0},
{35, 3212836864u, 1061158912u, 1065353216u, 0, COPYSIGNF_TOLERANCE, 0},
{36, 3212836864u, 1061997773u, 1065353216u, 0, COPYSIGNF_TOLERANCE, 0},
{37, 3212836864u, 1062836634u, 1065353216u, 0, COPYSIGNF_TOLERANCE, 0},
{38, 3212836864u, 1063675494u, 1065353216u, 0, COPYSIGNF_TOLERANCE, 0},
{39, 3212836864u, 1064514355u, 1065353216u, 0, COPYSIGNF_TOLERANCE, 0},
{40, 3211998003u, 3212836864u, 3211998003u, 0, COPYSIGNF_TOLERANCE, 0},
{41, 3211998003u, 3211998003u, 3211998003u, 0, COPYSIGNF_TOLERANCE, 0},
{42, 3211998003u, 3211159142u, 3211998003u, 0, COPYSIGNF_TOLERANCE, 0},
{43, 3211998003u, 3210320282u, 3211998003u, 0, COPYSIGNF_TOLERANCE, 0},
{44, 3211998003u, 3209481421u, 3211998003u, 0, COPYSIGNF_TOLERANCE, 0},
{45, 3211998003u, 3208642560u, 3211998003u, 0, COPYSIGNF_TOLERANCE, 0},
{46, 3211998003u, 3207803699u, 3211998003u, 0, COPYSIGNF_TOLERANCE, 0},
{47, 3211998003u, 3206964838u, 3211998003u, 0, COPYSIGNF_TOLERANCE, 0},
{48, 3211998003u, 3206125978u, 3211998003u, 0, COPYSIGNF_TOLERANCE, 0},
{49, 3211998003u, 3205287117u, 3211998003u, 0, COPYSIGNF_TOLERANCE, 0},
{50, 3211998003u, 3204448256u, 3211998003u, 0, COPYSIGNF_TOLERANCE, 0},
{51, 3211998003u, 3202770534u, 3211998003u, 0, COPYSIGNF_TOLERANCE, 0},
{52, 3211998003u, 3201092813u, 3211998003u, 0, COPYSIGNF_TOLERANCE, 0},
{53, 3211998003u, 3199415091u, 3211998003u, 0, COPYSIGNF_TOLERANCE, 0},
{54, 3211998003u, 3197737370u, 3211998003u, 0, COPYSIGNF_TOLERANCE, 0},
{55, 3211998003u, 3196059648u, 3211998003u, 0, COPYSIGNF_TOLERANCE, 0},
{56, 3211998003u, 3192704205u, 3211998003u, 0, COPYSIGNF_TOLERANCE, 0},
{57, 3211998003u, 3189348762u, 3211998003u, 0, COPYSIGNF_TOLERANCE, 0},
{58, 3211998003u, 3184315597u, 3211998003u, 0, COPYSIGNF_TOLERANCE, 0},
{59, 3211998003u, 3175926989u, 3211998003u, 0, COPYSIGNF_TOLERANCE, 0},
{60, 3211998003u, 632815616u, 1064514355u, 0, COPYSIGNF_TOLERANCE, 0},
{61, 3211998003u, 1028443341u, 1064514355u, 0, COPYSIGNF_TOLERANCE, 0},
{62, 3211998003u, 1036831949u, 1064514355u, 0, COPYSIGNF_TOLERANCE, 0},
{63, 3211998003u, 1041865114u, 1064514355u, 0, COPYSIGNF_TOLERANCE, 0},
{64, 3211998003u, 1045220557u, 1064514355u, 0, COPYSIGNF_TOLERANCE, 0},
{65, 3211998003u, 1048576000u, 1064514355u, 0, COPYSIGNF_TOLERANCE, 0},
{66, 3211998003u, 1050253722u, 1064514355u, 0, COPYSIGNF_TOLERANCE, 0},
{67, 3211998003u, 1051931443u, 1064514355u, 0, COPYSIGNF_TOLERANCE, 0},
{68, 3211998003u, 1053609165u, 1064514355u, 0, COPYSIGNF_TOLERANCE, 0},
{69, 3211998003u, 1055286886u, 1064514355u, 0, COPYSIGNF_TOLERANCE, 0},
{70, 3211998003u, 1056964608u, 1064514355u, 0, COPYSIGNF_TOLERANCE, 0},
{71, 3211998003u, 1057803469u, 1064514355u, 0, COPYSIGNF_TOLERANCE, 0},
{72, 3211998003u, 1058642330u, 1064514355u, 0, COPYSIGNF_TOLERANCE, 0},
{73, 3211998003u, 1059481190u, 1064514355u, 0, COPYSIGNF_TOLERANCE, 0},
{74, 3211998003u, 1060320051u, 1064514355u, 0, COPYSIGNF_TOLERANCE, 0},
{75, 3211998003u, 1061158912u, 1064514355u, 0, COPYSIGNF_TOLERANCE, 0},
{76, 3211998003u, 1061997773u, 1064514355u, 0, COPYSIGNF_TOLERANCE, 0},
{77, 3211998003u, 1062836634u, 1064514355u, 0, COPYSIGNF_TOLERANCE, 0},
{78, 3211998003u, 1063675494u, 1064514355u, 0, COPYSIGNF_TOLERANCE, 0},
{79, 3211998003u, 1064514355u, 1064514355u, 0, COPYSIGNF_TOLERANCE, 0},
{80, 3211159142u, 3212836864u, 3211159142u, 0, COPYSIGNF_TOLERANCE, 0},
{81, 3211159142u, 3211998003u, 3211159142u, 0, COPYSIGNF_TOLERANCE, 0},
{82, 3211159142u, 3211159142u, 3211159142u, 0, COPYSIGNF_TOLERANCE, 0},
{83, 3211159142u, 3210320282u, 3211159142u, 0, COPYSIGNF_TOLERANCE, 0},
{84, 3211159142u, 3209481421u, 3211159142u, 0, COPYSIGNF_TOLERANCE, 0},
{85, 3211159142u, 3208642560u, 3211159142u, 0, COPYSIGNF_TOLERANCE, 0},
{86, 3211159142u, 3207803699u, 3211159142u, 0, COPYSIGNF_TOLERANCE, 0},
{87, 3211159142u, 3206964838u, 3211159142u, 0, COPYSIGNF_TOLERANCE, 0},
{88, 3211159142u, 3206125978u, 3211159142u, 0, COPYSIGNF_TOLERANCE, 0},
{89, 3211159142u, 3205287117u, 3211159142u, 0, COPYSIGNF_TOLERANCE, 0},
{90, 3211159142u, 3204448256u, 3211159142u, 0, COPYSIGNF_TOLERANCE, 0},
{91, 3211159142u, 3202770534u, 3211159142u, 0, COPYSIGNF_TOLERANCE, 0},
{92, 3211159142u, 3201092813u, 3211159142u, 0, COPYSIGNF_TOLERANCE, 0},
{93, 3211159142u, 3199415091u, 3211159142u, 0, COPYSIGNF_TOLERANCE, 0},
{94, 3211159142u, 3197737370u, 3211159142u, 0, COPYSIGNF_TOLERANCE, 0},
{95, 3211159142u, 3196059648u, 3211159142u, 0, COPYSIGNF_TOLERANCE, 0},
{96, 3211159142u, 3192704205u, 3211159142u, 0, COPYSIGNF_TOLERANCE, 0},
{97, 3211159142u, 3189348762u, 3211159142u, 0, COPYSIGNF_TOLERANCE, 0},
{98, 3211159142u, 3184315597u, 3211159142u, 0, COPYSIGNF_TOLERANCE, 0},
{99, 3211159142u, 3175926989u, 3211159142u, 0, COPYSIGNF_TOLERANCE, 0},
{100, 3211159142u, 632815616u, 1063675494u, 0, COPYSIGNF_TOLERANCE, 0},
{101, 3211159142u, 1028443341u, 1063675494u, 0, COPYSIGNF_TOLERANCE, 0},
{102, 3211159142u, 1036831949u, 1063675494u, 0, COPYSIGNF_TOLERANCE, 0},
{103, 3211159142u, 1041865114u, 1063675494u, 0, COPYSIGNF_TOLERANCE, 0},
{104, 3211159142u, 1045220557u, 1063675494u, 0, COPYSIGNF_TOLERANCE, 0},
{105, 3211159142u, 1048576000u, 1063675494u, 0, COPYSIGNF_TOLERANCE, 0},
{106, 3211159142u, 1050253722u, 1063675494u, 0, COPYSIGNF_TOLERANCE, 0},
{107, 3211159142u, 1051931443u, 1063675494u, 0, COPYSIGNF_TOLERANCE, 0},
{108, 3211159142u, 1053609165u, 1063675494u, 0, COPYSIGNF_TOLERANCE, 0},
{109, 3211159142u, 1055286886u, 1063675494u, 0, COPYSIGNF_TOLERANCE, 0},
{110, 3211159142u, 1056964608u, 1063675494u, 0, COPYSIGNF_TOLERANCE, 0},
{111, 3211159142u, 1057803469u, 1063675494u, 0, COPYSIGNF_TOLERANCE, 0},
{112, 3211159142u, 1058642330u, 1063675494u, 0, COPYSIGNF_TOLERANCE, 0},
{113, 3211159142u, 1059481190u, 1063675494u, 0, COPYSIGNF_TOLERANCE, 0},
{114, 3211159142u, 1060320051u, 1063675494u, 0, COPYSIGNF_TOLERANCE, 0},
{115, 3211159142u, 1061158912u, 1063675494u, 0, COPYSIGNF_TOLERANCE, 0},
{116, 3211159142u, 1061997773u, 1063675494u, 0, COPYSIGNF_TOLERANCE, 0},
{117, 3211159142u, 1062836634u, 1063675494u, 0, COPYSIGNF_TOLERANCE, 0},
{118, 3211159142u, 1063675494u, 1063675494u, 0, COPYSIGNF_TOLERANCE, 0},
{119, 3211159142u, 1064514355u, 1063675494u, 0, COPYSIGNF_TOLERANCE, 0},
{120, 3210320282u, 3212836864u, 3210320282u, 0, COPYSIGNF_TOLERANCE, 0},
{121, 3210320282u, 3211998003u, 3210320282u, 0, COPYSIGNF_TOLERANCE, 0},
{122, 3210320282u, 3211159142u, 3210320282u, 0, COPYSIGNF_TOLERANCE, 0},
{123, 3210320282u, 3210320282u, 3210320282u, 0, COPYSIGNF_TOLERANCE, 0},
{124, 3210320282u, 3209481421u, 3210320282u, 0, COPYSIGNF_TOLERANCE, 0},
{125, 3210320282u, 3208642560u, 3210320282u, 0, COPYSIGNF_TOLERANCE, 0},
{126, 3210320282u, 3207803699u, 3210320282u, 0, COPYSIGNF_TOLERANCE, 0},
{127, 3210320282u, 3206964838u, 3210320282u, 0, COPYSIGNF_TOLERANCE, 0},
{128, 3210320282u, 3206125978u, 3210320282u, 0, COPYSIGNF_TOLERANCE, 0},
{129, 3210320282u, 3205287117u, 3210320282u, 0, COPYSIGNF_TOLERANCE, 0},
{130, 3210320282u, 3204448256u, 3210320282u, 0, COPYSIGNF_TOLERANCE, 0},
{131, 3210320282u, 3202770534u, 3210320282u, 0, COPYSIGNF_TOLERANCE, 0},
{132, 3210320282u, 3201092813u, 3210320282u, 0, COPYSIGNF_TOLERANCE, 0},
{133, 3210320282u, 3199415091u, 3210320282u, 0, COPYSIGNF_TOLERANCE, 0},
{134, 3210320282u, 3197737370u, 3210320282u, 0, COPYSIGNF_TOLERANCE, 0},
{135, 3210320282u, 3196059648u, 3210320282u, 0, COPYSIGNF_TOLERANCE, 0},
{136, 3210320282u, 3192704205u, 3210320282u, 0, COPYSIGNF_TOLERANCE, 0},
{137, 3210320282u, 3189348762u, 3210320282u, 0, COPYSIGNF_TOLERANCE, 0},
{138, 3210320282u, 3184315597u, 3210320282u, 0, COPYSIGNF_TOLERANCE, 0},
{139, 3210320282u, 3175926989u, 3210320282u, 0, COPYSIGNF_TOLERANCE, 0},
{140, 3210320282u, 632815616u, 1062836634u, 0, COPYSIGNF_TOLERANCE, 0},
{141, 3210320282u, 1028443341u, 1062836634u, 0, COPYSIGNF_TOLERANCE, 0},
{142, 3210320282u, 1036831949u, 1062836634u, 0, COPYSIGNF_TOLERANCE, 0},
{143, 3210320282u, 1041865114u, 1062836634u, 0, COPYSIGNF_TOLERANCE, 0},
{144, 3210320282u, 1045220557u, 1062836634u, 0, COPYSIGNF_TOLERANCE, 0},
{145, 3210320282u, 1048576000u, 1062836634u, 0, COPYSIGNF_TOLERANCE, 0},
{146, 3210320282u, 1050253722u, 1062836634u, 0, COPYSIGNF_TOLERANCE, 0},
{147, 3210320282u, 1051931443u, 1062836634u, 0, COPYSIGNF_TOLERANCE, 0},
{148, 3210320282u, 1053609165u, 1062836634u, 0, COPYSIGNF_TOLERANCE, 0},
{149, 3210320282u, 1055286886u, 1062836634u, 0, COPYSIGNF_TOLERANCE, 0},
{150, 3210320282u, 1056964608u, 1062836634u, 0, COPYSIGNF_TOLERANCE, 0},
{151, 3210320282u, 1057803469u, 1062836634u, 0, COPYSIGNF_TOLERANCE, 0},
{152, 3210320282u, 1058642330u, 1062836634u, 0, COPYSIGNF_TOLERANCE, 0},
{153, 3210320282u, 1059481190u, 1062836634u, 0, COPYSIGNF_TOLERANCE, 0},
{154, 3210320282u, 1060320051u, 1062836634u, 0, COPYSIGNF_TOLERANCE, 0},
{155, 3210320282u, 1061158912u, 1062836634u, 0, COPYSIGNF_TOLERANCE, 0},
{156, 3210320282u, 1061997773u, 1062836634u, 0, COPYSIGNF_TOLERANCE, 0},
{157, 3210320282u, 1062836634u, 1062836634u, 0, COPYSIGNF_TOLERANCE, 0},
{158, 3210320282u, 1063675494u, 1062836634u, 0, COPYSIGNF_TOLERANCE, 0},
{159, 3210320282u, 1064514355u, 1062836634u, 0, COPYSIGNF_TOLERANCE, 0},
{160, 3209481421u, 3212836864u, 3209481421u, 0, COPYSIGNF_TOLERANCE, 0},
{161, 3209481421u, 3211998003u, 3209481421u, 0, COPYSIGNF_TOLERANCE, 0},
{162, 3209481421u, 3211159142u, 3209481421u, 0, COPYSIGNF_TOLERANCE, 0},
{163, 3209481421u, 3210320282u, 3209481421u, 0, COPYSIGNF_TOLERANCE, 0},
{164, 3209481421u, 3209481421u, 3209481421u, 0, COPYSIGNF_TOLERANCE, 0},
{165, 3209481421u, 3208642560u, 3209481421u, 0, COPYSIGNF_TOLERANCE, 0},
{166, 3209481421u, 3207803699u, 3209481421u, 0, COPYSIGNF_TOLERANCE, 0},
{167, 3209481421u, 3206964838u, 3209481421u, 0, COPYSIGNF_TOLERANCE, 0},
{168, 3209481421u, 3206125978u, 3209481421u, 0, COPYSIGNF_TOLERANCE, 0},
{169, 3209481421u, 3205287117u, 3209481421u, 0, COPYSIGNF_TOLERANCE, 0},
{170, 3209481421u, 3204448256u, 3209481421u, 0, COPYSIGNF_TOLERANCE, 0},
{171, 3209481421u, 3202770534u, 3209481421u, 0, COPYSIGNF_TOLERANCE, 0},
{172, 3209481421u, 3201092813u, 3209481421u, 0, COPYSIGNF_TOLERANCE, 0},
{173, 3209481421u, 3199415091u, 3209481421u, 0, COPYSIGNF_TOLERANCE, 0},
{174, 3209481421u, 3197737370u, 3209481421u, 0, COPYSIGNF_TOLERANCE, 0},
{175, 3209481421u, 3196059648u, 3209481421u, 0, COPYSIGNF_TOLERANCE, 0},
{176, 3209481421u, 3192704205u, 3209481421u, 0, COPYSIGNF_TOLERANCE, 0},
{177, 3209481421u, 3189348762u, 3209481421u, 0, COPYSIGNF_TOLERANCE, 0},
{178, 3209481421u, 3184315597u, 3209481421u, 0, COPYSIGNF_TOLERANCE, 0},
{179, 3209481421u, 3175926989u, 3209481421u, 0, COPYSIGNF_TOLERANCE, 0},
{180, 3209481421u, 632815616u, 1061997773u, 0, COPYSIGNF_TOLERANCE, 0},
{181, 3209481421u, 1028443341u, 1061997773u, 0, COPYSIGNF_TOLERANCE, 0},
{182, 3209481421u, 1036831949u, 1061997773u, 0, COPYSIGNF_TOLERANCE, 0},
{183, 3209481421u, 1041865114u, 1061997773u, 0, COPYSIGNF_TOLERANCE, 0},
{184, 3209481421u, 1045220557u, 1061997773u, 0, COPYSIGNF_TOLERANCE, 0},
{185, 3209481421u, 1048576000u, 1061997773u, 0, COPYSIGNF_TOLERANCE, 0},
{186, 3209481421u, 1050253722u, 1061997773u, 0, COPYSIGNF_TOLERANCE, 0},
{187, 3209481421u, 1051931443u, 1061997773u, 0, COPYSIGNF_TOLERANCE, 0},
{188, 3209481421u, 1053609165u, 1061997773u, 0, COPYSIGNF_TOLERANCE, 0},
{189, 3209481421u, 1055286886u, 1061997773u, 0, COPYSIGNF_TOLERANCE, 0},
{190, 3209481421u, 1056964608u, 1061997773u, 0, COPYSIGNF_TOLERANCE, 0},
{191, 3209481421u, 1057803469u, 1061997773u, 0, COPYSIGNF_TOLERANCE, 0},
{192, 3209481421u, 1058642330u, 1061997773u, 0, COPYSIGNF_TOLERANCE, 0},
{193, 3209481421u, 1059481190u, 1061997773u, 0, COPYSIGNF_TOLERANCE, 0},
{194, 3209481421u, 1060320051u, 1061997773u, 0, COPYSIGNF_TOLERANCE, 0},
{195, 3209481421u, 1061158912u, 1061997773u, 0, COPYSIGNF_TOLERANCE, 0},
{196, 3209481421u, 1061997773u, 1061997773u, 0, COPYSIGNF_TOLERANCE, 0},
{197, 3209481421u, 1062836634u, 1061997773u, 0, COPYSIGNF_TOLERANCE, 0},
{198, 3209481421u, 1063675494u, 1061997773u, 0, COPYSIGNF_TOLERANCE, 0},
{199, 3209481421u, 1064514355u, 1061997773u, 0, COPYSIGNF_TOLERANCE, 0},
{200, 3208642560u, 3212836864u, 3208642560u, 0, COPYSIGNF_TOLERANCE, 0},
{201, 3208642560u, 3211998003u, 3208642560u, 0, COPYSIGNF_TOLERANCE, 0},
{202, 3208642560u, 3211159142u, 3208642560u, 0, COPYSIGNF_TOLERANCE, 0},
{203, 3208642560u, 3210320282u, 3208642560u, 0, COPYSIGNF_TOLERANCE, 0},
{204, 3208642560u, 3209481421u, 3208642560u, 0, COPYSIGNF_TOLERANCE, 0},
{205, 3208642560u, 3208642560u, 3208642560u, 0, COPYSIGNF_TOLERANCE, 0},
{206, 3208642560u, 3207803699u, 3208642560u, 0, COPYSIGNF_TOLERANCE, 0},
{207, 3208642560u, 3206964838u, 3208642560u, 0, COPYSIGNF_TOLERANCE, 0},
{208, 3208642560u, 3206125978u, 3208642560u, 0, COPYSIGNF_TOLERANCE, 0},
{209, 3208642560u, 3205287117u, 3208642560u, 0, COPYSIGNF_TOLERANCE, 0},
{210, 3208642560u, 3204448256u, 3208642560u, 0, COPYSIGNF_TOLERANCE, 0},
{211, 3208642560u, 3202770534u, 3208642560u, 0, COPYSIGNF_TOLERANCE, 0},
{212, 3208642560u, 3201092813u, 3208642560u, 0, COPYSIGNF_TOLERANCE, 0},
{213, 3208642560u, 3199415091u, 3208642560u, 0, COPYSIGNF_TOLERANCE, 0},
{214, 3208642560u, 3197737370u, 3208642560u, 0, COPYSIGNF_TOLERANCE, 0},
{215, 3208642560u, 3196059648u, 3208642560u, 0, COPYSIGNF_TOLERANCE, 0},
{216, 3208642560u, 3192704205u, 3208642560u, 0, COPYSIGNF_TOLERANCE, 0},
{217, 3208642560u, 3189348762u, 3208642560u, 0, COPYSIGNF_TOLERANCE, 0},
{218, 3208642560u, 3184315597u, 3208642560u, 0, COPYSIGNF_TOLERANCE, 0},
{219, 3208642560u, 3175926989u, 3208642560u, 0, COPYSIGNF_TOLERANCE, 0},
{220, 3208642560u, 632815616u, 1061158912u, 0, COPYSIGNF_TOLERANCE, 0},
{221, 3208642560u, 1028443341u, 1061158912u, 0, COPYSIGNF_TOLERANCE, 0},
{222, 3208642560u, 1036831949u, 1061158912u, 0, COPYSIGNF_TOLERANCE, 0},
{223, 3208642560u, 1041865114u, 1061158912u, 0, COPYSIGNF_TOLERANCE, 0},
{224, 3208642560u, 1045220557u, 1061158912u, 0, COPYSIGNF_TOLERANCE, 0},
{225, 3208642560u, 1048576000u, 1061158912u, 0, COPYSIGNF_TOLERANCE, 0},
{226, 3208642560u, 1050253722u, 1061158912u, 0, COPYSIGNF_TOLERANCE, 0},
{227, 3208642560u, 1051931443u, 1061158912u, 0, COPYSIGNF_TOLERANCE, 0},
{228, 3208642560u, 1053609165u, 1061158912u, 0, COPYSIGNF_TOLERANCE, 0},
{229, 3208642560u, 1055286886u, 1061158912u, 0, COPYSIGNF_TOLERANCE, 0},
{230, 3208642560u, 1056964608u, 1061158912u, 0, COPYSIGNF_TOLERANCE, 0},
{231, 3208642560u, 1057803469u, 1061158912u, 0, COPYSIGNF_TOLERANCE, 0},
{232, 3208642560u, 1058642330u, 1061158912u, 0, COPYSIGNF_TOLERANCE, 0},
{233, 3208642560u, 1059481190u, 1061158912u, 0, COPYSIGNF_TOLERANCE, 0},
{234, 3208642560u, 1060320051u, 1061158912u, 0, COPYSIGNF_TOLERANCE, 0},
{235, 3208642560u, 1061158912u, 1061158912u, 0, COPYSIGNF_TOLERANCE, 0},
{236, 3208642560u, 1061997773u, 1061158912u, 0, COPYSIGNF_TOLERANCE, 0},
{237, 3208642560u, 1062836634u, 1061158912u, 0, COPYSIGNF_TOLERANCE, 0},
{238, 3208642560u, 1063675494u, 1061158912u, 0, COPYSIGNF_TOLERANCE, 0},
{239, 3208642560u, 1064514355u, 1061158912u, 0, COPYSIGNF_TOLERANCE, 0},
{240, 3207803699u, 3212836864u, 3207803699u, 0, COPYSIGNF_TOLERANCE, 0},
{241, 3207803699u, 3211998003u, 3207803699u, 0, COPYSIGNF_TOLERANCE, 0},
{242, 3207803699u, 3211159142u, 3207803699u, 0, COPYSIGNF_TOLERANCE, 0},
{243, 3207803699u, 3210320282u, 3207803699u, 0, COPYSIGNF_TOLERANCE, 0},
{244, 3207803699u, 3209481421u, 3207803699u, 0, COPYSIGNF_TOLERANCE, 0},
{245, 3207803699u, 3208642560u, 3207803699u, 0, COPYSIGNF_TOLERANCE, 0},
{246, 3207803699u, 3207803699u, 3207803699u, 0, COPYSIGNF_TOLERANCE, 0},
{247, 3207803699u, 3206964838u, 3207803699u, 0, COPYSIGNF_TOLERANCE, 0},
{248, 3207803699u, 3206125978u, 3207803699u, 0, COPYSIGNF_TOLERANCE, 0},
{249, 3207803699u, 3205287117u, 3207803699u, 0, COPYSIGNF_TOLERANCE, 0},
{250, 3207803699u, 3204448256u, 3207803699u, 0, COPYSIGNF_TOLERANCE, 0},
{251, 3207803699u, 3202770534u, 3207803699u, 0, COPYSIGNF_TOLERANCE, 0},
{252, 3207803699u, 3201092813u, 3207803699u, 0, COPYSIGNF_TOLERANCE, 0},
{253, 3207803699u, 3199415091u, 3207803699u, 0, COPYSIGNF_TOLERANCE, 0},
{254, 3207803699u, 3197737370u, 3207803699u, 0, COPYSIGNF_TOLERANCE, 0},
{255, 3207803699u, 3196059648u, 3207803699u, 0, COPYSIGNF_TOLERANCE, 0},
{256, 3207803699u, 3192704205u, 3207803699u, 0, COPYSIGNF_TOLERANCE, 0},
{257, 3207803699u, 3189348762u, 3207803699u, 0, COPYSIGNF_TOLERANCE, 0},
{258, 3207803699u, 3184315597u, 3207803699u, 0, COPYSIGNF_TOLERANCE, 0},
{259, 3207803699u, 3175926989u, 3207803699u, 0, COPYSIGNF_TOLERANCE, 0},
{260, 3207803699u, 632815616u, 1060320051u, 0, COPYSIGNF_TOLERANCE, 0},
{261, 3207803699u, 1028443341u, 1060320051u, 0, COPYSIGNF_TOLERANCE, 0},
{262, 3207803699u, 1036831949u, 1060320051u, 0, COPYSIGNF_TOLERANCE, 0},
{263, 3207803699u, 1041865114u, 1060320051u, 0, COPYSIGNF_TOLERANCE, 0},
{264, 3207803699u, 1045220557u, 1060320051u, 0, COPYSIGNF_TOLERANCE, 0},
{265, 3207803699u, 1048576000u, 1060320051u, 0, COPYSIGNF_TOLERANCE, 0},
{266, 3207803699u, 1050253722u, 1060320051u, 0, COPYSIGNF_TOLERANCE, 0},
{267, 3207803699u, 1051931443u, 1060320051u, 0, COPYSIGNF_TOLERANCE, 0},
{268, 3207803699u, 1053609165u, 1060320051u, 0, COPYSIGNF_TOLERANCE, 0},
{269, 3207803699u, 1055286886u, 1060320051u, 0, COPYSIGNF_TOLERANCE, 0},
{270, 3207803699u, 1056964608u, 1060320051u, 0, COPYSIGNF_TOLERANCE, 0},
{271, 3207803699u, 1057803469u, 1060320051u, 0, COPYSIGNF_TOLERANCE, 0},
{272, 3207803699u, 1058642330u, 1060320051u, 0, COPYSIGNF_TOLERANCE, 0},
{273, 3207803699u, 1059481190u, 1060320051u, 0, COPYSIGNF_TOLERANCE, 0},
{274, 3207803699u, 1060320051u, 1060320051u, 0, COPYSIGNF_TOLERANCE, 0},
{275, 3207803699u, 1061158912u, 1060320051u, 0, COPYSIGNF_TOLERANCE, 0},
{276, 3207803699u, 1061997773u, 1060320051u, 0, COPYSIGNF_TOLERANCE, 0},
{277, 3207803699u, 1062836634u, 1060320051u, 0, COPYSIGNF_TOLERANCE, 0},
{278, 3207803699u, 1063675494u, 1060320051u, 0, COPYSIGNF_TOLERANCE, 0},
{279, 3207803699u, 1064514355u, 1060320051u, 0, COPYSIGNF_TOLERANCE, 0},
{280, 3206964838u, 3212836864u, 3206964838u, 0, COPYSIGNF_TOLERANCE, 0},
{281, 3206964838u, 3211998003u, 3206964838u, 0, COPYSIGNF_TOLERANCE, 0},
{282, 3206964838u, 3211159142u, 3206964838u, 0, COPYSIGNF_TOLERANCE, 0},
{283, 3206964838u, 3210320282u, 3206964838u, 0, COPYSIGNF_TOLERANCE, 0},
{284, 3206964838u, 3209481421u, 3206964838u, 0, COPYSIGNF_TOLERANCE, 0},
{285, 3206964838u, 3208642560u, 3206964838u, 0, COPYSIGNF_TOLERANCE, 0},
{286, 3206964838u, 3207803699u, 3206964838u, 0, COPYSIGNF_TOLERANCE, 0},
{287, 3206964838u, 3206964838u, 3206964838u, 0, COPYSIGNF_TOLERANCE, 0},
{288, 3206964838u, 3206125978u, 3206964838u, 0, COPYSIGNF_TOLERANCE, 0},
{289, 3206964838u, 3205287117u, 3206964838u, 0, COPYSIGNF_TOLERANCE, 0},
{290, 3206964838u, 3204448256u, 3206964838u, 0, COPYSIGNF_TOLERANCE, 0},
{291, 3206964838u, 3202770534u, 3206964838u, 0, COPYSIGNF_TOLERANCE, 0},
{292, 3206964838u, 3201092813u, 3206964838u, 0, COPYSIGNF_TOLERANCE, 0},
{293, 3206964838u, 3199415091u, 3206964838u, 0, COPYSIGNF_TOLERANCE, 0},
{294, 3206964838u, 3197737370u, 3206964838u, 0, COPYSIGNF_TOLERANCE, 0},
{295, 3206964838u, 3196059648u, 3206964838u, 0, COPYSIGNF_TOLERANCE, 0},
{296, 3206964838u, 3192704205u, 3206964838u, 0, COPYSIGNF_TOLERANCE, 0},
{297, 3206964838u, 3189348762u, 3206964838u, 0, COPYSIGNF_TOLERANCE, 0},
{298, 3206964838u, 3184315597u, 3206964838u, 0, COPYSIGNF_TOLERANCE, 0},
{299, 3206964838u, 3175926989u, 3206964838u, 0, COPYSIGNF_TOLERANCE, 0},
{300, 3206964838u, 632815616u, 1059481190u, 0, COPYSIGNF_TOLERANCE, 0},
{301, 3206964838u, 1028443341u, 1059481190u, 0, COPYSIGNF_TOLERANCE, 0},
{302, 3206964838u, 1036831949u, 1059481190u, 0, COPYSIGNF_TOLERANCE, 0},
{303, 3206964838u, 1041865114u, 1059481190u, 0, COPYSIGNF_TOLERANCE, 0},
{304, 3206964838u, 1045220557u, 1059481190u, 0, COPYSIGNF_TOLERANCE, 0},
{305, 3206964838u, 1048576000u, 1059481190u, 0, COPYSIGNF_TOLERANCE, 0},
{306, 3206964838u, 1050253722u, 1059481190u, 0, COPYSIGNF_TOLERANCE, 0},
{307, 3206964838u, 1051931443u, 1059481190u, 0, COPYSIGNF_TOLERANCE, 0},
{308, 3206964838u, 1053609165u, 1059481190u, 0, COPYSIGNF_TOLERANCE, 0},
{309, 3206964838u, 1055286886u, 1059481190u, 0, COPYSIGNF_TOLERANCE, 0},
{310, 3206964838u, 1056964608u, 1059481190u, 0, COPYSIGNF_TOLERANCE, 0},
{311, 3206964838u, 1057803469u, 1059481190u, 0, COPYSIGNF_TOLERANCE, 0},
{312, 3206964838u, 1058642330u, 1059481190u, 0, COPYSIGNF_TOLERANCE, 0},
{313, 3206964838u, 1059481190u, 1059481190u, 0, COPYSIGNF_TOLERANCE, 0},
{314, 3206964838u, 1060320051u, 1059481190u, 0, COPYSIGNF_TOLERANCE, 0},
{315, 3206964838u, 1061158912u, 1059481190u, 0, COPYSIGNF_TOLERANCE, 0},
{316, 3206964838u, 1061997773u, 1059481190u, 0, COPYSIGNF_TOLERANCE, 0},
{317, 3206964838u, 1062836634u, 1059481190u, 0, COPYSIGNF_TOLERANCE, 0},
{318, 3206964838u, 1063675494u, 1059481190u, 0, COPYSIGNF_TOLERANCE, 0},
{319, 3206964838u, 1064514355u, 1059481190u, 0, COPYSIGNF_TOLERANCE, 0},
{320, 3206125978u, 3212836864u, 3206125978u, 0, COPYSIGNF_TOLERANCE, 0},
{321, 3206125978u, 3211998003u, 3206125978u, 0, COPYSIGNF_TOLERANCE, 0},
{322, 3206125978u, 3211159142u, 3206125978u, 0, COPYSIGNF_TOLERANCE, 0},
{323, 3206125978u, 3210320282u, 3206125978u, 0, COPYSIGNF_TOLERANCE, 0},
{324, 3206125978u, 3209481421u, 3206125978u, 0, COPYSIGNF_TOLERANCE, 0},
{325, 3206125978u, 3208642560u, 3206125978u, 0, COPYSIGNF_TOLERANCE, 0},
{326, 3206125978u, 3207803699u, 3206125978u, 0, COPYSIGNF_TOLERANCE, 0},
{327, 3206125978u, 3206964838u, 3206125978u, 0, COPYSIGNF_TOLERANCE, 0},
{328, 3206125978u, 3206125978u, 3206125978u, 0, COPYSIGNF_TOLERANCE, 0},
{329, 3206125978u, 3205287117u, 3206125978u, 0, COPYSIGNF_TOLERANCE, 0},
{330, 3206125978u, 3204448256u, 3206125978u, 0, COPYSIGNF_TOLERANCE, 0},
{331, 3206125978u, 3202770534u, 3206125978u, 0, COPYSIGNF_TOLERANCE, 0},
{332, 3206125978u, 3201092813u, 3206125978u, 0, COPYSIGNF_TOLERANCE, 0},
{333, 3206125978u, 3199415091u, 3206125978u, 0, COPYSIGNF_TOLERANCE, 0},
{334, 3206125978u, 3197737370u, 3206125978u, 0, COPYSIGNF_TOLERANCE, 0},
{335, 3206125978u, 3196059648u, 3206125978u, 0, COPYSIGNF_TOLERANCE, 0},
{336, 3206125978u, 3192704205u, 3206125978u, 0, COPYSIGNF_TOLERANCE, 0},
{337, 3206125978u, 3189348762u, 3206125978u, 0, COPYSIGNF_TOLERANCE, 0},
{338, 3206125978u, 3184315597u, 3206125978u, 0, COPYSIGNF_TOLERANCE, 0},
{339, 3206125978u, 3175926989u, 3206125978u, 0, COPYSIGNF_TOLERANCE, 0},
{340, 3206125978u, 632815616u, 1058642330u, 0, COPYSIGNF_TOLERANCE, 0},
{341, 3206125978u, 1028443341u, 1058642330u, 0, COPYSIGNF_TOLERANCE, 0},
{342, 3206125978u, 1036831949u, 1058642330u, 0, COPYSIGNF_TOLERANCE, 0},
{343, 3206125978u, 1041865114u, 1058642330u, 0, COPYSIGNF_TOLERANCE, 0},
{344, 3206125978u, 1045220557u, 1058642330u, 0, COPYSIGNF_TOLERANCE, 0},
{345, 3206125978u, 1048576000u, 1058642330u, 0, COPYSIGNF_TOLERANCE, 0},
{346, 3206125978u, 1050253722u, 1058642330u, 0, COPYSIGNF_TOLERANCE, 0},
{347, 3206125978u, 1051931443u, 1058642330u, 0, COPYSIGNF_TOLERANCE, 0},
{348, 3206125978u, 1053609165u, 1058642330u, 0, COPYSIGNF_TOLERANCE, 0},
{349, 3206125978u, 1055286886u, 1058642330u, 0, COPYSIGNF_TOLERANCE, 0},
{350, 3206125978u, 1056964608u, 1058642330u, 0, COPYSIGNF_TOLERANCE, 0},
{351, 3206125978u, 1057803469u, 1058642330u, 0, COPYSIGNF_TOLERANCE, 0},
{352, 3206125978u, 1058642330u, 1058642330u, 0, COPYSIGNF_TOLERANCE, 0},
{353, 3206125978u, 1059481190u, 1058642330u, 0, COPYSIGNF_TOLERANCE, 0},
{354, 3206125978u, 1060320051u, 1058642330u, 0, COPYSIGNF_TOLERANCE, 0},
{355, 3206125978u, 1061158912u, 1058642330u, 0, COPYSIGNF_TOLERANCE, 0},
{356, 3206125978u, 1061997773u, 1058642330u, 0, COPYSIGNF_TOLERANCE, 0},
{357, 3206125978u, 1062836634u, 1058642330u, 0, COPYSIGNF_TOLERANCE, 0},
{358, 3206125978u, 1063675494u, 1058642330u, 0, COPYSIGNF_TOLERANCE, 0},
{359, 3206125978u, 1064514355u, 1058642330u, 0, COPYSIGNF_TOLERANCE, 0},
{360, 3205287117u, 3212836864u, 3205287117u, 0, COPYSIGNF_TOLERANCE, 0},
{361, 3205287117u, 3211998003u, 3205287117u, 0, COPYSIGNF_TOLERANCE, 0},
{362, 3205287117u, 3211159142u, 3205287117u, 0, COPYSIGNF_TOLERANCE, 0},
{363, 3205287117u, 3210320282u, 3205287117u, 0, COPYSIGNF_TOLERANCE, 0},
{364, 3205287117u, 3209481421u, 3205287117u, 0, COPYSIGNF_TOLERANCE, 0},
{365, 3205287117u, 3208642560u, 3205287117u, 0, COPYSIGNF_TOLERANCE, 0},
{366, 3205287117u, 3207803699u, 3205287117u, 0, COPYSIGNF_TOLERANCE, 0},
{367, 3205287117u, 3206964838u, 3205287117u, 0, COPYSIGNF_TOLERANCE, 0},
{368, 3205287117u, 3206125978u, 3205287117u, 0, COPYSIGNF_TOLERANCE, 0},
{369, 3205287117u, 3205287117u, 3205287117u, 0, COPYSIGNF_TOLERANCE, 0},
{370, 3205287117u, 3204448256u, 3205287117u, 0, COPYSIGNF_TOLERANCE, 0},
{371, 3205287117u, 3202770534u, 3205287117u, 0, COPYSIGNF_TOLERANCE, 0},
{372, 3205287117u, 3201092813u, 3205287117u, 0, COPYSIGNF_TOLERANCE, 0},
{373, 3205287117u, 3199415091u, 3205287117u, 0, COPYSIGNF_TOLERANCE, 0},
{374, 3205287117u, 3197737370u, 3205287117u, 0, COPYSIGNF_TOLERANCE, 0},
{375, 3205287117u, 3196059648u, 3205287117u, 0, COPYSIGNF_TOLERANCE, 0},
{376, 3205287117u, 3192704205u, 3205287117u, 0, COPYSIGNF_TOLERANCE, 0},
{377, 3205287117u, 3189348762u, 3205287117u, 0, COPYSIGNF_TOLERANCE, 0},
{378, 3205287117u, 3184315597u, 3205287117u, 0, COPYSIGNF_TOLERANCE, 0},
{379, 3205287117u, 3175926989u, 3205287117u, 0, COPYSIGNF_TOLERANCE, 0},
{380, 3205287117u, 632815616u, 1057803469u, 0, COPYSIGNF_TOLERANCE, 0},
{381, 3205287117u, 1028443341u, 1057803469u, 0, COPYSIGNF_TOLERANCE, 0},
{382, 3205287117u, 1036831949u, 1057803469u, 0, COPYSIGNF_TOLERANCE, 0},
{383, 3205287117u, 1041865114u, 1057803469u, 0, COPYSIGNF_TOLERANCE, 0},
{384, 3205287117u, 1045220557u, 1057803469u, 0, COPYSIGNF_TOLERANCE, 0},
{385, 3205287117u, 1048576000u, 1057803469u, 0, COPYSIGNF_TOLERANCE, 0},
{386, 3205287117u, 1050253722u, 1057803469u, 0, COPYSIGNF_TOLERANCE, 0},
{387, 3205287117u, 1051931443u, 1057803469u, 0, COPYSIGNF_TOLERANCE, 0},
{388, 3205287117u, 1053609165u, 1057803469u, 0, COPYSIGNF_TOLERANCE, 0},
{389, 3205287117u, 1055286886u, 1057803469u, 0, COPYSIGNF_TOLERANCE, 0},
{390, 3205287117u, 1056964608u, 1057803469u, 0, COPYSIGNF_TOLERANCE, 0},
{391, 3205287117u, 1057803469u, 1057803469u, 0, COPYSIGNF_TOLERANCE, 0},
{392, 3205287117u, 1058642330u, 1057803469u, 0, COPYSIGNF_TOLERANCE, 0},
{393, 3205287117u, 1059481190u, 1057803469u, 0, COPYSIGNF_TOLERANCE, 0},
{394, 3205287117u, 1060320051u, 1057803469u, 0, COPYSIGNF_TOLERANCE, 0},
{395, 3205287117u, 1061158912u, 1057803469u, 0, COPYSIGNF_TOLERANCE, 0},
{396, 3205287117u, 1061997773u, 1057803469u, 0, COPYSIGNF_TOLERANCE, 0},
{397, 3205287117u, 1062836634u, 1057803469u, 0, COPYSIGNF_TOLERANCE, 0},
{398, 3205287117u, 1063675494u, 1057803469u, 0, COPYSIGNF_TOLERANCE, 0},
{399, 3205287117u, 1064514355u, 1057803469u, 0, COPYSIGNF_TOLERANCE, 0},
{400, 3204448256u, 3212836864u, 3204448256u, 0, COPYSIGNF_TOLERANCE, 0},
{401, 3204448256u, 3211998003u, 3204448256u, 0, COPYSIGNF_TOLERANCE, 0},
{402, 3204448256u, 3211159142u, 3204448256u, 0, COPYSIGNF_TOLERANCE, 0},
{403, 3204448256u, 3210320282u, 3204448256u, 0, COPYSIGNF_TOLERANCE, 0},
{404, 3204448256u, 3209481421u, 3204448256u, 0, COPYSIGNF_TOLERANCE, 0},
{405, 3204448256u, 3208642560u, 3204448256u, 0, COPYSIGNF_TOLERANCE, 0},
{406, 3204448256u, 3207803699u, 3204448256u, 0, COPYSIGNF_TOLERANCE, 0},
{407, 3204448256u, 3206964838u, 3204448256u, 0, COPYSIGNF_TOLERANCE, 0},
{408, 3204448256u, 3206125978u, 3204448256u, 0, COPYSIGNF_TOLERANCE, 0},
{409, 3204448256u, 3205287117u, 3204448256u, 0, COPYSIGNF_TOLERANCE, 0},
{410, 3204448256u, 3204448256u, 3204448256u, 0, COPYSIGNF_TOLERANCE, 0},
{411, 3204448256u, 3202770534u, 3204448256u, 0, COPYSIGNF_TOLERANCE, 0},
{412, 3204448256u, 3201092813u, 3204448256u, 0, COPYSIGNF_TOLERANCE, 0},
{413, 3204448256u, 3199415091u, 3204448256u, 0, COPYSIGNF_TOLERANCE, 0},
{414, 3204448256u, 3197737370u, 3204448256u, 0, COPYSIGNF_TOLERANCE, 0},
{415, 3204448256u, 3196059648u, 3204448256u, 0, COPYSIGNF_TOLERANCE, 0},
{416, 3204448256u, 3192704205u, 3204448256u, 0, COPYSIGNF_TOLERANCE, 0},
{417, 3204448256u, 3189348762u, 3204448256u, 0, COPYSIGNF_TOLERANCE, 0},
{418, 3204448256u, 3184315597u, 3204448256u, 0, COPYSIGNF_TOLERANCE, 0},
{419, 3204448256u, 3175926989u, 3204448256u, 0, COPYSIGNF_TOLERANCE, 0},
{420, 3204448256u, 632815616u, 1056964608u, 0, COPYSIGNF_TOLERANCE, 0},
{421, 3204448256u, 1028443341u, 1056964608u, 0, COPYSIGNF_TOLERANCE, 0},
{422, 3204448256u, 1036831949u, 1056964608u, 0, COPYSIGNF_TOLERANCE, 0},
{423, 3204448256u, 1041865114u, 1056964608u, 0, COPYSIGNF_TOLERANCE, 0},
{424, 3204448256u, 1045220557u, 1056964608u, 0, COPYSIGNF_TOLERANCE, 0},
{425, 3204448256u, 1048576000u, 1056964608u, 0, COPYSIGNF_TOLERANCE, 0},
{426, 3204448256u, 1050253722u, 1056964608u, 0, COPYSIGNF_TOLERANCE, 0},
{427, 3204448256u, 1051931443u, 1056964608u, 0, COPYSIGNF_TOLERANCE, 0},
{428, 3204448256u, 1053609165u, 1056964608u, 0, COPYSIGNF_TOLERANCE, 0},
{429, 3204448256u, 1055286886u, 1056964608u, 0, COPYSIGNF_TOLERANCE, 0},
{430, 3204448256u, 1056964608u, 1056964608u, 0, COPYSIGNF_TOLERANCE, 0},
{431, 3204448256u, 1057803469u, 1056964608u, 0, COPYSIGNF_TOLERANCE, 0},
{432, 3204448256u, 1058642330u, 1056964608u, 0, COPYSIGNF_TOLERANCE, 0},
{433, 3204448256u, 1059481190u, 1056964608u, 0, COPYSIGNF_TOLERANCE, 0},
{434, 3204448256u, 1060320051u, 1056964608u, 0, COPYSIGNF_TOLERANCE, 0},
{435, 3204448256u, 1061158912u, 1056964608u, 0, COPYSIGNF_TOLERANCE, 0},
{436, 3204448256u, 1061997773u, 1056964608u, 0, COPYSIGNF_TOLERANCE, 0},
{437, 3204448256u, 1062836634u, 1056964608u, 0, COPYSIGNF_TOLERANCE, 0},
{438, 3204448256u, 1063675494u, 1056964608u, 0, COPYSIGNF_TOLERANCE, 0},
{439, 3204448256u, 1064514355u, 1056964608u, 0, COPYSIGNF_TOLERANCE, 0},
{440, 3202770534u, 3212836864u, 3202770534u, 0, COPYSIGNF_TOLERANCE, 0},
{441, 3202770534u, 3211998003u, 3202770534u, 0, COPYSIGNF_TOLERANCE, 0},
{442, 3202770534u, 3211159142u, 3202770534u, 0, COPYSIGNF_TOLERANCE, 0},
{443, 3202770534u, 3210320282u, 3202770534u, 0, COPYSIGNF_TOLERANCE, 0},
{444, 3202770534u, 3209481421u, 3202770534u, 0, COPYSIGNF_TOLERANCE, 0},
{445, 3202770534u, 3208642560u, 3202770534u, 0, COPYSIGNF_TOLERANCE, 0},
{446, 3202770534u, 3207803699u, 3202770534u, 0, COPYSIGNF_TOLERANCE, 0},
{447, 3202770534u, 3206964838u, 3202770534u, 0, COPYSIGNF_TOLERANCE, 0},
{448, 3202770534u, 3206125978u, 3202770534u, 0, COPYSIGNF_TOLERANCE, 0},
{449, 3202770534u, 3205287117u, 3202770534u, 0, COPYSIGNF_TOLERANCE, 0},
{450, 3202770534u, 3204448256u, 3202770534u, 0, COPYSIGNF_TOLERANCE, 0},
{451, 3202770534u, 3202770534u, 3202770534u, 0, COPYSIGNF_TOLERANCE, 0},
{452, 3202770534u, 3201092813u, 3202770534u, 0, COPYSIGNF_TOLERANCE, 0},
{453, 3202770534u, 3199415091u, 3202770534u, 0, COPYSIGNF_TOLERANCE, 0},
{454, 3202770534u, 3197737370u, 3202770534u, 0, COPYSIGNF_TOLERANCE, 0},
{455, 3202770534u, 3196059648u, 3202770534u, 0, COPYSIGNF_TOLERANCE, 0},
{456, 3202770534u, 3192704205u, 3202770534u, 0, COPYSIGNF_TOLERANCE, 0},
{457, 3202770534u, 3189348762u, 3202770534u, 0, COPYSIGNF_TOLERANCE, 0},
{458, 3202770534u, 3184315597u, 3202770534u, 0, COPYSIGNF_TOLERANCE, 0},
{459, 3202770534u, 3175926989u, 3202770534u, 0, COPYSIGNF_TOLERANCE, 0},
{460, 3202770534u, 632815616u, 1055286886u, 0, COPYSIGNF_TOLERANCE, 0},
{461, 3202770534u, 1028443341u, 1055286886u, 0, COPYSIGNF_TOLERANCE, 0},
{462, 3202770534u, 1036831949u, 1055286886u, 0, COPYSIGNF_TOLERANCE, 0},
{463, 3202770534u, 1041865114u, 1055286886u, 0, COPYSIGNF_TOLERANCE, 0},
{464, 3202770534u, 1045220557u, 1055286886u, 0, COPYSIGNF_TOLERANCE, 0},
{465, 3202770534u, 1048576000u, 1055286886u, 0, COPYSIGNF_TOLERANCE, 0},
{466, 3202770534u, 1050253722u, 1055286886u, 0, COPYSIGNF_TOLERANCE, 0},
{467, 3202770534u, 1051931443u, 1055286886u, 0, COPYSIGNF_TOLERANCE, 0},
{468, 3202770534u, 1053609165u, 1055286886u, 0, COPYSIGNF_TOLERANCE, 0},
{469, 3202770534u, 1055286886u, 1055286886u, 0, COPYSIGNF_TOLERANCE, 0},
{470, 3202770534u, 1056964608u, 1055286886u, 0, COPYSIGNF_TOLERANCE, 0},
{471, 3202770534u, 1057803469u, 1055286886u, 0, COPYSIGNF_TOLERANCE, 0},
{472, 3202770534u, 1058642330u, 1055286886u, 0, COPYSIGNF_TOLERANCE, 0},
{473, 3202770534u, 1059481190u, 1055286886u, 0, COPYSIGNF_TOLERANCE, 0},
{474, 3202770534u, 1060320051u, 1055286886u, 0, COPYSIGNF_TOLERANCE, 0},
{475, 3202770534u, 1061158912u, 1055286886u, 0, COPYSIGNF_TOLERANCE, 0},
{476, 3202770534u, 1061997773u, 1055286886u, 0, COPYSIGNF_TOLERANCE, 0},
{477, 3202770534u, 1062836634u, 1055286886u, 0, COPYSIGNF_TOLERANCE, 0},
{478, 3202770534u, 1063675494u, 1055286886u, 0, COPYSIGNF_TOLERANCE, 0},
{479, 3202770534u, 1064514355u, 1055286886u, 0, COPYSIGNF_TOLERANCE, 0},
{480, 3201092813u, 3212836864u, 3201092813u, 0, COPYSIGNF_TOLERANCE, 0},
{481, 3201092813u, 3211998003u, 3201092813u, 0, COPYSIGNF_TOLERANCE, 0},
{482, 3201092813u, 3211159142u, 3201092813u, 0, COPYSIGNF_TOLERANCE, 0},
{483, 3201092813u, 3210320282u, 3201092813u, 0, COPYSIGNF_TOLERANCE, 0},
{484, 3201092813u, 3209481421u, 3201092813u, 0, COPYSIGNF_TOLERANCE, 0},
{485, 3201092813u, 3208642560u, 3201092813u, 0, COPYSIGNF_TOLERANCE, 0},
{486, 3201092813u, 3207803699u, 3201092813u, 0, COPYSIGNF_TOLERANCE, 0},
{487, 3201092813u, 3206964838u, 3201092813u, 0, COPYSIGNF_TOLERANCE, 0},
{488, 3201092813u, 3206125978u, 3201092813u, 0, COPYSIGNF_TOLERANCE, 0},
{489, 3201092813u, 3205287117u, 3201092813u, 0, COPYSIGNF_TOLERANCE, 0},
{490, 3201092813u, 3204448256u, 3201092813u, 0, COPYSIGNF_TOLERANCE, 0},
{491, 3201092813u, 3202770534u, 3201092813u, 0, COPYSIGNF_TOLERANCE, 0},
{492, 3201092813u, 3201092813u, 3201092813u, 0, COPYSIGNF_TOLERANCE, 0},
{493, 3201092813u, 3199415091u, 3201092813u, 0, COPYSIGNF_TOLERANCE, 0},
{494, 3201092813u, 3197737370u, 3201092813u, 0, COPYSIGNF_TOLERANCE, 0},
{495, 3201092813u, 3196059648u, 3201092813u, 0, COPYSIGNF_TOLERANCE, 0},
{496, 3201092813u, 3192704205u, 3201092813u, 0, COPYSIGNF_TOLERANCE, 0},
{497, 3201092813u, 3189348762u, 3201092813u, 0, COPYSIGNF_TOLERANCE, 0},
{498, 3201092813u, 3184315597u, 3201092813u, 0, COPYSIGNF_TOLERANCE, 0},
{499, 3201092813u, 3175926989u, 3201092813u, 0, COPYSIGNF_TOLERANCE, 0},
{500, 3201092813u, 632815616u, 1053609165u, 0, COPYSIGNF_TOLERANCE, 0},
{501, 3201092813u, 1028443341u, 1053609165u, 0, COPYSIGNF_TOLERANCE, 0},
{502, 3201092813u, 1036831949u, 1053609165u, 0, COPYSIGNF_TOLERANCE, 0},
{503, 3201092813u, 1041865114u, 1053609165u, 0, COPYSIGNF_TOLERANCE, 0},
{504, 3201092813u, 1045220557u, 1053609165u, 0, COPYSIGNF_TOLERANCE, 0},
{505, 3201092813u, 1048576000u, 1053609165u, 0, COPYSIGNF_TOLERANCE, 0},
{506, 3201092813u, 1050253722u, 1053609165u, 0, COPYSIGNF_TOLERANCE, 0},
{507, 3201092813u, 1051931443u, 1053609165u, 0, COPYSIGNF_TOLERANCE, 0},
{508, 3201092813u, 1053609165u, 1053609165u, 0, COPYSIGNF_TOLERANCE, 0},
{509, 3201092813u, 1055286886u, 1053609165u, 0, COPYSIGNF_TOLERANCE, 0},
{510, 3201092813u, 1056964608u, 1053609165u, 0, COPYSIGNF_TOLERANCE, 0},
{511, 3201092813u, 1057803469u, 1053609165u, 0, COPYSIGNF_TOLERANCE, 0},
{512, 3201092813u, 1058642330u, 1053609165u, 0, COPYSIGNF_TOLERANCE, 0},
{513, 3201092813u, 1059481190u, 1053609165u, 0, COPYSIGNF_TOLERANCE, 0},
{514, 3201092813u, 1060320051u, 1053609165u, 0, COPYSIGNF_TOLERANCE, 0},
{515, 3201092813u, 1061158912u, 1053609165u, 0, COPYSIGNF_TOLERANCE, 0},
{516, 3201092813u, 1061997773u, 1053609165u, 0, COPYSIGNF_TOLERANCE, 0},
{517, 3201092813u, 1062836634u, 1053609165u, 0, COPYSIGNF_TOLERANCE, 0},
{518, 3201092813u, 1063675494u, 1053609165u, 0, COPYSIGNF_TOLERANCE, 0},
{519, 3201092813u, 1064514355u, 1053609165u, 0, COPYSIGNF_TOLERANCE, 0},
{520, 3199415091u, 3212836864u, 3199415091u, 0, COPYSIGNF_TOLERANCE, 0},
{521, 3199415091u, 3211998003u, 3199415091u, 0, COPYSIGNF_TOLERANCE, 0},
{522, 3199415091u, 3211159142u, 3199415091u, 0, COPYSIGNF_TOLERANCE, 0},
{523, 3199415091u, 3210320282u, 3199415091u, 0, COPYSIGNF_TOLERANCE, 0},
{524, 3199415091u, 3209481421u, 3199415091u, 0, COPYSIGNF_TOLERANCE, 0},
{525, 3199415091u, 3208642560u, 3199415091u, 0, COPYSIGNF_TOLERANCE, 0},
{526, 3199415091u, 3207803699u, 3199415091u, 0, COPYSIGNF_TOLERANCE, 0},
{527, 3199415091u, 3206964838u, 3199415091u, 0, COPYSIGNF_TOLERANCE, 0},
{528, 3199415091u, 3206125978u, 3199415091u, 0, COPYSIGNF_TOLERANCE, 0},
{529, 3199415091u, 3205287117u, 3199415091u, 0, COPYSIGNF_TOLERANCE, 0},
{530, 3199415091u, 3204448256u, 3199415091u, 0, COPYSIGNF_TOLERANCE, 0},
{531, 3199415091u, 3202770534u, 3199415091u, 0, COPYSIGNF_TOLERANCE, 0},
{532, 3199415091u, 3201092813u, 3199415091u, 0, COPYSIGNF_TOLERANCE, 0},
{533, 3199415091u, 3199415091u, 3199415091u, 0, COPYSIGNF_TOLERANCE, 0},
{534, 3199415091u, 3197737370u, 3199415091u, 0, COPYSIGNF_TOLERANCE, 0},
{535, 3199415091u, 3196059648u, 3199415091u, 0, COPYSIGNF_TOLERANCE, 0},
{536, 3199415091u, 3192704205u, 3199415091u, 0, COPYSIGNF_TOLERANCE, 0},
{537, 3199415091u, 3189348762u, 3199415091u, 0, COPYSIGNF_TOLERANCE, 0},
{538, 3199415091u, 3184315597u, 3199415091u, 0, COPYSIGNF_TOLERANCE, 0},
{539, 3199415091u, 3175926989u, 3199415091u, 0, COPYSIGNF_TOLERANCE, 0},
{540, 3199415091u, 632815616u, 1051931443u, 0, COPYSIGNF_TOLERANCE, 0},
{541, 3199415091u, 1028443341u, 1051931443u, 0, COPYSIGNF_TOLERANCE, 0},
{542, 3199415091u, 1036831949u, 1051931443u, 0, COPYSIGNF_TOLERANCE, 0},
{543, 3199415091u, 1041865114u, 1051931443u, 0, COPYSIGNF_TOLERANCE, 0},
{544, 3199415091u, 1045220557u, 1051931443u, 0, COPYSIGNF_TOLERANCE, 0},
{545, 3199415091u, 1048576000u, 1051931443u, 0, COPYSIGNF_TOLERANCE, 0},
{546, 3199415091u, 1050253722u, 1051931443u, 0, COPYSIGNF_TOLERANCE, 0},
{547, 3199415091u, 1051931443u, 1051931443u, 0, COPYSIGNF_TOLERANCE, 0},
{548, 3199415091u, 1053609165u, 1051931443u, 0, COPYSIGNF_TOLERANCE, 0},
{549, 3199415091u, 1055286886u, 1051931443u, 0, COPYSIGNF_TOLERANCE, 0},
{550, 3199415091u, 1056964608u, 1051931443u, 0, COPYSIGNF_TOLERANCE, 0},
{551, 3199415091u, 1057803469u, 1051931443u, 0, COPYSIGNF_TOLERANCE, 0},
{552, 3199415091u, 1058642330u, 1051931443u, 0, COPYSIGNF_TOLERANCE, 0},
{553, 3199415091u, 1059481190u, 1051931443u, 0, COPYSIGNF_TOLERANCE, 0},
{554, 3199415091u, 1060320051u, 1051931443u, 0, COPYSIGNF_TOLERANCE, 0},
{555, 3199415091u, 1061158912u, 1051931443u, 0, COPYSIGNF_TOLERANCE, 0},
{556, 3199415091u, 1061997773u, 1051931443u, 0, COPYSIGNF_TOLERANCE, 0},
{557, 3199415091u, 1062836634u, 1051931443u, 0, COPYSIGNF_TOLERANCE, 0},
{558, 3199415091u, 1063675494u, 1051931443u, 0, COPYSIGNF_TOLERANCE, 0},
{559, 3199415091u, 1064514355u, 1051931443u, 0, COPYSIGNF_TOLERANCE, 0},
{560, 3197737370u, 3212836864u, 3197737370u, 0, COPYSIGNF_TOLERANCE, 0},
{561, 3197737370u, 3211998003u, 3197737370u, 0, COPYSIGNF_TOLERANCE, 0},
{562, 3197737370u, 3211159142u, 3197737370u, 0, COPYSIGNF_TOLERANCE, 0},
{563, 3197737370u, 3210320282u, 3197737370u, 0, COPYSIGNF_TOLERANCE, 0},
{564, 3197737370u, 3209481421u, 3197737370u, 0, COPYSIGNF_TOLERANCE, 0},
{565, 3197737370u, 3208642560u, 3197737370u, 0, COPYSIGNF_TOLERANCE, 0},
{566, 3197737370u, 3207803699u, 3197737370u, 0, COPYSIGNF_TOLERANCE, 0},
{567, 3197737370u, 3206964838u, 3197737370u, 0, COPYSIGNF_TOLERANCE, 0},
{568, 3197737370u, 3206125978u, 3197737370u, 0, COPYSIGNF_TOLERANCE, 0},
{569, 3197737370u, 3205287117u, 3197737370u, 0, COPYSIGNF_TOLERANCE, 0},
{570, 3197737370u, 3204448256u, 3197737370u, 0, COPYSIGNF_TOLERANCE, 0},
{571, 3197737370u, 3202770534u, 3197737370u, 0, COPYSIGNF_TOLERANCE, 0},
{572, 3197737370u, 3201092813u, 3197737370u, 0, COPYSIGNF_TOLERANCE, 0},
{573, 3197737370u, 3199415091u, 3197737370u, 0, COPYSIGNF_TOLERANCE, 0},
{574, 3197737370u, 3197737370u, 3197737370u, 0, COPYSIGNF_TOLERANCE, 0},
{575, 3197737370u, 3196059648u, 3197737370u, 0, COPYSIGNF_TOLERANCE, 0},
{576, 3197737370u, 3192704205u, 3197737370u, 0, COPYSIGNF_TOLERANCE, 0},
{577, 3197737370u, 3189348762u, 3197737370u, 0, COPYSIGNF_TOLERANCE, 0},
{578, 3197737370u, 3184315597u, 3197737370u, 0, COPYSIGNF_TOLERANCE, 0},
{579, 3197737370u, 3175926989u, 3197737370u, 0, COPYSIGNF_TOLERANCE, 0},
{580, 3197737370u, 632815616u, 1050253722u, 0, COPYSIGNF_TOLERANCE, 0},
{581, 3197737370u, 1028443341u, 1050253722u, 0, COPYSIGNF_TOLERANCE, 0},
{582, 3197737370u, 1036831949u, 1050253722u, 0, COPYSIGNF_TOLERANCE, 0},
{583, 3197737370u, 1041865114u, 1050253722u, 0, COPYSIGNF_TOLERANCE, 0},
{584, 3197737370u, 1045220557u, 1050253722u, 0, COPYSIGNF_TOLERANCE, 0},
{585, 3197737370u, 1048576000u, 1050253722u, 0, COPYSIGNF_TOLERANCE, 0},
{586, 3197737370u, 1050253722u, 1050253722u, 0, COPYSIGNF_TOLERANCE, 0},
{587, 3197737370u, 1051931443u, 1050253722u, 0, COPYSIGNF_TOLERANCE, 0},
{588, 3197737370u, 1053609165u, 1050253722u, 0, COPYSIGNF_TOLERANCE, 0},
{589, 3197737370u, 1055286886u, 1050253722u, 0, COPYSIGNF_TOLERANCE, 0},
{590, 3197737370u, 1056964608u, 1050253722u, 0, COPYSIGNF_TOLERANCE, 0},
{591, 3197737370u, 1057803469u, 1050253722u, 0, COPYSIGNF_TOLERANCE, 0},
{592, 3197737370u, 1058642330u, 1050253722u, 0, COPYSIGNF_TOLERANCE, 0},
{593, 3197737370u, 1059481190u, 1050253722u, 0, COPYSIGNF_TOLERANCE, 0},
{594, 3197737370u, 1060320051u, 1050253722u, 0, COPYSIGNF_TOLERANCE, 0},
{595, 3197737370u, 1061158912u, 1050253722u, 0, COPYSIGNF_TOLERANCE, 0},
{596, 3197737370u, 1061997773u, 1050253722u, 0, COPYSIGNF_TOLERANCE, 0},
{597, 3197737370u, 1062836634u, 1050253722u, 0, COPYSIGNF_TOLERANCE, 0},
{598, 3197737370u, 1063675494u, 1050253722u, 0, COPYSIGNF_TOLERANCE, 0},
{599, 3197737370u, 1064514355u, 1050253722u, 0, COPYSIGNF_TOLERANCE, 0},
{600, 3196059648u, 3212836864u, 3196059648u, 0, COPYSIGNF_TOLERANCE, 0},
{601, 3196059648u, 3211998003u, 3196059648u, 0, COPYSIGNF_TOLERANCE, 0},
{602, 3196059648u, 3211159142u, 3196059648u, 0, COPYSIGNF_TOLERANCE, 0},
{603, 3196059648u, 3210320282u, 3196059648u, 0, COPYSIGNF_TOLERANCE, 0},
{604, 3196059648u, 3209481421u, 3196059648u, 0, COPYSIGNF_TOLERANCE, 0},
{605, 3196059648u, 3208642560u, 3196059648u, 0, COPYSIGNF_TOLERANCE, 0},
{606, 3196059648u, 3207803699u, 3196059648u, 0, COPYSIGNF_TOLERANCE, 0},
{607, 3196059648u, 3206964838u, 3196059648u, 0, COPYSIGNF_TOLERANCE, 0},
{608, 3196059648u, 3206125978u, 3196059648u, 0, COPYSIGNF_TOLERANCE, 0},
{609, 3196059648u, 3205287117u, 3196059648u, 0, COPYSIGNF_TOLERANCE, 0},
{610, 3196059648u, 3204448256u, 3196059648u, 0, COPYSIGNF_TOLERANCE, 0},
{611, 3196059648u, 3202770534u, 3196059648u, 0, COPYSIGNF_TOLERANCE, 0},
{612, 3196059648u, 3201092813u, 3196059648u, 0, COPYSIGNF_TOLERANCE, 0},
{613, 3196059648u, 3199415091u, 3196059648u, 0, COPYSIGNF_TOLERANCE, 0},
{614, 3196059648u, 3197737370u, 3196059648u, 0, COPYSIGNF_TOLERANCE, 0},
{615, 3196059648u, 3196059648u, 3196059648u, 0, COPYSIGNF_TOLERANCE, 0},
{616, 3196059648u, 3192704205u, 3196059648u, 0, COPYSIGNF_TOLERANCE, 0},
{617, 3196059648u, 3189348762u, 3196059648u, 0, COPYSIGNF_TOLERANCE, 0},
{618, 3196059648u, 3184315597u, 3196059648u, 0, COPYSIGNF_TOLERANCE, 0},
{619, 3196059648u, 3175926989u, 3196059648u, 0, COPYSIGNF_TOLERANCE, 0},
{620, 3196059648u, 632815616u, 1048576000u, 0, COPYSIGNF_TOLERANCE, 0},
{621, 3196059648u, 1028443341u, 1048576000u, 0, COPYSIGNF_TOLERANCE, 0},
{622, 3196059648u, 1036831949u, 1048576000u, 0, COPYSIGNF_TOLERANCE, 0},
{623, 3196059648u, 1041865114u, 1048576000u, 0, COPYSIGNF_TOLERANCE, 0},
{624, 3196059648u, 1045220557u, 1048576000u, 0, COPYSIGNF_TOLERANCE, 0},
{625, 3196059648u, 1048576000u, 1048576000u, 0, COPYSIGNF_TOLERANCE, 0},
{626, 3196059648u, 1050253722u, 1048576000u, 0, COPYSIGNF_TOLERANCE, 0},
{627, 3196059648u, 1051931443u, 1048576000u, 0, COPYSIGNF_TOLERANCE, 0},
{628, 3196059648u, 1053609165u, 1048576000u, 0, COPYSIGNF_TOLERANCE, 0},
{629, 3196059648u, 1055286886u, 1048576000u, 0, COPYSIGNF_TOLERANCE, 0},
{630, 3196059648u, 1056964608u, 1048576000u, 0, COPYSIGNF_TOLERANCE, 0},
{631, 3196059648u, 1057803469u, 1048576000u, 0, COPYSIGNF_TOLERANCE, 0},
{632, 3196059648u, 1058642330u, 1048576000u, 0, COPYSIGNF_TOLERANCE, 0},
{633, 3196059648u, 1059481190u, 1048576000u, 0, COPYSIGNF_TOLERANCE, 0},
{634, 3196059648u, 1060320051u, 1048576000u, 0, COPYSIGNF_TOLERANCE, 0},
{635, 3196059648u, 1061158912u, 1048576000u, 0, COPYSIGNF_TOLERANCE, 0},
{636, 3196059648u, 1061997773u, 1048576000u, 0, COPYSIGNF_TOLERANCE, 0},
{637, 3196059648u, 1062836634u, 1048576000u, 0, COPYSIGNF_TOLERANCE, 0},
{638, 3196059648u, 1063675494u, 1048576000u, 0, COPYSIGNF_TOLERANCE, 0},
{639, 3196059648u, 1064514355u, 1048576000u, 0, COPYSIGNF_TOLERANCE, 0},
{640, 3192704205u, 3212836864u, 3192704205u, 0, COPYSIGNF_TOLERANCE, 0},
{641, 3192704205u, 3211998003u, 3192704205u, 0, COPYSIGNF_TOLERANCE, 0},
{642, 3192704205u, 3211159142u, 3192704205u, 0, COPYSIGNF_TOLERANCE, 0},
{643, 3192704205u, 3210320282u, 3192704205u, 0, COPYSIGNF_TOLERANCE, 0},
{644, 3192704205u, 3209481421u, 3192704205u, 0, COPYSIGNF_TOLERANCE, 0},
{645, 3192704205u, 3208642560u, 3192704205u, 0, COPYSIGNF_TOLERANCE, 0},
{646, 3192704205u, 3207803699u, 3192704205u, 0, COPYSIGNF_TOLERANCE, 0},
{647, 3192704205u, 3206964838u, 3192704205u, 0, COPYSIGNF_TOLERANCE, 0},
{648, 3192704205u, 3206125978u, 3192704205u, 0, COPYSIGNF_TOLERANCE, 0},
{649, 3192704205u, 3205287117u, 3192704205u, 0, COPYSIGNF_TOLERANCE, 0},
{650, 3192704205u, 3204448256u, 3192704205u, 0, COPYSIGNF_TOLERANCE, 0},
{651, 3192704205u, 3202770534u, 3192704205u, 0, COPYSIGNF_TOLERANCE, 0},
{652, 3192704205u, 3201092813u, 3192704205u, 0, COPYSIGNF_TOLERANCE, 0},
{653, 3192704205u, 3199415091u, 3192704205u, 0, COPYSIGNF_TOLERANCE, 0},
{654, 3192704205u, 3197737370u, 3192704205u, 0, COPYSIGNF_TOLERANCE, 0},
{655, 3192704205u, 3196059648u, 3192704205u, 0, COPYSIGNF_TOLERANCE, 0},
{656, 3192704205u, 3192704205u, 3192704205u, 0, COPYSIGNF_TOLERANCE, 0},
{657, 3192704205u, 3189348762u, 3192704205u, 0, COPYSIGNF_TOLERANCE, 0},
{658, 3192704205u, 3184315597u, 3192704205u, 0, COPYSIGNF_TOLERANCE, 0},
{659, 3192704205u, 3175926989u, 3192704205u, 0, COPYSIGNF_TOLERANCE, 0},
{660, 3192704205u, 632815616u, 1045220557u, 0, COPYSIGNF_TOLERANCE, 0},
{661, 3192704205u, 1028443341u, 1045220557u, 0, COPYSIGNF_TOLERANCE, 0},
{662, 3192704205u, 1036831949u, 1045220557u, 0, COPYSIGNF_TOLERANCE, 0},
{663, 3192704205u, 1041865114u, 1045220557u, 0, COPYSIGNF_TOLERANCE, 0},
{664, 3192704205u, 1045220557u, 1045220557u, 0, COPYSIGNF_TOLERANCE, 0},
{665, 3192704205u, 1048576000u, 1045220557u, 0, COPYSIGNF_TOLERANCE, 0},
{666, 3192704205u, 1050253722u, 1045220557u, 0, COPYSIGNF_TOLERANCE, 0},
{667, 3192704205u, 1051931443u, 1045220557u, 0, COPYSIGNF_TOLERANCE, 0},
{668, 3192704205u, 1053609165u, 1045220557u, 0, COPYSIGNF_TOLERANCE, 0},
{669, 3192704205u, 1055286886u, 1045220557u, 0, COPYSIGNF_TOLERANCE, 0},
{670, 3192704205u, 1056964608u, 1045220557u, 0, COPYSIGNF_TOLERANCE, 0},
{671, 3192704205u, 1057803469u, 1045220557u, 0, COPYSIGNF_TOLERANCE, 0},
{672, 3192704205u, 1058642330u, 1045220557u, 0, COPYSIGNF_TOLERANCE, 0},
{673, 3192704205u, 1059481190u, 1045220557u, 0, COPYSIGNF_TOLERANCE, 0},
{674, 3192704205u, 1060320051u, 1045220557u, 0, COPYSIGNF_TOLERANCE, 0},
{675, 3192704205u, 1061158912u, 1045220557u, 0, COPYSIGNF_TOLERANCE, 0},
{676, 3192704205u, 1061997773u, 1045220557u, 0, COPYSIGNF_TOLERANCE, 0},
{677, 3192704205u, 1062836634u, 1045220557u, 0, COPYSIGNF_TOLERANCE, 0},
{678, 3192704205u, 1063675494u, 1045220557u, 0, COPYSIGNF_TOLERANCE, 0},
{679, 3192704205u, 1064514355u, 1045220557u, 0, COPYSIGNF_TOLERANCE, 0},
{680, 3189348762u, 3212836864u, 3189348762u, 0, COPYSIGNF_TOLERANCE, 0},
{681, 3189348762u, 3211998003u, 3189348762u, 0, COPYSIGNF_TOLERANCE, 0},
{682, 3189348762u, 3211159142u, 3189348762u, 0, COPYSIGNF_TOLERANCE, 0},
{683, 3189348762u, 3210320282u, 3189348762u, 0, COPYSIGNF_TOLERANCE, 0},
{684, 3189348762u, 3209481421u, 3189348762u, 0, COPYSIGNF_TOLERANCE, 0},
{685, 3189348762u, 3208642560u, 3189348762u, 0, COPYSIGNF_TOLERANCE, 0},
{686, 3189348762u, 3207803699u, 3189348762u, 0, COPYSIGNF_TOLERANCE, 0},
{687, 3189348762u, 3206964838u, 3189348762u, 0, COPYSIGNF_TOLERANCE, 0},
{688, 3189348762u, 3206125978u, 3189348762u, 0, COPYSIGNF_TOLERANCE, 0},
{689, 3189348762u, 3205287117u, 3189348762u, 0, COPYSIGNF_TOLERANCE, 0},
{690, 3189348762u, 3204448256u, 3189348762u, 0, COPYSIGNF_TOLERANCE, 0},
{691, 3189348762u, 3202770534u, 3189348762u, 0, COPYSIGNF_TOLERANCE, 0},
{692, 3189348762u, 3201092813u, 3189348762u, 0, COPYSIGNF_TOLERANCE, 0},
{693, 3189348762u, 3199415091u, 3189348762u, 0, COPYSIGNF_TOLERANCE, 0},
{694, 3189348762u, 3197737370u, 3189348762u, 0, COPYSIGNF_TOLERANCE, 0},
{695, 3189348762u, 3196059648u, 3189348762u, 0, COPYSIGNF_TOLERANCE, 0},
{696, 3189348762u, 3192704205u, 3189348762u, 0, COPYSIGNF_TOLERANCE, 0},
{697, 3189348762u, 3189348762u, 3189348762u, 0, COPYSIGNF_TOLERANCE, 0},
{698, 3189348762u, 3184315597u, 3189348762u, 0, COPYSIGNF_TOLERANCE, 0},
{699, 3189348762u, 3175926989u, 3189348762u, 0, COPYSIGNF_TOLERANCE, 0},
{700, 3189348762u, 632815616u, 1041865114u, 0, COPYSIGNF_TOLERANCE, 0},
{701, 3189348762u, 1028443341u, 1041865114u, 0, COPYSIGNF_TOLERANCE, 0},
{702, 3189348762u, 1036831949u, 1041865114u, 0, COPYSIGNF_TOLERANCE, 0},
{703, 3189348762u, 1041865114u, 1041865114u, 0, COPYSIGNF_TOLERANCE, 0},
{704, 3189348762u, 1045220557u, 1041865114u, 0, COPYSIGNF_TOLERANCE, 0},
{705, 3189348762u, 1048576000u, 1041865114u, 0, COPYSIGNF_TOLERANCE, 0},
{706, 3189348762u, 1050253722u, 1041865114u, 0, COPYSIGNF_TOLERANCE, 0},
{707, 3189348762u, 1051931443u, 1041865114u, 0, COPYSIGNF_TOLERANCE, 0},
{708, 3189348762u, 1053609165u, 1041865114u, 0, COPYSIGNF_TOLERANCE, 0},
{709, 3189348762u, 1055286886u, 1041865114u, 0, COPYSIGNF_TOLERANCE, 0},
{710, 3189348762u, 1056964608u, 1041865114u, 0, COPYSIGNF_TOLERANCE, 0},
{711, 3189348762u, 1057803469u, 1041865114u, 0, COPYSIGNF_TOLERANCE, 0},
{712, 3189348762u, 1058642330u, 1041865114u, 0, COPYSIGNF_TOLERANCE, 0},
{713, 3189348762u, 1059481190u, 1041865114u, 0, COPYSIGNF_TOLERANCE, 0},
{714, 3189348762u, 1060320051u, 1041865114u, 0, COPYSIGNF_TOLERANCE, 0},
{715, 3189348762u, 1061158912u, 1041865114u, 0, COPYSIGNF_TOLERANCE, 0},
{716, 3189348762u, 1061997773u, 1041865114u, 0, COPYSIGNF_TOLERANCE, 0},
{717, 3189348762u, 1062836634u, 1041865114u, 0, COPYSIGNF_TOLERANCE, 0},
{718, 3189348762u, 1063675494u, 1041865114u, 0, COPYSIGNF_TOLERANCE, 0},
{719, 3189348762u, 1064514355u, 1041865114u, 0, COPYSIGNF_TOLERANCE, 0},
{720, 3184315597u, 3212836864u, 3184315597u, 0, COPYSIGNF_TOLERANCE, 0},
{721, 3184315597u, 3211998003u, 3184315597u, 0, COPYSIGNF_TOLERANCE, 0},
{722, 3184315597u, 3211159142u, 3184315597u, 0, COPYSIGNF_TOLERANCE, 0},
{723, 3184315597u, 3210320282u, 3184315597u, 0, COPYSIGNF_TOLERANCE, 0},
{724, 3184315597u, 3209481421u, 3184315597u, 0, COPYSIGNF_TOLERANCE, 0},
{725, 3184315597u, 3208642560u, 3184315597u, 0, COPYSIGNF_TOLERANCE, 0},
{726, 3184315597u, 3207803699u, 3184315597u, 0, COPYSIGNF_TOLERANCE, 0},
{727, 3184315597u, 3206964838u, 3184315597u, 0, COPYSIGNF_TOLERANCE, 0},
{728, 3184315597u, 3206125978u, 3184315597u, 0, COPYSIGNF_TOLERANCE, 0},
{729, 3184315597u, 3205287117u, 3184315597u, 0, COPYSIGNF_TOLERANCE, 0},
{730, 3184315597u, 3204448256u, 3184315597u, 0, COPYSIGNF_TOLERANCE, 0},
{731, 3184315597u, 3202770534u, 3184315597u, 0, COPYSIGNF_TOLERANCE, 0},
{732, 3184315597u, 3201092813u, 3184315597u, 0, COPYSIGNF_TOLERANCE, 0},
{733, 3184315597u, 3199415091u, 3184315597u, 0, COPYSIGNF_TOLERANCE, 0},
{734, 3184315597u, 3197737370u, 3184315597u, 0, COPYSIGNF_TOLERANCE, 0},
{735, 3184315597u, 3196059648u, 3184315597u, 0, COPYSIGNF_TOLERANCE, 0},
{736, 3184315597u, 3192704205u, 3184315597u, 0, COPYSIGNF_TOLERANCE, 0},
{737, 3184315597u, 3189348762u, 3184315597u, 0, COPYSIGNF_TOLERANCE, 0},
{738, 3184315597u, 3184315597u, 3184315597u, 0, COPYSIGNF_TOLERANCE, 0},
{739, 3184315597u, 3175926989u, 3184315597u, 0, COPYSIGNF_TOLERANCE, 0},
{740, 3184315597u, 632815616u, 1036831949u, 0, COPYSIGNF_TOLERANCE, 0},
{741, 3184315597u, 1028443341u, 1036831949u, 0, COPYSIGNF_TOLERANCE, 0},
{742, 3184315597u, 1036831949u, 1036831949u, 0, COPYSIGNF_TOLERANCE, 0},
{743, 3184315597u, 1041865114u, 1036831949u, 0, COPYSIGNF_TOLERANCE, 0},
{744, 3184315597u, 1045220557u, 1036831949u, 0, COPYSIGNF_TOLERANCE, 0},
{745, 3184315597u, 1048576000u, 1036831949u, 0, COPYSIGNF_TOLERANCE, 0},
{746, 3184315597u, 1050253722u, 1036831949u, 0, COPYSIGNF_TOLERANCE, 0},
{747, 3184315597u, 1051931443u, 1036831949u, 0, COPYSIGNF_TOLERANCE, 0},
{748, 3184315597u, 1053609165u, 1036831949u, 0, COPYSIGNF_TOLERANCE, 0},
{749, 3184315597u, 1055286886u, 1036831949u, 0, COPYSIGNF_TOLERANCE, 0},
{750, 3184315597u, 1056964608u, 1036831949u, 0, COPYSIGNF_TOLERANCE, 0},
{751, 3184315597u, 1057803469u, 1036831949u, 0, COPYSIGNF_TOLERANCE, 0},
{752, 3184315597u, 1058642330u, 1036831949u, 0, COPYSIGNF_TOLERANCE, 0},
{753, 3184315597u, 1059481190u, 1036831949u, 0, COPYSIGNF_TOLERANCE, 0},
{754, 3184315597u, 1060320051u, 1036831949u, 0, COPYSIGNF_TOLERANCE, 0},
{755, 3184315597u, 1061158912u, 1036831949u, 0, COPYSIGNF_TOLERANCE, 0},
{756, 3184315597u, 1061997773u, 1036831949u, 0, COPYSIGNF_TOLERANCE, 0},
{757, 3184315597u, 1062836634u, 1036831949u, 0, COPYSIGNF_TOLERANCE, 0},
{758, 3184315597u, 1063675494u, 1036831949u, 0, COPYSIGNF_TOLERANCE, 0},
{759, 3184315597u, 1064514355u, 1036831949u, 0, COPYSIGNF_TOLERANCE, 0},
{760, 3175926989u, 3212836864u, 3175926989u, 0, COPYSIGNF_TOLERANCE, 0},
{761, 3175926989u, 3211998003u, 3175926989u, 0, COPYSIGNF_TOLERANCE, 0},
{762, 3175926989u, 3211159142u, 3175926989u, 0, COPYSIGNF_TOLERANCE, 0},
{763, 3175926989u, 3210320282u, 3175926989u, 0, COPYSIGNF_TOLERANCE, 0},
{764, 3175926989u, 3209481421u, 3175926989u, 0, COPYSIGNF_TOLERANCE, 0},
{765, 3175926989u, 3208642560u, 3175926989u, 0, COPYSIGNF_TOLERANCE, 0},
{766, 3175926989u, 3207803699u, 3175926989u, 0, COPYSIGNF_TOLERANCE, 0},
{767, 3175926989u, 3206964838u, 3175926989u, 0, COPYSIGNF_TOLERANCE, 0},
{768, 3175926989u, 3206125978u, 3175926989u, 0, COPYSIGNF_TOLERANCE, 0},
{769, 3175926989u, 3205287117u, 3175926989u, 0, COPYSIGNF_TOLERANCE, 0},
{770, 3175926989u, 3204448256u, 3175926989u, 0, COPYSIGNF_TOLERANCE, 0},
{771, 3175926989u, 3202770534u, 3175926989u, 0, COPYSIGNF_TOLERANCE, 0},
{772, 3175926989u, 3201092813u, 3175926989u, 0, COPYSIGNF_TOLERANCE, 0},
{773, 3175926989u, 3199415091u, 3175926989u, 0, COPYSIGNF_TOLERANCE, 0},
{774, 3175926989u, 3197737370u, 3175926989u, 0, COPYSIGNF_TOLERANCE, 0},
{775, 3175926989u, 3196059648u, 3175926989u, 0, COPYSIGNF_TOLERANCE, 0},
{776, 3175926989u, 3192704205u, 3175926989u, 0, COPYSIGNF_TOLERANCE, 0},
{777, 3175926989u, 3189348762u, 3175926989u, 0, COPYSIGNF_TOLERANCE, 0},
{778, 3175926989u, 3184315597u, 3175926989u, 0, COPYSIGNF_TOLERANCE, 0},
{779, 3175926989u, 3175926989u, 3175926989u, 0, COPYSIGNF_TOLERANCE, 0},
{780, 3175926989u, 632815616u, 1028443341u, 0, COPYSIGNF_TOLERANCE, 0},
{781, 3175926989u, 1028443341u, 1028443341u, 0, COPYSIGNF_TOLERANCE, 0},
{782, 3175926989u, 1036831949u, 1028443341u, 0, COPYSIGNF_TOLERANCE, 0},
{783, 3175926989u, 1041865114u, 1028443341u, 0, COPYSIGNF_TOLERANCE, 0},
{784, 3175926989u, 1045220557u, 1028443341u, 0, COPYSIGNF_TOLERANCE, 0},
{785, 3175926989u, 1048576000u, 1028443341u, 0, COPYSIGNF_TOLERANCE, 0},
{786, 3175926989u, 1050253722u, 1028443341u, 0, COPYSIGNF_TOLERANCE, 0},
{787, 3175926989u, 1051931443u, 1028443341u, 0, COPYSIGNF_TOLERANCE, 0},
{788, 3175926989u, 1053609165u, 1028443341u, 0, COPYSIGNF_TOLERANCE, 0},
{789, 3175926989u, 1055286886u, 1028443341u, 0, COPYSIGNF_TOLERANCE, 0},
{790, 3175926989u, 1056964608u, 1028443341u, 0, COPYSIGNF_TOLERANCE, 0},
{791, 3175926989u, 1057803469u, 1028443341u, 0, COPYSIGNF_TOLERANCE, 0},
{792, 3175926989u, 1058642330u, 1028443341u, 0, COPYSIGNF_TOLERANCE, 0},
{793, 3175926989u, 1059481190u, 1028443341u, 0, COPYSIGNF_TOLERANCE, 0},
{794, 3175926989u, 1060320051u, 1028443341u, 0, COPYSIGNF_TOLERANCE, 0},
{795, 3175926989u, 1061158912u, 1028443341u, 0, COPYSIGNF_TOLERANCE, 0},
{796, 3175926989u, 1061997773u, 1028443341u, 0, COPYSIGNF_TOLERANCE, 0},
{797, 3175926989u, 1062836634u, 1028443341u, 0, COPYSIGNF_TOLERANCE, 0},
{798, 3175926989u, 1063675494u, 1028443341u, 0, COPYSIGNF_TOLERANCE, 0},
{799, 3175926989u, 1064514355u, 1028443341u, 0, COPYSIGNF_TOLERANCE, 0},
{800, 632815616u, 3212836864u, 2780299264u, 0, COPYSIGNF_TOLERANCE, 0},
{801, 632815616u, 3211998003u, 2780299264u, 0, COPYSIGNF_TOLERANCE, 0},
{802, 632815616u, 3211159142u, 2780299264u, 0, COPYSIGNF_TOLERANCE, 0},
{803, 632815616u, 3210320282u, 2780299264u, 0, COPYSIGNF_TOLERANCE, 0},
{804, 632815616u, 3209481421u, 2780299264u, 0, COPYSIGNF_TOLERANCE, 0},
{805, 632815616u, 3208642560u, 2780299264u, 0, COPYSIGNF_TOLERANCE, 0},
{806, 632815616u, 3207803699u, 2780299264u, 0, COPYSIGNF_TOLERANCE, 0},
{807, 632815616u, 3206964838u, 2780299264u, 0, COPYSIGNF_TOLERANCE, 0},
{808, 632815616u, 3206125978u, 2780299264u, 0, COPYSIGNF_TOLERANCE, 0},
{809, 632815616u, 3205287117u, 2780299264u, 0, COPYSIGNF_TOLERANCE, 0},
{810, 632815616u, 3204448256u, 2780299264u, 0, COPYSIGNF_TOLERANCE, 0},
{811, 632815616u, 3202770534u, 2780299264u, 0, COPYSIGNF_TOLERANCE, 0},
{812, 632815616u, 3201092813u, 2780299264u, 0, COPYSIGNF_TOLERANCE, 0},
{813, 632815616u, 3199415091u, 2780299264u, 0, COPYSIGNF_TOLERANCE, 0},
{814, 632815616u, 3197737370u, 2780299264u, 0, COPYSIGNF_TOLERANCE, 0},
{815, 632815616u, 3196059648u, 2780299264u, 0, COPYSIGNF_TOLERANCE, 0},
{816, 632815616u, 3192704205u, 2780299264u, 0, COPYSIGNF_TOLERANCE, 0},
{817, 632815616u, 3189348762u, 2780299264u, 0, COPYSIGNF_TOLERANCE, 0},
{818, 632815616u, 3184315597u, 2780299264u, 0, COPYSIGNF_TOLERANCE, 0},
{819, 632815616u, 3175926989u, 2780299264u, 0, COPYSIGNF_TOLERANCE, 0},
{820, 632815616u, 632815616u, 632815616u, 0, COPYSIGNF_TOLERANCE, 0},
{821, 632815616u, 1028443341u, 632815616u, 0, COPYSIGNF_TOLERANCE, 0},
{822, 632815616u, 1036831949u, 632815616u, 0, COPYSIGNF_TOLERANCE, 0},
{823, 632815616u, 1041865114u, 632815616u, 0, COPYSIGNF_TOLERANCE, 0},
{824, 632815616u, 1045220557u, 632815616u, 0, COPYSIGNF_TOLERANCE, 0},
{825, 632815616u, 1048576000u, 632815616u, 0, COPYSIGNF_TOLERANCE, 0},
{826, 632815616u, 1050253722u, 632815616u, 0, COPYSIGNF_TOLERANCE, 0},
{827, 632815616u, 1051931443u, 632815616u, 0, COPYSIGNF_TOLERANCE, 0},
{828, 632815616u, 1053609165u, 632815616u, 0, COPYSIGNF_TOLERANCE, 0},
{829, 632815616u, 1055286886u, 632815616u, 0, COPYSIGNF_TOLERANCE, 0},
{830, 632815616u, 1056964608u, 632815616u, 0, COPYSIGNF_TOLERANCE, 0},
{831, 632815616u, 1057803469u, 632815616u, 0, COPYSIGNF_TOLERANCE, 0},
{832, 632815616u, 1058642330u, 632815616u, 0, COPYSIGNF_TOLERANCE, 0},
{833, 632815616u, 1059481190u, 632815616u, 0, COPYSIGNF_TOLERANCE, 0},
{834, 632815616u, 1060320051u, 632815616u, 0, COPYSIGNF_TOLERANCE, 0},
{835, 632815616u, 1061158912u, 632815616u, 0, COPYSIGNF_TOLERANCE, 0},
{836, 632815616u, 1061997773u, 632815616u, 0, COPYSIGNF_TOLERANCE, 0},
{837, 632815616u, 1062836634u, 632815616u, 0, COPYSIGNF_TOLERANCE, 0},
{838, 632815616u, 1063675494u, 632815616u, 0, COPYSIGNF_TOLERANCE, 0},
{839, 632815616u, 1064514355u, 632815616u, 0, COPYSIGNF_TOLERANCE, 0},
{840, 1028443341u, 3212836864u, 3175926989u, 0, COPYSIGNF_TOLERANCE, 0},
{841, 1028443341u, 3211998003u, 3175926989u, 0, COPYSIGNF_TOLERANCE, 0},
{842, 1028443341u, 3211159142u, 3175926989u, 0, COPYSIGNF_TOLERANCE, 0},
{843, 1028443341u, 3210320282u, 3175926989u, 0, COPYSIGNF_TOLERANCE, 0},
{844, 1028443341u, 3209481421u, 3175926989u, 0, COPYSIGNF_TOLERANCE, 0},
{845, 1028443341u, 3208642560u, 3175926989u, 0, COPYSIGNF_TOLERANCE, 0},
{846, 1028443341u, 3207803699u, 3175926989u, 0, COPYSIGNF_TOLERANCE, 0},
{847, 1028443341u, 3206964838u, 3175926989u, 0, COPYSIGNF_TOLERANCE, 0},
{848, 1028443341u, 3206125978u, 3175926989u, 0, COPYSIGNF_TOLERANCE, 0},
{849, 1028443341u, 3205287117u, 3175926989u, 0, COPYSIGNF_TOLERANCE, 0},
{850, 1028443341u, 3204448256u, 3175926989u, 0, COPYSIGNF_TOLERANCE, 0},
{851, 1028443341u, 3202770534u, 3175926989u, 0, COPYSIGNF_TOLERANCE, 0},
{852, 1028443341u, 3201092813u, 3175926989u, 0, COPYSIGNF_TOLERANCE, 0},
{853, 1028443341u, 3199415091u, 3175926989u, 0, COPYSIGNF_TOLERANCE, 0},
{854, 1028443341u, 3197737370u, 3175926989u, 0, COPYSIGNF_TOLERANCE, 0},
{855, 1028443341u, 3196059648u, 3175926989u, 0, COPYSIGNF_TOLERANCE, 0},
{856, 1028443341u, 3192704205u, 3175926989u, 0, COPYSIGNF_TOLERANCE, 0},
{857, 1028443341u, 3189348762u, 3175926989u, 0, COPYSIGNF_TOLERANCE, 0},
{858, 1028443341u, 3184315597u, 3175926989u, 0, COPYSIGNF_TOLERANCE, 0},
{859, 1028443341u, 3175926989u, 3175926989u, 0, COPYSIGNF_TOLERANCE, 0},
{860, 1028443341u, 632815616u, 1028443341u, 0, COPYSIGNF_TOLERANCE, 0},
{861, 1028443341u, 1028443341u, 1028443341u, 0, COPYSIGNF_TOLERANCE, 0},
{862, 1028443341u, 1036831949u, 1028443341u, 0, COPYSIGNF_TOLERANCE, 0},
{863, 1028443341u, 1041865114u, 1028443341u, 0, COPYSIGNF_TOLERANCE, 0},
{864, 1028443341u, 1045220557u, 1028443341u, 0, COPYSIGNF_TOLERANCE, 0},
{865, 1028443341u, 1048576000u, 1028443341u, 0, COPYSIGNF_TOLERANCE, 0},
{866, 1028443341u, 1050253722u, 1028443341u, 0, COPYSIGNF_TOLERANCE, 0},
{867, 1028443341u, 1051931443u, 1028443341u, 0, COPYSIGNF_TOLERANCE, 0},
{868, 1028443341u, 1053609165u, 1028443341u, 0, COPYSIGNF_TOLERANCE, 0},
{869, 1028443341u, 1055286886u, 1028443341u, 0, COPYSIGNF_TOLERANCE, 0},
{870, 1028443341u, 1056964608u, 1028443341u, 0, COPYSIGNF_TOLERANCE, 0},
{871, 1028443341u, 1057803469u, 1028443341u, 0, COPYSIGNF_TOLERANCE, 0},
{872, 1028443341u, 1058642330u, 1028443341u, 0, COPYSIGNF_TOLERANCE, 0},
{873, 1028443341u, 1059481190u, 1028443341u, 0, COPYSIGNF_TOLERANCE, 0},
{874, 1028443341u, 1060320051u, 1028443341u, 0, COPYSIGNF_TOLERANCE, 0},
{875, 1028443341u, 1061158912u, 1028443341u, 0, COPYSIGNF_TOLERANCE, 0},
{876, 1028443341u, 1061997773u, 1028443341u, 0, COPYSIGNF_TOLERANCE, 0},
{877, 1028443341u, 1062836634u, 1028443341u, 0, COPYSIGNF_TOLERANCE, 0},
{878, 1028443341u, 1063675494u, 1028443341u, 0, COPYSIGNF_TOLERANCE, 0},
{879, 1028443341u, 1064514355u, 1028443341u, 0, COPYSIGNF_TOLERANCE, 0},
{880, 1036831949u, 3212836864u, 3184315597u, 0, COPYSIGNF_TOLERANCE, 0},
{881, 1036831949u, 3211998003u, 3184315597u, 0, COPYSIGNF_TOLERANCE, 0},
{882, 1036831949u, 3211159142u, 3184315597u, 0, COPYSIGNF_TOLERANCE, 0},
{883, 1036831949u, 3210320282u, 3184315597u, 0, COPYSIGNF_TOLERANCE, 0},
{884, 1036831949u, 3209481421u, 3184315597u, 0, COPYSIGNF_TOLERANCE, 0},
{885, 1036831949u, 3208642560u, 3184315597u, 0, COPYSIGNF_TOLERANCE, 0},
{886, 1036831949u, 3207803699u, 3184315597u, 0, COPYSIGNF_TOLERANCE, 0},
{887, 1036831949u, 3206964838u, 3184315597u, 0, COPYSIGNF_TOLERANCE, 0},
{888, 1036831949u, 3206125978u, 3184315597u, 0, COPYSIGNF_TOLERANCE, 0},
{889, 1036831949u, 3205287117u, 3184315597u, 0, COPYSIGNF_TOLERANCE, 0},
{890, 1036831949u, 3204448256u, 3184315597u, 0, COPYSIGNF_TOLERANCE, 0},
{891, 1036831949u, 3202770534u, 3184315597u, 0, COPYSIGNF_TOLERANCE, 0},
{892, 1036831949u, 3201092813u, 3184315597u, 0, COPYSIGNF_TOLERANCE, 0},
{893, 1036831949u, 3199415091u, 3184315597u, 0, COPYSIGNF_TOLERANCE, 0},
{894, 1036831949u, 3197737370u, 3184315597u, 0, COPYSIGNF_TOLERANCE, 0},
{895, 1036831949u, 3196059648u, 3184315597u, 0, COPYSIGNF_TOLERANCE, 0},
{896, 1036831949u, 3192704205u, 3184315597u, 0, COPYSIGNF_TOLERANCE, 0},
{897, 1036831949u, 3189348762u, 3184315597u, 0, COPYSIGNF_TOLERANCE, 0},
{898, 1036831949u, 3184315597u, 3184315597u, 0, COPYSIGNF_TOLERANCE, 0},
{899, 1036831949u, 3175926989u, 3184315597u, 0, COPYSIGNF_TOLERANCE, 0},
{900, 1036831949u, 632815616u, 1036831949u, 0, COPYSIGNF_TOLERANCE, 0},
{901, 1036831949u, 1028443341u, 1036831949u, 0, COPYSIGNF_TOLERANCE, 0},
{902, 1036831949u, 1036831949u, 1036831949u, 0, COPYSIGNF_TOLERANCE, 0},
{903, 1036831949u, 1041865114u, 1036831949u, 0, COPYSIGNF_TOLERANCE, 0},
{904, 1036831949u, 1045220557u, 1036831949u, 0, COPYSIGNF_TOLERANCE, 0},
{905, 1036831949u, 1048576000u, 1036831949u, 0, COPYSIGNF_TOLERANCE, 0},
{906, 1036831949u, 1050253722u, 1036831949u, 0, COPYSIGNF_TOLERANCE, 0},
{907, 1036831949u, 1051931443u, 1036831949u, 0, COPYSIGNF_TOLERANCE, 0},
{908, 1036831949u, 1053609165u, 1036831949u, 0, COPYSIGNF_TOLERANCE, 0},
{909, 1036831949u, 1055286886u, 1036831949u, 0, COPYSIGNF_TOLERANCE, 0},
{910, 1036831949u, 1056964608u, 1036831949u, 0, COPYSIGNF_TOLERANCE, 0},
{911, 1036831949u, 1057803469u, 1036831949u, 0, COPYSIGNF_TOLERANCE, 0},
{912, 1036831949u, 1058642330u, 1036831949u, 0, COPYSIGNF_TOLERANCE, 0},
{913, 1036831949u, 1059481190u, 1036831949u, 0, COPYSIGNF_TOLERANCE, 0},
{914, 1036831949u, 1060320051u, 1036831949u, 0, COPYSIGNF_TOLERANCE, 0},
{915, 1036831949u, 1061158912u, 1036831949u, 0, COPYSIGNF_TOLERANCE, 0},
{916, 1036831949u, 1061997773u, 1036831949u, 0, COPYSIGNF_TOLERANCE, 0},
{917, 1036831949u, 1062836634u, 1036831949u, 0, COPYSIGNF_TOLERANCE, 0},
{918, 1036831949u, 1063675494u, 1036831949u, 0, COPYSIGNF_TOLERANCE, 0},
{919, 1036831949u, 1064514355u, 1036831949u, 0, COPYSIGNF_TOLERANCE, 0},
{920, 1041865114u, 3212836864u, 3189348762u, 0, COPYSIGNF_TOLERANCE, 0},
{921, 1041865114u, 3211998003u, 3189348762u, 0, COPYSIGNF_TOLERANCE, 0},
{922, 1041865114u, 3211159142u, 3189348762u, 0, COPYSIGNF_TOLERANCE, 0},
{923, 1041865114u, 3210320282u, 3189348762u, 0, COPYSIGNF_TOLERANCE, 0},
{924, 1041865114u, 3209481421u, 3189348762u, 0, COPYSIGNF_TOLERANCE, 0},
{925, 1041865114u, 3208642560u, 3189348762u, 0, COPYSIGNF_TOLERANCE, 0},
{926, 1041865114u, 3207803699u, 3189348762u, 0, COPYSIGNF_TOLERANCE, 0},
{927, 1041865114u, 3206964838u, 3189348762u, 0, COPYSIGNF_TOLERANCE, 0},
{928, 1041865114u, 3206125978u, 3189348762u, 0, COPYSIGNF_TOLERANCE, 0},
{929, 1041865114u, 3205287117u, 3189348762u, 0, COPYSIGNF_TOLERANCE, 0},
{930, 1041865114u, 3204448256u, 3189348762u, 0, COPYSIGNF_TOLERANCE, 0},
{931, 1041865114u, 3202770534u, 3189348762u, 0, COPYSIGNF_TOLERANCE, 0},
{932, 1041865114u, 3201092813u, 3189348762u, 0, COPYSIGNF_TOLERANCE, 0},
{933, 1041865114u, 3199415091u, 3189348762u, 0, COPYSIGNF_TOLERANCE, 0},
{934, 1041865114u, 3197737370u, 3189348762u, 0, COPYSIGNF_TOLERANCE, 0},
{935, 1041865114u, 3196059648u, 3189348762u, 0, COPYSIGNF_TOLERANCE, 0},
{936, 1041865114u, 3192704205u, 3189348762u, 0, COPYSIGNF_TOLERANCE, 0},
{937, 1041865114u, 3189348762u, 3189348762u, 0, COPYSIGNF_TOLERANCE, 0},
{938, 1041865114u, 3184315597u, 3189348762u, 0, COPYSIGNF_TOLERANCE, 0},
{939, 1041865114u, 3175926989u, 3189348762u, 0, COPYSIGNF_TOLERANCE, 0},
{940, 1041865114u, 632815616u, 1041865114u, 0, COPYSIGNF_TOLERANCE, 0},
{941, 1041865114u, 1028443341u, 1041865114u, 0, COPYSIGNF_TOLERANCE, 0},
{942, 1041865114u, 1036831949u, 1041865114u, 0, COPYSIGNF_TOLERANCE, 0},
{943, 1041865114u, 1041865114u, 1041865114u, 0, COPYSIGNF_TOLERANCE, 0},
{944, 1041865114u, 1045220557u, 1041865114u, 0, COPYSIGNF_TOLERANCE, 0},
{945, 1041865114u, 1048576000u, 1041865114u, 0, COPYSIGNF_TOLERANCE, 0},
{946, 1041865114u, 1050253722u, 1041865114u, 0, COPYSIGNF_TOLERANCE, 0},
{947, 1041865114u, 1051931443u, 1041865114u, 0, COPYSIGNF_TOLERANCE, 0},
{948, 1041865114u, 1053609165u, 1041865114u, 0, COPYSIGNF_TOLERANCE, 0},
{949, 1041865114u, 1055286886u, 1041865114u, 0, COPYSIGNF_TOLERANCE, 0},
{950, 1041865114u, 1056964608u, 1041865114u, 0, COPYSIGNF_TOLERANCE, 0},
{951, 1041865114u, 1057803469u, 1041865114u, 0, COPYSIGNF_TOLERANCE, 0},
{952, 1041865114u, 1058642330u, 1041865114u, 0, COPYSIGNF_TOLERANCE, 0},
{953, 1041865114u, 1059481190u, 1041865114u, 0, COPYSIGNF_TOLERANCE, 0},
{954, 1041865114u, 1060320051u, 1041865114u, 0, COPYSIGNF_TOLERANCE, 0},
{955, 1041865114u, 1061158912u, 1041865114u, 0, COPYSIGNF_TOLERANCE, 0},
{956, 1041865114u, 1061997773u, 1041865114u, 0, COPYSIGNF_TOLERANCE, 0},
{957, 1041865114u, 1062836634u, 1041865114u, 0, COPYSIGNF_TOLERANCE, 0},
{958, 1041865114u, 1063675494u, 1041865114u, 0, COPYSIGNF_TOLERANCE, 0},
{959, 1041865114u, 1064514355u, 1041865114u, 0, COPYSIGNF_TOLERANCE, 0},
{960, 1045220557u, 3212836864u, 3192704205u, 0, COPYSIGNF_TOLERANCE, 0},
{961, 1045220557u, 3211998003u, 3192704205u, 0, COPYSIGNF_TOLERANCE, 0},
{962, 1045220557u, 3211159142u, 3192704205u, 0, COPYSIGNF_TOLERANCE, 0},
{963, 1045220557u, 3210320282u, 3192704205u, 0, COPYSIGNF_TOLERANCE, 0},
{964, 1045220557u, 3209481421u, 3192704205u, 0, COPYSIGNF_TOLERANCE, 0},
{965, 1045220557u, 3208642560u, 3192704205u, 0, COPYSIGNF_TOLERANCE, 0},
{966, 1045220557u, 3207803699u, 3192704205u, 0, COPYSIGNF_TOLERANCE, 0},
{967, 1045220557u, 3206964838u, 3192704205u, 0, COPYSIGNF_TOLERANCE, 0},
{968, 1045220557u, 3206125978u, 3192704205u, 0, COPYSIGNF_TOLERANCE, 0},
{969, 1045220557u, 3205287117u, 3192704205u, 0, COPYSIGNF_TOLERANCE, 0},
{970, 1045220557u, 3204448256u, 3192704205u, 0, COPYSIGNF_TOLERANCE, 0},
{971, 1045220557u, 3202770534u, 3192704205u, 0, COPYSIGNF_TOLERANCE, 0},
{972, 1045220557u, 3201092813u, 3192704205u, 0, COPYSIGNF_TOLERANCE, 0},
{973, 1045220557u, 3199415091u, 3192704205u, 0, COPYSIGNF_TOLERANCE, 0},
{974, 1045220557u, 3197737370u, 3192704205u, 0, COPYSIGNF_TOLERANCE, 0},
{975, 1045220557u, 3196059648u, 3192704205u, 0, COPYSIGNF_TOLERANCE, 0},
{976, 1045220557u, 3192704205u, 3192704205u, 0, COPYSIGNF_TOLERANCE, 0},
{977, 1045220557u, 3189348762u, 3192704205u, 0, COPYSIGNF_TOLERANCE, 0},
{978, 1045220557u, 3184315597u, 3192704205u, 0, COPYSIGNF_TOLERANCE, 0},
{979, 1045220557u, 3175926989u, 3192704205u, 0, COPYSIGNF_TOLERANCE, 0},
{980, 1045220557u, 632815616u, 1045220557u, 0, COPYSIGNF_TOLERANCE, 0},
{981, 1045220557u, 1028443341u, 1045220557u, 0, COPYSIGNF_TOLERANCE, 0},
{982, 1045220557u, 1036831949u, 1045220557u, 0, COPYSIGNF_TOLERANCE, 0},
{983, 1045220557u, 1041865114u, 1045220557u, 0, COPYSIGNF_TOLERANCE, 0},
{984, 1045220557u, 1045220557u, 1045220557u, 0, COPYSIGNF_TOLERANCE, 0},
{985, 1045220557u, 1048576000u, 1045220557u, 0, COPYSIGNF_TOLERANCE, 0},
{986, 1045220557u, 1050253722u, 1045220557u, 0, COPYSIGNF_TOLERANCE, 0},
{987, 1045220557u, 1051931443u, 1045220557u, 0, COPYSIGNF_TOLERANCE, 0},
{988, 1045220557u, 1053609165u, 1045220557u, 0, COPYSIGNF_TOLERANCE, 0},
{989, 1045220557u, 1055286886u, 1045220557u, 0, COPYSIGNF_TOLERANCE, 0},
{990, 1045220557u, 1056964608u, 1045220557u, 0, COPYSIGNF_TOLERANCE, 0},
{991, 1045220557u, 1057803469u, 1045220557u, 0, COPYSIGNF_TOLERANCE, 0},
{992, 1045220557u, 1058642330u, 1045220557u, 0, COPYSIGNF_TOLERANCE, 0},
{993, 1045220557u, 1059481190u, 1045220557u, 0, COPYSIGNF_TOLERANCE, 0},
{994, 1045220557u, 1060320051u, 1045220557u, 0, COPYSIGNF_TOLERANCE, 0},
{995, 1045220557u, 1061158912u, 1045220557u, 0, COPYSIGNF_TOLERANCE, 0},
{996, 1045220557u, 1061997773u, 1045220557u, 0, COPYSIGNF_TOLERANCE, 0},
{997, 1045220557u, 1062836634u, 1045220557u, 0, COPYSIGNF_TOLERANCE, 0},
{998, 1045220557u, 1063675494u, 1045220557u, 0, COPYSIGNF_TOLERANCE, 0},
{999, 1045220557u, 1064514355u, 1045220557u, 0, COPYSIGNF_TOLERANCE, 0},
{1000, 1048576000u, 3212836864u, 3196059648u, 0, COPYSIGNF_TOLERANCE, 0},
{1001, 1048576000u, 3211998003u, 3196059648u, 0, COPYSIGNF_TOLERANCE, 0},
{1002, 1048576000u, 3211159142u, 3196059648u, 0, COPYSIGNF_TOLERANCE, 0},
{1003, 1048576000u, 3210320282u, 3196059648u, 0, COPYSIGNF_TOLERANCE, 0},
{1004, 1048576000u, 3209481421u, 3196059648u, 0, COPYSIGNF_TOLERANCE, 0},
{1005, 1048576000u, 3208642560u, 3196059648u, 0, COPYSIGNF_TOLERANCE, 0},
{1006, 1048576000u, 3207803699u, 3196059648u, 0, COPYSIGNF_TOLERANCE, 0},
{1007, 1048576000u, 3206964838u, 3196059648u, 0, COPYSIGNF_TOLERANCE, 0},
{1008, 1048576000u, 3206125978u, 3196059648u, 0, COPYSIGNF_TOLERANCE, 0},
{1009, 1048576000u, 3205287117u, 3196059648u, 0, COPYSIGNF_TOLERANCE, 0},
{1010, 1048576000u, 3204448256u, 3196059648u, 0, COPYSIGNF_TOLERANCE, 0},
{1011, 1048576000u, 3202770534u, 3196059648u, 0, COPYSIGNF_TOLERANCE, 0},
{1012, 1048576000u, 3201092813u, 3196059648u, 0, COPYSIGNF_TOLERANCE, 0},
{1013, 1048576000u, 3199415091u, 3196059648u, 0, COPYSIGNF_TOLERANCE, 0},
{1014, 1048576000u, 3197737370u, 3196059648u, 0, COPYSIGNF_TOLERANCE, 0},
{1015, 1048576000u, 3196059648u, 3196059648u, 0, COPYSIGNF_TOLERANCE, 0},
{1016, 1048576000u, 3192704205u, 3196059648u, 0, COPYSIGNF_TOLERANCE, 0},
{1017, 1048576000u, 3189348762u, 3196059648u, 0, COPYSIGNF_TOLERANCE, 0},
{1018, 1048576000u, 3184315597u, 3196059648u, 0, COPYSIGNF_TOLERANCE, 0},
{1019, 1048576000u, 3175926989u, 3196059648u, 0, COPYSIGNF_TOLERANCE, 0},
{1020, 1048576000u, 632815616u, 1048576000u, 0, COPYSIGNF_TOLERANCE, 0},
{1021, 1048576000u, 1028443341u, 1048576000u, 0, COPYSIGNF_TOLERANCE, 0},
{1022, 1048576000u, 1036831949u, 1048576000u, 0, COPYSIGNF_TOLERANCE, 0},
{1023, 1048576000u, 1041865114u, 1048576000u, 0, COPYSIGNF_TOLERANCE, 0},
{1024, 1048576000u, 1045220557u, 1048576000u, 0, COPYSIGNF_TOLERANCE, 0},
{1025, 1048576000u, 1048576000u, 1048576000u, 0, COPYSIGNF_TOLERANCE, 0},
{1026, 1048576000u, 1050253722u, 1048576000u, 0, COPYSIGNF_TOLERANCE, 0},
{1027, 1048576000u, 1051931443u, 1048576000u, 0, COPYSIGNF_TOLERANCE, 0},
{1028, 1048576000u, 1053609165u, 1048576000u, 0, COPYSIGNF_TOLERANCE, 0},
{1029, 1048576000u, 1055286886u, 1048576000u, 0, COPYSIGNF_TOLERANCE, 0},
{1030, 1048576000u, 1056964608u, 1048576000u, 0, COPYSIGNF_TOLERANCE, 0},
{1031, 1048576000u, 1057803469u, 1048576000u, 0, COPYSIGNF_TOLERANCE, 0},
{1032, 1048576000u, 1058642330u, 1048576000u, 0, COPYSIGNF_TOLERANCE, 0},
{1033, 1048576000u, 1059481190u, 1048576000u, 0, COPYSIGNF_TOLERANCE, 0},
{1034, 1048576000u, 1060320051u, 1048576000u, 0, COPYSIGNF_TOLERANCE, 0},
{1035, 1048576000u, 1061158912u, 1048576000u, 0, COPYSIGNF_TOLERANCE, 0},
{1036, 1048576000u, 1061997773u, 1048576000u, 0, COPYSIGNF_TOLERANCE, 0},
{1037, 1048576000u, 1062836634u, 1048576000u, 0, COPYSIGNF_TOLERANCE, 0},
{1038, 1048576000u, 1063675494u, 1048576000u, 0, COPYSIGNF_TOLERANCE, 0},
{1039, 1048576000u, 1064514355u, 1048576000u, 0, COPYSIGNF_TOLERANCE, 0},
{1040, 1050253722u, 3212836864u, 3197737370u, 0, COPYSIGNF_TOLERANCE, 0},
{1041, 1050253722u, 3211998003u, 3197737370u, 0, COPYSIGNF_TOLERANCE, 0},
{1042, 1050253722u, 3211159142u, 3197737370u, 0, COPYSIGNF_TOLERANCE, 0},
{1043, 1050253722u, 3210320282u, 3197737370u, 0, COPYSIGNF_TOLERANCE, 0},
{1044, 1050253722u, 3209481421u, 3197737370u, 0, COPYSIGNF_TOLERANCE, 0},
{1045, 1050253722u, 3208642560u, 3197737370u, 0, COPYSIGNF_TOLERANCE, 0},
{1046, 1050253722u, 3207803699u, 3197737370u, 0, COPYSIGNF_TOLERANCE, 0},
{1047, 1050253722u, 3206964838u, 3197737370u, 0, COPYSIGNF_TOLERANCE, 0},
{1048, 1050253722u, 3206125978u, 3197737370u, 0, COPYSIGNF_TOLERANCE, 0},
{1049, 1050253722u, 3205287117u, 3197737370u, 0, COPYSIGNF_TOLERANCE, 0},
{1050, 1050253722u, 3204448256u, 3197737370u, 0, COPYSIGNF_TOLERANCE, 0},
{1051, 1050253722u, 3202770534u, 3197737370u, 0, COPYSIGNF_TOLERANCE, 0},
{1052, 1050253722u, 3201092813u, 3197737370u, 0, COPYSIGNF_TOLERANCE, 0},
{1053, 1050253722u, 3199415091u, 3197737370u, 0, COPYSIGNF_TOLERANCE, 0},
{1054, 1050253722u, 3197737370u, 3197737370u, 0, COPYSIGNF_TOLERANCE, 0},
{1055, 1050253722u, 3196059648u, 3197737370u, 0, COPYSIGNF_TOLERANCE, 0},
{1056, 1050253722u, 3192704205u, 3197737370u, 0, COPYSIGNF_TOLERANCE, 0},
{1057, 1050253722u, 3189348762u, 3197737370u, 0, COPYSIGNF_TOLERANCE, 0},
{1058, 1050253722u, 3184315597u, 3197737370u, 0, COPYSIGNF_TOLERANCE, 0},
{1059, 1050253722u, 3175926989u, 3197737370u, 0, COPYSIGNF_TOLERANCE, 0},
{1060, 1050253722u, 632815616u, 1050253722u, 0, COPYSIGNF_TOLERANCE, 0},
{1061, 1050253722u, 1028443341u, 1050253722u, 0, COPYSIGNF_TOLERANCE, 0},
{1062, 1050253722u, 1036831949u, 1050253722u, 0, COPYSIGNF_TOLERANCE, 0},
{1063, 1050253722u, 1041865114u, 1050253722u, 0, COPYSIGNF_TOLERANCE, 0},
{1064, 1050253722u, 1045220557u, 1050253722u, 0, COPYSIGNF_TOLERANCE, 0},
{1065, 1050253722u, 1048576000u, 1050253722u, 0, COPYSIGNF_TOLERANCE, 0},
{1066, 1050253722u, 1050253722u, 1050253722u, 0, COPYSIGNF_TOLERANCE, 0},
{1067, 1050253722u, 1051931443u, 1050253722u, 0, COPYSIGNF_TOLERANCE, 0},
{1068, 1050253722u, 1053609165u, 1050253722u, 0, COPYSIGNF_TOLERANCE, 0},
{1069, 1050253722u, 1055286886u, 1050253722u, 0, COPYSIGNF_TOLERANCE, 0},
{1070, 1050253722u, 1056964608u, 1050253722u, 0, COPYSIGNF_TOLERANCE, 0},
{1071, 1050253722u, 1057803469u, 1050253722u, 0, COPYSIGNF_TOLERANCE, 0},
{1072, 1050253722u, 1058642330u, 1050253722u, 0, COPYSIGNF_TOLERANCE, 0},
{1073, 1050253722u, 1059481190u, 1050253722u, 0, COPYSIGNF_TOLERANCE, 0},
{1074, 1050253722u, 1060320051u, 1050253722u, 0, COPYSIGNF_TOLERANCE, 0},
{1075, 1050253722u, 1061158912u, 1050253722u, 0, COPYSIGNF_TOLERANCE, 0},
{1076, 1050253722u, 1061997773u, 1050253722u, 0, COPYSIGNF_TOLERANCE, 0},
{1077, 1050253722u, 1062836634u, 1050253722u, 0, COPYSIGNF_TOLERANCE, 0},
{1078, 1050253722u, 1063675494u, 1050253722u, 0, COPYSIGNF_TOLERANCE, 0},
{1079, 1050253722u, 1064514355u, 1050253722u, 0, COPYSIGNF_TOLERANCE, 0},
{1080, 1051931443u, 3212836864u, 3199415091u, 0, COPYSIGNF_TOLERANCE, 0},
{1081, 1051931443u, 3211998003u, 3199415091u, 0, COPYSIGNF_TOLERANCE, 0},
{1082, 1051931443u, 3211159142u, 3199415091u, 0, COPYSIGNF_TOLERANCE, 0},
{1083, 1051931443u, 3210320282u, 3199415091u, 0, COPYSIGNF_TOLERANCE, 0},
{1084, 1051931443u, 3209481421u, 3199415091u, 0, COPYSIGNF_TOLERANCE, 0},
{1085, 1051931443u, 3208642560u, 3199415091u, 0, COPYSIGNF_TOLERANCE, 0},
{1086, 1051931443u, 3207803699u, 3199415091u, 0, COPYSIGNF_TOLERANCE, 0},
{1087, 1051931443u, 3206964838u, 3199415091u, 0, COPYSIGNF_TOLERANCE, 0},
{1088, 1051931443u, 3206125978u, 3199415091u, 0, COPYSIGNF_TOLERANCE, 0},
{1089, 1051931443u, 3205287117u, 3199415091u, 0, COPYSIGNF_TOLERANCE, 0},
{1090, 1051931443u, 3204448256u, 3199415091u, 0, COPYSIGNF_TOLERANCE, 0},
{1091, 1051931443u, 3202770534u, 3199415091u, 0, COPYSIGNF_TOLERANCE, 0},
{1092, 1051931443u, 3201092813u, 3199415091u, 0, COPYSIGNF_TOLERANCE, 0},
{1093, 1051931443u, 3199415091u, 3199415091u, 0, COPYSIGNF_TOLERANCE, 0},
{1094, 1051931443u, 3197737370u, 3199415091u, 0, COPYSIGNF_TOLERANCE, 0},
{1095, 1051931443u, 3196059648u, 3199415091u, 0, COPYSIGNF_TOLERANCE, 0},
{1096, 1051931443u, 3192704205u, 3199415091u, 0, COPYSIGNF_TOLERANCE, 0},
{1097, 1051931443u, 3189348762u, 3199415091u, 0, COPYSIGNF_TOLERANCE, 0},
{1098, 1051931443u, 3184315597u, 3199415091u, 0, COPYSIGNF_TOLERANCE, 0},
{1099, 1051931443u, 3175926989u, 3199415091u, 0, COPYSIGNF_TOLERANCE, 0},
{1100, 1051931443u, 632815616u, 1051931443u, 0, COPYSIGNF_TOLERANCE, 0},
{1101, 1051931443u, 1028443341u, 1051931443u, 0, COPYSIGNF_TOLERANCE, 0},
{1102, 1051931443u, 1036831949u, 1051931443u, 0, COPYSIGNF_TOLERANCE, 0},
{1103, 1051931443u, 1041865114u, 1051931443u, 0, COPYSIGNF_TOLERANCE, 0},
{1104, 1051931443u, 1045220557u, 1051931443u, 0, COPYSIGNF_TOLERANCE, 0},
{1105, 1051931443u, 1048576000u, 1051931443u, 0, COPYSIGNF_TOLERANCE, 0},
{1106, 1051931443u, 1050253722u, 1051931443u, 0, COPYSIGNF_TOLERANCE, 0},
{1107, 1051931443u, 1051931443u, 1051931443u, 0, COPYSIGNF_TOLERANCE, 0},
{1108, 1051931443u, 1053609165u, 1051931443u, 0, COPYSIGNF_TOLERANCE, 0},
{1109, 1051931443u, 1055286886u, 1051931443u, 0, COPYSIGNF_TOLERANCE, 0},
{1110, 1051931443u, 1056964608u, 1051931443u, 0, COPYSIGNF_TOLERANCE, 0},
{1111, 1051931443u, 1057803469u, 1051931443u, 0, COPYSIGNF_TOLERANCE, 0},
{1112, 1051931443u, 1058642330u, 1051931443u, 0, COPYSIGNF_TOLERANCE, 0},
{1113, 1051931443u, 1059481190u, 1051931443u, 0, COPYSIGNF_TOLERANCE, 0},
{1114, 1051931443u, 1060320051u, 1051931443u, 0, COPYSIGNF_TOLERANCE, 0},
{1115, 1051931443u, 1061158912u, 1051931443u, 0, COPYSIGNF_TOLERANCE, 0},
{1116, 1051931443u, 1061997773u, 1051931443u, 0, COPYSIGNF_TOLERANCE, 0},
{1117, 1051931443u, 1062836634u, 1051931443u, 0, COPYSIGNF_TOLERANCE, 0},
{1118, 1051931443u, 1063675494u, 1051931443u, 0, COPYSIGNF_TOLERANCE, 0},
{1119, 1051931443u, 1064514355u, 1051931443u, 0, COPYSIGNF_TOLERANCE, 0},
{1120, 1053609165u, 3212836864u, 3201092813u, 0, COPYSIGNF_TOLERANCE, 0},
{1121, 1053609165u, 3211998003u, 3201092813u, 0, COPYSIGNF_TOLERANCE, 0},
{1122, 1053609165u, 3211159142u, 3201092813u, 0, COPYSIGNF_TOLERANCE, 0},
{1123, 1053609165u, 3210320282u, 3201092813u, 0, COPYSIGNF_TOLERANCE, 0},
{1124, 1053609165u, 3209481421u, 3201092813u, 0, COPYSIGNF_TOLERANCE, 0},
{1125, 1053609165u, 3208642560u, 3201092813u, 0, COPYSIGNF_TOLERANCE, 0},
{1126, 1053609165u, 3207803699u, 3201092813u, 0, COPYSIGNF_TOLERANCE, 0},
{1127, 1053609165u, 3206964838u, 3201092813u, 0, COPYSIGNF_TOLERANCE, 0},
{1128, 1053609165u, 3206125978u, 3201092813u, 0, COPYSIGNF_TOLERANCE, 0},
{1129, 1053609165u, 3205287117u, 3201092813u, 0, COPYSIGNF_TOLERANCE, 0},
{1130, 1053609165u, 3204448256u, 3201092813u, 0, COPYSIGNF_TOLERANCE, 0},
{1131, 1053609165u, 3202770534u, 3201092813u, 0, COPYSIGNF_TOLERANCE, 0},
{1132, 1053609165u, 3201092813u, 3201092813u, 0, COPYSIGNF_TOLERANCE, 0},
{1133, 1053609165u, 3199415091u, 3201092813u, 0, COPYSIGNF_TOLERANCE, 0},
{1134, 1053609165u, 3197737370u, 3201092813u, 0, COPYSIGNF_TOLERANCE, 0},
{1135, 1053609165u, 3196059648u, 3201092813u, 0, COPYSIGNF_TOLERANCE, 0},
{1136, 1053609165u, 3192704205u, 3201092813u, 0, COPYSIGNF_TOLERANCE, 0},
{1137, 1053609165u, 3189348762u, 3201092813u, 0, COPYSIGNF_TOLERANCE, 0},
{1138, 1053609165u, 3184315597u, 3201092813u, 0, COPYSIGNF_TOLERANCE, 0},
{1139, 1053609165u, 3175926989u, 3201092813u, 0, COPYSIGNF_TOLERANCE, 0},
{1140, 1053609165u, 632815616u, 1053609165u, 0, COPYSIGNF_TOLERANCE, 0},
{1141, 1053609165u, 1028443341u, 1053609165u, 0, COPYSIGNF_TOLERANCE, 0},
{1142, 1053609165u, 1036831949u, 1053609165u, 0, COPYSIGNF_TOLERANCE, 0},
{1143, 1053609165u, 1041865114u, 1053609165u, 0, COPYSIGNF_TOLERANCE, 0},
{1144, 1053609165u, 1045220557u, 1053609165u, 0, COPYSIGNF_TOLERANCE, 0},
{1145, 1053609165u, 1048576000u, 1053609165u, 0, COPYSIGNF_TOLERANCE, 0},
{1146, 1053609165u, 1050253722u, 1053609165u, 0, COPYSIGNF_TOLERANCE, 0},
{1147, 1053609165u, 1051931443u, 1053609165u, 0, COPYSIGNF_TOLERANCE, 0},
{1148, 1053609165u, 1053609165u, 1053609165u, 0, COPYSIGNF_TOLERANCE, 0},
{1149, 1053609165u, 1055286886u, 1053609165u, 0, COPYSIGNF_TOLERANCE, 0},
{1150, 1053609165u, 1056964608u, 1053609165u, 0, COPYSIGNF_TOLERANCE, 0},
{1151, 1053609165u, 1057803469u, 1053609165u, 0, COPYSIGNF_TOLERANCE, 0},
{1152, 1053609165u, 1058642330u, 1053609165u, 0, COPYSIGNF_TOLERANCE, 0},
{1153, 1053609165u, 1059481190u, 1053609165u, 0, COPYSIGNF_TOLERANCE, 0},
{1154, 1053609165u, 1060320051u, 1053609165u, 0, COPYSIGNF_TOLERANCE, 0},
{1155, 1053609165u, 1061158912u, 1053609165u, 0, COPYSIGNF_TOLERANCE, 0},
{1156, 1053609165u, 1061997773u, 1053609165u, 0, COPYSIGNF_TOLERANCE, 0},
{1157, 1053609165u, 1062836634u, 1053609165u, 0, COPYSIGNF_TOLERANCE, 0},
{1158, 1053609165u, 1063675494u, 1053609165u, 0, COPYSIGNF_TOLERANCE, 0},
{1159, 1053609165u, 1064514355u, 1053609165u, 0, COPYSIGNF_TOLERANCE, 0},
{1160, 1055286886u, 3212836864u, 3202770534u, 0, COPYSIGNF_TOLERANCE, 0},
{1161, 1055286886u, 3211998003u, 3202770534u, 0, COPYSIGNF_TOLERANCE, 0},
{1162, 1055286886u, 3211159142u, 3202770534u, 0, COPYSIGNF_TOLERANCE, 0},
{1163, 1055286886u, 3210320282u, 3202770534u, 0, COPYSIGNF_TOLERANCE, 0},
{1164, 1055286886u, 3209481421u, 3202770534u, 0, COPYSIGNF_TOLERANCE, 0},
{1165, 1055286886u, 3208642560u, 3202770534u, 0, COPYSIGNF_TOLERANCE, 0},
{1166, 1055286886u, 3207803699u, 3202770534u, 0, COPYSIGNF_TOLERANCE, 0},
{1167, 1055286886u, 3206964838u, 3202770534u, 0, COPYSIGNF_TOLERANCE, 0},
{1168, 1055286886u, 3206125978u, 3202770534u, 0, COPYSIGNF_TOLERANCE, 0},
{1169, 1055286886u, 3205287117u, 3202770534u, 0, COPYSIGNF_TOLERANCE, 0},
{1170, 1055286886u, 3204448256u, 3202770534u, 0, COPYSIGNF_TOLERANCE, 0},
{1171, 1055286886u, 3202770534u, 3202770534u, 0, COPYSIGNF_TOLERANCE, 0},
{1172, 1055286886u, 3201092813u, 3202770534u, 0, COPYSIGNF_TOLERANCE, 0},
{1173, 1055286886u, 3199415091u, 3202770534u, 0, COPYSIGNF_TOLERANCE, 0},
{1174, 1055286886u, 3197737370u, 3202770534u, 0, COPYSIGNF_TOLERANCE, 0},
{1175, 1055286886u, 3196059648u, 3202770534u, 0, COPYSIGNF_TOLERANCE, 0},
{1176, 1055286886u, 3192704205u, 3202770534u, 0, COPYSIGNF_TOLERANCE, 0},
{1177, 1055286886u, 3189348762u, 3202770534u, 0, COPYSIGNF_TOLERANCE, 0},
{1178, 1055286886u, 3184315597u, 3202770534u, 0, COPYSIGNF_TOLERANCE, 0},
{1179, 1055286886u, 3175926989u, 3202770534u, 0, COPYSIGNF_TOLERANCE, 0},
{1180, 1055286886u, 632815616u, 1055286886u, 0, COPYSIGNF_TOLERANCE, 0},
{1181, 1055286886u, 1028443341u, 1055286886u, 0, COPYSIGNF_TOLERANCE, 0},
{1182, 1055286886u, 1036831949u, 1055286886u, 0, COPYSIGNF_TOLERANCE, 0},
{1183, 1055286886u, 1041865114u, 1055286886u, 0, COPYSIGNF_TOLERANCE, 0},
{1184, 1055286886u, 1045220557u, 1055286886u, 0, COPYSIGNF_TOLERANCE, 0},
{1185, 1055286886u, 1048576000u, 1055286886u, 0, COPYSIGNF_TOLERANCE, 0},
{1186, 1055286886u, 1050253722u, 1055286886u, 0, COPYSIGNF_TOLERANCE, 0},
{1187, 1055286886u, 1051931443u, 1055286886u, 0, COPYSIGNF_TOLERANCE, 0},
{1188, 1055286886u, 1053609165u, 1055286886u, 0, COPYSIGNF_TOLERANCE, 0},
{1189, 1055286886u, 1055286886u, 1055286886u, 0, COPYSIGNF_TOLERANCE, 0},
{1190, 1055286886u, 1056964608u, 1055286886u, 0, COPYSIGNF_TOLERANCE, 0},
{1191, 1055286886u, 1057803469u, 1055286886u, 0, COPYSIGNF_TOLERANCE, 0},
{1192, 1055286886u, 1058642330u, 1055286886u, 0, COPYSIGNF_TOLERANCE, 0},
{1193, 1055286886u, 1059481190u, 1055286886u, 0, COPYSIGNF_TOLERANCE, 0},
{1194, 1055286886u, 1060320051u, 1055286886u, 0, COPYSIGNF_TOLERANCE, 0},
{1195, 1055286886u, 1061158912u, 1055286886u, 0, COPYSIGNF_TOLERANCE, 0},
{1196, 1055286886u, 1061997773u, 1055286886u, 0, COPYSIGNF_TOLERANCE, 0},
{1197, 1055286886u, 1062836634u, 1055286886u, 0, COPYSIGNF_TOLERANCE, 0},
{1198, 1055286886u, 1063675494u, 1055286886u, 0, COPYSIGNF_TOLERANCE, 0},
{1199, 1055286886u, 1064514355u, 1055286886u, 0, COPYSIGNF_TOLERANCE, 0},
{1200, 1056964608u, 3212836864u, 3204448256u, 0, COPYSIGNF_TOLERANCE, 0},
{1201, 1056964608u, 3211998003u, 3204448256u, 0, COPYSIGNF_TOLERANCE, 0},
{1202, 1056964608u, 3211159142u, 3204448256u, 0, COPYSIGNF_TOLERANCE, 0},
{1203, 1056964608u, 3210320282u, 3204448256u, 0, COPYSIGNF_TOLERANCE, 0},
{1204, 1056964608u, 3209481421u, 3204448256u, 0, COPYSIGNF_TOLERANCE, 0},
{1205, 1056964608u, 3208642560u, 3204448256u, 0, COPYSIGNF_TOLERANCE, 0},
{1206, 1056964608u, 3207803699u, 3204448256u, 0, COPYSIGNF_TOLERANCE, 0},
{1207, 1056964608u, 3206964838u, 3204448256u, 0, COPYSIGNF_TOLERANCE, 0},
{1208, 1056964608u, 3206125978u, 3204448256u, 0, COPYSIGNF_TOLERANCE, 0},
{1209, 1056964608u, 3205287117u, 3204448256u, 0, COPYSIGNF_TOLERANCE, 0},
{1210, 1056964608u, 3204448256u, 3204448256u, 0, COPYSIGNF_TOLERANCE, 0},
{1211, 1056964608u, 3202770534u, 3204448256u, 0, COPYSIGNF_TOLERANCE, 0},
{1212, 1056964608u, 3201092813u, 3204448256u, 0, COPYSIGNF_TOLERANCE, 0},
{1213, 1056964608u, 3199415091u, 3204448256u, 0, COPYSIGNF_TOLERANCE, 0},
{1214, 1056964608u, 3197737370u, 3204448256u, 0, COPYSIGNF_TOLERANCE, 0},
{1215, 1056964608u, 3196059648u, 3204448256u, 0, COPYSIGNF_TOLERANCE, 0},
{1216, 1056964608u, 3192704205u, 3204448256u, 0, COPYSIGNF_TOLERANCE, 0},
{1217, 1056964608u, 3189348762u, 3204448256u, 0, COPYSIGNF_TOLERANCE, 0},
{1218, 1056964608u, 3184315597u, 3204448256u, 0, COPYSIGNF_TOLERANCE, 0},
{1219, 1056964608u, 3175926989u, 3204448256u, 0, COPYSIGNF_TOLERANCE, 0},
{1220, 1056964608u, 632815616u, 1056964608u, 0, COPYSIGNF_TOLERANCE, 0},
{1221, 1056964608u, 1028443341u, 1056964608u, 0, COPYSIGNF_TOLERANCE, 0},
{1222, 1056964608u, 1036831949u, 1056964608u, 0, COPYSIGNF_TOLERANCE, 0},
{1223, 1056964608u, 1041865114u, 1056964608u, 0, COPYSIGNF_TOLERANCE, 0},
{1224, 1056964608u, 1045220557u, 1056964608u, 0, COPYSIGNF_TOLERANCE, 0},
{1225, 1056964608u, 1048576000u, 1056964608u, 0, COPYSIGNF_TOLERANCE, 0},
{1226, 1056964608u, 1050253722u, 1056964608u, 0, COPYSIGNF_TOLERANCE, 0},
{1227, 1056964608u, 1051931443u, 1056964608u, 0, COPYSIGNF_TOLERANCE, 0},
{1228, 1056964608u, 1053609165u, 1056964608u, 0, COPYSIGNF_TOLERANCE, 0},
{1229, 1056964608u, 1055286886u, 1056964608u, 0, COPYSIGNF_TOLERANCE, 0},
{1230, 1056964608u, 1056964608u, 1056964608u, 0, COPYSIGNF_TOLERANCE, 0},
{1231, 1056964608u, 1057803469u, 1056964608u, 0, COPYSIGNF_TOLERANCE, 0},
{1232, 1056964608u, 1058642330u, 1056964608u, 0, COPYSIGNF_TOLERANCE, 0},
{1233, 1056964608u, 1059481190u, 1056964608u, 0, COPYSIGNF_TOLERANCE, 0},
{1234, 1056964608u, 1060320051u, 1056964608u, 0, COPYSIGNF_TOLERANCE, 0},
{1235, 1056964608u, 1061158912u, 1056964608u, 0, COPYSIGNF_TOLERANCE, 0},
{1236, 1056964608u, 1061997773u, 1056964608u, 0, COPYSIGNF_TOLERANCE, 0},
{1237, 1056964608u, 1062836634u, 1056964608u, 0, COPYSIGNF_TOLERANCE, 0},
{1238, 1056964608u, 1063675494u, 1056964608u, 0, COPYSIGNF_TOLERANCE, 0},
{1239, 1056964608u, 1064514355u, 1056964608u, 0, COPYSIGNF_TOLERANCE, 0},
{1240, 1057803469u, 3212836864u, 3205287117u, 0, COPYSIGNF_TOLERANCE, 0},
{1241, 1057803469u, 3211998003u, 3205287117u, 0, COPYSIGNF_TOLERANCE, 0},
{1242, 1057803469u, 3211159142u, 3205287117u, 0, COPYSIGNF_TOLERANCE, 0},
{1243, 1057803469u, 3210320282u, 3205287117u, 0, COPYSIGNF_TOLERANCE, 0},
{1244, 1057803469u, 3209481421u, 3205287117u, 0, COPYSIGNF_TOLERANCE, 0},
{1245, 1057803469u, 3208642560u, 3205287117u, 0, COPYSIGNF_TOLERANCE, 0},
{1246, 1057803469u, 3207803699u, 3205287117u, 0, COPYSIGNF_TOLERANCE, 0},
{1247, 1057803469u, 3206964838u, 3205287117u, 0, COPYSIGNF_TOLERANCE, 0},
{1248, 1057803469u, 3206125978u, 3205287117u, 0, COPYSIGNF_TOLERANCE, 0},
{1249, 1057803469u, 3205287117u, 3205287117u, 0, COPYSIGNF_TOLERANCE, 0},
{1250, 1057803469u, 3204448256u, 3205287117u, 0, COPYSIGNF_TOLERANCE, 0},
{1251, 1057803469u, 3202770534u, 3205287117u, 0, COPYSIGNF_TOLERANCE, 0},
{1252, 1057803469u, 3201092813u, 3205287117u, 0, COPYSIGNF_TOLERANCE, 0},
{1253, 1057803469u, 3199415091u, 3205287117u, 0, COPYSIGNF_TOLERANCE, 0},
{1254, 1057803469u, 3197737370u, 3205287117u, 0, COPYSIGNF_TOLERANCE, 0},
{1255, 1057803469u, 3196059648u, 3205287117u, 0, COPYSIGNF_TOLERANCE, 0},
{1256, 1057803469u, 3192704205u, 3205287117u, 0, COPYSIGNF_TOLERANCE, 0},
{1257, 1057803469u, 3189348762u, 3205287117u, 0, COPYSIGNF_TOLERANCE, 0},
{1258, 1057803469u, 3184315597u, 3205287117u, 0, COPYSIGNF_TOLERANCE, 0},
{1259, 1057803469u, 3175926989u, 3205287117u, 0, COPYSIGNF_TOLERANCE, 0},
{1260, 1057803469u, 632815616u, 1057803469u, 0, COPYSIGNF_TOLERANCE, 0},
{1261, 1057803469u, 1028443341u, 1057803469u, 0, COPYSIGNF_TOLERANCE, 0},
{1262, 1057803469u, 1036831949u, 1057803469u, 0, COPYSIGNF_TOLERANCE, 0},
{1263, 1057803469u, 1041865114u, 1057803469u, 0, COPYSIGNF_TOLERANCE, 0},
{1264, 1057803469u, 1045220557u, 1057803469u, 0, COPYSIGNF_TOLERANCE, 0},
{1265, 1057803469u, 1048576000u, 1057803469u, 0, COPYSIGNF_TOLERANCE, 0},
{1266, 1057803469u, 1050253722u, 1057803469u, 0, COPYSIGNF_TOLERANCE, 0},
{1267, 1057803469u, 1051931443u, 1057803469u, 0, COPYSIGNF_TOLERANCE, 0},
{1268, 1057803469u, 1053609165u, 1057803469u, 0, COPYSIGNF_TOLERANCE, 0},
{1269, 1057803469u, 1055286886u, 1057803469u, 0, COPYSIGNF_TOLERANCE, 0},
{1270, 1057803469u, 1056964608u, 1057803469u, 0, COPYSIGNF_TOLERANCE, 0},
{1271, 1057803469u, 1057803469u, 1057803469u, 0, COPYSIGNF_TOLERANCE, 0},
{1272, 1057803469u, 1058642330u, 1057803469u, 0, COPYSIGNF_TOLERANCE, 0},
{1273, 1057803469u, 1059481190u, 1057803469u, 0, COPYSIGNF_TOLERANCE, 0},
{1274, 1057803469u, 1060320051u, 1057803469u, 0, COPYSIGNF_TOLERANCE, 0},
{1275, 1057803469u, 1061158912u, 1057803469u, 0, COPYSIGNF_TOLERANCE, 0},
{1276, 1057803469u, 1061997773u, 1057803469u, 0, COPYSIGNF_TOLERANCE, 0},
{1277, 1057803469u, 1062836634u, 1057803469u, 0, COPYSIGNF_TOLERANCE, 0},
{1278, 1057803469u, 1063675494u, 1057803469u, 0, COPYSIGNF_TOLERANCE, 0},
{1279, 1057803469u, 1064514355u, 1057803469u, 0, COPYSIGNF_TOLERANCE, 0},
{1280, 1058642330u, 3212836864u, 3206125978u, 0, COPYSIGNF_TOLERANCE, 0},
{1281, 1058642330u, 3211998003u, 3206125978u, 0, COPYSIGNF_TOLERANCE, 0},
{1282, 1058642330u, 3211159142u, 3206125978u, 0, COPYSIGNF_TOLERANCE, 0},
{1283, 1058642330u, 3210320282u, 3206125978u, 0, COPYSIGNF_TOLERANCE, 0},
{1284, 1058642330u, 3209481421u, 3206125978u, 0, COPYSIGNF_TOLERANCE, 0},
{1285, 1058642330u, 3208642560u, 3206125978u, 0, COPYSIGNF_TOLERANCE, 0},
{1286, 1058642330u, 3207803699u, 3206125978u, 0, COPYSIGNF_TOLERANCE, 0},
{1287, 1058642330u, 3206964838u, 3206125978u, 0, COPYSIGNF_TOLERANCE, 0},
{1288, 1058642330u, 3206125978u, 3206125978u, 0, COPYSIGNF_TOLERANCE, 0},
{1289, 1058642330u, 3205287117u, 3206125978u, 0, COPYSIGNF_TOLERANCE, 0},
{1290, 1058642330u, 3204448256u, 3206125978u, 0, COPYSIGNF_TOLERANCE, 0},
{1291, 1058642330u, 3202770534u, 3206125978u, 0, COPYSIGNF_TOLERANCE, 0},
{1292, 1058642330u, 3201092813u, 3206125978u, 0, COPYSIGNF_TOLERANCE, 0},
{1293, 1058642330u, 3199415091u, 3206125978u, 0, COPYSIGNF_TOLERANCE, 0},
{1294, 1058642330u, 3197737370u, 3206125978u, 0, COPYSIGNF_TOLERANCE, 0},
{1295, 1058642330u, 3196059648u, 3206125978u, 0, COPYSIGNF_TOLERANCE, 0},
{1296, 1058642330u, 3192704205u, 3206125978u, 0, COPYSIGNF_TOLERANCE, 0},
{1297, 1058642330u, 3189348762u, 3206125978u, 0, COPYSIGNF_TOLERANCE, 0},
{1298, 1058642330u, 3184315597u, 3206125978u, 0, COPYSIGNF_TOLERANCE, 0},
{1299, 1058642330u, 3175926989u, 3206125978u, 0, COPYSIGNF_TOLERANCE, 0},
{1300, 1058642330u, 632815616u, 1058642330u, 0, COPYSIGNF_TOLERANCE, 0},
{1301, 1058642330u, 1028443341u, 1058642330u, 0, COPYSIGNF_TOLERANCE, 0},
{1302, 1058642330u, 1036831949u, 1058642330u, 0, COPYSIGNF_TOLERANCE, 0},
{1303, 1058642330u, 1041865114u, 1058642330u, 0, COPYSIGNF_TOLERANCE, 0},
{1304, 1058642330u, 1045220557u, 1058642330u, 0, COPYSIGNF_TOLERANCE, 0},
{1305, 1058642330u, 1048576000u, 1058642330u, 0, COPYSIGNF_TOLERANCE, 0},
{1306, 1058642330u, 1050253722u, 1058642330u, 0, COPYSIGNF_TOLERANCE, 0},
{1307, 1058642330u, 1051931443u, 1058642330u, 0, COPYSIGNF_TOLERANCE, 0},
{1308, 1058642330u, 1053609165u, 1058642330u, 0, COPYSIGNF_TOLERANCE, 0},
{1309, 1058642330u, 1055286886u, 1058642330u, 0, COPYSIGNF_TOLERANCE, 0},
{1310, 1058642330u, 1056964608u, 1058642330u, 0, COPYSIGNF_TOLERANCE, 0},
{1311, 1058642330u, 1057803469u, 1058642330u, 0, COPYSIGNF_TOLERANCE, 0},
{1312, 1058642330u, 1058642330u, 1058642330u, 0, COPYSIGNF_TOLERANCE, 0},
{1313, 1058642330u, 1059481190u, 1058642330u, 0, COPYSIGNF_TOLERANCE, 0},
{1314, 1058642330u, 1060320051u, 1058642330u, 0, COPYSIGNF_TOLERANCE, 0},
{1315, 1058642330u, 1061158912u, 1058642330u, 0, COPYSIGNF_TOLERANCE, 0},
{1316, 1058642330u, 1061997773u, 1058642330u, 0, COPYSIGNF_TOLERANCE, 0},
{1317, 1058642330u, 1062836634u, 1058642330u, 0, COPYSIGNF_TOLERANCE, 0},
{1318, 1058642330u, 1063675494u, 1058642330u, 0, COPYSIGNF_TOLERANCE, 0},
{1319, 1058642330u, 1064514355u, 1058642330u, 0, COPYSIGNF_TOLERANCE, 0},
{1320, 1059481190u, 3212836864u, 3206964838u, 0, COPYSIGNF_TOLERANCE, 0},
{1321, 1059481190u, 3211998003u, 3206964838u, 0, COPYSIGNF_TOLERANCE, 0},
{1322, 1059481190u, 3211159142u, 3206964838u, 0, COPYSIGNF_TOLERANCE, 0},
{1323, 1059481190u, 3210320282u, 3206964838u, 0, COPYSIGNF_TOLERANCE, 0},
{1324, 1059481190u, 3209481421u, 3206964838u, 0, COPYSIGNF_TOLERANCE, 0},
{1325, 1059481190u, 3208642560u, 3206964838u, 0, COPYSIGNF_TOLERANCE, 0},
{1326, 1059481190u, 3207803699u, 3206964838u, 0, COPYSIGNF_TOLERANCE, 0},
{1327, 1059481190u, 3206964838u, 3206964838u, 0, COPYSIGNF_TOLERANCE, 0},
{1328, 1059481190u, 3206125978u, 3206964838u, 0, COPYSIGNF_TOLERANCE, 0},
{1329, 1059481190u, 3205287117u, 3206964838u, 0, COPYSIGNF_TOLERANCE, 0},
{1330, 1059481190u, 3204448256u, 3206964838u, 0, COPYSIGNF_TOLERANCE, 0},
{1331, 1059481190u, 3202770534u, 3206964838u, 0, COPYSIGNF_TOLERANCE, 0},
{1332, 1059481190u, 3201092813u, 3206964838u, 0, COPYSIGNF_TOLERANCE, 0},
{1333, 1059481190u, 3199415091u, 3206964838u, 0, COPYSIGNF_TOLERANCE, 0},
{1334, 1059481190u, 3197737370u, 3206964838u, 0, COPYSIGNF_TOLERANCE, 0},
{1335, 1059481190u, 3196059648u, 3206964838u, 0, COPYSIGNF_TOLERANCE, 0},
{1336, 1059481190u, 3192704205u, 3206964838u, 0, COPYSIGNF_TOLERANCE, 0},
{1337, 1059481190u, 3189348762u, 3206964838u, 0, COPYSIGNF_TOLERANCE, 0},
{1338, 1059481190u, 3184315597u, 3206964838u, 0, COPYSIGNF_TOLERANCE, 0},
{1339, 1059481190u, 3175926989u, 3206964838u, 0, COPYSIGNF_TOLERANCE, 0},
{1340, 1059481190u, 632815616u, 1059481190u, 0, COPYSIGNF_TOLERANCE, 0},
{1341, 1059481190u, 1028443341u, 1059481190u, 0, COPYSIGNF_TOLERANCE, 0},
{1342, 1059481190u, 1036831949u, 1059481190u, 0, COPYSIGNF_TOLERANCE, 0},
{1343, 1059481190u, 1041865114u, 1059481190u, 0, COPYSIGNF_TOLERANCE, 0},
{1344, 1059481190u, 1045220557u, 1059481190u, 0, COPYSIGNF_TOLERANCE, 0},
{1345, 1059481190u, 1048576000u, 1059481190u, 0, COPYSIGNF_TOLERANCE, 0},
{1346, 1059481190u, 1050253722u, 1059481190u, 0, COPYSIGNF_TOLERANCE, 0},
{1347, 1059481190u, 1051931443u, 1059481190u, 0, COPYSIGNF_TOLERANCE, 0},
{1348, 1059481190u, 1053609165u, 1059481190u, 0, COPYSIGNF_TOLERANCE, 0},
{1349, 1059481190u, 1055286886u, 1059481190u, 0, COPYSIGNF_TOLERANCE, 0},
{1350, 1059481190u, 1056964608u, 1059481190u, 0, COPYSIGNF_TOLERANCE, 0},
{1351, 1059481190u, 1057803469u, 1059481190u, 0, COPYSIGNF_TOLERANCE, 0},
{1352, 1059481190u, 1058642330u, 1059481190u, 0, COPYSIGNF_TOLERANCE, 0},
{1353, 1059481190u, 1059481190u, 1059481190u, 0, COPYSIGNF_TOLERANCE, 0},
{1354, 1059481190u, 1060320051u, 1059481190u, 0, COPYSIGNF_TOLERANCE, 0},
{1355, 1059481190u, 1061158912u, 1059481190u, 0, COPYSIGNF_TOLERANCE, 0},
{1356, 1059481190u, 1061997773u, 1059481190u, 0, COPYSIGNF_TOLERANCE, 0},
{1357, 1059481190u, 1062836634u, 1059481190u, 0, COPYSIGNF_TOLERANCE, 0},
{1358, 1059481190u, 1063675494u, 1059481190u, 0, COPYSIGNF_TOLERANCE, 0},
{1359, 1059481190u, 1064514355u, 1059481190u, 0, COPYSIGNF_TOLERANCE, 0},
{1360, 1060320051u, 3212836864u, 3207803699u, 0, COPYSIGNF_TOLERANCE, 0},
{1361, 1060320051u, 3211998003u, 3207803699u, 0, COPYSIGNF_TOLERANCE, 0},
{1362, 1060320051u, 3211159142u, 3207803699u, 0, COPYSIGNF_TOLERANCE, 0},
{1363, 1060320051u, 3210320282u, 3207803699u, 0, COPYSIGNF_TOLERANCE, 0},
{1364, 1060320051u, 3209481421u, 3207803699u, 0, COPYSIGNF_TOLERANCE, 0},
{1365, 1060320051u, 3208642560u, 3207803699u, 0, COPYSIGNF_TOLERANCE, 0},
{1366, 1060320051u, 3207803699u, 3207803699u, 0, COPYSIGNF_TOLERANCE, 0},
{1367, 1060320051u, 3206964838u, 3207803699u, 0, COPYSIGNF_TOLERANCE, 0},
{1368, 1060320051u, 3206125978u, 3207803699u, 0, COPYSIGNF_TOLERANCE, 0},
{1369, 1060320051u, 3205287117u, 3207803699u, 0, COPYSIGNF_TOLERANCE, 0},
{1370, 1060320051u, 3204448256u, 3207803699u, 0, COPYSIGNF_TOLERANCE, 0},
{1371, 1060320051u, 3202770534u, 3207803699u, 0, COPYSIGNF_TOLERANCE, 0},
{1372, 1060320051u, 3201092813u, 3207803699u, 0, COPYSIGNF_TOLERANCE, 0},
{1373, 1060320051u, 3199415091u, 3207803699u, 0, COPYSIGNF_TOLERANCE, 0},
{1374, 1060320051u, 3197737370u, 3207803699u, 0, COPYSIGNF_TOLERANCE, 0},
{1375, 1060320051u, 3196059648u, 3207803699u, 0, COPYSIGNF_TOLERANCE, 0},
{1376, 1060320051u, 3192704205u, 3207803699u, 0, COPYSIGNF_TOLERANCE, 0},
{1377, 1060320051u, 3189348762u, 3207803699u, 0, COPYSIGNF_TOLERANCE, 0},
{1378, 1060320051u, 3184315597u, 3207803699u, 0, COPYSIGNF_TOLERANCE, 0},
{1379, 1060320051u, 3175926989u, 3207803699u, 0, COPYSIGNF_TOLERANCE, 0},
{1380, 1060320051u, 632815616u, 1060320051u, 0, COPYSIGNF_TOLERANCE, 0},
{1381, 1060320051u, 1028443341u, 1060320051u, 0, COPYSIGNF_TOLERANCE, 0},
{1382, 1060320051u, 1036831949u, 1060320051u, 0, COPYSIGNF_TOLERANCE, 0},
{1383, 1060320051u, 1041865114u, 1060320051u, 0, COPYSIGNF_TOLERANCE, 0},
{1384, 1060320051u, 1045220557u, 1060320051u, 0, COPYSIGNF_TOLERANCE, 0},
{1385, 1060320051u, 1048576000u, 1060320051u, 0, COPYSIGNF_TOLERANCE, 0},
{1386, 1060320051u, 1050253722u, 1060320051u, 0, COPYSIGNF_TOLERANCE, 0},
{1387, 1060320051u, 1051931443u, 1060320051u, 0, COPYSIGNF_TOLERANCE, 0},
{1388, 1060320051u, 1053609165u, 1060320051u, 0, COPYSIGNF_TOLERANCE, 0},
{1389, 1060320051u, 1055286886u, 1060320051u, 0, COPYSIGNF_TOLERANCE, 0},
{1390, 1060320051u, 1056964608u, 1060320051u, 0, COPYSIGNF_TOLERANCE, 0},
{1391, 1060320051u, 1057803469u, 1060320051u, 0, COPYSIGNF_TOLERANCE, 0},
{1392, 1060320051u, 1058642330u, 1060320051u, 0, COPYSIGNF_TOLERANCE, 0},
{1393, 1060320051u, 1059481190u, 1060320051u, 0, COPYSIGNF_TOLERANCE, 0},
{1394, 1060320051u, 1060320051u, 1060320051u, 0, COPYSIGNF_TOLERANCE, 0},
{1395, 1060320051u, 1061158912u, 1060320051u, 0, COPYSIGNF_TOLERANCE, 0},
{1396, 1060320051u, 1061997773u, 1060320051u, 0, COPYSIGNF_TOLERANCE, 0},
{1397, 1060320051u, 1062836634u, 1060320051u, 0, COPYSIGNF_TOLERANCE, 0},
{1398, 1060320051u, 1063675494u, 1060320051u, 0, COPYSIGNF_TOLERANCE, 0},
{1399, 1060320051u, 1064514355u, 1060320051u, 0, COPYSIGNF_TOLERANCE, 0},
{1400, 1061158912u, 3212836864u, 3208642560u, 0, COPYSIGNF_TOLERANCE, 0},
{1401, 1061158912u, 3211998003u, 3208642560u, 0, COPYSIGNF_TOLERANCE, 0},
{1402, 1061158912u, 3211159142u, 3208642560u, 0, COPYSIGNF_TOLERANCE, 0},
{1403, 1061158912u, 3210320282u, 3208642560u, 0, COPYSIGNF_TOLERANCE, 0},
{1404, 1061158912u, 3209481421u, 3208642560u, 0, COPYSIGNF_TOLERANCE, 0},
{1405, 1061158912u, 3208642560u, 3208642560u, 0, COPYSIGNF_TOLERANCE, 0},
{1406, 1061158912u, 3207803699u, 3208642560u, 0, COPYSIGNF_TOLERANCE, 0},
{1407, 1061158912u, 3206964838u, 3208642560u, 0, COPYSIGNF_TOLERANCE, 0},
{1408, 1061158912u, 3206125978u, 3208642560u, 0, COPYSIGNF_TOLERANCE, 0},
{1409, 1061158912u, 3205287117u, 3208642560u, 0, COPYSIGNF_TOLERANCE, 0},
{1410, 1061158912u, 3204448256u, 3208642560u, 0, COPYSIGNF_TOLERANCE, 0},
{1411, 1061158912u, 3202770534u, 3208642560u, 0, COPYSIGNF_TOLERANCE, 0},
{1412, 1061158912u, 3201092813u, 3208642560u, 0, COPYSIGNF_TOLERANCE, 0},
{1413, 1061158912u, 3199415091u, 3208642560u, 0, COPYSIGNF_TOLERANCE, 0},
{1414, 1061158912u, 3197737370u, 3208642560u, 0, COPYSIGNF_TOLERANCE, 0},
{1415, 1061158912u, 3196059648u, 3208642560u, 0, COPYSIGNF_TOLERANCE, 0},
{1416, 1061158912u, 3192704205u, 3208642560u, 0, COPYSIGNF_TOLERANCE, 0},
{1417, 1061158912u, 3189348762u, 3208642560u, 0, COPYSIGNF_TOLERANCE, 0},
{1418, 1061158912u, 3184315597u, 3208642560u, 0, COPYSIGNF_TOLERANCE, 0},
{1419, 1061158912u, 3175926989u, 3208642560u, 0, COPYSIGNF_TOLERANCE, 0},
{1420, 1061158912u, 632815616u, 1061158912u, 0, COPYSIGNF_TOLERANCE, 0},
{1421, 1061158912u, 1028443341u, 1061158912u, 0, COPYSIGNF_TOLERANCE, 0},
{1422, 1061158912u, 1036831949u, 1061158912u, 0, COPYSIGNF_TOLERANCE, 0},
{1423, 1061158912u, 1041865114u, 1061158912u, 0, COPYSIGNF_TOLERANCE, 0},
{1424, 1061158912u, 1045220557u, 1061158912u, 0, COPYSIGNF_TOLERANCE, 0},
{1425, 1061158912u, 1048576000u, 1061158912u, 0, COPYSIGNF_TOLERANCE, 0},
{1426, 1061158912u, 1050253722u, 1061158912u, 0, COPYSIGNF_TOLERANCE, 0},
{1427, 1061158912u, 1051931443u, 1061158912u, 0, COPYSIGNF_TOLERANCE, 0},
{1428, 1061158912u, 1053609165u, 1061158912u, 0, COPYSIGNF_TOLERANCE, 0},
{1429, 1061158912u, 1055286886u, 1061158912u, 0, COPYSIGNF_TOLERANCE, 0},
{1430, 1061158912u, 1056964608u, 1061158912u, 0, COPYSIGNF_TOLERANCE, 0},
{1431, 1061158912u, 1057803469u, 1061158912u, 0, COPYSIGNF_TOLERANCE, 0},
{1432, 1061158912u, 1058642330u, 1061158912u, 0, COPYSIGNF_TOLERANCE, 0},
{1433, 1061158912u, 1059481190u, 1061158912u, 0, COPYSIGNF_TOLERANCE, 0},
{1434, 1061158912u, 1060320051u, 1061158912u, 0, COPYSIGNF_TOLERANCE, 0},
{1435, 1061158912u, 1061158912u, 1061158912u, 0, COPYSIGNF_TOLERANCE, 0},
{1436, 1061158912u, 1061997773u, 1061158912u, 0, COPYSIGNF_TOLERANCE, 0},
{1437, 1061158912u, 1062836634u, 1061158912u, 0, COPYSIGNF_TOLERANCE, 0},
{1438, 1061158912u, 1063675494u, 1061158912u, 0, COPYSIGNF_TOLERANCE, 0},
{1439, 1061158912u, 1064514355u, 1061158912u, 0, COPYSIGNF_TOLERANCE, 0},
{1440, 1061997773u, 3212836864u, 3209481421u, 0, COPYSIGNF_TOLERANCE, 0},
{1441, 1061997773u, 3211998003u, 3209481421u, 0, COPYSIGNF_TOLERANCE, 0},
{1442, 1061997773u, 3211159142u, 3209481421u, 0, COPYSIGNF_TOLERANCE, 0},
{1443, 1061997773u, 3210320282u, 3209481421u, 0, COPYSIGNF_TOLERANCE, 0},
{1444, 1061997773u, 3209481421u, 3209481421u, 0, COPYSIGNF_TOLERANCE, 0},
{1445, 1061997773u, 3208642560u, 3209481421u, 0, COPYSIGNF_TOLERANCE, 0},
{1446, 1061997773u, 3207803699u, 3209481421u, 0, COPYSIGNF_TOLERANCE, 0},
{1447, 1061997773u, 3206964838u, 3209481421u, 0, COPYSIGNF_TOLERANCE, 0},
{1448, 1061997773u, 3206125978u, 3209481421u, 0, COPYSIGNF_TOLERANCE, 0},
{1449, 1061997773u, 3205287117u, 3209481421u, 0, COPYSIGNF_TOLERANCE, 0},
{1450, 1061997773u, 3204448256u, 3209481421u, 0, COPYSIGNF_TOLERANCE, 0},
{1451, 1061997773u, 3202770534u, 3209481421u, 0, COPYSIGNF_TOLERANCE, 0},
{1452, 1061997773u, 3201092813u, 3209481421u, 0, COPYSIGNF_TOLERANCE, 0},
{1453, 1061997773u, 3199415091u, 3209481421u, 0, COPYSIGNF_TOLERANCE, 0},
{1454, 1061997773u, 3197737370u, 3209481421u, 0, COPYSIGNF_TOLERANCE, 0},
{1455, 1061997773u, 3196059648u, 3209481421u, 0, COPYSIGNF_TOLERANCE, 0},
{1456, 1061997773u, 3192704205u, 3209481421u, 0, COPYSIGNF_TOLERANCE, 0},
{1457, 1061997773u, 3189348762u, 3209481421u, 0, COPYSIGNF_TOLERANCE, 0},
{1458, 1061997773u, 3184315597u, 3209481421u, 0, COPYSIGNF_TOLERANCE, 0},
{1459, 1061997773u, 3175926989u, 3209481421u, 0, COPYSIGNF_TOLERANCE, 0},
{1460, 1061997773u, 632815616u, 1061997773u, 0, COPYSIGNF_TOLERANCE, 0},
{1461, 1061997773u, 1028443341u, 1061997773u, 0, COPYSIGNF_TOLERANCE, 0},
{1462, 1061997773u, 1036831949u, 1061997773u, 0, COPYSIGNF_TOLERANCE, 0},
{1463, 1061997773u, 1041865114u, 1061997773u, 0, COPYSIGNF_TOLERANCE, 0},
{1464, 1061997773u, 1045220557u, 1061997773u, 0, COPYSIGNF_TOLERANCE, 0},
{1465, 1061997773u, 1048576000u, 1061997773u, 0, COPYSIGNF_TOLERANCE, 0},
{1466, 1061997773u, 1050253722u, 1061997773u, 0, COPYSIGNF_TOLERANCE, 0},
{1467, 1061997773u, 1051931443u, 1061997773u, 0, COPYSIGNF_TOLERANCE, 0},
{1468, 1061997773u, 1053609165u, 1061997773u, 0, COPYSIGNF_TOLERANCE, 0},
{1469, 1061997773u, 1055286886u, 1061997773u, 0, COPYSIGNF_TOLERANCE, 0},
{1470, 1061997773u, 1056964608u, 1061997773u, 0, COPYSIGNF_TOLERANCE, 0},
{1471, 1061997773u, 1057803469u, 1061997773u, 0, COPYSIGNF_TOLERANCE, 0},
{1472, 1061997773u, 1058642330u, 1061997773u, 0, COPYSIGNF_TOLERANCE, 0},
{1473, 1061997773u, 1059481190u, 1061997773u, 0, COPYSIGNF_TOLERANCE, 0},
{1474, 1061997773u, 1060320051u, 1061997773u, 0, COPYSIGNF_TOLERANCE, 0},
{1475, 1061997773u, 1061158912u, 1061997773u, 0, COPYSIGNF_TOLERANCE, 0},
{1476, 1061997773u, 1061997773u, 1061997773u, 0, COPYSIGNF_TOLERANCE, 0},
{1477, 1061997773u, 1062836634u, 1061997773u, 0, COPYSIGNF_TOLERANCE, 0},
{1478, 1061997773u, 1063675494u, 1061997773u, 0, COPYSIGNF_TOLERANCE, 0},
{1479, 1061997773u, 1064514355u, 1061997773u, 0, COPYSIGNF_TOLERANCE, 0},
{1480, 1062836634u, 3212836864u, 3210320282u, 0, COPYSIGNF_TOLERANCE, 0},
{1481, 1062836634u, 3211998003u, 3210320282u, 0, COPYSIGNF_TOLERANCE, 0},
{1482, 1062836634u, 3211159142u, 3210320282u, 0, COPYSIGNF_TOLERANCE, 0},
{1483, 1062836634u, 3210320282u, 3210320282u, 0, COPYSIGNF_TOLERANCE, 0},
{1484, 1062836634u, 3209481421u, 3210320282u, 0, COPYSIGNF_TOLERANCE, 0},
{1485, 1062836634u, 3208642560u, 3210320282u, 0, COPYSIGNF_TOLERANCE, 0},
{1486, 1062836634u, 3207803699u, 3210320282u, 0, COPYSIGNF_TOLERANCE, 0},
{1487, 1062836634u, 3206964838u, 3210320282u, 0, COPYSIGNF_TOLERANCE, 0},
{1488, 1062836634u, 3206125978u, 3210320282u, 0, COPYSIGNF_TOLERANCE, 0},
{1489, 1062836634u, 3205287117u, 3210320282u, 0, COPYSIGNF_TOLERANCE, 0},
{1490, 1062836634u, 3204448256u, 3210320282u, 0, COPYSIGNF_TOLERANCE, 0},
{1491, 1062836634u, 3202770534u, 3210320282u, 0, COPYSIGNF_TOLERANCE, 0},
{1492, 1062836634u, 3201092813u, 3210320282u, 0, COPYSIGNF_TOLERANCE, 0},
{1493, 1062836634u, 3199415091u, 3210320282u, 0, COPYSIGNF_TOLERANCE, 0},
{1494, 1062836634u, 3197737370u, 3210320282u, 0, COPYSIGNF_TOLERANCE, 0},
{1495, 1062836634u, 3196059648u, 3210320282u, 0, COPYSIGNF_TOLERANCE, 0},
{1496, 1062836634u, 3192704205u, 3210320282u, 0, COPYSIGNF_TOLERANCE, 0},
{1497, 1062836634u, 3189348762u, 3210320282u, 0, COPYSIGNF_TOLERANCE, 0},
{1498, 1062836634u, 3184315597u, 3210320282u, 0, COPYSIGNF_TOLERANCE, 0},
{1499, 1062836634u, 3175926989u, 3210320282u, 0, COPYSIGNF_TOLERANCE, 0},
{1500, 1062836634u, 632815616u, 1062836634u, 0, COPYSIGNF_TOLERANCE, 0},
{1501, 1062836634u, 1028443341u, 1062836634u, 0, COPYSIGNF_TOLERANCE, 0},
{1502, 1062836634u, 1036831949u, 1062836634u, 0, COPYSIGNF_TOLERANCE, 0},
{1503, 1062836634u, 1041865114u, 1062836634u, 0, COPYSIGNF_TOLERANCE, 0},
{1504, 1062836634u, 1045220557u, 1062836634u, 0, COPYSIGNF_TOLERANCE, 0},
{1505, 1062836634u, 1048576000u, 1062836634u, 0, COPYSIGNF_TOLERANCE, 0},
{1506, 1062836634u, 1050253722u, 1062836634u, 0, COPYSIGNF_TOLERANCE, 0},
{1507, 1062836634u, 1051931443u, 1062836634u, 0, COPYSIGNF_TOLERANCE, 0},
{1508, 1062836634u, 1053609165u, 1062836634u, 0, COPYSIGNF_TOLERANCE, 0},
{1509, 1062836634u, 1055286886u, 1062836634u, 0, COPYSIGNF_TOLERANCE, 0},
{1510, 1062836634u, 1056964608u, 1062836634u, 0, COPYSIGNF_TOLERANCE, 0},
{1511, 1062836634u, 1057803469u, 1062836634u, 0, COPYSIGNF_TOLERANCE, 0},
{1512, 1062836634u, 1058642330u, 1062836634u, 0, COPYSIGNF_TOLERANCE, 0},
{1513, 1062836634u, 1059481190u, 1062836634u, 0, COPYSIGNF_TOLERANCE, 0},
{1514, 1062836634u, 1060320051u, 1062836634u, 0, COPYSIGNF_TOLERANCE, 0},
{1515, 1062836634u, 1061158912u, 1062836634u, 0, COPYSIGNF_TOLERANCE, 0},
{1516, 1062836634u, 1061997773u, 1062836634u, 0, COPYSIGNF_TOLERANCE, 0},
{1517, 1062836634u, 1062836634u, 1062836634u, 0, COPYSIGNF_TOLERANCE, 0},
{1518, 1062836634u, 1063675494u, 1062836634u, 0, COPYSIGNF_TOLERANCE, 0},
{1519, 1062836634u, 1064514355u, 1062836634u, 0, COPYSIGNF_TOLERANCE, 0},
{1520, 1063675494u, 3212836864u, 3211159142u, 0, COPYSIGNF_TOLERANCE, 0},
{1521, 1063675494u, 3211998003u, 3211159142u, 0, COPYSIGNF_TOLERANCE, 0},
{1522, 1063675494u, 3211159142u, 3211159142u, 0, COPYSIGNF_TOLERANCE, 0},
{1523, 1063675494u, 3210320282u, 3211159142u, 0, COPYSIGNF_TOLERANCE, 0},
{1524, 1063675494u, 3209481421u, 3211159142u, 0, COPYSIGNF_TOLERANCE, 0},
{1525, 1063675494u, 3208642560u, 3211159142u, 0, COPYSIGNF_TOLERANCE, 0},
{1526, 1063675494u, 3207803699u, 3211159142u, 0, COPYSIGNF_TOLERANCE, 0},
{1527, 1063675494u, 3206964838u, 3211159142u, 0, COPYSIGNF_TOLERANCE, 0},
{1528, 1063675494u, 3206125978u, 3211159142u, 0, COPYSIGNF_TOLERANCE, 0},
{1529, 1063675494u, 3205287117u, 3211159142u, 0, COPYSIGNF_TOLERANCE, 0},
{1530, 1063675494u, 3204448256u, 3211159142u, 0, COPYSIGNF_TOLERANCE, 0},
{1531, 1063675494u, 3202770534u, 3211159142u, 0, COPYSIGNF_TOLERANCE, 0},
{1532, 1063675494u, 3201092813u, 3211159142u, 0, COPYSIGNF_TOLERANCE, 0},
{1533, 1063675494u, 3199415091u, 3211159142u, 0, COPYSIGNF_TOLERANCE, 0},
{1534, 1063675494u, 3197737370u, 3211159142u, 0, COPYSIGNF_TOLERANCE, 0},
{1535, 1063675494u, 3196059648u, 3211159142u, 0, COPYSIGNF_TOLERANCE, 0},
{1536, 1063675494u, 3192704205u, 3211159142u, 0, COPYSIGNF_TOLERANCE, 0},
{1537, 1063675494u, 3189348762u, 3211159142u, 0, COPYSIGNF_TOLERANCE, 0},
{1538, 1063675494u, 3184315597u, 3211159142u, 0, COPYSIGNF_TOLERANCE, 0},
{1539, 1063675494u, 3175926989u, 3211159142u, 0, COPYSIGNF_TOLERANCE, 0},
{1540, 1063675494u, 632815616u, 1063675494u, 0, COPYSIGNF_TOLERANCE, 0},
{1541, 1063675494u, 1028443341u, 1063675494u, 0, COPYSIGNF_TOLERANCE, 0},
{1542, 1063675494u, 1036831949u, 1063675494u, 0, COPYSIGNF_TOLERANCE, 0},
{1543, 1063675494u, 1041865114u, 1063675494u, 0, COPYSIGNF_TOLERANCE, 0},
{1544, 1063675494u, 1045220557u, 1063675494u, 0, COPYSIGNF_TOLERANCE, 0},
{1545, 1063675494u, 1048576000u, 1063675494u, 0, COPYSIGNF_TOLERANCE, 0},
{1546, 1063675494u, 1050253722u, 1063675494u, 0, COPYSIGNF_TOLERANCE, 0},
{1547, 1063675494u, 1051931443u, 1063675494u, 0, COPYSIGNF_TOLERANCE, 0},
{1548, 1063675494u, 1053609165u, 1063675494u, 0, COPYSIGNF_TOLERANCE, 0},
{1549, 1063675494u, 1055286886u, 1063675494u, 0, COPYSIGNF_TOLERANCE, 0},
{1550, 1063675494u, 1056964608u, 1063675494u, 0, COPYSIGNF_TOLERANCE, 0},
{1551, 1063675494u, 1057803469u, 1063675494u, 0, COPYSIGNF_TOLERANCE, 0},
{1552, 1063675494u, 1058642330u, 1063675494u, 0, COPYSIGNF_TOLERANCE, 0},
{1553, 1063675494u, 1059481190u, 1063675494u, 0, COPYSIGNF_TOLERANCE, 0},
{1554, 1063675494u, 1060320051u, 1063675494u, 0, COPYSIGNF_TOLERANCE, 0},
{1555, 1063675494u, 1061158912u, 1063675494u, 0, COPYSIGNF_TOLERANCE, 0},
{1556, 1063675494u, 1061997773u, 1063675494u, 0, COPYSIGNF_TOLERANCE, 0},
{1557, 1063675494u, 1062836634u, 1063675494u, 0, COPYSIGNF_TOLERANCE, 0},
{1558, 1063675494u, 1063675494u, 1063675494u, 0, COPYSIGNF_TOLERANCE, 0},
{1559, 1063675494u, 1064514355u, 1063675494u, 0, COPYSIGNF_TOLERANCE, 0},
{1560, 1064514355u, 3212836864u, 3211998003u, 0, COPYSIGNF_TOLERANCE, 0},
{1561, 1064514355u, 3211998003u, 3211998003u, 0, COPYSIGNF_TOLERANCE, 0},
{1562, 1064514355u, 3211159142u, 3211998003u, 0, COPYSIGNF_TOLERANCE, 0},
{1563, 1064514355u, 3210320282u, 3211998003u, 0, COPYSIGNF_TOLERANCE, 0},
{1564, 1064514355u, 3209481421u, 3211998003u, 0, COPYSIGNF_TOLERANCE, 0},
{1565, 1064514355u, 3208642560u, 3211998003u, 0, COPYSIGNF_TOLERANCE, 0},
{1566, 1064514355u, 3207803699u, 3211998003u, 0, COPYSIGNF_TOLERANCE, 0},
{1567, 1064514355u, 3206964838u, 3211998003u, 0, COPYSIGNF_TOLERANCE, 0},
{1568, 1064514355u, 3206125978u, 3211998003u, 0, COPYSIGNF_TOLERANCE, 0},
{1569, 1064514355u, 3205287117u, 3211998003u, 0, COPYSIGNF_TOLERANCE, 0},
{1570, 1064514355u, 3204448256u, 3211998003u, 0, COPYSIGNF_TOLERANCE, 0},
{1571, 1064514355u, 3202770534u, 3211998003u, 0, COPYSIGNF_TOLERANCE, 0},
{1572, 1064514355u, 3201092813u, 3211998003u, 0, COPYSIGNF_TOLERANCE, 0},
{1573, 1064514355u, 3199415091u, 3211998003u, 0, COPYSIGNF_TOLERANCE, 0},
{1574, 1064514355u, 3197737370u, 3211998003u, 0, COPYSIGNF_TOLERANCE, 0},
{1575, 1064514355u, 3196059648u, 3211998003u, 0, COPYSIGNF_TOLERANCE, 0},
{1576, 1064514355u, 3192704205u, 3211998003u, 0, COPYSIGNF_TOLERANCE, 0},
{1577, 1064514355u, 3189348762u, 3211998003u, 0, COPYSIGNF_TOLERANCE, 0},
{1578, 1064514355u, 3184315597u, 3211998003u, 0, COPYSIGNF_TOLERANCE, 0},
{1579, 1064514355u, 3175926989u, 3211998003u, 0, COPYSIGNF_TOLERANCE, 0},
{1580, 1064514355u, 632815616u, 1064514355u, 0, COPYSIGNF_TOLERANCE, 0},
{1581, 1064514355u, 1028443341u, 1064514355u, 0, COPYSIGNF_TOLERANCE, 0},
{1582, 1064514355u, 1036831949u, 1064514355u, 0, COPYSIGNF_TOLERANCE, 0},
{1583, 1064514355u, 1041865114u, 1064514355u, 0, COPYSIGNF_TOLERANCE, 0},
{1584, 1064514355u, 1045220557u, 1064514355u, 0, COPYSIGNF_TOLERANCE, 0},
{1585, 1064514355u, 1048576000u, 1064514355u, 0, COPYSIGNF_TOLERANCE, 0},
{1586, 1064514355u, 1050253722u, 1064514355u, 0, COPYSIGNF_TOLERANCE, 0},
{1587, 1064514355u, 1051931443u, 1064514355u, 0, COPYSIGNF_TOLERANCE, 0},
{1588, 1064514355u, 1053609165u, 1064514355u, 0, COPYSIGNF_TOLERANCE, 0},
{1589, 1064514355u, 1055286886u, 1064514355u, 0, COPYSIGNF_TOLERANCE, 0},
{1590, 1064514355u, 1056964608u, 1064514355u, 0, COPYSIGNF_TOLERANCE, 0},
{1591, 1064514355u, 1057803469u, 1064514355u, 0, COPYSIGNF_TOLERANCE, 0},
{1592, 1064514355u, 1058642330u, 1064514355u, 0, COPYSIGNF_TOLERANCE, 0},
{1593, 1064514355u, 1059481190u, 1064514355u, 0, COPYSIGNF_TOLERANCE, 0},
{1594, 1064514355u, 1060320051u, 1064514355u, 0, COPYSIGNF_TOLERANCE, 0},
{1595, 1064514355u, 1061158912u, 1064514355u, 0, COPYSIGNF_TOLERANCE, 0},
{1596, 1064514355u, 1061997773u, 1064514355u, 0, COPYSIGNF_TOLERANCE, 0},
{1597, 1064514355u, 1062836634u, 1064514355u, 0, COPYSIGNF_TOLERANCE, 0},
{1598, 1064514355u, 1063675494u, 1064514355u, 0, COPYSIGNF_TOLERANCE, 0},
{1599, 1064514355u, 1064514355u, 1064514355u, 0, COPYSIGNF_TOLERANCE, 0},
{1600, 1107800421u, 1203999711u, 1107800421u, 0, COPYSIGNF_TOLERANCE, 0},
{1601, 3196650934u, 896005582u, 1049167286u, 0, COPYSIGNF_TOLERANCE, 0},
{1602, 3368700125u, 3308232444u, 3368700125u, 0, COPYSIGNF_TOLERANCE, 0},
{1603, 1224242132u, 3061363425u, 3371725780u, 0, COPYSIGNF_TOLERANCE, 0},
{1604, 3221027117u, 1284201705u, 1073543469u, 0, COPYSIGNF_TOLERANCE, 0},
{1605, 1198712763u, 919636942u, 1198712763u, 0, COPYSIGNF_TOLERANCE, 0},
{1606, 3159309973u, 852521077u, 1011826325u, 0, COPYSIGNF_TOLERANCE, 0},
{1607, 954173073u, 850531830u, 954173073u, 0, COPYSIGNF_TOLERANCE, 0},
{1608, 3090780435u, 1035260608u, 943296787u, 0, COPYSIGNF_TOLERANCE, 0},
{1609, 966554515u, 3234538174u, 3114038163u, 0, COPYSIGNF_TOLERANCE, 0},
{1610, 1312607135u, 1194999402u, 1312607135u, 0, COPYSIGNF_TOLERANCE, 0},
{1611, 1166191415u, 1018661564u, 1166191415u, 0, COPYSIGNF_TOLERANCE, 0},
{1612, 3111900019u, 1130472166u, 964416371u, 0, COPYSIGNF_TOLERANCE, 0},
{1613, 1234419246u, 2984575812u, 3381902894u, 0, COPYSIGNF_TOLERANCE, 0},
{1614, 1302107128u, 3370647675u, 3449590776u, 0, COPYSIGNF_TOLERANCE, 0},
{1615, 1052801068u, 3039122570u, 3200284716u, 0, COPYSIGNF_TOLERANCE, 0},
{1616, 1060849628u, 3081357692u, 3208333276u, 0, COPYSIGNF_TOLERANCE, 0},
{1617, 3484320003u, 3033957825u, 3484320003u, 0, COPYSIGNF_TOLERANCE, 0},
{1618, 3181522772u, 3305392896u, 3181522772u, 0, COPYSIGNF_TOLERANCE, 0},
{1619, 882596369u, 1256676590u, 882596369u, 0, COPYSIGNF_TOLERANCE, 0},
{1620, 1167223673u, 846102364u, 1167223673u, 0, COPYSIGNF_TOLERANCE, 0},
{1621, 968192794u, 878547432u, 968192794u, 0, COPYSIGNF_TOLERANCE, 0},
{1622, 3122346862u, 1111584337u, 974863214u, 0, COPYSIGNF_TOLERANCE, 0},
{1623, 1052361612u, 1280025214u, 1052361612u, 0, COPYSIGNF_TOLERANCE, 0},
{1624, 906701409u, 2968301825u, 3054185057u, 0, COPYSIGNF_TOLERANCE, 0},
{1625, 3471653172u, 1154138102u, 1324169524u, 0, COPYSIGNF_TOLERANCE, 0},
{1626, 3231467496u, 934336592u, 1083983848u, 0, COPYSIGNF_TOLERANCE, 0},
{1627, 1341514497u, 3466051188u, 3488998145u, 0, COPYSIGNF_TOLERANCE, 0},
{1628, 1272351391u, 3373485062u, 3419835039u, 0, COPYSIGNF_TOLERANCE, 0},
{1629, 3319724992u, 3354615790u, 3319724992u, 0, COPYSIGNF_TOLERANCE, 0},
{1630, 917622040u, 1334966485u, 917622040u, 0, COPYSIGNF_TOLERANCE, 0},
{1631, 940236348u, 3304072663u, 3087719996u, 0, COPYSIGNF_TOLERANCE, 0},
{1632, 3251541546u, 3174764041u, 3251541546u, 0, COPYSIGNF_TOLERANCE, 0},
{1633, 3099843889u, 3355962282u, 3099843889u, 0, COPYSIGNF_TOLERANCE, 0},
{1634, 3110358400u, 851145088u, 962874752u, 0, COPYSIGNF_TOLERANCE, 0},
{1635, 3371863479u, 1014861921u, 1224379831u, 0, COPYSIGNF_TOLERANCE, 0},
{1636, 3204069187u, 966573255u, 1056585539u, 0, COPYSIGNF_TOLERANCE, 0},
{1637, 1306460502u, 903489435u, 1306460502u, 0, COPYSIGNF_TOLERANCE, 0},
{1638, 1197542187u, 3024598921u, 3345025835u, 0, COPYSIGNF_TOLERANCE, 0},
{1639, 922888249u, 1139392309u, 922888249u, 0, COPYSIGNF_TOLERANCE, 0},
{1640, 1184239996u, 3224098462u, 3331723644u, 0, COPYSIGNF_TOLERANCE, 0},
{1641, 1252490238u, 1173619825u, 1252490238u, 0, COPYSIGNF_TOLERANCE, 0},
{1642, 1001673627u, 3462631271u, 3149157275u, 0, COPYSIGNF_TOLERANCE, 0},
{1643, 976098044u, 1151967422u, 976098044u, 0, COPYSIGNF_TOLERANCE, 0},
{1644, 941796645u, 886451963u, 941796645u, 0, COPYSIGNF_TOLERANCE, 0},
{1645, 3287199470u, 854245542u, 1139715822u, 0, COPYSIGNF_TOLERANCE, 0},
{1646, 893184329u, 1243067084u, 893184329u, 0, COPYSIGNF_TOLERANCE, 0},
{1647, 1143233714u, 1007268238u, 1143233714u, 0, COPYSIGNF_TOLERANCE, 0},
{1648, 1139941253u, 1147688821u, 1139941253u, 0, COPYSIGNF_TOLERANCE, 0},
{1649, 3143717025u, 3234638157u, 3143717025u, 0, COPYSIGNF_TOLERANCE, 0},
{1650, 3048866608u, 3449209899u, 3048866608u, 0, COPYSIGNF_TOLERANCE, 0},
{1651, 3240298487u, 1020260821u, 1092814839u, 0, COPYSIGNF_TOLERANCE, 0},
{1652, 1288902137u, 3123875978u, 3436385785u, 0, COPYSIGNF_TOLERANCE, 0},
{1653, 1333134799u, 1338107877u, 1333134799u, 0, COPYSIGNF_TOLERANCE, 0},
{1654, 1187847971u, 1317663644u, 1187847971u, 0, COPYSIGNF_TOLERANCE, 0},
{1655, 1038851706u, 1327544110u, 1038851706u, 0, COPYSIGNF_TOLERANCE, 0},
{1656, 3329354473u, 3165437289u, 3329354473u, 0, COPYSIGNF_TOLERANCE, 0},
{1657, 3077218579u, 1308397879u, 929734931u, 0, COPYSIGNF_TOLERANCE, 0},
{1658, 1309289088u, 1019883016u, 1309289088u, 0, COPYSIGNF_TOLERANCE, 0},
{1659, 3444653659u, 1279248024u, 1297170011u, 0, COPYSIGNF_TOLERANCE, 0},
{1660, 3405585402u, 2962345057u, 3405585402u, 0, COPYSIGNF_TOLERANCE, 0},
{1661, 3106647724u, 853848387u, 959164076u, 0, COPYSIGNF_TOLERANCE, 0},
{1662, 1106778573u, 3304487767u, 3254262221u, 0, COPYSIGNF_TOLERANCE, 0},
{1663, 1140567947u, 3069174149u, 3288051595u, 0, COPYSIGNF_TOLERANCE, 0},
{1664, 1238569473u, 873035665u, 1238569473u, 0, COPYSIGNF_TOLERANCE, 0},
{1665, 3154871957u, 1276671061u, 1007388309u, 0, COPYSIGNF_TOLERANCE, 0},
{1666, 1261071232u, 1182202773u, 1261071232u, 0, COPYSIGNF_TOLERANCE, 0},
{1667, 1175011025u, 3029705783u, 3322494673u, 0, COPYSIGNF_TOLERANCE, 0},
{1668, 1082692850u, 1211581107u, 1082692850u, 0, COPYSIGNF_TOLERANCE, 0},
{1669, 974547519u, 3475164509u, 3122031167u, 0, COPYSIGNF_TOLERANCE, 0},
{1670, 3058097085u, 3104309359u, 3058097085u, 0, COPYSIGNF_TOLERANCE, 0},
{1671, 3107252546u, 1071134451u, 959768898u, 0, COPYSIGNF_TOLERANCE, 0},
{1672, 3096032662u, 2976848821u, 3096032662u, 0, COPYSIGNF_TOLERANCE, 0},
{1673, 3197942144u, 3094120030u, 3197942144u, 0, COPYSIGNF_TOLERANCE, 0},
{1674, 3403348556u, 3184653669u, 3403348556u, 0, COPYSIGNF_TOLERANCE, 0},
{1675, 3182301130u, 3460764044u, 3182301130u, 0, COPYSIGNF_TOLERANCE, 0},
{1676, 1136411063u, 1118097422u, 1136411063u, 0, COPYSIGNF_TOLERANCE, 0},
{1677, 3239231622u, 3302723069u, 3239231622u, 0, COPYSIGNF_TOLERANCE, 0},
{1678, 3340615780u, 870350055u, 1193132132u, 0, COPYSIGNF_TOLERANCE, 0},
{1679, 998567360u, 2995278691u, 3146051008u, 0, COPYSIGNF_TOLERANCE, 0},
{1680, 3417964312u, 1321337529u, 1270480664u, 0, COPYSIGNF_TOLERANCE, 0},
{1681, 3109481038u, 1143864063u, 961997390u, 0, COPYSIGNF_TOLERANCE, 0},
{1682, 1148867223u, 1256486202u, 1148867223u, 0, COPYSIGNF_TOLERANCE, 0},
{1683, 989687421u, 3372681320u, 3137171069u, 0, COPYSIGNF_TOLERANCE, 0},
{1684, 1152956913u, 3166480640u, 3300440561u, 0, COPYSIGNF_TOLERANCE, 0},
{1685, 892922651u, 3373029087u, 3040406299u, 0, COPYSIGNF_TOLERANCE, 0},
{1686, 1109627625u, 1314158257u, 1109627625u, 0, COPYSIGNF_TOLERANCE, 0},
{1687, 1307091856u, 1103202538u, 1307091856u, 0, COPYSIGNF_TOLERANCE, 0},
{1688, 1077234132u, 3272167130u, 3224717780u, 0, COPYSIGNF_TOLERANCE, 0},
{1689, 1142167709u, 1096445242u, 1142167709u, 0, COPYSIGNF_TOLERANCE, 0},
{1690, 3426232834u, 1036705270u, 1278749186u, 0, COPYSIGNF_TOLERANCE, 0},
{1691, 3368566779u, 967249167u, 1221083131u, 0, COPYSIGNF_TOLERANCE, 0},
{1692, 3030724760u, 3349013503u, 3030724760u, 0, COPYSIGNF_TOLERANCE, 0},
{1693, 1138741813u, 3073453199u, 3286225461u, 0, COPYSIGNF_TOLERANCE, 0},
{1694, 982950501u, 982549888u, 982950501u, 0, COPYSIGNF_TOLERANCE, 0},
{1695, 1142981585u, 1015602236u, 1142981585u, 0, COPYSIGNF_TOLERANCE, 0},
{1696, 3347165962u, 3135486696u, 3347165962u, 0, COPYSIGNF_TOLERANCE, 0},
{1697, 1009535440u, 3381353228u, 3157019088u, 0, COPYSIGNF_TOLERANCE, 0},
{1698, 3103736980u, 3402950505u, 3103736980u, 0, COPYSIGNF_TOLERANCE, 0},
{1699, 3126820946u, 1077903063u, 979337298u, 0, COPYSIGNF_TOLERANCE, 0},
{1700, 3473956030u, 976891930u, 1326472382u, 0, COPYSIGNF_TOLERANCE, 0},
{1701, 3349098349u, 1055327704u, 1201614701u, 0, COPYSIGNF_TOLERANCE, 0},
{1702, 3152729489u, 1060398533u, 1005245841u, 0, COPYSIGNF_TOLERANCE, 0},
{1703, 945568720u, 3313485084u, 3093052368u, 0, COPYSIGNF_TOLERANCE, 0},
{1704, 3345489836u, 1108392401u, 1198006188u, 0, COPYSIGNF_TOLERANCE, 0},
{1705, 940893161u, 1137000140u, 940893161u, 0, COPYSIGNF_TOLERANCE, 0},
{1706, 976791751u, 3230678102u, 3124275399u, 0, COPYSIGNF_TOLERANCE, 0},
{1707, 1004442355u, 3036510596u, 3151926003u, 0, COPYSIGNF_TOLERANCE, 0},
{1708, 1108485380u, 3173536878u, 3255969028u, 0, COPYSIGNF_TOLERANCE, 0},
{1709, 1061834641u, 972388096u, 1061834641u, 0, COPYSIGNF_TOLERANCE, 0},
{1710, 3381268392u, 1146976802u, 1233784744u, 0, COPYSIGNF_TOLERANCE, 0},
{1711, 1087189715u, 2952822478u, 3234673363u, 0, COPYSIGNF_TOLERANCE, 0},
{1712, 3212952285u, 3329407365u, 3212952285u, 0, COPYSIGNF_TOLERANCE, 0},
{1713, 1000611335u, 857599439u, 1000611335u, 0, COPYSIGNF_TOLERANCE, 0},
{1714, 3466188568u, 1041678304u, 1318704920u, 0, COPYSIGNF_TOLERANCE, 0},
{1715, 3072456205u, 3160254633u, 3072456205u, 0, COPYSIGNF_TOLERANCE, 0},
{1716, 3319315516u, 3422089012u, 3319315516u, 0, COPYSIGNF_TOLERANCE, 0},
{1717, 935938416u, 1146676692u, 935938416u, 0, COPYSIGNF_TOLERANCE, 0},
{1718, 3212614372u, 1152633030u, 1065130724u, 0, COPYSIGNF_TOLERANCE, 0},
{1719, 1315030230u, 3336225884u, 3462513878u, 0, COPYSIGNF_TOLERANCE, 0},
{1720, 1134593658u, 3456812581u, 3282077306u, 0, COPYSIGNF_TOLERANCE, 0},
{1721, 977281449u, 879922831u, 977281449u, 0, COPYSIGNF_TOLERANCE, 0},
{1722, 1086198791u, 920125958u, 1086198791u, 0, COPYSIGNF_TOLERANCE, 0},
{1723, 1255152035u, 851754050u, 1255152035u, 0, COPYSIGNF_TOLERANCE, 0},
{1724, 1135271264u, 3284878412u, 3282754912u, 0, COPYSIGNF_TOLERANCE, 0},
{1725, 1094190727u, 1056854532u, 1094190727u, 0, COPYSIGNF_TOLERANCE, 0},
{1726, 1294665325u, 991185677u, 1294665325u, 0, COPYSIGNF_TOLERANCE, 0},
{1727, 1036608591u, 805416536u, 1036608591u, 0, COPYSIGNF_TOLERANCE, 0},
{1728, 3229998064u, 825237063u, 1082514416u, 0, COPYSIGNF_TOLERANCE, 0},
{1729, 3439134022u, 1043829691u, 1291650374u, 0, COPYSIGNF_TOLERANCE, 0},
{1730, 3073083133u, 1317170485u, 925599485u, 0, COPYSIGNF_TOLERANCE, 0},
{1731, 1325668223u, 970681762u, 1325668223u, 0, COPYSIGNF_TOLERANCE, 0},
{1732, 1092037607u, 1027330835u, 1092037607u, 0, COPYSIGNF_TOLERANCE, 0},
{1733, 3316278408u, 3455589207u, 3316278408u, 0, COPYSIGNF_TOLERANCE, 0},
{1734, 3295436768u, 3129873731u, 3295436768u, 0, COPYSIGNF_TOLERANCE, 0},
{1735, 1151984049u, 3074547120u, 3299467697u, 0, COPYSIGNF_TOLERANCE, 0},
{1736, 1129287043u, 3076527544u, 3276770691u, 0, COPYSIGNF_TOLERANCE, 0},
{1737, 1243664530u, 972879810u, 1243664530u, 0, COPYSIGNF_TOLERANCE, 0},
{1738, 950829092u, 929114193u, 950829092u, 0, COPYSIGNF_TOLERANCE, 0},
{1739, 1115471979u, 3047246262u, 3262955627u, 0, COPYSIGNF_TOLERANCE, 0},
{1740, 3351092088u, 3024661404u, 3351092088u, 0, COPYSIGNF_TOLERANCE, 0},
{1741, 3424479544u, 3312047722u, 3424479544u, 0, COPYSIGNF_TOLERANCE, 0},
{1742, 3241193975u, 884465785u, 1093710327u, 0, COPYSIGNF_TOLERANCE, 0},
{1743, 1030934236u, 1045139240u, 1030934236u, 0, COPYSIGNF_TOLERANCE, 0},
{1744, 3131791114u, 3408392958u, 3131791114u, 0, COPYSIGNF_TOLERANCE, 0},
{1745, 1025254314u, 3057812821u, 3172737962u, 0, COPYSIGNF_TOLERANCE, 0},
{1746, 1110545760u, 3240144177u, 3258029408u, 0, COPYSIGNF_TOLERANCE, 0},
{1747, 3180213739u, 1108793820u, 1032730091u, 0, COPYSIGNF_TOLERANCE, 0},
{1748, 3361976590u, 3138179993u, 3361976590u, 0, COPYSIGNF_TOLERANCE, 0},
{1749, 881280146u, 3421884736u, 3028763794u, 0, COPYSIGNF_TOLERANCE, 0},
{1750, 1304154705u, 2961937089u, 3451638353u, 0, COPYSIGNF_TOLERANCE, 0},
{1751, 3264443610u, 3222916705u, 3264443610u, 0, COPYSIGNF_TOLERANCE, 0},
{1752, 3374550627u, 3055856293u, 3374550627u, 0, COPYSIGNF_TOLERANCE, 0},
{1753, 899599265u, 3240118211u, 3047082913u, 0, COPYSIGNF_TOLERANCE, 0},
{1754, 1268194719u, 1332489410u, 1268194719u, 0, COPYSIGNF_TOLERANCE, 0},
{1755, 1133420220u, 1245770860u, 1133420220u, 0, COPYSIGNF_TOLERANCE, 0},
{1756, 1161858787u, 815362075u, 1161858787u, 0, COPYSIGNF_TOLERANCE, 0},
{1757, 3184462258u, 1263529646u, 1036978610u, 0, COPYSIGNF_TOLERANCE, 0},
{1758, 3295996963u, 3453334307u, 3295996963u, 0, COPYSIGNF_TOLERANCE, 0},
{1759, 1270887389u, 1156123987u, 1270887389u, 0, COPYSIGNF_TOLERANCE, 0},
{1760, 3325193181u, 993979179u, 1177709533u, 0, COPYSIGNF_TOLERANCE, 0},
{1761, 925657343u, 1315159742u, 925657343u, 0, COPYSIGNF_TOLERANCE, 0},
{1762, 3115275450u, 3008350271u, 3115275450u, 0, COPYSIGNF_TOLERANCE, 0},
{1763, 3116607482u, 3224327456u, 3116607482u, 0, COPYSIGNF_TOLERANCE, 0},
{1764, 3187892415u, 3118097315u, 3187892415u, 0, COPYSIGNF_TOLERANCE, 0},
{1765, 1189120494u, 978961471u, 1189120494u, 0, COPYSIGNF_TOLERANCE, 0},
{1766, 889030794u, 3129523970u, 3036514442u, 0, COPYSIGNF_TOLERANCE, 0},
{1767, 1323529208u, 3100744786u, 3471012856u, 0, COPYSIGNF_TOLERANCE, 0},
{1768, 3465768388u, 3190881451u, 3465768388u, 0, COPYSIGNF_TOLERANCE, 0},
{1769, 3426099899u, 1118756120u, 1278616251u, 0, COPYSIGNF_TOLERANCE, 0},
{1770, 3224857113u, 3398166843u, 3224857113u, 0, COPYSIGNF_TOLERANCE, 0},
{1771, 1065798296u, 816191940u, 1065798296u, 0, COPYSIGNF_TOLERANCE, 0},
{1772, 3328989444u, 850266225u, 1181505796u, 0, COPYSIGNF_TOLERANCE, 0},
{1773, 3357819026u, 3148475462u, 3357819026u, 0, COPYSIGNF_TOLERANCE, 0},
{1774, 1273397670u, 901308750u, 1273397670u, 0, COPYSIGNF_TOLERANCE, 0},
{1775, 3424831780u, 1304806106u, 1277348132u, 0, COPYSIGNF_TOLERANCE, 0},
{1776, 1257596246u, 3420832544u, 3405079894u, 0, COPYSIGNF_TOLERANCE, 0},
{1777, 1051773536u, 896271348u, 1051773536u, 0, COPYSIGNF_TOLERANCE, 0},
{1778, 3294752507u, 3113225954u, 3294752507u, 0, COPYSIGNF_TOLERANCE, 0},
{1779, 3424848725u, 2973850350u, 3424848725u, 0, COPYSIGNF_TOLERANCE, 0},
{1780, 1090870906u, 3294742905u, 3238354554u, 0, COPYSIGNF_TOLERANCE, 0},
{1781, 1227582289u, 1208979668u, 1227582289u, 0, COPYSIGNF_TOLERANCE, 0},
{1782, 1272325814u, 3004311296u, 3419809462u, 0, COPYSIGNF_TOLERANCE, 0},
{1783, 3359508271u, 859974315u, 1212024623u, 0, COPYSIGNF_TOLERANCE, 0},
{1784, 1137854355u, 3335041917u, 3285338003u, 0, COPYSIGNF_TOLERANCE, 0},
{1785, 3440773058u, 3204192793u, 3440773058u, 0, COPYSIGNF_TOLERANCE, 0},
{1786, 3101598400u, 3057760708u, 3101598400u, 0, COPYSIGNF_TOLERANCE, 0},
{1787, 3451216836u, 3347783723u, 3451216836u, 0, COPYSIGNF_TOLERANCE, 0},
{1788, 3437062994u, 3106834845u, 3437062994u, 0, COPYSIGNF_TOLERANCE, 0},
{1789, 1131196082u, 1164573183u, 1131196082u, 0, COPYSIGNF_TOLERANCE, 0},
{1790, 3177294154u, 1282436638u, 1029810506u, 0, COPYSIGNF_TOLERANCE, 0},
{1791, 3258097678u, 1305882290u, 1110614030u, 0, COPYSIGNF_TOLERANCE, 0},
{1792, 3460915348u, 1219372260u, 1313431700u, 0, COPYSIGNF_TOLERANCE, 0},
{1793, 3303035472u, 3153013020u, 3303035472u, 0, COPYSIGNF_TOLERANCE, 0},
{1794, 1053698677u, 3284313107u, 3201182325u, 0, COPYSIGNF_TOLERANCE, 0},
{1795, 3396166221u, 1201894512u, 1248682573u, 0, COPYSIGNF_TOLERANCE, 0},
{1796, 3037541131u, 1085398440u, 890057483u, 0, COPYSIGNF_TOLERANCE, 0},
{1797, 3458934263u, 1005577835u, 1311450615u, 0, COPYSIGNF_TOLERANCE, 0},
{1798, 1065761827u, 3333928591u, 3213245475u, 0, COPYSIGNF_TOLERANCE, 0},
{1799, 3025843188u, 820250112u, 878359540u, 0, COPYSIGNF_TOLERANCE, 0},
{1800, 926665223u, 3150815797u, 3074148871u, 0, COPYSIGNF_TOLERANCE, 0},
{1801, 1199816046u, 3143776186u, 3347299694u, 0, COPYSIGNF_TOLERANCE, 0},
{1802, 3333779015u, 952421041u, 1186295367u, 0, COPYSIGNF_TOLERANCE, 0},
{1803, 948398145u, 3238273189u, 3095881793u, 0, COPYSIGNF_TOLERANCE, 0},
{1804, 3054021468u, 1270257895u, 906537820u, 0, COPYSIGNF_TOLERANCE, 0},
{1805, 1080781593u, 1213908300u, 1080781593u, 0, COPYSIGNF_TOLERANCE, 0},
{1806, 3164749613u, 3010837763u, 3164749613u, 0, COPYSIGNF_TOLERANCE, 0},
{1807, 3235326590u, 1271705594u, 1087842942u, 0, COPYSIGNF_TOLERANCE, 0},
{1808, 3118883815u, 1051802647u, 971400167u, 0, COPYSIGNF_TOLERANCE, 0},
{1809, 965378004u, 1292594138u, 965378004u, 0, COPYSIGNF_TOLERANCE, 0},
{1810, 3226990408u, 1110755136u, 1079506760u, 0, COPYSIGNF_TOLERANCE, 0},
{1811, 3117098218u, 1122474770u, 969614570u, 0, COPYSIGNF_TOLERANCE, 0},
{1812, 1283624229u, 906796922u, 1283624229u, 0, COPYSIGNF_TOLERANCE, 0},
{1813, 970649315u, 1078286437u, 970649315u, 0, COPYSIGNF_TOLERANCE, 0},
{1814, 959776291u, 3280345347u, 3107259939u, 0, COPYSIGNF_TOLERANCE, 0},
{1815, 3341117305u, 3294559023u, 3341117305u, 0, COPYSIGNF_TOLERANCE, 0},
{1816, 1270734970u, 3355874874u, 3418218618u, 0, COPYSIGNF_TOLERANCE, 0},
{1817, 3454816067u, 868771977u, 1307332419u, 0, COPYSIGNF_TOLERANCE, 0},
{1818, 917206623u, 1172710814u, 917206623u, 0, COPYSIGNF_TOLERANCE, 0},
{1819, 1106502045u, 1290849316u, 1106502045u, 0, COPYSIGNF_TOLERANCE, 0},
{1820, 1157598381u, 3309023746u, 3305082029u, 0, COPYSIGNF_TOLERANCE, 0},
{1821, 3335234513u, 1002337336u, 1187750865u, 0, COPYSIGNF_TOLERANCE, 0},
{1822, 1279489061u, 1006049444u, 1279489061u, 0, COPYSIGNF_TOLERANCE, 0},
{1823, 3157416480u, 1309984610u, 1009932832u, 0, COPYSIGNF_TOLERANCE, 0},
{1824, 3143920719u, 3131608518u, 3143920719u, 0, COPYSIGNF_TOLERANCE, 0},
{1825, 1233171235u, 826460580u, 1233171235u, 0, COPYSIGNF_TOLERANCE, 0},
{1826, 1148920078u, 1007674793u, 1148920078u, 0, COPYSIGNF_TOLERANCE, 0},
{1827, 3064988156u, 3230867340u, 3064988156u, 0, COPYSIGNF_TOLERANCE, 0},
{1828, 3083619260u, 1159415661u, 936135612u, 0, COPYSIGNF_TOLERANCE, 0},
{1829, 1109198803u, 1221754614u, 1109198803u, 0, COPYSIGNF_TOLERANCE, 0},
{1830, 3219949483u, 1056167693u, 1072465835u, 0, COPYSIGNF_TOLERANCE, 0},
{1831, 3361149474u, 3387342069u, 3361149474u, 0, COPYSIGNF_TOLERANCE, 0},
{1832, 1207502108u, 3388073586u, 3354985756u, 0, COPYSIGNF_TOLERANCE, 0},
{1833, 1000014431u, 831213088u, 1000014431u, 0, COPYSIGNF_TOLERANCE, 0},
{1834, 3161756316u, 3143659754u, 3161756316u, 0, COPYSIGNF_TOLERANCE, 0},
{1835, 3160728744u, 3382954009u, 3160728744u, 0, COPYSIGNF_TOLERANCE, 0},
{1836, 1234530539u, 1079988872u, 1234530539u, 0, COPYSIGNF_TOLERANCE, 0},
{1837, 1017843965u, 1193076204u, 1017843965u, 0, COPYSIGNF_TOLERANCE, 0},
{1838, 951862956u, 1173464654u, 951862956u, 0, COPYSIGNF_TOLERANCE, 0},
{1839, 3306328852u, 1118701064u, 1158845204u, 0, COPYSIGNF_TOLERANCE, 0},
{1840, 1291910469u, 1211303367u, 1291910469u, 0, COPYSIGNF_TOLERANCE, 0},
{1841, 3027442905u, 1173894400u, 879959257u, 0, COPYSIGNF_TOLERANCE, 0},
{1842, 1131927531u, 3182962700u, 3279411179u, 0, COPYSIGNF_TOLERANCE, 0},
{1843, 3449879391u, 991614550u, 1302395743u, 0, COPYSIGNF_TOLERANCE, 0},
{1844, 970094304u, 3344590506u, 3117577952u, 0, COPYSIGNF_TOLERANCE, 0},
{1845, 1125551064u, 3331248076u, 3273034712u, 0, COPYSIGNF_TOLERANCE, 0},
{1846, 3427296372u, 3455289118u, 3427296372u, 0, COPYSIGNF_TOLERANCE, 0},
{1847, 1198917460u, 1327195159u, 1198917460u, 0, COPYSIGNF_TOLERANCE, 0},
{1848, 3201603336u, 820047343u, 1054119688u, 0, COPYSIGNF_TOLERANCE, 0},
{1849, 3114686212u, 3476082461u, 3114686212u, 0, COPYSIGNF_TOLERANCE, 0},
{1850, 921940707u, 2967544056u, 3069424355u, 0, COPYSIGNF_TOLERANCE, 0},
{1851, 1091906532u, 3011904455u, 3239390180u, 0, COPYSIGNF_TOLERANCE, 0},
{1852, 3393557778u, 3383396815u, 3393557778u, 0, COPYSIGNF_TOLERANCE, 0},
{1853, 1276853215u, 873199561u, 1276853215u, 0, COPYSIGNF_TOLERANCE, 0},
{1854, 3462778440u, 3349284325u, 3462778440u, 0, COPYSIGNF_TOLERANCE, 0},
{1855, 3360170117u, 3048354042u, 3360170117u, 0, COPYSIGNF_TOLERANCE, 0},
{1856, 3224245428u, 3271307999u, 3224245428u, 0, COPYSIGNF_TOLERANCE, 0},
{1857, 1120124467u, 1135619937u, 1120124467u, 0, COPYSIGNF_TOLERANCE, 0},
{1858, 1064364381u, 3180675544u, 3211848029u, 0, COPYSIGNF_TOLERANCE, 0},
{1859, 1268744779u, 3328452652u, 3416228427u, 0, COPYSIGNF_TOLERANCE, 0},
{1860, 1165195428u, 3390323168u, 3312679076u, 0, COPYSIGNF_TOLERANCE, 0},
{1861, 3044092739u, 1106497311u, 896609091u, 0, COPYSIGNF_TOLERANCE, 0},
{1862, 3149469534u, 1278465842u, 1001985886u, 0, COPYSIGNF_TOLERANCE, 0},
{1863, 3247790039u, 909788142u, 1100306391u, 0, COPYSIGNF_TOLERANCE, 0},
{1864, 3215244648u, 1083988595u, 1067761000u, 0, COPYSIGNF_TOLERANCE, 0},
{1865, 3095275931u, 989153382u, 947792283u, 0, COPYSIGNF_TOLERANCE, 0},
{1866, 3059688264u, 1117455718u, 912204616u, 0, COPYSIGNF_TOLERANCE, 0},
{1867, 1212717473u, 837873779u, 1212717473u, 0, COPYSIGNF_TOLERANCE, 0},
{1868, 3275973009u, 3450721670u, 3275973009u, 0, COPYSIGNF_TOLERANCE, 0},
{1869, 3028857014u, 3188853813u, 3028857014u, 0, COPYSIGNF_TOLERANCE, 0},
{1870, 3391162308u, 1291220039u, 1243678660u, 0, COPYSIGNF_TOLERANCE, 0},
{1871, 1044867873u, 3369493273u, 3192351521u, 0, COPYSIGNF_TOLERANCE, 0},
{1872, 1089986803u, 3462160118u, 3237470451u, 0, COPYSIGNF_TOLERANCE, 0},
{1873, 1296314700u, 2957454177u, 3443798348u, 0, COPYSIGNF_TOLERANCE, 0},
{1874, 1251462432u, 3171021770u, 3398946080u, 0, COPYSIGNF_TOLERANCE, 0},
{1875, 3485236902u, 980772835u, 1337753254u, 0, COPYSIGNF_TOLERANCE, 0},
{1876, 3262169538u, 1268270462u, 1114685890u, 0, COPYSIGNF_TOLERANCE, 0},
{1877, 3080852256u, 994641495u, 933368608u, 0, COPYSIGNF_TOLERANCE, 0},
{1878, 1022211242u, 922124181u, 1022211242u, 0, COPYSIGNF_TOLERANCE, 0},
{1879, 884661176u, 2985540645u, 3032144824u, 0, COPYSIGNF_TOLERANCE, 0},
{1880, 3071422941u, 3271100396u, 3071422941u, 0, COPYSIGNF_TOLERANCE, 0},
{1881, 989762529u, 3362011135u, 3137246177u, 0, COPYSIGNF_TOLERANCE, 0},
{1882, 1295475718u, 3212305413u, 3442959366u, 0, COPYSIGNF_TOLERANCE, 0},
{1883, 1002632518u, 3330388441u, 3150116166u, 0, COPYSIGNF_TOLERANCE, 0},
{1884, 3404372005u, 3450484255u, 3404372005u, 0, COPYSIGNF_TOLERANCE, 0},
{1885, 3158912530u, 3105501826u, 3158912530u, 0, COPYSIGNF_TOLERANCE, 0},
{1886, 1125800069u, 3256265749u, 3273283717u, 0, COPYSIGNF_TOLERANCE, 0},
{1887, 3138037576u, 3103365227u, 3138037576u, 0, COPYSIGNF_TOLERANCE, 0},
{1888, 3108384823u, 1300246663u, 960901175u, 0, COPYSIGNF_TOLERANCE, 0},
{1889, 999985470u, 3409354318u, 3147469118u, 0, COPYSIGNF_TOLERANCE, 0},
{1890, 1189421739u, 1056599002u, 1189421739u, 0, COPYSIGNF_TOLERANCE, 0},
{1891, 3075182644u, 3144159778u, 3075182644u, 0, COPYSIGNF_TOLERANCE, 0},
{1892, 3028099649u, 3391513557u, 3028099649u, 0, COPYSIGNF_TOLERANCE, 0},
{1893, 3132541814u, 3444521949u, 3132541814u, 0, COPYSIGNF_TOLERANCE, 0},
{1894, 1164046161u, 3440635788u, 3311529809u, 0, COPYSIGNF_TOLERANCE, 0},
{1895, 1292596266u, 3116569667u, 3440079914u, 0, COPYSIGNF_TOLERANCE, 0},
{1896, 3469748379u, 3412765608u, 3469748379u, 0, COPYSIGNF_TOLERANCE, 0},
{1897, 1314644642u, 3123051784u, 3462128290u, 0, COPYSIGNF_TOLERANCE, 0},
{1898, 3399813173u, 828743798u, 1252329525u, 0, COPYSIGNF_TOLERANCE, 0},
{1899, 948775569u, 3485444126u, 3096259217u, 0, COPYSIGNF_TOLERANCE, 0},
{1900, 1034611395u, 882288581u, 1034611395u, 0, COPYSIGNF_TOLERANCE, 0},
{1901, 3489122735u, 3372450889u, 3489122735u, 0, COPYSIGNF_TOLERANCE, 0},
{1902, 1181604787u, 3363067409u, 3329088435u, 0, COPYSIGNF_TOLERANCE, 0},
{1903, 3059042077u, 3204983963u, 3059042077u, 0, COPYSIGNF_TOLERANCE, 0},
{1904, 1043691622u, 3402603223u, 3191175270u, 0, COPYSIGNF_TOLERANCE, 0},
{1905, 1314588083u, 856187848u, 1314588083u, 0, COPYSIGNF_TOLERANCE, 0},
{1906, 3141533334u, 3010142974u, 3141533334u, 0, COPYSIGNF_TOLERANCE, 0},
{1907, 3157534378u, 3451674717u, 3157534378u, 0, COPYSIGNF_TOLERANCE, 0},
{1908, 3400949680u, 3073750220u, 3400949680u, 0, COPYSIGNF_TOLERANCE, 0},
{1909, 3365581801u, 1175843167u, 1218098153u, 0, COPYSIGNF_TOLERANCE, 0},
{1910, 1110424755u, 3011308654u, 3257908403u, 0, COPYSIGNF_TOLERANCE, 0},
{1911, 3189917167u, 927278934u, 1042433519u, 0, COPYSIGNF_TOLERANCE, 0},
{1912, 969804941u, 3355439348u, 3117288589u, 0, COPYSIGNF_TOLERANCE, 0},
{1913, 1139120919u, 3270515074u, 3286604567u, 0, COPYSIGNF_TOLERANCE, 0},
{1914, 934308144u, 3118191228u, 3081791792u, 0, COPYSIGNF_TOLERANCE, 0},
{1915, 1220524226u, 1152648002u, 1220524226u, 0, COPYSIGNF_TOLERANCE, 0},
{1916, 3162548604u, 3461790298u, 3162548604u, 0, COPYSIGNF_TOLERANCE, 0},
{1917, 3382391700u, 3296962745u, 3382391700u, 0, COPYSIGNF_TOLERANCE, 0},
{1918, 1156767533u, 1088986462u, 1156767533u, 0, COPYSIGNF_TOLERANCE, 0},
{1919, 3079222483u, 3312324949u, 3079222483u, 0, COPYSIGNF_TOLERANCE, 0},
{1920, 994934087u, 967678094u, 994934087u, 0, COPYSIGNF_TOLERANCE, 0},
{1921, 3185240099u, 1123403720u, 1037756451u, 0, COPYSIGNF_TOLERANCE, 0},
{1922, 3479873563u, 1246277393u, 1332389915u, 0, COPYSIGNF_TOLERANCE, 0},
{1923, 3424264117u, 3434026174u, 3424264117u, 0, COPYSIGNF_TOLERANCE, 0},
{1924, 3228365887u, 1216775310u, 1080882239u, 0, COPYSIGNF_TOLERANCE, 0},
{1925, 1035909900u, 1249532942u, 1035909900u, 0, COPYSIGNF_TOLERANCE, 0},
{1926, 3024951184u, 1247632131u, 877467536u, 0, COPYSIGNF_TOLERANCE, 0},
{1927, 1212129651u, 3017366784u, 3359613299u, 0, COPYSIGNF_TOLERANCE, 0},
{1928, 3125775254u, 955826310u, 978291606u, 0, COPYSIGNF_TOLERANCE, 0},
{1929, 1037464105u, 3121544932u, 3184947753u, 0, COPYSIGNF_TOLERANCE, 0},
{1930, 1311706596u, 1254918706u, 1311706596u, 0, COPYSIGNF_TOLERANCE, 0},
{1931, 918212457u, 1017468331u, 918212457u, 0, COPYSIGNF_TOLERANCE, 0},
{1932, 1337315179u, 3461361185u, 3484798827u, 0, COPYSIGNF_TOLERANCE, 0},
{1933, 1131358407u, 3325958870u, 3278842055u, 0, COPYSIGNF_TOLERANCE, 0},
{1934, 1156517523u, 3343716230u, 3304001171u, 0, COPYSIGNF_TOLERANCE, 0},
{1935, 3210802820u, 3207408574u, 3210802820u, 0, COPYSIGNF_TOLERANCE, 0},
{1936, 3337499209u, 1226297264u, 1190015561u, 0, COPYSIGNF_TOLERANCE, 0},
{1937, 3468429030u, 3253874001u, 3468429030u, 0, COPYSIGNF_TOLERANCE, 0},
{1938, 3253515800u, 1189005947u, 1106032152u, 0, COPYSIGNF_TOLERANCE, 0},
{1939, 3055299953u, 3047908678u, 3055299953u, 0, COPYSIGNF_TOLERANCE, 0},
{1940, 959956547u, 876324728u, 959956547u, 0, COPYSIGNF_TOLERANCE, 0},
{1941, 3425290480u, 1139193797u, 1277806832u, 0, COPYSIGNF_TOLERANCE, 0},
{1942, 1039917375u, 1122740999u, 1039917375u, 0, COPYSIGNF_TOLERANCE, 0},
{1943, 3220979495u, 3429223871u, 3220979495u, 0, COPYSIGNF_TOLERANCE, 0},
{1944, 1311016004u, 3334899880u, 3458499652u, 0, COPYSIGNF_TOLERANCE, 0},
{1945, 1128016396u, 1105151547u, 1128016396u, 0, COPYSIGNF_TOLERANCE, 0},
{1946, 3210335769u, 3100646155u, 3210335769u, 0, COPYSIGNF_TOLERANCE, 0},
{1947, 3022705759u, 3404762495u, 3022705759u, 0, COPYSIGNF_TOLERANCE, 0},
{1948, 1206054701u, 826010009u, 1206054701u, 0, COPYSIGNF_TOLERANCE, 0},
{1949, 3144504834u, 1162227076u, 997021186u, 0, COPYSIGNF_TOLERANCE, 0},
{1950, 1213609983u, 919983950u, 1213609983u, 0, COPYSIGNF_TOLERANCE, 0},
{1951, 1246902946u, 3064047808u, 3394386594u, 0, COPYSIGNF_TOLERANCE, 0},
{1952, 995850843u, 1332031130u, 995850843u, 0, COPYSIGNF_TOLERANCE, 0},
{1953, 3362082828u, 3374056268u, 3362082828u, 0, COPYSIGNF_TOLERANCE, 0},
{1954, 1029480631u, 3047777170u, 3176964279u, 0, COPYSIGNF_TOLERANCE, 0},
{1955, 3153568584u, 3106514232u, 3153568584u, 0, COPYSIGNF_TOLERANCE, 0},
{1956, 3384988527u, 3109485565u, 3384988527u, 0, COPYSIGNF_TOLERANCE, 0},
{1957, 1317696241u, 870681806u, 1317696241u, 0, COPYSIGNF_TOLERANCE, 0},
{1958, 3235395924u, 1132055244u, 1087912276u, 0, COPYSIGNF_TOLERANCE, 0},
{1959, 3341877624u, 2969495570u, 3341877624u, 0, COPYSIGNF_TOLERANCE, 0},
{1960, 1228636133u, 886552820u, 1228636133u, 0, COPYSIGNF_TOLERANCE, 0},
{1961, 3161654634u, 3335899347u, 3161654634u, 0, COPYSIGNF_TOLERANCE, 0},
{1962, 3162655243u, 3307203982u, 3162655243u, 0, COPYSIGNF_TOLERANCE, 0},
{1963, 1207246237u, 859223639u, 1207246237u, 0, COPYSIGNF_TOLERANCE, 0},
{1964, 1165476654u, 3350219111u, 3312960302u, 0, COPYSIGNF_TOLERANCE, 0},
{1965, 1215278023u, 3019755242u, 3362761671u, 0, COPYSIGNF_TOLERANCE, 0},
{1966, 1017239798u, 3438501281u, 3164723446u, 0, COPYSIGNF_TOLERANCE, 0},
{1967, 1149651309u, 970030475u, 1149651309u, 0, COPYSIGNF_TOLERANCE, 0},
{1968, 1111943722u, 3122211334u, 3259427370u, 0, COPYSIGNF_TOLERANCE, 0},
{1969, 1189849849u, 3382739134u, 3337333497u, 0, COPYSIGNF_TOLERANCE, 0},
{1970, 3204848496u, 3141519085u, 3204848496u, 0, COPYSIGNF_TOLERANCE, 0},
{1971, 1249758327u, 3104759211u, 3397241975u, 0, COPYSIGNF_TOLERANCE, 0},
{1972, 3092982276u, 3445282331u, 3092982276u, 0, COPYSIGNF_TOLERANCE, 0},
{1973, 1168098747u, 1316854744u, 1168098747u, 0, COPYSIGNF_TOLERANCE, 0},
{1974, 892549317u, 1179637545u, 892549317u, 0, COPYSIGNF_TOLERANCE, 0},
{1975, 3301009024u, 3406174560u, 3301009024u, 0, COPYSIGNF_TOLERANCE, 0},
{1976, 3233089227u, 1212652543u, 1085605579u, 0, COPYSIGNF_TOLERANCE, 0},
{1977, 3218245284u, 1238873830u, 1070761636u, 0, COPYSIGNF_TOLERANCE, 0},
{1978, 3215981890u, 3240474694u, 3215981890u, 0, COPYSIGNF_TOLERANCE, 0},
{1979, 1266687209u, 3092038122u, 3414170857u, 0, COPYSIGNF_TOLERANCE, 0},
{1980, 3487959775u, 3331372071u, 3487959775u, 0, COPYSIGNF_TOLERANCE, 0},
{1981, 943645710u, 852875779u, 943645710u, 0, COPYSIGNF_TOLERANCE, 0},
{1982, 3345065699u, 3282620725u, 3345065699u, 0, COPYSIGNF_TOLERANCE, 0},
{1983, 935847271u, 1067255804u, 935847271u, 0, COPYSIGNF_TOLERANCE, 0},
{1984, 3410336089u, 1111437780u, 1262852441u, 0, COPYSIGNF_TOLERANCE, 0},
{1985, 3082940740u, 1336840432u, 935457092u, 0, COPYSIGNF_TOLERANCE, 0},
{1986, 1141063391u, 1168908072u, 1141063391u, 0, COPYSIGNF_TOLERANCE, 0},
{1987, 3059263153u, 3067795684u, 3059263153u, 0, COPYSIGNF_TOLERANCE, 0},
{1988, 3353679791u, 897158391u, 1206196143u, 0, COPYSIGNF_TOLERANCE, 0},
{1989, 1001823878u, 1016826861u, 1001823878u, 0, COPYSIGNF_TOLERANCE, 0},
{1990, 1009130212u, 1004302940u, 1009130212u, 0, COPYSIGNF_TOLERANCE, 0},
{1991, 3367127535u, 943136342u, 1219643887u, 0, COPYSIGNF_TOLERANCE, 0},
{1992, 1032920919u, 3449126417u, 3180404567u, 0, COPYSIGNF_TOLERANCE, 0},
{1993, 3281952870u, 3147012185u, 3281952870u, 0, COPYSIGNF_TOLERANCE, 0},
{1994, 1237868497u, 3048281802u, 3385352145u, 0, COPYSIGNF_TOLERANCE, 0},
{1995, 1153753924u, 3322269242u, 3301237572u, 0, COPYSIGNF_TOLERANCE, 0},
{1996, 1120261759u, 892210998u, 1120261759u, 0, COPYSIGNF_TOLERANCE, 0},
{1997, 3226328360u, 3366432856u, 3226328360u, 0, COPYSIGNF_TOLERANCE, 0},
{1998, 3349595986u, 3251588707u, 3349595986u, 0, COPYSIGNF_TOLERANCE, 0},
{1999, 3166889490u, 3306023523u, 3166889490u, 0, COPYSIGNF_TOLERANCE, 0},
{2000, 1087750238u, 1099325523u, 1087750238u, 0, COPYSIGNF_TOLERANCE, 0},
{2001, 3121620061u, 3359488363u, 3121620061u, 0, COPYSIGNF_TOLERANCE, 0},
{2002, 1066116543u, 3072159933u, 3213600191u, 0, COPYSIGNF_TOLERANCE, 0},
{2003, 3210898034u, 2981803389u, 3210898034u, 0, COPYSIGNF_TOLERANCE, 0},
{2004, 3051923237u, 3364074347u, 3051923237u, 0, COPYSIGNF_TOLERANCE, 0},
{2005, 1030612298u, 3345396001u, 3178095946u, 0, COPYSIGNF_TOLERANCE, 0},
{2006, 1186234578u, 858134374u, 1186234578u, 0, COPYSIGNF_TOLERANCE, 0},
{2007, 1331680743u, 1009396165u, 1331680743u, 0, COPYSIGNF_TOLERANCE, 0},
{2008, 3060774997u, 1326067357u, 913291349u, 0, COPYSIGNF_TOLERANCE, 0},
{2009, 887589411u, 1292305693u, 887589411u, 0, COPYSIGNF_TOLERANCE, 0},
{2010, 1045232522u, 3234993273u, 3192716170u, 0, COPYSIGNF_TOLERANCE, 0},
{2011, 3119858470u, 962515365u, 972374822u, 0, COPYSIGNF_TOLERANCE, 0},
{2012, 3349432725u, 928848003u, 1201949077u, 0, COPYSIGNF_TOLERANCE, 0},
{2013, 912423027u, 3184646319u, 3059906675u, 0, COPYSIGNF_TOLERANCE, 0},
{2014, 3228795133u, 3273940030u, 3228795133u, 0, COPYSIGNF_TOLERANCE, 0},
{2015, 3194674746u, 3112269709u, 3194674746u, 0, COPYSIGNF_TOLERANCE, 0},
{2016, 3296784303u, 3276182352u, 3296784303u, 0, COPYSIGNF_TOLERANCE, 0},
{2017, 965402291u, 3107104376u, 3112885939u, 0, COPYSIGNF_TOLERANCE, 0},
{2018, 3388153589u, 3426245389u, 3388153589u, 0, COPYSIGNF_TOLERANCE, 0},
{2019, 1133410485u, 3329658993u, 3280894133u, 0, COPYSIGNF_TOLERANCE, 0},
{2020, 3136790322u, 1088652637u, 989306674u, 0, COPYSIGNF_TOLERANCE, 0},
{2021, 3369970587u, 959121458u, 1222486939u, 0, COPYSIGNF_TOLERANCE, 0},
{2022, 1270451568u, 928393353u, 1270451568u, 0, COPYSIGNF_TOLERANCE, 0},
{2023, 989498922u, 3088358419u, 3136982570u, 0, COPYSIGNF_TOLERANCE, 0},
{2024, 1280215674u, 3148135875u, 3427699322u, 0, COPYSIGNF_TOLERANCE, 0},
{2025, 1171873518u, 954709738u, 1171873518u, 0, COPYSIGNF_TOLERANCE, 0},
{2026, 3298258100u, 935525182u, 1150774452u, 0, COPYSIGNF_TOLERANCE, 0},
{2027, 3415208824u, 822843236u, 1267725176u, 0, COPYSIGNF_TOLERANCE, 0},
{2028, 1001897182u, 3191875320u, 3149380830u, 0, COPYSIGNF_TOLERANCE, 0},
{2029, 3152777939u, 3245830463u, 3152777939u, 0, COPYSIGNF_TOLERANCE, 0},
{2030, 985903305u, 3333087577u, 3133386953u, 0, COPYSIGNF_TOLERANCE, 0},
{2031, 3357328848u, 859306298u, 1209845200u, 0, COPYSIGNF_TOLERANCE, 0},
{2032, 982612185u, 923582663u, 982612185u, 0, COPYSIGNF_TOLERANCE, 0},
{2033, 3267868136u, 1208301947u, 1120384488u, 0, COPYSIGNF_TOLERANCE, 0},
{2034, 3319048157u, 1172271145u, 1171564509u, 0, COPYSIGNF_TOLERANCE, 0},
{2035, 1144755661u, 860947435u, 1144755661u, 0, COPYSIGNF_TOLERANCE, 0},
{2036, 898467286u, 839254959u, 898467286u, 0, COPYSIGNF_TOLERANCE, 0},
{2037, 3301461672u, 1233693827u, 1153978024u, 0, COPYSIGNF_TOLERANCE, 0},
{2038, 3364525678u, 3089849671u, 3364525678u, 0, COPYSIGNF_TOLERANCE, 0},
{2039, 931441127u, 1133424555u, 931441127u, 0, COPYSIGNF_TOLERANCE, 0},
{2040, 3146660041u, 3143695961u, 3146660041u, 0, COPYSIGNF_TOLERANCE, 0},
{2041, 3467121799u, 3023584354u, 3467121799u, 0, COPYSIGNF_TOLERANCE, 0},
{2042, 1151257041u, 3084216427u, 3298740689u, 0, COPYSIGNF_TOLERANCE, 0},
{2043, 3097873255u, 3219266640u, 3097873255u, 0, COPYSIGNF_TOLERANCE, 0},
{2044, 3130670309u, 3192399254u, 3130670309u, 0, COPYSIGNF_TOLERANCE, 0},
{2045, 1017573824u, 3130901062u, 3165057472u, 0, COPYSIGNF_TOLERANCE, 0},
{2046, 1258369714u, 3462258576u, 3405853362u, 0, COPYSIGNF_TOLERANCE, 0},
{2047, 1216602683u, 3371396332u, 3364086331u, 0, COPYSIGNF_TOLERANCE, 0},
{2048, 3297265739u, 1214184410u, 1149782091u, 0, COPYSIGNF_TOLERANCE, 0},
{2049, 1071940738u, 3311731012u, 3219424386u, 0, COPYSIGNF_TOLERANCE, 0},
{2050, 922601356u, 3337171870u, 3070085004u, 0, COPYSIGNF_TOLERANCE, 0},
{2051, 3462285635u, 3444030332u, 3462285635u, 0, COPYSIGNF_TOLERANCE, 0},
{2052, 3357177805u, 1085464241u, 1209694157u, 0, COPYSIGNF_TOLERANCE, 0},
{2053, 3049120080u, 900832851u, 901636432u, 0, COPYSIGNF_TOLERANCE, 0},
{2054, 1153863660u, 1011991342u, 1153863660u, 0, COPYSIGNF_TOLERANCE, 0},
{2055, 3034243695u, 917098003u, 886760047u, 0, COPYSIGNF_TOLERANCE, 0},
{2056, 1249365132u, 3278686216u, 3396848780u, 0, COPYSIGNF_TOLERANCE, 0},
{2057, 3046215730u, 3211219980u, 3046215730u, 0, COPYSIGNF_TOLERANCE, 0},
{2058, 3047251716u, 1090787353u, 899768068u, 0, COPYSIGNF_TOLERANCE, 0},
{2059, 3131219358u, 3471261157u, 3131219358u, 0, COPYSIGNF_TOLERANCE, 0},
{2060, 3222096285u, 1198013705u, 1074612637u, 0, COPYSIGNF_TOLERANCE, 0},
{2061, 1297708818u, 3079166173u, 3445192466u, 0, COPYSIGNF_TOLERANCE, 0},
{2062, 3345532722u, 3383708463u, 3345532722u, 0, COPYSIGNF_TOLERANCE, 0},
{2063, 3418753236u, 3481843070u, 3418753236u, 0, COPYSIGNF_TOLERANCE, 0},
{2064, 1277417964u, 3487506626u, 3424901612u, 0, COPYSIGNF_TOLERANCE, 0},
{2065, 987577257u, 1152077087u, 987577257u, 0, COPYSIGNF_TOLERANCE, 0},
{2066, 3161606610u, 3190282989u, 3161606610u, 0, COPYSIGNF_TOLERANCE, 0},
{2067, 888030585u, 3062367380u, 3035514233u, 0, COPYSIGNF_TOLERANCE, 0},
{2068, 1043442869u, 3311393817u, 3190926517u, 0, COPYSIGNF_TOLERANCE, 0},
{2069, 3320923228u, 3464544249u, 3320923228u, 0, COPYSIGNF_TOLERANCE, 0},
{2070, 1337400405u, 3488844154u, 3484884053u, 0, COPYSIGNF_TOLERANCE, 0},
{2071, 3400348640u, 3129868490u, 3400348640u, 0, COPYSIGNF_TOLERANCE, 0},
{2072, 1250249095u, 1069023744u, 1250249095u, 0, COPYSIGNF_TOLERANCE, 0},
{2073, 3284411233u, 1173613526u, 1136927585u, 0, COPYSIGNF_TOLERANCE, 0},
{2074, 3020883322u, 2953622587u, 3020883322u, 0, COPYSIGNF_TOLERANCE, 0},
{2075, 1215968622u, 3469884568u, 3363452270u, 0, COPYSIGNF_TOLERANCE, 0},
{2076, 3202319550u, 819117302u, 1054835902u, 0, COPYSIGNF_TOLERANCE, 0},
{2077, 3061638260u, 3116222327u, 3061638260u, 0, COPYSIGNF_TOLERANCE, 0},
{2078, 1025404104u, 1066370251u, 1025404104u, 0, COPYSIGNF_TOLERANCE, 0},
{2079, 3138086437u, 3195983510u, 3138086437u, 0, COPYSIGNF_TOLERANCE, 0},
{2080, 3091024506u, 3456196859u, 3091024506u, 0, COPYSIGNF_TOLERANCE, 0},
{2081, 3362748242u, 3369843597u, 3362748242u, 0, COPYSIGNF_TOLERANCE, 0},
{2082, 3099671635u, 3218383623u, 3099671635u, 0, COPYSIGNF_TOLERANCE, 0},
{2083, 3068014841u, 2978226656u, 3068014841u, 0, COPYSIGNF_TOLERANCE, 0},
{2084, 1252237719u, 1121169249u, 1252237719u, 0, COPYSIGNF_TOLERANCE, 0},
{2085, 3327895594u, 1224511805u, 1180411946u, 0, COPYSIGNF_TOLERANCE, 0},
{2086, 3082454432u, 889268276u, 934970784u, 0, COPYSIGNF_TOLERANCE, 0},
{2087, 3396161504u, 1182798837u, 1248677856u, 0, COPYSIGNF_TOLERANCE, 0},
{2088, 1099710167u, 887180181u, 1099710167u, 0, COPYSIGNF_TOLERANCE, 0},
{2089, 1157186482u, 1288722647u, 1157186482u, 0, COPYSIGNF_TOLERANCE, 0},
{2090, 1282110851u, 3176633124u, 3429594499u, 0, COPYSIGNF_TOLERANCE, 0},
{2091, 3477008113u, 1331845018u, 1329524465u, 0, COPYSIGNF_TOLERANCE, 0},
{2092, 3292127294u, 3409957764u, 3292127294u, 0, COPYSIGNF_TOLERANCE, 0},
{2093, 1123357102u, 3281307320u, 3270840750u, 0, COPYSIGNF_TOLERANCE, 0},
{2094, 1106837025u, 3088080674u, 3254320673u, 0, COPYSIGNF_TOLERANCE, 0},
{2095, 1049949008u, 1130799489u, 1049949008u, 0, COPYSIGNF_TOLERANCE, 0},
{2096, 1253017688u, 942062372u, 1253017688u, 0, COPYSIGNF_TOLERANCE, 0},
{2097, 1108543194u, 3281299199u, 3256026842u, 0, COPYSIGNF_TOLERANCE, 0},
{2098, 3087985411u, 1238341456u, 940501763u, 0, COPYSIGNF_TOLERANCE, 0},
{2099, 3163283126u, 1328636961u, 1015799478u, 0, COPYSIGNF_TOLERANCE, 0},
{2100, 1160162706u, 1264067367u, 1160162706u, 0, COPYSIGNF_TOLERANCE, 0},
{2101, 3305715025u, 3017496063u, 3305715025u, 0, COPYSIGNF_TOLERANCE, 0},
{2102, 1266928623u, 811778614u, 1266928623u, 0, COPYSIGNF_TOLERANCE, 0},
{2103, 3025340297u, 1193925540u, 877856649u, 0, COPYSIGNF_TOLERANCE, 0},
{2104, 3438080027u, 3107114149u, 3438080027u, 0, COPYSIGNF_TOLERANCE, 0},
{2105, 3344574751u, 3111270744u, 3344574751u, 0, COPYSIGNF_TOLERANCE, 0},
{2106, 1152416724u, 962669179u, 1152416724u, 0, COPYSIGNF_TOLERANCE, 0},
{2107, 1218239308u, 1126238113u, 1218239308u, 0, COPYSIGNF_TOLERANCE, 0},
{2108, 3263310567u, 1030748197u, 1115826919u, 0, COPYSIGNF_TOLERANCE, 0},
{2109, 3041998669u, 1160635263u, 894515021u, 0, COPYSIGNF_TOLERANCE, 0},
{2110, 1000313118u, 2980130729u, 3147796766u, 0, COPYSIGNF_TOLERANCE, 0},
{2111, 972485427u, 1124312043u, 972485427u, 0, COPYSIGNF_TOLERANCE, 0},
{2112, 3290264612u, 1124703898u, 1142780964u, 0, COPYSIGNF_TOLERANCE, 0},
{2113, 3222106584u, 1183748648u, 1074622936u, 0, COPYSIGNF_TOLERANCE, 0},
{2114, 1278946388u, 825129857u, 1278946388u, 0, COPYSIGNF_TOLERANCE, 0},
{2115, 947914771u, 3181847068u, 3095398419u, 0, COPYSIGNF_TOLERANCE, 0},
{2116, 3167730654u, 3195765940u, 3167730654u, 0, COPYSIGNF_TOLERANCE, 0},
{2117, 1098530298u, 3255870890u, 3246013946u, 0, COPYSIGNF_TOLERANCE, 0},
{2118, 3232726036u, 871038882u, 1085242388u, 0, COPYSIGNF_TOLERANCE, 0},
{2119, 1297190916u, 811863044u, 1297190916u, 0, COPYSIGNF_TOLERANCE, 0},
{2120, 1277649137u, 961171401u, 1277649137u, 0, COPYSIGNF_TOLERANCE, 0},
{2121, 3203377685u, 1306427476u, 1055894037u, 0, COPYSIGNF_TOLERANCE, 0},
{2122, 3090306474u, 3124785016u, 3090306474u, 0, COPYSIGNF_TOLERANCE, 0},
{2123, 3244032016u, 3045313345u, 3244032016u, 0, COPYSIGNF_TOLERANCE, 0},
{2124, 3033122376u, 3049877065u, 3033122376u, 0, COPYSIGNF_TOLERANCE, 0},
{2125, 1096155623u, 1256423752u, 1096155623u, 0, COPYSIGNF_TOLERANCE, 0},
{2126, 873151908u, 3246562559u, 3020635556u, 0, COPYSIGNF_TOLERANCE, 0},
{2127, 3238729605u, 1298769842u, 1091245957u, 0, COPYSIGNF_TOLERANCE, 0},
{2128, 3317196817u, 989537151u, 1169713169u, 0, COPYSIGNF_TOLERANCE, 0},
{2129, 3374748510u, 834161190u, 1227264862u, 0, COPYSIGNF_TOLERANCE, 0},
{2130, 3345634950u, 959901149u, 1198151302u, 0, COPYSIGNF_TOLERANCE, 0},
{2131, 3189860276u, 883598767u, 1042376628u, 0, COPYSIGNF_TOLERANCE, 0},
{2132, 887311687u, 1175312255u, 887311687u, 0, COPYSIGNF_TOLERANCE, 0},
{2133, 3396917283u, 3066326686u, 3396917283u, 0, COPYSIGNF_TOLERANCE, 0},
{2134, 3317032737u, 3143803722u, 3317032737u, 0, COPYSIGNF_TOLERANCE, 0},
{2135, 1200051436u, 1163802508u, 1200051436u, 0, COPYSIGNF_TOLERANCE, 0},
{2136, 3105291012u, 1194385202u, 957807364u, 0, COPYSIGNF_TOLERANCE, 0},
{2137, 1306520561u, 957302464u, 1306520561u, 0, COPYSIGNF_TOLERANCE, 0},
{2138, 1314936356u, 2985592532u, 3462420004u, 0, COPYSIGNF_TOLERANCE, 0},
{2139, 3475052219u, 1284049853u, 1327568571u, 0, COPYSIGNF_TOLERANCE, 0},
{2140, 3085636260u, 1107682820u, 938152612u, 0, COPYSIGNF_TOLERANCE, 0},
{2141, 3393227708u, 3271879112u, 3393227708u, 0, COPYSIGNF_TOLERANCE, 0},
{2142, 3182540197u, 852580839u, 1035056549u, 0, COPYSIGNF_TOLERANCE, 0},
{2143, 3349005404u, 3080993030u, 3349005404u, 0, COPYSIGNF_TOLERANCE, 0},
{2144, 3154720153u, 3443720494u, 3154720153u, 0, COPYSIGNF_TOLERANCE, 0},
{2145, 1262863321u, 1219003129u, 1262863321u, 0, COPYSIGNF_TOLERANCE, 0},
{2146, 882902102u, 1224362550u, 882902102u, 0, COPYSIGNF_TOLERANCE, 0},
{2147, 1053387478u, 3184880021u, 3200871126u, 0, COPYSIGNF_TOLERANCE, 0},
{2148, 3387653691u, 3347783852u, 3387653691u, 0, COPYSIGNF_TOLERANCE, 0},
{2149, 3136364836u, 1018492227u, 988881188u, 0, COPYSIGNF_TOLERANCE, 0},
{2150, 1338680611u, 1166078045u, 1338680611u, 0, COPYSIGNF_TOLERANCE, 0},
{2151, 1112891928u, 3074730425u, 3260375576u, 0, COPYSIGNF_TOLERANCE, 0},
{2152, 893449284u, 1052877339u, 893449284u, 0, COPYSIGNF_TOLERANCE, 0},
{2153, 892311459u, 1097338393u, 892311459u, 0, COPYSIGNF_TOLERANCE, 0},
{2154, 3105373037u, 3246705916u, 3105373037u, 0, COPYSIGNF_TOLERANCE, 0},
{2155, 1190105283u, 3033907262u, 3337588931u, 0, COPYSIGNF_TOLERANCE, 0},
{2156, 1011225926u, 1180485180u, 1011225926u, 0, COPYSIGNF_TOLERANCE, 0},
{2157, 1043025031u, 987068973u, 1043025031u, 0, COPYSIGNF_TOLERANCE, 0},
{2158, 3410531037u, 2953541915u, 3410531037u, 0, COPYSIGNF_TOLERANCE, 0},
{2159, 3125834184u, 896953754u, 978350536u, 0, COPYSIGNF_TOLERANCE, 0},
{2160, 902318189u, 849277289u, 902318189u, 0, COPYSIGNF_TOLERANCE, 0},
{2161, 3213624815u, 2987148017u, 3213624815u, 0, COPYSIGNF_TOLERANCE, 0},
{2162, 1120888322u, 1086209113u, 1120888322u, 0, COPYSIGNF_TOLERANCE, 0},
{2163, 1315217243u, 3396371713u, 3462700891u, 0, COPYSIGNF_TOLERANCE, 0},
{2164, 3137758475u, 1039403054u, 990274827u, 0, COPYSIGNF_TOLERANCE, 0},
{2165, 1040617590u, 1034835971u, 1040617590u, 0, COPYSIGNF_TOLERANCE, 0},
{2166, 955384253u, 3344785562u, 3102867901u, 0, COPYSIGNF_TOLERANCE, 0},
{2167, 3061417900u, 1172208065u, 913934252u, 0, COPYSIGNF_TOLERANCE, 0},
{2168, 904255535u, 1019967545u, 904255535u, 0, COPYSIGNF_TOLERANCE, 0},
{2169, 1022984119u, 3113891410u, 3170467767u, 0, COPYSIGNF_TOLERANCE, 0},
{2170, 997362368u, 3112875428u, 3144846016u, 0, COPYSIGNF_TOLERANCE, 0},
{2171, 900933520u, 1100589187u, 900933520u, 0, COPYSIGNF_TOLERANCE, 0},
{2172, 1168623062u, 1143306482u, 1168623062u, 0, COPYSIGNF_TOLERANCE, 0},
{2173, 878737490u, 3269908326u, 3026221138u, 0, COPYSIGNF_TOLERANCE, 0},
{2174, 1039827284u, 1072928888u, 1039827284u, 0, COPYSIGNF_TOLERANCE, 0},
{2175, 1021564080u, 1064468397u, 1021564080u, 0, COPYSIGNF_TOLERANCE, 0},
{2176, 3458669745u, 3033299853u, 3458669745u, 0, COPYSIGNF_TOLERANCE, 0},
{2177, 3327516316u, 3405380971u, 3327516316u, 0, COPYSIGNF_TOLERANCE, 0},
{2178, 1040711112u, 3229444200u, 3188194760u, 0, COPYSIGNF_TOLERANCE, 0},
{2179, 1134528351u, 3365952513u, 3282011999u, 0, COPYSIGNF_TOLERANCE, 0},
{2180, 3039884464u, 1170612785u, 892400816u, 0, COPYSIGNF_TOLERANCE, 0},
{2181, 3414352838u, 3350285760u, 3414352838u, 0, COPYSIGNF_TOLERANCE, 0},
{2182, 1133689539u, 1067460093u, 1133689539u, 0, COPYSIGNF_TOLERANCE, 0},
{2183, 3455688478u, 3333091960u, 3455688478u, 0, COPYSIGNF_TOLERANCE, 0},
{2184, 1137634874u, 1137038869u, 1137634874u, 0, COPYSIGNF_TOLERANCE, 0},
{2185, 3415502662u, 955510692u, 1268019014u, 0, COPYSIGNF_TOLERANCE, 0},
{2186, 954999730u, 969618597u, 954999730u, 0, COPYSIGNF_TOLERANCE, 0},
{2187, 1066157309u, 3241712664u, 3213640957u, 0, COPYSIGNF_TOLERANCE, 0},
{2188, 3436353675u, 1174967495u, 1288870027u, 0, COPYSIGNF_TOLERANCE, 0},
{2189, 940437609u, 860372396u, 940437609u, 0, COPYSIGNF_TOLERANCE, 0},
{2190, 3108347547u, 3434003435u, 3108347547u, 0, COPYSIGNF_TOLERANCE, 0},
{2191, 3064200154u, 3158080507u, 3064200154u, 0, COPYSIGNF_TOLERANCE, 0},
{2192, 1023889593u, 2979304683u, 3171373241u, 0, COPYSIGNF_TOLERANCE, 0},
{2193, 3272661536u, 3461799138u, 3272661536u, 0, COPYSIGNF_TOLERANCE, 0},
{2194, 1170245333u, 1233406410u, 1170245333u, 0, COPYSIGNF_TOLERANCE, 0},
{2195, 1219052056u, 3369557946u, 3366535704u, 0, COPYSIGNF_TOLERANCE, 0},
{2196, 3318983619u, 3259663338u, 3318983619u, 0, COPYSIGNF_TOLERANCE, 0},
{2197, 3372118621u, 837597103u, 1224634973u, 0, COPYSIGNF_TOLERANCE, 0},
{2198, 3146190320u, 889646054u, 998706672u, 0, COPYSIGNF_TOLERANCE, 0},
{2199, 1299683827u, 966031619u, 1299683827u, 0, COPYSIGNF_TOLERANCE, 0},
{2200, 3190796331u, 1320011850u, 1043312683u, 0, COPYSIGNF_TOLERANCE, 0},
{2201, 3086068902u, 3484245751u, 3086068902u, 0, COPYSIGNF_TOLERANCE, 0},
{2202, 3064155399u, 3176569312u, 3064155399u, 0, COPYSIGNF_TOLERANCE, 0},
{2203, 3040314717u, 1071290674u, 892831069u, 0, COPYSIGNF_TOLERANCE, 0},
{2204, 3257224022u, 3361778245u, 3257224022u, 0, COPYSIGNF_TOLERANCE, 0},
{2205, 1229268598u, 1066965677u, 1229268598u, 0, COPYSIGNF_TOLERANCE, 0},
{2206, 3184078812u, 871003709u, 1036595164u, 0, COPYSIGNF_TOLERANCE, 0},
{2207, 1086717248u, 3423795374u, 3234200896u, 0, COPYSIGNF_TOLERANCE, 0},
{2208, 3434884607u, 3029593823u, 3434884607u, 0, COPYSIGNF_TOLERANCE, 0},
{2209, 3464955606u, 1017987696u, 1317471958u, 0, COPYSIGNF_TOLERANCE, 0},
{2210, 1025278524u, 3121856207u, 3172762172u, 0, COPYSIGNF_TOLERANCE, 0},
{2211, 1242829722u, 3233935671u, 3390313370u, 0, COPYSIGNF_TOLERANCE, 0},
{2212, 3075149137u, 1117325737u, 927665489u, 0, COPYSIGNF_TOLERANCE, 0},
{2213, 1200927971u, 1317167489u, 1200927971u, 0, COPYSIGNF_TOLERANCE, 0},
{2214, 3326858092u, 3452602832u, 3326858092u, 0, COPYSIGNF_TOLERANCE, 0},
{2215, 1246019790u, 850632217u, 1246019790u, 0, COPYSIGNF_TOLERANCE, 0},
{2216, 3184801644u, 1137974313u, 1037317996u, 0, COPYSIGNF_TOLERANCE, 0},
{2217, 1136052740u, 3244616020u, 3283536388u, 0, COPYSIGNF_TOLERANCE, 0},
{2218, 1069009211u, 3002507482u, 3216492859u, 0, COPYSIGNF_TOLERANCE, 0},
{2219, 1015670780u, 1101217251u, 1015670780u, 0, COPYSIGNF_TOLERANCE, 0},
{2220, 1012543234u, 1116520440u, 1012543234u, 0, COPYSIGNF_TOLERANCE, 0},
{2221, 3316611992u, 3394732912u, 3316611992u, 0, COPYSIGNF_TOLERANCE, 0},
{2222, 1087942795u, 3316660295u, 3235426443u, 0, COPYSIGNF_TOLERANCE, 0},
{2223, 3426365713u, 3069778532u, 3426365713u, 0, COPYSIGNF_TOLERANCE, 0},
{2224, 3066654389u, 3443934204u, 3066654389u, 0, COPYSIGNF_TOLERANCE, 0},
{2225, 3295326432u, 1313396175u, 1147842784u, 0, COPYSIGNF_TOLERANCE, 0},
{2226, 3318835308u, 3277583511u, 3318835308u, 0, COPYSIGNF_TOLERANCE, 0},
{2227, 3283555717u, 891875120u, 1136072069u, 0, COPYSIGNF_TOLERANCE, 0},
{2228, 3381255420u, 3015406047u, 3381255420u, 0, COPYSIGNF_TOLERANCE, 0},
{2229, 3040485181u, 3375450886u, 3040485181u, 0, COPYSIGNF_TOLERANCE, 0},
{2230, 3388772093u, 1032597076u, 1241288445u, 0, COPYSIGNF_TOLERANCE, 0},
{2231, 954670189u, 1144923689u, 954670189u, 0, COPYSIGNF_TOLERANCE, 0},
{2232, 1319200415u, 3387555900u, 3466684063u, 0, COPYSIGNF_TOLERANCE, 0},
{2233, 1279324488u, 3228401212u, 3426808136u, 0, COPYSIGNF_TOLERANCE, 0},
{2234, 3217795424u, 865577227u, 1070311776u, 0, COPYSIGNF_TOLERANCE, 0},
{2235, 3455131757u, 1260217257u, 1307648109u, 0, COPYSIGNF_TOLERANCE, 0},
{2236, 1246947517u, 1087951909u, 1246947517u, 0, COPYSIGNF_TOLERANCE, 0},
{2237, 3396723577u, 869285240u, 1249239929u, 0, COPYSIGNF_TOLERANCE, 0},
{2238, 3433761025u, 3060143904u, 3433761025u, 0, COPYSIGNF_TOLERANCE, 0},
{2239, 3201187455u, 900233172u, 1053703807u, 0, COPYSIGNF_TOLERANCE, 0},
{2240, 1173247961u, 1191127979u, 1173247961u, 0, COPYSIGNF_TOLERANCE, 0},
{2241, 3037297123u, 3346394818u, 3037297123u, 0, COPYSIGNF_TOLERANCE, 0},
{2242, 3248534678u, 1323683800u, 1101051030u, 0, COPYSIGNF_TOLERANCE, 0},
{2243, 3083019343u, 3033309444u, 3083019343u, 0, COPYSIGNF_TOLERANCE, 0},
{2244, 3042018375u, 3203882372u, 3042018375u, 0, COPYSIGNF_TOLERANCE, 0},
{2245, 1082862511u, 3032804719u, 3230346159u, 0, COPYSIGNF_TOLERANCE, 0},
{2246, 3157626955u, 3483653298u, 3157626955u, 0, COPYSIGNF_TOLERANCE, 0},
{2247, 1341821683u, 3003675365u, 3489305331u, 0, COPYSIGNF_TOLERANCE, 0},
{2248, 881101379u, 1190838126u, 881101379u, 0, COPYSIGNF_TOLERANCE, 0},
{2249, 1079061705u, 2960507663u, 3226545353u, 0, COPYSIGNF_TOLERANCE, 0},
{2250, 3182695954u, 3256861672u, 3182695954u, 0, COPYSIGNF_TOLERANCE, 0},
{2251, 1105291533u, 3482971524u, 3252775181u, 0, COPYSIGNF_TOLERANCE, 0},
{2252, 1016023520u, 3227712090u, 3163507168u, 0, COPYSIGNF_TOLERANCE, 0},
{2253, 3370691006u, 1295870514u, 1223207358u, 0, COPYSIGNF_TOLERANCE, 0},
{2254, 1156767169u, 1049756240u, 1156767169u, 0, COPYSIGNF_TOLERANCE, 0},
{2255, 3077020499u, 894671462u, 929536851u, 0, COPYSIGNF_TOLERANCE, 0},
{2256, 1104284039u, 3040211914u, 3251767687u, 0, COPYSIGNF_TOLERANCE, 0},
{2257, 3335212901u, 3486414589u, 3335212901u, 0, COPYSIGNF_TOLERANCE, 0},
{2258, 1093697541u, 3193708441u, 3241181189u, 0, COPYSIGNF_TOLERANCE, 0},
{2259, 3266691185u, 1160074593u, 1119207537u, 0, COPYSIGNF_TOLERANCE, 0},
{2260, 3179003144u, 1108615803u, 1031519496u, 0, COPYSIGNF_TOLERANCE, 0},
{2261, 1094115255u, 3008610212u, 3241598903u, 0, COPYSIGNF_TOLERANCE, 0},
{2262, 3424086808u, 3260140004u, 3424086808u, 0, COPYSIGNF_TOLERANCE, 0},
{2263, 3353608773u, 1134068114u, 1206125125u, 0, COPYSIGNF_TOLERANCE, 0},
{2264, 973664327u, 1319516167u, 973664327u, 0, COPYSIGNF_TOLERANCE, 0},
{2265, 882878091u, 3136970767u, 3030361739u, 0, COPYSIGNF_TOLERANCE, 0},
{2266, 1098662266u, 833740182u, 1098662266u, 0, COPYSIGNF_TOLERANCE, 0},
{2267, 927582555u, 947955456u, 927582555u, 0, COPYSIGNF_TOLERANCE, 0},
{2268, 3111440310u, 3067634077u, 3111440310u, 0, COPYSIGNF_TOLERANCE, 0},
{2269, 3476083859u, 966439623u, 1328600211u, 0, COPYSIGNF_TOLERANCE, 0},
{2270, 3038754840u, 932009686u, 891271192u, 0, COPYSIGNF_TOLERANCE, 0},
{2271, 979878744u, 1232482646u, 979878744u, 0, COPYSIGNF_TOLERANCE, 0},
{2272, 3464546616u, 3205527253u, 3464546616u, 0, COPYSIGNF_TOLERANCE, 0},
{2273, 1002542205u, 3152136093u, 3150025853u, 0, COPYSIGNF_TOLERANCE, 0},
{2274, 3443552129u, 3165561391u, 3443552129u, 0, COPYSIGNF_TOLERANCE, 0},
{2275, 1287620154u, 3119707283u, 3435103802u, 0, COPYSIGNF_TOLERANCE, 0},
{2276, 946058434u, 1249928879u, 946058434u, 0, COPYSIGNF_TOLERANCE, 0},
{2277, 3073260205u, 3093124531u, 3073260205u, 0, COPYSIGNF_TOLERANCE, 0},
{2278, 1245702957u, 894348966u, 1245702957u, 0, COPYSIGNF_TOLERANCE, 0},
{2279, 989655126u, 1308376568u, 989655126u, 0, COPYSIGNF_TOLERANCE, 0},
{2280, 1002715618u, 1191006977u, 1002715618u, 0, COPYSIGNF_TOLERANCE, 0},
{2281, 3087802274u, 897541752u, 940318626u, 0, COPYSIGNF_TOLERANCE, 0},
{2282, 1000863905u, 1196831314u, 1000863905u, 0, COPYSIGNF_TOLERANCE, 0},
{2283, 3415763001u, 3032518431u, 3415763001u, 0, COPYSIGNF_TOLERANCE, 0},
{2284, 3283471961u, 1260093226u, 1135988313u, 0, COPYSIGNF_TOLERANCE, 0},
{2285, 3311210827u, 1192192264u, 1163727179u, 0, COPYSIGNF_TOLERANCE, 0},
{2286, 3026311911u, 2968974374u, 3026311911u, 0, COPYSIGNF_TOLERANCE, 0},
{2287, 1198307901u, 1116328249u, 1198307901u, 0, COPYSIGNF_TOLERANCE, 0},
{2288, 1288901567u, 1296370667u, 1288901567u, 0, COPYSIGNF_TOLERANCE, 0},
{2289, 922255363u, 958305289u, 922255363u, 0, COPYSIGNF_TOLERANCE, 0},
{2290, 1113104661u, 944376032u, 1113104661u, 0, COPYSIGNF_TOLERANCE, 0},
{2291, 1136714348u, 828849087u, 1136714348u, 0, COPYSIGNF_TOLERANCE, 0},
{2292, 948856035u, 1015466475u, 948856035u, 0, COPYSIGNF_TOLERANCE, 0},
{2293, 1062512367u, 3229559531u, 3209996015u, 0, COPYSIGNF_TOLERANCE, 0},
{2294, 3486907092u, 823220784u, 1339423444u, 0, COPYSIGNF_TOLERANCE, 0},
{2295, 1162027071u, 3308983387u, 3309510719u, 0, COPYSIGNF_TOLERANCE, 0},
{2296, 1034561811u, 1054043114u, 1034561811u, 0, COPYSIGNF_TOLERANCE, 0},
{2297, 3271615417u, 3209997200u, 3271615417u, 0, COPYSIGNF_TOLERANCE, 0},
{2298, 1042014529u, 1146708584u, 1042014529u, 0, COPYSIGNF_TOLERANCE, 0},
{2299, 1177157787u, 3090208179u, 3324641435u, 0, COPYSIGNF_TOLERANCE, 0},
{2300, 3196144817u, 1056118717u, 1048661169u, 0, COPYSIGNF_TOLERANCE, 0},
{2301, 3432084552u, 2997091781u, 3432084552u, 0, COPYSIGNF_TOLERANCE, 0},
{2302, 1309658335u, 1010219988u, 1309658335u, 0, COPYSIGNF_TOLERANCE, 0},
{2303, 1226494979u, 2991604792u, 3373978627u, 0, COPYSIGNF_TOLERANCE, 0},
{2304, 3100289712u, 3456334210u, 3100289712u, 0, COPYSIGNF_TOLERANCE, 0},
{2305, 3375507013u, 1306310823u, 1228023365u, 0, COPYSIGNF_TOLERANCE, 0},
{2306, 3460699001u, 3096700943u, 3460699001u, 0, COPYSIGNF_TOLERANCE, 0},
{2307, 3079231719u, 1044386263u, 931748071u, 0, COPYSIGNF_TOLERANCE, 0},
{2308, 3093951884u, 1014115231u, 946468236u, 0, COPYSIGNF_TOLERANCE, 0},
{2309, 3468023178u, 1209565017u, 1320539530u, 0, COPYSIGNF_TOLERANCE, 0},
{2310, 1204196034u, 3298625731u, 3351679682u, 0, COPYSIGNF_TOLERANCE, 0},
{2311, 3459877411u, 2960476959u, 3459877411u, 0, COPYSIGNF_TOLERANCE, 0},
{2312, 909696559u, 1163075690u, 909696559u, 0, COPYSIGNF_TOLERANCE, 0},
{2313, 1161439847u, 943449277u, 1161439847u, 0, COPYSIGNF_TOLERANCE, 0},
{2314, 908663107u, 939489763u, 908663107u, 0, COPYSIGNF_TOLERANCE, 0},
{2315, 1055319316u, 3261813492u, 3202802964u, 0, COPYSIGNF_TOLERANCE, 0},
{2316, 1084378658u, 1009650785u, 1084378658u, 0, COPYSIGNF_TOLERANCE, 0},
{2317, 3053887750u, 3341786453u, 3053887750u, 0, COPYSIGNF_TOLERANCE, 0},
{2318, 3022828828u, 881335251u, 875345180u, 0, COPYSIGNF_TOLERANCE, 0},
{2319, 1226473697u, 821025132u, 1226473697u, 0, COPYSIGNF_TOLERANCE, 0},
{2320, 1123114742u, 1229815537u, 1123114742u, 0, COPYSIGNF_TOLERANCE, 0},
{2321, 1258114435u, 1291336083u, 1258114435u, 0, COPYSIGNF_TOLERANCE, 0},
{2322, 3468040845u, 3066966245u, 3468040845u, 0, COPYSIGNF_TOLERANCE, 0},
{2323, 1178825761u, 1113195286u, 1178825761u, 0, COPYSIGNF_TOLERANCE, 0},
{2324, 3059266302u, 878503862u, 911782654u, 0, COPYSIGNF_TOLERANCE, 0},
{2325, 3223384012u, 1130486973u, 1075900364u, 0, COPYSIGNF_TOLERANCE, 0},
{2326, 1019964626u, 1235133609u, 1019964626u, 0, COPYSIGNF_TOLERANCE, 0},
{2327, 3445262427u, 3465211174u, 3445262427u, 0, COPYSIGNF_TOLERANCE, 0},
{2328, 1125653081u, 1207799746u, 1125653081u, 0, COPYSIGNF_TOLERANCE, 0},
{2329, 3337652712u, 3025581813u, 3337652712u, 0, COPYSIGNF_TOLERANCE, 0},
{2330, 1184753508u, 3147374485u, 3332237156u, 0, COPYSIGNF_TOLERANCE, 0},
{2331, 996404791u, 3353251979u, 3143888439u, 0, COPYSIGNF_TOLERANCE, 0},
{2332, 1188439315u, 1113484271u, 1188439315u, 0, COPYSIGNF_TOLERANCE, 0},
{2333, 906557513u, 3006513432u, 3054041161u, 0, COPYSIGNF_TOLERANCE, 0},
{2334, 916831283u, 999465787u, 916831283u, 0, COPYSIGNF_TOLERANCE, 0},
{2335, 996786317u, 3179221951u, 3144269965u, 0, COPYSIGNF_TOLERANCE, 0},
{2336, 3461635065u, 1004690387u, 1314151417u, 0, COPYSIGNF_TOLERANCE, 0},
{2337, 1188167943u, 1200744896u, 1188167943u, 0, COPYSIGNF_TOLERANCE, 0},
{2338, 3036502395u, 1172597364u, 889018747u, 0, COPYSIGNF_TOLERANCE, 0},
{2339, 891257783u, 1267560050u, 891257783u, 0, COPYSIGNF_TOLERANCE, 0},
{2340, 3290079438u, 846519377u, 1142595790u, 0, COPYSIGNF_TOLERANCE, 0},
{2341, 3350690327u, 2967953392u, 3350690327u, 0, COPYSIGNF_TOLERANCE, 0},
{2342, 1102061604u, 3424449935u, 3249545252u, 0, COPYSIGNF_TOLERANCE, 0},
{2343, 1282351521u, 3039376424u, 3429835169u, 0, COPYSIGNF_TOLERANCE, 0},
{2344, 3458861065u, 3392466405u, 3458861065u, 0, COPYSIGNF_TOLERANCE, 0},
{2345, 3095256878u, 1023623326u, 947773230u, 0, COPYSIGNF_TOLERANCE, 0},
{2346, 3163373610u, 843150426u, 1015889962u, 0, COPYSIGNF_TOLERANCE, 0},
{2347, 3228793330u, 855146890u, 1081309682u, 0, COPYSIGNF_TOLERANCE, 0},
{2348, 3422194733u, 893873945u, 1274711085u, 0, COPYSIGNF_TOLERANCE, 0},
{2349, 3083885296u, 974543672u, 936401648u, 0, COPYSIGNF_TOLERANCE, 0},
{2350, 1261940623u, 3402349985u, 3409424271u, 0, COPYSIGNF_TOLERANCE, 0},
{2351, 3400603081u, 3234396843u, 3400603081u, 0, COPYSIGNF_TOLERANCE, 0},
{2352, 1219411812u, 2961857939u, 3366895460u, 0, COPYSIGNF_TOLERANCE, 0},
{2353, 3094833770u, 805351108u, 947350122u, 0, COPYSIGNF_TOLERANCE, 0},
{2354, 3139250800u, 3079109479u, 3139250800u, 0, COPYSIGNF_TOLERANCE, 0},
{2355, 886201503u, 3272760705u, 3033685151u, 0, COPYSIGNF_TOLERANCE, 0},
{2356, 3297366026u, 1089966380u, 1149882378u, 0, COPYSIGNF_TOLERANCE, 0},
{2357, 1218488455u, 3309646450u, 3365972103u, 0, COPYSIGNF_TOLERANCE, 0},
{2358, 3040358923u, 3093401553u, 3040358923u, 0, COPYSIGNF_TOLERANCE, 0},
{2359, 1283938137u, 1196383822u, 1283938137u, 0, COPYSIGNF_TOLERANCE, 0},
{2360, 3182551696u, 3029982441u, 3182551696u, 0, COPYSIGNF_TOLERANCE, 0},
{2361, 1317098613u, 949986176u, 1317098613u, 0, COPYSIGNF_TOLERANCE, 0},
{2362, 3116209179u, 3303588342u, 3116209179u, 0, COPYSIGNF_TOLERANCE, 0},
{2363, 3431703657u, 3014443710u, 3431703657u, 0, COPYSIGNF_TOLERANCE, 0},
{2364, 3239728775u, 927815421u, 1092245127u, 0, COPYSIGNF_TOLERANCE, 0},
{2365, 3207141672u, 933456504u, 1059658024u, 0, COPYSIGNF_TOLERANCE, 0},
{2366, 3154378805u, 905462392u, 1006895157u, 0, COPYSIGNF_TOLERANCE, 0},
{2367, 3069658155u, 1041452042u, 922174507u, 0, COPYSIGNF_TOLERANCE, 0},
{2368, 3313160088u, 2964063309u, 3313160088u, 0, COPYSIGNF_TOLERANCE, 0},
{2369, 3207056527u, 3384206601u, 3207056527u, 0, COPYSIGNF_TOLERANCE, 0},
{2370, 1284174954u, 3436881197u, 3431658602u, 0, COPYSIGNF_TOLERANCE, 0},
{2371, 3156081645u, 3308839704u, 3156081645u, 0, COPYSIGNF_TOLERANCE, 0},
{2372, 1063693032u, 976661408u, 1063693032u, 0, COPYSIGNF_TOLERANCE, 0},
{2373, 3036026175u, 1251203998u, 888542527u, 0, COPYSIGNF_TOLERANCE, 0},
{2374, 1102631663u, 3396951425u, 3250115311u, 0, COPYSIGNF_TOLERANCE, 0},
{2375, 968803479u, 992989712u, 968803479u, 0, COPYSIGNF_TOLERANCE, 0},
{2376, 3273080388u, 3109405906u, 3273080388u, 0, COPYSIGNF_TOLERANCE, 0},
{2377, 1172529774u, 3294550127u, 3320013422u, 0, COPYSIGNF_TOLERANCE, 0},
{2378, 1306695905u, 1292690378u, 1306695905u, 0, COPYSIGNF_TOLERANCE, 0},
{2379, 1003649752u, 1218792138u, 1003649752u, 0, COPYSIGNF_TOLERANCE, 0},
{2380, 1078478376u, 1326246424u, 1078478376u, 0, COPYSIGNF_TOLERANCE, 0},
{2381, 3158855023u, 3151283866u, 3158855023u, 0, COPYSIGNF_TOLERANCE, 0},
{2382, 1165177679u, 3276237026u, 3312661327u, 0, COPYSIGNF_TOLERANCE, 0},
{2383, 3403009513u, 3381966453u, 3403009513u, 0, COPYSIGNF_TOLERANCE, 0},
{2384, 952348506u, 3377573987u, 3099832154u, 0, COPYSIGNF_TOLERANCE, 0},
{2385, 1222777442u, 1125769920u, 1222777442u, 0, COPYSIGNF_TOLERANCE, 0},
{2386, 1325324763u, 978336043u, 1325324763u, 0, COPYSIGNF_TOLERANCE, 0},
{2387, 3363524213u, 3202991311u, 3363524213u, 0, COPYSIGNF_TOLERANCE, 0},
{2388, 1158950321u, 1073578913u, 1158950321u, 0, COPYSIGNF_TOLERANCE, 0},
{2389, 903129873u, 3416864271u, 3050613521u, 0, COPYSIGNF_TOLERANCE, 0},
{2390, 3078339944u, 988173985u, 930856296u, 0, COPYSIGNF_TOLERANCE, 0},
{2391, 1208345407u, 1254181270u, 1208345407u, 0, COPYSIGNF_TOLERANCE, 0},
{2392, 1258634105u, 1247426200u, 1258634105u, 0, COPYSIGNF_TOLERANCE, 0},
{2393, 1248478509u, 1287895126u, 1248478509u, 0, COPYSIGNF_TOLERANCE, 0},
{2394, 1153863988u, 3430539165u, 3301347636u, 0, COPYSIGNF_TOLERANCE, 0},
{2395, 1235620969u, 866627358u, 1235620969u, 0, COPYSIGNF_TOLERANCE, 0},
{2396, 1097120930u, 3221726305u, 3244604578u, 0, COPYSIGNF_TOLERANCE, 0},
{2397, 3469778622u, 1200179013u, 1322294974u, 0, COPYSIGNF_TOLERANCE, 0},
{2398, 1147712200u, 931865525u, 1147712200u, 0, COPYSIGNF_TOLERANCE, 0},
{2399, 1124721745u, 3058969650u, 3272205393u, 0, COPYSIGNF_TOLERANCE, 0},
{2400, 3261744304u, 1043806501u, 1114260656u, 0, COPYSIGNF_TOLERANCE, 0},
{2401, 1064922416u, 1320485628u, 1064922416u, 0, COPYSIGNF_TOLERANCE, 0},
{2402, 3303160152u, 3075455322u, 3303160152u, 0, COPYSIGNF_TOLERANCE, 0},
{2403, 1315090496u, 3269683237u, 3462574144u, 0, COPYSIGNF_TOLERANCE, 0},
{2404, 3230403187u, 1322841992u, 1082919539u, 0, COPYSIGNF_TOLERANCE, 0},
{2405, 1335399673u, 974138676u, 1335399673u, 0, COPYSIGNF_TOLERANCE, 0},
{2406, 1072458508u, 3372833993u, 3219942156u, 0, COPYSIGNF_TOLERANCE, 0},
{2407, 3303015249u, 3015039539u, 3303015249u, 0, COPYSIGNF_TOLERANCE, 0},
{2408, 3252139741u, 1059615003u, 1104656093u, 0, COPYSIGNF_TOLERANCE, 0},
{2409, 3468519966u, 3113982619u, 3468519966u, 0, COPYSIGNF_TOLERANCE, 0},
{2410, 1006231203u, 897530770u, 1006231203u, 0, COPYSIGNF_TOLERANCE, 0},
{2411, 951554138u, 1001144381u, 951554138u, 0, COPYSIGNF_TOLERANCE, 0},
{2412, 942046828u, 986341002u, 942046828u, 0, COPYSIGNF_TOLERANCE, 0},
{2413, 3319723279u, 3414482416u, 3319723279u, 0, COPYSIGNF_TOLERANCE, 0},
{2414, 3255104167u, 928827688u, 1107620519u, 0, COPYSIGNF_TOLERANCE, 0},
{2415, 1155477903u, 3104812800u, 3302961551u, 0, COPYSIGNF_TOLERANCE, 0},
{2416, 3273889176u, 980486479u, 1126405528u, 0, COPYSIGNF_TOLERANCE, 0},
{2417, 3237813668u, 3441016803u, 3237813668u, 0, COPYSIGNF_TOLERANCE, 0},
{2418, 1228207362u, 2985476579u, 3375691010u, 0, COPYSIGNF_TOLERANCE, 0},
{2419, 975349337u, 1311932596u, 975349337u, 0, COPYSIGNF_TOLERANCE, 0},
{2420, 1290175785u, 3008182462u, 3437659433u, 0, COPYSIGNF_TOLERANCE, 0},
{2421, 981908840u, 3314038398u, 3129392488u, 0, COPYSIGNF_TOLERANCE, 0},
{2422, 941187647u, 1107765599u, 941187647u, 0, COPYSIGNF_TOLERANCE, 0},
{2423, 1214223128u, 3225536822u, 3361706776u, 0, COPYSIGNF_TOLERANCE, 0},
{2424, 3422922584u, 1086391131u, 1275438936u, 0, COPYSIGNF_TOLERANCE, 0},
{2425, 1315857601u, 3487600045u, 3463341249u, 0, COPYSIGNF_TOLERANCE, 0},
{2426, 3453226030u, 3233768835u, 3453226030u, 0, COPYSIGNF_TOLERANCE, 0},
{2427, 1078359574u, 3199175230u, 3225843222u, 0, COPYSIGNF_TOLERANCE, 0},
{2428, 1029557624u, 3302959071u, 3177041272u, 0, COPYSIGNF_TOLERANCE, 0},
{2429, 1207675424u, 3042692550u, 3355159072u, 0, COPYSIGNF_TOLERANCE, 0},
{2430, 1028355074u, 3442294040u, 3175838722u, 0, COPYSIGNF_TOLERANCE, 0},
{2431, 3119299090u, 1187096397u, 971815442u, 0, COPYSIGNF_TOLERANCE, 0},
{2432, 1248421894u, 3367769132u, 3395905542u, 0, COPYSIGNF_TOLERANCE, 0},
{2433, 3353251994u, 1095517730u, 1205768346u, 0, COPYSIGNF_TOLERANCE, 0},
{2434, 876926659u, 3288089977u, 3024410307u, 0, COPYSIGNF_TOLERANCE, 0},
{2435, 1076752219u, 876236939u, 1076752219u, 0, COPYSIGNF_TOLERANCE, 0},
{2436, 3388531942u, 2988520062u, 3388531942u, 0, COPYSIGNF_TOLERANCE, 0},
{2437, 1273395082u, 3031189261u, 3420878730u, 0, COPYSIGNF_TOLERANCE, 0},
{2438, 3385588183u, 3258252464u, 3385588183u, 0, COPYSIGNF_TOLERANCE, 0},
{2439, 3192315328u, 3289489214u, 3192315328u, 0, COPYSIGNF_TOLERANCE, 0},
{2440, 3441804648u, 3274638356u, 3441804648u, 0, COPYSIGNF_TOLERANCE, 0},
{2441, 3392827417u, 1277961150u, 1245343769u, 0, COPYSIGNF_TOLERANCE, 0},
{2442, 1161241793u, 1328003707u, 1161241793u, 0, COPYSIGNF_TOLERANCE, 0},
{2443, 3034494183u, 3041579130u, 3034494183u, 0, COPYSIGNF_TOLERANCE, 0},
{2444, 1171318485u, 3374409104u, 3318802133u, 0, COPYSIGNF_TOLERANCE, 0},
{2445, 3047748143u, 831102792u, 900264495u, 0, COPYSIGNF_TOLERANCE, 0},
{2446, 1001216371u, 3052357038u, 3148700019u, 0, COPYSIGNF_TOLERANCE, 0},
{2447, 912515889u, 1074635609u, 912515889u, 0, COPYSIGNF_TOLERANCE, 0},
{2448, 3391452505u, 897989232u, 1243968857u, 0, COPYSIGNF_TOLERANCE, 0},
{2449, 3249603369u, 3147662248u, 3249603369u, 0, COPYSIGNF_TOLERANCE, 0},
{2450, 1220264047u, 2960450369u, 3367747695u, 0, COPYSIGNF_TOLERANCE, 0},
{2451, 3169816394u, 988430929u, 1022332746u, 0, COPYSIGNF_TOLERANCE, 0},
{2452, 3098997418u, 3002162688u, 3098997418u, 0, COPYSIGNF_TOLERANCE, 0},
{2453, 3282212423u, 3174079140u, 3282212423u, 0, COPYSIGNF_TOLERANCE, 0},
{2454, 3352293320u, 3247843425u, 3352293320u, 0, COPYSIGNF_TOLERANCE, 0},
{2455, 3296358441u, 875645354u, 1148874793u, 0, COPYSIGNF_TOLERANCE, 0},
{2456, 1197828352u, 3245614728u, 3345312000u, 0, COPYSIGNF_TOLERANCE, 0},
{2457, 3340510371u, 914930263u, 1193026723u, 0, COPYSIGNF_TOLERANCE, 0},
{2458, 1127109339u, 3368125489u, 3274592987u, 0, COPYSIGNF_TOLERANCE, 0},
{2459, 909467381u, 1232375752u, 909467381u, 0, COPYSIGNF_TOLERANCE, 0},
{2460, 1200599955u, 2981200675u, 3348083603u, 0, COPYSIGNF_TOLERANCE, 0},
{2461, 962230977u, 2988248037u, 3109714625u, 0, COPYSIGNF_TOLERANCE, 0},
{2462, 3192887808u, 3191848339u, 3192887808u, 0, COPYSIGNF_TOLERANCE, 0},
{2463, 3237183876u, 3179379969u, 3237183876u, 0, COPYSIGNF_TOLERANCE, 0},
{2464, 939285924u, 3056079386u, 3086769572u, 0, COPYSIGNF_TOLERANCE, 0},
{2465, 944050180u, 3452557879u, 3091533828u, 0, COPYSIGNF_TOLERANCE, 0},
{2466, 3058135703u, 3090284601u, 3058135703u, 0, COPYSIGNF_TOLERANCE, 0},
{2467, 3480592662u, 3261728191u, 3480592662u, 0, COPYSIGNF_TOLERANCE, 0},
{2468, 3061939312u, 3274418540u, 3061939312u, 0, COPYSIGNF_TOLERANCE, 0},
{2469, 1003299981u, 853295521u, 1003299981u, 0, COPYSIGNF_TOLERANCE, 0},
{2470, 1155775526u, 1255814444u, 1155775526u, 0, COPYSIGNF_TOLERANCE, 0},
{2471, 1234491880u, 3408568717u, 3381975528u, 0, COPYSIGNF_TOLERANCE, 0}

// AUTOMATICALLY GENERATED VECTORS STOP

};

#endif // CYGONCE_LIBM_COPYSIGNF_H multiple inclusion protection

// EOF copysignf.h
