#ifndef CYGONCE_LIBM_ATANHF_H
#define CYGONCE_LIBM_ATANHF_H
//===========================================================================
//
//      atanhf.h
//
//      Test vectors for testing of atanhf() math library function
//
//===========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 2012 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later
// version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License
// along with eCos; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
// As a special exception, if other files instantiate templates or use
// macros or inline functions from this file, or you compile this file
// and link it with other works to produce a work based on this file,
// this file does not by itself cause the resulting work to be covered by
// the GNU General Public License. However the source code for this file
// must still be made available in accordance with section (3) of the GNU
// General Public License v2.
//
// This exception does not invalidate any other reasons why a work based
// on this file might be covered by the GNU General Public License.
// -------------------------------------------
// ####ECOSGPLCOPYRIGHTEND####
//===========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):
// Contributors:  visar, ilijak
// Date:        1998-02-13
// Purpose:
// Description:
// Usage:       #include "vectors/atanhf.h"
//
//####DESCRIPTIONEND####
//
//===========================================================================


// CONFIGURATION

#include <pkgconf/libm.h>   // Configuration header


// INCLUDES

#include <cyg/infra/cyg_type.h>    // Common type definitions and support
#include "vectors/vector_support_float.h"// extra support for math tests

#define ATANH_TOLERANCE 1.0E-04

static const Cyg_libm_test_float_vec_t atanhf_vec[] = {

// AUTOMATICALLY GENERATED VECTORS START

{0, 3214514586u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{1, 3214430700u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{2, 3214346813u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{3, 3214262927u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{4, 3214179041u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{5, 3214095155u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{6, 3214011269u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{7, 3213927383u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{8, 3213843497u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{9, 3213759611u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{10, 3213675725u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{11, 3213591839u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{12, 3213507953u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{13, 3213424067u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{14, 3213340180u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{15, 3213256294u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{16, 3213172408u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{17, 3213088522u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{18, 3213004636u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{19, 3212920750u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{20, 3212836864u, 1115684864u, 4286578688u, EDOM, ATANH_TOLERANCE, 0},
{21, 3212669092u, 3223937731u, 3223937731u, 0, ATANH_TOLERANCE, 0},
{22, 3212501320u, 3222473531u, 3222473531u, 0, ATANH_TOLERANCE, 0},
{23, 3212333548u, 3221612590u, 3221612590u, 0, ATANH_TOLERANCE, 0},
{24, 3212165775u, 3220771731u, 3220771731u, 0, ATANH_TOLERANCE, 0},
{25, 3211998003u, 3219814346u, 3219814346u, 0, ATANH_TOLERANCE, 0},
{26, 3211830231u, 3219028070u, 3219028070u, 0, ATANH_TOLERANCE, 0},
{27, 3211662459u, 3218359840u, 3218359840u, 0, ATANH_TOLERANCE, 0},
{28, 3211494687u, 3217777981u, 3217777981u, 0, ATANH_TOLERANCE, 0},
{29, 3211326915u, 3217262061u, 3217262061u, 0, ATANH_TOLERANCE, 0},
{30, 3211159142u, 3216798127u, 3216798127u, 0, ATANH_TOLERANCE, 0},
{31, 3210991370u, 3216376234u, 3216376234u, 0, ATANH_TOLERANCE, 0},
{32, 3210823598u, 3215989031u, 3215989031u, 0, ATANH_TOLERANCE, 0},
{33, 3210655826u, 3215630939u, 3215630939u, 0, ATANH_TOLERANCE, 0},
{34, 3210488054u, 3215297618u, 3215297618u, 0, ATANH_TOLERANCE, 0},
{35, 3210320282u, 3214985630u, 3214985630u, 0, ATANH_TOLERANCE, 0},
{36, 3210152509u, 3214692201u, 3214692201u, 0, ATANH_TOLERANCE, 0},
{37, 3209984737u, 3214415066u, 3214415066u, 0, ATANH_TOLERANCE, 0},
{38, 3209816965u, 3214152344u, 3214152344u, 0, ATANH_TOLERANCE, 0},
{39, 3209649193u, 3213902461u, 3213902461u, 0, ATANH_TOLERANCE, 0},
{40, 3209481421u, 3213664084u, 3213664084u, 0, ATANH_TOLERANCE, 0},
{41, 3209313649u, 3213436077u, 3213436077u, 0, ATANH_TOLERANCE, 0},
{42, 3209145876u, 3213217459u, 3213217459u, 0, ATANH_TOLERANCE, 0},
{43, 3208978104u, 3213007385u, 3213007385u, 0, ATANH_TOLERANCE, 0},
{44, 3208810332u, 3212773363u, 3212773363u, 0, ATANH_TOLERANCE, 0},
{45, 3208642560u, 3212383125u, 3212383125u, 0, ATANH_TOLERANCE, 0},
{46, 3208474788u, 3212006046u, 3212006046u, 0, ATANH_TOLERANCE, 0},
{47, 3208307016u, 3211641108u, 3211641108u, 0, ATANH_TOLERANCE, 0},
{48, 3208139244u, 3211287405u, 3211287405u, 0, ATANH_TOLERANCE, 0},
{49, 3207971471u, 3210944122u, 3210944122u, 0, ATANH_TOLERANCE, 0},
{50, 3207803699u, 3210610536u, 3210610536u, 0, ATANH_TOLERANCE, 0},
{51, 3207635927u, 3210285985u, 3210285985u, 0, ATANH_TOLERANCE, 0},
{52, 3207468155u, 3209969873u, 3209969873u, 0, ATANH_TOLERANCE, 0},
{53, 3207300383u, 3209661661u, 3209661661u, 0, ATANH_TOLERANCE, 0},
{54, 3207132611u, 3209360854u, 3209360854u, 0, ATANH_TOLERANCE, 0},
{55, 3206964838u, 3209067001u, 3209067001u, 0, ATANH_TOLERANCE, 0},
{56, 3206797066u, 3208779692u, 3208779692u, 0, ATANH_TOLERANCE, 0},
{57, 3206629294u, 3208498547u, 3208498547u, 0, ATANH_TOLERANCE, 0},
{58, 3206461522u, 3208223215u, 3208223215u, 0, ATANH_TOLERANCE, 0},
{59, 3206293750u, 3207953375u, 3207953375u, 0, ATANH_TOLERANCE, 0},
{60, 3206125978u, 3207688728u, 3207688728u, 0, ATANH_TOLERANCE, 0},
{61, 3205958205u, 3207428997u, 3207428997u, 0, ATANH_TOLERANCE, 0},
{62, 3205790433u, 3207173927u, 3207173927u, 0, ATANH_TOLERANCE, 0},
{63, 3205622661u, 3206923278u, 3206923278u, 0, ATANH_TOLERANCE, 0},
{64, 3205454889u, 3206676827u, 3206676827u, 0, ATANH_TOLERANCE, 0},
{65, 3205287117u, 3206434365u, 3206434365u, 0, ATANH_TOLERANCE, 0},
{66, 3205119345u, 3206195697u, 3206195697u, 0, ATANH_TOLERANCE, 0},
{67, 3204951572u, 3205960640u, 3205960640u, 0, ATANH_TOLERANCE, 0},
{68, 3204783800u, 3205729024u, 3205729024u, 0, ATANH_TOLERANCE, 0},
{69, 3204616028u, 3205500687u, 3205500687u, 0, ATANH_TOLERANCE, 0},
{70, 3204448256u, 3205275476u, 3205275476u, 0, ATANH_TOLERANCE, 0},
{71, 3204112712u, 3205053248u, 3205053248u, 0, ATANH_TOLERANCE, 0},
{72, 3203777167u, 3204833868u, 3204833868u, 0, ATANH_TOLERANCE, 0},
{73, 3203441623u, 3204617208u, 3204617208u, 0, ATANH_TOLERANCE, 0},
{74, 3203106079u, 3204358038u, 3204358038u, 0, ATANH_TOLERANCE, 0},
{75, 3202770534u, 3203934881u, 3203934881u, 0, ATANH_TOLERANCE, 0},
{76, 3202434990u, 3203516476u, 3203516476u, 0, ATANH_TOLERANCE, 0},
{77, 3202099446u, 3203102612u, 3203102612u, 0, ATANH_TOLERANCE, 0},
{78, 3201763901u, 3202693091u, 3202693091u, 0, ATANH_TOLERANCE, 0},
{79, 3201428357u, 3202287727u, 3202287727u, 0, ATANH_TOLERANCE, 0},
{80, 3201092813u, 3201886339u, 3201886339u, 0, ATANH_TOLERANCE, 0},
{81, 3200757268u, 3201488755u, 3201488755u, 0, ATANH_TOLERANCE, 0},
{82, 3200421724u, 3201094814u, 3201094814u, 0, ATANH_TOLERANCE, 0},
{83, 3200086180u, 3200704357u, 3200704357u, 0, ATANH_TOLERANCE, 0},
{84, 3199750636u, 3200317233u, 3200317233u, 0, ATANH_TOLERANCE, 0},
{85, 3199415091u, 3199933297u, 3199933297u, 0, ATANH_TOLERANCE, 0},
{86, 3199079547u, 3199552413u, 3199552413u, 0, ATANH_TOLERANCE, 0},
{87, 3198744003u, 3199174448u, 3199174448u, 0, ATANH_TOLERANCE, 0},
{88, 3198408458u, 3198799270u, 3198799270u, 0, ATANH_TOLERANCE, 0},
{89, 3198072914u, 3198426759u, 3198426759u, 0, ATANH_TOLERANCE, 0},
{90, 3197737370u, 3198056795u, 3198056795u, 0, ATANH_TOLERANCE, 0},
{91, 3197401825u, 3197689261u, 3197689261u, 0, ATANH_TOLERANCE, 0},
{92, 3197066281u, 3197324049u, 3197324049u, 0, ATANH_TOLERANCE, 0},
{93, 3196730737u, 3196961049u, 3196961049u, 0, ATANH_TOLERANCE, 0},
{94, 3196395192u, 3196600156u, 3196600156u, 0, ATANH_TOLERANCE, 0},
{95, 3196059648u, 3196241272u, 3196241272u, 0, ATANH_TOLERANCE, 0},
{96, 3195388559u, 3195708944u, 3195708944u, 0, ATANH_TOLERANCE, 0},
{97, 3194717471u, 3194998622u, 3194998622u, 0, ATANH_TOLERANCE, 0},
{98, 3194046382u, 3194291739u, 3194291739u, 0, ATANH_TOLERANCE, 0},
{99, 3193375293u, 3193588118u, 3193588118u, 0, ATANH_TOLERANCE, 0},
{100, 3192704205u, 3192887583u, 3192887583u, 0, ATANH_TOLERANCE, 0},
{101, 3192033116u, 3192189961u, 3192189961u, 0, ATANH_TOLERANCE, 0},
{102, 3191362028u, 3191495084u, 3191495084u, 0, ATANH_TOLERANCE, 0},
{103, 3190690939u, 3190802787u, 3190802787u, 0, ATANH_TOLERANCE, 0},
{104, 3190019850u, 3190112909u, 3190112909u, 0, ATANH_TOLERANCE, 0},
{105, 3189348762u, 3189425295u, 3189425295u, 0, ATANH_TOLERANCE, 0},
{106, 3188677673u, 3188739788u, 3188739788u, 0, ATANH_TOLERANCE, 0},
{107, 3188006584u, 3188056235u, 3188056235u, 0, ATANH_TOLERANCE, 0},
{108, 3186999951u, 3187077935u, 3187077935u, 0, ATANH_TOLERANCE, 0},
{109, 3185657774u, 3185717758u, 3185717758u, 0, ATANH_TOLERANCE, 0},
{110, 3184315597u, 3184360607u, 3184360607u, 0, ATANH_TOLERANCE, 0},
{111, 3182973420u, 3183006194u, 3183006194u, 0, ATANH_TOLERANCE, 0},
{112, 3181631242u, 3181654236u, 3181654236u, 0, ATANH_TOLERANCE, 0},
{113, 3180289065u, 3180304456u, 3180304456u, 0, ATANH_TOLERANCE, 0},
{114, 3178611343u, 3178630713u, 3178630713u, 0, ATANH_TOLERANCE, 0},
{115, 3175926989u, 3175938190u, 3175938190u, 0, ATANH_TOLERANCE, 0},
{116, 3173242634u, 3173248366u, 3173248366u, 0, ATANH_TOLERANCE, 0},
{117, 3170222735u, 3170227570u, 3170227570u, 0, ATANH_TOLERANCE, 0},
{118, 3164854026u, 3164855458u, 3164855458u, 0, ATANH_TOLERANCE, 0},
{119, 3156465418u, 3156465776u, 3156465776u, 0, ATANH_TOLERANCE, 0},
{120, 1008981770u, 1008982128u, 1008982128u, 0, ATANH_TOLERANCE, 0},
{121, 1017370378u, 1017371810u, 1017371810u, 0, ATANH_TOLERANCE, 0},
{122, 1022739087u, 1022743922u, 1022743922u, 0, ATANH_TOLERANCE, 0},
{123, 1025758986u, 1025764718u, 1025764718u, 0, ATANH_TOLERANCE, 0},
{124, 1028443341u, 1028454542u, 1028454542u, 0, ATANH_TOLERANCE, 0},
{125, 1031127695u, 1031147065u, 1031147065u, 0, ATANH_TOLERANCE, 0},
{126, 1032805417u, 1032820808u, 1032820808u, 0, ATANH_TOLERANCE, 0},
{127, 1034147594u, 1034170588u, 1034170588u, 0, ATANH_TOLERANCE, 0},
{128, 1035489772u, 1035522546u, 1035522546u, 0, ATANH_TOLERANCE, 0},
{129, 1036831949u, 1036876959u, 1036876959u, 0, ATANH_TOLERANCE, 0},
{130, 1038174126u, 1038234110u, 1038234110u, 0, ATANH_TOLERANCE, 0},
{131, 1039516303u, 1039594287u, 1039594287u, 0, ATANH_TOLERANCE, 0},
{132, 1040522936u, 1040572587u, 1040572587u, 0, ATANH_TOLERANCE, 0},
{133, 1041194025u, 1041256140u, 1041256140u, 0, ATANH_TOLERANCE, 0},
{134, 1041865114u, 1041941647u, 1041941647u, 0, ATANH_TOLERANCE, 0},
{135, 1042536202u, 1042629261u, 1042629261u, 0, ATANH_TOLERANCE, 0},
{136, 1043207291u, 1043319139u, 1043319139u, 0, ATANH_TOLERANCE, 0},
{137, 1043878380u, 1044011436u, 1044011436u, 0, ATANH_TOLERANCE, 0},
{138, 1044549468u, 1044706313u, 1044706313u, 0, ATANH_TOLERANCE, 0},
{139, 1045220557u, 1045403935u, 1045403935u, 0, ATANH_TOLERANCE, 0},
{140, 1045891645u, 1046104470u, 1046104470u, 0, ATANH_TOLERANCE, 0},
{141, 1046562734u, 1046808091u, 1046808091u, 0, ATANH_TOLERANCE, 0},
{142, 1047233823u, 1047514974u, 1047514974u, 0, ATANH_TOLERANCE, 0},
{143, 1047904911u, 1048225296u, 1048225296u, 0, ATANH_TOLERANCE, 0},
{144, 1048576000u, 1048757624u, 1048757624u, 0, ATANH_TOLERANCE, 0},
{145, 1048911544u, 1049116508u, 1049116508u, 0, ATANH_TOLERANCE, 0},
{146, 1049247089u, 1049477401u, 1049477401u, 0, ATANH_TOLERANCE, 0},
{147, 1049582633u, 1049840401u, 1049840401u, 0, ATANH_TOLERANCE, 0},
{148, 1049918177u, 1050205613u, 1050205613u, 0, ATANH_TOLERANCE, 0},
{149, 1050253722u, 1050573147u, 1050573147u, 0, ATANH_TOLERANCE, 0},
{150, 1050589266u, 1050943111u, 1050943111u, 0, ATANH_TOLERANCE, 0},
{151, 1050924810u, 1051315622u, 1051315622u, 0, ATANH_TOLERANCE, 0},
{152, 1051260355u, 1051690800u, 1051690800u, 0, ATANH_TOLERANCE, 0},
{153, 1051595899u, 1052068765u, 1052068765u, 0, ATANH_TOLERANCE, 0},
{154, 1051931443u, 1052449649u, 1052449649u, 0, ATANH_TOLERANCE, 0},
{155, 1052266988u, 1052833585u, 1052833585u, 0, ATANH_TOLERANCE, 0},
{156, 1052602532u, 1053220709u, 1053220709u, 0, ATANH_TOLERANCE, 0},
{157, 1052938076u, 1053611166u, 1053611166u, 0, ATANH_TOLERANCE, 0},
{158, 1053273620u, 1054005107u, 1054005107u, 0, ATANH_TOLERANCE, 0},
{159, 1053609165u, 1054402691u, 1054402691u, 0, ATANH_TOLERANCE, 0},
{160, 1053944709u, 1054804079u, 1054804079u, 0, ATANH_TOLERANCE, 0},
{161, 1054280253u, 1055209443u, 1055209443u, 0, ATANH_TOLERANCE, 0},
{162, 1054615798u, 1055618964u, 1055618964u, 0, ATANH_TOLERANCE, 0},
{163, 1054951342u, 1056032828u, 1056032828u, 0, ATANH_TOLERANCE, 0},
{164, 1055286886u, 1056451233u, 1056451233u, 0, ATANH_TOLERANCE, 0},
{165, 1055622431u, 1056874390u, 1056874390u, 0, ATANH_TOLERANCE, 0},
{166, 1055957975u, 1057133560u, 1057133560u, 0, ATANH_TOLERANCE, 0},
{167, 1056293519u, 1057350220u, 1057350220u, 0, ATANH_TOLERANCE, 0},
{168, 1056629064u, 1057569600u, 1057569600u, 0, ATANH_TOLERANCE, 0},
{169, 1056964608u, 1057791828u, 1057791828u, 0, ATANH_TOLERANCE, 0},
{170, 1057132380u, 1058017039u, 1058017039u, 0, ATANH_TOLERANCE, 0},
{171, 1057300152u, 1058245376u, 1058245376u, 0, ATANH_TOLERANCE, 0},
{172, 1057467924u, 1058476992u, 1058476992u, 0, ATANH_TOLERANCE, 0},
{173, 1057635697u, 1058712049u, 1058712049u, 0, ATANH_TOLERANCE, 0},
{174, 1057803469u, 1058950717u, 1058950717u, 0, ATANH_TOLERANCE, 0},
{175, 1057971241u, 1059193179u, 1059193179u, 0, ATANH_TOLERANCE, 0},
{176, 1058139013u, 1059439630u, 1059439630u, 0, ATANH_TOLERANCE, 0},
{177, 1058306785u, 1059690279u, 1059690279u, 0, ATANH_TOLERANCE, 0},
{178, 1058474557u, 1059945349u, 1059945349u, 0, ATANH_TOLERANCE, 0},
{179, 1058642330u, 1060205080u, 1060205080u, 0, ATANH_TOLERANCE, 0},
{180, 1058810102u, 1060469727u, 1060469727u, 0, ATANH_TOLERANCE, 0},
{181, 1058977874u, 1060739567u, 1060739567u, 0, ATANH_TOLERANCE, 0},
{182, 1059145646u, 1061014899u, 1061014899u, 0, ATANH_TOLERANCE, 0},
{183, 1059313418u, 1061296044u, 1061296044u, 0, ATANH_TOLERANCE, 0},
{184, 1059481190u, 1061583353u, 1061583353u, 0, ATANH_TOLERANCE, 0},
{185, 1059648963u, 1061877206u, 1061877206u, 0, ATANH_TOLERANCE, 0},
{186, 1059816735u, 1062178013u, 1062178013u, 0, ATANH_TOLERANCE, 0},
{187, 1059984507u, 1062486225u, 1062486225u, 0, ATANH_TOLERANCE, 0},
{188, 1060152279u, 1062802337u, 1062802337u, 0, ATANH_TOLERANCE, 0},
{189, 1060320051u, 1063126888u, 1063126888u, 0, ATANH_TOLERANCE, 0},
{190, 1060487823u, 1063460474u, 1063460474u, 0, ATANH_TOLERANCE, 0},
{191, 1060655596u, 1063803757u, 1063803757u, 0, ATANH_TOLERANCE, 0},
{192, 1060823368u, 1064157460u, 1064157460u, 0, ATANH_TOLERANCE, 0},
{193, 1060991140u, 1064522398u, 1064522398u, 0, ATANH_TOLERANCE, 0},
{194, 1061158912u, 1064899477u, 1064899477u, 0, ATANH_TOLERANCE, 0},
{195, 1061326684u, 1065289715u, 1065289715u, 0, ATANH_TOLERANCE, 0},
{196, 1061494456u, 1065523737u, 1065523737u, 0, ATANH_TOLERANCE, 0},
{197, 1061662228u, 1065733811u, 1065733811u, 0, ATANH_TOLERANCE, 0},
{198, 1061830001u, 1065952429u, 1065952429u, 0, ATANH_TOLERANCE, 0},
{199, 1061997773u, 1066180436u, 1066180436u, 0, ATANH_TOLERANCE, 0},
{200, 1062165545u, 1066418813u, 1066418813u, 0, ATANH_TOLERANCE, 0},
{201, 1062333317u, 1066668696u, 1066668696u, 0, ATANH_TOLERANCE, 0},
{202, 1062501089u, 1066931418u, 1066931418u, 0, ATANH_TOLERANCE, 0},
{203, 1062668861u, 1067208553u, 1067208553u, 0, ATANH_TOLERANCE, 0},
{204, 1062836634u, 1067501982u, 1067501982u, 0, ATANH_TOLERANCE, 0},
{205, 1063004406u, 1067813970u, 1067813970u, 0, ATANH_TOLERANCE, 0},
{206, 1063172178u, 1068147291u, 1068147291u, 0, ATANH_TOLERANCE, 0},
{207, 1063339950u, 1068505383u, 1068505383u, 0, ATANH_TOLERANCE, 0},
{208, 1063507722u, 1068892586u, 1068892586u, 0, ATANH_TOLERANCE, 0},
{209, 1063675494u, 1069314479u, 1069314479u, 0, ATANH_TOLERANCE, 0},
{210, 1063843267u, 1069778413u, 1069778413u, 0, ATANH_TOLERANCE, 0},
{211, 1064011039u, 1070294333u, 1070294333u, 0, ATANH_TOLERANCE, 0},
{212, 1064178811u, 1070876192u, 1070876192u, 0, ATANH_TOLERANCE, 0},
{213, 1064346583u, 1071544422u, 1071544422u, 0, ATANH_TOLERANCE, 0},
{214, 1064514355u, 1072330698u, 1072330698u, 0, ATANH_TOLERANCE, 0},
{215, 1064682127u, 1073288083u, 1073288083u, 0, ATANH_TOLERANCE, 0},
{216, 1064849900u, 1074128942u, 1074128942u, 0, ATANH_TOLERANCE, 0},
{217, 1065017672u, 1074989883u, 1074989883u, 0, ATANH_TOLERANCE, 0},
{218, 1065185444u, 1076454083u, 1076454083u, 0, ATANH_TOLERANCE, 0},
{219, 1065353216u, 1115684864u, 2139095040u, EDOM, ATANH_TOLERANCE, 0},
{220, 1065437102u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{221, 1065520988u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{222, 1065604874u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{223, 1065688760u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{224, 1065772646u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{225, 1065856532u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{226, 1065940419u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{227, 1066024305u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{228, 1066108191u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{229, 1066192077u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{230, 1066275963u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{231, 1066359849u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{232, 1066443735u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{233, 1066527621u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{234, 1066611507u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{235, 1066695393u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{236, 1066779279u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{237, 1066863165u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{238, 1066947052u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{239, 3234402267u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{240, 3231108068u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{241, 3226013659u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{242, 3217625051u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{243, 1070141403u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{244, 1078530011u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{245, 1083624420u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{246, 3253731328u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{247, 3252840038u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{248, 3251948749u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{249, 3251057459u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{250, 3250166170u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{251, 3249274880u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{252, 3248383590u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{253, 3247492301u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{254, 3246601011u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{255, 3245028147u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{256, 3243245568u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{257, 3241462989u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{258, 3239680410u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{259, 3237792973u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{260, 3234227814u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{261, 3230662656u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{262, 3224580915u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{263, 3213675725u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{264, 1058642330u, 1060205080u, 1060205080u, 0, ATANH_TOLERANCE, 0},
{265, 1075000115u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{266, 1082130432u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{267, 1085695590u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{268, 1089260749u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{269, 1091672474u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{270, 1093455053u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{271, 1095237632u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{272, 1097020211u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{273, 1098802790u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{274, 1099746509u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{275, 1100637798u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{276, 1101529088u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{277, 1102420378u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{278, 1103311667u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{279, 1104202957u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{280, 1105094246u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0},
{281, 1105985536u, 1115684864u, 2143289344u, EDOM, ATANH_TOLERANCE, 0}

// AUTOMATICALLY GENERATED VECTORS STOP

};

#endif // CYGONCE_LIBM_ATANHF_H multiple inclusion protection

// EOF atanhf.h
