#ifndef CYGONCE_LIBM_ATAN2_H
#define CYGONCE_LIBM_ATAN2_H
//===========================================================================
//
//      atan2f.h
//
//      Test vectors for testing of atan2f() math library function
//
//===========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 2012 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later
// version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License
// along with eCos; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
// As a special exception, if other files instantiate templates or use
// macros or inline functions from this file, or you compile this file
// and link it with other works to produce a work based on this file,
// this file does not by itself cause the resulting work to be covered by
// the GNU General Public License. However the source code for this file
// must still be made available in accordance with section (3) of the GNU
// General Public License v2.
//
// This exception does not invalidate any other reasons why a work based
// on this file might be covered by the GNU General Public License.
// -------------------------------------------
// ####ECOSGPLCOPYRIGHTEND####
//===========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):
// Contributors:  visar, ilijak
// Date:        1998-02-13
// Purpose:
// Description:
// Usage:       #include "vectors/atan2f.h"
//
//####DESCRIPTIONEND####
//
//===========================================================================


// CONFIGURATION

#include <pkgconf/libm.h>   // Configuration header


// INCLUDES

#include <cyg/infra/cyg_type.h>    // Common type definitions and support
#include "vectors/vector_support_float.h"// extra support for math tests

#define ATAN2_TOLERANCE 1.0E-04

static const Cyg_libm_test_float_vec_t atan2f_vec[] = {

// AUTOMATICALLY GENERATED VECTORS START

{0, 3212836864u, 3212836864u, 3222719460u, 0, ATAN2_TOLERANCE, 0},
{1, 3212836864u, 3211998003u, 3222611937u, 0, ATAN2_TOLERANCE, 0},
{2, 3212836864u, 3211159142u, 3222498911u, 0, ATAN2_TOLERANCE, 0},
{3, 3212836864u, 3210320282u, 3222380124u, 0, ATAN2_TOLERANCE, 0},
{4, 3212836864u, 3209481421u, 3222255330u, 0, ATAN2_TOLERANCE, 0},
{5, 3212836864u, 3208642560u, 3222124301u, 0, ATAN2_TOLERANCE, 0},
{6, 3212836864u, 3207803699u, 3221986832u, 0, ATAN2_TOLERANCE, 0},
{7, 3212836864u, 3206964838u, 3221842754u, 0, ATAN2_TOLERANCE, 0},
{8, 3212836864u, 3206125978u, 3221691945u, 0, ATAN2_TOLERANCE, 0},
{9, 3212836864u, 3205287117u, 3221534339u, 0, ATAN2_TOLERANCE, 0},
{10, 3212836864u, 3204448256u, 3221369940u, 0, ATAN2_TOLERANCE, 0},
{11, 3212836864u, 3202770534u, 3221172206u, 0, ATAN2_TOLERANCE, 0},
{12, 3212836864u, 3201092813u, 3220816969u, 0, ATAN2_TOLERANCE, 0},
{13, 3212836864u, 3199415091u, 3220449284u, 0, ATAN2_TOLERANCE, 0},
{14, 3212836864u, 3197737370u, 3220069967u, 0, ATAN2_TOLERANCE, 0},
{15, 3212836864u, 3196059648u, 3219680081u, 0, ATAN2_TOLERANCE, 0},
{16, 3212836864u, 3192704205u, 3219280925u, 0, ATAN2_TOLERANCE, 0},
{17, 3212836864u, 3189348762u, 3218874030u, 0, ATAN2_TOLERANCE, 0},
{18, 3212836864u, 3184315597u, 3218461132u, 0, ATAN2_TOLERANCE, 0},
{19, 3212836864u, 3175926989u, 3218044132u, 0, ATAN2_TOLERANCE, 0},
{20, 3212836864u, 1028443341u, 3217205969u, 0, ATAN2_TOLERANCE, 0},
{21, 3212836864u, 1036831949u, 3216788969u, 0, ATAN2_TOLERANCE, 0},
{22, 3212836864u, 1041865114u, 3216376071u, 0, ATAN2_TOLERANCE, 0},
{23, 3212836864u, 1045220557u, 3215969177u, 0, ATAN2_TOLERANCE, 0},
{24, 3212836864u, 1048576000u, 3215570021u, 0, ATAN2_TOLERANCE, 0},
{25, 3212836864u, 1050253722u, 3215180134u, 0, ATAN2_TOLERANCE, 0},
{26, 3212836864u, 1051931443u, 3214800818u, 0, ATAN2_TOLERANCE, 0},
{27, 3212836864u, 1053609165u, 3214433132u, 0, ATAN2_TOLERANCE, 0},
{28, 3212836864u, 1055286886u, 3214077895u, 0, ATAN2_TOLERANCE, 0},
{29, 3212836864u, 1056964608u, 3213735693u, 0, ATAN2_TOLERANCE, 0},
{30, 3212836864u, 1057803469u, 3213406896u, 0, ATAN2_TOLERANCE, 0},
{31, 3212836864u, 1058642330u, 3213091683u, 0, ATAN2_TOLERANCE, 0},
{32, 3212836864u, 1059481190u, 3212743266u, 0, ATAN2_TOLERANCE, 0},
{33, 3212836864u, 1060320051u, 3212166956u, 0, ATAN2_TOLERANCE, 0},
{34, 3212836864u, 1061158912u, 3211617080u, 0, ATAN2_TOLERANCE, 0},
{35, 3212836864u, 1061997773u, 3211092963u, 0, ATAN2_TOLERANCE, 0},
{36, 3212836864u, 1062836634u, 3210593788u, 0, ATAN2_TOLERANCE, 0},
{37, 3212836864u, 1063675494u, 3210118640u, 0, ATAN2_TOLERANCE, 0},
{38, 3212836864u, 1064514355u, 3209666533u, 0, ATAN2_TOLERANCE, 0},
{39, 3211998003u, 3212836864u, 3222826983u, 0, ATAN2_TOLERANCE, 0},
{40, 3211998003u, 3211998003u, 3222719460u, 0, ATAN2_TOLERANCE, 0},
{41, 3211998003u, 3211159142u, 3222606128u, 0, ATAN2_TOLERANCE, 0},
{42, 3211998003u, 3210320282u, 3222486682u, 0, ATAN2_TOLERANCE, 0},
{43, 3211998003u, 3209481421u, 3222360825u, 0, ATAN2_TOLERANCE, 0},
{44, 3211998003u, 3208642560u, 3222228270u, 0, ATAN2_TOLERANCE, 0},
{45, 3211998003u, 3207803699u, 3222088756u, 0, ATAN2_TOLERANCE, 0},
{46, 3211998003u, 3206964838u, 3221942054u, 0, ATAN2_TOLERANCE, 0},
{47, 3211998003u, 3206125978u, 3221787981u, 0, ATAN2_TOLERANCE, 0},
{48, 3211998003u, 3205287117u, 3221626414u, 0, ATAN2_TOLERANCE, 0},
{49, 3211998003u, 3204448256u, 3221457309u, 0, ATAN2_TOLERANCE, 0},
{50, 3211998003u, 3202770534u, 3221280713u, 0, ATAN2_TOLERANCE, 0},
{51, 3211998003u, 3201092813u, 3220968099u, 0, ATAN2_TOLERANCE, 0},
{52, 3211998003u, 3199415091u, 3220586149u, 0, ATAN2_TOLERANCE, 0},
{53, 3211998003u, 3197737370u, 3220190949u, 0, ATAN2_TOLERANCE, 0},
{54, 3211998003u, 3196059648u, 3219783638u, 0, ATAN2_TOLERANCE, 0},
{55, 3211998003u, 3192704205u, 3219365655u, 0, ATAN2_TOLERANCE, 0},
{56, 3211998003u, 3189348762u, 3218938722u, 0, ATAN2_TOLERANCE, 0},
{57, 3211998003u, 3184315597u, 3218504822u, 0, ATAN2_TOLERANCE, 0},
{58, 3211998003u, 3175926989u, 3218066149u, 0, ATAN2_TOLERANCE, 0},
{59, 3211998003u, 1028443341u, 3217183952u, 0, ATAN2_TOLERANCE, 0},
{60, 3211998003u, 1036831949u, 3216745279u, 0, ATAN2_TOLERANCE, 0},
{61, 3211998003u, 1041865114u, 3216311379u, 0, ATAN2_TOLERANCE, 0},
{62, 3211998003u, 1045220557u, 3215884446u, 0, ATAN2_TOLERANCE, 0},
{63, 3211998003u, 1048576000u, 3215466463u, 0, ATAN2_TOLERANCE, 0},
{64, 3211998003u, 1050253722u, 3215059153u, 0, ATAN2_TOLERANCE, 0},
{65, 3211998003u, 1051931443u, 3214663953u, 0, ATAN2_TOLERANCE, 0},
{66, 3211998003u, 1053609165u, 3214282002u, 0, ATAN2_TOLERANCE, 0},
{67, 3211998003u, 1055286886u, 3213914147u, 0, ATAN2_TOLERANCE, 0},
{68, 3211998003u, 1056964608u, 3213560955u, 0, ATAN2_TOLERANCE, 0},
{69, 3211998003u, 1057803469u, 3213222745u, 0, ATAN2_TOLERANCE, 0},
{70, 3211998003u, 1058642330u, 3212899611u, 0, ATAN2_TOLERANCE, 0},
{71, 3211998003u, 1059481190u, 3212346065u, 0, ATAN2_TOLERANCE, 0},
{72, 3211998003u, 1060320051u, 3211759257u, 0, ATAN2_TOLERANCE, 0},
{73, 3211998003u, 1061158912u, 3211201201u, 0, ATAN2_TOLERANCE, 0},
{74, 3211998003u, 1061997773u, 3210670983u, 0, ATAN2_TOLERANCE, 0},
{75, 3211998003u, 1062836634u, 3210167553u, 0, ATAN2_TOLERANCE, 0},
{76, 3211998003u, 1063675494u, 3209689771u, 0, ATAN2_TOLERANCE, 0},
{77, 3211998003u, 1064514355u, 3209236443u, 0, ATAN2_TOLERANCE, 0},
{78, 3211159142u, 3212836864u, 3222940009u, 0, ATAN2_TOLERANCE, 0},
{79, 3211159142u, 3211998003u, 3222832792u, 0, ATAN2_TOLERANCE, 0},
{80, 3211159142u, 3211159142u, 3222719460u, 0, ATAN2_TOLERANCE, 0},
{81, 3211159142u, 3210320282u, 3222599655u, 0, ATAN2_TOLERANCE, 0},
{82, 3211159142u, 3209481421u, 3222473020u, 0, ATAN2_TOLERANCE, 0},
{83, 3211159142u, 3208642560u, 3222339205u, 0, ATAN2_TOLERANCE, 0},
{84, 3211159142u, 3207803699u, 3222197877u, 0, ATAN2_TOLERANCE, 0},
{85, 3211159142u, 3206964838u, 3222048736u, 0, ATAN2_TOLERANCE, 0},
{86, 3211159142u, 3206125978u, 3221891523u, 0, ATAN2_TOLERANCE, 0},
{87, 3211159142u, 3205287117u, 3221726044u, 0, ATAN2_TOLERANCE, 0},
{88, 3211159142u, 3204448256u, 3221552187u, 0, ATAN2_TOLERANCE, 0},
{89, 3211159142u, 3202770534u, 3221369940u, 0, ATAN2_TOLERANCE, 0},
{90, 3211159142u, 3201092813u, 3221133371u, 0, ATAN2_TOLERANCE, 0},
{91, 3211159142u, 3199415091u, 3220736312u, 0, ATAN2_TOLERANCE, 0},
{92, 3211159142u, 3197737370u, 3220324090u, 0, ATAN2_TOLERANCE, 0},
{93, 3211159142u, 3196059648u, 3219897918u, 0, ATAN2_TOLERANCE, 0},
{94, 3211159142u, 3192704205u, 3219459379u, 0, ATAN2_TOLERANCE, 0},
{95, 3211159142u, 3189348762u, 3219010418u, 0, ATAN2_TOLERANCE, 0},
{96, 3211159142u, 3184315597u, 3218553311u, 0, ATAN2_TOLERANCE, 0},
{97, 3211159142u, 3175926989u, 3218090606u, 0, ATAN2_TOLERANCE, 0},
{98, 3211159142u, 1028443341u, 3217159495u, 0, ATAN2_TOLERANCE, 0},
{99, 3211159142u, 1036831949u, 3216696791u, 0, ATAN2_TOLERANCE, 0},
{100, 3211159142u, 1041865114u, 3216239683u, 0, ATAN2_TOLERANCE, 0},
{101, 3211159142u, 1045220557u, 3215790723u, 0, ATAN2_TOLERANCE, 0},
{102, 3211159142u, 1048576000u, 3215352184u, 0, ATAN2_TOLERANCE, 0},
{103, 3211159142u, 1050253722u, 3214926011u, 0, ATAN2_TOLERANCE, 0},
{104, 3211159142u, 1051931443u, 3214513789u, 0, ATAN2_TOLERANCE, 0},
{105, 3211159142u, 1053609165u, 3214116731u, 0, ATAN2_TOLERANCE, 0},
{106, 3211159142u, 1055286886u, 3213735693u, 0, ATAN2_TOLERANCE, 0},
{107, 3211159142u, 1056964608u, 3213371200u, 0, ATAN2_TOLERANCE, 0},
{108, 3211159142u, 1057803469u, 3213023485u, 0, ATAN2_TOLERANCE, 0},
{109, 3211159142u, 1058642330u, 3212548191u, 0, ATAN2_TOLERANCE, 0},
{110, 3211159142u, 1059481190u, 3211919340u, 0, ATAN2_TOLERANCE, 0},
{111, 3211159142u, 1060320051u, 3211322773u, 0, ATAN2_TOLERANCE, 0},
{112, 3211159142u, 1061158912u, 3210757463u, 0, ATAN2_TOLERANCE, 0},
{113, 3211159142u, 1061997773u, 3210222202u, 0, ATAN2_TOLERANCE, 0},
{114, 3211159142u, 1062836634u, 3209715661u, 0, ATAN2_TOLERANCE, 0},
{115, 3211159142u, 1063675494u, 3209236443u, 0, ATAN2_TOLERANCE, 0},
{116, 3211159142u, 1064514355u, 3208783115u, 0, ATAN2_TOLERANCE, 0},
{117, 3210320282u, 3212836864u, 3223058796u, 0, ATAN2_TOLERANCE, 0},
{118, 3210320282u, 3211998003u, 3222952238u, 0, ATAN2_TOLERANCE, 0},
{119, 3210320282u, 3211159142u, 3222839265u, 0, ATAN2_TOLERANCE, 0},
{120, 3210320282u, 3210320282u, 3222719460u, 0, ATAN2_TOLERANCE, 0},
{121, 3210320282u, 3209481421u, 3222592399u, 0, ATAN2_TOLERANCE, 0},
{122, 3210320282u, 3208642560u, 3222457657u, 0, ATAN2_TOLERANCE, 0},
{123, 3210320282u, 3207803699u, 3222314820u, 0, ATAN2_TOLERANCE, 0},
{124, 3210320282u, 3206964838u, 3222163499u, 0, ATAN2_TOLERANCE, 0},
{125, 3210320282u, 3206125978u, 3222003345u, 0, ATAN2_TOLERANCE, 0},
{126, 3210320282u, 3205287117u, 3221834070u, 0, ATAN2_TOLERANCE, 0},
{127, 3210320282u, 3204448256u, 3221655474u, 0, ATAN2_TOLERANCE, 0},
{128, 3210320282u, 3202770534u, 3221467465u, 0, ATAN2_TOLERANCE, 0},
{129, 3210320282u, 3201092813u, 3221270095u, 0, ATAN2_TOLERANCE, 0},
{130, 3210320282u, 3199415091u, 3220901700u, 0, ATAN2_TOLERANCE, 0},
{131, 3210320282u, 3197737370u, 3220471243u, 0, ATAN2_TOLERANCE, 0},
{132, 3210320282u, 3196059648u, 3220024624u, 0, ATAN2_TOLERANCE, 0},
{133, 3210320282u, 3192704205u, 3219563580u, 0, ATAN2_TOLERANCE, 0},
{134, 3210320282u, 3189348762u, 3219090307u, 0, ATAN2_TOLERANCE, 0},
{135, 3210320282u, 3184315597u, 3218607430u, 0, ATAN2_TOLERANCE, 0},
{136, 3210320282u, 3175926989u, 3218117930u, 0, ATAN2_TOLERANCE, 0},
{137, 3210320282u, 1028443341u, 3217132171u, 0, ATAN2_TOLERANCE, 0},
{138, 3210320282u, 1036831949u, 3216642671u, 0, ATAN2_TOLERANCE, 0},
{139, 3210320282u, 1041865114u, 3216159794u, 0, ATAN2_TOLERANCE, 0},
{140, 3210320282u, 1045220557u, 3215686522u, 0, ATAN2_TOLERANCE, 0},
{141, 3210320282u, 1048576000u, 3215225477u, 0, ATAN2_TOLERANCE, 0},
{142, 3210320282u, 1050253722u, 3214778858u, 0, ATAN2_TOLERANCE, 0},
{143, 3210320282u, 1051931443u, 3214348401u, 0, ATAN2_TOLERANCE, 0},
{144, 3210320282u, 1053609165u, 3213935384u, 0, ATAN2_TOLERANCE, 0},
{145, 3210320282u, 1055286886u, 3213540644u, 0, ATAN2_TOLERANCE, 0},
{146, 3210320282u, 1056964608u, 3213164626u, 0, ATAN2_TOLERANCE, 0},
{147, 3210320282u, 1057803469u, 3212778001u, 0, ATAN2_TOLERANCE, 0},
{148, 3210320282u, 1058642330u, 3212100904u, 0, ATAN2_TOLERANCE, 0},
{149, 3210320282u, 1059481190u, 3211460288u, 0, ATAN2_TOLERANCE, 0},
{150, 3210320282u, 1060320051u, 3210855004u, 0, ATAN2_TOLERANCE, 0},
{151, 3210320282u, 1061158912u, 3210283656u, 0, ATAN2_TOLERANCE, 0},
{152, 3210320282u, 1061997773u, 3209744688u, 0, ATAN2_TOLERANCE, 0},
{153, 3210320282u, 1062836634u, 3209236443u, 0, ATAN2_TOLERANCE, 0},
{154, 3210320282u, 1063675494u, 3208757224u, 0, ATAN2_TOLERANCE, 0},
{155, 3210320282u, 1064514355u, 3208305332u, 0, ATAN2_TOLERANCE, 0},
{156, 3209481421u, 3212836864u, 3223183590u, 0, ATAN2_TOLERANCE, 0},
{157, 3209481421u, 3211998003u, 3223078095u, 0, ATAN2_TOLERANCE, 0},
{158, 3209481421u, 3211159142u, 3222965900u, 0, ATAN2_TOLERANCE, 0},
{159, 3209481421u, 3210320282u, 3222846521u, 0, ATAN2_TOLERANCE, 0},
{160, 3209481421u, 3209481421u, 3222719460u, 0, ATAN2_TOLERANCE, 0},
{161, 3209481421u, 3208642560u, 3222584207u, 0, ATAN2_TOLERANCE, 0},
{162, 3209481421u, 3207803699u, 3222440253u, 0, ATAN2_TOLERANCE, 0},
{163, 3209481421u, 3206964838u, 3222287104u, 0, ATAN2_TOLERANCE, 0},
{164, 3209481421u, 3206125978u, 3222124301u, 0, ATAN2_TOLERANCE, 0},
{165, 3209481421u, 3205287117u, 3221951438u, 0, ATAN2_TOLERANCE, 0},
{166, 3209481421u, 3204448256u, 3221768197u, 0, ATAN2_TOLERANCE, 0},
{167, 3209481421u, 3202770534u, 3221574378u, 0, ATAN2_TOLERANCE, 0},
{168, 3209481421u, 3201092813u, 3221369940u, 0, ATAN2_TOLERANCE, 0},
{169, 3209481421u, 3199415091u, 3221084600u, 0, ATAN2_TOLERANCE, 0},
{170, 3209481421u, 3197737370u, 3220634637u, 0, ATAN2_TOLERANCE, 0},
{171, 3209481421u, 3196059648u, 3220165833u, 0, ATAN2_TOLERANCE, 0},
{172, 3209481421u, 3192704205u, 3219680081u, 0, ATAN2_TOLERANCE, 0},
{173, 3209481421u, 3189348762u, 3219179862u, 0, ATAN2_TOLERANCE, 0},
{174, 3209481421u, 3184315597u, 3218668216u, 0, ATAN2_TOLERANCE, 0},
{175, 3209481421u, 3175926989u, 3218148658u, 0, ATAN2_TOLERANCE, 0},
{176, 3209481421u, 1028443341u, 3217101444u, 0, ATAN2_TOLERANCE, 0},
{177, 3209481421u, 1036831949u, 3216581885u, 0, ATAN2_TOLERANCE, 0},
{178, 3209481421u, 1041865114u, 3216070239u, 0, ATAN2_TOLERANCE, 0},
{179, 3209481421u, 1045220557u, 3215570021u, 0, ATAN2_TOLERANCE, 0},
{180, 3209481421u, 1048576000u, 3215084268u, 0, ATAN2_TOLERANCE, 0},
{181, 3209481421u, 1050253722u, 3214615464u, 0, ATAN2_TOLERANCE, 0},
{182, 3209481421u, 1051931443u, 3214165501u, 0, ATAN2_TOLERANCE, 0},
{183, 3209481421u, 1053609165u, 3213735693u, 0, ATAN2_TOLERANCE, 0},
{184, 3209481421u, 1055286886u, 3213326816u, 0, ATAN2_TOLERANCE, 0},
{185, 3209481421u, 1056964608u, 3212939180u, 0, ATAN2_TOLERANCE, 0},
{186, 3209481421u, 1057803469u, 3212308532u, 0, ATAN2_TOLERANCE, 0},
{187, 3209481421u, 1058642330u, 3211617080u, 0, ATAN2_TOLERANCE, 0},
{188, 3209481421u, 1059481190u, 3210965865u, 0, ATAN2_TOLERANCE, 0},
{189, 3209481421u, 1060320051u, 3210353271u, 0, ATAN2_TOLERANCE, 0},
{190, 3209481421u, 1061158912u, 3209777456u, 0, ATAN2_TOLERANCE, 0},
{191, 3209481421u, 1061997773u, 3209236443u, 0, ATAN2_TOLERANCE, 0},
{192, 3209481421u, 1062836634u, 3208728198u, 0, ATAN2_TOLERANCE, 0},
{193, 3209481421u, 1063675494u, 3208250684u, 0, ATAN2_TOLERANCE, 0},
{194, 3209481421u, 1064514355u, 3207801902u, 0, ATAN2_TOLERANCE, 0},
{195, 3208642560u, 3212836864u, 3223314619u, 0, ATAN2_TOLERANCE, 0},
{196, 3208642560u, 3211998003u, 3223210650u, 0, ATAN2_TOLERANCE, 0},
{197, 3208642560u, 3211159142u, 3223099715u, 0, ATAN2_TOLERANCE, 0},
{198, 3208642560u, 3210320282u, 3222981263u, 0, ATAN2_TOLERANCE, 0},
{199, 3208642560u, 3209481421u, 3222854713u, 0, ATAN2_TOLERANCE, 0},
{200, 3208642560u, 3208642560u, 3222719460u, 0, ATAN2_TOLERANCE, 0},
{201, 3208642560u, 3207803699u, 3222574886u, 0, ATAN2_TOLERANCE, 0},
{202, 3208642560u, 3206964838u, 3222420375u, 0, ATAN2_TOLERANCE, 0},
{203, 3208642560u, 3206125978u, 3222255330u, 0, ATAN2_TOLERANCE, 0},
{204, 3208642560u, 3205287117u, 3222079202u, 0, ATAN2_TOLERANCE, 0},
{205, 3208642560u, 3204448256u, 3221891523u, 0, ATAN2_TOLERANCE, 0},
{206, 3208642560u, 3202770534u, 3221691945u, 0, ATAN2_TOLERANCE, 0},
{207, 3208642560u, 3201092813u, 3221480291u, 0, ATAN2_TOLERANCE, 0},
{208, 3208642560u, 3199415091u, 3221256608u, 0, ATAN2_TOLERANCE, 0},
{209, 3208642560u, 3197737370u, 3220816969u, 0, ATAN2_TOLERANCE, 0},
{210, 3208642560u, 3196059648u, 3220324090u, 0, ATAN2_TOLERANCE, 0},
{211, 3208642560u, 3192704205u, 3219811142u, 0, ATAN2_TOLERANCE, 0},
{212, 3208642560u, 3189348762u, 3219280925u, 0, ATAN2_TOLERANCE, 0},
{213, 3208642560u, 3184315597u, 3218736973u, 0, ATAN2_TOLERANCE, 0},
{214, 3208642560u, 3175926989u, 3218183465u, 0, ATAN2_TOLERANCE, 0},
{215, 3208642560u, 1028443341u, 3217066636u, 0, ATAN2_TOLERANCE, 0},
{216, 3208642560u, 1036831949u, 3216513128u, 0, ATAN2_TOLERANCE, 0},
{217, 3208642560u, 1041865114u, 3215969177u, 0, ATAN2_TOLERANCE, 0},
{218, 3208642560u, 1045220557u, 3215438959u, 0, ATAN2_TOLERANCE, 0},
{219, 3208642560u, 1048576000u, 3214926011u, 0, ATAN2_TOLERANCE, 0},
{220, 3208642560u, 1050253722u, 3214433132u, 0, ATAN2_TOLERANCE, 0},
{221, 3208642560u, 1051931443u, 3213962357u, 0, ATAN2_TOLERANCE, 0},
{222, 3208642560u, 1053609165u, 3213514991u, 0, ATAN2_TOLERANCE, 0},
{223, 3208642560u, 1055286886u, 3213091683u, 0, ATAN2_TOLERANCE, 0},
{224, 3208642560u, 1056964608u, 3212548191u, 0, ATAN2_TOLERANCE, 0},
{225, 3208642560u, 1057803469u, 3211797473u, 0, ATAN2_TOLERANCE, 0},
{226, 3208642560u, 1058642330u, 3211092963u, 0, ATAN2_TOLERANCE, 0},
{227, 3208642560u, 1059481190u, 3210432783u, 0, ATAN2_TOLERANCE, 0},
{228, 3208642560u, 1060320051u, 3209814738u, 0, ATAN2_TOLERANCE, 0},
{229, 3208642560u, 1061158912u, 3209236443u, 0, ATAN2_TOLERANCE, 0},
{230, 3208642560u, 1061997773u, 3208695430u, 0, ATAN2_TOLERANCE, 0},
{231, 3208642560u, 1062836634u, 3208189229u, 0, ATAN2_TOLERANCE, 0},
{232, 3208642560u, 1063675494u, 3207715422u, 0, ATAN2_TOLERANCE, 0},
{233, 3208642560u, 1064514355u, 3207271684u, 0, ATAN2_TOLERANCE, 0},
{234, 3207803699u, 3212836864u, 3223452088u, 0, ATAN2_TOLERANCE, 0},
{235, 3207803699u, 3211998003u, 3223350163u, 0, ATAN2_TOLERANCE, 0},
{236, 3207803699u, 3211159142u, 3223241043u, 0, ATAN2_TOLERANCE, 0},
{237, 3207803699u, 3210320282u, 3223124100u, 0, ATAN2_TOLERANCE, 0},
{238, 3207803699u, 3209481421u, 3222998667u, 0, ATAN2_TOLERANCE, 0},
{239, 3207803699u, 3208642560u, 3222864034u, 0, ATAN2_TOLERANCE, 0},
{240, 3207803699u, 3207803699u, 3222719460u, 0, ATAN2_TOLERANCE, 0},
{241, 3207803699u, 3206964838u, 3222564186u, 0, ATAN2_TOLERANCE, 0},
{242, 3207803699u, 3206125978u, 3222397455u, 0, ATAN2_TOLERANCE, 0},
{243, 3207803699u, 3205287117u, 3222218539u, 0, ATAN2_TOLERANCE, 0},
{244, 3207803699u, 3204448256u, 3222026776u, 0, ATAN2_TOLERANCE, 0},
{245, 3207803699u, 3202770534u, 3221821624u, 0, ATAN2_TOLERANCE, 0},
{246, 3207803699u, 3201092813u, 3221602718u, 0, ATAN2_TOLERANCE, 0},
{247, 3207803699u, 3199415091u, 3221369940u, 0, ATAN2_TOLERANCE, 0},
{248, 3207803699u, 3197737370u, 3221021529u, 0, ATAN2_TOLERANCE, 0},
{249, 3207803699u, 3196059648u, 3220502544u, 0, ATAN2_TOLERANCE, 0},
{250, 3207803699u, 3192704205u, 3219959597u, 0, ATAN2_TOLERANCE, 0},
{251, 3207803699u, 3189348762u, 3219395830u, 0, ATAN2_TOLERANCE, 0},
{252, 3207803699u, 3184315597u, 3218815369u, 0, ATAN2_TOLERANCE, 0},
{253, 3207803699u, 3175926989u, 3218223221u, 0, ATAN2_TOLERANCE, 0},
{254, 3207803699u, 1028443341u, 3217026880u, 0, ATAN2_TOLERANCE, 0},
{255, 3207803699u, 1036831949u, 3216434732u, 0, ATAN2_TOLERANCE, 0},
{256, 3207803699u, 1041865114u, 3215854271u, 0, ATAN2_TOLERANCE, 0},
{257, 3207803699u, 1045220557u, 3215290504u, 0, ATAN2_TOLERANCE, 0},
{258, 3207803699u, 1048576000u, 3214747557u, 0, ATAN2_TOLERANCE, 0},
{259, 3207803699u, 1050253722u, 3214228572u, 0, ATAN2_TOLERANCE, 0},
{260, 3207803699u, 1051931443u, 3213735693u, 0, ATAN2_TOLERANCE, 0},
{261, 3207803699u, 1053609165u, 3213270137u, 0, ATAN2_TOLERANCE, 0},
{262, 3207803699u, 1055286886u, 3212827785u, 0, ATAN2_TOLERANCE, 0},
{263, 3207803699u, 1056964608u, 3212007178u, 0, ATAN2_TOLERANCE, 0},
{264, 3207803699u, 1057803469u, 3211240128u, 0, ATAN2_TOLERANCE, 0},
{265, 3207803699u, 1058642330u, 3210524461u, 0, ATAN2_TOLERANCE, 0},
{266, 3207803699u, 1059481190u, 3209857537u, 0, ATAN2_TOLERANCE, 0},
{267, 3207803699u, 1060320051u, 3209236443u, 0, ATAN2_TOLERANCE, 0},
{268, 3207803699u, 1061158912u, 3208658147u, 0, ATAN2_TOLERANCE, 0},
{269, 3207803699u, 1061997773u, 3208119614u, 0, ATAN2_TOLERANCE, 0},
{270, 3207803699u, 1062836634u, 3207617881u, 0, ATAN2_TOLERANCE, 0},
{271, 3207803699u, 1063675494u, 3207150112u, 0, ATAN2_TOLERANCE, 0},
{272, 3207803699u, 1064514355u, 3206713629u, 0, ATAN2_TOLERANCE, 0},
{273, 3206964838u, 3212836864u, 3223596166u, 0, ATAN2_TOLERANCE, 0},
{274, 3206964838u, 3211998003u, 3223496866u, 0, ATAN2_TOLERANCE, 0},
{275, 3206964838u, 3211159142u, 3223390184u, 0, ATAN2_TOLERANCE, 0},
{276, 3206964838u, 3210320282u, 3223275421u, 0, ATAN2_TOLERANCE, 0},
{277, 3206964838u, 3209481421u, 3223151816u, 0, ATAN2_TOLERANCE, 0},
{278, 3206964838u, 3208642560u, 3223018545u, 0, ATAN2_TOLERANCE, 0},
{279, 3206964838u, 3207803699u, 3222874734u, 0, ATAN2_TOLERANCE, 0},
{280, 3206964838u, 3206964838u, 3222719460u, 0, ATAN2_TOLERANCE, 0},
{281, 3206964838u, 3206125978u, 3222551777u, 0, ATAN2_TOLERANCE, 0},
{282, 3206964838u, 3205287117u, 3222370740u, 0, ATAN2_TOLERANCE, 0},
{283, 3206964838u, 3204448256u, 3222175448u, 0, ATAN2_TOLERANCE, 0},
{284, 3206964838u, 3202770534u, 3221965100u, 0, ATAN2_TOLERANCE, 0},
{285, 3206964838u, 3201092813u, 3221739070u, 0, ATAN2_TOLERANCE, 0},
{286, 3206964838u, 3199415091u, 3221497002u, 0, ATAN2_TOLERANCE, 0},
{287, 3206964838u, 3197737370u, 3221238911u, 0, ATAN2_TOLERANCE, 0},
{288, 3206964838u, 3196059648u, 3220705128u, 0, ATAN2_TOLERANCE, 0},
{289, 3206964838u, 3192704205u, 3220129041u, 0, ATAN2_TOLERANCE, 0},
{290, 3206964838u, 3189348762u, 3219527577u, 0, ATAN2_TOLERANCE, 0},
{291, 3206964838u, 3184315597u, 3218905566u, 0, ATAN2_TOLERANCE, 0},
{292, 3206964838u, 3175926989u, 3218269060u, 0, ATAN2_TOLERANCE, 0},
{293, 3206964838u, 1028443341u, 3216981041u, 0, ATAN2_TOLERANCE, 0},
{294, 3206964838u, 1036831949u, 3216344535u, 0, ATAN2_TOLERANCE, 0},
{295, 3206964838u, 1041865114u, 3215722524u, 0, ATAN2_TOLERANCE, 0},
{296, 3206964838u, 1045220557u, 3215121060u, 0, ATAN2_TOLERANCE, 0},
{297, 3206964838u, 1048576000u, 3214544973u, 0, ATAN2_TOLERANCE, 0},
{298, 3206964838u, 1050253722u, 3213997751u, 0, ATAN2_TOLERANCE, 0},
{299, 3206964838u, 1051931443u, 3213481570u, 0, ATAN2_TOLERANCE, 0},
{300, 3206964838u, 1053609165u, 3212997433u, 0, ATAN2_TOLERANCE, 0},
{301, 3206964838u, 1055286886u, 3212253884u, 0, ATAN2_TOLERANCE, 0},
{302, 3206964838u, 1056964608u, 3211412490u, 0, ATAN2_TOLERANCE, 0},
{303, 3206964838u, 1057803469u, 3210631321u, 0, ATAN2_TOLERANCE, 0},
{304, 3206964838u, 1058642330u, 3209907174u, 0, ATAN2_TOLERANCE, 0},
{305, 3206964838u, 1059481190u, 3209236443u, 0, ATAN2_TOLERANCE, 0},
{306, 3206964838u, 1060320051u, 3208615348u, 0, ATAN2_TOLERANCE, 0},
{307, 3206964838u, 1061158912u, 3208040102u, 0, ATAN2_TOLERANCE, 0},
{308, 3206964838u, 1061997773u, 3207507020u, 0, ATAN2_TOLERANCE, 0},
{309, 3206964838u, 1062836634u, 3207012597u, 0, ATAN2_TOLERANCE, 0},
{310, 3206964838u, 1063675494u, 3206553546u, 0, ATAN2_TOLERANCE, 0},
{311, 3206964838u, 1064514355u, 3206126820u, 0, ATAN2_TOLERANCE, 0},
{312, 3206125978u, 3212836864u, 3223746975u, 0, ATAN2_TOLERANCE, 0},
{313, 3206125978u, 3211998003u, 3223650939u, 0, ATAN2_TOLERANCE, 0},
{314, 3206125978u, 3211159142u, 3223547397u, 0, ATAN2_TOLERANCE, 0},
{315, 3206125978u, 3210320282u, 3223435575u, 0, ATAN2_TOLERANCE, 0},
{316, 3206125978u, 3209481421u, 3223314619u, 0, ATAN2_TOLERANCE, 0},
{317, 3206125978u, 3208642560u, 3223183590u, 0, ATAN2_TOLERANCE, 0},
{318, 3206125978u, 3207803699u, 3223041465u, 0, ATAN2_TOLERANCE, 0},
{319, 3206125978u, 3206964838u, 3222887143u, 0, ATAN2_TOLERANCE, 0},
{320, 3206125978u, 3206125978u, 3222719460u, 0, ATAN2_TOLERANCE, 0},
{321, 3206125978u, 3205287117u, 3222537214u, 0, ATAN2_TOLERANCE, 0},
{322, 3206125978u, 3204448256u, 3222339205u, 0, ATAN2_TOLERANCE, 0},
{323, 3206125978u, 3202770534u, 3222124301u, 0, ATAN2_TOLERANCE, 0},
{324, 3206125978u, 3201092813u, 3221891523u, 0, ATAN2_TOLERANCE, 0},
{325, 3206125978u, 3199415091u, 3221640166u, 0, ATAN2_TOLERANCE, 0},
{326, 3206125978u, 3197737370u, 3221369940u, 0, ATAN2_TOLERANCE, 0},
{327, 3206125978u, 3196059648u, 3220936799u, 0, ATAN2_TOLERANCE, 0},
{328, 3206125978u, 3192704205u, 3220324090u, 0, ATAN2_TOLERANCE, 0},
{329, 3206125978u, 3189348762u, 3219680081u, 0, ATAN2_TOLERANCE, 0},
{330, 3206125978u, 3184315597u, 3219010418u, 0, ATAN2_TOLERANCE, 0},
{331, 3206125978u, 3175926989u, 3218322490u, 0, ATAN2_TOLERANCE, 0},
{332, 3206125978u, 1028443341u, 3216927611u, 0, ATAN2_TOLERANCE, 0},
{333, 3206125978u, 1036831949u, 3216239683u, 0, ATAN2_TOLERANCE, 0},
{334, 3206125978u, 1041865114u, 3215570021u, 0, ATAN2_TOLERANCE, 0},
{335, 3206125978u, 1045220557u, 3214926011u, 0, ATAN2_TOLERANCE, 0},
{336, 3206125978u, 1048576000u, 3214313303u, 0, ATAN2_TOLERANCE, 0},
{337, 3206125978u, 1050253722u, 3213735693u, 0, ATAN2_TOLERANCE, 0},
{338, 3206125978u, 1051931443u, 3213195241u, 0, ATAN2_TOLERANCE, 0},
{339, 3206125978u, 1053609165u, 3212548191u, 0, ATAN2_TOLERANCE, 0},
{340, 3206125978u, 1055286886u, 3211617080u, 0, ATAN2_TOLERANCE, 0},
{341, 3206125978u, 1056964608u, 3210757463u, 0, ATAN2_TOLERANCE, 0},
{342, 3206125978u, 1057803469u, 3209965428u, 0, ATAN2_TOLERANCE, 0},
{343, 3206125978u, 1058642330u, 3209236443u, 0, ATAN2_TOLERANCE, 0},
{344, 3206125978u, 1059481190u, 3208565712u, 0, ATAN2_TOLERANCE, 0},
{345, 3206125978u, 1060320051u, 3207948424u, 0, ATAN2_TOLERANCE, 0},
{346, 3206125978u, 1061158912u, 3207379923u, 0, ATAN2_TOLERANCE, 0},
{347, 3206125978u, 1061997773u, 3206855805u, 0, ATAN2_TOLERANCE, 0},
{348, 3206125978u, 1062836634u, 3206371981u, 0, ATAN2_TOLERANCE, 0},
{349, 3206125978u, 1063675494u, 3205924695u, 0, ATAN2_TOLERANCE, 0},
{350, 3206125978u, 1064514355u, 3205510527u, 0, ATAN2_TOLERANCE, 0},
{351, 3205287117u, 3212836864u, 3223904581u, 0, ATAN2_TOLERANCE, 0},
{352, 3205287117u, 3211998003u, 3223812506u, 0, ATAN2_TOLERANCE, 0},
{353, 3205287117u, 3211159142u, 3223712876u, 0, ATAN2_TOLERANCE, 0},
{354, 3205287117u, 3210320282u, 3223604850u, 0, ATAN2_TOLERANCE, 0},
{355, 3205287117u, 3209481421u, 3223487482u, 0, ATAN2_TOLERANCE, 0},
{356, 3205287117u, 3208642560u, 3223359718u, 0, ATAN2_TOLERANCE, 0},
{357, 3205287117u, 3207803699u, 3223220381u, 0, ATAN2_TOLERANCE, 0},
{358, 3205287117u, 3206964838u, 3223068180u, 0, ATAN2_TOLERANCE, 0},
{359, 3205287117u, 3206125978u, 3222901706u, 0, ATAN2_TOLERANCE, 0},
{360, 3205287117u, 3205287117u, 3222719460u, 0, ATAN2_TOLERANCE, 0},
{361, 3205287117u, 3204448256u, 3222519882u, 0, ATAN2_TOLERANCE, 0},
{362, 3205287117u, 3202770534u, 3222301419u, 0, ATAN2_TOLERANCE, 0},
{363, 3205287117u, 3201092813u, 3222062624u, 0, ATAN2_TOLERANCE, 0},
{364, 3205287117u, 3199415091u, 3221802296u, 0, ATAN2_TOLERANCE, 0},
{365, 3205287117u, 3197737370u, 3221519673u, 0, ATAN2_TOLERANCE, 0},
{366, 3205287117u, 3196059648u, 3221203861u, 0, ATAN2_TOLERANCE, 0},
{367, 3205287117u, 3192704205u, 3220550754u, 0, ATAN2_TOLERANCE, 0},
{368, 3205287117u, 3189348762u, 3219858535u, 0, ATAN2_TOLERANCE, 0},
{369, 3205287117u, 3184315597u, 3219133771u, 0, ATAN2_TOLERANCE, 0},
{370, 3205287117u, 3175926989u, 3218385561u, 0, ATAN2_TOLERANCE, 0},
{371, 3205287117u, 1028443341u, 3216864540u, 0, ATAN2_TOLERANCE, 0},
{372, 3205287117u, 1036831949u, 3216116330u, 0, ATAN2_TOLERANCE, 0},
{373, 3205287117u, 1041865114u, 3215391567u, 0, ATAN2_TOLERANCE, 0},
{374, 3205287117u, 1045220557u, 3214699347u, 0, ATAN2_TOLERANCE, 0},
{375, 3205287117u, 1048576000u, 3214046240u, 0, ATAN2_TOLERANCE, 0},
{376, 3205287117u, 1050253722u, 3213436227u, 0, ATAN2_TOLERANCE, 0},
{377, 3205287117u, 1051931443u, 3212870981u, 0, ATAN2_TOLERANCE, 0},
{378, 3205287117u, 1053609165u, 3211863786u, 0, ATAN2_TOLERANCE, 0},
{379, 3205287117u, 1055286886u, 3210908605u, 0, ATAN2_TOLERANCE, 0},
{380, 3205287117u, 1056964608u, 3210034755u, 0, ATAN2_TOLERANCE, 0},
{381, 3205287117u, 1057803469u, 3209236443u, 0, ATAN2_TOLERANCE, 0},
{382, 3205287117u, 1058642330u, 3208507458u, 0, ATAN2_TOLERANCE, 0},
{383, 3205287117u, 1059481190u, 3207841564u, 0, ATAN2_TOLERANCE, 0},
{384, 3205287117u, 1060320051u, 3207232758u, 0, ATAN2_TOLERANCE, 0},
{385, 3205287117u, 1061158912u, 3206675412u, 0, ATAN2_TOLERANCE, 0},
{386, 3205287117u, 1061997773u, 3206164353u, 0, ATAN2_TOLERANCE, 0},
{387, 3205287117u, 1062836634u, 3205694884u, 0, ATAN2_TOLERANCE, 0},
{388, 3205287117u, 1063675494u, 3205262780u, 0, ATAN2_TOLERANCE, 0},
{389, 3205287117u, 1064514355u, 3204864260u, 0, ATAN2_TOLERANCE, 0},
{390, 3204448256u, 3212836864u, 3224068980u, 0, ATAN2_TOLERANCE, 0},
{391, 3204448256u, 3211998003u, 3223981611u, 0, ATAN2_TOLERANCE, 0},
{392, 3204448256u, 3211159142u, 3223886733u, 0, ATAN2_TOLERANCE, 0},
{393, 3204448256u, 3210320282u, 3223783446u, 0, ATAN2_TOLERANCE, 0},
{394, 3204448256u, 3209481421u, 3223670723u, 0, ATAN2_TOLERANCE, 0},
{395, 3204448256u, 3208642560u, 3223547397u, 0, ATAN2_TOLERANCE, 0},
{396, 3204448256u, 3207803699u, 3223412144u, 0, ATAN2_TOLERANCE, 0},
{397, 3204448256u, 3206964838u, 3223263472u, 0, ATAN2_TOLERANCE, 0},
{398, 3204448256u, 3206125978u, 3223099715u, 0, ATAN2_TOLERANCE, 0},
{399, 3204448256u, 3205287117u, 3222919038u, 0, ATAN2_TOLERANCE, 0},
{400, 3204448256u, 3204448256u, 3222719460u, 0, ATAN2_TOLERANCE, 0},
{401, 3204448256u, 3202770534u, 3222498911u, 0, ATAN2_TOLERANCE, 0},
{402, 3204448256u, 3201092813u, 3222255330u, 0, ATAN2_TOLERANCE, 0},
{403, 3204448256u, 3199415091u, 3221986832u, 0, ATAN2_TOLERANCE, 0},
{404, 3204448256u, 3197737370u, 3221691945u, 0, ATAN2_TOLERANCE, 0},
{405, 3204448256u, 3196059648u, 3221369940u, 0, ATAN2_TOLERANCE, 0},
{406, 3204448256u, 3192704205u, 3220816969u, 0, ATAN2_TOLERANCE, 0},
{407, 3204448256u, 3189348762u, 3220069967u, 0, ATAN2_TOLERANCE, 0},
{408, 3204448256u, 3184315597u, 3219280925u, 0, ATAN2_TOLERANCE, 0},
{409, 3204448256u, 3175926989u, 3218461132u, 0, ATAN2_TOLERANCE, 0},
{410, 3204448256u, 1028443341u, 3216788969u, 0, ATAN2_TOLERANCE, 0},
{411, 3204448256u, 1036831949u, 3215969177u, 0, ATAN2_TOLERANCE, 0},
{412, 3204448256u, 1041865114u, 3215180134u, 0, ATAN2_TOLERANCE, 0},
{413, 3204448256u, 1045220557u, 3214433132u, 0, ATAN2_TOLERANCE, 0},
{414, 3204448256u, 1048576000u, 3213735693u, 0, ATAN2_TOLERANCE, 0},
{415, 3204448256u, 1050253722u, 3213091683u, 0, ATAN2_TOLERANCE, 0},
{416, 3204448256u, 1051931443u, 3212166956u, 0, ATAN2_TOLERANCE, 0},
{417, 3204448256u, 1053609165u, 3211092963u, 0, ATAN2_TOLERANCE, 0},
{418, 3204448256u, 1055286886u, 3210118640u, 0, ATAN2_TOLERANCE, 0},
{419, 3204448256u, 1056964608u, 3209236443u, 0, ATAN2_TOLERANCE, 0},
{420, 3204448256u, 1057803469u, 3208438131u, 0, ATAN2_TOLERANCE, 0},
{421, 3204448256u, 1058642330u, 3207715422u, 0, ATAN2_TOLERANCE, 0},
{422, 3204448256u, 1059481190u, 3207060395u, 0, ATAN2_TOLERANCE, 0},
{423, 3204448256u, 1060320051u, 3206465708u, 0, ATAN2_TOLERANCE, 0},
{424, 3204448256u, 1061158912u, 3205924695u, 0, ATAN2_TOLERANCE, 0},
{425, 3204448256u, 1061997773u, 3205431389u, 0, ATAN2_TOLERANCE, 0},
{426, 3204448256u, 1062836634u, 3204980498u, 0, ATAN2_TOLERANCE, 0},
{427, 3204448256u, 1063675494u, 3204567349u, 0, ATAN2_TOLERANCE, 0},
{428, 3204448256u, 1064514355u, 3203927422u, 0, ATAN2_TOLERANCE, 0},
{429, 3202770534u, 3212836864u, 3224240081u, 0, ATAN2_TOLERANCE, 0},
{430, 3202770534u, 3211998003u, 3224158207u, 0, ATAN2_TOLERANCE, 0},
{431, 3202770534u, 3211159142u, 3224068980u, 0, ATAN2_TOLERANCE, 0},
{432, 3202770534u, 3210320282u, 3223971455u, 0, ATAN2_TOLERANCE, 0},
{433, 3202770534u, 3209481421u, 3223864541u, 0, ATAN2_TOLERANCE, 0},
{434, 3202770534u, 3208642560u, 3223746975u, 0, ATAN2_TOLERANCE, 0},
{435, 3202770534u, 3207803699u, 3223617296u, 0, ATAN2_TOLERANCE, 0},
{436, 3202770534u, 3206964838u, 3223473820u, 0, ATAN2_TOLERANCE, 0},
{437, 3202770534u, 3206125978u, 3223314619u, 0, ATAN2_TOLERANCE, 0},
{438, 3202770534u, 3205287117u, 3223137501u, 0, ATAN2_TOLERANCE, 0},
{439, 3202770534u, 3204448256u, 3222940009u, 0, ATAN2_TOLERANCE, 0},
{440, 3202770534u, 3202770534u, 3222719460u, 0, ATAN2_TOLERANCE, 0},
{441, 3202770534u, 3201092813u, 3222473020u, 0, ATAN2_TOLERANCE, 0},
{442, 3202770534u, 3199415091u, 3222197877u, 0, ATAN2_TOLERANCE, 0},
{443, 3202770534u, 3197737370u, 3221891523u, 0, ATAN2_TOLERANCE, 0},
{444, 3202770534u, 3196059648u, 3221552187u, 0, ATAN2_TOLERANCE, 0},
{445, 3202770534u, 3192704205u, 3221133371u, 0, ATAN2_TOLERANCE, 0},
{446, 3202770534u, 3189348762u, 3220324090u, 0, ATAN2_TOLERANCE, 0},
{447, 3202770534u, 3184315597u, 3219459379u, 0, ATAN2_TOLERANCE, 0},
{448, 3202770534u, 3175926989u, 3218553311u, 0, ATAN2_TOLERANCE, 0},
{449, 3202770534u, 1028443341u, 3216696791u, 0, ATAN2_TOLERANCE, 0},
{450, 3202770534u, 1036831949u, 3215790723u, 0, ATAN2_TOLERANCE, 0},
{451, 3202770534u, 1041865114u, 3214926011u, 0, ATAN2_TOLERANCE, 0},
{452, 3202770534u, 1045220557u, 3214116731u, 0, ATAN2_TOLERANCE, 0},
{453, 3202770534u, 1048576000u, 3213371200u, 0, ATAN2_TOLERANCE, 0},
{454, 3202770534u, 1050253722u, 3212548191u, 0, ATAN2_TOLERANCE, 0},
{455, 3202770534u, 1051931443u, 3211322773u, 0, ATAN2_TOLERANCE, 0},
{456, 3202770534u, 1053609165u, 3210222202u, 0, ATAN2_TOLERANCE, 0},
{457, 3202770534u, 1055286886u, 3209236443u, 0, ATAN2_TOLERANCE, 0},
{458, 3202770534u, 1056964608u, 3208354245u, 0, ATAN2_TOLERANCE, 0},
{459, 3202770534u, 1057803469u, 3207564280u, 0, ATAN2_TOLERANCE, 0},
{460, 3202770534u, 1058642330u, 3206855805u, 0, ATAN2_TOLERANCE, 0},
{461, 3202770534u, 1059481190u, 3206219002u, 0, ATAN2_TOLERANCE, 0},
{462, 3202770534u, 1060320051u, 3205645100u, 0, ATAN2_TOLERANCE, 0},
{463, 3202770534u, 1061158912u, 3205126383u, 0, ATAN2_TOLERANCE, 0},
{464, 3202770534u, 1061997773u, 3204656117u, 0, ATAN2_TOLERANCE, 0},
{465, 3202770534u, 1062836634u, 3204008667u, 0, ATAN2_TOLERANCE, 0},
{466, 3202770534u, 1063675494u, 3203228472u, 0, ATAN2_TOLERANCE, 0},
{467, 3202770534u, 1064514355u, 3202514656u, 0, ATAN2_TOLERANCE, 0},
{468, 3201092813u, 3212836864u, 3224417699u, 0, ATAN2_TOLERANCE, 0},
{469, 3201092813u, 3211998003u, 3224342134u, 0, ATAN2_TOLERANCE, 0},
{470, 3201092813u, 3211159142u, 3224259499u, 0, ATAN2_TOLERANCE, 0},
{471, 3201092813u, 3210320282u, 3224168825u, 0, ATAN2_TOLERANCE, 0},
{472, 3201092813u, 3209481421u, 3224068980u, 0, ATAN2_TOLERANCE, 0},
{473, 3201092813u, 3208642560u, 3223958629u, 0, ATAN2_TOLERANCE, 0},
{474, 3201092813u, 3207803699u, 3223836202u, 0, ATAN2_TOLERANCE, 0},
{475, 3201092813u, 3206964838u, 3223699850u, 0, ATAN2_TOLERANCE, 0},
{476, 3201092813u, 3206125978u, 3223547397u, 0, ATAN2_TOLERANCE, 0},
{477, 3201092813u, 3205287117u, 3223376296u, 0, ATAN2_TOLERANCE, 0},
{478, 3201092813u, 3204448256u, 3223183590u, 0, ATAN2_TOLERANCE, 0},
{479, 3201092813u, 3202770534u, 3222965900u, 0, ATAN2_TOLERANCE, 0},
{480, 3201092813u, 3201092813u, 3222719460u, 0, ATAN2_TOLERANCE, 0},
{481, 3201092813u, 3199415091u, 3222440253u, 0, ATAN2_TOLERANCE, 0},
{482, 3201092813u, 3197737370u, 3222124301u, 0, ATAN2_TOLERANCE, 0},
{483, 3201092813u, 3196059648u, 3221768197u, 0, ATAN2_TOLERANCE, 0},
{484, 3201092813u, 3192704205u, 3221369940u, 0, ATAN2_TOLERANCE, 0},
{485, 3201092813u, 3189348762u, 3220634637u, 0, ATAN2_TOLERANCE, 0},
{486, 3201092813u, 3184315597u, 3219680081u, 0, ATAN2_TOLERANCE, 0},
{487, 3201092813u, 3175926989u, 3218668216u, 0, ATAN2_TOLERANCE, 0},
{488, 3201092813u, 1028443341u, 3216581885u, 0, ATAN2_TOLERANCE, 0},
{489, 3201092813u, 1036831949u, 3215570021u, 0, ATAN2_TOLERANCE, 0},
{490, 3201092813u, 1041865114u, 3214615464u, 0, ATAN2_TOLERANCE, 0},
{491, 3201092813u, 1045220557u, 3213735693u, 0, ATAN2_TOLERANCE, 0},
{492, 3201092813u, 1048576000u, 3212939180u, 0, ATAN2_TOLERANCE, 0},
{493, 3201092813u, 1050253722u, 3211617080u, 0, ATAN2_TOLERANCE, 0},
{494, 3201092813u, 1051931443u, 3210353271u, 0, ATAN2_TOLERANCE, 0},
{495, 3201092813u, 1053609165u, 3209236443u, 0, ATAN2_TOLERANCE, 0},
{496, 3201092813u, 1055286886u, 3208250684u, 0, ATAN2_TOLERANCE, 0},
{497, 3201092813u, 1056964608u, 3207379923u, 0, ATAN2_TOLERANCE, 0},
{498, 3201092813u, 1057803469u, 3206609099u, 0, ATAN2_TOLERANCE, 0},
{499, 3201092813u, 1058642330u, 3205924695u, 0, ATAN2_TOLERANCE, 0},
{500, 3201092813u, 1059481190u, 3205314883u, 0, ATAN2_TOLERANCE, 0},
{501, 3201092813u, 1060320051u, 3204769474u, 0, ATAN2_TOLERANCE, 0},
{502, 3201092813u, 1061158912u, 3204111280u, 0, ATAN2_TOLERANCE, 0},
{503, 3201092813u, 1061997773u, 3203228472u, 0, ATAN2_TOLERANCE, 0},
{504, 3201092813u, 1062836634u, 3202429708u, 0, ATAN2_TOLERANCE, 0},
{505, 3201092813u, 1063675494u, 3201704320u, 0, ATAN2_TOLERANCE, 0},
{506, 3201092813u, 1064514355u, 3201043234u, 0, ATAN2_TOLERANCE, 0},
{507, 3199415091u, 3212836864u, 3224601542u, 0, ATAN2_TOLERANCE, 0},
{508, 3199415091u, 3211998003u, 3224533110u, 0, ATAN2_TOLERANCE, 0},
{509, 3199415091u, 3211159142u, 3224458028u, 0, ATAN2_TOLERANCE, 0},
{510, 3199415091u, 3210320282u, 3224375334u, 0, ATAN2_TOLERANCE, 0},
{511, 3199415091u, 3209481421u, 3224283884u, 0, ATAN2_TOLERANCE, 0},
{512, 3199415091u, 3208642560u, 3224182312u, 0, ATAN2_TOLERANCE, 0},
{513, 3199415091u, 3207803699u, 3224068980u, 0, ATAN2_TOLERANCE, 0},
{514, 3199415091u, 3206964838u, 3223941918u, 0, ATAN2_TOLERANCE, 0},
{515, 3199415091u, 3206125978u, 3223798754u, 0, ATAN2_TOLERANCE, 0},
{516, 3199415091u, 3205287117u, 3223636624u, 0, ATAN2_TOLERANCE, 0},
{517, 3199415091u, 3204448256u, 3223452088u, 0, ATAN2_TOLERANCE, 0},
{518, 3199415091u, 3202770534u, 3223241043u, 0, ATAN2_TOLERANCE, 0},
{519, 3199415091u, 3201092813u, 3222998667u, 0, ATAN2_TOLERANCE, 0},
{520, 3199415091u, 3199415091u, 3222719460u, 0, ATAN2_TOLERANCE, 0},
{521, 3199415091u, 3197737370u, 3222397455u, 0, ATAN2_TOLERANCE, 0},
{522, 3199415091u, 3196059648u, 3222026776u, 0, ATAN2_TOLERANCE, 0},
{523, 3199415091u, 3192704205u, 3221602718u, 0, ATAN2_TOLERANCE, 0},
{524, 3199415091u, 3189348762u, 3221021529u, 0, ATAN2_TOLERANCE, 0},
{525, 3199415091u, 3184315597u, 3219959597u, 0, ATAN2_TOLERANCE, 0},
{526, 3199415091u, 3175926989u, 3218815369u, 0, ATAN2_TOLERANCE, 0},
{527, 3199415091u, 1028443341u, 3216434732u, 0, ATAN2_TOLERANCE, 0},
{528, 3199415091u, 1036831949u, 3215290504u, 0, ATAN2_TOLERANCE, 0},
{529, 3199415091u, 1041865114u, 3214228572u, 0, ATAN2_TOLERANCE, 0},
{530, 3199415091u, 1045220557u, 3213270137u, 0, ATAN2_TOLERANCE, 0},
{531, 3199415091u, 1048576000u, 3212007178u, 0, ATAN2_TOLERANCE, 0},
{532, 3199415091u, 1050253722u, 3210524461u, 0, ATAN2_TOLERANCE, 0},
{533, 3199415091u, 1051931443u, 3209236443u, 0, ATAN2_TOLERANCE, 0},
{534, 3199415091u, 1053609165u, 3208119614u, 0, ATAN2_TOLERANCE, 0},
{535, 3199415091u, 1055286886u, 3207150112u, 0, ATAN2_TOLERANCE, 0},
{536, 3199415091u, 1056964608u, 3206305929u, 0, ATAN2_TOLERANCE, 0},
{537, 3199415091u, 1057803469u, 3205567786u, 0, ATAN2_TOLERANCE, 0},
{538, 3199415091u, 1058642330u, 3204919267u, 0, ATAN2_TOLERANCE, 0},
{539, 3199415091u, 1059481190u, 3204244962u, 0, ATAN2_TOLERANCE, 0},
{540, 3199415091u, 1060320051u, 3203228472u, 0, ATAN2_TOLERANCE, 0},
{541, 3199415091u, 1061158912u, 3202321816u, 0, ATAN2_TOLERANCE, 0},
{542, 3199415091u, 1061997773u, 3201509238u, 0, ATAN2_TOLERANCE, 0},
{543, 3199415091u, 1062836634u, 3200777637u, 0, ATAN2_TOLERANCE, 0},
{544, 3199415091u, 1063675494u, 3200116087u, 0, ATAN2_TOLERANCE, 0},
{545, 3199415091u, 1064514355u, 3199515432u, 0, ATAN2_TOLERANCE, 0},
{546, 3197737370u, 3212836864u, 3224791200u, 0, ATAN2_TOLERANCE, 0},
{547, 3197737370u, 3211998003u, 3224730710u, 0, ATAN2_TOLERANCE, 0},
{548, 3197737370u, 3211159142u, 3224664139u, 0, ATAN2_TOLERANCE, 0},
{549, 3197737370u, 3210320282u, 3224590562u, 0, ATAN2_TOLERANCE, 0},
{550, 3197737370u, 3209481421u, 3224508865u, 0, ATAN2_TOLERANCE, 0},
{551, 3197737370u, 3208642560u, 3224417699u, 0, ATAN2_TOLERANCE, 0},
{552, 3197737370u, 3207803699u, 3224315419u, 0, ATAN2_TOLERANCE, 0},
{553, 3197737370u, 3206964838u, 3224200009u, 0, ATAN2_TOLERANCE, 0},
{554, 3197737370u, 3206125978u, 3224068980u, 0, ATAN2_TOLERANCE, 0},
{555, 3197737370u, 3205287117u, 3223919247u, 0, ATAN2_TOLERANCE, 0},
{556, 3197737370u, 3204448256u, 3223746975u, 0, ATAN2_TOLERANCE, 0},
{557, 3197737370u, 3202770534u, 3223547397u, 0, ATAN2_TOLERANCE, 0},
{558, 3197737370u, 3201092813u, 3223314619u, 0, ATAN2_TOLERANCE, 0},
{559, 3197737370u, 3199415091u, 3223041465u, 0, ATAN2_TOLERANCE, 0},
{560, 3197737370u, 3197737370u, 3222719460u, 0, ATAN2_TOLERANCE, 0},
{561, 3197737370u, 3196059648u, 3222339205u, 0, ATAN2_TOLERANCE, 0},
{562, 3197737370u, 3192704205u, 3221891523u, 0, ATAN2_TOLERANCE, 0},
{563, 3197737370u, 3189348762u, 3221369940u, 0, ATAN2_TOLERANCE, 0},
{564, 3197737370u, 3184315597u, 3220324090u, 0, ATAN2_TOLERANCE, 0},
{565, 3197737370u, 3175926989u, 3219010418u, 0, ATAN2_TOLERANCE, 0},
{566, 3197737370u, 1028443341u, 3216239683u, 0, ATAN2_TOLERANCE, 0},
{567, 3197737370u, 1036831949u, 3214926011u, 0, ATAN2_TOLERANCE, 0},
{568, 3197737370u, 1041865114u, 3213735693u, 0, ATAN2_TOLERANCE, 0},
{569, 3197737370u, 1045220557u, 3212548191u, 0, ATAN2_TOLERANCE, 0},
{570, 3197737370u, 1048576000u, 3210757463u, 0, ATAN2_TOLERANCE, 0},
{571, 3197737370u, 1050253722u, 3209236443u, 0, ATAN2_TOLERANCE, 0},
{572, 3197737370u, 1051931443u, 3207948424u, 0, ATAN2_TOLERANCE, 0},
{573, 3197737370u, 1053609165u, 3206855805u, 0, ATAN2_TOLERANCE, 0},
{574, 3197737370u, 1055286886u, 3205924695u, 0, ATAN2_TOLERANCE, 0},
{575, 3197737370u, 1056964608u, 3205126383u, 0, ATAN2_TOLERANCE, 0},
{576, 3197737370u, 1057803469u, 3204426336u, 0, ATAN2_TOLERANCE, 0},
{577, 3197737370u, 1058642330u, 3203228472u, 0, ATAN2_TOLERANCE, 0},
{578, 3197737370u, 1059481190u, 3202180237u, 0, ATAN2_TOLERANCE, 0},
{579, 3197737370u, 1060320051u, 3201256954u, 0, ATAN2_TOLERANCE, 0},
{580, 3197737370u, 1061158912u, 3200438715u, 0, ATAN2_TOLERANCE, 0},
{581, 3197737370u, 1061997773u, 3199709386u, 0, ATAN2_TOLERANCE, 0},
{582, 3197737370u, 1062836634u, 3199055811u, 0, ATAN2_TOLERANCE, 0},
{583, 3197737370u, 1063675494u, 3198467197u, 0, ATAN2_TOLERANCE, 0},
{584, 3197737370u, 1064514355u, 3197934632u, 0, ATAN2_TOLERANCE, 0},
{585, 3196059648u, 3212836864u, 3224986144u, 0, ATAN2_TOLERANCE, 0},
{586, 3196059648u, 3211998003u, 3224934365u, 0, ATAN2_TOLERANCE, 0},
{587, 3196059648u, 3211159142u, 3224877225u, 0, ATAN2_TOLERANCE, 0},
{588, 3196059648u, 3210320282u, 3224813872u, 0, ATAN2_TOLERANCE, 0},
{589, 3196059648u, 3209481421u, 3224743267u, 0, ATAN2_TOLERANCE, 0},
{590, 3196059648u, 3208642560u, 3224664139u, 0, ATAN2_TOLERANCE, 0},
{591, 3196059648u, 3207803699u, 3224574912u, 0, ATAN2_TOLERANCE, 0},
{592, 3196059648u, 3206964838u, 3224473620u, 0, ATAN2_TOLERANCE, 0},
{593, 3196059648u, 3206125978u, 3224357785u, 0, ATAN2_TOLERANCE, 0},
{594, 3196059648u, 3205287117u, 3224224253u, 0, ATAN2_TOLERANCE, 0},
{595, 3196059648u, 3204448256u, 3224068980u, 0, ATAN2_TOLERANCE, 0},
{596, 3196059648u, 3202770534u, 3223886733u, 0, ATAN2_TOLERANCE, 0},
{597, 3196059648u, 3201092813u, 3223670723u, 0, ATAN2_TOLERANCE, 0},
{598, 3196059648u, 3199415091u, 3223412144u, 0, ATAN2_TOLERANCE, 0},
{599, 3196059648u, 3197737370u, 3223099715u, 0, ATAN2_TOLERANCE, 0},
{600, 3196059648u, 3196059648u, 3222719460u, 0, ATAN2_TOLERANCE, 0},
{601, 3196059648u, 3192704205u, 3222255330u, 0, ATAN2_TOLERANCE, 0},
{602, 3196059648u, 3189348762u, 3221691945u, 0, ATAN2_TOLERANCE, 0},
{603, 3196059648u, 3184315597u, 3220816969u, 0, ATAN2_TOLERANCE, 0},
{604, 3196059648u, 3175926989u, 3219280925u, 0, ATAN2_TOLERANCE, 0},
{605, 3196059648u, 1028443341u, 3215969177u, 0, ATAN2_TOLERANCE, 0},
{606, 3196059648u, 1036831949u, 3214433132u, 0, ATAN2_TOLERANCE, 0},
{607, 3196059648u, 1041865114u, 3213091683u, 0, ATAN2_TOLERANCE, 0},
{608, 3196059648u, 1045220557u, 3211092963u, 0, ATAN2_TOLERANCE, 0},
{609, 3196059648u, 1048576000u, 3209236443u, 0, ATAN2_TOLERANCE, 0},
{610, 3196059648u, 1050253722u, 3207715422u, 0, ATAN2_TOLERANCE, 0},
{611, 3196059648u, 1051931443u, 3206465708u, 0, ATAN2_TOLERANCE, 0},
{612, 3196059648u, 1053609165u, 3205431389u, 0, ATAN2_TOLERANCE, 0},
{613, 3196059648u, 1055286886u, 3204567349u, 0, ATAN2_TOLERANCE, 0},
{614, 3196059648u, 1056964608u, 3203228472u, 0, ATAN2_TOLERANCE, 0},
{615, 3196059648u, 1057803469u, 3201986283u, 0, ATAN2_TOLERANCE, 0},
{616, 3196059648u, 1058642330u, 3200918032u, 0, ATAN2_TOLERANCE, 0},
{617, 3196059648u, 1059481190u, 3199991349u, 0, ATAN2_TOLERANCE, 0},
{618, 3196059648u, 1060320051u, 3199181013u, 0, ATAN2_TOLERANCE, 0},
{619, 3196059648u, 1061158912u, 3198467197u, 0, ATAN2_TOLERANCE, 0},
{620, 3196059648u, 1061997773u, 3197834170u, 0, ATAN2_TOLERANCE, 0},
{621, 3196059648u, 1062836634u, 3197269334u, 0, ATAN2_TOLERANCE, 0},
{622, 3196059648u, 1063675494u, 3196762508u, 0, ATAN2_TOLERANCE, 0},
{623, 3196059648u, 1064514355u, 3196305391u, 0, ATAN2_TOLERANCE, 0},
{624, 3192704205u, 3212836864u, 3225185722u, 0, ATAN2_TOLERANCE, 0},
{625, 3192704205u, 3211998003u, 3225143356u, 0, ATAN2_TOLERANCE, 0},
{626, 3192704205u, 3211159142u, 3225096495u, 0, ATAN2_TOLERANCE, 0},
{627, 3192704205u, 3210320282u, 3225044394u, 0, ATAN2_TOLERANCE, 0},
{628, 3192704205u, 3209481421u, 3224986144u, 0, ATAN2_TOLERANCE, 0},
{629, 3192704205u, 3208642560u, 3224920613u, 0, ATAN2_TOLERANCE, 0},
{630, 3192704205u, 3207803699u, 3224846385u, 0, ATAN2_TOLERANCE, 0},
{631, 3192704205u, 3206964838u, 3224761663u, 0, ATAN2_TOLERANCE, 0},
{632, 3192704205u, 3206125978u, 3224664139u, 0, ATAN2_TOLERANCE, 0},
{633, 3192704205u, 3205287117u, 3224550807u, 0, ATAN2_TOLERANCE, 0},
{634, 3192704205u, 3204448256u, 3224417699u, 0, ATAN2_TOLERANCE, 0},
{635, 3192704205u, 3202770534u, 3224259499u, 0, ATAN2_TOLERANCE, 0},
{636, 3192704205u, 3201092813u, 3224068980u, 0, ATAN2_TOLERANCE, 0},
{637, 3192704205u, 3199415091u, 3223836202u, 0, ATAN2_TOLERANCE, 0},
{638, 3192704205u, 3197737370u, 3223547397u, 0, ATAN2_TOLERANCE, 0},
{639, 3192704205u, 3196059648u, 3223183590u, 0, ATAN2_TOLERANCE, 0},
{640, 3192704205u, 3192704205u, 3222719460u, 0, ATAN2_TOLERANCE, 0},
{641, 3192704205u, 3189348762u, 3222124301u, 0, ATAN2_TOLERANCE, 0},
{642, 3192704205u, 3184315597u, 3221369940u, 0, ATAN2_TOLERANCE, 0},
{643, 3192704205u, 3175926989u, 3219680081u, 0, ATAN2_TOLERANCE, 0},
{644, 3192704205u, 1028443341u, 3215570021u, 0, ATAN2_TOLERANCE, 0},
{645, 3192704205u, 1036831949u, 3213735693u, 0, ATAN2_TOLERANCE, 0},
{646, 3192704205u, 1041865114u, 3211617080u, 0, ATAN2_TOLERANCE, 0},
{647, 3192704205u, 1045220557u, 3209236443u, 0, ATAN2_TOLERANCE, 0},
{648, 3192704205u, 1048576000u, 3207379923u, 0, ATAN2_TOLERANCE, 0},
{649, 3192704205u, 1050253722u, 3205924695u, 0, ATAN2_TOLERANCE, 0},
{650, 3192704205u, 1051931443u, 3204769474u, 0, ATAN2_TOLERANCE, 0},
{651, 3192704205u, 1053609165u, 3203228472u, 0, ATAN2_TOLERANCE, 0},
{652, 3192704205u, 1055286886u, 3201704320u, 0, ATAN2_TOLERANCE, 0},
{653, 3192704205u, 1056964608u, 3200438715u, 0, ATAN2_TOLERANCE, 0},
{654, 3192704205u, 1057803469u, 3199373853u, 0, ATAN2_TOLERANCE, 0},
{655, 3192704205u, 1058642330u, 3198467197u, 0, ATAN2_TOLERANCE, 0},
{656, 3192704205u, 1059481190u, 3197687002u, 0, ATAN2_TOLERANCE, 0},
{657, 3192704205u, 1060320051u, 3197009227u, 0, ATAN2_TOLERANCE, 0},
{658, 3192704205u, 1061158912u, 3196415405u, 0, ATAN2_TOLERANCE, 0},
{659, 3192704205u, 1061997773u, 3195722672u, 0, ATAN2_TOLERANCE, 0},
{660, 3192704205u, 1062836634u, 3194790664u, 0, ATAN2_TOLERANCE, 0},
{661, 3192704205u, 1063675494u, 3193957057u, 0, ATAN2_TOLERANCE, 0},
{662, 3192704205u, 1064514355u, 3193207268u, 0, ATAN2_TOLERANCE, 0},
{663, 3189348762u, 3212836864u, 3225389169u, 0, ATAN2_TOLERANCE, 0},
{664, 3189348762u, 3211998003u, 3225356823u, 0, ATAN2_TOLERANCE, 0},
{665, 3189348762u, 3211159142u, 3225320975u, 0, ATAN2_TOLERANCE, 0},
{666, 3189348762u, 3210320282u, 3225281030u, 0, ATAN2_TOLERANCE, 0},
{667, 3189348762u, 3209481421u, 3225236253u, 0, ATAN2_TOLERANCE, 0},
{668, 3189348762u, 3208642560u, 3225185722u, 0, ATAN2_TOLERANCE, 0},
{669, 3189348762u, 3207803699u, 3225128269u, 0, ATAN2_TOLERANCE, 0},
{670, 3189348762u, 3206964838u, 3225062395u, 0, ATAN2_TOLERANCE, 0},
{671, 3189348762u, 3206125978u, 3224986144u, 0, ATAN2_TOLERANCE, 0},
{672, 3189348762u, 3205287117u, 3224896917u, 0, ATAN2_TOLERANCE, 0},
{673, 3189348762u, 3204448256u, 3224791200u, 0, ATAN2_TOLERANCE, 0},
{674, 3189348762u, 3202770534u, 3224664139u, 0, ATAN2_TOLERANCE, 0},
{675, 3189348762u, 3201092813u, 3224508865u, 0, ATAN2_TOLERANCE, 0},
{676, 3189348762u, 3199415091u, 3224315419u, 0, ATAN2_TOLERANCE, 0},
{677, 3189348762u, 3197737370u, 3224068980u, 0, ATAN2_TOLERANCE, 0},
{678, 3189348762u, 3196059648u, 3223746975u, 0, ATAN2_TOLERANCE, 0},
{679, 3189348762u, 3192704205u, 3223314619u, 0, ATAN2_TOLERANCE, 0},
{680, 3189348762u, 3189348762u, 3222719460u, 0, ATAN2_TOLERANCE, 0},
{681, 3189348762u, 3184315597u, 3221891523u, 0, ATAN2_TOLERANCE, 0},
{682, 3189348762u, 3175926989u, 3220324090u, 0, ATAN2_TOLERANCE, 0},
{683, 3189348762u, 1028443341u, 3214926011u, 0, ATAN2_TOLERANCE, 0},
{684, 3189348762u, 1036831949u, 3212548191u, 0, ATAN2_TOLERANCE, 0},
{685, 3189348762u, 1041865114u, 3209236443u, 0, ATAN2_TOLERANCE, 0},
{686, 3189348762u, 1045220557u, 3206855805u, 0, ATAN2_TOLERANCE, 0},
{687, 3189348762u, 1048576000u, 3205126383u, 0, ATAN2_TOLERANCE, 0},
{688, 3189348762u, 1050253722u, 3203228472u, 0, ATAN2_TOLERANCE, 0},
{689, 3189348762u, 1051931443u, 3201256954u, 0, ATAN2_TOLERANCE, 0},
{690, 3189348762u, 1053609165u, 3199709386u, 0, ATAN2_TOLERANCE, 0},
{691, 3189348762u, 1055286886u, 3198467197u, 0, ATAN2_TOLERANCE, 0},
{692, 3189348762u, 1056964608u, 3197450707u, 0, ATAN2_TOLERANCE, 0},
{693, 3189348762u, 1057803469u, 3196604976u, 0, ATAN2_TOLERANCE, 0},
{694, 3189348762u, 1058642330u, 3195722672u, 0, ATAN2_TOLERANCE, 0},
{695, 3189348762u, 1059481190u, 3194502645u, 0, ATAN2_TOLERANCE, 0},
{696, 3189348762u, 1060320051u, 3193448666u, 0, ATAN2_TOLERANCE, 0},
{697, 3189348762u, 1061158912u, 3192529424u, 0, ATAN2_TOLERANCE, 0},
{698, 3189348762u, 1061997773u, 3191720922u, 0, ATAN2_TOLERANCE, 0},
{699, 3189348762u, 1062836634u, 3191004485u, 0, ATAN2_TOLERANCE, 0},
{700, 3189348762u, 1063675494u, 3190365372u, 0, ATAN2_TOLERANCE, 0},
{701, 3189348762u, 1064514355u, 3189791806u, 0, ATAN2_TOLERANCE, 0},
{702, 3184315597u, 3212836864u, 3225595618u, 0, ATAN2_TOLERANCE, 0},
{703, 3184315597u, 3211998003u, 3225573773u, 0, ATAN2_TOLERANCE, 0},
{704, 3184315597u, 3211159142u, 3225549529u, 0, ATAN2_TOLERANCE, 0},
{705, 3184315597u, 3210320282u, 3225522469u, 0, ATAN2_TOLERANCE, 0},
{706, 3184315597u, 3209481421u, 3225492076u, 0, ATAN2_TOLERANCE, 0},
{707, 3184315597u, 3208642560u, 3225457697u, 0, ATAN2_TOLERANCE, 0},
{708, 3184315597u, 3207803699u, 3225418499u, 0, ATAN2_TOLERANCE, 0},
{709, 3184315597u, 3206964838u, 3225373401u, 0, ATAN2_TOLERANCE, 0},
{710, 3184315597u, 3206125978u, 3225320975u, 0, ATAN2_TOLERANCE, 0},
{711, 3184315597u, 3205287117u, 3225259298u, 0, ATAN2_TOLERANCE, 0},
{712, 3184315597u, 3204448256u, 3225185722u, 0, ATAN2_TOLERANCE, 0},
{713, 3184315597u, 3202770534u, 3225096495u, 0, ATAN2_TOLERANCE, 0},
{714, 3184315597u, 3201092813u, 3224986144u, 0, ATAN2_TOLERANCE, 0},
{715, 3184315597u, 3199415091u, 3224846385u, 0, ATAN2_TOLERANCE, 0},
{716, 3184315597u, 3197737370u, 3224664139u, 0, ATAN2_TOLERANCE, 0},
{717, 3184315597u, 3196059648u, 3224417699u, 0, ATAN2_TOLERANCE, 0},
{718, 3184315597u, 3192704205u, 3224068980u, 0, ATAN2_TOLERANCE, 0},
{719, 3184315597u, 3189348762u, 3223547397u, 0, ATAN2_TOLERANCE, 0},
{720, 3184315597u, 3184315597u, 3222719460u, 0, ATAN2_TOLERANCE, 0},
{721, 3184315597u, 3175926989u, 3221369940u, 0, ATAN2_TOLERANCE, 0},
{722, 3184315597u, 1028443341u, 3213735693u, 0, ATAN2_TOLERANCE, 0},
{723, 3184315597u, 1036831949u, 3209236443u, 0, ATAN2_TOLERANCE, 0},
{724, 3184315597u, 1041865114u, 3205924695u, 0, ATAN2_TOLERANCE, 0},
{725, 3184315597u, 1045220557u, 3203228472u, 0, ATAN2_TOLERANCE, 0},
{726, 3184315597u, 1048576000u, 3200438715u, 0, ATAN2_TOLERANCE, 0},
{727, 3184315597u, 1050253722u, 3198467197u, 0, ATAN2_TOLERANCE, 0},
{728, 3184315597u, 1051931443u, 3197009227u, 0, ATAN2_TOLERANCE, 0},
{729, 3184315597u, 1053609165u, 3195722672u, 0, ATAN2_TOLERANCE, 0},
{730, 3184315597u, 1055286886u, 3193957057u, 0, ATAN2_TOLERANCE, 0},
{731, 3184315597u, 1056964608u, 3192529424u, 0, ATAN2_TOLERANCE, 0},
{732, 3184315597u, 1057803469u, 3191352196u, 0, ATAN2_TOLERANCE, 0},
{733, 3184315597u, 1058642330u, 3190365372u, 0, ATAN2_TOLERANCE, 0},
{734, 3184315597u, 1059481190u, 3189526555u, 0, ATAN2_TOLERANCE, 0},
{735, 3184315597u, 1060320051u, 3188804982u, 0, ATAN2_TOLERANCE, 0},
{736, 3184315597u, 1061158912u, 3188177815u, 0, ATAN2_TOLERANCE, 0},
{737, 3184315597u, 1061997773u, 3187584469u, 0, ATAN2_TOLERANCE, 0},
{738, 3184315597u, 1062836634u, 3186611894u, 0, ATAN2_TOLERANCE, 0},
{739, 3184315597u, 1063675494u, 3185745985u, 0, ATAN2_TOLERANCE, 0},
{740, 3184315597u, 1064514355u, 3184970168u, 0, ATAN2_TOLERANCE, 0},
{741, 3175926989u, 3212836864u, 3225804118u, 0, ATAN2_TOLERANCE, 0},
{742, 3175926989u, 3211998003u, 3225793109u, 0, ATAN2_TOLERANCE, 0},
{743, 3175926989u, 3211159142u, 3225780881u, 0, ATAN2_TOLERANCE, 0},
{744, 3175926989u, 3210320282u, 3225767219u, 0, ATAN2_TOLERANCE, 0},
{745, 3175926989u, 3209481421u, 3225751855u, 0, ATAN2_TOLERANCE, 0},
{746, 3175926989u, 3208642560u, 3225734452u, 0, ATAN2_TOLERANCE, 0},
{747, 3175926989u, 3207803699u, 3225714573u, 0, ATAN2_TOLERANCE, 0},
{748, 3175926989u, 3206964838u, 3225691654u, 0, ATAN2_TOLERANCE, 0},
{749, 3175926989u, 3206125978u, 3225664939u, 0, ATAN2_TOLERANCE, 0},
{750, 3175926989u, 3205287117u, 3225633404u, 0, ATAN2_TOLERANCE, 0},
{751, 3175926989u, 3204448256u, 3225595618u, 0, ATAN2_TOLERANCE, 0},
{752, 3175926989u, 3202770534u, 3225549529u, 0, ATAN2_TOLERANCE, 0},
{753, 3175926989u, 3201092813u, 3225492076u, 0, ATAN2_TOLERANCE, 0},
{754, 3175926989u, 3199415091u, 3225418499u, 0, ATAN2_TOLERANCE, 0},
{755, 3175926989u, 3197737370u, 3225320975u, 0, ATAN2_TOLERANCE, 0},
{756, 3175926989u, 3196059648u, 3225185722u, 0, ATAN2_TOLERANCE, 0},
{757, 3175926989u, 3192704205u, 3224986144u, 0, ATAN2_TOLERANCE, 0},
{758, 3175926989u, 3189348762u, 3224664139u, 0, ATAN2_TOLERANCE, 0},
{759, 3175926989u, 3184315597u, 3224068980u, 0, ATAN2_TOLERANCE, 0},
{760, 3175926989u, 3175926989u, 3222719460u, 0, ATAN2_TOLERANCE, 0},
{761, 3175926989u, 1028443341u, 3209236443u, 0, ATAN2_TOLERANCE, 0},
{762, 3175926989u, 1036831949u, 3203228472u, 0, ATAN2_TOLERANCE, 0},
{763, 3175926989u, 1041865114u, 3198467197u, 0, ATAN2_TOLERANCE, 0},
{764, 3175926989u, 1045220557u, 3195722672u, 0, ATAN2_TOLERANCE, 0},
{765, 3175926989u, 1048576000u, 3192529424u, 0, ATAN2_TOLERANCE, 0},
{766, 3175926989u, 1050253722u, 3190365372u, 0, ATAN2_TOLERANCE, 0},
{767, 3175926989u, 1051931443u, 3188804982u, 0, ATAN2_TOLERANCE, 0},
{768, 3175926989u, 1053609165u, 3187584469u, 0, ATAN2_TOLERANCE, 0},
{769, 3175926989u, 1055286886u, 3185745985u, 0, ATAN2_TOLERANCE, 0},
{770, 3175926989u, 1056964608u, 3184271124u, 0, ATAN2_TOLERANCE, 0},
{771, 3175926989u, 1057803469u, 3183061988u, 0, ATAN2_TOLERANCE, 0},
{772, 3175926989u, 1058642330u, 3182052851u, 0, ATAN2_TOLERANCE, 0},
{773, 3175926989u, 1059481190u, 3181197973u, 0, ATAN2_TOLERANCE, 0},
{774, 3175926989u, 1060320051u, 3180464550u, 0, ATAN2_TOLERANCE, 0},
{775, 3175926989u, 1061158912u, 3179828452u, 0, ATAN2_TOLERANCE, 0},
{776, 3175926989u, 1061997773u, 3179260638u, 0, ATAN2_TOLERANCE, 0},
{777, 3175926989u, 1062836634u, 3178277362u, 0, ATAN2_TOLERANCE, 0},
{778, 3175926989u, 1063675494u, 3177402983u, 0, ATAN2_TOLERANCE, 0},
{779, 3175926989u, 1064514355u, 3176620374u, 0, ATAN2_TOLERANCE, 0},
{780, 1028443341u, 3212836864u, 1078320470u, 0, ATAN2_TOLERANCE, 0},
{781, 1028443341u, 3211998003u, 1078309461u, 0, ATAN2_TOLERANCE, 0},
{782, 1028443341u, 3211159142u, 1078297233u, 0, ATAN2_TOLERANCE, 0},
{783, 1028443341u, 3210320282u, 1078283571u, 0, ATAN2_TOLERANCE, 0},
{784, 1028443341u, 3209481421u, 1078268207u, 0, ATAN2_TOLERANCE, 0},
{785, 1028443341u, 3208642560u, 1078250804u, 0, ATAN2_TOLERANCE, 0},
{786, 1028443341u, 3207803699u, 1078230925u, 0, ATAN2_TOLERANCE, 0},
{787, 1028443341u, 3206964838u, 1078208006u, 0, ATAN2_TOLERANCE, 0},
{788, 1028443341u, 3206125978u, 1078181291u, 0, ATAN2_TOLERANCE, 0},
{789, 1028443341u, 3205287117u, 1078149756u, 0, ATAN2_TOLERANCE, 0},
{790, 1028443341u, 3204448256u, 1078111970u, 0, ATAN2_TOLERANCE, 0},
{791, 1028443341u, 3202770534u, 1078065881u, 0, ATAN2_TOLERANCE, 0},
{792, 1028443341u, 3201092813u, 1078008428u, 0, ATAN2_TOLERANCE, 0},
{793, 1028443341u, 3199415091u, 1077934851u, 0, ATAN2_TOLERANCE, 0},
{794, 1028443341u, 3197737370u, 1077837327u, 0, ATAN2_TOLERANCE, 0},
{795, 1028443341u, 3196059648u, 1077702074u, 0, ATAN2_TOLERANCE, 0},
{796, 1028443341u, 3192704205u, 1077502496u, 0, ATAN2_TOLERANCE, 0},
{797, 1028443341u, 3189348762u, 1077180491u, 0, ATAN2_TOLERANCE, 0},
{798, 1028443341u, 3184315597u, 1076585332u, 0, ATAN2_TOLERANCE, 0},
{799, 1028443341u, 3175926989u, 1075235812u, 0, ATAN2_TOLERANCE, 0},
{800, 1028443341u, 1028443341u, 1061752795u, 0, ATAN2_TOLERANCE, 0},
{801, 1028443341u, 1036831949u, 1055744824u, 0, ATAN2_TOLERANCE, 0},
{802, 1028443341u, 1041865114u, 1050983549u, 0, ATAN2_TOLERANCE, 0},
{803, 1028443341u, 1045220557u, 1048239024u, 0, ATAN2_TOLERANCE, 0},
{804, 1028443341u, 1048576000u, 1045045776u, 0, ATAN2_TOLERANCE, 0},
{805, 1028443341u, 1050253722u, 1042881724u, 0, ATAN2_TOLERANCE, 0},
{806, 1028443341u, 1051931443u, 1041321334u, 0, ATAN2_TOLERANCE, 0},
{807, 1028443341u, 1053609165u, 1040100821u, 0, ATAN2_TOLERANCE, 0},
{808, 1028443341u, 1055286886u, 1038262337u, 0, ATAN2_TOLERANCE, 0},
{809, 1028443341u, 1056964608u, 1036787476u, 0, ATAN2_TOLERANCE, 0},
{810, 1028443341u, 1057803469u, 1035578340u, 0, ATAN2_TOLERANCE, 0},
{811, 1028443341u, 1058642330u, 1034569203u, 0, ATAN2_TOLERANCE, 0},
{812, 1028443341u, 1059481190u, 1033714325u, 0, ATAN2_TOLERANCE, 0},
{813, 1028443341u, 1060320051u, 1032980902u, 0, ATAN2_TOLERANCE, 0},
{814, 1028443341u, 1061158912u, 1032344804u, 0, ATAN2_TOLERANCE, 0},
{815, 1028443341u, 1061997773u, 1031776990u, 0, ATAN2_TOLERANCE, 0},
{816, 1028443341u, 1062836634u, 1030793714u, 0, ATAN2_TOLERANCE, 0},
{817, 1028443341u, 1063675494u, 1029919335u, 0, ATAN2_TOLERANCE, 0},
{818, 1028443341u, 1064514355u, 1029136726u, 0, ATAN2_TOLERANCE, 0},
{819, 1036831949u, 3212836864u, 1078111970u, 0, ATAN2_TOLERANCE, 0},
{820, 1036831949u, 3211998003u, 1078090125u, 0, ATAN2_TOLERANCE, 0},
{821, 1036831949u, 3211159142u, 1078065881u, 0, ATAN2_TOLERANCE, 0},
{822, 1036831949u, 3210320282u, 1078038821u, 0, ATAN2_TOLERANCE, 0},
{823, 1036831949u, 3209481421u, 1078008428u, 0, ATAN2_TOLERANCE, 0},
{824, 1036831949u, 3208642560u, 1077974049u, 0, ATAN2_TOLERANCE, 0},
{825, 1036831949u, 3207803699u, 1077934851u, 0, ATAN2_TOLERANCE, 0},
{826, 1036831949u, 3206964838u, 1077889753u, 0, ATAN2_TOLERANCE, 0},
{827, 1036831949u, 3206125978u, 1077837327u, 0, ATAN2_TOLERANCE, 0},
{828, 1036831949u, 3205287117u, 1077775650u, 0, ATAN2_TOLERANCE, 0},
{829, 1036831949u, 3204448256u, 1077702074u, 0, ATAN2_TOLERANCE, 0},
{830, 1036831949u, 3202770534u, 1077612847u, 0, ATAN2_TOLERANCE, 0},
{831, 1036831949u, 3201092813u, 1077502496u, 0, ATAN2_TOLERANCE, 0},
{832, 1036831949u, 3199415091u, 1077362737u, 0, ATAN2_TOLERANCE, 0},
{833, 1036831949u, 3197737370u, 1077180491u, 0, ATAN2_TOLERANCE, 0},
{834, 1036831949u, 3196059648u, 1076934051u, 0, ATAN2_TOLERANCE, 0},
{835, 1036831949u, 3192704205u, 1076585332u, 0, ATAN2_TOLERANCE, 0},
{836, 1036831949u, 3189348762u, 1076063749u, 0, ATAN2_TOLERANCE, 0},
{837, 1036831949u, 3184315597u, 1075235812u, 0, ATAN2_TOLERANCE, 0},
{838, 1036831949u, 3175926989u, 1073886292u, 0, ATAN2_TOLERANCE, 0},
{839, 1036831949u, 1028443341u, 1066252045u, 0, ATAN2_TOLERANCE, 0},
{840, 1036831949u, 1036831949u, 1061752795u, 0, ATAN2_TOLERANCE, 0},
{841, 1036831949u, 1041865114u, 1058441047u, 0, ATAN2_TOLERANCE, 0},
{842, 1036831949u, 1045220557u, 1055744824u, 0, ATAN2_TOLERANCE, 0},
{843, 1036831949u, 1048576000u, 1052955067u, 0, ATAN2_TOLERANCE, 0},
{844, 1036831949u, 1050253722u, 1050983549u, 0, ATAN2_TOLERANCE, 0},
{845, 1036831949u, 1051931443u, 1049525579u, 0, ATAN2_TOLERANCE, 0},
{846, 1036831949u, 1053609165u, 1048239024u, 0, ATAN2_TOLERANCE, 0},
{847, 1036831949u, 1055286886u, 1046473409u, 0, ATAN2_TOLERANCE, 0},
{848, 1036831949u, 1056964608u, 1045045776u, 0, ATAN2_TOLERANCE, 0},
{849, 1036831949u, 1057803469u, 1043868548u, 0, ATAN2_TOLERANCE, 0},
{850, 1036831949u, 1058642330u, 1042881724u, 0, ATAN2_TOLERANCE, 0},
{851, 1036831949u, 1059481190u, 1042042907u, 0, ATAN2_TOLERANCE, 0},
{852, 1036831949u, 1060320051u, 1041321334u, 0, ATAN2_TOLERANCE, 0},
{853, 1036831949u, 1061158912u, 1040694167u, 0, ATAN2_TOLERANCE, 0},
{854, 1036831949u, 1061997773u, 1040100821u, 0, ATAN2_TOLERANCE, 0},
{855, 1036831949u, 1062836634u, 1039128246u, 0, ATAN2_TOLERANCE, 0},
{856, 1036831949u, 1063675494u, 1038262337u, 0, ATAN2_TOLERANCE, 0},
{857, 1036831949u, 1064514355u, 1037486520u, 0, ATAN2_TOLERANCE, 0},
{858, 1041865114u, 3212836864u, 1077905521u, 0, ATAN2_TOLERANCE, 0},
{859, 1041865114u, 3211998003u, 1077873175u, 0, ATAN2_TOLERANCE, 0},
{860, 1041865114u, 3211159142u, 1077837327u, 0, ATAN2_TOLERANCE, 0},
{861, 1041865114u, 3210320282u, 1077797382u, 0, ATAN2_TOLERANCE, 0},
{862, 1041865114u, 3209481421u, 1077752605u, 0, ATAN2_TOLERANCE, 0},
{863, 1041865114u, 3208642560u, 1077702074u, 0, ATAN2_TOLERANCE, 0},
{864, 1041865114u, 3207803699u, 1077644621u, 0, ATAN2_TOLERANCE, 0},
{865, 1041865114u, 3206964838u, 1077578747u, 0, ATAN2_TOLERANCE, 0},
{866, 1041865114u, 3206125978u, 1077502496u, 0, ATAN2_TOLERANCE, 0},
{867, 1041865114u, 3205287117u, 1077413269u, 0, ATAN2_TOLERANCE, 0},
{868, 1041865114u, 3204448256u, 1077307552u, 0, ATAN2_TOLERANCE, 0},
{869, 1041865114u, 3202770534u, 1077180491u, 0, ATAN2_TOLERANCE, 0},
{870, 1041865114u, 3201092813u, 1077025217u, 0, ATAN2_TOLERANCE, 0},
{871, 1041865114u, 3199415091u, 1076831771u, 0, ATAN2_TOLERANCE, 0},
{872, 1041865114u, 3197737370u, 1076585332u, 0, ATAN2_TOLERANCE, 0},
{873, 1041865114u, 3196059648u, 1076263327u, 0, ATAN2_TOLERANCE, 0},
{874, 1041865114u, 3192704205u, 1075830971u, 0, ATAN2_TOLERANCE, 0},
{875, 1041865114u, 3189348762u, 1075235812u, 0, ATAN2_TOLERANCE, 0},
{876, 1041865114u, 3184315597u, 1074407875u, 0, ATAN2_TOLERANCE, 0},
{877, 1041865114u, 3175926989u, 1072840442u, 0, ATAN2_TOLERANCE, 0},
{878, 1041865114u, 1028443341u, 1067442363u, 0, ATAN2_TOLERANCE, 0},
{879, 1041865114u, 1036831949u, 1065064543u, 0, ATAN2_TOLERANCE, 0},
{880, 1041865114u, 1041865114u, 1061752795u, 0, ATAN2_TOLERANCE, 0},
{881, 1041865114u, 1045220557u, 1059372157u, 0, ATAN2_TOLERANCE, 0},
{882, 1041865114u, 1048576000u, 1057642735u, 0, ATAN2_TOLERANCE, 0},
{883, 1041865114u, 1050253722u, 1055744824u, 0, ATAN2_TOLERANCE, 0},
{884, 1041865114u, 1051931443u, 1053773306u, 0, ATAN2_TOLERANCE, 0},
{885, 1041865114u, 1053609165u, 1052225738u, 0, ATAN2_TOLERANCE, 0},
{886, 1041865114u, 1055286886u, 1050983549u, 0, ATAN2_TOLERANCE, 0},
{887, 1041865114u, 1056964608u, 1049967059u, 0, ATAN2_TOLERANCE, 0},
{888, 1041865114u, 1057803469u, 1049121328u, 0, ATAN2_TOLERANCE, 0},
{889, 1041865114u, 1058642330u, 1048239024u, 0, ATAN2_TOLERANCE, 0},
{890, 1041865114u, 1059481190u, 1047018997u, 0, ATAN2_TOLERANCE, 0},
{891, 1041865114u, 1060320051u, 1045965018u, 0, ATAN2_TOLERANCE, 0},
{892, 1041865114u, 1061158912u, 1045045776u, 0, ATAN2_TOLERANCE, 0},
{893, 1041865114u, 1061997773u, 1044237274u, 0, ATAN2_TOLERANCE, 0},
{894, 1041865114u, 1062836634u, 1043520837u, 0, ATAN2_TOLERANCE, 0},
{895, 1041865114u, 1063675494u, 1042881724u, 0, ATAN2_TOLERANCE, 0},
{896, 1041865114u, 1064514355u, 1042308158u, 0, ATAN2_TOLERANCE, 0},
{897, 1045220557u, 3212836864u, 1077702074u, 0, ATAN2_TOLERANCE, 0},
{898, 1045220557u, 3211998003u, 1077659708u, 0, ATAN2_TOLERANCE, 0},
{899, 1045220557u, 3211159142u, 1077612847u, 0, ATAN2_TOLERANCE, 0},
{900, 1045220557u, 3210320282u, 1077560746u, 0, ATAN2_TOLERANCE, 0},
{901, 1045220557u, 3209481421u, 1077502496u, 0, ATAN2_TOLERANCE, 0},
{902, 1045220557u, 3208642560u, 1077436965u, 0, ATAN2_TOLERANCE, 0},
{903, 1045220557u, 3207803699u, 1077362737u, 0, ATAN2_TOLERANCE, 0},
{904, 1045220557u, 3206964838u, 1077278015u, 0, ATAN2_TOLERANCE, 0},
{905, 1045220557u, 3206125978u, 1077180491u, 0, ATAN2_TOLERANCE, 0},
{906, 1045220557u, 3205287117u, 1077067159u, 0, ATAN2_TOLERANCE, 0},
{907, 1045220557u, 3204448256u, 1076934051u, 0, ATAN2_TOLERANCE, 0},
{908, 1045220557u, 3202770534u, 1076775851u, 0, ATAN2_TOLERANCE, 0},
{909, 1045220557u, 3201092813u, 1076585332u, 0, ATAN2_TOLERANCE, 0},
{910, 1045220557u, 3199415091u, 1076352554u, 0, ATAN2_TOLERANCE, 0},
{911, 1045220557u, 3197737370u, 1076063749u, 0, ATAN2_TOLERANCE, 0},
{912, 1045220557u, 3196059648u, 1075699942u, 0, ATAN2_TOLERANCE, 0},
{913, 1045220557u, 3192704205u, 1075235812u, 0, ATAN2_TOLERANCE, 0},
{914, 1045220557u, 3189348762u, 1074640653u, 0, ATAN2_TOLERANCE, 0},
{915, 1045220557u, 3184315597u, 1073886292u, 0, ATAN2_TOLERANCE, 0},
{916, 1045220557u, 3175926989u, 1072196433u, 0, ATAN2_TOLERANCE, 0},
{917, 1045220557u, 1028443341u, 1068086373u, 0, ATAN2_TOLERANCE, 0},
{918, 1045220557u, 1036831949u, 1066252045u, 0, ATAN2_TOLERANCE, 0},
{919, 1045220557u, 1041865114u, 1064133432u, 0, ATAN2_TOLERANCE, 0},
{920, 1045220557u, 1045220557u, 1061752795u, 0, ATAN2_TOLERANCE, 0},
{921, 1045220557u, 1048576000u, 1059896275u, 0, ATAN2_TOLERANCE, 0},
{922, 1045220557u, 1050253722u, 1058441047u, 0, ATAN2_TOLERANCE, 0},
{923, 1045220557u, 1051931443u, 1057285826u, 0, ATAN2_TOLERANCE, 0},
{924, 1045220557u, 1053609165u, 1055744824u, 0, ATAN2_TOLERANCE, 0},
{925, 1045220557u, 1055286886u, 1054220672u, 0, ATAN2_TOLERANCE, 0},
{926, 1045220557u, 1056964608u, 1052955067u, 0, ATAN2_TOLERANCE, 0},
{927, 1045220557u, 1057803469u, 1051890205u, 0, ATAN2_TOLERANCE, 0},
{928, 1045220557u, 1058642330u, 1050983549u, 0, ATAN2_TOLERANCE, 0},
{929, 1045220557u, 1059481190u, 1050203354u, 0, ATAN2_TOLERANCE, 0},
{930, 1045220557u, 1060320051u, 1049525579u, 0, ATAN2_TOLERANCE, 0},
{931, 1045220557u, 1061158912u, 1048931757u, 0, ATAN2_TOLERANCE, 0},
{932, 1045220557u, 1061997773u, 1048239024u, 0, ATAN2_TOLERANCE, 0},
{933, 1045220557u, 1062836634u, 1047307016u, 0, ATAN2_TOLERANCE, 0},
{934, 1045220557u, 1063675494u, 1046473409u, 0, ATAN2_TOLERANCE, 0},
{935, 1045220557u, 1064514355u, 1045723620u, 0, ATAN2_TOLERANCE, 0},
{936, 1048576000u, 3212836864u, 1077502496u, 0, ATAN2_TOLERANCE, 0},
{937, 1048576000u, 3211998003u, 1077450717u, 0, ATAN2_TOLERANCE, 0},
{938, 1048576000u, 3211159142u, 1077393577u, 0, ATAN2_TOLERANCE, 0},
{939, 1048576000u, 3210320282u, 1077330224u, 0, ATAN2_TOLERANCE, 0},
{940, 1048576000u, 3209481421u, 1077259619u, 0, ATAN2_TOLERANCE, 0},
{941, 1048576000u, 3208642560u, 1077180491u, 0, ATAN2_TOLERANCE, 0},
{942, 1048576000u, 3207803699u, 1077091264u, 0, ATAN2_TOLERANCE, 0},
{943, 1048576000u, 3206964838u, 1076989972u, 0, ATAN2_TOLERANCE, 0},
{944, 1048576000u, 3206125978u, 1076874137u, 0, ATAN2_TOLERANCE, 0},
{945, 1048576000u, 3205287117u, 1076740605u, 0, ATAN2_TOLERANCE, 0},
{946, 1048576000u, 3204448256u, 1076585332u, 0, ATAN2_TOLERANCE, 0},
{947, 1048576000u, 3202770534u, 1076403085u, 0, ATAN2_TOLERANCE, 0},
{948, 1048576000u, 3201092813u, 1076187075u, 0, ATAN2_TOLERANCE, 0},
{949, 1048576000u, 3199415091u, 1075928496u, 0, ATAN2_TOLERANCE, 0},
{950, 1048576000u, 3197737370u, 1075616067u, 0, ATAN2_TOLERANCE, 0},
{951, 1048576000u, 3196059648u, 1075235812u, 0, ATAN2_TOLERANCE, 0},
{952, 1048576000u, 3192704205u, 1074771682u, 0, ATAN2_TOLERANCE, 0},
{953, 1048576000u, 3189348762u, 1074208297u, 0, ATAN2_TOLERANCE, 0},
{954, 1048576000u, 3184315597u, 1073333321u, 0, ATAN2_TOLERANCE, 0},
{955, 1048576000u, 3175926989u, 1071797277u, 0, ATAN2_TOLERANCE, 0},
{956, 1048576000u, 1028443341u, 1068485529u, 0, ATAN2_TOLERANCE, 0},
{957, 1048576000u, 1036831949u, 1066949484u, 0, ATAN2_TOLERANCE, 0},
{958, 1048576000u, 1041865114u, 1065608035u, 0, ATAN2_TOLERANCE, 0},
{959, 1048576000u, 1045220557u, 1063609315u, 0, ATAN2_TOLERANCE, 0},
{960, 1048576000u, 1048576000u, 1061752795u, 0, ATAN2_TOLERANCE, 0},
{961, 1048576000u, 1050253722u, 1060231774u, 0, ATAN2_TOLERANCE, 0},
{962, 1048576000u, 1051931443u, 1058982060u, 0, ATAN2_TOLERANCE, 0},
{963, 1048576000u, 1053609165u, 1057947741u, 0, ATAN2_TOLERANCE, 0},
{964, 1048576000u, 1055286886u, 1057083701u, 0, ATAN2_TOLERANCE, 0},
{965, 1048576000u, 1056964608u, 1055744824u, 0, ATAN2_TOLERANCE, 0},
{966, 1048576000u, 1057803469u, 1054502635u, 0, ATAN2_TOLERANCE, 0},
{967, 1048576000u, 1058642330u, 1053434384u, 0, ATAN2_TOLERANCE, 0},
{968, 1048576000u, 1059481190u, 1052507701u, 0, ATAN2_TOLERANCE, 0},
{969, 1048576000u, 1060320051u, 1051697365u, 0, ATAN2_TOLERANCE, 0},
{970, 1048576000u, 1061158912u, 1050983549u, 0, ATAN2_TOLERANCE, 0},
{971, 1048576000u, 1061997773u, 1050350522u, 0, ATAN2_TOLERANCE, 0},
{972, 1048576000u, 1062836634u, 1049785686u, 0, ATAN2_TOLERANCE, 0},
{973, 1048576000u, 1063675494u, 1049278860u, 0, ATAN2_TOLERANCE, 0},
{974, 1048576000u, 1064514355u, 1048821743u, 0, ATAN2_TOLERANCE, 0},
{975, 1050253722u, 3212836864u, 1077307552u, 0, ATAN2_TOLERANCE, 0},
{976, 1050253722u, 3211998003u, 1077247062u, 0, ATAN2_TOLERANCE, 0},
{977, 1050253722u, 3211159142u, 1077180491u, 0, ATAN2_TOLERANCE, 0},
{978, 1050253722u, 3210320282u, 1077106914u, 0, ATAN2_TOLERANCE, 0},
{979, 1050253722u, 3209481421u, 1077025217u, 0, ATAN2_TOLERANCE, 0},
{980, 1050253722u, 3208642560u, 1076934051u, 0, ATAN2_TOLERANCE, 0},
{981, 1050253722u, 3207803699u, 1076831771u, 0, ATAN2_TOLERANCE, 0},
{982, 1050253722u, 3206964838u, 1076716361u, 0, ATAN2_TOLERANCE, 0},
{983, 1050253722u, 3206125978u, 1076585332u, 0, ATAN2_TOLERANCE, 0},
{984, 1050253722u, 3205287117u, 1076435599u, 0, ATAN2_TOLERANCE, 0},
{985, 1050253722u, 3204448256u, 1076263327u, 0, ATAN2_TOLERANCE, 0},
{986, 1050253722u, 3202770534u, 1076063749u, 0, ATAN2_TOLERANCE, 0},
{987, 1050253722u, 3201092813u, 1075830971u, 0, ATAN2_TOLERANCE, 0},
{988, 1050253722u, 3199415091u, 1075557817u, 0, ATAN2_TOLERANCE, 0},
{989, 1050253722u, 3197737370u, 1075235812u, 0, ATAN2_TOLERANCE, 0},
{990, 1050253722u, 3196059648u, 1074855557u, 0, ATAN2_TOLERANCE, 0},
{991, 1050253722u, 3192704205u, 1074407875u, 0, ATAN2_TOLERANCE, 0},
{992, 1050253722u, 3189348762u, 1073886292u, 0, ATAN2_TOLERANCE, 0},
{993, 1050253722u, 3184315597u, 1072840442u, 0, ATAN2_TOLERANCE, 0},
{994, 1050253722u, 3175926989u, 1071526770u, 0, ATAN2_TOLERANCE, 0},
{995, 1050253722u, 1028443341u, 1068756035u, 0, ATAN2_TOLERANCE, 0},
{996, 1050253722u, 1036831949u, 1067442363u, 0, ATAN2_TOLERANCE, 0},
{997, 1050253722u, 1041865114u, 1066252045u, 0, ATAN2_TOLERANCE, 0},
{998, 1050253722u, 1045220557u, 1065064543u, 0, ATAN2_TOLERANCE, 0},
{999, 1050253722u, 1048576000u, 1063273815u, 0, ATAN2_TOLERANCE, 0},
{1000, 1050253722u, 1050253722u, 1061752795u, 0, ATAN2_TOLERANCE, 0},
{1001, 1050253722u, 1051931443u, 1060464776u, 0, ATAN2_TOLERANCE, 0},
{1002, 1050253722u, 1053609165u, 1059372157u, 0, ATAN2_TOLERANCE, 0},
{1003, 1050253722u, 1055286886u, 1058441047u, 0, ATAN2_TOLERANCE, 0},
{1004, 1050253722u, 1056964608u, 1057642735u, 0, ATAN2_TOLERANCE, 0},
{1005, 1050253722u, 1057803469u, 1056942688u, 0, ATAN2_TOLERANCE, 0},
{1006, 1050253722u, 1058642330u, 1055744824u, 0, ATAN2_TOLERANCE, 0},
{1007, 1050253722u, 1059481190u, 1054696589u, 0, ATAN2_TOLERANCE, 0},
{1008, 1050253722u, 1060320051u, 1053773306u, 0, ATAN2_TOLERANCE, 0},
{1009, 1050253722u, 1061158912u, 1052955067u, 0, ATAN2_TOLERANCE, 0},
{1010, 1050253722u, 1061997773u, 1052225738u, 0, ATAN2_TOLERANCE, 0},
{1011, 1050253722u, 1062836634u, 1051572163u, 0, ATAN2_TOLERANCE, 0},
{1012, 1050253722u, 1063675494u, 1050983549u, 0, ATAN2_TOLERANCE, 0},
{1013, 1050253722u, 1064514355u, 1050450984u, 0, ATAN2_TOLERANCE, 0},
{1014, 1051931443u, 3212836864u, 1077117894u, 0, ATAN2_TOLERANCE, 0},
{1015, 1051931443u, 3211998003u, 1077049462u, 0, ATAN2_TOLERANCE, 0},
{1016, 1051931443u, 3211159142u, 1076974380u, 0, ATAN2_TOLERANCE, 0},
{1017, 1051931443u, 3210320282u, 1076891686u, 0, ATAN2_TOLERANCE, 0},
{1018, 1051931443u, 3209481421u, 1076800236u, 0, ATAN2_TOLERANCE, 0},
{1019, 1051931443u, 3208642560u, 1076698664u, 0, ATAN2_TOLERANCE, 0},
{1020, 1051931443u, 3207803699u, 1076585332u, 0, ATAN2_TOLERANCE, 0},
{1021, 1051931443u, 3206964838u, 1076458270u, 0, ATAN2_TOLERANCE, 0},
{1022, 1051931443u, 3206125978u, 1076315106u, 0, ATAN2_TOLERANCE, 0},
{1023, 1051931443u, 3205287117u, 1076152976u, 0, ATAN2_TOLERANCE, 0},
{1024, 1051931443u, 3204448256u, 1075968440u, 0, ATAN2_TOLERANCE, 0},
{1025, 1051931443u, 3202770534u, 1075757395u, 0, ATAN2_TOLERANCE, 0},
{1026, 1051931443u, 3201092813u, 1075515019u, 0, ATAN2_TOLERANCE, 0},
{1027, 1051931443u, 3199415091u, 1075235812u, 0, ATAN2_TOLERANCE, 0},
{1028, 1051931443u, 3197737370u, 1074913807u, 0, ATAN2_TOLERANCE, 0},
{1029, 1051931443u, 3196059648u, 1074543128u, 0, ATAN2_TOLERANCE, 0},
{1030, 1051931443u, 3192704205u, 1074119070u, 0, ATAN2_TOLERANCE, 0},
{1031, 1051931443u, 3189348762u, 1073537881u, 0, ATAN2_TOLERANCE, 0},
{1032, 1051931443u, 3184315597u, 1072475949u, 0, ATAN2_TOLERANCE, 0},
{1033, 1051931443u, 3175926989u, 1071331721u, 0, ATAN2_TOLERANCE, 0},
{1034, 1051931443u, 1028443341u, 1068951084u, 0, ATAN2_TOLERANCE, 0},
{1035, 1051931443u, 1036831949u, 1067806856u, 0, ATAN2_TOLERANCE, 0},
{1036, 1051931443u, 1041865114u, 1066744924u, 0, ATAN2_TOLERANCE, 0},
{1037, 1051931443u, 1045220557u, 1065786489u, 0, ATAN2_TOLERANCE, 0},
{1038, 1051931443u, 1048576000u, 1064523530u, 0, ATAN2_TOLERANCE, 0},
{1039, 1051931443u, 1050253722u, 1063040813u, 0, ATAN2_TOLERANCE, 0},
{1040, 1051931443u, 1051931443u, 1061752795u, 0, ATAN2_TOLERANCE, 0},
{1041, 1051931443u, 1053609165u, 1060635966u, 0, ATAN2_TOLERANCE, 0},
{1042, 1051931443u, 1055286886u, 1059666464u, 0, ATAN2_TOLERANCE, 0},
{1043, 1051931443u, 1056964608u, 1058822281u, 0, ATAN2_TOLERANCE, 0},
{1044, 1051931443u, 1057803469u, 1058084138u, 0, ATAN2_TOLERANCE, 0},
{1045, 1051931443u, 1058642330u, 1057435619u, 0, ATAN2_TOLERANCE, 0},
{1046, 1051931443u, 1059481190u, 1056761314u, 0, ATAN2_TOLERANCE, 0},
{1047, 1051931443u, 1060320051u, 1055744824u, 0, ATAN2_TOLERANCE, 0},
{1048, 1051931443u, 1061158912u, 1054838168u, 0, ATAN2_TOLERANCE, 0},
{1049, 1051931443u, 1061997773u, 1054025590u, 0, ATAN2_TOLERANCE, 0},
{1050, 1051931443u, 1062836634u, 1053293989u, 0, ATAN2_TOLERANCE, 0},
{1051, 1051931443u, 1063675494u, 1052632439u, 0, ATAN2_TOLERANCE, 0},
{1052, 1051931443u, 1064514355u, 1052031784u, 0, ATAN2_TOLERANCE, 0},
{1053, 1053609165u, 3212836864u, 1076934051u, 0, ATAN2_TOLERANCE, 0},
{1054, 1053609165u, 3211998003u, 1076858486u, 0, ATAN2_TOLERANCE, 0},
{1055, 1053609165u, 3211159142u, 1076775851u, 0, ATAN2_TOLERANCE, 0},
{1056, 1053609165u, 3210320282u, 1076685177u, 0, ATAN2_TOLERANCE, 0},
{1057, 1053609165u, 3209481421u, 1076585332u, 0, ATAN2_TOLERANCE, 0},
{1058, 1053609165u, 3208642560u, 1076474981u, 0, ATAN2_TOLERANCE, 0},
{1059, 1053609165u, 3207803699u, 1076352554u, 0, ATAN2_TOLERANCE, 0},
{1060, 1053609165u, 3206964838u, 1076216202u, 0, ATAN2_TOLERANCE, 0},
{1061, 1053609165u, 3206125978u, 1076063749u, 0, ATAN2_TOLERANCE, 0},
{1062, 1053609165u, 3205287117u, 1075892648u, 0, ATAN2_TOLERANCE, 0},
{1063, 1053609165u, 3204448256u, 1075699942u, 0, ATAN2_TOLERANCE, 0},
{1064, 1053609165u, 3202770534u, 1075482252u, 0, ATAN2_TOLERANCE, 0},
{1065, 1053609165u, 3201092813u, 1075235812u, 0, ATAN2_TOLERANCE, 0},
{1066, 1053609165u, 3199415091u, 1074956605u, 0, ATAN2_TOLERANCE, 0},
{1067, 1053609165u, 3197737370u, 1074640653u, 0, ATAN2_TOLERANCE, 0},
{1068, 1053609165u, 3196059648u, 1074284549u, 0, ATAN2_TOLERANCE, 0},
{1069, 1053609165u, 3192704205u, 1073886292u, 0, ATAN2_TOLERANCE, 0},
{1070, 1053609165u, 3189348762u, 1073150989u, 0, ATAN2_TOLERANCE, 0},
{1071, 1053609165u, 3184315597u, 1072196433u, 0, ATAN2_TOLERANCE, 0},
{1072, 1053609165u, 3175926989u, 1071184568u, 0, ATAN2_TOLERANCE, 0},
{1073, 1053609165u, 1028443341u, 1069098237u, 0, ATAN2_TOLERANCE, 0},
{1074, 1053609165u, 1036831949u, 1068086373u, 0, ATAN2_TOLERANCE, 0},
{1075, 1053609165u, 1041865114u, 1067131816u, 0, ATAN2_TOLERANCE, 0},
{1076, 1053609165u, 1045220557u, 1066252045u, 0, ATAN2_TOLERANCE, 0},
{1077, 1053609165u, 1048576000u, 1065455532u, 0, ATAN2_TOLERANCE, 0},
{1078, 1053609165u, 1050253722u, 1064133432u, 0, ATAN2_TOLERANCE, 0},
{1079, 1053609165u, 1051931443u, 1062869623u, 0, ATAN2_TOLERANCE, 0},
{1080, 1053609165u, 1053609165u, 1061752795u, 0, ATAN2_TOLERANCE, 0},
{1081, 1053609165u, 1055286886u, 1060767036u, 0, ATAN2_TOLERANCE, 0},
{1082, 1053609165u, 1056964608u, 1059896275u, 0, ATAN2_TOLERANCE, 0},
{1083, 1053609165u, 1057803469u, 1059125451u, 0, ATAN2_TOLERANCE, 0},
{1084, 1053609165u, 1058642330u, 1058441047u, 0, ATAN2_TOLERANCE, 0},
{1085, 1053609165u, 1059481190u, 1057831235u, 0, ATAN2_TOLERANCE, 0},
{1086, 1053609165u, 1060320051u, 1057285826u, 0, ATAN2_TOLERANCE, 0},
{1087, 1053609165u, 1061158912u, 1056627632u, 0, ATAN2_TOLERANCE, 0},
{1088, 1053609165u, 1061997773u, 1055744824u, 0, ATAN2_TOLERANCE, 0},
{1089, 1053609165u, 1062836634u, 1054946060u, 0, ATAN2_TOLERANCE, 0},
{1090, 1053609165u, 1063675494u, 1054220672u, 0, ATAN2_TOLERANCE, 0},
{1091, 1053609165u, 1064514355u, 1053559586u, 0, ATAN2_TOLERANCE, 0},
{1092, 1055286886u, 3212836864u, 1076756433u, 0, ATAN2_TOLERANCE, 0},
{1093, 1055286886u, 3211998003u, 1076674559u, 0, ATAN2_TOLERANCE, 0},
{1094, 1055286886u, 3211159142u, 1076585332u, 0, ATAN2_TOLERANCE, 0},
{1095, 1055286886u, 3210320282u, 1076487807u, 0, ATAN2_TOLERANCE, 0},
{1096, 1055286886u, 3209481421u, 1076380893u, 0, ATAN2_TOLERANCE, 0},
{1097, 1055286886u, 3208642560u, 1076263327u, 0, ATAN2_TOLERANCE, 0},
{1098, 1055286886u, 3207803699u, 1076133648u, 0, ATAN2_TOLERANCE, 0},
{1099, 1055286886u, 3206964838u, 1075990172u, 0, ATAN2_TOLERANCE, 0},
{1100, 1055286886u, 3206125978u, 1075830971u, 0, ATAN2_TOLERANCE, 0},
{1101, 1055286886u, 3205287117u, 1075653853u, 0, ATAN2_TOLERANCE, 0},
{1102, 1055286886u, 3204448256u, 1075456361u, 0, ATAN2_TOLERANCE, 0},
{1103, 1055286886u, 3202770534u, 1075235812u, 0, ATAN2_TOLERANCE, 0},
{1104, 1055286886u, 3201092813u, 1074989372u, 0, ATAN2_TOLERANCE, 0},
{1105, 1055286886u, 3199415091u, 1074714229u, 0, ATAN2_TOLERANCE, 0},
{1106, 1055286886u, 3197737370u, 1074407875u, 0, ATAN2_TOLERANCE, 0},
{1107, 1055286886u, 3196059648u, 1074068539u, 0, ATAN2_TOLERANCE, 0},
{1108, 1055286886u, 3192704205u, 1073649723u, 0, ATAN2_TOLERANCE, 0},
{1109, 1055286886u, 3189348762u, 1072840442u, 0, ATAN2_TOLERANCE, 0},
{1110, 1055286886u, 3184315597u, 1071975731u, 0, ATAN2_TOLERANCE, 0},
{1111, 1055286886u, 3175926989u, 1071069663u, 0, ATAN2_TOLERANCE, 0},
{1112, 1055286886u, 1028443341u, 1069213143u, 0, ATAN2_TOLERANCE, 0},
{1113, 1055286886u, 1036831949u, 1068307075u, 0, ATAN2_TOLERANCE, 0},
{1114, 1055286886u, 1041865114u, 1067442363u, 0, ATAN2_TOLERANCE, 0},
{1115, 1055286886u, 1045220557u, 1066633083u, 0, ATAN2_TOLERANCE, 0},
{1116, 1055286886u, 1048576000u, 1065887552u, 0, ATAN2_TOLERANCE, 0},
{1117, 1055286886u, 1050253722u, 1065064543u, 0, ATAN2_TOLERANCE, 0},
{1118, 1055286886u, 1051931443u, 1063839125u, 0, ATAN2_TOLERANCE, 0},
{1119, 1055286886u, 1053609165u, 1062738554u, 0, ATAN2_TOLERANCE, 0},
{1120, 1055286886u, 1055286886u, 1061752795u, 0, ATAN2_TOLERANCE, 0},
{1121, 1055286886u, 1056964608u, 1060870597u, 0, ATAN2_TOLERANCE, 0},
{1122, 1055286886u, 1057803469u, 1060080632u, 0, ATAN2_TOLERANCE, 0},
{1123, 1055286886u, 1058642330u, 1059372157u, 0, ATAN2_TOLERANCE, 0},
{1124, 1055286886u, 1059481190u, 1058735354u, 0, ATAN2_TOLERANCE, 0},
{1125, 1055286886u, 1060320051u, 1058161452u, 0, ATAN2_TOLERANCE, 0},
{1126, 1055286886u, 1061158912u, 1057642735u, 0, ATAN2_TOLERANCE, 0},
{1127, 1055286886u, 1061997773u, 1057172469u, 0, ATAN2_TOLERANCE, 0},
{1128, 1055286886u, 1062836634u, 1056525019u, 0, ATAN2_TOLERANCE, 0},
{1129, 1055286886u, 1063675494u, 1055744824u, 0, ATAN2_TOLERANCE, 0},
{1130, 1055286886u, 1064514355u, 1055031008u, 0, ATAN2_TOLERANCE, 0},
{1131, 1056964608u, 3212836864u, 1076585332u, 0, ATAN2_TOLERANCE, 0},
{1132, 1056964608u, 3211998003u, 1076497963u, 0, ATAN2_TOLERANCE, 0},
{1133, 1056964608u, 3211159142u, 1076403085u, 0, ATAN2_TOLERANCE, 0},
{1134, 1056964608u, 3210320282u, 1076299798u, 0, ATAN2_TOLERANCE, 0},
{1135, 1056964608u, 3209481421u, 1076187075u, 0, ATAN2_TOLERANCE, 0},
{1136, 1056964608u, 3208642560u, 1076063749u, 0, ATAN2_TOLERANCE, 0},
{1137, 1056964608u, 3207803699u, 1075928496u, 0, ATAN2_TOLERANCE, 0},
{1138, 1056964608u, 3206964838u, 1075779824u, 0, ATAN2_TOLERANCE, 0},
{1139, 1056964608u, 3206125978u, 1075616067u, 0, ATAN2_TOLERANCE, 0},
{1140, 1056964608u, 3205287117u, 1075435390u, 0, ATAN2_TOLERANCE, 0},
{1141, 1056964608u, 3204448256u, 1075235812u, 0, ATAN2_TOLERANCE, 0},
{1142, 1056964608u, 3202770534u, 1075015263u, 0, ATAN2_TOLERANCE, 0},
{1143, 1056964608u, 3201092813u, 1074771682u, 0, ATAN2_TOLERANCE, 0},
{1144, 1056964608u, 3199415091u, 1074503184u, 0, ATAN2_TOLERANCE, 0},
{1145, 1056964608u, 3197737370u, 1074208297u, 0, ATAN2_TOLERANCE, 0},
{1146, 1056964608u, 3196059648u, 1073886292u, 0, ATAN2_TOLERANCE, 0},
{1147, 1056964608u, 3192704205u, 1073333321u, 0, ATAN2_TOLERANCE, 0},
{1148, 1056964608u, 3189348762u, 1072586319u, 0, ATAN2_TOLERANCE, 0},
{1149, 1056964608u, 3184315597u, 1071797277u, 0, ATAN2_TOLERANCE, 0},
{1150, 1056964608u, 3175926989u, 1070977484u, 0, ATAN2_TOLERANCE, 0},
{1151, 1056964608u, 1028443341u, 1069305321u, 0, ATAN2_TOLERANCE, 0},
{1152, 1056964608u, 1036831949u, 1068485529u, 0, ATAN2_TOLERANCE, 0},
{1153, 1056964608u, 1041865114u, 1067696486u, 0, ATAN2_TOLERANCE, 0},
{1154, 1056964608u, 1045220557u, 1066949484u, 0, ATAN2_TOLERANCE, 0},
{1155, 1056964608u, 1048576000u, 1066252045u, 0, ATAN2_TOLERANCE, 0},
{1156, 1056964608u, 1050253722u, 1065608035u, 0, ATAN2_TOLERANCE, 0},
{1157, 1056964608u, 1051931443u, 1064683308u, 0, ATAN2_TOLERANCE, 0},
{1158, 1056964608u, 1053609165u, 1063609315u, 0, ATAN2_TOLERANCE, 0},
{1159, 1056964608u, 1055286886u, 1062634992u, 0, ATAN2_TOLERANCE, 0},
{1160, 1056964608u, 1056964608u, 1061752795u, 0, ATAN2_TOLERANCE, 0},
{1161, 1056964608u, 1057803469u, 1060954483u, 0, ATAN2_TOLERANCE, 0},
{1162, 1056964608u, 1058642330u, 1060231774u, 0, ATAN2_TOLERANCE, 0},
{1163, 1056964608u, 1059481190u, 1059576747u, 0, ATAN2_TOLERANCE, 0},
{1164, 1056964608u, 1060320051u, 1058982060u, 0, ATAN2_TOLERANCE, 0},
{1165, 1056964608u, 1061158912u, 1058441047u, 0, ATAN2_TOLERANCE, 0},
{1166, 1056964608u, 1061997773u, 1057947741u, 0, ATAN2_TOLERANCE, 0},
{1167, 1056964608u, 1062836634u, 1057496850u, 0, ATAN2_TOLERANCE, 0},
{1168, 1056964608u, 1063675494u, 1057083701u, 0, ATAN2_TOLERANCE, 0},
{1169, 1056964608u, 1064514355u, 1056443774u, 0, ATAN2_TOLERANCE, 0},
{1170, 1057803469u, 3212836864u, 1076420933u, 0, ATAN2_TOLERANCE, 0},
{1171, 1057803469u, 3211998003u, 1076328858u, 0, ATAN2_TOLERANCE, 0},
{1172, 1057803469u, 3211159142u, 1076229228u, 0, ATAN2_TOLERANCE, 0},
{1173, 1057803469u, 3210320282u, 1076121202u, 0, ATAN2_TOLERANCE, 0},
{1174, 1057803469u, 3209481421u, 1076003834u, 0, ATAN2_TOLERANCE, 0},
{1175, 1057803469u, 3208642560u, 1075876070u, 0, ATAN2_TOLERANCE, 0},
{1176, 1057803469u, 3207803699u, 1075736733u, 0, ATAN2_TOLERANCE, 0},
{1177, 1057803469u, 3206964838u, 1075584532u, 0, ATAN2_TOLERANCE, 0},
{1178, 1057803469u, 3206125978u, 1075418058u, 0, ATAN2_TOLERANCE, 0},
{1179, 1057803469u, 3205287117u, 1075235812u, 0, ATAN2_TOLERANCE, 0},
{1180, 1057803469u, 3204448256u, 1075036234u, 0, ATAN2_TOLERANCE, 0},
{1181, 1057803469u, 3202770534u, 1074817771u, 0, ATAN2_TOLERANCE, 0},
{1182, 1057803469u, 3201092813u, 1074578976u, 0, ATAN2_TOLERANCE, 0},
{1183, 1057803469u, 3199415091u, 1074318648u, 0, ATAN2_TOLERANCE, 0},
{1184, 1057803469u, 3197737370u, 1074036025u, 0, ATAN2_TOLERANCE, 0},
{1185, 1057803469u, 3196059648u, 1073720213u, 0, ATAN2_TOLERANCE, 0},
{1186, 1057803469u, 3192704205u, 1073067106u, 0, ATAN2_TOLERANCE, 0},
{1187, 1057803469u, 3189348762u, 1072374887u, 0, ATAN2_TOLERANCE, 0},
{1188, 1057803469u, 3184315597u, 1071650123u, 0, ATAN2_TOLERANCE, 0},
{1189, 1057803469u, 3175926989u, 1070901913u, 0, ATAN2_TOLERANCE, 0},
{1190, 1057803469u, 1028443341u, 1069380892u, 0, ATAN2_TOLERANCE, 0},
{1191, 1057803469u, 1036831949u, 1068632682u, 0, ATAN2_TOLERANCE, 0},
{1192, 1057803469u, 1041865114u, 1067907919u, 0, ATAN2_TOLERANCE, 0},
{1193, 1057803469u, 1045220557u, 1067215699u, 0, ATAN2_TOLERANCE, 0},
{1194, 1057803469u, 1048576000u, 1066562592u, 0, ATAN2_TOLERANCE, 0},
{1195, 1057803469u, 1050253722u, 1065952579u, 0, ATAN2_TOLERANCE, 0},
{1196, 1057803469u, 1051931443u, 1065387333u, 0, ATAN2_TOLERANCE, 0},
{1197, 1057803469u, 1053609165u, 1064380138u, 0, ATAN2_TOLERANCE, 0},
{1198, 1057803469u, 1055286886u, 1063424957u, 0, ATAN2_TOLERANCE, 0},
{1199, 1057803469u, 1056964608u, 1062551107u, 0, ATAN2_TOLERANCE, 0},
{1200, 1057803469u, 1057803469u, 1061752795u, 0, ATAN2_TOLERANCE, 0},
{1201, 1057803469u, 1058642330u, 1061023810u, 0, ATAN2_TOLERANCE, 0},
{1202, 1057803469u, 1059481190u, 1060357916u, 0, ATAN2_TOLERANCE, 0},
{1203, 1057803469u, 1060320051u, 1059749110u, 0, ATAN2_TOLERANCE, 0},
{1204, 1057803469u, 1061158912u, 1059191764u, 0, ATAN2_TOLERANCE, 0},
{1205, 1057803469u, 1061997773u, 1058680705u, 0, ATAN2_TOLERANCE, 0},
{1206, 1057803469u, 1062836634u, 1058211236u, 0, ATAN2_TOLERANCE, 0},
{1207, 1057803469u, 1063675494u, 1057779132u, 0, ATAN2_TOLERANCE, 0},
{1208, 1057803469u, 1064514355u, 1057380612u, 0, ATAN2_TOLERANCE, 0},
{1209, 1058642330u, 3212836864u, 1076263327u, 0, ATAN2_TOLERANCE, 0},
{1210, 1058642330u, 3211998003u, 1076167291u, 0, ATAN2_TOLERANCE, 0},
{1211, 1058642330u, 3211159142u, 1076063749u, 0, ATAN2_TOLERANCE, 0},
{1212, 1058642330u, 3210320282u, 1075951927u, 0, ATAN2_TOLERANCE, 0},
{1213, 1058642330u, 3209481421u, 1075830971u, 0, ATAN2_TOLERANCE, 0},
{1214, 1058642330u, 3208642560u, 1075699942u, 0, ATAN2_TOLERANCE, 0},
{1215, 1058642330u, 3207803699u, 1075557817u, 0, ATAN2_TOLERANCE, 0},
{1216, 1058642330u, 3206964838u, 1075403495u, 0, ATAN2_TOLERANCE, 0},
{1217, 1058642330u, 3206125978u, 1075235812u, 0, ATAN2_TOLERANCE, 0},
{1218, 1058642330u, 3205287117u, 1075053566u, 0, ATAN2_TOLERANCE, 0},
{1219, 1058642330u, 3204448256u, 1074855557u, 0, ATAN2_TOLERANCE, 0},
{1220, 1058642330u, 3202770534u, 1074640653u, 0, ATAN2_TOLERANCE, 0},
{1221, 1058642330u, 3201092813u, 1074407875u, 0, ATAN2_TOLERANCE, 0},
{1222, 1058642330u, 3199415091u, 1074156518u, 0, ATAN2_TOLERANCE, 0},
{1223, 1058642330u, 3197737370u, 1073886292u, 0, ATAN2_TOLERANCE, 0},
{1224, 1058642330u, 3196059648u, 1073453151u, 0, ATAN2_TOLERANCE, 0},
{1225, 1058642330u, 3192704205u, 1072840442u, 0, ATAN2_TOLERANCE, 0},
{1226, 1058642330u, 3189348762u, 1072196433u, 0, ATAN2_TOLERANCE, 0},
{1227, 1058642330u, 3184315597u, 1071526770u, 0, ATAN2_TOLERANCE, 0},
{1228, 1058642330u, 3175926989u, 1070838842u, 0, ATAN2_TOLERANCE, 0},
{1229, 1058642330u, 1028443341u, 1069443963u, 0, ATAN2_TOLERANCE, 0},
{1230, 1058642330u, 1036831949u, 1068756035u, 0, ATAN2_TOLERANCE, 0},
{1231, 1058642330u, 1041865114u, 1068086373u, 0, ATAN2_TOLERANCE, 0},
{1232, 1058642330u, 1045220557u, 1067442363u, 0, ATAN2_TOLERANCE, 0},
{1233, 1058642330u, 1048576000u, 1066829655u, 0, ATAN2_TOLERANCE, 0},
{1234, 1058642330u, 1050253722u, 1066252045u, 0, ATAN2_TOLERANCE, 0},
{1235, 1058642330u, 1051931443u, 1065711593u, 0, ATAN2_TOLERANCE, 0},
{1236, 1058642330u, 1053609165u, 1065064543u, 0, ATAN2_TOLERANCE, 0},
{1237, 1058642330u, 1055286886u, 1064133432u, 0, ATAN2_TOLERANCE, 0},
{1238, 1058642330u, 1056964608u, 1063273815u, 0, ATAN2_TOLERANCE, 0},
{1239, 1058642330u, 1057803469u, 1062481780u, 0, ATAN2_TOLERANCE, 0},
{1240, 1058642330u, 1058642330u, 1061752795u, 0, ATAN2_TOLERANCE, 0},
{1241, 1058642330u, 1059481190u, 1061082064u, 0, ATAN2_TOLERANCE, 0},
{1242, 1058642330u, 1060320051u, 1060464776u, 0, ATAN2_TOLERANCE, 0},
{1243, 1058642330u, 1061158912u, 1059896275u, 0, ATAN2_TOLERANCE, 0},
{1244, 1058642330u, 1061997773u, 1059372157u, 0, ATAN2_TOLERANCE, 0},
{1245, 1058642330u, 1062836634u, 1058888333u, 0, ATAN2_TOLERANCE, 0},
{1246, 1058642330u, 1063675494u, 1058441047u, 0, ATAN2_TOLERANCE, 0},
{1247, 1058642330u, 1064514355u, 1058026879u, 0, ATAN2_TOLERANCE, 0},
{1248, 1059481190u, 3212836864u, 1076112518u, 0, ATAN2_TOLERANCE, 0},
{1249, 1059481190u, 3211998003u, 1076013218u, 0, ATAN2_TOLERANCE, 0},
{1250, 1059481190u, 3211159142u, 1075906536u, 0, ATAN2_TOLERANCE, 0},
{1251, 1059481190u, 3210320282u, 1075791773u, 0, ATAN2_TOLERANCE, 0},
{1252, 1059481190u, 3209481421u, 1075668168u, 0, ATAN2_TOLERANCE, 0},
{1253, 1059481190u, 3208642560u, 1075534897u, 0, ATAN2_TOLERANCE, 0},
{1254, 1059481190u, 3207803699u, 1075391086u, 0, ATAN2_TOLERANCE, 0},
{1255, 1059481190u, 3206964838u, 1075235812u, 0, ATAN2_TOLERANCE, 0},
{1256, 1059481190u, 3206125978u, 1075068129u, 0, ATAN2_TOLERANCE, 0},
{1257, 1059481190u, 3205287117u, 1074887092u, 0, ATAN2_TOLERANCE, 0},
{1258, 1059481190u, 3204448256u, 1074691800u, 0, ATAN2_TOLERANCE, 0},
{1259, 1059481190u, 3202770534u, 1074481452u, 0, ATAN2_TOLERANCE, 0},
{1260, 1059481190u, 3201092813u, 1074255422u, 0, ATAN2_TOLERANCE, 0},
{1261, 1059481190u, 3199415091u, 1074013354u, 0, ATAN2_TOLERANCE, 0},
{1262, 1059481190u, 3197737370u, 1073755263u, 0, ATAN2_TOLERANCE, 0},
{1263, 1059481190u, 3196059648u, 1073221480u, 0, ATAN2_TOLERANCE, 0},
{1264, 1059481190u, 3192704205u, 1072645393u, 0, ATAN2_TOLERANCE, 0},
{1265, 1059481190u, 3189348762u, 1072043929u, 0, ATAN2_TOLERANCE, 0},
{1266, 1059481190u, 3184315597u, 1071421918u, 0, ATAN2_TOLERANCE, 0},
{1267, 1059481190u, 3175926989u, 1070785412u, 0, ATAN2_TOLERANCE, 0},
{1268, 1059481190u, 1028443341u, 1069497393u, 0, ATAN2_TOLERANCE, 0},
{1269, 1059481190u, 1036831949u, 1068860887u, 0, ATAN2_TOLERANCE, 0},
{1270, 1059481190u, 1041865114u, 1068238876u, 0, ATAN2_TOLERANCE, 0},
{1271, 1059481190u, 1045220557u, 1067637412u, 0, ATAN2_TOLERANCE, 0},
{1272, 1059481190u, 1048576000u, 1067061325u, 0, ATAN2_TOLERANCE, 0},
{1273, 1059481190u, 1050253722u, 1066514103u, 0, ATAN2_TOLERANCE, 0},
{1274, 1059481190u, 1051931443u, 1065997922u, 0, ATAN2_TOLERANCE, 0},
{1275, 1059481190u, 1053609165u, 1065513785u, 0, ATAN2_TOLERANCE, 0},
{1276, 1059481190u, 1055286886u, 1064770236u, 0, ATAN2_TOLERANCE, 0},
{1277, 1059481190u, 1056964608u, 1063928842u, 0, ATAN2_TOLERANCE, 0},
{1278, 1059481190u, 1057803469u, 1063147673u, 0, ATAN2_TOLERANCE, 0},
{1279, 1059481190u, 1058642330u, 1062423526u, 0, ATAN2_TOLERANCE, 0},
{1280, 1059481190u, 1059481190u, 1061752795u, 0, ATAN2_TOLERANCE, 0},
{1281, 1059481190u, 1060320051u, 1061131700u, 0, ATAN2_TOLERANCE, 0},
{1282, 1059481190u, 1061158912u, 1060556454u, 0, ATAN2_TOLERANCE, 0},
{1283, 1059481190u, 1061997773u, 1060023372u, 0, ATAN2_TOLERANCE, 0},
{1284, 1059481190u, 1062836634u, 1059528949u, 0, ATAN2_TOLERANCE, 0},
{1285, 1059481190u, 1063675494u, 1059069898u, 0, ATAN2_TOLERANCE, 0},
{1286, 1059481190u, 1064514355u, 1058643172u, 0, ATAN2_TOLERANCE, 0},
{1287, 1060320051u, 3212836864u, 1075968440u, 0, ATAN2_TOLERANCE, 0},
{1288, 1060320051u, 3211998003u, 1075866515u, 0, ATAN2_TOLERANCE, 0},
{1289, 1060320051u, 3211159142u, 1075757395u, 0, ATAN2_TOLERANCE, 0},
{1290, 1060320051u, 3210320282u, 1075640452u, 0, ATAN2_TOLERANCE, 0},
{1291, 1060320051u, 3209481421u, 1075515019u, 0, ATAN2_TOLERANCE, 0},
{1292, 1060320051u, 3208642560u, 1075380386u, 0, ATAN2_TOLERANCE, 0},
{1293, 1060320051u, 3207803699u, 1075235812u, 0, ATAN2_TOLERANCE, 0},
{1294, 1060320051u, 3206964838u, 1075080538u, 0, ATAN2_TOLERANCE, 0},
{1295, 1060320051u, 3206125978u, 1074913807u, 0, ATAN2_TOLERANCE, 0},
{1296, 1060320051u, 3205287117u, 1074734891u, 0, ATAN2_TOLERANCE, 0},
{1297, 1060320051u, 3204448256u, 1074543128u, 0, ATAN2_TOLERANCE, 0},
{1298, 1060320051u, 3202770534u, 1074337976u, 0, ATAN2_TOLERANCE, 0},
{1299, 1060320051u, 3201092813u, 1074119070u, 0, ATAN2_TOLERANCE, 0},
{1300, 1060320051u, 3199415091u, 1073886292u, 0, ATAN2_TOLERANCE, 0},
{1301, 1060320051u, 3197737370u, 1073537881u, 0, ATAN2_TOLERANCE, 0},
{1302, 1060320051u, 3196059648u, 1073018896u, 0, ATAN2_TOLERANCE, 0},
{1303, 1060320051u, 3192704205u, 1072475949u, 0, ATAN2_TOLERANCE, 0},
{1304, 1060320051u, 3189348762u, 1071912182u, 0, ATAN2_TOLERANCE, 0},
{1305, 1060320051u, 3184315597u, 1071331721u, 0, ATAN2_TOLERANCE, 0},
{1306, 1060320051u, 3175926989u, 1070739573u, 0, ATAN2_TOLERANCE, 0},
{1307, 1060320051u, 1028443341u, 1069543232u, 0, ATAN2_TOLERANCE, 0},
{1308, 1060320051u, 1036831949u, 1068951084u, 0, ATAN2_TOLERANCE, 0},
{1309, 1060320051u, 1041865114u, 1068370623u, 0, ATAN2_TOLERANCE, 0},
{1310, 1060320051u, 1045220557u, 1067806856u, 0, ATAN2_TOLERANCE, 0},
{1311, 1060320051u, 1048576000u, 1067263909u, 0, ATAN2_TOLERANCE, 0},
{1312, 1060320051u, 1050253722u, 1066744924u, 0, ATAN2_TOLERANCE, 0},
{1313, 1060320051u, 1051931443u, 1066252045u, 0, ATAN2_TOLERANCE, 0},
{1314, 1060320051u, 1053609165u, 1065786489u, 0, ATAN2_TOLERANCE, 0},
{1315, 1060320051u, 1055286886u, 1065344137u, 0, ATAN2_TOLERANCE, 0},
{1316, 1060320051u, 1056964608u, 1064523530u, 0, ATAN2_TOLERANCE, 0},
{1317, 1060320051u, 1057803469u, 1063756480u, 0, ATAN2_TOLERANCE, 0},
{1318, 1060320051u, 1058642330u, 1063040813u, 0, ATAN2_TOLERANCE, 0},
{1319, 1060320051u, 1059481190u, 1062373889u, 0, ATAN2_TOLERANCE, 0},
{1320, 1060320051u, 1060320051u, 1061752795u, 0, ATAN2_TOLERANCE, 0},
{1321, 1060320051u, 1061158912u, 1061174499u, 0, ATAN2_TOLERANCE, 0},
{1322, 1060320051u, 1061997773u, 1060635966u, 0, ATAN2_TOLERANCE, 0},
{1323, 1060320051u, 1062836634u, 1060134233u, 0, ATAN2_TOLERANCE, 0},
{1324, 1060320051u, 1063675494u, 1059666464u, 0, ATAN2_TOLERANCE, 0},
{1325, 1060320051u, 1064514355u, 1059229981u, 0, ATAN2_TOLERANCE, 0},
{1326, 1061158912u, 3212836864u, 1075830971u, 0, ATAN2_TOLERANCE, 0},
{1327, 1061158912u, 3211998003u, 1075727002u, 0, ATAN2_TOLERANCE, 0},
{1328, 1061158912u, 3211159142u, 1075616067u, 0, ATAN2_TOLERANCE, 0},
{1329, 1061158912u, 3210320282u, 1075497615u, 0, ATAN2_TOLERANCE, 0},
{1330, 1061158912u, 3209481421u, 1075371065u, 0, ATAN2_TOLERANCE, 0},
{1331, 1061158912u, 3208642560u, 1075235812u, 0, ATAN2_TOLERANCE, 0},
{1332, 1061158912u, 3207803699u, 1075091238u, 0, ATAN2_TOLERANCE, 0},
{1333, 1061158912u, 3206964838u, 1074936727u, 0, ATAN2_TOLERANCE, 0},
{1334, 1061158912u, 3206125978u, 1074771682u, 0, ATAN2_TOLERANCE, 0},
{1335, 1061158912u, 3205287117u, 1074595554u, 0, ATAN2_TOLERANCE, 0},
{1336, 1061158912u, 3204448256u, 1074407875u, 0, ATAN2_TOLERANCE, 0},
{1337, 1061158912u, 3202770534u, 1074208297u, 0, ATAN2_TOLERANCE, 0},
{1338, 1061158912u, 3201092813u, 1073996643u, 0, ATAN2_TOLERANCE, 0},
{1339, 1061158912u, 3199415091u, 1073772960u, 0, ATAN2_TOLERANCE, 0},
{1340, 1061158912u, 3197737370u, 1073333321u, 0, ATAN2_TOLERANCE, 0},
{1341, 1061158912u, 3196059648u, 1072840442u, 0, ATAN2_TOLERANCE, 0},
{1342, 1061158912u, 3192704205u, 1072327494u, 0, ATAN2_TOLERANCE, 0},
{1343, 1061158912u, 3189348762u, 1071797277u, 0, ATAN2_TOLERANCE, 0},
{1344, 1061158912u, 3184315597u, 1071253325u, 0, ATAN2_TOLERANCE, 0},
{1345, 1061158912u, 3175926989u, 1070699817u, 0, ATAN2_TOLERANCE, 0},
{1346, 1061158912u, 1028443341u, 1069582988u, 0, ATAN2_TOLERANCE, 0},
{1347, 1061158912u, 1036831949u, 1069029480u, 0, ATAN2_TOLERANCE, 0},
{1348, 1061158912u, 1041865114u, 1068485529u, 0, ATAN2_TOLERANCE, 0},
{1349, 1061158912u, 1045220557u, 1067955311u, 0, ATAN2_TOLERANCE, 0},
{1350, 1061158912u, 1048576000u, 1067442363u, 0, ATAN2_TOLERANCE, 0},
{1351, 1061158912u, 1050253722u, 1066949484u, 0, ATAN2_TOLERANCE, 0},
{1352, 1061158912u, 1051931443u, 1066478709u, 0, ATAN2_TOLERANCE, 0},
{1353, 1061158912u, 1053609165u, 1066031343u, 0, ATAN2_TOLERANCE, 0},
{1354, 1061158912u, 1055286886u, 1065608035u, 0, ATAN2_TOLERANCE, 0},
{1355, 1061158912u, 1056964608u, 1065064543u, 0, ATAN2_TOLERANCE, 0},
{1356, 1061158912u, 1057803469u, 1064313825u, 0, ATAN2_TOLERANCE, 0},
{1357, 1061158912u, 1058642330u, 1063609315u, 0, ATAN2_TOLERANCE, 0},
{1358, 1061158912u, 1059481190u, 1062949135u, 0, ATAN2_TOLERANCE, 0},
{1359, 1061158912u, 1060320051u, 1062331090u, 0, ATAN2_TOLERANCE, 0},
{1360, 1061158912u, 1061158912u, 1061752795u, 0, ATAN2_TOLERANCE, 0},
{1361, 1061158912u, 1061997773u, 1061211782u, 0, ATAN2_TOLERANCE, 0},
{1362, 1061158912u, 1062836634u, 1060705581u, 0, ATAN2_TOLERANCE, 0},
{1363, 1061158912u, 1063675494u, 1060231774u, 0, ATAN2_TOLERANCE, 0},
{1364, 1061158912u, 1064514355u, 1059788036u, 0, ATAN2_TOLERANCE, 0},
{1365, 1061997773u, 3212836864u, 1075699942u, 0, ATAN2_TOLERANCE, 0},
{1366, 1061997773u, 3211998003u, 1075594447u, 0, ATAN2_TOLERANCE, 0},
{1367, 1061997773u, 3211159142u, 1075482252u, 0, ATAN2_TOLERANCE, 0},
{1368, 1061997773u, 3210320282u, 1075362873u, 0, ATAN2_TOLERANCE, 0},
{1369, 1061997773u, 3209481421u, 1075235812u, 0, ATAN2_TOLERANCE, 0},
{1370, 1061997773u, 3208642560u, 1075100559u, 0, ATAN2_TOLERANCE, 0},
{1371, 1061997773u, 3207803699u, 1074956605u, 0, ATAN2_TOLERANCE, 0},
{1372, 1061997773u, 3206964838u, 1074803456u, 0, ATAN2_TOLERANCE, 0},
{1373, 1061997773u, 3206125978u, 1074640653u, 0, ATAN2_TOLERANCE, 0},
{1374, 1061997773u, 3205287117u, 1074467790u, 0, ATAN2_TOLERANCE, 0},
{1375, 1061997773u, 3204448256u, 1074284549u, 0, ATAN2_TOLERANCE, 0},
{1376, 1061997773u, 3202770534u, 1074090730u, 0, ATAN2_TOLERANCE, 0},
{1377, 1061997773u, 3201092813u, 1073886292u, 0, ATAN2_TOLERANCE, 0},
{1378, 1061997773u, 3199415091u, 1073600952u, 0, ATAN2_TOLERANCE, 0},
{1379, 1061997773u, 3197737370u, 1073150989u, 0, ATAN2_TOLERANCE, 0},
{1380, 1061997773u, 3196059648u, 1072682185u, 0, ATAN2_TOLERANCE, 0},
{1381, 1061997773u, 3192704205u, 1072196433u, 0, ATAN2_TOLERANCE, 0},
{1382, 1061997773u, 3189348762u, 1071696214u, 0, ATAN2_TOLERANCE, 0},
{1383, 1061997773u, 3184315597u, 1071184568u, 0, ATAN2_TOLERANCE, 0},
{1384, 1061997773u, 3175926989u, 1070665010u, 0, ATAN2_TOLERANCE, 0},
{1385, 1061997773u, 1028443341u, 1069617796u, 0, ATAN2_TOLERANCE, 0},
{1386, 1061997773u, 1036831949u, 1069098237u, 0, ATAN2_TOLERANCE, 0},
{1387, 1061997773u, 1041865114u, 1068586591u, 0, ATAN2_TOLERANCE, 0},
{1388, 1061997773u, 1045220557u, 1068086373u, 0, ATAN2_TOLERANCE, 0},
{1389, 1061997773u, 1048576000u, 1067600620u, 0, ATAN2_TOLERANCE, 0},
{1390, 1061997773u, 1050253722u, 1067131816u, 0, ATAN2_TOLERANCE, 0},
{1391, 1061997773u, 1051931443u, 1066681853u, 0, ATAN2_TOLERANCE, 0},
{1392, 1061997773u, 1053609165u, 1066252045u, 0, ATAN2_TOLERANCE, 0},
{1393, 1061997773u, 1055286886u, 1065843168u, 0, ATAN2_TOLERANCE, 0},
{1394, 1061997773u, 1056964608u, 1065455532u, 0, ATAN2_TOLERANCE, 0},
{1395, 1061997773u, 1057803469u, 1064824884u, 0, ATAN2_TOLERANCE, 0},
{1396, 1061997773u, 1058642330u, 1064133432u, 0, ATAN2_TOLERANCE, 0},
{1397, 1061997773u, 1059481190u, 1063482217u, 0, ATAN2_TOLERANCE, 0},
{1398, 1061997773u, 1060320051u, 1062869623u, 0, ATAN2_TOLERANCE, 0},
{1399, 1061997773u, 1061158912u, 1062293808u, 0, ATAN2_TOLERANCE, 0},
{1400, 1061997773u, 1061997773u, 1061752795u, 0, ATAN2_TOLERANCE, 0},
{1401, 1061997773u, 1062836634u, 1061244550u, 0, ATAN2_TOLERANCE, 0},
{1402, 1061997773u, 1063675494u, 1060767036u, 0, ATAN2_TOLERANCE, 0},
{1403, 1061997773u, 1064514355u, 1060318254u, 0, ATAN2_TOLERANCE, 0},
{1404, 1062836634u, 3212836864u, 1075575148u, 0, ATAN2_TOLERANCE, 0},
{1405, 1062836634u, 3211998003u, 1075468590u, 0, ATAN2_TOLERANCE, 0},
{1406, 1062836634u, 3211159142u, 1075355617u, 0, ATAN2_TOLERANCE, 0},
{1407, 1062836634u, 3210320282u, 1075235812u, 0, ATAN2_TOLERANCE, 0},
{1408, 1062836634u, 3209481421u, 1075108751u, 0, ATAN2_TOLERANCE, 0},
{1409, 1062836634u, 3208642560u, 1074974009u, 0, ATAN2_TOLERANCE, 0},
{1410, 1062836634u, 3207803699u, 1074831172u, 0, ATAN2_TOLERANCE, 0},
{1411, 1062836634u, 3206964838u, 1074679851u, 0, ATAN2_TOLERANCE, 0},
{1412, 1062836634u, 3206125978u, 1074519697u, 0, ATAN2_TOLERANCE, 0},
{1413, 1062836634u, 3205287117u, 1074350422u, 0, ATAN2_TOLERANCE, 0},
{1414, 1062836634u, 3204448256u, 1074171826u, 0, ATAN2_TOLERANCE, 0},
{1415, 1062836634u, 3202770534u, 1073983817u, 0, ATAN2_TOLERANCE, 0},
{1416, 1062836634u, 3201092813u, 1073786447u, 0, ATAN2_TOLERANCE, 0},
{1417, 1062836634u, 3199415091u, 1073418052u, 0, ATAN2_TOLERANCE, 0},
{1418, 1062836634u, 3197737370u, 1072987595u, 0, ATAN2_TOLERANCE, 0},
{1419, 1062836634u, 3196059648u, 1072540976u, 0, ATAN2_TOLERANCE, 0},
{1420, 1062836634u, 3192704205u, 1072079932u, 0, ATAN2_TOLERANCE, 0},
{1421, 1062836634u, 3189348762u, 1071606659u, 0, ATAN2_TOLERANCE, 0},
{1422, 1062836634u, 3184315597u, 1071123782u, 0, ATAN2_TOLERANCE, 0},
{1423, 1062836634u, 3175926989u, 1070634282u, 0, ATAN2_TOLERANCE, 0},
{1424, 1062836634u, 1028443341u, 1069648523u, 0, ATAN2_TOLERANCE, 0},
{1425, 1062836634u, 1036831949u, 1069159023u, 0, ATAN2_TOLERANCE, 0},
{1426, 1062836634u, 1041865114u, 1068676146u, 0, ATAN2_TOLERANCE, 0},
{1427, 1062836634u, 1045220557u, 1068202874u, 0, ATAN2_TOLERANCE, 0},
{1428, 1062836634u, 1048576000u, 1067741829u, 0, ATAN2_TOLERANCE, 0},
{1429, 1062836634u, 1050253722u, 1067295210u, 0, ATAN2_TOLERANCE, 0},
{1430, 1062836634u, 1051931443u, 1066864753u, 0, ATAN2_TOLERANCE, 0},
{1431, 1062836634u, 1053609165u, 1066451736u, 0, ATAN2_TOLERANCE, 0},
{1432, 1062836634u, 1055286886u, 1066056996u, 0, ATAN2_TOLERANCE, 0},
{1433, 1062836634u, 1056964608u, 1065680978u, 0, ATAN2_TOLERANCE, 0},
{1434, 1062836634u, 1057803469u, 1065294353u, 0, ATAN2_TOLERANCE, 0},
{1435, 1062836634u, 1058642330u, 1064617256u, 0, ATAN2_TOLERANCE, 0},
{1436, 1062836634u, 1059481190u, 1063976640u, 0, ATAN2_TOLERANCE, 0},
{1437, 1062836634u, 1060320051u, 1063371356u, 0, ATAN2_TOLERANCE, 0},
{1438, 1062836634u, 1061158912u, 1062800008u, 0, ATAN2_TOLERANCE, 0},
{1439, 1062836634u, 1061997773u, 1062261040u, 0, ATAN2_TOLERANCE, 0},
{1440, 1062836634u, 1062836634u, 1061752795u, 0, ATAN2_TOLERANCE, 0},
{1441, 1062836634u, 1063675494u, 1061273576u, 0, ATAN2_TOLERANCE, 0},
{1442, 1062836634u, 1064514355u, 1060821684u, 0, ATAN2_TOLERANCE, 0},
{1443, 1063675494u, 3212836864u, 1075456361u, 0, ATAN2_TOLERANCE, 0},
{1444, 1063675494u, 3211998003u, 1075349144u, 0, ATAN2_TOLERANCE, 0},
{1445, 1063675494u, 3211159142u, 1075235812u, 0, ATAN2_TOLERANCE, 0},
{1446, 1063675494u, 3210320282u, 1075116007u, 0, ATAN2_TOLERANCE, 0},
{1447, 1063675494u, 3209481421u, 1074989372u, 0, ATAN2_TOLERANCE, 0},
{1448, 1063675494u, 3208642560u, 1074855557u, 0, ATAN2_TOLERANCE, 0},
{1449, 1063675494u, 3207803699u, 1074714229u, 0, ATAN2_TOLERANCE, 0},
{1450, 1063675494u, 3206964838u, 1074565088u, 0, ATAN2_TOLERANCE, 0},
{1451, 1063675494u, 3206125978u, 1074407875u, 0, ATAN2_TOLERANCE, 0},
{1452, 1063675494u, 3205287117u, 1074242396u, 0, ATAN2_TOLERANCE, 0},
{1453, 1063675494u, 3204448256u, 1074068539u, 0, ATAN2_TOLERANCE, 0},
{1454, 1063675494u, 3202770534u, 1073886292u, 0, ATAN2_TOLERANCE, 0},
{1455, 1063675494u, 3201092813u, 1073649723u, 0, ATAN2_TOLERANCE, 0},
{1456, 1063675494u, 3199415091u, 1073252664u, 0, ATAN2_TOLERANCE, 0},
{1457, 1063675494u, 3197737370u, 1072840442u, 0, ATAN2_TOLERANCE, 0},
{1458, 1063675494u, 3196059648u, 1072414270u, 0, ATAN2_TOLERANCE, 0},
{1459, 1063675494u, 3192704205u, 1071975731u, 0, ATAN2_TOLERANCE, 0},
{1460, 1063675494u, 3189348762u, 1071526770u, 0, ATAN2_TOLERANCE, 0},
{1461, 1063675494u, 3184315597u, 1071069663u, 0, ATAN2_TOLERANCE, 0},
{1462, 1063675494u, 3175926989u, 1070606958u, 0, ATAN2_TOLERANCE, 0},
{1463, 1063675494u, 1028443341u, 1069675847u, 0, ATAN2_TOLERANCE, 0},
{1464, 1063675494u, 1036831949u, 1069213143u, 0, ATAN2_TOLERANCE, 0},
{1465, 1063675494u, 1041865114u, 1068756035u, 0, ATAN2_TOLERANCE, 0},
{1466, 1063675494u, 1045220557u, 1068307075u, 0, ATAN2_TOLERANCE, 0},
{1467, 1063675494u, 1048576000u, 1067868536u, 0, ATAN2_TOLERANCE, 0},
{1468, 1063675494u, 1050253722u, 1067442363u, 0, ATAN2_TOLERANCE, 0},
{1469, 1063675494u, 1051931443u, 1067030141u, 0, ATAN2_TOLERANCE, 0},
{1470, 1063675494u, 1053609165u, 1066633083u, 0, ATAN2_TOLERANCE, 0},
{1471, 1063675494u, 1055286886u, 1066252045u, 0, ATAN2_TOLERANCE, 0},
{1472, 1063675494u, 1056964608u, 1065887552u, 0, ATAN2_TOLERANCE, 0},
{1473, 1063675494u, 1057803469u, 1065539837u, 0, ATAN2_TOLERANCE, 0},
{1474, 1063675494u, 1058642330u, 1065064543u, 0, ATAN2_TOLERANCE, 0},
{1475, 1063675494u, 1059481190u, 1064435692u, 0, ATAN2_TOLERANCE, 0},
{1476, 1063675494u, 1060320051u, 1063839125u, 0, ATAN2_TOLERANCE, 0},
{1477, 1063675494u, 1061158912u, 1063273815u, 0, ATAN2_TOLERANCE, 0},
{1478, 1063675494u, 1061997773u, 1062738554u, 0, ATAN2_TOLERANCE, 0},
{1479, 1063675494u, 1062836634u, 1062232013u, 0, ATAN2_TOLERANCE, 0},
{1480, 1063675494u, 1063675494u, 1061752795u, 0, ATAN2_TOLERANCE, 0},
{1481, 1063675494u, 1064514355u, 1061299467u, 0, ATAN2_TOLERANCE, 0},
{1482, 1064514355u, 3212836864u, 1075343335u, 0, ATAN2_TOLERANCE, 0},
{1483, 1064514355u, 3211998003u, 1075235812u, 0, ATAN2_TOLERANCE, 0},
{1484, 1064514355u, 3211159142u, 1075122480u, 0, ATAN2_TOLERANCE, 0},
{1485, 1064514355u, 3210320282u, 1075003034u, 0, ATAN2_TOLERANCE, 0},
{1486, 1064514355u, 3209481421u, 1074877177u, 0, ATAN2_TOLERANCE, 0},
{1487, 1064514355u, 3208642560u, 1074744622u, 0, ATAN2_TOLERANCE, 0},
{1488, 1064514355u, 3207803699u, 1074605108u, 0, ATAN2_TOLERANCE, 0},
{1489, 1064514355u, 3206964838u, 1074458406u, 0, ATAN2_TOLERANCE, 0},
{1490, 1064514355u, 3206125978u, 1074304333u, 0, ATAN2_TOLERANCE, 0},
{1491, 1064514355u, 3205287117u, 1074142766u, 0, ATAN2_TOLERANCE, 0},
{1492, 1064514355u, 3204448256u, 1073973661u, 0, ATAN2_TOLERANCE, 0},
{1493, 1064514355u, 3202770534u, 1073797065u, 0, ATAN2_TOLERANCE, 0},
{1494, 1064514355u, 3201092813u, 1073484451u, 0, ATAN2_TOLERANCE, 0},
{1495, 1064514355u, 3199415091u, 1073102501u, 0, ATAN2_TOLERANCE, 0},
{1496, 1064514355u, 3197737370u, 1072707301u, 0, ATAN2_TOLERANCE, 0},
{1497, 1064514355u, 3196059648u, 1072299990u, 0, ATAN2_TOLERANCE, 0},
{1498, 1064514355u, 3192704205u, 1071882007u, 0, ATAN2_TOLERANCE, 0},
{1499, 1064514355u, 3189348762u, 1071455074u, 0, ATAN2_TOLERANCE, 0},
{1500, 1064514355u, 3184315597u, 1071021174u, 0, ATAN2_TOLERANCE, 0},
{1501, 1064514355u, 3175926989u, 1070582501u, 0, ATAN2_TOLERANCE, 0},
{1502, 1064514355u, 1028443341u, 1069700304u, 0, ATAN2_TOLERANCE, 0},
{1503, 1064514355u, 1036831949u, 1069261631u, 0, ATAN2_TOLERANCE, 0},
{1504, 1064514355u, 1041865114u, 1068827731u, 0, ATAN2_TOLERANCE, 0},
{1505, 1064514355u, 1045220557u, 1068400798u, 0, ATAN2_TOLERANCE, 0},
{1506, 1064514355u, 1048576000u, 1067982815u, 0, ATAN2_TOLERANCE, 0},
{1507, 1064514355u, 1050253722u, 1067575505u, 0, ATAN2_TOLERANCE, 0},
{1508, 1064514355u, 1051931443u, 1067180305u, 0, ATAN2_TOLERANCE, 0},
{1509, 1064514355u, 1053609165u, 1066798354u, 0, ATAN2_TOLERANCE, 0},
{1510, 1064514355u, 1055286886u, 1066430499u, 0, ATAN2_TOLERANCE, 0},
{1511, 1064514355u, 1056964608u, 1066077307u, 0, ATAN2_TOLERANCE, 0},
{1512, 1064514355u, 1057803469u, 1065739097u, 0, ATAN2_TOLERANCE, 0},
{1513, 1064514355u, 1058642330u, 1065415963u, 0, ATAN2_TOLERANCE, 0},
{1514, 1064514355u, 1059481190u, 1064862417u, 0, ATAN2_TOLERANCE, 0},
{1515, 1064514355u, 1060320051u, 1064275609u, 0, ATAN2_TOLERANCE, 0},
{1516, 1064514355u, 1061158912u, 1063717553u, 0, ATAN2_TOLERANCE, 0},
{1517, 1064514355u, 1061997773u, 1063187335u, 0, ATAN2_TOLERANCE, 0},
{1518, 1064514355u, 1062836634u, 1062683905u, 0, ATAN2_TOLERANCE, 0},
{1519, 1064514355u, 1063675494u, 1062206123u, 0, ATAN2_TOLERANCE, 0},
{1520, 1064514355u, 1064514355u, 1061752795u, 0, ATAN2_TOLERANCE, 0},
{1521, 1107800421u, 1203999711u, 967941446u, 0, ATAN2_TOLERANCE, 0},
{1522, 3196650934u, 896005582u, 3217625024u, 0, ATAN2_TOLERANCE, 0},
{1523, 3368700125u, 3308232444u, 3217681947u, 0, ATAN2_TOLERANCE, 0},
{1524, 1224242132u, 3061363425u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{1525, 1198712763u, 919636942u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{1526, 3090780435u, 1035260608u, 3120782230u, 0, ATAN2_TOLERANCE, 0},
{1527, 966554515u, 3234538174u, 1078529813u, 0, ATAN2_TOLERANCE, 0},
{1528, 1312607135u, 1194999402u, 1070140898u, 0, ATAN2_TOLERANCE, 0},
{1529, 1166191415u, 1018661564u, 1070141358u, 0, ATAN2_TOLERANCE, 0},
{1530, 3111900019u, 1130472166u, 3046038371u, 0, ATAN2_TOLERANCE, 0},
{1531, 1302107128u, 3370647675u, 1070153541u, 0, ATAN2_TOLERANCE, 0},
{1532, 1052801068u, 3039122570u, 1070141416u, 0, ATAN2_TOLERANCE, 0},
{1533, 1060849628u, 3081357692u, 1070141635u, 0, ATAN2_TOLERANCE, 0},
{1534, 3484320003u, 3033957825u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{1535, 3181522772u, 3305392896u, 3226013502u, 0, ATAN2_TOLERANCE, 0},
{1536, 968192794u, 878547432u, 1070136401u, 0, ATAN2_TOLERANCE, 0},
{1537, 3122346862u, 1111584337u, 3075305969u, 0, ATAN2_TOLERANCE, 0},
{1538, 3471653172u, 1154138102u, 3217625044u, 0, ATAN2_TOLERANCE, 0},
{1539, 3231467496u, 934336592u, 3217625014u, 0, ATAN2_TOLERANCE, 0},
{1540, 1341514497u, 3466051188u, 1071425492u, 0, ATAN2_TOLERANCE, 0},
{1541, 1272351391u, 3373485062u, 1070321354u, 0, ATAN2_TOLERANCE, 0},
{1542, 3319724992u, 3354615790u, 3225773741u, 0, ATAN2_TOLERANCE, 0},
{1543, 940236348u, 3304072663u, 1078530011u, 0, ATAN2_TOLERANCE, 0},
{1544, 3251541546u, 3174764041u, 3217639886u, 0, ATAN2_TOLERANCE, 0},
{1545, 3099843889u, 3355962282u, 3226013659u, 0, ATAN2_TOLERANCE, 0},
{1546, 3371863479u, 1014861921u, 3217625050u, 0, ATAN2_TOLERANCE, 0},
{1547, 3204069187u, 966573255u, 3217619919u, 0, ATAN2_TOLERANCE, 0},
{1548, 1306460502u, 903489435u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{1549, 1197542187u, 3024598921u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{1550, 1184239996u, 3224098462u, 1070142575u, 0, ATAN2_TOLERANCE, 0},
{1551, 1252490238u, 1173619825u, 1070129467u, 0, ATAN2_TOLERANCE, 0},
{1552, 1001673627u, 3462631271u, 1078530011u, 0, ATAN2_TOLERANCE, 0},
{1553, 976098044u, 1151967422u, 889412329u, 0, ATAN2_TOLERANCE, 0},
{1554, 941796645u, 886451963u, 1070055119u, 0, ATAN2_TOLERANCE, 0},
{1555, 1143233714u, 1007268238u, 1070141295u, 0, ATAN2_TOLERANCE, 0},
{1556, 1139941253u, 1147688821u, 1056305106u, 0, ATAN2_TOLERANCE, 0},
{1557, 3143717025u, 3234638157u, 3226011404u, 0, ATAN2_TOLERANCE, 0},
{1558, 3048866608u, 3449209899u, 3226013659u, 0, ATAN2_TOLERANCE, 0},
{1559, 3240298487u, 1020260821u, 3217604153u, 0, ATAN2_TOLERANCE, 0},
{1560, 1288902137u, 3123875978u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{1561, 1333134799u, 1338107877u, 1058060514u, 0, ATAN2_TOLERANCE, 0},
{1562, 1187847971u, 1317663644u, 935219985u, 0, ATAN2_TOLERANCE, 0},
{1563, 3329354473u, 3165437289u, 3217625062u, 0, ATAN2_TOLERANCE, 0},
{1564, 1309289088u, 1019883016u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{1565, 3444653659u, 1279248024u, 3215735586u, 0, ATAN2_TOLERANCE, 0},
{1566, 1106778573u, 3304487767u, 1078464050u, 0, ATAN2_TOLERANCE, 0},
{1567, 1140567947u, 3069174149u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{1568, 1238569473u, 873035665u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{1569, 1261071232u, 1182202773u, 1070129530u, 0, ATAN2_TOLERANCE, 0},
{1570, 1175011025u, 3029705783u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{1571, 1082692850u, 1211581107u, 935250732u, 0, ATAN2_TOLERANCE, 0},
{1572, 974547519u, 3475164509u, 1078530011u, 0, ATAN2_TOLERANCE, 0},
{1573, 3058097085u, 3104309359u, 3225917850u, 0, ATAN2_TOLERANCE, 0},
{1574, 3107252546u, 1071134451u, 3101045579u, 0, ATAN2_TOLERANCE, 0},
{1575, 3197942144u, 3094120030u, 3217626596u, 0, ATAN2_TOLERANCE, 0},
{1576, 3403348556u, 3184653669u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{1577, 3182301130u, 3460764044u, 3226013659u, 0, ATAN2_TOLERANCE, 0},
{1578, 1136411063u, 1118097422u, 1068333915u, 0, ATAN2_TOLERANCE, 0},
{1579, 3239231622u, 3302723069u, 3225991756u, 0, ATAN2_TOLERANCE, 0},
{1580, 3417964312u, 1321337529u, 3161810981u, 0, ATAN2_TOLERANCE, 0},
{1581, 3109481038u, 1143864063u, 3030261193u, 0, ATAN2_TOLERANCE, 0},
{1582, 1148867223u, 1256486202u, 957104149u, 0, ATAN2_TOLERANCE, 0},
{1583, 989687421u, 3372681320u, 1078530011u, 0, ATAN2_TOLERANCE, 0},
{1584, 1152956913u, 3166480640u, 1070141533u, 0, ATAN2_TOLERANCE, 0},
{1585, 892922651u, 3373029087u, 1078530011u, 0, ATAN2_TOLERANCE, 0},
{1586, 1307091856u, 1103202538u, 1070141402u, 0, ATAN2_TOLERANCE, 0},
{1587, 1077234132u, 3272167130u, 1078443495u, 0, ATAN2_TOLERANCE, 0},
{1588, 1142167709u, 1096445242u, 1069948119u, 0, ATAN2_TOLERANCE, 0},
{1589, 3426232834u, 1036705270u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{1590, 3368566779u, 967249167u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{1591, 3030724760u, 3349013503u, 3226013659u, 0, ATAN2_TOLERANCE, 0},
{1592, 1138741813u, 3073453199u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{1593, 982950501u, 982549888u, 1062100212u, 0, ATAN2_TOLERANCE, 0},
{1594, 1142981585u, 1015602236u, 1070141184u, 0, ATAN2_TOLERANCE, 0},
{1595, 3347165962u, 3135486696u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{1596, 1009535440u, 3381353228u, 1078530011u, 0, ATAN2_TOLERANCE, 0},
{1597, 3103736980u, 3402950505u, 3226013659u, 0, ATAN2_TOLERANCE, 0},
{1598, 3126820946u, 1077903063u, 3113575606u, 0, ATAN2_TOLERANCE, 0},
{1599, 3473956030u, 976891930u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{1600, 3349098349u, 1055327704u, 3217625004u, 0, ATAN2_TOLERANCE, 0},
{1601, 3152729489u, 1060398533u, 3156647575u, 0, ATAN2_TOLERANCE, 0},
{1602, 945568720u, 3313485084u, 1078530011u, 0, ATAN2_TOLERANCE, 0},
{1603, 3345489836u, 1108392401u, 3217619943u, 0, ATAN2_TOLERANCE, 0},
{1604, 976791751u, 3230678102u, 1078529355u, 0, ATAN2_TOLERANCE, 0},
{1605, 1004442355u, 3036510596u, 1070141986u, 0, ATAN2_TOLERANCE, 0},
{1606, 1108485380u, 3173536878u, 1070150838u, 0, ATAN2_TOLERANCE, 0},
{1607, 1061834641u, 972388096u, 1070136433u, 0, ATAN2_TOLERANCE, 0},
{1608, 3381268392u, 1146976802u, 3217618480u, 0, ATAN2_TOLERANCE, 0},
{1609, 3212952285u, 3329407365u, 3226013385u, 0, ATAN2_TOLERANCE, 0},
{1610, 3466188568u, 1041678304u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{1611, 3072456205u, 3160254633u, 3226010666u, 0, ATAN2_TOLERANCE, 0},
{1612, 3319315516u, 3422089012u, 3226012767u, 0, ATAN2_TOLERANCE, 0},
{1613, 3212614372u, 1152633030u, 3123959940u, 0, ATAN2_TOLERANCE, 0},
{1614, 1315030230u, 3336225884u, 1070141651u, 0, ATAN2_TOLERANCE, 0},
{1615, 1134593658u, 3456812581u, 1078530008u, 0, ATAN2_TOLERANCE, 0},
{1616, 977281449u, 879922831u, 1070138817u, 0, ATAN2_TOLERANCE, 0},
{1617, 1086198791u, 920125958u, 1070141394u, 0, ATAN2_TOLERANCE, 0},
{1618, 1135271264u, 3284878412u, 1075598160u, 0, ATAN2_TOLERANCE, 0},
{1619, 1094190727u, 1056854532u, 1069779349u, 0, ATAN2_TOLERANCE, 0},
{1620, 1294665325u, 991185677u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{1621, 3439134022u, 1043829691u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{1622, 1325668223u, 970681762u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{1623, 1092037607u, 1027330835u, 1070100690u, 0, ATAN2_TOLERANCE, 0},
{1624, 3316278408u, 3455589207u, 3226013615u, 0, ATAN2_TOLERANCE, 0},
{1625, 3295436768u, 3129873731u, 3217625060u, 0, ATAN2_TOLERANCE, 0},
{1626, 1151984049u, 3074547120u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{1627, 1129287043u, 3076527544u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{1628, 1243664530u, 972879810u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{1629, 950829092u, 929114193u, 1068784696u, 0, ATAN2_TOLERANCE, 0},
{1630, 1115471979u, 3047246262u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{1631, 3351092088u, 3024661404u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{1632, 3424479544u, 3312047722u, 3217625811u, 0, ATAN2_TOLERANCE, 0},
{1633, 3241193975u, 884465785u, 3217625050u, 0, ATAN2_TOLERANCE, 0},
{1634, 1030934236u, 1045139240u, 1049911720u, 0, ATAN2_TOLERANCE, 0},
{1635, 3131791114u, 3408392958u, 3226013659u, 0, ATAN2_TOLERANCE, 0},
{1636, 1025254314u, 3057812821u, 1070142040u, 0, ATAN2_TOLERANCE, 0},
{1637, 1110545760u, 3240144177u, 1072007490u, 0, ATAN2_TOLERANCE, 0},
{1638, 3180213739u, 1108793820u, 3136378415u, 0, ATAN2_TOLERANCE, 0},
{1639, 3361976590u, 3138179993u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{1640, 881280146u, 3421884736u, 1078530011u, 0, ATAN2_TOLERANCE, 0},
{1641, 3264443610u, 3222916705u, 3217898386u, 0, ATAN2_TOLERANCE, 0},
{1642, 3374550627u, 3055856293u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{1643, 899599265u, 3240118211u, 1078530010u, 0, ATAN2_TOLERANCE, 0},
{1644, 1268194719u, 1332489410u, 1000590502u, 0, ATAN2_TOLERANCE, 0},
{1645, 1133420220u, 1245770860u, 951924760u, 0, ATAN2_TOLERANCE, 0},
{1646, 3295996963u, 3453334307u, 3226013649u, 0, ATAN2_TOLERANCE, 0},
{1647, 1270887389u, 1156123987u, 1070140782u, 0, ATAN2_TOLERANCE, 0},
{1648, 3325193181u, 993979179u, 3217625048u, 0, ATAN2_TOLERANCE, 0},
{1649, 3116607482u, 3224327456u, 3226013087u, 0, ATAN2_TOLERANCE, 0},
{1650, 3187892415u, 3118097315u, 3217652286u, 0, ATAN2_TOLERANCE, 0},
{1651, 1189120494u, 978961471u, 1070141402u, 0, ATAN2_TOLERANCE, 0},
{1652, 889030794u, 3129523970u, 1078528112u, 0, ATAN2_TOLERANCE, 0},
{1653, 1323529208u, 3100744786u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{1654, 3465768388u, 3190881451u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{1655, 3426099899u, 1118756120u, 3217625035u, 0, ATAN2_TOLERANCE, 0},
{1656, 3224857113u, 3398166843u, 3226013656u, 0, ATAN2_TOLERANCE, 0},
{1657, 3357819026u, 3148475462u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{1658, 1273397670u, 901308750u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{1659, 3424831780u, 1304806106u, 3184655445u, 0, ATAN2_TOLERANCE, 0},
{1660, 1257596246u, 3420832544u, 1077435618u, 0, ATAN2_TOLERANCE, 0},
{1661, 1051773536u, 896271348u, 1070141381u, 0, ATAN2_TOLERANCE, 0},
{1662, 3294752507u, 3113225954u, 3217625053u, 0, ATAN2_TOLERANCE, 0},
{1663, 1090870906u, 3294742905u, 1078491301u, 0, ATAN2_TOLERANCE, 0},
{1664, 1227582289u, 1208979668u, 1068410023u, 0, ATAN2_TOLERANCE, 0},
{1665, 1137854355u, 3335041917u, 1078461353u, 0, ATAN2_TOLERANCE, 0},
{1666, 3440773058u, 3204192793u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{1667, 3101598400u, 3057760708u, 3217853098u, 0, ATAN2_TOLERANCE, 0},
{1668, 3451216836u, 3347783723u, 3217626621u, 0, ATAN2_TOLERANCE, 0},
{1669, 3437062994u, 3106834845u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{1670, 1131196082u, 1164573183u, 1031884516u, 0, ATAN2_TOLERANCE, 0},
{1671, 3460915348u, 1219372260u, 3217621509u, 0, ATAN2_TOLERANCE, 0},
{1672, 3303035472u, 3153013020u, 3217625085u, 0, ATAN2_TOLERANCE, 0},
{1673, 1053698677u, 3284313107u, 1078525672u, 0, ATAN2_TOLERANCE, 0},
{1674, 3396166221u, 1201894512u, 3217444575u, 0, ATAN2_TOLERANCE, 0},
{1675, 3458934263u, 1005577835u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{1676, 1065761827u, 3333928591u, 1078529824u, 0, ATAN2_TOLERANCE, 0},
{1677, 926665223u, 3150815797u, 1078522530u, 0, ATAN2_TOLERANCE, 0},
{1678, 1199816046u, 3143776186u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{1679, 3333779015u, 952421041u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{1680, 948398145u, 3238273189u, 1078529978u, 0, ATAN2_TOLERANCE, 0},
{1681, 1080781593u, 1213908300u, 931773831u, 0, ATAN2_TOLERANCE, 0},
{1682, 3235326590u, 1271705594u, 3028716927u, 0, ATAN2_TOLERANCE, 0},
{1683, 3118883815u, 1051802647u, 3131466655u, 0, ATAN2_TOLERANCE, 0},
{1684, 3226990408u, 1110755136u, 3180896673u, 0, ATAN2_TOLERANCE, 0},
{1685, 3117098218u, 1122474770u, 3059780203u, 0, ATAN2_TOLERANCE, 0},
{1686, 1283624229u, 906796922u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{1687, 970649315u, 1078286437u, 957218953u, 0, ATAN2_TOLERANCE, 0},
{1688, 959776291u, 3280345347u, 1078530008u, 0, ATAN2_TOLERANCE, 0},
{1689, 3341117305u, 3294559023u, 3217801722u, 0, ATAN2_TOLERANCE, 0},
{1690, 1270734970u, 3355874874u, 1070187855u, 0, ATAN2_TOLERANCE, 0},
{1691, 1106502045u, 1290849316u, 880911273u, 0, ATAN2_TOLERANCE, 0},
{1692, 1157598381u, 3309023746u, 1076023102u, 0, ATAN2_TOLERANCE, 0},
{1693, 3335234513u, 1002337336u, 3217625049u, 0, ATAN2_TOLERANCE, 0},
{1694, 1279489061u, 1006049444u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{1695, 3143920719u, 3131608518u, 3220590061u, 0, ATAN2_TOLERANCE, 0},
{1696, 1148920078u, 1007674793u, 1070141329u, 0, ATAN2_TOLERANCE, 0},
{1697, 3064988156u, 3230867340u, 3226013654u, 0, ATAN2_TOLERANCE, 0},
{1698, 1109198803u, 1221754614u, 952039946u, 0, ATAN2_TOLERANCE, 0},
{1699, 3219949483u, 1056167693u, 3215509131u, 0, ATAN2_TOLERANCE, 0},
{1700, 3361149474u, 3387342069u, 3225527164u, 0, ATAN2_TOLERANCE, 0},
{1701, 1207502108u, 3388073586u, 1078260522u, 0, ATAN2_TOLERANCE, 0},
{1702, 3161756316u, 3143659754u, 3219516841u, 0, ATAN2_TOLERANCE, 0},
{1703, 3160728744u, 3382954009u, 3226013659u, 0, ATAN2_TOLERANCE, 0},
{1704, 1234530539u, 1079988872u, 1070141379u, 0, ATAN2_TOLERANCE, 0},
{1705, 1017843965u, 1193076204u, 889949957u, 0, ATAN2_TOLERANCE, 0},
{1706, 3306328852u, 1118701064u, 3217313958u, 0, ATAN2_TOLERANCE, 0},
{1707, 1291910469u, 1211303367u, 1070130033u, 0, ATAN2_TOLERANCE, 0},
{1708, 1131927531u, 3182962700u, 1070144446u, 0, ATAN2_TOLERANCE, 0},
{1709, 3449879391u, 991614550u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{1710, 970094304u, 3344590506u, 1078530011u, 0, ATAN2_TOLERANCE, 0},
{1711, 1125551064u, 3331248076u, 1078495469u, 0, ATAN2_TOLERANCE, 0},
{1712, 3427296372u, 3455289118u, 3225583748u, 0, ATAN2_TOLERANCE, 0},
{1713, 1198917460u, 1327195159u, 936028460u, 0, ATAN2_TOLERANCE, 0},
{1714, 3114686212u, 3476082461u, 3226013659u, 0, ATAN2_TOLERANCE, 0},
{1715, 3393557778u, 3383396815u, 3221042705u, 0, ATAN2_TOLERANCE, 0},
{1716, 1276853215u, 873199561u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{1717, 3462778440u, 3349284325u, 3217625773u, 0, ATAN2_TOLERANCE, 0},
{1718, 3360170117u, 3048354042u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{1719, 3224245428u, 3271307999u, 3225923200u, 0, ATAN2_TOLERANCE, 0},
{1720, 1120124467u, 1135619937u, 1049278053u, 0, ATAN2_TOLERANCE, 0},
{1721, 1064364381u, 3180675544u, 1070789756u, 0, ATAN2_TOLERANCE, 0},
{1722, 1268744779u, 3328452652u, 1070147261u, 0, ATAN2_TOLERANCE, 0},
{1723, 1165195428u, 3390323168u, 1078523283u, 0, ATAN2_TOLERANCE, 0},
{1724, 3247790039u, 909788142u, 3217625049u, 0, ATAN2_TOLERANCE, 0},
{1725, 3215244648u, 1083988595u, 3196313290u, 0, ATAN2_TOLERANCE, 0},
{1726, 3095275931u, 989153382u, 3171194471u, 0, ATAN2_TOLERANCE, 0},
{1727, 3275973009u, 3450721670u, 3226013656u, 0, ATAN2_TOLERANCE, 0},
{1728, 3028857014u, 3188853813u, 3226013651u, 0, ATAN2_TOLERANCE, 0},
{1729, 3391162308u, 1291220039u, 3165077124u, 0, ATAN2_TOLERANCE, 0},
{1730, 1044867873u, 3369493273u, 1078530009u, 0, ATAN2_TOLERANCE, 0},
{1731, 1089986803u, 3462160118u, 1078530011u, 0, ATAN2_TOLERANCE, 0},
{1732, 1251462432u, 3171021770u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{1733, 3485236902u, 980772835u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{1734, 3262169538u, 1268270462u, 3058327958u, 0, ATAN2_TOLERANCE, 0},
{1735, 3080852256u, 994641495u, 3150865718u, 0, ATAN2_TOLERANCE, 0},
{1736, 1022211242u, 922124181u, 1070139279u, 0, ATAN2_TOLERANCE, 0},
{1737, 3071422941u, 3271100396u, 3226013658u, 0, ATAN2_TOLERANCE, 0},
{1738, 989762529u, 3362011135u, 1078530011u, 0, ATAN2_TOLERANCE, 0},
{1739, 1295475718u, 3212305413u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{1740, 1002632518u, 3330388441u, 1078530009u, 0, ATAN2_TOLERANCE, 0},
{1741, 3404372005u, 3450484255u, 3225923347u, 0, ATAN2_TOLERANCE, 0},
{1742, 3158912530u, 3105501826u, 3217725508u, 0, ATAN2_TOLERANCE, 0},
{1743, 1125800069u, 3256265749u, 1072149389u, 0, ATAN2_TOLERANCE, 0},
{1744, 3138037576u, 3103365227u, 3218096449u, 0, ATAN2_TOLERANCE, 0},
{1745, 999985470u, 3409354318u, 1078530011u, 0, ATAN2_TOLERANCE, 0},
{1746, 1189421739u, 1056599002u, 1070141263u, 0, ATAN2_TOLERANCE, 0},
{1747, 3075182644u, 3144159778u, 3225999287u, 0, ATAN2_TOLERANCE, 0},
{1748, 3028099649u, 3391513557u, 3226013659u, 0, ATAN2_TOLERANCE, 0},
{1749, 3132541814u, 3444521949u, 3226013659u, 0, ATAN2_TOLERANCE, 0},
{1750, 1164046161u, 3440635788u, 1078529913u, 0, ATAN2_TOLERANCE, 0},
{1751, 1292596266u, 3116569667u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{1752, 3469748379u, 3412765608u, 3217698932u, 0, ATAN2_TOLERANCE, 0},
{1753, 1314644642u, 3123051784u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{1754, 948775569u, 3485444126u, 1078530011u, 0, ATAN2_TOLERANCE, 0},
{1755, 1034611395u, 882288581u, 1070141374u, 0, ATAN2_TOLERANCE, 0},
{1756, 3489122735u, 3372450889u, 3217625594u, 0, ATAN2_TOLERANCE, 0},
{1757, 1181604787u, 3363067409u, 1078275131u, 0, ATAN2_TOLERANCE, 0},
{1758, 3059042077u, 3204983963u, 3226013634u, 0, ATAN2_TOLERANCE, 0},
{1759, 1043691622u, 3402603223u, 1078530011u, 0, ATAN2_TOLERANCE, 0},
{1760, 3157534378u, 3451674717u, 3226013659u, 0, ATAN2_TOLERANCE, 0},
{1761, 3400949680u, 3073750220u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{1762, 3365581801u, 1175843167u, 3217371050u, 0, ATAN2_TOLERANCE, 0},
{1763, 3189917167u, 927278934u, 3217624429u, 0, ATAN2_TOLERANCE, 0},
{1764, 969804941u, 3355439348u, 1078530011u, 0, ATAN2_TOLERANCE, 0},
{1765, 1139120919u, 3270515074u, 1072286397u, 0, ATAN2_TOLERANCE, 0},
{1766, 934308144u, 3118191228u, 1078319812u, 0, ATAN2_TOLERANCE, 0},
{1767, 1220524226u, 1152648002u, 1070110636u, 0, ATAN2_TOLERANCE, 0},
{1768, 3162548604u, 3461790298u, 3226013659u, 0, ATAN2_TOLERANCE, 0},
{1769, 3382391700u, 3296962745u, 3217632000u, 0, ATAN2_TOLERANCE, 0},
{1770, 1156767533u, 1088986462u, 1070110019u, 0, ATAN2_TOLERANCE, 0},
{1771, 3079222483u, 3312324949u, 3226013659u, 0, ATAN2_TOLERANCE, 0},
{1772, 994934087u, 967678094u, 1069258844u, 0, ATAN2_TOLERANCE, 0},
{1773, 3185240099u, 1123403720u, 3127116361u, 0, ATAN2_TOLERANCE, 0},
{1774, 3479873563u, 1246277393u, 3217618045u, 0, ATAN2_TOLERANCE, 0},
{1775, 3424264117u, 3434026174u, 3224274563u, 0, ATAN2_TOLERANCE, 0},
{1776, 3228365887u, 1216775310u, 3076618514u, 0, ATAN2_TOLERANCE, 0},
{1777, 3125775254u, 955826310u, 3216377565u, 0, ATAN2_TOLERANCE, 0},
{1778, 1037464105u, 3121544932u, 1070185103u, 0, ATAN2_TOLERANCE, 0},
{1779, 1311706596u, 1254918706u, 1070064830u, 0, ATAN2_TOLERANCE, 0},
{1780, 918212457u, 1017468331u, 965779528u, 0, ATAN2_TOLERANCE, 0},
{1781, 1337315179u, 3461361185u, 1071333966u, 0, ATAN2_TOLERANCE, 0},
{1782, 1131358407u, 3325958870u, 1078447574u, 0, ATAN2_TOLERANCE, 0},
{1783, 1156517523u, 3343716230u, 1078377276u, 0, ATAN2_TOLERANCE, 0},
{1784, 3210802820u, 3207408574u, 3222176882u, 0, ATAN2_TOLERANCE, 0},
{1785, 3337499209u, 1226297264u, 3175656659u, 0, ATAN2_TOLERANCE, 0},
{1786, 3468429030u, 3253874001u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{1787, 3253515800u, 1189005947u, 3129474916u, 0, ATAN2_TOLERANCE, 0},
{1788, 3055299953u, 3047908678u, 3221530216u, 0, ATAN2_TOLERANCE, 0},
{1789, 959956547u, 876324728u, 1070133038u, 0, ATAN2_TOLERANCE, 0},
{1790, 3425290480u, 1139193797u, 3217624964u, 0, ATAN2_TOLERANCE, 0},
{1791, 1039917375u, 1122740999u, 982044192u, 0, ATAN2_TOLERANCE, 0},
{1792, 3220979495u, 3429223871u, 3226013658u, 0, ATAN2_TOLERANCE, 0},
{1793, 1311016004u, 3334899880u, 1070141712u, 0, ATAN2_TOLERANCE, 0},
{1794, 1128016396u, 1105151547u, 1068906176u, 0, ATAN2_TOLERANCE, 0},
{1795, 3210335769u, 3100646155u, 3217626029u, 0, ATAN2_TOLERANCE, 0},
{1796, 3022705759u, 3404762495u, 3226013659u, 0, ATAN2_TOLERANCE, 0},
{1797, 3144504834u, 1162227076u, 3046722218u, 0, ATAN2_TOLERANCE, 0},
{1798, 1213609983u, 919983950u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{1799, 1246902946u, 3064047808u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{1800, 3362082828u, 3374056268u, 3224536668u, 0, ATAN2_TOLERANCE, 0},
{1801, 1029480631u, 3047777170u, 1070141599u, 0, ATAN2_TOLERANCE, 0},
{1802, 3153568584u, 3106514232u, 3217804606u, 0, ATAN2_TOLERANCE, 0},
{1803, 3384988527u, 3109485565u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{1804, 3235395924u, 1132055244u, 3168635683u, 0, ATAN2_TOLERANCE, 0},
{1805, 1228636133u, 886552820u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{1806, 3161654634u, 3335899347u, 3226013656u, 0, ATAN2_TOLERANCE, 0},
{1807, 3162655243u, 3307203982u, 3226013633u, 0, ATAN2_TOLERANCE, 0},
{1808, 1165476654u, 3350219111u, 1078345914u, 0, ATAN2_TOLERANCE, 0},
{1809, 1017239798u, 3438501281u, 1078530011u, 0, ATAN2_TOLERANCE, 0},
{1810, 1149651309u, 970030475u, 1070141400u, 0, ATAN2_TOLERANCE, 0},
{1811, 1111943722u, 3122211334u, 1070141501u, 0, ATAN2_TOLERANCE, 0},
{1812, 1189849849u, 3382739134u, 1078433800u, 0, ATAN2_TOLERANCE, 0},
{1813, 3204848496u, 3141519085u, 3217671909u, 0, ATAN2_TOLERANCE, 0},
{1814, 1249758327u, 3104759211u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{1815, 3092982276u, 3445282331u, 3226013659u, 0, ATAN2_TOLERANCE, 0},
{1816, 1168098747u, 1316854744u, 916539235u, 0, ATAN2_TOLERANCE, 0},
{1817, 3301009024u, 3406174560u, 3226012920u, 0, ATAN2_TOLERANCE, 0},
{1818, 3233089227u, 1212652543u, 3085445853u, 0, ATAN2_TOLERANCE, 0},
{1819, 3218245284u, 1238873830u, 3044661167u, 0, ATAN2_TOLERANCE, 0},
{1820, 3215981890u, 3240474694u, 3225460117u, 0, ATAN2_TOLERANCE, 0},
{1821, 1266687209u, 3092038122u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{1822, 3487959775u, 3331372071u, 3217625071u, 0, ATAN2_TOLERANCE, 0},
{1823, 3345065699u, 3282620725u, 3217674080u, 0, ATAN2_TOLERANCE, 0},
{1824, 935847271u, 1067255804u, 933425332u, 0, ATAN2_TOLERANCE, 0},
{1825, 3410336089u, 1111437780u, 3217625020u, 0, ATAN2_TOLERANCE, 0},
{1826, 1141063391u, 1168908072u, 1036164544u, 0, ATAN2_TOLERANCE, 0},
{1827, 3059263153u, 3067795684u, 3224085849u, 0, ATAN2_TOLERANCE, 0},
{1828, 3353679791u, 897158391u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{1829, 1001823878u, 1016826861u, 1049766982u, 0, ATAN2_TOLERANCE, 0},
{1830, 1009130212u, 1004302940u, 1065100489u, 0, ATAN2_TOLERANCE, 0},
{1831, 3367127535u, 943136342u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{1832, 1032920919u, 3449126417u, 1078530011u, 0, ATAN2_TOLERANCE, 0},
{1833, 3281952870u, 3147012185u, 3217625170u, 0, ATAN2_TOLERANCE, 0},
{1834, 1237868497u, 3048281802u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{1835, 1153753924u, 3322269242u, 1077767076u, 0, ATAN2_TOLERANCE, 0},
{1836, 1120261759u, 892210998u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{1837, 3226328360u, 3366432856u, 3226013619u, 0, ATAN2_TOLERANCE, 0},
{1838, 3349595986u, 3251588707u, 3217627596u, 0, ATAN2_TOLERANCE, 0},
{1839, 3166889490u, 3306023523u, 3226013615u, 0, ATAN2_TOLERANCE, 0},
{1840, 1087750238u, 1099325523u, 1052887712u, 0, ATAN2_TOLERANCE, 0},
{1841, 3121620061u, 3359488363u, 3226013659u, 0, ATAN2_TOLERANCE, 0},
{1842, 1066116543u, 3072159933u, 1070141475u, 0, ATAN2_TOLERANCE, 0},
{1843, 3051923237u, 3364074347u, 3226013659u, 0, ATAN2_TOLERANCE, 0},
{1844, 1030612298u, 3345396001u, 1078530007u, 0, ATAN2_TOLERANCE, 0},
{1845, 1331680743u, 1009396165u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{1846, 1045232522u, 3234993273u, 1078402159u, 0, ATAN2_TOLERANCE, 0},
{1847, 3119858470u, 962515365u, 3214048321u, 0, ATAN2_TOLERANCE, 0},
{1848, 3349432725u, 928848003u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{1849, 912423027u, 3184646319u, 1078529872u, 0, ATAN2_TOLERANCE, 0},
{1850, 3228795133u, 3273940030u, 3225916583u, 0, ATAN2_TOLERANCE, 0},
{1851, 3194674746u, 3112269709u, 3217634082u, 0, ATAN2_TOLERANCE, 0},
{1852, 3296784303u, 3276182352u, 3219220450u, 0, ATAN2_TOLERANCE, 0},
{1853, 965402291u, 3107104376u, 1074339079u, 0, ATAN2_TOLERANCE, 0},
{1854, 3388153589u, 3426245389u, 3225840904u, 0, ATAN2_TOLERANCE, 0},
{1855, 1133410485u, 3329658993u, 1078454282u, 0, ATAN2_TOLERANCE, 0},
{1856, 3136790322u, 1088652637u, 3112914680u, 0, ATAN2_TOLERANCE, 0},
{1857, 3369970587u, 959121458u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{1858, 1270451568u, 928393353u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{1859, 989498922u, 3088358419u, 1070296868u, 0, ATAN2_TOLERANCE, 0},
{1860, 1280215674u, 3148135875u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{1861, 1171873518u, 954709738u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{1862, 3298258100u, 935525182u, 3217625050u, 0, ATAN2_TOLERANCE, 0},
{1863, 1001897182u, 3191875320u, 1078404716u, 0, ATAN2_TOLERANCE, 0},
{1864, 3152777939u, 3245830463u, 3226011709u, 0, ATAN2_TOLERANCE, 0},
{1865, 985903305u, 3333087577u, 1078530010u, 0, ATAN2_TOLERANCE, 0},
{1866, 982612185u, 923582663u, 1070077994u, 0, ATAN2_TOLERANCE, 0},
{1867, 3267868136u, 1208301947u, 3124748530u, 0, ATAN2_TOLERANCE, 0},
{1868, 3319048157u, 1172271145u, 3208821711u, 0, ATAN2_TOLERANCE, 0},
{1869, 3301461672u, 1233693827u, 3132856391u, 0, ATAN2_TOLERANCE, 0},
{1870, 3364525678u, 3089849671u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{1871, 3146660041u, 3143695961u, 3222232199u, 0, ATAN2_TOLERANCE, 0},
{1872, 3467121799u, 3023584354u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{1873, 1151257041u, 3084216427u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{1874, 3097873255u, 3219266640u, 3226013471u, 0, ATAN2_TOLERANCE, 0},
{1875, 3130670309u, 3192399254u, 3225988407u, 0, ATAN2_TOLERANCE, 0},
{1876, 1017573824u, 3130901062u, 1070636269u, 0, ATAN2_TOLERANCE, 0},
{1877, 1258369714u, 3462258576u, 1078491850u, 0, ATAN2_TOLERANCE, 0},
{1878, 1216602683u, 3371396332u, 1076447486u, 0, ATAN2_TOLERANCE, 0},
{1879, 3297265739u, 1214184410u, 3147593150u, 0, ATAN2_TOLERANCE, 0},
{1880, 1071940738u, 3311731012u, 1078527967u, 0, ATAN2_TOLERANCE, 0},
{1881, 922601356u, 3337171870u, 1078530011u, 0, ATAN2_TOLERANCE, 0},
{1882, 3462285635u, 3444030332u, 3219478650u, 0, ATAN2_TOLERANCE, 0},
{1883, 3357177805u, 1085464241u, 3217624754u, 0, ATAN2_TOLERANCE, 0},
{1884, 3049120080u, 900832851u, 3209796011u, 0, ATAN2_TOLERANCE, 0},
{1885, 1153863660u, 1011991342u, 1070141335u, 0, ATAN2_TOLERANCE, 0},
{1886, 3034243695u, 917098003u, 3181683726u, 0, ATAN2_TOLERANCE, 0},
{1887, 1249365132u, 3278686216u, 1070141892u, 0, ATAN2_TOLERANCE, 0},
{1888, 3046215730u, 3211219980u, 3226013654u, 0, ATAN2_TOLERANCE, 0},
{1889, 3047251716u, 1090787353u, 3021758111u, 0, ATAN2_TOLERANCE, 0},
{1890, 3131219358u, 3471261157u, 3226013659u, 0, ATAN2_TOLERANCE, 0},
{1891, 3222096285u, 1198013705u, 3088825940u, 0, ATAN2_TOLERANCE, 0},
{1892, 1297708818u, 3079166173u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{1893, 3345532722u, 3383708463u, 3225839704u, 0, ATAN2_TOLERANCE, 0},
{1894, 3418753236u, 3481843070u, 3225989925u, 0, ATAN2_TOLERANCE, 0},
{1895, 1277417964u, 3487506626u, 1078505948u, 0, ATAN2_TOLERANCE, 0},
{1896, 987577257u, 1152077087u, 900026212u, 0, ATAN2_TOLERANCE, 0},
{1897, 3161606610u, 3190282989u, 3225636292u, 0, ATAN2_TOLERANCE, 0},
{1898, 888030585u, 3062367380u, 1078072618u, 0, ATAN2_TOLERANCE, 0},
{1899, 1043442869u, 3311393817u, 1078529807u, 0, ATAN2_TOLERANCE, 0},
{1900, 3320923228u, 3464544249u, 3226013629u, 0, ATAN2_TOLERANCE, 0},
{1901, 1337400405u, 3488844154u, 1075825929u, 0, ATAN2_TOLERANCE, 0},
{1902, 3400348640u, 3129868490u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{1903, 1250249095u, 1069023744u, 1070141400u, 0, ATAN2_TOLERANCE, 0},
{1904, 3284411233u, 1173613526u, 3175984512u, 0, ATAN2_TOLERANCE, 0},
{1905, 1215968622u, 3469884568u, 1078529401u, 0, ATAN2_TOLERANCE, 0},
{1906, 3061638260u, 3116222327u, 3225969995u, 0, ATAN2_TOLERANCE, 0},
{1907, 1025404104u, 1066370251u, 1024277766u, 0, ATAN2_TOLERANCE, 0},
{1908, 3138086437u, 3195983510u, 3225977811u, 0, ATAN2_TOLERANCE, 0},
{1909, 3091024506u, 3456196859u, 3226013659u, 0, ATAN2_TOLERANCE, 0},
{1910, 3362748242u, 3369843597u, 3223921029u, 0, ATAN2_TOLERANCE, 0},
{1911, 3099671635u, 3218383623u, 3226013426u, 0, ATAN2_TOLERANCE, 0},
{1912, 1252237719u, 1121169249u, 1070141237u, 0, ATAN2_TOLERANCE, 0},
{1913, 3327895594u, 1224511805u, 3168704100u, 0, ATAN2_TOLERANCE, 0},
{1914, 3082454432u, 889268276u, 3217443557u, 0, ATAN2_TOLERANCE, 0},
{1915, 3396161504u, 1182798837u, 3217589681u, 0, ATAN2_TOLERANCE, 0},
{1916, 1099710167u, 887180181u, 1070141402u, 0, ATAN2_TOLERANCE, 0},
{1917, 1157186482u, 1288722647u, 932782932u, 0, ATAN2_TOLERANCE, 0},
{1918, 1282110851u, 3176633124u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{1919, 3477008113u, 1331845018u, 3207816178u, 0, ATAN2_TOLERANCE, 0},
{1920, 3292127294u, 3409957764u, 3226013411u, 0, ATAN2_TOLERANCE, 0},
{1921, 1123357102u, 3281307320u, 1076891530u, 0, ATAN2_TOLERANCE, 0},
{1922, 1106837025u, 3088080674u, 1070141412u, 0, ATAN2_TOLERANCE, 0},
{1923, 1049949008u, 1130799489u, 983913904u, 0, ATAN2_TOLERANCE, 0},
{1924, 1253017688u, 942062372u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{1925, 1108543194u, 3281299199u, 1078014074u, 0, ATAN2_TOLERANCE, 0},
{1926, 1160162706u, 1264067367u, 960850742u, 0, ATAN2_TOLERANCE, 0},
{1927, 3438080027u, 3107114149u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{1928, 3344574751u, 3111270744u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{1929, 1152416724u, 962669179u, 1070141401u, 0, ATAN2_TOLERANCE, 0},
{1930, 1218239308u, 1126238113u, 1070137198u, 0, ATAN2_TOLERANCE, 0},
{1931, 3263310567u, 1030748197u, 3217617499u, 0, ATAN2_TOLERANCE, 0},
{1932, 972485427u, 1124312043u, 913317624u, 0, ATAN2_TOLERANCE, 0},
{1933, 3290264612u, 1124703898u, 3215820437u, 0, ATAN2_TOLERANCE, 0},
{1934, 3222106584u, 1183748648u, 3103652430u, 0, ATAN2_TOLERANCE, 0},
{1935, 947914771u, 3181847068u, 1078526873u, 0, ATAN2_TOLERANCE, 0},
{1936, 3167730654u, 3195765940u, 3225582168u, 0, ATAN2_TOLERANCE, 0},
{1937, 1098530298u, 3255870890u, 1076817855u, 0, ATAN2_TOLERANCE, 0},
{1938, 1277649137u, 961171401u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{1939, 3090306474u, 3124785016u, 3225770994u, 0, ATAN2_TOLERANCE, 0},
{1940, 3244032016u, 3045313345u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{1941, 3033122376u, 3049877065u, 3224984460u, 0, ATAN2_TOLERANCE, 0},
{1942, 1096155623u, 1256423752u, 904974295u, 0, ATAN2_TOLERANCE, 0},
{1943, 873151908u, 3246562559u, 1078530011u, 0, ATAN2_TOLERANCE, 0},
{1944, 3317196817u, 989537151u, 3217625048u, 0, ATAN2_TOLERANCE, 0},
{1945, 3345634950u, 959901149u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{1946, 3189860276u, 883598767u, 3217625034u, 0, ATAN2_TOLERANCE, 0},
{1947, 3396917283u, 3066326686u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{1948, 3317032737u, 3143803722u, 3217625056u, 0, ATAN2_TOLERANCE, 0},
{1949, 1200051436u, 1163802508u, 1069711335u, 0, ATAN2_TOLERANCE, 0},
{1950, 1306520561u, 957302464u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{1951, 3475052219u, 1284049853u, 3217402085u, 0, ATAN2_TOLERANCE, 0},
{1952, 3085636260u, 1107682820u, 3043014567u, 0, ATAN2_TOLERANCE, 0},
{1953, 3393227708u, 3271879112u, 3217625404u, 0, ATAN2_TOLERANCE, 0},
{1954, 3349005404u, 3080993030u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{1955, 3154720153u, 3443720494u, 3226013659u, 0, ATAN2_TOLERANCE, 0},
{1956, 1262863321u, 1219003129u, 1069918088u, 0, ATAN2_TOLERANCE, 0},
{1957, 1053387478u, 3184880021u, 1072313561u, 0, ATAN2_TOLERANCE, 0},
{1958, 3387653691u, 3347783852u, 3217934656u, 0, ATAN2_TOLERANCE, 0},
{1959, 3136364836u, 1018492227u, 3182046039u, 0, ATAN2_TOLERANCE, 0},
{1960, 1338680611u, 1166078045u, 1070141398u, 0, ATAN2_TOLERANCE, 0},
{1961, 1112891928u, 3074730425u, 1070141404u, 0, ATAN2_TOLERANCE, 0},
{1962, 893449284u, 1052877339u, 905910827u, 0, ATAN2_TOLERANCE, 0},
{1963, 3105373037u, 3246705916u, 3226013622u, 0, ATAN2_TOLERANCE, 0},
{1964, 1190105283u, 3033907262u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{1965, 1011225926u, 1180485180u, 895856689u, 0, ATAN2_TOLERANCE, 0},
{1966, 1043025031u, 987068973u, 1070059733u, 0, ATAN2_TOLERANCE, 0},
{1967, 3125834184u, 896953754u, 3217615366u, 0, ATAN2_TOLERANCE, 0},
{1968, 1120888322u, 1086209113u, 1069661027u, 0, ATAN2_TOLERANCE, 0},
{1969, 1315217243u, 3396371713u, 1070175876u, 0, ATAN2_TOLERANCE, 0},
{1970, 3137758475u, 1039403054u, 3163355342u, 0, ATAN2_TOLERANCE, 0},
{1971, 1040617590u, 1034835971u, 1065285491u, 0, ATAN2_TOLERANCE, 0},
{1972, 955384253u, 3344785562u, 1078530011u, 0, ATAN2_TOLERANCE, 0},
{1973, 904255535u, 1019967545u, 949000081u, 0, ATAN2_TOLERANCE, 0},
{1974, 1022984119u, 3113891410u, 1070222414u, 0, ATAN2_TOLERANCE, 0},
{1975, 997362368u, 3112875428u, 1070740064u, 0, ATAN2_TOLERANCE, 0},
{1976, 1168623062u, 1143306482u, 1069112396u, 0, ATAN2_TOLERANCE, 0},
{1977, 878737490u, 3269908326u, 1078530011u, 0, ATAN2_TOLERANCE, 0},
{1978, 1039827284u, 1072928888u, 1032024878u, 0, ATAN2_TOLERANCE, 0},
{1979, 1021564080u, 1064468397u, 1022390853u, 0, ATAN2_TOLERANCE, 0},
{1980, 3458669745u, 3033299853u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{1981, 3327516316u, 3405380971u, 3226006650u, 0, ATAN2_TOLERANCE, 0},
{1982, 1040711112u, 3229444200u, 1078389384u, 0, ATAN2_TOLERANCE, 0},
{1983, 1134528351u, 3365952513u, 1078525936u, 0, ATAN2_TOLERANCE, 0},
{1984, 3414352838u, 3350285760u, 3217669438u, 0, ATAN2_TOLERANCE, 0},
{1985, 1133689539u, 1067460093u, 1070105638u, 0, ATAN2_TOLERANCE, 0},
{1986, 3455688478u, 3333091960u, 3217625401u, 0, ATAN2_TOLERANCE, 0},
{1987, 1137634874u, 1137038869u, 1062129683u, 0, ATAN2_TOLERANCE, 0},
{1988, 3415502662u, 955510692u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{1989, 954999730u, 969618597u, 1049674404u, 0, ATAN2_TOLERANCE, 0},
{1990, 1066157309u, 3241712664u, 1078132839u, 0, ATAN2_TOLERANCE, 0},
{1991, 3436353675u, 1174967495u, 3217624387u, 0, ATAN2_TOLERANCE, 0},
{1992, 3108347547u, 3434003435u, 3226013659u, 0, ATAN2_TOLERANCE, 0},
{1993, 3064200154u, 3158080507u, 3226011877u, 0, ATAN2_TOLERANCE, 0},
{1994, 3272661536u, 3461799138u, 3226013658u, 0, ATAN2_TOLERANCE, 0},
{1995, 1170245333u, 1233406410u, 1002064036u, 0, ATAN2_TOLERANCE, 0},
{1996, 1219052056u, 3369557946u, 1075736302u, 0, ATAN2_TOLERANCE, 0},
{1997, 3318983619u, 3259663338u, 3217687751u, 0, ATAN2_TOLERANCE, 0},
{1998, 3146190320u, 889646054u, 3217624028u, 0, ATAN2_TOLERANCE, 0},
{1999, 1299683827u, 966031619u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{2000, 3086068902u, 3484245751u, 3226013659u, 0, ATAN2_TOLERANCE, 0},
{2001, 3064155399u, 3176569312u, 3226013269u, 0, ATAN2_TOLERANCE, 0},
{2002, 3040314717u, 1071290674u, 3033983935u, 0, ATAN2_TOLERANCE, 0},
{2003, 3257224022u, 3361778245u, 3226012905u, 0, ATAN2_TOLERANCE, 0},
{2004, 1229268598u, 1066965677u, 1070141390u, 0, ATAN2_TOLERANCE, 0},
{2005, 1086717248u, 3423795374u, 1078530010u, 0, ATAN2_TOLERANCE, 0},
{2006, 3434884607u, 3029593823u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{2007, 3464955606u, 1017987696u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{2008, 1025278524u, 3121856207u, 1070265127u, 0, ATAN2_TOLERANCE, 0},
{2009, 1242829722u, 3233935671u, 1070141424u, 0, ATAN2_TOLERANCE, 0},
{2010, 3075149137u, 1117325737u, 3022640362u, 0, ATAN2_TOLERANCE, 0},
{2011, 1200927971u, 1317167489u, 949091767u, 0, ATAN2_TOLERANCE, 0},
{2012, 3326858092u, 3452602832u, 3226013530u, 0, ATAN2_TOLERANCE, 0},
{2013, 3184801644u, 1137974313u, 3112177779u, 0, ATAN2_TOLERANCE, 0},
{2014, 1136052740u, 3244616020u, 1070469525u, 0, ATAN2_TOLERANCE, 0},
{2015, 1015670780u, 1101217251u, 978863264u, 0, ATAN2_TOLERANCE, 0},
{2016, 1012543234u, 1116520440u, 960916317u, 0, ATAN2_TOLERANCE, 0},
{2017, 3316611992u, 3394732912u, 3226006988u, 0, ATAN2_TOLERANCE, 0},
{2018, 1087942795u, 3316660295u, 1078524974u, 0, ATAN2_TOLERANCE, 0},
{2019, 3426365713u, 3069778532u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{2020, 3066654389u, 3443934204u, 3226013659u, 0, ATAN2_TOLERANCE, 0},
{2021, 3295326432u, 1313396175u, 3046478811u, 0, ATAN2_TOLERANCE, 0},
{2022, 3318835308u, 3277583511u, 3217900300u, 0, ATAN2_TOLERANCE, 0},
{2023, 3283555717u, 891875120u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{2024, 3040485181u, 3375450886u, 3226013659u, 0, ATAN2_TOLERANCE, 0},
{2025, 3388772093u, 1032597076u, 3217625050u, 0, ATAN2_TOLERANCE, 0},
{2026, 954670189u, 1144923689u, 874222309u, 0, ATAN2_TOLERANCE, 0},
{2027, 1319200415u, 3387555900u, 1070153279u, 0, ATAN2_TOLERANCE, 0},
{2028, 1279324488u, 3228401212u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{2029, 3455131757u, 1260217257u, 3217453967u, 0, ATAN2_TOLERANCE, 0},
{2030, 1246947517u, 1087951909u, 1070141386u, 0, ATAN2_TOLERANCE, 0},
{2031, 3433761025u, 3060143904u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{2032, 3201187455u, 900233172u, 3217625024u, 0, ATAN2_TOLERANCE, 0},
{2033, 1173247961u, 1191127979u, 1047193748u, 0, ATAN2_TOLERANCE, 0},
{2034, 3037297123u, 3346394818u, 3226013659u, 0, ATAN2_TOLERANCE, 0},
{2035, 3083019343u, 3033309444u, 3217762483u, 0, ATAN2_TOLERANCE, 0},
{2036, 3042018375u, 3203882372u, 3226013652u, 0, ATAN2_TOLERANCE, 0},
{2037, 1082862511u, 3032804719u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{2038, 3157626955u, 3483653298u, 3226013659u, 0, ATAN2_TOLERANCE, 0},
{2039, 3182695954u, 3256861672u, 3226004425u, 0, ATAN2_TOLERANCE, 0},
{2040, 1105291533u, 3482971524u, 1078530011u, 0, ATAN2_TOLERANCE, 0},
{2041, 1016023520u, 3227712090u, 1078509325u, 0, ATAN2_TOLERANCE, 0},
{2042, 3370691006u, 1295870514u, 3139254705u, 0, ATAN2_TOLERANCE, 0},
{2043, 1156767169u, 1049756240u, 1070140171u, 0, ATAN2_TOLERANCE, 0},
{2044, 3077020499u, 894671462u, 3217146564u, 0, ATAN2_TOLERANCE, 0},
{2045, 1104284039u, 3040211914u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{2046, 3335212901u, 3486414589u, 3226013643u, 0, ATAN2_TOLERANCE, 0},
{2047, 1093697541u, 3193708441u, 1070304849u, 0, ATAN2_TOLERANCE, 0},
{2048, 3266691185u, 1160074593u, 3171723218u, 0, ATAN2_TOLERANCE, 0},
{2049, 3179003144u, 1108615803u, 3134817668u, 0, ATAN2_TOLERANCE, 0},
{2050, 3424086808u, 3260140004u, 3217625062u, 0, ATAN2_TOLERANCE, 0},
{2051, 3353608773u, 1134068114u, 3217603133u, 0, ATAN2_TOLERANCE, 0},
{2052, 882878091u, 3136970767u, 1078529358u, 0, ATAN2_TOLERANCE, 0},
{2053, 927582555u, 947955456u, 1044791214u, 0, ATAN2_TOLERANCE, 0},
{2054, 3111440310u, 3067634077u, 3217856693u, 0, ATAN2_TOLERANCE, 0},
{2055, 3476083859u, 966439623u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{2056, 3038754840u, 932009686u, 3171980751u, 0, ATAN2_TOLERANCE, 0},
{2057, 3464546616u, 3205527253u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{2058, 1002542205u, 3152136093u, 1075557233u, 0, ATAN2_TOLERANCE, 0},
{2059, 3443552129u, 3165561391u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{2060, 1287620154u, 3119707283u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{2061, 3073260205u, 3093124531u, 3225198660u, 0, ATAN2_TOLERANCE, 0},
{2062, 1245702957u, 894348966u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{2063, 1002715618u, 1191006977u, 877022332u, 0, ATAN2_TOLERANCE, 0},
{2064, 3087802274u, 897541752u, 3217386213u, 0, ATAN2_TOLERANCE, 0},
{2065, 3415763001u, 3032518431u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{2066, 3283471961u, 1260093226u, 3088427057u, 0, ATAN2_TOLERANCE, 0},
{2067, 3311210827u, 1192192264u, 3183785110u, 0, ATAN2_TOLERANCE, 0},
{2068, 1198307901u, 1116328249u, 1070131864u, 0, ATAN2_TOLERANCE, 0},
{2069, 1288901567u, 1296370667u, 1056686848u, 0, ATAN2_TOLERANCE, 0},
{2070, 922255363u, 958305289u, 1028156442u, 0, ATAN2_TOLERANCE, 0},
{2071, 1113104661u, 944376032u, 1070141395u, 0, ATAN2_TOLERANCE, 0},
{2072, 948856035u, 1015466475u, 998717622u, 0, ATAN2_TOLERANCE, 0},
{2073, 1062512367u, 3229559531u, 1077668471u, 0, ATAN2_TOLERANCE, 0},
{2074, 1162027071u, 3308983387u, 1075147524u, 0, ATAN2_TOLERANCE, 0},
{2075, 1034561811u, 1054043114u, 1045123831u, 0, ATAN2_TOLERANCE, 0},
{2076, 3271615417u, 3209997200u, 3217679118u, 0, ATAN2_TOLERANCE, 0},
{2077, 1042014529u, 1146708584u, 959943147u, 0, ATAN2_TOLERANCE, 0},
{2078, 1177157787u, 3090208179u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{2079, 3196144817u, 1056118717u, 3204073657u, 0, ATAN2_TOLERANCE, 0},
{2080, 1309658335u, 1010219988u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{2081, 3100289712u, 3456334210u, 3226013659u, 0, ATAN2_TOLERANCE, 0},
{2082, 3375507013u, 1306310823u, 3134103462u, 0, ATAN2_TOLERANCE, 0},
{2083, 3460699001u, 3096700943u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{2084, 3079231719u, 1044386263u, 3099004977u, 0, ATAN2_TOLERANCE, 0},
{2085, 3093951884u, 1014115231u, 3145159061u, 0, ATAN2_TOLERANCE, 0},
{2086, 3468023178u, 1209565017u, 3217624192u, 0, ATAN2_TOLERANCE, 0},
{2087, 1204196034u, 3298625731u, 1070245051u, 0, ATAN2_TOLERANCE, 0},
{2088, 1161439847u, 943449277u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{2089, 908663107u, 939489763u, 1034489716u, 0, ATAN2_TOLERANCE, 0},
{2090, 1055319316u, 3261813492u, 1078497860u, 0, ATAN2_TOLERANCE, 0},
{2091, 1084378658u, 1009650785u, 1070123833u, 0, ATAN2_TOLERANCE, 0},
{2092, 3053887750u, 3341786453u, 3226013659u, 0, ATAN2_TOLERANCE, 0},
{2093, 3022828828u, 881335251u, 3205544878u, 0, ATAN2_TOLERANCE, 0},
{2094, 1123114742u, 1229815537u, 957765780u, 0, ATAN2_TOLERANCE, 0},
{2095, 1258114435u, 1291336083u, 1031958809u, 0, ATAN2_TOLERANCE, 0},
{2096, 3468040845u, 3066966245u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{2097, 1178825761u, 1113195286u, 1070104853u, 0, ATAN2_TOLERANCE, 0},
{2098, 3059266302u, 878503862u, 3217091308u, 0, ATAN2_TOLERANCE, 0},
{2099, 3223384012u, 1130486973u, 3157682004u, 0, ATAN2_TOLERANCE, 0},
{2100, 3445262427u, 3465211174u, 3225199336u, 0, ATAN2_TOLERANCE, 0},
{2101, 1125653081u, 1207799746u, 983142602u, 0, ATAN2_TOLERANCE, 0},
{2102, 3337652712u, 3025581813u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{2103, 1184753508u, 3147374485u, 1070141405u, 0, ATAN2_TOLERANCE, 0},
{2104, 996404791u, 3353251979u, 1078530011u, 0, ATAN2_TOLERANCE, 0},
{2105, 1188439315u, 1113484271u, 1070124385u, 0, ATAN2_TOLERANCE, 0},
{2106, 916831283u, 999465787u, 982559633u, 0, ATAN2_TOLERANCE, 0},
{2107, 996786317u, 3179221951u, 1078290045u, 0, ATAN2_TOLERANCE, 0},
{2108, 3461635065u, 1004690387u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{2109, 1188167943u, 1200744896u, 1051776672u, 0, ATAN2_TOLERANCE, 0},
{2110, 1102061604u, 3424449935u, 1078530008u, 0, ATAN2_TOLERANCE, 0},
{2111, 1282351521u, 3039376424u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{2112, 3458861065u, 3392466405u, 3217659919u, 0, ATAN2_TOLERANCE, 0},
{2113, 3095256878u, 1023623326u, 3136787620u, 0, ATAN2_TOLERANCE, 0},
{2114, 3422194733u, 893873945u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{2115, 3083885296u, 974543672u, 3174122414u, 0, ATAN2_TOLERANCE, 0},
{2116, 1261940623u, 3402349985u, 1074065444u, 0, ATAN2_TOLERANCE, 0},
{2117, 3400603081u, 3234396843u, 3217625060u, 0, ATAN2_TOLERANCE, 0},
{2118, 3139250800u, 3079109479u, 3217681544u, 0, ATAN2_TOLERANCE, 0},
{2119, 886201503u, 3272760705u, 1078530011u, 0, ATAN2_TOLERANCE, 0},
{2120, 3297366026u, 1089966380u, 3217566187u, 0, ATAN2_TOLERANCE, 0},
{2121, 1218488455u, 3309646450u, 1070221841u, 0, ATAN2_TOLERANCE, 0},
{2122, 3040358923u, 3093401553u, 3225960144u, 0, ATAN2_TOLERANCE, 0},
{2123, 1283938137u, 1196383822u, 1070135127u, 0, ATAN2_TOLERANCE, 0},
{2124, 3182551696u, 3029982441u, 3217625078u, 0, ATAN2_TOLERANCE, 0},
{2125, 1317098613u, 949986176u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{2126, 3116209179u, 3303588342u, 3226013658u, 0, ATAN2_TOLERANCE, 0},
{2127, 3239728775u, 927815421u, 3217625040u, 0, ATAN2_TOLERANCE, 0},
{2128, 3207141672u, 933456504u, 3217624803u, 0, ATAN2_TOLERANCE, 0},
{2129, 3154378805u, 905462392u, 3217623125u, 0, ATAN2_TOLERANCE, 0},
{2130, 3069658155u, 1041452042u, 3092701021u, 0, ATAN2_TOLERANCE, 0},
{2131, 3207056527u, 3384206601u, 3226013657u, 0, ATAN2_TOLERANCE, 0},
{2132, 1284174954u, 3436881197u, 1076155477u, 0, ATAN2_TOLERANCE, 0},
{2133, 3156081645u, 3308839704u, 3226013645u, 0, ATAN2_TOLERANCE, 0},
{2134, 1063693032u, 976661408u, 1070134915u, 0, ATAN2_TOLERANCE, 0},
{2135, 1102631663u, 3396951425u, 1078529987u, 0, ATAN2_TOLERANCE, 0},
{2136, 968803479u, 992989712u, 1040845349u, 0, ATAN2_TOLERANCE, 0},
{2137, 3273080388u, 3109405906u, 3217625062u, 0, ATAN2_TOLERANCE, 0},
{2138, 1172529774u, 3294550127u, 1071163952u, 0, ATAN2_TOLERANCE, 0},
{2139, 1306695905u, 1292690378u, 1067612994u, 0, ATAN2_TOLERANCE, 0},
{2140, 3158855023u, 3151283866u, 3221473110u, 0, ATAN2_TOLERANCE, 0},
{2141, 1165177679u, 3276237026u, 1070570911u, 0, ATAN2_TOLERANCE, 0},
{2142, 3403009513u, 3381966453u, 3219069294u, 0, ATAN2_TOLERANCE, 0},
{2143, 952348506u, 3377573987u, 1078530011u, 0, ATAN2_TOLERANCE, 0},
{2144, 1222777442u, 1125769920u, 1070138615u, 0, ATAN2_TOLERANCE, 0},
{2145, 1325324763u, 978336043u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{2146, 3363524213u, 3202991311u, 3217625066u, 0, ATAN2_TOLERANCE, 0},
{2147, 1158950321u, 1073578913u, 1070134395u, 0, ATAN2_TOLERANCE, 0},
{2148, 903129873u, 3416864271u, 1078530011u, 0, ATAN2_TOLERANCE, 0},
{2149, 3078339944u, 988173985u, 3154895797u, 0, ATAN2_TOLERANCE, 0},
{2150, 1208345407u, 1254181270u, 1018252503u, 0, ATAN2_TOLERANCE, 0},
{2151, 1258634105u, 1247426200u, 1066881297u, 0, ATAN2_TOLERANCE, 0},
{2152, 1248478509u, 1287895126u, 1025057766u, 0, ATAN2_TOLERANCE, 0},
{2153, 1153863988u, 3430539165u, 1078529909u, 0, ATAN2_TOLERANCE, 0},
{2154, 1097120930u, 3221726305u, 1071376032u, 0, ATAN2_TOLERANCE, 0},
{2155, 3469778622u, 1200179013u, 3217624714u, 0, ATAN2_TOLERANCE, 0},
{2156, 1147712200u, 931865525u, 1070141402u, 0, ATAN2_TOLERANCE, 0},
{2157, 1124721745u, 3058969650u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{2158, 3261744304u, 1043806501u, 3217599423u, 0, ATAN2_TOLERANCE, 0},
{2159, 3303160152u, 3075455322u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{2160, 1315090496u, 3269683237u, 1070141404u, 0, ATAN2_TOLERANCE, 0},
{2161, 1335399673u, 974138676u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{2162, 1072458508u, 3372833993u, 1078529997u, 0, ATAN2_TOLERANCE, 0},
{2163, 3252139741u, 1059615003u, 3217420395u, 0, ATAN2_TOLERANCE, 0},
{2164, 3468519966u, 3113982619u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{2165, 1006231203u, 897530770u, 1070140357u, 0, ATAN2_TOLERANCE, 0},
{2166, 951554138u, 1001144381u, 1015571681u, 0, ATAN2_TOLERANCE, 0},
{2167, 942046828u, 986341002u, 1020432919u, 0, ATAN2_TOLERANCE, 0},
{2168, 3319723279u, 3414482416u, 3226011940u, 0, ATAN2_TOLERANCE, 0},
{2169, 3255104167u, 928827688u, 3217625047u, 0, ATAN2_TOLERANCE, 0},
{2170, 1155477903u, 3104812800u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{2171, 3273889176u, 980486479u, 3217625003u, 0, ATAN2_TOLERANCE, 0},
{2172, 3237813668u, 3441016803u, 3226013658u, 0, ATAN2_TOLERANCE, 0},
{2173, 981908840u, 3314038398u, 1078530010u, 0, ATAN2_TOLERANCE, 0},
{2174, 941187647u, 1107765599u, 898711988u, 0, ATAN2_TOLERANCE, 0},
{2175, 1214223128u, 3225536822u, 1070141514u, 0, ATAN2_TOLERANCE, 0},
{2176, 3422922584u, 1086391131u, 3217625049u, 0, ATAN2_TOLERANCE, 0},
{2177, 1315857601u, 3487600045u, 1077976642u, 0, ATAN2_TOLERANCE, 0},
{2178, 3453226030u, 3233768835u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{2179, 1078359574u, 3199175230u, 1071065122u, 0, ATAN2_TOLERANCE, 0},
{2180, 1029557624u, 3302959071u, 1078529883u, 0, ATAN2_TOLERANCE, 0},
{2181, 1207675424u, 3042692550u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{2182, 1028355074u, 3442294040u, 1078530011u, 0, ATAN2_TOLERANCE, 0},
{2183, 1248421894u, 3367769132u, 1070983505u, 0, ATAN2_TOLERANCE, 0},
{2184, 3353251994u, 1095517730u, 3217624111u, 0, ATAN2_TOLERANCE, 0},
{2185, 876926659u, 3288089977u, 1078530011u, 0, ATAN2_TOLERANCE, 0},
{2186, 1076752219u, 876236939u, 1070141402u, 0, ATAN2_TOLERANCE, 0},
{2187, 1273395082u, 3031189261u, 1070141403u, 0, ATAN2_TOLERANCE, 0},
{2188, 3385588183u, 3258252464u, 3217625278u, 0, ATAN2_TOLERANCE, 0},
{2189, 3192315328u, 3289489214u, 3226012260u, 0, ATAN2_TOLERANCE, 0},
{2190, 3441804648u, 3274638356u, 3217625059u, 0, ATAN2_TOLERANCE, 0},
{2191, 3392827417u, 1277961150u, 3179965369u, 0, ATAN2_TOLERANCE, 0},
{2192, 1161241793u, 1328003707u, 898352014u, 0, ATAN2_TOLERANCE, 0},
{2193, 3034494183u, 3041579130u, 3223907672u, 0, ATAN2_TOLERANCE, 0},
{2194, 1171318485u, 3374409104u, 1078487599u, 0, ATAN2_TOLERANCE, 0},
{2195, 1001216371u, 3052357038u, 1070144229u, 0, ATAN2_TOLERANCE, 0},
{2196, 912515889u, 1074635609u, 902689232u, 0, ATAN2_TOLERANCE, 0},
{2197, 3391452505u, 897989232u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{2198, 3249603369u, 3147662248u, 3217626873u, 0, ATAN2_TOLERANCE, 0},
{2199, 3169816394u, 988430929u, 3217113000u, 0, ATAN2_TOLERANCE, 0},
{2200, 3282212423u, 3174079140u, 3217626163u, 0, ATAN2_TOLERANCE, 0},
{2201, 3352293320u, 3247843425u, 3217626530u, 0, ATAN2_TOLERANCE, 0},
{2202, 3296358441u, 875645354u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{2203, 1197828352u, 3245614728u, 1070143582u, 0, ATAN2_TOLERANCE, 0},
{2204, 3340510371u, 914930263u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{2205, 1127109339u, 3368125489u, 1078528166u, 0, ATAN2_TOLERANCE, 0},
{2206, 3192887808u, 3191848339u, 3222552959u, 0, ATAN2_TOLERANCE, 0},
{2207, 3237183876u, 3179379969u, 3217694749u, 0, ATAN2_TOLERANCE, 0},
{2208, 939285924u, 3056079386u, 1070838127u, 0, ATAN2_TOLERANCE, 0},
{2209, 944050180u, 3452557879u, 1078530011u, 0, ATAN2_TOLERANCE, 0},
{2210, 3058135703u, 3090284601u, 3225720409u, 0, ATAN2_TOLERANCE, 0},
{2211, 3480592662u, 3261728191u, 3217625051u, 0, ATAN2_TOLERANCE, 0},
{2212, 3061939312u, 3274418540u, 3226013659u, 0, ATAN2_TOLERANCE, 0},
{2213, 1155775526u, 1255814444u, 965056178u, 0, ATAN2_TOLERANCE, 0},
{2214, 1234491880u, 3408568717u, 1078074444u, 0, ATAN2_TOLERANCE, 0},

// AUTOMATICALLY GENERATED VECTORS STOP

};

#endif // CYGONCE_LIBM_ATAN2_H multiple inclusion protection

// EOF atan2f.h
