#ifndef CYGONCE_LIBM_ASINH_H
#define CYGONCE_LIBM_ASINH_H
//===========================================================================
//
//      asinh.h
//
//      Test vectors for testing of asinh() math library function
//
//===========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 2012 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later
// version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License
// along with eCos; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
// As a special exception, if other files instantiate templates or use
// macros or inline functions from this file, or you compile this file
// and link it with other works to produce a work based on this file,
// this file does not by itself cause the resulting work to be covered by
// the GNU General Public License. However the source code for this file
// must still be made available in accordance with section (3) of the GNU
// General Public License v2.
//
// This exception does not invalidate any other reasons why a work based
// on this file might be covered by the GNU General Public License.
// -------------------------------------------
// ####ECOSGPLCOPYRIGHTEND####
//===========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):
// Contributors:  visar, ilijak
// Date:        1998-02-13
// Purpose:
// Description:
// Usage:       #include "vectors/asinh.h"
//
//####DESCRIPTIONEND####
//
//===========================================================================


// CONFIGURATION

#include <pkgconf/libm.h>   // Configuration header


// INCLUDES

#include <cyg/infra/cyg_type.h>    // Common type definitions and support
#include "vectors/vector_support_float.h"// extra support for math tests

#define ASINH_TOLERANCE 1.0E-04

static const Cyg_libm_test_float_vec_t asinhf_vec[] = {

// AUTOMATICALLY GENERATED VECTORS START

{0, 3214514586u, 2147495668u, 3212970857u, 0, ASINH_TOLERANCE, 0},
{1, 3214430700u, 2147495668u, 3212917021u, 0, ASINH_TOLERANCE, 0},
{2, 3214346813u, 2147495668u, 3212862920u, 0, ASINH_TOLERANCE, 0},
{3, 3214262927u, 2147495668u, 3212780240u, 0, ASINH_TOLERANCE, 0},
{4, 3214179041u, 2147495668u, 3212670966u, 0, ASINH_TOLERANCE, 0},
{5, 3214095155u, 2147495668u, 3212561149u, 0, ASINH_TOLERANCE, 0},
{6, 3214011269u, 2147495668u, 3212450788u, 0, ASINH_TOLERANCE, 0},
{7, 3213927383u, 2147495668u, 3212339878u, 0, ASINH_TOLERANCE, 0},
{8, 3213843497u, 2147495668u, 3212228416u, 0, ASINH_TOLERANCE, 0},
{9, 3213759611u, 2147495668u, 3212116399u, 0, ASINH_TOLERANCE, 0},
{10, 3213675725u, 2147495668u, 3212003823u, 0, ASINH_TOLERANCE, 0},
{11, 3213591839u, 2147495668u, 3211890687u, 0, ASINH_TOLERANCE, 0},
{12, 3213507953u, 2147495668u, 3211776985u, 0, ASINH_TOLERANCE, 0},
{13, 3213424067u, 2147495668u, 3211662714u, 0, ASINH_TOLERANCE, 0},
{14, 3213340180u, 2147495668u, 3211547871u, 0, ASINH_TOLERANCE, 0},
{15, 3213256294u, 2147495668u, 3211432455u, 0, ASINH_TOLERANCE, 0},
{16, 3213172408u, 2147495668u, 3211316461u, 0, ASINH_TOLERANCE, 0},
{17, 3213088522u, 2147495668u, 3211199885u, 0, ASINH_TOLERANCE, 0},
{18, 3213004636u, 2147495668u, 3211082726u, 0, ASINH_TOLERANCE, 0},
{19, 3212920750u, 2147495668u, 3210964979u, 0, ASINH_TOLERANCE, 0},
{20, 3212836864u, 2147495668u, 3210846643u, 0, ASINH_TOLERANCE, 0},
{21, 3212669092u, 2147495668u, 3210727713u, 0, ASINH_TOLERANCE, 0},
{22, 3212501320u, 2147495668u, 3210608188u, 0, ASINH_TOLERANCE, 0},
{23, 3212333548u, 2147495668u, 3210488062u, 0, ASINH_TOLERANCE, 0},
{24, 3212165775u, 2147495668u, 3210367335u, 0, ASINH_TOLERANCE, 0},
{25, 3211998003u, 2147495668u, 3210246003u, 0, ASINH_TOLERANCE, 0},
{26, 3211830231u, 2147495668u, 3210124064u, 0, ASINH_TOLERANCE, 0},
{27, 3211662459u, 2147495668u, 3210001516u, 0, ASINH_TOLERANCE, 0},
{28, 3211494687u, 2147495668u, 3209878354u, 0, ASINH_TOLERANCE, 0},
{29, 3211326915u, 2147495668u, 3209754578u, 0, ASINH_TOLERANCE, 0},
{30, 3211159142u, 2147495668u, 3209630183u, 0, ASINH_TOLERANCE, 0},
{31, 3210991370u, 2147495668u, 3209505169u, 0, ASINH_TOLERANCE, 0},
{32, 3210823598u, 2147495668u, 3209379532u, 0, ASINH_TOLERANCE, 0},
{33, 3210655826u, 2147495668u, 3209253271u, 0, ASINH_TOLERANCE, 0},
{34, 3210488054u, 2147495668u, 3209126382u, 0, ASINH_TOLERANCE, 0},
{35, 3210320282u, 2147495668u, 3208998865u, 0, ASINH_TOLERANCE, 0},
{36, 3210152509u, 2147495668u, 3208870717u, 0, ASINH_TOLERANCE, 0},
{37, 3209984737u, 2147495668u, 3208741936u, 0, ASINH_TOLERANCE, 0},
{38, 3209816965u, 2147495668u, 3208612522u, 0, ASINH_TOLERANCE, 0},
{39, 3209649193u, 2147495668u, 3208482470u, 0, ASINH_TOLERANCE, 0},
{40, 3209481421u, 2147495668u, 3208351781u, 0, ASINH_TOLERANCE, 0},
{41, 3209313649u, 2147495668u, 3208220454u, 0, ASINH_TOLERANCE, 0},
{42, 3209145876u, 2147495668u, 3208088485u, 0, ASINH_TOLERANCE, 0},
{43, 3208978104u, 2147495668u, 3207955876u, 0, ASINH_TOLERANCE, 0},
{44, 3208810332u, 2147495668u, 3207822623u, 0, ASINH_TOLERANCE, 0},
{45, 3208642560u, 2147495668u, 3207688728u, 0, ASINH_TOLERANCE, 0},
{46, 3208474788u, 2147495668u, 3207554188u, 0, ASINH_TOLERANCE, 0},
{47, 3208307016u, 2147495668u, 3207419003u, 0, ASINH_TOLERANCE, 0},
{48, 3208139244u, 2147495668u, 3207283173u, 0, ASINH_TOLERANCE, 0},
{49, 3207971471u, 2147495668u, 3207146697u, 0, ASINH_TOLERANCE, 0},
{50, 3207803699u, 2147495668u, 3207009576u, 0, ASINH_TOLERANCE, 0},
{51, 3207635927u, 2147495668u, 3206871809u, 0, ASINH_TOLERANCE, 0},
{52, 3207468155u, 2147495668u, 3206733396u, 0, ASINH_TOLERANCE, 0},
{53, 3207300383u, 2147495668u, 3206594339u, 0, ASINH_TOLERANCE, 0},
{54, 3207132611u, 2147495668u, 3206454637u, 0, ASINH_TOLERANCE, 0},
{55, 3206964838u, 2147495668u, 3206314290u, 0, ASINH_TOLERANCE, 0},
{56, 3206797066u, 2147495668u, 3206173301u, 0, ASINH_TOLERANCE, 0},
{57, 3206629294u, 2147495668u, 3206031671u, 0, ASINH_TOLERANCE, 0},
{58, 3206461522u, 2147495668u, 3205889401u, 0, ASINH_TOLERANCE, 0},
{59, 3206293750u, 2147495668u, 3205746492u, 0, ASINH_TOLERANCE, 0},
{60, 3206125978u, 2147495668u, 3205602946u, 0, ASINH_TOLERANCE, 0},
{61, 3205958205u, 2147495668u, 3205458765u, 0, ASINH_TOLERANCE, 0},
{62, 3205790433u, 2147495668u, 3205313953u, 0, ASINH_TOLERANCE, 0},
{63, 3205622661u, 2147495668u, 3205168510u, 0, ASINH_TOLERANCE, 0},
{64, 3205454889u, 2147495668u, 3205022440u, 0, ASINH_TOLERANCE, 0},
{65, 3205287117u, 2147495668u, 3204875747u, 0, ASINH_TOLERANCE, 0},
{66, 3205119345u, 2147495668u, 3204728433u, 0, ASINH_TOLERANCE, 0},
{67, 3204951572u, 2147495668u, 3204580501u, 0, ASINH_TOLERANCE, 0},
{68, 3204783800u, 2147495668u, 3204415655u, 0, ASINH_TOLERANCE, 0},
{69, 3204616028u, 2147495668u, 3204117348u, 0, ASINH_TOLERANCE, 0},
{70, 3204448256u, 2147495668u, 3203817830u, 0, ASINH_TOLERANCE, 0},
{71, 3204112712u, 2147495668u, 3203517110u, 0, ASINH_TOLERANCE, 0},
{72, 3203777167u, 2147495668u, 3203215201u, 0, ASINH_TOLERANCE, 0},
{73, 3203441623u, 2147495668u, 3202912112u, 0, ASINH_TOLERANCE, 0},
{74, 3203106079u, 2147495668u, 3202607855u, 0, ASINH_TOLERANCE, 0},
{75, 3202770534u, 2147495668u, 3202302439u, 0, ASINH_TOLERANCE, 0},
{76, 3202434990u, 2147495668u, 3201995878u, 0, ASINH_TOLERANCE, 0},
{77, 3202099446u, 2147495668u, 3201688186u, 0, ASINH_TOLERANCE, 0},
{78, 3201763901u, 2147495668u, 3201379374u, 0, ASINH_TOLERANCE, 0},
{79, 3201428357u, 2147495668u, 3201069459u, 0, ASINH_TOLERANCE, 0},
{80, 3201092813u, 2147495668u, 3200758454u, 0, ASINH_TOLERANCE, 0},
{81, 3200757268u, 2147495668u, 3200446374u, 0, ASINH_TOLERANCE, 0},
{82, 3200421724u, 2147495668u, 3200133237u, 0, ASINH_TOLERANCE, 0},
{83, 3200086180u, 2147495668u, 3199819057u, 0, ASINH_TOLERANCE, 0},
{84, 3199750636u, 2147495668u, 3199503854u, 0, ASINH_TOLERANCE, 0},
{85, 3199415091u, 2147495668u, 3199187644u, 0, ASINH_TOLERANCE, 0},
{86, 3199079547u, 2147495668u, 3198870448u, 0, ASINH_TOLERANCE, 0},
{87, 3198744003u, 2147495668u, 3198552283u, 0, ASINH_TOLERANCE, 0},
{88, 3198408458u, 2147495668u, 3198233169u, 0, ASINH_TOLERANCE, 0},
{89, 3198072914u, 2147495668u, 3197913129u, 0, ASINH_TOLERANCE, 0},
{90, 3197737370u, 2147495668u, 3197592182u, 0, ASINH_TOLERANCE, 0},
{91, 3197401825u, 2147495668u, 3197270349u, 0, ASINH_TOLERANCE, 0},
{92, 3197066281u, 2147495668u, 3196947656u, 0, ASINH_TOLERANCE, 0},
{93, 3196730737u, 2147495668u, 3196624123u, 0, ASINH_TOLERANCE, 0},
{94, 3196395192u, 2147495668u, 3196299775u, 0, ASINH_TOLERANCE, 0},
{95, 3196059648u, 2147495668u, 3195889625u, 0, ASINH_TOLERANCE, 0},
{96, 3195388559u, 2147495668u, 3195237815u, 0, ASINH_TOLERANCE, 0},
{97, 3194717471u, 2147495668u, 3194584526u, 0, ASINH_TOLERANCE, 0},
{98, 3194046382u, 2147495668u, 3193929807u, 0, ASINH_TOLERANCE, 0},
{99, 3193375293u, 2147495668u, 3193273714u, 0, ASINH_TOLERANCE, 0},
{100, 3192704205u, 2147495668u, 3192616299u, 0, ASINH_TOLERANCE, 0},
{101, 3192033116u, 2147495668u, 3191957620u, 0, ASINH_TOLERANCE, 0},
{102, 3191362028u, 2147495668u, 3191297731u, 0, ASINH_TOLERANCE, 0},
{103, 3190690939u, 2147495668u, 3190636690u, 0, ASINH_TOLERANCE, 0},
{104, 3190019850u, 2147495668u, 3189974557u, 0, ASINH_TOLERANCE, 0},
{105, 3189348762u, 2147495668u, 3189311390u, 0, ASINH_TOLERANCE, 0},
{106, 3188677673u, 2147495668u, 3188647250u, 0, ASINH_TOLERANCE, 0},
{107, 3188006584u, 2147495668u, 3187982196u, 0, ASINH_TOLERANCE, 0},
{108, 3186999951u, 2147495668u, 3186961544u, 0, ASINH_TOLERANCE, 0},
{109, 3185657774u, 2147495668u, 3185628161u, 0, ASINH_TOLERANCE, 0},
{110, 3184315597u, 2147495668u, 3184293327u, 0, ASINH_TOLERANCE, 0},
{111, 3182973420u, 2147495668u, 3182957172u, 0, ASINH_TOLERANCE, 0},
{112, 3181631242u, 2147495668u, 3181619822u, 0, ASINH_TOLERANCE, 0},
{113, 3180289065u, 2147495668u, 3180281409u, 0, ASINH_TOLERANCE, 0},
{114, 3178611343u, 2147495668u, 3178601695u, 0, ASINH_TOLERANCE, 0},
{115, 3175926989u, 2147495668u, 3175921403u, 0, ASINH_TOLERANCE, 0},
{116, 3173242634u, 2147495668u, 3173239773u, 0, ASINH_TOLERANCE, 0},
{117, 3170222735u, 2147495668u, 3170220320u, 0, ASINH_TOLERANCE, 0},
{118, 3164854026u, 2147495668u, 3164853310u, 0, ASINH_TOLERANCE, 0},
{119, 3156465418u, 2147495668u, 3156465239u, 0, ASINH_TOLERANCE, 0},
{120, 646742016u, 2147495668u, 646742016u, 0, ASINH_TOLERANCE, 0},
{121, 1008981770u, 2147495668u, 1008981591u, 0, ASINH_TOLERANCE, 0},
{122, 1017370378u, 2147495668u, 1017369662u, 0, ASINH_TOLERANCE, 0},
{123, 1022739087u, 2147495668u, 1022736672u, 0, ASINH_TOLERANCE, 0},
{124, 1025758986u, 2147495668u, 1025756125u, 0, ASINH_TOLERANCE, 0},
{125, 1028443341u, 2147495668u, 1028437755u, 0, ASINH_TOLERANCE, 0},
{126, 1031127695u, 2147495668u, 1031118047u, 0, ASINH_TOLERANCE, 0},
{127, 1032805417u, 2147495668u, 1032797761u, 0, ASINH_TOLERANCE, 0},
{128, 1034147594u, 2147495668u, 1034136174u, 0, ASINH_TOLERANCE, 0},
{129, 1035489772u, 2147495668u, 1035473524u, 0, ASINH_TOLERANCE, 0},
{130, 1036831949u, 2147495668u, 1036809679u, 0, ASINH_TOLERANCE, 0},
{131, 1038174126u, 2147495668u, 1038144513u, 0, ASINH_TOLERANCE, 0},
{132, 1039516303u, 2147495668u, 1039477896u, 0, ASINH_TOLERANCE, 0},
{133, 1040522936u, 2147495668u, 1040498548u, 0, ASINH_TOLERANCE, 0},
{134, 1041194025u, 2147495668u, 1041163602u, 0, ASINH_TOLERANCE, 0},
{135, 1041865114u, 2147495668u, 1041827742u, 0, ASINH_TOLERANCE, 0},
{136, 1042536202u, 2147495668u, 1042490909u, 0, ASINH_TOLERANCE, 0},
{137, 1043207291u, 2147495668u, 1043153042u, 0, ASINH_TOLERANCE, 0},
{138, 1043878380u, 2147495668u, 1043814083u, 0, ASINH_TOLERANCE, 0},
{139, 1044549468u, 2147495668u, 1044473972u, 0, ASINH_TOLERANCE, 0},
{140, 1045220557u, 2147495668u, 1045132651u, 0, ASINH_TOLERANCE, 0},
{141, 1045891645u, 2147495668u, 1045790066u, 0, ASINH_TOLERANCE, 0},
{142, 1046562734u, 2147495668u, 1046446159u, 0, ASINH_TOLERANCE, 0},
{143, 1047233823u, 2147495668u, 1047100878u, 0, ASINH_TOLERANCE, 0},
{144, 1047904911u, 2147495668u, 1047754167u, 0, ASINH_TOLERANCE, 0},
{145, 1048576000u, 2147495668u, 1048405977u, 0, ASINH_TOLERANCE, 0},
{146, 1048911544u, 2147495668u, 1048816127u, 0, ASINH_TOLERANCE, 0},
{147, 1049247089u, 2147495668u, 1049140475u, 0, ASINH_TOLERANCE, 0},
{148, 1049582633u, 2147495668u, 1049464008u, 0, ASINH_TOLERANCE, 0},
{149, 1049918177u, 2147495668u, 1049786701u, 0, ASINH_TOLERANCE, 0},
{150, 1050253722u, 2147495668u, 1050108534u, 0, ASINH_TOLERANCE, 0},
{151, 1050589266u, 2147495668u, 1050429481u, 0, ASINH_TOLERANCE, 0},
{152, 1050924810u, 2147495668u, 1050749521u, 0, ASINH_TOLERANCE, 0},
{153, 1051260355u, 2147495668u, 1051068635u, 0, ASINH_TOLERANCE, 0},
{154, 1051595899u, 2147495668u, 1051386800u, 0, ASINH_TOLERANCE, 0},
{155, 1051931443u, 2147495668u, 1051703996u, 0, ASINH_TOLERANCE, 0},
{156, 1052266988u, 2147495668u, 1052020206u, 0, ASINH_TOLERANCE, 0},
{157, 1052602532u, 2147495668u, 1052335409u, 0, ASINH_TOLERANCE, 0},
{158, 1052938076u, 2147495668u, 1052649589u, 0, ASINH_TOLERANCE, 0},
{159, 1053273620u, 2147495668u, 1052962726u, 0, ASINH_TOLERANCE, 0},
{160, 1053609165u, 2147495668u, 1053274806u, 0, ASINH_TOLERANCE, 0},
{161, 1053944709u, 2147495668u, 1053585811u, 0, ASINH_TOLERANCE, 0},
{162, 1054280253u, 2147495668u, 1053895726u, 0, ASINH_TOLERANCE, 0},
{163, 1054615798u, 2147495668u, 1054204538u, 0, ASINH_TOLERANCE, 0},
{164, 1054951342u, 2147495668u, 1054512230u, 0, ASINH_TOLERANCE, 0},
{165, 1055286886u, 2147495668u, 1054818791u, 0, ASINH_TOLERANCE, 0},
{166, 1055622431u, 2147495668u, 1055124207u, 0, ASINH_TOLERANCE, 0},
{167, 1055957975u, 2147495668u, 1055428464u, 0, ASINH_TOLERANCE, 0},
{168, 1056293519u, 2147495668u, 1055731553u, 0, ASINH_TOLERANCE, 0},
{169, 1056629064u, 2147495668u, 1056033462u, 0, ASINH_TOLERANCE, 0},
{170, 1056964608u, 2147495668u, 1056334182u, 0, ASINH_TOLERANCE, 0},
{171, 1057132380u, 2147495668u, 1056633700u, 0, ASINH_TOLERANCE, 0},
{172, 1057300152u, 2147495668u, 1056932007u, 0, ASINH_TOLERANCE, 0},
{173, 1057467924u, 2147495668u, 1057096853u, 0, ASINH_TOLERANCE, 0},
{174, 1057635697u, 2147495668u, 1057244785u, 0, ASINH_TOLERANCE, 0},
{175, 1057803469u, 2147495668u, 1057392099u, 0, ASINH_TOLERANCE, 0},
{176, 1057971241u, 2147495668u, 1057538792u, 0, ASINH_TOLERANCE, 0},
{177, 1058139013u, 2147495668u, 1057684862u, 0, ASINH_TOLERANCE, 0},
{178, 1058306785u, 2147495668u, 1057830305u, 0, ASINH_TOLERANCE, 0},
{179, 1058474557u, 2147495668u, 1057975117u, 0, ASINH_TOLERANCE, 0},
{180, 1058642330u, 2147495668u, 1058119298u, 0, ASINH_TOLERANCE, 0},
{181, 1058810102u, 2147495668u, 1058262844u, 0, ASINH_TOLERANCE, 0},
{182, 1058977874u, 2147495668u, 1058405753u, 0, ASINH_TOLERANCE, 0},
{183, 1059145646u, 2147495668u, 1058548023u, 0, ASINH_TOLERANCE, 0},
{184, 1059313418u, 2147495668u, 1058689653u, 0, ASINH_TOLERANCE, 0},
{185, 1059481190u, 2147495668u, 1058830642u, 0, ASINH_TOLERANCE, 0},
{186, 1059648963u, 2147495668u, 1058970989u, 0, ASINH_TOLERANCE, 0},
{187, 1059816735u, 2147495668u, 1059110691u, 0, ASINH_TOLERANCE, 0},
{188, 1059984507u, 2147495668u, 1059249748u, 0, ASINH_TOLERANCE, 0},
{189, 1060152279u, 2147495668u, 1059388161u, 0, ASINH_TOLERANCE, 0},
{190, 1060320051u, 2147495668u, 1059525928u, 0, ASINH_TOLERANCE, 0},
{191, 1060487823u, 2147495668u, 1059663049u, 0, ASINH_TOLERANCE, 0},
{192, 1060655596u, 2147495668u, 1059799525u, 0, ASINH_TOLERANCE, 0},
{193, 1060823368u, 2147495668u, 1059935355u, 0, ASINH_TOLERANCE, 0},
{194, 1060991140u, 2147495668u, 1060070540u, 0, ASINH_TOLERANCE, 0},
{195, 1061158912u, 2147495668u, 1060205080u, 0, ASINH_TOLERANCE, 0},
{196, 1061326684u, 2147495668u, 1060338975u, 0, ASINH_TOLERANCE, 0},
{197, 1061494456u, 2147495668u, 1060472228u, 0, ASINH_TOLERANCE, 0},
{198, 1061662228u, 2147495668u, 1060604837u, 0, ASINH_TOLERANCE, 0},
{199, 1061830001u, 2147495668u, 1060736806u, 0, ASINH_TOLERANCE, 0},
{200, 1061997773u, 2147495668u, 1060868133u, 0, ASINH_TOLERANCE, 0},
{201, 1062165545u, 2147495668u, 1060998822u, 0, ASINH_TOLERANCE, 0},
{202, 1062333317u, 2147495668u, 1061128874u, 0, ASINH_TOLERANCE, 0},
{203, 1062501089u, 2147495668u, 1061258288u, 0, ASINH_TOLERANCE, 0},
{204, 1062668861u, 2147495668u, 1061387069u, 0, ASINH_TOLERANCE, 0},
{205, 1062836634u, 2147495668u, 1061515217u, 0, ASINH_TOLERANCE, 0},
{206, 1063004406u, 2147495668u, 1061642734u, 0, ASINH_TOLERANCE, 0},
{207, 1063172178u, 2147495668u, 1061769623u, 0, ASINH_TOLERANCE, 0},
{208, 1063339950u, 2147495668u, 1061895884u, 0, ASINH_TOLERANCE, 0},
{209, 1063507722u, 2147495668u, 1062021521u, 0, ASINH_TOLERANCE, 0},
{210, 1063675494u, 2147495668u, 1062146535u, 0, ASINH_TOLERANCE, 0},
{211, 1063843267u, 2147495668u, 1062270930u, 0, ASINH_TOLERANCE, 0},
{212, 1064011039u, 2147495668u, 1062394706u, 0, ASINH_TOLERANCE, 0},
{213, 1064178811u, 2147495668u, 1062517868u, 0, ASINH_TOLERANCE, 0},
{214, 1064346583u, 2147495668u, 1062640416u, 0, ASINH_TOLERANCE, 0},
{215, 1064514355u, 2147495668u, 1062762355u, 0, ASINH_TOLERANCE, 0},
{216, 1064682127u, 2147495668u, 1062883687u, 0, ASINH_TOLERANCE, 0},
{217, 1064849900u, 2147495668u, 1063004414u, 0, ASINH_TOLERANCE, 0},
{218, 1065017672u, 2147495668u, 1063124540u, 0, ASINH_TOLERANCE, 0},
{219, 1065185444u, 2147495668u, 1063244065u, 0, ASINH_TOLERANCE, 0},
{220, 1065353216u, 2147495668u, 1063362995u, 0, ASINH_TOLERANCE, 0},
{221, 1065437102u, 2147495668u, 1063481331u, 0, ASINH_TOLERANCE, 0},
{222, 1065520988u, 2147495668u, 1063599078u, 0, ASINH_TOLERANCE, 0},
{223, 1065604874u, 2147495668u, 1063716237u, 0, ASINH_TOLERANCE, 0},
{224, 1065688760u, 2147495668u, 1063832813u, 0, ASINH_TOLERANCE, 0},
{225, 1065772646u, 2147495668u, 1063948807u, 0, ASINH_TOLERANCE, 0},
{226, 1065856532u, 2147495668u, 1064064223u, 0, ASINH_TOLERANCE, 0},
{227, 1065940419u, 2147495668u, 1064179066u, 0, ASINH_TOLERANCE, 0},
{228, 1066024305u, 2147495668u, 1064293337u, 0, ASINH_TOLERANCE, 0},
{229, 1066108191u, 2147495668u, 1064407039u, 0, ASINH_TOLERANCE, 0},
{230, 1066192077u, 2147495668u, 1064520175u, 0, ASINH_TOLERANCE, 0},
{231, 1066275963u, 2147495668u, 1064632751u, 0, ASINH_TOLERANCE, 0},
{232, 1066359849u, 2147495668u, 1064744768u, 0, ASINH_TOLERANCE, 0},
{233, 1066443735u, 2147495668u, 1064856230u, 0, ASINH_TOLERANCE, 0},
{234, 1066527621u, 2147495668u, 1064967140u, 0, ASINH_TOLERANCE, 0},
{235, 1066611507u, 2147495668u, 1065077501u, 0, ASINH_TOLERANCE, 0},
{236, 1066695393u, 2147495668u, 1065187318u, 0, ASINH_TOLERANCE, 0},
{237, 1066779279u, 2147495668u, 1065296592u, 0, ASINH_TOLERANCE, 0},
{238, 1066863165u, 2147495668u, 1065379272u, 0, ASINH_TOLERANCE, 0},
{239, 1066947052u, 2147495668u, 1065433373u, 0, ASINH_TOLERANCE, 0},
{240, 3234402267u, 2147495668u, 3223479061u, 0, ASINH_TOLERANCE, 0},
{241, 3231108068u, 2147495668u, 3222292564u, 0, ASINH_TOLERANCE, 0},
{242, 3226013659u, 2147495668u, 3220070325u, 0, ASINH_TOLERANCE, 0},
{243, 3217625051u, 2147495668u, 3214794791u, 0, ASINH_TOLERANCE, 0},
{244, 0u, 2147495668u, 0u, 0, ASINH_TOLERANCE, 0},
{245, 1070141403u, 2147495668u, 1067311143u, 0, ASINH_TOLERANCE, 0},
{246, 1078530011u, 2147495668u, 1072586677u, 0, ASINH_TOLERANCE, 0},
{247, 1083624420u, 2147495668u, 1074808916u, 0, ASINH_TOLERANCE, 0},
{248, 3253731328u, 2147495668u, 3229812517u, 0, ASINH_TOLERANCE, 0},
{249, 3252840038u, 2147495668u, 3229690251u, 0, ASINH_TOLERANCE, 0},
{250, 3251948749u, 2147495668u, 3229506754u, 0, ASINH_TOLERANCE, 0},
{251, 3251057459u, 2147495668u, 3229229957u, 0, ASINH_TOLERANCE, 0},
{252, 3250166170u, 2147495668u, 3228933611u, 0, ASINH_TOLERANCE, 0},
{253, 3249274880u, 2147495668u, 3228614747u, 0, ASINH_TOLERANCE, 0},
{254, 3248383590u, 2147495668u, 3228269663u, 0, ASINH_TOLERANCE, 0},
{255, 3247492301u, 2147495668u, 3227893666u, 0, ASINH_TOLERANCE, 0},
{256, 3246601011u, 2147495668u, 3227480676u, 0, ASINH_TOLERANCE, 0},
{257, 3245028147u, 2147495668u, 3227022627u, 0, ASINH_TOLERANCE, 0},
{258, 3243245568u, 2147495668u, 3226508502u, 0, ASINH_TOLERANCE, 0},
{259, 3241462989u, 2147495668u, 3225922682u, 0, ASINH_TOLERANCE, 0},
{260, 3239680410u, 2147495668u, 3225241988u, 0, ASINH_TOLERANCE, 0},
{261, 3237792973u, 2147495668u, 3224429886u, 0, ASINH_TOLERANCE, 0},
{262, 3234227814u, 2147495668u, 3223423864u, 0, ASINH_TOLERANCE, 0},
{263, 3230662656u, 2147495668u, 3222103540u, 0, ASINH_TOLERANCE, 0},
{264, 3224580915u, 2147495668u, 3219155405u, 0, ASINH_TOLERANCE, 0},
{265, 3213675725u, 2147495668u, 3212003823u, 0, ASINH_TOLERANCE, 0},
{266, 1058642330u, 2147495668u, 1058119298u, 0, ASINH_TOLERANCE, 0},
{267, 1075000115u, 2147495668u, 1070137059u, 0, ASINH_TOLERANCE, 0},
{268, 1082130432u, 2147495668u, 1074139077u, 0, ASINH_TOLERANCE, 0},
{269, 1085695590u, 2147495668u, 1075592438u, 0, ASINH_TOLERANCE, 0},
{270, 1089260749u, 2147495668u, 1076674320u, 0, ASINH_TOLERANCE, 0},
{271, 1091672474u, 2147495668u, 1077535266u, 0, ASINH_TOLERANCE, 0},
{272, 1093455053u, 2147495668u, 1078249987u, 0, ASINH_TOLERANCE, 0},
{273, 1095237632u, 2147495668u, 1078860855u, 0, ASINH_TOLERANCE, 0},
{274, 1097020211u, 2147495668u, 1079394180u, 0, ASINH_TOLERANCE, 0},
{275, 1098802790u, 2147495668u, 1079867411u, 0, ASINH_TOLERANCE, 0},
{276, 1099746509u, 2147495668u, 1080292707u, 0, ASINH_TOLERANCE, 0},
{277, 1100637798u, 2147495668u, 1080678879u, 0, ASINH_TOLERANCE, 0},
{278, 1101529088u, 2147495668u, 1081032514u, 0, ASINH_TOLERANCE, 0},
{279, 1102420378u, 2147495668u, 1081358667u, 0, ASINH_TOLERANCE, 0},
{280, 1103311667u, 2147495668u, 1081661299u, 0, ASINH_TOLERANCE, 0},
{281, 1104202957u, 2147495668u, 1081943573u, 0, ASINH_TOLERANCE, 0},
{282, 1105094246u, 2147495668u, 1082169243u, 0, ASINH_TOLERANCE, 0},
{283, 1105985536u, 2147495668u, 1082293642u, 0, ASINH_TOLERANCE, 0},
{284, 0u, 2147495668u, 0u, 0, ASINH_TOLERANCE, 0},

// AUTOMATICALLY GENERATED VECTORS STOP

};

#endif // CYGONCE_LIBM_ASINH_H multiple inclusion protection

// EOF asinh.h
