#ifndef CYGONCE_LIBM_ASIN_H
#define CYGONCE_LIBM_ASIN_H
//===========================================================================
//
//      asin.h
//
//      Test vectors for testing of asin() math library function
//
//===========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 2012 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later
// version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License
// along with eCos; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
// As a special exception, if other files instantiate templates or use
// macros or inline functions from this file, or you compile this file
// and link it with other works to produce a work based on this file,
// this file does not by itself cause the resulting work to be covered by
// the GNU General Public License. However the source code for this file
// must still be made available in accordance with section (3) of the GNU
// General Public License v2.
//
// This exception does not invalidate any other reasons why a work based
// on this file might be covered by the GNU General Public License.
// -------------------------------------------
// ####ECOSGPLCOPYRIGHTEND####
//===========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):
// Contributors:  visar, ilijak
// Date:        1998-02-13
// Purpose:
// Description:
// Usage:       #include "vectors/asin.h"
//
//####DESCRIPTIONEND####
//
//===========================================================================


// CONFIGURATION

#include <pkgconf/libm.h>   // Configuration header


// INCLUDES

#include <cyg/infra/cyg_type.h>    // Common type definitions and support
#include "vectors/vector_support_float.h"// extra support for math tests

#define ASIN_TOLERANCE 1.0E-04

static const Cyg_libm_test_float_vec_t asinf_vec[] = {

// AUTOMATICALLY GENERATED VECTORS START

{0, 3214514586u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{1, 3214430700u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{2, 3214346813u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{3, 3214262927u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{4, 3214179041u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{5, 3214095155u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{6, 3214011269u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{7, 3213927383u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{8, 3213843497u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{9, 3213759611u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{10, 3213675725u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{11, 3213591839u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{12, 3213507953u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{13, 3213424067u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{14, 3213340180u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{15, 3213256294u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{16, 3213172408u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{17, 3213088522u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{18, 3213004636u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{19, 3212920750u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{20, 3212836864u, 3217625051u, 3217625051u, 0, ASIN_TOLERANCE, 0},
{21, 3212669092u, 3216437732u, 3216437732u, 0, ASIN_TOLERANCE, 0},
{22, 3212501320u, 3215944521u, 3215944521u, 0, ASIN_TOLERANCE, 0},
{23, 3212333548u, 3215565099u, 3215565099u, 0, ASIN_TOLERANCE, 0},
{24, 3212165775u, 3215244413u, 3215244413u, 0, ASIN_TOLERANCE, 0},
{25, 3211998003u, 3214961161u, 3214961161u, 0, ASIN_TOLERANCE, 0},
{26, 3211830231u, 3214704423u, 3214704423u, 0, ASIN_TOLERANCE, 0},
{27, 3211662459u, 3214467718u, 3214467718u, 0, ASIN_TOLERANCE, 0},
{28, 3211494687u, 3214246826u, 3214246826u, 0, ASIN_TOLERANCE, 0},
{29, 3211326915u, 3214038819u, 3214038819u, 0, ASIN_TOLERANCE, 0},
{30, 3211159142u, 3213841564u, 3213841564u, 0, ASIN_TOLERANCE, 0},
{31, 3210991370u, 3213653454u, 3213653454u, 0, ASIN_TOLERANCE, 0},
{32, 3210823598u, 3213473242u, 3213473242u, 0, ASIN_TOLERANCE, 0},
{33, 3210655826u, 3213299935u, 3213299935u, 0, ASIN_TOLERANCE, 0},
{34, 3210488054u, 3213132728u, 3213132728u, 0, ASIN_TOLERANCE, 0},
{35, 3210320282u, 3212970959u, 3212970959u, 0, ASIN_TOLERANCE, 0},
{36, 3210152509u, 3212791284u, 3212791284u, 0, ASIN_TOLERANCE, 0},
{37, 3209984737u, 3212486350u, 3212486350u, 0, ASIN_TOLERANCE, 0},
{38, 3209816965u, 3212189449u, 3212189449u, 0, ASIN_TOLERANCE, 0},
{39, 3209649193u, 3211899893u, 3211899893u, 0, ASIN_TOLERANCE, 0},
{40, 3209481421u, 3211617081u, 3211617081u, 0, ASIN_TOLERANCE, 0},
{41, 3209313649u, 3211340489u, 3211340489u, 0, ASIN_TOLERANCE, 0},
{42, 3209145876u, 3211069649u, 3211069649u, 0, ASIN_TOLERANCE, 0},
{43, 3208978104u, 3210804156u, 3210804156u, 0, ASIN_TOLERANCE, 0},
{44, 3208810332u, 3210543640u, 3210543640u, 0, ASIN_TOLERANCE, 0},
{45, 3208642560u, 3210287770u, 3210287770u, 0, ASIN_TOLERANCE, 0},
{46, 3208474788u, 3210036251u, 3210036251u, 0, ASIN_TOLERANCE, 0},
{47, 3208307016u, 3209788813u, 3209788813u, 0, ASIN_TOLERANCE, 0},
{48, 3208139244u, 3209545215u, 3209545215u, 0, ASIN_TOLERANCE, 0},
{49, 3207971471u, 3209305230u, 3209305230u, 0, ASIN_TOLERANCE, 0},
{50, 3207803699u, 3209068660u, 3209068660u, 0, ASIN_TOLERANCE, 0},
{51, 3207635927u, 3208835315u, 3208835315u, 0, ASIN_TOLERANCE, 0},
{52, 3207468155u, 3208605024u, 3208605024u, 0, ASIN_TOLERANCE, 0},
{53, 3207300383u, 3208377629u, 3208377629u, 0, ASIN_TOLERANCE, 0},
{54, 3207132611u, 3208152982u, 3208152982u, 0, ASIN_TOLERANCE, 0},
{55, 3206964838u, 3207930946u, 3207930946u, 0, ASIN_TOLERANCE, 0},
{56, 3206797066u, 3207711396u, 3207711396u, 0, ASIN_TOLERANCE, 0},
{57, 3206629294u, 3207494214u, 3207494214u, 0, ASIN_TOLERANCE, 0},
{58, 3206461522u, 3207279289u, 3207279289u, 0, ASIN_TOLERANCE, 0},
{59, 3206293750u, 3207066519u, 3207066519u, 0, ASIN_TOLERANCE, 0},
{60, 3206125978u, 3206855806u, 3206855806u, 0, ASIN_TOLERANCE, 0},
{61, 3205958205u, 3206647058u, 3206647058u, 0, ASIN_TOLERANCE, 0},
{62, 3205790433u, 3206440193u, 3206440193u, 0, ASIN_TOLERANCE, 0},
{63, 3205622661u, 3206235129u, 3206235129u, 0, ASIN_TOLERANCE, 0},
{64, 3205454889u, 3206031787u, 3206031787u, 0, ASIN_TOLERANCE, 0},
{65, 3205287117u, 3205830100u, 3205830100u, 0, ASIN_TOLERANCE, 0},
{66, 3205119345u, 3205629996u, 3205629996u, 0, ASIN_TOLERANCE, 0},
{67, 3204951572u, 3205431410u, 3205431410u, 0, ASIN_TOLERANCE, 0},
{68, 3204783800u, 3205234284u, 3205234284u, 0, ASIN_TOLERANCE, 0},
{69, 3204616028u, 3205038560u, 3205038560u, 0, ASIN_TOLERANCE, 0},
{70, 3204448256u, 3204844178u, 3204844178u, 0, ASIN_TOLERANCE, 0},
{71, 3204112712u, 3204651089u, 3204651089u, 0, ASIN_TOLERANCE, 0},
{72, 3203777167u, 3204459240u, 3204459240u, 0, ASIN_TOLERANCE, 0},
{73, 3203441623u, 3204088914u, 3204088914u, 0, ASIN_TOLERANCE, 0},
{74, 3203106079u, 3203709898u, 3203709898u, 0, ASIN_TOLERANCE, 0},
{75, 3202770534u, 3203333085u, 3203333085u, 0, ASIN_TOLERANCE, 0},
{76, 3202434990u, 3202958395u, 3202958395u, 0, ASIN_TOLERANCE, 0},
{77, 3202099446u, 3202585743u, 3202585743u, 0, ASIN_TOLERANCE, 0},
{78, 3201763901u, 3202215051u, 3202215051u, 0, ASIN_TOLERANCE, 0},
{79, 3201428357u, 3201846246u, 3201846246u, 0, ASIN_TOLERANCE, 0},
{80, 3201092813u, 3201479254u, 3201479254u, 0, ASIN_TOLERANCE, 0},
{81, 3200757268u, 3201114005u, 3201114005u, 0, ASIN_TOLERANCE, 0},
{82, 3200421724u, 3200750433u, 3200750433u, 0, ASIN_TOLERANCE, 0},
{83, 3200086180u, 3200388473u, 3200388473u, 0, ASIN_TOLERANCE, 0},
{84, 3199750636u, 3200028060u, 3200028060u, 0, ASIN_TOLERANCE, 0},
{85, 3199415091u, 3199669135u, 3199669135u, 0, ASIN_TOLERANCE, 0},
{86, 3199079547u, 3199311640u, 3199311640u, 0, ASIN_TOLERANCE, 0},
{87, 3198744003u, 3198955516u, 3198955516u, 0, ASIN_TOLERANCE, 0},
{88, 3198408458u, 3198600708u, 3198600708u, 0, ASIN_TOLERANCE, 0},
{89, 3198072914u, 3198247163u, 3198247163u, 0, ASIN_TOLERANCE, 0},
{90, 3197737370u, 3197894829u, 3197894829u, 0, ASIN_TOLERANCE, 0},
{91, 3197401825u, 3197543654u, 3197543654u, 0, ASIN_TOLERANCE, 0},
{92, 3197066281u, 3197193590u, 3197193590u, 0, ASIN_TOLERANCE, 0},
{93, 3196730737u, 3196844588u, 3196844588u, 0, ASIN_TOLERANCE, 0},
{94, 3196395192u, 3196496600u, 3196496600u, 0, ASIN_TOLERANCE, 0},
{95, 3196059648u, 3196149582u, 3196149582u, 0, ASIN_TOLERANCE, 0},
{96, 3195388559u, 3195547329u, 3195547329u, 0, ASIN_TOLERANCE, 0},
{97, 3194717471u, 3194856902u, 3194856902u, 0, ASIN_TOLERANCE, 0},
{98, 3194046382u, 3194168149u, 3194168149u, 0, ASIN_TOLERANCE, 0},
{99, 3193375293u, 3193480987u, 3193480987u, 0, ASIN_TOLERANCE, 0},
{100, 3192704205u, 3192795334u, 3192795334u, 0, ASIN_TOLERANCE, 0},
{101, 3192033116u, 3192111106u, 3192111106u, 0, ASIN_TOLERANCE, 0},
{102, 3191362028u, 3191428228u, 3191428228u, 0, ASIN_TOLERANCE, 0},
{103, 3190690939u, 3190746617u, 3190746617u, 0, ASIN_TOLERANCE, 0},
{104, 3190019850u, 3190066199u, 3190066199u, 0, ASIN_TOLERANCE, 0},
{105, 3189348762u, 3189386898u, 3189386898u, 0, ASIN_TOLERANCE, 0},
{106, 3188677673u, 3188708638u, 3188708638u, 0, ASIN_TOLERANCE, 0},
{107, 3188006584u, 3188031346u, 3188031346u, 0, ASIN_TOLERANCE, 0},
{108, 3186999951u, 3187038858u, 3187038858u, 0, ASIN_TOLERANCE, 0},
{109, 3185657774u, 3185687711u, 3185687711u, 0, ASIN_TOLERANCE, 0},
{110, 3184315597u, 3184338068u, 3184338068u, 0, ASIN_TOLERANCE, 0},
{111, 3182973420u, 3182989787u, 3182989787u, 0, ASIN_TOLERANCE, 0},
{112, 3181631242u, 3181642728u, 3181642728u, 0, ASIN_TOLERANCE, 0},
{113, 3180289065u, 3180296755u, 3180296755u, 0, ASIN_TOLERANCE, 0},
{114, 3178611343u, 3178621022u, 3178621022u, 0, ASIN_TOLERANCE, 0},
{115, 3175926989u, 3175932588u, 3175932588u, 0, ASIN_TOLERANCE, 0},
{116, 3173242634u, 3173245499u, 3173245499u, 0, ASIN_TOLERANCE, 0},
{117, 3170222735u, 3170225152u, 3170225152u, 0, ASIN_TOLERANCE, 0},
{118, 3164854026u, 3164854742u, 3164854742u, 0, ASIN_TOLERANCE, 0},
{119, 3156465418u, 3156465597u, 3156465597u, 0, ASIN_TOLERANCE, 0},
{120, 1008981770u, 1008981949u, 1008981949u, 0, ASIN_TOLERANCE, 0},
{121, 1017370378u, 1017371094u, 1017371094u, 0, ASIN_TOLERANCE, 0},
{122, 1022739087u, 1022741504u, 1022741504u, 0, ASIN_TOLERANCE, 0},
{123, 1025758986u, 1025761851u, 1025761851u, 0, ASIN_TOLERANCE, 0},
{124, 1028443341u, 1028448940u, 1028448940u, 0, ASIN_TOLERANCE, 0},
{125, 1031127695u, 1031137374u, 1031137374u, 0, ASIN_TOLERANCE, 0},
{126, 1032805417u, 1032813107u, 1032813107u, 0, ASIN_TOLERANCE, 0},
{127, 1034147594u, 1034159080u, 1034159080u, 0, ASIN_TOLERANCE, 0},
{128, 1035489772u, 1035506139u, 1035506139u, 0, ASIN_TOLERANCE, 0},
{129, 1036831949u, 1036854420u, 1036854420u, 0, ASIN_TOLERANCE, 0},
{130, 1038174126u, 1038204063u, 1038204063u, 0, ASIN_TOLERANCE, 0},
{131, 1039516303u, 1039555210u, 1039555210u, 0, ASIN_TOLERANCE, 0},
{132, 1040522936u, 1040547698u, 1040547698u, 0, ASIN_TOLERANCE, 0},
{133, 1041194025u, 1041224990u, 1041224990u, 0, ASIN_TOLERANCE, 0},
{134, 1041865114u, 1041903250u, 1041903250u, 0, ASIN_TOLERANCE, 0},
{135, 1042536202u, 1042582551u, 1042582551u, 0, ASIN_TOLERANCE, 0},
{136, 1043207291u, 1043262969u, 1043262969u, 0, ASIN_TOLERANCE, 0},
{137, 1043878380u, 1043944580u, 1043944580u, 0, ASIN_TOLERANCE, 0},
{138, 1044549468u, 1044627458u, 1044627458u, 0, ASIN_TOLERANCE, 0},
{139, 1045220557u, 1045311686u, 1045311686u, 0, ASIN_TOLERANCE, 0},
{140, 1045891645u, 1045997339u, 1045997339u, 0, ASIN_TOLERANCE, 0},
{141, 1046562734u, 1046684501u, 1046684501u, 0, ASIN_TOLERANCE, 0},
{142, 1047233823u, 1047373254u, 1047373254u, 0, ASIN_TOLERANCE, 0},
{143, 1047904911u, 1048063681u, 1048063681u, 0, ASIN_TOLERANCE, 0},
{144, 1048576000u, 1048665934u, 1048665934u, 0, ASIN_TOLERANCE, 0},
{145, 1048911544u, 1049012952u, 1049012952u, 0, ASIN_TOLERANCE, 0},
{146, 1049247089u, 1049360940u, 1049360940u, 0, ASIN_TOLERANCE, 0},
{147, 1049582633u, 1049709942u, 1049709942u, 0, ASIN_TOLERANCE, 0},
{148, 1049918177u, 1050060006u, 1050060006u, 0, ASIN_TOLERANCE, 0},
{149, 1050253722u, 1050411181u, 1050411181u, 0, ASIN_TOLERANCE, 0},
{150, 1050589266u, 1050763515u, 1050763515u, 0, ASIN_TOLERANCE, 0},
{151, 1050924810u, 1051117060u, 1051117060u, 0, ASIN_TOLERANCE, 0},
{152, 1051260355u, 1051471868u, 1051471868u, 0, ASIN_TOLERANCE, 0},
{153, 1051595899u, 1051827992u, 1051827992u, 0, ASIN_TOLERANCE, 0},
{154, 1051931443u, 1052185487u, 1052185487u, 0, ASIN_TOLERANCE, 0},
{155, 1052266988u, 1052544412u, 1052544412u, 0, ASIN_TOLERANCE, 0},
{156, 1052602532u, 1052904825u, 1052904825u, 0, ASIN_TOLERANCE, 0},
{157, 1052938076u, 1053266785u, 1053266785u, 0, ASIN_TOLERANCE, 0},
{158, 1053273620u, 1053630357u, 1053630357u, 0, ASIN_TOLERANCE, 0},
{159, 1053609165u, 1053995606u, 1053995606u, 0, ASIN_TOLERANCE, 0},
{160, 1053944709u, 1054362598u, 1054362598u, 0, ASIN_TOLERANCE, 0},
{161, 1054280253u, 1054731403u, 1054731403u, 0, ASIN_TOLERANCE, 0},
{162, 1054615798u, 1055102095u, 1055102095u, 0, ASIN_TOLERANCE, 0},
{163, 1054951342u, 1055474747u, 1055474747u, 0, ASIN_TOLERANCE, 0},
{164, 1055286886u, 1055849437u, 1055849437u, 0, ASIN_TOLERANCE, 0},
{165, 1055622431u, 1056226250u, 1056226250u, 0, ASIN_TOLERANCE, 0},
{166, 1055957975u, 1056605266u, 1056605266u, 0, ASIN_TOLERANCE, 0},
{167, 1056293519u, 1056975592u, 1056975592u, 0, ASIN_TOLERANCE, 0},
{168, 1056629064u, 1057167441u, 1057167441u, 0, ASIN_TOLERANCE, 0},
{169, 1056964608u, 1057360530u, 1057360530u, 0, ASIN_TOLERANCE, 0},
{170, 1057132380u, 1057554912u, 1057554912u, 0, ASIN_TOLERANCE, 0},
{171, 1057300152u, 1057750636u, 1057750636u, 0, ASIN_TOLERANCE, 0},
{172, 1057467924u, 1057947762u, 1057947762u, 0, ASIN_TOLERANCE, 0},
{173, 1057635697u, 1058146348u, 1058146348u, 0, ASIN_TOLERANCE, 0},
{174, 1057803469u, 1058346452u, 1058346452u, 0, ASIN_TOLERANCE, 0},
{175, 1057971241u, 1058548139u, 1058548139u, 0, ASIN_TOLERANCE, 0},
{176, 1058139013u, 1058751481u, 1058751481u, 0, ASIN_TOLERANCE, 0},
{177, 1058306785u, 1058956545u, 1058956545u, 0, ASIN_TOLERANCE, 0},
{178, 1058474557u, 1059163410u, 1059163410u, 0, ASIN_TOLERANCE, 0},
{179, 1058642330u, 1059372158u, 1059372158u, 0, ASIN_TOLERANCE, 0},
{180, 1058810102u, 1059582871u, 1059582871u, 0, ASIN_TOLERANCE, 0},
{181, 1058977874u, 1059795641u, 1059795641u, 0, ASIN_TOLERANCE, 0},
{182, 1059145646u, 1060010566u, 1060010566u, 0, ASIN_TOLERANCE, 0},
{183, 1059313418u, 1060227748u, 1060227748u, 0, ASIN_TOLERANCE, 0},
{184, 1059481190u, 1060447298u, 1060447298u, 0, ASIN_TOLERANCE, 0},
{185, 1059648963u, 1060669334u, 1060669334u, 0, ASIN_TOLERANCE, 0},
{186, 1059816735u, 1060893981u, 1060893981u, 0, ASIN_TOLERANCE, 0},
{187, 1059984507u, 1061121376u, 1061121376u, 0, ASIN_TOLERANCE, 0},
{188, 1060152279u, 1061351667u, 1061351667u, 0, ASIN_TOLERANCE, 0},
{189, 1060320051u, 1061585012u, 1061585012u, 0, ASIN_TOLERANCE, 0},
{190, 1060487823u, 1061821582u, 1061821582u, 0, ASIN_TOLERANCE, 0},
{191, 1060655596u, 1062061567u, 1062061567u, 0, ASIN_TOLERANCE, 0},
{192, 1060823368u, 1062305165u, 1062305165u, 0, ASIN_TOLERANCE, 0},
{193, 1060991140u, 1062552603u, 1062552603u, 0, ASIN_TOLERANCE, 0},
{194, 1061158912u, 1062804122u, 1062804122u, 0, ASIN_TOLERANCE, 0},
{195, 1061326684u, 1063059992u, 1063059992u, 0, ASIN_TOLERANCE, 0},
{196, 1061494456u, 1063320508u, 1063320508u, 0, ASIN_TOLERANCE, 0},
{197, 1061662228u, 1063586001u, 1063586001u, 0, ASIN_TOLERANCE, 0},
{198, 1061830001u, 1063856841u, 1063856841u, 0, ASIN_TOLERANCE, 0},
{199, 1061997773u, 1064133433u, 1064133433u, 0, ASIN_TOLERANCE, 0},
{200, 1062165545u, 1064416245u, 1064416245u, 0, ASIN_TOLERANCE, 0},
{201, 1062333317u, 1064705801u, 1064705801u, 0, ASIN_TOLERANCE, 0},
{202, 1062501089u, 1065002702u, 1065002702u, 0, ASIN_TOLERANCE, 0},
{203, 1062668861u, 1065307636u, 1065307636u, 0, ASIN_TOLERANCE, 0},
{204, 1062836634u, 1065487311u, 1065487311u, 0, ASIN_TOLERANCE, 0},
{205, 1063004406u, 1065649080u, 1065649080u, 0, ASIN_TOLERANCE, 0},
{206, 1063172178u, 1065816287u, 1065816287u, 0, ASIN_TOLERANCE, 0},
{207, 1063339950u, 1065989594u, 1065989594u, 0, ASIN_TOLERANCE, 0},
{208, 1063507722u, 1066169806u, 1066169806u, 0, ASIN_TOLERANCE, 0},
{209, 1063675494u, 1066357916u, 1066357916u, 0, ASIN_TOLERANCE, 0},
{210, 1063843267u, 1066555171u, 1066555171u, 0, ASIN_TOLERANCE, 0},
{211, 1064011039u, 1066763178u, 1066763178u, 0, ASIN_TOLERANCE, 0},
{212, 1064178811u, 1066984070u, 1066984070u, 0, ASIN_TOLERANCE, 0},
{213, 1064346583u, 1067220775u, 1067220775u, 0, ASIN_TOLERANCE, 0},
{214, 1064514355u, 1067477513u, 1067477513u, 0, ASIN_TOLERANCE, 0},
{215, 1064682127u, 1067760765u, 1067760765u, 0, ASIN_TOLERANCE, 0},
{216, 1064849900u, 1068081451u, 1068081451u, 0, ASIN_TOLERANCE, 0},
{217, 1065017672u, 1068460873u, 1068460873u, 0, ASIN_TOLERANCE, 0},
{218, 1065185444u, 1068954084u, 1068954084u, 0, ASIN_TOLERANCE, 0},
{219, 1065353216u, 1070141403u, 1070141403u, 0, ASIN_TOLERANCE, 0},
{220, 1065437102u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{221, 1065520988u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{222, 1065604874u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{223, 1065688760u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{224, 1065772646u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{225, 1065856532u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{226, 1065940419u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{227, 1066024305u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{228, 1066108191u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{229, 1066192077u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{230, 1066275963u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{231, 1066359849u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{232, 1066443735u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{233, 1066527621u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{234, 1066611507u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{235, 1066695393u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{236, 1066779279u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{237, 1066863165u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{238, 1066947052u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{239, 3234402267u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{240, 3231108068u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{241, 3226013659u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{242, 3217625051u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{243, 0u, 0u, 0u, 0, ASIN_TOLERANCE, 0},
{244, 1070141403u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{245, 1078530011u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{246, 1083624420u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{247, 3253731328u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{248, 3252840038u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{249, 3251948749u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{250, 3251057459u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{251, 3250166170u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{252, 3249274880u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{253, 3248383590u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{254, 3247492301u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{255, 3246601011u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{256, 3245028147u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{257, 3243245568u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{258, 3241462989u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{259, 3239680410u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{260, 3237792973u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{261, 3234227814u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{262, 3230662656u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{263, 3224580915u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{264, 3213675725u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{265, 1058642330u, 1059372158u, 1059372158u, 0, ASIN_TOLERANCE, 0},
{266, 1075000115u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{267, 1082130432u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{268, 1085695590u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{269, 1089260749u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{270, 1091672474u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{271, 1093455053u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{272, 1095237632u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{273, 1097020211u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{274, 1098802790u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{275, 1099746509u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{276, 1100637798u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{277, 1101529088u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{278, 1102420378u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{279, 1103311667u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{280, 1104202957u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{281, 1105094246u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{282, 1105985536u, 1115684864u, 2143289344u, EDOM, ASIN_TOLERANCE, 0},
{283, 0u, 3169600404u, 0u, 0, ASIN_TOLERANCE, 0},
{284, 0u, 1339715816u, 0u, 0, ASIN_TOLERANCE, 0},
{285, 0u, 1137623440u, 0u, 0, ASIN_TOLERANCE, 0},
{286, 0u, 1318077703u, 0u, 0, ASIN_TOLERANCE, 0},
{287, 0u, 3138716210u, 0u, 0, ASIN_TOLERANCE, 0},
{288, 0u, 956731690u, 0u, 0, ASIN_TOLERANCE, 0},
{289, 0u, 3090780435u, 0u, 0, ASIN_TOLERANCE, 0},
{290, 0u, 1184078964u, 0u, 0, ASIN_TOLERANCE, 0},
{291, 0u, 805930990u, 0u, 0, ASIN_TOLERANCE, 0},
{292, 0u, 2961815950u, 0u, 0, ASIN_TOLERANCE, 0},
{293, 0u, 3293150194u, 0u, 0, ASIN_TOLERANCE, 0},
{294, 0u, 3446630737u, 0u, 0, ASIN_TOLERANCE, 0},
{295, 3207495939u, 1009178246u, 3208642957u, 0, ASIN_TOLERANCE, 0},
{296, 0u, 1011741316u, 0u, 0, ASIN_TOLERANCE, 0},
{297, 0u, 924152434u, 0u, 0, ASIN_TOLERANCE, 0},
{298, 0u, 1046519338u, 0u, 0, ASIN_TOLERANCE, 0},
{299, 0u, 843024648u, 0u, 0, ASIN_TOLERANCE, 0},
{300, 0u, 1207613046u, 0u, 0, ASIN_TOLERANCE, 0},
{301, 0u, 3373702511u, 0u, 0, ASIN_TOLERANCE, 0},
{302, 0u, 1287042017u, 0u, 0, ASIN_TOLERANCE, 0},
{303, 0u, 3174764041u, 0u, 0, ASIN_TOLERANCE, 0},
{304, 0u, 3366639803u, 0u, 0, ASIN_TOLERANCE, 0},
{305, 0u, 927668332u, 0u, 0, ASIN_TOLERANCE, 0},
{306, 0u, 1231561331u, 0u, 0, ASIN_TOLERANCE, 0},
{307, 0u, 846986655u, 0u, 0, ASIN_TOLERANCE, 0},
{308, 0u, 1325838529u, 0u, 0, ASIN_TOLERANCE, 0},
{309, 0u, 2994813381u, 0u, 0, ASIN_TOLERANCE, 0},
{310, 0u, 1319183848u, 0u, 0, ASIN_TOLERANCE, 0},
{311, 0u, 3059184837u, 0u, 0, ASIN_TOLERANCE, 0},
{312, 0u, 3234638157u, 0u, 0, ASIN_TOLERANCE, 0},
{313, 0u, 3468333016u, 0u, 0, ASIN_TOLERANCE, 0},
{314, 0u, 973297633u, 0u, 0, ASIN_TOLERANCE, 0},
{315, 0u, 3060497453u, 0u, 0, ASIN_TOLERANCE, 0},
{316, 0u, 3053313644u, 0u, 0, ASIN_TOLERANCE, 0},
{317, 0u, 905204998u, 0u, 0, ASIN_TOLERANCE, 0},
{318, 0u, 1031869860u, 0u, 0, ASIN_TOLERANCE, 0},
{319, 0u, 3090663336u, 0u, 0, ASIN_TOLERANCE, 0},
{320, 0u, 3325365308u, 0u, 0, ASIN_TOLERANCE, 0},
{321, 0u, 1222145080u, 0u, 0, ASIN_TOLERANCE, 0},
{322, 0u, 3182301130u, 0u, 0, ASIN_TOLERANCE, 0},
{323, 0u, 3141898978u, 0u, 0, ASIN_TOLERANCE, 0},
{324, 0u, 3250208698u, 0u, 0, ASIN_TOLERANCE, 0},
{325, 0u, 850607273u, 0u, 0, ASIN_TOLERANCE, 0},
{326, 0u, 986147596u, 0u, 0, ASIN_TOLERANCE, 0},
{327, 0u, 817336158u, 0u, 0, ASIN_TOLERANCE, 0},
{328, 0u, 1228929743u, 0u, 0, ASIN_TOLERANCE, 0},
{329, 0u, 1285620759u, 0u, 0, ASIN_TOLERANCE, 0},
{330, 0u, 3150558310u, 0u, 0, ASIN_TOLERANCE, 0},
{331, 0u, 1026729590u, 0u, 0, ASIN_TOLERANCE, 0},
{332, 0u, 1322457908u, 0u, 0, ASIN_TOLERANCE, 0},
{333, 0u, 3293402534u, 0u, 0, ASIN_TOLERANCE, 0},
{334, 0u, 3376286224u, 0u, 0, ASIN_TOLERANCE, 0},
{335, 0u, 1262396132u, 0u, 0, ASIN_TOLERANCE, 0},
{336, 0u, 3357890790u, 0u, 0, ASIN_TOLERANCE, 0},
{337, 0u, 1227031652u, 0u, 0, ASIN_TOLERANCE, 0},
{338, 0u, 3486821126u, 0u, 0, ASIN_TOLERANCE, 0},
{339, 0u, 3361769033u, 0u, 0, ASIN_TOLERANCE, 0},
{340, 0u, 3099071752u, 0u, 0, ASIN_TOLERANCE, 0},
{341, 3064942859u, 3410406460u, 3064942859u, 0, ASIN_TOLERANCE, 0},
{342, 0u, 1218561473u, 0u, 0, ASIN_TOLERANCE, 0},
{343, 0u, 936690127u, 0u, 0, ASIN_TOLERANCE, 0},
{344, 0u, 1127391340u, 0u, 0, ASIN_TOLERANCE, 0},
{345, 0u, 3036142101u, 0u, 0, ASIN_TOLERANCE, 0},
{346, 0u, 3471390739u, 0u, 0, ASIN_TOLERANCE, 0},
{347, 0u, 3241193975u, 0u, 0, ASIN_TOLERANCE, 0},
{348, 0u, 820404624u, 0u, 0, ASIN_TOLERANCE, 0},
{349, 0u, 905618576u, 0u, 0, ASIN_TOLERANCE, 0},
{350, 0u, 1263769881u, 0u, 0, ASIN_TOLERANCE, 0},
{351, 0u, 3422581846u, 0u, 0, ASIN_TOLERANCE, 0},
{352, 0u, 3020874439u, 0u, 0, ASIN_TOLERANCE, 0},
{353, 1044854841u, 3441293384u, 1044938638u, 0, ASIN_TOLERANCE, 0},
{354, 0u, 1327700779u, 0u, 0, ASIN_TOLERANCE, 0},
{355, 0u, 1053048637u, 0u, 0, ASIN_TOLERANCE, 0},
{356, 0u, 3390124302u, 0u, 0, ASIN_TOLERANCE, 0},
{357, 0u, 1326155577u, 0u, 0, ASIN_TOLERANCE, 0},
{358, 0u, 3009485985u, 0u, 0, ASIN_TOLERANCE, 0},
{359, 0u, 976507183u, 0u, 0, ASIN_TOLERANCE, 0},
{360, 0u, 3465702297u, 0u, 0, ASIN_TOLERANCE, 0},
{361, 0u, 3162613159u, 0u, 0, ASIN_TOLERANCE, 0},
{362, 0u, 3424831780u, 0u, 0, ASIN_TOLERANCE, 0},
{363, 0u, 1315193884u, 0u, 0, ASIN_TOLERANCE, 0},
{364, 0u, 3393434856u, 0u, 0, ASIN_TOLERANCE, 0},
{365, 0u, 3075595653u, 0u, 0, ASIN_TOLERANCE, 0},
{366, 0u, 1073959932u, 0u, 0, ASIN_TOLERANCE, 0},
{367, 0u, 984063398u, 0u, 0, ASIN_TOLERANCE, 0},
{368, 0u, 3051776777u, 0u, 0, ASIN_TOLERANCE, 0},
{369, 0u, 3333928591u, 0u, 0, ASIN_TOLERANCE, 0},
{370, 0u, 3277810397u, 0u, 0, ASIN_TOLERANCE, 0},
{371, 0u, 3375812155u, 0u, 0, ASIN_TOLERANCE, 0},
{372, 0u, 879559037u, 0u, 0, ASIN_TOLERANCE, 0},
{373, 0u, 3359727790u, 0u, 0, ASIN_TOLERANCE, 0},
{374, 0u, 1094033983u, 0u, 0, ASIN_TOLERANCE, 0},
{375, 0u, 965490084u, 0u, 0, ASIN_TOLERANCE, 0},
{376, 0u, 1063615282u, 0u, 0, ASIN_TOLERANCE, 0},
{377, 0u, 916132262u, 0u, 0, ASIN_TOLERANCE, 0},
{378, 0u, 3214499901u, 0u, 0, ASIN_TOLERANCE, 0},
{379, 0u, 1149498437u, 0u, 0, ASIN_TOLERANCE, 0},
{380, 0u, 957867294u, 0u, 0, ASIN_TOLERANCE, 0},
{381, 0u, 1292682598u, 0u, 0, ASIN_TOLERANCE, 0},
{382, 0u, 3181128080u, 0u, 0, ASIN_TOLERANCE, 0},
{383, 1034143548u, 3146558751u, 1034155022u, 0, ASIN_TOLERANCE, 0},
{384, 0u, 3118386084u, 0u, 0, ASIN_TOLERANCE, 0},
{385, 0u, 3281577923u, 0u, 0, ASIN_TOLERANCE, 0},
{386, 0u, 3108459270u, 0u, 0, ASIN_TOLERANCE, 0},
{387, 0u, 877939434u, 0u, 0, ASIN_TOLERANCE, 0},
{388, 0u, 1092863108u, 0u, 0, ASIN_TOLERANCE, 0},
{389, 0u, 2984618214u, 0u, 0, ASIN_TOLERANCE, 0},
{390, 0u, 3230867340u, 0u, 0, ASIN_TOLERANCE, 0},
{391, 0u, 1299947984u, 0u, 0, ASIN_TOLERANCE, 0},
{392, 0u, 1014533799u, 0u, 0, ASIN_TOLERANCE, 0},
{393, 0u, 3294931045u, 0u, 0, ASIN_TOLERANCE, 0},
{394, 0u, 1234530539u, 0u, 0, ASIN_TOLERANCE, 0},
{395, 0u, 1167174417u, 0u, 0, ASIN_TOLERANCE, 0},
{396, 0u, 1033515667u, 0u, 0, ASIN_TOLERANCE, 0},
{397, 0u, 3461029208u, 0u, 0, ASIN_TOLERANCE, 0},
{398, 0u, 2963999387u, 0u, 0, ASIN_TOLERANCE, 0},
{399, 0u, 1289841195u, 0u, 0, ASIN_TOLERANCE, 0},
{400, 0u, 991614550u, 0u, 0, ASIN_TOLERANCE, 0},
{401, 0u, 3005733479u, 0u, 0, ASIN_TOLERANCE, 0},
{402, 0u, 3028772689u, 0u, 0, ASIN_TOLERANCE, 0},
{403, 0u, 3461908440u, 0u, 0, ASIN_TOLERANCE, 0},
{404, 0u, 3395559071u, 0u, 0, ASIN_TOLERANCE, 0},
{405, 0u, 3386631630u, 0u, 0, ASIN_TOLERANCE, 0},
{406, 0u, 1302044669u, 0u, 0, ASIN_TOLERANCE, 0},
{407, 0u, 3136041385u, 0u, 0, ASIN_TOLERANCE, 0},
{408, 0u, 819212976u, 0u, 0, ASIN_TOLERANCE, 0},
{409, 0u, 1308276557u, 0u, 0, ASIN_TOLERANCE, 0},
{410, 0u, 890279471u, 0u, 0, ASIN_TOLERANCE, 0},
{411, 0u, 3391162308u, 0u, 0, ASIN_TOLERANCE, 0},
{412, 0u, 3366933172u, 0u, 0, ASIN_TOLERANCE, 0},
{413, 0u, 2972468923u, 0u, 0, ASIN_TOLERANCE, 0},
{414, 0u, 1096223283u, 0u, 0, ASIN_TOLERANCE, 0},
{415, 0u, 2985540645u, 0u, 0, ASIN_TOLERANCE, 0},
{416, 0u, 3045939684u, 0u, 0, ASIN_TOLERANCE, 0},
{417, 0u, 3289105549u, 0u, 0, ASIN_TOLERANCE, 0},
{418, 0u, 3118459546u, 0u, 0, ASIN_TOLERANCE, 0},
{419, 0u, 805655869u, 0u, 0, ASIN_TOLERANCE, 0},
{420, 0u, 1298783885u, 0u, 0, ASIN_TOLERANCE, 0},
{421, 0u, 3314827933u, 0u, 0, ASIN_TOLERANCE, 0},
{422, 0u, 1010844213u, 0u, 0, ASIN_TOLERANCE, 0},
{423, 0u, 3185364965u, 0u, 0, ASIN_TOLERANCE, 0},
{424, 0u, 1196910312u, 0u, 0, ASIN_TOLERANCE, 0},
{425, 0u, 3036177925u, 0u, 0, ASIN_TOLERANCE, 0},
{426, 0u, 1260339199u, 0u, 0, ASIN_TOLERANCE, 0},
{427, 0u, 3421558958u, 0u, 0, ASIN_TOLERANCE, 0},
{428, 1009721212u, 1046112320u, 1009721431u, 0, ASIN_TOLERANCE, 0},
{429, 0u, 3361661885u, 0u, 0, ASIN_TOLERANCE, 0},
{430, 0u, 927278934u, 0u, 0, ASIN_TOLERANCE, 0},
{431, 0u, 3168337905u, 0u, 0, ASIN_TOLERANCE, 0},
{432, 3209292679u, 3097629295u, 3211306330u, 0, ASIN_TOLERANCE, 0},
{433, 0u, 900870557u, 0u, 0, ASIN_TOLERANCE, 0},
{434, 0u, 1018873558u, 0u, 0, ASIN_TOLERANCE, 0},
{435, 0u, 1336758936u, 0u, 0, ASIN_TOLERANCE, 0},
{436, 0u, 3333739154u, 0u, 0, ASIN_TOLERANCE, 0},
{437, 0u, 1320787767u, 0u, 0, ASIN_TOLERANCE, 0},
{438, 0u, 3388356571u, 0u, 0, ASIN_TOLERANCE, 0},
{439, 0u, 1178658982u, 0u, 0, ASIN_TOLERANCE, 0},
{440, 0u, 1052318349u, 0u, 0, ASIN_TOLERANCE, 0},
{441, 0u, 1305787839u, 0u, 0, ASIN_TOLERANCE, 0},
{442, 0u, 3343304699u, 0u, 0, ASIN_TOLERANCE, 0},
{443, 0u, 3210802820u, 0u, 0, ASIN_TOLERANCE, 0},
{444, 0u, 2981916252u, 0u, 0, ASIN_TOLERANCE, 0},
{445, 0u, 3331408262u, 0u, 0, ASIN_TOLERANCE, 0},
{446, 0u, 3398215908u, 0u, 0, ASIN_TOLERANCE, 0},
{447, 0u, 1200012284u, 0u, 0, ASIN_TOLERANCE, 0},
{448, 0u, 3334899880u, 0u, 0, ASIN_TOLERANCE, 0},
{449, 0u, 3254921054u, 0u, 0, ASIN_TOLERANCE, 0},
{450, 0u, 1327067896u, 0u, 0, ASIN_TOLERANCE, 0},
{451, 0u, 3322159484u, 0u, 0, ASIN_TOLERANCE, 0},
{452, 0u, 1170972749u, 0u, 0, ASIN_TOLERANCE, 0},
{453, 0u, 1088950833u, 0u, 0, ASIN_TOLERANCE, 0},
{454, 0u, 1021298336u, 0u, 0, ASIN_TOLERANCE, 0},
{455, 0u, 3396911457u, 0u, 0, ASIN_TOLERANCE, 0},
{456, 0u, 1226465223u, 0u, 0, ASIN_TOLERANCE, 0},
{457, 0u, 3032345638u, 0u, 0, ASIN_TOLERANCE, 0},
{458, 0u, 3372887038u, 0u, 0, ASIN_TOLERANCE, 0},
{459, 0u, 3047298800u, 0u, 0, ASIN_TOLERANCE, 0},
{460, 0u, 1328903537u, 0u, 0, ASIN_TOLERANCE, 0},
{461, 0u, 943122002u, 0u, 0, ASIN_TOLERANCE, 0},
{462, 0u, 3240474694u, 0u, 0, ASIN_TOLERANCE, 0},
{463, 0u, 1321478210u, 0u, 0, ASIN_TOLERANCE, 0},
{464, 0u, 3150110905u, 0u, 0, ASIN_TOLERANCE, 0},
{465, 1044716314u, 1175058883u, 1044797442u, 0, ASIN_TOLERANCE, 0},
{466, 0u, 1113112437u, 0u, 0, ASIN_TOLERANCE, 0},
{467, 0u, 1133955508u, 0u, 0, ASIN_TOLERANCE, 0},
{468, 0u, 3322269242u, 0u, 0, ASIN_TOLERANCE, 0},
{469, 0u, 1007037967u, 0u, 0, ASIN_TOLERANCE, 0},
{470, 0u, 1034712760u, 0u, 0, ASIN_TOLERANCE, 0},
{471, 0u, 3242154340u, 0u, 0, ASIN_TOLERANCE, 0},
{472, 0u, 3198746395u, 0u, 0, ASIN_TOLERANCE, 0},
{473, 0u, 871518549u, 0u, 0, ASIN_TOLERANCE, 0},
{474, 0u, 1076307289u, 0u, 0, ASIN_TOLERANCE, 0},
{475, 0u, 1093265845u, 0u, 0, ASIN_TOLERANCE, 0},
{476, 0u, 3425791859u, 0u, 0, ASIN_TOLERANCE, 0},
{477, 0u, 1132019346u, 0u, 0, ASIN_TOLERANCE, 0},
{478, 0u, 3188748064u, 0u, 0, ASIN_TOLERANCE, 0},
{479, 0u, 2959991506u, 0u, 0, ASIN_TOLERANCE, 0},
{480, 0u, 3424322165u, 0u, 0, ASIN_TOLERANCE, 0},
{481, 0u, 3159354376u, 0u, 0, ASIN_TOLERANCE, 0},
{482, 0u, 3191112451u, 0u, 0, ASIN_TOLERANCE, 0},
{483, 0u, 3268491661u, 0u, 0, ASIN_TOLERANCE, 0},
{484, 0u, 1228416507u, 0u, 0, ASIN_TOLERANCE, 0},
{485, 0u, 1006050163u, 0u, 0, ASIN_TOLERANCE, 0},
{486, 0u, 3194999530u, 0u, 0, ASIN_TOLERANCE, 0},
{487, 0u, 3455139526u, 0u, 0, ASIN_TOLERANCE, 0},
{488, 0u, 1028994668u, 0u, 0, ASIN_TOLERANCE, 0},
{489, 0u, 827857784u, 0u, 0, ASIN_TOLERANCE, 0},
{490, 0u, 1089013253u, 0u, 0, ASIN_TOLERANCE, 0},
{491, 0u, 3332044773u, 0u, 0, ASIN_TOLERANCE, 0},
{492, 0u, 955602880u, 0u, 0, ASIN_TOLERANCE, 0},
{493, 0u, 834883605u, 0u, 0, ASIN_TOLERANCE, 0},
{494, 0u, 2967925613u, 0u, 0, ASIN_TOLERANCE, 0},
{495, 0u, 3273003721u, 0u, 0, ASIN_TOLERANCE, 0},
{496, 0u, 3114823772u, 0u, 0, ASIN_TOLERANCE, 0},
{497, 0u, 2978999239u, 0u, 0, ASIN_TOLERANCE, 0},
{498, 0u, 1241824475u, 0u, 0, ASIN_TOLERANCE, 0},
{499, 0u, 1331775131u, 0u, 0, ASIN_TOLERANCE, 0},
{500, 0u, 3141296194u, 0u, 0, ASIN_TOLERANCE, 0},
{501, 0u, 1337844885u, 0u, 0, ASIN_TOLERANCE, 0},
{502, 0u, 3106714954u, 0u, 0, ASIN_TOLERANCE, 0},
{503, 0u, 3096592046u, 0u, 0, ASIN_TOLERANCE, 0},
{504, 0u, 1073304723u, 0u, 0, ASIN_TOLERANCE, 0},
{505, 0u, 1241050896u, 0u, 0, ASIN_TOLERANCE, 0},
{506, 0u, 3396048528u, 0u, 0, ASIN_TOLERANCE, 0},
{507, 0u, 815233034u, 0u, 0, ASIN_TOLERANCE, 0},
{508, 0u, 1336420810u, 0u, 0, ASIN_TOLERANCE, 0},
{509, 0u, 3385978192u, 0u, 0, ASIN_TOLERANCE, 0},
{510, 0u, 865415249u, 0u, 0, ASIN_TOLERANCE, 0},
{511, 0u, 1098069770u, 0u, 0, ASIN_TOLERANCE, 0},
{512, 0u, 1309182624u, 0u, 0, ASIN_TOLERANCE, 0},
{513, 0u, 3090687943u, 0u, 0, ASIN_TOLERANCE, 0},
{514, 0u, 3294568849u, 0u, 0, ASIN_TOLERANCE, 0},
{515, 0u, 1248962235u, 0u, 0, ASIN_TOLERANCE, 0},
{516, 0u, 1181971466u, 0u, 0, ASIN_TOLERANCE, 0},
{517, 0u, 3364325750u, 0u, 0, ASIN_TOLERANCE, 0},
{518, 0u, 3438080027u, 0u, 0, ASIN_TOLERANCE, 0},
{519, 0u, 1092687408u, 0u, 0, ASIN_TOLERANCE, 0},
{520, 0u, 3314756782u, 0u, 0, ASIN_TOLERANCE, 0},
{521, 3155280708u, 1025618776u, 3155280834u, 0, ASIN_TOLERANCE, 0},
{522, 3157435720u, 933489446u, 3157435952u, 0, ASIN_TOLERANCE, 0},
{523, 0u, 1124703898u, 0u, 0, ASIN_TOLERANCE, 0},
{524, 0u, 988628692u, 0u, 0, ASIN_TOLERANCE, 0},
{525, 0u, 3448856777u, 0u, 0, ASIN_TOLERANCE, 0},
{526, 0u, 3203377685u, 0u, 0, ASIN_TOLERANCE, 0},
{527, 0u, 811346780u, 0u, 0, ASIN_TOLERANCE, 0},
{528, 0u, 3263906037u, 0u, 0, ASIN_TOLERANCE, 0},
{529, 0u, 3005448018u, 0u, 0, ASIN_TOLERANCE, 0},
{530, 0u, 983776939u, 0u, 0, ASIN_TOLERANCE, 0},
{531, 0u, 3283111355u, 0u, 0, ASIN_TOLERANCE, 0},
{532, 0u, 3483799470u, 0u, 0, ASIN_TOLERANCE, 0},
{533, 0u, 1224362550u, 0u, 0, ASIN_TOLERANCE, 0},
{534, 0u, 989304021u, 0u, 0, ASIN_TOLERANCE, 0},
{535, 0u, 1266021967u, 0u, 0, ASIN_TOLERANCE, 0},
{536, 0u, 821670697u, 0u, 0, ASIN_TOLERANCE, 0},
{537, 0u, 1094961730u, 0u, 0, ASIN_TOLERANCE, 0},
{538, 0u, 865575622u, 0u, 0, ASIN_TOLERANCE, 0},
{539, 0u, 3105373037u, 0u, 0, ASIN_TOLERANCE, 0},
{540, 0u, 3230771910u, 0u, 0, ASIN_TOLERANCE, 0},
{541, 0u, 3018555990u, 0u, 0, ASIN_TOLERANCE, 0},
{542, 0u, 976031447u, 0u, 0, ASIN_TOLERANCE, 0},
{543, 0u, 1176712907u, 0u, 0, ASIN_TOLERANCE, 0},
{544, 0u, 3060368257u, 0u, 0, ASIN_TOLERANCE, 0},
{545, 0u, 3445308988u, 0u, 0, ASIN_TOLERANCE, 0},
{546, 0u, 3180028770u, 0u, 0, ASIN_TOLERANCE, 0},
{547, 0u, 1124209516u, 0u, 0, ASIN_TOLERANCE, 0},
{548, 0u, 1336654718u, 0u, 0, ASIN_TOLERANCE, 0},
{549, 0u, 947482291u, 0u, 0, ASIN_TOLERANCE, 0},
{550, 0u, 3118293357u, 0u, 0, ASIN_TOLERANCE, 0},
{551, 0u, 3118498177u, 0u, 0, ASIN_TOLERANCE, 0},
{552, 0u, 3229444200u, 0u, 0, ASIN_TOLERANCE, 0},
{553, 0u, 3258228828u, 0u, 0, ASIN_TOLERANCE, 0},
{554, 0u, 922323270u, 0u, 0, ASIN_TOLERANCE, 0},
{555, 0u, 3114663401u, 0u, 0, ASIN_TOLERANCE, 0},
{556, 0u, 885324962u, 0u, 0, ASIN_TOLERANCE, 0},
{557, 0u, 1317998064u, 0u, 0, ASIN_TOLERANCE, 0},
{558, 0u, 3403521222u, 0u, 0, ASIN_TOLERANCE, 0},
{559, 0u, 994818884u, 0u, 0, ASIN_TOLERANCE, 0},
{560, 0u, 3308921926u, 0u, 0, ASIN_TOLERANCE, 0},
{561, 0u, 837597103u, 0u, 0, ASIN_TOLERANCE, 0},
{562, 0u, 818395888u, 0u, 0, ASIN_TOLERANCE, 0},
{563, 0u, 3385546293u, 0u, 0, ASIN_TOLERANCE, 0},
{564, 0u, 1307494704u, 0u, 0, ASIN_TOLERANCE, 0},
{565, 0u, 3195630702u, 0u, 0, ASIN_TOLERANCE, 0},
{566, 0u, 3452970791u, 0u, 0, ASIN_TOLERANCE, 0},
{567, 0u, 969181440u, 0u, 0, ASIN_TOLERANCE, 0},
{568, 0u, 3198823742u, 0u, 0, ASIN_TOLERANCE, 0},
{569, 0u, 859215836u, 0u, 0, ASIN_TOLERANCE, 0},
{570, 0u, 1032431894u, 0u, 0, ASIN_TOLERANCE, 0},
{571, 0u, 1317167489u, 0u, 0, ASIN_TOLERANCE, 0},
{572, 0u, 1168321640u, 0u, 0, ASIN_TOLERANCE, 0},
{573, 0u, 3419973892u, 0u, 0, ASIN_TOLERANCE, 0},
{574, 0u, 3233127658u, 0u, 0, ASIN_TOLERANCE, 0},
{575, 0u, 3080940727u, 0u, 0, ASIN_TOLERANCE, 0},
{576, 0u, 3347164575u, 0u, 0, ASIN_TOLERANCE, 0},
{577, 0u, 1252328733u, 0u, 0, ASIN_TOLERANCE, 0},
{578, 0u, 3419080316u, 0u, 0, ASIN_TOLERANCE, 0},
{579, 0u, 2972433958u, 0u, 0, ASIN_TOLERANCE, 0},
{580, 0u, 1116045545u, 0u, 0, ASIN_TOLERANCE, 0},
{581, 0u, 998741069u, 0u, 0, ASIN_TOLERANCE, 0},
{582, 957816867u, 3201187455u, 957816867u, 0, ASIN_TOLERANCE, 0},
{583, 0u, 3053678168u, 0u, 0, ASIN_TOLERANCE, 0},
{584, 0u, 1305765795u, 0u, 0, ASIN_TOLERANCE, 0},
{585, 0u, 1103014375u, 0u, 0, ASIN_TOLERANCE, 0},
{586, 0u, 3232872279u, 0u, 0, ASIN_TOLERANCE, 0},
{587, 0u, 1181934749u, 0u, 0, ASIN_TOLERANCE, 0},
{588, 0u, 1190838126u, 0u, 0, ASIN_TOLERANCE, 0},
{589, 0u, 867988931u, 0u, 0, ASIN_TOLERANCE, 0},
{590, 0u, 991229856u, 0u, 0, ASIN_TOLERANCE, 0},
{591, 0u, 3364998151u, 0u, 0, ASIN_TOLERANCE, 0},
{592, 0u, 1315543293u, 0u, 0, ASIN_TOLERANCE, 0},
{593, 0u, 1057448325u, 0u, 0, ASIN_TOLERANCE, 0},
{594, 0u, 1267482842u, 0u, 0, ASIN_TOLERANCE, 0},
{595, 0u, 934466263u, 0u, 0, ASIN_TOLERANCE, 0},
{596, 0u, 1245869105u, 0u, 0, ASIN_TOLERANCE, 0},
{597, 0u, 1108490809u, 0u, 0, ASIN_TOLERANCE, 0},
{598, 0u, 3400104881u, 0u, 0, ASIN_TOLERANCE, 0},
{599, 0u, 1319516167u, 0u, 0, ASIN_TOLERANCE, 0},
{600, 0u, 1340013152u, 0u, 0, ASIN_TOLERANCE, 0},
{601, 0u, 1178045349u, 0u, 0, ASIN_TOLERANCE, 0},
{602, 0u, 999587166u, 0u, 0, ASIN_TOLERANCE, 0},
{603, 0u, 1311927022u, 0u, 0, ASIN_TOLERANCE, 0},
{604, 0u, 3367551312u, 0u, 0, ASIN_TOLERANCE, 0},
{605, 0u, 1288794633u, 0u, 0, ASIN_TOLERANCE, 0},
{606, 0u, 3187139195u, 0u, 0, ASIN_TOLERANCE, 0},
{607, 0u, 3454228018u, 0u, 0, ASIN_TOLERANCE, 0},
{608, 0u, 1027563924u, 0u, 0, ASIN_TOLERANCE, 0},
{609, 0u, 1113104661u, 0u, 0, ASIN_TOLERANCE, 0},
{610, 0u, 3245719778u, 0u, 0, ASIN_TOLERANCE, 0},
{611, 0u, 3316389232u, 0u, 0, ASIN_TOLERANCE, 0},
{612, 0u, 1282310126u, 0u, 0, ASIN_TOLERANCE, 0},
{613, 0u, 1054537352u, 0u, 0, ASIN_TOLERANCE, 0},
{614, 0u, 1030482448u, 0u, 0, ASIN_TOLERANCE, 0},
{615, 0u, 898656161u, 0u, 0, ASIN_TOLERANCE, 0},
{616, 0u, 3168363256u, 0u, 0, ASIN_TOLERANCE, 0},
{617, 0u, 3100289712u, 0u, 0, ASIN_TOLERANCE, 0},
{618, 0u, 1002569587u, 0u, 0, ASIN_TOLERANCE, 0},
{619, 0u, 1295189320u, 0u, 0, ASIN_TOLERANCE, 0},
{620, 0u, 3292709189u, 0u, 0, ASIN_TOLERANCE, 0},
{621, 0u, 1154162408u, 0u, 0, ASIN_TOLERANCE, 0},
{622, 0u, 1163075690u, 0u, 0, ASIN_TOLERANCE, 0},
{623, 0u, 876100581u, 0u, 0, ASIN_TOLERANCE, 0},
{624, 0u, 2992721023u, 0u, 0, ASIN_TOLERANCE, 0},
{625, 0u, 822384047u, 0u, 0, ASIN_TOLERANCE, 0},
{626, 0u, 1028558726u, 0u, 0, ASIN_TOLERANCE, 0},
{627, 0u, 979448121u, 0u, 0, ASIN_TOLERANCE, 0},
{628, 0u, 1258114435u, 0u, 0, ASIN_TOLERANCE, 0},
{629, 0u, 3391984950u, 0u, 0, ASIN_TOLERANCE, 0},
{630, 0u, 3106769746u, 0u, 0, ASIN_TOLERANCE, 0},
{631, 0u, 3401317856u, 0u, 0, ASIN_TOLERANCE, 0},
{632, 0u, 941984293u, 0u, 0, ASIN_TOLERANCE, 0},
{633, 0u, 3104817582u, 0u, 0, ASIN_TOLERANCE, 0},
{634, 0u, 887134496u, 0u, 0, ASIN_TOLERANCE, 0},
{635, 0u, 3355201503u, 0u, 0, ASIN_TOLERANCE, 0},
{636, 0u, 977588436u, 0u, 0, ASIN_TOLERANCE, 0},
{637, 0u, 1191609115u, 0u, 0, ASIN_TOLERANCE, 0},
{638, 0u, 1047298999u, 0u, 0, ASIN_TOLERANCE, 0},
{639, 0u, 3483356946u, 0u, 0, ASIN_TOLERANCE, 0},
{640, 0u, 3353529760u, 0u, 0, ASIN_TOLERANCE, 0},
{641, 0u, 928612885u, 0u, 0, ASIN_TOLERANCE, 0},
{642, 0u, 3162606086u, 0u, 0, ASIN_TOLERANCE, 0},
{643, 3042097453u, 3471777274u, 3042097453u, 0, ASIN_TOLERANCE, 0},
{644, 0u, 3202575407u, 0u, 0, ASIN_TOLERANCE, 0},
{645, 0u, 1255148034u, 0u, 0, ASIN_TOLERANCE, 0},
{646, 0u, 1218488455u, 0u, 0, ASIN_TOLERANCE, 0},
{647, 0u, 1043585640u, 0u, 0, ASIN_TOLERANCE, 0},
{648, 0u, 860904453u, 0u, 0, ASIN_TOLERANCE, 0},
{649, 0u, 3070312723u, 0u, 0, ASIN_TOLERANCE, 0},
{650, 0u, 3269996350u, 0u, 0, ASIN_TOLERANCE, 0},
{651, 0u, 3451862908u, 0u, 0, ASIN_TOLERANCE, 0},
{652, 0u, 3159551767u, 0u, 0, ASIN_TOLERANCE, 0},
{653, 0u, 3150026558u, 0u, 0, ASIN_TOLERANCE, 0},
{654, 0u, 3018474595u, 0u, 0, ASIN_TOLERANCE, 0},
{655, 0u, 3092228268u, 0u, 0, ASIN_TOLERANCE, 0},
{656, 0u, 3177295669u, 0u, 0, ASIN_TOLERANCE, 0},
{657, 0u, 1281912088u, 0u, 0, ASIN_TOLERANCE, 0},
{658, 0u, 1011694414u, 0u, 0, ASIN_TOLERANCE, 0},
{659, 0u, 3017590098u, 0u, 0, ASIN_TOLERANCE, 0},
{660, 0u, 932275550u, 0u, 0, ASIN_TOLERANCE, 0},
{661, 0u, 925977317u, 0u, 0, ASIN_TOLERANCE, 0},
{662, 0u, 3172338958u, 0u, 0, ASIN_TOLERANCE, 0},
{663, 0u, 950074301u, 0u, 0, ASIN_TOLERANCE, 0},
{664, 0u, 1031925638u, 0u, 0, ASIN_TOLERANCE, 0},
{665, 0u, 3234909547u, 0u, 0, ASIN_TOLERANCE, 0},
{666, 0u, 1309726409u, 0u, 0, ASIN_TOLERANCE, 0},
{667, 0u, 2975716887u, 0u, 0, ASIN_TOLERANCE, 0},
{668, 0u, 3070622494u, 0u, 0, ASIN_TOLERANCE, 0},
{669, 3097616807u, 1185177793u, 3097616807u, 0, ASIN_TOLERANCE, 0},
{670, 0u, 1086032676u, 0u, 0, ASIN_TOLERANCE, 0},
{671, 0u, 3143814681u, 0u, 0, ASIN_TOLERANCE, 0},
{672, 0u, 3071087132u, 0u, 0, ASIN_TOLERANCE, 0},
{673, 0u, 868114980u, 0u, 0, ASIN_TOLERANCE, 0},
{674, 0u, 1082239587u, 0u, 0, ASIN_TOLERANCE, 0},
{675, 928394985u, 3470455863u, 928394985u, 0, ASIN_TOLERANCE, 0},
{676, 0u, 3038104593u, 0u, 0, ASIN_TOLERANCE, 0},
{677, 0u, 3266487747u, 0u, 0, ASIN_TOLERANCE, 0},
{678, 0u, 931954492u, 0u, 0, ASIN_TOLERANCE, 0},
{679, 0u, 845877036u, 0u, 0, ASIN_TOLERANCE, 0},
{680, 0u, 3361912856u, 0u, 0, ASIN_TOLERANCE, 0},
{681, 0u, 1288217553u, 0u, 0, ASIN_TOLERANCE, 0},
{682, 994042498u, 1228207362u, 994042516u, 0, ASIN_TOLERANCE, 0},
{683, 3026246945u, 3323646643u, 3026246945u, 0, ASIN_TOLERANCE, 0},
{684, 0u, 931002785u, 0u, 0, ASIN_TOLERANCE, 0},
{685, 0u, 852275082u, 0u, 0, ASIN_TOLERANCE, 0},
{686, 0u, 3208517087u, 0u, 0, ASIN_TOLERANCE, 0},
{687, 0u, 950619617u, 0u, 0, ASIN_TOLERANCE, 0},
{688, 0u, 3062617950u, 0u, 0, ASIN_TOLERANCE, 0},
{689, 0u, 2954695230u, 0u, 0, ASIN_TOLERANCE, 0},
{690, 0u, 1249768800u, 0u, 0, ASIN_TOLERANCE, 0},
{691, 0u, 3430381004u, 0u, 0, ASIN_TOLERANCE, 0},
{692, 0u, 3468526321u, 0u, 0, ASIN_TOLERANCE, 0},
{693, 0u, 3314169584u, 0u, 0, ASIN_TOLERANCE, 0},
{694, 0u, 1252586244u, 0u, 0, ASIN_TOLERANCE, 0},
{695, 0u, 807089907u, 0u, 0, ASIN_TOLERANCE, 0},
{696, 0u, 1273960227u, 0u, 0, ASIN_TOLERANCE, 0},
{697, 0u, 847765686u, 0u, 0, ASIN_TOLERANCE, 0},
{698, 0u, 925967342u, 0u, 0, ASIN_TOLERANCE, 0},
{699, 0u, 1232375752u, 0u, 0, ASIN_TOLERANCE, 0},
{700, 0u, 1315058051u, 0u, 0, ASIN_TOLERANCE, 0},
{701, 0u, 1134517149u, 0u, 0, ASIN_TOLERANCE, 0},
{702, 0u, 1277946299u, 0u, 0, ASIN_TOLERANCE, 0},
{703, 0u, 1071856519u, 0u, 0, ASIN_TOLERANCE, 0},
{704, 0u, 1146993272u, 0u, 0, ASIN_TOLERANCE, 0},
{705, 0u, 3474395292u, 0u, 0, ASIN_TOLERANCE, 0},
{706, 0u, 3483908964u, 0u, 0, ASIN_TOLERANCE, 0},
{707, 951674212u, 815317784u, 951674212u, 0, ASIN_TOLERANCE, 0},
{708, 0u, 865935606u, 0u, 0, ASIN_TOLERANCE, 0},
{709, 0u, 1318415694u, 0u, 0, ASIN_TOLERANCE, 0},
{710, 0u, 880973446u, 0u, 0, ASIN_TOLERANCE, 0},
{711, 0u, 949780485u, 0u, 0, ASIN_TOLERANCE, 0},
{712, 0u, 986578339u, 0u, 0, ASIN_TOLERANCE, 0},
{713, 0u, 3045907993u, 0u, 0, ASIN_TOLERANCE, 0},
{714, 0u, 3092473439u, 0u, 0, ASIN_TOLERANCE, 0},
{715, 0u, 1284508208u, 0u, 0, ASIN_TOLERANCE, 0},
{716, 0u, 845285114u, 0u, 0, ASIN_TOLERANCE, 0},
{717, 0u, 3251252972u, 0u, 0, ASIN_TOLERANCE, 0},
{718, 0u, 3057474479u, 0u, 0, ASIN_TOLERANCE, 0},
{719, 0u, 1335933001u, 0u, 0, ASIN_TOLERANCE, 0},
{720, 0u, 843284752u, 0u, 0, ASIN_TOLERANCE, 0},
{721, 0u, 3431817697u, 0u, 0, ASIN_TOLERANCE, 0},
{722, 0u, 3245903485u, 0u, 0, ASIN_TOLERANCE, 0},
{723, 0u, 1173153950u, 0u, 0, ASIN_TOLERANCE, 0},
{724, 0u, 919202446u, 0u, 0, ASIN_TOLERANCE, 0},
{725, 0u, 3274909610u, 0u, 0, ASIN_TOLERANCE, 0},
{726, 0u, 913211241u, 0u, 0, ASIN_TOLERANCE, 0},
{727, 0u, 994489862u, 0u, 0, ASIN_TOLERANCE, 0},
{728, 0u, 1157022610u, 0u, 0, ASIN_TOLERANCE, 0},
{729, 0u, 2962468497u, 0u, 0, ASIN_TOLERANCE, 0},
{730, 0u, 3371554093u, 0u, 0, ASIN_TOLERANCE, 0},
{731, 0u, 3188178213u, 0u, 0, ASIN_TOLERANCE, 0},
{732, 0u, 860714230u, 0u, 0, ASIN_TOLERANCE, 0},
{733, 0u, 3031764695u, 0u, 0, ASIN_TOLERANCE, 0},
{734, 0u, 3438580893u, 0u, 0, ASIN_TOLERANCE, 0},
{735, 0u, 1174324978u, 0u, 0, ASIN_TOLERANCE, 0},
{736, 0u, 3489323653u, 0u, 0, ASIN_TOLERANCE, 0},
{737, 0u, 3302139250u, 0u, 0, ASIN_TOLERANCE, 0},
{738, 0u, 808328507u, 0u, 0, ASIN_TOLERANCE, 0},
{739, 0u, 1030880169u, 0u, 0, ASIN_TOLERANCE, 0},
{740, 0u, 831593944u, 0u, 0, ASIN_TOLERANCE, 0}

// AUTOMATICALLY GENERATED VECTORS STOP

};

#endif // CYGONCE_LIBM_ASIN_H multiple inclusion protection

// EOF asin.h
