#ifndef CYGONCE_LIBM_ACOS_H
#define CYGONCE_LIBM_ACOS_H
//===========================================================================
//
//      acosf.h
//
//      Test vectors for testing of acosf() math library function
//
//===========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 2012 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later
// version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License
// along with eCos; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
// As a special exception, if other files instantiate templates or use
// macros or inline functions from this file, or you compile this file
// and link it with other works to produce a work based on this file,
// this file does not by itself cause the resulting work to be covered by
// the GNU General Public License. However the source code for this file
// must still be made available in accordance with section (3) of the GNU
// General Public License v2.
//
// This exception does not invalidate any other reasons why a work based
// on this file might be covered by the GNU General Public License.
// -------------------------------------------
// ####ECOSGPLCOPYRIGHTEND####
//===========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):
// Contributors:  visar, ilijak
// Date:        1998-02-13
// Purpose:
// Description:
// Usage:       #include "vectors/acosf.h"
//
//####DESCRIPTIONEND####
//
//===========================================================================


// CONFIGURATION

#include <pkgconf/libm.h>   // Configuration header


// INCLUDES

#include <cyg/infra/cyg_type.h>    // Common type definitions and support
#include "vectors/vector_support_float.h"// extra support for math tests

#define ACOS_TOLERANCE 1.0E-04

static const Cyg_libm_test_float_vec_t acosf_vec[] = {

// AUTOMATICALLY GENERATED VECTORS START

{0, 3214514586u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{1, 3214430700u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{2, 3214346813u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{3, 3214262927u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{4, 3214179041u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{5, 3214095155u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{6, 3214011269u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{7, 3213927383u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{8, 3213843497u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{9, 3213759611u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{10, 3213675725u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{11, 3213591839u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{12, 3213507953u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{13, 3213424067u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{14, 3213340180u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{15, 3213256294u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{16, 3213172408u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{17, 3213088522u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{18, 3213004636u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{19, 3212920750u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{20, 3212836864u, 1078530011u, 1078530011u, 0, ACOS_TOLERANCE, 0},
{21, 3212669092u, 1077936352u, 1077936352u, 0, ACOS_TOLERANCE, 0},
{22, 3212501320u, 1077689746u, 1077689746u, 0, ACOS_TOLERANCE, 0},
{23, 3212333548u, 1077500035u, 1077500035u, 0, ACOS_TOLERANCE, 0},
{24, 3212165775u, 1077339692u, 1077339692u, 0, ACOS_TOLERANCE, 0},
{25, 3211998003u, 1077198066u, 1077198066u, 0, ACOS_TOLERANCE, 0},
{26, 3211830231u, 1077069697u, 1077069697u, 0, ACOS_TOLERANCE, 0},
{27, 3211662459u, 1076951344u, 1076951344u, 0, ACOS_TOLERANCE, 0},
{28, 3211494687u, 1076840899u, 1076840899u, 0, ACOS_TOLERANCE, 0},
{29, 3211326915u, 1076736895u, 1076736895u, 0, ACOS_TOLERANCE, 0},
{30, 3211159142u, 1076638267u, 1076638267u, 0, ACOS_TOLERANCE, 0},
{31, 3210991370u, 1076544213u, 1076544213u, 0, ACOS_TOLERANCE, 0},
{32, 3210823598u, 1076454107u, 1076454107u, 0, ACOS_TOLERANCE, 0},
{33, 3210655826u, 1076367453u, 1076367453u, 0, ACOS_TOLERANCE, 0},
{34, 3210488054u, 1076283850u, 1076283850u, 0, ACOS_TOLERANCE, 0},
{35, 3210320282u, 1076202965u, 1076202965u, 0, ACOS_TOLERANCE, 0},
{36, 3210152509u, 1076124522u, 1076124522u, 0, ACOS_TOLERANCE, 0},
{37, 3209984737u, 1076048289u, 1076048289u, 0, ACOS_TOLERANCE, 0},
{38, 3209816965u, 1075974064u, 1075974064u, 0, ACOS_TOLERANCE, 0},
{39, 3209649193u, 1075901675u, 1075901675u, 0, ACOS_TOLERANCE, 0},
{40, 3209481421u, 1075830972u, 1075830972u, 0, ACOS_TOLERANCE, 0},
{41, 3209313649u, 1075761824u, 1075761824u, 0, ACOS_TOLERANCE, 0},
{42, 3209145876u, 1075694114u, 1075694114u, 0, ACOS_TOLERANCE, 0},
{43, 3208978104u, 1075627740u, 1075627740u, 0, ACOS_TOLERANCE, 0},
{44, 3208810332u, 1075562612u, 1075562612u, 0, ACOS_TOLERANCE, 0},
{45, 3208642560u, 1075498644u, 1075498644u, 0, ACOS_TOLERANCE, 0},
{46, 3208474788u, 1075435764u, 1075435764u, 0, ACOS_TOLERANCE, 0},
{47, 3208307016u, 1075373905u, 1075373905u, 0, ACOS_TOLERANCE, 0},
{48, 3208139244u, 1075313005u, 1075313005u, 0, ACOS_TOLERANCE, 0},
{49, 3207971471u, 1075253009u, 1075253009u, 0, ACOS_TOLERANCE, 0},
{50, 3207803699u, 1075193866u, 1075193866u, 0, ACOS_TOLERANCE, 0},
{51, 3207635927u, 1075135530u, 1075135530u, 0, ACOS_TOLERANCE, 0},
{52, 3207468155u, 1075077958u, 1075077958u, 0, ACOS_TOLERANCE, 0},
{53, 3207300383u, 1075021109u, 1075021109u, 0, ACOS_TOLERANCE, 0},
{54, 3207132611u, 1074964947u, 1074964947u, 0, ACOS_TOLERANCE, 0},
{55, 3206964838u, 1074909438u, 1074909438u, 0, ACOS_TOLERANCE, 0},
{56, 3206797066u, 1074854550u, 1074854550u, 0, ACOS_TOLERANCE, 0},
{57, 3206629294u, 1074800255u, 1074800255u, 0, ACOS_TOLERANCE, 0},
{58, 3206461522u, 1074746524u, 1074746524u, 0, ACOS_TOLERANCE, 0},
{59, 3206293750u, 1074693331u, 1074693331u, 0, ACOS_TOLERANCE, 0},
{60, 3206125978u, 1074640653u, 1074640653u, 0, ACOS_TOLERANCE, 0},
{61, 3205958205u, 1074588466u, 1074588466u, 0, ACOS_TOLERANCE, 0},
{62, 3205790433u, 1074536750u, 1074536750u, 0, ACOS_TOLERANCE, 0},
{63, 3205622661u, 1074485484u, 1074485484u, 0, ACOS_TOLERANCE, 0},
{64, 3205454889u, 1074434648u, 1074434648u, 0, ACOS_TOLERANCE, 0},
{65, 3205287117u, 1074384226u, 1074384226u, 0, ACOS_TOLERANCE, 0},
{66, 3205119345u, 1074334200u, 1074334200u, 0, ACOS_TOLERANCE, 0},
{67, 3204951572u, 1074284554u, 1074284554u, 0, ACOS_TOLERANCE, 0},
{68, 3204783800u, 1074235272u, 1074235272u, 0, ACOS_TOLERANCE, 0},
{69, 3204616028u, 1074186342u, 1074186342u, 0, ACOS_TOLERANCE, 0},
{70, 3204448256u, 1074137746u, 1074137746u, 0, ACOS_TOLERANCE, 0},
{71, 3204112712u, 1074089474u, 1074089474u, 0, ACOS_TOLERANCE, 0},
{72, 3203777167u, 1074041512u, 1074041512u, 0, ACOS_TOLERANCE, 0},
{73, 3203441623u, 1073993848u, 1073993848u, 0, ACOS_TOLERANCE, 0},
{74, 3203106079u, 1073946471u, 1073946471u, 0, ACOS_TOLERANCE, 0},
{75, 3202770534u, 1073899369u, 1073899369u, 0, ACOS_TOLERANCE, 0},
{76, 3202434990u, 1073852533u, 1073852533u, 0, ACOS_TOLERANCE, 0},
{77, 3202099446u, 1073805951u, 1073805951u, 0, ACOS_TOLERANCE, 0},
{78, 3201763901u, 1073759615u, 1073759615u, 0, ACOS_TOLERANCE, 0},
{79, 3201428357u, 1073685204u, 1073685204u, 0, ACOS_TOLERANCE, 0},
{80, 3201092813u, 1073593456u, 1073593456u, 0, ACOS_TOLERANCE, 0},
{81, 3200757268u, 1073502144u, 1073502144u, 0, ACOS_TOLERANCE, 0},
{82, 3200421724u, 1073411251u, 1073411251u, 0, ACOS_TOLERANCE, 0},
{83, 3200086180u, 1073320761u, 1073320761u, 0, ACOS_TOLERANCE, 0},
{84, 3199750636u, 1073230658u, 1073230658u, 0, ACOS_TOLERANCE, 0},
{85, 3199415091u, 1073140927u, 1073140927u, 0, ACOS_TOLERANCE, 0},
{86, 3199079547u, 1073051553u, 1073051553u, 0, ACOS_TOLERANCE, 0},
{87, 3198744003u, 1072962522u, 1072962522u, 0, ACOS_TOLERANCE, 0},
{88, 3198408458u, 1072873820u, 1072873820u, 0, ACOS_TOLERANCE, 0},
{89, 3198072914u, 1072785434u, 1072785434u, 0, ACOS_TOLERANCE, 0},
{90, 3197737370u, 1072697350u, 1072697350u, 0, ACOS_TOLERANCE, 0},
{91, 3197401825u, 1072609556u, 1072609556u, 0, ACOS_TOLERANCE, 0},
{92, 3197066281u, 1072522040u, 1072522040u, 0, ACOS_TOLERANCE, 0},
{93, 3196730737u, 1072434790u, 1072434790u, 0, ACOS_TOLERANCE, 0},
{94, 3196395192u, 1072347793u, 1072347793u, 0, ACOS_TOLERANCE, 0},
{95, 3196059648u, 1072261038u, 1072261038u, 0, ACOS_TOLERANCE, 0},
{96, 3195388559u, 1072174515u, 1072174515u, 0, ACOS_TOLERANCE, 0},
{97, 3194717471u, 1072088212u, 1072088212u, 0, ACOS_TOLERANCE, 0},
{98, 3194046382u, 1072002118u, 1072002118u, 0, ACOS_TOLERANCE, 0},
{99, 3193375293u, 1071916222u, 1071916222u, 0, ACOS_TOLERANCE, 0},
{100, 3192704205u, 1071830516u, 1071830516u, 0, ACOS_TOLERANCE, 0},
{101, 3192033116u, 1071744987u, 1071744987u, 0, ACOS_TOLERANCE, 0},
{102, 3191362028u, 1071659628u, 1071659628u, 0, ACOS_TOLERANCE, 0},
{103, 3190690939u, 1071574426u, 1071574426u, 0, ACOS_TOLERANCE, 0},
{104, 3190019850u, 1071489374u, 1071489374u, 0, ACOS_TOLERANCE, 0},
{105, 3189348762u, 1071404461u, 1071404461u, 0, ACOS_TOLERANCE, 0},
{106, 3188677673u, 1071319679u, 1071319679u, 0, ACOS_TOLERANCE, 0},
{107, 3188006584u, 1071235017u, 1071235017u, 0, ACOS_TOLERANCE, 0},
{108, 3186999951u, 1071150468u, 1071150468u, 0, ACOS_TOLERANCE, 0},
{109, 3185657774u, 1071066021u, 1071066021u, 0, ACOS_TOLERANCE, 0},
{110, 3184315597u, 1070981668u, 1070981668u, 0, ACOS_TOLERANCE, 0},
{111, 3182973420u, 1070897401u, 1070897401u, 0, ACOS_TOLERANCE, 0},
{112, 3181631242u, 1070813210u, 1070813210u, 0, ACOS_TOLERANCE, 0},
{113, 3180289065u, 1070729086u, 1070729086u, 0, ACOS_TOLERANCE, 0},
{114, 3178611343u, 1070645022u, 1070645022u, 0, ACOS_TOLERANCE, 0},
{115, 3175926989u, 1070561008u, 1070561008u, 0, ACOS_TOLERANCE, 0},
{116, 3173242634u, 1070477037u, 1070477037u, 0, ACOS_TOLERANCE, 0},
{117, 3170222735u, 1070393099u, 1070393099u, 0, ACOS_TOLERANCE, 0},
{118, 3164854026u, 1070309186u, 1070309186u, 0, ACOS_TOLERANCE, 0},
{119, 3156465418u, 1070225290u, 1070225290u, 0, ACOS_TOLERANCE, 0},
{120, 1008981770u, 1070057516u, 1070057516u, 0, ACOS_TOLERANCE, 0},
{121, 1017370378u, 1069973620u, 1069973620u, 0, ACOS_TOLERANCE, 0},
{122, 1022739087u, 1069889707u, 1069889707u, 0, ACOS_TOLERANCE, 0},
{123, 1025758986u, 1069805769u, 1069805769u, 0, ACOS_TOLERANCE, 0},
{124, 1028443341u, 1069721798u, 1069721798u, 0, ACOS_TOLERANCE, 0},
{125, 1031127695u, 1069637784u, 1069637784u, 0, ACOS_TOLERANCE, 0},
{126, 1032805417u, 1069553720u, 1069553720u, 0, ACOS_TOLERANCE, 0},
{127, 1034147594u, 1069469596u, 1069469596u, 0, ACOS_TOLERANCE, 0},
{128, 1035489772u, 1069385405u, 1069385405u, 0, ACOS_TOLERANCE, 0},
{129, 1036831949u, 1069301138u, 1069301138u, 0, ACOS_TOLERANCE, 0},
{130, 1038174126u, 1069216785u, 1069216785u, 0, ACOS_TOLERANCE, 0},
{131, 1039516303u, 1069132338u, 1069132338u, 0, ACOS_TOLERANCE, 0},
{132, 1040522936u, 1069047789u, 1069047789u, 0, ACOS_TOLERANCE, 0},
{133, 1041194025u, 1068963127u, 1068963127u, 0, ACOS_TOLERANCE, 0},
{134, 1041865114u, 1068878345u, 1068878345u, 0, ACOS_TOLERANCE, 0},
{135, 1042536202u, 1068793432u, 1068793432u, 0, ACOS_TOLERANCE, 0},
{136, 1043207291u, 1068708380u, 1068708380u, 0, ACOS_TOLERANCE, 0},
{137, 1043878380u, 1068623178u, 1068623178u, 0, ACOS_TOLERANCE, 0},
{138, 1044549468u, 1068537819u, 1068537819u, 0, ACOS_TOLERANCE, 0},
{139, 1045220557u, 1068452290u, 1068452290u, 0, ACOS_TOLERANCE, 0},
{140, 1045891645u, 1068366584u, 1068366584u, 0, ACOS_TOLERANCE, 0},
{141, 1046562734u, 1068280688u, 1068280688u, 0, ACOS_TOLERANCE, 0},
{142, 1047233823u, 1068194594u, 1068194594u, 0, ACOS_TOLERANCE, 0},
{143, 1047904911u, 1068108291u, 1068108291u, 0, ACOS_TOLERANCE, 0},
{144, 1048576000u, 1068021768u, 1068021768u, 0, ACOS_TOLERANCE, 0},
{145, 1048911544u, 1067935013u, 1067935013u, 0, ACOS_TOLERANCE, 0},
{146, 1049247089u, 1067848016u, 1067848016u, 0, ACOS_TOLERANCE, 0},
{147, 1049582633u, 1067760766u, 1067760766u, 0, ACOS_TOLERANCE, 0},
{148, 1049918177u, 1067673250u, 1067673250u, 0, ACOS_TOLERANCE, 0},
{149, 1050253722u, 1067585456u, 1067585456u, 0, ACOS_TOLERANCE, 0},
{150, 1050589266u, 1067497372u, 1067497372u, 0, ACOS_TOLERANCE, 0},
{151, 1050924810u, 1067408986u, 1067408986u, 0, ACOS_TOLERANCE, 0},
{152, 1051260355u, 1067320284u, 1067320284u, 0, ACOS_TOLERANCE, 0},
{153, 1051595899u, 1067231253u, 1067231253u, 0, ACOS_TOLERANCE, 0},
{154, 1051931443u, 1067141879u, 1067141879u, 0, ACOS_TOLERANCE, 0},
{155, 1052266988u, 1067052148u, 1067052148u, 0, ACOS_TOLERANCE, 0},
{156, 1052602532u, 1066962045u, 1066962045u, 0, ACOS_TOLERANCE, 0},
{157, 1052938076u, 1066871555u, 1066871555u, 0, ACOS_TOLERANCE, 0},
{158, 1053273620u, 1066780662u, 1066780662u, 0, ACOS_TOLERANCE, 0},
{159, 1053609165u, 1066689350u, 1066689350u, 0, ACOS_TOLERANCE, 0},
{160, 1053944709u, 1066597602u, 1066597602u, 0, ACOS_TOLERANCE, 0},
{161, 1054280253u, 1066505400u, 1066505400u, 0, ACOS_TOLERANCE, 0},
{162, 1054615798u, 1066412727u, 1066412727u, 0, ACOS_TOLERANCE, 0},
{163, 1054951342u, 1066319564u, 1066319564u, 0, ACOS_TOLERANCE, 0},
{164, 1055286886u, 1066225892u, 1066225892u, 0, ACOS_TOLERANCE, 0},
{165, 1055622431u, 1066131688u, 1066131688u, 0, ACOS_TOLERANCE, 0},
{166, 1055957975u, 1066036934u, 1066036934u, 0, ACOS_TOLERANCE, 0},
{167, 1056293519u, 1065941607u, 1065941607u, 0, ACOS_TOLERANCE, 0},
{168, 1056629064u, 1065845682u, 1065845682u, 0, ACOS_TOLERANCE, 0},
{169, 1056964608u, 1065749138u, 1065749138u, 0, ACOS_TOLERANCE, 0},
{170, 1057132380u, 1065651947u, 1065651947u, 0, ACOS_TOLERANCE, 0},
{171, 1057300152u, 1065554085u, 1065554085u, 0, ACOS_TOLERANCE, 0},
{172, 1057467924u, 1065455522u, 1065455522u, 0, ACOS_TOLERANCE, 0},
{173, 1057635697u, 1065356229u, 1065356229u, 0, ACOS_TOLERANCE, 0},
{174, 1057803469u, 1065159138u, 1065159138u, 0, ACOS_TOLERANCE, 0},
{175, 1057971241u, 1064957451u, 1064957451u, 0, ACOS_TOLERANCE, 0},
{176, 1058139013u, 1064754109u, 1064754109u, 0, ACOS_TOLERANCE, 0},
{177, 1058306785u, 1064549045u, 1064549045u, 0, ACOS_TOLERANCE, 0},
{178, 1058474557u, 1064342180u, 1064342180u, 0, ACOS_TOLERANCE, 0},
{179, 1058642330u, 1064133432u, 1064133432u, 0, ACOS_TOLERANCE, 0},
{180, 1058810102u, 1063922719u, 1063922719u, 0, ACOS_TOLERANCE, 0},
{181, 1058977874u, 1063709949u, 1063709949u, 0, ACOS_TOLERANCE, 0},
{182, 1059145646u, 1063495024u, 1063495024u, 0, ACOS_TOLERANCE, 0},
{183, 1059313418u, 1063277842u, 1063277842u, 0, ACOS_TOLERANCE, 0},
{184, 1059481190u, 1063058292u, 1063058292u, 0, ACOS_TOLERANCE, 0},
{185, 1059648963u, 1062836256u, 1062836256u, 0, ACOS_TOLERANCE, 0},
{186, 1059816735u, 1062611609u, 1062611609u, 0, ACOS_TOLERANCE, 0},
{187, 1059984507u, 1062384214u, 1062384214u, 0, ACOS_TOLERANCE, 0},
{188, 1060152279u, 1062153923u, 1062153923u, 0, ACOS_TOLERANCE, 0},
{189, 1060320051u, 1061920578u, 1061920578u, 0, ACOS_TOLERANCE, 0},
{190, 1060487823u, 1061684008u, 1061684008u, 0, ACOS_TOLERANCE, 0},
{191, 1060655596u, 1061444023u, 1061444023u, 0, ACOS_TOLERANCE, 0},
{192, 1060823368u, 1061200425u, 1061200425u, 0, ACOS_TOLERANCE, 0},
{193, 1060991140u, 1060952987u, 1060952987u, 0, ACOS_TOLERANCE, 0},
{194, 1061158912u, 1060701468u, 1060701468u, 0, ACOS_TOLERANCE, 0},
{195, 1061326684u, 1060445598u, 1060445598u, 0, ACOS_TOLERANCE, 0},
{196, 1061494456u, 1060185082u, 1060185082u, 0, ACOS_TOLERANCE, 0},
{197, 1061662228u, 1059919589u, 1059919589u, 0, ACOS_TOLERANCE, 0},
{198, 1061830001u, 1059648749u, 1059648749u, 0, ACOS_TOLERANCE, 0},
{199, 1061997773u, 1059372157u, 1059372157u, 0, ACOS_TOLERANCE, 0},
{200, 1062165545u, 1059089345u, 1059089345u, 0, ACOS_TOLERANCE, 0},
{201, 1062333317u, 1058799789u, 1058799789u, 0, ACOS_TOLERANCE, 0},
{202, 1062501089u, 1058502888u, 1058502888u, 0, ACOS_TOLERANCE, 0},
{203, 1062668861u, 1058197954u, 1058197954u, 0, ACOS_TOLERANCE, 0},
{204, 1062836634u, 1057884184u, 1057884184u, 0, ACOS_TOLERANCE, 0},
{205, 1063004406u, 1057560646u, 1057560646u, 0, ACOS_TOLERANCE, 0},
{206, 1063172178u, 1057226232u, 1057226232u, 0, ACOS_TOLERANCE, 0},
{207, 1063339950u, 1056794626u, 1056794626u, 0, ACOS_TOLERANCE, 0},
{208, 1063507722u, 1056073778u, 1056073778u, 0, ACOS_TOLERANCE, 0},
{209, 1063675494u, 1055321342u, 1055321342u, 0, ACOS_TOLERANCE, 0},
{210, 1063843267u, 1054532321u, 1054532321u, 0, ACOS_TOLERANCE, 0},
{211, 1064011039u, 1053700291u, 1053700291u, 0, ACOS_TOLERANCE, 0},
{212, 1064178811u, 1052816725u, 1052816725u, 0, ACOS_TOLERANCE, 0},
{213, 1064346583u, 1051869905u, 1051869905u, 0, ACOS_TOLERANCE, 0},
{214, 1064514355u, 1050842953u, 1050842953u, 0, ACOS_TOLERANCE, 0},
{215, 1064682127u, 1049709945u, 1049709945u, 0, ACOS_TOLERANCE, 0},
{216, 1064849900u, 1048278399u, 1048278399u, 0, ACOS_TOLERANCE, 0},
{217, 1065017672u, 1045243021u, 1045243021u, 0, ACOS_TOLERANCE, 0},
{218, 1065185444u, 1041297333u, 1041297333u, 0, ACOS_TOLERANCE, 0},
{219, 1065437102u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{220, 1065520988u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{221, 1065604874u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{222, 1065688760u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{223, 1065772646u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{224, 1065856532u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{225, 1065940419u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{226, 1066024305u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{227, 1066108191u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{228, 1066192077u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{229, 1066275963u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{230, 1066359849u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{231, 1066443735u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{232, 1066527621u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{233, 1066611507u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{234, 1066695393u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{235, 1066779279u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{236, 1066863165u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{237, 1066947052u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{238, 3234402267u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{239, 3231108068u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{240, 3226013659u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{241, 3217625051u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{242, 1070141403u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{243, 1078530011u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{244, 1083624420u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{245, 3253731328u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{246, 3252840038u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{247, 3251948749u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{248, 3251057459u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{249, 3250166170u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{250, 3249274880u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{251, 3248383590u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{252, 3247492301u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{253, 3246601011u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{254, 3245028147u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{255, 3243245568u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{256, 3241462989u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{257, 3239680410u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{258, 3237792973u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{259, 3234227814u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{260, 3230662656u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{261, 3224580915u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{262, 3213675725u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{263, 1058642330u, 1064133432u, 1064133432u, 0, ACOS_TOLERANCE, 0},
{264, 1075000115u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{265, 1082130432u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{266, 1085695590u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{267, 1089260749u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{268, 1091672474u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{269, 1093455053u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{270, 1095237632u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{271, 1097020211u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{272, 1098802790u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{273, 1099746509u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{274, 1100637798u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{275, 1101529088u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{276, 1102420378u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{277, 1103311667u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{278, 1104202957u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{279, 1105094246u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{280, 1105985536u, 1115684864u, 2143289344u, EDOM, ACOS_TOLERANCE, 0},
{281, 2147483648u, 1052069095u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{282, 2147483648u, 1071072428u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{283, 2147483648u, 3296950845u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{284, 2147483648u, 3156566413u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{285, 2147483648u, 3358077510u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{286, 2147483648u, 1025523870u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{287, 2147483648u, 1243001035u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{288, 2147483648u, 972638352u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{289, 810619489u, 3185903817u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{290, 2147491935u, 1278817364u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{291, 2147483648u, 3171458120u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{292, 288269848u, 1320608539u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{293, 2147483648u, 931147479u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{294, 2147483648u, 1037515180u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{295, 2277437585u, 3100002586u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{296, 2147483648u, 3192719340u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{297, 2147483648u, 1021132553u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{298, 591881758u, 951277634u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{299, 2147483648u, 3330035379u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{300, 2147483648u, 1001673627u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{301, 2749599591u, 851226131u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{302, 2147483648u, 906737571u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{303, 749404886u, 3268990607u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{304, 2147483648u, 1275963161u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{305, 2147483648u, 3253933764u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{306, 2147483648u, 3484034384u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{307, 2147483648u, 1233424920u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{308, 2334905811u, 938541324u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{309, 2147483648u, 1267908299u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{310, 2147483648u, 1017806823u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{311, 2147483648u, 2991550291u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{312, 363647387u, 3260698942u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{313, 2147483648u, 842980605u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{314, 2147483648u, 1081230948u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{315, 2743120633u, 3414609019u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{316, 2267257448u, 1021746912u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{317, 2147483648u, 1182202773u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{318, 2147483648u, 991146039u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{319, 2147483648u, 906951239u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{320, 2147483648u, 1118207485u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{321, 2147483648u, 1196181063u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{322, 2689012108u, 3480992834u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{323, 2147483648u, 3477870099u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{324, 2147483648u, 813029006u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{325, 2837565631u, 988745783u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{326, 2147483648u, 1205426478u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{327, 2147888351u, 3188486667u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{328, 2147483648u, 3372681320u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{329, 2147483648u, 960989701u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{330, 2147483744u, 3213319290u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{331, 2147483648u, 2994036021u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{332, 2147483648u, 1163818382u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{333, 2147483648u, 3030724760u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{334, 2147483648u, 3251462098u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{335, 448400401u, 936708769u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{336, 2147483648u, 845007087u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{337, 2444070966u, 3144245472u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{338, 2147483648u, 3162429103u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{339, 2147483648u, 976891930u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{340, 2147483648u, 856188678u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{341, 2147483648u, 898585738u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{342, 2147483648u, 3006490973u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{343, 2147483648u, 956052691u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{344, 391u, 3480430994u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{345, 2147483648u, 3206874009u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{346, 2756996510u, 1061834641u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{347, 2873449850u, 1051903437u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{348, 2147483648u, 1250159739u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{349, 2147483648u, 1000330041u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{350, 119045454u, 3402754560u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{351, 2147483648u, 1060741775u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{352, 160249855u, 3349719404u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{353, 2147483648u, 3422089012u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{354, 920u, 3207629620u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{355, 2147483648u, 3262490615u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{356, 2147483648u, 968020321u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{357, 2147483648u, 918937712u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{358, 2147483648u, 3361987866u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{359, 2147483648u, 1037918217u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{360, 340020199u, 1094190727u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{361, 2147483648u, 1053266823u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{362, 2147877445u, 3113871093u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{363, 2147483648u, 924982045u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{364, 2147483648u, 3075674944u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{365, 2147483648u, 3343511749u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{366, 2147483648u, 3472160795u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{367, 2147483648u, 1185255822u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{368, 2147483648u, 2964473730u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{369, 2723075543u, 3293073011u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{370, 2314131156u, 1131488075u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{371, 2147483648u, 1155973549u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{372, 2147483648u, 1273466037u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{373, 2147483648u, 3160115806u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{374, 2147483648u, 3421884736u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{375, 490459729u, 896142227u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{376, 2147483648u, 824119322u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{377, 2147483648u, 1226409254u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{378, 2724754778u, 3052084797u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{379, 2147483648u, 1043837748u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{380, 2147483648u, 3023809388u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{381, 2147483648u, 3184462258u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{382, 3u, 3117479148u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{383, 2147483648u, 3454151744u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{384, 2147483648u, 997035638u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{385, 2147483648u, 1205909956u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{386, 2147483648u, 2961687578u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{387, 2147483648u, 3129523970u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{388, 719549432u, 891539868u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{389, 2147483648u, 1092464984u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{390, 440779482u, 3412981093u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{391, 2147483648u, 3265523505u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{392, 2147483648u, 3232569165u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{393, 2147483648u, 1209839368u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{394, 2147483648u, 904437268u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{395, 2410584209u, 3238493878u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{396, 2147483648u, 3232169970u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{397, 2147483648u, 859974315u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{398, 2147483648u, 1129234809u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{399, 2147483648u, 916838473u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{400, 2147483648u, 1167070004u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{401, 2147483648u, 3031347719u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{402, 2147483648u, 3177294154u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{403, 108031518u, 3304796832u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{404, 2147483648u, 3171306569u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{405, 2147483648u, 3020473908u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{406, 2147483648u, 1096158518u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{407, 2147483648u, 3179481213u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{408, 2147483648u, 1281942534u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{409, 2147483648u, 3441620273u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{410, 728778715u, 1194063479u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{411, 2147483648u, 1269521406u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{412, 2147483648u, 1080781593u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{413, 391u, 3017708315u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{414, 2147483648u, 1305758312u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{415, 321062391u, 3276701541u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{416, 2147483648u, 3341726399u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{417, 2147483648u, 906796922u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{418, 2147483648u, 1224014884u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{419, 2147483648u, 966599478u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{420, 2326921734u, 835476614u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{421, 2147483648u, 923275921u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{422, 46071684u, 3343681859u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{423, 2147483648u, 3021544263u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{424, 2147483648u, 1178287186u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{425, 2147483648u, 829189744u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{426, 393982026u, 1143885245u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{427, 2147483648u, 3046898319u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{428, 2147483648u, 867967302u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{429, 2147483648u, 3338770855u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{430, 2147483648u, 3475508255u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{431, 2147483648u, 1202693903u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{432, 284154797u, 3427090024u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{433, 2264306954u, 1056262920u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{434, 2147483648u, 3264549339u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{435, 2147483648u, 1276853215u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{436, 2550407686u, 1096828073u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{437, 2147483648u, 1012272490u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{438, 2147483648u, 1295490054u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{439, 2147483648u, 1164664124u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{440, 570155606u, 3450612343u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{441, 480515653u, 3283738666u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{442, 2611692162u, 1106497311u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{443, 2147483648u, 3351032791u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{444, 2147483648u, 3046751162u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{445, 2147483648u, 838969199u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{446, 2324006503u, 3232806352u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{447, 141980743u, 1191954283u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{448, 2147483648u, 3441975288u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{449, 2147483648u, 3112892091u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{450, 2147483648u, 1336130408u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{451, 2147483648u, 813667607u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{452, 2147483648u, 3446438152u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{453, 2147483648u, 3270337976u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{454, 59461286u, 1214457631u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{455, 2147483648u, 3282519962u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{456, 2147483648u, 3108384823u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{457, 478163079u, 1090165393u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{458, 2147483648u, 882977381u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{459, 2147483648u, 1112072452u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{460, 2147483648u, 1028145400u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{461, 2147483648u, 1286245415u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{462, 2147483648u, 806097243u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{463, 2147483648u, 3412765608u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{464, 2147483648u, 940691906u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{465, 2147483648u, 3364307110u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{466, 2147483648u, 3065390393u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{467, 2147483648u, 3038555590u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{468, 2677724809u, 1314588083u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{469, 75734u, 3253167645u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{470, 797989396u, 1127052054u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{471, 2880582777u, 3331526060u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{472, 2147483648u, 3303828921u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{473, 2147483648u, 1059458160u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{474, 2147483648u, 1271766333u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{475, 2147483648u, 994934087u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{476, 2147483648u, 3349215575u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{477, 2147483648u, 1280179344u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{478, 2917059631u, 3430128441u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{479, 2147483648u, 3121491888u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{480, 2383125370u, 3134983555u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{481, 2490969476u, 1274271338u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{482, 2147483648u, 3137789275u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{483, 2147483648u, 3421282265u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{484, 2147483648u, 1176648675u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{485, 2147483648u, 3318141593u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{486, 2147483648u, 2953745031u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{487, 2147483648u, 3120393778u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{488, 2147483648u, 3057446844u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{489, 2147483648u, 1301684858u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{490, 2147483648u, 3268263719u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{491, 2147483648u, 1125665786u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{492, 2147483648u, 1164064095u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{493, 2147483648u, 3294185127u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{494, 2147483648u, 1210292360u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{495, 2147483648u, 1252991340u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{496, 2147483648u, 1129547574u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{497, 2690145161u, 3166174863u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{498, 2147483648u, 1246902946u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{499, 2147483648u, 821713786u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{500, 2147483648u, 1234682085u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{501, 2147483648u, 3196797581u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{502, 2147483648u, 3216636846u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{503, 2147483648u, 886552820u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{504, 2147483648u, 3275838921u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{505, 2147483648u, 3431026150u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{506, 2147483648u, 3013546177u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{507, 2147483648u, 3207228055u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{508, 2147483648u, 1189849849u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{509, 2147483648u, 1324123675u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{510, 2147483648u, 1284669825u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{511, 2147483648u, 1215659576u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{512, 2147483648u, 3313440410u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{513, 1049501u, 1325911234u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{514, 2147483648u, 865445870u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{515, 2147483648u, 3317255445u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{516, 234742983u, 1296303326u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{517, 2147483648u, 3141459622u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{518, 2147483648u, 3059263153u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{519, 2147483648u, 1150362008u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{520, 2147483648u, 3413901925u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{521, 2147483648u, 2970282274u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{522, 2385195833u, 1103833874u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{523, 2564584176u, 3380095806u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{524, 2513707978u, 3321602471u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{525, 2147483648u, 3149379368u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{526, 2147483648u, 1227380036u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{527, 2147483648u, 1030612298u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{528, 2147483648u, 1274230155u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{529, 2170277926u, 943702773u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{530, 2147483648u, 3455490212u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{531, 2147483648u, 3397380506u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{532, 2147653175u, 1070703949u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{533, 2147483648u, 946724121u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{534, 2147483648u, 1142740742u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{535, 2897405230u, 1257041821u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{536, 2147483648u, 3223269892u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{537, 2147483648u, 3369970587u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{538, 2147483648u, 911179122u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{539, 2147483648u, 3163556685u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{540, 2938612105u, 1098390556u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{541, 2147483648u, 3333087577u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{542, 2147483648u, 1138833401u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{543, 2147483648u, 1340199001u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{544, 2147483648u, 1153598995u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{545, 2147483648u, 3343190157u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{546, 2147483648u, 3327511577u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{547, 2687462036u, 1246668916u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{548, 2147483648u, 3364525678u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{549, 2147483648u, 841477222u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{550, 2147483648u, 3094865367u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{551, 2147483648u, 823554575u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{552, 2147483648u, 3426895417u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{553, 2147483648u, 3462258576u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{554, 843704503u, 3393355960u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{555, 2147483648u, 1100950868u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{556, 2147483648u, 891772654u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{557, 2147483648u, 3201307027u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{558, 2147483648u, 3034243695u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{559, 2147483648u, 3361467010u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{560, 2147483648u, 1252032904u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{561, 2147483648u, 1075881433u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{562, 33406260u, 1076793020u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{563, 2147483648u, 1198013705u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{564, 400127762u, 1226901593u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{565, 2147483648u, 3169114927u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{566, 149822278u, 1322250198u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{567, 2147483648u, 3037360125u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{568, 3392684u, 925229709u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{569, 2147483648u, 1041547928u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{570, 840558416u, 3019447745u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{571, 2147483648u, 851189486u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{572, 2147483648u, 3178983748u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{573, 2147483648u, 846808247u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{574, 2147483648u, 3362274638u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{575, 2652324524u, 940145823u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{576, 2156232923u, 3258645378u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{577, 486701u, 3392968785u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{578, 763674077u, 819117302u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{579, 2147483648u, 1087159751u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{580, 2147483648u, 3112136590u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{581, 2147483648u, 1093996718u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{582, 2147483648u, 1221138363u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{583, 2147483648u, 3082454432u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{584, 2147483648u, 905107980u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{585, 2147483648u, 1327101792u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{586, 2147483648u, 1130799489u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{587, 2147483648u, 3019855125u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{588, 2147483648u, 3403051413u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{589, 2147483648u, 1177352432u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{590, 2147483648u, 3033883446u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{591, 2147483648u, 1248810001u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{592, 2147483648u, 3065502249u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{593, 2147483648u, 970336973u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{594, 2468094017u, 1200966067u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{595, 637394373u, 816383247u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{596, 2147483648u, 933435023u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{597, 2147483648u, 3247983449u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{598, 2147483648u, 3377417079u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{599, 2147483648u, 1202153484u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{600, 2147483648u, 1258550065u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{601, 2147483648u, 3135303960u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{602, 501121108u, 1170420310u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{603, 2147483648u, 1161379350u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{604, 472266126u, 3040081476u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{605, 2147483648u, 3126785738u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{606, 2147483648u, 1135720261u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{607, 2147483648u, 834161190u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{608, 2147483648u, 1195849454u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{609, 2147483648u, 1031113622u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{610, 2147483648u, 3041923509u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{611, 2741465718u, 1268459262u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{612, 2147483648u, 3245406322u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{613, 2147483648u, 2958435407u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{614, 864473987u, 3475052219u, 1070141402u, 0, ACOS_TOLERANCE, 0},
{615, 193530813u, 1034349331u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{616, 2147483648u, 875370373u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{617, 2147483648u, 1326938231u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{618, 2147483648u, 3081333275u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{619, 2147483648u, 1083849288u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{620, 2147483648u, 1160615461u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{621, 2147483648u, 1057159525u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{622, 2147483648u, 1099193347u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{623, 2147483648u, 1156923458u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{624, 2147483648u, 1173759936u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{625, 2147483648u, 3051974545u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{626, 2147483648u, 1270944913u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{627, 2147483648u, 1068842002u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{628, 453373699u, 2987148017u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{629, 2147483648u, 3188146033u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{630, 2147483648u, 1292551278u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{631, 2147483648u, 3472203760u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{632, 2147483672u, 3151507159u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{633, 2147483648u, 1022984119u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{634, 2147483648u, 831320715u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{635, 2147483648u, 1236928772u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{636, 2147483648u, 833633147u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{637, 2255937854u, 3272421852u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{638, 2147483648u, 1274899097u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{639, 2147483648u, 1203700708u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{640, 2147483648u, 1219956070u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{641, 2147483648u, 3250328831u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{642, 2147483648u, 3115437331u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{643, 2147483648u, 3436353675u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{644, 2147483648u, 970565586u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{645, 733874287u, 1140723341u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{646, 2147483648u, 1094978498u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{647, 339953634u, 3229870615u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{648, 2147483648u, 1100875500u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{649, 2147483648u, 1281399060u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{650, 2147483648u, 3339857921u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{651, 2670707199u, 3289859792u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{652, 2147483648u, 905068959u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{653, 2147483648u, 2967285726u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{654, 2594850059u, 1229268598u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{655, 2147483648u, 817642171u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{656, 2147483648u, 3296217738u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{657, 2147483648u, 886781716u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{658, 2147483648u, 822243042u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{659, 2147483648u, 1232836633u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{660, 2147483648u, 3012101436u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{661, 2147483648u, 2985875633u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{662, 2898702392u, 3271988538u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{663, 2147483648u, 3255541781u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{664, 2147483648u, 3012527353u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{665, 2147483648u, 853459706u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{666, 2147483648u, 1032597076u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{667, 2147483648u, 3396154986u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{668, 2147483648u, 1280578799u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{669, 2147483648u, 3177612111u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{670, 2147483648u, 3086531260u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{671, 368559080u, 1200160986u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{672, 2374565676u, 1146511497u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{673, 409663799u, 3322946721u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{674, 2147483648u, 3286432366u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{675, 2147483648u, 3250061248u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{676, 2147483648u, 1195896327u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{677, 2147483648u, 1171219623u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{678, 2147483648u, 1093697541u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{679, 2147483648u, 3032135104u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{680, 2147483648u, 3411964796u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{681, 244369307u, 3136168070u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{682, 2147483648u, 1147204146u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{683, 2169506506u, 952770933u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{684, 2147483648u, 1038197181u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{685, 31340u, 812862946u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{686, 2147483650u, 1327912576u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{687, 197631173u, 3443552129u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{688, 2147483648u, 2953199494u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{689, 2147483648u, 1184612738u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{690, 2147483648u, 3402547824u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{691, 2147483648u, 894632143u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{692, 2728370577u, 897541752u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{693, 2147483648u, 1261942977u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{694, 2147483648u, 1099200954u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{695, 2147483648u, 3154292435u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{696, 2147483648u, 3152683606u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{697, 2147483648u, 1121826464u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{698, 2147483648u, 880804546u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{699, 2147483648u, 3141673859u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{700, 2446012935u, 3133522904u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{701, 2147483648u, 954983712u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{702, 2147483648u, 854348972u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{703, 308447u, 3231395033u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{704, 2147483648u, 3231323929u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{705, 236u, 3463576490u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{706, 2147483648u, 3276600049u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{707, 2147483648u, 1012037114u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{708, 428667909u, 827589466u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{709, 2709748098u, 3349525030u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{710, 2147483648u, 3030201286u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{711, 2147483648u, 3395574276u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{712, 2147483648u, 3037433263u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{713, 2147483648u, 3367144216u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{714, 2147483648u, 3296624630u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{715, 2147483648u, 3185505910u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{716, 225982867u, 855857523u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{717, 2147483648u, 1190400416u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{718, 2147483648u, 3268819116u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{719, 487188428u, 3025581813u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{720, 2147483648u, 3452213962u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{721, 2147483648u, 2994137867u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{722, 2147483648u, 1097262576u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{723, 71316482u, 3285809933u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{724, 2147483648u, 891257783u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{725, 1131u, 3188660897u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{726, 2147483648u, 3448533274u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{727, 2345099095u, 1024052164u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{728, 2147483648u, 893873945u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{729, 2147483648u, 1318917723u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{730, 2811770800u, 1094056396u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{731, 2147483648u, 971406232u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{732, 2147483648u, 1156679346u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{733, 505481166u, 1327433469u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{734, 2147483648u, 1158002738u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{735, 80634256u, 3217565926u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{736, 2147483648u, 3348046043u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{737, 2147483648u, 3042603886u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{738, 2147483648u, 3401478939u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{739, 117882441u, 2975268107u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{740, 622405526u, 933456504u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{741, 2147483648u, 1275983938u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{742, 2147483648u, 3064757885u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{743, 2147483648u, 3213261231u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{744, 2147483648u, 1257170393u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{745, 2147483648u, 968803479u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{746, 2147483648u, 3190256226u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{747, 2147483648u, 3107269354u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{748, 2147483648u, 3276193236u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{749, 651028769u, 3381966453u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{750, 2147483648u, 3137791426u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{751, 2147483648u, 3392203888u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{752, 2678157437u, 959123675u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{753, 372854u, 2997685349u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{754, 2147483648u, 3365775178u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{755, 2147483648u, 1200179013u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{756, 788951227u, 3254453434u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{757, 2957296123u, 2972152223u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{758, 2147483648u, 1273440283u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{759, 701665361u, 1227824408u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{760, 2147483648u, 938291177u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{761, 2147483648u, 3086279225u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{762, 2147483648u, 1223209034u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{763, 2147483648u, 1154573712u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{764, 2147483648u, 955325067u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{765, 2147483648u, 3113982619u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{766, 2147483648u, 1295331892u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{767, 2147483648u, 3134912135u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{768, 2863444097u, 815271840u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{769, 491705664u, 1193124813u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{770, 2147483648u, 1130046118u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{771, 2147483648u, 3422483143u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{772, 2147483648u, 963588452u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{773, 2147483648u, 3040968274u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{774, 2147483648u, 1029390534u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{775, 2147495995u, 1200467128u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{776, 2584489366u, 3233768835u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{777, 2147483648u, 3410148475u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{778, 2151563707u, 913267570u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{779, 2147483648u, 3388531942u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{780, 2147483648u, 3200345720u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{781, 780554677u, 1168166977u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{782, 2984790262u, 1225900941u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{783, 2147483648u, 3225037855u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{784, 2147483648u, 3391018698u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{785, 2147483648u, 1069185756u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{786, 2147483648u, 3123041418u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{787, 2147483648u, 1066846928u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{788, 2147483648u, 3461136033u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{789, 2147483648u, 912815101u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{790, 730526127u, 3412416876u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{791, 2147483654u, 1015752130u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{792, 2147483648u, 826306215u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{793, 2147483648u, 3169816394u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{794, 2915338033u, 3341154295u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{795, 2147483648u, 956765468u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{796, 635019546u, 3395476366u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{797, 2147483648u, 903755282u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{798, 2147483648u, 1184548899u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{799, 230260625u, 3475052132u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{800, 2147483648u, 3061939312u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{801, 2147483648u, 1130024229u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{802, 2147483648u, 2992012112u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{803, 15126300u, 3116086293u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{804, 2147483648u, 1247679409u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{805, 2147483648u, 1206496619u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{806, 632617934u, 3033764041u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{807, 256321691u, 3371852521u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{808, 2147483648u, 3320833608u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{809, 2147483648u, 893808771u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{810, 504952999u, 1266922074u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{811, 2147483648u, 1180498658u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{812, 2677787743u, 3136744746u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{813, 2147483648u, 992654477u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{814, 2147483648u, 1244289498u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{815, 154625229u, 2984576643u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{816, 2147483649u, 3184572184u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{817, 2147483648u, 3328004548u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{818, 2147483648u, 1110034241u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{819, 2147483648u, 3342934766u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{820, 2147483648u, 965658941u, 1070141403u, 0, ACOS_TOLERANCE, 0},
{821, 2147483648u, 3037575685u, 1070141403u, 0, ACOS_TOLERANCE, 0}

// AUTOMATICALLY GENERATED VECTORS STOP

};

#endif // CYGONCE_LIBM_ACOS_H multiple inclusion protection

// EOF acosf.h
