//==========================================================================
//
//      io/serial/mips/bcm33xx/bcm33940_serial.h
//
//      Broadcom 33940 Serial I/O definitions.
//
//==========================================================================
//####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 1998, 1999, 2000, 2001, 2002 Red Hat, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License along
// with eCos; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
//
// As a special exception, if other files instantiate templates or use macros
// or inline functions from this file, or you compile this file and link it
// with other works to produce a work based on this file, this file does not
// by itself cause the resulting work to be covered by the GNU General Public
// License. However the source code for this file must still be made available
// in accordance with section (3) of the GNU General Public License.
//
// This exception does not invalidate any other reasons why a work based on
// this file might be covered by the GNU General Public License.
//
// Alternative licenses for eCos may be arranged by contacting Red Hat, Inc.
// at http://sources.redhat.com/ecos/ecos-license/
// -------------------------------------------
//####ECOSGPLCOPYRIGHTEND####
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    jbarroso, based on MIPS IDT 16550 driver by tmichals, based on driver by dmoseley, based on POWERPC driver by jskov
// Contributors: gthomas, jskov, dmoseley, tmichals,msieweke
// Date:         2020-02-03
// Purpose:      Broadcom 33940 reference platform serial device driver definitions.
// Description:  Broadcom 33940 serial device driver definitions.
//####DESCRIPTIONEND####
//==========================================================================
//==========================================================================
// Portions of this software Copyright (c) 2020 Broadcom Corporation
//==========================================================================

bool bcm33940_serial_config_port(serial_channel *chan, cyg_serial_info_t *new_config, bool initialize);
bool bcm33940_serial_putc(serial_channel *chan, unsigned char c);
bool bcm33940_serial_putc_non_blocking(serial_channel *chan, unsigned char c);
unsigned char bcm33940_serial_getc(serial_channel *chan);
void bcm33940_serial_start_xmit(serial_channel *chan);
void bcm33940_serial_stop_xmit(serial_channel *chan);
void bcm33940_serial_debug_uart_init( uint32 baudDivider, volatile DbgUartSdwRegistersType * UART );
void bcm33940_hal_serial_putc( volatile DbgUartSdwRegistersType *UART, unsigned char c  );
void bcm33940_serial_ISR( void *data );
// EOF bcm33940_serial.h
