TOPDIR=$(cd `dirname $0` && pwd)

usage() {
cat <<EOF

Usage:  [ -d destination dir ]

  All arguments are optional. Default settings will be used if not specified.

  -t : Tar override

  -h : Print this message

  Examples:

  Will force creation of patches based of a specific tag for all repositories

EOF

exit 1
}

# Main
patches_dir="$TOPDIR/patches"
dst_dir="$TOPDIR"
overlay_dir="no"

while getopts "d:s:t" opt; do
  case $opt in
      :)
        echo "Option \"$OPTARG\" requires an argument"
        exit 1
        ;;

      t)
        echo "tar override"
	ln -s ${dst_dir}/.tar_ ${dst_dir}/tar_
	ln -s ${dst_dir}/.set-tar.mk ${dst_dir}/set-tar.mk
	;;

      *)
        echo "$OPTARG"
        echo "Unimplemented option chosen"
        exit 1
        ;;   # Default
  esac
done

echo "Starting install at:"
echo -e "$dst_dir\n"

if [ ! -d $dst_dir ]; then
    echo "Invalid destination directory"
    exit 1
fi

echo "Success"

exit 0
