#!/bin/bash

#
# As CM Implemented a framework to report security violations and events of interest using BfcEventLog,
# this script is used to monitor the Uart. If Rx Packets increases, it will
# report security event log via Lattice API to CM.
#
# Author:         Chris Zacker
# Creation Date:  Jan 29, 2019
#

# To prevent report to many event logs
maxLogEventCount=3

# uart stats can gotten by "cat /proc/tty/driver/serial"
initialUartRxCnt=0

# Loop timeout, by seconds
timeout=60
# Once event log is reported, wait timeout to send a new one, by seconds
reportTimeout=600
# After reported maxLogEventCount events, freeze until timeout
freezeReport=false
freezeReportTimeout=0
# EventId sent by RG
systemSecurityEventId="1.3.6.1.4.1.4413.2.2.2.1.9.1.3.1.1.5"
loggedEvent=0

if [ -f "/proc/tty/driver/serial" ]; then
  initialUartRxCnt=$(cat /proc/tty/driver/serial | grep rx: | head -1 | awk 'END {print$6}' | grep -o -E '[0-9]+')
else
  initialUartRxCnt=$(cat /proc/tty/driver/bcm63xx_uart | grep rx: | head -1 | awk 'END {print$6}' | grep -o -E '[0-9]+')
fi

echo "Start monitoring UartRxCnt, beginning RxCnt set to "$initialUartRxCnt" ..."

# monitoring loop
while [ true ]
do
  sleep $timeout

  # check if report is in freeze
  if [ $freezeReport ] && [ $freezeReportTimeout -gt 0 ]; then
    freezeReportTimeout=`expr $freezeReportTimeout - $timeout`
    if [ $freezeReportTimeout -le 0 ]; then
      freezeReport=false
      freezeReportTimeout=0
    fi
    continue
  fi

if [ -f "/proc/tty/driver/serial" ]; then
  currentUartRxCnt=$(cat /proc/tty/driver/serial | grep rx: | head -1 | awk 'END {print$6}' | grep -o -E '[0-9]+')
else
  currentUartRxCnt=$(cat /proc/tty/driver/bcm63xx_uart | grep rx: | head -1 | awk 'END {print$6}' | grep -o -E '[0-9]+')
fi
  # check if current Rx pkt cnt is greater than initaal Rx Cnt
  if [ $currentUartRxCnt -gt $initialUartRxCnt ]; then
    loggedEvent=`expr $loggedEvent + 1`
    initialUartRxCnt=$currentUartRxCnt

    # prevent report too many log events to CM
    if [ $loggedEvent -le $maxLogEventCount ]; then
      # report event
      systemSecurityEventText="Abnormal_UART_RX_Bytes_"$currentUartRxCnt

      latticecli -n "set Cm.LogEventId "$systemSecurityEventId
      latticecli -n "set Cm.LogEventText "$systemSecurityEventText
    else
      # report maximum events, freeze reporting, reset loggedEvent
      freezeReport=true
      # set freeze report timeout to 1 day ( 60 * 60 * 24 )
      freezeReportTimeout=`expr $timeout \* 1440`
      loggedEvent=0
    fi

    sleep $reportTimeout
  fi
done
