#!/bin/bash
#
# As CM Implemented a framework to report events, thi script is used to
# report previous RG Reset information to ResetReasonEventLog via SNMP to CM.
#
# Author:         Venky
# Creation Date:  Feb 19, 2020
#

# Wait timeout, by seconds
waitTimeout=10
# Number of retry allowed to send information via Lattice API
retry=0
retryLimit=5
# EventId sent by RG
bfcResetReasonEventId="1.3.6.1.4.1.4413.2.2.2.1.9.1.3.1.1.2"
snmpResetReasonEventIdOID="1.3.6.1.4.1.4413.2.2.2.1.2.12161.1.1.21.0"
snmpResetReasonEventTextOID="1.3.6.1.4.1.4413.2.2.2.1.2.12161.1.1.22.0"

if [ -e /proc/driver/sramdump/show_prev ]; then
     echo "Sending Crash Info to bfcResetReasonEventLog"
     cat /proc/driver/sramdump/show_prev | grep "Kernel crash detected: Yes" > /dev/null
     if [ $? -eq 0 ]; then
          resetCause=`cat /proc/driver/sramdump/show_prev | grep -o 'reset cause.*'`
          if [ ! -z "$resetCause" ]; then
               bfcResetReasonEventText+="RG "$resetCause
          fi
          kernelCrash=`cat /proc/driver/sramdump/show_prev | grep -o 'crash detected.*'`
          if [ ! -z "$kernelCrash" ]; then
               kernelCrash=`echo ${kernelCrash:0:1} | tr  '[a-z]' '[A-Z]'`${kernelCrash:1}
               bfcResetReasonEventText+=", "$kernelCrash
          fi
          crashType=`cat /proc/driver/sramdump/show_prev | grep -o 'Crash type.*'`
          if [ ! -z "$crashType" ]; then
               bfcResetReasonEventText+=", "$crashType
          fi
          crashDate=`cat /proc/driver/sramdump/show_prev | grep -o 'Crash date.*'`
          if [ ! -z "$crashDate" ]; then
               bfcResetReasonEventText+=", "$crashDate
          fi
          crashCPU=`cat /proc/driver/sramdump/show_prev | grep -o 'Crash cpu.*'`
          if [ ! -z "$crashCPU" ]; then
               bfcResetReasonEventText+=", "$crashCPU
          fi
          crashRegs=`cat /proc/driver/sramdump/show_prev | sed -n '/Regs:/,/r10:/{/Regs:\|r10:/!p;}' | sed ':a;N;$!ba;s/\n//g'`
          if [ ! -z "$crashRegs" ]; then
               crashRegs=`echo "$crashRegs" | sed 's/pc/PC/g;s/lr/LR/g;s/psr/PSR/g;s/sp/SP/g;s/ip/IP/g;s/fp/FP/g'`
               bfcResetReasonEventText+=", "$crashRegs
          fi
          crashBT=`cat /proc/driver/sramdump/show_prev | sed  -n '/Backtrace:/{n;p}'`
          if [ ! -z "$crashBT" ]; then
               bfcResetReasonEventText+=", BT-"$crashBT
          fi
     else
          resetCause=`cat /proc/driver/sramdump/show_now | grep -o 'reset cause.*'`
          if [ ! -z "$resetCause" ]; then
               bfcResetReasonEventText+="RG "$resetCause
          fi
          kernelCrash=`cat /proc/driver/sramdump/show_now | grep -o 'crash detected.*'`
          if [ ! -z "$kernelCrash" ]; then
		       kernelCrash=`echo "$kernelCrash" | sed 's/^c/C/g'`
               bfcResetReasonEventText+=", "$kernelCrash
          fi
          crashType=`cat /proc/driver/sramdump/show_now | grep -o 'Crash type.*'`
          if [ ! -z "$$crashType" ]; then
               bfcResetReasonEventText+=", "$crashType
          fi
     fi
     while [ $retry -le $retryLimit ]
     do
          snmpset -v2c -c public 172.31.255.45 $snmpResetReasonEventIdOID oid $bfcResetReasonEventId
          if [ $? -eq 0 ]; then
               echo "$CMD executed successfully"
               break
          else
               echo "$CMD terminated unsuccessfully"
               retry=`expr $retry + 1`
          fi
          sleep $waitTimeout
     done
     if [ $retry -le $retryLimit ]; then
          bfcResetReasonEventText=`echo $bfcResetReasonEventText | sed 's/ *: */:/g' | sed 's/, */, /g'`
          snmpset -v2c -c public 172.31.255.45 $snmpResetReasonEventTextOID s "$bfcResetReasonEventText"
     fi
fi
