#! /bin/sh

echo "/sbin/stbhotplug" > /proc/sys/kernel/hotplug

echo "Configuring private network"

. /etc/init.d/rcS.net

# USB auto upgrade case
if [ "$USBAUTO" = "y" ]; then
	echo "Detected USB auto boot option"
	if [ -f /root/rc.user ]; then
		echo "Starting user services"
		/bin/sh /root/rc.user
	fi
fi

APPS_IMG_MNT_POINT=/mnt/apps
if ! check_rootfs_part; then
UBIFS_APPS=0
APPS_PART_TYPE=$(cat /proc/cmdline | sed -n 's/.* \([a-zA-Z0-9]*\)_apps.*/\1/p')
if [ -n "$APPS_PART_TYPE" ]; then
  if [ "$APPS_PART_TYPE" = "ubifs" ]; then
    # Use UBIFS apps flash image
    UBIFS_APPS=1
    APPS_BLOCK_NODE="apps"
  elif [ -n "$FLASH_BOOT" ]; then
    ROOT_PART_NODE=$(cat /proc/cmdline | sed -n 's/.*root=\/dev\/\([a-zA-Z0-9]*\).*/\1/p')
    APPS_BLOCK_NODE=$(echo $ROOT_PART_NODE | sed -n 's/\(.*\)p[0-9].*\|[0-9].*/\1/p')
  fi
  # Look for apps=partitiontype:partitionname on cmdline
  APPS_NAME=$(cat /proc/cmdline | sed -n 's/.*apps=[a-z]*:\([^ ]*\).*/\1/p')
  if [ "x$APPS_NAME" = "x" ]
  then
    if $(ls /proc/device-tree | grep -q vflashclient)
    then
      APPS_NAME=vf0
    else
      if [ -z "$FLASH_BOOT" ]
      then
        echo "Running INITRD, default to apps index 0"
        rgindex=0
      else
        if [ "$APPS_PART_TYPE" = "ubifs" ]; then
          rgindex=$(cat /proc/cmdline | cut -d . -f 3 | cut -d " " -f 1 | cut -d "g" -f 2)
        elif find_part_name_by_node $ROOT_PART_NODE ROOT_PART_NAME; then
          rgindex=$(echo $ROOT_PART_NAME | sed -n 's/.*\([^0-9]\)//p')
        else
          echo "CAN NOT DETERMINE CURRENT RUNNING PARTITION, DEFAULT TO 0"
          rgindex=0
        fi
      fi
      if [ "$APPS_PART_TYPE" = "ubifs" ]; then
        APPS_NAME=$(cat /proc/mtd | sed -n 's/.*\(flash[0-9].rg\)0\?"/\1/p')$rgindex
      else
        APPS_NAME=apps$rgindex
      fi
    fi
  fi

  mount_by_name $APPS_NAME $APPS_PART_TYPE:$APPS_BLOCK_NODE $APPS_IMG_MNT_POINT

fi  # END *_apps
fi  # END ! rootfs

# Start MBOX assist
if [ ! $(ps -C mboxassist > /dev/null) ] && [ -f /bin/mboxassist ] && [ -e /dev/mbox ]
then
	/bin/mboxassist
fi

BOOT_ROOT=$(cat /proc/cmdline | sed -n 's/.*root=\([a-zA-Z0-9:/-]*\).*/\1/p')
if [ -f $APPS_IMG_MNT_POINT/etc/init.d/rc.apps ] && [ ! -z "$BOOT_ROOT" ]; then
	# /usr/local is mapped to APPS_IMG_MNT_POINT
	echo
	echo "******************************"
	read -t 5 -n 1 -r -p $'Starting user apps services...\n******************************\n' tmp_in
	if [[ $tmp_in =~ [[:cntrl:]] ]]; then
		echo -e "\nBypassing user apps startup\n"
	else
		echo -e "\nContinuing with user apps startup\n"
		export PATH=$PATH.:/usr/local/bin:/usr/local/sbin:/usr/local/usr/bin:/var:/bin:/sbin
		export LD_LIBRARY_PATH=/usr/local/lib:/usr/local/lib/public:/usr/local/lib/private:/usr/local/lib/gpl:/lib
		/bin/sh $APPS_IMG_MNT_POINT/etc/init.d/rc.apps
	fi
fi
