#!/bin/bash
#
# This script is used to generate /etc/resolv.conf, when /etc/resolv.conf is being updated by multiple sources.
# BROADCOM simple resolvconf script
# See usage() for the procedure gen_resolv.sh used for generating /etc/resolv.conf
#
# Author:         Ignatius Cheng
# Creation Date:  Jan 27, 2021
#
PRINT_RESULT="false"
GEN_RESOLV_RUN_DIR="/var/gen_resolv"

gen_resolv() (
	local word
	local line
	local search
	local final_ns
	local final_search
	local TMP_GEN_RESOLV_CONF="/tmp/gen_resolv.conf"
	local dup
	local i
	local j

	[ ! -d $GEN_RESOLV_RUN_DIR ] && echo "ERROR: $GEN_RESOLV_RUN_DIR dir is missing." && exit 1
	(
		flock 9
		echo "# generated by gen_resolv.sh, DO NOT EDIT this file" > $TMP_GEN_RESOLV_CONF
		echo "# add your own resolv.conf in run state directory, and re-run gen_resolv.sh" >> $TMP_GEN_RESOLV_CONF

		# find all non-duplicating nameserver lines
		unset final_ns
		for file in $GEN_RESOLV_RUN_DIR/*; do
			while IFS= read -r line; do
				word=( $line )
				if [ ${word[0]} == "nameserver" ]; then
					dup=0
					for i in ${final_ns[@]}; do
						[ ${word[1]} == $i ] && dup=1
					done
					[ $dup -eq 0 ] && final_ns+=( ${word[1]} )
				fi
			done < "$file"
		done
		for i in ${final_ns[@]}; do
			echo "nameserver $i" >> $TMP_GEN_RESOLV_CONF
		done

		# find all the search line and merge it
		for file in $GEN_RESOLV_RUN_DIR/* ; do
			line=$(grep "^search" $file)
			[ -z "$line" ] && continue
			word=( $line )
			search+=( ${word[@]:1} )
		done
		# remove duplicate in search
		unset final_search
		for i in ${search[@]}; do
			dup=0
			for j in ${final_search[@]}; do
				[ $j == $i ] && dup=1
			done
			[ $dup -eq 0 ] && final_search+=($i)
		done
		[ ${#final_search[@]} -gt 0 ] && echo "search ${final_search[@]}" >> $TMP_GEN_RESOLV_CONF;

		if [ $PRINT_RESULT == "false" ]; then
			cat $TMP_GEN_RESOLV_CONF > /etc/resolv.conf
		else
			echo "**** This is the file generated by gen_resolv.sh ****"
			echo
			cat $TMP_GEN_RESOLV_CONF
			rm  $TMP_GEN_RESOLV_CONF
		fi
	) 9>/tmp/resolv.conf.lock
	rm /tmp/resolv.conf.lock
)

usage() {
	echo "Usage: gen_resolv.sh [-h] [-p] [-d dir]"
	echo "   -d     set the state directory for gen_resolv.sh, where all interface resolv.conf files are located"
	echo "          default state directory is \"var/gen_resolv\" when this is not defined."
	echo "   -p     print output result to console instead of updating /etc/resolv.conf"
	echo "   -h     help (this output)"
	echo
	echo "gen_resolv.sh walks through each resolv.conf file in the state directory, and"
	echo "combines all the nameservers and search domanins in the order the files are read."
	echo "Duplicate nameservers and search domains are discarded, and the result is"
	echo "written to the system resolver configuration file /etc/resolv.conf."
	echo
	echo "The priority/order of the files being read is based on the filename"
	echo "The suggest filename template used is XXX-YYY-ZZZ.resolv.conf, where"
	echo "   XXX is the metric/priority of the configuration, smaller has higher priority"
	echo "   YYY is the application generating the configuration"
	echo "   ZZZ is the interface generating the configuration"
	exit 0
}

while getopts "d:hp" OPTION; do
	case $OPTION in
		p)
			PRINT_RESULT="true"
			;;
		d)
			GEN_RESOLV_RUN_DIR=$OPTARG
			;;
		h)
			usage;
			;;
	esac
done

gen_resolv
