#!/bin/bash

# bas is disabled for cert image
cert_mode=`latticecli -n "cfgget Device.CM Certification" | grep "default value" | awk '{print $NF}'`
if [ -n "$cert_mode" ]; then
  if [ "$cert_mode" = "Yes" ] || [ "$cert_mode" = "yes" ]; then
    echo "bas is disabled for cert image"
    exit 0
  fi
fi

action=${1:-start}

# Loop timeout, by seconds
timeout=20

LATTICE_DYN_CONFIG=/data/lattice-dyn.config
wan_mode=`cat $LATTICE_DYN_CONFIG | grep WANMode | awk -F '=' '{print $2}'`
wanif=`cat $LATTICE_DYN_CONFIG | grep WANInterface | awk -F '=' '{print $2}'`
wanbridge="cm0"
if [ $wan_mode = "Ethernet" ]; then
  wanbridge="wanbridge"
fi

start () {
    echo "basl: Start"
    # monitoring loop
    while [ true ]
    do
      # get wanbridge status
      ifconfig $wanbridge | grep RUNNING > /dev/null
      if [ $? -eq 0 ]; then
          echo $wanbridge " is running, launch basl"
          export PATH=/usr/local/bas:$PATH
          export LD_LIBRARY_PATH=/usr/local/bas:$LD_LIBRARY_PATH
          ulimit -c unlimited
          cd /usr/local/bas && basl &
          # Modprobe flowlyzer
          modprobe -q flowlyzer
          break
      fi
      sleep $timeout
    done
}


stop () {
    echo "basl: Stop"
    rmmod flowlyzer  &> /dev/null
    # When basl exits, it will also stop all its clients bas/rgapp
    killall basl &> /dev/null &> /dev/null
}

$action "$@"
