#!/bin/sh
[ -z "$2" ] && echo "Error: should be run by odhcpc6c" && exit 1

update_resolv() {
	local device="$1"
	local dns="$2"
	local domains="$3"
	local GEN_RESOLV_RUN_DIR="/var/gen_resolv"

	mkdir -p $GEN_RESOLV_RUN_DIR
	TMP_RESOLV_CONF="$GEN_RESOLV_RUN_DIR/010-odhcp6c-$device.resolv.conf"
	echo -n > $TMP_RESOLV_CONF
	[ -n "$domains" ] && echo "search $domains" >> $TMP_RESOLV_CONF
	for c in $dns; do
		echo "nameserver $c" >> $TMP_RESOLV_CONF
	done

	if command -v gen_resolv.sh > /dev/null; then
		gen_resolv.sh
	else
		if [ -n "$dns" ] && [ -n "$domains" ]; then
			echo "WARNING: Missing gen_resolv.sh tool!" >&2
			echo "odhcp6c_script.sh will overwrite /etc/resolv.conf with setting from interface $device dhcp6 setting" >&2
			cat $TMP_RESOLV_CONF > /etc/resolv.conf
		fi
	fi
}

setup_interface () {
	local device="$1"

	# Merge RA-DNS
	for radns in $RA_DNS; do
		local duplicate=0
		for dns in $RDNSS; do
			[ "$radns" = "$dns" ] && duplicate=1
		done
		[ "$duplicate" = 0 ] && RDNSS="$RDNSS $radns"
	done

	# Merge RA-DOMAINS
	for radomains in $RA_DOMAINS; do
		local duplicate=0
		for domain in $DOMAINS; do
			[ "$radomains" = "$domain" ] && duplicate=1
		done
		[ "$duplicate" = 0 ] && DOMAINS="$DOMAINS $radomains"
	done
	update_resolv "$device" "$RDNSS" "$DOMAINS"

	local prefixpart=""
	for entry in $PREFIXES; do
		local addr="${entry%%,*}"
		entry="${entry#*,}"
		local preferred="${entry%%,*}"
		entry="${entry#*,}"
		local valid="${entry%%,*}"
		entry="${entry#*,}"
		[ "$entry" = "$valid" ] && entry=

		local class=""
		local excluded=""

		while [ -n "$entry" ]; do
			local key="${entry%%=*}"
			entry="${entry#*=}"
			local val="${entry%%,*}"
			entry="${entry#*,}"
			[ "$entry" = "$val" ] && entry=

			if [ "$key" = "class" ]; then
				class=", \"class\": $val"
			elif [ "$key" = "excluded" ]; then
				excluded=", \"excluded\": \"$val\""
			fi
		done

		local prefix="{\"address\": \"$addr\", \"preferred\": $preferred, \"valid\": $valid $class $excluded}"

		if [ -z "$prefixpart" ]; then
			prefixpart="$prefix"
		else
			prefixpart="$prefixpart, $prefix"
		fi

		# TODO: delete this somehow when the prefix disappears
		ip -6 route add unreachable "$addr"
	done

	ip -6 route flush dev "$device" proto kernel
	ip -6 address flush dev "$device" scope global

	# Merge addresses
	for entry in $RA_ADDRESSES; do
		local duplicate=0
		local addr="${entry%%/*}"
		for dentry in $ADDRESSES; do
			local daddr="${dentry%%/*}"
			[ "$addr" = "$daddr" ] && duplicate=1
		done
		[ "$duplicate" = "0" ] && ADDRESSES="$ADDRESSES $entry"
	done

	for entry in $ADDRESSES; do
		local addr="${entry%%,*}"
		entry="${entry#*,}"
		local preferred="${entry%%,*}"
		entry="${entry#*,}"
		local valid="${entry%%,*}"

		ip -6 address add "$addr" dev "$device" preferred_lft "$preferred" valid_lft "$valid"
	done

	for entry in $RA_ROUTES; do
		local addr="${entry%%,*}"
		entry="${entry#*,}"
		local gw="${entry%%,*}"
		entry="${entry#*,}"
		local valid="${entry%%,*}"
		entry="${entry#*,}"
		local metric="${entry%%,*}"

		if [ -n "$gw" ]; then
			ip -6 route add "$addr" via "$gw" metric "$metric" dev "$device"
		else
			ip -6 route add "$addr" metric "$metric" dev "$device"
		fi

		for prefix in $PREFIXES; do
			local paddr="${prefix%%,*}"
			[ -n "$gw" ] && ip -6 route add "$addr" via "$gw" metric "$metric" dev "$device" from "$paddr"
		done
	done
}

teardown_interface() {
	local device="$1"
	ip -6 route flush dev "$device" proto kernel
	ip -6 address flush dev "$device" scope global
	update_resolv "$device" "" ""
}

(
	flock 9
	case "$2" in
		bound)
			teardown_interface "$1"
			setup_interface "$1"
		;;
		informed|updated|rebound)
			setup_interface "$1"
		;;
		stopped|unbound)
			teardown_interface "$1"
		;;
		started)
			teardown_interface "$1"
		;;
	esac

	# user rules
	[ -f /etc/odhcp6c.user ] && . /etc/odhcp6c.user
) 9>/tmp/odhcp6c.lock.$1
rm -f /tmp/odhcp6c.lock.$1
