#!/bin/sh

# udhcpc script edited by Tim Riker <Tim@Rikers.org>

[ -z "$1" ] && echo "Error: should be called from udhcpc" && exit 1

[ -x /etc/udhcpc.script.user ] && /etc/udhcpc.script.user "$@"

[ -n "$broadcast" ] && BROADCAST="broadcast $broadcast"
[ -n "$subnet" ] && NETMASK="netmask $subnet"

update_resolv() {
	local device="$1"
	local dns="$2"
	local domains="$3"
	local GEN_RESOLV_RUN_DIR="/var/gen_resolv"
	local TMP_RESOLV_CONF

	mkdir -p $GEN_RESOLV_RUN_DIR
	TMP_RESOLV_CONF="$GEN_RESOLV_RUN_DIR/020-udhcpc-$device.resolv.conf"
	echo -n > $TMP_RESOLV_CONF
	[ -n "$domains" ] && echo "search $domains" >> $TMP_RESOLV_CONF
	for c in $dns; do
		echo "nameserver $c" >> $TMP_RESOLV_CONF
	done

	if command -v gen_resolv.sh > /dev/null; then
		gen_resolv.sh
	else
		if [ -n "$dns" ] && [ -n "$domains" ]; then
			echo "WARNING: Missing gen_resolv.sh tool!" >&2
			echo "udhcpc.script.rc will overwrite /etc/resolv.conf with setting from interface $device dhcp setting" >&2
			cat $TMP_RESOLV_CONF > /etc/resolv.conf
		fi
	fi
}

case "$1" in
	deconfig)
		if [[ "$interface" = *:* ]]; then
			# aliases (e.g. eth0:0) don't like to be called 0.0.0.0
			/sbin/ifconfig $interface 127.0.0.2
		else
			/sbin/ifconfig $interface 0.0.0.0
		fi
		update_resolv "$interface" "" ""
		;;

	renew|bound)
		/sbin/ifconfig $interface $ip $BROADCAST $NETMASK

		if [ -n "$router" ] ; then
			echo "deleting routers"
			while route del default gw 0.0.0.0 dev $interface 2> /dev/null; do
				:
			done

			metric=0
			for i in $router ; do
				route add default gw $i dev $interface metric $((metric++))
				# /etc/udhcpd.conf is on a read-only mount and it is a symlink to /var/udhcpd/udhcpd.conf
				sed s/"opt lease 60"/"opt lease 6000"/ /etc/udhcpd.conf > /tmp/tmp_udhcpd.conf
				cat /tmp/tmp_udhcpd.conf > /etc/udhcpd.conf
				iptables -t nat -F POSTROUTING
				iptables -t nat -A POSTROUTING -o $interface -j MASQUERADE
			done
		fi

		update_resolv "$interface" "$dns" "$domain"
		for i in $dns ; do
			cat /etc/udhcpd.conf | grep "opt dns $i" > /dev/null
			if [ $? == 1 ]; then
				echo opt dns $i >> /etc/udhcpd.conf
			fi
		done
		killall udhcpd
		udhcpd /etc/udhcpd.conf
		;;
esac

exit 0
