function flowmgr() {
    if [ "$#" -ne 1 ]; then
        echo show > /proc/driver/flowmgr/cmd
    else
        case "$1" in
            1 | [yYeE] | enable )
                echo 1 > /proc/sys/net/flowmgr/enable
            ;;
            0 | [nNdD] | disable )
                echo 0 > /proc/sys/net/flowmgr/enable
            ;;
            *)
            echo "flowmgr - No arguments show status"
            echo "flowmgr [0|n|disable] - Disable flowmgr"
            echo "flowmgr [1|y|enable]  - Enable  flowmgr"
            ;;
        esac
    fi
}

function brshowmacs() {
    for x in `ls /sys/class/net`; do
        ethtool -i $x 2>&1 | grep -i bridge > /dev/null 2>&1
        if [ "0" -eq "$?" ]; then
            echo -e "\n**** Show MACs on $x ****"
            brctl showmacs $x
        fi
    done
}

function brshowstp() {
    for x in `ls /sys/class/net`; do
        ethtool -i $x 2>&1 | grep -i bridge > /dev/null 2>&1
        if [ "0" -eq "$?" ]; then
            echo -e "\n**** Show STP on $x ****"
            brctl showstp $x
        fi
    done
}

function brflush() {
    for x in `ls /sys/class/net`; do
        ethtool -i $x 2>&1 | grep -i bridge > /dev/null 2>&1
        if [ "0" -eq "$?" ]; then
            echo 1 > /sys/class/net/%x/bridge/flush
        fi
    done
}

# Additional Useful Aliases for debugging
alias lsnf='cat /proc/net/stat/nf_conntrack && cat /proc/net/nf_conntrack'
alias lsflownf='cat /proc/net/nf_conntrack_offload'
alias lsflowmgr='echo show > /proc/driver/flowmgr/cmd'
alias lsflow='lsflowmgr && lsflownf'
alias lsflowdb='echo "**** CientDB ****" && cat /proc/driver/flowmgr/db && echo "**** MulticastDB ****" && cat /proc/driver/flowmgr/mdb && echo "**** TunnelDB ****" && cat /proc/driver/flowmgr/tdb'
alias lsiptf='echo -e "\n**** FILTER TABLE ****" && iptables -t filter -n -L -v'
alias lsiptn='echo -e "\n****    NAT TABLE ****" && iptables -t nat -n -L -v'
alias lsiptm='echo -e "\n**** MANGLE TABLE ****" && iptables -t mangle -n -L -v'
alias lsiptr='echo -e "\n****    RAW TABLE ****" && iptables -t raw -n -L -v'
alias lsipt='lsiptf && lsiptn && lsiptm && lsiptr'
alias lsiptf6='echo -e "\n**** IPv6 FILTER TABLE ****" && ip6tables -t filter -n -L -v'
alias lsiptm6='echo -e "\n**** IPv6 MANGLE TABLE ****" && ip6tables -t mangle -n -L -v'
alias lsiptr6='echo -e "\n****    IPv6 RAW TABLE ****" && ip6tables -t raw -n -L -v'
alias lsipt6='lsiptf6 && lsiptm6 && lsiptr6'
alias lsebtf='echo -e "\n**** FILTER TABLE ****" && ebtables -t filter -L --Lc'
alias lsebtn='echo -e "\n****    NAT TABLE ****" && ebtables -t nat -L --Lc'
alias lsebtb='echo -e "\n**** BROUTE TABLE ****" && ebtables -t broute -L --Lc'
alias lsebt='lsebtf && lsebtn && lsebtb'
alias lsversion='latticecli -n "version"'
alias swversion='lsversion'
alias lsnetstat='cat /proc/net/dev && cat /proc/net/dev_eth'
alias lsnet='ip addr'
alias lsneigh='/usr/local/bin/ip neigh && /usr/local/bin/ip -6 neigh'
alias lsbr='brctl show && brshowmacs'

if [ -e /proc/driver/dqm ]; then
    alias dqm='cat /proc/driver/dqm/mib'
    alias showdqm='cat /proc/driver/dqm/status'
    alias lsdqm='showdqm'
fi

if [ -e /proc/driver/fpm ]; then
    alias fpm='cat /proc/driver/fpm/stats'
    alias showfpm='cat /proc/driver/fpm/stats'
    alias lsfpm='showfpm'
fi

if [ -e /proc/driver/dqnet ]; then
    alias showdqnet='echo stats > /proc/driver/dqnet/cmd && cat /proc/driver/dqnet/nethooks'
    alias showcmim='echo cmim > /proc/driver/dqnet/cmd'
    alias lsdqnet='showdqnet'
fi

function ddb()
{
    if [ "$#" -eq 0 ]; then
        echo "ddb <key> <match> <0|1>"
        echo "key: func, file or module"
        echo "match: For key module: Module name - flowmgr, dqnet, fpm etc"
        echo "match: For key file: File name - flowmgr_core.c, dqnet_core.c etc"
        echo "match: For key func: Function name"
        echo "0|1: 0-Disable 1-Enable. Display all match lines if this argument is omitted"
    else
        case "$3" in
            1 | [yYeE] | enable )
                echo "$1 $2 +pmfl" > /sys/kernel/debug/dynamic_debug/control
            ;;
            0 | [nNdD] | disable )
                echo "$1 $2 =_" > /sys/kernel/debug/dynamic_debug/control
            ;;
            *)
                if [ "$#" -eq 2 ]; then
                    cat /sys/kernel/debug/dynamic_debug/control | grep $2
                else
                    echo "ddb <key> <match> <0|1>"
                    echo "key: func, file or module"
                    echo "match: For key module: Module name - flowmgr, dqnet, fpm etc"
                    echo "match: For key file: File name - flowmgr_core.c, dqnet_core.c etc"
                    echo "match: For key func: Function name"
                    echo "0|1: 0-Disable 1-Enable. Display all match lines if this argument is omitted"
                fi
            ;;
        esac
    fi
}
