# Recommended usage: Module
# ------------------------------------------------------------------------------

BUILD_DIR ?= $(shell pwd)
TARBALL=./$(wildcard mod/*.tar.gz)

# Extra Options
# ------------------------------------------------------------------------------
$(TARGET)_OPTS= INSTALL_MOD_STRIP=1 INSTALL_MOD_PATH=$(TARGET_DIR) \
		KBUILD_EXTMOD=$(BUILD_DIR)/mod

# Commands
# ------------------------------------------------------------------------------
.PHONY: all clean distclean

all_: untar_ patch_ internal_ config_ build_ build_internal_ release_ release_internal_ install_

untar_:
	if [ -f $(TARBALL) ]; then \
		if [ ! -f mod/.untarred ]; then \
			echo "Extract $(TARGET)."; \
			$(TAR) xzf $(TARBALL) -C mod/ || exit 2; \
			touch mod/.untarred; \
		else \
			echo "Extract $(TARGET), nothing to do."; \
		fi; \
	fi

patch_:
	@echo "Patch $(TARGET)."

internal_:
	@echo "Pre-build internal $(TARGET)."
	if [ ! -d ../internal ]; then \
		cp -L $(RELEASE_DIR)/*.o_$(ARCH)_shipped mod; \
	fi

config_:
	@echo "Config $(TARGET)."

build_:
	@echo "Build $(TARGET)."
	$(MAKE) -C $(LINUX_DIR) M=$(BUILD_DIR)/mod ARCH=$(ARCH) $($(TARGET)_OPTS) modules V=1

build_internal_:
	@echo "Build internal $(TARGET)."
	if [ -d ../internal ]; then \
		$(MAKE) -C $(LINUX_DIR) M=$(BUILD_DIR)/../internal ARCH=$(ARCH) modules V=1; \
		cp -L ../internal/$(TARGET).o mod/$(TARGET).o_$(ARCH)_shipped; \
	fi

stage_:
	@echo "Stage $(TARGET)."
	cd $(STAGING_DIR)/usr/share/build && \
	ln -sfT $(BUILD_DIR)/mod $(TARGET)

release_:
	@echo "Release $(TARGET)."
	$(STRIP) --strip-debug mod/*.ko
	cp -L mod/*.ko $(RELEASE_DIR)

release_internal_:
	@echo "Release internal $(TARGET)."
	cp -L mod/*.o_$(ARCH)_shipped $(RELEASE_DIR)

install_:
	@echo "Install $(TARGET)."
	mkdir -p $(INSTALL_DIR)/lib
	mkdir -p $(INSTALL_DIR)/lib/modules
	mkdir -p $(INSTALL_DIR)/lib/modules/$(LINUX_VER_STR)
	cp *.ko $(INSTALL_DIR)/lib/modules/$(LINUX_VER_STR)

clean_:
	@echo "Clean $(TARGET)."
ifneq ($(wildcard $(LINUX_DIR)/Makefile),)
	- $(MAKE) -C $(LINUX_DIR) M=$(BUILD_DIR)/mod clean V=1
endif
	- @cd $(BUILD_DIR)/mod && rm -f *.o .*.o.cmd *.d *.ko .*.ko.cmd *.mod.o *.mod.c modules.order Module.symvers
	- @rm -rf $(wildcard .release_$(ARCH)*)

distclean_: clean_
	- @rm -rf .release_*
