 /****************************************************************************
 *
 * Broadcom Proprietary and Confidential.
 * (c) 2015-2016 Broadcom. All rights reserved.
 * The term Broadcom refers to Broadcom Limited and/or its subsidiaries.
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************
 * Author: Jayesh Patel <jayeshp@broadcom.com>
 ****************************************************************************/

#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/netdevice.h>
#include <proc_cmd.h>
#include "bcmnethooks.h"
#include "rtf.h"

#define RTF_PROC_DIR_NAME	"driver/rtf"


static int cmd_show(int argc, char *argv[])
{
	rtf_show();
	return 0;
}
static int cmd_enable(int argc, char *argv[])
{
	unsigned int enable;
	if (argc > 1) {
		if (kstrtouint(argv[1], 0, &enable) != 0)
			goto help;

		if ((enable != 0) && (enable != 1) && (enable != 3))
			goto help;

		rtf_nethook_enable(enable);
		goto done;
	}
help:
/* help */
	pr_info("%s mask: bit[0] - RTF; bit[1] - VLAN\n", argv[0]);
	pr_info("%s 1: Enable RTF\n", argv[0]);
	pr_info("%s 0: Disable RTF\n", argv[0]);
	pr_info("%s 3: Enable RTF and VLAN header removal\n", argv[0]);
done:
	return 0;
}

static int cmd_filter(int argc, char *argv[])
{
	if (argc == 3) {
		if (!strncmp(argv[1], "add", 3))
			rtf_ip_filter(1, argv[2]);
		else
			rtf_ip_filter(0, argv[2]);
		goto done;
	}
/* help */
	pr_info("%s <add|del> <ip address>\n", argv[0]);
done:
	return 0;
}

static int cmd_host(int argc, char *argv[])
{
	if (argc == 2) {
		rtf_host_interface(argv[1]);
		goto done;
	}
/* help */
	pr_info("%s <host interface name>\n", argv[0]);
done:
	return 0;
}

static int cmd_filter_port(int argc, char *argv[])
{
	if (argc == 4) {
		if (strcasecmp("add", argv[1]) == 0) {
			__be16 port;
			__be16 protocol;
			if ((kstrtou16(argv[2], 0, &port) == 0) &&
             (kstrtou16(argv[3], 0, &protocol) == 0))
				rtf_filter_port_add(port,protocol);
			goto done;
		} else if (strcasecmp("del", argv[1]) == 0) {
			__be16 port;
			__be16 protocol;
			if ((kstrtou16(argv[2], 0, &port) == 0) &&
             (kstrtou16(argv[3], 0, &protocol) == 0))
				rtf_filter_port_add(port,protocol);
			goto done;
		} else if (strcasecmp("clear", argv[1]) == 0) {
			rtf_filter_port_clear();
			goto done;
		}
	}
/* help */
	pr_info("%s <add|del|clear> <port_num> <protocol_enum>\n", argv[0]);
done:
	return 0;
}

static struct proc_cmd_ops command_entries[] = {
	{ .name = "show", .do_command = cmd_show},
	{ .name = "enable", .do_command = cmd_enable},
	{ .name = "filter_ip", .do_command = cmd_filter},
	{ .name = "host_inf", .do_command = cmd_host},
	{ .name = "filter_port", .do_command = cmd_filter_port},
};

struct proc_cmd_table command_table = {
	.module_name = "rtf",
	.size = ARRAY_SIZE(command_entries),
	.ops = command_entries
};

static struct
proc_dir_entry *rtf_proc_dir;

void rtf_procfs_init(void)
{
	rtf_proc_dir = proc_mkdir(RTF_PROC_DIR_NAME, NULL);
	if (rtf_proc_dir == NULL) {
		pr_warn("rtf Warning: cannot create /proc/%s\n",
			RTF_PROC_DIR_NAME);
		return;
	}
	proc_create_cmd("cmd", rtf_proc_dir, &command_table);
}

void rtf_procfs_exit(void)
{
	if (rtf_proc_dir) {
		remove_proc_entry("cmd", rtf_proc_dir);
		remove_proc_entry(RTF_PROC_DIR_NAME, NULL);
		rtf_proc_dir = NULL;
	}
}
