 /****************************************************************************
 *
 * Broadcom Proprietary and Confidential.
 * (c) 2016 Broadcom. All rights reserved.
 * The term "Broadcom" refers to Broadcom Limited and/or its subsidiaries.
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************
 * Author: Jayesh Patel <jayesh.patel@broadcom.com>
 ****************************************************************************/

#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <proc_cmd.h>
#include <linux/if_ether.h>
#include <linux/etherdevice.h>
#include "netxl.h"

#define NETXL_PROC_DIR_NAME	"driver/netxl"

static int cmd_show(int argc, char *argv[])
{
	if (argc == 2) {
		netxl_netdevice_show(argv[1]);
		goto done;
	}
/* help */
	pr_info("%s <master name>\n", argv[0]);
done:
	return 0;
}

static int cmd_addif(int argc, char *argv[])
{
	if (argc >= 4) {
		int id;
		if (kstrtoint(argv[3], 0, &id) == 0) {
			char *pkt_type = "fpm";
			if (argc == 5)
				pkt_type = argv[4];
			if (netxl_netdevice_add(argv[1], argv[2],
						id, pkt_type) == 0)
				goto done;
		}
	}
/* help */
	pr_info("%s <master name> <slave name> <mapping id: 0..23>\n",
		argv[0]);
done:
	return 0;
}

static int cmd_config(int argc, char *argv[])
{
	if (argc == 4) {
		int val;
		if (kstrtoint(argv[3], 0, &val) == 0) {
			if (netxl_netdevice_cfg(argv[1], argv[2], val) == 0)
				goto done;
		}
	}
/* help */
	pr_info("%s <master name> <param> <value>\n", argv[0]);
done:
	return 0;
}

static int cmd_delif(int argc, char *argv[])
{
	if (argc == 2) {
		if (netxl_netdevice_del(argv[1]) == 0)
			goto done;
	}
/* help */
	pr_info("%s <master name>\n", argv[0]);
done:
	return 0;
}

/* Layer 2 Update frame (802.2 Type 1 LLC XID Update response) */
struct iapp_layer2_update {
	u8 da[ETH_ALEN];	/* broadcast */
	u8 sa[ETH_ALEN];	/* STA addr */
	__be16 len;		/* 6 */
	u8 dsap;		/* 0 */
	u8 ssap;		/* 0 */
	u8 control;
	u8 xid_info[3];
} __packed;


static int cmd_simrx(int argc, char *argv[])
{
	struct iapp_layer2_update *msg;
	struct sk_buff *skb;

	if (argc == 2) {

		/* Send Level 2 Update Frame to update forwarding tables in layer 2
		 * bridge devices */

		skb = dev_alloc_skb(sizeof(*msg));
		if (!skb)
			goto done;
		msg = (struct iapp_layer2_update *)skb_put(skb, sizeof(*msg));

		/* 802.2 Type 1 Logical Link Control (LLC) Exchange Identifier (XID)
		 * Update response frame; IEEE Std 802.2-1998, 5.4.1.2.1 */

		eth_broadcast_addr(msg->da);
		eth_random_addr(msg->sa);
		msg->len = htons(6);
		msg->dsap = 0;
		msg->ssap = 0x01;	/* NULL LSAP, CR Bit: Response */
		msg->control = 0xaf;	/* XID response lsb.1111F101.
					 * F=0 (no poll command; unsolicited frame) */
		msg->xid_info[0] = 0x81;	/* XID format identifier */
		msg->xid_info[1] = 1;	/* LLC types/classes: Type 1 LLC */
		msg->xid_info[2] = 0;	/* XID sender's receive window size (RW) */

		skb->dev = __dev_get_by_name(&init_net, argv[1]);;
		skb->protocol = eth_type_trans(skb, skb->dev);
		memset(skb->cb, 0, sizeof(skb->cb));
		netif_rx_ni(skb);

		goto done;
	}
/* help */
	pr_info("%s <slave name>\n", argv[0]);
done:
	return 0;
}

static struct proc_cmd_ops command_entries[] = {
	{ .name = "show", .do_command = cmd_show},
	{ .name = "addif", .do_command = cmd_addif},
	{ .name = "delif", .do_command = cmd_delif},
	{ .name = "cfg", .do_command = cmd_config},
	{ .name = "simrx", .do_command = cmd_simrx},
};

struct proc_cmd_table command_table = {
	.module_name = "NETXL",
	.size = ARRAY_SIZE(command_entries),
	.ops = command_entries
};

struct
proc_dir_entry *netxl_proc_dir;

void netxl_procfs_init(void)
{
	netxl_proc_dir = proc_mkdir(NETXL_PROC_DIR_NAME, NULL);
	if (netxl_proc_dir == NULL) {
		pr_warn("NETXL Warning: cannot create /proc/%s\n",
			NETXL_PROC_DIR_NAME);
		return;
	}
	proc_create_cmd("cmd", netxl_proc_dir, &command_table);
}

void netxl_procfs_exit(void)
{
	if (netxl_proc_dir) {
		remove_proc_entry("cmd", netxl_proc_dir);
		remove_proc_entry(NETXL_PROC_DIR_NAME, NULL);
		netxl_proc_dir = NULL;
	}
}
