 /****************************************************************************
 *
 * Copyright (c) 2016-2020 Broadcom. All rights reserved
 * The term "Broadcom" refers to Broadcom Inc. and/or its subsidiaries.
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************
 * Author: Jayesh Patel <jayesh.patel@broadcom.com>
 ****************************************************************************/

#include <linux/version.h>
#include "netxl.h"
#if (LINUX_VERSION_CODE > KERNEL_VERSION(5,4,0))
#include <linux/ethtool.h>
#endif

#define SLAVE_ETHOPS netxl->slave->ethtool_ops

#if (LINUX_VERSION_CODE < KERNEL_VERSION(4,20,0))
static
int	get_settings(struct net_device *dev, struct ethtool_cmd *cmd)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	return SLAVE_ETHOPS->get_settings(netxl->slave, cmd);
}
static
int	set_settings(struct net_device *dev, struct ethtool_cmd *cmd)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	return SLAVE_ETHOPS->set_settings(netxl->slave, cmd);
}
#endif
static
void	get_drvinfo(struct net_device *dev, struct ethtool_drvinfo *info)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	SLAVE_ETHOPS->get_drvinfo(netxl->slave, info);
}
static
int	get_regs_len(struct net_device *dev)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	return SLAVE_ETHOPS->get_regs_len(netxl->slave);
}
static
void    get_regs(struct net_device *dev, struct ethtool_regs *reg, void *data)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	SLAVE_ETHOPS->get_regs(netxl->slave, reg, data);
}
static
void	get_wol(struct net_device *dev, struct ethtool_wolinfo *info)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	SLAVE_ETHOPS->get_wol(netxl->slave, info);
}
static
int	set_wol(struct net_device *dev, struct ethtool_wolinfo *info)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	return SLAVE_ETHOPS->set_wol(netxl->slave, info);
}
static
u32	get_msglevel(struct net_device *dev)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	return SLAVE_ETHOPS->get_msglevel(netxl->slave);
}
static
void	set_msglevel(struct net_device *dev, u32 lvl)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	SLAVE_ETHOPS->set_msglevel(netxl->slave, lvl);
}
static
int	nway_reset(struct net_device *dev)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	return SLAVE_ETHOPS->nway_reset(netxl->slave);
}
static
u32	get_link(struct net_device *dev)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	return SLAVE_ETHOPS->get_link(netxl->slave);
}
static
int	get_eeprom_len(struct net_device *dev)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	return SLAVE_ETHOPS->get_eeprom_len(netxl->slave);
}
static
int	get_eeprom(struct net_device *dev,
		   struct ethtool_eeprom *eeprom, u8 *data)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	return SLAVE_ETHOPS->get_eeprom(netxl->slave, eeprom, data);
}
static
int	set_eeprom(struct net_device *dev,
		   struct ethtool_eeprom *eeprom, u8 *data)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	return SLAVE_ETHOPS->set_eeprom(netxl->slave, eeprom, data);
}
#if (LINUX_VERSION_CODE < KERNEL_VERSION(5,14,0))
static
int	get_coalesce(struct net_device *dev, struct ethtool_coalesce *cs)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	return SLAVE_ETHOPS->get_coalesce(netxl->slave, cs);
}
static
int	set_coalesce(struct net_device *dev, struct ethtool_coalesce *cs)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	return SLAVE_ETHOPS->set_coalesce(netxl->slave, cs);
}
#endif
static
void	get_ringparam(struct net_device *dev,
		      struct ethtool_ringparam *param)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	return SLAVE_ETHOPS->get_ringparam(netxl->slave, param);
}
static
int	set_ringparam(struct net_device *dev,
		      struct ethtool_ringparam *param)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	return SLAVE_ETHOPS->set_ringparam(netxl->slave, param);
}
static
void	get_pauseparam(struct net_device *dev,
		       struct ethtool_pauseparam *param)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	return SLAVE_ETHOPS->get_pauseparam(netxl->slave, param);
}
static
int	set_pauseparam(struct net_device *dev,
		       struct ethtool_pauseparam *param)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	return SLAVE_ETHOPS->set_pauseparam(netxl->slave, param);
}
static
void	self_test(struct net_device *dev, struct ethtool_test *test, u64 *data)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	return SLAVE_ETHOPS->self_test(netxl->slave, test, data);
}
static
void	get_strings(struct net_device *dev, u32 stringset, u8 *data)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	return SLAVE_ETHOPS->get_strings(netxl->slave, stringset, data);
}
static
int	set_phys_id(struct net_device *dev, enum ethtool_phys_id_state id)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	return SLAVE_ETHOPS->set_phys_id(netxl->slave, id);
}
static
void	get_ethtool_stats(struct net_device *dev,
			  struct ethtool_stats *stats, u64 *data)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	return SLAVE_ETHOPS->get_ethtool_stats(netxl->slave, stats, data);
}
static
int	ethtool_begin(struct net_device *dev)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	return SLAVE_ETHOPS->begin(netxl->slave);
}
static
void	ethtool_complete(struct net_device *dev)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	SLAVE_ETHOPS->complete(netxl->slave);
}
static
u32	get_priv_flags(struct net_device *dev)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	return SLAVE_ETHOPS->get_priv_flags(netxl->slave);
}
static
int	set_priv_flags(struct net_device *dev, u32 flags)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	return SLAVE_ETHOPS->set_priv_flags(netxl->slave, flags);
}
static
int	get_sset_count(struct net_device *dev, int set)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	return SLAVE_ETHOPS->get_sset_count(netxl->slave, set);
}
static
int	get_rxnfc(struct net_device *dev,
		  struct ethtool_rxnfc *rxnfc, u32 *rule_locs)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	return SLAVE_ETHOPS->get_rxnfc(netxl->slave, rxnfc, rule_locs);
}
static
int	set_rxnfc(struct net_device *dev, struct ethtool_rxnfc *rxnfc)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	return SLAVE_ETHOPS->set_rxnfc(netxl->slave, rxnfc);
}
static
int	flash_device(struct net_device *dev, struct ethtool_flash *flash)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	return SLAVE_ETHOPS->flash_device(netxl->slave, flash);
}
static
int	ethtool_reset(struct net_device *dev, u32 *data)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	return SLAVE_ETHOPS->reset(netxl->slave, data);
}
static
u32	get_rxfh_indir_size(struct net_device *dev)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	return SLAVE_ETHOPS->get_rxfh_indir_size(netxl->slave);
}
#if LINUX_VERSION_CODE > KERNEL_VERSION(3, 18, 0)
static
int	get_rxfh(struct net_device *dev, u32 *indir, u8 *key,
		 u8 *hfunc)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	return SLAVE_ETHOPS->get_rxfh(netxl->slave, indir, key, hfunc);
}
static
int	set_rxfh(struct net_device *dev, const u32 *indir,
		 const u8 *key, const u8 hfunc)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	return SLAVE_ETHOPS->set_rxfh(netxl->slave, indir, key, hfunc);
}
#else
static
int	get_rxfh(struct net_device *dev, u32 *rxfh)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	return SLAVE_ETHOPS->get_rxfh_indir(netxl->slave, rxfh);
}
static
int	set_rxfh(struct net_device *dev, const u32 *rxfh)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	return SLAVE_ETHOPS->set_rxfh_indir(netxl->slave, rxfh);
}
#endif
static
void	get_channels(struct net_device *dev, struct ethtool_channels *chan)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	return SLAVE_ETHOPS->get_channels(netxl->slave, chan);
}
static
int	set_channels(struct net_device *dev, struct ethtool_channels *chan)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	return SLAVE_ETHOPS->set_channels(netxl->slave, chan);
}
static
int	get_dump_flag(struct net_device *dev, struct ethtool_dump *dump)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	return SLAVE_ETHOPS->get_dump_flag(netxl->slave, dump);
}
static
int	get_dump_data(struct net_device *dev,
		      struct ethtool_dump *dump, void *data)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	return SLAVE_ETHOPS->get_dump_data(netxl->slave, dump, data);
}
static
int	set_dump(struct net_device *dev, struct ethtool_dump *dump)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	return SLAVE_ETHOPS->set_dump(netxl->slave, dump);
}
static
int	get_ts_info(struct net_device *dev, struct ethtool_ts_info *info)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	return SLAVE_ETHOPS->get_ts_info(netxl->slave, info);
}
static
int     get_module_info(struct net_device *dev,
			struct ethtool_modinfo *info)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	return SLAVE_ETHOPS->get_module_info(netxl->slave, info);
}
static
int     get_module_eeprom(struct net_device *dev,
			  struct ethtool_eeprom *eeprom, u8 *data)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	return SLAVE_ETHOPS->get_module_eeprom(netxl->slave, eeprom, data);
}
static
int	get_eee(struct net_device *dev, struct ethtool_eee *eee)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	return SLAVE_ETHOPS->get_eee(netxl->slave, eee);
}
static
int	set_eee(struct net_device *dev, struct ethtool_eee *eee)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	return SLAVE_ETHOPS->set_eee(netxl->slave, eee);
}
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(4,6,0))
static
int	get_link_ksettings(struct net_device *dev, struct ethtool_link_ksettings *link_ksetting)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	return SLAVE_ETHOPS->get_link_ksettings(netxl->slave, link_ksetting);
}
static
int	set_link_ksettings(struct net_device *dev, const struct ethtool_link_ksettings *link_ksetting)
{
	struct netxl *netxl;
	netxl = NETXL_CTX(dev);
	return SLAVE_ETHOPS->set_link_ksettings(netxl->slave, link_ksetting);
}
#endif

static struct ethtool_ops netxl_ethtool_ops = {
#if (LINUX_VERSION_CODE < KERNEL_VERSION(4,20,0))
	.get_settings        = get_settings,
	.set_settings        = set_settings,
#endif
	.get_drvinfo         = get_drvinfo,
	.get_regs_len        = get_regs_len,
	.get_regs            = get_regs,
	.get_wol             = get_wol,
	.set_wol             = set_wol,
	.get_msglevel        = get_msglevel,
	.set_msglevel        = set_msglevel,
	.nway_reset          = nway_reset,
	.get_link            = get_link,
	.get_eeprom_len      = get_eeprom_len,
	.get_eeprom          = get_eeprom,
	.set_eeprom          = set_eeprom,
#if (LINUX_VERSION_CODE < KERNEL_VERSION(5,14,0))
	.get_coalesce        = get_coalesce,
	.set_coalesce        = set_coalesce,
#endif
	.get_ringparam       = get_ringparam,
	.set_ringparam       = set_ringparam,
	.get_pauseparam      = get_pauseparam,
	.set_pauseparam      = set_pauseparam,
	.self_test           = self_test,
	.get_strings         = get_strings,
	.set_phys_id         = set_phys_id,
	.get_ethtool_stats   = get_ethtool_stats,
	.begin               = ethtool_begin,
	.complete            = ethtool_complete,
	.get_priv_flags      = get_priv_flags,
	.set_priv_flags      = set_priv_flags,
	.get_sset_count      = get_sset_count,
	.get_rxnfc           = get_rxnfc,
	.set_rxnfc           = set_rxnfc,
	.flash_device        = flash_device,
	.reset               = ethtool_reset,
	.get_rxfh_indir_size = get_rxfh_indir_size,
#if LINUX_VERSION_CODE > KERNEL_VERSION(3, 18, 0)
	.get_rxfh            = get_rxfh,
	.set_rxfh            = set_rxfh,
#else
	.get_rxfh_indir      = get_rxfh,
	.set_rxfh_indir      = set_rxfh,
#endif
	.get_channels        = get_channels,
	.set_channels        = set_channels,
	.get_dump_flag       = get_dump_flag,
	.get_dump_data       = get_dump_data,
	.set_dump            = set_dump,
	.get_ts_info         = get_ts_info,
	.get_module_info     = get_module_info,
	.get_module_eeprom   = get_module_eeprom,
	.get_eee             = get_eee,
	.set_eee             = set_eee,
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(4,6,0))
	.get_link_ksettings   = get_link_ksettings,
	.set_link_ksettings   = set_link_ksettings,
#endif
};

void netxl_copy_ethtool_ops(struct net_device *dst,
			    struct net_device *src)
{
	int i;
	funcptr *p1;
	funcptr *p2;
	dst->ethtool_ops = kmemdup(&netxl_ethtool_ops,
				   sizeof(struct ethtool_ops),
				   GFP_KERNEL);
	p1 = (funcptr *) dst->ethtool_ops;
	p2 = (funcptr *) src->ethtool_ops;
	for (i = 0; i < (sizeof(struct ethtool_ops)/sizeof(funcptr)); i++) {
		/* If src function is null then make dst function null */
		if (!*p2)
			*p1 = 0;
		p2++;
		p1++;
	}
}
