/****************************************************************************
 *
 * Broadcom Proprietary and Confidential.
 * (c) 2016 Broadcom. All rights reserved.
 * The term "Broadcom" refers to Broadcom Limited and/or its subsidiaries.
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************
 * Author: Jayesh Patel <jayesh.patel@broadcom.com>
 ***************************************************************************/

#ifndef _NETXL_H
#define _NETXL_H
#include <bcmnethooks.h>
#include <linux/netdevice.h>

#define NETXL_CTX(p)  (((struct netxl_priv *)netdev_priv(p))->netxl)

#define NETXL_SYSCTL_VARS_MAX	6
struct netxl_sysctl {
	struct ctl_table_header *ctl_hdr;
	struct ctl_table vars[NETXL_SYSCTL_VARS_MAX];
};

/* netxl interface mapping structure */
struct netxl_if_map {
	int id;			/* Mapping ID: Dev ID  */
	int fap_if;             /* FAP interface id */
	int r;			/* Radio match: 0, 1 or 2 */
	int s;			/* SSID match: Bit mask */
	char *mrx;		/* RX MDQM Name */
	char *mtx;		/* TX MDQM Name */
	struct net_device  *dev;/* Netxl device */
};

struct netxl {
	struct   net_device *dev;
	struct   net_device *slave;
	struct   netxl_sysctl sysctl;
	struct   proc_dir_entry	*proc_dir_entry;
	int      rx_offload;
	int      tx_bypass;
	int      wlertx_skb_in_fpm;
	int      mdqm_rx_id;
	int      mdqm_tx_id;
	void     *dqm_tx_h;
	int      msg_size;
	int      id;
	bool     rx_type;
	bool     tx_type;
	u32      head_pad;
	u32      tail_pad;
	u32 	 tx_headroom;
	struct netxl_if_map *ifmapping;
};

/* Cannot be more than 4words as this structure is overlapped into
   1st 4words of dqnet_netdev struct */
struct netxl_priv {
	union {
		struct netdev_priv_shared shared;
		struct netxl *netxl;
	};
};

void netxl_netdevice_show(char *master_name);
int netxl_netdevice_add(char *master_name, char *slave_name,
			int id, char *pkt_type);
int netxl_netdevice_del(char *master_name);
int netxl_netdevice_cfg(char *master_name, char *param,
			int value);
bool netxl_netdevice_is_slave(struct net_device *dev);

void netxl_procfs_init(void);
void netxl_procfs_exit(void);
int netxl_sys_add(struct net_device *dev);
void netxl_sys_del(struct net_device *dev);
typedef int (*funcptr)(void);
void netxl_copy_ethtool_ops(struct net_device *dst,
			    struct net_device *src);

struct netxl_if_map *netxl_fap_ifmapping(unsigned id);
int netxl_fap_netdev_init(struct netxl *netxl, char *pkt_type);
int netxl_fap_netdev_exit(struct netxl *netxl);
int netxl_fap_init(void);
void netxl_fap_exit(void);
int netxl_fap_show(struct netxl *netxl);

#endif
