/*
 * Copyright (C) 2022 Broadcom Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 *
 * Author: Peter Sulc <peter.sulc@broadcom.com>
 *
 */

#include <linux/version.h>
#include <linux/kernel.h>
#include <linux/types.h>
#include <linux/ctype.h>
#include <linux/ktime.h>
#include <linux/timer.h>
#include <linux/printk.h>
#include <linux/dynamic_debug.h>

#include "bspeed.h"

#define ACK_TIMER_FREQ	3

static struct timer_list ack_timer;

static unsigned long expires;

static u32 timer_mods;
static u32 timer_triggers;

static void ack_timer_func(struct timer_list *t)
{
	bspeed_ack_timer(jiffies);
	timer_triggers++;
}

void bspeed_init_ack_timer(void)
{
	expires = 0;
	timer_setup(&ack_timer, ack_timer_func, 0);
}

void bspeed_del_ack_timer(void)
{
	del_timer_sync(&ack_timer);
}

void bspeed_mod_ack_timer(void)
{
	unsigned long newtime = jiffies + msecs_to_jiffies(ACK_TIMER_FREQ);
	if (newtime != expires) {
		mod_timer(&ack_timer, newtime);
		expires = newtime;
		timer_mods++;
	}
}

void bspeed_print_timer_stats(void)
{
	pr_info("Timer stats: mods %u triggers %u\n", timer_mods, timer_triggers);
	timer_mods = 0;
	timer_triggers = 0;
}
