/*
 * Copyright (C) 2018 Broadcom Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 *
 * Author: Peter Sulc <peter.sulc@broadcom.com>
 *
 */

#ifndef __BSPEED_API__
#define __BSPEED_API__

struct bspeed_fpm_buff {
        u32     if_id;          /* interface ID from pkt descriptor */
        u32     if_sub_id;      /* interface sub-ID from pkt descriptor */
        u32     priority;       /* priority from pkt descriptor */
        u32     cmim;           /* CMIM */
        u8      queue_id;       /* RX/TX Queue ID */
        int     brcm_tag_len;   /* length of BRCM tag */
        int     fap_tag_len;    /* length of FAP tag */
        int     sv_tag_len;     /* length of SV tag */
        int     type;           /* FPM or SKB */
        void    *skb;           /* SKB */
        u32     token;          /* FPM token */
        u8      *buf;           /* FPM buffer */
        u8      *data;          /* FPM buffer valid data */
        u32     len;            /* FPM data length */
        u32     offset;         /* FPM data offset */
        void    *dev_in;
        void    *dev_out;
};

struct bspeed_stats {
	u32 packets;
	u32 acks;
	u32 sacks;
	u32 ooo;
	u32 start_jiffies;
	u32 end_jiffies;
	u64 bytes;
};

struct bspeed_udp_stats {
	u64 packets;
	union {
		u32 rd_calls;
		u32 wr_calls;
	};
	u64 ooo;
	u64 lost;
	u32 start_jiffies;
	u32 end_jiffies;
	u64 bytes;
	s32 jitter;
};

extern u32	bspeed_ack_delay_start;
extern u32	bspeed_ack_delay_limit;
extern u32	bspeed_validate_checksum;
extern u32	bspeed_noaccel;
extern u32	bspeed_nspp;
extern u32	bspeed_nspp_static;
extern u32	bspeed_retrans_gap;
extern u32	bspeed_rcvlowat;
extern u32	bspeed_rtt_stats;
extern u32	bspeed_rtt_max;
extern u32	bspeed_udp_pkt_thresh;
extern u32	bspeed_no_schedule;

extern int bspeed_alloc_fpm(void *dev, struct bspeed_fpm_buff *fb, int len);
extern int bspeed_free_fpm_buff(struct bspeed_fpm_buff *fb);

extern void bspeed_conn_list_write_lock(void);
extern void bspeed_conn_list_write_unlock(void);
extern void bspeed_conn_list_read_lock(void);
extern void bspeed_conn_list_read_unlock(void);
extern void *bspeed_spin_lock_create(void);
extern void bspeed_spin_lock_destroy(void *lock);
extern void bspeed_spin_lock(void *lock, unsigned long *flags);
extern void bspeed_spin_unlock(void *lock, unsigned long flags);

extern int bspeed_printk(const char *fmt, ...);
extern int bspeed_pr_info(const char *fmt, ...);
extern int bspeed_pr_err(const char *fmt, ...);
extern int bspeed_sprintf(char *buf, const char *fmt, ...);

extern void *bspeed_kmalloc(int size, bool atomic);
extern void bspeed_kfree(void *p);

extern u32 bspeed_get_ports(void *skp);
extern void bspeed_clean_old(void);

extern u32 bspeed_get_jiffies(void);
extern u32 bspeed_msecs_since(u32 prior_jiffies);
extern u32 bspeed_get_tcp_timestamp(void *sk);
extern u32 bspeed_get_tcp_timestamp_diff(void *sk, u32 ts);
extern void bspeed_set_rcvlowat(void *sk, int lowat);

extern u64 bspeed_get_ns(void);
extern u64 bspeed_ns_since(u64 ns);

extern void bspeed_update_us_tcp_send_seq(void *sk, u32 seq);
extern void bspeed_update_ds_tcp_send_seq(void *sk, u32 seq);
extern void bspeed_update_ds_tcp_recv_seq(void *sk, u32 seq);
extern void bspeed_update_ds_tcp_copied_seq(void *sk, int copied);

extern __be16 bspeed_tcp_v4_csum(int len,
				__be32 saddr,
				__be32 daddr,
				const void *tcph);
extern __be16 bspeed_tcp_v6_csum(int len,
				const struct in6_addr *saddr,
				const struct in6_addr *daddr,
				const void *tcph);
extern void bspeed_ip_send_check(struct iphdr *ip);


extern u64 bspeed_tx_fpm_buff(struct bspeed_fpm_buff *fb);
extern u32 bspeed_get_tcpsock_mss(void *sk);
extern void bspeed_update_send_tcp_window(void *sk, u32 seq, u16 window);
extern u32 bspeed_get_snd_una(void *sk);
extern void bspeed_set_snd_una(void *sk, u32 seq);
extern int bspeed_get_avail(void *sk);

enum bspeed_nethook_result {
        BSPEED_NETHOOK_PASS,       /* pass packet to next nethook */
        BSPEED_NETHOOK_DROP,       /* drop packet */
        BSPEED_NETHOOK_SKIP,       /* skip remaining nethooks */
        BSPEED_NETHOOK_CONSUMED,   /* nethook consumed packet */
        BSPEED_NETHOOK_MAX_RESULT
};

enum bspeed_nethook_result bspeed_nethook_tx(void *buf);
enum bspeed_nethook_result bspeed_nethook_rx(void *buf);

extern int bspeed_connection_count(void);
extern void bspeed_new_connection_v4(void *sk, __be32 saddr, __be32 daddr,
				     __be32 ports, u32 rate, bool sender,
				     int udp, u64 blocks);
extern void bspeed_new_connection_v6(void *sk, __be32 *saddr, __be32 *daddr,
				    __be32 ports, u32 rate, bool sender,
				     int udp, u64 blocks);

extern int bspeed_del_connection(void *sk);
extern int bspeed_read_connection(void *sk, int buflen, int *accelerated);
extern int bspeed_write_accelerated(void *sock, void *buff, int len, int mss, int wnd);
extern int bspeed_sock_sendmsg(void *sock, void *buff, int len);

extern void bspeed_print_stream_stats(struct bspeed_stats *stats);
extern void bspeed_record_stats(struct bspeed_stats *stats);

extern void bspeed_schedule(void);
extern int bspeed_unregister_hooks(void *sock);
extern void *bspeed_get_sock_sk(void *sock);
extern bool bspeed_socket_tx_acks_pending(void *sock);
extern void *bspeed_register_napi_complete(void *dev, void (*napi_complete_hook)(void *));
extern void bspeed_unregister_napi_complete(void *chan);
extern void bspeed_clear_xmit_timers(void *sock);

extern void *bspeed_hrtimer_create(void);
extern void bspeed_hrtimer_destroy(void *vhc);
extern void bspeed_hrtimer_init(void *vhc);
extern void bspeed_hrtimer_start(void *vhc, u32 interval);
extern void bspeed_hrtimer_stop(void *vhc);
extern void bspeed_hrtimer_set_interval(void *vhc, u32 interval);
extern bool bspeed_hrtimer_tx_congested(void *vhc);
extern bool bspeed_hrtimer_tx_empty(void *vhc);
extern bool bspeed_hrtimer_tx_fpm(void *vhc, struct bspeed_fpm_buff *fb);

void bspeed_csum_replace4(__be16 *sum, __be32 from, __be32 to);
extern __be16 bspeed_udp_v4_csum(int len,
				__be32 saddr,
				__be32 daddr,
				const void *udph);
extern __be16 bspeed_udp_v6_csum(int len,
				const struct in6_addr *saddr,
				const struct in6_addr *daddr,
				const void *udph);
struct timeval32
{
    int tv_sec, tv_usec;
};
void bspeed_get_timeval32(struct timeval32 *value);
extern u32 bspeed_usecs_since(u32 prior_jiffies);
void bspeed_update_ds_udp_recv(void *sk);
enum bspeed_nethook_result bspeed_nethook_tx_udp4(void *dev, void *buf, int len);
enum bspeed_nethook_result bspeed_nethook_tx_udp6(void *dev, void *buf, int len);
enum bspeed_nethook_result bspeed_nethook_rx_udp4(void *buf);
enum bspeed_nethook_result bspeed_nethook_rx_udp6(void *buf);
extern int bspeed_write_accelerated_udp(void *sock, void *buff, int len);
extern int bspeed_read_udp_connection(void *sk, int *buff, int *accelerated);
extern int bspeed_sock_sendmsg_udp(void *sock, void *buff, int len);
extern void bspeed_print_stream_udp_stats(struct bspeed_udp_stats *stats);
extern void bspeed_record_udp_stats(struct bspeed_udp_stats *stats);

extern const char *bspeed_version_string;

#endif
