/*
 * Copyright (C) 2018 Broadcom Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 *
 * Author: Peter Sulc <peter.sulc@broadcom.com>
 *
 */

#include <linux/kernel.h>
#include <linux/types.h>
#include <linux/ctype.h>
#include <linux/file.h>
#include <linux/skbuff.h>
#include <linux/net.h>
#include <linux/etherdevice.h>
#include <linux/socket.h>
#include <net/neighbour.h>
#include <net/netevent.h>
#include <linux/if_arp.h>
#include <net/ipv6.h>
#include <net/tcp.h>
#include <net/udp.h>
#include <net/sock.h>
#include <net/protocol.h>
#include <net/inet_sock.h>
#include <linux/netfilter.h>
#include <linux/netfilter_bridge.h>
#include <uapi/linux/ip.h>
#include <uapi/linux/ipv6.h>
#include <net/ip6_checksum.h>

#include "fpm.h"
#include "bcmnethooks.h"
#include "bspeed.h"
#include "bspeed_shim.h"

#include "dqnet.h"
#include "dqnet_priv.h"
#include "dqnet_fap.h"
#include "dqnet_brcmtag.h"

static struct fpm_hw_info fpm_info;

int bspeed_alloc_fpm(void *dv, struct bspeed_fpm_buff *fb, int len)
{
	int token_len;
	struct net_device *dev = dv;
	struct dqnet_netdev *ndev = netdev_priv(dev);

	fb->fap_tag_len = dqnet_fap_get_tag_len(dev);
	fb->brcm_tag_len = dqnet_get_brcm_tag_len(ndev);
	token_len = ndev->head_pad + fb->fap_tag_len + fb->brcm_tag_len + len +
		ndev->tail_pad + 4;
	fb->token = fpm_alloc_token(token_len);
	if (fb->token) {
		fb->if_id = ndev->if_id;
		fb->if_sub_id = ndev->if_sub_id;
		fb->priority = 0;
		fb->cmim = 0;
		fb->queue_id = 0;
		fb->type = BUF_TYPE_FPM;
		fb->skb = NULL;
		fb->buf = fpm_token_to_buffer(fb->token);
		fb->offset = fpm_info.net_buf_head_pad;
		fb->data = fb->buf + fb->offset;
		fb->len = len;
		fb->dev_in = fb->dev_out = dev;
		fpm_flush_invalidate_token(fb->token, ndev->head_pad, ndev->tail_pad,
					   FPM_SYNC_HEAD | FPM_SYNC_TAIL);
		pr_debug("%s len %d token_len %d buf %p data %p offset %d\n",
			 __func__, len, token_len, fb->buf, fb->data, fb->offset);
	}
	else {
		pr_err("%s: Error alloc token failed!\n", __func__);
		return -ENOMEM;
	}
	return 0;
}

int bspeed_free_fpm_buff(struct bspeed_fpm_buff *fb)
{
	if (fpm_is_valid_token(fb->token)) {
		fpm_invalidate_token(fb->token, fb->offset, fpm_info.net_buf_tail_pad,
				     FPM_SYNC_HEAD | FPM_SYNC_TAIL);
		fpm_free_token(fb->token);
		fb->token = 0;
		return 0;
	}
	pr_err("%s invalid token %08x\n", __func__, fb->token);
	return -ENXIO;
}

int __init bspeed_fpm_init(void)
{
	if (fpm_info.pool_base[0] == 0)
		return fpm_get_hw_info(&fpm_info);
	return 0;
}
