/*
 * Copyright (C) 2017 Broadcom Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Author: Peter Sulc <peter.sulc@broadcom.com>
 */

#ifndef __BSPEED_H__
#define __BSPEED_H__

#include <uapi/linux/ip.h>
#include <uapi/linux/ipv6.h>
#include <net/ipv6.h>
#include <uapi/linux/bcm_media_gw/iperf.h>

#include "bspeed_shim.h"

extern int bspeed_recv(struct iperf_driver_message __user *msg);
extern int bspeed_command(struct iperf_driver_message __user *msg);
extern void bspeed_print_stats(void);
extern void bspeed_print_udp_stats(void);
extern void bspeed_print_stats_proc(struct seq_file *seq);
extern void bspeed_reset_stats(void);
extern void print_connection_info(void);
extern void __init bspeed_client_init(void);
extern int __init bspeed_proc_init(void);
extern void __exit bspeed_proc_exit(void);
extern int __init bspeed_fpm_init(void);

#endif
