################################################################################
#
# bas_mqtt
#
################################################################################
BAS_URIPARSER_VERSION = 0.9.7
# BAS_URIPARSER_SOURCE = uriparser-$(BAS_URIPARSER_VERSION).tar.gz
# BAS_URIPARSER_SITE = https://github.com/uriparser/uriparser/releases/download/uriparser-0.9.7/
# BAS_URIPARSER_SITE_METHOD = wget
BAS_URIPARSER_LICENSE = BSD-3-Clause and MIT
BAS_URIPARSER_LICENSE_FILES = COPYING
BAS_URIPARSER_REDISTRIBUTE = YES
BAS_URIPARSER_INSTALL_STAGING = YES
BAS_URIPARSER_INSTALL_TARGET = NO

#################
# Using base-pkg
#################
BAS_URIPARSER_SITE_METHOD = local
BAS_URIPARSER_SITE = $(realpath $(BAS_URIPARSER_PKGDIR))

# Provide the legal-info's site/URL information that uses "local" site method
# The BAS's mqtt opensource package is pre-downloaded.
BAS_URIPARSER_ACTUAL_SOURCE_SITE = https://github.com/uriparser/uriparser/releases/download/uriparser-0.9.7/ ($(subst $(BR2_EXTERNAL_OPENBFC_PATH),~/external/openbfc,$(BAS_URIPARSER_PKGDIR)))
BAS_URIPARSER_ACTUAL_SOURCE_TARBALL = uriparser-$(BAS_URIPARSER_VERSION).tar.gz

# Extract
# ------------------------------------------------------------------------------
BAS_URIPARSER_POST_RSYNC_HOOKS += BASE_PKG_CUSTOM_EXTRACT

# Patch
# ------------------------------------------------------------------------------
BAS_URIPARSER_POST_RSYNC_HOOKS += BASE_PKG_CUSTOM_PATCH

# Configure
# ------------------------------------------------------------------------------
define BAS_URIPARSER_CONFIGURE_CMDS
	$(call base-pkg-configure)
endef

# Build
# ------------------------------------------------------------------------------
define BAS_URIPARSER_BUILD_CMDS
	$(call base-pkg-build)
endef

# Stage
# ------------------------------------------------------------------------------
define BAS_URIPARSER_INSTALL_STAGING_CMDS
	$(call base-pkg-stage)
endef

# Install
# ------------------------------------------------------------------------------
define BAS_URIPARSER_INSTALL_TARGET_CMDS
	$(call base-pkg-release-install,$(TARGET_DIR))
endef

# Legal-info
# ------------------------------------------------------------------------------
BAS_URIPARSER_PRE_LEGAL_INFO_HOOKS += BASE_PKG_CUSTOM_EXTRACT
BAS_URIPARSER_PRE_LEGAL_INFO_HOOKS += BAS_URIPARSER_PRE_LEGAL_INFO_CMDS

define BAS_URIPARSER_PRE_LEGAL_INFO_CMDS
	@if [[ ! -f $(BAS_URIPARSER_DIR)/COPYING ]]; then \
		ln -s src/$(TARGET)_working_$(ARCH)/COPYING $(BAS_URIPARSER_DIR)/COPYING; \
	fi;
endef

# Clean for reconfigure - need for cleaning the CMakeFiles and CMakeCache.txt
# ------------------------------------------------------------------------------
define BAS_URIPARSER_CLEAN_FOR_RECONFIG_CMDS
	$(call base-pkg-clean-reconfigure)
endef

$(eval $(generic-package))
