################################################################################
#
# bas_sqlite
#
################################################################################

BAS_SQLITE_VERSION = 3440200
# BAS_SQLITE_SOURCE = sqlite-autoconf-$(BAS_SQLITE_VERSION).tar.gz
# BAS_SQLITE_SITE = https://www.sqlite.org/2023
# BAS_SQLITE_SITE_METHOD = wget
BAS_SQLITE_REDISTRIBUTE = YES
BAS_SQLITE_INSTALL_STAGING = YES
BAS_SQLITE_INSTALL_TARGET = NO
BAS_SQLITE_LICENSE = Public domain
BAS_SQLITE_LICENSE_FILES = tea/license.terms

# BAS_SQLITE_CONF_OPTS = --prefix=$(BAS_PREFIX) --libdir=$(BAS_PREFIX)

# $(eval $(autotools-package))

#################
# Using base-pkg
#################
BAS_SQLITE_SITE_METHOD = local
BAS_SQLITE_SITE = $(realpath $(BAS_SQLITE_PKGDIR))

# Provide the legal-info's site/URL information that uses "local" site method
# The BAS's libuv opensource package is pre-downloaded.
BAS_SQLITE_ACTUAL_SOURCE_SITE = https://www.sqlite.org/2023 ($(subst $(BR2_EXTERNAL_OPENBFC_PATH),~/external/openbfc,$(BAS_SQLITE_PKGDIR)))
BAS_SQLITE_ACTUAL_SOURCE_TARBALL = sqlite-autoconf-$(BAS_SQLITE_VERSION).tar.gz
BAS_SQLITE_LICENSE_FILES=license.terms

# Extract
# ------------------------------------------------------------------------------
BAS_SQLITE_POST_RSYNC_HOOKS += BASE_PKG_CUSTOM_EXTRACT

# Patch
# ------------------------------------------------------------------------------
BAS_SQLITE_POST_RSYNC_HOOKS += BASE_PKG_CUSTOM_PATCH

# Configure
# ------------------------------------------------------------------------------
define BAS_SQLITE_CONFIGURE_CMDS
	$(call base-pkg-configure)
endef

# Build
# ------------------------------------------------------------------------------
define BAS_SQLITE_BUILD_CMDS
	$(call base-pkg-build)
endef

# Stage
# ------------------------------------------------------------------------------
define BAS_SQLITE_INSTALL_STAGING_CMDS
	$(call base-pkg-stage)
endef

# Install
# ------------------------------------------------------------------------------
define BAS_SQLITE_INSTALL_TARGET_CMDS
	$(call base-pkg-release-install,$(TARGET_DIR))
endef

# Legal-info
# ------------------------------------------------------------------------------
BAS_SQLITE_PRE_LEGAL_INFO_HOOKS += BASE_PKG_CUSTOM_EXTRACT
BAS_SQLITE_PRE_LEGAL_INFO_HOOKS += BAS_SQLITE_PRE_LEGAL_INFO_CMDS

define BAS_SQLITE_PRE_LEGAL_INFO_CMDS
	@if [[ ! -f $(BAS_SQLITE_DIR)/license.terms ]]; then \
		ln -s src/$(TARGET)_working_$(ARCH)/tea/license.terms $(BAS_SQLITE_DIR)/license.terms; \
	fi;
endef

# Clean for reconfigure - need for cleaning the CMakeFiles and CMakeCache.txt
# ------------------------------------------------------------------------------
define BAS_SQLITE_CLEAN_FOR_RECONFIG_CMDS
	$(call base-pkg-clean-reconfigure)
endef

$(eval $(generic-package))
