################################################################################
#
# bas_mqtt
#
################################################################################
BAS_MQTT_VERSION = 1.3.13
# BAS_MQTT_SOURCE = v$(BAS_MQTT_VERSION).tar.gz
# BAS_MQTT_SITE = https://github.com/eclipse/paho.mqtt.c/archive/refs/tags
# BAS_MQTT_SITE_METHOD = wget
BAS_MQTT_LICENSE = EPL-2.0 or BSD-3-Clause
BAS_MQTT_LICENSE_FILES = epl-v20 edl-v10 LICENSE
BAS_MQTT_REDISTRIBUTE = YES
BAS_MQTT_INSTALL_STAGING = YES
BAS_MQTT_INSTALL_TARGET = NO
BAS_MQTT_DEPENDENCIES = libopenssl

# BAS_MQTT_CONF_OPTS = -DPAHO_BUILD_DEB_PACKAGE=FALSE \
# -DPAHO_ENABLE_TESTING=FALSE \
# -DPAHO_BUILD_SAMPLES=FALSE \
# -DPAHO_BUILD_DOCUMENTATION=FALSE \
# -DPAHO_BUILD_SHARED=TRUE \
# -DPAHO_BUILD_STATIC=FALSE \
# -DPAHO_ENABLE_CPACK=FALSE \
# -DPAHO_WITH_SSL=TRUE \
# -DOPENSSL_ROOT_DIR=$(STAGING_DIR)/usr/lib \
# -DOPENSSL_INCLUDE_DIR=$(STAGING_DIR)/usr/include \
# -DCMAKE_INSTALL_PREFIX=$(BAS_PREFIX) \
# -DCMAKE_INSTALL_LIBDIR=$(BAS_PREFIX)
# $(eval $(cmake-package))

#################
# Using base-pkg
#################
BAS_MQTT_SITE_METHOD = local
BAS_MQTT_SITE = $(realpath $(BAS_MQTT_PKGDIR))

# Provide the legal-info's site/URL information that uses "local" site method
# The BAS's mqtt opensource package is pre-downloaded.
BAS_MQTT_ACTUAL_SOURCE_SITE = https://github.com/eclipse/paho.mqtt.c/archive/refs/tags ($(subst $(BR2_EXTERNAL_OPENBFC_PATH),~/external/openbfc,$(BAS_MQTT_PKGDIR)))
BAS_MQTT_ACTUAL_SOURCE_TARBALL = v$(BAS_MQTT_VERSION).tar.gz



# Extract
# ------------------------------------------------------------------------------
BAS_MQTT_POST_RSYNC_HOOKS += BASE_PKG_CUSTOM_EXTRACT

# Patch
# ------------------------------------------------------------------------------
BAS_MQTT_POST_RSYNC_HOOKS += BASE_PKG_CUSTOM_PATCH

# Configure
# ------------------------------------------------------------------------------
define BAS_MQTT_CONFIGURE_CMDS
	$(call base-pkg-configure)
endef

# Build
# ------------------------------------------------------------------------------
define BAS_MQTT_BUILD_CMDS
	$(call base-pkg-build)
endef

# Stage
# ------------------------------------------------------------------------------
define BAS_MQTT_INSTALL_STAGING_CMDS
	$(call base-pkg-stage)
endef

# Install
# ------------------------------------------------------------------------------
define BAS_MQTT_INSTALL_TARGET_CMDS
	$(call base-pkg-release-install,$(TARGET_DIR))
endef

# Legal-info
# ------------------------------------------------------------------------------
BAS_MQTT_PRE_LEGAL_INFO_HOOKS += BASE_PKG_CUSTOM_EXTRACT
BAS_MQTT_PRE_LEGAL_INFO_HOOKS += BAS_MQTT_PRE_LEGAL_INFO_CMDS

define BAS_MQTT_PRE_LEGAL_INFO_CMDS
	if [[ ! -f $(BAS_MQTT_DIR)/LICENSE ]]; then \
		ln -s src/$(TARGET)_working_$(ARCH)/LICENSE $(BAS_MQTT_DIR)/LICENSE; \
		ln -s src/$(TARGET)_working_$(ARCH)/epl-v20 $(BAS_MQTT_DIR)/epl-v20; \
		ln -s src/$(TARGET)_working_$(ARCH)/edl-v10 $(BAS_MQTT_DIR)/edl-v10; \
	fi;
endef

# Clean for reconfigure - need for cleaning the CMakeFiles and CMakeCache.txt
# ------------------------------------------------------------------------------
define BAS_MQTT_CLEAN_FOR_RECONFIG_CMDS
	$(call base-pkg-clean-reconfigure)
endef

$(eval $(generic-package))
