################################################################################
#
# bas_libuv
#
################################################################################
BAS_LIBUV_VERSION = 1.47.0
# BAS_LIBUV_SOURCE = libuv-v$(BAS_LIBUV_VERSION).tar.gz
# BAS_LIBUV_SITE = https://dist.libuv.org/dist/v$(BAS_LIBUV_VERSION)
# BAS_LIBUV_SITE_METHOD = wget
BAS_LIBUV_LICENSE = BSD-2-Clause, BSD-3-Clause, ISC, MIT
BAS_LIBUV_LICENSE_FILES = LICENSE
BAS_LIBUV_REDISTRIBUTE = YES
BAS_LIBUV_INSTALL_STAGING = YES
BAS_LIBUV_INSTALL_TARGET = NO
BAS_LIBUV_DEPENDENCIES = host-pkgconf

# BAS_LIBUV_CONF_OPTS = --prefix=$(BAS_PREFIX) --libdir=$(BAS_PREFIX)

# define BAS_LIBUV_PRE_CONFIGURE_CMDS
	# $(@D)/autogen.sh
# endef
# BAS_LIBUV_PRE_CONFIGURE_HOOKS += BAS_LIBUV_PRE_CONFIGURE_CMDS

# $(eval $(autotools-package))

#################
# Using base-pkg
#################
BAS_LIBUV_SITE_METHOD = local
BAS_LIBUV_SITE = $(realpath $(BAS_LIBUV_PKGDIR))

# Provide the legal-info's site/URL information that uses "local" site method
# The BAS's libuv opensource package is pre-downloaded.
BAS_LIBUV_ACTUAL_SOURCE_SITE = https://dist.libuv.org/dist/v$(BAS_LIBUV_VERSION) ($(subst $(BR2_EXTERNAL_OPENBFC_PATH),~/external/openbfc,$(BAS_LIBUV_PKGDIR)))
BAS_LIBUV_ACTUAL_SOURCE_TARBALL = libuv-v$(BAS_LIBUV_VERSION).tar.gz

# Extract
# ------------------------------------------------------------------------------
BAS_LIBUV_POST_RSYNC_HOOKS += BASE_PKG_CUSTOM_EXTRACT

# Patch
# ------------------------------------------------------------------------------
BAS_LIBUV_POST_RSYNC_HOOKS += BASE_PKG_CUSTOM_PATCH

# Configure
# ------------------------------------------------------------------------------
define BAS_LIBUV_CONFIGURE_CMDS
	$(call base-pkg-configure)
endef

# Build
# ------------------------------------------------------------------------------
define BAS_LIBUV_BUILD_CMDS
	$(call base-pkg-build)
endef

# Stage
# ------------------------------------------------------------------------------
define BAS_LIBUV_INSTALL_STAGING_CMDS
	$(call base-pkg-stage)
endef

# Install
# ------------------------------------------------------------------------------
define BAS_LIBUV_INSTALL_TARGET_CMDS
	$(call base-pkg-release-install,$(TARGET_DIR))
endef

# Legal-info
# ------------------------------------------------------------------------------
BAS_LIBUV_PRE_LEGAL_INFO_HOOKS += BASE_PKG_CUSTOM_EXTRACT
BAS_LIBUV_PRE_LEGAL_INFO_HOOKS += BAS_LIBUV_PRE_LEGAL_INFO_CMDS

define BAS_LIBUV_PRE_LEGAL_INFO_CMDS
	@if [[ ! -f $(BAS_LIBUV_DIR)/LICENSE ]]; then \
		ln -s src/$(TARGET)_working_$(ARCH)/LICENSE $(BAS_LIBUV_DIR)/LICENSE; \
	fi;
endef

# Clean for reconfigure - need for cleaning the CMakeFiles and CMakeCache.txt
# ------------------------------------------------------------------------------
define BAS_LIBUV_CLEAN_FOR_RECONFIG_CMDS
	$(call base-pkg-clean-reconfigure)
endef

$(eval $(generic-package))
