################################################################################
#
# bas_cjson
#
################################################################################
BAS_CJSON_VERSION = 1.7.17
# BAS_CJSON_SOURCE = v$(BAS_CJSON_VERSION).tar.gz
# BAS_CJSON_SITE = https://github.com/DaveGamble/cJSON/archive/refs/tags/
# BAS_CJSON_SITE_METHOD = wget
BAS_CJSON_LICENSE = MIT
BAS_CJSON_LICENSE_FILES = LICENSE
BAS_CJSON_REDISTRIBUTE = YES
BAS_CJSON_INSTALL_STAGING = YES
BAS_CJSON_INSTALL_TARGET = NO

# BAS_CJSON_CONF_OPTS = -DCMAKE_INSTALL_PREFIX=$(BAS_PREFIX) -DCMAKE_INSTALL_LIBDIR=$(BAS_PREFIX)

# $(eval $(cmake-package))

#################
# Using base-pkg
#################
BAS_CJSON_SITE_METHOD = local
BAS_CJSON_SITE = $(realpath $(BAS_CJSON_PKGDIR))

# Provide the legal-info's site/URL information that uses "local" site method
# The BAS's cjson opensource package is pre-downloaded.
BAS_CJSON_ACTUAL_SOURCE_SITE = https://github.com/DaveGamble/cJSON/archive/refs/tags/ ($(subst $(BR2_EXTERNAL_OPENBFC_PATH),~/external/openbfc,$(BAS_CJSON_PKGDIR)))
BAS_CJSON_ACTUAL_SOURCE_TARBALL = v$(BAS_CJSON_VERSION).tar.gz

# Extract
# ------------------------------------------------------------------------------
BAS_CJSON_POST_RSYNC_HOOKS += BASE_PKG_CUSTOM_EXTRACT

# Patch
# ------------------------------------------------------------------------------
BAS_CJSON_POST_RSYNC_HOOKS += BASE_PKG_CUSTOM_PATCH

# Configure
# ------------------------------------------------------------------------------
define BAS_CJSON_CONFIGURE_CMDS
	$(call base-pkg-configure)
endef

# Build
# ------------------------------------------------------------------------------
define BAS_CJSON_BUILD_CMDS
	$(call base-pkg-build)
endef

# Stage
# ------------------------------------------------------------------------------
define BAS_CJSON_INSTALL_STAGING_CMDS
	$(call base-pkg-stage)
endef

# Install
# ------------------------------------------------------------------------------
define BAS_CJSON_INSTALL_TARGET_CMDS
	$(call base-pkg-release-install,$(TARGET_DIR))
endef

# Legal-info
# ------------------------------------------------------------------------------
BAS_CJSON_PRE_LEGAL_INFO_HOOKS += BASE_PKG_CUSTOM_EXTRACT
BAS_CJSON_PRE_LEGAL_INFO_HOOKS += BAS_CJSON_PRE_LEGAL_INFO_CMDS

define BAS_CJSON_PRE_LEGAL_INFO_CMDS
	@if [[ ! -f $(BAS_CJSON_DIR)/LICENSE ]]; then \
		ln -s src/$(TARGET)_working_$(ARCH)/LICENSE $(BAS_CJSON_DIR)/LICENSE; \
	fi;
endef

# Clean for reconfigure - need for cleaning the CMakeFiles and CMakeCache.txt
# ------------------------------------------------------------------------------
define BAS_CJSON_CLEAN_FOR_RECONFIG_CMDS
	$(call base-pkg-clean-reconfigure)
endef

$(eval $(generic-package))
