################################################################################
#
# bas
#
################################################################################
BAS_PREFIX ?= /usr/local/bas

BAS_VERSION = 2.0
BAS_SITE = $(realpath $(BAS_PKGDIR))
BAS_SITE_METHOD = local
BAS_LICENSE = BROADCOM
BAS_LICENSE_FILES = LICENSE

# ~/src is excluded in release-package, only the release binaries ~/$(ARCH) is included
BAS_REDISTRIBUTE = NO
BAS_INSTALL_STAGING = YES
BAS_INSTALL_TARGET = YES
BAS_DEPENDENCIES = linux libopenssl netsnmp custotp fdt

# Opensource library used by bas
BAS_DEPENDENCIES += bas_cjson
BAS_DEPENDENCIES += bas_libuv
BAS_DEPENDENCIES += bas_mqtt
BAS_DEPENDENCIES += bas_sqlite
BAS_DEPENDENCIES += bas_uriparser

ifeq ($(BR2_PACKAGE_IPERF3_OPENBFC),y)
BAS_DEPENDENCIES += iperf3_openbfc
else ifeq ($(BR2_PACKAGE_IPERF3),y)
BAS_DEPENDENCIES += iperf3
else
$(error NO IPERF3 enabled)
endif

# Tell buildroot not to exclude our output binaries in the "target-finalize" stripping procedure
# strip the leading slash in our prefix as the TARGET_DIR and a slash are prepended to the folder
BR2_STRIP_EXCLUDE_DIRS += $(patsubst /%,%,$(BAS_PREFIX))

# Extract
# ------------------------------------------------------------------------------
BAS_POST_RSYNC_HOOKS += BASE_PKG_CUSTOM_EXTRACT

# Patch
# ------------------------------------------------------------------------------
BAS_POST_RSYNC_HOOKS += BASE_PKG_CUSTOM_PATCH

# Configure
# ------------------------------------------------------------------------------
define BAS_CONFIGURE_CMDS
	$(call base-pkg-configure)
endef

# Build
# ------------------------------------------------------------------------------
define BAS_BUILD_CMDS
	$(call base-pkg-build)
endef

# Stage
# ------------------------------------------------------------------------------
define BAS_INSTALL_STAGING_CMDS
	$(call base-pkg-stage)
endef

# Install
# ------------------------------------------------------------------------------
define BAS_INSTALL_TARGET_CMDS
	$(call base-pkg-release-install,$(TARGET_DIR))
endef

# Clean for reconfigure - need for cleaning the CMakeFiles and CMakeCache.txt
# ------------------------------------------------------------------------------
define BAS_CLEAN_FOR_RECONFIG_CMDS
	$(call base-pkg-clean-reconfigure)
endef

$(eval $(generic-package))
