/*
   Copyright (c) 2015 Broadcom Corporation
   All Rights Reserved

    <:label-BRCM:2015:DUAL/GPL:standard

    Unless you and Broadcom execute a separate written software license
    agreement governing use of this software, this software is licensed
    to you under the terms of the GNU General Public License version 2
    (the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
    with the following added to such license:

       As a special exception, the copyright holders of this software give
       you permission to link this software with independent modules, and
       to copy and distribute the resulting executable under terms of your
       choice, provided that you also meet, for each linked independent
       module, the terms and conditions of the license of that module.
       An independent module is a module which is not derived from this
       software.  The special exception does not apply to any modifications
       of the software.

    Not withstanding the above, under no circumstances may you combine
    this software in any way with any other Broadcom software provided
    under a license other than the GPL, without Broadcom's express prior
    written consent.

:>
*/
#include <stdio.h>
#include <stdint.h>
#include <stdlib.h>
#include <stddef.h>
#include <string.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <limits.h>
#include "macsec_api.h"

#ifndef PHY_DRV_H_
#define PHY_DRV_H_

#define msleep(x)	 usleep(x*1000)
#define udelay		 usleep
#define printk		 printf
#define kfree		 free
#define kmalloc(x,y) malloc(x);
#define GFP_KERNEL	 0
#define do_gettimeofday(x)	gettimeofday(x, 0)

#define MACSEC_IPC_PORT	0x8990

#define SOCK_BUFFER_SIZE	sizeof(if_api_data)

#define MACSEC_PAD  40
#define MAX_MTU_SIZE (1522 + MACSEC_PAD) /* Include 4 bytes for a VLAN header */

typedef struct
{
	void *macsec_dev;
	int	skfd;
	int	phy_id;
	int addr;
	int if_index;
	char if_name[NAME_MAX];
    int phys_port;
    int debug_mode;
    int debug_level;
    unsigned int   ifi_flags;
} phy_dev_t;

typedef struct
{
	macsec_api_data macsec_data;
	char if_name[NAME_MAX];
	unsigned int key_signature;
	unsigned char pad[4];
} if_api_data;

int mdio_read(phy_dev_t *phy_dev, uint16_t phy_addr, uint16_t location, uint16_t *value);
int mdio_write(phy_dev_t *phy_dev, uint16_t phy_addr, uint16_t location, uint16_t value);

#define PHY_READ(a, b, c, d)	if ((ret = mdio_read(a, b, c, d))) goto Exit;
#define PHY_WRITE(a, b, c, d)	if ((ret = mdio_write(a, b, c, d))) goto Exit;

#endif
