#!/usr/bin/perl -w

## Lattice Build Flag Generation Tool
## Generate module.inc file containing Lattice HAL build flags from the Lattice config file.

use strict;

my $MODULE_CM = "CM";
my $MODULE_MTA = "MTA";
my $MODULE_ETHSW = "Ethernet";
my $MODULE_MOCA = "MoCA";
my $MODULE_WIFI = "WiFi";
my $MODULE_PKTACCEL = "PacketAcceleration";
my $MODULE_PON = "Pon";
my $MODULE_SECURITY = "Security";
my $MODULE_WANFAILOVER = "WanFailover";
my $MODULE_VOICEFAILOVER = "VoiceFailover";
my $MODULE_SPEEDTEST = "SpeedTest";
my $MODULE_THREAD = "Thread";
my $MODULE_THERMAL = "Thermal";
my $MODULE_ALTWAN = "AltWan";
my $MODULE_LAG = "LAG";
my $MODULE_GPIO = "Gpio";
my $MODULE_MACSEC = "MacSec";
my $MODULE_NA = "N/A";

my $MODULE_INC_FILE = "module.inc";

my $MODULE;

if (open(CONFIG_FILE, $ARGV[0]) == 0)
{
	print "Error opening config file $ARGV[0]\n";
	exit -1;
}

if (open(LINUX_CONFIG_FILE, $ARGV[1]) == 0)
{
	print "Error opening config file $ARGV[1]\n";
	exit -1;
}

if (open(MODULE_INC, ">", $MODULE_INC_FILE) == 0)
{
	print "Error opening config file $$MODULE_INC_FILE\n";
	exit -1;
}

print MODULE_INC "# It is an automatically generated file. Do not modify.\n\n";
print MODULE_INC "# Module Build Flags\n\n";

while (<CONFIG_FILE>)
{
	chomp;
	if (/object name="Device.(\S+)"/)
	{
		if (($1 eq $MODULE_CM)
		|| ($1 eq $MODULE_MTA)
		|| ($1 eq $MODULE_MOCA)
		|| ($1 eq $MODULE_WIFI)
		|| ($1 eq $MODULE_PON)
		|| ($1 eq $MODULE_SECURITY)
		|| ($1 eq $MODULE_WANFAILOVER)
		|| ($1 eq $MODULE_VOICEFAILOVER)
		|| ($1 eq $MODULE_SPEEDTEST)
		|| ($1 eq $MODULE_THREAD)
		|| ($1 eq $MODULE_THERMAL)
		|| ($1 eq $MODULE_ALTWAN)
		|| ($1 eq $MODULE_LAG)
		|| ($1 eq $MODULE_GPIO)
		|| ($1 eq $MODULE_MACSEC))
		{
			$MODULE = uc($1);
		}
		elsif ($1 eq $MODULE_ETHSW)
		{
			$MODULE = "ETHSW";
		}
		elsif ($1 eq $MODULE_PKTACCEL)
		{
			$MODULE = "PKTACCEL";
		}
		else
		{
			$MODULE = $MODULE_NA;
		}
	}
	if (/parameter name="Present" type="string" defaultValue="(\S+)"/)
	{
		if ($MODULE ne $MODULE_NA)
		{
			if (($1 eq "Yes") && (-d lc($MODULE)))
			{
				print MODULE_INC "LATTICE_", $MODULE, "_INCLUDED=y\n";
				print MODULE_INC "CFLAGS += -DLATTICE_", $MODULE, "_INCLUDED\n\n";
			}
			else
			{
				print MODULE_INC "LATTICE_", $MODULE, "_INCLUDED=n\n\n";
			}
		}
	}
	if (/parameter name="Certification" type="string" defaultValue="(\S+)"/)
	{
		if (($MODULE eq $MODULE_CM) && ($1 eq "Yes"))
		{
			print MODULE_INC "LATTICE_CERT_INCLUDED=y\n";
			print MODULE_INC "CFLAGS += -DLATTICE_CERT_INCLUDED\n\n";
		}
	}
	if (/parameter name="Bridge" type="string" defaultValue="(\S+)"/)
	{
		if (($MODULE eq $MODULE_CM) && ($1 eq "Yes"))
		{
			print MODULE_INC "LATTICE_BRIDGE_INCLUDED=y\n";
			print MODULE_INC "CFLAGS += -DLATTICE_BRIDGE_INCLUDED\n\n";
		}
	}
	if (/parameter name="SwitchType" type="string" defaultValue="(\S+)"/)
	{
		if (($MODULE eq "ETHSW") && ($1 eq "GFAP"))
		{
			print MODULE_INC "LATTICE_ETHSW_GFAP_INCLUDED=y\n";
			print MODULE_INC "CFLAGS += -DLATTICE_ETHSW_GFAP_INCLUDED\n\n";
		}
	}
}

print MODULE_INC "# Module Feature Flags\n\n";

while (<LINUX_CONFIG_FILE>)
{
	chomp;
	if (/CONFIG_BCM_FLOWMGR_IOCTL=y/)
	{
		print MODULE_INC "CFLAGS += -DLATTICE_PKTACCEL_FLOWMGR_IOCTL_INCLUDED\n\n";
	}
}

close(CONFIG_FILE);
close(LINUX_CONFIG_FILE);
close(MODULE_INC);
