################################################################################
#
# lattice
#
################################################################################

LATTICE_VERSION = 1.0
LATTICE_SITE = $(OPENBFC_PACKAGE_LIBS_DIR)/lattice
LATTICE_SITE_METHOD = local
LATTICE_REDISTRIBUTE = YES
LATTICE_INSTALL_STAGING = YES
LATTICE_DEPENDENCIES = linux netsnmp itc_rpc dma_ipc
LATTICE_DEPENDENCIES += $(if $(BR2_PACKAGE_MOCACTL_OPENBFC),mocactl_openbfc)
LATTICE_DEPENDENCIES += $(if $(BR2_PACKAGE_BCMASTRA_SUPPORTED),bcm_astra)
LATTICE_LICENSE = BROADCOM
LATTICE_LICENSE_FILES = LICENSE

# Extract
# ------------------------------------------------------------------------------

# Patch
# ------------------------------------------------------------------------------
LATTICE_POST_RSYNC_HOOKS += BASE_PKG_CUSTOM_PATCH

# Configure
# ------------------------------------------------------------------------------
define LATTICE_CONFIGURE_CMDS
        $(call base-pkg-configure)
endef

# Build
# ------------------------------------------------------------------------------
define LATTICE_BUILD_CMDS
	$(call base-pkg-build)
endef

# Stage
# ------------------------------------------------------------------------------
define LATTICE_INSTALL_STAGING_CMDS
	$(call base-pkg-stage,'$(TARGET).inc')
        $(call base-pkg-stage,'*/*.h')
endef

# Install
# ------------------------------------------------------------------------------
define LATTICE_INSTALL_TARGET_CMDS
	$(call base-pkg-release-install,$(TARGET_DIR))
endef

$(eval $(generic-package))
