#include <stdio.h>
#include <inttypes.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <arpa/inet.h>

/* awkward checksum */
int hcs32(const char *filename, int verbose)
{
	int fd, bytes, count, aligned_len;
	uint32_t csum, data_csum, data_len, val;

	fd = open(filename, O_RDONLY);
	if (fd < 0) {
		if (verbose)
            printf("Unable to open %s for reading\n", filename);
		return -1;
	}
	bytes = read(fd, &data_len, sizeof(data_len));
	if (bytes < sizeof(data_len)) {
		if (verbose)
            printf("file %s is too small to be valid\n", filename);
      close(fd);
		return -1;
	}
	count = bytes;
	data_len = ntohl(data_len);
	bytes = read(fd, &data_csum, sizeof(data_csum));
	if (bytes < sizeof(data_csum)) {
		if (verbose)
            printf("file %s is too small to be valid\n", filename);
      close(fd);
		return -1;
	}
	count += bytes;
	data_csum = ntohl(data_csum);

	if (verbose)
        printf("file       %s\nlength     %d\nchecksum   %08x\ncomplement %08x\n",
               filename, data_len, data_csum, ~data_csum);

	csum = data_len;

	aligned_len = data_len & ~3;

	do {
		val = 0;
		bytes = read(fd, &val, sizeof(val));
		if (bytes > 0) {
			count += bytes;
			val = ntohl(val);
			csum += val;
		}
	} while ((bytes > 0) && (count < aligned_len));

	if ((bytes > 0) && (count < data_len)) {
		/* this bit of crazyness is due to the C++ code on CM */
		int left = data_len - count;
		unsigned char ch;
		val = 0;
		do {
			bytes = read(fd, &ch, sizeof(ch));
			if (bytes > 0) {
				val |= ch;
				val <<= 8;
				count += bytes;
			}
		} while ((bytes > 0) && (count < data_len));
		if (left == 2)
			val <<= 8;
		if (verbose)
            printf("precheck   %08x left %d val %08x\n", csum, left, val);
		csum += val;
	}
	close(fd);
	csum = ~csum;
	if (verbose)
        printf("Calculated %08x\ncomplement %08x %s\n",
               ~csum, csum, csum == data_csum ? "good" : "bad");

	return csum == data_csum ? 0 : -1;
}
