/*
 * Note: this file originally auto-generated by mib2c using
 *  $
 */

#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>
#include "bcm_net_snmp.h"
#include "latticeTestMib.h"
#include <pthread.h>
#include <unistd.h>
#include <string.h>
#include <arpa/inet.h>

#define SNMP_IPV4 (1)
#define SNMP_IPV6 (2)

#define SNMP_TRUE (1)
#define SNMP_FALSE (2)

#define LOCAL_TEST_PATH    "/tmp/python/test"
#ifdef BUILD_OPENWRT
#define LOCAL_USERIO_LIB   "/usr/local/etc/python/UserIO.py"
#else
#define LOCAL_USERIO_LIB   "/tmp/python/scripts/UserIO.py"
#endif

#define NNN 256
#define MAX_LATTICE_TEST_ENTRIES 16

#define LATTICE_STATUS_IDLE     (1)
#define LATTICE_STATUS_TESTING  (2)
#define LATTICE_STATUS_COMPLETE (3)

#define LATTICE_MODE_AUTOUPLOAD (1)
#define LATTICE_MODE_NOAUTOUPLOAD (2)

#define LATTICE_OUTPUT_FILE_CONTROL_UPLOAD          (2)
#define LATTICE_OUTPUT_FILE_CONTROL_CANCEL_UPLOAD   (3)

#define LATTICE_OUTPUT_FILE_OTHER               (1)
#define LATTICE_OUTPUT_FILE_AVAILABLE           (2)
#define LATTICE_OUTPUT_FILE_UPLOAD_INPROGRESS   (3)
#define LATTICE_OUTPUT_FILE_UPLOAD_COMPLETE     (4)
#define LATTICE_OUTPUT_FILE_UPLOAD_PENDING      (5)
#define LATTICE_OUTPUT_FILE_UPLOAD_CANCELLED    (6)
#define LATTICE_OUTPUT_FILE_UPLOAD_ERROR        (7)

static int lattice_test_status = LATTICE_STATUS_IDLE;
static int lattice_test_tftp_ip_type = 0;
static char lattice_test_tftp_ip[NNN];
static int lattice_test_tftp_ip_len = 0;
static char lattice_test_tftp_path[NNN];
static int lattice_test_tftp_path_len = 0;
static int lattice_test_mode = LATTICE_MODE_AUTOUPLOAD;
static pthread_mutex_t lattice_test_mutex;
static pthread_t lattice_thread_id = 0;
static pthread_t lattice_upload_thread_id = 0;

void latticeTestTable_rebuildTableData(void);
void latticeTestOutputFileTable_rebuildTableData(void);

static int lattice_test_check(void);
static void lattice_test_cleanup(void);
static int lattice_set_test_status(int new_status);
static void *lattice_test_thread(void *arg);
static void *lattice_test_upload_thread(void *arg);

/** Initializes the latticeTestMib module */
void
init_latticeTestMib(void)
{
    int ret;
    const oid latticeTestControl_oid[] = { 1,3,6,1,4,1,4413,2,4,1,1,1200,1,1 };
    const oid latticeTestStatus_oid[] = { 1,3,6,1,4,1,4413,2,4,1,1,1200,1,2 };
    const oid latticeTestTftpServerIpAddrType_oid[] = { 1,3,6,1,4,1,4413,2,4,1,1,1200,1,3 };
    const oid latticeTestTftpServerIpAddr_oid[] = { 1,3,6,1,4,1,4413,2,4,1,1,1200,1,4 };
    const oid latticeTestTftpServerPath_oid[] = { 1,3,6,1,4,1,4413,2,4,1,1,1200,1,5 };
    const oid latticeTestFileUploadMode_oid[] = { 1,3,6,1,4,1,4413,2,4,1,1,1200,1,6 };
    const oid latticeTestResetToFactory_oid[] = { 1,3,6,1,4,1,4413,2,4,1,1,1200,1,9 };

    DEBUGMSGTL(("latticeTestMib", "Initializing\n"));

	if ((ret = pthread_mutex_init(&lattice_test_mutex, NULL))) {
		snmp_log(LOG_ERR, "init lattice_test_mutex failed\n");
		return;
	}

    netsnmp_register_scalar(
        netsnmp_create_handler_registration("latticeTestControl", handle_latticeTestControl,
                               latticeTestControl_oid, OID_LENGTH(latticeTestControl_oid),
                               HANDLER_CAN_RWRITE
        ));
    netsnmp_register_scalar(
        netsnmp_create_handler_registration("latticeTestStatus", handle_latticeTestStatus,
                               latticeTestStatus_oid, OID_LENGTH(latticeTestStatus_oid),
                               HANDLER_CAN_RONLY
        ));
    netsnmp_register_scalar(
        netsnmp_create_handler_registration("latticeTestTftpServerIpAddrType", handle_latticeTestTftpServerIpAddrType,
                               latticeTestTftpServerIpAddrType_oid, OID_LENGTH(latticeTestTftpServerIpAddrType_oid),
                               HANDLER_CAN_RWRITE
        ));
    netsnmp_register_scalar(
        netsnmp_create_handler_registration("latticeTestTftpServerIpAddr", handle_latticeTestTftpServerIpAddr,
                               latticeTestTftpServerIpAddr_oid, OID_LENGTH(latticeTestTftpServerIpAddr_oid),
                               HANDLER_CAN_RWRITE
        ));
    netsnmp_register_scalar(
        netsnmp_create_handler_registration("latticeTestTftpServerPath", handle_latticeTestTftpServerPath,
                               latticeTestTftpServerPath_oid, OID_LENGTH(latticeTestTftpServerPath_oid),
                               HANDLER_CAN_RWRITE
        ));
    netsnmp_register_scalar(
        netsnmp_create_handler_registration("latticeTestFileUploadMode", handle_latticeTestFileUploadMode,
                               latticeTestFileUploadMode_oid, OID_LENGTH(latticeTestFileUploadMode_oid),
                               HANDLER_CAN_RWRITE
        ));
    netsnmp_register_scalar(
        netsnmp_create_handler_registration("latticeTestResetToFactory", handle_latticeTestResetToFactory,
                               latticeTestResetToFactory_oid, OID_LENGTH(latticeTestResetToFactory_oid),
                               HANDLER_CAN_RWRITE
        ));
    /* here we initialize all the tables we're planning on supporting */
    initialize_table_latticeTestTable();
    initialize_table_latticeTestOutputFileTable();
}

int
handle_latticeTestControl(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info   *reqinfo,
                          netsnmp_request_info         *requests)
{
    int ret;
    int val = 0;
    char cmd[128];

    /* We are never called for a GETNEXT if it's registered as a
       "instance", as it's "magically" handled for us.  */

    /* a instance handler also only hands us one request at a time, so
       we don't need to loop over a list of requests; we'll only get one. */

    switch(reqinfo->mode) {

        case MODE_GET:
            val = 1; /* other(1) */
            snmp_set_var_typed_integer(requests->requestvb, ASN_INTEGER, val);
            break;

        /*
         * SET REQUEST
         *
         * multiple states in the transaction.  See:
         * http://www.net-snmp.org/tutorial-5/toolkit/mib_module/set-actions.jpg
         */
        case MODE_SET_RESERVE1:
                /* or you could use netsnmp_check_vb_type_and_size instead */
            ret = netsnmp_check_vb_int_range(requests->requestvb, 2, 4);
            if ( ret != SNMP_ERR_NOERROR ) {
                netsnmp_set_request_error(reqinfo, requests, ret );
            }
            break;

        case MODE_SET_RESERVE2:
            /* XXX malloc "undo" storage buffer */
            if (0) {
                netsnmp_set_request_error(reqinfo, requests, SNMP_ERR_RESOURCEUNAVAILABLE);
            }
            break;

        case MODE_SET_FREE:
            /* XXX: free resources allocated in RESERVE1 and/or
               RESERVE2.  Something failed somewhere, and the states
               below won't be called. */
            break;

        case MODE_SET_ACTION:
            val = *requests->requestvb->val.integer;
            switch(val)
            {
            case 2:
                if(lattice_test_status == LATTICE_STATUS_TESTING)
                {
                    netsnmp_set_request_error(reqinfo, requests, SNMP_ERR_INCONSISTENTVALUE);
                    return SNMP_ERR_GENERR;
                }
                /* Check script and tftp parameters */
                if(lattice_test_check())
                {
                    netsnmp_set_request_error(reqinfo, requests, SNMP_ERR_INCONSISTENTVALUE);
                    return SNMP_ERR_GENERR;
                }
                ret = pthread_create(&lattice_thread_id, NULL, &lattice_test_thread, NULL);
                if(ret)
                {
                    snmp_log(LOG_ERR, "pthread_create failed, return %d\n", ret);
                    netsnmp_set_request_error(reqinfo, requests, SNMP_ERR_GENERR);
                }
                break;
            case 3:
                if(lattice_test_status == LATTICE_STATUS_TESTING)
                {
                    pthread_cancel(lattice_thread_id);
                    ret = lattice_set_test_status(LATTICE_STATUS_COMPLETE);
                    if(ret)
                    {
                        snmp_log(LOG_ERR, "stopped test, but set lattice test status to (complete) failed\n");
                    }
                }
                break;
            case 4:
                if(lattice_test_status == LATTICE_STATUS_TESTING)
                {
                    netsnmp_set_request_error(reqinfo, requests, SNMP_ERR_INCONSISTENTVALUE);
                    return SNMP_ERR_GENERR;
                }
                lattice_test_cleanup();
                sprintf(cmd, "rm -r %s", LOCAL_TEST_PATH);
                system(cmd);
                ret = lattice_set_test_status(LATTICE_STATUS_IDLE);
                if(ret)
                {
                    snmp_log(LOG_ERR, "stopped test, but set lattice test status to (complete) failed\n");
                }
            }

            break;

        case MODE_SET_COMMIT:
            /* XXX: delete temporary storage */
            if (0) {
                /* try _really_really_ hard to never get to this point */
                netsnmp_set_request_error(reqinfo, requests, SNMP_ERR_COMMITFAILED);
            }
            break;

        case MODE_SET_UNDO:
            /* XXX: UNDO and return to previous value for the object */
            if (0) {
                /* try _really_really_ hard to never get to this point */
                netsnmp_set_request_error(reqinfo, requests, SNMP_ERR_UNDOFAILED);
            }
            break;

        default:
            /* we should never get here, so this is a really bad error */
            snmp_log(LOG_ERR, "unknown mode (%d) in handle_latticeTestControl\n", reqinfo->mode );
            return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}
int
handle_latticeTestStatus(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info   *reqinfo,
                          netsnmp_request_info         *requests)
{
    /* We are never called for a GETNEXT if it's registered as a
       "instance", as it's "magically" handled for us.  */

    /* a instance handler also only hands us one request at a time, so
       we don't need to loop over a list of requests; we'll only get one. */

    switch(reqinfo->mode) {

        case MODE_GET:
            snmp_set_var_typed_value(requests->requestvb, ASN_INTEGER,
                                     &lattice_test_status,
                                     sizeof(int));
            break;


        default:
            /* we should never get here, so this is a really bad error */
            snmp_log(LOG_ERR, "unknown mode (%d) in handle_latticeTestStatus\n", reqinfo->mode );
            return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}
int
handle_latticeTestTftpServerIpAddrType(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info   *reqinfo,
                          netsnmp_request_info         *requests)
{
    int ret;
    /* We are never called for a GETNEXT if it's registered as a
       "instance", as it's "magically" handled for us.  */

    /* a instance handler also only hands us one request at a time, so
       we don't need to loop over a list of requests; we'll only get one. */

    switch(reqinfo->mode) {

        case MODE_GET:
            snmp_set_var_typed_integer(requests->requestvb, ASN_INTEGER, lattice_test_tftp_ip_type);
            break;

        /*
         * SET REQUEST
         *
         * multiple states in the transaction.  See:
         * http://www.net-snmp.org/tutorial-5/toolkit/mib_module/set-actions.jpg
         */
        case MODE_SET_RESERVE1:
                /* or you could use netsnmp_check_vb_type_and_size instead */
            ret = netsnmp_check_vb_int_range(requests->requestvb, 0, 2);
            if ( ret != SNMP_ERR_NOERROR ) {
                netsnmp_set_request_error(reqinfo, requests, ret );
            }
            if(lattice_test_status == LATTICE_STATUS_TESTING) {
                netsnmp_set_request_error(reqinfo, requests, SNMP_ERR_INCONSISTENTVALUE );
            }

            break;

        case MODE_SET_RESERVE2:
            /* XXX malloc "undo" storage buffer */
            if (0) {
                netsnmp_set_request_error(reqinfo, requests, SNMP_ERR_RESOURCEUNAVAILABLE);
            }
            break;

        case MODE_SET_FREE:
            /* XXX: free resources allocated in RESERVE1 and/or
               RESERVE2.  Something failed somewhere, and the states
               below won't be called. */
            break;

        case MODE_SET_ACTION:
            lattice_test_tftp_ip_type = *requests->requestvb->val.integer;
            break;

        case MODE_SET_COMMIT:
            if (0) {
                /* try _really_really_ hard to never get to this point */
                netsnmp_set_request_error(reqinfo, requests, SNMP_ERR_COMMITFAILED);
            }
            break;

        case MODE_SET_UNDO:
            /* XXX: UNDO and return to previous value for the object */
            if (0) {
                /* try _really_really_ hard to never get to this point */
                netsnmp_set_request_error(reqinfo, requests, SNMP_ERR_UNDOFAILED);
            }
            break;

        default:
            /* we should never get here, so this is a really bad error */
            snmp_log(LOG_ERR, "unknown mode (%d) in handle_latticeTestTftpServerIpAddrType\n", reqinfo->mode );
            return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}
int
handle_latticeTestTftpServerIpAddr(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info   *reqinfo,
                          netsnmp_request_info         *requests)
{
    int ret;

    /* We are never called for a GETNEXT if it's registered as a
       "instance", as it's "magically" handled for us.  */

    /* a instance handler also only hands us one request at a time, so
       we don't need to loop over a list of requests; we'll only get one. */

    switch(reqinfo->mode) {

        case MODE_GET:
            snmp_set_var_typed_value(requests->requestvb, ASN_OCTET_STR,
                                     lattice_test_tftp_ip,
                                     lattice_test_tftp_ip_len);
            break;

        /*
         * SET REQUEST
         *
         * multiple states in the transaction.  See:
         * http://www.net-snmp.org/tutorial-5/toolkit/mib_module/set-actions.jpg
         */
        case MODE_SET_RESERVE1:
                /* or you could use netsnmp_check_vb_type_and_size instead */
            ret = netsnmp_check_vb_type(requests->requestvb, ASN_OCTET_STR);
            if ( ret != SNMP_ERR_NOERROR ) {
                netsnmp_set_request_error(reqinfo, requests, ret );
            }
            if(lattice_test_status == LATTICE_STATUS_TESTING) {
                netsnmp_set_request_error(reqinfo, requests, SNMP_ERR_INCONSISTENTVALUE );
            }
            if( (lattice_test_tftp_ip_type != SNMP_IPV4) && (lattice_test_tftp_ip_type != SNMP_IPV6) ) {
                netsnmp_set_request_error(reqinfo, requests, SNMP_ERR_INCONSISTENTVALUE );
            }
            break;

        case MODE_SET_RESERVE2:
            /* XXX malloc "undo" storage buffer */
            if (0) {
                netsnmp_set_request_error(reqinfo, requests, SNMP_ERR_RESOURCEUNAVAILABLE);
            }
            break;

        case MODE_SET_FREE:
            /* XXX: free resources allocated in RESERVE1 and/or
               RESERVE2.  Something failed somewhere, and the states
               below won't be called. */
            break;

        case MODE_SET_ACTION:
            if (lattice_test_tftp_ip_type == SNMP_IPV4)
            {
                if(requests->requestvb->val_len != 4)
                {
                    netsnmp_set_request_error(reqinfo, requests, SNMP_ERR_BADVALUE);
                    break;
                }
                memcpy(lattice_test_tftp_ip, requests->requestvb->val.string, requests->requestvb->val_len);
                lattice_test_tftp_ip_len = 4;
            }
            else if (lattice_test_tftp_ip_type == SNMP_IPV6)
            {
                if(requests->requestvb->val_len != 16)
                {
                    netsnmp_set_request_error(reqinfo, requests, SNMP_ERR_BADVALUE);
                    break;
                }
                memcpy(lattice_test_tftp_ip, requests->requestvb->val.string, requests->requestvb->val_len);
                lattice_test_tftp_ip_len = 16;
            }
            break;

        case MODE_SET_COMMIT:
            if (0) {
                /* try _really_really_ hard to never get to this point */
                netsnmp_set_request_error(reqinfo, requests, SNMP_ERR_COMMITFAILED);
            }
            break;

        case MODE_SET_UNDO:
            /* XXX: UNDO and return to previous value for the object */
            if (0) {
                /* try _really_really_ hard to never get to this point */
                netsnmp_set_request_error(reqinfo, requests, SNMP_ERR_UNDOFAILED);
            }
            break;

        default:
            /* we should never get here, so this is a really bad error */
            snmp_log(LOG_ERR, "unknown mode (%d) in handle_latticeTestTftpServerIpAddr\n", reqinfo->mode );
            return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}
int
handle_latticeTestTftpServerPath(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info   *reqinfo,
                          netsnmp_request_info         *requests)
{
    int ret;
    /* We are never called for a GETNEXT if it's registered as a
       "instance", as it's "magically" handled for us.  */

    /* a instance handler also only hands us one request at a time, so
       we don't need to loop over a list of requests; we'll only get one. */

    switch(reqinfo->mode) {

        case MODE_GET:
            snmp_set_var_typed_value(requests->requestvb, ASN_OCTET_STR,
                                     lattice_test_tftp_path,
                                     lattice_test_tftp_path_len);
            break;

        /*
         * SET REQUEST
         *
         * multiple states in the transaction.  See:
         * http://www.net-snmp.org/tutorial-5/toolkit/mib_module/set-actions.jpg
         */
        case MODE_SET_RESERVE1:
                /* or you could use netsnmp_check_vb_type_and_size instead */
            ret = netsnmp_check_vb_type(requests->requestvb, ASN_OCTET_STR);
            if ( ret != SNMP_ERR_NOERROR ) {
                netsnmp_set_request_error(reqinfo, requests, ret );
            }
            if(lattice_test_status == LATTICE_STATUS_TESTING) {
                netsnmp_set_request_error(reqinfo, requests, SNMP_ERR_INCONSISTENTVALUE );
            }
            break;

        case MODE_SET_RESERVE2:
            /* XXX malloc "undo" storage buffer */
            if (0) {
                netsnmp_set_request_error(reqinfo, requests, SNMP_ERR_RESOURCEUNAVAILABLE);
            }
            break;

        case MODE_SET_FREE:
            /* XXX: free resources allocated in RESERVE1 and/or
               RESERVE2.  Something failed somewhere, and the states
               below won't be called. */
            break;

        case MODE_SET_ACTION:
            memcpy(lattice_test_tftp_path, requests->requestvb->val.string, requests->requestvb->val_len);
            lattice_test_tftp_path_len = requests->requestvb->val_len;
            break;

        case MODE_SET_COMMIT:
            if (0) {
                /* try _really_really_ hard to never get to this point */
                netsnmp_set_request_error(reqinfo, requests, SNMP_ERR_COMMITFAILED);
            }
            break;

        case MODE_SET_UNDO:
            /* XXX: UNDO and return to previous value for the object */
            if (0) {
                /* try _really_really_ hard to never get to this point */
                netsnmp_set_request_error(reqinfo, requests, SNMP_ERR_UNDOFAILED);
            }
            break;

        default:
            /* we should never get here, so this is a really bad error */
            snmp_log(LOG_ERR, "unknown mode (%d) in handle_latticeTestTftpServerPath\n", reqinfo->mode );
            return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}
int
handle_latticeTestFileUploadMode(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info   *reqinfo,
                          netsnmp_request_info         *requests)
{
    int ret;
    /* We are never called for a GETNEXT if it's registered as a
       "instance", as it's "magically" handled for us.  */

    /* a instance handler also only hands us one request at a time, so
       we don't need to loop over a list of requests; we'll only get one. */

    switch(reqinfo->mode) {

        case MODE_GET:
            snmp_set_var_typed_value(requests->requestvb, ASN_INTEGER,
                                     &lattice_test_mode,
                                     sizeof(int));
            break;

        /*
         * SET REQUEST
         *
         * multiple states in the transaction.  See:
         * http://www.net-snmp.org/tutorial-5/toolkit/mib_module/set-actions.jpg
         */
        case MODE_SET_RESERVE1:
            ret = netsnmp_check_vb_int_range(requests->requestvb, 1, 2);
            if ( ret != SNMP_ERR_NOERROR ) {
                netsnmp_set_request_error(reqinfo, requests, ret );
            }
            if(lattice_test_status == LATTICE_STATUS_TESTING) {
                netsnmp_set_request_error(reqinfo, requests, SNMP_ERR_INCONSISTENTVALUE );
            }
            break;

        case MODE_SET_RESERVE2:
            if (0) {
                netsnmp_set_request_error(reqinfo, requests, SNMP_ERR_RESOURCEUNAVAILABLE);
            }
            break;

        case MODE_SET_FREE:
            /* XXX: free resources allocated in RESERVE1 and/or
               RESERVE2.  Something failed somewhere, and the states
               below won't be called. */
            break;

        case MODE_SET_ACTION:
            lattice_test_mode = *requests->requestvb->val.integer;
            break;

        case MODE_SET_COMMIT:
            if (0) {
                /* try _really_really_ hard to never get to this point */
                netsnmp_set_request_error(reqinfo, requests, SNMP_ERR_COMMITFAILED);
            }
            break;

        case MODE_SET_UNDO:
            /* XXX: UNDO and return to previous value for the object */
            if (0) {
                /* try _really_really_ hard to never get to this point */
                netsnmp_set_request_error(reqinfo, requests, SNMP_ERR_UNDOFAILED);
            }
            break;

        default:
            /* we should never get here, so this is a really bad error */
            snmp_log(LOG_ERR, "unknown mode (%d) in handle_latticeTestFileUploadMode\n", reqinfo->mode );
            return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}
int
handle_latticeTestResetToFactory(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info   *reqinfo,
                          netsnmp_request_info         *requests)
{
    int ret;
    /* We are never called for a GETNEXT if it's registered as a
       "instance", as it's "magically" handled for us.  */

    /* a instance handler also only hands us one request at a time, so
       we don't need to loop over a list of requests; we'll only get one. */

    switch(reqinfo->mode) {

        case MODE_GET:
            snmp_set_var_typed_integer(requests->requestvb, ASN_INTEGER, SNMP_FALSE);
            break;

        /*
         * SET REQUEST
         *
         * multiple states in the transaction.  See:
         * http://www.net-snmp.org/tutorial-5/toolkit/mib_module/set-actions.jpg
         */
        case MODE_SET_RESERVE1:
                /* or you could use netsnmp_check_vb_type_and_size instead */
            ret = netsnmp_check_vb_truthvalue(requests->requestvb);
            if ( ret != SNMP_ERR_NOERROR ) {
                netsnmp_set_request_error(reqinfo, requests, ret );
            }
            break;

        case MODE_SET_RESERVE2:
            /* XXX malloc "undo" storage buffer */
            if (0) {
                netsnmp_set_request_error(reqinfo, requests, SNMP_ERR_RESOURCEUNAVAILABLE);
            }
            break;

        case MODE_SET_FREE:
            /* XXX: free resources allocated in RESERVE1 and/or
               RESERVE2.  Something failed somewhere, and the states
               below won't be called. */
            break;

        case MODE_SET_ACTION:
            if(*requests->requestvb->val.integer == SNMP_TRUE)
            {
                system("rm -f /data/nvram");
            }
            break;

        case MODE_SET_COMMIT:
            if (0) {
                /* try _really_really_ hard to never get to this point */
                netsnmp_set_request_error(reqinfo, requests, SNMP_ERR_COMMITFAILED);
            }
            break;

        case MODE_SET_UNDO:
            if (0) {
                /* try _really_really_ hard to never get to this point */
                netsnmp_set_request_error(reqinfo, requests, SNMP_ERR_UNDOFAILED);
            }
            break;

        default:
            /* we should never get here, so this is a really bad error */
            snmp_log(LOG_ERR, "unknown mode (%d) in handle_latticeTestResetToFactory\n", reqinfo->mode );
            return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}


/** Initialize the latticeTestTable table by defining its contents and how it's structured */
void
initialize_table_latticeTestTable(void)
{
    const oid latticeTestTable_oid[] = {1,3,6,1,4,1,4413,2,4,1,1,1200,1,7};
    const size_t latticeTestTable_oid_len   = OID_LENGTH(latticeTestTable_oid);
    netsnmp_handler_registration    *reg;
    netsnmp_iterator_info           *iinfo;
    netsnmp_table_registration_info *table_info;

    DEBUGMSGTL(("latticeTestMib:init", "initializing table latticeTestTable\n"));

    reg = netsnmp_create_handler_registration(
              "latticeTestTable",     latticeTestTable_handler,
              latticeTestTable_oid, latticeTestTable_oid_len,
              HANDLER_CAN_RWRITE
              );

    table_info = SNMP_MALLOC_TYPEDEF( netsnmp_table_registration_info );
    netsnmp_table_helper_add_indexes(table_info,
                           ASN_INTEGER,  /* index: latticeTestScriptIndex */
                           0);
    table_info->min_column = COLUMN_LATTICETESTSCRIPTFILE;
    table_info->max_column = COLUMN_LATTICETESTDURATION;

    iinfo = SNMP_MALLOC_TYPEDEF( netsnmp_iterator_info );
    iinfo->get_first_data_point = latticeTestTable_get_first_data_point;
    iinfo->get_next_data_point  = latticeTestTable_get_next_data_point;
    iinfo->table_reginfo        = table_info;

    netsnmp_register_table_iterator( reg, iinfo );

    latticeTestTable_rebuildTableData();
    /* Initialise the contents of the table here */
}

    /* Typical data structure for a row entry */
struct latticeTestTable_entry {
    /* Index values */
    long latticeTestScriptIndex;

    /* Column values */
    char latticeTestScriptFile[NNN];
    size_t latticeTestScriptFile_len;
    char old_latticeTestScriptFile[NNN];
    size_t old_latticeTestScriptFile_len;
    char latticeTestInputParameters[NNN];
    size_t latticeTestInputParameters_len;
    char old_latticeTestInputParameters[NNN];
    size_t old_latticeTestInputParameters_len;
    char latticeTestResultFileName[NNN];
    size_t latticeTestResultFileName_len;
    char old_latticeTestResultFileName[NNN];
    size_t old_latticeTestResultFileName_len;
    char latticeTestLogFileName[NNN];
    size_t latticeTestLogFileName_len;
    char old_latticeTestLogFileName[NNN];
    size_t old_latticeTestLogFileName_len;
    long latticeTestScriptStatus;
    u_long latticeTestDuration;

    /* Illustrate using a simple linked list */
    int   valid;
    struct latticeTestTable_entry *next;
};

struct latticeTestTable_entry  *latticeTestTable_head;

/* create a new row in the (unsorted) table */
struct latticeTestTable_entry *
latticeTestTable_createEntry(
                 long  latticeTestScriptIndex
                ) {
    struct latticeTestTable_entry *entry;

    entry = SNMP_MALLOC_TYPEDEF(struct latticeTestTable_entry);
    if (!entry)
        return NULL;

    entry->latticeTestScriptIndex = latticeTestScriptIndex;
    entry->latticeTestScriptStatus = 1;
    entry->next = latticeTestTable_head;
    latticeTestTable_head = entry;
    return entry;
}

/* remove a row from the table */
void
latticeTestTable_removeEntry( struct latticeTestTable_entry *entry ) {
    struct latticeTestTable_entry *ptr, *prev;

    if (!entry)
        return;    /* Nothing to remove */

    for ( ptr  = latticeTestTable_head, prev = NULL;
          ptr != NULL;
          prev = ptr, ptr = ptr->next ) {
        if ( ptr == entry )
            break;
    }
    if ( !ptr )
        return;    /* Can't find it */

    if ( prev == NULL )
        latticeTestTable_head = ptr->next;
    else
        prev->next = ptr->next;

    SNMP_FREE( entry );   /* XXX - release any other internal resources */
}


/** Rebuild the latticeTestTable table by defining its contents and how it's structured */

void
latticeTestTable_rebuildTableData(void)
{
    struct latticeTestTable_entry *entry;
    int i;

    /*Clear the table  */
    while((entry = latticeTestTable_head))
    {
        latticeTestTable_removeEntry(entry);
    }

    for(i = MAX_LATTICE_TEST_ENTRIES; i > 0; i--)
    {
        entry = latticeTestTable_createEntry(i);
    }
    return;
}

/* Example iterator hook routines - using 'get_next' to do most of the work */
netsnmp_variable_list *
latticeTestTable_get_first_data_point(void **my_loop_context,
                          void **my_data_context,
                          netsnmp_variable_list *put_index_data,
                          netsnmp_iterator_info *mydata)
{
    *my_loop_context = latticeTestTable_head;
    return latticeTestTable_get_next_data_point(my_loop_context, my_data_context,
                                    put_index_data,  mydata );
}

netsnmp_variable_list *
latticeTestTable_get_next_data_point(void **my_loop_context,
                          void **my_data_context,
                          netsnmp_variable_list *put_index_data,
                          netsnmp_iterator_info *mydata)
{
    struct latticeTestTable_entry *entry = (struct latticeTestTable_entry *)*my_loop_context;
    netsnmp_variable_list *idx = put_index_data;

    if ( entry ) {
        snmp_set_var_typed_integer( idx, ASN_INTEGER, entry->latticeTestScriptIndex );
        idx = idx->next_variable;
        *my_data_context = (void *)entry;
        *my_loop_context = (void *)entry->next;
        return put_index_data;
    } else {
        return NULL;
    }
}


/** handles requests for the latticeTestTable table */
int
latticeTestTable_handler(
    netsnmp_mib_handler               *handler,
    netsnmp_handler_registration      *reginfo,
    netsnmp_agent_request_info        *reqinfo,
    netsnmp_request_info              *requests) {
    int ret;

    netsnmp_request_info       *request;
    netsnmp_table_request_info *table_info;
    struct latticeTestTable_entry          *table_entry;

    DEBUGMSGTL(("latticeTestMib:handler", "Processing request (%d)\n", reqinfo->mode));

    switch (reqinfo->mode) {
        /*
         * Read-support (also covers GetNext requests)
         */
    case MODE_GET:
        for (request=requests; request; request=request->next) {
            table_entry = (struct latticeTestTable_entry *)
                              netsnmp_extract_iterator_context(request);
            table_info  =     netsnmp_extract_table_info(      request);

            switch (table_info->colnum) {
            case COLUMN_LATTICETESTSCRIPTFILE:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_value( request->requestvb, ASN_OCTET_STR,
                                          table_entry->latticeTestScriptFile,
                                          table_entry->latticeTestScriptFile_len);
                break;
            case COLUMN_LATTICETESTINPUTPARAMETERS:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_value( request->requestvb, ASN_OCTET_STR,
                                          table_entry->latticeTestInputParameters,
                                          table_entry->latticeTestInputParameters_len);
                break;
            case COLUMN_LATTICETESTRESULTFILENAME:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_value( request->requestvb, ASN_OCTET_STR,
                                          table_entry->latticeTestResultFileName,
                                          table_entry->latticeTestResultFileName_len);
                break;
            case COLUMN_LATTICETESTLOGFILENAME:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_value( request->requestvb, ASN_OCTET_STR,
                                          table_entry->latticeTestLogFileName,
                                          table_entry->latticeTestLogFileName_len);
                break;
            case COLUMN_LATTICETESTSCRIPTSTATUS:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_INTEGER,
                                            table_entry->latticeTestScriptStatus);
                break;
            case COLUMN_LATTICETESTDURATION:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_UNSIGNED,
                                            table_entry->latticeTestDuration);
                break;
            default:
                netsnmp_set_request_error(reqinfo, request,
                                          SNMP_NOSUCHOBJECT);
                break;
            }
        }
        break;

        /*
         * Write-support
         */
    case MODE_SET_RESERVE1:
        for (request=requests; request; request=request->next) {
            table_entry = (struct latticeTestTable_entry *)
                              netsnmp_extract_iterator_context(request);
            table_info  =     netsnmp_extract_table_info(      request);

            switch (table_info->colnum) {
            case COLUMN_LATTICETESTSCRIPTFILE:
            /* or possibly 'netsnmp_check_vb_type_and_size' */
                ret = netsnmp_check_vb_type_and_max_size(
                          request->requestvb, ASN_OCTET_STR, sizeof(table_entry->latticeTestScriptFile));
                if ( ret != SNMP_ERR_NOERROR ) {
                    netsnmp_set_request_error( reqinfo, request, ret );
                    return SNMP_ERR_NOERROR;
                }
                break;
            case COLUMN_LATTICETESTINPUTPARAMETERS:
            /* or possibly 'netsnmp_check_vb_type_and_size' */
                ret = netsnmp_check_vb_type_and_max_size(
                          request->requestvb, ASN_OCTET_STR, sizeof(table_entry->latticeTestInputParameters));
                if ( ret != SNMP_ERR_NOERROR ) {
                    netsnmp_set_request_error( reqinfo, request, ret );
                    return SNMP_ERR_NOERROR;
                }
                break;
            case COLUMN_LATTICETESTRESULTFILENAME:
            /* or possibly 'netsnmp_check_vb_type_and_size' */
                ret = netsnmp_check_vb_type_and_max_size(
                          request->requestvb, ASN_OCTET_STR, sizeof(table_entry->latticeTestResultFileName));
                if ( ret != SNMP_ERR_NOERROR ) {
                    netsnmp_set_request_error( reqinfo, request, ret );
                    return SNMP_ERR_NOERROR;
                }
                break;
            case COLUMN_LATTICETESTLOGFILENAME:
            /* or possibly 'netsnmp_check_vb_type_and_size' */
                ret = netsnmp_check_vb_type_and_max_size(
                          request->requestvb, ASN_OCTET_STR, sizeof(table_entry->latticeTestLogFileName));
                if ( ret != SNMP_ERR_NOERROR ) {
                    netsnmp_set_request_error( reqinfo, request, ret );
                    return SNMP_ERR_NOERROR;
                }
                break;
            default:
                netsnmp_set_request_error( reqinfo, request,
                                           SNMP_ERR_NOTWRITABLE );
                return SNMP_ERR_NOERROR;
            }
        }
        if(lattice_test_status == LATTICE_STATUS_TESTING) {
            netsnmp_set_request_error(reqinfo, requests, SNMP_ERR_INCONSISTENTVALUE );
        }
        break;

    case MODE_SET_RESERVE2:
        break;

    case MODE_SET_FREE:
        break;

    case MODE_SET_ACTION:
        for (request=requests; request; request=request->next) {
            table_entry = (struct latticeTestTable_entry *)
                              netsnmp_extract_iterator_context(request);
            table_info  =     netsnmp_extract_table_info(      request);

            switch (table_info->colnum) {
            case COLUMN_LATTICETESTSCRIPTFILE:
                memcpy( table_entry->old_latticeTestScriptFile,
                        table_entry->latticeTestScriptFile,
                        sizeof(table_entry->latticeTestScriptFile));
                table_entry->old_latticeTestScriptFile_len =
                        table_entry->latticeTestScriptFile_len;
                memset( table_entry->latticeTestScriptFile, 0,
                        sizeof(table_entry->latticeTestScriptFile));
                memcpy( table_entry->latticeTestScriptFile,
                        request->requestvb->val.string,
                        request->requestvb->val_len);
                table_entry->latticeTestScriptFile_len =
                        request->requestvb->val_len;
                break;
            case COLUMN_LATTICETESTINPUTPARAMETERS:
                memcpy( table_entry->old_latticeTestInputParameters,
                        table_entry->latticeTestInputParameters,
                        sizeof(table_entry->latticeTestInputParameters));
                table_entry->old_latticeTestInputParameters_len =
                        table_entry->latticeTestInputParameters_len;
                memset( table_entry->latticeTestInputParameters, 0,
                        sizeof(table_entry->latticeTestInputParameters));
                memcpy( table_entry->latticeTestInputParameters,
                        request->requestvb->val.string,
                        request->requestvb->val_len);
                table_entry->latticeTestInputParameters_len =
                        request->requestvb->val_len;
                break;
            case COLUMN_LATTICETESTRESULTFILENAME:
                memcpy( table_entry->old_latticeTestResultFileName,
                        table_entry->latticeTestResultFileName,
                        sizeof(table_entry->latticeTestResultFileName));
                table_entry->old_latticeTestResultFileName_len =
                        table_entry->latticeTestResultFileName_len;
                memset( table_entry->latticeTestResultFileName, 0,
                        sizeof(table_entry->latticeTestResultFileName));
                memcpy( table_entry->latticeTestResultFileName,
                        request->requestvb->val.string,
                        request->requestvb->val_len);
                table_entry->latticeTestResultFileName_len =
                        request->requestvb->val_len;
                break;
            case COLUMN_LATTICETESTLOGFILENAME:
                memcpy( table_entry->old_latticeTestLogFileName,
                        table_entry->latticeTestLogFileName,
                        sizeof(table_entry->latticeTestLogFileName));
                table_entry->old_latticeTestLogFileName_len =
                        table_entry->latticeTestLogFileName_len;
                memset( table_entry->latticeTestLogFileName, 0,
                        sizeof(table_entry->latticeTestLogFileName));
                memcpy( table_entry->latticeTestLogFileName,
                        request->requestvb->val.string,
                        request->requestvb->val_len);
                table_entry->latticeTestLogFileName_len =
                        request->requestvb->val_len;
                break;
            }
        }
        break;

    case MODE_SET_UNDO:
        for (request=requests; request; request=request->next) {
            table_entry = (struct latticeTestTable_entry *)
                              netsnmp_extract_iterator_context(request);
            table_info  =     netsnmp_extract_table_info(      request);

            switch (table_info->colnum) {
            case COLUMN_LATTICETESTSCRIPTFILE:
                memcpy( table_entry->latticeTestScriptFile,
                        table_entry->old_latticeTestScriptFile,
                        sizeof(table_entry->latticeTestScriptFile));
                memset( table_entry->old_latticeTestScriptFile, 0,
                        sizeof(table_entry->latticeTestScriptFile));
                table_entry->latticeTestScriptFile_len =
                        table_entry->old_latticeTestScriptFile_len;
                break;
            case COLUMN_LATTICETESTINPUTPARAMETERS:
                memcpy( table_entry->latticeTestInputParameters,
                        table_entry->old_latticeTestInputParameters,
                        sizeof(table_entry->latticeTestInputParameters));
                memset( table_entry->old_latticeTestInputParameters, 0,
                        sizeof(table_entry->latticeTestInputParameters));
                table_entry->latticeTestInputParameters_len =
                        table_entry->old_latticeTestInputParameters_len;
                break;
            case COLUMN_LATTICETESTRESULTFILENAME:
                memcpy( table_entry->latticeTestResultFileName,
                        table_entry->old_latticeTestResultFileName,
                        sizeof(table_entry->latticeTestResultFileName));
                memset( table_entry->old_latticeTestResultFileName, 0,
                        sizeof(table_entry->latticeTestResultFileName));
                table_entry->latticeTestResultFileName_len =
                        table_entry->old_latticeTestResultFileName_len;
                break;
            case COLUMN_LATTICETESTLOGFILENAME:
                memcpy( table_entry->latticeTestLogFileName,
                        table_entry->old_latticeTestLogFileName,
                        sizeof(table_entry->latticeTestLogFileName));
                memset( table_entry->old_latticeTestLogFileName, 0,
                        sizeof(table_entry->latticeTestLogFileName));
                table_entry->latticeTestLogFileName_len =
                        table_entry->old_latticeTestLogFileName_len;
                break;
            }
        }
        break;

    case MODE_SET_COMMIT:
        break;
    }
    return SNMP_ERR_NOERROR;
}

/** Initialize the latticeTestOutputFileTable table by defining its contents and how it's structured */
void
initialize_table_latticeTestOutputFileTable(void)
{
    const oid latticeTestOutputFileTable_oid[] = {1,3,6,1,4,1,4413,2,4,1,1,1200,1,8};
    const size_t latticeTestOutputFileTable_oid_len   = OID_LENGTH(latticeTestOutputFileTable_oid);
    netsnmp_handler_registration    *reg;
    netsnmp_iterator_info           *iinfo;
    netsnmp_table_registration_info *table_info;

    DEBUGMSGTL(("latticeTestMib:init", "initializing table latticeTestOutputFileTable\n"));

    reg = netsnmp_create_handler_registration(
              "latticeTestOutputFileTable",     latticeTestOutputFileTable_handler,
              latticeTestOutputFileTable_oid, latticeTestOutputFileTable_oid_len,
              HANDLER_CAN_RWRITE
              );

    table_info = SNMP_MALLOC_TYPEDEF( netsnmp_table_registration_info );
    netsnmp_table_helper_add_indexes(table_info,
                           ASN_INTEGER,  /* index: latticeTestOutputFileIndex */
                           0);
    table_info->min_column = COLUMN_LATTICETESTOUTPUTFILE;
    table_info->max_column = COLUMN_LATTICETESTOUTPUTFILEUPLOADSTATUS;

    iinfo = SNMP_MALLOC_TYPEDEF( netsnmp_iterator_info );
    iinfo->get_first_data_point = latticeTestOutputFileTable_get_first_data_point;
    iinfo->get_next_data_point  = latticeTestOutputFileTable_get_next_data_point;
    iinfo->table_reginfo        = table_info;

    netsnmp_register_table_iterator( reg, iinfo );

    latticeTestOutputFileTable_rebuildTableData();
    /* Initialise the contents of the table here */
}

    /* Typical data structure for a row entry */
struct latticeTestOutputFileTable_entry {
    /* Index values */
    long latticeTestOutputFileIndex;

    /* Column values */
    char latticeTestOutputFile[NNN];
    size_t latticeTestOutputFile_len;
    long latticeTestOutputFileControl;
    long old_latticeTestOutputFileControl;
    long latticeTestOutputFileUploadStatus;

    /* Illustrate using a simple linked list */
    int   valid;
    struct latticeTestOutputFileTable_entry *next;
};

struct latticeTestOutputFileTable_entry  *latticeTestOutputFileTable_head;
static long latticeTestOutputFileTable_lastIndex = 0;

/* create a new row in the (unsorted) table */
struct latticeTestOutputFileTable_entry *
latticeTestOutputFileTable_createEntry(
                 long  latticeTestOutputFileIndex
                ) {
    struct latticeTestOutputFileTable_entry *entry;

    entry = SNMP_MALLOC_TYPEDEF(struct latticeTestOutputFileTable_entry);
    if (!entry)
        return NULL;

    entry->latticeTestOutputFileIndex = latticeTestOutputFileIndex;
    entry->next = latticeTestOutputFileTable_head;
    latticeTestOutputFileTable_head = entry;
    return entry;
}

/* remove a row from the table */
void
latticeTestOutputFileTable_removeEntry( struct latticeTestOutputFileTable_entry *entry ) {
    struct latticeTestOutputFileTable_entry *ptr, *prev;

    if (!entry)
        return;    /* Nothing to remove */

    for ( ptr  = latticeTestOutputFileTable_head, prev = NULL;
          ptr != NULL;
          prev = ptr, ptr = ptr->next ) {
        if ( ptr == entry )
            break;
    }
    if ( !ptr )
        return;    /* Can't find it */

    if ( prev == NULL )
        latticeTestOutputFileTable_head = ptr->next;
    else
        prev->next = ptr->next;

    SNMP_FREE( entry );   /* XXX - release any other internal resources */
}


/** Rebuild the latticeTestOutputFileTable table by defining its contents and how it's structured */

void
latticeTestOutputFileTable_rebuildTableData(void)
{
    struct latticeTestOutputFileTable_entry *entry;
    /*Clear the table  */
    while((entry = latticeTestOutputFileTable_head))
    {
        latticeTestOutputFileTable_removeEntry(entry);
    }
    latticeTestOutputFileTable_lastIndex = 0;
    return;
}

/* Example iterator hook routines - using 'get_next' to do most of the work */
netsnmp_variable_list *
latticeTestOutputFileTable_get_first_data_point(void **my_loop_context,
                          void **my_data_context,
                          netsnmp_variable_list *put_index_data,
                          netsnmp_iterator_info *mydata)
{
    *my_loop_context = latticeTestOutputFileTable_head;
    return latticeTestOutputFileTable_get_next_data_point(my_loop_context, my_data_context,
                                    put_index_data,  mydata );
}

netsnmp_variable_list *
latticeTestOutputFileTable_get_next_data_point(void **my_loop_context,
                          void **my_data_context,
                          netsnmp_variable_list *put_index_data,
                          netsnmp_iterator_info *mydata)
{
    struct latticeTestOutputFileTable_entry *entry = (struct latticeTestOutputFileTable_entry *)*my_loop_context;
    netsnmp_variable_list *idx = put_index_data;

    if ( entry ) {
        snmp_set_var_typed_integer( idx, ASN_INTEGER, entry->latticeTestOutputFileIndex );
        idx = idx->next_variable;
        *my_data_context = (void *)entry;
        *my_loop_context = (void *)entry->next;
        return put_index_data;
    } else {
        return NULL;
    }
}


/** handles requests for the latticeTestOutputFileTable table */
int
latticeTestOutputFileTable_handler(
    netsnmp_mib_handler               *handler,
    netsnmp_handler_registration      *reginfo,
    netsnmp_agent_request_info        *reqinfo,
    netsnmp_request_info              *requests) {
    int ret;

    netsnmp_request_info       *request;
    netsnmp_table_request_info *table_info;
    struct latticeTestOutputFileTable_entry          *table_entry;

    DEBUGMSGTL(("latticeTestMib:handler", "Processing request (%d)\n", reqinfo->mode));

    switch (reqinfo->mode) {
        /*
         * Read-support (also covers GetNext requests)
         */
    case MODE_GET:
        for (request=requests; request; request=request->next) {
            table_entry = (struct latticeTestOutputFileTable_entry *)
                              netsnmp_extract_iterator_context(request);
            table_info  =     netsnmp_extract_table_info(      request);

            switch (table_info->colnum) {
            case COLUMN_LATTICETESTOUTPUTFILE:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_value( request->requestvb, ASN_OCTET_STR,
                                          table_entry->latticeTestOutputFile,
                                          table_entry->latticeTestOutputFile_len);
                break;
            case COLUMN_LATTICETESTOUTPUTFILECONTROL:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_INTEGER,
                                            table_entry->latticeTestOutputFileControl);
                break;
            case COLUMN_LATTICETESTOUTPUTFILEUPLOADSTATUS:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_INTEGER,
                                            table_entry->latticeTestOutputFileUploadStatus);
                break;
            default:
                netsnmp_set_request_error(reqinfo, request,
                                          SNMP_NOSUCHOBJECT);
                break;
            }
        }
        break;

        /*
         * Write-support
         */
    case MODE_SET_RESERVE1:
        for (request=requests; request; request=request->next) {
            table_entry = (struct latticeTestOutputFileTable_entry *)
                              netsnmp_extract_iterator_context(request);
            table_info  =     netsnmp_extract_table_info(      request);

            if(table_entry == NULL)
            {
                netsnmp_set_request_error( reqinfo, request, SNMP_ERR_RESOURCEUNAVAILABLE );
                return SNMP_ERR_NOERROR;
            }
            switch (table_info->colnum) {
            case COLUMN_LATTICETESTOUTPUTFILECONTROL:
                /* or possibly 'netsnmp_check_vb_int_range' */
                ret = netsnmp_check_vb_int_range( request->requestvb, LATTICE_OUTPUT_FILE_CONTROL_UPLOAD, LATTICE_OUTPUT_FILE_CONTROL_CANCEL_UPLOAD );
                if ( ret != SNMP_ERR_NOERROR ) {
                    netsnmp_set_request_error( reqinfo, request, ret );
                    return SNMP_ERR_NOERROR;
                }
                if(lattice_test_status == LATTICE_STATUS_TESTING) {
                    netsnmp_set_request_error(reqinfo, request, SNMP_ERR_INCONSISTENTVALUE );
                }


                break;
            default:
                netsnmp_set_request_error( reqinfo, request,
                                           SNMP_ERR_NOTWRITABLE );
                return SNMP_ERR_NOERROR;
            }
        }
        break;

    case MODE_SET_RESERVE2:
        break;

    case MODE_SET_FREE:
        break;

    case MODE_SET_ACTION:
        for (request=requests; request; request=request->next) {
            table_entry = (struct latticeTestOutputFileTable_entry *)
                              netsnmp_extract_iterator_context(request);
            table_info  =     netsnmp_extract_table_info(      request);

            switch (table_info->colnum) {
            case COLUMN_LATTICETESTOUTPUTFILECONTROL:
                table_entry->old_latticeTestOutputFileControl = table_entry->latticeTestOutputFileControl;
                table_entry->latticeTestOutputFileControl     = *request->requestvb->val.integer;
                if(table_entry->latticeTestOutputFileControl == LATTICE_OUTPUT_FILE_CONTROL_UPLOAD) {
                    /* Check if upload status */
                    if(table_entry->latticeTestOutputFileUploadStatus == LATTICE_OUTPUT_FILE_UPLOAD_INPROGRESS) {
                        netsnmp_set_request_error( reqinfo, request, SNMP_ERR_INCONSISTENTVALUE );
                        break;
                    }
                    if(table_entry->latticeTestOutputFileUploadStatus == LATTICE_OUTPUT_FILE_OTHER) {
                        netsnmp_set_request_error( reqinfo, request, SNMP_ERR_INCONSISTENTVALUE );
                        break;
                    }
                    ret = pthread_create(&lattice_upload_thread_id, NULL, &lattice_test_upload_thread, table_entry);
                    if(ret)
                    {
                        snmp_log(LOG_ERR, "pthread_create failed, return %d\n", ret);
                        netsnmp_set_request_error(reqinfo, request, SNMP_ERR_GENERR);
                    }
                }
                else if(table_entry->latticeTestOutputFileControl == LATTICE_OUTPUT_FILE_CONTROL_CANCEL_UPLOAD) {
                    /* Check if upload status is uploadInProgress */
                    if(table_entry->latticeTestOutputFileUploadStatus != LATTICE_OUTPUT_FILE_UPLOAD_INPROGRESS) {
                        netsnmp_set_request_error( reqinfo, request, SNMP_ERR_INCONSISTENTVALUE );
                        break;
                    }
                    pthread_cancel(lattice_upload_thread_id);
                    pthread_mutex_lock(&lattice_test_mutex);
                    table_entry->latticeTestOutputFileUploadStatus = LATTICE_OUTPUT_FILE_UPLOAD_CANCELLED;
                    pthread_mutex_unlock(&lattice_test_mutex);
                }

                break;
            }
        }
        break;

    case MODE_SET_UNDO:
        for (request=requests; request; request=request->next) {
            table_entry = (struct latticeTestOutputFileTable_entry *)
                              netsnmp_extract_iterator_context(request);
            table_info  =     netsnmp_extract_table_info(      request);

            switch (table_info->colnum) {
            case COLUMN_LATTICETESTOUTPUTFILECONTROL:
                table_entry->latticeTestOutputFileControl     = table_entry->old_latticeTestOutputFileControl;
                table_entry->old_latticeTestOutputFileControl = 0;
                break;
            }
        }
        break;

    case MODE_SET_COMMIT:
        break;
    }
    return SNMP_ERR_NOERROR;
}

static void lattice_test_cleanup(void)
{
    pthread_mutex_lock(&lattice_test_mutex);
    lattice_test_status = LATTICE_STATUS_IDLE;

    lattice_test_tftp_ip_type = 0;
    memset(lattice_test_tftp_ip, 0, NNN);
    lattice_test_tftp_ip_len = 0;

    memset(lattice_test_tftp_path, 0, NNN);
    lattice_test_tftp_path_len = 0;
    lattice_test_mode = LATTICE_MODE_AUTOUPLOAD;
    latticeTestTable_rebuildTableData();
    latticeTestOutputFileTable_rebuildTableData();
    pthread_mutex_unlock(&lattice_test_mutex);
}

static int lattice_set_test_status(int new_status)
{
    int ret;
    ret = pthread_mutex_lock(&lattice_test_mutex);
    if(ret){
        return ret;
    }
    lattice_test_status = new_status;
	pthread_mutex_unlock(&lattice_test_mutex);
	return 0;
}

/**
 * Check if all parameters are reday to test
 * @return: 0 - all ready; other - not ready
*/
static int lattice_test_check(void)
{
    if(lattice_test_tftp_ip_type != SNMP_IPV4
        && lattice_test_tftp_ip_type != SNMP_IPV6)
        return 1;

    if(lattice_test_tftp_ip_len == 0)
        return 1;

    return 0;
}

static int lattice_test_generate_output_file_name(char *output_file_name, char *script_file_name, char *type_str)
{
    char *p;
    char buf[128];
    int len;

    if(output_file_name == NULL)
        return 0;
    if(script_file_name == NULL)
        return 0;

    p = strstr(script_file_name, ".");
    if(p == NULL)
        return 0;

    memset(buf, 0, sizeof(buf));
    strncpy(buf, script_file_name, p - script_file_name);
    len = sprintf(output_file_name, "%s_%s.txt", buf, type_str);

    return len;
}

static void *lattice_test_thread(void *arg)
{
    struct latticeTestTable_entry *entry;
    int ret;
    char tftp_file[520];
    char tftp_ip[256];
    char tftp_path[256];
    char cmd[1088];
    struct latticeTestOutputFileTable_entry *output_entry;
    struct timeval tv_start, tv_end;

    /* set the test status to testing */
    ret = lattice_set_test_status(LATTICE_STATUS_TESTING);
    if(ret)
    {
        snmp_log(LOG_ERR, "set lattice test status to (testing) failed\n");
        pthread_exit(NULL);
    }

    /* get tftp ip */
    if(lattice_test_tftp_ip_type == SNMP_IPV4)
        inet_ntop(AF_INET, lattice_test_tftp_ip, tftp_ip, 256);
    else if(lattice_test_tftp_ip_type == SNMP_IPV6)
        inet_ntop(AF_INET6, lattice_test_tftp_ip, tftp_ip, 256);

    if(lattice_test_tftp_path_len != 0)
    {
        strncpy(tftp_path, lattice_test_tftp_path, lattice_test_tftp_path_len);
        if(tftp_path[lattice_test_tftp_path_len - 1] == '/')
           tftp_path[lattice_test_tftp_path_len - 1] = '\0';
    }
    sprintf(cmd, "mkdir -p %s", LOCAL_TEST_PATH);
    system(cmd);
    sprintf(cmd, "cp -f %s %s/", LOCAL_USERIO_LIB, LOCAL_TEST_PATH);
    system(cmd);
    ret = chdir(LOCAL_TEST_PATH);
    if(ret)
    {
        snmp_log(LOG_ERR, "chdir to %s failed, return %d\n", LOCAL_TEST_PATH, ret);
        pthread_exit(NULL);
    }

#ifdef BUILD_OPENWRT
    /* Add iptables rules to bypass the firewall */
    snprintf(cmd, sizeof(cmd), "iptables -I zone_wan_input -p udp --src %s -j ACCEPT", tftp_ip);
    system(cmd);
    snprintf(cmd, sizeof(cmd), "iptables -I zone_wan_input -p udp --dst %s -j ACCEPT", tftp_ip);
    system(cmd);
#endif

    entry = latticeTestTable_head;
    while(entry)
    {
        if(entry->latticeTestScriptFile_len)
        {
            if(entry->latticeTestResultFileName_len == 0)
            {
                entry->latticeTestResultFileName_len = lattice_test_generate_output_file_name(entry->latticeTestResultFileName, entry->latticeTestScriptFile, "result");
            }
            if(entry->latticeTestLogFileName_len == 0)
            {
                entry->latticeTestLogFileName_len = lattice_test_generate_output_file_name(entry->latticeTestLogFileName, entry->latticeTestScriptFile, "log");
            }
            /* get script file */
            if(lattice_test_tftp_path_len == 0)
                strcpy(tftp_file, entry->latticeTestScriptFile);
            else
                sprintf(tftp_file, "%s/%s", tftp_path, entry->latticeTestScriptFile);

            sprintf(cmd, "tftp -g -r %s %s",
                    tftp_file, tftp_ip);
            ret = system(cmd);
            if(ret)
            {
                pthread_mutex_lock(&lattice_test_mutex);
                entry->latticeTestScriptStatus = 4;
                pthread_mutex_unlock(&lattice_test_mutex);
                snmp_log(LOG_ERR, "test(%ld): get script file failed. cmd[%s]\n", entry->latticeTestScriptIndex, cmd);
                entry = entry->next;
                continue;
            }
            if(entry->latticeTestInputParameters_len)
            {
                /* get param file */
                if(lattice_test_tftp_path_len == 0)
                    strcpy(tftp_file, entry->latticeTestInputParameters);
                else
                    sprintf(tftp_file, "%s/%s", tftp_path, entry->latticeTestInputParameters);

                sprintf(cmd, "tftp -g -r %s %s",
                        tftp_file, tftp_ip);
                ret = system(cmd);
                if(ret)
                {
                    pthread_mutex_lock(&lattice_test_mutex);
                    entry->latticeTestScriptStatus = 4;
                    pthread_mutex_unlock(&lattice_test_mutex);
                    snmp_log(LOG_ERR, "test(%ld): get param file failed. cmd[%s]\n", entry->latticeTestScriptIndex, cmd);
                    entry = entry->next;
                    continue;
                }
            }

            /* run the test */
            sprintf(cmd, "python3 %s %s %s %s",
                    entry->latticeTestScriptFile,
                    entry->latticeTestInputParameters,
                    entry->latticeTestResultFileName,
                    entry->latticeTestLogFileName);

            pthread_mutex_lock(&lattice_test_mutex);
            entry->latticeTestScriptStatus = 2;
            pthread_mutex_unlock(&lattice_test_mutex);
            gettimeofday(&tv_start, NULL);
            ret = system(cmd);
            gettimeofday(&tv_end, NULL);

            pthread_mutex_lock(&lattice_test_mutex);
            if(ret == -1)
            {
                entry->latticeTestScriptStatus = 4;
                snmp_log(LOG_ERR, "test(%ld) run failed. cmd[%s]\n", entry->latticeTestScriptIndex, cmd);
            } else
                entry->latticeTestScriptStatus = 3;
            entry->latticeTestDuration = tv_end.tv_sec - tv_start.tv_sec;
            pthread_mutex_unlock(&lattice_test_mutex);

            sync();

            /* handle result file */
            pthread_mutex_lock(&lattice_test_mutex);
            output_entry = latticeTestOutputFileTable_createEntry(++latticeTestOutputFileTable_lastIndex);
            strcpy(output_entry->latticeTestOutputFile, entry->latticeTestResultFileName);
            output_entry->latticeTestOutputFile_len = entry->latticeTestResultFileName_len;
            output_entry->latticeTestOutputFileUploadStatus = LATTICE_OUTPUT_FILE_AVAILABLE;
            pthread_mutex_unlock(&lattice_test_mutex);
            if(lattice_test_mode == LATTICE_MODE_AUTOUPLOAD)
            {
                memset(tftp_file, 0, sizeof(tftp_file));
                if(lattice_test_tftp_path_len == 0)
                    strcpy(tftp_file, output_entry->latticeTestOutputFile);
                else
                    sprintf(tftp_file, "%s/%s", tftp_path, output_entry->latticeTestOutputFile);

                pthread_mutex_lock(&lattice_test_mutex);
                output_entry->latticeTestOutputFileUploadStatus = LATTICE_OUTPUT_FILE_UPLOAD_INPROGRESS;
                pthread_mutex_unlock(&lattice_test_mutex);

                sprintf(cmd, "tftp -p -l %s -r %s %s",
                    output_entry->latticeTestOutputFile,
                    tftp_file,
                    tftp_ip);
                ret = system(cmd);
                if(ret) {
                    pthread_mutex_lock(&lattice_test_mutex);
                    output_entry->latticeTestOutputFileUploadStatus = LATTICE_OUTPUT_FILE_UPLOAD_ERROR;
                    pthread_mutex_unlock(&lattice_test_mutex);
                    snmp_log(LOG_ERR, "test(%ld) upload test result file failed, cmd[%s], ret = %d\n", entry->latticeTestScriptIndex, cmd, ret);
                } else {
                    pthread_mutex_lock(&lattice_test_mutex);
                    output_entry->latticeTestOutputFileUploadStatus = LATTICE_OUTPUT_FILE_UPLOAD_COMPLETE;
                    pthread_mutex_unlock(&lattice_test_mutex);
                }
            }

            /* handle log file */
            pthread_mutex_lock(&lattice_test_mutex);
            output_entry = latticeTestOutputFileTable_createEntry(++latticeTestOutputFileTable_lastIndex);
            strcpy(output_entry->latticeTestOutputFile, entry->latticeTestLogFileName);
            output_entry->latticeTestOutputFile_len = entry->latticeTestLogFileName_len;
            output_entry->latticeTestOutputFileUploadStatus = LATTICE_OUTPUT_FILE_AVAILABLE;
            pthread_mutex_unlock(&lattice_test_mutex);
            if(lattice_test_mode == LATTICE_MODE_AUTOUPLOAD)
            {
                memset(tftp_file, 0, sizeof(tftp_file));
                if(lattice_test_tftp_path_len == 0)
                    strcpy(tftp_file, output_entry->latticeTestOutputFile);
                else
                    sprintf(tftp_file, "%s/%s", tftp_path, output_entry->latticeTestOutputFile);

                pthread_mutex_lock(&lattice_test_mutex);
                output_entry->latticeTestOutputFileUploadStatus = LATTICE_OUTPUT_FILE_UPLOAD_INPROGRESS;
                pthread_mutex_unlock(&lattice_test_mutex);
                sprintf(cmd, "tftp -p -l %s -r %s %s",
                    output_entry->latticeTestOutputFile,
                    tftp_file,
                    tftp_ip);
                ret = system(cmd);
                if(ret) {
                    pthread_mutex_lock(&lattice_test_mutex);
                    output_entry->latticeTestOutputFileUploadStatus = LATTICE_OUTPUT_FILE_UPLOAD_ERROR;
                    pthread_mutex_unlock(&lattice_test_mutex);
                    snmp_log(LOG_ERR, "test(%ld) upload test log file failed, cmd[%s], ret = %d\n", entry->latticeTestScriptIndex, cmd, ret);
                } else {
                    pthread_mutex_lock(&lattice_test_mutex);
                    output_entry->latticeTestOutputFileUploadStatus = LATTICE_OUTPUT_FILE_UPLOAD_COMPLETE;
                    pthread_mutex_unlock(&lattice_test_mutex);
                }
            }
        } else {
            break;
        }
        entry = entry->next;
    }

    chdir("/");

#ifdef BUILD_OPENWRT
    /* Remove iptables rules */
    snprintf(cmd, sizeof(cmd), "iptables -D zone_wan_input -p udp --src %s -j ACCEPT", tftp_ip);
    system(cmd);
    snprintf(cmd, sizeof(cmd), "iptables -D zone_wan_input -p udp --dst %s -j ACCEPT", tftp_ip);
    system(cmd);
#endif

    ret = lattice_set_test_status(LATTICE_STATUS_COMPLETE);
    if(ret)
    {
        snmp_log(LOG_ERR, "set lattice test status to (testing) failed\n");
        pthread_exit(NULL);
    }

    pthread_exit(NULL);
}


static void *lattice_test_upload_thread(void *arg)
{
    struct latticeTestOutputFileTable_entry *output_entry;
    int ret;
    char tftp_file[520];
    char tftp_ip[256];
    char tftp_path[256];
    char cmd[1088];

    output_entry = (struct latticeTestOutputFileTable_entry *)arg;

    /* get tftp ip */
    if(lattice_test_tftp_ip_type == SNMP_IPV4)
        inet_ntop(AF_INET, lattice_test_tftp_ip, tftp_ip, 256);
    else if(lattice_test_tftp_ip_type == SNMP_IPV6)
        inet_ntop(AF_INET6, lattice_test_tftp_ip, tftp_ip, 256);

#ifdef BUILD_OPENWRT
    /* Add iptables rules to bypass the firewall */
    snprintf(cmd, sizeof(cmd), "iptables -I zone_wan_input -p udp --src %s -j ACCEPT", tftp_ip);
    system(cmd);
    snprintf(cmd, sizeof(cmd), "iptables -I zone_wan_input -p udp --dst %s -j ACCEPT", tftp_ip);
    system(cmd);
#endif

    if(lattice_test_tftp_path_len != 0)
    {
        strncpy(tftp_path, lattice_test_tftp_path, lattice_test_tftp_path_len);
        if(tftp_path[lattice_test_tftp_path_len - 1] == '/')
           tftp_path[lattice_test_tftp_path_len - 1] = '\0';
    }
    memset(tftp_file, 0, sizeof(tftp_file));
    if(lattice_test_tftp_path_len == 0)
        strcpy(tftp_file, output_entry->latticeTestOutputFile);
    else
        sprintf(tftp_file, "%s/%s", tftp_path, output_entry->latticeTestOutputFile);

    pthread_mutex_lock(&lattice_test_mutex);
    output_entry->latticeTestOutputFileUploadStatus = LATTICE_OUTPUT_FILE_UPLOAD_INPROGRESS;
    pthread_mutex_unlock(&lattice_test_mutex);

    sprintf(cmd, "tftp -p -l %s -r %s %s",
        output_entry->latticeTestOutputFile,
        tftp_file,
        tftp_ip);
    ret = system(cmd);
    if(ret) {
        pthread_mutex_lock(&lattice_test_mutex);
        output_entry->latticeTestOutputFileUploadStatus = LATTICE_OUTPUT_FILE_UPLOAD_ERROR;
        pthread_mutex_unlock(&lattice_test_mutex);
        snmp_log(LOG_ERR, "upload test output file failed, cmd[%s], ret = %d\n", cmd, ret);
    } else {
        pthread_mutex_lock(&lattice_test_mutex);
        output_entry->latticeTestOutputFileUploadStatus = LATTICE_OUTPUT_FILE_UPLOAD_COMPLETE;
        pthread_mutex_unlock(&lattice_test_mutex);
    }

#ifdef BUILD_OPENWRT
    /* Remove iptables rules */
    snprintf(cmd, sizeof(cmd), "iptables -D zone_wan_input -p udp --src %s -j ACCEPT", tftp_ip);
    system(cmd);
    snprintf(cmd, sizeof(cmd), "iptables -D zone_wan_input -p udp --dst %s -j ACCEPT", tftp_ip);
    system(cmd);
#endif

    pthread_exit(NULL);
}
