/*
 * Note: this file originally auto-generated by mib2c using
 *        $
 */

#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>
#include "esafeMib.h"
#include <errno.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include <unistd.h>
#ifdef BUILD_RDKM
#include <syscfg/syscfg.h>
#endif

/*BRCM implementation*/
#include "bcm_net_snmp.h"

int getErouterInitMode( void );
int setErouterInitMode( unsigned int mode );
int getErouterOperMode( void );
int getProvisioningStatus( long *progress, char *failureErrorText );

#define ESAFE_MAX_STRING 256
int eSafeIndex = 1;
/** Initializes the esafeMib module */
void
init_esafeMib(void)
{
    const oid       esafeErouterAdminMode_oid[] =
        { 1, 3, 6, 1, 4, 1, 4491, 2, 1, 14, 1, 5, 1 };
    const oid       esafeErouterOperMode_oid[] =
        { 1, 3, 6, 1, 4, 1, 4491, 2, 1, 14, 1, 5, 2 };
    const oid       esafeErouterPhysAddress_oid[] =
        { 1, 3, 6, 1, 4, 1, 4491, 2, 1, 14, 1, 5, 3 };
    const oid       esafeErouterInitModeControl_oid[] =
        { 1, 3, 6, 1, 4, 1, 4491, 2, 1, 14, 1, 5, 4 };
    const oid       esafeErouterSoftReset_oid[] =
        { 1, 3, 6, 1, 4, 1, 4491, 2, 1, 14, 1, 5, 5 };

    DEBUGMSGTL(("esafeMib", "Initializing\n"));

//   eSafeIndex = getIntIfTableIfindexByName("wanbridge");
    netsnmp_register_scalar(netsnmp_create_handler_registration
                            ("esafeErouterAdminMode",
                             handle_esafeErouterAdminMode,
                             esafeErouterAdminMode_oid,
                             OID_LENGTH(esafeErouterAdminMode_oid),
                             HANDLER_CAN_RONLY));
    netsnmp_register_scalar(netsnmp_create_handler_registration
                            ("esafeErouterOperMode",
                             handle_esafeErouterOperMode,
                             esafeErouterOperMode_oid,
                             OID_LENGTH(esafeErouterOperMode_oid),
                             HANDLER_CAN_RONLY));
    netsnmp_register_scalar(netsnmp_create_handler_registration
                            ("esafeErouterPhysAddress",
                             handle_esafeErouterPhysAddress,
                             esafeErouterPhysAddress_oid,
                             OID_LENGTH(esafeErouterPhysAddress_oid),
                             HANDLER_CAN_RONLY));
    netsnmp_register_scalar(netsnmp_create_handler_registration
                            ("esafeErouterInitModeControl",
                             handle_esafeErouterInitModeControl,
                             esafeErouterInitModeControl_oid,
                             OID_LENGTH(esafeErouterInitModeControl_oid),
                             HANDLER_CAN_RWRITE));
    netsnmp_register_scalar(netsnmp_create_handler_registration
                            ("esafeErouterSoftReset",
                             handle_esafeErouterSoftReset,
                             esafeErouterSoftReset_oid,
                             OID_LENGTH(esafeErouterSoftReset_oid),
                             HANDLER_CAN_RWRITE));

  /* here we initialize all the tables we're planning on supporting */
    initialize_table_esafeProvisioningStatusTable();
    initialize_table_esafeDevStatusTable();

}

int
handle_esafeErouterAdminMode(netsnmp_mib_handler *handler,
                             netsnmp_handler_registration *reginfo,
                             netsnmp_agent_request_info *reqinfo,
                             netsnmp_request_info *requests)
{
    int mode = 0;

    /*
     * We are never called for a GETNEXT if it's registered as a
     * "instance", as it's "magically" handled for us.
     */

    /*
     * a instance handler also only hands us one request at a time, so
     * we don't need to loop over a list of requests; we'll only get one.
     */

    switch (reqinfo->mode)
    {
        case MODE_GET:
        {
            mode = getErouterAdminMode();
            if( mode != -1 )
            {
               snmp_set_var_typed_value(requests->requestvb, ASN_INTEGER, &mode, sizeof(unsigned int));
            }
            else
            {
               return SNMP_ERR_GENERR;
            }
        }
        break;

        default:
        {
            /*
             * we should never get here, so this is a really bad error
             */
            snmp_log(LOG_ERR, "unknown mode (%d) in handle_esafeErouterAdminMode\n",
                     reqinfo->mode);
            return SNMP_ERR_GENERR;
        }
    }

    return SNMP_ERR_NOERROR;
}

int
handle_esafeErouterOperMode(netsnmp_mib_handler *handler,
                            netsnmp_handler_registration *reginfo,
                            netsnmp_agent_request_info *reqinfo,
                            netsnmp_request_info *requests)
{
    int mode = 0;

    /*
     * We are never called for a GETNEXT if it's registered as a
     * "instance", as it's "magically" handled for us.
     */

    /*
     * a instance handler also only hands us one request at a time, so
     * we don't need to loop over a list of requests; we'll only get one.
     */

    switch (reqinfo->mode)
    {
        case MODE_GET:
        {
            mode = getErouterOperMode();
            if( mode != -1 )
            {
               snmp_set_var_typed_value(requests->requestvb, ASN_INTEGER, &mode, sizeof(unsigned int));
            }
            else
            {
               return SNMP_ERR_GENERR;
            }
        }
        break;

        default:
        {
            /*
             * we should never get here, so this is a really bad error
             */
            snmp_log(LOG_ERR, "unknown mode (%d) in handle_esafeErouterOperMode\n",
                     reqinfo->mode);
            return SNMP_ERR_GENERR;
        }
    }

    return SNMP_ERR_NOERROR;
}

int
handle_esafeErouterPhysAddress(netsnmp_mib_handler *handler,
                               netsnmp_handler_registration *reginfo,
                               netsnmp_agent_request_info *reqinfo,
                               netsnmp_request_info *requests)
{
    unsigned char phyAddress[SYSTEM_MAC_ADDR_LEN];
    int res;

    /*
     * We are never called for a GETNEXT if it's registered as a
     * "instance", as it's "magically" handled for us.
     */

    /*
     * a instance handler also only hands us one request at a time, so
     * we don't need to loop over a list of requests; we'll only get one.
     */

    switch (reqinfo->mode)
    {
        case MODE_GET:
        {
            /* Retrieve MAC address of br-wan interface */
#if defined(BUILD_OPENWRT)
            res = getIfMacAddress( "br-wan", phyAddress );
#elif defined(BUILD_RDKM)
            res = getIfMacAddress( "erouter0", phyAddress );
#else
            res = getIfMacAddress( "cm0", phyAddress );
#endif

            /* Return value if retrieved successfully */
            if(res != -1)
            {
                snmp_set_var_typed_value(requests->requestvb, ASN_OCTET_STR, phyAddress, sizeof(phyAddress));
            }
            else
            {
                return SNMP_ERR_GENERR;
            }
        }
        break;

        default:
        {
            /*
             * we should never get here, so this is a really bad error
             */
            snmp_log(LOG_ERR, "unknown mode (%d) in handle_esafeErouterPhysAddress\n",
                     reqinfo->mode);
            return SNMP_ERR_GENERR;
        }
    }

    return SNMP_ERR_NOERROR;
}

int
handle_esafeErouterInitModeControl(netsnmp_mib_handler *handler,
                                   netsnmp_handler_registration *reginfo,
                                   netsnmp_agent_request_info *reqinfo,
                                   netsnmp_request_info *requests)
{
    int mode = 0;
    pid_t pid;
    int ret;

    /*
     * We are never called for a GETNEXT if it's registered as a
     * "instance", as it's "magically" handled for us.
     */

    /*
     * a instance handler also only hands us one request at a time, so
     * we don't need to loop over a list of requests; we'll only get one.
     */

    switch (reqinfo->mode)
    {
        case MODE_GET:
        {
            mode = getErouterInitMode();
            if( mode != -1 )
            {
               snmp_set_var_typed_value(requests->requestvb, ASN_INTEGER, &mode, sizeof(unsigned int));
            }
            else
            {
               return SNMP_ERR_GENERR;
            }
        }
        break;

        /*
             * SET REQUEST
             *
             * multiple states in the transaction.  See:
             * http://www.net-snmp.org/tutorial-5/toolkit/mib_module/set-actions.jpg
             */
        case MODE_SET_RESERVE1:
        /*
             * or you could use netsnmp_check_vb_type_and_size instead
             */
            ret = netsnmp_check_vb_type(requests->requestvb, ASN_INTEGER);
            if (ret != SNMP_ERR_NOERROR) {
                netsnmp_set_request_error(reqinfo, requests, ret);
            }
            break;

        case MODE_SET_RESERVE2:
            /*
                 * XXX malloc "undo" storage buffer
                 */
            mode = *requests->requestvb->val.integer;
            if ((mode < 1) || (mode > 5))
            {
                netsnmp_set_request_error(reqinfo, requests,
                                        SNMP_ERR_WRONGVALUE);
            }
            break;

        case MODE_SET_FREE:
            /*
             * XXX: free resources allocated in RESERVE1 and/or
             * RESERVE2.  Something failed somewhere, and the states
             * below won't be called.
             */
            break;

        case MODE_SET_ACTION:
            pid = fork();
            if(pid < 0)
            {
                return SNMP_ERR_GENERR;
            }
            else if (pid == 0)
            {
                mode = *requests->requestvb->val.integer;
                setErouterInitMode(mode);
                exit(errno);
            }
            break;

        case MODE_SET_COMMIT:
          /*
           * XXX: delete temporary storage
           */
            if (0) {
                /*
                 * try _really_really_ hard to never get to this point
                 */
                netsnmp_set_request_error(reqinfo, requests,
                                        SNMP_ERR_COMMITFAILED);
            }
            break;

        case MODE_SET_UNDO:
            /*
             * XXX: UNDO and return to previous value for the object
             */
            if(0) {
                netsnmp_set_request_error(reqinfo, requests,
                                        SNMP_ERR_UNDOFAILED);
            }
            break;

        default:
          /*
           * we should never get here, so this is a really bad error
           */
            snmp_log(LOG_ERR,
                   "unknown mode (%d) in handle_esafeErouterInitModeControl\n",
                   reqinfo->mode);
            return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}

int
handle_esafeErouterSoftReset(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info   *reqinfo,
                          netsnmp_request_info         *requests)
{
    int ret;
    pid_t pid;

    /* We are never called for a GETNEXT if it's registered as a
       "instance", as it's "magically" handled for us.  */

    /* a instance handler also only hands us one request at a time, so
       we don't need to loop over a list of requests; we'll only get one. */

    switch(reqinfo->mode) {

        case MODE_GET:
            /* when get, always return false */
            ret = SNMP_FALSE;
            snmp_set_var_typed_integer(requests->requestvb, ASN_INTEGER, ret);
            break;

        /*
         * SET REQUEST
         *
         * multiple states in the transaction.  See:
         * http://www.net-snmp.org/tutorial-5/toolkit/mib_module/set-actions.jpg
         */
        case MODE_SET_RESERVE1:
                /* or you could use netsnmp_check_vb_type_and_size instead */
            ret = netsnmp_check_vb_truthvalue(requests->requestvb);
            if ( ret != SNMP_ERR_NOERROR ) {
                netsnmp_set_request_error(reqinfo, requests, ret );
            }
            break;

        case MODE_SET_RESERVE2:
            /* XXX malloc "undo" storage buffer */
            if (0/* XXX if malloc, or whatever, failed: */) {
                netsnmp_set_request_error(reqinfo, requests, SNMP_ERR_RESOURCEUNAVAILABLE);
            }
            break;

        case MODE_SET_FREE:
            /* XXX: free resources allocated in RESERVE1 and/or
               RESERVE2.  Something failed somewhere, and the states
               below won't be called. */
            break;

        case MODE_SET_ACTION:
            /* XXX: perform the value change here */
            if(*requests->requestvb->val.integer == SNMP_TRUE)
            {
                pid = fork();
                if(pid < 0)
                {
                    return SNMP_ERR_GENERR;
                }
                else if (pid == 0)
                {
                    resetErouter();
                    exit(errno);
                }
            }
            break;

        case MODE_SET_COMMIT:
            /* XXX: delete temporary storage */
            if (0 /* XXX: error? */) {
                /* try _really_really_ hard to never get to this point */
                netsnmp_set_request_error(reqinfo, requests, SNMP_ERR_COMMITFAILED);
            }
            break;

        case MODE_SET_UNDO:
            /* XXX: UNDO and return to previous value for the object */
            if (0 /* XXX: error? */) {
                /* try _really_really_ hard to never get to this point */
                netsnmp_set_request_error(reqinfo, requests, SNMP_ERR_UNDOFAILED);
            }
            break;

        default:
            /* we should never get here, so this is a really bad error */
            snmp_log(LOG_ERR, "unknown mode (%d) in handle_esafeErouterSoftReset\n", reqinfo->mode );
            return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}

/** Initialize the esafeProvisioningStatusTable table by defining its contents and how it's structured */

void
initialize_table_esafeProvisioningStatusTable(void)
{
    const oid esafeProvisioningStatusTable_oid[] = {1,3,6,1,4,1,4491,2,1,14,1,1,1};
    const size_t esafeProvisioningStatusTable_oid_len   = OID_LENGTH(esafeProvisioningStatusTable_oid);
    netsnmp_handler_registration    *reg;
    netsnmp_iterator_info           *iinfo;
    netsnmp_table_registration_info *table_info;

    DEBUGMSGTL(("esafeMib:init", "initializing table esafeProvisioningStatusTable\n"));

    reg = netsnmp_create_handler_registration(
              "esafeProvisioningStatusTable",     esafeProvisioningStatusTable_handler,
              esafeProvisioningStatusTable_oid, esafeProvisioningStatusTable_oid_len,
              HANDLER_CAN_RONLY
              );

    table_info = SNMP_MALLOC_TYPEDEF( netsnmp_table_registration_info );
    netsnmp_table_helper_add_indexes(table_info,
                           ASN_INTEGER,  /* index: ifIndex */
                           0);
    table_info->min_column = COLUMN_ESAFEPROVISIONINGSTATUSPROGRESS;
    table_info->max_column = COLUMN_ESAFEPROVISIONINGSTATUSLASTUPDATE;

    iinfo = SNMP_MALLOC_TYPEDEF( netsnmp_iterator_info );
    iinfo->get_first_data_point = esafeProvisioningStatusTable_get_first_data_point;
    iinfo->get_next_data_point  = esafeProvisioningStatusTable_get_next_data_point;
    iinfo->table_reginfo        = table_info;

    netsnmp_register_table_iterator( reg, iinfo );

    /* Initialise the contents of the table here */
}



    /* Typical data structure for a row entry */
struct esafeProvisioningStatusTable_entry {
    /* Index values */
    long ifIndex;

    /* Column values */
    long esafeProvisioningStatusProgress;
    long esafeProvisioningStatusFailureFound;
    char esafeProvisioningStatusFailureFlow[ESAFE_MAX_STRING];
    size_t esafeProvisioningStatusFailureFlow_len;
    u_long esafeProvisioningStatusFailureEventID;
    char esafeProvisioningStatusFailureErrorText[ESAFE_MAX_STRING];
    size_t esafeProvisioningStatusFailureErrorText_len;
    char esafeProvisioningStatusLastUpdate[ESAFE_MAX_STRING];
    size_t esafeProvisioningStatusLastUpdate_len;

    /* Illustrate using a simple linked list */
    int   valid;
    struct esafeProvisioningStatusTable_entry *next;
};

struct esafeProvisioningStatusTable_entry  *esafeProvisioningStatusTable_head;

/* create a new row in the (unsorted) table */
struct esafeProvisioningStatusTable_entry *
esafeProvisioningStatusTable_createEntry(
                 long  ifIndex
                ) {
    struct esafeProvisioningStatusTable_entry *entry;

    entry = SNMP_MALLOC_TYPEDEF(struct esafeProvisioningStatusTable_entry);
    if (!entry)
        return NULL;

    entry->ifIndex = ifIndex;
    entry->next = esafeProvisioningStatusTable_head;
    esafeProvisioningStatusTable_head = entry;
    return entry;
}

/* remove a row from the table */
void
esafeProvisioningStatusTable_removeEntry( struct esafeProvisioningStatusTable_entry *entry ) {
    struct esafeProvisioningStatusTable_entry *ptr, *prev;

    if (!entry)
        return;    /* Nothing to remove */

    for ( ptr  = esafeProvisioningStatusTable_head, prev = NULL;
          ptr != NULL;
          prev = ptr, ptr = ptr->next ) {
        if ( ptr == entry )
            break;
    }
    if ( !ptr )
        return;    /* Can't find it */

    if ( prev == NULL )
        esafeProvisioningStatusTable_head = ptr->next;
    else
        prev->next = ptr->next;

    SNMP_FREE( entry );   /* XXX - release any other internal resources */
}


static struct timeval	esafeProvisioningStatusTable_last_rebuild_time;

/** Rebuild the esafeProvisioningStatusTable table by defining its contents and how it's structured */

static int convert_tr181_dateTime_to_snmp(char *dateTime, char *snmpDateTime)
{

    int year,month, day, hour, minute, second, hour_utc, min_utc;
    char dir_utc;
    int len;
    int ret;

    if (dateTime == NULL)
    {
        return 0;
    }

    /* The tr181 datetime format is "2015-04-13T08:31:53+00:00" */
    len = sscanf(dateTime, "%d%*[-]%d%*[-]%d%*[T]%d%*[:]%d%*[:]%d%c%d%*[:]%d",
        &year, &month, &day, &hour, &minute, &second, &dir_utc, &hour_utc, &min_utc);

    if(len != 9 && len != 7)
    {
        return 0;
    }

    if(len == 7 && dir_utc != 'Z')
    {
        return 0;
    }

    snmpDateTime[0] = (year >> 8) & 0xff;
    snmpDateTime[1] = year & 0xff;
    snmpDateTime[2] = month & 0xff;
    snmpDateTime[3] = day & 0xff;
    snmpDateTime[4] = hour & 0xff;
    snmpDateTime[5] = minute & 0xff;
    snmpDateTime[6] = second & 0xff;
    snmpDateTime[7] = 0;
    if(len == 9)
    {
        snmpDateTime[8] = dir_utc;
        snmpDateTime[9] = hour_utc & 0xff;
        snmpDateTime[10] = min_utc & 0xff;
        ret = 11;
    } else {
        ret = 8;
    }
    return ret;
}

void
esafeProvisioningStatusTable_rebuildTableData(int forceRenew)
{
    struct esafeProvisioningStatusTable_entry *entry;
    struct timeval tv_now = (struct timeval){0};;
    struct tm *tm_now = localtime((time_t *)&(tv_now.tv_sec));
    char time_buf[ESAFE_MAX_STRING] = {0};

    gettimeofday(&tv_now, NULL);

    if(( tv_now.tv_sec - esafeProvisioningStatusTable_last_rebuild_time.tv_sec >= ESAFEPROVISIONINGSTATUSTABLE_REBUILD_TIME) || (1 == forceRenew))
    {
        /*Clear the table  */
        while ((entry = esafeProvisioningStatusTable_head)) {
            esafeProvisioningStatusTable_removeEntry(entry);
        }

        entry = esafeProvisioningStatusTable_createEntry(eSafeIndex); /**< for internal use only */

        /* Index values */
        entry->ifIndex = eSafeIndex;

        /* Column values */
        entry->esafeProvisioningStatusFailureFound = getProvisioningStatus(&(entry->esafeProvisioningStatusProgress), entry->esafeProvisioningStatusFailureErrorText);
        entry->esafeProvisioningStatusFailureEventID = 0;

        strftime(time_buf, sizeof(time_buf), "%Y-%m-%dT%H:%M:%S", tm_now);
        strcat(time_buf, "Z");
        entry->esafeProvisioningStatusLastUpdate_len = convert_tr181_dateTime_to_snmp(time_buf, entry->esafeProvisioningStatusLastUpdate);

        esafeProvisioningStatusTable_last_rebuild_time = tv_now;
    }
	return;
}

/* Example iterator hook routines - using 'get_next' to do most of the work */
netsnmp_variable_list *
esafeProvisioningStatusTable_get_first_data_point(void **my_loop_context,
                          void **my_data_context,
                          netsnmp_variable_list *put_index_data,
                          netsnmp_iterator_info *mydata)
{

    esafeProvisioningStatusTable_rebuildTableData(1);
    *my_loop_context = esafeProvisioningStatusTable_head;
    return esafeProvisioningStatusTable_get_next_data_point(my_loop_context, my_data_context,
                                    put_index_data,  mydata );
}

netsnmp_variable_list *
esafeProvisioningStatusTable_get_next_data_point(void **my_loop_context,
                          void **my_data_context,
                          netsnmp_variable_list *put_index_data,
                          netsnmp_iterator_info *mydata)
{
    struct esafeProvisioningStatusTable_entry *entry = (struct esafeProvisioningStatusTable_entry *)*my_loop_context;
    netsnmp_variable_list *idx = put_index_data;

    if ( entry ) {
        snmp_set_var_typed_integer( idx, ASN_INTEGER, entry->ifIndex );
        idx = idx->next_variable;
        *my_data_context = (void *)entry;
        *my_loop_context = (void *)entry->next;
        return put_index_data;
    } else {
        return NULL;
    }
}


/** handles requests for the esafeProvisioningStatusTable table */
int
esafeProvisioningStatusTable_handler(
    netsnmp_mib_handler               *handler,
    netsnmp_handler_registration      *reginfo,
    netsnmp_agent_request_info        *reqinfo,
    netsnmp_request_info              *requests) {

    netsnmp_request_info       *request;
    netsnmp_table_request_info *table_info;
    struct esafeProvisioningStatusTable_entry          *table_entry;

    DEBUGMSGTL(("esafeMib:handler", "Processing request (%d)\n", reqinfo->mode));

    switch (reqinfo->mode) {
        /*
         * Read-support (also covers GetNext requests)
         */
    case MODE_GET:
        for (request=requests; request; request=request->next) {
            table_entry = (struct esafeProvisioningStatusTable_entry *)
                              netsnmp_extract_iterator_context(request);
            table_info  =     netsnmp_extract_table_info(      request);

            switch (table_info->colnum) {
            case COLUMN_ESAFEPROVISIONINGSTATUSPROGRESS:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_INTEGER,
                                            table_entry->esafeProvisioningStatusProgress);
                break;
            case COLUMN_ESAFEPROVISIONINGSTATUSFAILUREFOUND:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_INTEGER,
                                            table_entry->esafeProvisioningStatusFailureFound);
                break;
            case COLUMN_ESAFEPROVISIONINGSTATUSFAILUREFLOW:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_value( request->requestvb, ASN_OCTET_STR,
                                          table_entry->esafeProvisioningStatusFailureFlow,
                                          table_entry->esafeProvisioningStatusFailureFlow_len);
                break;
            case COLUMN_ESAFEPROVISIONINGSTATUSFAILUREEVENTID:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_UNSIGNED,
                                            table_entry->esafeProvisioningStatusFailureEventID);
                break;
            case COLUMN_ESAFEPROVISIONINGSTATUSFAILUREERRORTEXT:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_value( request->requestvb, ASN_OCTET_STR,
                                          table_entry->esafeProvisioningStatusFailureErrorText,
                                          table_entry->esafeProvisioningStatusFailureErrorText_len);
                break;
            case COLUMN_ESAFEPROVISIONINGSTATUSLASTUPDATE:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_value( request->requestvb, ASN_OCTET_STR,
                                          table_entry->esafeProvisioningStatusLastUpdate,
                                          table_entry->esafeProvisioningStatusLastUpdate_len);
                break;
            default:
                netsnmp_set_request_error(reqinfo, request,
                                          SNMP_NOSUCHOBJECT);
                break;
            }
        }
        break;

    }
    return SNMP_ERR_NOERROR;
}

/** Initialize the esafeDevStatusTable table by defining its contents and how it's structured */

void
initialize_table_esafeDevStatusTable(void)
{
    const oid esafeDevStatusTable_oid[] = {1,3,6,1,4,1,4491,2,1,14,1,1,2};
    const size_t esafeDevStatusTable_oid_len   = OID_LENGTH(esafeDevStatusTable_oid);
    netsnmp_handler_registration    *reg;
    netsnmp_iterator_info           *iinfo;
    netsnmp_table_registration_info *table_info;

    DEBUGMSGTL(("esafeMib:init", "initializing table esafeDevStatusTable\n"));

    reg = netsnmp_create_handler_registration(
              "esafeDevStatusTable",     esafeDevStatusTable_handler,
              esafeDevStatusTable_oid, esafeDevStatusTable_oid_len,
              HANDLER_CAN_RONLY
              );

    table_info = SNMP_MALLOC_TYPEDEF( netsnmp_table_registration_info );
    netsnmp_table_helper_add_indexes(table_info,
                           ASN_INTEGER,  /* index: ifIndex */
                           0);
    table_info->min_column = COLUMN_ESAFEDEVSERVICEINTIMPACT;
    table_info->max_column = COLUMN_ESAFEDEVSERVICEINTIMPACTINFO;

    iinfo = SNMP_MALLOC_TYPEDEF( netsnmp_iterator_info );
    iinfo->get_first_data_point = esafeDevStatusTable_get_first_data_point;
    iinfo->get_next_data_point  = esafeDevStatusTable_get_next_data_point;
    iinfo->table_reginfo        = table_info;

    netsnmp_register_table_iterator( reg, iinfo );

    /* Initialise the contents of the table here */
}



    /* Typical data structure for a row entry */
struct esafeDevStatusTable_entry {
    /* Index values */
    long ifIndex;

    /* Column values */
    long esafeDevServiceIntImpact;
    char esafeDevServiceIntImpactInfo[ESAFE_MAX_STRING];
    size_t esafeDevServiceIntImpactInfo_len;

    /* Illustrate using a simple linked list */
    int   valid;
    struct esafeDevStatusTable_entry *next;
};

struct esafeDevStatusTable_entry  *esafeDevStatusTable_head;

/* create a new row in the (unsorted) table */
struct esafeDevStatusTable_entry *
esafeDevStatusTable_createEntry(
                 long  ifIndex
                ) {
    struct esafeDevStatusTable_entry *entry;

    entry = SNMP_MALLOC_TYPEDEF(struct esafeDevStatusTable_entry);
    if (!entry)
        return NULL;

    entry->ifIndex = ifIndex;
    entry->next = esafeDevStatusTable_head;
    esafeDevStatusTable_head = entry;
    return entry;
}

/* remove a row from the table */
void
esafeDevStatusTable_removeEntry( struct esafeDevStatusTable_entry *entry ) {
    struct esafeDevStatusTable_entry *ptr, *prev;

    if (!entry)
        return;    /* Nothing to remove */

    for ( ptr  = esafeDevStatusTable_head, prev = NULL;
          ptr != NULL;
          prev = ptr, ptr = ptr->next ) {
        if ( ptr == entry )
            break;
    }
    if ( !ptr )
        return;    /* Can't find it */

    if ( prev == NULL )
        esafeDevStatusTable_head = ptr->next;
    else
        prev->next = ptr->next;

    SNMP_FREE( entry );   /* XXX - release any other internal resources */
}


static struct timeval	esafeDevStatusTable_last_rebuild_time;

/** Rebuild the esafeDevStatusTable table by defining its contents and how it's structured */

void
esafeDevStatusTable_rebuildTableData(int forceRenew)
{
    struct timeval tv_now;
    struct esafeDevStatusTable_entry *entry;

    gettimeofday(&tv_now, NULL);

    if(( tv_now.tv_sec - esafeDevStatusTable_last_rebuild_time.tv_sec >= ESAFEDEVSTATUSTABLE_REBUILD_TIME) || (1 == forceRenew))
    {
        /*Clear the table  */
        while ((entry = esafeDevStatusTable_head)) {
            esafeDevStatusTable_removeEntry(entry);
        }

        entry = esafeDevStatusTable_createEntry(eSafeIndex); /**< for internal use only */
        /* Index values */
        entry->ifIndex = eSafeIndex;

        /* Column values */
        entry->esafeDevServiceIntImpact = 3; /* Not supported */

        esafeDevStatusTable_last_rebuild_time = tv_now;
    }
    return;
}

/* Example iterator hook routines - using 'get_next' to do most of the work */
netsnmp_variable_list *
esafeDevStatusTable_get_first_data_point(void **my_loop_context,
                          void **my_data_context,
                          netsnmp_variable_list *put_index_data,
                          netsnmp_iterator_info *mydata)
{
    esafeDevStatusTable_rebuildTableData(1);
    *my_loop_context = esafeDevStatusTable_head;
    return esafeDevStatusTable_get_next_data_point(my_loop_context, my_data_context,
                                    put_index_data,  mydata );
}

netsnmp_variable_list *
esafeDevStatusTable_get_next_data_point(void **my_loop_context,
                          void **my_data_context,
                          netsnmp_variable_list *put_index_data,
                          netsnmp_iterator_info *mydata)
{
    struct esafeDevStatusTable_entry *entry = (struct esafeDevStatusTable_entry *)*my_loop_context;
    netsnmp_variable_list *idx = put_index_data;

    if ( entry ) {
        snmp_set_var_typed_integer( idx, ASN_INTEGER, entry->ifIndex );
        idx = idx->next_variable;
        *my_data_context = (void *)entry;
        *my_loop_context = (void *)entry->next;
        return put_index_data;
    } else {
        return NULL;
    }
}


/** handles requests for the esafeDevStatusTable table */
int
esafeDevStatusTable_handler(
    netsnmp_mib_handler               *handler,
    netsnmp_handler_registration      *reginfo,
    netsnmp_agent_request_info        *reqinfo,
    netsnmp_request_info              *requests) {

    netsnmp_request_info       *request;
    netsnmp_table_request_info *table_info;
    struct esafeDevStatusTable_entry          *table_entry;

    DEBUGMSGTL(("esafeMib:handler", "Processing request (%d)\n", reqinfo->mode));

    switch (reqinfo->mode) {
        /*
         * Read-support (also covers GetNext requests)
         */
    case MODE_GET:
        for (request=requests; request; request=request->next) {
            table_entry = (struct esafeDevStatusTable_entry *)
                              netsnmp_extract_iterator_context(request);
            table_info  =     netsnmp_extract_table_info(      request);

            switch (table_info->colnum) {
            case COLUMN_ESAFEDEVSERVICEINTIMPACT:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_INTEGER,
                                            table_entry->esafeDevServiceIntImpact);
                break;
            case COLUMN_ESAFEDEVSERVICEINTIMPACTINFO:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_value( request->requestvb, ASN_OCTET_STR,
                                          table_entry->esafeDevServiceIntImpactInfo,
                                          table_entry->esafeDevServiceIntImpactInfo_len);
                break;
            default:
                netsnmp_set_request_error(reqinfo, request,
                                          SNMP_NOSUCHOBJECT);
                break;
            }
        }
        break;

    }
    return SNMP_ERR_NOERROR;
}

/* IP prov mode enumerations */
typedef enum
{
   IP_PROV_MODE_DISABLED = 1,
   IP_PROV_MODE_IPV4,
   IP_PROV_MODE_IPV6,
   IP_PROV_MODE_DUAL,
   IP_PROV_MODE_NOT_FORWARDING

} IP_PROV_MODE;

/* Define IP prov mode token pairs */
const SNMPTOKENS ipProvModeParmVals[] =
{
   { IP_PROV_MODE_DISABLED,   "disabled" },
   { IP_PROV_MODE_IPV4,       "ipv4"     },
   { IP_PROV_MODE_IPV6,       "ipv6"     },
   { IP_PROV_MODE_DUAL,       "dual"     },
   { SNMP_TOKEN_ERROR,        NULL       }
};

#define IP_PROV_MODE_HONORTLV   5

/* Define IP prov mode token pairs */
const SNMPTOKENS ipProvModeInitControlParmVals[] =
{
   { IP_PROV_MODE_DISABLED,   "disabled" },
   { IP_PROV_MODE_IPV4,       "ipv4"     },
   { IP_PROV_MODE_IPV6,       "ipv6"     },
   { IP_PROV_MODE_DUAL,       "dual"     },
   { IP_PROV_MODE_HONORTLV,   "honortlv" },
   { SNMP_TOKEN_ERROR,        NULL       }
};

/* Provisioning status enumerations */
enum
{
   PROV_STATUS_NOTINIT = 1,
   PROV_STATUS_INPROGRESS,
   PROV_STATUS_FINISHED
};

#if defined(BUILD_OPENWRT)
/* Retrieve erouter admin mode */
int getErouterAdminMode( void )
{
   char buffer[200];
   unsigned int res;
   unsigned int mode;

   memset( buffer, 0, sizeof(buffer) );
   res = getUciValue( "erouter.globals.ip_prov_mode", buffer, sizeof(buffer) );
   if( res != UCI_SUCCESS )
   {
      return( -1 );
   }

   mode = tokenToId( ipProvModeParmVals, buffer );
   return( mode );
}

/* Retrieve erouter admin mode */
int getErouterInitMode( void )
{
   char buffer[200];
   unsigned int res;
   unsigned int mode;

   memset( buffer, 0, sizeof(buffer) );
   res = getUciValue( "erouter.globals.init_mode_control", buffer, sizeof(buffer) );
   if( res != UCI_SUCCESS )
   {
      return( -1 );
   }

   mode = tokenToId( ipProvModeInitControlParmVals, buffer );
   return( mode );
}

/* Update erouter admin mode */
int setErouterInitMode( unsigned int mode )
{
   char buffer[200];
   char *modeStr;
   unsigned int res;

   modeStr = tokenToString( ipProvModeInitControlParmVals, mode );
   if( modeStr == NULL )
   {
      return( -1 );
   }

   memset( buffer, 0, sizeof(buffer) );
   strcpy( buffer, modeStr );
   res = setUciValue( "erouter.globals.init_mode_control", buffer, sizeof(buffer) );
   if( res != UCI_SUCCESS )
   {
      return( -1 );
   }

   if( mode != IP_PROV_MODE_HONORTLV )
   {
       res = setUciValue( "erouter.globals.ip_prov_mode", buffer, sizeof(buffer) );
       if( res != UCI_SUCCESS )
       {
          return( -1 );
       }
       resetErouter();
   }

   return( 0 );
}

/* Retrieve erouter oper mode */
int getErouterOperMode( void )
{
   int adminMode;
   int operMode;
   bool ipv4, ipv6;

   /* Retrieve and check admin mode */
   adminMode = getErouterAdminMode();
   if( adminMode == -1 )
   {
      return( adminMode );
   }

   /* Check IP status of br-wan */
   checkIpPresent( "br-wan", &ipv4, &ipv6 );

   /* Map admin mode and IP state to oper mode */
   switch( adminMode )
   {
      case IP_PROV_MODE_DISABLED:
      {
         operMode = IP_PROV_MODE_DISABLED;
      }
      break;

      case IP_PROV_MODE_IPV4:
      {
         if( ipv4 )
         {
            operMode = IP_PROV_MODE_IPV4;
         }
         else
         {
            operMode = IP_PROV_MODE_NOT_FORWARDING;
         }
      }
      break;

      case IP_PROV_MODE_IPV6:
      {
         if( ipv6 )
         {
            operMode = IP_PROV_MODE_IPV6;
         }
         else
         {
            operMode = IP_PROV_MODE_NOT_FORWARDING;
         }
      }
      break;

      case IP_PROV_MODE_DUAL:
      {
         if( ipv4 && ipv6 )
         {
            operMode = IP_PROV_MODE_DUAL;
         }
         else if ( ipv6 )
         {
            operMode = IP_PROV_MODE_IPV6;
         }
         else if ( ipv4 )
         {
            operMode = IP_PROV_MODE_IPV4;
         }
         else
         {
            operMode = IP_PROV_MODE_NOT_FORWARDING;
         }
      }
      break;

      default:
      {
         /* Unexpected error */
         return( -1 );
      }
      break;
   }

   return( operMode );
}

/* Retrieve provisioning status: Return SNMP_TRUE on Error */
int getProvisioningStatus( long *progress, char *failureErrorText )
{
    int fd;
    struct ifreq intf;

    if (!progress || !failureErrorText)
        return( SNMP_TRUE);

    if ((fd = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
    {
        strcpy(failureErrorText, "Failed to open socket");
        return( SNMP_TRUE );
    }
    else
    {
        /* Get WAN interface */
        char ifName[16] = {0};
        if( (getUciValue( "flowmgr.globals.wan_dev_name", ifName, sizeof(ifName) )) != UCI_SUCCESS )
        {
            strcpy(failureErrorText, "Failed to get WAN interface");
            return( SNMP_TRUE );
        }
        strncpy(intf.ifr_name, ifName, sizeof(intf.ifr_name));

        /* Check if the WAN interface is RUNNING */
        if (ioctl(fd, SIOCGIFFLAGS, &intf) != -1)
        {
            if (intf.ifr_flags & IFF_RUNNING)
                *progress = PROV_STATUS_INPROGRESS;
            else
                *progress = PROV_STATUS_NOTINIT;
        }
        else
        {
            strcpy(failureErrorText, "Failed to get WAN interface");
            close(fd);
            return( SNMP_TRUE );
        }
    }
    close(fd);

    /* Provision finished if operMode same as adminMode */
    if (*progress == PROV_STATUS_INPROGRESS)
    {
        int adminMode = getErouterAdminMode();
        int operMode = getErouterOperMode();
        if (adminMode == operMode)
            *progress = PROV_STATUS_FINISHED;
    }

    failureErrorText[0] = '\0';
    return( SNMP_FALSE );
}

/* Reset eRouter via UCI script */
int resetErouter( void )
{
   system("/etc/init.d/erouter restart");
   return( 0 );
}
#elif defined(BUILD_RDKM)
static int SysCfgGetInt(const char *name)
{
   char out_value[20];
   int outbufsz = sizeof(out_value);
   if (!syscfg_get(NULL, name, out_value, outbufsz))
   {
      return atoi(out_value);
   }
   else
   {
      return -1;
   }
}

/* Retrieve erouter admin mode */
int getErouterAdminMode( void )
{
    int bridgeMode = SysCfgGetInt("bridge_mode");
    int eRouterMode = SysCfgGetInt("last_erouter_mode");

    return eRouterMode? (bridgeMode ? IP_PROV_MODE_DISABLED : IP_PROV_MODE_DUAL) : IP_PROV_MODE_DISABLED;
}

/* Retrieve erouter admin mode */
int getErouterInitMode( void )
{
    return IP_PROV_MODE_HONORTLV;
}

/* Update erouter admin mode */
int setErouterInitMode( unsigned int mode )
{
    char cmd[128] = {'\0'};

    if( mode != IP_PROV_MODE_HONORTLV )
    {
        snprintf(cmd, sizeof(cmd), "sysevent set erouter_mode %d", --mode);
        system(cmd);
        resetErouter();
    }

    return 0;
}

/* Retrieve erouter oper mode */
int getErouterOperMode( void )
{
    int adminMode;
    int operMode;
    bool ipv4, ipv6;

    /* Retrieve and check admin mode */
    adminMode = getErouterAdminMode();
    if( adminMode == -1 )
    {
       return( adminMode );
    }

    /* Check IP status of br-wan */
    checkIpPresent( "erouter0", &ipv4, &ipv6 );

    /* Map admin mode and IP state to oper mode */
    switch( adminMode )
    {
       case IP_PROV_MODE_DISABLED:
       {
          operMode = IP_PROV_MODE_DISABLED;
       }
       break;

       case IP_PROV_MODE_IPV4:
       {
          if( ipv4 )
          {
             operMode = IP_PROV_MODE_IPV4;
          }
          else
          {
             operMode = IP_PROV_MODE_NOT_FORWARDING;
          }
       }
       break;

       case IP_PROV_MODE_IPV6:
       {
          if( ipv6 )
          {
             operMode = IP_PROV_MODE_IPV6;
          }
          else
          {
             operMode = IP_PROV_MODE_NOT_FORWARDING;
          }
       }
       break;

       case IP_PROV_MODE_DUAL:
       {
          if( ipv4 && ipv6 )
          {
             operMode = IP_PROV_MODE_DUAL;
          }
          else if ( ipv6 )
          {
             operMode = IP_PROV_MODE_IPV6;
          }
          else if ( ipv4 )
          {
             operMode = IP_PROV_MODE_IPV4;
          }
          else
          {
             operMode = IP_PROV_MODE_NOT_FORWARDING;
          }
       }
       break;

       default:
       {
          /* Unexpected error */
          return( -1 );
       }
       break;
    }

    return( operMode );

}

/* Retrieve provisioning status: Return SNMP_TRUE on Error */
int getProvisioningStatus( long *progress, char *failureErrorText )
{
    int fd;
    struct ifreq intf;

    if (!progress || !failureErrorText)
        return( SNMP_TRUE);

    if ((fd = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
    {
        strcpy(failureErrorText, "Failed to open socket");
        return( SNMP_TRUE );
    }
    else
    {
        /* Get WAN interface */
        char *ifName = "erouter0";
        strncpy(intf.ifr_name, ifName, sizeof(intf.ifr_name));

        /* Check if the WAN interface is RUNNING */
        if (ioctl(fd, SIOCGIFFLAGS, &intf) != -1)
        {
            if (intf.ifr_flags & IFF_RUNNING)
                *progress = PROV_STATUS_INPROGRESS;
            else
                *progress = PROV_STATUS_NOTINIT;
        }
        else
        {
            strcpy(failureErrorText, "Failed to get WAN interface");
            close(fd);
            return( SNMP_TRUE );
        }
    }
    close(fd);

    /* Provision finished if operMode same as adminMode */
    if (*progress == PROV_STATUS_INPROGRESS)
    {
        int adminMode = getErouterAdminMode();
        int operMode = getErouterOperMode();
        if (adminMode == operMode)
            *progress = PROV_STATUS_FINISHED;
    }

    failureErrorText[0] = '\0';
    return( SNMP_FALSE );

}

/* Reset eRouter via UCI script */
int resetErouter( void )
{
    system("dmcli eRT setv Device.X_CISCO_COM_DeviceControl.RebootDevice string \"Router\"");
    return 0;
}

#else
/* Retrieve erouter admin mode */
int getErouterAdminMode( void )
{
    if (!system("grep Bridge /usr/local/etc/lattice/lattice-config.xml|grep -q Yes"))
        return 1;
    else if (!system("grep VirtNiHal /usr/local/etc/lattice/lattice-config.xml|grep -q Yes"))
        return 1;

    /* hard code to be dual(4). */
    return 4;
}

/* Retrieve erouter admin mode */
int getErouterInitMode( void )
{
    return 0;
}

/* Update erouter admin mode */
int setErouterInitMode( unsigned int mode )
{
    return 0;
}

/* Retrieve erouter oper mode */
int getErouterOperMode( void )
{
    return 0;
}

/* Retrieve provisioning status: Return SNMP_TRUE on Error */
int getProvisioningStatus( long *progress, char *failureErrorText )
{
    return 0;
}

/* Reset eRouter via UCI script */
int resetErouter( void )
{
    return 0;
}
#endif
