/*
 * Note: this file originally auto-generated by mib2c using
 *  $
 */

#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>
#include "dot1d_bridge.h"
#include "bcm_net_snmp.h"

#include <stdio.h>
#include <unistd.h>
#include <dirent.h>
#include <linux/if_bridge.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <linux/netdevice.h>

#define SYSFS_CLASS_NET "/sys/class/net/"
#define SYSFS_PATH_MAX    512
#define NNN 256

#if defined(BUILD_OPENWRT)
#define BR_NAME_BRIDGE "br-wan"
#define BR_NAME_ROUTER "br-lan"
#elif defined(BUILD_RDKM)
#define BR_NAME_BRIDGE "brlan0"
#define BR_NAME_ROUTER "brlan0"
#else
#define BR_NAME_BRIDGE "wanbridge"
#define BR_NAME_ROUTER "br0"
#endif
#define BR_ADDRESSFILE_BRIDGE "/sys/class/net/"BR_NAME_BRIDGE"/address"
#define SYSFS_CLASS_NET_BR_IF_BRIDGE "/sys/class/net/"BR_NAME_BRIDGE"/brif"
#define AGINGTIME_FILE_BRIDGE "/sys/class/net/"BR_NAME_BRIDGE"/bridge/ageing_time"
#define SYSFS_CLASS_NET_BR_FORWARD_BRIDGE "/sys/class/net/"BR_NAME_BRIDGE"/brforward"
#define BR_ADDRESSFILE_ROUTER "/sys/class/net/"BR_NAME_ROUTER"/address"
#define SYSFS_CLASS_NET_BR_IF_ROUTER "/sys/class/net/"BR_NAME_ROUTER"/brif"
#define AGINGTIME_FILE_ROUTER "/sys/class/net/"BR_NAME_ROUTER"/bridge/ageing_time"
#define SYSFS_CLASS_NET_BR_FORWARD_ROUTER "/sys/class/net/"BR_NAME_ROUTER"/brforward"

/** Initializes the dot1d_bridge module */
void
init_dot1d_bridge(void)
{
    const oid dot1dBaseBridgeAddress_oid[] = { 1,3,6,1,2,1,17,1,1 };
    const oid dot1dBaseNumPorts_oid[] = { 1,3,6,1,2,1,17,1,2 };
    const oid dot1dBaseType_oid[] = { 1,3,6,1,2,1,17,1,3 };
    const oid dot1dTpLearnedEntryDiscards_oid[] = { 1,3,6,1,2,1,17,4,1 };
    const oid dot1dTpAgingTime_oid[] = { 1,3,6,1,2,1,17,4,2 };

  DEBUGMSGTL(("dot1d_bridge", "Initializing\n"));

    netsnmp_register_scalar(
        netsnmp_create_handler_registration("dot1dBaseBridgeAddress", handle_dot1dBaseBridgeAddress,
                               dot1dBaseBridgeAddress_oid, OID_LENGTH(dot1dBaseBridgeAddress_oid),
                               HANDLER_CAN_RONLY
        ));
    netsnmp_register_scalar(
        netsnmp_create_handler_registration("dot1dBaseNumPorts", handle_dot1dBaseNumPorts,
                               dot1dBaseNumPorts_oid, OID_LENGTH(dot1dBaseNumPorts_oid),
                               HANDLER_CAN_RONLY
        ));
    netsnmp_register_scalar(
        netsnmp_create_handler_registration("dot1dBaseType", handle_dot1dBaseType,
                               dot1dBaseType_oid, OID_LENGTH(dot1dBaseType_oid),
                               HANDLER_CAN_RONLY
        ));
    netsnmp_register_scalar(
        netsnmp_create_handler_registration("dot1dTpLearnedEntryDiscards", handle_dot1dTpLearnedEntryDiscards,
                               dot1dTpLearnedEntryDiscards_oid, OID_LENGTH(dot1dTpLearnedEntryDiscards_oid),
                               HANDLER_CAN_RONLY
        ));
    netsnmp_register_scalar(
        netsnmp_create_handler_registration("dot1dTpAgingTime", handle_dot1dTpAgingTime,
                               dot1dTpAgingTime_oid, OID_LENGTH(dot1dTpAgingTime_oid),
                               HANDLER_CAN_RWRITE
        ));

  /* here we initialize all the tables we're planning on supporting */
    initialize_table_dot1dBasePortTable();
    initialize_table_dot1dTpFdbTable();
    initialize_table_dot1dTpPortTable();
}

int
handle_dot1dBaseBridgeAddress(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info   *reqinfo,
                          netsnmp_request_info         *requests)
{
    char line[128];
    FILE *in;
    unsigned int values[6];
    int numScanned, numRead;
    int i;
    unsigned char bridgeAddress[6];
    char BR_ADDRESSFILE[64] = {0};

    if (getErouterAdminMode() == 1)
        strcpy(BR_ADDRESSFILE, BR_ADDRESSFILE_BRIDGE);
    else
        strcpy(BR_ADDRESSFILE, BR_ADDRESSFILE_ROUTER);

    /* We are never called for a GETNEXT if it's registered as a
       "instance", as it's "magically" handled for us.  */

    /* a instance handler also only hands us one request at a time, so
       we don't need to loop over a list of requests; we'll only get one. */

    switch(reqinfo->mode) {

        case MODE_GET:
            if (!(in = fopen(BR_ADDRESSFILE, "r"))) {
                snmp_log(LOG_ERR,"could not open %s \n", BR_ADDRESSFILE);
                return -2;
            }

            fgets(line, sizeof(line), in);
            fclose(in);

            /* convert string to mac address */
            numScanned = sscanf(line, "%x%*[:.]%x%*[:.]%x%*[:.]%x%*[:.]%x%*[:.]%x%n",
                                    &(values[0]), &(values[1]), &(values[2]),
                                    &(values[3]), &(values[4]), &(values[5]), &numRead);
            if(numScanned != 6)
            {
                snmp_log(LOG_ERR,"%s: Bad Macaddress, get %d hex number.\n", __FUNCTION__, numScanned);
                numScanned = 0;
            } else {
                for(i = 0; i< numScanned; i++)
                {
                    bridgeAddress[i] = values[i] & 0xff;
                }
            }
            snmp_set_var_typed_value(requests->requestvb, ASN_OCTET_STR,
                     bridgeAddress /* XXX: a pointer to the scalar's data */,
                     numScanned/* XXX: the length of the data in bytes */);
            break;


        default:
            /* we should never get here, so this is a really bad error */
            snmp_log(LOG_ERR, "unknown mode (%d) in handle_dot1dBaseBridgeAddress\n", reqinfo->mode );
            return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}
int
handle_dot1dBaseNumPorts(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info   *reqinfo,
                          netsnmp_request_info         *requests)
{
    struct dirent **namelist;
    int i, dirCount = 0;
    int ifCount = 0;
    char SYSFS_CLASS_NET_BR_IF[64] = {0};

    if (getErouterAdminMode() == 1)
        strcpy(SYSFS_CLASS_NET_BR_IF, SYSFS_CLASS_NET_BR_IF_BRIDGE);
    else
        strcpy(SYSFS_CLASS_NET_BR_IF, SYSFS_CLASS_NET_BR_IF_ROUTER);

    /* We are never called for a GETNEXT if it's registered as a
       "instance", as it's "magically" handled for us.  */

    /* a instance handler also only hands us one request at a time, so
       we don't need to loop over a list of requests; we'll only get one. */

    switch(reqinfo->mode) {

        case MODE_GET:
            dirCount = scandir(SYSFS_CLASS_NET_BR_IF, &namelist, NULL, alphasort);
            if (dirCount < 0)
                return -1;

            for (i = 0; i < dirCount; i++)
            {
                if (namelist[i]->d_name[0] == '.'
                        && (namelist[i]->d_name[1] == '\0'
                        || (namelist[i]->d_name[1] == '.'
                        && namelist[i]->d_name[2] == '\0')))
                {
                    /* Ignore "." and ".." */
                } else {
                    ifCount++;
                }

                free(namelist[i]);
            }
            free(namelist);

            snmp_set_var_typed_value(requests->requestvb, ASN_INTEGER,
                                     &ifCount /* XXX: a pointer to the scalar's data */,
                                     sizeof(ifCount)/* XXX: the length of the data in bytes */);
            break;


        default:
            /* we should never get here, so this is a really bad error */
            snmp_log(LOG_ERR, "unknown mode (%d) in handle_dot1dBaseNumPorts\n", reqinfo->mode );
            return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}
int
handle_dot1dBaseType(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info   *reqinfo,
                          netsnmp_request_info         *requests)
{
    int value;

    /* We are never called for a GETNEXT if it's registered as a
       "instance", as it's "magically" handled for us.  */

    /* a instance handler also only hands us one request at a time, so
       we don't need to loop over a list of requests; we'll only get one. */

    switch(reqinfo->mode) {

        case MODE_GET:
            value = 2; /* transparent-only */
            snmp_set_var_typed_value(requests->requestvb, ASN_INTEGER,
                                     &value /* XXX: a pointer to the scalar's data */,
                                     sizeof(value) /* XXX: the length of the data in bytes */);
            break;


        default:
            /* we should never get here, so this is a really bad error */
            snmp_log(LOG_ERR, "unknown mode (%d) in handle_dot1dBaseType\n", reqinfo->mode );
            return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}
int
handle_dot1dTpLearnedEntryDiscards(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info   *reqinfo,
                          netsnmp_request_info         *requests)
{
    int value;
    /* We are never called for a GETNEXT if it's registered as a
       "instance", as it's "magically" handled for us.  */

    /* a instance handler also only hands us one request at a time, so
       we don't need to loop over a list of requests; we'll only get one. */

    switch(reqinfo->mode) {

        case MODE_GET:
            /* There is no LearnedEntryDiscards in Linux, we simply set it with 0 */
            value = 0;
            snmp_set_var_typed_value(requests->requestvb, ASN_COUNTER,
                                     &value/* XXX: a pointer to the scalar's data */,
                                     sizeof(value)/* XXX: the length of the data in bytes */);
            break;


        default:
            /* we should never get here, so this is a really bad error */
            snmp_log(LOG_ERR, "unknown mode (%d) in handle_dot1dTpLearnedEntryDiscards\n", reqinfo->mode );
            return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}
int
handle_dot1dTpAgingTime(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info   *reqinfo,
                          netsnmp_request_info         *requests)
{
    int ret;
    unsigned long agingTime;
    FILE *f;
    char AGINGTIME_FILE[64] = {0};

    if (getErouterAdminMode() == 1)
        strcpy(AGINGTIME_FILE, AGINGTIME_FILE_BRIDGE);
    else
        strcpy(AGINGTIME_FILE, AGINGTIME_FILE_ROUTER);

    /* We are never called for a GETNEXT if it's registered as a
       "instance", as it's "magically" handled for us.  */

    /* a instance handler also only hands us one request at a time, so
       we don't need to loop over a list of requests; we'll only get one. */
    switch(reqinfo->mode) {

        case MODE_GET:
            if (!(f = fopen(AGINGTIME_FILE, "r"))) {
                snmp_log(LOG_ERR,"could not open %s\n", AGINGTIME_FILE);
                return -2;
            }
            ret = fscanf(f, "%ld", &agingTime);
            fclose(f);
            if(ret < 0)
            {
                snmp_log(LOG_ERR,"get ageing_time from %s failed\n", AGINGTIME_FILE);
                return ret;
            }
            /* convert to seconds */
            agingTime /= sysconf(_SC_CLK_TCK);

            snmp_set_var_typed_value(requests->requestvb, ASN_INTEGER,
                                     &agingTime /* XXX: a pointer to the scalar's data */,
                                     sizeof(agingTime)/* XXX: the length of the data in bytes */);
            break;

        /*
         * SET REQUEST
         *
         * multiple states in the transaction.  See:
         * http://www.net-snmp.org/tutorial-5/toolkit/mib_module/set-actions.jpg
         */
        case MODE_SET_RESERVE1:
                /* or you could use netsnmp_check_vb_type_and_size instead */
            ret = netsnmp_check_vb_type(requests->requestvb, ASN_INTEGER);
            if ( ret != SNMP_ERR_NOERROR ) {
                netsnmp_set_request_error(reqinfo, requests, ret );
            }
            break;

        case MODE_SET_RESERVE2:
            /* XXX malloc "undo" storage buffer */
            if (0) {
                netsnmp_set_request_error(reqinfo, requests, SNMP_ERR_RESOURCEUNAVAILABLE);
            }
            break;

        case MODE_SET_FREE:
            /* XXX: free resources allocated in RESERVE1 and/or
               RESERVE2.  Something failed somewhere, and the states
               below won't be called. */
            break;

        case MODE_SET_ACTION:
            /* XXX: perform the value change here */
            agingTime = *requests->requestvb->val.integer;
            /* convert seconds to clock ticks */
            agingTime *= sysconf(_SC_CLK_TCK);
            if (!(f = fopen(AGINGTIME_FILE, "w"))) {
                snmp_log(LOG_ERR,"could not open %s\n", AGINGTIME_FILE);
                return -2;
            }

            ret = fprintf(f, "%ld\n", agingTime);
            if(ret < 0)
            {
                snmp_log(LOG_ERR,"write ageing_time %lu to %s failed\n", agingTime, AGINGTIME_FILE);
            }
            fclose(f);

            break;

        case MODE_SET_COMMIT:
            /* XXX: delete temporary storage */
            if (0) {
                /* try _really_really_ hard to never get to this point */
                netsnmp_set_request_error(reqinfo, requests, SNMP_ERR_COMMITFAILED);
            }
            break;

        case MODE_SET_UNDO:
            /* XXX: UNDO and return to previous value for the object */
            if (0) {
                /* try _really_really_ hard to never get to this point */
                netsnmp_set_request_error(reqinfo, requests, SNMP_ERR_UNDOFAILED);
            }
            break;

        default:
            /* we should never get here, so this is a really bad error */
            snmp_log(LOG_ERR, "unknown mode (%d) in handle_dot1dTpAgingTime\n", reqinfo->mode );
            return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}

/** Initialize the dot1dBasePortTable table by defining its contents and how it's structured */
void
initialize_table_dot1dBasePortTable(void)
{
    const oid dot1dBasePortTable_oid[] = {1,3,6,1,2,1,17,1,4};
    const size_t dot1dBasePortTable_oid_len   = OID_LENGTH(dot1dBasePortTable_oid);
    netsnmp_handler_registration    *reg;
    netsnmp_iterator_info           *iinfo;
    netsnmp_table_registration_info *table_info;

    DEBUGMSGTL(("dot1d_bridge:init", "initializing table dot1dBasePortTable\n"));

    reg = netsnmp_create_handler_registration(
              "dot1dBasePortTable",     dot1dBasePortTable_handler,
              dot1dBasePortTable_oid, dot1dBasePortTable_oid_len,
              HANDLER_CAN_RONLY
              );

    table_info = SNMP_MALLOC_TYPEDEF( netsnmp_table_registration_info );
    netsnmp_table_helper_add_indexes(table_info,
                           ASN_INTEGER,  /* index: dot1dBasePort */
                           0);
    table_info->min_column = COLUMN_DOT1DBASEPORT;
    table_info->max_column = COLUMN_DOT1DBASEPORTMTUEXCEEDEDDISCARDS;

    iinfo = SNMP_MALLOC_TYPEDEF( netsnmp_iterator_info );
    iinfo->get_first_data_point = dot1dBasePortTable_get_first_data_point;
    iinfo->get_next_data_point  = dot1dBasePortTable_get_next_data_point;
    iinfo->table_reginfo        = table_info;

    netsnmp_register_table_iterator( reg, iinfo );

    /* Initialise the contents of the table here */
}

    /* Typical data structure for a row entry */
struct dot1dBasePortTable_entry {
    /* Index values */
    long dot1dBasePort;

    /* Column values */
    long dot1dBasePortIfIndex;
    oid dot1dBasePortCircuit[NNN];
    size_t dot1dBasePortCircuit_len;
    u_long dot1dBasePortDelayExceededDiscards;
    u_long dot1dBasePortMtuExceededDiscards;

    /* Illustrate using a simple linked list */
    int   valid;
    struct dot1dBasePortTable_entry *next;
};

struct dot1dBasePortTable_entry  *dot1dBasePortTable_head;

/* create a new row in the (unsorted) table */
struct dot1dBasePortTable_entry *
dot1dBasePortTable_createEntry(
                 long  dot1dBasePort
                ) {
    struct dot1dBasePortTable_entry *entry;

    entry = SNMP_MALLOC_TYPEDEF(struct dot1dBasePortTable_entry);
    if (!entry)
        return NULL;

    entry->dot1dBasePort = dot1dBasePort;
    entry->next = dot1dBasePortTable_head;
    dot1dBasePortTable_head = entry;
    return entry;
}

/* remove a row from the table */
void
dot1dBasePortTable_removeEntry( struct dot1dBasePortTable_entry *entry ) {
    struct dot1dBasePortTable_entry *ptr, *prev;

    if (!entry)
        return;    /* Nothing to remove */

    for ( ptr  = dot1dBasePortTable_head, prev = NULL;
          ptr != NULL;
          prev = ptr, ptr = ptr->next ) {
        if ( ptr == entry )
            break;
    }
    if ( !ptr )
        return;    /* Can't find it */

    if ( prev == NULL )
        dot1dBasePortTable_head = ptr->next;
    else
        prev->next = ptr->next;

    SNMP_FREE( entry );   /* XXX - release any other internal resources */
}

#define DOT1DBASEPORTTABLE_REBUILD_TIME  (5) /* in seconds */
static struct timeval   dot1dBasePortTable_rebuildTime;

/** Rebuild the dot1dBasePortTable table by defining its contents and how it's structured */

void
dot1dBasePortTable_rebuildTableData(void)
{
    struct timeval tv_now;
    struct dot1dBasePortTable_entry *entry;
    struct dirent **namelist;
    FILE *f;
    int i, dirCount = 0;
    char path[SYSFS_PATH_MAX];
    long port_no;
    int ret;
    char SYSFS_CLASS_NET_BR_IF[64] = {0};

    if (getErouterAdminMode() == 1)
        strcpy(SYSFS_CLASS_NET_BR_IF, SYSFS_CLASS_NET_BR_IF_BRIDGE);
    else
        strcpy(SYSFS_CLASS_NET_BR_IF, SYSFS_CLASS_NET_BR_IF_ROUTER);

    gettimeofday(&tv_now, NULL);

    if( tv_now.tv_sec - dot1dBasePortTable_rebuildTime.tv_sec >= DOT1DBASEPORTTABLE_REBUILD_TIME)
    {
        /*Clear the table  */
        while((entry = dot1dBasePortTable_head))
        {
            dot1dBasePortTable_removeEntry(entry);
        }

        /* rebuild the table*/
        dirCount = scandir(SYSFS_CLASS_NET_BR_IF, &namelist, NULL, alphasort);
        if (dirCount < 0)
        {
            snmp_log(LOG_ERR,"%s: scan dir %s failed\n", __FUNCTION__, SYSFS_CLASS_NET_BR_IF);
            return;
        }
        for (i = 0; i < dirCount; i++)
        {
            if (namelist[i]->d_name[0] == '.'
                    && (namelist[i]->d_name[1] == '\0'
                    || (namelist[i]->d_name[1] == '.'
                    && namelist[i]->d_name[2] == '\0')))
            {
                /* Ignore "." and ".." */
            } else {
                /* Get port number */
                snprintf(path, SYSFS_PATH_MAX, SYSFS_CLASS_NET "%s/brport/port_no", namelist[i]->d_name);
                if (!(f = fopen(path, "r"))) {
                    snmp_log(LOG_ERR,"could not open %s\n", path);
                    continue;
                }
                ret = fscanf(f, "%lx", &port_no);
                fclose(f);
                if(ret < 0)
                {
                    snmp_log(LOG_ERR,"get port_no from %s failed\n", path);
                    continue;
                }

                entry = dot1dBasePortTable_createEntry(port_no);

                /* Get If index */
                snprintf(path, SYSFS_PATH_MAX, SYSFS_CLASS_NET "%s/ifindex", namelist[i]->d_name);
                if (!(f = fopen(path, "r"))) {
                    snmp_log(LOG_ERR,"could not open %s\n", path);
                    continue;
                }
                ret = fscanf(f, "%ld", &entry->dot1dBasePortIfIndex);
                fclose(f);
                if(ret < 0)
                {
                    snmp_log(LOG_ERR,"get ifindex from %s failed\n", path);
                }


                /* we simply set dot1dBasePortCircuit to 0.0 */
                memcpy(entry->dot1dBasePortCircuit, "0.0", strlen("0.0"));
                entry->dot1dBasePortCircuit_len = strlen("0.0");

                /* Get DelayExceededDiscards */
                snprintf(path, SYSFS_PATH_MAX, SYSFS_CLASS_NET "%s/statistics/rx_over_errors", namelist[i]->d_name);
                if (!(f = fopen(path, "r"))) {
                    snmp_log(LOG_ERR,"could not open %s\n", path);
                    continue;
                }
                ret = fscanf(f, "%ld", &entry->dot1dBasePortDelayExceededDiscards);
                fclose(f);
                if(ret < 0)
                {
                    snmp_log(LOG_ERR,"get DelayExceededDiscards from %s failed\n", path);
                }

                /* Get MtuExceededDiscards */
                snprintf(path, SYSFS_PATH_MAX, SYSFS_CLASS_NET "%s/mtu", namelist[i]->d_name);
                if (!(f = fopen(path, "r"))) {
                    snmp_log(LOG_ERR,"could not open %s\n", path);
                    continue;
                }
                ret = fscanf(f, "%ld", &entry->dot1dBasePortMtuExceededDiscards);
                fclose(f);
                if(ret < 0)
                {
                    snmp_log(LOG_ERR,"get MtuExceededDiscards from %s failed\n", path);
                }

            }

            free(namelist[i]);
        }
        free(namelist);
        dot1dBasePortTable_rebuildTime = tv_now;
    }
    return;
}
/* Example iterator hook routines - using 'get_next' to do most of the work */
netsnmp_variable_list *
dot1dBasePortTable_get_first_data_point(void **my_loop_context,
                          void **my_data_context,
                          netsnmp_variable_list *put_index_data,
                          netsnmp_iterator_info *mydata)
{
    dot1dBasePortTable_rebuildTableData();
    *my_loop_context = dot1dBasePortTable_head;
    return dot1dBasePortTable_get_next_data_point(my_loop_context, my_data_context,
                                    put_index_data,  mydata );
}

netsnmp_variable_list *
dot1dBasePortTable_get_next_data_point(void **my_loop_context,
                          void **my_data_context,
                          netsnmp_variable_list *put_index_data,
                          netsnmp_iterator_info *mydata)
{
    struct dot1dBasePortTable_entry *entry = (struct dot1dBasePortTable_entry *)*my_loop_context;
    netsnmp_variable_list *idx = put_index_data;

    if ( entry ) {
        snmp_set_var_typed_integer( idx, ASN_INTEGER, entry->dot1dBasePort );
        idx = idx->next_variable;
        *my_data_context = (void *)entry;
        *my_loop_context = (void *)entry->next;
        return put_index_data;
    } else {
        return NULL;
    }
}


/** handles requests for the dot1dBasePortTable table */
int
dot1dBasePortTable_handler(
    netsnmp_mib_handler               *handler,
    netsnmp_handler_registration      *reginfo,
    netsnmp_agent_request_info        *reqinfo,
    netsnmp_request_info              *requests) {

    netsnmp_request_info       *request;
    netsnmp_table_request_info *table_info;
    struct dot1dBasePortTable_entry          *table_entry;

    DEBUGMSGTL(("dot1d_bridge:handler", "Processing request (%d)\n", reqinfo->mode));

    switch (reqinfo->mode) {
        /*
         * Read-support (also covers GetNext requests)
         */
    case MODE_GET:
        for (request=requests; request; request=request->next) {
            table_entry = (struct dot1dBasePortTable_entry *)
                              netsnmp_extract_iterator_context(request);
            table_info  =     netsnmp_extract_table_info(      request);

            switch (table_info->colnum) {
            case COLUMN_DOT1DBASEPORT:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_INTEGER,
                                            table_entry->dot1dBasePort);
                break;
            case COLUMN_DOT1DBASEPORTIFINDEX:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_INTEGER,
                                            table_entry->dot1dBasePortIfIndex);
                break;
            case COLUMN_DOT1DBASEPORTCIRCUIT:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_value( request->requestvb, ASN_OBJECT_ID,
                                          table_entry->dot1dBasePortCircuit,
                                          table_entry->dot1dBasePortCircuit_len);
                break;
            case COLUMN_DOT1DBASEPORTDELAYEXCEEDEDDISCARDS:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_COUNTER,
                                            table_entry->dot1dBasePortDelayExceededDiscards);
                break;
            case COLUMN_DOT1DBASEPORTMTUEXCEEDEDDISCARDS:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_COUNTER,
                                            table_entry->dot1dBasePortMtuExceededDiscards);
                break;
            default:
                netsnmp_set_request_error(reqinfo, request,
                                          SNMP_NOSUCHOBJECT);
                break;
            }
        }
        break;

    }
    return SNMP_ERR_NOERROR;
}
/** Initialize the dot1dTpFdbTable table by defining its contents and how it's structured */
void
initialize_table_dot1dTpFdbTable(void)
{
    const oid dot1dTpFdbTable_oid[] = {1,3,6,1,2,1,17,4,3};
    const size_t dot1dTpFdbTable_oid_len   = OID_LENGTH(dot1dTpFdbTable_oid);
    netsnmp_handler_registration    *reg;
    netsnmp_iterator_info           *iinfo;
    netsnmp_table_registration_info *table_info;

    DEBUGMSGTL(("dot1d_bridge:init", "initializing table dot1dTpFdbTable\n"));

    reg = netsnmp_create_handler_registration(
              "dot1dTpFdbTable",     dot1dTpFdbTable_handler,
              dot1dTpFdbTable_oid, dot1dTpFdbTable_oid_len,
              HANDLER_CAN_RONLY
              );

    table_info = SNMP_MALLOC_TYPEDEF( netsnmp_table_registration_info );
    netsnmp_table_helper_add_indexes(table_info,
                           ASN_PRIV_IMPLIED_OCTET_STR,  /* index: dot1dTpFdbAddress */
                           0);
    table_info->min_column = COLUMN_DOT1DTPFDBADDRESS;
    table_info->max_column = COLUMN_DOT1DTPFDBSTATUS;

    iinfo = SNMP_MALLOC_TYPEDEF( netsnmp_iterator_info );
    iinfo->get_first_data_point = dot1dTpFdbTable_get_first_data_point;
    iinfo->get_next_data_point  = dot1dTpFdbTable_get_next_data_point;
    iinfo->table_reginfo        = table_info;

    netsnmp_register_table_iterator( reg, iinfo );

    /* Initialise the contents of the table here */
}

    /* Typical data structure for a row entry */
struct dot1dTpFdbTable_entry {
    /* Index values */
    u_char dot1dTpFdbAddress[NNN];
    size_t dot1dTpFdbAddress_len;

    /* Column values */
    long dot1dTpFdbPort;
    long dot1dTpFdbStatus;

    /* Illustrate using a simple linked list */
    int   valid;
    struct dot1dTpFdbTable_entry *next;
};

struct dot1dTpFdbTable_entry  *dot1dTpFdbTable_head;

/* create a new row in the (unsorted) table */
struct dot1dTpFdbTable_entry *
dot1dTpFdbTable_createEntry(
                 char* dot1dTpFdbAddress,
                 size_t dot1dTpFdbAddress_len
                ) {
    struct dot1dTpFdbTable_entry *entry;

    entry = SNMP_MALLOC_TYPEDEF(struct dot1dTpFdbTable_entry);
    if (!entry)
        return NULL;

    memcpy(entry->dot1dTpFdbAddress, dot1dTpFdbAddress, dot1dTpFdbAddress_len);
    entry->dot1dTpFdbAddress_len = dot1dTpFdbAddress_len;
    entry->next = dot1dTpFdbTable_head;
    dot1dTpFdbTable_head = entry;
    return entry;
}

/* remove a row from the table */
void
dot1dTpFdbTable_removeEntry( struct dot1dTpFdbTable_entry *entry ) {
    struct dot1dTpFdbTable_entry *ptr, *prev;

    if (!entry)
        return;    /* Nothing to remove */

    for ( ptr  = dot1dTpFdbTable_head, prev = NULL;
          ptr != NULL;
          prev = ptr, ptr = ptr->next ) {
        if ( ptr == entry )
            break;
    }
    if ( !ptr )
        return;    /* Can't find it */

    if ( prev == NULL )
        dot1dTpFdbTable_head = ptr->next;
    else
        prev->next = ptr->next;

    SNMP_FREE( entry );   /* XXX - release any other internal resources */
}

#define DOT1DTPFDBTABLE_REBUILD_TIME  (5) /* in seconds */
static struct timeval   dot1dTpFdbTable_rebuildTime;

/** Rebuild the dot1dTpFdbTable table by defining its contents and how it's structured */

void
dot1dTpFdbTable_rebuildTableData(void)
{
    struct timeval tv_now;
    struct dot1dTpFdbTable_entry *entry;
#define CHUNK 128
    struct __fdb_entry fe[CHUNK];
    FILE *f;
    int offset = 0;
    int n, i;
    char SYSFS_CLASS_NET_BR_FORWARD[64] = {0};

    if (getErouterAdminMode() == 1)
        strcpy(SYSFS_CLASS_NET_BR_FORWARD, SYSFS_CLASS_NET_BR_FORWARD_BRIDGE);
    else
        strcpy(SYSFS_CLASS_NET_BR_FORWARD, SYSFS_CLASS_NET_BR_FORWARD_ROUTER);

    gettimeofday(&tv_now, NULL);

    if( tv_now.tv_sec - dot1dTpFdbTable_rebuildTime.tv_sec >= DOT1DTPFDBTABLE_REBUILD_TIME)
    {
        /*Clear the table  */
        while((entry = dot1dTpFdbTable_head))
        {
            dot1dTpFdbTable_removeEntry(entry);
        }

        /* rebuild the table*/
        while(1)
        {
            f = fopen(SYSFS_CLASS_NET_BR_FORWARD, "r");
            if (f) {
                fseek(f, offset*sizeof(struct __fdb_entry), SEEK_SET);
                n = fread(fe, sizeof(struct __fdb_entry), CHUNK, f);
                fclose(f);
            } else {
                /* old kernel, use ioctl */
                unsigned long args[4] = { BRCTL_GET_FDB_ENTRIES,
                              (unsigned long) fe,
                              CHUNK, offset };
                struct ifreq ifr;
                int retries = 0;
                int br_socket_fd = -1;
                if ((br_socket_fd = socket(AF_LOCAL, SOCK_STREAM, 0)) < 0)
                {
                    snmp_log(LOG_ERR, "%s: can not create socket\n", __FUNCTION__);
                    break;
                }
                if (getErouterAdminMode() == 1)
                    strcpy(ifr.ifr_name, BR_NAME_BRIDGE);
                else
                    strcpy(ifr.ifr_name, BR_NAME_ROUTER);

                ifr.ifr_data = (char *) args;

            retry:
                n = ioctl(br_socket_fd, SIOCDEVPRIVATE, &ifr);

                /* table can change during ioctl processing */
                if (n < 0 && errno == EAGAIN && ++retries < 10) {
                    sleep(0);
                    goto retry;
                }
                close(br_socket_fd);
                br_socket_fd = -1;
            }

            if(n > 0)
            {
                offset += n;
                for(i = 0; i < n; i++)
                {
                    entry = dot1dTpFdbTable_createEntry((char *)fe[i].mac_addr, 6);
                    entry->dot1dTpFdbPort = fe[i].port_no;
                    if(!(fe[i].is_local))
                        entry->dot1dTpFdbStatus = 3; /* Learned */
                    else
                        entry->dot1dTpFdbStatus = 4; /* Self */
                }
            } else {
                if(n < 0)
                {
                    snmp_log(LOG_ERR, "read of forward table failed: %s\n",
                                strerror(errno));
                }
                break;
            }
        }

        dot1dTpFdbTable_rebuildTime = tv_now;
    }
    return;
}
/* Example iterator hook routines - using 'get_next' to do most of the work */
netsnmp_variable_list *
dot1dTpFdbTable_get_first_data_point(void **my_loop_context,
                          void **my_data_context,
                          netsnmp_variable_list *put_index_data,
                          netsnmp_iterator_info *mydata)
{
    dot1dTpFdbTable_rebuildTableData();
    *my_loop_context = dot1dTpFdbTable_head;
    return dot1dTpFdbTable_get_next_data_point(my_loop_context, my_data_context,
                                    put_index_data,  mydata );
}

netsnmp_variable_list *
dot1dTpFdbTable_get_next_data_point(void **my_loop_context,
                          void **my_data_context,
                          netsnmp_variable_list *put_index_data,
                          netsnmp_iterator_info *mydata)
{
    struct dot1dTpFdbTable_entry *entry = (struct dot1dTpFdbTable_entry *)*my_loop_context;
    netsnmp_variable_list *idx = put_index_data;
    if ( entry ) {
        snmp_set_var_value( idx, entry->dot1dTpFdbAddress, entry->dot1dTpFdbAddress_len);
        idx = idx->next_variable;
        *my_data_context = (void *)entry;
        *my_loop_context = (void *)entry->next;
        return put_index_data;
    } else {
        return NULL;
    }
}


/** handles requests for the dot1dTpFdbTable table */
int
dot1dTpFdbTable_handler(
    netsnmp_mib_handler               *handler,
    netsnmp_handler_registration      *reginfo,
    netsnmp_agent_request_info        *reqinfo,
    netsnmp_request_info              *requests) {

    netsnmp_request_info       *request;
    netsnmp_table_request_info *table_info;
    struct dot1dTpFdbTable_entry          *table_entry;

    DEBUGMSGTL(("dot1d_bridge:handler", "Processing request (%d)\n", reqinfo->mode));
    switch (reqinfo->mode) {
        /*
         * Read-support (also covers GetNext requests)
         */
    case MODE_GET:
        for (request=requests; request; request=request->next) {
            table_entry = (struct dot1dTpFdbTable_entry *)
                              netsnmp_extract_iterator_context(request);
            table_info  =     netsnmp_extract_table_info(      request);

            switch (table_info->colnum) {
            case COLUMN_DOT1DTPFDBADDRESS:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_value( request->requestvb, ASN_OCTET_STR,
                                          table_entry->dot1dTpFdbAddress,
                                          table_entry->dot1dTpFdbAddress_len);
                break;
            case COLUMN_DOT1DTPFDBPORT:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_INTEGER,
                                            table_entry->dot1dTpFdbPort);
                break;
            case COLUMN_DOT1DTPFDBSTATUS:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_INTEGER,
                                            table_entry->dot1dTpFdbStatus);
                break;
            default:
                netsnmp_set_request_error(reqinfo, request,
                                          SNMP_NOSUCHOBJECT);
                break;
            }
        }
        break;

    }
    return SNMP_ERR_NOERROR;
}

/** Initialize the dot1dTpPortTable table by defining its contents and how it's structured */
void
initialize_table_dot1dTpPortTable(void)
{
    const oid dot1dTpPortTable_oid[] = {1,3,6,1,2,1,17,4,4};
    const size_t dot1dTpPortTable_oid_len   = OID_LENGTH(dot1dTpPortTable_oid);
    netsnmp_handler_registration    *reg;
    netsnmp_iterator_info           *iinfo;
    netsnmp_table_registration_info *table_info;

    DEBUGMSGTL(("dot1d_bridge:init", "initializing table dot1dTpPortTable\n"));

    reg = netsnmp_create_handler_registration(
              "dot1dTpPortTable",     dot1dTpPortTable_handler,
              dot1dTpPortTable_oid, dot1dTpPortTable_oid_len,
              HANDLER_CAN_RONLY
              );

    table_info = SNMP_MALLOC_TYPEDEF( netsnmp_table_registration_info );
    netsnmp_table_helper_add_indexes(table_info,
                           ASN_INTEGER,  /* index: dot1dTpPort */
                           0);
    table_info->min_column = COLUMN_DOT1DTPPORT;
    table_info->max_column = COLUMN_DOT1DTPPORTINDISCARDS;

    iinfo = SNMP_MALLOC_TYPEDEF( netsnmp_iterator_info );
    iinfo->get_first_data_point = dot1dTpPortTable_get_first_data_point;
    iinfo->get_next_data_point  = dot1dTpPortTable_get_next_data_point;
    iinfo->table_reginfo        = table_info;

    netsnmp_register_table_iterator( reg, iinfo );

    /* Initialise the contents of the table here */
}

    /* Typical data structure for a row entry */
struct dot1dTpPortTable_entry {
    /* Index values */
    long dot1dTpPort;

    /* Column values */
    long dot1dTpPortMaxInfo;
    u_long dot1dTpPortInFrames;
    u_long dot1dTpPortOutFrames;
    u_long dot1dTpPortInDiscards;

    /* Illustrate using a simple linked list */
    int   valid;
    struct dot1dTpPortTable_entry *next;
};

struct dot1dTpPortTable_entry  *dot1dTpPortTable_head;

/* create a new row in the (unsorted) table */
struct dot1dTpPortTable_entry *
dot1dTpPortTable_createEntry(
                 long  dot1dTpPort
                ) {
    struct dot1dTpPortTable_entry *entry;

    entry = SNMP_MALLOC_TYPEDEF(struct dot1dTpPortTable_entry);
    if (!entry)
        return NULL;

    entry->dot1dTpPort = dot1dTpPort;
    entry->next = dot1dTpPortTable_head;
    dot1dTpPortTable_head = entry;
    return entry;
}

/* remove a row from the table */
void
dot1dTpPortTable_removeEntry( struct dot1dTpPortTable_entry *entry ) {
    struct dot1dTpPortTable_entry *ptr, *prev;

    if (!entry)
        return;    /* Nothing to remove */

    for ( ptr  = dot1dTpPortTable_head, prev = NULL;
          ptr != NULL;
          prev = ptr, ptr = ptr->next ) {
        if ( ptr == entry )
            break;
    }
    if ( !ptr )
        return;    /* Can't find it */

    if ( prev == NULL )
        dot1dTpPortTable_head = ptr->next;
    else
        prev->next = ptr->next;

    SNMP_FREE( entry );   /* XXX - release any other internal resources */
}

#define DOT1DTPPORTTABLE_REBUILD_TIME  (5) /* in seconds */
static struct timeval   dot1dTpPortTable_rebuildTime;

/** Rebuild the dot1dTpPortTable table by defining its contents and how it's structured */

void
dot1dTpPortTable_rebuildTableData(void)
{
    struct timeval tv_now;
    struct dot1dTpPortTable_entry *entry;
    struct dirent **namelist;
    FILE *f;
    int i, dirCount = 0;
    char path[SYSFS_PATH_MAX];
    long port_no;
    int ret;
    char SYSFS_CLASS_NET_BR_IF[64] = {0};

    if (getErouterAdminMode() == 1)
        strcpy(SYSFS_CLASS_NET_BR_IF, SYSFS_CLASS_NET_BR_IF_BRIDGE);
    else
        strcpy(SYSFS_CLASS_NET_BR_IF, SYSFS_CLASS_NET_BR_IF_ROUTER);

    gettimeofday(&tv_now, NULL);

    if( tv_now.tv_sec - dot1dTpPortTable_rebuildTime.tv_sec >= DOT1DTPPORTTABLE_REBUILD_TIME)
    {
        /*Clear the table  */
        while((entry = dot1dTpPortTable_head))
        {
            dot1dTpPortTable_removeEntry(entry);
        }

        /* rebuild the table*/
        dirCount = scandir(SYSFS_CLASS_NET_BR_IF, &namelist, NULL, alphasort);
        if (dirCount < 0)
        {
            snmp_log(LOG_ERR,"%s: scan dir %s failed\n", __FUNCTION__, SYSFS_CLASS_NET_BR_IF);
            return;
        }
        for (i = 0; i < dirCount; i++)
        {
            if (namelist[i]->d_name[0] == '.'
                    && (namelist[i]->d_name[1] == '\0'
                    || (namelist[i]->d_name[1] == '.'
                    && namelist[i]->d_name[2] == '\0')))
            {
                /* Ignore "." and ".." */
            } else {
                /* Get port number */
                snprintf(path, SYSFS_PATH_MAX, SYSFS_CLASS_NET "%s/brport/port_no", namelist[i]->d_name);
                if (!(f = fopen(path, "r"))) {
                    snmp_log(LOG_ERR,"could not open %s\n", path);
                    continue;
                }
                ret = fscanf(f, "%lx", &port_no);
                fclose(f);
                if(ret < 0)
                {
                    snmp_log(LOG_ERR,"get port_no from %s failed\n", path);
                    continue;
                }

                entry = dot1dTpPortTable_createEntry(port_no);
                /* Get dot1dTpPortMaxInfo */
                snprintf(path, SYSFS_PATH_MAX, SYSFS_CLASS_NET "%s/mtu", namelist[i]->d_name);
                if (!(f = fopen(path, "r"))) {
                    snmp_log(LOG_ERR,"could not open %s\n", path);
                    continue;
                }
                ret = fscanf(f, "%ld", &entry->dot1dTpPortMaxInfo);
                fclose(f);
                if(ret < 0)
                {
                    snmp_log(LOG_ERR,"get dot1dTpPortMaxInfo from %s failed\n", path);
                }

                /* Get dot1dTpPortInFrames */
                snprintf(path, SYSFS_PATH_MAX, SYSFS_CLASS_NET "%s/statistics/rx_packets", namelist[i]->d_name);
                if (!(f = fopen(path, "r"))) {
                    snmp_log(LOG_ERR,"could not open %s\n", path);
                    continue;
                }
                ret = fscanf(f, "%ld", &entry->dot1dTpPortInFrames);
                fclose(f);
                if(ret < 0)
                {
                    snmp_log(LOG_ERR,"get dot1dTpPortInFrames from %s failed\n", path);
                }

                /* Get dot1dTpPortOutFrames */
                snprintf(path, SYSFS_PATH_MAX, SYSFS_CLASS_NET "%s/statistics/tx_packets", namelist[i]->d_name);
                if (!(f = fopen(path, "r"))) {
                    snmp_log(LOG_ERR,"could not open %s\n", path);
                    continue;
                }
                ret = fscanf(f, "%ld", &entry->dot1dTpPortOutFrames);
                fclose(f);
                if(ret < 0)
                {
                    snmp_log(LOG_ERR,"get dot1dTpPortOutFrames from %s failed\n", path);
                }

                /* Get dot1dTpPortInDiscards */
                snprintf(path, SYSFS_PATH_MAX, SYSFS_CLASS_NET "%s/statistics/rx_dropped", namelist[i]->d_name);
                if (!(f = fopen(path, "r"))) {
                    snmp_log(LOG_ERR,"could not open %s\n", path);
                    continue;
                }
                ret = fscanf(f, "%ld", &entry->dot1dTpPortInDiscards);
                fclose(f);
                if(ret < 0)
                {
                    snmp_log(LOG_ERR,"get dot1dTpPortInDiscards from %s failed\n", path);
                }

            }

            free(namelist[i]);
        }
        free(namelist);
        dot1dTpPortTable_rebuildTime = tv_now;
    }
    return;
}
/* Example iterator hook routines - using 'get_next' to do most of the work */
netsnmp_variable_list *
dot1dTpPortTable_get_first_data_point(void **my_loop_context,
                          void **my_data_context,
                          netsnmp_variable_list *put_index_data,
                          netsnmp_iterator_info *mydata)
{
    dot1dTpPortTable_rebuildTableData();
    *my_loop_context = dot1dTpPortTable_head;
    return dot1dTpPortTable_get_next_data_point(my_loop_context, my_data_context,
                                    put_index_data,  mydata );
}

netsnmp_variable_list *
dot1dTpPortTable_get_next_data_point(void **my_loop_context,
                          void **my_data_context,
                          netsnmp_variable_list *put_index_data,
                          netsnmp_iterator_info *mydata)
{
    struct dot1dTpPortTable_entry *entry = (struct dot1dTpPortTable_entry *)*my_loop_context;
    netsnmp_variable_list *idx = put_index_data;
    if ( entry ) {
        snmp_set_var_typed_integer( idx, ASN_INTEGER, entry->dot1dTpPort );
        idx = idx->next_variable;
        *my_data_context = (void *)entry;
        *my_loop_context = (void *)entry->next;
        return put_index_data;
    } else {
        return NULL;
    }
}


/** handles requests for the dot1dTpPortTable table */
int
dot1dTpPortTable_handler(
    netsnmp_mib_handler               *handler,
    netsnmp_handler_registration      *reginfo,
    netsnmp_agent_request_info        *reqinfo,
    netsnmp_request_info              *requests) {

    netsnmp_request_info       *request;
    netsnmp_table_request_info *table_info;
    struct dot1dTpPortTable_entry          *table_entry;

    DEBUGMSGTL(("dot1d_bridge:handler", "Processing request (%d)\n", reqinfo->mode));

    switch (reqinfo->mode) {
        /*
         * Read-support (also covers GetNext requests)
         */
    case MODE_GET:
        for (request=requests; request; request=request->next) {
            table_entry = (struct dot1dTpPortTable_entry *)
                              netsnmp_extract_iterator_context(request);
            table_info  =     netsnmp_extract_table_info(      request);

            switch (table_info->colnum) {
            case COLUMN_DOT1DTPPORT:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_INTEGER,
                                            table_entry->dot1dTpPort);
                break;
            case COLUMN_DOT1DTPPORTMAXINFO:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_INTEGER,
                                            table_entry->dot1dTpPortMaxInfo);
                break;
            case COLUMN_DOT1DTPPORTINFRAMES:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_COUNTER,
                                            table_entry->dot1dTpPortInFrames);
                break;
            case COLUMN_DOT1DTPPORTOUTFRAMES:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_COUNTER,
                                            table_entry->dot1dTpPortOutFrames);
                break;
            case COLUMN_DOT1DTPPORTINDISCARDS:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_COUNTER,
                                            table_entry->dot1dTpPortInDiscards);
                break;
            default:
                netsnmp_set_request_error(reqinfo, request,
                                          SNMP_NOSUCHOBJECT);
                break;
            }
        }
        break;

    }
    return SNMP_ERR_NOERROR;
}
