/*
 * Note: this file originally auto-generated by mib2c
 * using mib2c.iterate.conf
 */

#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>
#include "brcm_wifi_mgmt.h"
#include "bcm_net_snmp.h"

#define NNN 256

/* ifIndex functions */
/*(1=Disabled, 2=IPv4, 3=IPv6, 4=DualIP)*/
int getRgIpProvMode()
{
#if defined(BUILD_CERTIFICATION) || defined(BUILD_BRIDGE)
   return 1;
#else
   return 4;
#endif
}

int getIntIfTableIfindexByName(const char * ifName)
{
    int rgAdminMode;

    if (!ifName)
        return 0;

    rgAdminMode = getRgIpProvMode();
    if(rgAdminMode != 1)
    {
       /*Mute Wifi interfaces for no wifi build*/
        if(strcmp(ifName, "radio_wl0") == 0)
          return RGIFINDEX_RADIO_WL0;
        else  if(strcmp(ifName, "wl0") == 0)
          return RGIFINDEX_WL0;
        else  if(strcmp(ifName, "wl0.1") == 0)
          return RGIFINDEX_WL0_1;
        else  if(strcmp(ifName, "wl0.2") == 0)
          return RGIFINDEX_WL0_2;
        else  if(strcmp(ifName, "wl0.3") == 0)
          return RGIFINDEX_WL0_3;
        else  if(strcmp(ifName, "wl0.4") == 0)
          return RGIFINDEX_WL0_4;
        else  if(strcmp(ifName, "wl0.5") == 0)
          return RGIFINDEX_WL0_5;
        else  if(strcmp(ifName, "wl0.6") == 0)
            return RGIFINDEX_WL0_6;
        else  if(strcmp(ifName, "wl0.7") == 0)
          return RGIFINDEX_WL0_7;
        else  if(strcmp(ifName, "radio_wl1") == 0)
          return RGIFINDEX_RADIO_WL1;
        else  if(strcmp(ifName, "wl1") == 0)
          return RGIFINDEX_WL1;
        else  if(strcmp(ifName, "wl1.1") == 0)
          return RGIFINDEX_WL1_1;
        else  if(strcmp(ifName, "wl1.2") == 0)
          return RGIFINDEX_WL1_2;
        else  if(strcmp(ifName, "wl1.3") == 0)
          return RGIFINDEX_WL1_3;
        else  if(strcmp(ifName, "wl1.4") == 0)
          return RGIFINDEX_WL1_4;
        else  if(strcmp(ifName, "wl1.5") == 0)
          return RGIFINDEX_WL1_5;
        else  if(strcmp(ifName, "wl1.6") == 0)
          return RGIFINDEX_WL1_6;
        else  if(strcmp(ifName, "wl1.7") == 0)
          return RGIFINDEX_WL1_7;
        else  if(strcmp(ifName, "radio_wl2") == 0)
          return RGIFINDEX_RADIO_WL2;
        else  if(strcmp(ifName, "wl2") == 0)
          return RGIFINDEX_WL2;
        else  if(strcmp(ifName, "wl2.1") == 0)
          return RGIFINDEX_WL2_1;
        else  if(strcmp(ifName, "wl2.2") == 0)
          return RGIFINDEX_WL2_2;
        else  if(strcmp(ifName, "wl2.3") == 0)
          return RGIFINDEX_WL2_3;
        else  if(strcmp(ifName, "wl2.4") == 0)
          return RGIFINDEX_WL2_4;
        else  if(strcmp(ifName, "wl2.5") == 0)
            return RGIFINDEX_WL2_5;
        else  if(strcmp(ifName, "wl2.6") == 0)
          return RGIFINDEX_WL2_6;
        else  if(strcmp(ifName, "wl2.7") == 0)
          return RGIFINDEX_WL2_7;
        else
          return 0; /*Don't report this */
    } else {
    /*in rg bridge/disable mode*/
        /*Mute Wifi interfaces for no wifi build*/
        if(strcmp(ifName, "radio_wl0") == 0)
          return RGIFINDEX_DISABLE_RADIO_WL0;
        else  if(strcmp(ifName, "wl0") == 0)
          return RGIFINDEX_DISABLE_WL0;
        else  if(strcmp(ifName, "wl0.1") == 0)
          return RGIFINDEX_DISABLE_WL0_1;
        else  if(strcmp(ifName, "wl0.2") == 0)
            return RGIFINDEX_DISABLE_WL0_2;
        else  if(strcmp(ifName, "wl0.3") == 0)
          return RGIFINDEX_DISABLE_WL0_3;
        else  if(strcmp(ifName, "wl0.4") == 0)
          return RGIFINDEX_DISABLE_WL0_4;
        else  if(strcmp(ifName, "wl0.5") == 0)
          return RGIFINDEX_DISABLE_WL0_5;
        else  if(strcmp(ifName, "wl0.6") == 0)
          return RGIFINDEX_DISABLE_WL0_6;
        else  if(strcmp(ifName, "wl0.7") == 0)
          return RGIFINDEX_DISABLE_WL0_7;
        else  if(strcmp(ifName, "radio_wl1") == 0)
          return RGIFINDEX_DISABLE_RADIO_WL1;
        else  if(strcmp(ifName, "wl1") == 0)
          return RGIFINDEX_DISABLE_WL1;
        else  if(strcmp(ifName, "wl1.1") == 0)
          return RGIFINDEX_DISABLE_WL1_1;
        else  if(strcmp(ifName, "wl1.2") == 0)
          return RGIFINDEX_DISABLE_WL1_2;
        else  if(strcmp(ifName, "wl1.3") == 0)
          return RGIFINDEX_DISABLE_WL1_3;
        else  if(strcmp(ifName, "wl1.4") == 0)
          return RGIFINDEX_DISABLE_WL1_4;
        else  if(strcmp(ifName, "wl1.5") == 0)
          return RGIFINDEX_DISABLE_WL1_5;
        else  if(strcmp(ifName, "wl1.6") == 0)
          return RGIFINDEX_DISABLE_WL1_6;
        else  if(strcmp(ifName, "wl1.7") == 0)
          return RGIFINDEX_DISABLE_WL1_7;
        else  if(strcmp(ifName, "radio_wl2") == 0)
          return RGIFINDEX_DISABLE_RADIO_WL2;
        else  if(strcmp(ifName, "wl2") == 0)
          return RGIFINDEX_DISABLE_WL2;
        else  if(strcmp(ifName, "wl2.1") == 0)
            return RGIFINDEX_DISABLE_WL2_1;
        else  if(strcmp(ifName, "wl2.2") == 0)
          return RGIFINDEX_DISABLE_WL2_2;
        else  if(strcmp(ifName, "wl2.3") == 0)
          return RGIFINDEX_DISABLE_WL2_3;
        else  if(strcmp(ifName, "wl2.4") == 0)
          return RGIFINDEX_DISABLE_WL2_4;
        else  if(strcmp(ifName, "wl2.5") == 0)
          return RGIFINDEX_DISABLE_WL2_5;
        else  if(strcmp(ifName, "wl2.6") == 0)
          return RGIFINDEX_DISABLE_WL2_6;
        else  if(strcmp(ifName, "wl2.7") == 0)
          return RGIFINDEX_DISABLE_WL2_7;
        else
          return 0; /*Don't report this */
     }
}

char* getIfNameByIfTableIfindex(int ifIndex, char* ifName)
{
    int rgAdminMode;

    if(NULL == ifName)
        return NULL;

    if(ifIndex == 0)
        return NULL;

    rgAdminMode = getRgIpProvMode();
    if(rgAdminMode != 1)
    {
        /* Router mode */
        if(ifIndex == RGIFINDEX_WL0) {
            strcpy(ifName,"wl0");
        } else if(ifIndex == RGIFINDEX_WL0_1) {
            strcpy(ifName,"wl0.1");
        } else if(ifIndex == RGIFINDEX_WL0_2) {
            strcpy(ifName,"wl0.2");
        } else if(ifIndex == RGIFINDEX_WL0_3) {
            strcpy(ifName,"wl0.3");
        } else if(ifIndex == RGIFINDEX_WL0_4) {
            strcpy(ifName,"wl0.4");
        } else if(ifIndex == RGIFINDEX_WL0_5) {
            strcpy(ifName,"wl0.5");
        } else if(ifIndex == RGIFINDEX_WL0_6) {
            strcpy(ifName,"wl0.6");
        } else if(ifIndex == RGIFINDEX_WL0_7) {
            strcpy(ifName,"wl0.7");
        } else if(ifIndex == RGIFINDEX_WL1) {
            strcpy(ifName,"wl1");
        } else if(ifIndex == RGIFINDEX_WL1_1) {
            strcpy(ifName,"wl1.1");
        } else if(ifIndex == RGIFINDEX_WL1_2) {
            strcpy(ifName,"wl1.2");
        } else if(ifIndex == RGIFINDEX_WL1_3) {
            strcpy(ifName,"wl1.3");
        } else if(ifIndex == RGIFINDEX_WL1_4) {
            strcpy(ifName,"wl1.4");
        } else if(ifIndex == RGIFINDEX_WL1_5) {
            strcpy(ifName,"wl1.5");
        } else if(ifIndex == RGIFINDEX_WL1_6) {
            strcpy(ifName,"wl1.6");
        } else if(ifIndex == RGIFINDEX_WL1_7) {
            strcpy(ifName,"wl1.7");
        } else if(ifIndex == RGIFINDEX_WL2) {
            strcpy(ifName,"wl2");
        } else if(ifIndex == RGIFINDEX_WL2_1) {
            strcpy(ifName,"wl2.1");
        } else if(ifIndex == RGIFINDEX_WL2_2) {
            strcpy(ifName,"wl2.2");
        } else if(ifIndex == RGIFINDEX_WL2_3) {
            strcpy(ifName,"wl2.3");
        } else if(ifIndex == RGIFINDEX_WL2_4) {
            strcpy(ifName,"wl2.4");
        } else if(ifIndex == RGIFINDEX_WL2_5) {
            strcpy(ifName,"wl2.5");
        } else if(ifIndex == RGIFINDEX_WL2_6) {
            strcpy(ifName,"wl2.6");
        } else if(ifIndex == RGIFINDEX_WL2_7) {
            strcpy(ifName,"wl2.7");
        } else {
            return NULL;
        }
    } else {
        /* Disable mode */
        if(ifIndex == RGIFINDEX_DISABLE_RADIO_WL0) {
            strcpy(ifName,"radio_wl0");
        } else if(ifIndex == RGIFINDEX_DISABLE_RADIO_WL1) {
            strcpy(ifName,"radio_wl1");
        } else if(ifIndex == RGIFINDEX_DISABLE_RADIO_WL2) {
            strcpy(ifName,"radio_wl2");
        } else {
            return NULL;
        }
    }
    return ifName;
}

/** Initializes the brcm_wifi_mgmt module */
void
init_brcm_wifi_mgmt(void)
{
    const oid wifiApplySettings_oid[] = { 1,3,6,1,4,1,4413,2,2,2,1,18,1,1,1 };
    netsnmp_register_scalar(
        netsnmp_create_handler_registration("wifiApplySettings", handle_wifiApplySettings,
                               wifiApplySettings_oid, OID_LENGTH(wifiApplySettings_oid),
                               HANDLER_CAN_RWRITE
        ));
  /* here we initialize all the tables we're planning on supporting */
    initialize_table_wifiPrimaryInterfaceTable();

}

/** Initialize the wifiPrimaryInterfaceTable table by defining its contents and how it's structured */

/**
 * This flag will be set to 1(true) when any object is set in wifiPrimaryInterfaceTable.
 * And will be set to 0(false) when modifications are applied by wifiApplySettings.
 */
static int wifiPrimaryInterfaceTable_apply_flag = 0;

void
initialize_table_wifiPrimaryInterfaceTable(void)
{
    const oid wifiPrimaryInterfaceTable_oid[] = {1,3,6,1,4,1,4413,2,2,2,1,18,1,1,2};
    const size_t wifiPrimaryInterfaceTable_oid_len   = OID_LENGTH(wifiPrimaryInterfaceTable_oid);
    netsnmp_handler_registration    *reg;
    netsnmp_iterator_info           *iinfo;
    netsnmp_table_registration_info *table_info;

    DEBUGMSGTL(("brcm_wifi_mgmt:init", "initializing table wifiPrimaryInterfaceTable\n"));

    wifiPrimaryInterfaceTable_apply_flag = 0;

    reg = netsnmp_create_handler_registration(
              "wifiPrimaryInterfaceTable",     wifiPrimaryInterfaceTable_handler,
              wifiPrimaryInterfaceTable_oid, wifiPrimaryInterfaceTable_oid_len,
              HANDLER_CAN_RWRITE
              );

    table_info = SNMP_MALLOC_TYPEDEF( netsnmp_table_registration_info );
    netsnmp_table_helper_add_indexes(table_info,
                           ASN_INTEGER,  /* index: ifIndex */
                           0);
    table_info->min_column = COLUMN_WIFIOPERMODE;
    table_info->max_column = COLUMN_WIFIDEEPSLEEP;
    iinfo = SNMP_MALLOC_TYPEDEF( netsnmp_iterator_info );
    iinfo->get_first_data_point = wifiPrimaryInterfaceTable_get_first_data_point;
    iinfo->get_next_data_point  = wifiPrimaryInterfaceTable_get_next_data_point;
    iinfo->table_reginfo        = table_info;
    netsnmp_register_table_iterator( reg, iinfo );

    /* Initialise the contents of the table here */
    wifiPrimaryInterfaceTable_rebuildTableData();
}

    /* Typical data structure for a row entry */
struct wifiPrimaryInterfaceTable_entry {
    /* Index values */
    long ifIndex;

    /* Column values */
    long wifiOperMode;
    long old_wifiOperMode;
    u_long wifiCurrentChannel;
    u_long old_wifiCurrentChannel;
    u_long wifiBeaconInterval;
    u_long old_wifiBeaconInterval;
    u_long wifiDTIMInterval;
    u_long old_wifiDTIMInterval;
    u_long wifiFragThresh;
    u_long old_wifiFragThresh;
    u_long wifiRTSThresh;
    u_long old_wifiRTSThresh;
    u_long wifiShortRetryLimit;
    u_long old_wifiShortRetryLimit;
    u_long wifiLongRetryLimit;
    u_long old_wifiLongRetryLimit;
    long wifiRate;
    long old_wifiRate;
    long wifiOutputPower;
    long wifiMbssUserControl;
    long old_wifiMbssUserControl;
    long wifiRadioEnable;
    long old_wifiRadioEnable;
    long wifiApsScan;
    long old_wifiApsScan;
    long wifiObssCoexMode;
    long old_wifiObssCoexMode;
    u_long wifiAcsdScanTimer;
    u_long old_wifiAcsdScanTimer;
    long wifiWMFEnable;
    long old_wifiWMFEnable;
    long wifiBSEnable;
    long old_wifiBSEnable;
    long wifiATFEnable;
    long old_wifiATFEnable;
    long wifiTrafficSchedulerEnable;
    long old_wifiTrafficSchedulerEnable;
    long wifiEbosEnable;
    long old_wifiEbosEnable;
    u_long wifiPsPretendRetryLimit;
    u_long old_wifiPsPretendRetryLimit;
    u_long wifiPsPretendThreshold;
    u_long old_wifiPsPretendThreshold;
    u_long wifiAcsFcsMode;
    u_long old_wifiAcsFcsMode;
    u_long wifiAcsDfs;
    u_long old_wifiAcsDfs;
    u_long wifiAcsCsScanTimer;
    u_long old_wifiAcsCsScanTimer;
    u_long wifiAcsCiScanTimer;
    u_long old_wifiAcsCiScanTimer;
    u_long wifiAcsCiScanTimeout;
    u_long old_wifiAcsCiScanTimeout;
    u_long wifiAcsScanEntryExpire;
    u_long old_wifiAcsScanEntryExpire;
    u_long wifiAcsTxIdleCnt;
    u_long old_wifiAcsTxIdleCnt;
    u_long wifiAcsChanDwellTime;
    u_long old_wifiAcsChanDwellTime;
    u_long wifiAcsChanFlopPeriod;
    u_long old_wifiAcsChanFlopPeriod;
    u_long wifiAcsIntferPeriod;
    u_long old_wifiAcsIntferPeriod;
    u_long wifiAcsIntferCnt;
    u_long old_wifiAcsIntferCnt;
    u_long wifiAcsIntferTxfail;
    u_long old_wifiAcsIntferTxfail;
    u_long wifiAcsIntferTcptxfail;
    u_long old_wifiAcsIntferTcptxfail;
    u_long wifiAcsDfsrImmediateSec;
    u_long old_wifiAcsDfsrImmediateSec;
    u_long wifiAcsDfsrImmediateThr;
    u_long old_wifiAcsDfsrImmediateThr;
    u_long wifiAcsDfsrDeferredSec;
    u_long old_wifiAcsDfsrDeferredSec;
    u_long wifiAcsDfsrDeferredThr;
    u_long old_wifiAcsDfsrDeferredThr;
    u_long wifiAcsDfsrActivitySec;
    u_long old_wifiAcsDfsrActivitySec;
    u_long wifiAcsDfsrActivityThr;
    u_long old_wifiAcsDfsrActivityThr;
    char wifiACSExcludeChannels[NNN];
    size_t wifiACSExcludeChannels_len;
    char old_wifiACSExcludeChannels[NNN];
    size_t old_wifiACSExcludeChannels_len;
    u_long wifiOperatingChannel;
    long wifiDeepSleep;
    long old_wifiDeepSleep;

    /* Illustrate using a simple linked list */
    int   valid;
    struct wifiPrimaryInterfaceTable_entry *next;
};

struct wifiPrimaryInterfaceTable_entry  *wifiPrimaryInterfaceTable_head;
struct wifiPrimaryInterfaceTable_entry  *wifiPrimaryInterfaceTable_local_head = NULL;

/* create a new row in the (unsorted) table */
struct wifiPrimaryInterfaceTable_entry *
wifiPrimaryInterfaceTable_createEntry(
                 long  ifIndex
                ) {
    struct wifiPrimaryInterfaceTable_entry *entry;

    entry = SNMP_MALLOC_TYPEDEF(struct wifiPrimaryInterfaceTable_entry);
    if (!entry)
        return NULL;

    entry->ifIndex = ifIndex;
    entry->next = wifiPrimaryInterfaceTable_head;
    wifiPrimaryInterfaceTable_head = entry;
    return entry;
}

/* remove a row from the table */
void
wifiPrimaryInterfaceTable_removeEntry( struct wifiPrimaryInterfaceTable_entry *entry ) {
    struct wifiPrimaryInterfaceTable_entry *ptr, *prev;

    if (!entry)
        return;    /* Nothing to remove */

    for ( ptr  = wifiPrimaryInterfaceTable_head, prev = NULL;
          ptr != NULL;
          prev = ptr, ptr = ptr->next ) {
        if ( ptr == entry )
            break;
    }
    if ( !ptr )
        return;    /* Can't find it */

    if ( prev == NULL )
        wifiPrimaryInterfaceTable_head = ptr->next;
    else
        prev->next = ptr->next;

    SNMP_FREE( entry );   /* XXX - release any other internal resources */
}


static struct timeval   wifiPrimaryInterfaceTable_rebuildTime;

/** Rebuild the wifiPrimaryInterfaceTable table by defining its contents and how it's structured */
static int get_wl_num(void)
{
    FILE* fp = NULL;
    char *p = NULL;
    char cmd[128];
    char buf[128];
    int wl_num = 0;
    sprintf(cmd, "cat /tmp/wl_instances.txt");
    fp = popen(cmd, "r");
    if (fp) {
        p = fgets( buf, sizeof(buf), fp );
        if (p) {
            wl_num = atoi(p);
        }
        pclose(fp);
    }
    else {
        printf("%s: error open file\n",__FUNCTION__);
    }
    return wl_num;
}

static int get_wl_status(char *name)
{
    FILE* fp = NULL;
    char *p = NULL;
    char cmd[128];
    char buf[128];
    int wl_status = -1;
    sprintf(cmd, "wl -i %s isup", name);
    fp = popen(cmd, "r");
    if (fp) {
        p = fgets( buf, sizeof(buf), fp );
        if (p) {
            wl_status = atoi(p);
        }
        pclose(fp);
    }
    else {
        printf("%s: error open file\n",__FUNCTION__);
    }
    return wl_status;
}

void
wifiPrimaryInterfaceTable_rebuildTableData(void)
{
    struct timeval tv_now;
    struct wifiPrimaryInterfaceTable_entry *entry;
    int wifi_num = 0;
    int ifIndex = 0;
    char name[32];
    int i;
    int wl_status;

    gettimeofday(&tv_now, NULL);

    if( tv_now.tv_sec - wifiPrimaryInterfaceTable_rebuildTime.tv_sec >= WIFIPRIMARYINTERFACETABLE_REBUILD_TIME)
    {
        /*Clear the table  */
        while((entry = wifiPrimaryInterfaceTable_head))
        {
            wifiPrimaryInterfaceTable_removeEntry(entry);
        }
        /* rebuild the table based on the MDM */
		wifi_num = get_wl_num();
        for (i = 0; i < wifi_num; i++) {
            sprintf(name, "wl%d", i);
            ifIndex = getIntIfTableIfindexByName(name);
            if(ifIndex == 0)
            {
                snmp_log(LOG_ERR, "%s - get interface index from name[%s] failed, return %d\n",
                        __FUNCTION__, name, ifIndex);
                continue;
            }
            entry = wifiPrimaryInterfaceTable_createEntry(ifIndex);
            wl_status = get_wl_status(name);
            if(wl_status ==  1)
            {
                entry->wifiRadioEnable = SNMP_TRUE;
            } else {
                entry->wifiRadioEnable = SNMP_FALSE;
            }
        }
        wifiPrimaryInterfaceTable_rebuildTime = tv_now;
    }
    return;
}

int wifiPrimaryInterfaceTable_buildLocalTableData(void)
{
    struct wifiPrimaryInterfaceTable_entry *entry;
    struct wifiPrimaryInterfaceTable_entry *local_entry;

    if(wifiPrimaryInterfaceTable_local_head != NULL)
    {
        snmp_log(LOG_ERR, "%s - wifiPrimaryInterfaceTable_local_head was not clear last time\n", __FUNCTION__);
        return -1;
    }

    /* copy table to local cache table */
    entry  = wifiPrimaryInterfaceTable_head;
    while(entry)
    {
        local_entry = SNMP_MALLOC_TYPEDEF(struct wifiPrimaryInterfaceTable_entry);
        if (!local_entry)
        {
            goto fail;
        }
        memcpy(local_entry, entry, sizeof(struct wifiPrimaryInterfaceTable_entry));
        local_entry->next = wifiPrimaryInterfaceTable_local_head;
        wifiPrimaryInterfaceTable_local_head = local_entry;

        entry =  entry->next;
    }

    return 0;

fail:
    /* clear local table and return error */
    while(wifiPrimaryInterfaceTable_local_head)
    {
        local_entry = wifiPrimaryInterfaceTable_local_head;
        wifiPrimaryInterfaceTable_local_head = wifiPrimaryInterfaceTable_local_head->next;
        SNMP_FREE( local_entry );
    }
    return -1;
}

struct wifiPrimaryInterfaceTable_entry *
wifiPrimaryInterfaceTable_getLocalTableEntry(struct wifiPrimaryInterfaceTable_entry *table_entry)
{
    struct wifiPrimaryInterfaceTable_entry *local_entry = wifiPrimaryInterfaceTable_local_head;

    while(local_entry)
    {
        if(local_entry->ifIndex == table_entry->ifIndex)
        {
            break;
        }
        local_entry = local_entry->next;
    }

    if(local_entry == NULL)
    {
        snmp_log(LOG_ERR, "%s - can't find local table_entry for index %ld\n", __FUNCTION__, table_entry->ifIndex);
    }

    return local_entry;
}

/* Example iterator hook routines - using 'get_next' to do most of the work */
netsnmp_variable_list *
wifiPrimaryInterfaceTable_get_first_data_point(void **my_loop_context,
                          void **my_data_context,
                          netsnmp_variable_list *put_index_data,
                          netsnmp_iterator_info *mydata)
{
    wifiPrimaryInterfaceTable_rebuildTableData();
    *my_loop_context = wifiPrimaryInterfaceTable_head;
    return wifiPrimaryInterfaceTable_get_next_data_point(my_loop_context, my_data_context,
                                    put_index_data,  mydata );
}

netsnmp_variable_list *
wifiPrimaryInterfaceTable_get_next_data_point(void **my_loop_context,
                          void **my_data_context,
                          netsnmp_variable_list *put_index_data,
                          netsnmp_iterator_info *mydata)
{
    struct wifiPrimaryInterfaceTable_entry *entry = (struct wifiPrimaryInterfaceTable_entry *)*my_loop_context;
    netsnmp_variable_list *idx = put_index_data;

    if ( entry ) {
        snmp_set_var_typed_integer( idx, ASN_INTEGER, entry->ifIndex );
        idx = idx->next_variable;
        *my_data_context = (void *)entry;
        *my_loop_context = (void *)entry->next;
        return put_index_data;
    } else {
        return NULL;
    }
}

static int set_wifi_raido_enable(char *radio_name, int radio_enable)
{
    char cmd[128];
    if (radio_enable == SNMP_TRUE) {
        snprintf(cmd, sizeof(cmd), "wl -i %s up", radio_name);
    } else if (radio_enable == SNMP_FALSE) {
        snprintf(cmd, sizeof(cmd), "wlconf %s down", radio_name);
    }
    snmp_log(LOG_ERR, "cmd[%s]\n", cmd);
    return system(cmd);
}

static int set_wifi_deep_sleep(char *radio_name, int deep_sleep)
{
    char cmd[128];
    if (deep_sleep == SNMP_TRUE) {
        snprintf(cmd, sizeof(cmd), "wlconf %s power_down", radio_name);
    } else if (deep_sleep == SNMP_FALSE) {
        snprintf(cmd, sizeof(cmd), "wlconf %s power_up", radio_name);
    }
    snmp_log(LOG_ERR, "cmd[%s]\n", cmd);
    return system(cmd);
}

/** handles requests for the wifiPrimaryInterfaceTable table */
int
wifiPrimaryInterfaceTable_handler(
    netsnmp_mib_handler               *handler,
    netsnmp_handler_registration      *reginfo,
    netsnmp_agent_request_info        *reqinfo,
    netsnmp_request_info              *requests) {

    netsnmp_request_info       *request;
    netsnmp_table_request_info *table_info;
    struct wifiPrimaryInterfaceTable_entry          *table_entry;

    int ret;

    DEBUGMSGTL(("brcm_wifi_mgmt:handler", "Processing request (%d)\n", reqinfo->mode));

    switch (reqinfo->mode) {
        /*
         * Read-support (also covers GetNext requests)
         */
    case MODE_GET:
        for (request=requests; request; request=request->next) {
            table_entry = (struct wifiPrimaryInterfaceTable_entry *)
                              netsnmp_extract_iterator_context(request);
            table_info  =     netsnmp_extract_table_info(      request);

            switch (table_info->colnum) {
            case COLUMN_WIFIOPERMODE:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_INTEGER,
                                            table_entry->wifiOperMode);
                break;
            case COLUMN_WIFICURRENTCHANNEL:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_UNSIGNED,
                                            table_entry->wifiCurrentChannel);
                break;
            case COLUMN_WIFIBEACONINTERVAL:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_UNSIGNED,
                                            table_entry->wifiBeaconInterval);
                break;
            case COLUMN_WIFIDTIMINTERVAL:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_UNSIGNED,
                                            table_entry->wifiDTIMInterval);
                break;
            case COLUMN_WIFIFRAGTHRESH:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_UNSIGNED,
                                            table_entry->wifiFragThresh);
                break;
            case COLUMN_WIFIRTSTHRESH:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_UNSIGNED,
                                            table_entry->wifiRTSThresh);
                break;
            case COLUMN_WIFISHORTRETRYLIMIT:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_UNSIGNED,
                                            table_entry->wifiShortRetryLimit);
                break;
            case COLUMN_WIFILONGRETRYLIMIT:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_UNSIGNED,
                                            table_entry->wifiLongRetryLimit);
                break;
            case COLUMN_WIFIRATE:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_INTEGER,
                                            table_entry->wifiRate);
                break;
            case COLUMN_WIFIOUTPUTPOWER:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_INTEGER,
                                            table_entry->wifiOutputPower);
                break;
            case COLUMN_WIFIMBSSUSERCONTROL:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_INTEGER,
                                            table_entry->wifiMbssUserControl);
                break;
            case COLUMN_WIFIRADIOENABLE:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_INTEGER,
                                            table_entry->wifiRadioEnable);
                break;
            case COLUMN_WIFIAPSSCAN:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_INTEGER,
                                            table_entry->wifiApsScan);
                break;
            case COLUMN_WIFIOBSSCOEXMODE:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_INTEGER,
                                            table_entry->wifiObssCoexMode);
                break;
            case COLUMN_WIFIACSDSCANTIMER:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_UNSIGNED,
                                            table_entry->wifiAcsdScanTimer);
                break;
            case COLUMN_WIFIWMFENABLE:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_INTEGER,
                                            table_entry->wifiWMFEnable);
                break;
            case COLUMN_WIFIBSENABLE:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_INTEGER,
                                            table_entry->wifiBSEnable);
                break;
            case COLUMN_WIFIATFENABLE:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_INTEGER,
                                            table_entry->wifiATFEnable);
                break;
            case COLUMN_WIFITRAFFICSCHEDULERENABLE:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_INTEGER,
                                            table_entry->wifiTrafficSchedulerEnable);
                break;
            case COLUMN_WIFIEBOSENABLE:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_INTEGER,
                                            table_entry->wifiEbosEnable);
                break;
            case COLUMN_WIFIPSPRETENDRETRYLIMIT:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_UNSIGNED,
                                            table_entry->wifiPsPretendRetryLimit);
                break;
            case COLUMN_WIFIPSPRETENDTHRESHOLD:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_UNSIGNED,
                                            table_entry->wifiPsPretendThreshold);
                break;
            case COLUMN_WIFIACSFCSMODE:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_UNSIGNED,
                                            table_entry->wifiAcsFcsMode);
                break;
            case COLUMN_WIFIACSDFS:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_UNSIGNED,
                                            table_entry->wifiAcsDfs);
                break;
            case COLUMN_WIFIACSCSSCANTIMER:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_UNSIGNED,
                                            table_entry->wifiAcsCsScanTimer);
                break;
            case COLUMN_WIFIACSCISCANTIMER:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_UNSIGNED,
                                            table_entry->wifiAcsCiScanTimer);
                break;
            case COLUMN_WIFIACSCISCANTIMEOUT:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_UNSIGNED,
                                            table_entry->wifiAcsCiScanTimeout);
                break;
            case COLUMN_WIFIACSSCANENTRYEXPIRE:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_UNSIGNED,
                                            table_entry->wifiAcsScanEntryExpire);
                break;
            case COLUMN_WIFIACSTXIDLECNT:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_UNSIGNED,
                                            table_entry->wifiAcsTxIdleCnt);
                break;
            case COLUMN_WIFIACSCHANDWELLTIME:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_UNSIGNED,
                                            table_entry->wifiAcsChanDwellTime);
                break;
            case COLUMN_WIFIACSCHANFLOPPERIOD:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_UNSIGNED,
                                            table_entry->wifiAcsChanFlopPeriod);
                break;
            case COLUMN_WIFIACSINTFERPERIOD:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_UNSIGNED,
                                            table_entry->wifiAcsIntferPeriod);
                break;
            case COLUMN_WIFIACSINTFERCNT:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_UNSIGNED,
                                            table_entry->wifiAcsIntferCnt);
                break;
            case COLUMN_WIFIACSINTFERTXFAIL:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_UNSIGNED,
                                            table_entry->wifiAcsIntferTxfail);
                break;
            case COLUMN_WIFIACSINTFERTCPTXFAIL:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_UNSIGNED,
                                            table_entry->wifiAcsIntferTcptxfail);
                break;
            case COLUMN_WIFIACSDFSRIMMEDIATESEC:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_UNSIGNED,
                                            table_entry->wifiAcsDfsrImmediateSec);
                break;
            case COLUMN_WIFIACSDFSRIMMEDIATETHR:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_UNSIGNED,
                                            table_entry->wifiAcsDfsrImmediateThr);
                break;
            case COLUMN_WIFIACSDFSRDEFERREDSEC:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_UNSIGNED,
                                            table_entry->wifiAcsDfsrDeferredSec);
                break;
            case COLUMN_WIFIACSDFSRDEFERREDTHR:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_UNSIGNED,
                                            table_entry->wifiAcsDfsrDeferredThr);
                break;
            case COLUMN_WIFIACSDFSRACTIVITYSEC:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_UNSIGNED,
                                            table_entry->wifiAcsDfsrActivitySec);
                break;
            case COLUMN_WIFIACSDFSRACTIVITYTHR:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_UNSIGNED,
                                            table_entry->wifiAcsDfsrActivityThr);
                break;
            case COLUMN_WIFIACSEXCLUDECHANNELS:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_value( request->requestvb, ASN_OCTET_STR,
                                          table_entry->wifiACSExcludeChannels,
                                          table_entry->wifiACSExcludeChannels_len);
                break;
            case COLUMN_WIFIOPERATINGCHANNEL:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_UNSIGNED,
                                            table_entry->wifiOperatingChannel);
                break;
            case COLUMN_WIFIDEEPSLEEP:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_INTEGER,
                                            2);
                break;
            default:
                netsnmp_set_request_error(reqinfo, request,
                                          SNMP_NOSUCHOBJECT);
                break;
            }
        }
        break;

        /*
         * Write-support
         */
    case MODE_SET_RESERVE1:
        for (request=requests; request; request=request->next) {
            table_entry = (struct wifiPrimaryInterfaceTable_entry *)
                              netsnmp_extract_iterator_context(request);
            table_info  =     netsnmp_extract_table_info(      request);
            if(table_entry == NULL)
            {
                netsnmp_set_request_error( reqinfo, request,
                           SNMP_ERR_RESOURCEUNAVAILABLE );
                return SNMP_ERR_NOERROR;
            }

            switch (table_info->colnum) {
            case COLUMN_WIFIOPERMODE:
                /* or possibly 'netsnmp_check_vb_int_range' */
                ret = netsnmp_check_vb_int( request->requestvb );
                if ( ret != SNMP_ERR_NOERROR ) {
                    netsnmp_set_request_error( reqinfo, request, ret );
                    return SNMP_ERR_NOERROR;
                }
                break;
            case COLUMN_WIFICURRENTCHANNEL:
                /* or possibly 'netsnmp_check_vb_int_range' */
                ret = netsnmp_check_vb_int( request->requestvb );
                if ( ret != SNMP_ERR_NOERROR ) {
                    netsnmp_set_request_error( reqinfo, request, ret );
                    return SNMP_ERR_NOERROR;
                }
                break;
            case COLUMN_WIFIBEACONINTERVAL:
                /* or possibly 'netsnmp_check_vb_int_range' */
                ret = netsnmp_check_vb_int( request->requestvb );
                if ( ret != SNMP_ERR_NOERROR ) {
                    netsnmp_set_request_error( reqinfo, request, ret );
                    return SNMP_ERR_NOERROR;
                }
                break;
            case COLUMN_WIFIDTIMINTERVAL:
                /* or possibly 'netsnmp_check_vb_int_range' */
                ret = netsnmp_check_vb_int( request->requestvb );
                if ( ret != SNMP_ERR_NOERROR ) {
                    netsnmp_set_request_error( reqinfo, request, ret );
                    return SNMP_ERR_NOERROR;
                }
                break;
            case COLUMN_WIFIFRAGTHRESH:
                /* or possibly 'netsnmp_check_vb_int_range' */
                ret = netsnmp_check_vb_int( request->requestvb );
                if ( ret != SNMP_ERR_NOERROR ) {
                    netsnmp_set_request_error( reqinfo, request, ret );
                    return SNMP_ERR_NOERROR;
                }
                break;
            case COLUMN_WIFIRTSTHRESH:
                /* or possibly 'netsnmp_check_vb_int_range' */
                ret = netsnmp_check_vb_int( request->requestvb );
                if ( ret != SNMP_ERR_NOERROR ) {
                    netsnmp_set_request_error( reqinfo, request, ret );
                    return SNMP_ERR_NOERROR;
                }
                break;
            case COLUMN_WIFISHORTRETRYLIMIT:
                /* or possibly 'netsnmp_check_vb_int_range' */
                ret = netsnmp_check_vb_int( request->requestvb );
                if ( ret != SNMP_ERR_NOERROR ) {
                    netsnmp_set_request_error( reqinfo, request, ret );
                    return SNMP_ERR_NOERROR;
                }
                break;
            case COLUMN_WIFILONGRETRYLIMIT:
                /* or possibly 'netsnmp_check_vb_int_range' */
                ret = netsnmp_check_vb_int( request->requestvb );
                if ( ret != SNMP_ERR_NOERROR ) {
                    netsnmp_set_request_error( reqinfo, request, ret );
                    return SNMP_ERR_NOERROR;
                }
                break;
            case COLUMN_WIFIRATE:
                /* or possibly 'netsnmp_check_vb_int_range' */
                ret = netsnmp_check_vb_int( request->requestvb );
                if ( ret != SNMP_ERR_NOERROR ) {
                    netsnmp_set_request_error( reqinfo, request, ret );
                    return SNMP_ERR_NOERROR;
                }
                break;
            case COLUMN_WIFIMBSSUSERCONTROL:
                /* or possibly 'netsnmp_check_vb_int_range' */
                ret = netsnmp_check_vb_int( request->requestvb );
                if ( ret != SNMP_ERR_NOERROR ) {
                    netsnmp_set_request_error( reqinfo, request, ret );
                    return SNMP_ERR_NOERROR;
                }
                break;
            case COLUMN_WIFIRADIOENABLE:
                /* or possibly 'netsnmp_check_vb_int_range' */
                ret = netsnmp_check_vb_int( request->requestvb );
                if ( ret != SNMP_ERR_NOERROR ) {
                    netsnmp_set_request_error( reqinfo, request, ret );
                    return SNMP_ERR_NOERROR;
                }
                break;
            case COLUMN_WIFIAPSSCAN:
                /* or possibly 'netsnmp_check_vb_int_range' */
                ret = netsnmp_check_vb_int( request->requestvb );
                if ( ret != SNMP_ERR_NOERROR ) {
                    netsnmp_set_request_error( reqinfo, request, ret );
                    return SNMP_ERR_NOERROR;
                }
                break;
            case COLUMN_WIFIOBSSCOEXMODE:
                /* or possibly 'netsnmp_check_vb_int_range' */
                ret = netsnmp_check_vb_int( request->requestvb );
                if ( ret != SNMP_ERR_NOERROR ) {
                    netsnmp_set_request_error( reqinfo, request, ret );
                    return SNMP_ERR_NOERROR;
                }
                break;
            case COLUMN_WIFIACSDSCANTIMER:
                /* or possibly 'netsnmp_check_vb_int_range' */
                ret = netsnmp_check_vb_int( request->requestvb );
                if ( ret != SNMP_ERR_NOERROR ) {
                    netsnmp_set_request_error( reqinfo, request, ret );
                    return SNMP_ERR_NOERROR;
                }
                break;
            case COLUMN_WIFIWMFENABLE:
                /* or possibly 'netsnmp_check_vb_int_range' */
                ret = netsnmp_check_vb_int( request->requestvb );
                if ( ret != SNMP_ERR_NOERROR ) {
                    netsnmp_set_request_error( reqinfo, request, ret );
                    return SNMP_ERR_NOERROR;
                }
                break;
            case COLUMN_WIFIBSENABLE:
                /* or possibly 'netsnmp_check_vb_int_range' */
                ret = netsnmp_check_vb_int( request->requestvb );
                if ( ret != SNMP_ERR_NOERROR ) {
                    netsnmp_set_request_error( reqinfo, request, ret );
                    return SNMP_ERR_NOERROR;
                }
                break;
            case COLUMN_WIFIATFENABLE:
                /* or possibly 'netsnmp_check_vb_int_range' */
                ret = netsnmp_check_vb_int( request->requestvb );
                if ( ret != SNMP_ERR_NOERROR ) {
                    netsnmp_set_request_error( reqinfo, request, ret );
                    return SNMP_ERR_NOERROR;
                }
                break;
            case COLUMN_WIFITRAFFICSCHEDULERENABLE:
                /* or possibly 'netsnmp_check_vb_int_range' */
                ret = netsnmp_check_vb_int( request->requestvb );
                if ( ret != SNMP_ERR_NOERROR ) {
                    netsnmp_set_request_error( reqinfo, request, ret );
                    return SNMP_ERR_NOERROR;
                }
                break;
            case COLUMN_WIFIEBOSENABLE:
                /* or possibly 'netsnmp_check_vb_int_range' */
                ret = netsnmp_check_vb_int( request->requestvb );
                if ( ret != SNMP_ERR_NOERROR ) {
                    netsnmp_set_request_error( reqinfo, request, ret );
                    return SNMP_ERR_NOERROR;
                }
                break;
            case COLUMN_WIFIPSPRETENDRETRYLIMIT:
                /* or possibly 'netsnmp_check_vb_int_range' */
                ret = netsnmp_check_vb_int( request->requestvb );
                if ( ret != SNMP_ERR_NOERROR ) {
                    netsnmp_set_request_error( reqinfo, request, ret );
                    return SNMP_ERR_NOERROR;
                }
                break;
            case COLUMN_WIFIPSPRETENDTHRESHOLD:
                /* or possibly 'netsnmp_check_vb_int_range' */
                ret = netsnmp_check_vb_int( request->requestvb );
                if ( ret != SNMP_ERR_NOERROR ) {
                    netsnmp_set_request_error( reqinfo, request, ret );
                    return SNMP_ERR_NOERROR;
                }
                break;
            case COLUMN_WIFIACSFCSMODE:
                /* or possibly 'netsnmp_check_vb_int_range' */
                ret = netsnmp_check_vb_int( request->requestvb );
                if ( ret != SNMP_ERR_NOERROR ) {
                    netsnmp_set_request_error( reqinfo, request, ret );
                    return SNMP_ERR_NOERROR;
                }
                break;
            case COLUMN_WIFIACSDFS:
                /* or possibly 'netsnmp_check_vb_int_range' */
                ret = netsnmp_check_vb_int( request->requestvb );
                if ( ret != SNMP_ERR_NOERROR ) {
                    netsnmp_set_request_error( reqinfo, request, ret );
                    return SNMP_ERR_NOERROR;
                }
                break;
            case COLUMN_WIFIACSCSSCANTIMER:
                /* or possibly 'netsnmp_check_vb_int_range' */
                ret = netsnmp_check_vb_int( request->requestvb );
                if ( ret != SNMP_ERR_NOERROR ) {
                    netsnmp_set_request_error( reqinfo, request, ret );
                    return SNMP_ERR_NOERROR;
                }
                break;
            case COLUMN_WIFIACSCISCANTIMER:
                /* or possibly 'netsnmp_check_vb_int_range' */
                ret = netsnmp_check_vb_int( request->requestvb );
                if ( ret != SNMP_ERR_NOERROR ) {
                    netsnmp_set_request_error( reqinfo, request, ret );
                    return SNMP_ERR_NOERROR;
                }
                break;
            case COLUMN_WIFIACSCISCANTIMEOUT:
                /* or possibly 'netsnmp_check_vb_int_range' */
                ret = netsnmp_check_vb_int( request->requestvb );
                if ( ret != SNMP_ERR_NOERROR ) {
                    netsnmp_set_request_error( reqinfo, request, ret );
                    return SNMP_ERR_NOERROR;
                }
                break;
            case COLUMN_WIFIACSSCANENTRYEXPIRE:
                /* or possibly 'netsnmp_check_vb_int_range' */
                ret = netsnmp_check_vb_int( request->requestvb );
                if ( ret != SNMP_ERR_NOERROR ) {
                    netsnmp_set_request_error( reqinfo, request, ret );
                    return SNMP_ERR_NOERROR;
                }
                break;
            case COLUMN_WIFIACSTXIDLECNT:
                /* or possibly 'netsnmp_check_vb_int_range' */
                ret = netsnmp_check_vb_int( request->requestvb );
                if ( ret != SNMP_ERR_NOERROR ) {
                    netsnmp_set_request_error( reqinfo, request, ret );
                    return SNMP_ERR_NOERROR;
                }
                break;
            case COLUMN_WIFIACSCHANDWELLTIME:
                /* or possibly 'netsnmp_check_vb_int_range' */
                ret = netsnmp_check_vb_int( request->requestvb );
                if ( ret != SNMP_ERR_NOERROR ) {
                    netsnmp_set_request_error( reqinfo, request, ret );
                    return SNMP_ERR_NOERROR;
                }
                break;
            case COLUMN_WIFIACSCHANFLOPPERIOD:
                /* or possibly 'netsnmp_check_vb_int_range' */
                ret = netsnmp_check_vb_int( request->requestvb );
                if ( ret != SNMP_ERR_NOERROR ) {
                    netsnmp_set_request_error( reqinfo, request, ret );
                    return SNMP_ERR_NOERROR;
                }
                break;
            case COLUMN_WIFIACSINTFERPERIOD:
                /* or possibly 'netsnmp_check_vb_int_range' */
                ret = netsnmp_check_vb_int( request->requestvb );
                if ( ret != SNMP_ERR_NOERROR ) {
                    netsnmp_set_request_error( reqinfo, request, ret );
                    return SNMP_ERR_NOERROR;
                }
                break;
            case COLUMN_WIFIACSINTFERCNT:
                /* or possibly 'netsnmp_check_vb_int_range' */
                ret = netsnmp_check_vb_int( request->requestvb );
                if ( ret != SNMP_ERR_NOERROR ) {
                    netsnmp_set_request_error( reqinfo, request, ret );
                    return SNMP_ERR_NOERROR;
                }
                break;
            case COLUMN_WIFIACSINTFERTXFAIL:
                /* or possibly 'netsnmp_check_vb_int_range' */
                ret = netsnmp_check_vb_int( request->requestvb );
                if ( ret != SNMP_ERR_NOERROR ) {
                    netsnmp_set_request_error( reqinfo, request, ret );
                    return SNMP_ERR_NOERROR;
                }
                break;
            case COLUMN_WIFIACSINTFERTCPTXFAIL:
                /* or possibly 'netsnmp_check_vb_int_range' */
                ret = netsnmp_check_vb_int( request->requestvb );
                if ( ret != SNMP_ERR_NOERROR ) {
                    netsnmp_set_request_error( reqinfo, request, ret );
                    return SNMP_ERR_NOERROR;
                }
                break;
            case COLUMN_WIFIACSDFSRIMMEDIATESEC:
                /* or possibly 'netsnmp_check_vb_int_range' */
                ret = netsnmp_check_vb_int( request->requestvb );
                if ( ret != SNMP_ERR_NOERROR ) {
                    netsnmp_set_request_error( reqinfo, request, ret );
                    return SNMP_ERR_NOERROR;
                }
                break;
            case COLUMN_WIFIACSDFSRIMMEDIATETHR:
                /* or possibly 'netsnmp_check_vb_int_range' */
                ret = netsnmp_check_vb_int( request->requestvb );
                if ( ret != SNMP_ERR_NOERROR ) {
                    netsnmp_set_request_error( reqinfo, request, ret );
                    return SNMP_ERR_NOERROR;
                }
                break;
            case COLUMN_WIFIACSDFSRDEFERREDSEC:
                /* or possibly 'netsnmp_check_vb_int_range' */
                ret = netsnmp_check_vb_int( request->requestvb );
                if ( ret != SNMP_ERR_NOERROR ) {
                    netsnmp_set_request_error( reqinfo, request, ret );
                    return SNMP_ERR_NOERROR;
                }
                break;
            case COLUMN_WIFIACSDFSRDEFERREDTHR:
                /* or possibly 'netsnmp_check_vb_int_range' */
                ret = netsnmp_check_vb_int( request->requestvb );
                if ( ret != SNMP_ERR_NOERROR ) {
                    netsnmp_set_request_error( reqinfo, request, ret );
                    return SNMP_ERR_NOERROR;
                }
                break;
            case COLUMN_WIFIACSDFSRACTIVITYSEC:
                /* or possibly 'netsnmp_check_vb_int_range' */
                ret = netsnmp_check_vb_int( request->requestvb );
                if ( ret != SNMP_ERR_NOERROR ) {
                    netsnmp_set_request_error( reqinfo, request, ret );
                    return SNMP_ERR_NOERROR;
                }
                break;
            case COLUMN_WIFIACSDFSRACTIVITYTHR:
                /* or possibly 'netsnmp_check_vb_int_range' */
                ret = netsnmp_check_vb_int( request->requestvb );
                if ( ret != SNMP_ERR_NOERROR ) {
                    netsnmp_set_request_error( reqinfo, request, ret );
                    return SNMP_ERR_NOERROR;
                }
                break;
            case COLUMN_WIFIACSEXCLUDECHANNELS:
	        /* or possibly 'netsnmp_check_vb_type_and_size' */
                ret = netsnmp_check_vb_type_and_max_size(
                          request->requestvb, ASN_OCTET_STR, sizeof(table_entry->wifiACSExcludeChannels));
                if ( ret != SNMP_ERR_NOERROR ) {
                    netsnmp_set_request_error( reqinfo, request, ret );
                    return SNMP_ERR_NOERROR;
                }
                break;
            case COLUMN_WIFIDEEPSLEEP:
                /* or possibly 'netsnmp_check_vb_int_range' */
                ret = netsnmp_check_vb_int( request->requestvb );
                if ( ret != SNMP_ERR_NOERROR ) {
                    netsnmp_set_request_error( reqinfo, request, ret );
                    return SNMP_ERR_NOERROR;
                }
                break;
            default:
                netsnmp_set_request_error( reqinfo, request,
                                           SNMP_ERR_NOTWRITABLE );
                return SNMP_ERR_NOERROR;
            }
        }
        break;

    case MODE_SET_RESERVE2:
        break;

    case MODE_SET_FREE:
        break;

    case MODE_SET_ACTION:
        /* Check the flag */
        if(!wifiPrimaryInterfaceTable_apply_flag)
        {
            /* build the local cache table */
            wifiPrimaryInterfaceTable_buildLocalTableData();
            wifiPrimaryInterfaceTable_apply_flag = 1;
        }

        for (request=requests; request; request=request->next) {
            table_entry = (struct wifiPrimaryInterfaceTable_entry *)
                              netsnmp_extract_iterator_context(request);
            /* Replace the table_entry with local cache table_entry */
            table_entry = wifiPrimaryInterfaceTable_getLocalTableEntry(table_entry);
            if(table_entry == NULL)
            {
                snmp_log(LOG_ERR, "%s - can't find local table entry\n", __FUNCTION__);
                continue;
            }
            table_info  =     netsnmp_extract_table_info(      request);

            switch (table_info->colnum) {
            case COLUMN_WIFIOPERMODE:
                table_entry->old_wifiOperMode = table_entry->wifiOperMode;
                table_entry->wifiOperMode     = *request->requestvb->val.integer;
                break;
            case COLUMN_WIFICURRENTCHANNEL:
                table_entry->old_wifiCurrentChannel = table_entry->wifiCurrentChannel;
                table_entry->wifiCurrentChannel     = *request->requestvb->val.integer;
                break;
            case COLUMN_WIFIBEACONINTERVAL:
                table_entry->old_wifiBeaconInterval = table_entry->wifiBeaconInterval;
                table_entry->wifiBeaconInterval     = *request->requestvb->val.integer;
                break;
            case COLUMN_WIFIDTIMINTERVAL:
                table_entry->old_wifiDTIMInterval = table_entry->wifiDTIMInterval;
                table_entry->wifiDTIMInterval     = *request->requestvb->val.integer;
                break;
            case COLUMN_WIFIFRAGTHRESH:
                table_entry->old_wifiFragThresh = table_entry->wifiFragThresh;
                table_entry->wifiFragThresh     = *request->requestvb->val.integer;
                break;
            case COLUMN_WIFIRTSTHRESH:
                table_entry->old_wifiRTSThresh = table_entry->wifiRTSThresh;
                table_entry->wifiRTSThresh     = *request->requestvb->val.integer;
                break;
            case COLUMN_WIFISHORTRETRYLIMIT:
                table_entry->old_wifiShortRetryLimit = table_entry->wifiShortRetryLimit;
                table_entry->wifiShortRetryLimit     = *request->requestvb->val.integer;
                break;
            case COLUMN_WIFILONGRETRYLIMIT:
                table_entry->old_wifiLongRetryLimit = table_entry->wifiLongRetryLimit;
                table_entry->wifiLongRetryLimit     = *request->requestvb->val.integer;
                break;
            case COLUMN_WIFIRATE:
                table_entry->old_wifiRate = table_entry->wifiRate;
                table_entry->wifiRate     = *request->requestvb->val.integer;
                break;
            case COLUMN_WIFIMBSSUSERCONTROL:
                table_entry->old_wifiMbssUserControl = table_entry->wifiMbssUserControl;
                table_entry->wifiMbssUserControl     = *request->requestvb->val.integer;
                break;
            case COLUMN_WIFIRADIOENABLE:
                table_entry->old_wifiRadioEnable = table_entry->wifiRadioEnable;
                table_entry->wifiRadioEnable     = *request->requestvb->val.integer;
                break;
            case COLUMN_WIFIAPSSCAN:
                table_entry->old_wifiApsScan = table_entry->wifiApsScan;
                table_entry->wifiApsScan     = *request->requestvb->val.integer;
                break;
            case COLUMN_WIFIOBSSCOEXMODE:
                table_entry->old_wifiObssCoexMode = table_entry->wifiObssCoexMode;
                table_entry->wifiObssCoexMode     = *request->requestvb->val.integer;
                break;
            case COLUMN_WIFIACSDSCANTIMER:
                table_entry->old_wifiAcsdScanTimer = table_entry->wifiAcsdScanTimer;
                table_entry->wifiAcsdScanTimer     = *request->requestvb->val.integer;
                break;
            case COLUMN_WIFIWMFENABLE:
                table_entry->old_wifiWMFEnable = table_entry->wifiWMFEnable;
                table_entry->wifiWMFEnable     = *request->requestvb->val.integer;
                break;
            case COLUMN_WIFIBSENABLE:
                table_entry->old_wifiBSEnable = table_entry->wifiBSEnable;
                table_entry->wifiBSEnable     = *request->requestvb->val.integer;
                break;
            case COLUMN_WIFIATFENABLE:
                table_entry->old_wifiATFEnable = table_entry->wifiATFEnable;
                table_entry->wifiATFEnable     = *request->requestvb->val.integer;
                break;
            case COLUMN_WIFITRAFFICSCHEDULERENABLE:
                table_entry->old_wifiTrafficSchedulerEnable = table_entry->wifiTrafficSchedulerEnable;
                table_entry->wifiTrafficSchedulerEnable     = *request->requestvb->val.integer;
                break;
            case COLUMN_WIFIEBOSENABLE:
                table_entry->old_wifiEbosEnable = table_entry->wifiEbosEnable;
                table_entry->wifiEbosEnable     = *request->requestvb->val.integer;
                break;
            case COLUMN_WIFIPSPRETENDRETRYLIMIT:
                table_entry->old_wifiPsPretendRetryLimit = table_entry->wifiPsPretendRetryLimit;
                table_entry->wifiPsPretendRetryLimit     = *request->requestvb->val.integer;
                break;
            case COLUMN_WIFIPSPRETENDTHRESHOLD:
                table_entry->old_wifiPsPretendThreshold = table_entry->wifiPsPretendThreshold;
                table_entry->wifiPsPretendThreshold     = *request->requestvb->val.integer;
                break;
            case COLUMN_WIFIACSFCSMODE:
                table_entry->old_wifiAcsFcsMode = table_entry->wifiAcsFcsMode;
                table_entry->wifiAcsFcsMode     = *request->requestvb->val.integer;
                break;
            case COLUMN_WIFIACSDFS:
                table_entry->old_wifiAcsDfs = table_entry->wifiAcsDfs;
                table_entry->wifiAcsDfs     = *request->requestvb->val.integer;
                break;
            case COLUMN_WIFIACSCSSCANTIMER:
                table_entry->old_wifiAcsCsScanTimer = table_entry->wifiAcsCsScanTimer;
                table_entry->wifiAcsCsScanTimer     = *request->requestvb->val.integer;
                break;
            case COLUMN_WIFIACSCISCANTIMER:
                table_entry->old_wifiAcsCiScanTimer = table_entry->wifiAcsCiScanTimer;
                table_entry->wifiAcsCiScanTimer     = *request->requestvb->val.integer;
                break;
            case COLUMN_WIFIACSCISCANTIMEOUT:
                table_entry->old_wifiAcsCiScanTimeout = table_entry->wifiAcsCiScanTimeout;
                table_entry->wifiAcsCiScanTimeout     = *request->requestvb->val.integer;
                break;
            case COLUMN_WIFIACSSCANENTRYEXPIRE:
                table_entry->old_wifiAcsScanEntryExpire = table_entry->wifiAcsScanEntryExpire;
                table_entry->wifiAcsScanEntryExpire     = *request->requestvb->val.integer;
                break;
            case COLUMN_WIFIACSTXIDLECNT:
                table_entry->old_wifiAcsTxIdleCnt = table_entry->wifiAcsTxIdleCnt;
                table_entry->wifiAcsTxIdleCnt     = *request->requestvb->val.integer;
                break;
            case COLUMN_WIFIACSCHANDWELLTIME:
                table_entry->old_wifiAcsChanDwellTime = table_entry->wifiAcsChanDwellTime;
                table_entry->wifiAcsChanDwellTime     = *request->requestvb->val.integer;
                break;
            case COLUMN_WIFIACSCHANFLOPPERIOD:
                table_entry->old_wifiAcsChanFlopPeriod = table_entry->wifiAcsChanFlopPeriod;
                table_entry->wifiAcsChanFlopPeriod     = *request->requestvb->val.integer;
                break;
            case COLUMN_WIFIACSINTFERPERIOD:
                table_entry->old_wifiAcsIntferPeriod = table_entry->wifiAcsIntferPeriod;
                table_entry->wifiAcsIntferPeriod     = *request->requestvb->val.integer;
                break;
            case COLUMN_WIFIACSINTFERCNT:
                table_entry->old_wifiAcsIntferCnt = table_entry->wifiAcsIntferCnt;
                table_entry->wifiAcsIntferCnt     = *request->requestvb->val.integer;
                break;
            case COLUMN_WIFIACSINTFERTXFAIL:
                table_entry->old_wifiAcsIntferTxfail = table_entry->wifiAcsIntferTxfail;
                table_entry->wifiAcsIntferTxfail     = *request->requestvb->val.integer;
                break;
            case COLUMN_WIFIACSINTFERTCPTXFAIL:
                table_entry->old_wifiAcsIntferTcptxfail = table_entry->wifiAcsIntferTcptxfail;
                table_entry->wifiAcsIntferTcptxfail     = *request->requestvb->val.integer;
                break;
            case COLUMN_WIFIACSDFSRIMMEDIATESEC:
                table_entry->old_wifiAcsDfsrImmediateSec = table_entry->wifiAcsDfsrImmediateSec;
                table_entry->wifiAcsDfsrImmediateSec     = *request->requestvb->val.integer;
                break;
            case COLUMN_WIFIACSDFSRIMMEDIATETHR:
                table_entry->old_wifiAcsDfsrImmediateThr = table_entry->wifiAcsDfsrImmediateThr;
                table_entry->wifiAcsDfsrImmediateThr     = *request->requestvb->val.integer;
                break;
            case COLUMN_WIFIACSDFSRDEFERREDSEC:
                table_entry->old_wifiAcsDfsrDeferredSec = table_entry->wifiAcsDfsrDeferredSec;
                table_entry->wifiAcsDfsrDeferredSec     = *request->requestvb->val.integer;
                break;
            case COLUMN_WIFIACSDFSRDEFERREDTHR:
                table_entry->old_wifiAcsDfsrDeferredThr = table_entry->wifiAcsDfsrDeferredThr;
                table_entry->wifiAcsDfsrDeferredThr     = *request->requestvb->val.integer;
                break;
            case COLUMN_WIFIACSDFSRACTIVITYSEC:
                table_entry->old_wifiAcsDfsrActivitySec = table_entry->wifiAcsDfsrActivitySec;
                table_entry->wifiAcsDfsrActivitySec     = *request->requestvb->val.integer;
                break;
            case COLUMN_WIFIACSDFSRACTIVITYTHR:
                table_entry->old_wifiAcsDfsrActivityThr = table_entry->wifiAcsDfsrActivityThr;
                table_entry->wifiAcsDfsrActivityThr     = *request->requestvb->val.integer;
                break;
            case COLUMN_WIFIACSEXCLUDECHANNELS:
                memcpy( table_entry->old_wifiACSExcludeChannels,
                        table_entry->wifiACSExcludeChannels,
                        sizeof(table_entry->wifiACSExcludeChannels));
                table_entry->old_wifiACSExcludeChannels_len =
                        table_entry->wifiACSExcludeChannels_len;
                memset( table_entry->wifiACSExcludeChannels, 0,
                        sizeof(table_entry->wifiACSExcludeChannels));
                memcpy( table_entry->wifiACSExcludeChannels,
                        request->requestvb->val.string,
                        request->requestvb->val_len);
                table_entry->wifiACSExcludeChannels_len =
                        request->requestvb->val_len;
                break;
            case COLUMN_WIFIDEEPSLEEP:
                table_entry->old_wifiDeepSleep = table_entry->wifiDeepSleep;
                table_entry->wifiDeepSleep     = *request->requestvb->val.integer;
                break;
            }
        }
        break;

    case MODE_SET_UNDO:
        for (request=requests; request; request=request->next) {
            table_entry = (struct wifiPrimaryInterfaceTable_entry *)
                              netsnmp_extract_iterator_context(request);
            table_info  =     netsnmp_extract_table_info(      request);

            switch (table_info->colnum) {
            case COLUMN_WIFIOPERMODE:
                table_entry->wifiOperMode     = table_entry->old_wifiOperMode;
                table_entry->old_wifiOperMode = 0;
                break;
            case COLUMN_WIFICURRENTCHANNEL:
                table_entry->wifiCurrentChannel     = table_entry->old_wifiCurrentChannel;
                table_entry->old_wifiCurrentChannel = 0;
                break;
            case COLUMN_WIFIBEACONINTERVAL:
                table_entry->wifiBeaconInterval     = table_entry->old_wifiBeaconInterval;
                table_entry->old_wifiBeaconInterval = 0;
                break;
            case COLUMN_WIFIDTIMINTERVAL:
                table_entry->wifiDTIMInterval     = table_entry->old_wifiDTIMInterval;
                table_entry->old_wifiDTIMInterval = 0;
                break;
            case COLUMN_WIFIFRAGTHRESH:
                table_entry->wifiFragThresh     = table_entry->old_wifiFragThresh;
                table_entry->old_wifiFragThresh = 0;
                break;
            case COLUMN_WIFIRTSTHRESH:
                table_entry->wifiRTSThresh     = table_entry->old_wifiRTSThresh;
                table_entry->old_wifiRTSThresh = 0;
                break;
            case COLUMN_WIFISHORTRETRYLIMIT:
                table_entry->wifiShortRetryLimit     = table_entry->old_wifiShortRetryLimit;
                table_entry->old_wifiShortRetryLimit = 0;
                break;
            case COLUMN_WIFILONGRETRYLIMIT:
                table_entry->wifiLongRetryLimit     = table_entry->old_wifiLongRetryLimit;
                table_entry->old_wifiLongRetryLimit = 0;
                break;
            case COLUMN_WIFIRATE:
                table_entry->wifiRate     = table_entry->old_wifiRate;
                table_entry->old_wifiRate = 0;
                break;
            case COLUMN_WIFIMBSSUSERCONTROL:
                table_entry->wifiMbssUserControl     = table_entry->old_wifiMbssUserControl;
                table_entry->old_wifiMbssUserControl = 0;
                break;
            case COLUMN_WIFIRADIOENABLE:
                table_entry->wifiRadioEnable     = table_entry->old_wifiRadioEnable;
                table_entry->old_wifiRadioEnable = 0;
                break;
            case COLUMN_WIFIAPSSCAN:
                table_entry->wifiApsScan     = table_entry->old_wifiApsScan;
                table_entry->old_wifiApsScan = 0;
                break;
            case COLUMN_WIFIOBSSCOEXMODE:
                table_entry->wifiObssCoexMode     = table_entry->old_wifiObssCoexMode;
                table_entry->old_wifiObssCoexMode = 0;
                break;
            case COLUMN_WIFIACSDSCANTIMER:
                table_entry->wifiAcsdScanTimer     = table_entry->old_wifiAcsdScanTimer;
                table_entry->old_wifiAcsdScanTimer = 0;
                break;
            case COLUMN_WIFIWMFENABLE:
                table_entry->wifiWMFEnable     = table_entry->old_wifiWMFEnable;
                table_entry->old_wifiWMFEnable = 0;
                break;
            case COLUMN_WIFIBSENABLE:
                table_entry->wifiBSEnable     = table_entry->old_wifiBSEnable;
                table_entry->old_wifiBSEnable = 0;
                break;
            case COLUMN_WIFIATFENABLE:
                table_entry->wifiATFEnable     = table_entry->old_wifiATFEnable;
                table_entry->old_wifiATFEnable = 0;
                break;
            case COLUMN_WIFITRAFFICSCHEDULERENABLE:
                table_entry->wifiTrafficSchedulerEnable     = table_entry->old_wifiTrafficSchedulerEnable;
                table_entry->old_wifiTrafficSchedulerEnable = 0;
                break;
            case COLUMN_WIFIEBOSENABLE:
                table_entry->wifiEbosEnable     = table_entry->old_wifiEbosEnable;
                table_entry->old_wifiEbosEnable = 0;
                break;
            case COLUMN_WIFIPSPRETENDRETRYLIMIT:
                table_entry->wifiPsPretendRetryLimit     = table_entry->old_wifiPsPretendRetryLimit;
                table_entry->old_wifiPsPretendRetryLimit = 0;
                break;
            case COLUMN_WIFIPSPRETENDTHRESHOLD:
                table_entry->wifiPsPretendThreshold     = table_entry->old_wifiPsPretendThreshold;
                table_entry->old_wifiPsPretendThreshold = 0;
                break;
            case COLUMN_WIFIACSFCSMODE:
                table_entry->wifiAcsFcsMode     = table_entry->old_wifiAcsFcsMode;
                table_entry->old_wifiAcsFcsMode = 0;
                break;
            case COLUMN_WIFIACSDFS:
                table_entry->wifiAcsDfs     = table_entry->old_wifiAcsDfs;
                table_entry->old_wifiAcsDfs = 0;
                break;
            case COLUMN_WIFIACSCSSCANTIMER:
                table_entry->wifiAcsCsScanTimer     = table_entry->old_wifiAcsCsScanTimer;
                table_entry->old_wifiAcsCsScanTimer = 0;
                break;
            case COLUMN_WIFIACSCISCANTIMER:
                table_entry->wifiAcsCiScanTimer     = table_entry->old_wifiAcsCiScanTimer;
                table_entry->old_wifiAcsCiScanTimer = 0;
                break;
            case COLUMN_WIFIACSCISCANTIMEOUT:
                table_entry->wifiAcsCiScanTimeout     = table_entry->old_wifiAcsCiScanTimeout;
                table_entry->old_wifiAcsCiScanTimeout = 0;
                break;
            case COLUMN_WIFIACSSCANENTRYEXPIRE:
                table_entry->wifiAcsScanEntryExpire     = table_entry->old_wifiAcsScanEntryExpire;
                table_entry->old_wifiAcsScanEntryExpire = 0;
                break;
            case COLUMN_WIFIACSTXIDLECNT:
                table_entry->wifiAcsTxIdleCnt     = table_entry->old_wifiAcsTxIdleCnt;
                table_entry->old_wifiAcsTxIdleCnt = 0;
                break;
            case COLUMN_WIFIACSCHANDWELLTIME:
                table_entry->wifiAcsChanDwellTime     = table_entry->old_wifiAcsChanDwellTime;
                table_entry->old_wifiAcsChanDwellTime = 0;
                break;
            case COLUMN_WIFIACSCHANFLOPPERIOD:
                table_entry->wifiAcsChanFlopPeriod     = table_entry->old_wifiAcsChanFlopPeriod;
                table_entry->old_wifiAcsChanFlopPeriod = 0;
                break;
            case COLUMN_WIFIACSINTFERPERIOD:
                table_entry->wifiAcsIntferPeriod     = table_entry->old_wifiAcsIntferPeriod;
                table_entry->old_wifiAcsIntferPeriod = 0;
                break;
            case COLUMN_WIFIACSINTFERCNT:
                table_entry->wifiAcsIntferCnt     = table_entry->old_wifiAcsIntferCnt;
                table_entry->old_wifiAcsIntferCnt = 0;
                break;
            case COLUMN_WIFIACSINTFERTXFAIL:
                table_entry->wifiAcsIntferTxfail     = table_entry->old_wifiAcsIntferTxfail;
                table_entry->old_wifiAcsIntferTxfail = 0;
                break;
            case COLUMN_WIFIACSINTFERTCPTXFAIL:
                table_entry->wifiAcsIntferTcptxfail     = table_entry->old_wifiAcsIntferTcptxfail;
                table_entry->old_wifiAcsIntferTcptxfail = 0;
                break;
            case COLUMN_WIFIACSDFSRIMMEDIATESEC:
                table_entry->wifiAcsDfsrImmediateSec     = table_entry->old_wifiAcsDfsrImmediateSec;
                table_entry->old_wifiAcsDfsrImmediateSec = 0;
                break;
            case COLUMN_WIFIACSDFSRIMMEDIATETHR:
                table_entry->wifiAcsDfsrImmediateThr     = table_entry->old_wifiAcsDfsrImmediateThr;
                table_entry->old_wifiAcsDfsrImmediateThr = 0;
                break;
            case COLUMN_WIFIACSDFSRDEFERREDSEC:
                table_entry->wifiAcsDfsrDeferredSec     = table_entry->old_wifiAcsDfsrDeferredSec;
                table_entry->old_wifiAcsDfsrDeferredSec = 0;
                break;
            case COLUMN_WIFIACSDFSRDEFERREDTHR:
                table_entry->wifiAcsDfsrDeferredThr     = table_entry->old_wifiAcsDfsrDeferredThr;
                table_entry->old_wifiAcsDfsrDeferredThr = 0;
                break;
            case COLUMN_WIFIACSDFSRACTIVITYSEC:
                table_entry->wifiAcsDfsrActivitySec     = table_entry->old_wifiAcsDfsrActivitySec;
                table_entry->old_wifiAcsDfsrActivitySec = 0;
                break;
            case COLUMN_WIFIACSDFSRACTIVITYTHR:
                table_entry->wifiAcsDfsrActivityThr     = table_entry->old_wifiAcsDfsrActivityThr;
                table_entry->old_wifiAcsDfsrActivityThr = 0;
                break;
            case COLUMN_WIFIACSEXCLUDECHANNELS:
                memcpy( table_entry->wifiACSExcludeChannels,
                        table_entry->old_wifiACSExcludeChannels,
                        sizeof(table_entry->wifiACSExcludeChannels));
                memset( table_entry->old_wifiACSExcludeChannels, 0,
                        sizeof(table_entry->wifiACSExcludeChannels));
                table_entry->wifiACSExcludeChannels_len =
                        table_entry->old_wifiACSExcludeChannels_len;
                break;
            case COLUMN_WIFIDEEPSLEEP:
                table_entry->wifiDeepSleep     = table_entry->old_wifiDeepSleep;
                table_entry->old_wifiDeepSleep = 0;
                break;
            }
        }
        break;

    case MODE_SET_COMMIT:
        break;
    }
    return SNMP_ERR_NOERROR;
}

int
handle_wifiApplySettings(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info   *reqinfo,
                          netsnmp_request_info         *requests)
{
    int ret;
    int value;
    char ifName[32];
    /* We are never called for a GETNEXT if it's registered as a
       "instance", as it's "magically" handled for us.  */

    /* a instance handler also only hands us one request at a time, so
       we don't need to loop over a list of requests; we'll only get one. */
    struct wifiPrimaryInterfaceTable_entry *wifiPrimaryInterfaceTable_entry;
    struct wifiPrimaryInterfaceTable_entry *wifiPrimaryInterfaceTable_local_entry;
    switch(reqinfo->mode) {

        case MODE_GET:
            /* Always returns false(2) when read. */
            value = 2;
            snmp_set_var_typed_value(requests->requestvb, ASN_INTEGER,
                                     &value,
                                     4);
            break;

        /*
         * SET REQUEST
         *
         * multiple states in the transaction.  See:
         * http://www.net-snmp.org/tutorial-5/toolkit/mib_module/set-actions.jpg
         */
        case MODE_SET_RESERVE1:
                /* or you could use netsnmp_check_vb_type_and_size instead */
            ret = netsnmp_check_vb_type(requests->requestvb, ASN_INTEGER);
            if ( ret != SNMP_ERR_NOERROR ) {
                netsnmp_set_request_error(reqinfo, requests, ret );
            }
            break;

        case MODE_SET_RESERVE2:
            /* Set value must be 1 */
            if (*requests->requestvb->val.integer != 1) {
                netsnmp_set_request_error(reqinfo, requests, SNMP_ERR_WRONGVALUE);
            }
            break;

        case MODE_SET_FREE:
            /* XXX: free resources allocated in RESERVE1 and/or
               RESERVE2.  Something failed somewhere, and the states
               below won't be called. */
            break;

        case MODE_SET_ACTION:
            /* XXX: perform the value change here */
            if( !(wifiPrimaryInterfaceTable_apply_flag) )
            {
                /* no write for any table, do nothing */
                break;
            }
            if(wifiPrimaryInterfaceTable_apply_flag)
            {
                wifiPrimaryInterfaceTable_entry = wifiPrimaryInterfaceTable_head;
                while(wifiPrimaryInterfaceTable_entry)
                {
                    wifiPrimaryInterfaceTable_local_entry = wifiPrimaryInterfaceTable_getLocalTableEntry(wifiPrimaryInterfaceTable_entry);

                    if (wifiPrimaryInterfaceTable_local_entry->wifiRadioEnable != wifiPrimaryInterfaceTable_entry->wifiRadioEnable) {
                        if(!getIfNameByIfTableIfindex(wifiPrimaryInterfaceTable_local_entry->ifIndex, ifName))
                        {
                            snmp_log(LOG_ERR, "Get ifName from index(%ld) failed\n", wifiPrimaryInterfaceTable_local_entry->ifIndex);
                            return -1;
                        }
                        set_wifi_raido_enable(ifName, wifiPrimaryInterfaceTable_local_entry->wifiRadioEnable);
                    }
					if (wifiPrimaryInterfaceTable_local_entry->wifiDeepSleep != wifiPrimaryInterfaceTable_entry->wifiDeepSleep) {
						if(!getIfNameByIfTableIfindex(wifiPrimaryInterfaceTable_local_entry->ifIndex, ifName))
                        {
                            snmp_log(LOG_ERR, "Get ifName from index(%ld) failed\n", wifiPrimaryInterfaceTable_local_entry->ifIndex);
                            return -1;
                        }
                        set_wifi_deep_sleep(ifName, wifiPrimaryInterfaceTable_local_entry->wifiDeepSleep);
					}

                    wifiPrimaryInterfaceTable_entry = wifiPrimaryInterfaceTable_entry->next;
                }

                while(wifiPrimaryInterfaceTable_local_head)
                {
                    wifiPrimaryInterfaceTable_local_entry = wifiPrimaryInterfaceTable_local_head;
                    wifiPrimaryInterfaceTable_local_head = wifiPrimaryInterfaceTable_local_head->next;
                    SNMP_FREE( wifiPrimaryInterfaceTable_local_entry );
                }
                /* All the local table data has been set to MDM, clear the local flag */
                wifiPrimaryInterfaceTable_apply_flag = 0;
                memset(&wifiPrimaryInterfaceTable_rebuildTime, 0, sizeof(wifiPrimaryInterfaceTable_rebuildTime));
            } /* end if wifiPrimaryInterfaceTable_apply_flag */
            break;

        case MODE_SET_COMMIT:
            /* XXX: delete temporary storage */
            if (0/* XXX: error? */) {
                /* try _really_really_ hard to never get to this point */
                netsnmp_set_request_error(reqinfo, requests, SNMP_ERR_COMMITFAILED);
            }
            break;

        case MODE_SET_UNDO:
            /* XXX: UNDO and return to previous value for the object */
            if (0/* XXX: error? */) {
                /* try _really_really_ hard to never get to this point */
                netsnmp_set_request_error(reqinfo, requests, SNMP_ERR_UNDOFAILED);
            }
            break;

        default:
            /* we should never get here, so this is a really bad error */
            snmp_log(LOG_ERR, "unknown mode (%d) in handle_wifiApplySettings\n", reqinfo->mode );
            return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}
