/*
 * Note: this file originally auto-generated by mib2c using
 *        $
 */

#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>
#include <stdlib.h>
#include <errno.h>
#include <unistd.h>
#include <ctype.h>

#include "brcm_rg_mgmt.h"
#include "bcm_net_snmp.h"

#define NNN 512
#define SNMP_TRUE (1)
#define SNMP_FALSE (2)

#ifdef ARM64
/* TODO: Remove after new bp3 daemon ready */
#define BP3_STATE_TMP_FIX

/* Constants for BFE/BP3 */
#define BFE_LICENSE_SAVE_PATH "/data"
#define BFE_LICENSE_RUN_PATH "/var/tftpboot"
#define BFE_PATH_ENV "BFELIC_PATH"
#define BP3_LICENSE_PATH "/mnt/bp3lic"
#define BP3_PATH_ENV "BP3LIC_PATH"
#define BP3_PROVISION_LOG "/data/bp3_provision.log"
#define BP3_LICENSE_URI_FILE "/data/license.uri"
#define BP3_LOCAL_FILE_NAME_LEN 64
#define BP3_LICENSE_DOWNLOAD_TIMEOUT 10

#define BP3_STATE_OUTPUT_PASS "Pass"
#define BP3_STATE_OUTPUT_FAIL "Fail"
#define BP3_STATE_OUTPUT_EXPIRED "Expired"
#define BP3_STATE_ABSENT "Absent"
#define BP3_STATE_ACTIVE "Active"
#define BP3_STATE_EXPIRED "Expired"
#define BP3_STATE_PROVISIONING "Provisioning"
#define BP3_PROVISION_STATUS_ERROR "Provision Error"

#define BP3_PROVISION_TYPE_BFE "bfe"
#define BP3_PROVISION_TYPE_PAK "pak"
#define BP3_PROVISION_TYPE_DRM "drm"
#define BP3_PROVISION_TYPE_PKL "pkl"
#define BP3_PROVISION_TYPE_STRLEN 3
#define BP3_LICENSE_TYPE_NUM 3
const char *gBP3LicenseType[BP3_LICENSE_TYPE_NUM] =
{
    BP3_PROVISION_TYPE_BFE,
    BP3_PROVISION_TYPE_PAK,
    BP3_PROVISION_TYPE_DRM
};
#endif

#ifdef BUILD_OPENWRT
void getSetAltWanEnable( int* altWanMode, unsigned int set );
#endif

/** Initializes the residentialGatewayMgmt module */
void
init_brcm_rg_mgmt(void)
{
    const oid       rgeRouterIpProvMode_oid[] =
        { 1, 3, 6, 1, 4, 1, 4413, 2, 2, 2, 1, 7, 1, 4 };
    const oid       rgResetToFactory_oid[] =
        { 1, 3, 6, 1, 4, 1, 4413, 2, 2, 2, 1, 7, 1, 10 };
#ifdef BUILD_OPENWRT
    const oid rgAltWanMode_oid[] =
        { 1, 3, 6, 1, 4, 1, 4413, 2, 2, 2, 1, 7, 1, 18 };
#endif
#ifdef ARM64
    const oid rgBfeBp3LicenseUri_oid[] =
        { 1, 3, 6, 1, 4, 1, 4413, 2, 2, 2, 1, 7, 1, 19, 1 };
    const oid rgBfeBp3LicenseState_oid[] =
        { 1, 3, 6, 1, 4, 1, 4413, 2, 2, 2, 1, 7, 1, 19, 2 };
#endif

    snmp_log(LOG_INFO,"Initializing init_brcm_rg_mgmt\n");

    DEBUGMSGTL(("residentialGatewayMgmt", "Initializing\n"));

    netsnmp_register_scalar(netsnmp_create_handler_registration
                            ("rgeRouterIpProvMode",
                             handle_rgeRouterIpProvMode,
                             rgeRouterIpProvMode_oid,
                             OID_LENGTH(rgeRouterIpProvMode_oid),
                             HANDLER_CAN_RWRITE));
    snmp_log(LOG_INFO,"Registered handle_rgeRouterIpProvMode\n");

    netsnmp_register_scalar(netsnmp_create_handler_registration
                             ("rgResetToFactory", handle_rgResetToFactory,
                             rgResetToFactory_oid,
                             OID_LENGTH(rgResetToFactory_oid),
                             HANDLER_CAN_RWRITE));
    snmp_log(LOG_INFO,"Registered handle_rgResetToFactory\n");

#ifdef BUILD_OPENWRT
    netsnmp_register_scalar(netsnmp_create_handler_registration
                            ("rgAltWanMode", handle_rgAltWanMode,
                             rgAltWanMode_oid,
                             OID_LENGTH(rgAltWanMode_oid),
                             HANDLER_CAN_RWRITE));
    snmp_log(LOG_INFO,"Registered handle_rgAltWanMode\n");
#endif

#ifdef ARM64
    if (!system("which bp3 > /dev/null"))
    {
        netsnmp_register_scalar(netsnmp_create_handler_registration
                                ("rgBfeBp3LicenseUri", handle_rgBfeBp3LicenseUri,
                                 rgBfeBp3LicenseUri_oid,
                                 OID_LENGTH(rgBfeBp3LicenseUri_oid),
                                 HANDLER_CAN_RWRITE));
        snmp_log(LOG_INFO,"Registered handle_rgBfeBp3LicenseUri\n");

        netsnmp_register_scalar(netsnmp_create_handler_registration
                                ("rgBfeBp3LicenseState", handle_rgBfeBp3LicenseState,
                                 rgBfeBp3LicenseState_oid,
                                 OID_LENGTH(rgBfeBp3LicenseState_oid),
                                 HANDLER_CAN_RONLY));
        snmp_log(LOG_INFO,"Registered handle_rgBfeBp3LicenseState\n");
    }
#endif
}

int
handle_rgeRouterIpProvMode(netsnmp_mib_handler *handler,
                           netsnmp_handler_registration *reginfo,
                           netsnmp_agent_request_info *reqinfo,
                           netsnmp_request_info *requests)
{
    int            mode = 0;
    int ret;
    /*
     * We are never called for a GETNEXT if it's registered as an
     * "instance", as it's "magically" handled for us.
     */

    /*
     * an instance handler also only hands us one request at a time, so
     * we don't need to loop over a list of requests; we'll only get one.
     */

    switch (reqinfo->mode) {

    case MODE_GET:

        mode = getErouterAdminMode();
        snmp_set_var_typed_value(requests->requestvb, ASN_INTEGER,&mode,sizeof(int));
        break;

        /*
         * SET REQUEST
         *
         * multiple states in the transaction.  See:
         * http://www.net-snmp.org/tutorial-5/toolkit/mib_module/set-actions.jpg
         */
    case MODE_SET_RESERVE1:
        /*
         * or you could use netsnmp_check_vb_type_and_size instead
         */
        ret = netsnmp_check_vb_type(requests->requestvb, ASN_INTEGER);
        if (ret != SNMP_ERR_NOERROR) {
            netsnmp_set_request_error(reqinfo, requests, ret);
        }

        mode = *requests->requestvb->val.integer;
        if ((mode < 1) || (mode > 4))
        {
            netsnmp_set_request_error(reqinfo, requests,
                                      SNMP_ERR_WRONGVALUE);
        }

        break;

    case MODE_SET_RESERVE2:
        /*
         * XXX malloc "undo" storage buffer
         */
        break;

    case MODE_SET_FREE:
        /*
         * XXX: free resources allocated in RESERVE1 and/or
         * RESERVE2.  Something failed somewhere, and the states
         * below won't be called.
         */
        break;

    case MODE_SET_ACTION:
        /*
         * XXX: perform the value change here
         */
        break;

    case MODE_SET_COMMIT:
        /*
         * XXX: delete temporary storage
         */
        break;

    case MODE_SET_UNDO:
        /*
         * XXX: UNDO and return to previous value for the object
         */
        break;

    default:
        /*
         * we should never get here, so this is a really bad error
         */
        snmp_log(LOG_ERR,
                 "unknown mode (%d) in handle_rgeRouterIpProvMode\n",
                 reqinfo->mode);
        return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}

int
handle_rgResetToFactory(netsnmp_mib_handler *handler,
                        netsnmp_handler_registration *reginfo,
                        netsnmp_agent_request_info *reqinfo,
                        netsnmp_request_info *requests)
{
    int mode = 0;
    int ret;
    /*
     * We are never called for a GETNEXT if it's registered as an
     * "instance", as it's "magically" handled for us.
     */

    /*
     * an instance handler also only hands us one request at a time, so
     * we don't need to loop over a list of requests; we'll only get one.
     */

    switch (reqinfo->mode) {

    case MODE_GET:
      mode = SNMP_FALSE;
      snmp_set_var_typed_value(requests->requestvb, ASN_INTEGER,&mode,sizeof(int));
      break;

        /*
         * SET REQUEST
         *
         * multiple states in the transaction.  See:
         * http://www.net-snmp.org/tutorial-5/toolkit/mib_module/set-actions.jpg
         */
    case MODE_SET_RESERVE1:
        /*
         * or you could use netsnmp_check_vb_type_and_size instead
         */
        ret = netsnmp_check_vb_type(requests->requestvb, ASN_INTEGER);
        if (ret != SNMP_ERR_NOERROR) {
            netsnmp_set_request_error(reqinfo, requests, ret);
        }
        break;

    case MODE_SET_RESERVE2:
        /*
         * XXX malloc "undo" storage buffer
         */
        break;

    case MODE_SET_FREE:
        /*
         * XXX: free resources allocated in RESERVE1 and/or
         * RESERVE2.  Something failed somewhere, and the states
         * below won't be called.
         */
        break;

    case MODE_SET_ACTION:
        /*
         * XXX: perform the value change here
         */

        mode = *requests->requestvb->val.integer;
        if(mode == 1)
        {
#if defined(BUILD_OPENWRT)
            system("factory");
#elif defined(BUILD_RDKM)
            system("dmcli eRT setv Device.X_CISCO_COM_DeviceControl.FactoryReset string \"Router,Wifi,VoIP,Dect,MoCA\"");
            system("reboot");
#else
            if (getErouterAdminMode() == 1)
                remove(ROUTER_DYN_CONFIG_FILE);
            system("reboot");
#endif
        }
        else
            return SNMP_ERR_WRONGVALUE;

        break;

    case MODE_SET_COMMIT:
        /*
         * XXX: delete temporary storage
         */
        break;

    case MODE_SET_UNDO:
        /*
         * XXX: UNDO and return to previous value for the object
         */
        break;

    default:
        /*
         * we should never get here, so this is a really bad error
         */
        snmp_log(LOG_ERR, "unknown mode (%d) in handle_rgResetToFactory\n",
                 reqinfo->mode);
        return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}

#ifdef BUILD_OPENWRT
typedef enum
{
   ALT_WAN_MODE_DISABLED = 1,
   ALT_WAN_MODE_ENABLED

} ALT_WAN_MODE;

int
handle_rgAltWanMode(netsnmp_mib_handler *handler,
                    netsnmp_handler_registration *reginfo,
                    netsnmp_agent_request_info *reqinfo,
                    netsnmp_request_info *requests)
{
    int mode = 0;
    int altWanEnabled = 0;
    int ret = 0;

    /*
     * We are never called for a GETNEXT if it's registered as a
     * "instance", as it's "magically" handled for us.
     */

    /*
     * a instance handler also only hands us one request at a time, so
     * we don't need to loop over a list of requests; we'll only get one.
     */

    switch (reqinfo->mode)
    {
        case MODE_GET:
            /* Check if AtlWan enabled */
            getSetAltWanEnable( &altWanEnabled, 0 );
            if( altWanEnabled )
            {
               mode = ALT_WAN_MODE_ENABLED;
            }
            else
            {
               mode = ALT_WAN_MODE_DISABLED;
            }
            snmp_set_var_typed_integer(requests->requestvb, ASN_INTEGER, mode);
            break;

        /*
         * SET REQUEST
         *
         * multiple states in the transaction.  See:
         * http://www.net-snmp.org/tutorial-5/toolkit/mib_module/set-actions.jpg
         */
        case MODE_SET_RESERVE1:
            /* or you could use netsnmp_check_vb_type_and_size instead */
            ret = netsnmp_check_vb_type(requests->requestvb, ASN_INTEGER);
            if ( ret != SNMP_ERR_NOERROR ) {
                netsnmp_set_request_error(reqinfo, requests, ret );
            }
            break;

        case MODE_SET_RESERVE2:
            /* XXX malloc "undo" storage buffer */
            if (0/* XXX if malloc, or whatever, failed: */) {
                netsnmp_set_request_error(reqinfo, requests, SNMP_ERR_RESOURCEUNAVAILABLE);
            }
            break;

        case MODE_SET_FREE:
            /* XXX: free resources allocated in RESERVE1 and/or
               RESERVE2.  Something failed somewhere, and the states
               below won't be called. */
            break;

        case MODE_SET_ACTION:
            /* XXX: perform the value change here */
            switch( *requests->requestvb->val.integer )
            {
                case ALT_WAN_MODE_DISABLED:
                {
                    altWanEnabled = 0;
                    getSetAltWanEnable( &altWanEnabled, 1 );
                }
                break;

                case ALT_WAN_MODE_ENABLED:
                {
                    altWanEnabled = 1;
                    getSetAltWanEnable( &altWanEnabled, 1 );
                }
                break;

                default:
                {
                    return SNMP_ERR_WRONGVALUE;
                }
                break;
            }

        case MODE_SET_COMMIT:
            /* XXX: delete temporary storage */
            if (0 /* XXX: error? */) {
                /* try _really_really_ hard to never get to this point */
                netsnmp_set_request_error(reqinfo, requests, SNMP_ERR_COMMITFAILED);
            }
            break;

        case MODE_SET_UNDO:
            /* XXX: UNDO and return to previous value for the object */
            if (0 /* XXX: error? */) {
                /* try _really_really_ hard to never get to this point */
                netsnmp_set_request_error(reqinfo, requests, SNMP_ERR_UNDOFAILED);
            }
            break;

        default:
            /* we should never get here, so this is a really bad error */
            snmp_log(LOG_ERR, "unknown mode (%d) in handle_rgAltWanMode\n", reqinfo->mode );
            return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}

/* Get/set Alt WAN enable flag */
void getSetAltWanEnable( int* altWanMode, unsigned int set )
{
   char buffer[10];
   unsigned int res;

   memset( buffer, 0, sizeof(buffer) );

   if( set )
   {
      if( *altWanMode )
      {
         strncpy( buffer, "1", sizeof(buffer) );
      }
      else
      {
         strncpy( buffer, "0", sizeof(buffer) );
      }
      setUciValue( "erouter.altwan.enable", buffer, sizeof(buffer) );
      resetErouter();
   }
   else
   {
      res = getUciValue( "erouter.altwan.enable", buffer, sizeof(buffer) );
      if( res != UCI_SUCCESS )
      {
         *altWanMode = 0;
         return;
      }

      if( atoi( buffer ) == 1 )
      {
         *altWanMode = 1;
      }
      else
      {
         *altWanMode = 0;
      }
   }
}
#endif

#ifdef ARM64
static void getLocalLicenseFile(const char *pLicenseType, char *pLocalLicenseFile)
{
    char * pBP3LicensePath = getenv((strcmp(pLicenseType, BP3_PROVISION_TYPE_BFE)? BP3_PATH_ENV : BFE_PATH_ENV));
    if (!pBP3LicensePath)
        pBP3LicensePath = (strcmp(pLicenseType, BP3_PROVISION_TYPE_BFE)? BP3_LICENSE_PATH : BFE_LICENSE_SAVE_PATH);
    if (strcmp(pLicenseType, BP3_PROVISION_TYPE_DRM))
        snprintf(pLocalLicenseFile, BP3_LOCAL_FILE_NAME_LEN, "%s/%s.bin", pBP3LicensePath, pLicenseType);
    else
        snprintf(pLocalLicenseFile, BP3_LOCAL_FILE_NAME_LEN, "%s/bp3.bin", pBP3LicensePath);
}

static int parsePklURI(const char *pPklURI, char *pCmd)
{
    FILE *pFile = NULL;
    char *pTmpPklURI = strdup(pPklURI);
    const unsigned int maxArg = 5;
    unsigned int argc = 0, i = 0, len = 0;
    char *argv[maxArg];

    remove(BP3_LICENSE_URI_FILE);
    parseTokensFromStr(pTmpPklURI, argv, &argc, maxArg, "|");

    /* Check if it's pkl type and the number of parameters is correct */
    if (argc != 4)
    {
        free(pTmpPklURI);
        return -1;
    }
    if (strcmp(argv[0], BP3_PROVISION_TYPE_PKL))
    {
        free(pTmpPklURI);
        return -1;
    }

    /* Check if portal is http:// or https:// */
    if (strncasecmp(argv[1], "http://", strlen("http://")) &&
            strncasecmp(argv[1], "https://", strlen("https://")))
    {
        free(pTmpPklURI);
        return -1;
    }

    /* Validate user key hash */
    for (i = 0, len = strlen(argv[2]); i < len; i++)
    {
        if (!isalnum(argv[2][i]))
        {
            free(pTmpPklURI);
            return -1;
        }
    }

    /* Validate license number */
    for (i = 0, len = strlen(argv[3]); i < len; i++)
    {
        if (!isdigit(argv[3][i]) && argv[3][i] != ',')
        {
            free(pTmpPklURI);
            return -1;
        }
    }

    if ((pFile = fopen(BP3_LICENSE_URI_FILE, "w")) != NULL)
    {
        for (i = 0, len = strlen(argv[2]); i < len; i++)
            argv[2][i] = 'X';
        fprintf(pFile, "%s|%s|%s|%s", argv[0], argv[1], argv[2], argv[3]);
        fclose(pFile);
    }

    snprintf(pCmd, NNN, "bp3 provision -portal %s -key %s -license %s &>%s &",
        argv[1], argv[2], argv[3], BP3_PROVISION_LOG);
    free(pTmpPklURI);
    return 0;
}

int
handle_rgBfeBp3LicenseUri(netsnmp_mib_handler *handler,
                    netsnmp_handler_registration *reginfo,
                    netsnmp_agent_request_info *reqinfo,
                    netsnmp_request_info *requests)
{
    int ret = 0;

    /*
     * We are never called for a GETNEXT if it's registered as a
     * "instance", as it's "magically" handled for us.
     */

    /*
     * a instance handler also only hands us one request at a time, so
     * we don't need to loop over a list of requests; we'll only get one.
     */

    switch (reqinfo->mode)
    {
        case MODE_GET:
        {
            char pLicenseURI[NNN] = {0};
            FILE *pFile = fopen(BP3_LICENSE_URI_FILE, "r");
            if (pFile)
            {
                fgets(pLicenseURI, sizeof(pLicenseURI), pFile);
                fclose(pFile);
                snmp_set_var_typed_value(requests->requestvb, ASN_OCTET_STR, pLicenseURI, strlen(pLicenseURI));
            }
            else
                snmp_set_var_typed_value(requests->requestvb, ASN_OCTET_STR, "", 0);
        }
        break;

        /*
         * SET REQUEST
         *
         * multiple states in the transaction.  See:
         * http://www.net-snmp.org/tutorial-5/toolkit/mib_module/set-actions.jpg
         */
        case MODE_SET_RESERVE1:
            /* or you could use netsnmp_check_vb_type_and_size instead */
            ret = netsnmp_check_vb_type(requests->requestvb, ASN_OCTET_STR);
            if (ret != SNMP_ERR_NOERROR) {
                netsnmp_set_request_error(reqinfo, requests, ret);
            }
            if (!requests->requestvb->val.string || requests->requestvb->val_len <= BP3_PROVISION_TYPE_STRLEN) {
                ret = SNMP_ERR_GENERR;
                netsnmp_set_request_error(reqinfo, requests, ret);
            }
            break;

        case MODE_SET_RESERVE2:
            /*
             * XXX malloc "undo" storage buffer
             */
            break;

        case MODE_SET_FREE:
            /*
             * XXX: free resources allocated in RESERVE1 and/or
             * RESERVE2.  Something failed somewhere, and the states
             * below won't be called.
             */
            break;

        case MODE_SET_ACTION:
        {
            /* XXX: perform the value change here */
            bool bFound = false;
            FILE *pFile = NULL;
            char pLicenseURI[NNN] = {0};
            char pLocalLicenseFile[BP3_LOCAL_FILE_NAME_LEN] = {0};
            char pCmd[NNN] = {0};
            int i;

            if (!system("pgrep bp3 -a | grep -q provision"))
                return SNMP_ERR_NOERROR;

            memcpy(pLicenseURI, requests->requestvb->val.string, requests->requestvb->val_len);
            for (i = 0; i < BP3_LICENSE_TYPE_NUM; i++)
            {
                if (!strncmp(pLicenseURI, gBP3LicenseType[i], strlen(gBP3LicenseType[i])) &&
                        pLicenseURI[strlen(gBP3LicenseType[i])] == '|')
                {
                    bFound = true;
                    break;
                }
            }

            if (bFound)
            {
                remove(BP3_LICENSE_URI_FILE);
                getLocalLicenseFile(gBP3LicenseType[i], pLocalLicenseFile);
                if ((downloadFileFromURI(&pLicenseURI[strlen(gBP3LicenseType[i]) + 1], pLocalLicenseFile, BP3_LICENSE_DOWNLOAD_TIMEOUT)) != 0)
                {
                    snmp_log(LOG_ERR, "downloadFileFromURI failed!\n");
                    return SNMP_ERR_GENERR;
                }
                if ((pFile = fopen(BP3_LICENSE_URI_FILE, "w")) != NULL)
                {
                    fprintf(pFile, "%s", pLicenseURI);
                    fclose(pFile);
                }

                remove(BP3_PROVISION_LOG);
                if (!strcmp(gBP3LicenseType[i], BP3_PROVISION_TYPE_BFE))
                {
                    snprintf(pCmd, sizeof(pCmd), "cp -f %s %s", pLocalLicenseFile, BFE_LICENSE_RUN_PATH);
                    system(pCmd);
                    /* TBD: Invoke bfe_init on CM side */
                }
                else
                {
                    snprintf(pCmd, sizeof(pCmd), "bp3 provision %s &>%s &", gBP3LicenseType[i], BP3_PROVISION_LOG);
                    system(pCmd);
                }
            }
            else if ((parsePklURI(pLicenseURI, pCmd)) ==0)
            {
                remove(BP3_PROVISION_LOG);
                system(pCmd);
            }
            else
            {
                snmp_log(LOG_ERR, "Unknown provision type %s\n", pLicenseURI);
                return SNMP_ERR_WRONGVALUE;
            }
        }
        break;

        case MODE_SET_COMMIT:
            /*
             * XXX: delete temporary storage
             */
            break;

        case MODE_SET_UNDO:
            /*
             * XXX: UNDO and return to previous value for the object
             */
            break;

        default:
            /*
             * we should never get here, so this is a really bad error
             */
            snmp_log(LOG_ERR,
                     "unknown mode (%d) in handle_rgBfeBp3LicenseUri\n",
                     reqinfo->mode);
            return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}

int
handle_rgBfeBp3LicenseState(netsnmp_mib_handler *handler,
                               netsnmp_handler_registration *reginfo,
                               netsnmp_agent_request_info *reqinfo,
                               netsnmp_request_info *requests)
{
#ifdef BP3_STATE_TMP_FIX
    char pLicenseState[NNN] = "Unavailable";
#else
    char pLicenseState[NNN] = {0};
    FILE *pFile = NULL;
#endif

    /*
     * We are never called for a GETNEXT if it's registered as a
     * "instance", as it's "magically" handled for us.
     */

    /*
     * a instance handler also only hands us one request at a time, so
     * we don't need to loop over a list of requests; we'll only get one.
     */

    switch (reqinfo->mode)
    {
        case MODE_GET:
        {
#ifndef BP3_STATE_TMP_FIX
            /* Check if bp3 provision is running */
            if (!system("pgrep bp3 -a | grep -q provision"))
            {
                snprintf(pLicenseState, sizeof(pLicenseState), BP3_STATE_PROVISIONING);
            }
            /* Look up errors in /data/bp3_provision.log */
            else if ((!access(BP3_PROVISION_LOG, F_OK)) &&
                    (!system("grep -iq \""BP3_PROVISION_STATUS_ERROR"\" "BP3_PROVISION_LOG)))
            {
                char pError[16] = {0};
                pFile = popen("grep -i \""BP3_PROVISION_STATUS_ERROR"\" "BP3_PROVISION_LOG" | cut -d \' \' -f 3", "r");
                if (!pFile)
                {
                    snmp_log(LOG_ERR, "Check "BP3_PROVISION_LOG" failed!\n");
                    return SNMP_ERR_GENERR;
                }
                fgets(pError, sizeof(pError), pFile);
                pError[strlen(pError) - 1] = '\0';
                snprintf(pLicenseState, sizeof(pLicenseState), "Error %s", pError);
                pclose(pFile);
            }
            else
            {
                char pOutput[64] = {0};
                if ((pFile = popen("bp3 state | tail -n 1", "r")) == NULL)
                {
                    snmp_log(LOG_ERR, "Call bp3 state failed!\n");
                    return SNMP_ERR_GENERR;
                }
                fgets(pOutput, sizeof(pOutput), pFile);
                pOutput[strlen(pOutput) - 1] = '\0';
                pclose(pFile);

                if (!strncmp(pOutput, BP3_STATE_OUTPUT_PASS, strlen(BP3_STATE_OUTPUT_PASS)))
                    snprintf(pLicenseState, sizeof(pLicenseState), BP3_STATE_ACTIVE);
                else if (!strncmp(pOutput, BP3_STATE_OUTPUT_FAIL, strlen(BP3_STATE_OUTPUT_FAIL)))
                    snprintf(pLicenseState, sizeof(pLicenseState), BP3_STATE_ABSENT);
                else if (!strncmp(pOutput, BP3_STATE_OUTPUT_EXPIRED, strlen(BP3_STATE_OUTPUT_EXPIRED)))
                    snprintf(pLicenseState, sizeof(pLicenseState), BP3_STATE_EXPIRED);
                else
                {
                    snmp_log(LOG_ERR, "Call bp3 state failed with output %s!\n", pOutput);
                    return SNMP_ERR_GENERR;
                }
            }
#endif
            snmp_set_var_typed_value(requests->requestvb, ASN_OCTET_STR, pLicenseState, strlen(pLicenseState));
        }
        break;

        default:
        {
            /*
             * we should never get here, so this is a really bad error
             */
                snmp_log(LOG_ERR,
                         "unknown mode (%d) in handle_rgBfeBp3LicenseState\n",
                         reqinfo->mode);
            return SNMP_ERR_GENERR;
        }
    }

    return SNMP_ERR_NOERROR;
}
#endif
