/*
 * Note: this file originally auto-generated by mib2c using
 *        $
 */

#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>
#include "brcm_linux_system.h"
#include "bcm_net_snmp.h"

#define MAX_LINE_BUFF_SIZE      1024

#define FPM_BUFFER_SIZE_STR                     "Buffer Size (bytes)"
#define FPM_HEAD_OFFSET_STR                     "Offset (Head) (bytes)"
#define FPM_TAIL_PAD_STR                        "Pad (Tail) (bytes)"
#define FPM_POOL_PHYS_BASE_ADDRESS_STR          "Base Address (Phys)"
#define FPM_POOL_VIRT_BASE_ADDRESS_STR          "Base Address (Virt)"
#define FPM_POOL_SIZE_BYTES_STR                 "Pool Size (bytes)"
#define FPM_POOL_TOTAL_TOKENS_STR               "Total Tokens"
#define FPM_POOL_AVAILABLE_TOKENS_STR           "Available Tokens"
#define FPM_POOL_ALLOC_WEIGHT_STR               "Pool Alloc Weight"
#define FPM_POOL_FREE_WEIGHT_STR                "Pool Free Weight"
#define FPM_POOL_UNDERFLOW_COUNT_STR            "Underflow Count"
#define FPM_POOL_OVERFLOW_COUNT_STR             "Overflow Count"
#define FPM_POOL_ALLOC_FIFO_EMPTY_STR           "Alloc FIFO Empty"
#define FPM_POOL_ALLOC_FIFO_FULL_STR            "Alloc FIFO Full"
#define FPM_POOL_FREE_FIFO_EMPTY_STR            "Free FIFO Empty"
#define FPM_POOL_FREE_FIFO_FULL_STR             "Free FIFO Full"
#define FPM_POOL_FULL_STR                       "Pool Full"
#define FPM_POOL_INVALID_TOKEN_FREES_STR        "Not Valid Token Frees"
#define FPM_POOL_INVALID_TOKEN_MULTICOUNT_STR   "Not Valid Token Multicount"
#define FPM_POOL_MEM_CORRUPT_INTRS_STR   "Mem Corrupt Interrupts"


#define MEM_TOTAL_STR           "MemTotal:"
#define MEM_FREE_STR            "MemFree:"
#define MEM_AVAILABLE_STR       "MemAvailable:"
#define MEM_CACHED_STR          "Cached:"
#define MEM_ACTIVE_STR          "Active:"
#define MEM_INACTIVE_STR        "Inactive:"
#define MEM_ACTIVE_ANON_STR     "Active(anon):"
#define MEM_INACTIVE_ANON_STR   "Inactive(anon):"
#define MEM_ACTIVE_FILE_STR     "Active(file):"
#define MEM_INACTIVE_FILE_STR   "Inactive(file):"
#define MEM_HIGH_TOTAL_STR      "HighTotal:"
#define MEM_HIGH_FREE_STR       "HighFree:"
#define MEM_LOW_TOTAL_STR       "LowTotal:"
#define MEM_LOW_FREE_STR        "LowFree:"
#define MEM_VMALLOC_TOTAL_STR   "VmallocTotal:"
#define MEM_VMALLOC_USED_STR    "VmallocUsed:"
#define MEM_VMALLOC_CHUNK_STR   "VmallocChunk:"


#define MEM_BUDDYINFO_FILE "/proc/buddyinfo"
#define MEM_ZONE_ORDER_MAX 11


#define LINUX_SYSTEM_INFO_UPDATE_TIME 10
static struct timeval linux_system_fpm_time;
static struct timeval linux_system_mem_time;
static struct timeval linux_system_mem_fragmentation_time;


/*
 * get fpm value
 *
 * @param (IN) fpm_str - the fpm str to find
 * @param (OUT) value - the fpm value
 */
static int get_fpm_value(char *fpm_str, u_long *value)
{
    char line[MAX_LINE_BUFF_SIZE];
    char fpmfile[16];
    FILE* fs = NULL;
    int len = 0;
    char *p;
    int numScanned ;
    int ret = -1;
    struct timeval tv_now;

    len = strlen(fpm_str);
    if(len >= MAX_LINE_BUFF_SIZE)
    {
        snmp_log(LOG_ERR, "The length of fpm string [%d] >= max line buffer size (%d)\n",
                                len, MAX_LINE_BUFF_SIZE);
        return ret;
    }

    sprintf(fpmfile, "/var/fpmstats");

    gettimeofday(&tv_now, NULL);
	if( tv_now.tv_sec - linux_system_fpm_time.tv_sec >= LINUX_SYSTEM_INFO_UPDATE_TIME)
    {
        snprintf(line, sizeof(line), "cat /proc/driver/fpm/stats > %s", fpmfile);
        system(line);
        linux_system_fpm_time = tv_now;
    }
    if ((fs = fopen(fpmfile, "r")) != NULL)
    {
        while (fgets(line, sizeof(line), fs))
        {
            if (strncmp(line, fpm_str, len) == 0)
            {
                p = line + len;
                numScanned = sscanf(p, "%*[.]%lul", value);
                if(numScanned == 1)
                {
                    ret = 0;
                }
                break;
            }
        }
        fclose(fs);
    }

    return ret;
}
/*
 * get mem value
 *
 * @param (IN) mem_str - the mem str to find
 * @param (OUT) value - the mem value
 */
static int get_mem_value(char *mem_str, u_long *value)
{
    char line[MAX_LINE_BUFF_SIZE];
    char memfile[16];
    FILE* fs = NULL;
    int len = 0;
    char *p;
    int numScanned ;
    int ret = -1;
    struct timeval tv_now;

    len = strlen(mem_str);
    if(len >= MAX_LINE_BUFF_SIZE)
    {
        snmp_log(LOG_ERR, "The length of mem string [%d] >= max line buffer size (%d)\n",
                                len, MAX_LINE_BUFF_SIZE);
        return ret;
    }

    sprintf(memfile, "/var/meminfo");

    gettimeofday(&tv_now, NULL);
	if( tv_now.tv_sec - linux_system_mem_time.tv_sec >= LINUX_SYSTEM_INFO_UPDATE_TIME)
	{
        snprintf(line, sizeof(line), "cat /proc/meminfo > %s", memfile);
        system(line);
        linux_system_mem_time = tv_now;
    }

    if ((fs = fopen(memfile, "r")) != NULL)
    {
        while (fgets(line, sizeof(line), fs))
        {
            if (strncmp(line, mem_str, len) == 0)
            {
                p = line + len;
                numScanned = sscanf(p, "%*[ ]%lul%*[ ]kB", value);
                if(numScanned == 1)
                {
                    ret = 0;
                }
                break;
            }
        }
        fclose(fs);
    }

    return ret;
}

/*
 * get mem value
 */
static long get_mem_fragmentation_ratio(void)
{
    static long mem_fragmentation_ratio = -1;
    FILE* fs = NULL;
    char line[MAX_LINE_BUFF_SIZE];
    int node_id, i, j, valid_zone = 0;
    char mem_type[16] = {0};
    long zone_info_read[MEM_ZONE_ORDER_MAX] = {0};
    long zone_info[MEM_ZONE_ORDER_MAX]= {0};
    long total_free_pages = 0, total_free_pages_curr_zone = 0;
    long free_pages_per_zone[MEM_ZONE_ORDER_MAX] = {0};
    struct timeval tv_now;

    gettimeofday(&tv_now, NULL);
    if (tv_now.tv_sec - linux_system_mem_fragmentation_time.tv_sec < LINUX_SYSTEM_INFO_UPDATE_TIME
        && mem_fragmentation_ratio >=0)
    {
        linux_system_mem_fragmentation_time = tv_now;
        return mem_fragmentation_ratio;
    }

    /* Get free pages from each zone from /proc/buddyinfo */
    fs = fopen(MEM_BUDDYINFO_FILE, "r");
    if (fs == NULL)
    {
        snmp_log(LOG_ERR, "Failed to open %s\n", MEM_BUDDYINFO_FILE);
        return mem_fragmentation_ratio;
    }

    while (fgets(line, sizeof(line), fs))
    {
        if ((sscanf(line, "Node %d, zone %8s %6lu %6lu %6lu %6lu  %6lu  %6lu  %6lu  %6lu  %6lu  %6lu  %6lu ",
            &node_id, mem_type, &zone_info_read[0], &zone_info_read[1], &zone_info_read[2], &zone_info_read[3],
            &zone_info_read[4], &zone_info_read[5], &zone_info_read[6], &zone_info_read[7], &zone_info_read[8],
            &zone_info_read[9], &zone_info_read[10])) != 13)
            continue;
        else
            valid_zone = 1;

        /* Sum all normal zone info from each node */
        for (i = 0; i < MEM_ZONE_ORDER_MAX; i++)
            zone_info[i] += zone_info_read[i];
    }
    fclose(fs);

    if (!valid_zone)
        return -1;

    for (i = 0; i < MEM_ZONE_ORDER_MAX; i++)
    {
        /* Calculate free pages from current zone */
        for (j = i; j < MEM_ZONE_ORDER_MAX; j++)
            free_pages_per_zone[i] += zone_info[j] * (1 << j);

        /* Total free pages equals the free pages from zone 0*/
        if (i == 0)
            total_free_pages = free_pages_per_zone[i];

        /* Sum the outcome */
        total_free_pages_curr_zone += free_pages_per_zone[i];
    }

    if (total_free_pages)
    {
        /* Calculate the average fragmentation ratio */
        mem_fragmentation_ratio = (total_free_pages * MEM_ZONE_ORDER_MAX - total_free_pages_curr_zone) * 100 /
            (total_free_pages * MEM_ZONE_ORDER_MAX);
    }
    else
    {
        /* No free pages, 100% fragment */
        mem_fragmentation_ratio = 100;
    }

    return mem_fragmentation_ratio;
}


/** Initializes the brcm_linux_system module */
void
init_brcm_linux_system(void)
{
    const oid linuxFpmBufferSizeBytes_oid[] = { 1,3,6,1,4,1,4413,2,2,2,1,21,1,1,1 };
    const oid linuxFpmHeadOffsetBytes_oid[] = { 1,3,6,1,4,1,4413,2,2,2,1,21,1,1,2 };
    const oid linuxFpmTailPadBytes_oid[] = { 1,3,6,1,4,1,4413,2,2,2,1,21,1,1,3 };
    const oid linuxMemTotal_oid[] = { 1,3,6,1,4,1,4413,2,2,2,1,21,1,2,1 };
    const oid linuxMemFree_oid[] = { 1,3,6,1,4,1,4413,2,2,2,1,21,1,2,2 };
    const oid linuxMemAvailable_oid[] = { 1,3,6,1,4,1,4413,2,2,2,1,21,1,2,3 };
    const oid linuxMemCached_oid[] = { 1,3,6,1,4,1,4413,2,2,2,1,21,1,2,4 };
    const oid linuxMemActive_oid[] = { 1,3,6,1,4,1,4413,2,2,2,1,21,1,2,5 };
    const oid linuxMemInactive_oid[] = { 1,3,6,1,4,1,4413,2,2,2,1,21,1,2,6 };
    const oid linuxMemActiveAnon_oid[] = { 1,3,6,1,4,1,4413,2,2,2,1,21,1,2,7 };
    const oid linuxMemInactiveAnon_oid[] = { 1,3,6,1,4,1,4413,2,2,2,1,21,1,2,8 };
    const oid linuxMemActiveFile_oid[] = { 1,3,6,1,4,1,4413,2,2,2,1,21,1,2,9 };
    const oid linuxMemInactiveFile_oid[] = { 1,3,6,1,4,1,4413,2,2,2,1,21,1,2,10 };
    const oid linuxMemHighTotal_oid[] = { 1,3,6,1,4,1,4413,2,2,2,1,21,1,2,11 };
    const oid linuxMemHighFree_oid[] = { 1,3,6,1,4,1,4413,2,2,2,1,21,1,2,12 };
    const oid linuxMemLowTotal_oid[] = { 1,3,6,1,4,1,4413,2,2,2,1,21,1,2,13 };
    const oid linuxMemLowFree_oid[] = { 1,3,6,1,4,1,4413,2,2,2,1,21,1,2,14 };
    const oid linuxMemVmallocTotal_oid[] = { 1,3,6,1,4,1,4413,2,2,2,1,21,1,2,15 };
    const oid linuxMemVmallocUsed_oid[] = { 1,3,6,1,4,1,4413,2,2,2,1,21,1,2,16 };
    const oid linuxMemVmallocChunk_oid[] = { 1,3,6,1,4,1,4413,2,2,2,1,21,1,2,17 };
    const oid linuxMemFragmentationRatio_oid[] = { 1,3,6,1,4,1,4413,2,2,2,1,21,1,2,18 };

    DEBUGMSGTL(("brcm_linux_system", "Initializing\n"));

    memset(&linux_system_fpm_time, 0, sizeof(struct timeval));
    memset(&linux_system_mem_time, 0, sizeof(struct timeval));
    memset(&linux_system_mem_fragmentation_time, 0, sizeof(struct timeval));

    netsnmp_register_scalar(
        netsnmp_create_handler_registration("linuxFpmBufferSizeBytes", handle_linuxFpmBufferSizeBytes,
                               linuxFpmBufferSizeBytes_oid, OID_LENGTH(linuxFpmBufferSizeBytes_oid),
                               HANDLER_CAN_RONLY
        ));
    netsnmp_register_scalar(
        netsnmp_create_handler_registration("linuxFpmHeadOffsetBytes", handle_linuxFpmHeadOffsetBytes,
                               linuxFpmHeadOffsetBytes_oid, OID_LENGTH(linuxFpmHeadOffsetBytes_oid),
                               HANDLER_CAN_RONLY
        ));
    netsnmp_register_scalar(
        netsnmp_create_handler_registration("linuxFpmTailPadBytes", handle_linuxFpmTailPadBytes,
                               linuxFpmTailPadBytes_oid, OID_LENGTH(linuxFpmTailPadBytes_oid),
                               HANDLER_CAN_RONLY
        ));
    netsnmp_register_scalar(
        netsnmp_create_handler_registration("linuxMemTotal", handle_linuxMemTotal,
                               linuxMemTotal_oid, OID_LENGTH(linuxMemTotal_oid),
                               HANDLER_CAN_RONLY
        ));
    netsnmp_register_scalar(
        netsnmp_create_handler_registration("linuxMemFree", handle_linuxMemFree,
                               linuxMemFree_oid, OID_LENGTH(linuxMemFree_oid),
                               HANDLER_CAN_RONLY
        ));
    netsnmp_register_scalar(
        netsnmp_create_handler_registration("linuxMemAvailable", handle_linuxMemAvailable,
                               linuxMemAvailable_oid, OID_LENGTH(linuxMemAvailable_oid),
                               HANDLER_CAN_RONLY
        ));
    netsnmp_register_scalar(
        netsnmp_create_handler_registration("linuxMemCached", handle_linuxMemCached,
                               linuxMemCached_oid, OID_LENGTH(linuxMemCached_oid),
                               HANDLER_CAN_RONLY
        ));
    netsnmp_register_scalar(
        netsnmp_create_handler_registration("linuxMemActive", handle_linuxMemActive,
                               linuxMemActive_oid, OID_LENGTH(linuxMemActive_oid),
                               HANDLER_CAN_RONLY
        ));
    netsnmp_register_scalar(
        netsnmp_create_handler_registration("linuxMemInactive", handle_linuxMemInactive,
                               linuxMemInactive_oid, OID_LENGTH(linuxMemInactive_oid),
                               HANDLER_CAN_RONLY
        ));
    netsnmp_register_scalar(
        netsnmp_create_handler_registration("linuxMemActiveAnon", handle_linuxMemActiveAnon,
                               linuxMemActiveAnon_oid, OID_LENGTH(linuxMemActiveAnon_oid),
                               HANDLER_CAN_RONLY
        ));
    netsnmp_register_scalar(
        netsnmp_create_handler_registration("linuxMemInactiveAnon", handle_linuxMemInactiveAnon,
                               linuxMemInactiveAnon_oid, OID_LENGTH(linuxMemInactiveAnon_oid),
                               HANDLER_CAN_RONLY
        ));
    netsnmp_register_scalar(
        netsnmp_create_handler_registration("linuxMemActiveFile", handle_linuxMemActiveFile,
                               linuxMemActiveFile_oid, OID_LENGTH(linuxMemActiveFile_oid),
                               HANDLER_CAN_RONLY
        ));
    netsnmp_register_scalar(
        netsnmp_create_handler_registration("linuxMemInactiveFile", handle_linuxMemInactiveFile,
                               linuxMemInactiveFile_oid, OID_LENGTH(linuxMemInactiveFile_oid),
                               HANDLER_CAN_RONLY
        ));
    netsnmp_register_scalar(
        netsnmp_create_handler_registration("linuxMemHighTotal", handle_linuxMemHighTotal,
                               linuxMemHighTotal_oid, OID_LENGTH(linuxMemHighTotal_oid),
                               HANDLER_CAN_RONLY
        ));
    netsnmp_register_scalar(
        netsnmp_create_handler_registration("linuxMemHighFree", handle_linuxMemHighFree,
                               linuxMemHighFree_oid, OID_LENGTH(linuxMemHighFree_oid),
                               HANDLER_CAN_RONLY
        ));
    netsnmp_register_scalar(
        netsnmp_create_handler_registration("linuxMemLowTotal", handle_linuxMemLowTotal,
                               linuxMemLowTotal_oid, OID_LENGTH(linuxMemLowTotal_oid),
                               HANDLER_CAN_RONLY
        ));
    netsnmp_register_scalar(
        netsnmp_create_handler_registration("linuxMemLowFree", handle_linuxMemLowFree,
                               linuxMemLowFree_oid, OID_LENGTH(linuxMemLowFree_oid),
                               HANDLER_CAN_RONLY
        ));
    netsnmp_register_scalar(
        netsnmp_create_handler_registration("linuxMemVmallocTotal", handle_linuxMemVmallocTotal,
                               linuxMemVmallocTotal_oid, OID_LENGTH(linuxMemVmallocTotal_oid),
                               HANDLER_CAN_RONLY
        ));
    netsnmp_register_scalar(
        netsnmp_create_handler_registration("linuxMemVmallocUsed", handle_linuxMemVmallocUsed,
                               linuxMemVmallocUsed_oid, OID_LENGTH(linuxMemVmallocUsed_oid),
                               HANDLER_CAN_RONLY
        ));
    netsnmp_register_scalar(
        netsnmp_create_handler_registration("linuxMemVmallocChunk", handle_linuxMemVmallocChunk,
                               linuxMemVmallocChunk_oid, OID_LENGTH(linuxMemVmallocChunk_oid),
                               HANDLER_CAN_RONLY
        ));
    netsnmp_register_scalar(
        netsnmp_create_handler_registration("linuxMemFragmentationRatio", handle_linuxMemFragmentationRatio,
                               linuxMemFragmentationRatio_oid, OID_LENGTH(linuxMemFragmentationRatio_oid),
                               HANDLER_CAN_RONLY
        ));
    initialize_table_linuxFpmPoolTable();
}

int
handle_linuxFpmBufferSizeBytes(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info   *reqinfo,
                          netsnmp_request_info         *requests)
{
    u_long value = 0;
    int ret = 0;
    /* We are never called for a GETNEXT if it's registered as a
       "instance", as it's "magically" handled for us.  */

    /* a instance handler also only hands us one request at a time, so
       we don't need to loop over a list of requests; we'll only get one. */

    switch(reqinfo->mode) {

        case MODE_GET:
            ret = get_fpm_value(FPM_BUFFER_SIZE_STR, &value);
            if(ret)
            {
                snmp_log(LOG_ERR, "Can't find fpm %s\n", FPM_BUFFER_SIZE_STR);
                value = 0;
            }
            snmp_set_var_typed_value(requests->requestvb, ASN_GAUGE,
                                     (u_char *) &value,
                                     sizeof(value));
            break;

        default:
            /* we should never get here, so this is a really bad error */
            snmp_log(LOG_ERR, "unknown mode (%d) in handle_linuxFpmBufferSizeBytes\n", reqinfo->mode );
            return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}
int
handle_linuxFpmHeadOffsetBytes(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info   *reqinfo,
                          netsnmp_request_info         *requests)
{
    u_long value = 0;
    int ret = 0;

    /* We are never called for a GETNEXT if it's registered as a
       "instance", as it's "magically" handled for us.  */

    /* a instance handler also only hands us one request at a time, so
       we don't need to loop over a list of requests; we'll only get one. */

    switch(reqinfo->mode) {

        case MODE_GET:
            ret = get_fpm_value(FPM_HEAD_OFFSET_STR, &value);
            if(ret)
            {
                snmp_log(LOG_ERR, "Can't find fpm %s\n", FPM_HEAD_OFFSET_STR);
                value = 0;
            }
            snmp_set_var_typed_value(requests->requestvb, ASN_GAUGE,
                                     (u_char *) &value,
                                     sizeof(value));
            break;

        default:
            /* we should never get here, so this is a really bad error */
            snmp_log(LOG_ERR, "unknown mode (%d) in handle_linuxFpmHeadOffsetBytes\n", reqinfo->mode );
            return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}
int
handle_linuxFpmTailPadBytes(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info   *reqinfo,
                          netsnmp_request_info         *requests)
{
    u_long value = 0;
    int ret = 0;

    /* We are never called for a GETNEXT if it's registered as a
       "instance", as it's "magically" handled for us.  */

    /* a instance handler also only hands us one request at a time, so
       we don't need to loop over a list of requests; we'll only get one. */

    switch(reqinfo->mode) {

        case MODE_GET:
            ret = get_fpm_value(FPM_TAIL_PAD_STR, &value);
            if(ret)
            {
                snmp_log(LOG_ERR, "Can't find fpm %s\n", FPM_TAIL_PAD_STR);
                value = 0;
            }
            snmp_set_var_typed_value(requests->requestvb, ASN_GAUGE,
                                     (u_char *) &value,
                                     sizeof(value));
            break;

        default:
            /* we should never get here, so this is a really bad error */
            snmp_log(LOG_ERR, "unknown mode (%d) in handle_linuxFpmTailPadBytes\n", reqinfo->mode );
            return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}
int
handle_linuxMemTotal(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info   *reqinfo,
                          netsnmp_request_info         *requests)
{
    u_long value = 0;
    int ret = 0;

    /* We are never called for a GETNEXT if it's registered as a
       "instance", as it's "magically" handled for us.  */

    /* a instance handler also only hands us one request at a time, so
       we don't need to loop over a list of requests; we'll only get one. */

    switch(reqinfo->mode) {
        case MODE_GET:
            ret = get_mem_value(MEM_TOTAL_STR, &value);
            if(ret)
            {
                snmp_log(LOG_ERR, "Can't find mem %s\n", MEM_TOTAL_STR);
                value = 0;
            }
            snmp_set_var_typed_value(requests->requestvb, ASN_UNSIGNED,
                                     &value,
                                     sizeof(value));
            break;

        default:
            /* we should never get here, so this is a really bad error */
            snmp_log(LOG_ERR, "unknown mode (%d) in handle_linuxMemTotal\n", reqinfo->mode );
            return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}

int
handle_linuxMemFree(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info   *reqinfo,
                          netsnmp_request_info         *requests)
{
    u_long value = 0;
    int ret = 0;

    /* We are never called for a GETNEXT if it's registered as a
       "instance", as it's "magically" handled for us.  */

    /* a instance handler also only hands us one request at a time, so
       we don't need to loop over a list of requests; we'll only get one. */

    switch(reqinfo->mode) {
        case MODE_GET:
            ret = get_mem_value(MEM_FREE_STR, &value);
            if(ret)
            {
                snmp_log(LOG_ERR, "Can't find mem %s\n", MEM_FREE_STR);
                value = 0;
            }
            snmp_set_var_typed_value(requests->requestvb, ASN_UNSIGNED,
                                     &value,
                                     sizeof(value));
            break;

        default:
            /* we should never get here, so this is a really bad error */
            snmp_log(LOG_ERR, "unknown mode (%d) in handle_linuxMemFree\n", reqinfo->mode );
            return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}
int
handle_linuxMemAvailable(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info   *reqinfo,
                          netsnmp_request_info         *requests)
{
    u_long value = 0;
    int ret = 0;

    /* We are never called for a GETNEXT if it's registered as a
       "instance", as it's "magically" handled for us.  */

    /* a instance handler also only hands us one request at a time, so
       we don't need to loop over a list of requests; we'll only get one. */

    switch(reqinfo->mode) {
        case MODE_GET:
            ret = get_mem_value(MEM_AVAILABLE_STR, &value);
            if(ret)
            {
                snmp_log(LOG_ERR, "Can't find mem %s\n", MEM_AVAILABLE_STR);
                value = 0;
            }
            snmp_set_var_typed_value(requests->requestvb, ASN_UNSIGNED,
                                     &value,
                                     sizeof(value));
            break;

        default:
            /* we should never get here, so this is a really bad error */
            snmp_log(LOG_ERR, "unknown mode (%d) in handle_linuxMemAvailable\n", reqinfo->mode );
            return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}
int
handle_linuxMemCached(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info   *reqinfo,
                          netsnmp_request_info         *requests)
{
    u_long value = 0;
    int ret = 0;

    /* We are never called for a GETNEXT if it's registered as a
       "instance", as it's "magically" handled for us.  */

    /* a instance handler also only hands us one request at a time, so
       we don't need to loop over a list of requests; we'll only get one. */

    switch(reqinfo->mode) {
        case MODE_GET:
            ret = get_mem_value(MEM_CACHED_STR, &value);
            if(ret)
            {
                snmp_log(LOG_ERR, "Can't find mem %s\n", MEM_CACHED_STR);
                value = 0;
            }
            snmp_set_var_typed_value(requests->requestvb, ASN_UNSIGNED,
                                     &value,
                                     sizeof(value));
            break;

        default:
            /* we should never get here, so this is a really bad error */
            snmp_log(LOG_ERR, "unknown mode (%d) in handle_linuxMemCached\n", reqinfo->mode );
            return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}
int
handle_linuxMemActive(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info   *reqinfo,
                          netsnmp_request_info         *requests)
{
    u_long value = 0;
    int ret = 0;

    /* We are never called for a GETNEXT if it's registered as a
       "instance", as it's "magically" handled for us.  */

    /* a instance handler also only hands us one request at a time, so
       we don't need to loop over a list of requests; we'll only get one. */

    switch(reqinfo->mode) {
        case MODE_GET:
            ret = get_mem_value(MEM_ACTIVE_STR, &value);
            if(ret)
            {
                snmp_log(LOG_ERR, "Can't find mem %s\n", MEM_ACTIVE_STR);
                value = 0;
            }
            snmp_set_var_typed_value(requests->requestvb, ASN_UNSIGNED,
                                     &value,
                                     sizeof(value));
            break;

        default:
            /* we should never get here, so this is a really bad error */
            snmp_log(LOG_ERR, "unknown mode (%d) in handle_linuxMemActive\n", reqinfo->mode );
            return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}
int
handle_linuxMemInactive(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info   *reqinfo,
                          netsnmp_request_info         *requests)
{
    u_long value = 0;
    int ret = 0;

    /* We are never called for a GETNEXT if it's registered as a
       "instance", as it's "magically" handled for us.  */

    /* a instance handler also only hands us one request at a time, so
       we don't need to loop over a list of requests; we'll only get one. */

    switch(reqinfo->mode) {
        case MODE_GET:
            ret = get_mem_value(MEM_INACTIVE_STR, &value);
            if(ret)
            {
                snmp_log(LOG_ERR, "Can't find mem %s\n", MEM_INACTIVE_STR);
                value = 0;
            }
            snmp_set_var_typed_value(requests->requestvb, ASN_UNSIGNED,
                                     &value,
                                     sizeof(value));
            break;

        default:
            /* we should never get here, so this is a really bad error */
            snmp_log(LOG_ERR, "unknown mode (%d) in handle_linuxMemInactive\n", reqinfo->mode );
            return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}
int
handle_linuxMemActiveAnon(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info   *reqinfo,
                          netsnmp_request_info         *requests)
{
    u_long value = 0;
    int ret = 0;

    /* We are never called for a GETNEXT if it's registered as a
       "instance", as it's "magically" handled for us.  */

    /* a instance handler also only hands us one request at a time, so
       we don't need to loop over a list of requests; we'll only get one. */

    switch(reqinfo->mode) {
        case MODE_GET:
            ret = get_mem_value(MEM_ACTIVE_ANON_STR, &value);
            if(ret)
            {
                snmp_log(LOG_ERR, "Can't find mem %s\n", MEM_ACTIVE_ANON_STR);
                value = 0;
            }
            snmp_set_var_typed_value(requests->requestvb, ASN_UNSIGNED,
                                     &value,
                                     sizeof(value));
            break;

        default:
            /* we should never get here, so this is a really bad error */
            snmp_log(LOG_ERR, "unknown mode (%d) in handle_linuxMemActiveAnon\n", reqinfo->mode );
            return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}
int
handle_linuxMemInactiveAnon(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info   *reqinfo,
                          netsnmp_request_info         *requests)
{
    u_long value = 0;
    int ret = 0;

    /* We are never called for a GETNEXT if it's registered as a
       "instance", as it's "magically" handled for us.  */

    /* a instance handler also only hands us one request at a time, so
       we don't need to loop over a list of requests; we'll only get one. */

    switch(reqinfo->mode) {
        case MODE_GET:
            ret = get_mem_value(MEM_INACTIVE_ANON_STR, &value);
            if(ret)
            {
                snmp_log(LOG_ERR, "Can't find mem %s\n", MEM_INACTIVE_ANON_STR);
                value = 0;
            }
            snmp_set_var_typed_value(requests->requestvb, ASN_UNSIGNED,
                                     &value,
                                     sizeof(value));
            break;

        default:
            /* we should never get here, so this is a really bad error */
            snmp_log(LOG_ERR, "unknown mode (%d) in handle_linuxMemInactiveAnon\n", reqinfo->mode );
            return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}
int
handle_linuxMemActiveFile(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info   *reqinfo,
                          netsnmp_request_info         *requests)
{
    u_long value = 0;
    int ret = 0;

    /* We are never called for a GETNEXT if it's registered as a
       "instance", as it's "magically" handled for us.  */

    /* a instance handler also only hands us one request at a time, so
       we don't need to loop over a list of requests; we'll only get one. */

    switch(reqinfo->mode) {
        case MODE_GET:
            ret = get_mem_value(MEM_ACTIVE_FILE_STR, &value);
            if(ret)
            {
                snmp_log(LOG_ERR, "Can't find mem %s\n", MEM_ACTIVE_FILE_STR);
                value = 0;
            }
            snmp_set_var_typed_value(requests->requestvb, ASN_UNSIGNED,
                                     &value,
                                     sizeof(value));
            break;

        default:
            /* we should never get here, so this is a really bad error */
            snmp_log(LOG_ERR, "unknown mode (%d) in handle_linuxMemActiveFile\n", reqinfo->mode );
            return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}
int
handle_linuxMemInactiveFile(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info   *reqinfo,
                          netsnmp_request_info         *requests)
{
    u_long value = 0;
    int ret = 0;

    /* We are never called for a GETNEXT if it's registered as a
       "instance", as it's "magically" handled for us.  */

    /* a instance handler also only hands us one request at a time, so
       we don't need to loop over a list of requests; we'll only get one. */

    switch(reqinfo->mode) {
        case MODE_GET:
            ret = get_mem_value(MEM_INACTIVE_FILE_STR, &value);
            if(ret)
            {
                snmp_log(LOG_ERR, "Can't find mem %s\n", MEM_INACTIVE_FILE_STR);
                value = 0;
            }
            snmp_set_var_typed_value(requests->requestvb, ASN_UNSIGNED,
                                     &value,
                                     sizeof(value));
            break;

        default:
            /* we should never get here, so this is a really bad error */
            snmp_log(LOG_ERR, "unknown mode (%d) in handle_linuxMemInactiveFile\n", reqinfo->mode );
            return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}
int
handle_linuxMemHighTotal(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info   *reqinfo,
                          netsnmp_request_info         *requests)
{
    u_long value = 0;
    int ret = 0;

    /* We are never called for a GETNEXT if it's registered as a
       "instance", as it's "magically" handled for us.  */

    /* a instance handler also only hands us one request at a time, so
       we don't need to loop over a list of requests; we'll only get one. */

    switch(reqinfo->mode) {
        case MODE_GET:
            ret = get_mem_value(MEM_HIGH_TOTAL_STR, &value);
            if(ret)
            {
                snmp_log(LOG_ERR, "Can't find mem %s\n", MEM_HIGH_TOTAL_STR);
                value = 0;
            }
            snmp_set_var_typed_value(requests->requestvb, ASN_UNSIGNED,
                                     &value,
                                     sizeof(value));
            break;

        default:
            /* we should never get here, so this is a really bad error */
            snmp_log(LOG_ERR, "unknown mode (%d) in handle_linuxMemHighTotal\n", reqinfo->mode );
            return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}
int
handle_linuxMemHighFree(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info   *reqinfo,
                          netsnmp_request_info         *requests)
{
    u_long value = 0;
    int ret = 0;

    /* We are never called for a GETNEXT if it's registered as a
       "instance", as it's "magically" handled for us.  */

    /* a instance handler also only hands us one request at a time, so
       we don't need to loop over a list of requests; we'll only get one. */

    switch(reqinfo->mode) {
        case MODE_GET:
            ret = get_mem_value(MEM_HIGH_FREE_STR, &value);
            if(ret)
            {
                snmp_log(LOG_ERR, "Can't find mem %s\n", MEM_HIGH_FREE_STR);
                value = 0;
            }
            snmp_set_var_typed_value(requests->requestvb, ASN_UNSIGNED,
                                     &value,
                                     sizeof(value));
            break;

        default:
            /* we should never get here, so this is a really bad error */
            snmp_log(LOG_ERR, "unknown mode (%d) in handle_linuxMemHighFree\n", reqinfo->mode );
            return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}
int
handle_linuxMemLowTotal(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info   *reqinfo,
                          netsnmp_request_info         *requests)
{
    u_long value = 0;
    int ret = 0;

    /* We are never called for a GETNEXT if it's registered as a
       "instance", as it's "magically" handled for us.  */

    /* a instance handler also only hands us one request at a time, so
       we don't need to loop over a list of requests; we'll only get one. */

    switch(reqinfo->mode) {
        case MODE_GET:
            ret = get_mem_value(MEM_LOW_TOTAL_STR, &value);
            if(ret)
            {
                snmp_log(LOG_ERR, "Can't find mem %s\n", MEM_LOW_TOTAL_STR);
                value = 0;
            }
            snmp_set_var_typed_value(requests->requestvb, ASN_UNSIGNED,
                                     &value,
                                     sizeof(value));
            break;

        default:
            /* we should never get here, so this is a really bad error */
            snmp_log(LOG_ERR, "unknown mode (%d) in handle_linuxMemLowTotal\n", reqinfo->mode );
            return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}
int
handle_linuxMemLowFree(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info   *reqinfo,
                          netsnmp_request_info         *requests)
{
    u_long value = 0;
    int ret = 0;

    /* We are never called for a GETNEXT if it's registered as a
       "instance", as it's "magically" handled for us.  */

    /* a instance handler also only hands us one request at a time, so
       we don't need to loop over a list of requests; we'll only get one. */

    switch(reqinfo->mode) {
        case MODE_GET:
            ret = get_mem_value(MEM_LOW_FREE_STR, &value);
            if(ret)
            {
                snmp_log(LOG_ERR, "Can't find mem %s\n", MEM_LOW_FREE_STR);
                value = 0;
            }
            snmp_set_var_typed_value(requests->requestvb, ASN_UNSIGNED,
                                     &value,
                                     sizeof(value));
            break;

        default:
            /* we should never get here, so this is a really bad error */
            snmp_log(LOG_ERR, "unknown mode (%d) in handle_linuxMemLowFree\n", reqinfo->mode );
            return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}
int
handle_linuxMemVmallocTotal(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info   *reqinfo,
                          netsnmp_request_info         *requests)
{
    u_long value = 0;
    int ret = 0;

    /* We are never called for a GETNEXT if it's registered as a
       "instance", as it's "magically" handled for us.  */

    /* a instance handler also only hands us one request at a time, so
       we don't need to loop over a list of requests; we'll only get one. */

    switch(reqinfo->mode) {
        case MODE_GET:
            ret = get_mem_value(MEM_VMALLOC_TOTAL_STR, &value);
            if(ret)
            {
                snmp_log(LOG_ERR, "Can't find mem %s\n", MEM_VMALLOC_TOTAL_STR);
                value = 0;
            }
            snmp_set_var_typed_value(requests->requestvb, ASN_UNSIGNED,
                                     &value,
                                     sizeof(value));
            break;

        default:
            /* we should never get here, so this is a really bad error */
            snmp_log(LOG_ERR, "unknown mode (%d) in handle_linuxMemVmallocTotal\n", reqinfo->mode );
            return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}
int
handle_linuxMemVmallocUsed(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info   *reqinfo,
                          netsnmp_request_info         *requests)
{
    u_long value = 0;
    int ret = 0;

    /* We are never called for a GETNEXT if it's registered as a
       "instance", as it's "magically" handled for us.  */

    /* a instance handler also only hands us one request at a time, so
       we don't need to loop over a list of requests; we'll only get one. */

    switch(reqinfo->mode) {
        case MODE_GET:
            ret = get_mem_value(MEM_VMALLOC_USED_STR, &value);
            if(ret)
            {
                snmp_log(LOG_ERR, "Can't find mem %s\n", MEM_VMALLOC_USED_STR);
                value = 0;
            }
            snmp_set_var_typed_value(requests->requestvb, ASN_UNSIGNED,
                                     &value,
                                     sizeof(value));
            break;

        default:
            /* we should never get here, so this is a really bad error */
            snmp_log(LOG_ERR, "unknown mode (%d) in handle_linuxMemVmallocUsed\n", reqinfo->mode );
            return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}
int
handle_linuxMemVmallocChunk(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info   *reqinfo,
                          netsnmp_request_info         *requests)
{
    u_long value = 0;
    int ret = 0;

    /* We are never called for a GETNEXT if it's registered as a
       "instance", as it's "magically" handled for us.  */

    /* a instance handler also only hands us one request at a time, so
       we don't need to loop over a list of requests; we'll only get one. */

    switch(reqinfo->mode) {
        case MODE_GET:
            ret = get_mem_value(MEM_VMALLOC_CHUNK_STR, &value);
            if(ret)
            {
                snmp_log(LOG_ERR, "Can't find mem %s\n", MEM_VMALLOC_CHUNK_STR);
                value = 0;
            }
            snmp_set_var_typed_value(requests->requestvb, ASN_UNSIGNED,
                                     &value,
                                     sizeof(value));
            break;

        default:
            /* we should never get here, so this is a really bad error */
            snmp_log(LOG_ERR, "unknown mode (%d) in handle_linuxMemVmallocChunk\n", reqinfo->mode );
            return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}
int
handle_linuxMemFragmentationRatio(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info   *reqinfo,
                          netsnmp_request_info         *requests)
{
    long value = 0;

    /* We are never called for a GETNEXT if it's registered as a
       "instance", as it's "magically" handled for us.  */

    /* a instance handler also only hands us one request at a time, so
       we don't need to loop over a list of requests; we'll only get one. */

    switch(reqinfo->mode) {

        case MODE_GET:
            value = get_mem_fragmentation_ratio();
            if(value < 0)
            {
                snmp_log(LOG_ERR, "Can't get fragmentation ratio\n");
            }
            snmp_set_var_typed_value(requests->requestvb, ASN_INTEGER,
                                     &value,
                                     sizeof(value));
            break;


        default:
            /* we should never get here, so this is a really bad error */
            snmp_log(LOG_ERR, "unknown mode (%d) in handle_linuxMemFragmentationRatio\n", reqinfo->mode );
            return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}

void
initialize_table_linuxFpmPoolTable(void)
{
    const oid linuxFpmPoolTable_oid[] = {1,3,6,1,4,1,4413,2,2,2,1,21,1,1,4};
    const size_t linuxFpmPoolTable_oid_len   = OID_LENGTH(linuxFpmPoolTable_oid);
    netsnmp_handler_registration    *reg;
    netsnmp_iterator_info           *iinfo;
    netsnmp_table_registration_info *table_info;

    DEBUGMSGTL(("brcm_linux_system:init", "initializing table linuxFpmPoolTable\n"));

    reg = netsnmp_create_handler_registration(
              "linuxFpmPoolTable",     linuxFpmPoolTable_handler,
              linuxFpmPoolTable_oid, linuxFpmPoolTable_oid_len,
              HANDLER_CAN_RONLY
              );

    table_info = SNMP_MALLOC_TYPEDEF( netsnmp_table_registration_info );
    netsnmp_table_helper_add_indexes(table_info,
                           ASN_INTEGER,  /* index: linuxFpmPoolIndex */
                           0);
    table_info->min_column = COLUMN_LINUXFPMPHYBASEADDRESS;
    table_info->max_column = COLUMN_LINUXFPMPOOLMEMORYCORRUPTIONIRQS;

    iinfo = SNMP_MALLOC_TYPEDEF( netsnmp_iterator_info );
    iinfo->get_first_data_point = linuxFpmPoolTable_get_first_data_point;
    iinfo->get_next_data_point  = linuxFpmPoolTable_get_next_data_point;
    iinfo->table_reginfo        = table_info;

    netsnmp_register_table_iterator( reg, iinfo );

    /* Initialise the contents of the table here */
}

    /* Typical data structure for a row entry */
struct linuxFpmPoolTable_entry {
    /* Index values */
    long linuxFpmPoolIndex;

    /* Column values */
    u_long linuxFpmPhyBaseAddress;
    u_long linuxFpmVirtBaseAddress;
    u_long linuxFpmPoolSizeBytes;
    u_long linuxFpmTokensTotal;
    u_long linuxFpmTokensAvailable;
    u_long linuxFpmPoolAllocWeight;
    u_long linuxFpmPoolFreeWeight;
    u_long linuxFpmPoolUnderflowCount;
    u_long linuxFpmPoolOverflowCount;
    long linuxFpmPoolAllocFifoEmpty;
    long linuxFpmPoolAllocFifoFull;
    long linuxFpmPoolFreeFifoEmpty;
    long linuxFpmPoolFreeFifoFull;
    long linuxFpmPoolFull;
    u_long linuxFpmPoolInvalidTokenFrees;
    u_long linuxFpmPoolInvalidTokenMulticount;
    u_long linuxFpmPoolMemoryCorruptionIrqs;

    /* Illustrate using a simple linked list */
    int   valid;
    struct linuxFpmPoolTable_entry *next;
};

struct linuxFpmPoolTable_entry  *linuxFpmPoolTable_head;

/* create a new row in the (unsorted) table */
struct linuxFpmPoolTable_entry *
linuxFpmPoolTable_createEntry(
                 long  linuxFpmPoolIndex
                ) {
    struct linuxFpmPoolTable_entry *entry;

    entry = SNMP_MALLOC_TYPEDEF(struct linuxFpmPoolTable_entry);
    if (!entry)
        return NULL;

    entry->linuxFpmPoolIndex = linuxFpmPoolIndex;
    entry->next = linuxFpmPoolTable_head;
    linuxFpmPoolTable_head = entry;
    return entry;
}

/* remove a row from the table */
void
linuxFpmPoolTable_removeEntry( struct linuxFpmPoolTable_entry *entry ) {
    struct linuxFpmPoolTable_entry *ptr, *prev;

    if (!entry)
        return;    /* Nothing to remove */

    for ( ptr  = linuxFpmPoolTable_head, prev = NULL;
          ptr != NULL;
          prev = ptr, ptr = ptr->next ) {
        if ( ptr == entry )
            break;
    }
    if ( !ptr )
        return;    /* Can't find it */

    if ( prev == NULL )
        linuxFpmPoolTable_head = ptr->next;
    else
        prev->next = ptr->next;

    SNMP_FREE( entry );   /* XXX - release any other internal resources */
}

void
linuxFpmPoolTable_rebuildTableData(void)
{
    char line[MAX_LINE_BUFF_SIZE];
    char fpmfile[16];
    FILE* fs = NULL;
    int len = 0;
    char *p;
    int numScanned ;
    struct timeval tv_now;
    int pool_num = 0;
    int in_pool = 0;
    struct linuxFpmPoolTable_entry *entry = NULL;
    u_long value;

    sprintf(fpmfile, "/var/fpmstats");

    gettimeofday(&tv_now, NULL);
	if( tv_now.tv_sec - linux_system_fpm_time.tv_sec >= LINUX_SYSTEM_INFO_UPDATE_TIME)
    {
        snprintf(line, sizeof(line), "cat /proc/driver/fpm/stats > %s", fpmfile);
        system(line);
        linux_system_fpm_time = tv_now;
    }
    if ((fs = fopen(fpmfile, "r")) != NULL)
    {
        while (fgets(line, sizeof(line), fs))
        {
            numScanned = sscanf(line, "Pool %d:", &pool_num);
            if(numScanned == 1)
            {
                in_pool = 1;
                pool_num += 1;
                entry = linuxFpmPoolTable_createEntry(pool_num);
                continue;
            }

            if(!in_pool)
                continue;

            len = strlen(FPM_POOL_PHYS_BASE_ADDRESS_STR);
            if(len < MAX_LINE_BUFF_SIZE)
            {
                if (strncmp(line, FPM_POOL_PHYS_BASE_ADDRESS_STR, len) == 0)
                {
                    p = line + len;
                    numScanned = sscanf(p, "%*[.]0x%lx", &value);
                    if(numScanned == 1)
                    {
                        entry->linuxFpmPhyBaseAddress = value;
                    }
                    continue;
                }
            } else {
                snmp_log(LOG_ERR, "The length of fpm string [%s] >= max line buffer size (%d)\n",
                                    FPM_POOL_PHYS_BASE_ADDRESS_STR, MAX_LINE_BUFF_SIZE);
            }

            len = strlen(FPM_POOL_VIRT_BASE_ADDRESS_STR);
            if(len < MAX_LINE_BUFF_SIZE)
            {
                if (strncmp(line, FPM_POOL_VIRT_BASE_ADDRESS_STR, len) == 0)
                {
                    p = line + len;
                    numScanned = sscanf(p, "%*[.]0x%lx", &value);
                    if(numScanned == 1)
                    {
                        entry->linuxFpmVirtBaseAddress = value;
                    }
                    continue;
                }
            } else {
                snmp_log(LOG_ERR, "The length of fpm string [%s] >= max line buffer size (%d)\n",
                                    FPM_POOL_VIRT_BASE_ADDRESS_STR, MAX_LINE_BUFF_SIZE);
            }

            len = strlen(FPM_POOL_SIZE_BYTES_STR);
            if(len < MAX_LINE_BUFF_SIZE)
            {
                if (strncmp(line, FPM_POOL_SIZE_BYTES_STR, len) == 0)
                {
                    p = line + len;
                    numScanned = sscanf(p, "%*[.]%lul", &value);
                    if(numScanned == 1)
                    {
                        entry->linuxFpmPoolSizeBytes = value;
                    }
                    continue;
                }
            } else {
                snmp_log(LOG_ERR, "The length of fpm string [%s] >= max line buffer size (%d)\n",
                                    FPM_POOL_SIZE_BYTES_STR, MAX_LINE_BUFF_SIZE);
            }

            len = strlen(FPM_POOL_TOTAL_TOKENS_STR);
            if(len < MAX_LINE_BUFF_SIZE)
            {
                if (strncmp(line, FPM_POOL_TOTAL_TOKENS_STR, len) == 0)
                {
                    p = line + len;
                    numScanned = sscanf(p, "%*[.]%lul", &value);
                    if(numScanned == 1)
                    {
                        entry->linuxFpmTokensTotal = value;
                    }
                    continue;
                }
            } else {
                snmp_log(LOG_ERR, "The length of fpm string [%s] >= max line buffer size (%d)\n",
                                    FPM_POOL_TOTAL_TOKENS_STR, MAX_LINE_BUFF_SIZE);
            }

            len = strlen(FPM_POOL_AVAILABLE_TOKENS_STR);
            if(len < MAX_LINE_BUFF_SIZE)
            {
                if (strncmp(line, FPM_POOL_AVAILABLE_TOKENS_STR, len) == 0)
                {
                    p = line + len;
                    numScanned = sscanf(p, "%*[.]%lul", &value);
                    if(numScanned == 1)
                    {
                        entry->linuxFpmTokensAvailable = value;
                    }
                    continue;
                }
            } else {
                snmp_log(LOG_ERR, "The length of fpm string [%s] >= max line buffer size (%d)\n",
                                    FPM_POOL_AVAILABLE_TOKENS_STR, MAX_LINE_BUFF_SIZE);
            }

            len = strlen(FPM_POOL_ALLOC_WEIGHT_STR);
            if(len < MAX_LINE_BUFF_SIZE)
            {
                if (strncmp(line, FPM_POOL_ALLOC_WEIGHT_STR, len) == 0)
                {
                    p = line + len;
                    numScanned = sscanf(p, "%*[.]%lul", &value);
                    if(numScanned == 1)
                    {
                        entry->linuxFpmPoolAllocWeight = value;
                    }
                    continue;
                }
            } else {
                snmp_log(LOG_ERR, "The length of fpm string [%s] >= max line buffer size (%d)\n",
                                    FPM_POOL_ALLOC_WEIGHT_STR, MAX_LINE_BUFF_SIZE);
            }

            len = strlen(FPM_POOL_FREE_WEIGHT_STR);
            if(len < MAX_LINE_BUFF_SIZE)
            {
                if (strncmp(line, FPM_POOL_FREE_WEIGHT_STR, len) == 0)
                {
                    p = line + len;
                    numScanned = sscanf(p, "%*[.]%lul", &value);
                    if(numScanned == 1)
                    {
                        entry->linuxFpmPoolFreeWeight = value;
                    }
                    continue;
                }
            } else {
                snmp_log(LOG_ERR, "The length of fpm string [%s] >= max line buffer size (%d)\n",
                                    FPM_POOL_FREE_WEIGHT_STR, MAX_LINE_BUFF_SIZE);
            }

            len = strlen(FPM_POOL_UNDERFLOW_COUNT_STR);
            if(len < MAX_LINE_BUFF_SIZE)
            {
                if (strncmp(line, FPM_POOL_UNDERFLOW_COUNT_STR, len) == 0)
                {
                    p = line + len;
                    numScanned = sscanf(p, "%*[.]%lul", &value);
                    if(numScanned == 1)
                    {
                        entry->linuxFpmPoolUnderflowCount = value;
                    }
                    continue;
                }
            } else {
                snmp_log(LOG_ERR, "The length of fpm string [%s] >= max line buffer size (%d)\n",
                                    FPM_POOL_UNDERFLOW_COUNT_STR, MAX_LINE_BUFF_SIZE);
            }

            len = strlen(FPM_POOL_OVERFLOW_COUNT_STR);
            if(len < MAX_LINE_BUFF_SIZE)
            {
                if (strncmp(line, FPM_POOL_OVERFLOW_COUNT_STR, len) == 0)
                {
                    p = line + len;
                    numScanned = sscanf(p, "%*[.]%lul", &value);
                    if(numScanned == 1)
                    {
                        entry->linuxFpmPoolOverflowCount = value;
                    }
                    continue;
                }
            } else {
                snmp_log(LOG_ERR, "The length of fpm string [%s] >= max line buffer size (%d)\n",
                                    FPM_POOL_OVERFLOW_COUNT_STR, MAX_LINE_BUFF_SIZE);
            }

            len = strlen(FPM_POOL_ALLOC_FIFO_EMPTY_STR);
            if(len < MAX_LINE_BUFF_SIZE)
            {
                if (strncmp(line, FPM_POOL_ALLOC_FIFO_EMPTY_STR, len) == 0)
                {
                    p = line + len;
                    numScanned = sscanf(p, "%*[.]%lul", &value);
                    if(numScanned == 1)
                    {
                        if(value)
                            entry->linuxFpmPoolAllocFifoEmpty = SNMP_TRUE;
                        else
                            entry->linuxFpmPoolAllocFifoEmpty = SNMP_FALSE;
                    }
                    continue;
                }
            } else {
                snmp_log(LOG_ERR, "The length of fpm string [%s] >= max line buffer size (%d)\n",
                                    FPM_POOL_ALLOC_FIFO_EMPTY_STR, MAX_LINE_BUFF_SIZE);
            }

            len = strlen(FPM_POOL_ALLOC_FIFO_FULL_STR);
            if(len < MAX_LINE_BUFF_SIZE)
            {
                if (strncmp(line, FPM_POOL_ALLOC_FIFO_FULL_STR, len) == 0)
                {
                    p = line + len;
                    numScanned = sscanf(p, "%*[.]%lul", &value);
                    if(numScanned == 1)
                    {
                        if(value)
                            entry->linuxFpmPoolAllocFifoFull = SNMP_TRUE;
                        else
                            entry->linuxFpmPoolAllocFifoFull = SNMP_FALSE;
                    }
                    continue;
                }
            } else {
                snmp_log(LOG_ERR, "The length of fpm string [%s] >= max line buffer size (%d)\n",
                                    FPM_POOL_ALLOC_FIFO_FULL_STR, MAX_LINE_BUFF_SIZE);
            }

            len = strlen(FPM_POOL_FREE_FIFO_EMPTY_STR);
            if(len < MAX_LINE_BUFF_SIZE)
            {
                if (strncmp(line, FPM_POOL_FREE_FIFO_EMPTY_STR, len) == 0)
                {
                    p = line + len;
                    numScanned = sscanf(p, "%*[.]%lul", &value);
                    if(numScanned == 1)
                    {
                        if(value)
                            entry->linuxFpmPoolFreeFifoEmpty = SNMP_TRUE;
                        else
                            entry->linuxFpmPoolFreeFifoEmpty = SNMP_FALSE;
                    }
                    continue;
                }
            } else {
                snmp_log(LOG_ERR, "The length of fpm string [%s] >= max line buffer size (%d)\n",
                                    FPM_POOL_FREE_FIFO_EMPTY_STR, MAX_LINE_BUFF_SIZE);
            }

            len = strlen(FPM_POOL_FREE_FIFO_FULL_STR);
            if(len < MAX_LINE_BUFF_SIZE)
            {
                if (strncmp(line, FPM_POOL_FREE_FIFO_FULL_STR, len) == 0)
                {
                    p = line + len;
                    numScanned = sscanf(p, "%*[.]%lul", &value);
                    if(numScanned == 1)
                    {
                        if(value)
                            entry->linuxFpmPoolFreeFifoFull = SNMP_TRUE;
                        else
                            entry->linuxFpmPoolFreeFifoFull = SNMP_FALSE;
                    }
                    continue;
                }
            } else {
                snmp_log(LOG_ERR, "The length of fpm string [%s] >= max line buffer size (%d)\n",
                                    FPM_POOL_FREE_FIFO_FULL_STR, MAX_LINE_BUFF_SIZE);
            }

            len = strlen(FPM_POOL_FULL_STR);
            if(len < MAX_LINE_BUFF_SIZE)
            {
                if (strncmp(line, FPM_POOL_FULL_STR, len) == 0)
                {
                    p = line + len;
                    numScanned = sscanf(p, "%*[.]%lul", &value);
                    if(numScanned == 1)
                    {
                        if(value)
                            entry->linuxFpmPoolFull = SNMP_TRUE;
                        else
                            entry->linuxFpmPoolFull = SNMP_FALSE;
                    }
                    continue;
                }
            } else {
                snmp_log(LOG_ERR, "The length of fpm string [%s] >= max line buffer size (%d)\n",
                                    FPM_POOL_FULL_STR, MAX_LINE_BUFF_SIZE);
            }

            len = strlen(FPM_POOL_INVALID_TOKEN_FREES_STR);
            if(len < MAX_LINE_BUFF_SIZE)
            {
                if (strncmp(line, FPM_POOL_INVALID_TOKEN_FREES_STR, len) == 0)
                {
                    p = line + len;
                    numScanned = sscanf(p, "%*[.]%lul", &value);
                    if(numScanned == 1)
                    {
                        entry->linuxFpmPoolInvalidTokenFrees = value;
                    }
                    continue;
                }
            } else {
                snmp_log(LOG_ERR, "The length of fpm string [%s] >= max line buffer size (%d)\n",
                                    FPM_POOL_INVALID_TOKEN_FREES_STR, MAX_LINE_BUFF_SIZE);
            }

            len = strlen(FPM_POOL_INVALID_TOKEN_MULTICOUNT_STR);
            if(len < MAX_LINE_BUFF_SIZE)
            {
                if (strncmp(line, FPM_POOL_INVALID_TOKEN_MULTICOUNT_STR, len) == 0)
                {
                    p = line + len;
                    numScanned = sscanf(p, "%*[.]%lul", &value);
                    if(numScanned == 1)
                    {
                        entry->linuxFpmPoolInvalidTokenMulticount = value;
                    }
                    continue;
                }
            } else {
                snmp_log(LOG_ERR, "The length of fpm string [%s] >= max line buffer size (%d)\n",
                                    FPM_POOL_INVALID_TOKEN_MULTICOUNT_STR, MAX_LINE_BUFF_SIZE);
            }

            len = strlen(FPM_POOL_MEM_CORRUPT_INTRS_STR);
            if(len < MAX_LINE_BUFF_SIZE)
            {
                if (strncmp(line, FPM_POOL_MEM_CORRUPT_INTRS_STR, len) == 0)
                {
                    p = line + len;
                    numScanned = sscanf(p, "%*[.]%lul", &value);
                    if(numScanned == 1)
                    {
                        entry->linuxFpmPoolMemoryCorruptionIrqs = value;
                    }
                    continue;
                }
            } else {
                snmp_log(LOG_ERR, "The length of fpm string [%s] >= max line buffer size (%d)\n",
                                    FPM_POOL_MEM_CORRUPT_INTRS_STR, MAX_LINE_BUFF_SIZE);
            }

        }
        fclose(fs);
    }

}

/* Example iterator hook routines - using 'get_next' to do most of the work */
netsnmp_variable_list *
linuxFpmPoolTable_get_first_data_point(void **my_loop_context,
                          void **my_data_context,
                          netsnmp_variable_list *put_index_data,
                          netsnmp_iterator_info *mydata)
{
    linuxFpmPoolTable_rebuildTableData();
    *my_loop_context = linuxFpmPoolTable_head;
    return linuxFpmPoolTable_get_next_data_point(my_loop_context, my_data_context,
                                    put_index_data,  mydata );
}

netsnmp_variable_list *
linuxFpmPoolTable_get_next_data_point(void **my_loop_context,
                          void **my_data_context,
                          netsnmp_variable_list *put_index_data,
                          netsnmp_iterator_info *mydata)
{
    struct linuxFpmPoolTable_entry *entry = (struct linuxFpmPoolTable_entry *)*my_loop_context;
    netsnmp_variable_list *idx = put_index_data;

    if ( entry ) {
        snmp_set_var_typed_integer( idx, ASN_INTEGER, entry->linuxFpmPoolIndex );
        idx = idx->next_variable;
        *my_data_context = (void *)entry;
        *my_loop_context = (void *)entry->next;
        return put_index_data;
    } else {
        return NULL;
    }
}


/** handles requests for the linuxFpmPoolTable table */
int
linuxFpmPoolTable_handler(
    netsnmp_mib_handler               *handler,
    netsnmp_handler_registration      *reginfo,
    netsnmp_agent_request_info        *reqinfo,
    netsnmp_request_info              *requests) {

    netsnmp_request_info       *request;
    netsnmp_table_request_info *table_info;
    struct linuxFpmPoolTable_entry          *table_entry;

    DEBUGMSGTL(("brcm_linux_system:handler", "Processing request (%d)\n", reqinfo->mode));

    switch (reqinfo->mode) {
        /*
         * Read-support (also covers GetNext requests)
         */
    case MODE_GET:
        for (request=requests; request; request=request->next) {
            table_entry = (struct linuxFpmPoolTable_entry *)
                              netsnmp_extract_iterator_context(request);
            table_info  =     netsnmp_extract_table_info(      request);

            switch (table_info->colnum) {
            case COLUMN_LINUXFPMPHYBASEADDRESS:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_UNSIGNED,
                                            table_entry->linuxFpmPhyBaseAddress);
                break;
            case COLUMN_LINUXFPMVIRTBASEADDRESS:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_UNSIGNED,
                                            table_entry->linuxFpmVirtBaseAddress);
                break;
            case COLUMN_LINUXFPMPOOLSIZEBYTES:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_GAUGE,
                                            table_entry->linuxFpmPoolSizeBytes);
                break;
            case COLUMN_LINUXFPMTOKENSTOTAL:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_COUNTER,
                                            table_entry->linuxFpmTokensTotal);
                break;
            case COLUMN_LINUXFPMTOKENSAVAILABLE:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_COUNTER,
                                            table_entry->linuxFpmTokensAvailable);
                break;
            case COLUMN_LINUXFPMPOOLALLOCWEIGHT:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_UNSIGNED,
                                            table_entry->linuxFpmPoolAllocWeight);
                break;
            case COLUMN_LINUXFPMPOOLFREEWEIGHT:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_UNSIGNED,
                                            table_entry->linuxFpmPoolFreeWeight);
                break;
            case COLUMN_LINUXFPMPOOLUNDERFLOWCOUNT:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_COUNTER,
                                            table_entry->linuxFpmPoolUnderflowCount);
                break;
            case COLUMN_LINUXFPMPOOLOVERFLOWCOUNT:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_COUNTER,
                                            table_entry->linuxFpmPoolOverflowCount);
                break;
            case COLUMN_LINUXFPMPOOLALLOCFIFOEMPTY:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_INTEGER,
                                            table_entry->linuxFpmPoolAllocFifoEmpty);
                break;
            case COLUMN_LINUXFPMPOOLALLOCFIFOFULL:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_INTEGER,
                                            table_entry->linuxFpmPoolAllocFifoFull);
                break;
            case COLUMN_LINUXFPMPOOLFREEFIFOEMPTY:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_INTEGER,
                                            table_entry->linuxFpmPoolFreeFifoEmpty);
                break;
            case COLUMN_LINUXFPMPOOLFREEFIFOFULL:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_INTEGER,
                                            table_entry->linuxFpmPoolFreeFifoFull);
                break;
            case COLUMN_LINUXFPMPOOLFULL:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_INTEGER,
                                            table_entry->linuxFpmPoolFull);
                break;
            case COLUMN_LINUXFPMPOOLINVALIDTOKENFREES:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_COUNTER,
                                            table_entry->linuxFpmPoolInvalidTokenFrees);
                break;
            case COLUMN_LINUXFPMPOOLINVALIDTOKENMULTICOUNT:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_COUNTER,
                                            table_entry->linuxFpmPoolInvalidTokenMulticount);
                break;
            case COLUMN_LINUXFPMPOOLMEMORYCORRUPTIONIRQS:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer( request->requestvb, ASN_COUNTER,
                                            table_entry->linuxFpmPoolMemoryCorruptionIrqs);
                break;
            default:
                netsnmp_set_request_error(reqinfo, request,
                                          SNMP_NOSUCHOBJECT);
                break;
            }
        }
        break;

    }
    return SNMP_ERR_NOERROR;
}
