/*
 * Note: this file originally auto-generated by mib2c using
 *  $
 */

#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>
#include <errno.h>
#include <pthread.h>
#include <signal.h>
#include "brcm_bfc_mgmt.h"
#include <sys/utsname.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <byteswap.h>

#if !defined(BUILD_RDKM) && defined(ARM64)
#include "libastra_api.h"
#define SMC_VER_LEN 70
#define AMS_VER_LEN 70
#define TA_VER_LEN  70
#endif

#define NNN (512)
#define RUNNER_VER_LEN 70

#ifndef FALSE
#define FALSE 0
#endif
#ifndef TRUE
#define TRUE  1
#endif

#define AGENTX_MSG_FLAG_BFC_SOURCE            0x80

typedef unsigned char BOOLEAN;

/* Define OID, length, type pairs */
typedef struct oidTypePair
{
   const oid *pOid;
   const char *pName;
   int oidLength;
   int oidType;
} oidTypePair;

const oid bfcTotalMemory_oid[]         = { 1,3,6,1,4,1,4413,2,2,2,1,9,1,2,8,1 };
const oid bfcSwBuiltBy_oid[]           = { 1,3,6,1,4,1,4413,2,2,2,1,9,1,1,2 };
const oid bfcSwOperatingSystem_oid[]   = { 1,3,6,1,4,1,4413,2,2,2,1,9,1,1,3 };
const oid bfcSwSnmpAgent_oid[]         = { 1,3,6,1,4,1,4413,2,2,2,1,9,1,1,4 };
const oid bfcSwImageName_oid[]         = { 1,3,6,1,4,1,4413,2,2,2,1,9,1,1,7 };
const oid bfcSwImagePath_oid[]         = { 1,3,6,1,4,1,4413,2,2,2,1,9,1,1,8 };
const oid bfcSwBuildCommandLine_oid[]  = { 1,3,6,1,4,1,4413,2,2,2,1,9,1,1,9 };
const oid bfcSwBuildYesNoOptions_oid[] = { 1,3,6,1,4,1,4413,2,2,2,1,9,1,1,10 };
const oid bfcSwBuildDefaults_oid[]     = { 1,3,6,1,4,1,4413,2,2,2,1,9,1,1,11 };

/* Define OID mappings */
const oidTypePair oidTypePairMap[] =
{
   { bfcTotalMemory_oid,          "bfcTotalMemory",          OID_LENGTH(bfcTotalMemory_oid),          ASN_INTEGER     },
   { bfcSwBuiltBy_oid,            "bfcSwBuiltBy",            OID_LENGTH(bfcSwBuiltBy_oid),            ASN_OCTET_STR   },
   { bfcSwOperatingSystem_oid,    "bfcSwOperatingSystem",    OID_LENGTH(bfcSwOperatingSystem_oid),    ASN_OCTET_STR   },
   { bfcSwSnmpAgent_oid,          "bfcSwSnmpAgent",          OID_LENGTH(bfcSwSnmpAgent_oid),          ASN_OCTET_STR   },
   { bfcSwImageName_oid,          "bfcSwImageName",          OID_LENGTH(bfcSwImageName_oid),          ASN_OCTET_STR   },
   { bfcSwImagePath_oid,          "bfcSwImagePath",          OID_LENGTH(bfcSwImagePath_oid),          ASN_OCTET_STR   },
   { bfcSwBuildCommandLine_oid,   "bfcSwBuildCommandLine",   OID_LENGTH(bfcSwBuildCommandLine_oid),   ASN_OCTET_STR   },
   { bfcSwBuildYesNoOptions_oid,  "bfcSwBuildYesNoOptions",  OID_LENGTH(bfcSwBuildYesNoOptions_oid),  ASN_OCTET_STR   },
   { bfcSwBuildDefaults_oid,      "bfcSwBuildDefaults",      OID_LENGTH(bfcSwBuildDefaults_oid),      ASN_OCTET_STR   },
   { NULL,                        NULL,                      -1,                                      -1              }
};

static int create_remote_bfc_entries( void );
static int populate_remote_bfc_entries( void );
static int forward_bfc_lookup( netsnmp_variable_list *varIn );
void bfcApplicationTable_rebuildTableData( void );
Netsnmp_Node_Handler handle_bfcForwardStatic;

static int getGfapInfo(char *gfap_ver, char *gfap_ts, char *gfap_api_ver, char *gfap_branch_hash)
{
    FILE *fp;
    int temp;
    unsigned int i;
    char pCmd[128] = {0};

    // Check if GFAP driver present
    fp = fopen("/proc/driver/gfap/cmd", "r");
    if(fp == NULL)
        return(-1);
    fclose(fp);

    // Trigger GFAP driver to print version info to log
    snprintf(pCmd, sizeof(pCmd), "echo ver > /proc/driver/gfap/cmd");
    system(pCmd);

    // Extract GFAP version info from log
    fp = popen("dmesg | grep 'GFAP Firmware version' | tail -1 | sed 's/.*GFAP Firmware version: //'", "r");
    if(fp == NULL)
        return(-1);
    i = 0;
    while ((temp=fgetc(fp))!=EOF && temp!='\n')
    {
        gfap_ver[i++] = (char)temp;
    }
    pclose(fp);

    // Extract GFAP timestamp info from log
    fp = popen("dmesg | grep 'GFAP Build' | tail -1 | sed 's/.*Build           : //'", "r");
    if(fp == NULL)
        return(-1);
    i = 0;
    while ((temp=fgetc(fp))!=EOF && temp!='\n')
    {
        gfap_ts[i++] = (char)temp;
    }
    pclose(fp);

    // Extract GFAP API version info from log
    fp = popen("dmesg | grep 'GFAP API version' | tail -1 | sed 's/.*GFAP API version     : //'", "r");
    if(fp == NULL)
        return(-1);
    i = 0;
    while ((temp=fgetc(fp))!=EOF && temp!='\n')
    {
        gfap_api_ver[i++] = (char)temp;
    }
    pclose(fp);

    // Extract GFAP branch and hash info from log
    fp = popen("dmesg | grep 'GFAP Branch' | tail -1 | sed 's/.*GFAP Branch\\/Hash     : //'", "r");
    if(fp == NULL)
        return(-1);
    i = 0;
    while ((temp=fgetc(fp))!=EOF && temp!='\n')
    {
        gfap_branch_hash[i++] = (char)temp;
    }
    pclose(fp);

    return(0);
}

static int getLatticeInfo(char *lattice_ver, char *build_options)
{
    char tmp[512] = {0};
    FILE *fp;

    if (!lattice_ver || !build_options)
    {
        return(-1);
    }
    lattice_ver[0] = '\0';
    build_options[0] = '\0';

    fp = popen("latticecli -n \"Get System.LatticeFrameworkVersion\"|cut -f 2 -d ':'", "r");
    if(fp == NULL)
    {
        return(-1);
    }
    fgets(tmp, sizeof(tmp), fp);
    tmp[strlen(tmp) -1 ] = '\0';
    pclose(fp);
    strcpy(lattice_ver, &tmp[1]);

    fp = popen("latticecli -n \"version\"|grep 'LATTICE' -A 100|grep 'Build Options'|cut -f 2 -d ':'", "r");
    if(fp == NULL)
    {
        return(-1);
    }
    while (!feof(fp))
    {
        memset(tmp, 0, sizeof(tmp));
        fgets(tmp, sizeof(tmp), fp);
        if (!strlen(tmp))
            continue;

        tmp[strlen(tmp) -1 ] = '\0';
        if (!strlen(build_options))
            strcpy(build_options, &tmp[1]);
        else
            strcat(build_options, tmp);
    }
    pclose(fp);

    return (0);
}

#ifdef BUILD_OPENWRT
static int getOpenWrtInfo(char *openwrt_ver, char *openwrt_info)
{
    char tmp[512] = {0};
    FILE *fp = fopen("/etc/version.txt", "r");
    if (fp == NULL)
    {
        return(-1);
    }

    if (!openwrt_ver || !openwrt_info)
    {
        fclose(fp);
        return(-1);
    }
    openwrt_ver[0] = '\0';
    openwrt_info[0] = '\0';

    while (!feof(fp))
    {
        memset(tmp, 0, sizeof(tmp));
        fgets(tmp, sizeof(tmp), fp);
        if (!strlen(tmp))
            continue;
        tmp[strlen(tmp) -1 ] = '\0';

        if (!strncmp(tmp, "Version:", strlen("Version:")))
        {
            if (!strlen(openwrt_ver))
                strcpy(openwrt_ver, &tmp[strlen("Version:") + 1]);
            else if (!strlen(openwrt_info))
                sprintf(openwrt_info, "Base Version: %s", &tmp[strlen("Version:") + 1]);
        }
        else if (!strncmp(tmp, "Version Code:", strlen("Version Code:")))
        {
            tmp[strlen("Version Code:")] = ' ';
            strcat(openwrt_info, " ");
            strcat(openwrt_info, tmp);
        }
        else if (!strncmp(tmp, "Revision:", strlen("Revision:")))
        {
            tmp[strlen("Revision:")] = ' ';
            strcat(openwrt_info, " ");
            strcat(openwrt_info, tmp);
        }
    }
    fclose(fp);

    return (0);
}
#endif

#ifdef BUILD_RDKM
static int getRdkmInfo(char *rdkm_ver, char *rdkm_info)
{
    char tmp[512] = {0};
    FILE *fp = fopen("/etc/version.txt", "r");
    if (fp == NULL)
    {
        return(-1);
    }

    if (!rdkm_ver || !rdkm_info)
    {
        fclose(fp);
        return(-1);
    }
    rdkm_ver[0] = '\0';
    rdkm_info[0] = '\0';

    while (!feof(fp))
    {
        memset(tmp, 0, sizeof(tmp));
        fgets(tmp, sizeof(tmp), fp);
        if (!strlen(tmp))
            continue;
        tmp[strlen(tmp) -1 ] = '\0';

        if (!strncmp(tmp, "VERSION:", strlen("VERSION:")))
        {
            if (!strlen(rdkm_ver))
                strcpy(rdkm_ver, &tmp[strlen("VERSION:") + 1]);
        }
        else if (!strncmp(tmp, "Build Date:", strlen("Build Date:")))
        {
            strcat(rdkm_info, tmp);
            strcat(rdkm_info, ";");
        }
        else if (!strncmp(tmp, "Build Time:", strlen("Build Time:")))
        {
            strcat(rdkm_info, tmp);
            strcat(rdkm_info, ";");
        }
        else if (!strncmp(tmp, "Build By:", strlen("Build By:")))
        {
            strcat(rdkm_info, tmp);
            strcat(rdkm_info, ";");
        }
        else if (!strncmp(tmp, "Build Path:", strlen("Build Path:")))
        {
            strcat(rdkm_info, tmp);
        }
    }
    fclose(fp);

    return (0);
}
#endif

static int getBoltInfo(char *bolt_ver, char *bolt_ts, char *bolt_tg, char *bolt_usr, char *fsbl_bolt_ver)
{
    FILE *bolt_fp;
    short int bolt_version_major,i;
    short int bolt_version_minor;
    char bolt_major_str[8],bolt_minor_str[8];
    short int fsbl_bolt_version_major=0;
    short int fsbl_bolt_version_minor=0;
    char fsbl_bolt_major_str[8],fsbl_bolt_minor_str[8];
#ifdef ARM64
    short int bolt_version_customer = 0;
    char bolt_customer_str[8];
    short int fsbl_bolt_version_customer = 0;
    char fsbl_bolt_customer_str[8];
#endif
    char c = 0xff;

    bolt_fp = fopen("/proc/device-tree/bolt/version", "r");
    if(bolt_fp == NULL)
    {
        return(-1);
    }
    #ifndef ARM64
    fread(&bolt_version_major, sizeof(short int), 1, bolt_fp);
    fread(&bolt_version_minor, sizeof(short int), 1, bolt_fp);
    fclose(bolt_fp);
    bolt_version_major = (bolt_version_major >> 8);
    bolt_version_minor = (bolt_version_minor >> 8);
    #else
    unsigned int raw_version_info;
    fread(&raw_version_info, sizeof(unsigned int), 1, bolt_fp);
    raw_version_info = bswap_32(raw_version_info);
    fclose(bolt_fp);
    bolt_version_major = ((raw_version_info & 0xff000000) >> 24);
    bolt_version_minor = ((raw_version_info & 0x00fff000) >> 12);
    bolt_version_customer = raw_version_info & 0x00000fff;
    #endif

    bolt_fp = fopen("/proc/device-tree/bolt/date", "r");
    if(bolt_fp == NULL)
    {
        return(-1);
    }
    i = 0;
    while(c != 0)
    {
        fread(&c, sizeof(char), 1, bolt_fp);
        bolt_ts[i++] = c;
    }
    c = 0xff;
    fclose(bolt_fp);

    bolt_fp = fopen("/proc/device-tree/bolt/tag", "r");
    if(bolt_fp == NULL)
    {
        return(-1);
    }
    i = 0;
    while(c != 0)
    {
        fread(&c, sizeof(char), 1, bolt_fp);
        bolt_tg[i++] = c;
    }
    c = 0xff;
    fclose(bolt_fp);

    bolt_fp = fopen("/proc/device-tree/bolt/user", "r");
    if(bolt_fp == NULL)
    {
        return(-1);
    }
    i = 0;
    while(c != 0)
    {
        fread(&c, sizeof(char), 1, bolt_fp);
        bolt_usr[i++] = c;
    }
    c = 0xff;
    fclose(bolt_fp);

    bolt_fp = fopen("/proc/device-tree/bolt/fsbl_version", "r");
    if(bolt_fp == NULL)
    {
        /* Check if file is present since only upgradable bolt binaries
           keep track of a bolt version in fsbl */
        if (errno == ENOENT)
        {
            fsbl_bolt_version_major = bolt_version_major;
            fsbl_bolt_version_minor = bolt_version_minor;
            #ifdef ARM64
            fsbl_bolt_version_customer = bolt_version_customer;
            #endif
        }
        else
        {
            return(-1);
        }
    }
    else
    {
        #ifndef ARM64
        fread(&fsbl_bolt_version_major, sizeof(short int), 1, bolt_fp);
        fread(&fsbl_bolt_version_minor, sizeof(short int), 1, bolt_fp);
        fclose(bolt_fp);
        fsbl_bolt_version_major = (fsbl_bolt_version_major >> 8);
        fsbl_bolt_version_minor = (fsbl_bolt_version_minor >> 8);
        #else
        fsbl_bolt_version_major = bolt_version_major;
        fsbl_bolt_version_minor = bolt_version_minor;
        fsbl_bolt_version_customer = bolt_version_customer;
        fclose(bolt_fp);
        #endif
    }

    sprintf(fsbl_bolt_major_str, "%d", fsbl_bolt_version_major);
    sprintf(fsbl_bolt_minor_str, "%02d", fsbl_bolt_version_minor);
    #ifndef ARM64
    sprintf(fsbl_bolt_ver, "%s.%s", fsbl_bolt_major_str, fsbl_bolt_minor_str);
    #else
    sprintf(fsbl_bolt_customer_str, "%02d", fsbl_bolt_version_customer);
    sprintf(fsbl_bolt_ver, "%s.%s.%s", fsbl_bolt_major_str, fsbl_bolt_minor_str, fsbl_bolt_customer_str);
    #endif

    sprintf(bolt_major_str, "%d", bolt_version_major);
    sprintf(bolt_minor_str, "%02d", bolt_version_minor);
    #ifndef ARM64
    sprintf(bolt_ver, "%s.%s", bolt_major_str, bolt_minor_str);
    #else
    sprintf(bolt_customer_str, "%02d", bolt_version_customer);
    sprintf(bolt_ver, "%s.%s.%s", bolt_major_str, bolt_minor_str, bolt_customer_str);
    #endif
    return (0);
}

static int getAeolusInfo(char *aeolus_ver)
{
    FILE *aeolus_fp;
    short int aeolus_version_major;
    short int aeolus_version_minor;

    aeolus_fp = fopen("/proc/device-tree/aeolus/version", "r");
    if(aeolus_fp == NULL)
    {
        return(-1);
    }
    fread(&aeolus_version_major, sizeof(short int), 1, aeolus_fp);
    fread(&aeolus_version_minor, sizeof(short int), 1, aeolus_fp);
    fclose(aeolus_fp);

    sprintf(aeolus_ver, "%d.%d", aeolus_version_major, aeolus_version_minor);
    return (0);
}

static int getRunnerInfo(char *ver, size_t len)
{
    FILE *fp;
    int temp;
    int i;
    BOOLEAN has_extension = FALSE;

    fp = fopen("/var/bdmf_sh_id", "r");
    if(fp == NULL)
        return(-1);
    fclose(fp);

    // Extract rdp version branch.
    fp = popen("bdmf_shell -c `cat /var/bdmf_sh_id` -cmd /b/e system sw_version | tail -n 2 | cut -f1 -d',' | cut -f2 -d'='", "r");
    if(fp == NULL)
        return(-1);
    i = 0;
    while ((temp=fgetc(fp))!=EOF && temp!='\n' && i<len)
    {
        ver[i++] = (char)temp;
    }
    if (i<len)
        ver[i++] = '_';
    pclose(fp);

    // Extract bfc version major number.
    fp = popen("bdmf_shell -c `cat /var/bdmf_sh_id` -cmd /b/e system sw_version | tail -n 2 | cut -f2 -d',' | cut -f2 -d'='", "r");
    if(fp == NULL)
        return(-1);
    while ((temp=fgetc(fp))!=EOF && temp!='\n' && i<len)
    {
        ver[i++] = (char)temp;
    }
    if (i<len)
        ver[i++] = '.';
    pclose(fp);

    // Extract bfc version minor number.
    fp = popen("bdmf_shell -c `cat /var/bdmf_sh_id` -cmd /b/e system sw_version | tail -n 2 | cut -f3 -d',' | cut -f2 -d'='", "r");
    if(fp == NULL)
        return(-1);
    while ((temp=fgetc(fp))!=EOF && temp!='\n' && i<len)
    {
        ver[i++] = (char)temp;
    }
    if (i<len)
        ver[i++] = '.';
    pclose(fp);

    // Extract rdp version major number.
    fp = popen("bdmf_shell -c `cat /var/bdmf_sh_id` -cmd /b/e system sw_version | tail -n 2 | cut -f4 -d',' | cut -f2 -d'='", "r");
    if(fp == NULL)
        return(-1);
    while ((temp=fgetc(fp))!=EOF && temp!='\n' && i<len)
    {
        ver[i++] = (char)temp;
    }
    if (i<len)
        ver[i++] = '.';
    pclose(fp);

    // Extract rdp version minor number.
    fp = popen("bdmf_shell -c `cat /var/bdmf_sh_id` -cmd /b/e system sw_version |  tail -n 2 | cut -f5 -d',' | cut -f2 -d'='", "r");
    if(fp == NULL)
        return(-1);
    while ((temp=fgetc(fp))!=EOF && temp!='\n' && i<len)
    {
        ver[i++] = (char)temp;
    }
    pclose(fp);

    // Extract rdp version extension string.
    fp = popen("bdmf_shell -c `cat /var/bdmf_sh_id` -cmd /b/e system sw_version | tail -n 2 | cut -f6 -d',' | cut -f2 -d'='", "r");
    if(fp == NULL)
        return(-1);

    while ((temp=fgetc(fp))!=EOF && temp!='\n' && temp != '}' && i<len)
    {
        if (!has_extension)
        {
            has_extension = TRUE;
            ver[i++] = '.';
        }
        if (i<len)
            ver[i++] = (char)temp;
    }
    pclose(fp);

    return(0);
}

#if !defined(BUILD_RDKM) && defined(ARM64)
static void getAstraInfo(struct astra_version *pVersion, struct astra_config *pConfig, struct astra_status *pStatus)
{
    astra_version_get(pVersion);
    astra_config_get(pConfig);
    astra_status_get(pStatus);
}

static void getAMSInfo(struct ams_version *pVersion)
{
    astra_ams_version_get(pVersion);
}

static int getTaInfo(char *pVersion, char *pTs, char *pTag, char *pBuild, unsigned int lenTs)
{
    FILE *fp;
    char day[16]= {0};
    char time[16]= {0};
    char tz[16]= {0};

    fp = fopen("/mnt/ata/astra_ta_bp3.ver", "r");
    if (!fp)
    {
        printf("Failed to open file /mnt/ata/astra_ta_bp3.ver\n");
        return -1;
    }
    fscanf(fp, "bp3 v%15s %127s\n", pVersion, pTag);
    fscanf(fp, "(%63s %15s %15s %6s)\n", pBuild, day, time, tz);
    snprintf(pTs, lenTs, "%s %s", day, time);
    fclose(fp);

    return 0;
}
#endif

int getWifiNumber( void )
{
    FILE *fd = NULL;
    int wl_instances=0;

    fd = fopen("/tmp/wl_instances.txt", "r");
    if (fd)
    {
        fscanf(fd, "%d", &wl_instances);
        fclose(fd);
    }
    return wl_instances;
}

/** Initializes the brcm_bfc_mgmt module */
void
init_brcm_bfc_mgmt(void)
{
    /* here we initialize all the tables we're planning on supporting */
    initialize_table_bfcApplicationTable();

    /* initialize items forwarded to BFC for lookup */
    const oidTypePair *pOidType = oidTypePairMap;
    while( pOidType->pOid != NULL )
    {
        netsnmp_register_scalar(
            netsnmp_create_handler_registration(pOidType->pName, handle_bfcForwardStatic,
                                   pOidType->pOid, pOidType->oidLength,
                                   HANDLER_CAN_RONLY
            ));
        pOidType++;
    }
}


/** Initialize the bfcApplicationTable table by defining its contents and how it's structured */
void
initialize_table_bfcApplicationTable(void)
{
    const oid bfcApplicationTable_oid[] = {1,3,6,1,4,1,4413,2,2,2,1,9,1,1,5};
    const size_t bfcApplicationTable_oid_len   = OID_LENGTH(bfcApplicationTable_oid);
    netsnmp_handler_registration    *reg;
    netsnmp_iterator_info           *iinfo;
    netsnmp_table_registration_info *table_info;

    DEBUGMSGTL(("brcm_bfc_mgmt:init", "initializing table bfcApplicationTable\n"));

    reg = netsnmp_create_handler_registration(
              "bfcApplicationTable",     bfcApplicationTable_handler,
              bfcApplicationTable_oid, bfcApplicationTable_oid_len,
              HANDLER_CAN_RONLY
              );

    table_info = SNMP_MALLOC_TYPEDEF( netsnmp_table_registration_info );
    netsnmp_table_helper_add_indexes(table_info,
                           ASN_INTEGER,  /* index: bfcAppIndex */
                           0);
    table_info->min_column = COLUMN_BFCAPPNAME;
    table_info->max_column = COLUMN_BFCAPPSYSDESCR;

    iinfo = SNMP_MALLOC_TYPEDEF( netsnmp_iterator_info );
    iinfo->get_first_data_point = bfcApplicationTable_get_first_data_point;
    iinfo->get_next_data_point  = bfcApplicationTable_get_next_data_point;
    iinfo->table_reginfo        = table_info;

    netsnmp_register_table_iterator( reg, iinfo );

    /* Initialise the contents of the table here */
    /* Agent X runs differently. Populate data now. */
    bfcApplicationTable_rebuildTableData();
}

    /* Typical data structure for a row entry */
struct bfcApplicationTable_entry {
    /* Index values */
    long bfcAppIndex;

    /* Column values */
    char bfcAppName[NNN];
    size_t bfcAppName_len;
    char bfcAppVersion[NNN];
    size_t bfcAppVersion_len;
    long bfcAppReleaseState;
    char *bfcAppFeatures;
    size_t bfcAppFeatures_len;
    char *bfcAppSysDescr;
    size_t bfcAppSysDescr_len;

    /* Illustrate using a simple linked list */
    int   valid;
    struct bfcApplicationTable_entry *next;
};

struct bfcApplicationTable_entry *bfcApplicationTable_head = NULL;
static BOOLEAN remote_bfc_entries_populated = FALSE;

/* create a new row in the (unsorted) table */
struct bfcApplicationTable_entry *
bfcApplicationTable_createEntry(
                 long  bfcAppIndex
                ) {
    struct bfcApplicationTable_entry *entry, *ptr;

    // Double check this entry doesn't already exist
    for ( ptr = bfcApplicationTable_head; ptr != NULL; ptr = ptr->next )
    {
        if ( ptr->bfcAppIndex == bfcAppIndex )
            return ptr;
    }

    // Create a new entry
    entry = SNMP_MALLOC_TYPEDEF(struct bfcApplicationTable_entry);
    if (!entry)
        return NULL;

    memset( entry, 0, sizeof(struct bfcApplicationTable_entry) );
    entry->bfcAppIndex = bfcAppIndex;
    entry->next = bfcApplicationTable_head;
    bfcApplicationTable_head = entry;
    return entry;
}

/* remove a row from the table */
void
bfcApplicationTable_removeEntry( struct bfcApplicationTable_entry *entry ) {
    struct bfcApplicationTable_entry *ptr, *prev;

    if (!entry)
        return;    /* Nothing to remove */

    for ( ptr = bfcApplicationTable_head, prev = NULL;
          ptr != NULL;
          prev = ptr, ptr = ptr->next ) {
        if ( ptr == entry )
            break;
    }
    if ( !ptr )
        return;    /* Can't find it */

    if ( prev == NULL )
        bfcApplicationTable_head = ptr->next;
    else
        prev->next = ptr->next;

    if(entry->bfcAppFeatures)
        free(entry->bfcAppFeatures);

    if(entry->bfcAppSysDescr)
        free(entry->bfcAppSysDescr);

    SNMP_FREE( entry );   /* XXX - release any other internal resources */
}

void
bfcApplicationTable_rebuildTableData(void)
{
    struct bfcApplicationTable_entry *entry;
    char lattice_ver[50]={0}, build_option[1024]={0};
#ifdef BUILD_OPENWRT
    char openwrt_ver[50]={0}, openwrt_info[1024]={0};
#endif
#ifdef BUILD_RDKM
    char rdkm_ver[50]={0}, rdkm_info[1024]={0};
#endif
    char bolt_version[25]={0}, bolt_timestamp[25]={0}, bolt_tag[25]={0}, bolt_user[50]={0};
    char fsbl_bolt_version[25]={0};
    char runner_ver[RUNNER_VER_LEN]={0};
    char aeolus_version[25]={0};
    char linuxVerString[100]={0};
    char gfap_api_ver[100]={0};
    char gfap_ts[100]={0};
    char gfap_branch_hash[100]={0};
    char gfap_ver[100]={0};
    struct utsname linuxVer;
    FILE *fp = NULL;
    char dt_chosen_in[200] = {0};
    char dt_chosen[200] = {0};
    char dt_aob[64] = {0};
    int dt_chosen_found = 0;
    int dt_aob_found = 0;
    char sys_descr[1024] = {0};
    const char *dt_prefix = "Device Tree: ";
    const char *dt_aob_prefix = "ARM on battery: ";
    size_t num_read;
    int cnt = 0;
    int cnt_out = 0;

    if (!bfcApplicationTable_head)
    {
        /* BFC */
        create_remote_bfc_entries();
        populate_remote_bfc_entries();

        /* Linux */
        entry = bfcApplicationTable_createEntry(BFC_APPLICATION_TABLE_INDEX_LINUX);
        strcpy(entry->bfcAppName, "Linux");
        entry->bfcAppName_len = strlen("Linux");
        if (uname(&linuxVer) == 0)
        {
            snprintf(linuxVerString, sizeof(linuxVerString), "%s", linuxVer.release);
            entry->bfcAppVersion_len = strlen(linuxVerString);
            strcpy(entry->bfcAppVersion, linuxVerString);
            fp = fopen("/proc/device-tree/chosen/filename", "r");
            if (fp)
            {
                if (fgets(dt_chosen, sizeof(dt_chosen), fp))
                {
                    dt_chosen_found = 1;
                }
                fclose(fp);
            }
            else
            {
                fp = fopen("/proc/device-tree/chosen/dtbs", "r");
                if (fp)
                {
                    dt_chosen_found = 1;
                    num_read = fread(dt_chosen_in, 1, sizeof(dt_chosen_in)-1, fp);
                    fclose(fp);
                    for (cnt = 0; cnt < num_read; cnt++)
                    {
                        if (dt_chosen_in[cnt] == '\0')
                        {
                            // Skip over these
                        }
                        else
                        {
                            dt_chosen[cnt_out] = dt_chosen_in[cnt];
                            cnt_out++;
                        }
                    }
                    dt_chosen[cnt_out] = '\0';
                }
            }

#ifdef ARM64
            fp = fopen("/proc/device-tree/ba-rpc/rg-batt-mode", "r");
#else
            fp = fopen("/proc/device-tree/ba/rg-batt-mode", "r");
#endif
            if (fp)
            {
                if (fgets(dt_aob, sizeof(dt_aob), fp))
                {
                    dt_aob_found = 1;
                }
                fclose(fp);
            }

            entry->bfcAppFeatures_len = strlen(dt_prefix) + strlen(dt_chosen) + 2 + strlen(dt_aob_prefix) + strlen(dt_aob); // 2 for ", + space"
            entry->bfcAppFeatures = malloc(entry->bfcAppFeatures_len + 1);
            if (entry->bfcAppFeatures)
            {
                if ( dt_chosen_found == 0 )
                {
                    snprintf(dt_chosen, sizeof(dt_chosen), "Unknown");
                }
                if ( dt_aob_found == 0 )
                {
                    snprintf(dt_aob, sizeof(dt_aob), "Unknown");
                }
                sprintf(entry->bfcAppFeatures, "%s%s, %s%s", dt_prefix, dt_chosen, dt_aob_prefix, dt_aob);
            }
            else
                entry->bfcAppFeatures_len = 0;


            // AppSysDescr
            snprintf(sys_descr, sizeof(sys_descr),
                    "%s %s %s %s %s", linuxVer.sysname,
                    linuxVer.nodename, linuxVer.release, linuxVer.version,
                    linuxVer.machine);
            sys_descr[ sizeof(sys_descr)-1 ] = 0;
            entry->bfcAppSysDescr_len = strlen(sys_descr);
            entry->bfcAppSysDescr = malloc(entry->bfcAppSysDescr_len + 1);
            strncpy(entry->bfcAppSysDescr, sys_descr, entry->bfcAppSysDescr_len + 1);
            entry->bfcAppSysDescr[entry->bfcAppSysDescr_len] = 0;
        }
        else
        {
            entry->bfcAppVersion_len = 0;
            entry->bfcAppFeatures_len = 0;
            entry->bfcAppSysDescr_len = 0;
        }
        entry->bfcAppReleaseState = 1;

#ifdef BUILD_WIFI
        /* WiFi */
        entry = bfcApplicationTable_createEntry(BFC_APPLICATION_TABLE_INDEX_WIFI);
        strcpy(entry->bfcAppName, "WiFi");
        entry->bfcAppName_len = strlen("WiFi");
        if(getWifiNumber())
        {
            memset(buf, 0, sizeof(buf));
            fp = popen("nvram get wl0_version", "r");
            if (fp != NULL)
            {
                if(fgets(buf, sizeof(buf), fp) != NULL)
                {
                    if(buf[strlen(buf) - 1] == '\n')
                        buf[strlen(buf) - 1] = '\0';
                    entry->bfcAppVersion_len = strlen(buf);
                    strcpy(entry->bfcAppVersion, buf);
                }
                pclose(fp);
            } else {
                entry->bfcAppVersion_len = 0;
            }
            entry->bfcAppReleaseState = 1;

            memset(buf, 0, sizeof(buf));
            fp = popen("wl revinfo", "r");
            if (fp != NULL)
            {
                while(fgets(line, sizeof(line), fp) != NULL)
                {
                    snmp_log(LOG_ERR, "get line[%s]\n", line);
                    if(line[strlen(line) - 1] == '\n')
                        line[strlen(line) - 1] = ',';
                    strncat(buf, line, sizeof(buf));
                }
                if(buf[strlen(buf) - 1] == ',')
                    buf[strlen(buf) - 1] = '\0';

                entry->bfcAppFeatures_len = strlen(buf);
                entry->bfcAppFeatures = malloc(entry->bfcAppFeatures_len + 1);
                if (entry->bfcAppFeatures)
                    strcpy(entry->bfcAppFeatures, buf);
                else
                    entry->bfcAppFeatures_len = 0;
                pclose(fp);
            } else {
                entry->bfcAppVersion_len = 0;
                entry->bfcAppFeatures_len = 0;
            }
            entry->bfcAppSysDescr_len = 0;
        }
#endif

        /* Bolt */
        if(getBoltInfo(bolt_version, bolt_timestamp, bolt_tag, bolt_user, fsbl_bolt_version) == 0)
        {
            entry = bfcApplicationTable_createEntry(BFC_APPLICATION_TABLE_INDEX_BOLT);
            strcpy(entry->bfcAppName, "Bolt");
            entry->bfcAppName_len = strlen("Bolt");
            entry->bfcAppVersion_len = strlen(bolt_version);
            strcpy(entry->bfcAppVersion, bolt_version);
            entry->bfcAppSysDescr_len = 0;
            entry->bfcAppReleaseState = 1;

            entry = bfcApplicationTable_createEntry(BFC_APPLICATION_TABLE_INDEX_FSBL);
            strcpy(entry->bfcAppName, "Bolt(FSBL)");
            entry->bfcAppName_len = strlen("Bolt(FSBL)");
            entry->bfcAppVersion_len = strlen(fsbl_bolt_version);
            strcpy(entry->bfcAppVersion, fsbl_bolt_version);
            entry->bfcAppSysDescr_len = 0;
            entry->bfcAppReleaseState = 1;
        }

        /* Runner */
        if(getRunnerInfo(runner_ver, RUNNER_VER_LEN) == 0)
        {
            entry = bfcApplicationTable_createEntry(BFC_APPLICATION_TABLE_INDEX_RUNNER);
            strcpy(entry->bfcAppName, "Runner");
            entry->bfcAppName_len = strlen("Runner");
            entry->bfcAppVersion_len = strlen(runner_ver);
            strcpy(entry->bfcAppVersion, runner_ver);
            entry->bfcAppSysDescr_len = 0;
            entry->bfcAppReleaseState = 1;
        }

        /* Aeolus */
        if(getAeolusInfo(aeolus_version) == 0)
        {
            entry = bfcApplicationTable_createEntry(BFC_APPLICATION_TABLE_INDEX_AEOLUS);
            strcpy(entry->bfcAppName, "Aeolus");
            entry->bfcAppName_len = strlen("Aeolus");
            entry->bfcAppVersion_len = strlen(aeolus_version);
            strcpy(entry->bfcAppVersion, aeolus_version);
            entry->bfcAppSysDescr_len = 0;
            entry->bfcAppReleaseState = 1;
        }

        /* LATTICE */
        entry = bfcApplicationTable_createEntry(BFC_APPLICATION_TABLE_INDEX_LATTICE);
        strcpy(entry->bfcAppName, "Lattice");
        entry->bfcAppName_len = strlen("Lattice");
        if((getLatticeInfo(lattice_ver, build_option)) == 0)
        {
            entry->bfcAppVersion_len = strlen(lattice_ver);
            strcpy(entry->bfcAppVersion, lattice_ver);
            entry->bfcAppFeatures_len = strlen(build_option);
            entry->bfcAppFeatures = malloc(entry->bfcAppFeatures_len + 1);
            if (entry->bfcAppFeatures)
                strcpy(entry->bfcAppFeatures, build_option);
            else
                entry->bfcAppFeatures_len = 0;
        } else {
            entry->bfcAppVersion_len = 0;
        }
        entry->bfcAppSysDescr_len = 0;
        entry->bfcAppReleaseState = 1;

#ifdef BUILD_OPENWRT
        /* OPENWRT */
        entry = bfcApplicationTable_createEntry(BFC_APPLICATION_TABLE_INDEX_OPENWRT);
        strcpy(entry->bfcAppName, "OpenWRT");
        entry->bfcAppName_len = strlen("OpenWRT");
        if((getOpenWrtInfo(openwrt_ver, openwrt_info)) == 0)
        {
            entry->bfcAppVersion_len = strlen(openwrt_ver);
            strcpy(entry->bfcAppVersion, openwrt_ver);
            entry->bfcAppFeatures_len = strlen(openwrt_info);
            entry->bfcAppFeatures = malloc(entry->bfcAppFeatures_len + 1);
            if (entry->bfcAppFeatures)
                strcpy(entry->bfcAppFeatures, openwrt_info);
            else
                entry->bfcAppFeatures_len = 0;
        } else {
            entry->bfcAppVersion_len = 0;
        }
        entry->bfcAppSysDescr_len = 0;
        entry->bfcAppReleaseState = 1;
#endif

#ifdef BUILD_RDKM
        /* RDKM */
        entry = bfcApplicationTable_createEntry(BFC_APPLICATION_TABLE_INDEX_RDKM);
        strcpy(entry->bfcAppName, "RDKM");
        entry->bfcAppName_len = strlen("RDKM");
        if((getRdkmInfo(rdkm_ver, rdkm_info)) == 0)
        {
            entry->bfcAppVersion_len = strlen(rdkm_ver);
            strcpy(entry->bfcAppVersion, rdkm_ver);
            entry->bfcAppFeatures_len = strlen(rdkm_info);
            entry->bfcAppFeatures = malloc(entry->bfcAppFeatures_len + 1);
            if (entry->bfcAppFeatures)
                strcpy(entry->bfcAppFeatures, rdkm_info);
            else
                entry->bfcAppFeatures_len = 0;
        } else {
            entry->bfcAppVersion_len = 0;
        }
        entry->bfcAppSysDescr_len = 0;
        entry->bfcAppReleaseState = 1;
#endif

        /* GFAP */
        if((getGfapInfo(gfap_ver, gfap_ts, gfap_api_ver, gfap_branch_hash)) == 0)
        {
            char gfap_features[1024]={0};
            entry = bfcApplicationTable_createEntry(BFC_APPLICATION_TABLE_INDEX_GFAP);
            strcpy(entry->bfcAppName, "GFAP");
            entry->bfcAppName_len = strlen("GFAP");
            entry->bfcAppVersion_len = strlen(gfap_ver);
            strcpy(entry->bfcAppVersion, gfap_ver);
            snprintf(gfap_features, sizeof(gfap_features), "API Version: %s, Build Timestamp: %s, Build Branch: %s", gfap_api_ver, gfap_ts, gfap_branch_hash);
            entry->bfcAppFeatures_len = strlen(gfap_features);
            entry->bfcAppFeatures = malloc(entry->bfcAppFeatures_len + 1);
            if (entry->bfcAppFeatures)
                strcpy(entry->bfcAppFeatures, gfap_features);
            else
                entry->bfcAppFeatures_len = 0;
            entry->bfcAppSysDescr_len = 0;
            entry->bfcAppReleaseState = 1;
        }

#if !defined(BUILD_RDKM) && defined(ARM64)
        /* ASTRA */
        char astra_ver[SMC_VER_LEN]={0};
        struct astra_version version;
        struct astra_config config;
        struct astra_status status;
        char astra_features[1024]={0};
        getAstraInfo(&version, &config, &status);
        snprintf(astra_ver, sizeof(astra_ver), "%d.%d.%d.%d", version.major, version.minor, version.build, version.branch);
        entry = bfcApplicationTable_createEntry(BFC_APPLICATION_TABLE_INDEX_ASTRA);
        strcpy(entry->bfcAppName, "ASTRA");
        entry->bfcAppName_len = strlen("ASTRA");
        entry->bfcAppVersion_len = strlen(astra_ver);
        strcpy(entry->bfcAppVersion, astra_ver);
        snprintf(astra_features, sizeof(astra_features), "Build Commit: g%08x, Build Timestamp: %4d-%02d-%02d %02d:%02d:%02d",
                 version.commit, version.year, version.month, version.day, version.hour, version.min, version.sec);
        entry->bfcAppFeatures_len = strlen(astra_features);
        entry->bfcAppFeatures = malloc(entry->bfcAppFeatures_len + 1);
        if (entry->bfcAppFeatures)
            strcpy(entry->bfcAppFeatures, astra_features);
        else
            entry->bfcAppFeatures_len = 0;
        entry->bfcAppSysDescr_len = 0;
        entry->bfcAppReleaseState = 1;

        /* AMS */
        char ams_ver[AMS_VER_LEN]={0};
        struct ams_version ams_version;
        char ams_features[1024]={0};
        getAMSInfo(&ams_version);
        snprintf(ams_ver, sizeof(ams_ver), "%d.%d.%d", ams_version.ver_major, ams_version.ver_minor, ams_version.ver_rev);
        entry = bfcApplicationTable_createEntry(BFC_APPLICATION_TABLE_INDEX_AMS);
        strcpy(entry->bfcAppName, "AMS");
        entry->bfcAppName_len = strlen("AMS");
        entry->bfcAppVersion_len = strlen(ams_ver);
        strcpy(entry->bfcAppVersion, ams_ver);
        snprintf(ams_features, sizeof(ams_features), "Build Commit: g%08x, Build Timestamp: %4d-%02d-%02d %02d:%02d:%02d",
                 ams_version.commit, ams_version.year, ams_version.month, ams_version.day,
                 ams_version.hour, ams_version.min, ams_version.sec);
        entry->bfcAppFeatures_len = strlen(ams_features);
        entry->bfcAppFeatures = malloc(entry->bfcAppFeatures_len + 1);
        if (entry->bfcAppFeatures)
            strcpy(entry->bfcAppFeatures, ams_features);
        else
            entry->bfcAppFeatures_len = 0;
        entry->bfcAppSysDescr_len = 0;
        entry->bfcAppReleaseState = 1;

        /* TA */
        char ta_ver[TA_VER_LEN]={0};
        char ta_ts[64]={0};
        char ta_tag[128]={0};
        char ta_build[64]={0};
        if(getTaInfo(ta_ver, ta_ts, ta_tag, ta_build, sizeof(ta_ts)) == 0)
        {
            char ta_features[1024]={0};
            entry = bfcApplicationTable_createEntry(BFC_APPLICATION_TABLE_INDEX_TA);
            strcpy(entry->bfcAppName, "TA");
            entry->bfcAppName_len = strlen("TA");
            entry->bfcAppVersion_len = strlen(ta_ver);
            strcpy(entry->bfcAppVersion, ta_ver);
            snprintf(ta_features, sizeof(ta_features), "Build Timestamp: %s, Build Tag: %s, Build By: %s",
                     ta_ts, ta_tag, ta_build);
            entry->bfcAppFeatures_len = strlen(ta_features);
            entry->bfcAppFeatures = malloc(entry->bfcAppFeatures_len + 1);
            if (entry->bfcAppFeatures)
                strcpy(entry->bfcAppFeatures, ta_features);
            else
                entry->bfcAppFeatures_len = 0;
            entry->bfcAppSysDescr_len = 0;
            entry->bfcAppReleaseState = 1;
        }
#endif

    }

    return;
}
/* Example iterator hook routines - using 'get_next' to do most of the work */
netsnmp_variable_list *
bfcApplicationTable_get_first_data_point(void **my_loop_context,
                          void **my_data_context,
                          netsnmp_variable_list *put_index_data,
                          netsnmp_iterator_info *mydata)
{
    bfcApplicationTable_rebuildTableData();
    *my_loop_context = bfcApplicationTable_head;
    return bfcApplicationTable_get_next_data_point(my_loop_context, my_data_context,
                                    put_index_data,  mydata );
}

netsnmp_variable_list *
bfcApplicationTable_get_next_data_point(void **my_loop_context,
                          void **my_data_context,
                          netsnmp_variable_list *put_index_data,
                          netsnmp_iterator_info *mydata)
{
    struct bfcApplicationTable_entry *entry = (struct bfcApplicationTable_entry *)*my_loop_context;
    netsnmp_variable_list *idx = put_index_data;

    if ( entry ) {
        snmp_set_var_typed_integer( idx, ASN_INTEGER, entry->bfcAppIndex );
        idx = idx->next_variable;
        *my_data_context = (void *)entry;
        *my_loop_context = (void *)entry->next;
        return put_index_data;
    } else {
        return NULL;
    }
}


/** handles requests for the bfcApplicationTable table */
int
bfcApplicationTable_handler(
    netsnmp_mib_handler               *handler,
    netsnmp_handler_registration      *reginfo,
    netsnmp_agent_request_info        *reqinfo,
    netsnmp_request_info              *requests) {

    netsnmp_request_info              *request;
    netsnmp_table_request_info        *table_info;
    struct bfcApplicationTable_entry  *table_entry;
    BOOLEAN                           bfc_request = FALSE;

    DEBUGMSGTL(("brcm_bfc_mgmt:handler", "Processing request (%d)\n", reqinfo->mode));

    // printf("**** %s %d\n",__FUNCTION__,__LINE__);
    // print_objid(request->requestvb->name,request->requestvb->name_length);

    // Check if this is a BFC request
    if( remote_bfc_entries_populated == FALSE )
    {
        if( reqinfo->asp->pdu->flags & AGENTX_MSG_FLAG_BFC_SOURCE )
        {
            bfc_request = TRUE;
        }
    }

    /* Populate entries if not present and this isn't a loop. */
    if(( remote_bfc_entries_populated == FALSE ) && ( bfc_request == FALSE ))
    {
        populate_remote_bfc_entries();
    }

    switch (reqinfo->mode) {
        /*
         * Read-support (also covers GetNext requests)
         */
    case MODE_GET:
        for (request=requests; request; request=request->next) {
            table_entry = (struct bfcApplicationTable_entry *)
                              netsnmp_extract_iterator_context(request);
            table_info  = netsnmp_extract_table_info(request);

            // Ignore BFC requests for BFC hosted entries
            if(( table_entry ) &&
               ( table_entry->bfcAppIndex >= BFC_APPLICATION_TABLE_INDEX_DOCSIS ) &&
               ( table_entry->bfcAppIndex <= BFC_APPLICATION_TABLE_INDEX_MAX_ECOS ) &&
               ( bfc_request == TRUE ))
            {
               table_entry = NULL;
            }

            switch (table_info->colnum) {
            case COLUMN_BFCAPPNAME:
                if ( table_entry )
                {
                   snmp_set_var_typed_value( request->requestvb, ASN_OCTET_STR,
                                             table_entry->bfcAppName,
                                             table_entry->bfcAppName_len);
                }
                break;
            case COLUMN_BFCAPPVERSION:
                if ( table_entry )
                {
                   snmp_set_var_typed_value( request->requestvb, ASN_OCTET_STR,
                                             table_entry->bfcAppVersion,
                                             table_entry->bfcAppVersion_len);
                }
                break;
            case COLUMN_BFCAPPRELEASESTATE:
                if ( table_entry )
                {
                   snmp_set_var_typed_integer( request->requestvb, ASN_INTEGER,
                                               table_entry->bfcAppReleaseState);
                }
                break;
            case COLUMN_BFCAPPFEATURES:
                if ( table_entry )
                {
                   snmp_set_var_typed_value( request->requestvb, ASN_OCTET_STR,
                                             table_entry->bfcAppFeatures,
                                             table_entry->bfcAppFeatures_len);
                }
                break;
            case COLUMN_BFCAPPSYSDESCR:
                if ( table_entry )
                {
                   snmp_set_var_typed_value( request->requestvb, ASN_OCTET_STR,
                                             table_entry->bfcAppSysDescr,
                                             table_entry->bfcAppSysDescr_len);
                }
                break;
            default:
                netsnmp_set_request_error(reqinfo, request,
                                          SNMP_NOSUCHOBJECT);
                continue;
            }

            if ( !table_entry )
            {
                netsnmp_set_request_error(reqinfo, request,
                                          SNMP_NOSUCHINSTANCE);
                continue;
            }
        }
        break;
    }

    return SNMP_ERR_NOERROR;
}

#define BFC_APPLICATION_TABLE_ENTRY "1.3.6.1.4.1.4413.2.2.2.1.9.1.1.5.1"
static int populate_remote_bfc_entries( void )
{
    struct bfcApplicationTable_entry *ptr, *entry;
    unsigned int length;
    unsigned int column, index;
    oid oidArray[MAX_OID_LEN];
    size_t oidLen = MAX_OID_LEN;
    char oidName[64];
    netsnmp_session session, *ss;
    netsnmp_variable_list *var = NULL;
    static time_t lastUpdate = 0;

    // Check time since last run
    if( ( time(NULL) - lastUpdate ) < 10 )
    {
        return -1;
    }
    time( &lastUpdate );

    snmp_sess_init( &session );
    session.peername = "172.31.255.45";
    session.version = SNMP_VERSION_2c;
    session.community = (u_char*)"private";
    session.community_len = strlen((char *)session.community);
    session.retries = 5;
    session.timeout = 500000L;

    SOCK_STARTUP;
    ss = snmp_open(&session);
    if (ss == NULL)
    {
        SOCK_CLEANUP;
        return -1;
    }

    for( column = COLUMN_BFCAPPNAME; column <= COLUMN_BFCAPPSYSDESCR; column++ )
    {
        for( index = BFC_APPLICATION_TABLE_INDEX_DOCSIS; index <= BFC_APPLICATION_TABLE_INDEX_MAX_ECOS; index++ )
        {
            memset( oidName, 0, sizeof(oidName) );
            snprintf( oidName, sizeof(oidName), BFC_APPLICATION_TABLE_ENTRY".%d.%d", column, index );

            if (!snmp_parse_oid(oidName, oidArray, &oidLen))
            {
                snmp_log(LOG_ERR, "snmp_parse_oid fails!\n");
                snmp_close(ss);
                SOCK_CLEANUP;
                return -1;
            }

            snmp_varlist_add_variable(&var, oidArray, oidLen, ASN_NULL, NULL,  0);
            if ((netsnmp_query_get( var, ss ) == SNMP_ERR_NOERROR) &&
                (var->type != SNMP_ENDOFMIBVIEW) &&
                (var->type != SNMP_NOSUCHOBJECT) &&
                (var->type != SNMP_NOSUCHINSTANCE))
            {
                entry = NULL;
                for ( ptr = bfcApplicationTable_head; ptr != NULL; ptr = ptr->next )
                {
                    if ( ptr && ptr->bfcAppIndex == index )
                    {
                        entry = ptr;
                        break;
                    }
                }

                if( !entry )
                {
                    continue;
                }

                switch( column )
                {
                    case COLUMN_BFCAPPNAME:
                    {
                        length = ( var->val_len >= sizeof(entry->bfcAppName) ? sizeof(entry->bfcAppName) : var->val_len);
                        entry->bfcAppName_len = length;
                        strncpy(entry->bfcAppName, (char *)var->val.string, length);
                    }
                    break;

                    case COLUMN_BFCAPPVERSION:
                    {
                        length = ( var->val_len >= sizeof(entry->bfcAppVersion) ? sizeof(entry->bfcAppVersion) : var->val_len);
                        entry->bfcAppVersion_len = length;
                        strncpy(entry->bfcAppVersion, (char *)var->val.string, length);
                    }
                    break;

                    case COLUMN_BFCAPPRELEASESTATE:
                    {
                        entry->bfcAppReleaseState = *var->val.integer;
                    }
                    break;

                    case COLUMN_BFCAPPFEATURES:
                    {
                        entry->bfcAppFeatures_len = var->val_len;
                        entry->bfcAppFeatures = malloc(entry->bfcAppFeatures_len + 1);
                        strncpy(entry->bfcAppFeatures, (char *)var->val.string, entry->bfcAppFeatures_len);
                        entry->bfcAppFeatures[entry->bfcAppFeatures_len] = 0;
                    }
                    break;

                    case COLUMN_BFCAPPSYSDESCR:
                    {
                        entry->bfcAppSysDescr_len = var->val_len;
                        entry->bfcAppSysDescr = malloc(entry->bfcAppSysDescr_len + 1);
                        strncpy(entry->bfcAppSysDescr, (char *)var->val.string, entry->bfcAppSysDescr_len);
                        entry->bfcAppSysDescr[entry->bfcAppSysDescr_len] = 0;
                    }
                    break;

                    default:
                    break;
                }
            }
            else
            {
                snmp_free_varbind(var);
                snmp_close(ss);
                SOCK_CLEANUP;
                return -1;
            }
            snmp_free_varbind(var);
            var = NULL;
        }
    }

    snmp_close(ss);
    SOCK_CLEANUP;

    remote_bfc_entries_populated = TRUE;

    return 0;
}

static int create_remote_bfc_entries( void )
{
    unsigned int index;

    for( index = BFC_APPLICATION_TABLE_INDEX_DOCSIS; index <= BFC_APPLICATION_TABLE_INDEX_MAX_ECOS; index++ )
    {
        bfcApplicationTable_createEntry(index);
    }

    return 0;
}

int
handle_bfcForwardStatic(netsnmp_mib_handler          *handler,
                        netsnmp_handler_registration *reginfo,
                        netsnmp_agent_request_info   *reqinfo,
                        netsnmp_request_info         *requests)
{
    int ret;

    /* We are never called for a GETNEXT if it's registered as a
       "instance", as it's "magically" handled for us.  */

    /* a instance handler also only hands us one request at a time, so
       we don't need to loop over a list of requests; we'll only get one. */

    // printf("**** %s %d 0x%08x\n",__FUNCTION__,__LINE__);
    // print_objid(requests->requestvb->name,requests->requestvb->name_length);

    // Check if this is a BFC request
    if( reqinfo->asp->pdu->flags & AGENTX_MSG_FLAG_BFC_SOURCE )
    {
        netsnmp_set_request_error(reqinfo, requests, SNMP_NOSUCHOBJECT);
        return SNMP_ERR_NOERROR;
    }

    switch (reqinfo->mode)
    {
        case MODE_GET:
        {
            ret = forward_bfc_lookup(requests->requestvb);
            if( ret != SNMP_ERR_NOERROR )
            {
                snmp_log(LOG_ERR, "forward_bfc_lookup in handle_bfcForwardStatic failed\n" );
                return ret;
            }
        }
        break;

        default:
        {
            /* we should never get here, so this is a really bad error */
            snmp_log(LOG_ERR, "unknown mode (%d) in handle_bfcForwardStatic\n", reqinfo->mode );
            return SNMP_ERR_GENERR;
        }
    }

    return SNMP_ERR_NOERROR;
}

static int forward_bfc_lookup( netsnmp_variable_list *varIn )
{
    netsnmp_session session, *ss;
    netsnmp_variable_list *var = NULL;
    int ret;

    snmp_sess_init( &session );
    session.peername = "172.31.255.45";
    session.version = SNMP_VERSION_2c;
    session.community = (u_char*)"private";
    session.community_len = strlen((char *)session.community);
    session.retries = 5;
    session.timeout = 500000L;

    SOCK_STARTUP;
    ss = snmp_open(&session);
    if (ss == NULL)
    {
        SOCK_CLEANUP;
        return SNMP_ERR_GENERR;
    }

    snmp_varlist_add_variable(&var, varIn->name, varIn->name_length, varIn->type, NULL, 0);
    ret = netsnmp_query_get( var, ss );
    if ((ret == SNMP_ERR_NOERROR) &&
        (var->type != SNMP_ENDOFMIBVIEW) &&
        (var->type != SNMP_NOSUCHOBJECT) &&
        (var->type != SNMP_NOSUCHINSTANCE))
    {
        snmp_set_var_typed_value( varIn, var->type,
                                  var->val.string,
                                  var->val_len );
    }
    else
    {
        snmp_log(LOG_ERR, "netsnmp_query_get fails!\n");
    }

    snmp_free_varbind(var);
    snmp_close(ss);
    SOCK_CLEANUP;

    return ret;
}
