//****************************************************************************
//
//  Copyright (c) 2006  Broadcom Corporation
//  All Rights Reserved
//  No portions of this material may be reproduced in any form without the
//  written permission of:
//          Broadcom Corporation
//          16215 Alton Parkway
//          Irvine, California 92619
//  All information contained in this document is Broadcom Corporation
//  company private, proprietary, and trade secret.
//
//****************************************************************************
//
//  Filename:       .h
//  Author:
//  Creation Date:
//
//****************************************************************************
//  Description:
//
//
//****************************************************************************

#ifndef R_PROGRAM_STORE_H
#define R_PROGRAM_STORE_H

//********************** Include Files ***************************************
#if defined __cplusplus
extern "C" {
#endif

//********************** Global Types ****************************************

#ifndef __cplusplus
#if !defined (TARGETOS_eCos)
typedef int bool;
#define true 1
#define false 0
#endif
#endif

// After each notification or transfer of image_chunk eCM waits on
// this port to hear from eSTB.
#define ESTB_SWDLOAD_REPLY_PORT		0xAAA
#define ESTB_PROGSTORE_WRITE_PORT	0x8888

#define HDR_SIZE					8
#define SEGMENT_SIZE                32768

//==============
#define IMAGE_1				0x01
#define IMAGE_2				0x02
#define kMonolithic			0x10

#define DLOAD_SUCCESSFUL			0x10000000
#define DLOAD_FAILED				0x20000000
#define PROG_STORE_WRITE			0x30000000
#define PROG_STORE_COMPUTE_CRC		0x40000000
#define PROG_STORE_VALIDATE_IMGHDR	0x50000000
#define PROG_STORE_COMPUTE_CRC_AND_LOCKIN 0x60000000


#define NUM_PARTS 11
enum parts
{
    RPROGSTORE_BOOTL,
    RPROGSTORE_DOCSIS,
    RPROGSTORE_SVM,
    RPROGSTORE_RG,
    RPROGSTORE_STB,
    RPROGSTORE_APPS,
    RPROGSTORE_BOLT,
    RPROGSTORE_DEVTREE,
    RPROGSTORE_HYP,
    RPROGSTORE_KERNEL,
    RPROGSTORE_SSBL,
};

// The Monolithic Image Header structure is simple. It includes a "magic" number, which is always set to
// "MONO" in hex, to distinguish between a regular DOCSIS secure download image and a monolithic image
// as the two use the same mechanism/code for upgrades.
// The major and minor versions are not currently used and could be used to differentiate features at some
// point of time.
// The monolithCombinedLength field has the full length of the monolith, including padding. This is not used
// currently either.
// The monolithImagesBitMask field tells us which partitions or ProgramStore locations are being upgraded in
// this monolith.
#define MONOLITH_MAGIC_NUM 0x4D4F4E4F  // "MONO"
#define MONOLITH_HEADER_MAJOR_VER   1
#define MONOLITH_HEADER_MINOR_VER   0
typedef struct
{
    unsigned int   monolithHeaderMagicNumber;
    unsigned short monolithMajorVersion;
    unsigned short monolithMinorVersion;
    unsigned int   monolithCombinedLength;
    unsigned int   monlithImagesBitMask;

} BcmMonolithHeader;

typedef struct _BcmProgramHeader
{

    // The application signature.  It may match the chip ID or a customer product ID.
    uint16 usSignature;

    // Control flags.  The compression type is an integer from 0-7, with 0
    // meaning uncompressed.  For historical reasons, the number 3 was skipped.
    // The upper 8 bits can be used for other features, such as dual binary.
    uint16 usControl;

    // Major and minor software revisions no longer mean anything in particular.
    // Customers may use them for their own purposes.
    uint16 usMajorRevision;
    uint16 usMinorRevision;

    // Time when image was ProgramStore'd, expressed as seconds since Jan 1 1970.
    uint32 ulcalendarTime;

    // Length of the file after compression, not including this header.
    uint32 ulfilelength;

    // Address where the program should be loaded.
    uint32 ulProgramLoadAddress;

    // Null-terminated file name, and padding reserved for future use.
    char cFilename[48];
    char pad[8];

    // When doing a dual binary, these are the lengths of the two parts.  The
    // sum of these should equal ulfilelength.
    unsigned long ulCompressedLength1;
    unsigned long ulCompressedLength2;

    // 16-bit crc Header checksum, not including the remaining fields.
    uint16 usHcs;

    // Reserved for future use.
    uint16 reserved;

    // CRC-32 of Program portion of file, not including this header.
    uint32 ulcrc;

} BcmProgramHeader;



//===============
#if defined __cplusplus
}
#endif

#endif
